"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AskCustomResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const path = require("path");
/**
 * A custom CloudFormation resource for Alexa Skill Kit SDK calls.
 */
class AskCustomResource extends aws_cdk_lib_1.Resource {
    /**
     * Creates an instance of the Ask Custom Resource.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Ask Custom Resource properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const codeDir = path.extname(__filename) === '.ts'
            ? path.join(__dirname, '..', '..', 'dist', 'src', 'handlers', 'ask-custom-resource')
            : path.join(__dirname, '..', '..', 'src', 'handlers', 'ask-custom-resource');
        this.provider = aws_cdk_lib_1.CustomResourceProvider.getOrCreateProvider(this, 'Custom::ASK', {
            codeDirectory: codeDir,
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_18_X,
        });
        this.customResource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::ASK',
            serviceToken: this.provider.serviceToken,
            removalPolicy: props.removalPolicy,
            properties: {
                authentication: props.authenticationConfiguration,
                create: props.onCreate ? this.encodeJson(props.onCreate) : undefined,
                update: props.onUpdate ? this.encodeJson(props.onUpdate) : undefined,
                delete: props.onDelete ? this.encodeJson(props.onDelete) : undefined,
            },
        });
    }
    /**
     * Gets the response field from the custom resource.
     * @param dataPath - The data path to retrieve from the response.
     * @returns The value of the response field.
     */
    getResponseField(dataPath) {
        return this.customResource.getAttString(dataPath);
    }
    encodeJson(obj) {
        return aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(obj) });
    }
}
exports.AskCustomResource = AskCustomResource;
_a = JSII_RTTI_SYMBOL_1;
AskCustomResource[_a] = { fqn: "cdk-skill-management.AskCustomResource", version: "1.0.11" };
//# sourceMappingURL=data:application/json;base64,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