# Contribution Guidelines

Thank you for considering contributing to the `cdk-skill-management` project.
We appreciate your help in making this project better and more useful to the community.
Please take a moment to review the following guidelines to understand how you can contribute.

## How Can You Contribute?

There are several ways you can contribute to this project:

1. **Bug Reports**: If you encounter a bug or issue with the library,
   please [open a new issue](https://github.com/t0bst4r/cdk-skill-management/issues/new). Please provide detailed
   information about the problem, including your environment and any steps to reproduce the issue.

2. **Feature Requests**: If you have a new feature in mind, feel free
   to [open a feature request](https://github.com/t0bst4r/cdk-skill-management/issues/new) on GitHub. We encourage you to
   discuss the proposed feature before implementation to ensure it aligns with the project's goals.

3. **Code Contributions**: If you'd like to contribute code to the project, please follow these steps:

    - Fork the repository on GitHub.
    - Create a new branch with a descriptive name for your feature or bug fix.
    - Make your changes and write tests if necessary.
    - Ensure that your code adheres to the project's coding standards and formatting.
    - Make sure to update the documentation as needed.
    - Create a pull request (PR) to the `main` branch of the original repository. Provide a clear description of your
      changes and reference any related issues.

4. **Documentation Improvements**: Help improve the project's documentation by submitting pull requests with
   enhancements, examples, or fixes.

5. **Spread the Word**: If you find the project useful, share it with others, and provide feedback or give it a star on
   GitHub.

## Code Contribution Guidelines

Before submitting code contributions, please consider the following:

- Adhere to the project's coding standards and style. We use eslint with prettier for this project. (`npm run lint`)

- Write clear and concise commit messages and PR descriptions following [conventional commits](https://www.conventionalcommits.org/).
  We use [husky](https://typicode.github.io/husky/) with [commitlint](https://commitlint.js.org/) for this project. 
  To enable this configuration run `npm run setup`, then it is automatically executed as a git hook.

- If your code adds new features or changes existing ones, make sure to update the project's documentation accordingly.

- Ensure your code passes all existing tests and consider adding new tests for your changes.

## Review Process

Contributions to this project are reviewed by maintainers and other contributors. Reviewers may provide feedback or
request changes to ensure code quality and consistency. Please be responsive to feedback and be prepared to make
adjustments as needed.

## Licensing

By contributing to this project, you agree that your contributions will be licensed under the
project's [license](LICENSE). If you're unsure or have questions about licensing, please contact us.

## Questions and Assistance

If you have questions or need assistance, feel free to reach out to us by [opening a new issue](https://github.com/t0bst4r/cdk-skill-management/issues/new).

We appreciate your contributions and thank you for helping make this project a valuable resource for the community!
