/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

function getPlotData() {
  const data = {
    data: [
      {
        type: 'scatter',
        x: [-23.94896727832828, 176.11536218851342],
        y: [-23.94896727832828, 176.11536218851342],
        line: {color: 'black', width: 2, dash: 'dot'},
        mode: 'lines',
        hoverinfo: 'none',
        visible: true,
        showlegend: false,
      },
      {
        type: 'scatter',
        x: [
          24.129964413622268,
          78.863835999175,
          10.325915083003967,
          98.68064045456067,
          26.449512503021804,
          31.321658517480987,
          132.44958166552067,
          86.10574699756219,
          16.326252826011096,
          70.60758289753784,
          66.7077438958342,
          32.8083830521407,
          21.424386764652148,
          166.3236985012143,
          33.738344621143135,
          2.5808075578294103,
          22.383482484999874,
          98.34760790686913,
          136.34953133391176,
          18.111011269006838,
          4.47623958200588,
          8.57972117932429,
          15.473497571024838,
          18.882901179508327,
          18.419596839926022,
          140.32747319783857,
          4.323605035294334,
          59.69046760890842,
          130.64996148022834,
          83.88052752898044,
          9.320218587634006,
          34.736739987996074,
          26.624171220014905,
          40.64753379393727,
          21.110094161886266,
          34.68741610290739,
          21.127854002025494,
          41.77178986158392,
          44.753611366285824,
          6.954951737223514,
        ],
        y: [
          23.831776096464477,
          82.815707961073,
          10.747738322645574,
          93.69829512978934,
          26.432574704476966,
          31.35967829299479,
          116.20058472252121,
          91.6818866635887,
          15.974232531635408,
          68.11476070585482,
          63.42229225469963,
          32.69640422664021,
          20.24231363712022,
          160.96833987278927,
          34.15918174538901,
          3.308923677197356,
          22.386752122774006,
          98.7539713900891,
          136.19881092376096,
          18.244226159530488,
          9.79588933833206,
          7.056956465524408,
          17.516872697880356,
          17.60009504000769,
          14.158474373680775,
          135.93053175106166,
          5.0976161658316315,
          61.761843402428816,
          130.0742203332636,
          83.86609875877086,
          9.538169968235806,
          34.29767048938933,
          26.06853258522539,
          39.04517735047875,
          20.75554971204689,
          34.60573727215491,
          21.215247383903154,
          45.86726085341013,
          45.35997743936865,
          8.151709494803775,
        ],
        marker: {color: 'rgba(128,177,211,1)'},
        mode: 'markers',
        name: 'In-sample',
        text: [
          '<b>Arm 0_0</b><br><br>Actual Outcome: 24.13 [20.210, 28.050]<br>Predicted Outcome: 23.832 [19.052, 28.612]<br><br><em>Parameterization:</em><br>x1: 2.5<br>x2: 7.5',
          '<b>Arm 0_23</b><br><br>Actual Outcome: 78.864 [74.944, 82.784]<br>Predicted Outcome: 82.816 [75.455, 90.176]<br><br><em>Parameterization:</em><br>x1: -2.65625<br>x2: 2.34375',
          '<b>Arm 0_38</b><br><br>Actual Outcome: 10.326 [6.406, 14.246]<br>Predicted Outcome: 10.748 [4.277, 17.218]<br><br><em>Parameterization:</em><br>x1: -2.421875<br>x2: 13.359375',
          '<b>Arm 0_26</b><br><br>Actual Outcome: 98.681 [94.761, 102.601]<br>Predicted Outcome: 93.698 [78.760, 108.636]<br><br><em>Parameterization:</em><br>x1: 1.09375<br>x2: 13.59375',
          '<b>Arm 0_27</b><br><br>Actual Outcome: 26.45 [22.530, 30.370]<br>Predicted Outcome: 26.433 [21.928, 30.937]<br><br><em>Parameterization:</em><br>x1: -0.78125<br>x2: 4.21875',
          '<b>Arm 0_10</b><br><br>Actual Outcome: 31.322 [27.402, 35.242]<br>Predicted Outcome: 31.36 [25.553, 37.166]<br><br><em>Parameterization:</em><br>x1: 1.5625<br>x2: 8.4375',
          '<b>Arm 0_31</b><br><br>Actual Outcome: 132.45 [128.530, 136.370]<br>Predicted Outcome: 116.201 [101.618, 130.784]<br><br><em>Parameterization:</em><br>x1: -4.296875<br>x2: 3.984375',
          '<b>Arm 0_32</b><br><br>Actual Outcome: 86.106 [82.186, 90.026]<br>Predicted Outcome: 91.682 [82.308, 101.056]<br><br><em>Parameterization:</em><br>x1: 3.203125<br>x2: 11.484375',
          '<b>Arm 0_35</b><br><br>Actual Outcome: 16.326 [12.406, 20.246]<br>Predicted Outcome: 15.974 [10.828, 21.120]<br><br><em>Parameterization:</em><br>x1: 1.328125<br>x2: 2.109375',
          '<b>Arm 0_30</b><br><br>Actual Outcome: 70.608 [66.688, 74.528]<br>Predicted Outcome: 68.115 [55.976, 80.253]<br><br><em>Parameterization:</em><br>x1: -4.53125<br>x2: 7.96875',
          '<b>Arm 0_39</b><br><br>Actual Outcome: 66.708 [62.788, 70.628]<br>Predicted Outcome: 63.422 [54.074, 72.770]<br><br><em>Parameterization:</em><br>x1: -1.484375<br>x2: 1.171875',
          '<b>Arm 0_11</b><br><br>Actual Outcome: 32.808 [28.888, 36.728]<br>Predicted Outcome: 32.696 [27.648, 37.744]<br><br><em>Parameterization:</em><br>x1: -0.3125<br>x2: 2.8125',
          '<b>Arm 0_25</b><br><br>Actual Outcome: 21.424 [17.504, 25.344]<br>Predicted Outcome: 20.242 [11.745, 28.739]<br><br><em>Parameterization:</em><br>x1: 8.59375<br>x2: 6.09375',
          '<b>Arm 0_16</b><br><br>Actual Outcome: 166.324 [162.404, 170.244]<br>Predicted Outcome: 160.968 [145.821, 176.115]<br><br><em>Parameterization:</em><br>x1: 3.90625<br>x2: 14.53125',
          '<b>Arm 0_7</b><br><br>Actual Outcome: 33.738 [29.818, 37.658]<br>Predicted Outcome: 34.159 [27.580, 40.739]<br><br><em>Parameterization:</em><br>x1: -2.1875<br>x2: 4.6875',
          '<b>Arm 0_9</b><br><br>Actual Outcome: 2.581 [-1.339, 6.501]<br>Predicted Outcome: 3.309 [-23.949, 30.567]<br><br><em>Parameterization:</em><br>x1: 9.0625<br>x2: 0.9375',
          '<b>Arm 0_2</b><br><br>Actual Outcome: 22.383 [18.463, 26.303]<br>Predicted Outcome: 22.387 [17.479, 27.295]<br><br><em>Parameterization:</em><br>x1: -1.25<br>x2: 11.25',
          '<b>Arm 0_12</b><br><br>Actual Outcome: 98.348 [94.428, 102.268]<br>Predicted Outcome: 98.754 [92.785, 104.723]<br><br><em>Parameterization:</em><br>x1: 7.1875<br>x2: 10.3125',
          '<b>Arm 0_8</b><br><br>Actual Outcome: 136.35 [132.430, 140.270]<br>Predicted Outcome: 136.199 [129.694, 142.704]<br><br><em>Parameterization:</em><br>x1: 5.3125<br>x2: 12.1875',
          '<b>Arm 0_3</b><br><br>Actual Outcome: 18.111 [14.191, 22.031]<br>Predicted Outcome: 18.244 [11.898, 24.590]<br><br><em>Parameterization:</em><br>x1: 0.625<br>x2: 5.625',
          '<b>Arm 0_14</b><br><br>Actual Outcome: 4.476 [0.556, 8.396]<br>Predicted Outcome: 9.796 [-12.608, 32.200]<br><br><em>Parameterization:</em><br>x1: -4.0625<br>x2: 14.0625',
          '<b>Arm 0_6</b><br><br>Actual Outcome: 8.58 [4.660, 12.500]<br>Predicted Outcome: 7.057 [-0.794, 14.908]<br><br><em>Parameterization:</em><br>x1: -3.125<br>x2: 9.375',
          '<b>Arm 0_17</b><br><br>Actual Outcome: 15.473 [11.553, 19.393]<br>Predicted Outcome: 17.517 [10.039, 24.995]<br><br><em>Parameterization:</em><br>x1: 7.65625<br>x2: 3.28125',
          '<b>Arm 0_34</b><br><br>Actual Outcome: 18.883 [14.963, 22.803]<br>Predicted Outcome: 17.6 [11.308, 23.893]<br><br><em>Parameterization:</em><br>x1: -0.546875<br>x2: 7.734375',
          '<b>Arm 0_33</b><br><br>Actual Outcome: 18.42 [14.500, 22.340]<br>Predicted Outcome: 14.158 [-1.909, 30.226]<br><br><em>Parameterization:</em><br>x1: 6.953125<br>x2: 0.234375',
          '<b>Arm 0_4</b><br><br>Actual Outcome: 140.327 [136.407, 144.247]<br>Predicted Outcome: 135.931 [119.081, 152.780]<br><br><em>Parameterization:</em><br>x1: 8.125<br>x2: 13.125',
          '<b>Arm 0_29</b><br><br>Actual Outcome: 4.324 [0.404, 8.244]<br>Predicted Outcome: 5.098 [-3.114, 13.309]<br><br><em>Parameterization:</em><br>x1: 2.96875<br>x2: 0.46875',
          '<b>Arm 0_36</b><br><br>Actual Outcome: 59.69 [55.770, 63.610]<br>Predicted Outcome: 61.762 [55.675, 67.849]<br><br><em>Parameterization:</em><br>x1: 8.828125<br>x2: 9.609375',
          '<b>Arm 0_28</b><br><br>Actual Outcome: 130.65 [126.730, 134.570]<br>Predicted Outcome: 130.074 [124.788, 135.360]<br><br><em>Parameterization:</em><br>x1: 6.71875<br>x2: 11.71875',
          '<b>Arm 0_24</b><br><br>Actual Outcome: 83.881 [79.961, 87.801]<br>Predicted Outcome: 83.866 [77.397, 90.336]<br><br><em>Parameterization:</em><br>x1: 4.84375<br>x2: 9.84375',
          '<b>Arm 0_19</b><br><br>Actual Outcome: 9.32 [5.400, 13.240]<br>Predicted Outcome: 9.538 [5.048, 14.029]<br><br><em>Parameterization:</em><br>x1: 2.03125<br>x2: 1.40625',
          '<b>Arm 0_21</b><br><br>Actual Outcome: 34.737 [30.817, 38.657]<br>Predicted Outcome: 34.298 [30.378, 38.218]<br><br><em>Parameterization:</em><br>x1: 5.78125<br>x2: 5.15625',
          '<b>Arm 0_1</b><br><br>Actual Outcome: 26.624 [22.704, 30.544]<br>Predicted Outcome: 26.069 [21.047, 31.090]<br><br><em>Parameterization:</em><br>x1: 6.25<br>x2: 3.75',
          '<b>Arm 0_20</b><br><br>Actual Outcome: 40.648 [36.728, 44.568]<br>Predicted Outcome: 39.045 [27.651, 50.440]<br><br><em>Parameterization:</em><br>x1: 9.53125<br>x2: 8.90625',
          '<b>Arm 0_22</b><br><br>Actual Outcome: 21.11 [17.190, 25.030]<br>Predicted Outcome: 20.756 [16.629, 24.882]<br><br><em>Parameterization:</em><br>x1: -1.71875<br>x2: 12.65625',
          '<b>Arm 0_37</b><br><br>Actual Outcome: 34.687 [30.767, 38.607]<br>Predicted Outcome: 34.606 [29.686, 39.525]<br><br><em>Parameterization:</em><br>x1: 5.078125<br>x2: 5.859375',
          '<b>Arm 0_13</b><br><br>Actual Outcome: 21.128 [17.208, 25.048]<br>Predicted Outcome: 21.215 [14.842, 27.589]<br><br><em>Parameterization:</em><br>x1: 3.4375<br>x2: 6.5625',
          '<b>Arm 0_15</b><br><br>Actual Outcome: 41.772 [37.852, 45.692]<br>Predicted Outcome: 45.867 [39.979, 51.756]<br><br><em>Parameterization:</em><br>x1: -3.59375<br>x2: 7.03125',
          '<b>Arm 0_18</b><br><br>Actual Outcome: 44.754 [40.834, 48.674]<br>Predicted Outcome: 45.36 [38.735, 51.985]<br><br><em>Parameterization:</em><br>x1: 0.15625<br>x2: 10.78125',
          '<b>Arm 0_5</b><br><br>Actual Outcome: 6.955 [3.035, 10.875]<br>Predicted Outcome: 8.152 [-1.688, 17.991]<br><br><em>Parameterization:</em><br>x1: 4.375<br>x2: 1.875',
        ],
        hoverinfo: 'text',
        error_x: {
          type: 'data',
          array: [
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
            3.92,
          ],
          color: 'rgba(128,177,211,0.4)',
        },
        error_y: {
          type: 'data',
          array: [
            4.780154758169175,
            7.36067899309994,
            6.470569145197851,
            14.938034212561863,
            4.504540390333295,
            5.806637069634283,
            14.583075480051319,
            9.373619429302671,
            5.14578065839648,
            12.138580717815296,
            9.34783922589498,
            5.048012164710921,
            8.496839941662675,
            15.147022315724154,
            6.579342415929554,
            27.257890955525635,
            4.907798201066071,
            5.9692582174096,
            6.505200491513234,
            6.34575404817052,
            22.40389387093856,
            7.850904809044198,
            7.47790641799058,
            6.292585617481667,
            16.06786726674987,
            16.849385150184524,
            8.21129208159199,
            6.087207954131656,
            5.286113613833347,
            6.469429186854726,
            4.4903418553834324,
            3.919856431501263,
            5.021506732891852,
            11.394420365794543,
            4.126361974255955,
            4.9195460093997125,
            6.373711099776367,
            5.888335915658178,
            6.625279548450101,
            9.839597864218801,
          ],
          color: 'rgba(128,177,211,0.4)',
        },
        visible: true,
        showlegend: true,
      },
    ],
    layout: {
      annotations: [
        {
          showarrow: false,
          text: 'Show CI',
          x: 1.125,
          xanchor: 'left',
          xref: 'paper',
          y: 0.9,
          yanchor: 'middle',
          yref: 'paper',
        },
      ],
      xaxis: {
        title: 'Actual Outcome',
        zeroline: false,
        mirror: true,
        linecolor: 'black',
        linewidth: 0.5,
      },
      yaxis: {
        title: 'Predicted Outcome',
        zeroline: false,
        mirror: true,
        linecolor: 'black',
        linewidth: 0.5,
      },
      showlegend: false,
      hovermode: 'closest',
      updatemenus: [
        {
          x: 0,
          y: 1.125,
          yanchor: 'top',
          xanchor: 'left',
          buttons: [
            {
              args: ['visible', [true, true]],
              label: 'metric_a',
              method: 'restyle',
            },
          ],
        },
        {
          buttons: [
            {
              args: [
                {
                  'error_x.width': 4,
                  'error_x.thickness': 2,
                  'error_y.width': 4,
                  'error_y.thickness': 2,
                },
              ],
              label: 'Yes',
              method: 'restyle',
            },
            {
              args: [
                {
                  'error_x.width': 0,
                  'error_x.thickness': 0,
                  'error_y.width': 0,
                  'error_y.thickness': 0,
                },
              ],
              label: 'No',
              method: 'restyle',
            },
          ],
          x: 1.125,
          xanchor: 'left',
          y: 0.8,
          yanchor: 'middle',
        },
      ],
      width: 530,
      height: 500,
    },
  };
  return {
    layout: data['layout'],
    traces: data['data'],
  };
}

const cvPlotData = getPlotData();

console.log(cvPlotData);

Plotly.newPlot('cv', cvPlotData['traces'], cvPlotData['layout'], {
  responsive: true,
  showLink: false,
});
