# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gradle_profiler_pttest']

package_data = \
{'': ['*']}

install_requires = \
['flake8==3.8.4', 'pingouin==0.3.8', 'rich==8.0.0']

entry_points = \
{'console_scripts': ['gradle-profiler-pttest = gradle_profiler_pttest:main']}

setup_kwargs = {
    'name': 'gradle-profiler-pttest',
    'version': '0.0.2',
    'description': 'Analyses the outcomes of two Gradle Profiler benchmarks with the Paired T-test statistical technique',
    'long_description': '# Paired T-tests for Gradle Benchmarks\n\n[![Flake8](https://img.shields.io/badge/codestyle-flake8-yellow)](https://flake8.pycqa.org/en/latest/)\n[![Maintainability](https://api.codeclimate.com/v1/badges/a9fe25bd995710be45d2/maintainability)](https://codeclimate.com/github/dotanuki-labs/gradle-profiler-pttest/maintainability)\n[![codecov](https://codecov.io/gh/dotanuki-labs/gradle-profiler-pttest/branch/master/graph/badge.svg)](https://codecov.io/gh/dotanuki-labs/gradle-profiler-pttest)\n[![PyPI](https://img.shields.io/pypi/v/gradle-profiler-pttest)](https://pypi.org/project/gradle-profiler-pttest/)\n[![Main](https://github.com/dotanuki-labs/gradle-profiler-pttest/workflows/Main/badge.svg)](https://github.com/dotanuki-labs/gradle-profiler-pttest/actions?query=workflow%3AMain)\n[![License](https://img.shields.io/github/license/dotanuki-labs/gradle-profiler-pttest)](https://choosealicense.com/licenses/mit)\n\n## Context\n\n> _Complete blog post to come. Stay tunned_\n\n`gradle-profiler-pttest` can analyse the outcomes of two benchmarks generated by [Gradle Profiler](https://github.com/gradle/gradle-profiler) with the [Paired T-test statistical technique](https://en.wikipedia.org/wiki/Student%27s_t-test).\n\nThe goal is provide a super easy way to compare two benchmarks for Gradle builds - for the same task - without being [mislead by simple means](https://thinkingneuron.com/statistics-data-science-why-mean-misleading/), since we are leveraging robust statistical evidence on top of the outcomes.\n\nThis tool is built on top of [pingouin](https://pingouin-stats.org/), an opinionated Statistics library which leverages NumPy, Pandas and SciPy. Among other things, `gradle-profiler-pttest` features :\n\n- An opinionated [hyphotesis test](https://en.wikipedia.org/wiki/Statistical_hypothesis_testing) (left-tailed) where we want to check if **modified build conditions** (_h1_) have a mean **statistically lower** than **baseline build conditions** (_h0_), which means better execution times given the modifications applied\n- Auto-correction for benchmark samples with different sizes\n\nNote that the ideal size for samples should be a small one - ideally between 10 and 30 measured builds - in order to make sense of T-student analysis.\n\n## Installing\n\nInstall from your CLI with [pip](https://pypi.org/project/pip/)\n\n\n```shell\npip install gradle-profiler-pttest\n```\n\nRequires **Python 3.8.5** or newer\n\n## Using\n\n- Run the benchmarks with Gradle profiler for the status quo (`baseline`) and for the modifications applied the your Gradle project (`modified`)\n\n- Supply the generated CSV files to `gradle-profiler-pttest`\n\n```bash\ngradle-profiler-pttest \\\n\t-b <path/to/baseline/benchmark.csv> \\\n\t-m <path/to/modified/benchmark.csv>\n```\n\n- Profit results\n\n![](.github/assets/showcase.png)\n\n## Limitations\n\nRight now `gradle-profiler-pttest` supports **only one Gradle task per supplied benchmark sample**, taking the first task executed as reference for the analysis given a multi-task [benchmarked scenario](https://github.com/gradle/gradle-profiler#advanced-profiling-scenarios). \n\n## Contributing\n\n- Ensure you have Python 3.8.5 or newer installed\n- Ensure you have [flake8](https://pypi.org/project/flake8/) support in your text editor / IDE\n- Check the [contribution guidelines](./CONTRIBUTING.md)\n- Make sure you have a green build\n\n```\nmake flake8\nmake test\n```\n- Summit your PR 🔥\n\n\n## Credits\n\n- [Raphael Vallat](https://github.com/raphaelvallat) for [pingouin](https://github.com/raphaelvallat/pingouin/), it made the task super easy\n- [Will McGugan](https://github.com/willmcgugan) for [rich](https://github.com/willmcgugan/rich), I wish I had something awesome like this for my JVM projects\n\n## Author\n\nCoded by Ubiratan Soares (follow me on [Twitter](https://twitter.com/ubiratanfsoares))\n\n## License\n\n```\nThe MIT License (MIT)\n\nCopyright (c) 2020 Dotanuki Labs\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of\nthis software and associated documentation files (the "Software"), to deal in\nthe Software without restriction, including without limitation the rights to\nuse, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of\nthe Software, and to permit persons to whom the Software is furnished to do so,\nsubject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS\nFOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR\nCOPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER\nIN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\nCONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n```\n',
    'author': 'Ubiratan Soares',
    'author_email': 'ubiratan.f.soares@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dotanuki-labs/gradle-profiler-pttest',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '==3.8.5',
}


setup(**setup_kwargs)
