# coding: utf-8

"""
    Collibra Catalog API

    The Catalog API offers functionality related to the catalog product.<br/>It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_classification.configuration import Configuration


class FindClassificationMatchesRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'offset': 'int',
        'limit': 'int',
        'count_limit': 'int',
        'asset_ids': 'list[str]',
        'statuses': 'list[str]',
        'classification_ids': 'list[str]',
        'asset_type_ids': 'list[str]'
    }

    attribute_map = {
        'offset': 'offset',
        'limit': 'limit',
        'count_limit': 'countLimit',
        'asset_ids': 'assetIds',
        'statuses': 'statuses',
        'classification_ids': 'classificationIds',
        'asset_type_ids': 'assetTypeIds'
    }

    def __init__(self, offset=None, limit=None, count_limit=None, asset_ids=None, statuses=None, classification_ids=None, asset_type_ids=None, local_vars_configuration=None):  # noqa: E501
        """FindClassificationMatchesRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._offset = None
        self._limit = None
        self._count_limit = None
        self._asset_ids = None
        self._statuses = None
        self._classification_ids = None
        self._asset_type_ids = None
        self.discriminator = None

        if offset is not None:
            self.offset = offset
        if limit is not None:
            self.limit = limit
        if count_limit is not None:
            self.count_limit = count_limit
        if asset_ids is not None:
            self.asset_ids = asset_ids
        if statuses is not None:
            self.statuses = statuses
        if classification_ids is not None:
            self.classification_ids = classification_ids
        if asset_type_ids is not None:
            self.asset_type_ids = asset_type_ids

    @property
    def offset(self):
        """Gets the offset of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The offset of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this FindClassificationMatchesRequest.


        :param offset: The offset of this FindClassificationMatchesRequest.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def limit(self):
        """Gets the limit of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The limit of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this FindClassificationMatchesRequest.


        :param limit: The limit of this FindClassificationMatchesRequest.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def count_limit(self):
        """Gets the count_limit of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The count_limit of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: int
        """
        return self._count_limit

    @count_limit.setter
    def count_limit(self, count_limit):
        """Sets the count_limit of this FindClassificationMatchesRequest.


        :param count_limit: The count_limit of this FindClassificationMatchesRequest.  # noqa: E501
        :type: int
        """

        self._count_limit = count_limit

    @property
    def asset_ids(self):
        """Gets the asset_ids of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The asset_ids of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._asset_ids

    @asset_ids.setter
    def asset_ids(self, asset_ids):
        """Sets the asset_ids of this FindClassificationMatchesRequest.


        :param asset_ids: The asset_ids of this FindClassificationMatchesRequest.  # noqa: E501
        :type: list[str]
        """

        self._asset_ids = asset_ids

    @property
    def statuses(self):
        """Gets the statuses of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The statuses of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._statuses

    @statuses.setter
    def statuses(self, statuses):
        """Sets the statuses of this FindClassificationMatchesRequest.


        :param statuses: The statuses of this FindClassificationMatchesRequest.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["ACCEPTED", "REJECTED", "SUGGESTED"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(statuses).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `statuses` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(statuses) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._statuses = statuses

    @property
    def classification_ids(self):
        """Gets the classification_ids of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The classification_ids of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._classification_ids

    @classification_ids.setter
    def classification_ids(self, classification_ids):
        """Sets the classification_ids of this FindClassificationMatchesRequest.


        :param classification_ids: The classification_ids of this FindClassificationMatchesRequest.  # noqa: E501
        :type: list[str]
        """

        self._classification_ids = classification_ids

    @property
    def asset_type_ids(self):
        """Gets the asset_type_ids of this FindClassificationMatchesRequest.  # noqa: E501


        :return: The asset_type_ids of this FindClassificationMatchesRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._asset_type_ids

    @asset_type_ids.setter
    def asset_type_ids(self, asset_type_ids):
        """Sets the asset_type_ids of this FindClassificationMatchesRequest.


        :param asset_type_ids: The asset_type_ids of this FindClassificationMatchesRequest.  # noqa: E501
        :type: list[str]
        """

        self._asset_type_ids = asset_type_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FindClassificationMatchesRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FindClassificationMatchesRequest):
            return True

        return self.to_dict() != other.to_dict()
