# collibra-classification
The Catalog API offers functionality related to the catalog product.<br/>It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_classification
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_classification
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import collibra_classification
from collibra_classification.rest import ApiException
from pprint import pprint

configuration = collibra_classification.Configuration()
# Configure HTTP basic authorization: basicAuth
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# Defining host is optional and default to http://localhost/rest/catalog/1.0
configuration.host = "http://localhost/rest/catalog/1.0"
# Enter a context with an instance of the API client
with collibra_classification.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = collibra_classification.DataClassificationApi(api_client)
    add_classification_request = collibra_classification.AddClassificationRequest() # AddClassificationRequest | The request with data needed for creation of new classification. (optional)

    try:
        # Adds new Classification
        api_response = api_instance.add_classification(add_classification_request=add_classification_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DataClassificationApi->add_classification: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest/catalog/1.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataClassificationApi* | [**add_classification**](docs/DataClassificationApi.md#add_classification) | **POST** /dataClassification/classifications | Adds new Classification
*DataClassificationApi* | [**add_classification_match**](docs/DataClassificationApi.md#add_classification_match) | **POST** /dataClassification/classificationMatches | Adds new Classification Match
*DataClassificationApi* | [**add_classification_matches**](docs/DataClassificationApi.md#add_classification_matches) | **POST** /dataClassification/classificationMatches/bulk | Adds new Classification Matches
*DataClassificationApi* | [**change_classification**](docs/DataClassificationApi.md#change_classification) | **PATCH** /dataClassification/classifications/{classificationId} | Changes existing Classification
*DataClassificationApi* | [**change_classification_match**](docs/DataClassificationApi.md#change_classification_match) | **PATCH** /dataClassification/classificationMatches/{classificationMatchId} | Changes a Classification Match
*DataClassificationApi* | [**change_classification_matches**](docs/DataClassificationApi.md#change_classification_matches) | **PATCH** /dataClassification/classificationMatches/bulk | Changes multiple Classification Matches
*DataClassificationApi* | [**classify**](docs/DataClassificationApi.md#classify) | **POST** /dataClassification/classifications/classify | Starts a job that classifies datasets, databases, schemas, tables or columns by external service based on sample data.
*DataClassificationApi* | [**find_classification_matches**](docs/DataClassificationApi.md#find_classification_matches) | **GET** /dataClassification/classificationMatches | Finds Classification Matches
*DataClassificationApi* | [**find_classification_matches_with_params**](docs/DataClassificationApi.md#find_classification_matches_with_params) | **GET** /dataClassification/classificationMatches/bulk | Finds Classification Matches
*DataClassificationApi* | [**find_classifications**](docs/DataClassificationApi.md#find_classifications) | **GET** /dataClassification/classifications | Finds Classifications
*DataClassificationApi* | [**find_classifications_bulk**](docs/DataClassificationApi.md#find_classifications_bulk) | **GET** /dataClassification/classifications/bulk | Finds Classifications
*DataClassificationApi* | [**get_classification**](docs/DataClassificationApi.md#get_classification) | **GET** /dataClassification/classifications/{classificationId} | Gets existing Classification by id.
*DataClassificationApi* | [**get_classification_match**](docs/DataClassificationApi.md#get_classification_match) | **GET** /internal/classificationMatches/{classificationMatchId} | Gets existing Classification Match by id.
*DataClassificationApi* | [**remove_classification**](docs/DataClassificationApi.md#remove_classification) | **DELETE** /dataClassification/classifications/{classificationId} | Removes existing Classification. WARNING: This will also remove all ClassificationMatches that are joined with this Classification!
*DataClassificationApi* | [**remove_classification_match**](docs/DataClassificationApi.md#remove_classification_match) | **DELETE** /internal/classificationMatches/{classificationMatchId} | Removes existing Classification Match.
*DataClassificationApi* | [**remove_classification_matches**](docs/DataClassificationApi.md#remove_classification_matches) | **DELETE** /internal/classificationMatches/bulk | Removes multiple Classification Matches


## Documentation For Models

 - [AddClassificationMatchRequest](docs/AddClassificationMatchRequest.md)
 - [AddClassificationMatchesRequest](docs/AddClassificationMatchesRequest.md)
 - [AddClassificationRequest](docs/AddClassificationRequest.md)
 - [ChangeClassificationMatchRequest](docs/ChangeClassificationMatchRequest.md)
 - [ChangeClassificationRequest](docs/ChangeClassificationRequest.md)
 - [Classification](docs/Classification.md)
 - [ClassificationMatch](docs/ClassificationMatch.md)
 - [ClassifyRequest](docs/ClassifyRequest.md)
 - [FindClassificationMatchesRequest](docs/FindClassificationMatchesRequest.md)
 - [FindClassificationsRequest](docs/FindClassificationsRequest.md)
 - [Job](docs/Job.md)
 - [NamedResourceReferenceImpl](docs/NamedResourceReferenceImpl.md)
 - [PagedResponseClassification](docs/PagedResponseClassification.md)
 - [PagedResponseClassificationMatch](docs/PagedResponseClassificationMatch.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author




