from io import IOBase
from typing import Any, Dict, Optional, Tuple

from django.db.backends.base.base import BaseDatabaseWrapper
from django.db.backends.utils import CursorDebugWrapper as BaseCursorDebugWrapper

def psycopg2_version() -> Tuple[int, ...]: ...

PSYCOPG2_VERSION: Tuple[int, ...] = ...

class DatabaseWrapper(BaseDatabaseWrapper):
    operators: Dict[str, str] = ...
    pattern_esc: str = ...
    pattern_ops: Dict[str, str] = ...

    # PostgreSQL backend-specific attributes.
    _named_cursor_idx: int = ...
    @property
    def pg_version(self) -> str: ...

class CursorDebugWrapper(BaseCursorDebugWrapper):
    def copy_expert(self, sql: str, file: IOBase, *args: Any): ...
    def copy_to(self, file: IOBase, table: str, *args: Any, **kwargs: Any): ...
