# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['Workflow']

# %% ../nbs/00_core.ipynb 3
from functools import wraps
from transitions import Machine

class Workflow(Machine):
    "Utility class for managing workflows with state transitions; built on [pytransitions](https://github.com/pytransitions/transitions)"
    
    def __init__(self, config={}):
        super().__init__(self, **config)
        self.__cache__ = {}

    def cache(key):
        "Decorator for ensuring that tests (`conditions`/`unless`) only get run once; `key` should be set to a unique value per test."
        def decorate(func):
            @wraps(func)
            def wrap(self, *args, **kwargs):
                if not key in self.__cache__:
                    self.__cache__[key] = func(self, *args, **kwargs)
                return self.__cache__[key]
            return wrap
        return decorate


