__version__ = "0.1.0"

""" Includes measure types variables, specifying the type of measure to use in specific measures.
The types are used to specify a specific measure function proposed in a study.
For example, Atanassov proposed 4 types of distances in a single study, the following
constants are used to specify each distance type to calculate using the `atanassov` measure:

>>> DISTANCE_HAMMING
>>> DISTANCE_EUCLIDEAN
>>> DISTANCE_NORMALIZED_HAMMING
>>> DISTANCE_NORMALIZED_EUCLIDEAN

Includes the following types:

>>> DISTANCE_HAMMING = 'Hamming'
>>> DISTANCE_EUCLIDEAN = 'Euclidean'
>>> DISTANCE_NORMALIZED_HAMMING = 'normalized Hamming'
>>> DISTANCE_NORMALIZED_EUCLIDEAN = 'normalized Euclidean'

>>> WANGXIN_DISTANCE_1 = 1
>>> WANGXIN_DISTANCE_2 = 2

>>> LIANG_SHI_SIMILARITY_1 = 'e'
>>> LIANG_SHI_SIMILARITY_2 = 's'
>>> LIANG_SHI_SIMILARITY_3 = 'h'

>>> HUNG_YANG_1_SIMILARITY_1 = 'l'
>>> HUNG_YANG_1_SIMILARITY_2 = 'e'
>>> HUNG_YANG_1_SIMILARITY_3 = 'c'

>>> HUNG_YANG_2_SIMILARITY_1 = 'l'
>>> HUNG_YANG_2_SIMILARITY_2 = 'e'
>>> HUNG_YANG_2_SIMILARITY_3 = 'c'

>>> HUNG_YANG_3_SIMILARITY_1 = 'w1'
>>> HUNG_YANG_3_SIMILARITY_2 = 'w2'
>>> HUNG_YANG_3_SIMILARITY_3 = 'pk1'
>>> HUNG_YANG_3_SIMILARITY_4 = 'pk2'
>>> HUNG_YANG_3_SIMILARITY_5 = 'pk3'
>>> HUNG_YANG_3_SIMILARITY_6 = 'new1'
>>> HUNG_YANG_3_SIMILARITY_7 = 'new2'

>>> HUNG_YANG_4_SIMILARITY_1 = 'l'
>>> HUNG_YANG_4_SIMILARITY_2 = 'e'
>>> HUNG_YANG_4_SIMILARITY_3 = 'c'

>>> IANCU_SIMILARITY_1 = 1
>>> IANCU_SIMILARITY_2 = 2
>>> IANCU_SIMILARITY_3 = 3
>>> IANCU_SIMILARITY_4 = 4
>>> IANCU_SIMILARITY_5 = 5
>>> IANCU_SIMILARITY_6 = 6
>>> IANCU_SIMILARITY_7 = 7
>>> IANCU_SIMILARITY_8 = 8
>>> IANCU_SIMILARITY_9 = 9
>>> IANCU_SIMILARITY_10 = 10
>>> IANCU_SIMILARITY_11 = 11
>>> IANCU_SIMILARITY_12 = 12
>>> IANCU_SIMILARITY_13 = 13
>>> IANCU_SIMILARITY_14 = 14
>>> IANCU_SIMILARITY_15 = 15
>>> IANCU_SIMILARITY_16 = 16
>>> IANCU_SIMILARITY_17 = 17
>>> IANCU_SIMILARITY_18 = 18
>>> IANCU_SIMILARITY_19 = 19
>>> IANCU_SIMILARITY_20 = 20

>>> DENG_JIANG_FU_MONOTONIC_TYPE_1_1 = 1
>>> DENG_JIANG_FU_MONOTONIC_TYPE_1_2 = 2
>>> DENG_JIANG_FU_MONOTONIC_TYPE_1_3 = 3
>>> DENG_JIANG_FU_MONOTONIC_TYPE_1_4 = 4
>>> DENG_JIANG_FU_MONOTONIC_TYPE_2_1 = 5
>>> DENG_JIANG_FU_MONOTONIC_TYPE_2_2 = 6
>>> DENG_JIANG_FU_MONOTONIC_TYPE_2_3 = 7
>>> DENG_JIANG_FU_MONOTONIC_TYPE_2_4 = 8
>>> DENG_JIANG_FU_MONOTONIC_TYPE_3_1 = 9
>>> DENG_JIANG_FU_MONOTONIC_TYPE_3_2 = 10
>>> DENG_JIANG_FU_MONOTONIC_TYPE_3_3 = 11

"""

DISTANCE_HAMMING = 'Hamming'
DISTANCE_EUCLIDEAN = 'Euclidean'
DISTANCE_NORMALIZED_HAMMING = 'normalized Hamming'
DISTANCE_NORMALIZED_EUCLIDEAN = 'normalized Euclidean'

WANGXIN_DISTANCE_1 = 1
WANGXIN_DISTANCE_2 = 2

LIANG_SHI_SIMILARITY_1 = 'e'
LIANG_SHI_SIMILARITY_2 = 's'
LIANG_SHI_SIMILARITY_3 = 'h'

HUNG_YANG_1_SIMILARITY_1 = 'l'
HUNG_YANG_1_SIMILARITY_2 = 'e'
HUNG_YANG_1_SIMILARITY_3 = 'c'

HUNG_YANG_2_SIMILARITY_1 = 'l'
HUNG_YANG_2_SIMILARITY_2 = 'e'
HUNG_YANG_2_SIMILARITY_3 = 'c'

HUNG_YANG_3_SIMILARITY_1 = 'w1'
HUNG_YANG_3_SIMILARITY_2 = 'w2'
HUNG_YANG_3_SIMILARITY_3 = 'pk1'
HUNG_YANG_3_SIMILARITY_4 = 'pk2'
HUNG_YANG_3_SIMILARITY_5 = 'pk3'
HUNG_YANG_3_SIMILARITY_6 = 'new1'
HUNG_YANG_3_SIMILARITY_7 = 'new2'

HUNG_YANG_4_SIMILARITY_1 = 'l'
HUNG_YANG_4_SIMILARITY_2 = 'e'
HUNG_YANG_4_SIMILARITY_3 = 'c'

IANCU_SIMILARITY_1 = 1
IANCU_SIMILARITY_2 = 2
IANCU_SIMILARITY_3 = 3
IANCU_SIMILARITY_4 = 4
IANCU_SIMILARITY_5 = 5
IANCU_SIMILARITY_6 = 6
IANCU_SIMILARITY_7 = 7
IANCU_SIMILARITY_8 = 8
IANCU_SIMILARITY_9 = 9
IANCU_SIMILARITY_10 = 10
IANCU_SIMILARITY_11 = 11
IANCU_SIMILARITY_12 = 12
IANCU_SIMILARITY_13 = 13
IANCU_SIMILARITY_14 = 14
IANCU_SIMILARITY_15 = 15
IANCU_SIMILARITY_16 = 16
IANCU_SIMILARITY_17 = 17
IANCU_SIMILARITY_18 = 18
IANCU_SIMILARITY_19 = 19
IANCU_SIMILARITY_20 = 20

DENG_JIANG_FU_MONOTONIC_TYPE_1_1 = 1
DENG_JIANG_FU_MONOTONIC_TYPE_1_2 = 2
DENG_JIANG_FU_MONOTONIC_TYPE_1_3 = 3
DENG_JIANG_FU_MONOTONIC_TYPE_1_4 = 4
DENG_JIANG_FU_MONOTONIC_TYPE_2_1 = 5
DENG_JIANG_FU_MONOTONIC_TYPE_2_2 = 6
DENG_JIANG_FU_MONOTONIC_TYPE_2_3 = 7
DENG_JIANG_FU_MONOTONIC_TYPE_2_4 = 8
DENG_JIANG_FU_MONOTONIC_TYPE_3_1 = 9
DENG_JIANG_FU_MONOTONIC_TYPE_3_2 = 10
DENG_JIANG_FU_MONOTONIC_TYPE_3_3 = 11

from . import distances
from . import similarities
from . import misc
from . import sets

__all__ = (
    "distances",
    "similarities",
    "misc",
    "sets"
)
