"""Constants for gRelu's Enformer model.

To test some parts of this:
```zsh
python -m nucleobench.models.grelu.enformer.constants
```
"""

ENFORMER_PROJECT_ = 'enformer'
ENFORMER_MODEL_NAME = 'human'
ENFORMER_TRAIN_LEN_ = 196_608

# In gRelu, this list is determined from:
# ```python
# model.data_params['tasks']['description']
# ```
ENFORMER_TASKS_ = [
    "DNASE:cerebellum male adult (27 years) and male adult (35 years)",
    "DNASE:frontal cortex male adult (27 years) and male adult (35 years)",
    "DNASE:chorion",
    "DNASE:Ishikawa treated with 0.02% dimethyl sulfoxide for 1 hour",
    "DNASE:GM03348",
    "DNASE:GM03348 genetically modified using transduction treated with 3 ug/mL doxycycline for 10 days",
    "DNASE:AG08395",
    "DNASE:AG08396",
    "DNASE:AG20443",
    "DNASE:frontal cortex female adult (67 years) and female adult (80 years)",
    "DNASE:H54",
    "DNASE:GM10248",
    "DNASE:GM12878",
    "DNASE:GM12891",
    "DNASE:GM12892",
    "DNASE:GM18507",
    "DNASE:GM19238",
    "DNASE:GM19239",
    "DNASE:GM19240",
    "DNASE:H1-hESC",
    "DNASE:H7-hESC",
    "DNASE:H9",
    "DNASE:heart male adult (27 years) and male adult (35 years)",
    "DNASE:HEK293T",
    "DNASE:HeLa-S3 treated with interferon alpha for 4 hours",
    "DNASE:HeLa-S3",
    "DNASE:hepatocyte",
    "DNASE:HepG2",
    "DNASE:HTR-8/SVneo",
    "DNASE:endothelial cell of umbilical vein newborn",
    "DNASE:CWRU1 male",
    "DNASE:iPS-NIHi11 male adult (71 year) originated from AG20443",
    "DNASE:iPS-NIHi7 female adult (85 years) originated from AG08395",
    "DNASE:K562 treated with 1 uM vorinostat for 72 hours",
    "DNASE:K562 G2 phase",
    "DNASE:K562 G1 phase",
    "DNASE:LNCaP clone FGC",
    "DNASE:LNCaP clone FGC treated with 1 nM 17B-hydroxy-17-methylestra-4,9,11-trien-3-one for 12 hours",
    "DNASE:MCF-7 originated from MCF-7",
    "DNASE:medulloblastoma",
    "DNASE:epidermal melanocyte",
    "DNASE:CD14-positive monocyte female",
    "DNASE:keratinocyte female",
    "DNASE:osteoblast",
    "DNASE:psoas muscle male adult (27 years) and male adult (35 years)",
    "DNASE:T47D treated with 10 nM 17B-estradiol for 30 minutes",
    "DNASE:urothelium cell line",
    "DNASE:A549",
    "DNASE:AG04449",
    "DNASE:AG04450",
    "DNASE:AG09309",
    "DNASE:AG09319",
    "DNASE:AG10803",
    "DNASE:fibroblast of the aortic adventitia female",
    "DNASE:BE2C",
    "DNASE:BJ",
    "DNASE:HS-27A",
    "DNASE:HS-5",
    "DNASE:stromal cell of bone marrow male",
    "DNASE:Caco-2",
    "DNASE:B cell female adult (43 years)",
    "DNASE:hematopoietic multipotent progenitor cell",
    "DNASE:naive thymus-derived CD4-positive, alpha-beta T cell male adult (26 years)",
    "DNASE:CMK",
    "DNASE:GM04503",
    "DNASE:GM04504",
    "DNASE:GM06990",
    "DNASE:GM12864",
    "DNASE:GM12865",
    "DNASE:GM12878",
    "DNASE:H1-hESC",
    "DNASE:cardiac mesoderm",
    "DNASE:cardiac mesoderm",
    "DNASE:cardiac mesoderm",
    "DNASE:cardiac mesoderm",
    "DNASE:H7-hESC",
    "DNASE:astrocyte of the hippocampus",
    "DNASE:astrocyte of the spinal cord",
    "DNASE:astrocyte of the cerebellum",
    "DNASE:amniotic epithelial cell",
    "DNASE:brain microvascular endothelial cell",
    "DNASE:brain pericyte",
    "DNASE:smooth muscle cell of the brain vasculature female",
    "DNASE:cardiac fibroblast",
    "DNASE:cardiac fibroblast female",
    "DNASE:cardiac muscle cell",
    "DNASE:fibroblast of the conjunctiva",
    "DNASE:choroid plexus epithelial cell",
    "DNASE:HCT116",
    "DNASE:epithelial cell of esophagus",
    "DNASE:HeLa-S3 G1b phase",
    "DNASE:HepG2",
    "DNASE:foreskin fibroblast male newborn",
    "DNASE:HFF-Myc originated from foreskin fibroblast",
    "DNASE:fibroblast of gingiva",
    "DNASE:iris pigment epithelial cell",
    "DNASE:HL-60",
    "DNASE:mammary epithelial cell female",
    "DNASE:fibroblast of mammary gland female",
    "DNASE:dermis blood vessel endothelial cell female adult",
    "DNASE:dermis blood vessel endothelial cell female adult",
    "DNASE:dermis blood vessel endothelial cell male newborn",
    "DNASE:dermis microvascular lymphatic vessel endothelial cell female",
    "DNASE:dermis microvascular lymphatic vessel endothelial cell male",
    "DNASE:dermis blood vessel endothelial cell male newborn",
    "DNASE:lung microvascular endothelial cell female",
    "DNASE:lung microvascular endothelial cell female",
    "DNASE:non-pigmented ciliary epithelial cell",
    "DNASE:pulmonary artery endothelial cell female",
    "DNASE:fibroblast of pulmonary artery",
    "DNASE:fibroblast of peridontal ligament male",
    "DNASE:fibroblast of lung",
    "DNASE:renal cortical epithelial cell",
    "DNASE:kidney epithelial cell",
    "DNASE:glomerular endothelial cell",
    "DNASE:retinal pigment epithelial cell",
    "DNASE:skeletal muscle myoblast",
    "DNASE:myotube originated from skeletal muscle myoblast",
    "DNASE:endothelial cell of umbilical vein newborn",
    "DNASE:fibroblast of villous mesenchyme",
    "DNASE:Jurkat clone E61",
    "DNASE:K562",
    "DNASE:K562",
    "DNASE:K562",
    "DNASE:myocyte originated from LHCN-M2",
    "DNASE:LHCN-M2",
    "DNASE:LNCaP clone FGC",
    "DNASE:M059J",
    "DNASE:MCF-7",
    "DNASE:MCF-7 treated with 100 nM estradiol for 1 hour",
    "DNASE:MCF-7",
    "DNASE:CD14-positive monocyte female",
    "DNASE:NB4",
    "DNASE:astrocyte",
    "DNASE:bronchial epithelial cell female treated with retinoic acid",
    "DNASE:fibroblast of dermis female adult",
    "DNASE:foreskin fibroblast male newborn",
    "DNASE:keratinocyte female",
    "DNASE:fibroblast of lung male adult (45 years)",
    "DNASE:NT2/D1",
    "DNASE:Panc1",
    "DNASE:epithelial cell of prostate",
    "DNASE:RPMI-7951",
    "DNASE:epithelial cell of proximal tubule",
    "DNASE:bronchial epithelial cell",
    "DNASE:SK-N-MC",
    "DNASE:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "DNASE:skeletal muscle cell",
    "DNASE:T47D",
    "DNASE:T-helper 1 cell",
    "DNASE:T-helper 1 cell female adult (26 years)",
    "DNASE:T-helper 1 cell male adult (33 years)",
    "DNASE:T-helper 17 cell",
    "DNASE:T-helper 2 cell",
    "DNASE:T-helper 2 cell female adult (26 years)",
    "DNASE:T-helper 2 cell male adult (33 years)",
    "DNASE:regulatory T cell female adult (35 years)",
    "DNASE:regulatory T cell male adult (28 years)",
    "DNASE:WERI-Rb-1",
    "DNASE:WI38 genetically modified using stable transfection originated from WI38 treated with 20 nM afimoxifene for 72 hours",
    "DNASE:WI38 genetically modified using stable transfection originated from WI38",
    "DNASE:HT1080",
    "DNASE:SK-MEL-5",
    "DNASE:SJCRH30",
    "DNASE:NCI-H460",
    "DNASE:SK-N-DZ treated with dimethyl sulfoxide for 72 hours",
    "DNASE:GM23338 male adult (53 years) originated from GM23248",
    "DNASE:lung embryo (112 days)",
    "DNASE:SK-MEL-5",
    "DNASE:muscle of back female embryo (113 days)",
    "DNASE:iPS DF 4.7 male newborn",
    "DNASE:right renal cortex interstitium male embryo (105 days)",
    "DNASE:caudate nucleus male adult (78 years)",
    "DNASE:left renal pelvis male embryo (105 days)",
    "DNASE:H9 S1 phase genetically modified using stable transfection",
    "DNASE:right kidney female embryo (87 days)",
    "DNASE:Karpas-422",
    "DNASE:CD8-positive, alpha-beta T cell male adult (21 year)",
    "DNASE:renal cortex interstitium female embryo (96 days)",
    "DNASE:brain female embryo (85 days)",
    "DNASE:muscle of leg male embryo (97 days)",
    "DNASE:muscle of back female embryo (105 days)",
    "DNASE:placenta female embryo (113 days)",
    "DNASE:foreskin keratinocyte male newborn",
    "DNASE:right kidney female embryo (107 days)",
    "DNASE:RCC 7860",
    "DNASE:colon epithelial cell line",
    "DNASE:left renal cortex interstitium male embryo (120 days)",
    "DNASE:T-cell",
    "DNASE:large intestine male embryo (113 days)",
    "DNASE:PC-3",
    "DNASE:muscle of leg male embryo (96 days)",
    "DNASE:adrenal gland embryo (96 days)",
    "DNASE:coronary artery female adult (53 years)",
    "DNASE:stomach female embryo (105 days)",
    "DNASE:muscle of arm female embryo (115 days)",
    "DNASE:heart female embryo (91 day)",
    "DNASE:kidney embryo (80 days)",
    "DNASE:heart left ventricle female adult (53 years)",
    "DNASE:muscle of back female embryo (98 days)",
    "DNASE:lung male embryo (108 days)",
    "DNASE:tibial artery female adult (53 years)",
    "DNASE:adrenal gland male embryo (101 day)",
    "DNASE:kidney female embryo (121 day)",
    "DNASE:stomach female embryo (107 days)",
    "DNASE:small intestine female embryo (110 days)",
    "DNASE:MG63",
    "DNASE:skin of body female embryo (82 days)",
    "DNASE:left renal cortex interstitium male embryo (105 days)",
    "DNASE:stomach male embryo (58 days) and male embryo (76 days)",
    "DNASE:left kidney female embryo (59 days) and male embryo (91 day)",
    "DNASE:hematopoietic multipotent progenitor cell",
    "DNASE:kidney female embryo (120 days)",
    "DNASE:muscle of back female embryo (115 days)",
    "DNASE:hematopoietic multipotent progenitor cell male adult (25 years) treated with erythropoietin for 20 days, hydrocortisone succinate for 20 days, kit ligand for 20 days, interleukin-3 for 20 days",
    "DNASE:small intestine female embryo (120 days)",
    "DNASE:brain embryo (112 days)",
    "DNASE:stomach female embryo (105 days)",
    "DNASE:left kidney female embryo (98 days)",
    "DNASE:trophoblast cell embryo (21 week)",
    "DNASE:common myeloid progenitor, CD34-positive female adult (27 years)",
    "DNASE:eye female embryo (76 days)",
    "DNASE:renal cortex interstitium male embryo (108 days)",
    "DNASE:placenta female embryo (108 days)",
    "DNASE:stomach female adult (53 years)",
    "DNASE:small intestine female embryo (107 days)",
    "DNASE:large intestine female embryo (120 days)",
    "DNASE:kidney glomerular epithelial cell male adult (43 years) and male adult (62 years)",
    "DNASE:renal pelvis female embryo (96 days)",
    "DNASE:lung female embryo (76 days)",
    "DNASE:muscle of back male embryo (104 days)",
    "DNASE:lung female embryo (85 days)",
    "DNASE:spinal cord male embryo (105 days)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 4 days, kit ligand for 4 days, hydrocortisone succinate for 4 days, erythropoietin for 4 days",
    "DNASE:HepG2",
    "DNASE:foreskin fibroblast male newborn",
    "DNASE:omental fat pad female adult (53 years)",
    "DNASE:large intestine female embryo (110 days)",
    "DNASE:heart female embryo (105 days)",
    "DNASE:renal cortex interstitium male embryo (113 days)",
    "DNASE:brain female embryo (96 days)",
    "DNASE:thyroid gland male adult (37 years)",
    "DNASE:liver embryo (59 days) and embryo (80 days)",
    "DNASE:stomach male adult (54 years)",
    "DNASE:thymus male embryo (127 days)",
    "DNASE:upper lobe of left lung male adult (37 years)",
    "DNASE:endodermal cell",
    "DNASE:forelimb muscle female embryo (108 days)",
    "DNASE:CD4-positive, alpha-beta T cell male adult (37 years)",
    "DNASE:muscle of leg male embryo (101 day)",
    "DNASE:gastrocnemius medialis male adult (37 years)",
    "DNASE:gastrocnemius medialis male adult (54 years)",
    "DNASE:stomach male embryo (91 day)",
    "DNASE:muscle of back male embryo (101 day)",
    "DNASE:heart female embryo (117 days)",
    "DNASE:kidney tubule cell female adult (80 years) and male adult (62 years)",
    "DNASE:fibroblast of skin of abdomen male embryo (97 days)",
    "DNASE:pancreas male adult (34 years)",
    "DNASE:trophoblast cell originated from H1-hESC",
    "DNASE:left kidney male embryo (96 days)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:brain female embryo (142 days)",
    "DNASE:small intestine male embryo (105 days)",
    "DNASE:heart female embryo (110 days)",
    "DNASE:common myeloid progenitor, CD34-positive female",
    "DNASE:adrenal gland male adult (37 years)",
    "DNASE:muscle of back female embryo (85 days)",
    "DNASE:muscle of leg female embryo (85 days)",
    "DNASE:Peyer's patch male adult (54 years)",
    "DNASE:amniotic stem cell",
    "DNASE:stomach female embryo (98 days)",
    "DNASE:large intestine female embryo (91 day)",
    "DNASE:lung female embryo (120 days)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:SW480",
    "DNASE:GM23248",
    "DNASE:muscle of trunk female embryo (120 days)",
    "DNASE:islet precursor cell",
    "DNASE:medulla oblongata male adult (78 years) and male adult (84 years)",
    "DNASE:right lung male embryo (115 days)",
    "DNASE:body of pancreas male adult (54 years)",
    "DNASE:mammary epithelial cell female adult (18 years)",
    "DNASE:gastrocnemius medialis female adult (51 year)",
    "DNASE:uterus female adult (53 years)",
    "DNASE:ELR",
    "DNASE:omental fat pad female adult (51 year)",
    "DNASE:stomach male child (3 years)",
    "DNASE:B cell male adult (37 years)",
    "DNASE:foreskin fibroblast male newborn",
    "DNASE:renal cortex interstitium male embryo (91 day)",
    "DNASE:ACHN",
    "DNASE:kidney tubule cell female adult (80 years) treated with 5 uM cisplatin",
    "DNASE:left renal pelvis male embryo (105 days)",
    "DNASE:iPS DF 6.9 male newborn",
    "DNASE:kidney male embryo (87 days)",
    "DNASE:right lung female embryo (91 day)",
    "DNASE:NCI-H226",
    "DNASE:right renal cortex interstitium male embryo (105 days)",
    "DNASE:G401",
    "DNASE:muscle of arm male embryo (113 days)",
    "DNASE:common myeloid progenitor, CD34-positive male adult",
    "DNASE:muscle of leg female embryo (113 days)",
    "DNASE:arm bone male embryo (81 day)",
    "DNASE:H9",
    "DNASE:testis male embryo",
    "DNASE:neural stem progenitor cell originated from H1-hESC",
    "DNASE:right atrium auricular region female adult (51 year)",
    "DNASE:common myeloid progenitor, CD34-positive male adult (49 years)",
    "DNASE:stomach female embryo (121 day)",
    "DNASE:muscle of leg female embryo (105 days)",
    "DNASE:muscle of leg male embryo (97 days)",
    "DNASE:left kidney female embryo (87 days)",
    "DNASE:muscle of back male embryo (97 days)",
    "DNASE:muscle of leg male embryo (96 days)",
    "DNASE:right lung female embryo (105 days)",
    "DNASE:NAMALWA treated with Sendai virus for 2 hours",
    "DNASE:renal pelvis male embryo (127 days)",
    "DNASE:muscle of arm male embryo (96 days)",
    "DNASE:heart male child (3 years)",
    "DNASE:brain female embryo (117 days)",
    "DNASE:muscle of arm female embryo (85 days)",
    "DNASE:heart male embryo (110 days)",
    "DNASE:L1-S8",
    "DNASE:CD8-positive, alpha-beta T cell male adult (37 years)",
    "DNASE:muscle of back male embryo (91 day)",
    "DNASE:left renal pelvis male embryo (105 days)",
    "DNASE:middle frontal gyrus male adult (78 years)",
    "DNASE:lung male embryo (103 days)",
    "DNASE:heart male embryo (105 days)",
    "DNASE:left renal pelvis male embryo (120 days)",
    "DNASE:common myeloid progenitor, CD34-positive female adult (50 years)",
    "DNASE:Peyer's patch female adult (53 years)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:hematopoietic multipotent progenitor cell",
    "DNASE:right kidney male embryo (87 days)",
    "DNASE:tibial artery male adult (37 years)",
    "DNASE:renal cell carcinoma",
    "DNASE:thymus female embryo (113 days)",
    "DNASE:brain female embryo (109 days)",
    "DNASE:Daoy",
    "DNASE:A673",
    "DNASE:muscle of arm male embryo (101 day)",
    "DNASE:muscle of arm female embryo (120 days)",
    "DNASE:muscle of back male embryo (105 days)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:ecto neural progenitor cell originated from H9",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 17 days, kit ligand for 17 days, hydrocortisone succinate for 17 days, erythropoietin for 17 days",
    "DNASE:hepatocyte originated from H9",
    "DNASE:renal pelvis male embryo (97 days)",
    "DNASE:heart embryo (101 day)",
    "DNASE:large intestine male embryo (115 days)",
    "DNASE:T-cell male adult (37 years)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:CD1c-positive myeloid dendritic cell",
    "DNASE:B cell male adult (21 year)",
    "DNASE:superior temporal gyrus male adult (84 years)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:iPS DF 19.11 male newborn",
    "DNASE:hindlimb muscle male embryo (120 days)",
    "DNASE:MCF 10A treated with 1 uM tamoxifen for 6 hours",
    "DNASE:sigmoid colon male adult (54 years)",
    "DNASE:heart male embryo (120 days)",
    "DNASE:tibial nerve female adult (51 year)",
    "DNASE:adipocyte",
    "DNASE:muscle of trunk female embryo (121 day)",
    "DNASE:left cardiac atrium female embryo (101 day)",
    "DNASE:T-cell male adult (21 year)",
    "DNASE:right kidney male embryo (108 days)",
    "DNASE:adrenal gland female embryo (108 days)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 11 day, kit ligand for 11 day, hydrocortisone succinate for 11 day, erythropoietin for 11 day",
    "DNASE:brain male embryo (105 days)",
    "DNASE:body of pancreas female adult (53 years)",
    "DNASE:left kidney female embryo (147 days)",
    "DNASE:CD4-positive, alpha-beta T cell male adult (37 years)",
    "DNASE:KBM-7",
    "DNASE:psoas muscle male child (3 years)",
    "DNASE:ovary female embryo",
    "DNASE:RKO",
    "DNASE:leg bone male embryo (81 day)",
    "DNASE:glomerular visceral epithelial cell child (3 years)",
    "DNASE:foreskin melanocyte male newborn",
    "DNASE:embryonic facial prominence embryo (53 days) and embryo (58 days)",
    "DNASE:vagina female adult (53 years)",
    "DNASE:kidney female embryo (85 days)",
    "DNASE:muscle of back male embryo (96 days)",
    "DNASE:muscle of trunk female embryo (113 days)",
    "DNASE:iPS DF 19.7 male newborn",
    "DNASE:right lung female embryo (110 days)",
    "DNASE:left lung male embryo (87 days)",
    "DNASE:large intestine female embryo (105 days)",
    "DNASE:right lung female embryo (98 days)",
    "DNASE:leg bone male embryo (81 day)",
    "DNASE:CD14-positive monocyte male adult (21 year)",
    "DNASE:muscle of arm male embryo (120 days)",
    "DNASE:Peyer's patch male adult (37 years)",
    "DNASE:common myeloid progenitor, CD34-positive male adult (36 years)",
    "DNASE:left lung female embryo (108 days)",
    "DNASE:small intestine female embryo (91 day)",
    "DNASE:MM.1S",
    "DNASE:sigmoid colon female adult (51 year)",
    "DNASE:left lung female embryo (105 days)",
    "DNASE:common myeloid progenitor, CD34-positive female adult (33 years)",
    "DNASE:retina embryo (125 days) and male embryo (103 days)",
    "DNASE:brain male embryo (72 days) and male embryo (76 days)",
    "DNASE:muscle of back male embryo (108 days)",
    "DNASE:IMR-90",
    "DNASE:lung female embryo (108 days)",
    "DNASE:left lung male embryo (113 days)",
    "DNASE:OCI-LY7",
    "DNASE:upper lobe of left lung female adult (51 year)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 18 days, kit ligand for 18 days, hydrocortisone succinate for 18 days, erythropoietin for 18 days",
    "DNASE:putamen male adult (78 years)",
    "DNASE:common myeloid progenitor, CD34-positive male adult (42 years)",
    "DNASE:placenta embryo (53 days)",
    "DNASE:kidney male embryo (105 days)",
    "DNASE:heart left ventricle female embryo (136 days)",
    "DNASE:small intestine female embryo (108 days)",
    "DNASE:LoVo",
    "DNASE:cerebellar cortex male adult (78 years) and male adult (84 years)",
    "DNASE:lung embryo (67 days)",
    "DNASE:transverse colon female adult (53 years)",
    "DNASE:brain embryo (80 days)",
    "DNASE:stomach female embryo (108 days)",
    "DNASE:umbilical cord embryo (59 days) and male embryo (76 days)",
    "DNASE:muscle of leg male embryo (105 days)",
    "DNASE:Caki2",
    "DNASE:muscle of arm female embryo (105 days)",
    "DNASE:foreskin melanocyte male newborn",
    "DNASE:stomach male embryo (108 days)",
    "DNASE:body of pancreas male adult (37 years)",
    "DNASE:renal cortex interstitium female embryo (120 days)",
    "DNASE:body of pancreas female adult (51 year)",
    "DNASE:large intestine male embryo (105 days)",
    "DNASE:limb embryo (58 days) and embryo (59 days)",
    "DNASE:heart female embryo (147 days)",
    "DNASE:heart male embryo (96 days)",
    "DNASE:right renal pelvis male embryo (120 days)",
    "DNASE:left lung female embryo (117 days)",
    "DNASE:thymus female embryo (98 days)",
    "DNASE:ovary female adult (53 years)",
    "DNASE:left kidney male embryo (115 days)",
    "DNASE:thymus male embryo (113 days)",
    "DNASE:placenta female embryo (105 days)",
    "DNASE:EH",
    "DNASE:renal cortex interstitium male embryo (97 days)",
    "DNASE:placenta embryo (102 days)",
    "DNASE:placenta embryo (56 days) and embryo (59 days)",
    "DNASE:renal pelvis female embryo (103 days)",
    "DNASE:right lobe of liver female adult (53 years)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:tongue male embryo (72 days)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:liver female embryo (101 day) and female embryo (113 days)",
    "DNASE:large intestine female embryo (107 days)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 6 days, kit ligand for 6 days, hydrocortisone succinate for 6 days, erythropoietin for 6 days",
    "DNASE:common myeloid progenitor, CD34-positive male",
    "DNASE:small intestine female embryo (98 days)",
    "DNASE:CD4-positive, alpha-beta T cell male adult (21 year)",
    "DNASE:brain male embryo (101 day)",
    "DNASE:placenta female embryo (101 day) and male embryo (105 days)",
    "DNASE:renal pelvis male embryo (91 day)",
    "DNASE:lung embryo (80 days) and male embryo (76 days)",
    "DNASE:Ammon's horn male adult (84 years)",
    "DNASE:muscle of back female embryo (105 days)",
    "DNASE:lung male embryo (82 days)",
    "DNASE:left renal cortex interstitium male embryo (105 days)",
    "DNASE:trophoblast cell embryo (17 weeks) and embryo (18 weeks)",
    "DNASE:RPMI8226",
    "DNASE:small intestine male embryo (91 day)",
    "DNASE:brain embryo (56 days) and male embryo (58 days)",
    "DNASE:pancreas female adult (30 years)",
    "DNASE:adrenal gland female adult (53 years)",
    "DNASE:breast epithelium female adult (51 year)",
    "DNASE:left kidney male embryo (87 days)",
    "DNASE:renal pelvis female embryo (96 days)",
    "DNASE:stomach male embryo (127 days)",
    "DNASE:CD8-positive, alpha-beta T cell female adult (34 years)",
    "DNASE:spinal cord female embryo (89 days)",
    "DNASE:muscle of arm male embryo (97 days)",
    "DNASE:renal pelvis female embryo (105 days)",
    "DNASE:HAP-1",
    "DNASE:SJSA1",
    "DNASE:retina embryo (74 days) and embryo (85 days)",
    "DNASE:muscle of leg male embryo (127 days)",
    "DNASE:fibroblast of skin of abdomen male embryo (97 days)",
    "DNASE:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "DNASE:stomach female embryo (147 days)",
    "DNASE:lung male embryo (54 days) and male embryo (58 days)",
    "DNASE:T-cell male adult (36 years)",
    "DNASE:T-cell male adult (21 year)",
    "DNASE:HK-2",
    "DNASE:NCI-H460",
    "DNASE:left lung male embryo (96 days)",
    "DNASE:common myeloid progenitor, CD34-positive male adult (23 years)",
    "DNASE:stomach female adult (51 year)",
    "DNASE:CD4-positive, alpha-beta T cell female adult (33 years)",
    "DNASE:kidney female embryo (113 days)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:placenta female embryo (85 days)",
    "DNASE:brain male embryo (122 days)",
    "DNASE:muscle of arm male embryo (97 days)",
    "DNASE:renal cortex interstitium female embryo (103 days)",
    "DNASE:thyroid gland female adult (51 year)",
    "DNASE:NAMALWA",
    "DNASE:heart embryo (59 days) and female embryo (76 days)",
    "DNASE:large intestine male embryo (105 days)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:right kidney male embryo (96 days)",
    "DNASE:CD14-positive monocyte male adult (37 years)",
    "DNASE:ELF-1",
    "DNASE:spinal cord female embryo (113 days)",
    "DNASE:spleen embryo (112 days)",
    "DNASE:left lung female embryo (107 days)",
    "DNASE:thymus female embryo",
    "DNASE:CD4-positive, alpha-beta T cell male adult (21 year)",
    "DNASE:stomach female embryo (96 days)",
    "DNASE:EL",
    "DNASE:CD14-positive monocyte female adult (34 years)",
    "DNASE:thyroid gland female adult (53 years)",
    "DNASE:adrenal gland female embryo (113 days)",
    "DNASE:muscle of back male embryo (96 days)",
    "DNASE:SJCRH30",
    "DNASE:natural killer cell male adult (21 year)",
    "DNASE:heart male embryo (72 days) and male embryo (76 days)",
    "DNASE:midbrain male adult (78 years) and male adult (84 years)",
    "DNASE:ovary female adult (30 years)",
    "DNASE:mesendoderm originated from H1-hESC",
    "DNASE:natural killer cell male adult (37 years)",
    "DNASE:natural killer cell female adult (34 years)",
    "DNASE:foreskin keratinocyte male newborn",
    "DNASE:stomach female embryo",
    "DNASE:adrenal gland male embryo (108 days)",
    "DNASE:testis male embryo",
    "DNASE:mesenchymal stem cell originated from H1-hESC",
    "DNASE:vagina female adult (51 year)",
    "DNASE:common myeloid progenitor, CD34-positive male adult (43 years)",
    "DNASE:heart right ventricle female embryo (101 day) and female embryo (103 days)",
    "DNASE:L1-S8R",
    "DNASE:heart female embryo (116 days) and female embryo (98 days)",
    "DNASE:MCF 10A treated with 1 uM tamoxifen for 24 hours",
    "DNASE:right renal pelvis male embryo (105 days)",
    "DNASE:muscle of arm female embryo (98 days)",
    "DNASE:H9 G1 phase genetically modified using stable transfection",
    "DNASE:tibial nerve male adult (37 years)",
    "DNASE:kidney male embryo (85 days)",
    "DNASE:tongue female embryo (59 days) and female embryo (76 days)",
    "DNASE:transverse colon female adult (51 year)",
    "DNASE:right renal pelvis male embryo (105 days)",
    "DNASE:large intestine male embryo (91 day)",
    "DNASE:right kidney female embryo (117 days)",
    "DNASE:right kidney male embryo (91 day)",
    "DNASE:skin fibroblast male embryo (97 days)",
    "DNASE:globus pallidus male adult (78 years) and male adult (84 years)",
    "DNASE:kidney female embryo (105 days)",
    "DNASE:right atrium auricular region female adult (53 years)",
    "DNASE:thymus female embryo (147 days)",
    "DNASE:stomach male adult (34 years)",
    "DNASE:eye embryo (56 days) and male embryo (76 days)",
    "DNASE:esophagus squamous epithelium male adult (37 years)",
    "DNASE:glomerular visceral epithelial cell child (3 years)",
    "DNASE:muscle of back male embryo (127 days)",
    "DNASE:spinal cord male embryo (96 days)",
    "DNASE:MCF 10A",
    "DNASE:transverse colon male adult (54 years)",
    "DNASE:kidney embryo (59 days) and female embryo (59 days)",
    "DNASE:H1-hESC",
    "DNASE:large intestine female embryo (98 days)",
    "DNASE:large intestine female embryo (103 days)",
    "DNASE:placenta male embryo (85 days)",
    "DNASE:left lung female embryo (91 day)",
    "DNASE:heart embryo (80 days)",
    "DNASE:femur female embryo (98 days)",
    "DNASE:H4",
    "DNASE:trophoblast cell embryo (23 weeks)",
    "DNASE:urinary bladder male embryo (76 days)",
    "DNASE:HT-29",
    "DNASE:limb embryo (53 days) and embryo (56 days)",
    "DNASE:retina female embryo (89 days)",
    "DNASE:dedifferentiated amniotic fluid mesenchymal stem cell",
    "DNASE:upper lobe of left lung female adult (53 years)",
    "DNASE:brain female embryo (105 days)",
    "DNASE:muscle of arm embryo (101 day)",
    "DNASE:renal cortex interstitium male embryo (108 days)",
    "DNASE:pons male adult (78 years)",
    "DNASE:thymus female embryo (105 days)",
    "DNASE:CD8-positive, alpha-beta T cell female adult (33 years)",
    "DNASE:cardiac muscle cell",
    "DNASE:CD8-positive, alpha-beta T cell male adult (21 year)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 8 days, kit ligand for 8 days, hydrocortisone succinate for 8 days, erythropoietin for 8 days",
    "DNASE:right lung female embryo (117 days)",
    "DNASE:right lung male embryo (105 days)",
    "DNASE:lung female embryo (96 days)",
    "DNASE:adrenal gland male adult (54 years)",
    "DNASE:renal cortex interstitium male embryo (127 days)",
    "DNASE:spleen male adult (54 years)",
    "DNASE:renal cortex interstitium female embryo (89 days)",
    "DNASE:ascending aorta female adult (51 year)",
    "DNASE:ovary female adult (51 year)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 13 days, kit ligand for 13 days, hydrocortisone succinate for 13 days, erythropoietin for 13 days",
    "DNASE:cardiac fibroblast female embryo (94 days) and female embryo (98 days)",
    "DNASE:adrenal gland male embryo (85 days)",
    "DNASE:large intestine male embryo (108 days)",
    "DNASE:occipital lobe male adult (84 years)",
    "DNASE:right lung female embryo (107 days)",
    "DNASE:small intestine female embryo (105 days)",
    "DNASE:muscle of leg male embryo (104 days)",
    "DNASE:lower leg skin female adult (53 years)",
    "DNASE:adrenal gland female adult (51 year)",
    "DNASE:adrenal gland female embryo (85 days)",
    "DNASE:muscle of arm male embryo (115 days)",
    "DNASE:right kidney female embryo (147 days)",
    "DNASE:kidney female embryo (76 days) and male embryo (76 days)",
    "DNASE:large intestine female embryo (108 days)",
    "DNASE:right kidney female embryo (98 days)",
    "DNASE:right renal cortex interstitium male embryo (120 days)",
    "DNASE:muscle of arm male embryo (96 days)",
    "DNASE:thymus male embryo (108 days)",
    "DNASE:B cell female adult (34 years)",
    "DNASE:thyroid gland male adult (54 years)",
    "DNASE:spinal cord female embryo (59 days) and male embryo (72 days)",
    "DNASE:heart embryo (96 days)",
    "DNASE:renal pelvis female embryo (89 days)",
    "DNASE:renal pelvis male embryo (108 days)",
    "DNASE:heart female embryo (103 days)",
    "DNASE:H9",
    "DNASE:K562",
    "DNASE:left renal cortex interstitium male embryo (105 days)",
    "DNASE:right lung female embryo (108 days)",
    "DNASE:stomach female embryo (96 days)",
    "DNASE:small intestine male adult (34 years)",
    "DNASE:renal cortex interstitium female embryo (96 days)",
    "DNASE:A172",
    "DNASE:left lung male embryo (115 days)",
    "DNASE:muscle of leg male embryo (115 days)",
    "DNASE:hematopoietic multipotent progenitor cell treated with interleukin-3 for 15 days, kit ligand for 15 days, hydrocortisone succinate for 15 days, erythropoietin for 15 days",
    "DNASE:muscle of leg female embryo (115 days)",
    "DNASE:PC-9",
    "DNASE:kidney female embryo (108 days)",
    "DNASE:stomach embryo (101 day)",
    "DNASE:H9 G2 phase genetically modified using stable transfection",
    "DNASE:esophagus muscularis mucosa male adult (37 years)",
    "DNASE:small intestine male embryo (108 days)",
    "DNASE:heart left ventricle female embryo (101 day) and female embryo (103 days)",
    "DNASE:SK-N-DZ",
    "DNASE:brain male embryo (104 days)",
    "DNASE:right lung male embryo (87 days)",
    "DNASE:muscle of arm male embryo (105 days)",
    "DNASE:muscle of arm male embryo (104 days)",
    "DNASE:kidney female embryo (105 days)",
    "DNASE:left lung male embryo (105 days)",
    "DNASE:left kidney female embryo (107 days)",
    "DNASE:Peyer's patch male adult (37 years)",
    "DNASE:renal pelvis male embryo (113 days)",
    "DNASE:prostate gland male adult (37 years)",
    "DNASE:HeLa-S3",
    "DNASE:left lung female embryo (110 days)",
    "DNASE:thymus male embryo (104 days)",
    "DNASE:neural progenitor cell originated from H9",
    "DNASE:trophoblast cell embryo (39 weeks) and embryo (40 weeks)",
    "DNASE:right lung male embryo (96 days)",
    "DNASE:H9 G1 phase genetically modified using stable transfection",
    "DNASE:small intestine male embryo (87 days)",
    "DNASE:spinal cord female embryo (87 days)",
    "DNASE:left kidney female embryo (110 days)",
    "DNASE:arm bone male embryo (81 day)",
    "DNASE:testis male adult (54 years)",
    "DNASE:transverse colon male adult (37 years)",
    "DNASE:right renal pelvis male embryo (105 days)",
    "DNASE:lung embryo (101 day)",
    "DNASE:inferior parietal cortex male adult (84 years)",
    "DNASE:kidney capillary endothelial cell female embryo (113 days)",
    "DNASE:placenta male embryo (91 day)",
    "DNASE:right kidney male embryo (115 days)",
    "DNASE:coronary artery female adult (51 year)",
    "ATAC:BM0106-Day0-MCP-A / Bone Marrow CD34+ / pDC",
    "ATAC:BM0106-UNK-ATAC-2 / Bone Marrow CD34+ / UNK",
    "ATAC:BM0828-MEGA1-A-151109 / Bone Marrow CD34+ / Mega",
    "ATAC:BM1077-MCP / Bone Marrow CD34+ / pDC",
    "ATAC:BM1077-UNK / Bone Marrow CD34+ / UNK",
    "ATAC:BM1137-GMP1-low-ATAC-2 / Bone Marrow CD34+ / GMP-A",
    "ATAC:BM1137-GMP2-mid-ATAC-1 / Bone Marrow CD34+ / GMP-B",
    "ATAC:BM1137-GMP3-high-ATAC-2 / Bone Marrow CD34+ / GMP-C",
    "ATAC:BM1214-Day0-MCP / Bone Marrow CD34+ / pDC",
    "ATAC:BM1214-Day0-UNK-A / Bone Marrow CD34+ / UNK",
    "CHIP:CTCF:MCF-7",
    "CHIP:TAF1:MCF-7",
    "CHIP:H3K4me3:GM12878",
    "CHIP:CTCF:GM12878",
    "CHIP:H3K27ac:GM12878",
    "CHIP:H3K27me3:GM12878",
    "CHIP:H3K4me1:GM12878",
    "CHIP:H3K4me2:GM12878",
    "CHIP:H3K9ac:GM12878",
    "CHIP:H4K20me1:GM12878",
    "CHIP:H3K27me3:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K4me2:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K4me3:endothelial cell of umbilical vein male newborn",
    "CHIP:CTCF:K562",
    "CHIP:H3K27me3:K562",
    "CHIP:H3K36me3:K562",
    "CHIP:H3K4me2:K562",
    "CHIP:H3K4me3:K562",
    "CHIP:H3K9ac:K562",
    "CHIP:H3K9me1:K562",
    "CHIP:CTCF:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K27ac:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K27ac:keratinocyte female",
    "CHIP:H3K27ac:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K27me3:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K36me3:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K4me2:HepG2",
    "CHIP:H3K9ac:HepG2",
    "CHIP:CTCF:H1-hESC",
    "CHIP:H3K4me1:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K4me2:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K4me3:mammary epithelial cell female adult (50 years)",
    "CHIP:H4K20me1:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K4me3:HepG2",
    "CHIP:H4K20me1:HepG2",
    "CHIP:H3K27ac:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K27me3:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K36me3:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K4me3:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K9ac:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K27ac:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K27me3:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K36me3:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K4me1:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K4me2:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K4me3:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K9ac:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H4K20me1:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K27ac:H1-hESC",
    "CHIP:H3K79me2:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K9me3:skeletal muscle myoblast male adult (22 years)",
    "CHIP:CTCF:myotube",
    "CHIP:H2AFZ:myotube",
    "CHIP:H3K27ac:myotube",
    "CHIP:H3K36me3:myotube",
    "CHIP:H3K4me1:myotube",
    "CHIP:H3K4me2:myotube",
    "CHIP:H3K4me3:myotube",
    "CHIP:CTCF:HeLa-S3",
    "CHIP:H3K27ac:HeLa-S3",
    "CHIP:H3K4me2:HeLa-S3",
    "CHIP:H3K4me3:HeLa-S3",
    "CHIP:H3K79me2:HeLa-S3",
    "CHIP:H3K9ac:HeLa-S3",
    "CHIP:H4K20me1:HeLa-S3",
    "CHIP:H3K27me3:HepG2",
    "CHIP:H3K79me2:myotube",
    "CHIP:CTCF:astrocyte",
    "CHIP:H3K27ac:astrocyte",
    "CHIP:H3K4me3:astrocyte",
    "CHIP:H2AFZ:GM12878",
    "CHIP:H3K79me2:GM12878",
    "CHIP:H3K9ac:myotube",
    "CHIP:H4K20me1:myotube",
    "CHIP:H2AFZ:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K27me3:HeLa-S3",
    "CHIP:H2AFZ:K562",
    "CHIP:H3K79me2:K562",
    "CHIP:H3K9me3:K562",
    "CHIP:H2AFZ:osteoblast",
    "CHIP:H3K27ac:osteoblast",
    "CHIP:H3K36me3:osteoblast",
    "CHIP:H3K4me1:osteoblast",
    "CHIP:H3K4me2:osteoblast",
    "CHIP:H3K9me3:osteoblast",
    "CHIP:CTCF:fibroblast of dermis",
    "CHIP:H3K27ac:fibroblast of dermis",
    "CHIP:H3K4me3:fibroblast of dermis NONE and female adult",
    "CHIP:H3K4me1:HepG2",
    "CHIP:H3K4me1:HeLa-S3",
    "CHIP:KDM5B:K562",
    "CHIP:RBBP5:H1-hESC",
    "CHIP:HDAC1:K562",
    "CHIP:HDAC2:K562",
    "CHIP:PHF8:K562",
    "CHIP:RBBP5:K562",
    "CHIP:SAP30:K562",
    "CHIP:CHD1:H1-hESC",
    "CHIP:H3K9me3:myotube",
    "CHIP:H2AFZ:HeLa-S3",
    "CHIP:H3K9me3:HeLa-S3",
    "CHIP:H3K27me3:osteoblast",
    "CHIP:H4K20me1:osteoblast",
    "CHIP:H2AFZ:DND-41",
    "CHIP:H3K27ac:DND-41",
    "CHIP:H3K36me3:DND-41",
    "CHIP:H3K4me1:DND-41",
    "CHIP:H3K4me3:DND-41",
    "CHIP:H3K79me2:DND-41",
    "CHIP:H4K20me1:DND-41",
    "CHIP:EZH2:GM12878",
    "CHIP:EZH2:mammary epithelial cell female adult (50 years)",
    "CHIP:H2AFZ:mammary epithelial cell female adult (50 years)",
    "CHIP:H3K9me3:mammary epithelial cell female adult (50 years)",
    "CHIP:EZH2:skeletal muscle myoblast male adult (22 years)",
    "CHIP:EZH2:HepG2",
    "CHIP:H2AFZ:keratinocyte female",
    "CHIP:H3K79me2:keratinocyte female",
    "CHIP:H3K9me3:keratinocyte female",
    "CHIP:EZH2:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H2AFZ:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K9me3:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K9ac:astrocyte",
    "CHIP:H4K20me1:astrocyte",
    "CHIP:H3K9ac:DND-41",
    "CHIP:H3K9me3:DND-41",
    "CHIP:H3K79me2:mammary epithelial cell female adult (50 years)",
    "CHIP:H2AFZ:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K79me2:endothelial cell of umbilical vein male newborn",
    "CHIP:EZH2:fibroblast of dermis",
    "CHIP:H3K79me2:fibroblast of lung female child (11 year) and male adult (45 years)",
    "CHIP:H3K79me2:osteoblast",
    "CHIP:H3K4me3:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K27ac:CD14-positive monocyte female",
    "CHIP:H3K27me3:CD14-positive monocyte female",
    "CHIP:H3K36me3:CD14-positive monocyte female",
    "CHIP:H3K4me1:CD14-positive monocyte female",
    "CHIP:H3K4me3:CD14-positive monocyte female",
    "CHIP:H3K79me2:CD14-positive monocyte female",
    "CHIP:H3K9me3:CD14-positive monocyte female",
    "CHIP:H4K20me1:CD14-positive monocyte female",
    "CHIP:H3K4me3:A549 treated with 100 nM dexamethasone for 1 hour",
    "CHIP:H3K9ac:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K27me3:DND-41",
    "CHIP:H3K9me3:endothelial cell of umbilical vein male newborn",
    "CHIP:EZH2:HeLa-S3",
    "CHIP:H3K9me3:HepG2",
    "CHIP:H3K9ac:CD14-positive monocyte female",
    "CHIP:H3K4me3:osteoblast",
    "CHIP:H3K27me3:myotube",
    "CHIP:HDAC6:K562",
    "CHIP:PHF8:H1-hESC",
    "CHIP:CTCF:CD14-positive monocyte female",
    "CHIP:H3K79me2:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:HDAC6:H1-hESC",
    "CHIP:SAP30:H1-hESC",
    "CHIP:SUZ12:H1-hESC",
    "CHIP:CREBBP:K562",
    "CHIP:CBX3:K562",
    "CHIP:KAT2B:K562",
    "CHIP:SIRT6:K562",
    "CHIP:SUZ12:K562",
    "CHIP:CTCF:A549 treated with 100 nM dexamethasone for 1 hour",
    "CHIP:H2AFZ:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K27ac:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K27me3:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K4me1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K9me3:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H4K20me1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H3K27ac:B cell female adult (27 years)",
    "CHIP:EP300:H1-hESC",
    "CHIP:SIRT6:H1-hESC",
    "CHIP:SETDB1:K562",
    "CHIP:CTCF:B cell female adult (27 years) and female adult (43 years)",
    "CHIP:H2AFZ:B cell female adult (27 years) and female adult (43 years)",
    "CHIP:H3K4me2:B cell female adult (27 years) and female adult (43 years)",
    "CHIP:CHD7:H1-hESC",
    "CHIP:HDAC2:H1-hESC",
    "CHIP:KDM4A:H1-hESC",
    "CHIP:WHSC1:K562",
    "CHIP:H3K27ac:A549 treated with 100 nM dexamethasone for 1 hour",
    "CHIP:H3K4me2:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:H4K20me1:B cell female adult (27 years)",
    "CHIP:FOXP2:SK-N-MC",
    "CHIP:POLR2A:GM12878",
    "CHIP:SRF:GM12878",
    "CHIP:REST:GM12878",
    "CHIP:USF1:GM12878",
    "CHIP:JUND:HepG2",
    "CHIP:SIN3A:HepG2",
    "CHIP:USF1:HepG2",
    "CHIP:POLR2A:HeLa-S3",
    "CHIP:PBX3:GM12878",
    "CHIP:TAF1:GM12878",
    "CHIP:BATF:GM12878",
    "CHIP:EBF1:GM12878",
    "CHIP:IRF4:GM12878",
    "CHIP:TCF12:GM12878",
    "CHIP:BCL11A:GM12878",
    "CHIP:EP300:GM12878",
    "CHIP:ZBTB33:GM12878",
    "CHIP:PAX5:GM12878",
    "CHIP:NR3C1:A549 treated with 500 pM dexamethasone for 1 hour",
    "CHIP:NR3C1:A549 treated with 50 nM dexamethasone for 1 hour",
    "CHIP:NR3C1:A549 treated with 5 nM dexamethasone for 1 hour",
    "CHIP:POLR2A:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:POLR2A:A549 treated with 100 nM dexamethasone for 1 hour",
    "CHIP:PAX5:GM12878",
    "CHIP:REST:H1-hESC",
    "CHIP:POLR2A:H1-hESC",
    "CHIP:TAF1:H1-hESC",
    "CHIP:FOSL2:HepG2",
    "CHIP:GABPA:HeLa-S3",
    "CHIP:TAF1:HeLa-S3",
    "CHIP:RXRA:HepG2",
    "CHIP:POLR2A:GM12892",
    "CHIP:POLR2AphosphoS5:GM12892",
    "CHIP:TAF1:GM12892",
    "CHIP:POLR2AphosphoS5:H1-hESC",
    "CHIP:BHLHE40:HepG2",
    "CHIP:CTCF:HepG2",
    "CHIP:POLR2AphosphoS5:GM12878",
    "CHIP:POU2F2:GM12891",
    "CHIP:SPI1:GM12891",
    "CHIP:POLR2A:GM12891",
    "CHIP:POLR2AphosphoS5:GM12891",
    "CHIP:TAF1:GM12891",
    "CHIP:NR3C1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:BCL11A:H1-hESC",
    "CHIP:SIX5:H1-hESC",
    "CHIP:SP1:H1-hESC",
    "CHIP:SIN3A:H1-hESC",
    "CHIP:TCF12:H1-hESC",
    "CHIP:USF1:H1-hESC",
    "CHIP:SRF:H1-hESC",
    "CHIP:GABPA:H1-hESC",
    "CHIP:ESR1:Ishikawa treated with 10 nM estradiol for 1 hour",
    "CHIP:ESR1:Ishikawa treated with 0.02% dimethyl sulfoxide for 1 hour",
    "CHIP:EGR1:H1-hESC",
    "CHIP:NR3C1:Ishikawa treated with 100 nM dexamethasone for 1 hour",
    "CHIP:RXRA:GM12878",
    "CHIP:SIX5:GM12878",
    "CHIP:TCF12:HepG2",
    "CHIP:PAX5:GM12891",
    "CHIP:REST:SK-N-SH",
    "CHIP:GABPA:HepG2",
    "CHIP:REST:HepG2",
    "CHIP:POLR2A:HepG2",
    "CHIP:TAF1:HepG2",
    "CHIP:REST:Panc1",
    "CHIP:REST:PFSK-1",
    "CHIP:NR3C1:A549 treated with 100 nM dexamethasone for 1 hour",
    "CHIP:ESR1:T47D treated with 100 nM genistein for 1 hour",
    "CHIP:NR3C1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:RXRA:H1-hESC",
    "CHIP:SP1:HepG2",
    "CHIP:BCLAF1:GM12878",
    "CHIP:ETS1:GM12878",
    "CHIP:MEF2A:GM12878",
    "CHIP:ATF3:H1-hESC",
    "CHIP:YY1:H1-hESC",
    "CHIP:ATF3:HepG2",
    "CHIP:BCLAF1:K562",
    "CHIP:POLR2A:Ishikawa treated with 0.02% dimethyl sulfoxide for 1 hour",
    "CHIP:YY1:GM12891",
    "CHIP:EP300:H1-hESC",
    "CHIP:JUND:H1-hESC",
    "CHIP:ETS1:K562",
    "CHIP:POLR2AphosphoS5:K562",
    "CHIP:FOXA1:T47D treated with 0.02% dimethyl sulfoxide for 1 hour",
    "CHIP:NR3C1:Ishikawa treated with 0.02% ethanol for 1 hour",
    "CHIP:RAD21:H1-hESC",
    "CHIP:FOXA1:HepG2",
    "CHIP:HNF4A:HepG2",
    "CHIP:E2F6:K562",
    "CHIP:ESR1:T47D treated with 0.02% dimethyl sulfoxide for 1 hour",
    "CHIP:GABPA:K562",
    "CHIP:MAX:K562",
    "CHIP:SIN3A:K562",
    "CHIP:RAD21:HepG2",
    "CHIP:YY1:GM12892",
    "CHIP:TAF7:H1-hESC",
    "CHIP:EP300:HepG2",
    "CHIP:CTCF:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:RAD21:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:YY1:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:HDAC2:HepG2",
    "CHIP:ZBTB7A:K562",
    "CHIP:USF1:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:YY1:K562",
    "CHIP:SRF:GM12878",
    "CHIP:BCL11A:H1-hESC",
    "CHIP:POLR2AphosphoS5:HCT116",
    "CHIP:REST:HeLa-S3",
    "CHIP:FOXA1:HepG2",
    "CHIP:POLR2A:K562",
    "CHIP:NANOG:H1-hESC",
    "CHIP:FOSL1:K562",
    "CHIP:REST:K562",
    "CHIP:GATA3:T47D treated with 0.02% dimethyl sulfoxide for 1 hour",
    "CHIP:RAD21:GM12878",
    "CHIP:ELF1:HepG2",
    "CHIP:ZBTB33:HepG2",
    "CHIP:EGR1:K562",
    "CHIP:MEF2C:GM12878",
    "CHIP:CTCF:H1-hESC",
    "CHIP:FOXA2:HepG2",
    "CHIP:HNF4G:HepG2",
    "CHIP:TAF7:K562",
    "CHIP:THAP1:K562",
    "CHIP:YY1:GM12878",
    "CHIP:BCL3:GM12878",
    "CHIP:HDAC2:H1-hESC",
    "CHIP:FOSL1:H1-hESC",
    "CHIP:YY1:HepG2",
    "CHIP:ATF3:K562",
    "CHIP:MEF2A:K562",
    "CHIP:SIX5:K562",
    "CHIP:REST:HepG2",
    "CHIP:POLR2AphosphoS5:Panc1",
    "CHIP:REST:PFSK-1",
    "CHIP:REST:SK-N-SH",
    "CHIP:POLR2AphosphoS5:SK-N-SH",
    "CHIP:SIN3A:SK-N-SH",
    "CHIP:POLR2AphosphoS5:PFSK-1",
    "CHIP:SP1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:TAF1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:POLR2AphosphoS5:HepG2",
    "CHIP:CTCF:K562",
    "CHIP:POLR2AphosphoS5:SK-N-MC",
    "CHIP:YY1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:ATF3:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:ELF1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:ETS1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:FOXA1:A549 treated with 100 nM dexamethasone for 1 hour",
    "CHIP:GABPA:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:ZBTB33:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:ZBTB7A:HepG2",
    "CHIP:POLR2A:endothelial cell of umbilical vein newborn",
    "CHIP:POLR2AphosphoS5:endothelial cell of umbilical vein newborn",
    "CHIP:ESR1:T47D treated with 100 nM bisphenol A for 30 minutes",
    "CHIP:CTCF:Ishikawa treated with 0.02% dimethyl sulfoxide for 1 hour",
    "CHIP:TAF1:SK-N-SH",
    "CHIP:BCL3:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:CEBPB:HepG2",
    "CHIP:ATF2:GM12878",
    "CHIP:NFATC1:GM12878",
    "CHIP:TAF1:PFSK-1",
    "CHIP:FOSL2:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:REST:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:TCF12:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:ESR1:Ishikawa treated with 100 nM bisphenol A for 1 hour",
    "CHIP:REST:GM12878",
    "CHIP:PML:K562",
    "CHIP:STAT5A:GM12878",
    "CHIP:CREB1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:CREB1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:FOXA1:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:JUND:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:EGR1:GM12878",
    "CHIP:MTA3:GM12878",
    "CHIP:RUNX3:GM12878",
    "CHIP:TEAD4:K562",
    "CHIP:SIX5:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:SIN3A:A549 treated with 0.02% ethanol for 1 hour",
    "CHIP:NFIC:GM12878",
    "CHIP:STAT5A:K562",
    "CHIP:NR2F2:K562",
    "CHIP:CBX3:K562",
    "CHIP:TRIM28:K562",
    "CHIP:JUND:HCT116",
    "CHIP:CTCF:HCT116",
    "CHIP:JUND:SK-N-SH",
    "CHIP:JUND:MCF-7",
    "CHIP:REST:HL-60",
    "CHIP:GABPA:HL-60",
    "CHIP:POLR2AphosphoS5:HL-60",
    "CHIP:POLR2AphosphoS5:neural cell",
    "CHIP:SPI1:HL-60",
    "CHIP:JUND:T47D",
    "CHIP:eGFP-NR4A1:K562 genetically modified using stable transfection",
    "CHIP:eGFP-HDAC8:K562 genetically modified using stable transfection",
    "CHIP:eGFP-GATA2:K562 genetically modified using stable transfection",
    "CHIP:CTCF:H54",
    "CHIP:CTCF:GM10248",
    "CHIP:CTCF:GM10266",
    "CHIP:CTCF:GM13976",
    "CHIP:CTCF:GM13977",
    "CHIP:CTCF:GM20000",
    "CHIP:POLR2A:H1-hESC",
    "CHIP:CTCF:H1-hESC",
    "CHIP:CTCF:LNCaP clone FGC",
    "CHIP:MYC:MCF-7 originated from MCF-7",
    "CHIP:MYC:MCF-7 originated from MCF-7",
    "CHIP:POLR2A:MCF-7 originated from MCF-7",
    "CHIP:CTCF:MCF-7 originated from MCF-7",
    "CHIP:MYC:MCF-7",
    "CHIP:CTCF:MCF-7",
    "CHIP:CTCF:MCF-7 treated with 100 nM 17B-estradiol for 45 minutes",
    "CHIP:CTCF:medulloblastoma",
    "CHIP:CTCF:A549",
    "CHIP:CTCF:keratinocyte female",
    "CHIP:CTCF:spleen female adult (20 years) and female adult (30 years)",
    "CHIP:NFYB:GM12878",
    "CHIP:NFYA:GM12878",
    "CHIP:KAT2A:GM12878",
    "CHIP:SUPT20H:GM12878",
    "CHIP:ZZZ3:GM12878",
    "CHIP:FOS:MCF 10A originated from MCF 10A treated with 1 uM afimoxifene for 36 hours",
    "CHIP:FOS:MCF 10A genetically modified using stable transfection treated with 1 uM afimoxifene for 4 hours",
    "CHIP:FOS:MCF 10A genetically modified using stable transfection treated with 1 uM afimoxifene for 12 hours",
    "CHIP:STAT3:MCF 10A genetically modified using stable transfection treated with 1 uM afimoxifene for 12 hours",
    "CHIP:MYC:MCF 10A genetically modified using stable transfection treated with 0.01% ethanol for 36 hours",
    "CHIP:FOS:MCF 10A genetically modified using stable transfection treated with 0.01% ethanol for 36 hours",
    "CHIP:STAT3:MCF 10A genetically modified using stable transfection treated with 0.01% ethanol for 36 hours",
    "CHIP:POLR2A:MCF 10A genetically modified using stable transfection treated with 0.01% ethanol for 36 hours",
    "CHIP:STAT3:MCF 10A originated from MCF 10A treated with 1 uM afimoxifene for 36 hours",
    "CHIP:POLR2A:MCF 10A originated from MCF 10A treated with 1 uM afimoxifene for 36 hours",
    "CHIP:H3K4me3:A549",
    "CHIP:CTCF:AG04449",
    "CHIP:H3K4me3:AG04449",
    "CHIP:H3K9me3:AG04450",
    "CHIP:H3K27me3:AG04450",
    "CHIP:H3K27ac:AG04450",
    "CHIP:CTCF:AG04450",
    "CHIP:H3K4me3:AG04450",
    "CHIP:CTCF:AG09309",
    "CHIP:H3K4me3:AG09309",
    "CHIP:CTCF:AG09319",
    "CHIP:H3K4me3:AG09319",
    "CHIP:CTCF:AG10803",
    "CHIP:H3K4me3:AG10803",
    "CHIP:CTCF:fibroblast of the aortic adventitia female",
    "CHIP:H3K4me3:fibroblast of the aortic adventitia female",
    "CHIP:H3K4me3:BE2C",
    "CHIP:CTCF:BE2C",
    "CHIP:H3K36me3:BJ",
    "CHIP:H3K27me3:BJ",
    "CHIP:H3K4me3:BJ",
    "CHIP:CTCF:BJ",
    "CHIP:H3K36me3:Caco-2",
    "CHIP:H3K27me3:Caco-2",
    "CHIP:H3K4me3:Caco-2",
    "CHIP:CTCF:Caco-2",
    "CHIP:H3K4me3:B cell female adult (43 years)",
    "CHIP:H3K4me3:B cell female adult (27 years)",
    "CHIP:H3K36me3:GM06990",
    "CHIP:H3K27me3:GM06990",
    "CHIP:H3K4me3:GM06990",
    "CHIP:CTCF:GM06990",
    "CHIP:H3K4me3:GM12864",
    "CHIP:CTCF:GM12864",
    "CHIP:H3K4me3:GM12865",
    "CHIP:CTCF:GM12865",
    "CHIP:CTCF:GM12873",
    "CHIP:CTCF:GM12874",
    "CHIP:H3K4me3:GM12875",
    "CHIP:H3K36me3:GM12878",
    "CHIP:H3K27me3:GM12878",
    "CHIP:H3K4me3:GM12878",
    "CHIP:H3K4me3:cardiac mesoderm",
    "CHIP:H3K4me3:cardiac mesoderm",
    "CHIP:H3K36me3:cardiac mesoderm",
    "CHIP:H3K36me3:cardiac mesoderm",
    "CHIP:H3K36me3:cardiac mesoderm",
    "CHIP:H3K36me3:cardiac mesoderm",
    "CHIP:H3K27me3:cardiac mesoderm",
    "CHIP:H3K27me3:cardiac mesoderm",
    "CHIP:H3K27me3:cardiac mesoderm",
    "CHIP:H3K27me3:cardiac mesoderm",
    "CHIP:H3K4me3:cardiac mesoderm",
    "CHIP:H3K4me3:cardiac mesoderm",
    "CHIP:H3K4me3:H7-hESC",
    "CHIP:H3K36me3:H7-hESC",
    "CHIP:H3K27me3:H7-hESC",
    "CHIP:CTCF:astrocyte of the spinal cord",
    "CHIP:H3K4me3:astrocyte of the spinal cord",
    "CHIP:H3K4me3:astrocyte of the cerebellum",
    "CHIP:CTCF:astrocyte of the cerebellum",
    "CHIP:CTCF:brain microvascular endothelial cell",
    "CHIP:H3K4me3:brain microvascular endothelial cell",
    "CHIP:H3K4me3:cardiac fibroblast",
    "CHIP:CTCF:cardiac fibroblast female",
    "CHIP:H3K4me3:cardiac fibroblast female",
    "CHIP:CTCF:cardiac muscle cell",
    "CHIP:H3K4me3:cardiac muscle cell",
    "CHIP:CTCF:choroid plexus epithelial cell",
    "CHIP:H3K4me3:choroid plexus epithelial cell",
    "CHIP:CTCF:HCT116",
    "CHIP:H3K4me3:HCT116",
    "CHIP:CTCF:epithelial cell of esophagus",
    "CHIP:H3K4me3:epithelial cell of esophagus",
    "CHIP:H3K4me3:HEK293",
    "CHIP:H3K27me3:HeLa-S3 G1b phase",
    "CHIP:H3K36me3:HeLa-S3 G1b phase",
    "CHIP:H3K4me3:HeLa-S3 G1b phase",
    "CHIP:H3K36me3:HepG2",
    "CHIP:H3K27me3:HepG2",
    "CHIP:H3K4me3:HepG2",
    "CHIP:CTCF:foreskin fibroblast male newborn",
    "CHIP:H3K4me3:foreskin fibroblast male newborn",
    "CHIP:H3K4me3:HFF-Myc originated from foreskin fibroblast",
    "CHIP:CTCF:HFF-Myc originated from foreskin fibroblast",
    "CHIP:H3K4me3:HL-60",
    "CHIP:CTCF:HL-60",
    "CHIP:H3K4me3:mammary epithelial cell female",
    "CHIP:CTCF:mammary epithelial cell female",
    "CHIP:CTCF:fibroblast of mammary gland female",
    "CHIP:H3K4me3:fibroblast of mammary gland female",
    "CHIP:CTCF:fibroblast of pulmonary artery",
    "CHIP:H3K4me3:fibroblast of pulmonary artery",
    "CHIP:CTCF:fibroblast of lung",
    "CHIP:H3K4me3:fibroblast of lung",
    "CHIP:H3K36me3:kidney epithelial cell",
    "CHIP:H3K27me3:kidney epithelial cell",
    "CHIP:H3K4me3:kidney epithelial cell",
    "CHIP:CTCF:kidney epithelial cell",
    "CHIP:CTCF:retinal pigment epithelial cell",
    "CHIP:H3K4me3:retinal pigment epithelial cell",
    "CHIP:H3K36me3:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K4me3:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K27me3:endothelial cell of umbilical vein male newborn",
    "CHIP:CTCF:fibroblast of villous mesenchyme",
    "CHIP:H3K4me3:fibroblast of villous mesenchyme",
    "CHIP:H3K4me3:Jurkat clone E61",
    "CHIP:H3K36me3:K562",
    "CHIP:H3K4me3:K562",
    "CHIP:CTCF:K562",
    "CHIP:H3K4me3:LNCaP clone FGC",
    "CHIP:CTCF:MCF-7",
    "CHIP:H3K4me3:MCF-7",
    "CHIP:H3K4me3:CD14-positive monocyte female",
    "CHIP:H3K27me3:CD14-positive monocyte female",
    "CHIP:CTCF:NB4",
    "CHIP:H3K4me3:NB4",
    "CHIP:CTCF:foreskin fibroblast male newborn",
    "CHIP:H3K4me3:foreskin fibroblast male newborn",
    "CHIP:H3K4me3:keratinocyte female",
    "CHIP:H3K36me3:keratinocyte female",
    "CHIP:CTCF:fibroblast of lung male adult (45 years)",
    "CHIP:H3K4me3:fibroblast of lung male adult (45 years)",
    "CHIP:H3K4me3:Panc1",
    "CHIP:CTCF:epithelial cell of proximal tubule",
    "CHIP:H3K4me3:epithelial cell of proximal tubule",
    "CHIP:H3K36me3:bronchial epithelial cell",
    "CHIP:H3K4me3:bronchial epithelial cell",
    "CHIP:H3K27me3:bronchial epithelial cell",
    "CHIP:H3K4me3:SK-N-MC",
    "CHIP:H3K36me3:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:H3K27me3:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:H3K4me3:SK-N-SH treated with 6 uM all-trans-retinoic acid for 48 hours",
    "CHIP:H3K4me3:skeletal muscle cell",
    "CHIP:H3K4me3:WERI-Rb-1",
    "CHIP:CTCF:WERI-Rb-1",
    "CHIP:H3K4me3:WI38 genetically modified using stable transfection treated with 20 nM afimoxifene for 72 hours",
    "CHIP:H3K4me3:WI38",
    "CHIP:CTCF:WI38",
    "CHIP:MYC:A549",
    "CHIP:CTCF:A549",
    "CHIP:RAD21:A549",
    "CHIP:POLR2AphosphoS2:A549",
    "CHIP:CEBPB:A549",
    "CHIP:ZNF384:GM12878",
    "CHIP:ESRRA:GM12878",
    "CHIP:CUX1:GM12878",
    "CHIP:JUND:GM12878",
    "CHIP:MAFK:GM12878",
    "CHIP:SIN3A:GM12878",
    "CHIP:E2F4:GM12878",
    "CHIP:TBL1XR1:GM12878",
    "CHIP:MAZ:GM12878",
    "CHIP:ELK1:GM12878",
    "CHIP:RCOR1:GM12878",
    "CHIP:EP300:GM12878",
    "CHIP:CHD1:GM12878",
    "CHIP:MAX:GM12878",
    "CHIP:EP300:GM12878",
    "CHIP:MXI1:GM12878",
    "CHIP:BHLHE40:GM12878",
    "CHIP:POLR2AphosphoS2:GM12878",
    "CHIP:ZNF143:GM12878",
    "CHIP:CTCF:GM12878",
    "CHIP:NRF1:GM12878",
    "CHIP:SMC3:GM12878",
    "CHIP:EBF1:GM12878",
    "CHIP:CHD2:GM12878",
    "CHIP:BRCA1:GM12878",
    "CHIP:USF2:GM12878",
    "CHIP:STAT3:GM12878",
    "CHIP:RFX5:GM12878",
    "CHIP:IRF3:GM12878",
    "CHIP:NFE2:GM12878",
    "CHIP:TBP:GM12878",
    "CHIP:WRNIP1:GM12878",
    "CHIP:SIN3A:H1-hESC",
    "CHIP:GTF2F1:H1-hESC",
    "CHIP:BACH1:H1-hESC",
    "CHIP:MAFK:H1-hESC",
    "CHIP:CHD2:H1-hESC",
    "CHIP:CHD1:H1-hESC",
    "CHIP:ZNF143:H1-hESC",
    "CHIP:BRCA1:H1-hESC",
    "CHIP:MYC:H1-hESC",
    "CHIP:JUND:H1-hESC",
    "CHIP:JUN:H1-hESC",
    "CHIP:TBP:H1-hESC",
    "CHIP:NRF1:H1-hESC",
    "CHIP:USF2:H1-hESC",
    "CHIP:RAD21:H1-hESC",
    "CHIP:RFX5:H1-hESC",
    "CHIP:MAFK:HeLa-S3",
    "CHIP:SUPT20H:HeLa-S3",
    "CHIP:GTF2F1:HeLa-S3",
    "CHIP:TBP:HeLa-S3",
    "CHIP:MAZ:HepG2",
    "CHIP:CEBPZ:HepG2",
    "CHIP:ARID3A:HepG2",
    "CHIP:RCOR1:HepG2",
    "CHIP:MAX:HepG2",
    "CHIP:BHLHE40:HepG2",
    "CHIP:EP300:HepG2",
    "CHIP:SMC3:HepG2",
    "CHIP:POLR2AphosphoS2:HepG2",
    "CHIP:BRCA1:HepG2",
    "CHIP:MAFK:HepG2",
    "CHIP:RFX5:HepG2",
    "CHIP:MAFK:HepG2",
    "CHIP:MAFF:HepG2",
    "CHIP:CHD2:HepG2",
    "CHIP:CEBPB:HepG2",
    "CHIP:RAD21:HepG2",
    "CHIP:NRF1:HepG2",
    "CHIP:JUND:HepG2",
    "CHIP:TBP:HepG2",
    "CHIP:CHD1:IMR-90",
    "CHIP:MAZ:IMR-90",
    "CHIP:RCOR1:IMR-90",
    "CHIP:MAFK:IMR-90",
    "CHIP:CTCF:IMR-90",
    "CHIP:RAD21:IMR-90",
    "CHIP:CEBPB:IMR-90",
    "CHIP:HCFC1:K562",
    "CHIP:CUX1:K562",
    "CHIP:ZNF384:K562",
    "CHIP:ZC3H11A:K562",
    "CHIP:JUN:K562",
    "CHIP:GATA1:K562",
    "CHIP:ELK1:K562",
    "CHIP:MAX:K562",
    "CHIP:UBTF:K562",
    "CHIP:ARID3A:K562",
    "CHIP:UBTF:K562",
    "CHIP:TBL1XR1:K562",
    "CHIP:TBL1XR1:K562",
    "CHIP:RCOR1:K562",
    "CHIP:BACH1:K562",
    "CHIP:EP300:K562",
    "CHIP:POLR2AphosphoS2:K562",
    "CHIP:JUN:K562 treated with interferon alpha for 30 minutes",
    "CHIP:MAFF:K562",
    "CHIP:MYC:K562",
    "CHIP:IRF1:K562 treated with interferon gamma for 30 minutes",
    "CHIP:IRF1:K562 treated with interferon alpha for 6 hours",
    "CHIP:CTCF:K562",
    "CHIP:JUND:K562",
    "CHIP:RFX5:K562",
    "CHIP:ZNF143:K562",
    "CHIP:MYC:K562 treated with interferon gamma for 30 minutes",
    "CHIP:IRF1:K562 treated with interferon gamma for 6 hours",
    "CHIP:IRF1:K562 treated with interferon alpha for 30 minutes",
    "CHIP:BHLHE40:K562",
    "CHIP:SMC3:K562",
    "CHIP:MAFK:K562",
    "CHIP:MXI1:K562",
    "CHIP:TBP:K562",
    "CHIP:TAL1:K562",
    "CHIP:GTF2F1:K562",
    "CHIP:CEBPB:K562",
    "CHIP:USF2:K562",
    "CHIP:STAT1:K562 treated with interferon gamma for 6 hours",
    "CHIP:POLR2A:K562",
    "CHIP:SMARCB1:K562",
    "CHIP:SMARCA4:K562",
    "CHIP:POLR2A:K562 treated with interferon gamma for 30 minutes",
    "CHIP:RFX5:SK-N-SH",
    "CHIP:MXI1:SK-N-SH",
    "CHIP:JUND:SK-N-SH",
    "CHIP:CTCF:SK-N-SH",
    "CHIP:ZNF274:GM08714",
    "CHIP:IKZF1:GM12878",
    "CHIP:NR2C2:GM12878",
    "CHIP:YY1:GM12878",
    "CHIP:CTBP2:H1-hESC",
    "CHIP:SUZ12:H1-hESC",
    "CHIP:H3K4me1:HCT116",
    "CHIP:H3K27ac:HCT116",
    "CHIP:TRIM28:HEK293",
    "CHIP:ZNF263:HEK293",
    "CHIP:FOS:endothelial cell of umbilical vein newborn",
    "CHIP:GATA2:endothelial cell of umbilical vein newborn",
    "CHIP:ZNF274:K562",
    "CHIP:TRIM28:K562",
    "CHIP:H3K9ac:K562",
    "CHIP:H3K4me3:K562",
    "CHIP:H3K27me3:K562",
    "CHIP:H3K4me1:K562",
    "CHIP:ZNF274:K562",
    "CHIP:YY1:K562",
    "CHIP:GATA2:K562",
    "CHIP:NR2C2:K562",
    "CHIP:SETDB1:K562",
    "CHIP:H3K27me3:MCF-7",
    "CHIP:H3K9me3:MCF-7",
    "CHIP:H3K27ac:MCF-7",
    "CHIP:ZNF274:NT2/D1",
    "CHIP:H3K9me3:NT2/D1",
    "CHIP:H3K4me1:NT2/D1",
    "CHIP:H3K36me3:NT2/D1",
    "CHIP:H3K9ac:NT2/D1",
    "CHIP:H3K4me3:NT2/D1",
    "CHIP:H3K27me3:NT2/D1",
    "CHIP:YY1:NT2/D1",
    "CHIP:H3K4me3:Panc1",
    "CHIP:H3K4me1:Panc1",
    "CHIP:H3K27ac:Panc1",
    "CHIP:TCF7L2:Panc1",
    "CHIP:GATA1:erythroblast male",
    "CHIP:GATA1:erythroblast embryo (16-19 weeks)",
    "CHIP:H3K4me3:mononuclear cell male",
    "CHIP:H3K9me3:mononuclear cell male",
    "CHIP:H3K4me1:mononuclear cell male",
    "CHIP:H3K27me3:mononuclear cell male",
    "CHIP:POLR2A:Raji",
    "CHIP:GATA3:SH-SY5Y",
    "CHIP:GATA2:SH-SY5Y",
    "CHIP:JUN:K562 treated with interferon gamma for 30 minutes",
    "CHIP:MYC:K562 treated with interferon gamma for 6 hours",
    "CHIP:MYC:K562 treated with interferon alpha for 6 hours",
    "CHIP:JUN:K562 treated with interferon gamma for 6 hours",
    "CHIP:JUN:K562 treated with interferon alpha for 6 hours",
    "CHIP:STAT2:K562 treated with interferon alpha for 30 minutes",
    "CHIP:STAT1:K562 treated with interferon alpha for 6 hours",
    "CHIP:STAT1:K562 treated with interferon alpha for 30 minutes",
    "CHIP:POLR2A:K562 treated with interferon gamma for 6 hours",
    "CHIP:POLR2A:K562 treated with interferon alpha for 6 hours",
    "CHIP:POLR2A:K562 treated with interferon alpha for 30 minutes",
    "CHIP:MYC:K562 treated with interferon alpha for 30 minutes",
    "CHIP:MITF:K562",
    "CHIP:NFE2:K562",
    "CHIP:SMAD5:K562",
    "CHIP:ETV6:K562",
    "CHIP:H3K4me1:HEK293",
    "CHIP:H3K9me3:HEK293",
    "CHIP:H3K4me3:GM08714",
    "CHIP:H3K36me3:Panc1",
    "CHIP:H3K27me3:Panc1",
    "CHIP:H3K4me1:SK-N-SH",
    "CHIP:H3K4me3:SK-N-SH",
    "CHIP:H3K9me3:SK-N-SH",
    "CHIP:H3K27ac:SK-N-SH",
    "CHIP:H3K9me3:neuron originated from H9",
    "CHIP:SMC3:IMR-90",
    "CHIP:H3K9me3:kidney male adult (67 years)",
    "CHIP:EP300:upper lobe of left lung female adult (51 year)",
    "CHIP:H3K27ac:cardiac muscle cell",
    "CHIP:H3K9me3:heart left ventricle female adult (53 years)",
    "CHIP:H3K27ac:stomach male adult (34 years)",
    "CHIP:H3K4me2:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:H3K27ac:IMR-90",
    "CHIP:CTCF:esophagus squamous epithelium female adult (51 year)",
    "CHIP:H3K9me3:stomach smooth muscle female adult (84 years)",
    "CHIP:H3K4me3:mesenchymal stem cell originated from adipose tissue",
    "CHIP:H3K27ac:muscle layer of colon female adult (56 years)",
    "CHIP:ZEB2:K562",
    "CHIP:eGFP-ZBTB10:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H4K8ac:IMR-90",
    "CHIP:CTCF:omental fat pad male adult (54 years)",
    "CHIP:H3K9me3:mucosa of stomach male adult (59 years)",
    "CHIP:eGFP-ID3:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:OCI-LY7",
    "CHIP:H3K9me3:Peyer's patch female adult (53 years)",
    "CHIP:H3K9me3:B cell female adult (43 years)",
    "CHIP:H3K36me3:trophoblast cell originated from H1-hESC",
    "CHIP:eGFP-KLF10:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:mesenchymal stem cell originated from adipose tissue",
    "CHIP:NEUROD1:MCF-7",
    "CHIP:H3K27ac:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:H3K27ac:GM23248",
    "CHIP:3xFLAG-KLF16:HepG2 genetically modified using CRISPR",
    "CHIP:HSF1:GM12878",
    "CHIP:H3K4me1:kidney male adult (67 years)",
    "CHIP:RCOR1:SK-N-SH",
    "CHIP:3xFLAG-ZNF614:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:NCI-H929",
    "CHIP:H3K36me3:muscle layer of colon female adult (56 years)",
    "CHIP:H3K36me3:angular gyrus female adult (75 years)",
    "CHIP:H3K27ac:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:ZNF407:K562",
    "CHIP:eGFP-ZNF175:K562 genetically modified using CRISPR",
    "CHIP:H3K27me3:common myeloid progenitor, CD34-positive male adult (36 years)",
    "CHIP:eGFP-ZNF585B:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:H3K27ac:CD14-positive monocyte male adult (21 year)",
    "CHIP:H3K27ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K4me1:foreskin keratinocyte male newborn",
    "CHIP:CTCF:adrenal gland female adult (51 year)",
    "CHIP:HNRNPK:K562",
    "CHIP:H3K27ac:temporal lobe male adult (81 year)",
    "CHIP:ATF7:GM12878",
    "CHIP:H3K27ac:thoracic aorta male adult (37 years)",
    "CHIP:BCLAF1:HepG2",
    "CHIP:TAF1:liver female child (4 years)",
    "CHIP:H3K4me3:mammary epithelial cell female adult (50 years)",
    "CHIP:TARDBP:GM12878",
    "CHIP:H3K27ac:middle frontal area 46 female adult (75 years)",
    "CHIP:CUX1:MCF-7",
    "CHIP:eGFP-TFDP1:K562 genetically modified using stable transfection",
    "CHIP:eGFP-ZNF600:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me2:SU-DHL-6",
    "CHIP:ZNF579:MCF-7",
    "CHIP:eGFP-ZNF148:K562 genetically modified using stable transfection",
    "CHIP:H3K9me3:brain female embryo (120 days)",
    "CHIP:PLRG1:HepG2",
    "CHIP:3xFLAG-SP5:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:H1-hESC",
    "CHIP:eGFP-ZNF10:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:foreskin fibroblast male newborn",
    "CHIP:eGFP-ZNF184:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:liver male adult (31 year)",
    "CHIP:eGFP-BCL11A:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:natural killer cell male adult (21 year)",
    "CHIP:H2AFZ:neural stem progenitor cell originated from H9",
    "CHIP:eGFP-ZNF623:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:cingulate gyrus male adult (81 year)",
    "CHIP:H3K4me1:heart right ventricle male child (3 years)",
    "CHIP:H3K4me1:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:EGR1:K562",
    "CHIP:H3K36me3:colonic mucosa female adult (56 years)",
    "CHIP:HDAC3:K562",
    "CHIP:H3K9me3:gastroesophageal sphincter female adult (53 years)",
    "CHIP:POLR2A:suprapubic skin female adult (51 year)",
    "CHIP:H3K4me1:foreskin keratinocyte male newborn",
    "CHIP:CTCF:upper lobe of left lung male adult (37 years)",
    "CHIP:CTCF:OCI-LY7",
    "CHIP:ZFX:C4-2B",
    "CHIP:eGFP-ZNF26:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:ZNF592:MCF-7",
    "CHIP:H3K27ac:heart right ventricle male child (3 years)",
    "CHIP:H3K27ac:placenta embryo (16 weeks)",
    "CHIP:ATF3:K562",
    "CHIP:CTCF:spleen male adult (54 years)",
    "CHIP:ARNT:HepG2",
    "CHIP:FOXP1:HepG2",
    "CHIP:DACH1:K562",
    "CHIP:3xFLAG-KDM6A:HepG2 genetically modified using CRISPR",
    "CHIP:POLR2A:adrenal gland female adult (53 years)",
    "CHIP:POLR2A:K562",
    "CHIP:XRCC5:HepG2",
    "CHIP:H3K4me3:cingulate gyrus male adult (81 year)",
    "CHIP:H3K4me1:subcutaneous abdominal adipose tissue nuclear fraction female adult (81 year)",
    "CHIP:POLR2AphosphoS5:stomach male adult (37 years)",
    "CHIP:POLR2A:upper lobe of left lung male adult (54 years)",
    "CHIP:ZNF830:K562",
    "CHIP:H3K4me3:Parathyroid adenoma male adult (62 years)",
    "CHIP:TARDBP:K562",
    "CHIP:H3K36me3:hepatocyte originated from H9",
    "CHIP:H3K9me3:iPS-18c female adult (48 years)",
    "CHIP:H3K27ac:Parathyroid adenoma male adult (65 years)",
    "CHIP:H3K36me3:esophagus male adult (34 years)",
    "CHIP:H3K27ac:breast epithelium female adult (53 years)",
    "CHIP:H4K5ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K4me1:trophoblast cell originated from H1-hESC",
    "CHIP:H3K9me3:pancreas male adult (34 years)",
    "CHIP:H3K9me3:stomach smooth muscle male adult (59 years)",
    "CHIP:H3K4me3:spinal cord female embryo (113 days)",
    "CHIP:H3K4me1:Loucy",
    "CHIP:H3K56ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K4me1:endodermal cell originated from HUES64",
    "CHIP:H3K27me3:ovary female adult (30 years)",
    "CHIP:SMAD1:K562",
    "CHIP:CTCF:suprapubic skin male adult (54 years)",
    "CHIP:GABPA:liver male adult (32 years)",
    "CHIP:H3K27me3:common myeloid progenitor, CD34-positive",
    "CHIP:H2AK9ac:IMR-90",
    "CHIP:H3K36me3:trophoblast cell originated from H1-hESC",
    "CHIP:MCM7:K562",
    "CHIP:eGFP-GABPA:MCF-7 genetically modified using stable transfection",
    "CHIP:ZNF444:MCF-7",
    "CHIP:POLR2A:stomach female adult (51 year)",
    "CHIP:H3K36me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3K4ac:IMR-90",
    "CHIP:H3K4me1:layer of hippocampus male adult (81 year)",
    "CHIP:RFX1:K562",
    "CHIP:H3K27ac:T-helper 17 cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:SRF:GM12878",
    "CHIP:eGFP-SALL1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:cerebellum male adult (53 years)",
    "CHIP:H3K36me3:middle frontal area 46 male adult (81 year)",
    "CHIP:H3K27me3:sigmoid colon male adult (34 years)",
    "CHIP:SNIP1:MCF-7",
    "CHIP:H3K27me3:CD4-positive, alpha-beta T cell",
    "CHIP:H3K9me3:CD8-positive, alpha-beta memory T cell",
    "CHIP:eGFP-SALL2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me2:neural cell",
    "CHIP:H3K4me3:common myeloid progenitor, CD34-positive",
    "CHIP:EZH2:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:EZH2:HCT116",
    "CHIP:EP300:testis male adult (37 years)",
    "CHIP:H3K27me3:placental basal plate female embryo (40 weeks)",
    "CHIP:ATF2:HepG2",
    "CHIP:EP300:omental fat pad male adult (54 years)",
    "CHIP:TAF15:K562",
    "CHIP:H3K56ac:H9",
    "CHIP:H3K36me3:muscle layer of colon female adult (77 years)",
    "CHIP:H3K4me1:foreskin melanocyte male newborn",
    "CHIP:H3K4me1:trophoblast female embryo (20 weeks)",
    "CHIP:FUS:K562",
    "CHIP:H3K4me1:middle frontal area 46 male adult (81 year)",
    "CHIP:NFATC3:K562",
    "CHIP:H3K79me2:B cell female adult (27 years)",
    "CHIP:PCBP1:K562",
    "CHIP:H3K4me3:DOHH2",
    "CHIP:H3K9me3:adrenal gland male adult (37 years)",
    "CHIP:H3K27ac:urinary bladder male adult (34 years)",
    "CHIP:3xFLAG-RAD21:HepG2 genetically modified using CRISPR",
    "CHIP:H2BK20ac:IMR-90",
    "CHIP:H3K4me1:muscle layer of duodenum male adult (73 years)",
    "CHIP:H3K36me3:mucosa of rectum female adult (61 year)",
    "CHIP:POLR2A:body of pancreas male adult (37 years)",
    "CHIP:H3K9me3:IMR-90",
    "CHIP:H3K9ac:MCF-7",
    "CHIP:H3K27me3:esophagus squamous epithelium female adult (53 years)",
    "CHIP:H3K14ac:H1-hESC",
    "CHIP:H3K4me3:GM12878",
    "CHIP:H2AFZ:MCF-7",
    "CHIP:H3K4me3:angular gyrus female adult (75 years)",
    "CHIP:H3K9me3:muscle layer of duodenum male adult (59 years)",
    "CHIP:H3K9me3:esophagus squamous epithelium female adult (53 years)",
    "CHIP:H3K9ac:substantia nigra female adult (75 years)",
    "CHIP:H3K27me3:neutrophil",
    "CHIP:H3K9ac:Karpas-422",
    "CHIP:H3K27ac:ACC112",
    "CHIP:H3K4me1:OCI-LY7",
    "CHIP:H3K36me3:common myeloid progenitor, CD34-positive male adult (42 years)",
    "CHIP:NANOG:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K9ac:endocrine pancreas male adult (46 years)",
    "CHIP:H3K27me3:duodenal mucosa male adult (59 years)",
    "CHIP:HSF1:MCF-7",
    "CHIP:H3K23me2:H9",
    "CHIP:H3K4me1:thyroid gland female adult (53 years)",
    "CHIP:RFX5:A549",
    "CHIP:H3K4me1:germinal matrix male embryo (20 weeks)",
    "CHIP:H3K4me1:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K4me1:urinary bladder male adult (34 years)",
    "CHIP:eGFP-KLF17:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CHAMP1:K562",
    "CHIP:H3K9me3:aorta male adult (34 years)",
    "CHIP:CTCF:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:FOXA2:HepG2",
    "CHIP:HNRNPH1:HepG2",
    "CHIP:CTCF:right atrium auricular region female adult (53 years)",
    "CHIP:H3K27ac:placental basal plate male embryo (38 weeks)",
    "CHIP:RFX1:MCF-7",
    "CHIP:H3K4me1:lung female embryo (82 days)",
    "CHIP:H3K36me3:iPS DF 19.11 male newborn",
    "CHIP:CHD2:A549",
    "CHIP:H3K27me3:heart right ventricle male adult (34 years)",
    "CHIP:MCM7:K562",
    "CHIP:POLR2A:upper lobe of left lung female adult (53 years)",
    "CHIP:EZH2:neural progenitor cell originated from H9",
    "CHIP:H3K27ac:transverse colon male adult (54 years)",
    "CHIP:H3K9me3:cingulate gyrus female adult (75 years)",
    "CHIP:H3K27ac:ascending aorta female adult (53 years)",
    "CHIP:H3K9me3:cingulate gyrus male adult (81 year)",
    "CHIP:eGFP-ZNF768:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:gastrocnemius medialis female adult (51 year)",
    "CHIP:3xFLAG-KMT2B:HepG2 genetically modified using CRISPR",
    "CHIP:CTCF:OCI-LY1",
    "CHIP:3xFLAG-HMG20A:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF76:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ZNF24:GM12878",
    "CHIP:H3K36me3:neutrophil male",
    "CHIP:SAFB:K562",
    "CHIP:H3K36me3:small intestine female adult (30 years)",
    "CHIP:H3K27ac:right cardiac atrium male adult (34 years)",
    "CHIP:H3K4me3:placenta male embryo (16 weeks)",
    "CHIP:CTCF:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:H3K79me2:SK-N-SH",
    "CHIP:eGFP-ZIK1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ZNF622:GM12878",
    "CHIP:HDAC2:K562",
    "CHIP:H3K4me3:foreskin keratinocyte male newborn",
    "CHIP:H3K4me3:muscle layer of duodenum male adult (73 years)",
    "CHIP:H3K4me1:heart right ventricle male adult (34 years)",
    "CHIP:eGFP-KLF9:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:OCI-LY1",
    "CHIP:eGFP-ZNF280C:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:layer of hippocampus male adult (73 years)",
    "CHIP:eGFP-ZBTB44:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:RNF2:K562",
    "CHIP:CREM:K562",
    "CHIP:H3K4me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:H3K36me3:spleen female adult (30 years)",
    "CHIP:H3K36me3:esophagus squamous epithelium female adult (53 years)",
    "CHIP:MCM5:K562",
    "CHIP:H3K4me3:foreskin fibroblast male newborn",
    "CHIP:eGFP-ZNF639:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:right lobe of liver female adult (53 years)",
    "CHIP:FOXA2:liver female child (4 years)",
    "CHIP:H3K27me3:CD14-positive monocyte male adult (21 year)",
    "CHIP:H3K18ac:trophoblast cell originated from H1-hESC",
    "CHIP:RAD51:HepG2",
    "CHIP:H3K4me3:NCI-H929",
    "CHIP:H3K27ac:adipose tissue male adult (34 years)",
    "CHIP:H3K9me3:transverse colon male adult (37 years)",
    "CHIP:H3K36me3:thoracic aorta male adult (37 years)",
    "CHIP:H3K36me3:mucosa of stomach male adult (59 years)",
    "CHIP:H3K36me3:spinal cord female embryo (113 days)",
    "CHIP:H3K36me3:stomach smooth muscle male adult (59 years)",
    "CHIP:CTCF:DOHH2",
    "CHIP:NFXL1:K562",
    "CHIP:H3K9ac:heart male embryo (105 days)",
    "CHIP:SP1:liver male adult (32 years)",
    "CHIP:H3K9me3:layer of hippocampus male adult (73 years)",
    "CHIP:NBN:K562",
    "CHIP:H3K79me2:Parathyroid adenoma male adult (65 years)",
    "CHIP:KAT8:K562",
    "CHIP:H3K9me3:heart right ventricle male child (3 years)",
    "CHIP:H3K27ac:spleen female adult (30 years)",
    "CHIP:H3K4me2:MM.1S",
    "CHIP:H3K9ac:skeletal muscle tissue female adult (72 years)",
    "CHIP:3xFLAG-KDM1A:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:IMR-90",
    "CHIP:H3K27me3:esophagus male adult (34 years)",
    "CHIP:EZH2phosphoT487:SU-DHL-6",
    "CHIP:EP300:gastroesophageal sphincter female adult (53 years)",
    "CHIP:CTCF:omental fat pad male adult (37 years)",
    "CHIP:H3K4me1:myoepithelial cell of mammary gland female adult (33 years)",
    "CHIP:H3K36me3:foreskin keratinocyte male newborn",
    "CHIP:HLTF:K562",
    "CHIP:H3K9me3:smooth muscle cell originated from H9",
    "CHIP:SUZ12:HEK293T",
    "CHIP:SUZ12:GM12878",
    "CHIP:POLR2A:gastroesophageal sphincter male adult (54 years)",
    "CHIP:eGFP-ATF1:K562 genetically modified using stable transfection originated from K562",
    "CHIP:HES1:K562",
    "CHIP:H3K36me3:HCT116",
    "CHIP:H3K4me1:T-helper 17 cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:3xFLAG-FOXA3:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-CREB3:K562 genetically modified using stable transfection",
    "CHIP:eGFP-ZNF16:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:HCT116",
    "CHIP:H3K4me1:brain female embryo (120 days)",
    "CHIP:H3K4me1:MM.1S",
    "CHIP:H3K27ac:adrenal gland male adult (37 years)",
    "CHIP:FOXA1:HEK293T",
    "CHIP:eGFP-CEBPG:MCF-7 genetically modified using stable transfection",
    "CHIP:H3K27ac:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:H3K4me3:kidney female embryo (120 days)",
    "CHIP:3xFLAG-ETV5:HepG2 genetically modified using CRISPR",
    "CHIP:EZH2phosphoT487:GM23248",
    "CHIP:ZNF207:MCF-7",
    "CHIP:eGFP-ZNF311:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2A:gastroesophageal sphincter female adult (53 years)",
    "CHIP:H3K9ac:ES-I3",
    "CHIP:H3K4me3:chorionic villus male embryo (16 weeks)",
    "CHIP:H3K4me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:RXRA:liver male adult (32 years)",
    "CHIP:H3K4me1:stomach female embryo (96 days)",
    "CHIP:eGFP-PRDM1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ZNF24:K562",
    "CHIP:H3K9ac:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:H3K36me3:mesodermal cell originated from HUES64",
    "CHIP:H3K4me3:kidney male adult (50 years)",
    "CHIP:H3K27me3:iPS DF 19.11 male newborn",
    "CHIP:H3K4me1:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:TAF9B:K562",
    "CHIP:H3K36me3:lung female embryo (96 days)",
    "CHIP:H3K36me3:transverse colon male adult (54 years)",
    "CHIP:TBL1XR1:HepG2",
    "CHIP:ZNF384:HepG2",
    "CHIP:H3K36me3:gastrocnemius medialis female adult (53 years)",
    "CHIP:CTCF:transverse colon male adult (37 years)",
    "CHIP:ZMYM3:K562",
    "CHIP:eGFP-ZNF175:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:CD8-positive, alpha-beta T cell male adult (37 years)",
    "CHIP:H3K4me3:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H3K27me3:ascending aorta female adult (51 year)",
    "CHIP:TFAP4:HepG2",
    "CHIP:POLR2A:gastrocnemius medialis female adult (53 years)",
    "CHIP:H3K9me3:radial glial cell genetically modified using stable transfection originated from H9",
    "CHIP:H3K27ac:peripheral blood mononuclear cell male adult (39 years)",
    "CHIP:H3K9ac:neural progenitor cell originated from H9",
    "CHIP:H3K9me3:spleen female adult (53 years)",
    "CHIP:H3K36me3:gastrocnemius medialis male adult (54 years)",
    "CHIP:eGFP-ZNF366:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:TAL1:K562",
    "CHIP:H3K4me2:Parathyroid adenoma male adult (62 years)",
    "CHIP:POLR2A:transverse colon female adult (53 years)",
    "CHIP:MLLT1:K562",
    "CHIP:H3K4me3:heart right ventricle male child (3 years)",
    "CHIP:YBX1:K562",
    "CHIP:H3K27ac:foreskin fibroblast male newborn",
    "CHIP:3xFLAG-GATAD1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:caudate nucleus male adult (81 year)",
    "CHIP:HES1:MCF-7",
    "CHIP:H3K27me3:heart left ventricle male child (3 years)",
    "CHIP:CREB3L1:K562",
    "CHIP:H3K27me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (25 years)",
    "CHIP:H3K27me3:lung female embryo (120 days)",
    "CHIP:H3K4me1:liver male adult (31 year)",
    "CHIP:H3K9ac:SK-N-MC",
    "CHIP:H3K9me3:endocrine pancreas adult (59 years)",
    "CHIP:H3K4me1:heart left ventricle male adult (34 years)",
    "CHIP:CREB1:HepG2",
    "CHIP:HNRNPLL:K562",
    "CHIP:H3K4me1:ovary female adult (30 years)",
    "CHIP:EZH2:SK-N-MC",
    "CHIP:MTA2:K562",
    "CHIP:H3K27me3:mid-neurogenesis radial glial cells genetically modified using stable transfection originated from H9",
    "CHIP:H3K27me3:luminal epithelial cell of mammary gland female adult (33 years)",
    "CHIP:H3K36me3:temporal lobe male adult (81 year)",
    "CHIP:H3K9ac:SU-DHL-6",
    "CHIP:ASH1L:K562",
    "CHIP:KDM1A:HepG2",
    "CHIP:H3K4me1:foreskin keratinocyte male newborn",
    "CHIP:H3K9me3:T-cell male adult (21 year)",
    "CHIP:3xFLAG-MIER2:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:PKNOX1:K562",
    "CHIP:H3K4me1:spleen female adult (30 years)",
    "CHIP:H3K4me1:adipocyte originated from mesenchymal stem cell",
    "CHIP:CSDE1:MCF-7",
    "CHIP:EP300:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:3xFLAG-HOMEZ:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:cingulate gyrus female adult (75 years)",
    "CHIP:H3K9me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:ZNF207:GM12878",
    "CHIP:eGFP-ZNF24:K562 genetically modified using stable transfection",
    "CHIP:NCOA4:K562",
    "CHIP:PHF21A:K562",
    "CHIP:H3K36me3:MM.1S",
    "CHIP:PRDM10:K562",
    "CHIP:H3K4me3:placenta embryo (16 weeks)",
    "CHIP:H3K9ac:SK-N-SH",
    "CHIP:CDC5L:K562",
    "CHIP:H3K4me1:esophagus squamous epithelium female adult (53 years)",
    "CHIP:POLR2A:stomach male adult (54 years)",
    "CHIP:H3K4me3:foreskin fibroblast male newborn",
    "CHIP:POLR2A:prostate gland male adult (54 years)",
    "CHIP:H3K4me3:ascending aorta female adult (53 years)",
    "CHIP:H3K27ac:layer of hippocampus female adult (75 years)",
    "CHIP:H2BK15ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:FOS:IMR-90",
    "CHIP:ETV6:K562",
    "CHIP:H2AFZ:IMR-90",
    "CHIP:H3K4me2:GM23248",
    "CHIP:H3K27ac:neural cell",
    "CHIP:3xFLAG-MLX:HepG2 genetically modified using CRISPR",
    "CHIP:CTCF:SU-DHL-6",
    "CHIP:eGFP-ZNF394:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3F3A:SK-N-SH",
    "CHIP:CTCF:neural progenitor cell originated from H9",
    "CHIP:eGFP-ZNF561:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-KLF9:MCF-7 genetically modified using stable transfection",
    "CHIP:H3K4me2:mesendoderm originated from H1-hESC",
    "CHIP:H3K36me3:layer of hippocampus male adult (81 year)",
    "CHIP:eGFP-PTRF:K562 genetically modified using stable transfection",
    "CHIP:FOXA1:MCF-7",
    "CHIP:H3K36me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:H3K36me3:tibial artery female adult (53 years)",
    "CHIP:SNRNP70:HepG2",
    "CHIP:H3K4me3:muscle of leg female embryo (110 days)",
    "CHIP:H3K27me3:aorta female adult (30 years)",
    "CHIP:H3K4me3:stomach male adult (34 years)",
    "CHIP:H3K4ac:H1-hESC",
    "CHIP:COPS2:K562",
    "CHIP:H3K4me1:smooth muscle cell originated from H9",
    "CHIP:eGFP-NR4A1:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:3xFLAG-PPARG:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:placenta female embryo (113 days)",
    "CHIP:EZH2:GM23248",
    "CHIP:POLR2A:transverse colon male adult (54 years)",
    "CHIP:H3K27ac:stomach female adult (53 years)",
    "CHIP:H3K9me3:prostate male adult (54 years)",
    "CHIP:H3K27me3:mammary epithelial cell female adult (18 years)",
    "CHIP:eGFP-ZFP3:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:NRF1:MCF-7",
    "CHIP:H3K36me3:radial glial cell genetically modified using stable transfection originated from H9",
    "CHIP:H3K4me3:common myeloid progenitor, CD34-positive female adult (33 years)",
    "CHIP:H3K27me3:fibroblast of breast female adult (26 years)",
    "CHIP:H3K4me1:ectodermal cell originated from embryonic stem cell",
    "CHIP:H3K36me3:adipocyte originated from mesenchymal stem cell",
    "CHIP:REST:K562",
    "CHIP:H3K27ac:CD4-positive, alpha-beta T cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:RNF2:K562",
    "CHIP:eGFP-ZNF132:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:MCM2:K562",
    "CHIP:GABPB1:K562",
    "CHIP:H3K27me3:neural progenitor cell originated from H9",
    "CHIP:H3K4me3:ovary female adult (30 years)",
    "CHIP:MAFF:HeLa-S3",
    "CHIP:eGFP-SP3:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:colonic mucosa female adult (73 years)",
    "CHIP:3xFLAG-CEBPA:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:heart right ventricle male adult (34 years)",
    "CHIP:POLR2A:uterus female adult (53 years)",
    "CHIP:EWSR1:K562",
    "CHIP:ZC3H8:K562",
    "CHIP:H3K4me3:brain male embryo (122 days)",
    "CHIP:H3K27me3:smooth muscle cell originated from H9",
    "CHIP:H3K27me3:amnion male embryo (16 weeks)",
    "CHIP:H3K36me3:mesendoderm originated from H1-hESC",
    "CHIP:NFRKB:HepG2",
    "CHIP:TARDBP:HepG2",
    "CHIP:ATF4:K562",
    "CHIP:HDGF:GM12878",
    "CHIP:CTCF:gastroesophageal sphincter female adult (51 year)",
    "CHIP:H3K4me3:mucosa of rectum female adult (61 year)",
    "CHIP:H3K4me1:skeletal muscle tissue",
    "CHIP:H3K9ac:subcutaneous abdominal adipose tissue nuclear fraction female adult (59 years)",
    "CHIP:H3K9me3:brain female embryo (17 weeks)",
    "CHIP:eGFP-REPIN1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:kidney male adult (50 years)",
    "CHIP:H3K27me3:foreskin melanocyte male newborn",
    "CHIP:POLR2A:esophagus squamous epithelium female adult (53 years)",
    "CHIP:EP300:subcutaneous adipose tissue female adult (53 years)",
    "CHIP:H3K4me1:gastrocnemius medialis male adult (37 years)",
    "CHIP:H3K4me3:duodenal mucosa male adult (76 years)",
    "CHIP:eGFP-ZNF584:K562 genetically modified using CRISPR",
    "CHIP:H3K9me3:esophagus male adult (34 years)",
    "CHIP:H3K4me1:substantia nigra female adult (75 years)",
    "CHIP:H3K36me3:muscle of leg female embryo (110 days)",
    "CHIP:H3K27ac:heart left ventricle male adult (34 years)",
    "CHIP:H3K36me3:sigmoid colon female adult (53 years)",
    "CHIP:AGO2:HepG2",
    "CHIP:H3K9ac:foreskin melanocyte male newborn",
    "CHIP:H3K4me1:SK-N-MC",
    "CHIP:H3K9ac:subcutaneous abdominal adipose tissue nuclear fraction female adult (41 year)",
    "CHIP:H4K20me1:PC-9",
    "CHIP:POLR2A:lower leg skin male adult (54 years)",
    "CHIP:H3K4me3:HUES48",
    "CHIP:TRIP13:K562",
    "CHIP:POLR2A:tibial nerve female adult (51 year)",
    "CHIP:H3K79me2:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:ARNT:K562",
    "CHIP:ZBTB11:MCF-7",
    "CHIP:PTBP1:HepG2",
    "CHIP:3xFLAG-DNMT3B:HepG2 genetically modified using CRISPR",
    "CHIP:POLR2A:esophagus squamous epithelium male adult (37 years)",
    "CHIP:H3K27ac:peripheral blood mononuclear cell female adult (28 years)",
    "CHIP:ZKSCAN1:HepG2",
    "CHIP:3xFLAG-ZNF205:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:middle frontal area 46 female adult (75 years)",
    "CHIP:H3K27me3:large intestine male embryo (108 days)",
    "CHIP:SMARCE1:K562",
    "CHIP:H3K36me3:tibial nerve female adult (53 years)",
    "CHIP:eGFP-ZBTB40:K562 genetically modified using CRISPR",
    "CHIP:EP300:ovary female adult (51 year)",
    "CHIP:H4K20me1:Karpas-422",
    "CHIP:3xFLAG-ERF:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF518A:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-ATF1:K562 genetically modified using CRISPR",
    "CHIP:H3K36me3:myoepithelial cell of mammary gland female adult (36 years)",
    "CHIP:GATAD2A:K562",
    "CHIP:KDM5A:H1-hESC",
    "CHIP:H3K27me3:spleen female adult (53 years)",
    "CHIP:H3K4me1:gastrocnemius medialis male adult (54 years)",
    "CHIP:H3K4me1:HCT116",
    "CHIP:H2BK5ac:H1-hESC",
    "CHIP:H3K4me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K27me3:B cell female adult (27 years)",
    "CHIP:MYBL2:K562",
    "CHIP:H3K36me3:peripheral blood mononuclear cell male adult (32 years)",
    "CHIP:H3K9ac:adipocyte originated from mesenchymal stem cell",
    "CHIP:H3K4me3:common myeloid progenitor, CD34-positive male adult",
    "CHIP:eGFP-ZNF189:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H4K91ac:IMR-90",
    "CHIP:H3K36me3:common myeloid progenitor, CD34-positive female adult (33 years)",
    "CHIP:H3K4me2:Loucy",
    "CHIP:H3K36me3:stomach female adult (53 years)",
    "CHIP:H3K9ac:iPS-20b male adult (55 years)",
    "CHIP:H3K9me3:tibial artery female adult (53 years)",
    "CHIP:H3K4me3:CD8-positive, alpha-beta T cell male adult (28 years)",
    "CHIP:eGFP-DIDO1:K562 genetically modified using stable transfection",
    "CHIP:ZNF316:K562",
    "CHIP:eGFP-ZNF544:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:NCOA6:K562",
    "CHIP:H3K4me3:stomach smooth muscle male adult (59 years)",
    "CHIP:NR2F2:liver female child (4 years)",
    "CHIP:H3K9me3:muscle layer of duodenum male adult (73 years)",
    "CHIP:H3K4me1:neural stem progenitor cell originated from H9",
    "CHIP:PHB2:HepG2",
    "CHIP:H3K27ac:spleen male child (3 years)",
    "CHIP:H3K4me1:common myeloid progenitor, CD34-positive",
    "CHIP:POLR2AphosphoS5:transverse colon female adult (51 year)",
    "CHIP:H3K4me3:muscle layer of colon female adult (56 years)",
    "CHIP:E2F7:K562",
    "CHIP:FOXK2:HepG2",
    "CHIP:H4K8ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K4me3:foreskin keratinocyte male newborn",
    "CHIP:CTCF:stomach female adult (51 year)",
    "CHIP:3xFLAG-ZNF580:HepG2 genetically modified using CRISPR",
    "CHIP:COPS2:MCF-7",
    "CHIP:H3K36me3:iPS DF 6.9 male newborn",
    "CHIP:ZNF592:GM12878",
    "CHIP:POLR2A:lower leg skin male adult (37 years)",
    "CHIP:EHMT2:K562",
    "CHIP:CTCF:coronary artery female adult (53 years)",
    "CHIP:H3K9ac:myoepithelial cell of mammary gland female adult (33 years)",
    "CHIP:H3K9me2:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:ZSCAN29:K562",
    "CHIP:H3K27ac:colonic mucosa female adult (56 years)",
    "CHIP:H3K4me3:HUES6",
    "CHIP:EP300:subcutaneous adipose tissue male adult (37 years)",
    "CHIP:JUN:MCF-7",
    "CHIP:H3K9me3:heart left ventricle male adult (34 years)",
    "CHIP:H3K36me3:duodenal mucosa male adult (59 years)",
    "CHIP:H3K27me3:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:FIP1L1:K562",
    "CHIP:H3K27ac:adrenal gland male adult (54 years)",
    "CHIP:H3K4me3:myoepithelial cell of mammary gland female adult (33 years)",
    "CHIP:MEF2B:GM12878",
    "CHIP:BRD9:K562",
    "CHIP:eGFP-NR2C1:K562 genetically modified using stable transfection",
    "CHIP:eGFP-CUX1:K562 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF274:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:HCT116",
    "CHIP:H3K9me3:common myeloid progenitor, CD34-positive male adult (36 years)",
    "CHIP:H3K4me1:small intestine male child (3 years)",
    "CHIP:EZH2:A673",
    "CHIP:H3F3A:PC-9",
    "CHIP:H3K27me3:substantia nigra female adult (75 years)",
    "CHIP:H3K27me3:adrenal gland male adult (34 years)",
    "CHIP:3xFLAG-ZNF3:HepG2 genetically modified using CRISPR",
    "CHIP:H3K18ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:HNRNPUL1:HepG2",
    "CHIP:H3K27me3:Loucy",
    "CHIP:H3K9me3:muscle of trunk female embryo (115 days)",
    "CHIP:ZFP36:HeLa-S3",
    "CHIP:H3K4me1:OCI-LY1",
    "CHIP:3xFLAG-ZBTB26:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF341:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF549:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me2:Loucy",
    "CHIP:CTCF:gastroesophageal sphincter male adult (37 years)",
    "CHIP:H3K27me3:H1-hESC",
    "CHIP:H3K27me3:pancreas male adult (34 years)",
    "CHIP:H3K79me2:H9",
    "CHIP:H3K9me3:OCI-LY1",
    "CHIP:SMAD2:K562",
    "CHIP:H3K27ac:adrenal gland female adult (53 years)",
    "CHIP:TCF12:K562",
    "CHIP:GTF2F1:K562",
    "CHIP:H4K20me1:smooth muscle cell originated from H9",
    "CHIP:eGFP-VEZF1:K562 genetically modified using CRISPR",
    "CHIP:ZBTB40:GM12878",
    "CHIP:H3K9ac:duodenal mucosa male adult (59 years)",
    "CHIP:3xFLAG-PHF5A:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:B cell male adult (37 years)",
    "CHIP:PAX8:GM12878",
    "CHIP:H3K4me3:common myeloid progenitor, CD34-positive male adult (42 years)",
    "CHIP:H3K36me3:muscle of trunk female embryo (115 days)",
    "CHIP:eGFP-ZNF221:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF766:K562 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF704:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:placental basal plate female embryo (40 weeks)",
    "CHIP:H3K4me1:endodermal cell originated from HUES64",
    "CHIP:H3K4me1:placenta embryo (16 weeks)",
    "CHIP:H3K27ac:middle frontal area 46 male adult (81 year)",
    "CHIP:3xFLAG-ZNF3:K562 genetically modified using CRISPR",
    "CHIP:JUND:liver female child (4 years)",
    "CHIP:CTCF:epithelial cell of prostate male",
    "CHIP:H3K4me1:common myeloid progenitor, CD34-positive male adult (36 years)",
    "CHIP:H3K4me1:mesenchymal stem cell originated from adipose tissue",
    "CHIP:H3K27me3:aorta male adult (34 years)",
    "CHIP:HDGF:K562",
    "CHIP:SREBF1:MCF-7",
    "CHIP:H3K4me3:spleen female adult (53 years)",
    "CHIP:H3K9ac:PC-3",
    "CHIP:NFE2L2:IMR-90",
    "CHIP:H3F3A:MCF-7",
    "CHIP:H3K27me3:H7-hESC",
    "CHIP:H3K36me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:RAD21:neural cell originated from H1-hESC",
    "CHIP:H3K9me2:OCI-LY7",
    "CHIP:H3K4me1:subcutaneous abdominal adipose tissue nuclear fraction female adult (25 years)",
    "CHIP:EED:GM12878",
    "CHIP:HDGF:MCF-7",
    "CHIP:H3K27ac:endodermal cell originated from HUES64",
    "CHIP:ZNF316:K562",
    "CHIP:H3K9me3:esophagus female adult (30 years)",
    "CHIP:H3K9me3:adipocyte originated from mesenchymal stem cell",
    "CHIP:3xFLAG-NFIL3:HepG2 genetically modified using CRISPR",
    "CHIP:CTBP1:K562",
    "CHIP:H3K27me3:gastrocnemius medialis female adult (53 years)",
    "CHIP:H3K4me3:stomach female embryo (98 days)",
    "CHIP:H3K4me1:ascending aorta female adult (51 year)",
    "CHIP:H3K36me3:chorionic villus male embryo (16 weeks)",
    "CHIP:H3K9me3:duodenal mucosa male adult (76 years)",
    "CHIP:H3K27me3:CD4-positive, CD25-positive, alpha-beta regulatory T cell",
    "CHIP:H3K27ac:thyroid gland male adult (54 years)",
    "CHIP:H3K27ac:RWPE1",
    "CHIP:CTCF:Panc1",
    "CHIP:H3K4me1:liver male adult (78 years)",
    "CHIP:H3K36me3:adrenal gland male adult (37 years)",
    "CHIP:H3K27me3:lung female adult (30 years)",
    "CHIP:ATF3:liver female child (4 years)",
    "CHIP:H3K36me3:small intestine male embryo (108 days)",
    "CHIP:YBX1:GM12878",
    "CHIP:CTCF:gastroesophageal sphincter female adult (53 years)",
    "CHIP:H3K4me3:peripheral blood mononuclear cell female adult (28 years)",
    "CHIP:H3K4me3:gastrocnemius medialis male adult (37 years)",
    "CHIP:H3K9me3:myoepithelial cell of mammary gland female adult (33 years)",
    "CHIP:ZBED1:GM12878",
    "CHIP:H3K4me1:adrenal gland male embryo (97 days)",
    "CHIP:H3K27ac:transverse colon female adult (53 years)",
    "CHIP:H3K4me3:upper lobe of left lung female adult (53 years)",
    "CHIP:H3K27ac:spinal cord female embryo (108 days)",
    "CHIP:H3K27me3:caudate nucleus female adult (75 years)",
    "CHIP:3xFLAG-IKZF5:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF391:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H2BK120ac:IMR-90",
    "CHIP:H3K27ac:smooth muscle cell originated from H9",
    "CHIP:NBN:HepG2",
    "CHIP:eGFP-ZSCAN4:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:EGR1:K562",
    "CHIP:eGFP-GLI4:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:luminal epithelial cell of mammary gland female adult (33 years)",
    "CHIP:SKIL:GM12878",
    "CHIP:H3K9me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (41 year)",
    "CHIP:H3K36me3:liver female adult (25 years)",
    "CHIP:TOE1:K562",
    "CHIP:H3K79me1:trophoblast cell originated from H1-hESC",
    "CHIP:H3K27ac:sigmoid colon male child (3 years)",
    "CHIP:H2BK5ac:trophoblast cell originated from H1-hESC",
    "CHIP:TRIM25:K562",
    "CHIP:H3K27me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (41 year)",
    "CHIP:H3K4me1:B cell male adult (21 year)",
    "CHIP:H3K9me3:iPS-20b male adult (55 years)",
    "CHIP:H3K4me3:chorion male embryo (16 weeks)",
    "CHIP:H3K27me3:H1-hESC",
    "CHIP:H3K27me3:stomach smooth muscle male adult (59 years)",
    "CHIP:eGFP-ATF2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2AphosphoS5:esophagus muscularis mucosa male adult (37 years)",
    "CHIP:eGFP-ZNF697:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-TSHZ1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:adrenal gland male embryo (97 days)",
    "CHIP:ZFX:HEK293T",
    "CHIP:H3K27me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K4me1:T-cell male adult (21 year)",
    "CHIP:EZH2:PC-3",
    "CHIP:H3K4me1:liver male adult (32 years)",
    "CHIP:DPF2:K562",
    "CHIP:DEK:HeLa-S3",
    "CHIP:H3K9ac:IMR-90",
    "CHIP:GTF2F1:HepG2",
    "CHIP:H3K4me2:hepatocyte originated from H9",
    "CHIP:PRPF4:K562",
    "CHIP:MBD2:K562",
    "CHIP:H3K27me3:trophoblast female embryo (20 weeks)",
    "CHIP:SRSF7:K562",
    "CHIP:H3K27ac:T-cell male adult (37 years)",
    "CHIP:CTCF:sigmoid colon male adult (54 years)",
    "CHIP:H3K4me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:BRCA1:K562",
    "CHIP:eGFP-PRDM10:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:HUES48",
    "CHIP:H3K9me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:eGFP-ZNF426:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF121:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:omental fat pad female adult (51 year)",
    "CHIP:H3K36me3:thyroid gland male adult (37 years)",
    "CHIP:3xFLAG-NFIA:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:foreskin melanocyte male newborn",
    "CHIP:H2AFZ:HCT116",
    "CHIP:eGFP-ZNF292:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:EP300:stomach male adult (37 years)",
    "CHIP:eGFP-ZBTB26:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:H3K9me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K27ac:kidney male adult (67 years)",
    "CHIP:H3K27ac:liver male adult (31 year)",
    "CHIP:H3K27me3:foreskin melanocyte male newborn",
    "CHIP:ZBTB2:K562",
    "CHIP:H3K4me1:heart left ventricle male child (3 years)",
    "CHIP:H3K4ac:H9",
    "CHIP:RAD21:liver female child (4 years)",
    "CHIP:ARID3A:MCF-7",
    "CHIP:H3K4me3:CD8-positive, alpha-beta T cell",
    "CHIP:ZBTB33:MCF-7",
    "CHIP:PKNOX1:HEK293T",
    "CHIP:H3K4me1:tibial artery female adult (53 years)",
    "CHIP:eGFP-ZNF670:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:spleen male adult (37 years)",
    "CHIP:DPF2:MCF-7",
    "CHIP:H3K4me3:adrenal gland male adult (34 years)",
    "CHIP:H3K4me1:iPS-18a female adult (48 years)",
    "CHIP:H3K9me3:ectodermal cell originated from embryonic stem cell",
    "CHIP:3xFLAG-NFKBIZ:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:spleen male adult (34 years)",
    "CHIP:H3K9me3:CD14-positive monocyte male adult (21 year)",
    "CHIP:H3K4me3:iPS-15b female adult (48 years)",
    "CHIP:CTCF:transverse colon female adult (53 years)",
    "CHIP:H3K36me3:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K36me3:HUES6",
    "CHIP:H3K4me3:small intestine male embryo (108 days)",
    "CHIP:CTBP1:HEK293T",
    "CHIP:ZBTB40:K562",
    "CHIP:H3K4me3:skeletal muscle tissue",
    "CHIP:TBX3:HepG2",
    "CHIP:H3K36me3:neural stem progenitor cell originated from H9",
    "CHIP:H3K9me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:eGFP-FOSL1:K562 genetically modified using stable transfection",
    "CHIP:H3K36me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (41 year)",
    "CHIP:CTCF:HCT116",
    "CHIP:LEF1:HEK293T",
    "CHIP:H3K36me3:lung female embryo (120 days)",
    "CHIP:H3K27me3:chorion female embryo (40 weeks)",
    "CHIP:AFF1:K562",
    "CHIP:H3K9me3:myoepithelial cell of mammary gland female adult (36 years)",
    "CHIP:eGFP-ZNF770:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:OCI-LY7",
    "CHIP:CTCF:PC-9",
    "CHIP:PRPF4:HepG2",
    "CHIP:H3K9ac:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:H3K4me1:chorion female embryo (40 weeks)",
    "CHIP:H3K36me3:CD14-positive monocyte male adult (21 year)",
    "CHIP:EP300:sigmoid colon female adult (51 year)",
    "CHIP:H3K4me3:psoas muscle male child (3 years)",
    "CHIP:H3K4me1:stomach male child (3 years)",
    "CHIP:H3K36me3:duodenal mucosa male adult (76 years)",
    "CHIP:H3K9me3:common myeloid progenitor, CD34-positive male adult (42 years)",
    "CHIP:H3K4me1:duodenal mucosa male adult (76 years)",
    "CHIP:ZFX:22Rv1",
    "CHIP:H3K9me3:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:CCAR2:HepG2",
    "CHIP:NFRKB:MCF-7",
    "CHIP:H2BK5ac:IMR-90",
    "CHIP:H3K36me3:ascending aorta female adult (53 years)",
    "CHIP:H3K4me1:amnion male embryo (16 weeks)",
    "CHIP:ZNF592:K562",
    "CHIP:H3K27ac:uterus female adult (53 years)",
    "CHIP:H2AFZ:Parathyroid adenoma male adult (65 years)",
    "CHIP:H3K9me3:spleen male child (3 years)",
    "CHIP:H3K4me1:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K27ac:psoas muscle female adult (30 years)",
    "CHIP:H2BK12ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:SMAD5:GM12878",
    "CHIP:CTCF:hepatocyte originated from H9",
    "CHIP:CTCF:lower leg skin male adult (54 years)",
    "CHIP:eGFP-ZSCAN21:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:middle frontal area 46 female adult (75 years)",
    "CHIP:3xFLAG-ATF1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:mucosa of rectum female adult (50 years)",
    "CHIP:H3K4me1:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K27me3:neutrophil male",
    "CHIP:CTCF:liver female child (6 years) and male adult (32 years)",
    "CHIP:H3K36me3:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H2AFZ:Parathyroid adenoma male adult (62 years)",
    "CHIP:H3K9me3:neural progenitor cell originated from H9",
    "CHIP:H3K4me1:stomach male adult (34 years)",
    "CHIP:eGFP-ZNF83:K562 genetically modified using stable transfection",
    "CHIP:H3K9me3:peripheral blood mononuclear cell male adult (39 years)",
    "CHIP:SFPQ:HepG2",
    "CHIP:H3K4me3:vagina female adult (53 years)",
    "CHIP:H4K91ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H2BK120ac:H9",
    "CHIP:3xFLAG-MBD1:HepG2 genetically modified using CRISPR",
    "CHIP:MNT:HepG2",
    "CHIP:CTCF:smooth muscle cell originated from H9",
    "CHIP:H3K9me3:spinal cord female embryo (108 days)",
    "CHIP:H3K27me3:HUES48",
    "CHIP:H3K27me3:mesenchymal stem cell originated from adipose tissue",
    "CHIP:H3K4me1:angular gyrus male adult (81 year)",
    "CHIP:eGFP-PBX2:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:iPS DF 6.9 male newborn",
    "CHIP:H3K36me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (25 years)",
    "CHIP:H3K4me3:CD4-positive, alpha-beta T cell",
    "CHIP:H3K4me3:muscle layer of duodenum male adult (59 years)",
    "CHIP:THRA:K562",
    "CHIP:POU5F1:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K4me1:caudate nucleus female adult (75 years)",
    "CHIP:CTCF:VCaP",
    "CHIP:H2AFZ:H9",
    "CHIP:CTCF:body of pancreas male adult (54 years)",
    "CHIP:eGFP-KLF4:MCF-7 genetically modified using stable transfection",
    "CHIP:H3K9me3:thyroid gland male adult (37 years)",
    "CHIP:H3K27me3:liver male adult (31 year)",
    "CHIP:POLR2A:spleen male adult (54 years)",
    "CHIP:FOXA1:HepG2",
    "CHIP:H3F3A:Loucy",
    "CHIP:H3K27ac:neutrophil",
    "CHIP:H3K27me3:foreskin keratinocyte male newborn",
    "CHIP:H3K36me3:common myeloid progenitor, CD34-positive male adult (36 years)",
    "CHIP:H3K27ac:ovary female adult (30 years)",
    "CHIP:SRSF3:K562",
    "CHIP:H3K27ac:sigmoid colon female adult (53 years)",
    "CHIP:H3K36me3:stomach male child (3 years)",
    "CHIP:3xFLAG-GABPA:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:cardiac muscle cell",
    "CHIP:EP300:suprapubic skin male adult (37 years)",
    "CHIP:H3K9me3:small intestine female adult (30 years)",
    "CHIP:H3K4me1:H1-hESC",
    "CHIP:H3K36me3:stomach smooth muscle female adult (84 years)",
    "CHIP:CBX5:K562",
    "CHIP:H3K27me3:endodermal cell originated from HUES64",
    "CHIP:H3K27me3:placenta male embryo (16 weeks)",
    "CHIP:H3K4me1:colonic mucosa female adult (73 years)",
    "CHIP:eGFP-ZNF776:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:neural progenitor cell originated from H9",
    "CHIP:CHD2:SK-N-SH",
    "CHIP:H2BK15ac:IMR-90",
    "CHIP:H3K27me3:liver male adult (78 years)",
    "CHIP:H3K4me3:peripheral blood mononuclear cell male adult (39 years)",
    "CHIP:H3K9ac:mucosa of rectum female adult (50 years)",
    "CHIP:H3K4me3:PC-3",
    "CHIP:H3K4me3:mucosa of rectum female adult (50 years)",
    "CHIP:H3K4me1:H9",
    "CHIP:H3K4me1:cardiac muscle cell",
    "CHIP:H3K4me1:iPS-15b female adult (48 years)",
    "CHIP:H3K9me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:ZBTB7B:MCF-7",
    "CHIP:eGFP-ETV1:K562 genetically modified using stable transfection",
    "CHIP:H4K8ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:ZC3H11A:A549",
    "CHIP:H3K36me3:psoas muscle male child (3 years)",
    "CHIP:HDAC6:HepG2",
    "CHIP:IKZF1:HepG2",
    "CHIP:NBN:GM12878",
    "CHIP:H3K4me1:radial glial cell genetically modified using stable transfection originated from H9",
    "CHIP:SIX4:MCF-7",
    "CHIP:H4K20me1:DOHH2",
    "CHIP:eGFP-ZNF677:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:C4-2B",
    "CHIP:H3K36me3:esophagus female adult (30 years)",
    "CHIP:H3K79me1:H9",
    "CHIP:H3K27me3:heart embryo (101 day)",
    "CHIP:H3K23ac:H9",
    "CHIP:eGFP-ZNF660:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF133:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K14ac:IMR-90",
    "CHIP:ZBTB8A:K562",
    "CHIP:POLR2G:K562",
    "CHIP:H3K27me3:rectal smooth muscle tissue female adult (50 years)",
    "CHIP:H3K27me3:foreskin fibroblast male newborn",
    "CHIP:ZBED1:K562",
    "CHIP:H3K36me3:layer of hippocampus female adult (75 years)",
    "CHIP:H3K9me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:H3K36me3:muscle layer of duodenum male adult (73 years)",
    "CHIP:H3K4me3:SK-N-MC",
    "CHIP:H3K4me3:myoepithelial cell of mammary gland female adult (36 years)",
    "CHIP:MAZ:MCF-7",
    "CHIP:LARP7:K562",
    "CHIP:eGFP-ZNF354C:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H4K20me1:hepatocyte originated from H9",
    "CHIP:POLR2A:spleen female adult (53 years)",
    "CHIP:H3K4me1:mid-neurogenesis radial glial cells genetically modified using stable transfection NONE and originated from H9",
    "CHIP:eGFP-GABPA:K562 genetically modified using stable transfection",
    "CHIP:EP300:upper lobe of left lung male adult (54 years)",
    "CHIP:eGFP-MAZ:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:B cell female adult (27 years)",
    "CHIP:EGR1:liver female child (4 years)",
    "CHIP:H3K4me3:effector memory CD4-positive, alpha-beta T cell",
    "CHIP:H3K4me1:endocrine pancreas male adult (46 years)",
    "CHIP:H3K36me3:regulatory T cell originated from blood cell",
    "CHIP:H3K4me3:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H4K20me1:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:MTA2:GM12878",
    "CHIP:H3K4me1:luminal epithelial cell of mammary gland female adult (33 years)",
    "CHIP:H3K9me3:colonic mucosa female adult (73 years)",
    "CHIP:ZFP36:A549",
    "CHIP:H3K4me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (81 year)",
    "CHIP:H3K18ac:H9",
    "CHIP:eGFP-ZNF777:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF213:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (59 years)",
    "CHIP:HNRNPUL1:K562",
    "CHIP:H2BK15ac:mesendoderm originated from H1-hESC",
    "CHIP:HNF4G:liver female child (4 years)",
    "CHIP:EZH2phosphoT487:SK-N-SH",
    "CHIP:H3K36me3:muscle layer of duodenum male adult (59 years)",
    "CHIP:NCOR1:K562",
    "CHIP:H3K9me3:thymus male child (3 years)",
    "CHIP:eGFP-MZF1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2A:breast epithelium female adult (53 years)",
    "CHIP:EP300:suprapubic skin female adult (51 year)",
    "CHIP:H3K4me1:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:H3K79me2:H1-hESC",
    "CHIP:H2AFZ:smooth muscle cell originated from H9",
    "CHIP:FOXK2:K562",
    "CHIP:CTCF:RWPE1",
    "CHIP:H3K27ac:thymus male child (3 years)",
    "CHIP:H3K4me1:caudate nucleus male adult (81 year)",
    "CHIP:eGFP-IKZF3:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2A:breast epithelium female adult (51 year)",
    "CHIP:CTCF:breast epithelium female adult (53 years)",
    "CHIP:H3K27ac:mucosa of rectum female adult (50 years)",
    "CHIP:H3K4me1:Karpas-422",
    "CHIP:H3K4me1:esophagus male adult (34 years)",
    "CHIP:eGFP-ZNF680:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:SU-DHL-6",
    "CHIP:H3K4me1:iPS DF 19.11 male newborn",
    "CHIP:CTCF:body of pancreas male adult (37 years)",
    "CHIP:H3K4me3:thymus female embryo (110 days)",
    "CHIP:ZBTB1:MCF-7",
    "CHIP:FOXA2:liver male adult (32 years)",
    "CHIP:H2AFZ:ACC112",
    "CHIP:H3K27me3:common myeloid progenitor, CD34-positive",
    "CHIP:H3K27me3:middle frontal area 46 male adult (81 year)",
    "CHIP:H3K9me3:fibroblast of breast female adult (26 years)",
    "CHIP:H3K27me3:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:H3K36me3:placental basal plate female embryo (40 weeks)",
    "CHIP:EP300:sigmoid colon female adult (53 years)",
    "CHIP:H3K36me3:substantia nigra male adult (81 year)",
    "CHIP:H3F3A:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K4me3:chorionic villus embryo (16 weeks)",
    "CHIP:FIP1L1:HepG2",
    "CHIP:eGFP-PTTG1:K562 genetically modified using stable transfection",
    "CHIP:H3K27ac:CD4-positive, alpha-beta memory T cell",
    "CHIP:H3K4me3:tibial nerve female adult (53 years)",
    "CHIP:H3K4me3:neuron originated from H9",
    "CHIP:H3K27ac:HUES6",
    "CHIP:HNRNPL:HepG2",
    "CHIP:H3K4me3:pancreas female adult (30 years)",
    "CHIP:CTCF:LNCAP",
    "CHIP:CHAMP1:K562",
    "CHIP:H3K36me3:SU-DHL-6",
    "CHIP:H3K9me3:HUES64",
    "CHIP:H3K9ac:kidney female embryo (120 days)",
    "CHIP:H2AFZ:Karpas-422",
    "CHIP:H3K9me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (59 years)",
    "CHIP:H3K27ac:thoracic aorta male adult (54 years)",
    "CHIP:ZBTB40:MCF-7",
    "CHIP:H3K9me3:angular gyrus male adult (81 year)",
    "CHIP:H3K4me3:chorionic villus male embryo (38 weeks)",
    "CHIP:EHMT2:A549",
    "CHIP:H3K27ac:layer of hippocampus male adult (73 years)",
    "CHIP:eGFP-ZBTB21:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:sigmoid colon male child (3 years)",
    "CHIP:H3K9me3:lung female embryo (85 days)",
    "CHIP:ZEB2:K562",
    "CHIP:H3K4me3:colonic mucosa female adult (56 years)",
    "CHIP:POLR2A:sigmoid colon female adult (53 years)",
    "CHIP:H3K4me2:H1-hESC",
    "CHIP:H3K27ac:aorta female adult (30 years)",
    "CHIP:H3K36me3:cingulate gyrus female adult (75 years)",
    "CHIP:H3K36me3:foreskin melanocyte male newborn",
    "CHIP:H3K27ac:endocrine pancreas male adult (45 years)",
    "CHIP:eGFP-OSR2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:FOXA1:liver female child (4 years)",
    "CHIP:H3K36me3:H9",
    "CHIP:H3K4me1:fibroblast of breast female adult (17 years)",
    "CHIP:NR3C1:K562",
    "CHIP:POLR2B:K562",
    "CHIP:H3K4me1:aorta male adult (34 years)",
    "CHIP:H3K23me2:H1-hESC",
    "CHIP:H2BK5ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K9ac:NCI-H929",
    "CHIP:3xFLAG-PAF1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:colonic mucosa female adult (73 years)",
    "CHIP:H3K9me2:GM23248",
    "CHIP:H3K9me3:muscle layer of colon female adult (77 years)",
    "CHIP:H3K9ac:colonic mucosa female adult (56 years)",
    "CHIP:eGFP-ZNF335:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:skeletal muscle tissue",
    "CHIP:H3K27ac:skeletal muscle tissue female adult (72 years)",
    "CHIP:DDX20:MCF-7",
    "CHIP:RBBP5:GM12878",
    "CHIP:H3K4me1:small intestine male embryo (108 days)",
    "CHIP:HDAC2:GM12878",
    "CHIP:NKRF:K562",
    "CHIP:H3K36me3:kidney male adult (50 years)",
    "CHIP:ZBTB11:K562",
    "CHIP:GABPA:GM12878",
    "CHIP:3xFLAG-CREB1:HepG2 genetically modified using CRISPR",
    "CHIP:H2AFZ:OCI-LY7",
    "CHIP:STAT1:GM12878",
    "CHIP:H2AK5ac:H9",
    "CHIP:H3K4me3:HCT116",
    "CHIP:H3K9me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:H3K4me1:adrenal gland female adult (30 years)",
    "CHIP:ZNF318:K562",
    "CHIP:SP1:HepG2",
    "CHIP:H3K9ac:HUES48",
    "CHIP:H3K9ac:Parathyroid adenoma male adult (65 years)",
    "CHIP:SKIL:K562",
    "CHIP:CTCF:Parathyroid adenoma male adult (65 years)",
    "CHIP:H3K27me3:mucosa of rectum female adult (61 year)",
    "CHIP:POLR2A:heart left ventricle female adult (53 years)",
    "CHIP:H3K4me1:peripheral blood mononuclear cell male adult (27 years)",
    "CHIP:ESRRA:MCF-7",
    "CHIP:HDAC2:HepG2",
    "CHIP:eGFP-SCRT2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:NR2F2:liver male adult (32 years)",
    "CHIP:eGFP-ZNF248:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K79me2:NCI-H929",
    "CHIP:RBM39:HepG2",
    "CHIP:H3K4me1:stomach smooth muscle female adult (84 years)",
    "CHIP:H3K9ac:stomach smooth muscle male adult (59 years)",
    "CHIP:H3K9me3:PC-3",
    "CHIP:3xFLAG-KAT7:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:angular gyrus male adult (81 year)",
    "CHIP:H3K27me3:small intestine male child (3 years)",
    "CHIP:H3K4me1:common myeloid progenitor, CD34-positive female adult (27 years)",
    "CHIP:H3K4me3:HeLa-S3",
    "CHIP:EZH2phosphoT487:hepatocyte originated from H9",
    "CHIP:BCLAF1:GM12878",
    "CHIP:LEF1:K562",
    "CHIP:CC2D1A:K562",
    "CHIP:H3K4me3:coronary artery female adult (53 years)",
    "CHIP:eGFP-ZNF596:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:right lobe of liver female adult (53 years)",
    "CHIP:H3K27me3:skeletal muscle tissue male adult (54 years)",
    "CHIP:H3K4me1:foreskin fibroblast male newborn",
    "CHIP:H3K9ac:rectal smooth muscle tissue female adult (50 years)",
    "CHIP:H3K36me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (59 years)",
    "CHIP:H3K4me3:placental basal plate male embryo (38 weeks)",
    "CHIP:ZBTB33:liver female child (4 years)",
    "CHIP:EP300:breast epithelium male adult (37 years)",
    "CHIP:H3K4me1:foreskin fibroblast male newborn",
    "CHIP:H3K4me3:skeletal muscle tissue male adult (54 years)",
    "CHIP:H3K27ac:fibroblast of breast female adult (26 years)",
    "CHIP:CEBPZ:GM12878",
    "CHIP:MTA1:MCF-7",
    "CHIP:eGFP-ZFP41:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:body of pancreas male adult (54 years)",
    "CHIP:H3K9ac:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:H3K9me3:middle frontal area 46 female adult (75 years)",
    "CHIP:NCOA2:K562",
    "CHIP:H3K4me3:foreskin melanocyte male newborn",
    "CHIP:GABPA:liver female child (4 years)",
    "CHIP:POLR2AphosphoS5:spleen female adult (51 year)",
    "CHIP:H3K27me3:DOHH2",
    "CHIP:C11orf30:K562",
    "CHIP:H4K8ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K9me3:liver male adult (31 year)",
    "CHIP:eGFP-ZNF629:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:ZNF318:K562",
    "CHIP:RXRA:liver female child (4 years)",
    "CHIP:H3K27me3:iPS-20b male adult (55 years)",
    "CHIP:CTCF:esophagus muscularis mucosa female adult (51 year)",
    "CHIP:TARDBP:K562",
    "CHIP:H3K9me3:foreskin melanocyte male newborn",
    "CHIP:H3K27me3:stomach female embryo (96 days)",
    "CHIP:H3K4ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me3:neural stem progenitor cell originated from H9",
    "CHIP:H3K27me3:common myeloid progenitor, CD34-positive female adult (33 years)",
    "CHIP:H3K27ac:cingulate gyrus male adult (81 year)",
    "CHIP:H2BK120ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me1:lung female adult (30 years)",
    "CHIP:RBM22:HepG2",
    "CHIP:H3K9me3:trophoblast female embryo (40 weeks)",
    "CHIP:H3K79me1:mesendoderm originated from H1-hESC",
    "CHIP:eGFP-ZSCAN5A:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:stomach female adult (53 years)",
    "CHIP:H3K27me3:temporal lobe male adult (81 year)",
    "CHIP:H3K4me3:heart male embryo (91 day)",
    "CHIP:H3K9me3:germinal matrix male embryo (20 weeks)",
    "CHIP:CTCF:PC-3",
    "CHIP:eGFP-USF2:K562 genetically modified using CRISPR",
    "CHIP:EP300:esophagus muscularis mucosa male adult (37 years)",
    "CHIP:KDM1A:K562",
    "CHIP:CHD1:MCF-7",
    "CHIP:H3K4me3:MM.1S",
    "CHIP:H3K23ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:HDAC1:HepG2",
    "CHIP:ZNF24:HepG2",
    "CHIP:H3K36me3:Peyer's patch female adult (53 years)",
    "CHIP:H3K9me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (25 years)",
    "CHIP:eGFP-ZNF488:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H2BK12ac:H1-hESC",
    "CHIP:H3K27me3:chorion male embryo (16 weeks)",
    "CHIP:POU5F1:K562",
    "CHIP:eGFP-ZNF211:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:myoepithelial cell of mammary gland female adult (36 years)",
    "CHIP:eGFP-ZFP37:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:kidney female embryo (120 days)",
    "CHIP:H2AFZ:SK-N-SH",
    "CHIP:H3K4me1:foreskin fibroblast male newborn",
    "CHIP:H4K8ac:H9",
    "CHIP:POLR2A:gastroesophageal sphincter female adult (51 year)",
    "CHIP:H3K4me3:adipocyte originated from mesenchymal stem cell",
    "CHIP:H3K27ac:psoas muscle male child (3 years)",
    "CHIP:H3K4me1:right atrium auricular region female adult (53 years)",
    "CHIP:H3K4me1:mucosa of stomach male adult (59 years)",
    "CHIP:H3K4me3:peripheral blood mononuclear cell male adult (32 years)",
    "CHIP:H3K27me3:effector memory CD4-positive, alpha-beta T cell",
    "CHIP:POLR2AphosphoS5:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:3xFLAG-FOXP1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27me3:Parathyroid adenoma male adult (62 years)",
    "CHIP:ZNF280A:K562",
    "CHIP:H3K36me3:endocrine pancreas male adult (46 years)",
    "CHIP:H4K91ac:trophoblast cell originated from H1-hESC",
    "CHIP:eGFP-ZNF37A:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CBX5:GM12878",
    "CHIP:3xFLAG-ZNF511:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:CD8-positive, alpha-beta memory T cell",
    "CHIP:H3K36me3:endocrine pancreas adult (59 years)",
    "CHIP:H3K36me3:neutrophil",
    "CHIP:H3K27me3:substantia nigra male adult (81 year)",
    "CHIP:H3K9me2:MCF-7",
    "CHIP:H3K9ac:colonic mucosa female adult (73 years)",
    "CHIP:H3K36me3:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:CTCF:Peyer's patch female adult (53 years)",
    "CHIP:EHMT2:HepG2",
    "CHIP:H3K9me3:testis male adult (37 years)",
    "CHIP:IRF2:K562",
    "CHIP:GTF2F1:K562",
    "CHIP:H3K36me3:foreskin keratinocyte male newborn",
    "CHIP:H3K4me3:heart left ventricle male child (3 years)",
    "CHIP:H3K9me3:temporal lobe male adult (81 year)",
    "CHIP:H3K27me3:foreskin keratinocyte male newborn",
    "CHIP:H3F3A:GM23248",
    "CHIP:H3K9me3:kidney male adult (50 years)",
    "CHIP:H3K27ac:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H3K36me3:gastrocnemius medialis male adult (37 years)",
    "CHIP:H3K27ac:angular gyrus male adult (81 year)",
    "CHIP:H3K27me3:muscle layer of colon female adult (77 years)",
    "CHIP:eGFP-ZFP69B:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:thymus female embryo (110 days)",
    "CHIP:eGFP-DDX20:K562 genetically modified using stable transfection",
    "CHIP:eGFP-INSM2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:YY1:liver male adult (32 years)",
    "CHIP:GTF2F1:HepG2",
    "CHIP:H3K4me1:foreskin melanocyte male newborn",
    "CHIP:ELK1:MCF-7",
    "CHIP:ZFP36:HepG2",
    "CHIP:H3K4me3:layer of hippocampus male adult (73 years)",
    "CHIP:H3K18ac:IMR-90",
    "CHIP:H3K9ac:mucosa of stomach male adult (59 years)",
    "CHIP:EZH2:hepatocyte originated from H9",
    "CHIP:ZNF24:K562",
    "CHIP:H3K4me1:muscle layer of colon female adult (77 years)",
    "CHIP:H3K4me1:brain female embryo (17 weeks)",
    "CHIP:H3K27me3:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H4K91ac:H9",
    "CHIP:SP1:liver female child (4 years)",
    "CHIP:3xFLAG-KDM3A:HepG2 genetically modified using CRISPR",
    "CHIP:RELB:GM12878",
    "CHIP:DEAF1:K562",
    "CHIP:HDAC1:K562",
    "CHIP:POLR2A:K562",
    "CHIP:GATAD2B:MCF-7",
    "CHIP:H3K9me3:peripheral blood mononuclear cell male adult (27 years)",
    "CHIP:H3K4me1:chorionic villus female embryo (40 weeks)",
    "CHIP:ZBTB5:K562",
    "CHIP:H3K9me3:angular gyrus female adult (75 years)",
    "CHIP:H3K9me3:OCI-LY7",
    "CHIP:H3K27me3:peripheral blood mononuclear cell female adult (28 years)",
    "CHIP:MNT:K562",
    "CHIP:H3K27ac:natural killer cell male adult (37 years)",
    "CHIP:KDM1A:GM12878",
    "CHIP:RCOR1:MCF-7",
    "CHIP:MTA3:MCF-7",
    "CHIP:H3K27ac:22Rv1",
    "CHIP:H3K9me3:neural stem progenitor cell originated from H1-hESC",
    "CHIP:CTCF:Peyer's patch female adult (51 year)",
    "CHIP:CTCF:uterus female adult (53 years)",
    "CHIP:H3K36me3:pancreas female adult (30 years)",
    "CHIP:H3K9me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3K4me3:neutrophil",
    "CHIP:H3K9me3:psoas muscle male child (3 years)",
    "CHIP:IKZF1:K562",
    "CHIP:H3K9me3:H1-hESC",
    "CHIP:H3K4me3:T-cell male adult (37 years)",
    "CHIP:3xFLAG-MBD1:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF331:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-ZNF792:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-KLF16:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:chorionic villus male embryo (16 weeks)",
    "CHIP:H3K9me2:neural cell",
    "CHIP:H2AFZ:GM23248",
    "CHIP:H3K36me3:caudate nucleus female adult (75 years)",
    "CHIP:H3K9me2:MM.1S",
    "CHIP:eGFP-POLR2H:K562 genetically modified using stable transfection",
    "CHIP:H3K4me1:CD14-positive monocyte male adult (21 year)",
    "CHIP:POLR2AphosphoS5:breast epithelium female adult (51 year)",
    "CHIP:H3K4me1:common myeloid progenitor, CD34-positive female adult (33 years)",
    "CHIP:POLR2A:vagina female adult (53 years)",
    "CHIP:H3K4me3:middle frontal area 46 male adult (81 year)",
    "CHIP:H3K27ac:pancreas female adult (30 years)",
    "CHIP:CTCF:MM.1S",
    "CHIP:ZNF574:MCF-7",
    "CHIP:H3K36me3:PC-9",
    "CHIP:CSDE1:K562",
    "CHIP:H3K4me3:fibroblast of breast female adult (17 years)",
    "CHIP:H3K9me3:breast epithelium female adult (53 years)",
    "CHIP:POLR2AphosphoS5:sigmoid colon female adult (53 years)",
    "CHIP:SMC3:neural cell originated from H1-hESC",
    "CHIP:H3K27me3:MM.1S",
    "CHIP:H3K27me3:B cell male adult (21 year)",
    "CHIP:POLR2AphosphoS5:prostate gland male adult (37 years)",
    "CHIP:H3K27me3:mesendoderm originated from H1-hESC",
    "CHIP:H3K27ac:adrenal gland male adult (34 years)",
    "CHIP:H3K27ac:duodenal mucosa male adult (59 years)",
    "CHIP:H3K9me3:neural cell",
    "CHIP:H3K9me3:temporal lobe female adult (75 years)",
    "CHIP:H3K4me1:adrenal gland male adult (54 years)",
    "CHIP:H3K9me3:thymus female embryo (110 days)",
    "CHIP:ZHX2:HepG2",
    "CHIP:IRF3:GM12878",
    "CHIP:H3K27me3:spleen male adult (34 years)",
    "CHIP:CTCF:body of pancreas female adult (51 year)",
    "CHIP:H3K9me3:adrenal gland male adult (54 years)",
    "CHIP:H3K4me1:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:eGFP-PYGO2:K562 genetically modified using stable transfection",
    "CHIP:H3K4me1:mesodermal cell originated from HUES64",
    "CHIP:H3K27me3:HUES6",
    "CHIP:H3K4me1:psoas muscle male adult (34 years)",
    "CHIP:MTA2:K562",
    "CHIP:SUZ12:K562",
    "CHIP:TARDBP:GM12878",
    "CHIP:POLR2A:adrenal gland female adult (51 year)",
    "CHIP:ZSCAN29:GM12878",
    "CHIP:3xFLAG-AHR:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:large intestine male embryo (108 days)",
    "CHIP:H3K4me3:lung embryo (101 day)",
    "CHIP:POLR2A:gastrocnemius medialis female adult (51 year)",
    "CHIP:POLR2A:gastroesophageal sphincter male adult (37 years)",
    "CHIP:RUNX1:K562",
    "CHIP:3xFLAG-ZNF48:HepG2 genetically modified using CRISPR",
    "CHIP:POLR2A:right lobe of liver female adult (53 years)",
    "CHIP:NONO:K562",
    "CHIP:H3K4me3:breast epithelium female adult (53 years)",
    "CHIP:H3K4me1:thoracic aorta male adult (54 years)",
    "CHIP:eGFP-CEBPB:K562 genetically modified using stable transfection",
    "CHIP:NFXL1:MCF-7",
    "CHIP:H3K27me3:foreskin fibroblast male newborn",
    "CHIP:H3K9me3:small intestine male child (3 years)",
    "CHIP:eGFP-ZEB2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:layer of hippocampus female adult (75 years)",
    "CHIP:ZEB1:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:eGFP-ZNF692:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF524:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:KDM1A:H1-hESC",
    "CHIP:CTCF:Peyer's patch male adult (37 years)",
    "CHIP:H3K4me3:placenta female embryo (113 days)",
    "CHIP:NCOR1:HepG2",
    "CHIP:ZNF507:MCF-7",
    "CHIP:H3K4me1:peripheral blood mononuclear cell male adult (39 years)",
    "CHIP:H3K4me3:amnion male embryo (16 weeks)",
    "CHIP:H3K9me3:spleen male adult (34 years)",
    "CHIP:H3K4me3:sigmoid colon male adult (34 years)",
    "CHIP:eGFP-ZNF571:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:OCI-LY1",
    "CHIP:H3K4me1:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:IRF3:SK-N-SH",
    "CHIP:H3K4me3:foreskin melanocyte male newborn",
    "CHIP:RBM14:K562",
    "CHIP:H3K27me3:gastrocnemius medialis male adult (54 years)",
    "CHIP:GATA3:MCF-7",
    "CHIP:H3K9me2:SK-N-SH",
    "CHIP:H3K36me3:B cell female adult (27 years) and female adult (43 years)",
    "CHIP:H2AK5ac:IMR-90",
    "CHIP:H3K4me3:adrenal gland female adult (30 years)",
    "CHIP:H3K27ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K36me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:MIER1:K562",
    "CHIP:AFF1:K562",
    "CHIP:H3K36me3:HUES64",
    "CHIP:MLLT1:MCF-7",
    "CHIP:H2AK5ac:trophoblast cell originated from H1-hESC",
    "CHIP:CTCF:gastrocnemius medialis female adult (53 years)",
    "CHIP:EZH2phosphoT487:HCT116",
    "CHIP:H3K9me3:skeletal muscle tissue",
    "CHIP:EP300:transverse colon male adult (37 years)",
    "CHIP:H3K36me3:lung male child (3 years)",
    "CHIP:FOXM1:K562",
    "CHIP:H3K79me2:Loucy",
    "CHIP:H3K4me1:body of pancreas female adult (53 years)",
    "CHIP:TARDBP:K562",
    "CHIP:H3K27ac:iPS-18a female adult (48 years)",
    "CHIP:3xFLAG-THRB:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:amnion male embryo (16 weeks)",
    "CHIP:CTCF:lower leg skin female adult (53 years)",
    "CHIP:H3K4me1:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:CTCF:KMS-11",
    "CHIP:POLR2A:sigmoid colon male adult (37 years)",
    "CHIP:CHD4:HepG2",
    "CHIP:H3K9me3:layer of hippocampus female adult (75 years)",
    "CHIP:SMARCE1:MCF-7",
    "CHIP:H3K27me3:IMR-90",
    "CHIP:PYGO2:K562",
    "CHIP:POLR2A:thyroid gland female adult (51 year)",
    "CHIP:H3K4me3:spleen male adult (34 years)",
    "CHIP:EP300:breast epithelium female adult (53 years)",
    "CHIP:H3K18ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K4me3:radial glial cell genetically modified using stable transfection originated from H9",
    "CHIP:H3K4me3:neutrophil male",
    "CHIP:H3K36me3:heart left ventricle male adult (34 years)",
    "CHIP:POLR2A:stomach female adult (53 years)",
    "CHIP:H3K4me1:Parathyroid adenoma male adult (62 years)",
    "CHIP:CTCF:tibial nerve male adult (37 years)",
    "CHIP:H3K4me3:A673",
    "CHIP:ZFX:MCF-7",
    "CHIP:H3K36me3:CD4-positive, CD25-positive, alpha-beta regulatory T cell",
    "CHIP:NFATC3:GM12878",
    "CHIP:H3K9me3:neutrophil male",
    "CHIP:H3K36me3:IMR-90",
    "CHIP:H3K27ac:stomach male child (3 years)",
    "CHIP:H3K4me3:mucosa of stomach male adult (59 years)",
    "CHIP:H3K4me3:common myeloid progenitor, CD34-positive male adult (36 years)",
    "CHIP:H3K4me1:H7-hESC",
    "CHIP:H3K9me3:KOPT-K1",
    "CHIP:H3K4me1:heart left ventricle female adult (53 years)",
    "CHIP:H3K27ac:kidney male adult (50 years)",
    "CHIP:H3K27me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3K9me3:mesenchymal stem cell originated from adipose tissue",
    "CHIP:ZNF407:K562",
    "CHIP:E4F1:GM12878",
    "CHIP:H3K14ac:H9",
    "CHIP:eGFP-ZNF239:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ADNP:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:PC-9",
    "CHIP:3xFLAG-MXD4:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:regulatory T cell originated from blood cell",
    "CHIP:H3K4me3:mesendoderm originated from H1-hESC",
    "CHIP:eGFP-RBAK:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:H1-hESC",
    "CHIP:IKZF1:GM12878",
    "CHIP:H3K9me3:ascending aorta female adult (51 year)",
    "CHIP:H3K27me3:peripheral blood mononuclear cell male adult (28 years)",
    "CHIP:POLR2AphosphoS5:prostate gland male adult (54 years)",
    "CHIP:H3K79me1:H1-hESC",
    "CHIP:H3K9me3:heart left ventricle male child (3 years)",
    "CHIP:RAD51:MCF-7",
    "CHIP:H3K4me3:hepatocyte originated from H9",
    "CHIP:POLR2AphosphoS5:esophagus muscularis mucosa female adult (51 year)",
    "CHIP:eGFP-PRDM4:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:cingulate gyrus male adult (81 year)",
    "CHIP:H3K4me3:peripheral blood mononuclear cell male adult (27 years)",
    "CHIP:H3K27ac:coronary artery female adult (53 years)",
    "CHIP:TCF7:HepG2",
    "CHIP:H4K8ac:IMR-90",
    "CHIP:H3K27me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:SOX13:HepG2",
    "CHIP:eGFP-GFI1B:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:HNF4A:liver female child (4 years)",
    "CHIP:H3K36me3:sigmoid colon male adult (34 years)",
    "CHIP:DDX20:K562",
    "CHIP:H3K4me3:endodermal cell originated from HUES64",
    "CHIP:H3K9me3:stomach female embryo (96 days)",
    "CHIP:H3K27ac:mucosa of rectum female adult (61 year)",
    "CHIP:H3K27ac:OCI-LY7",
    "CHIP:eGFP-ZNF558:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:spleen male child (3 years)",
    "CHIP:H3K9ac:middle frontal area 46 female adult (75 years)",
    "CHIP:H3K14ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:eGFP-ZKSCAN8:K562 genetically modified using CRISPR",
    "CHIP:H3K27ac:neural progenitor cell originated from H9",
    "CHIP:H3K36me3:OCI-LY1",
    "CHIP:H3K4me1:muscle of leg female embryo (110 days)",
    "CHIP:H3K36me3:chorion female embryo (40 weeks)",
    "CHIP:H3K4me1:pancreas male adult (34 years)",
    "CHIP:H3K36me3:peripheral blood mononuclear cell male adult (28 years)",
    "CHIP:H3K36me3:urinary bladder male adult (34 years)",
    "CHIP:ZKSCAN1:MCF-7",
    "CHIP:CTCF:adrenal gland male adult (54 years)",
    "CHIP:CTCF:esophagus squamous epithelium male adult (54 years)",
    "CHIP:eGFP-ZNF280D:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:placenta embryo (16 weeks)",
    "CHIP:H3K9me3:T-helper 17 cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:SIN3B:HepG2",
    "CHIP:H3K9me3:CD4-positive, alpha-beta T cell",
    "CHIP:H3K4me1:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:H3K27me3:skeletal muscle tissue female adult (72 years)",
    "CHIP:H3K27ac:small intestine male child (3 years)",
    "CHIP:H3K9me3:lung female embryo (120 days)",
    "CHIP:3xFLAG-RCOR2:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:adrenal gland male adult (37 years)",
    "CHIP:H3K9me3:lung male child (3 years)",
    "CHIP:H3K27me3:common myeloid progenitor, CD34-positive male adult (42 years)",
    "CHIP:H3K27ac:heart left ventricle male adult (32 years)",
    "CHIP:H3K4me3:liver male adult (31 year)",
    "CHIP:UBTF:GM12878",
    "CHIP:H3K4me1:kidney female embryo (120 days)",
    "CHIP:CTCF:C4-2B",
    "CHIP:eGFP-ZBTB20:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:liver male adult (31 year)",
    "CHIP:H3K4me1:DOHH2",
    "CHIP:MNT:MCF-7",
    "CHIP:H3F3A:PC-3",
    "CHIP:H3K9me3:MM.1S",
    "CHIP:eGFP-ZNF501:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF101:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-GABPB1:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF395:K562 genetically modified using CRISPR",
    "CHIP:H2BK20ac:H1-hESC",
    "CHIP:H3K9me2:DOHH2",
    "CHIP:POLR2AphosphoS5:suprapubic skin male adult (37 years)",
    "CHIP:CTCF:Loucy",
    "CHIP:eGFP-ZNF140:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:SRSF1:HepG2",
    "CHIP:FOXK2:MCF-7",
    "CHIP:ZNF217:MCF-7",
    "CHIP:H3K36me3:spleen male adult (34 years)",
    "CHIP:H3K4me3:lung female adult (30 years)",
    "CHIP:eGFP-ZNF266:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:CD4-positive, alpha-beta T cell male adult (37 years)",
    "CHIP:H3K36me3:iPS-18a female adult (48 years)",
    "CHIP:eGFP-SP7:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:SIN3A:MCF-7",
    "CHIP:CTCF:tibial nerve female adult (53 years)",
    "CHIP:CBX2:A549",
    "CHIP:BMI1:GM12878",
    "CHIP:H3K9ac:HUES64",
    "CHIP:H3K27me3:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:POLR2A:sigmoid colon male adult (54 years)",
    "CHIP:H3K23ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K27ac:mesendoderm originated from H1-hESC",
    "CHIP:ESRRA:A549",
    "CHIP:H3K9me2:Karpas-422",
    "CHIP:H3K4me1:chorionic villus male embryo (38 weeks)",
    "CHIP:TRIM28:K562",
    "CHIP:H4K20me1:HCT116",
    "CHIP:H3K27me3:KMS-11",
    "CHIP:H3K4me1:rectal smooth muscle tissue female adult (50 years)",
    "CHIP:H3K27me3:ACC112",
    "CHIP:eGFP-ELF1:MCF-7 genetically modified using stable transfection",
    "CHIP:NONO:HepG2",
    "CHIP:H3K4ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K36me3:H1-hESC",
    "CHIP:H3K4me3:temporal lobe female adult (75 years)",
    "CHIP:eGFP-ZNF423:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:esophagus female adult (30 years)",
    "CHIP:H3K9me3:placenta male embryo (16 weeks)",
    "CHIP:H3K27me3:brain female embryo (120 days)",
    "CHIP:H3K4me1:temporal lobe female adult (75 years)",
    "CHIP:H3K9me3:tibial nerve female adult (53 years)",
    "CHIP:H3K4me3:GM23248",
    "CHIP:U2AF2:K562",
    "CHIP:H3K4me1:thymus female embryo (110 days)",
    "CHIP:ATF3:liver male adult (32 years)",
    "CHIP:H3K4me1:heart male embryo (105 days)",
    "CHIP:H3K4me1:placenta male embryo (16 weeks)",
    "CHIP:eGFP-ZBTB8A:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:Parathyroid adenoma male adult (62 years)",
    "CHIP:H3K4me1:placental basal plate female embryo (40 weeks)",
    "CHIP:H3K4me3:foreskin melanocyte male newborn",
    "CHIP:SMC3:A549",
    "CHIP:eGFP-GLIS1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:trophoblast female embryo (40 weeks)",
    "CHIP:CTCF:spleen female adult (51 year)",
    "CHIP:H3K4me1:peripheral blood mononuclear cell male adult (32 years)",
    "CHIP:RAD51:GM12878",
    "CHIP:eGFP-ZNF662:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:body of pancreas female adult (53 years)",
    "CHIP:H3K9me2:hepatocyte originated from H9",
    "CHIP:H3K79me2:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:POLR2A:thyroid gland female adult (53 years)",
    "CHIP:H3K9ac:duodenal mucosa male adult (76 years)",
    "CHIP:H2AFZ:trophoblast cell originated from H1-hESC",
    "CHIP:3xFLAG-ZBTB25:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K27me3:UCSF-4",
    "CHIP:H3K4me1:Parathyroid adenoma male adult (65 years)",
    "CHIP:H3K4me2:neural stem progenitor cell originated from H1-hESC",
    "CHIP:ESRRA:K562",
    "CHIP:H3K27me3:pancreas female adult (30 years)",
    "CHIP:H3K79me2:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me3:caudate nucleus female adult (75 years)",
    "CHIP:H3K36me3:neuron originated from H9",
    "CHIP:SMARCA5:MCF-7",
    "CHIP:H3K4me3:heart left ventricle male adult (34 years)",
    "CHIP:3xFLAG-ZFP64:HepG2 genetically modified using CRISPR",
    "CHIP:PHF8:HepG2",
    "CHIP:NFE2L2:HepG2",
    "CHIP:H3K4me1:right lobe of liver female adult (53 years)",
    "CHIP:H3K9me3:liver male adult (78 years)",
    "CHIP:H3K9me3:peripheral blood mononuclear cell male adult (28 years)",
    "CHIP:H3K4me3:stomach female adult (53 years)",
    "CHIP:eGFP-CEBPG:K562 genetically modified using stable transfection",
    "CHIP:H3K4me1:spleen male adult (34 years)",
    "CHIP:H2BK15ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:ARID2:K562",
    "CHIP:POLR2AphosphoS5:suprapubic skin female adult (51 year)",
    "CHIP:H3K23ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H2AFZ:PC-9",
    "CHIP:H3K9ac:Parathyroid adenoma male adult (62 years)",
    "CHIP:BCLAF1:K562",
    "CHIP:H3K27ac:endocrine pancreas adult (59 years)",
    "CHIP:CTCF:thyroid gland male adult (54 years)",
    "CHIP:CTCF:ovary female adult (53 years)",
    "CHIP:H3K79me2:smooth muscle cell originated from H9",
    "CHIP:H3K4me1:MCF-7",
    "CHIP:H3K4me3:SU-DHL-6",
    "CHIP:H3K27ac:caudate nucleus male adult (81 year)",
    "CHIP:H3K27me3:caudate nucleus male adult (81 year)",
    "CHIP:H3K27me3:germinal matrix male embryo (20 weeks)",
    "CHIP:ZC3H8:K562",
    "CHIP:NRF1:K562",
    "CHIP:CTCF:testis male adult (37 years)",
    "CHIP:NR3C1:K562",
    "CHIP:H3K9me3:amnion male embryo (16 weeks)",
    "CHIP:H3K27me3:trophoblast female embryo (40 weeks)",
    "CHIP:H3K36me3:H1-hESC",
    "CHIP:eGFP-ZNF747:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-TEAD1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:mucosa of rectum female adult (50 years)",
    "CHIP:ZNF639:K562",
    "CHIP:H3K9me3:foreskin keratinocyte male newborn",
    "CHIP:H3K27ac:placenta female embryo (113 days)",
    "CHIP:H3K14ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K36me3:prostate male adult (54 years)",
    "CHIP:H3K27ac:chorion female embryo (40 weeks)",
    "CHIP:H2AFZ:KMS-11",
    "CHIP:H3K36me3:iPS-20b male adult (55 years)",
    "CHIP:H3K4me3:lung male child (3 years)",
    "CHIP:3xFLAG-RARA:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:heart left ventricle female adult (53 years)",
    "CHIP:TCF7:GM12878",
    "CHIP:H3K4me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (41 year)",
    "CHIP:H3K4me3:mesenchymal stem cell originated from H1-hESC",
    "CHIP:EP300:breast epithelium male adult (54 years)",
    "CHIP:eGFP-ZSCAN26:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-ZNF652:HepG2 genetically modified using CRISPR",
    "CHIP:H2BK120ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:eGFP-ZNF843:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ELF1:MCF-7",
    "CHIP:ELF1:K562",
    "CHIP:eGFP-ZNF513:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ZFX:HCT116",
    "CHIP:H3K9me3:skeletal muscle tissue female adult (72 years)",
    "CHIP:ZNF24:MCF-7",
    "CHIP:H3K27me3:heart left ventricle male adult (34 years)",
    "CHIP:H3K4me1:sigmoid colon male child (3 years)",
    "CHIP:eGFP-ZNF654:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:iPS-18a female adult (48 years)",
    "CHIP:eGFP-E2F4:MCF-7 genetically modified using stable transfection",
    "CHIP:H3K27ac:iPS DF 19.11 male newborn",
    "CHIP:H3K36me3:foreskin melanocyte male newborn",
    "CHIP:TRIM22:HepG2",
    "CHIP:XRCC5:K562",
    "CHIP:H3K4me1:trophoblast female embryo (40 weeks)",
    "CHIP:H3K27ac:trophoblast female embryo (20 weeks)",
    "CHIP:H3K27ac:hepatocyte originated from H9",
    "CHIP:FOXK2:K562",
    "CHIP:ASH2L:HepG2",
    "CHIP:H3K4me3:esophagus squamous epithelium female adult (53 years)",
    "CHIP:PPP1R10:MCF-7",
    "CHIP:DPF2:GM12878",
    "CHIP:H4K91ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K4me3:gastroesophageal sphincter female adult (53 years)",
    "CHIP:EZH2:neural cell",
    "CHIP:H3K4me1:adrenal gland male adult (34 years)",
    "CHIP:H3K27me3:SU-DHL-6",
    "CHIP:H3K9me3:foreskin fibroblast male newborn",
    "CHIP:H3K4me1:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H3K27me3:placenta embryo (16 weeks)",
    "CHIP:MNT:K562",
    "CHIP:H3K4me2:PC-9",
    "CHIP:eGFP-ZNF302:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:duodenal mucosa male adult (59 years)",
    "CHIP:USF2:IMR-90",
    "CHIP:SIN3A:A549",
    "CHIP:H3K4me1:muscle of trunk female embryo (115 days)",
    "CHIP:BRD4:HepG2",
    "CHIP:HCFC1:GM12878",
    "CHIP:NR2F1:GM12878",
    "CHIP:CTCF:suprapubic skin female adult (53 years)",
    "CHIP:H3K4me3:smooth muscle cell originated from H9",
    "CHIP:ZBTB33:liver male adult (32 years)",
    "CHIP:H3K9me3:H9 genetically modified using stable transfection",
    "CHIP:eGFP-ZNF174:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:myoepithelial cell of mammary gland female adult (36 years)",
    "CHIP:eGFP-ZNF48:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2A:body of pancreas male adult (54 years)",
    "CHIP:H3K27me3:CD8-positive, alpha-beta memory T cell",
    "CHIP:H3K79me2:neural progenitor cell originated from H9",
    "CHIP:NR2F6:HepG2",
    "CHIP:H3K27ac:aorta male adult (34 years)",
    "CHIP:HNRNPK:HepG2",
    "CHIP:H3K36me3:natural killer cell male adult (21 year)",
    "CHIP:SMARCC2:K562",
    "CHIP:H3K27me3:gastrocnemius medialis male adult (37 years)",
    "CHIP:H3K27ac:body of pancreas male adult (37 years)",
    "CHIP:H3K4me3:liver male adult (78 years)",
    "CHIP:EZH2:OCI-LY1",
    "CHIP:H3K9ac:KMS-11",
    "CHIP:H3K4me1:mammary epithelial cell female adult (18 years)",
    "CHIP:H3K9me2:PC-9",
    "CHIP:MAX:liver male adult (32 years)",
    "CHIP:H3K4me1:A673",
    "CHIP:HDGF:HEK293T",
    "CHIP:H3K4me1:CD4-positive, CD25-positive, alpha-beta regulatory T cell",
    "CHIP:H2BK12ac:IMR-90",
    "CHIP:H3K36me3:body of pancreas male adult (54 years)",
    "CHIP:RNF2:HepG2",
    "CHIP:RAD51:K562",
    "CHIP:H3K9me3:neutrophil",
    "CHIP:H3K9me3:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:ZBTB40:HepG2",
    "CHIP:H2AFZ:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K27ac:placental basal plate female embryo (40 weeks)",
    "CHIP:H3K27me3:stomach male adult (34 years)",
    "CHIP:3xFLAG-HLF:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:germinal matrix male embryo (20 weeks)",
    "CHIP:EP300:breast epithelium female adult (51 year)",
    "CHIP:H3K9me3:luminal epithelial cell of mammary gland female adult (33 years)",
    "CHIP:HCFC1:HepG2",
    "CHIP:H3K36me3:large intestine male embryo (108 days)",
    "CHIP:L3MBTL2:K562",
    "CHIP:H3K9ac:neural cell",
    "CHIP:3xFLAG-MIER3:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF740:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:stomach smooth muscle female adult (84 years)",
    "CHIP:eGFP-GTF2E2:K562 genetically modified using stable transfection",
    "CHIP:H3K9me3:kidney female embryo (120 days)",
    "CHIP:H3K9me3:pancreas female adult (30 years)",
    "CHIP:eGFP-ZNF195:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ETS1:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:eGFP-GLIS2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:angular gyrus male adult (81 year)",
    "CHIP:H3F3A:NCI-H929",
    "CHIP:H3K4me1:small intestine female adult (30 years)",
    "CHIP:H4K20me1:SU-DHL-6",
    "CHIP:eGFP-ZNF560:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:KMS-11",
    "CHIP:H3K27ac:lung female adult (30 years)",
    "CHIP:H3K9ac:smooth muscle cell originated from H9",
    "CHIP:CTCF:SK-N-SH",
    "CHIP:PHF8:A549",
    "CHIP:MAFK:A549",
    "CHIP:ZBTB33:GM12878",
    "CHIP:MCM7:K562",
    "CHIP:SOX6:HepG2",
    "CHIP:H3K27ac:small intestine male adult (34 years)",
    "CHIP:H3K27me3:tibial artery female adult (53 years)",
    "CHIP:POLR2A:lower leg skin female adult (51 year)",
    "CHIP:H3K9ac:Loucy",
    "CHIP:eGFP-ZBTB12:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:breast epithelium female adult (53 years)",
    "CHIP:CTCF:heart left ventricle female adult (53 years)",
    "CHIP:ATF7:HepG2",
    "CHIP:H3K9me3:stomach female adult (53 years)",
    "CHIP:ZNF184:K562",
    "CHIP:eGFP-FOSL2:MCF-7 genetically modified using stable transfection",
    "CHIP:H3K27ac:CD4-positive, alpha-beta T cell",
    "CHIP:GATAD2B:K562",
    "CHIP:eGFP-ZNF701:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:ovary female adult (51 year)",
    "CHIP:H3K4me3:right cardiac atrium male adult (34 years)",
    "CHIP:H3K4me3:OCI-LY3",
    "CHIP:CBX3:GM12878",
    "CHIP:CTCF:stomach male adult (54 years)",
    "CHIP:H3K9me3:UCSF-4",
    "CHIP:eGFP-KLF1:K562 genetically modified using stable transfection",
    "CHIP:CHD4:A549",
    "CHIP:H3K27ac:lung male child (3 years)",
    "CHIP:H3K27me3:neural stem progenitor cell originated from H9",
    "CHIP:eGFP-ZNF493:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF138:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:EP300:gastroesophageal sphincter male adult (37 years)",
    "CHIP:H3K4me3:substantia nigra female adult (75 years)",
    "CHIP:MTA2:MCF-7",
    "CHIP:H3K36me3:stomach male adult (34 years)",
    "CHIP:MCM2:K562",
    "CHIP:H3K9me3:caudate nucleus female adult (75 years)",
    "CHIP:MLLT1:GM12878",
    "CHIP:eGFP-NFE2:K562 genetically modified using stable transfection",
    "CHIP:H3K4me1:breast epithelium female adult (53 years)",
    "CHIP:H3K79me1:IMR-90",
    "CHIP:3xFLAG-ZNF7:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27me3:peripheral blood mononuclear cell male adult (39 years)",
    "CHIP:H3K4me3:body of pancreas male adult (54 years)",
    "CHIP:H4K5ac:H9",
    "CHIP:ZNF512B:MCF-7",
    "CHIP:H3K9me2:HCT116",
    "CHIP:MAFK:MCF-7",
    "CHIP:H3K36me3:mesenchymal stem cell originated from adipose tissue",
    "CHIP:H3K9me3:PC-9",
    "CHIP:AGO1:HepG2",
    "CHIP:H3K27ac:heart left ventricle male child (3 years)",
    "CHIP:GTF2F1:MCF-7",
    "CHIP:H3K36me3:myoepithelial cell of mammary gland female adult (33 years)",
    "CHIP:ZHX1:K562",
    "CHIP:H3K27me3:B cell male adult (37 years)",
    "CHIP:H3K9me3:thyroid gland female adult (51 year)",
    "CHIP:CTCF:transverse colon female adult (51 year)",
    "CHIP:H3K36me3:kidney male adult (67 years)",
    "CHIP:H3K9me3:iPS-15b female adult (48 years)",
    "CHIP:H3K36me3:foreskin keratinocyte male newborn",
    "CHIP:H3K4me1:substantia nigra male adult (81 year)",
    "CHIP:H2AFZ:NCI-H929",
    "CHIP:eGFP-ZXDB:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:esophagus muscularis mucosa male adult (37 years)",
    "CHIP:H3K36me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (81 year)",
    "CHIP:CTCF:MCF-7",
    "CHIP:H3K9ac:skeletal muscle tissue",
    "CHIP:H3K9me3:HUES48",
    "CHIP:3xFLAG-RXRB:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:CD4-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:H3K36me3:testis male adult (37 years)",
    "CHIP:H3K27ac:sigmoid colon male adult (34 years)",
    "CHIP:H3K36me3:NCI-H929",
    "CHIP:H3K9ac:GM23248",
    "CHIP:EZH2phosphoT487:DOHH2",
    "CHIP:3xFLAG-THAP11:HepG2 genetically modified using CRISPR",
    "CHIP:H3F3A:MM.1S",
    "CHIP:USF2:A549",
    "CHIP:E2F1:K562",
    "CHIP:HDGF:K562",
    "CHIP:H3K9me3:liver male adult (32 years)",
    "CHIP:H3K4me1:trophoblast cell originated from H1-hESC",
    "CHIP:H3K27ac:SK-N-SH",
    "CHIP:H3K27me3:colonic mucosa female adult (73 years)",
    "CHIP:H3K4me3:DND-41",
    "CHIP:eGFP-ZNF157:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:EZH2phosphoT487:OCI-LY7",
    "CHIP:H3K18ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K4me1:PC-3",
    "CHIP:H3K27me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (81 year)",
    "CHIP:H3K9me3:placental basal plate female embryo (40 weeks)",
    "CHIP:H3K9ac:lung female embryo (82 days)",
    "CHIP:YBX3:K562",
    "CHIP:eGFP-ZNF473:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (81 year)",
    "CHIP:H3K9me3:substantia nigra male adult (81 year)",
    "CHIP:H3K9me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:HDAC1:K562",
    "CHIP:H3K27me3:temporal lobe female adult (75 years)",
    "CHIP:3xFLAG-NFYC:HepG2 genetically modified using CRISPR",
    "CHIP:EP300:tibial nerve female adult (51 year)",
    "CHIP:FOS:MCF-7",
    "CHIP:H3K4me3:natural killer cell male adult (37 years)",
    "CHIP:H3K79me1:neural stem progenitor cell originated from H1-hESC",
    "CHIP:ARHGAP35:K562",
    "CHIP:H3K9me3:foreskin melanocyte male newborn",
    "CHIP:H2AFZ:H1-hESC",
    "CHIP:3xFLAG-SSRP1:HepG2 genetically modified using CRISPR",
    "CHIP:CTCF:body of pancreas male adult (37 years)",
    "CHIP:H3K36me3:neural progenitor cell originated from H9",
    "CHIP:NCOA3:MCF-7",
    "CHIP:EP300:stomach female adult (53 years)",
    "CHIP:H3K36me3:placenta male embryo (16 weeks)",
    "CHIP:NUFIP1:K562",
    "CHIP:H3K4me3:germinal matrix male embryo (20 weeks)",
    "CHIP:H3K4me3:HepG2",
    "CHIP:H3K4me1:lung male child (3 years)",
    "CHIP:H3K79me2:mesendoderm originated from H1-hESC",
    "CHIP:POLR2A:Peyer's patch male adult (54 years)",
    "CHIP:H3K9me3:muscle layer of colon female adult (56 years)",
    "CHIP:H3K9me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3K4me3:colonic mucosa female adult (73 years)",
    "CHIP:H3K27ac:CD4-positive, CD25-positive, alpha-beta regulatory T cell",
    "CHIP:H3K4me3:esophagus male adult (34 years)",
    "CHIP:3xFLAG-ZNF644:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:H3K4me3:endothelial cell of umbilical vein male newborn",
    "CHIP:H3K4me3:CD4-positive, CD25-positive, alpha-beta regulatory T cell",
    "CHIP:H3K4me1:chorionic villus embryo (16 weeks)",
    "CHIP:H3K79me1:IMR-90",
    "CHIP:H3K27ac:fibroblast of breast female adult (17 years)",
    "CHIP:eGFP-ZNF197:K562 genetically modified using CRISPR",
    "CHIP:H3K9me1:IMR-90",
    "CHIP:H3K36me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:EP300:tibial nerve male adult (37 years)",
    "CHIP:HNRNPH1:K562",
    "CHIP:H3K4me1:OCI-LY3",
    "CHIP:H3K36me3:A673",
    "CHIP:H3K27me3:endocrine pancreas male adult (46 years)",
    "CHIP:H3K27me3:iPS-15b female adult (48 years)",
    "CHIP:CTCF:lower leg skin male adult (37 years)",
    "CHIP:H3K27me3:thyroid gland male adult (54 years)",
    "CHIP:H3K27ac:stomach female adult (30 years)",
    "CHIP:NFIB:MCF-7",
    "CHIP:BRD4:K562",
    "CHIP:H3K9ac:HUES6",
    "CHIP:EZH2phosphoT487:OCI-LY3",
    "CHIP:NFE2L2:A549",
    "CHIP:H3K9ac:mucosa of rectum female adult (61 year)",
    "CHIP:H3K36me3:liver male adult (78 years)",
    "CHIP:eGFP-ZNF433:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-ZFP1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:neutrophil male",
    "CHIP:H3K9me3:SU-DHL-6",
    "CHIP:SMARCA4:K562",
    "CHIP:RUNX1:K562",
    "CHIP:H3K27me3:endocrine pancreas adult (59 years)",
    "CHIP:H3K27me3:ascending aorta female adult (53 years)",
    "CHIP:3xFLAG-TFE3:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:spleen female adult (53 years)",
    "CHIP:GATA4:HepG2",
    "CHIP:ARNT:GM12878",
    "CHIP:FUS:HepG2",
    "CHIP:eGFP-ZNF512:K562 genetically modified using stable transfection",
    "CHIP:EZH2phosphoT487:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:NBN:MCF-7",
    "CHIP:H3K9me3:skeletal muscle tissue male adult (54 years)",
    "CHIP:H3K9me3:large intestine male embryo (108 days)",
    "CHIP:H3F3A:neural progenitor cell originated from H9",
    "CHIP:H3K9ac:angular gyrus female adult (75 years)",
    "CHIP:H3K9ac:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:H3K23ac:trophoblast cell originated from H1-hESC",
    "CHIP:eGFP-ZFP64:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:right atrium auricular region female adult (53 years)",
    "CHIP:H3K79me1:mesenchymal stem cell originated from H1-hESC",
    "CHIP:HNRNPL:K562",
    "CHIP:PHF20:K562",
    "CHIP:eGFP-ZNF510:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:fibroblast of breast female adult (17 years)",
    "CHIP:H3K4me3:UCSF-4",
    "CHIP:H3K9me3:right cardiac atrium male adult (34 years)",
    "CHIP:3xFLAG-RBPJ:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ETS2:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:skeletal muscle myoblast male adult (22 years)",
    "CHIP:H3K27ac:body of pancreas male adult (54 years)",
    "CHIP:H3K27ac:thyroid gland male adult (37 years)",
    "CHIP:H3K36me3:mammary epithelial cell female adult (18 years)",
    "CHIP:H3K27ac:OCI-LY1",
    "CHIP:H3K27ac:VCaP",
    "CHIP:ETV6:GM12878",
    "CHIP:H3K4me1:subcutaneous abdominal adipose tissue nuclear fraction female adult (41 year)",
    "CHIP:CCAR2:K562",
    "CHIP:eGFP-ZNF507:K562 genetically modified using stable transfection",
    "CHIP:H2AK5ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K9me3:placenta female embryo (113 days)",
    "CHIP:HNF4A:liver male adult (32 years)",
    "CHIP:PCBP2:K562",
    "CHIP:eGFP-ZNF589:K562 genetically modified using CRISPR",
    "CHIP:eGFP-ZNF416:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K79me2:Karpas-422",
    "CHIP:H3K27ac:cingulate gyrus female adult (75 years)",
    "CHIP:H3K9me3:OCI-LY3",
    "CHIP:H3K18ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:3xFLAG-IRF2:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-KLF7:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-SCRT1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:H3K9me3:peripheral blood mononuclear cell female adult (28 years)",
    "CHIP:H3K4me3:adrenal gland female adult (53 years)",
    "CHIP:H3K36me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:TBX3:HepG2",
    "CHIP:CTCF:vagina female adult (53 years)",
    "CHIP:H3K27ac:chorionic villus male embryo (16 weeks)",
    "CHIP:H3K4me3:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:H3K27me3:spleen male child (3 years)",
    "CHIP:eGFP-KLF13:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:neural cell",
    "CHIP:CTCF:transverse colon male adult (37 years)",
    "CHIP:H3K27ac:temporal lobe female adult (75 years)",
    "CHIP:RNF2:K562",
    "CHIP:POLR2A:body of pancreas female adult (51 year)",
    "CHIP:H3K36me3:effector memory CD4-positive, alpha-beta T cell",
    "CHIP:H3K79me2:GM23248",
    "CHIP:H3K4me3:testis male adult (37 years)",
    "CHIP:CTCF:A673",
    "CHIP:SREBF2:HeLa-S3",
    "CHIP:H3K27me3:tibial nerve female adult (53 years)",
    "CHIP:H3K27ac:pancreas male adult (34 years)",
    "CHIP:H3K9me3:trophoblast female embryo (20 weeks)",
    "CHIP:ARNT:K562",
    "CHIP:H3K9me3:right lobe of liver female adult (53 years)",
    "CHIP:H3K27ac:peripheral blood mononuclear cell male adult (32 years)",
    "CHIP:H3K27me3:angular gyrus male adult (81 year)",
    "CHIP:H3K4me1:UCSF-4",
    "CHIP:CBX8:A549",
    "CHIP:3xFLAG-KLF11:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:heart right ventricle male child (3 years)",
    "CHIP:3xFLAG-HBP1:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-CTCF:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:EZH2phosphoT487:PC-3",
    "CHIP:H3K4me1:lung female embryo (120 days)",
    "CHIP:CEBPZ:K562",
    "CHIP:RCOR1:A549",
    "CHIP:CTCF:stomach male adult (37 years)",
    "CHIP:H3K79me2:Parathyroid adenoma male adult (62 years)",
    "CHIP:eGFP-HINFP:K562 genetically modified using stable transfection",
    "CHIP:CTCF:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:eGFP-ZBTB6:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:chorionic villus male embryo (38 weeks)",
    "CHIP:eGFP-ZNF300:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:iPS-15b female adult (48 years)",
    "CHIP:H3K27ac:common myeloid progenitor, CD34-positive female adult (33 years)",
    "CHIP:CREB1:MCF-7",
    "CHIP:H3K4me3:adrenal gland male adult (37 years)",
    "CHIP:eGFP-CEBPG:K562 genetically modified using stable transfection",
    "CHIP:KAT2B:HepG2",
    "CHIP:ZNF184:K562",
    "CHIP:H3K4me1:Peyer's patch female adult (53 years)",
    "CHIP:H3K36me3:foreskin fibroblast male newborn",
    "CHIP:H3K36me3:heart embryo (101 day)",
    "CHIP:H3K79me2:DOHH2",
    "CHIP:ELK1:A549",
    "CHIP:SRSF9:HepG2",
    "CHIP:H3K9me3:foreskin fibroblast male newborn",
    "CHIP:SYNCRIP:HepG2",
    "CHIP:CSDE1:K562",
    "CHIP:H3K9ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:ETV6:GM12878",
    "CHIP:H3K27me3:brain male embryo (122 days)",
    "CHIP:H3K9me3:DOHH2",
    "CHIP:MCM5:K562",
    "CHIP:H3K4me1:muscle layer of duodenum male adult (59 years)",
    "CHIP:H3K36me3:placental basal plate male embryo (38 weeks)",
    "CHIP:H3K36me3:middle frontal area 46 female adult (75 years)",
    "CHIP:H2AFZ:OCI-LY3",
    "CHIP:H3K4me1:KOPT-K1",
    "CHIP:H3K27me3:regulatory T cell originated from blood cell",
    "CHIP:H3K4me1:CD8-positive, alpha-beta T cell",
    "CHIP:H3K4me1:H1-hESC",
    "CHIP:eGFP-ZBTB17:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ATF3:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:urinary bladder male adult (34 years)",
    "CHIP:H3K4me1:subcutaneous abdominal adipose tissue nuclear fraction female adult (59 years)",
    "CHIP:eGFP-NFE2L1:K562 genetically modified using stable transfection",
    "CHIP:eGFP-ZFHX2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ILF3:K562",
    "CHIP:3xFLAG-PBX2:K562 genetically modified using CRISPR",
    "CHIP:POLR2AphosphoS5:sigmoid colon female adult (51 year)",
    "CHIP:3xFLAG-RFX3:HepG2 genetically modified using CRISPR",
    "CHIP:H2BK12ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K27me3:HUES64",
    "CHIP:CTCF:NCI-H929",
    "CHIP:UBTF:HeLa-S3",
    "CHIP:ZSCAN29:K562",
    "CHIP:eGFP-TEAD2:K562 genetically modified using stable transfection",
    "CHIP:eGFP-KLF8:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:RAD21:liver female child (6 years) and male adult (32 years)",
    "CHIP:H3K36me3:mammary stem cell",
    "CHIP:EP300:upper lobe of left lung female adult (53 years)",
    "CHIP:CTBP1:MCF-7",
    "CHIP:H3K27me3:myoepithelial cell of mammary gland female adult (33 years)",
    "CHIP:H3K9me3:sigmoid colon male child (3 years)",
    "CHIP:BACH1:GM12878",
    "CHIP:MAZ:A549",
    "CHIP:H3K27me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:TRIM22:GM12878",
    "CHIP:H3K27me3:hepatocyte originated from H9",
    "CHIP:H3K36me3:OCI-LY3",
    "CHIP:H3K4me1:layer of hippocampus female adult (75 years)",
    "CHIP:ELF4:K562",
    "CHIP:SREBF2:A549",
    "CHIP:KDM1A:A549",
    "CHIP:H3K27me3:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:3xFLAG-CEBPG:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:thyroid gland male adult (54 years)",
    "CHIP:H4K20me1:MCF-7",
    "CHIP:H3K9me3:stomach male adult (34 years)",
    "CHIP:H3K27ac:transverse colon male adult (37 years)",
    "CHIP:AGO1:K562",
    "CHIP:H3K27me3:esophagus female adult (30 years)",
    "CHIP:H3K27ac:adrenal gland female adult (30 years)",
    "CHIP:H3K4me1:liver female adult (25 years)",
    "CHIP:KDM4B:K562",
    "CHIP:H3K27me3:transverse colon male adult (37 years)",
    "CHIP:H3K27ac:chorionic villus female embryo (40 weeks)",
    "CHIP:H3K9ac:kidney male adult (67 years)",
    "CHIP:SMARCA4:K562",
    "CHIP:H3K4me2:neural progenitor cell originated from H9",
    "CHIP:H3K4me3:ascending aorta female adult (51 year)",
    "CHIP:POLR2AphosphoS5:vagina female adult (51 year)",
    "CHIP:H3K27me3:duodenal mucosa male adult (76 years)",
    "CHIP:H3K36me3:thymus female embryo (110 days)",
    "CHIP:H3K27ac:esophagus female adult (30 years)",
    "CHIP:H3K36me3:chorionic villus male embryo (38 weeks)",
    "CHIP:eGFP-MEF2D:K562 genetically modified using stable transfection",
    "CHIP:eGFP-ILK:K562 genetically modified using stable transfection",
    "CHIP:H3K36me3:chorionic villus embryo (16 weeks)",
    "CHIP:H3K9me3:adrenal gland male embryo (97 days)",
    "CHIP:H3K36me3:smooth muscle cell originated from H9",
    "CHIP:H2BK5ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K4me3:cardiac muscle cell",
    "CHIP:SNIP1:K562",
    "CHIP:3xFLAG-SLC30A9:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27me3:neural cell",
    "CHIP:CTCF:vagina female adult (51 year)",
    "CHIP:H3K27ac:small intestine female adult (30 years)",
    "CHIP:3xFLAG-HHEX:HepG2 genetically modified using CRISPR",
    "CHIP:EZH2phosphoT487:neural progenitor cell originated from H9",
    "CHIP:H3K27ac:UCSF-4",
    "CHIP:3xFLAG-ZBED5:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:rectal smooth muscle tissue female adult (50 years)",
    "CHIP:H3K4me3:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:NFRKB:K562",
    "CHIP:SIN3B:K562",
    "CHIP:H3K9me3:SK-N-SH",
    "CHIP:LARP7:GM12878",
    "CHIP:H3K4me3:Loucy",
    "CHIP:H3K4me1:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K9me3:thyroid gland female adult (53 years)",
    "CHIP:NCOA1:K562",
    "CHIP:H3K4me3:chorionic villus female embryo (40 weeks)",
    "CHIP:HDAC2:A549",
    "CHIP:H3K36me3:ovary female adult (30 years)",
    "CHIP:H3K27ac:large intestine male embryo (108 days)",
    "CHIP:H3K4me1:spleen female adult (53 years)",
    "CHIP:TOE1:HepG2",
    "CHIP:H3K27ac:Karpas-422",
    "CHIP:H3K4me3:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:KDM4B:K562",
    "CHIP:H3K9me3:chorionic villus female embryo (40 weeks)",
    "CHIP:H3K4me1:CD4-positive, alpha-beta memory T cell",
    "CHIP:eGFP-ZNF169:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:SK-N-SH",
    "CHIP:H3K27ac:HCT116",
    "CHIP:H3K4me3:neural progenitor cell originated from H9",
    "CHIP:CTCF:breast epithelium female adult (51 year)",
    "CHIP:CTCF:gastroesophageal sphincter male adult (54 years)",
    "CHIP:3xFLAG-NR2F1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:neuroepithelial stem cell genetically modified using stable transfection originated from H9",
    "CHIP:REST:H1-hESC",
    "CHIP:MNT:MCF-7",
    "CHIP:TRIM25:K562",
    "CHIP:H3K4me1:mesendoderm originated from H1-hESC",
    "CHIP:ELK1:IMR-90",
    "CHIP:H3K4me1:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:eGFP-ZNF521:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-ZNF639:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27me3:liver male adult (32 years)",
    "CHIP:3xFLAG-TEAD3:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27ac:foreskin keratinocyte male newborn",
    "CHIP:H3K9ac:skeletal muscle tissue male adult (54 years)",
    "CHIP:POLR2A:transverse colon male adult (37 years)",
    "CHIP:CTCF:thoracic aorta male adult (37 years)",
    "CHIP:H3K9me3:mammary epithelial cell female adult (18 years)",
    "CHIP:eGFP-ZNF580:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:K562",
    "CHIP:H3K4me1:skeletal muscle tissue male adult (54 years)",
    "CHIP:eGFP-ZNF404:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-ATF4:HepG2 genetically modified using CRISPR",
    "CHIP:ARNT:K562",
    "CHIP:NFATC3:K562",
    "CHIP:RB1:K562",
    "CHIP:3xFLAG-DMAP1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:right cardiac atrium male adult (34 years)",
    "CHIP:eGFP-TAF7:K562 genetically modified using stable transfection",
    "CHIP:H3K9me3:chorionic villus embryo (16 weeks)",
    "CHIP:H3K36me3:lung female adult (30 years)",
    "CHIP:H3K27me3:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H3K9ac:caudate nucleus female adult (75 years)",
    "CHIP:H3F3A:smooth muscle cell originated from H9",
    "CHIP:H3K4me2:IMR-90",
    "CHIP:H3K36me3:aorta male adult (34 years)",
    "CHIP:H3K9me3:GM23248",
    "CHIP:eGFP-BCL6B:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:LNCAP treated with 10 nM 17B-hydroxy-5a-androstan-3-one for 4 hours",
    "CHIP:H3K27me3:chorionic villus male embryo (16 weeks)",
    "CHIP:POLR2A:upper lobe of left lung male adult (37 years)",
    "CHIP:eGFP-ZNF354B:K562 genetically modified using stable transfection",
    "CHIP:H3K27ac:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K27me3:T-helper 17 cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:H4K5ac:H1-hESC",
    "CHIP:MLLT1:K562",
    "CHIP:H3K27me3:heart right ventricle male child (3 years)",
    "CHIP:eGFP-ZNF398:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:heart male embryo (91 day)",
    "CHIP:H3K36me3:endodermal cell originated from HUES64",
    "CHIP:EP300:omental fat pad female adult (53 years)",
    "CHIP:H3K27ac:gastroesophageal sphincter female adult (53 years)",
    "CHIP:H2AFZ:neural progenitor cell originated from H9",
    "CHIP:H3F3A:OCI-LY1",
    "CHIP:H3K27ac:liver female adult (25 years)",
    "CHIP:H3K9me3:T-helper 17 cell originated from blood cell",
    "CHIP:H3K9me3:foreskin keratinocyte male newborn",
    "CHIP:H3K9me3:SK-N-MC",
    "CHIP:eGFP-ZNF23:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:esophagus male adult (34 years)",
    "CHIP:eGFP-ZNF792:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:EP300:HeLa-S3",
    "CHIP:IKZF2:GM12878",
    "CHIP:H3K9me3:iPS DF 6.9 male newborn",
    "CHIP:H3K4me3:common myeloid progenitor, CD34-positive female adult (27 years)",
    "CHIP:CEBPB:GM12878",
    "CHIP:H3K36me3:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:ETS1:HepG2",
    "CHIP:H3K9me3:sigmoid colon female adult (53 years)",
    "CHIP:H3K9ac:liver female adult (25 years)",
    "CHIP:ZNF207:HepG2",
    "CHIP:H3F3A:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:H4K20me1:MM.1S",
    "CHIP:EP300:stomach male adult (54 years)",
    "CHIP:KHSRP:K562",
    "CHIP:H3K27me3:muscle of trunk female embryo (115 days)",
    "CHIP:NCOA3:MCF-7",
    "CHIP:H3K14ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K27me3:neuron originated from H9",
    "CHIP:H3K9me3:Parathyroid adenoma male adult (62 years)",
    "CHIP:H3K36me3:neuroepithelial stem cell genetically modified using stable transfection originated from H9",
    "CHIP:H3K4me1:hepatocyte originated from H9",
    "CHIP:H3K36me3:body of pancreas male adult (37 years)",
    "CHIP:eGFP-ZNF146:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:ectodermal cell originated from embryonic stem cell",
    "CHIP:U2AF1:K562",
    "CHIP:H3K36me3:germinal matrix male embryo (20 weeks)",
    "CHIP:H3K9me3:mid-neurogenesis radial glial cells genetically modified using stable transfection originated from H9",
    "CHIP:POLR2A:spleen female adult (51 year)",
    "CHIP:H3K4me1:common myeloid progenitor, CD34-positive male adult (42 years)",
    "CHIP:H3K36me3:layer of hippocampus male adult (73 years)",
    "CHIP:eGFP-ZNF610:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K36me3:peripheral blood mononuclear cell male adult (39 years)",
    "CHIP:H3K4me2:NCI-H929",
    "CHIP:eGFP-YY2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:CD4-positive, alpha-beta T cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:CTCF:spleen female adult (53 years)",
    "CHIP:H3K36me3:rectal smooth muscle tissue female adult (50 years)",
    "CHIP:H3K4me3:cingulate gyrus female adult (75 years)",
    "CHIP:H3K27ac:foreskin melanocyte male newborn",
    "CHIP:H3K36me3:CD8-positive, alpha-beta T cell",
    "CHIP:H3K27me3:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K9me3:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H3K27ac:muscle layer of duodenum male adult (59 years)",
    "CHIP:ZNF24:K562",
    "CHIP:H3K79me2:hepatocyte originated from H9",
    "CHIP:POLR2A:vagina female adult (51 year)",
    "CHIP:EP300:ovary female adult (53 years)",
    "CHIP:SRSF4:HepG2",
    "CHIP:HCFC1:MCF-7",
    "CHIP:H3K4me3:esophagus female adult (30 years)",
    "CHIP:H3K9me3:gastrocnemius medialis male adult (54 years)",
    "CHIP:CTCF:breast epithelium male adult (54 years)",
    "CHIP:CBFA2T3:K562",
    "CHIP:H3K36me3:stomach female embryo (98 days)",
    "CHIP:H2AFZ:MM.1S",
    "CHIP:CTCF:tibial artery male adult (37 years)",
    "CHIP:H3K9me3:thyroid gland male adult (54 years)",
    "CHIP:CBFA2T2:K562",
    "CHIP:CLOCK:MCF-7",
    "CHIP:POLR2A:heart left ventricle female adult (51 year)",
    "CHIP:H3K4me1:psoas muscle male child (3 years)",
    "CHIP:H3K9me2:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:ZNF592:MCF-7",
    "CHIP:H3K9ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:eGFP-ZNF530:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me2:OCI-LY3",
    "CHIP:NFIB:MCF-7",
    "CHIP:EZH2phosphoT487:PC-9",
    "CHIP:H3K27me3:CD4-positive, alpha-beta memory T cell",
    "CHIP:H3K4me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (25 years)",
    "CHIP:H3K4me3:foreskin keratinocyte male newborn",
    "CHIP:EZH2:MM.1S",
    "CHIP:H2AK5ac:H1-hESC",
    "CHIP:3xFLAG-RAD21:MCF-7 genetically modified using CRISPR",
    "CHIP:H3K9me3:iPS DF 19.11 male newborn",
    "CHIP:3xFLAG-ZGPAT:HepG2 genetically modified using CRISPR",
    "CHIP:EP300:transverse colon female adult (51 year)",
    "CHIP:eGFP-ZSCAN23:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K79me2:PC-9",
    "CHIP:eGFP-ZBTB11:K562 genetically modified using CRISPR",
    "CHIP:H4K5ac:IMR-90",
    "CHIP:SMARCA5:GM12878",
    "CHIP:H3K4me1:ascending aorta female adult (53 years)",
    "CHIP:eGFP-MYNN:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:NFE2L2:HeLa-S3",
    "CHIP:NR2F6:K562",
    "CHIP:H3K27me3:foreskin melanocyte male newborn",
    "CHIP:eGFP-E2F5:K562 genetically modified using CRISPR",
    "CHIP:MGA:K562",
    "CHIP:NCOA1:K562",
    "CHIP:eGFP-ZNF837:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:HDAC1:K562",
    "CHIP:PKNOX1:GM12878",
    "CHIP:3xFLAG-ZSCAN9:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:heart embryo (101 day)",
    "CHIP:H3K27me3:layer of hippocampus male adult (81 year)",
    "CHIP:3xFLAG-ZNF146:K562 genetically modified using CRISPR",
    "CHIP:H3K79me2:IMR-90",
    "CHIP:CTCF:cardiac muscle cell",
    "CHIP:H3K4me1:colonic mucosa female adult (56 years)",
    "CHIP:POLR2AphosphoS5:transverse colon female adult (53 years)",
    "CHIP:POLR2AphosphoS5:stomach female adult (51 year)",
    "CHIP:H3K36me3:neural cell",
    "CHIP:H3K4me3:CD4-positive, alpha-beta T cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:eGFP-PRDM2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF664:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:muscle of trunk female embryo (115 days)",
    "CHIP:H3K27ac:A673",
    "CHIP:ETV4:HepG2",
    "CHIP:DPF2:K562",
    "CHIP:H3K4me3:adrenal gland male embryo (97 days)",
    "CHIP:eGFP-ZNF362:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-SOX13:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:naive thymus-derived CD4-positive, alpha-beta T cell",
    "CHIP:H3K27ac:thyroid gland female adult (53 years)",
    "CHIP:H3K36me3:T-cell male adult (21 year)",
    "CHIP:H3K4me3:kidney male adult (67 years)",
    "CHIP:H3K4me3:H9 genetically modified using stable transfection",
    "CHIP:H3K4me3:temporal lobe male adult (81 year)",
    "CHIP:H3K36me3:germinal matrix male embryo (20 weeks)",
    "CHIP:H3K27ac:placenta male embryo (16 weeks)",
    "CHIP:H3K27ac:vagina female adult (53 years)",
    "CHIP:RLF:K562",
    "CHIP:H3K9me3:body of pancreas female adult (53 years)",
    "CHIP:H3K27ac:KOPT-K1",
    "CHIP:H3K14ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:E2F1:K562",
    "CHIP:H3K27me3:psoas muscle male adult (34 years)",
    "CHIP:CTCF:prostate gland male adult (37 years)",
    "CHIP:H4K20me1:neural progenitor cell originated from H9",
    "CHIP:CTCF:sigmoid colon male adult (37 years)",
    "CHIP:H4K8ac:mesendoderm originated from H1-hESC",
    "CHIP:eGFP-ZSCAN18:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:ascending aorta female adult (53 years)",
    "CHIP:POLR2A:sigmoid colon female adult (51 year)",
    "CHIP:SAFB2:K562",
    "CHIP:H3K27ac:CD4-positive, alpha-beta memory T cell",
    "CHIP:H3K4me1:angular gyrus female adult (75 years)",
    "CHIP:LARP7:MCF-7",
    "CHIP:TCF12:GM12878",
    "CHIP:H3K27ac:spleen female adult (53 years)",
    "CHIP:H3K27me3:PC-9",
    "CHIP:H3K27ac:substantia nigra male adult (81 year)",
    "CHIP:H3K4me1:ACC112",
    "CHIP:CTCF:lower leg skin female adult (51 year)",
    "CHIP:eGFP-ZNF34:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3K27me3:lung female embryo (82 days)",
    "CHIP:H3K9me3:lung female adult (30 years)",
    "CHIP:H3K36me3:fibroblast of breast female adult (17 years)",
    "CHIP:eGFP-ZIC2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H4K20me1:H1-hESC",
    "CHIP:H3K27ac:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K27ac:iPS-20b male adult (55 years)",
    "CHIP:POLR2A:spleen male adult (37 years)",
    "CHIP:eGFP-ZNF644:K562 genetically modified using stable transfection",
    "CHIP:SP1:MCF-7",
    "CHIP:H4K20me1:H9",
    "CHIP:H3K4me1:ES-I3",
    "CHIP:MNT:HepG2",
    "CHIP:eGFP-ZSCAN5C:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:mucosa of rectum female adult (50 years)",
    "CHIP:E4F1:K562",
    "CHIP:H3K36me3:common myeloid progenitor, CD34-positive female adult (27 years)",
    "CHIP:H3K27me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:H2AK5ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:NKRF:GM12878",
    "CHIP:H3K27me3:CD4-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:H3K9me3:common myeloid progenitor, CD34-positive female adult (27 years)",
    "CHIP:H3K23ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H2BK15ac:H9",
    "CHIP:H3K36me3:UCSF-4",
    "CHIP:POLR2A:esophagus squamous epithelium male adult (54 years)",
    "CHIP:FOXA1:liver male adult (32 years)",
    "CHIP:H3K27ac:Parathyroid adenoma male adult (62 years)",
    "CHIP:H3K27ac:gastrocnemius medialis female adult (53 years)",
    "CHIP:EGR1:liver male adult (32 years)",
    "CHIP:H3K36me3:ascending aorta female adult (51 year)",
    "CHIP:H3K36me3:cingulate gyrus male adult (81 year)",
    "CHIP:eGFP-ZNF148:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:MYNN:K562",
    "CHIP:H3K9me3:sigmoid colon male adult (34 years)",
    "CHIP:eGFP-ZNF740:K562 genetically modified using stable transfection",
    "CHIP:H2BK12ac:H9",
    "CHIP:H3K4me3:thymus male child (3 years)",
    "CHIP:eGFP-ZNF449:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:upper lobe of left lung female adult (53 years)",
    "CHIP:H2BK15ac:H1-hESC",
    "CHIP:TBX21:GM12878",
    "CHIP:H3K4me2:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:eGFP-BACH1:K562 genetically modified using stable transfection",
    "CHIP:H2BK5ac:H9",
    "CHIP:H3K9me3:neurosphere female embryo (17 weeks) originated from ganglionic eminence",
    "CHIP:H3K79me2:ACC112",
    "CHIP:H3K27ac:DOHH2",
    "CHIP:NR2C1:K562",
    "CHIP:ZNF282:K562",
    "CHIP:H3K27ac:stomach female embryo (96 days)",
    "CHIP:H3K27me3:iPS-18a female adult (48 years)",
    "CHIP:H3K36me3:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:TCF12:K562",
    "CHIP:CTCF:thyroid gland female adult (53 years)",
    "CHIP:3xFLAG-GMEB2:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K36me3:trophoblast female embryo (20 weeks)",
    "CHIP:H3K9me3:duodenal mucosa male adult (59 years)",
    "CHIP:NFXL1:GM12878",
    "CHIP:H3K27me3:chorionic villus male embryo (38 weeks)",
    "CHIP:H3K27me3:A673",
    "CHIP:H3K27ac:ectodermal cell originated from embryonic stem cell",
    "CHIP:H3K4me3:pancreas male adult (34 years)",
    "CHIP:H4K20me1:OCI-LY7",
    "CHIP:H3K27me3:thyroid gland male adult (37 years)",
    "CHIP:H3K4me3:prostate male adult (54 years)",
    "CHIP:H3K27ac:body of pancreas female adult (53 years)",
    "CHIP:H3K36me3:transverse colon male adult (37 years)",
    "CHIP:H3K9me3:colonic mucosa female adult (56 years)",
    "CHIP:eGFP-NR2C2:K562 genetically modified using stable transfection",
    "CHIP:H3K9me3:effector memory CD4-positive, alpha-beta T cell",
    "CHIP:CHD4:GM12878",
    "CHIP:H3K36me3:sigmoid colon male child (3 years)",
    "CHIP:eGFP-ZNF112:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ZNF282:HepG2",
    "CHIP:H3K27ac:MCF-7",
    "CHIP:TARDBP:HEK293T",
    "CHIP:H2AK5ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:POLR2A:ovary female adult (53 years)",
    "CHIP:SKI:HepG2",
    "CHIP:eGFP-ZNF529:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:H9 genetically modified using stable transfection",
    "CHIP:SNRNP70:K562",
    "CHIP:CTCF:suprapubic skin female adult (51 year)",
    "CHIP:H3K9ac:muscle layer of colon female adult (77 years)",
    "CHIP:CTCF:esophagus squamous epithelium female adult (53 years)",
    "CHIP:CTCF:OCI-LY3",
    "CHIP:3xFLAG-KLF6:HepG2 genetically modified using CRISPR",
    "CHIP:SUZ12:MCF-7",
    "CHIP:HMBOX1:K562",
    "CHIP:H3K9me3:hepatocyte originated from H9",
    "CHIP:H3K27ac:MM.1S",
    "CHIP:3xFLAG-BCL6:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-PRDM12:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:body of pancreas male adult (37 years)",
    "CHIP:H3K36me3:adrenal gland male embryo (97 days)",
    "CHIP:ARNT:HEK293T",
    "CHIP:KLF16:K562",
    "CHIP:H4K20me1:Loucy",
    "CHIP:H3K9ac:stomach smooth muscle female adult (84 years)",
    "CHIP:H3K27me3:MCF-7",
    "CHIP:H3K27me3:kidney female embryo (120 days)",
    "CHIP:ZNF512B:MCF-7",
    "CHIP:EP300:transverse colon female adult (53 years)",
    "CHIP:H3K4me3:thyroid gland female adult (53 years)",
    "CHIP:eGFP-ZNF658:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:CTCF:subcutaneous adipose tissue female adult (53 years)",
    "CHIP:H3K4me1:thymus male child (3 years)",
    "CHIP:H3K27ac:prostate male adult (54 years)",
    "CHIP:ZNF217:GM12878",
    "CHIP:H4K20me1:PC-3",
    "CHIP:RBM39:K562",
    "CHIP:H3K4me1:germinal matrix male embryo (20 weeks)",
    "CHIP:NR0B1:K562",
    "CHIP:3xFLAG-DRAP1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:neurosphere embryo (15 weeks) originated from ganglionic eminence",
    "CHIP:H3K4me3:skeletal muscle tissue female adult (72 years)",
    "CHIP:H3K9me3:chorionic villus male embryo (16 weeks)",
    "CHIP:H3K4me1:chorion male embryo (16 weeks)",
    "CHIP:eGFP-ZNF555:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:temporal lobe female adult (75 years)",
    "CHIP:H3K56ac:H1-hESC",
    "CHIP:eGFP-ZNF324:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-OVOL3:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:B cell male adult (37 years)",
    "CHIP:eGFP-ZSCAN30:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:PC-9",
    "CHIP:H3K27me3:adipocyte originated from mesenchymal stem cell",
    "CHIP:eGFP-AEBP2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:CD4-positive, alpha-beta T cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:CTCF:transverse colon female adult (53 years)",
    "CHIP:3xFLAG-ELF3:HepG2 genetically modified using CRISPR",
    "CHIP:H3K27me3:mucosa of stomach male adult (59 years)",
    "CHIP:CTCF:adrenal gland female adult (53 years)",
    "CHIP:eGFP-BCL11B:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:breast epithelium female adult (53 years)",
    "CHIP:SUZ12:HepG2",
    "CHIP:H3F3A:SU-DHL-6",
    "CHIP:H3K27ac:tibial nerve female adult (53 years)",
    "CHIP:eGFP-RELA:K562 genetically modified using stable transfection",
    "CHIP:CTCF:esophagus squamous epithelium female adult (53 years)",
    "CHIP:EP300:suprapubic skin male adult (54 years)",
    "CHIP:eGFP-ZBTB7A:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:small intestine male embryo (108 days)",
    "CHIP:H3K27me3:body of pancreas male adult (54 years)",
    "CHIP:H3K36me3:CD4-positive, alpha-beta T cell male adult (37 years)",
    "CHIP:H3K27ac:muscle of trunk female embryo (115 days)",
    "CHIP:H3K36me3:HUES48",
    "CHIP:eGFP-ZNF791:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2A:stomach male adult (37 years)",
    "CHIP:CTCF:stomach female adult (53 years)",
    "CHIP:ZFP36:K562",
    "CHIP:H3K4me1:gastrocnemius medialis female adult (53 years)",
    "CHIP:H3K27ac:thymus female embryo (110 days)",
    "CHIP:eGFP-ZNF645:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF577:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:22Rv1 treated with 10 nM 17B-hydroxy-5a-androstan-3-one for 4 hours",
    "CHIP:H3K4me1:CD4-positive, alpha-beta T cell",
    "CHIP:eGFP-ZNF781:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:ELF4:HEK293T",
    "CHIP:ARID3A:GM12878",
    "CHIP:H3K4me3:ACC112",
    "CHIP:H4K20me1:OCI-LY3",
    "CHIP:EP300:omental fat pad female adult (51 year)",
    "CHIP:ZZZ3:K562",
    "CHIP:eGFP-KLF14:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:brain female embryo (17 weeks)",
    "CHIP:CTCF:Parathyroid adenoma male adult (62 years)",
    "CHIP:eGFP-ZBTB48:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:temporal lobe female adult (75 years)",
    "CHIP:H3K9ac:foreskin keratinocyte male newborn",
    "CHIP:H3K36me3:CD8-positive, alpha-beta T cell male adult (37 years)",
    "CHIP:H3K4me1:sigmoid colon male adult (34 years)",
    "CHIP:BMI1:K562",
    "CHIP:H3K4me2:smooth muscle cell originated from H9",
    "CHIP:EZH2phosphoT487:Loucy",
    "CHIP:H3K36me3:DOHH2",
    "CHIP:RBFOX2:HepG2",
    "CHIP:NR2C1:GM12878",
    "CHIP:RNF2:H1-hESC",
    "CHIP:H3K4me3:gastrocnemius medialis female adult (53 years)",
    "CHIP:RB1:GM12878",
    "CHIP:ZNF8:MCF-7",
    "CHIP:CTCF:neutrophil",
    "CHIP:H3K36me3:amnion male embryo (16 weeks)",
    "CHIP:H3K27me3:foreskin fibroblast male newborn",
    "CHIP:H3K4me2:mesenchymal stem cell originated from H1-hESC",
    "CHIP:ZBTB5:K562",
    "CHIP:H3K4me3:chorion female embryo (40 weeks)",
    "CHIP:eGFP-TSC22D4:K562 genetically modified using stable transfection",
    "CHIP:H3K9me3:CD4-positive, alpha-beta T cell male adult (37 years)",
    "CHIP:H3K4me2:PC-3",
    "CHIP:SOX6:K562",
    "CHIP:RFX1:MCF-7",
    "CHIP:BHLHE40:HEK293T",
    "CHIP:H3K4me2:OCI-LY1",
    "CHIP:H4K20me1:KMS-11",
    "CHIP:CTCF:subcutaneous adipose tissue female adult (51 year)",
    "CHIP:ZNF24:HepG2",
    "CHIP:CTCF:heart left ventricle female adult (51 year)",
    "CHIP:H3K4me3:heart right ventricle male adult (34 years)",
    "CHIP:H3K4me2:SK-N-SH",
    "CHIP:H3K27ac:psoas muscle male adult (34 years)",
    "CHIP:H3K4me3:right atrium auricular region female adult (53 years)",
    "CHIP:H3K4me1:transverse colon female adult (53 years)",
    "CHIP:RBM25:K562",
    "CHIP:H3K27me3:H9",
    "CHIP:H3K4me3:small intestine male adult (34 years)",
    "CHIP:BCLAF1:K562",
    "CHIP:3xFLAG-MYRF:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:iPS-18c female adult (48 years)",
    "CHIP:E2F8:GM12878",
    "CHIP:H3K27me3:right atrium auricular region female adult (53 years)",
    "CHIP:EZH2:PC-9",
    "CHIP:H3K4me2:HCT116",
    "CHIP:JUNB:K562",
    "CHIP:H3K4me3:liver male adult (32 years)",
    "CHIP:H3K4me3:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:H3K4me3:CD14-positive monocyte male adult (37 years)",
    "CHIP:NFIC:K562",
    "CHIP:H3K27me3:CD8-positive, alpha-beta T cell",
    "CHIP:H3K4me1:layer of hippocampus male adult (73 years)",
    "CHIP:MITF:K562",
    "CHIP:RNF2:A549",
    "CHIP:3xFLAG-NR2F6:HepG2 genetically modified using CRISPR",
    "CHIP:NCOR1:K562",
    "CHIP:CTCF:uterus female adult (51 year)",
    "CHIP:H3K27ac:caudate nucleus female adult (75 years)",
    "CHIP:YBX1:HepG2",
    "CHIP:H3K9ac:B cell female adult (27 years) and female adult (43 years)",
    "CHIP:H3K27ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K4me3:duodenal mucosa male adult (59 years)",
    "CHIP:CTCF:Peyer's patch male adult (54 years)",
    "CHIP:H3K9me3:neural stem progenitor cell originated from H9",
    "CHIP:HNF1A:HepG2",
    "CHIP:eGFP-ZNF155:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:foreskin melanocyte male newborn",
    "CHIP:CBX2:HepG2",
    "CHIP:H3K27ac:gastrocnemius medialis male adult (37 years)",
    "CHIP:eGFP-GTF2A2:K562 genetically modified using stable transfection",
    "CHIP:TARDBP:MCF-7",
    "CHIP:NCOA2:K562",
    "CHIP:POLR2A:testis male adult (54 years)",
    "CHIP:eGFP-HIC1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:thoracic aorta male adult (37 years)",
    "CHIP:H3K4me3:liver female adult (25 years)",
    "CHIP:H3K9ac:peripheral blood mononuclear cell male adult (28 years)",
    "CHIP:HNRNPLL:HepG2",
    "CHIP:H3K27ac:HUES64",
    "CHIP:H3K4me2:SU-DHL-6",
    "CHIP:H3K27me3:layer of hippocampus female adult (75 years)",
    "CHIP:H4K20me1:IMR-90",
    "CHIP:H3K27me3:muscle layer of duodenum male adult (73 years)",
    "CHIP:H3K4me2:KMS-11",
    "CHIP:MTA1:K562",
    "CHIP:eGFP-SP2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:mammary epithelial cell female adult (18 years)",
    "CHIP:BCOR:K562",
    "CHIP:3xFLAG-ZKSCAN8:HepG2 genetically modified using CRISPR",
    "CHIP:H2BK5ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K27me3:HCT116",
    "CHIP:H3K27ac:CD8-positive, alpha-beta memory T cell",
    "CHIP:TOE1:MCF-7",
    "CHIP:eGFP-ZNF19:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H2BK120ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K4me1:sigmoid colon female adult (53 years)",
    "CHIP:H3K4me3:foreskin fibroblast male newborn",
    "CHIP:SMAD1:GM12878",
    "CHIP:H3K9ac:lung female embryo (120 days)",
    "CHIP:H3K4me1:myoepithelial cell of mammary gland female adult (36 years)",
    "CHIP:H3K4me3:transverse colon male adult (37 years)",
    "CHIP:SRSF9:K562",
    "CHIP:H3K4ac:mesendoderm originated from H1-hESC",
    "CHIP:H3K4me1:neuron originated from H9",
    "CHIP:H3K4me3:H1-hESC",
    "CHIP:H3K9ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K23ac:H1-hESC",
    "CHIP:H3K9me3:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:H3K36me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:SREBF1:K562",
    "CHIP:H2AFZ:neural cell",
    "CHIP:H3K36me3:B cell male adult (21 year)",
    "CHIP:H3K4me1:endocrine pancreas adult (59 years)",
    "CHIP:EP400:K562",
    "CHIP:eGFP-MAFG:K562 genetically modified using stable transfection",
    "CHIP:MYB:GM12878",
    "CHIP:H3K4me3:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:FOXA1:K562",
    "CHIP:H3K9me3:germinal matrix male embryo (20 weeks)",
    "CHIP:RNF2:K562",
    "CHIP:H4K20me1:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:H3K4me2:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:IKZF2:GM12878",
    "CHIP:ARID1B:K562",
    "CHIP:CTCF:neural cell originated from H1-hESC",
    "CHIP:RBFOX2:K562",
    "CHIP:CTCF:tibial nerve female adult (51 year)",
    "CHIP:H3K27ac:foreskin fibroblast male newborn",
    "CHIP:3xFLAG-RFXANK:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:endodermal cell originated from HUES64",
    "CHIP:POLR2AphosphoS5:stomach female adult (53 years)",
    "CHIP:H3K4me1:skeletal muscle tissue female adult (72 years)",
    "CHIP:H3K9me3:CD8-positive, alpha-beta T cell male adult (37 years)",
    "CHIP:H3K36me3:mesenchymal stem cell originated from H1-hESC",
    "CHIP:TAF15:HepG2",
    "CHIP:POLR2A:suprapubic skin female adult (53 years)",
    "CHIP:H3K27ac:PC-3",
    "CHIP:H3K4me1:neutrophil",
    "CHIP:3xFLAG-SMAD4:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:mucosa of rectum female adult (61 year)",
    "CHIP:H3K4me1:body of pancreas male adult (37 years)",
    "CHIP:eGFP-FEZF1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me3:ovary female adult (53 years)",
    "CHIP:GATAD2B:GM12878",
    "CHIP:EP300:upper lobe of left lung male adult (37 years)",
    "CHIP:H3K36me3:CD4-positive, alpha-beta T cell",
    "CHIP:CTCF:prostate gland male adult (54 years)",
    "CHIP:H3K9me3:brain male embryo (122 days)",
    "CHIP:H3K9me3:mucosa of rectum female adult (61 year)",
    "CHIP:FOXM1:HEK293T",
    "CHIP:H3K4me1:IMR-90",
    "CHIP:H3K27me3:colonic mucosa female adult (56 years)",
    "CHIP:SRSF1:K562",
    "CHIP:H3K27me3:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K36me3:placenta embryo (16 weeks)",
    "CHIP:LEF1:K562",
    "CHIP:CTCF:transverse colon male adult (54 years)",
    "CHIP:H3K9me3:muscle of leg female embryo (110 days)",
    "CHIP:H3K27ac:SK-N-MC",
    "CHIP:H3K27ac:CD8-positive, alpha-beta T cell",
    "CHIP:eGFP-HDAC8:K562 genetically modified using stable transfection",
    "CHIP:TRIM22:GM12878",
    "CHIP:H3K36me3:KMS-11",
    "CHIP:RBM17:K562",
    "CHIP:H3K36me3:skeletal muscle tissue",
    "CHIP:H3K36me3:chorionic villus female embryo (40 weeks)",
    "CHIP:NRF1:K562",
    "CHIP:JUND:liver male adult (32 years)",
    "CHIP:H3K27ac:Peyer's patch female adult (53 years)",
    "CHIP:H3K36me3:Loucy",
    "CHIP:CTCF:esophagus squamous epithelium male adult (37 years)",
    "CHIP:H3K27me3:placenta female embryo (113 days)",
    "CHIP:H3K9ac:mesendoderm originated from H1-hESC",
    "CHIP:SMARCA4:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:CREM:GM12878",
    "CHIP:H3K4me3:caudate nucleus male adult (81 year)",
    "CHIP:H3K27me3:transverse colon female adult (53 years)",
    "CHIP:ELF1:GM12878",
    "CHIP:E4F1:MCF-7",
    "CHIP:H3K9ac:iPS-18a female adult (48 years)",
    "CHIP:H3K27ac:neuroepithelial stem cell genetically modified using stable transfection NONE and originated from H9",
    "CHIP:H3K27me3:psoas muscle male child (3 years)",
    "CHIP:EP300:neural cell originated from H1-hESC",
    "CHIP:H3K36me3:ES-I3",
    "CHIP:POLR2AphosphoS5:breast epithelium male adult (54 years)",
    "CHIP:eGFP-ZNF639:K562 genetically modified using CRISPR",
    "CHIP:H3K4me1:HUES64",
    "CHIP:H2BK20ac:H9",
    "CHIP:EP300:omental fat pad male adult (37 years)",
    "CHIP:H3K27ac:adrenal gland male embryo (97 days)",
    "CHIP:MAX:liver female child (4 years)",
    "CHIP:eGFP-FOXJ2:K562 genetically modified using stable transfection",
    "CHIP:H3K79me2:KMS-11",
    "CHIP:CTCF:22Rv1 treated with 10 nM 17B-hydroxy-5a-androstan-3-one for 4 hours",
    "CHIP:RBM22:K562",
    "CHIP:H2BK120ac:H1-hESC",
    "CHIP:H3K9ac:iPS-15b female adult (48 years)",
    "CHIP:H3K4me1:aorta female adult (30 years)",
    "CHIP:ZMYM3:HepG2",
    "CHIP:H3K36me3:PC-3",
    "CHIP:3xFLAG-PBX2:HepG2 genetically modified using CRISPR",
    "CHIP:H3K9me3:endocrine pancreas male",
    "CHIP:ASH2L:GM12878",
    "CHIP:H3K4me3:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:ASH2L:H1-hESC",
    "CHIP:H3K9ac:hepatocyte originated from H9",
    "CHIP:H3K4me2:OCI-LY7",
    "CHIP:H3K4me1:tibial nerve female adult (53 years)",
    "CHIP:RBM15:K562",
    "CHIP:MEIS2:K562",
    "CHIP:H3K4me1:CD8-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:ZNF830:K562",
    "CHIP:H3K4me3:CD4-positive, alpha-beta T cell male adult (21 year)",
    "CHIP:NRF1:HepG2",
    "CHIP:H3K27me3:chorionic villus female embryo (40 weeks)",
    "CHIP:H3K9me3:liver female adult (25 years)",
    "CHIP:H3K27me3:foreskin keratinocyte male newborn",
    "CHIP:eGFP-ZNF707:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2G:HepG2",
    "CHIP:eGFP-IRF1:K562 genetically modified using stable transfection",
    "CHIP:eGFP-ZNF350:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:heart left ventricle female adult (53 years)",
    "CHIP:H3K27me3:spinal cord female embryo (108 days)",
    "CHIP:H3K36me3:thyroid gland female adult (53 years)",
    "CHIP:CTCF:RWPE2",
    "CHIP:H3K27ac:OCI-LY3",
    "CHIP:H3K4me1:iPS DF 6.9 male newborn",
    "CHIP:CTCF:22Rv1",
    "CHIP:H3K36me3:adrenal gland male adult (54 years)",
    "CHIP:H4K91ac:H1-hESC",
    "CHIP:eGFP-ZNF621:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:muscle layer of colon female adult (56 years)",
    "CHIP:eGFP-KLF1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:small intestine male embryo (108 days)",
    "CHIP:ZNF687:GM12878",
    "CHIP:H2AFZ:DOHH2",
    "CHIP:ATM:HepG2",
    "CHIP:H3K27me3:OCI-LY1",
    "CHIP:H3K27me3:upper lobe of left lung female adult (53 years)",
    "CHIP:eGFP-YY1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:CD4-positive, CD25-positive, alpha-beta regulatory T cell",
    "CHIP:H3K9ac:cingulate gyrus female adult (75 years)",
    "CHIP:CBFB:GM12878",
    "CHIP:FOXK2:GM12878",
    "CHIP:POLR2AphosphoS5:suprapubic skin male adult (54 years)",
    "CHIP:H3K27me3:common myeloid progenitor, CD34-positive female adult (27 years)",
    "CHIP:EP300:esophagus muscularis mucosa male adult (54 years)",
    "CHIP:L3MBTL2:HEK293T",
    "CHIP:H3K9me3:HUES6",
    "CHIP:H3K4me1:spinal cord female embryo (108 days)",
    "CHIP:TCF7:K562",
    "CHIP:H3K9me3:body of pancreas male adult (54 years)",
    "CHIP:YBX1:MCF-7",
    "CHIP:H3K27me3:cardiac muscle cell",
    "CHIP:eGFP-ZSCAN16:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:GM23248",
    "CHIP:ATF7:MCF-7",
    "CHIP:H3K27me3:peripheral blood mononuclear cell male adult (32 years)",
    "CHIP:H3K27me3:OCI-LY3",
    "CHIP:H3K36me3:Karpas-422",
    "CHIP:REST:liver male adult (32 years)",
    "CHIP:U2AF1:HepG2",
    "CHIP:H3K36me3:upper lobe of left lung female adult (53 years)",
    "CHIP:H2AFZ:SU-DHL-6",
    "CHIP:ATF2:K562",
    "CHIP:H3K36me3:brain female embryo (17 weeks)",
    "CHIP:H3K4me2:Karpas-422",
    "CHIP:H3K36me3:H9 genetically modified using stable transfection",
    "CHIP:REST:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:THRAP3:K562",
    "CHIP:FOXK2:HEK293T",
    "CHIP:PCBP1:HepG2",
    "CHIP:H3K9ac:MM.1S",
    "CHIP:H3K4me1:gastroesophageal sphincter female adult (53 years)",
    "CHIP:KDM5A:HepG2",
    "CHIP:H3F3A:neural cell",
    "CHIP:IKZF1:GM12878",
    "CHIP:H2AFZ:OCI-LY1",
    "CHIP:H3K4me3:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me2:MCF-7",
    "CHIP:TRIM22:MCF-7",
    "CHIP:H3K27ac:iPS DF 6.9 male newborn",
    "CHIP:H3K4me3:body of pancreas male adult (37 years)",
    "CHIP:ZBTB33:K562",
    "CHIP:H3K27ac:H9",
    "CHIP:ZHX2:MCF-7",
    "CHIP:POLR2A:esophagus squamous epithelium female adult (51 year)",
    "CHIP:H3K27me3:small intestine female adult (30 years)",
    "CHIP:H3K36me3:heart left ventricle male child (3 years)",
    "CHIP:EP300:vagina female adult (53 years)",
    "CHIP:H3K36me3:CD4-positive, alpha-beta T cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:eGFP-ZNF624:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H4K20me1:SK-N-SH",
    "CHIP:H3K4me3:B cell female adult (43 years)",
    "CHIP:H3K4me3:Peyer's patch female adult (53 years)",
    "CHIP:H3K36me3:KOPT-K1",
    "CHIP:H3K27ac:H1-hESC",
    "CHIP:H3K27me3:PC-3",
    "CHIP:ZKSCAN1:K562",
    "CHIP:ZNF384:HEK293T",
    "CHIP:eGFP-ZBTB11:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9me3:H1-hESC",
    "CHIP:H3K4me3:substantia nigra male adult (81 year)",
    "CHIP:H2AFZ:hepatocyte originated from H9",
    "CHIP:H3K4me3:endocrine pancreas adult (59 years)",
    "CHIP:H3K9me3:Loucy",
    "CHIP:H3K9me3:stomach male child (3 years)",
    "CHIP:EZH2phosphoT487:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:NONO:K562",
    "CHIP:H3K4me1:CD4-positive, alpha-beta memory T cell",
    "CHIP:SMARCC2:HepG2",
    "CHIP:ZHX1:HeLa-S3",
    "CHIP:H3K9me3:mesodermal cell originated from HUES64",
    "CHIP:POLR2A:lower leg skin female adult (53 years)",
    "CHIP:H3K36me3:brain male embryo (122 days)",
    "CHIP:H4K8ac:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me1:HUES48",
    "CHIP:POLR2A:upper lobe of left lung female adult (51 year)",
    "CHIP:H3K4me3:iPS DF 19.11 male newborn",
    "CHIP:TCF7L2:K562",
    "CHIP:POLR2AphosphoS5:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:H3K36me3:foreskin fibroblast male newborn",
    "CHIP:H3K4me1:neuroepithelial stem cell genetically modified using stable transfection originated from H9",
    "CHIP:H3K9me3:B cell male adult (21 year)",
    "CHIP:H3K27ac:common myeloid progenitor, CD34-positive female adult (27 years)",
    "CHIP:EP300:esophagus muscularis mucosa female adult (51 year)",
    "CHIP:H3K27ac:angular gyrus female adult (75 years)",
    "CHIP:REST:A549",
    "CHIP:H3K27ac:effector memory CD4-positive, alpha-beta T cell",
    "CHIP:H3K36me3:liver male adult (32 years)",
    "CHIP:eGFP-PRDM6:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:layer of hippocampus female adult (75 years)",
    "CHIP:H3K27ac:small intestine male embryo (108 days)",
    "CHIP:eGFP-ZNF548:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:caudate nucleus male adult (81 year)",
    "CHIP:POLR2AphosphoS5:upper lobe of left lung female adult (51 year)",
    "CHIP:REST:liver female child (4 years)",
    "CHIP:HDAC2:K562",
    "CHIP:SUPT5H:K562",
    "CHIP:H3K4me3:HUES64",
    "CHIP:EZH2phosphoT487:MM.1S",
    "CHIP:TCF12:HepG2",
    "CHIP:SMARCA5:K562",
    "CHIP:H3K9me3:ES-I3",
    "CHIP:H2BK12ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:eGFP-REST:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K36me3:ACC112",
    "CHIP:CREB1:MCF-7",
    "CHIP:eGFP-ZNF491:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:JUNB:GM12878",
    "CHIP:SREBF1:A549",
    "CHIP:eGFP-ZNF514:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27me3:sigmoid colon male child (3 years)",
    "CHIP:E2F8:MCF-7",
    "CHIP:ZFP91:K562",
    "CHIP:ZNF687:MCF-7",
    "CHIP:RBM34:K562",
    "CHIP:CTCF:adrenal gland male adult (37 years)",
    "CHIP:H3K36me3:adrenal gland female adult (30 years)",
    "CHIP:H3K9me3:gastrocnemius medialis female adult (53 years)",
    "CHIP:H4K20me1:GM23248",
    "CHIP:H2BK120ac:mesendoderm originated from H1-hESC",
    "CHIP:H2AFZ:Loucy",
    "CHIP:H3K4me3:sigmoid colon female adult (53 years)",
    "CHIP:ZFP36:GM12878",
    "CHIP:H3K4me3:thyroid gland male adult (37 years)",
    "CHIP:H3K4me1:mucosa of rectum female adult (50 years)",
    "CHIP:H3K4me1:temporal lobe male adult (81 year)",
    "CHIP:H3K4me3:heart left ventricle female adult (53 years)",
    "CHIP:H3K4ac:mesenchymal stem cell originated from H1-hESC",
    "CHIP:H3K9ac:subcutaneous abdominal adipose tissue nuclear fraction female adult (81 year)",
    "CHIP:H3K4me3:fibroblast of breast female adult (26 years)",
    "CHIP:CREM:HepG2",
    "CHIP:H3K27me3:body of pancreas female adult (53 years)",
    "CHIP:H3K4me1:stomach female adult (53 years)",
    "CHIP:H3K27me3:liver female adult (25 years)",
    "CHIP:H3K9me3:CD8-positive, alpha-beta T cell",
    "CHIP:H3K27ac:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:H3K4me1:GM23248",
    "CHIP:EP300:gastroesophageal sphincter male adult (54 years)",
    "CHIP:eGFP-ZNF223:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:SP1:HEK293T",
    "CHIP:EP300:sigmoid colon male adult (37 years)",
    "CHIP:H3K4me1:thyroid gland male adult (37 years)",
    "CHIP:CTCF:transverse colon male adult (54 years)",
    "CHIP:ZMIZ1:K562",
    "CHIP:TRIM24:K562",
    "CHIP:KDM1A:K562",
    "CHIP:H3K36me3:thyroid gland male adult (54 years)",
    "CHIP:H2AFZ:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:3xFLAG-MXD3:HepG2 genetically modified using CRISPR",
    "CHIP:eGFP-ZEB1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:eGFP-ZNF547:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K27ac:esophagus squamous epithelium female adult (53 years)",
    "CHIP:H3K9me3:thoracic aorta male adult (54 years)",
    "CHIP:H3K27ac:chorion male embryo (16 weeks)",
    "CHIP:NCOR1:K562",
    "CHIP:H3K36me3:HEK293",
    "CHIP:H3K27ac:epithelial cell of prostate male",
    "CHIP:H3K4me3:Karpas-422",
    "CHIP:H3K4me1:effector memory CD4-positive, alpha-beta T cell",
    "CHIP:CTCF:right lobe of liver female adult (53 years)",
    "CHIP:POLR2A:prostate gland male adult (37 years)",
    "CHIP:H3K27me3:germinal matrix male embryo (20 weeks)",
    "CHIP:ZNF217:MCF-7",
    "CHIP:H3K4me1:fibroblast of breast female adult (26 years)",
    "CHIP:NONO:MCF-7",
    "CHIP:H3K27ac:layer of hippocampus male adult (81 year)",
    "CHIP:H3K4me1:PC-9",
    "CHIP:H3K36me3:GM23248",
    "CHIP:MTA3:K562",
    "CHIP:H3K27me3:SK-N-SH",
    "CHIP:POLR2AphosphoS5:gastroesophageal sphincter male adult (37 years)",
    "CHIP:H3K27me3:iPS DF 6.9 male newborn",
    "CHIP:H3K27ac:foreskin fibroblast male newborn",
    "CHIP:RAD21:liver male adult (32 years)",
    "CHIP:eGFP-EGR2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:HUES6",
    "CHIP:POLR2AphosphoS5:vagina female adult (53 years)",
    "CHIP:eGFP-ZFX:K562 genetically modified using CRISPR",
    "CHIP:SIN3A:K562",
    "CHIP:H3K27me3:T-cell male adult (37 years)",
    "CHIP:POLR2AphosphoS5:sigmoid colon male adult (37 years)",
    "CHIP:H3K36me3:common myeloid progenitor, CD34-positive",
    "CHIP:H3K4me3:mid-neurogenesis radial glial cells genetically modified using stable transfection originated from H9",
    "CHIP:POLR2A:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:H3K9ac:subcutaneous abdominal adipose tissue nuclear fraction female adult (25 years)",
    "CHIP:H3K9me3:gastrocnemius medialis male adult (37 years)",
    "CHIP:H3K4me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (59 years)",
    "CHIP:NONO:HepG2",
    "CHIP:EP300:sigmoid colon male adult (54 years)",
    "CHIP:H3K36me3:thymus male child (3 years)",
    "CHIP:eGFP-ZBTB49:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:PHB2:K562",
    "CHIP:RFX5:MCF-7",
    "CHIP:3xFLAG-GATAD2A:HepG2 genetically modified using CRISPR",
    "CHIP:CTCF:sigmoid colon female adult (53 years)",
    "CHIP:H3K36me3:H1-hESC",
    "CHIP:3xFLAG-HMG20B:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:skeletal muscle tissue male adult (54 years)",
    "CHIP:eGFP-IRF9:K562 genetically modified using stable transfection",
    "CHIP:H3K4me3:adrenal gland male adult (54 years)",
    "CHIP:eGFP-ZBTB1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:RFX1:HepG2",
    "CHIP:H3K27ac:heart right ventricle male adult (34 years)",
    "CHIP:H3K27me3:H1-hESC",
    "CHIP:GMEB1:K562",
    "CHIP:EP300:suprapubic skin female adult (53 years)",
    "CHIP:H2AFZ:neuron originated from H9",
    "CHIP:H3K27me3:muscle layer of duodenum male adult (59 years)",
    "CHIP:POLR2AphosphoS5:transverse colon male adult (37 years)",
    "CHIP:H3K4me3:thoracic aorta male adult (54 years)",
    "CHIP:H3K36me3:skeletal muscle tissue female adult (72 years)",
    "CHIP:H3K9me3:H7-hESC",
    "CHIP:NCOA1:K562",
    "CHIP:H3K27ac:mesodermal cell originated from HUES64",
    "CHIP:CTCF:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:H3K4me3:transverse colon female adult (53 years)",
    "CHIP:HDAC6:GM12878",
    "CHIP:KDM5A:A549",
    "CHIP:CLOCK:MCF-7",
    "CHIP:MXI1:neural cell originated from H1-hESC",
    "CHIP:POLR2A:tibial nerve female adult (53 years)",
    "CHIP:H3K4me3:lung female embryo (120 days)",
    "CHIP:POLR2AphosphoS5:esophagus muscularis mucosa female adult (53 years)",
    "CHIP:ZNF143:GM12878",
    "CHIP:3xFLAG-KLF9:HepG2 genetically modified using CRISPR",
    "CHIP:POLR2AphosphoS5:breast epithelium female adult (53 years)",
    "CHIP:H3K27me3:natural killer cell male adult (21 year)",
    "CHIP:H3K27me3:thoracic aorta male adult (37 years)",
    "CHIP:H3K4me3:B cell male adult (37 years)",
    "CHIP:MBD2:MCF-7",
    "CHIP:H2BK12ac:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K4me2:trophoblast cell originated from H1-hESC",
    "CHIP:H3K27me3:stomach smooth muscle female adult (84 years)",
    "CHIP:H3K4me3:iPS-11a male adult (36 years)",
    "CHIP:H3K23ac:IMR-90",
    "CHIP:H3K36me3:adrenal gland male adult (34 years)",
    "CHIP:H3K36me3:pancreas male adult (34 years)",
    "CHIP:H3K9me2:PC-3",
    "CHIP:H3K4me3:muscle layer of colon female adult (77 years)",
    "CHIP:H3K4me3:small intestine female adult (30 years)",
    "CHIP:H3K36me3:CD8-positive, alpha-beta memory T cell",
    "CHIP:H3K9ac:PC-9",
    "CHIP:USF2:SK-N-SH",
    "CHIP:PCBP2:HepG2",
    "CHIP:H2AFZ:PC-3",
    "CHIP:eGFP-KLF13:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:PTBP1:K562",
    "CHIP:CBX1:K562",
    "CHIP:IKZF1:K562",
    "CHIP:H3K27ac:gastrocnemius medialis male adult (54 years)",
    "CHIP:H3K27me3:chorionic villus embryo (16 weeks)",
    "CHIP:PAX8:MCF-7",
    "CHIP:ZNF639:K562",
    "CHIP:H3K4me3:psoas muscle male adult (34 years)",
    "CHIP:eGFP-ZNF785:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2AphosphoS5:spleen male adult (37 years)",
    "CHIP:LCORL:HepG2",
    "CHIP:H3K27me3:thymus male child (3 years)",
    "CHIP:H3K9ac:H1-hESC",
    "CHIP:E2F8:K562",
    "CHIP:H3K4me3:rectal smooth muscle tissue female adult (50 years)",
    "CHIP:H3K9me3:layer of hippocampus male adult (81 year)",
    "CHIP:H3K36me3:fibroblast of breast female adult (26 years)",
    "CHIP:H3K4me1:lung female embryo (85 days)",
    "CHIP:3xFLAG-KAT8:HepG2 genetically modified using CRISPR",
    "CHIP:ESRRA:MCF-7",
    "CHIP:H3K27me3:muscle of leg female embryo (110 days)",
    "CHIP:CTCF:thyroid gland female adult (51 year)",
    "CHIP:H3K27ac:KMS-11",
    "CHIP:H3K27me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3K27ac:trophoblast female embryo (40 weeks)",
    "CHIP:H3K4me3:layer of hippocampus male adult (81 year)",
    "CHIP:H3K4me3:neural stem progenitor cell originated from H1-hESC",
    "CHIP:H3K9me3:ovary female adult (30 years)",
    "CHIP:H3K4me3:aorta male adult (34 years)",
    "CHIP:H3K79me2:OCI-LY3",
    "CHIP:H3K4me3:neurosphere female embryo (17 weeks) originated from cortex",
    "CHIP:H3T11ph:H9",
    "CHIP:BHLHE40:IMR-90",
    "CHIP:TRIM24:K562",
    "CHIP:H3K9me3:chorionic villus male embryo (38 weeks)",
    "CHIP:H3K4me3:endocrine pancreas male adult (45 years)",
    "CHIP:H3K9me3:common myeloid progenitor, CD34-positive female adult (33 years)",
    "CHIP:H3K4me3:T-helper 17 cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:H3K36me3:small intestine male child (3 years)",
    "CHIP:H3K9ac:H7-hESC",
    "CHIP:H4K20me1:neural cell",
    "CHIP:3xFLAG-SAP130:HepG2 genetically modified using CRISPR",
    "CHIP:POLR2AphosphoS5:spleen female adult (53 years)",
    "CHIP:H3K36me3:chorion male embryo (16 weeks)",
    "CHIP:H3K27me3:trophoblast cell originated from H1-hESC",
    "CHIP:H3K4me3:aorta female adult (30 years)",
    "CHIP:H4K12ac:trophoblast cell originated from H1-hESC",
    "CHIP:CTCF:ascending aorta female adult (51 year)",
    "CHIP:H4K20me1:OCI-LY1",
    "CHIP:ATF2:GM12878",
    "CHIP:3xFLAG-SOX5:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:CD8-positive, alpha-beta memory T cell",
    "CHIP:H3K36me3:vagina female adult (53 years)",
    "CHIP:H3K27me3:Karpas-422",
    "CHIP:H3K27ac:chorionic villus embryo (16 weeks)",
    "CHIP:H3K4me1:natural killer cell male adult (21 year)",
    "CHIP:CTCF:upper lobe of left lung male adult (54 years)",
    "CHIP:H3F3A:DOHH2",
    "CHIP:eGFP-WT1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-MIXL1:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me3:regulatory T cell originated from blood cell",
    "CHIP:eGFP-PATZ1:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:BMI1:MCF-7",
    "CHIP:H3K4me1:H9 genetically modified using stable transfection",
    "CHIP:H3K36me3:right atrium auricular region female adult (53 years)",
    "CHIP:RFX1:K562",
    "CHIP:SMARCE1:HepG2",
    "CHIP:H3K9ac:peripheral blood mononuclear cell male adult (27 years)",
    "CHIP:H3K4me3:keratinocyte female",
    "CHIP:NR2F1:K562",
    "CHIP:CTCF:upper lobe of left lung female adult (53 years)",
    "CHIP:H3K27ac:stomach smooth muscle female adult (84 years)",
    "CHIP:H3K4me1:CD4-positive, alpha-beta T cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:H3K4me3:gastrocnemius medialis male adult (54 years)",
    "CHIP:CTCF:upper lobe of left lung female adult (51 year)",
    "CHIP:H3K4me1:foreskin melanocyte male newborn",
    "CHIP:H3K27me3:right cardiac atrium male adult (34 years)",
    "CHIP:H3K9me3:H9",
    "CHIP:ATF7:K562",
    "CHIP:H3K9me3:T-cell",
    "CHIP:POLR2A:transverse colon female adult (51 year)",
    "CHIP:KLF5:GM12878",
    "CHIP:H3K9me3:thoracic aorta male adult (37 years)",
    "CHIP:H3K4me3:SK-N-SH",
    "CHIP:H3K4me3:thyroid gland male adult (54 years)",
    "CHIP:EP300:vagina female adult (51 year)",
    "CHIP:H3K9me3:substantia nigra female adult (75 years)",
    "CHIP:eGFP-ELF1:K562 genetically modified using stable transfection",
    "CHIP:H3K4me1:KMS-11",
    "CHIP:IRF5:GM12878",
    "CHIP:H3K27me3:body of pancreas male adult (37 years)",
    "CHIP:eGFP-ZNF18:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:placenta female embryo (113 days)",
    "CHIP:H3K9me3:Karpas-422",
    "CHIP:H3K36me3:SK-N-SH",
    "CHIP:eGFP-GLI2:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:POLR2AphosphoS5:sigmoid colon male adult (54 years)",
    "CHIP:POLR2A:body of pancreas female adult (53 years)",
    "CHIP:GATAD2B:MCF-7",
    "CHIP:MNT:K562",
    "CHIP:H3K9me3:common myeloid progenitor, CD34-positive",
    "CHIP:H3K9me3:iPS-18a female adult (48 years)",
    "CHIP:EP300:subcutaneous adipose tissue male adult (54 years)",
    "CHIP:H3K9me3:peripheral blood mononuclear cell male adult (32 years)",
    "CHIP:CTCF:testis male adult (54 years)",
    "CHIP:H3K27ac:right lobe of liver female adult (53 years)",
    "CHIP:H3K27me3:Peyer's patch female adult (53 years)",
    "CHIP:H3K27ac:ascending aorta female adult (51 year)",
    "CHIP:H2AFZ:bipolar neuron originated from GM23338 treated with 0.5 ug/mL doxycycline hyclate for 4 days",
    "CHIP:EP300:subcutaneous adipose tissue female adult (51 year)",
    "CHIP:H3K4me3:thoracic aorta male adult (37 years)",
    "CHIP:eGFP-ZNF24:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K4me1:pancreas female adult (30 years)",
    "CHIP:H3K4me3:MCF-7",
    "CHIP:eGFP-ZNF114:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:NEUROD1:K562",
    "CHIP:POLR2AphosphoS5:upper lobe of left lung female adult (53 years)",
    "CHIP:PKNOX1:MCF-7",
    "CHIP:CTCF:GM23338 male adult (53 years) originated from GM23248",
    "CHIP:BHLHE40:GM12878",
    "CHIP:DNMT1:K562",
    "CHIP:H3K27ac:RWPE2",
    "CHIP:H3K36me3:thoracic aorta male adult (54 years)",
    "CHIP:H3K9me3:A673",
    "CHIP:H3K27me3:heart left ventricle female adult (53 years)",
    "CHIP:3xFLAG-ARID4B:HepG2 genetically modified using CRISPR",
    "CHIP:3xFLAG-RERE:HepG2 genetically modified using CRISPR",
    "CHIP:H3K36me3:aorta female adult (30 years)",
    "CHIP:H3K36me3:subcutaneous abdominal adipose tissue nuclear fraction female adult (49 years)",
    "CHIP:H3K4me3:iPS-20b male adult (55 years)",
    "CHIP:MCM3:K562",
    "CHIP:U2AF2:HepG2",
    "CHIP:H3K4me1:H1-hESC",
    "CHIP:SP1:K562",
    "CHIP:H3K9me3:middle frontal area 46 male adult (81 year)",
    "CHIP:H3K36me3:peripheral blood mononuclear cell female adult (28 years)",
    "CHIP:H3K9me3:adrenal gland male adult (34 years)",
    "CHIP:H3K4me2:DOHH2",
    "CHIP:eGFP-ZNF214:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:3xFLAG-TGIF2:HepG2 genetically modified using CRISPR",
    "CHIP:H3K4me1:kidney male adult (50 years)",
    "CHIP:H3K36me3:cardiac muscle cell",
    "CHIP:YY1:liver female child (4 years)",
    "CHIP:POLR2A:Peyer's patch female adult (53 years)",
    "CHIP:H3K36me3:skeletal muscle satellite cell female adult originated from mesodermal cell",
    "CHIP:JUN:A549",
    "CHIP:H3K36me3:substantia nigra female adult (75 years)",
    "CHIP:NFRKB:K562",
    "CHIP:H3K4me1:iPS-20b male adult (55 years)",
    "CHIP:eGFP-ZNF202:HEK293 genetically modified using site-specific recombination originated from HEK293",
    "CHIP:H3K9ac:OCI-LY3",
    "CHIP:NFRKB:HEK293T",
    "CHIP:XRCC3:K562",
    "CHIP:H3K27me3:brain female embryo (17 weeks)",
    "CHIP:NRF1:K562",
    "CHIP:CTCF:gastrocnemius medialis male adult (54 years)",
    "CHIP:H3K36me3:T-helper 17 cell treated with phorbol 13-acetate 12-myristate , ionomycin",
    "CHIP:H3K4me1:large intestine male embryo (108 days)",
    "CHIP:POLR2A:uterus female adult (51 year)",
    "CHIP:H3K9me3:MCF-7",
    "CHIP:.:batch1_chrom1_LoVo_ARNT_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ASCL2_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ATOH1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_BARX2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_CAMTA2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_CASP8AP2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_CEBPB_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_CEBPG_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_CTCF_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_DBP_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_E2F2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_E2F4_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_EGR1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_EHF_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ELF1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_USF2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ESRRA_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ETV4_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_GATA4_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_GATA6_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_GLI2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_GMEB1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_GMEB2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HBP1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HES2_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HES4_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HINFP_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HNF4A_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HOXA10_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HOXA1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_HOXA7_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_IRX3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_JUN_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_KLF3_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_KLF5_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_LHX2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MED12_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MED1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MEF2C_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MYB_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MYBL2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MYC_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_MZF1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NEUROG3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NFAT5_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NFE2L2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NFIL3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NIPBL_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NPAT_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NR2F1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NR2F2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_NR3C1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_RAD21_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_RFX1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_RFX2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_RFX5_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_RXRA_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SMAD2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SMAD3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SMC1A_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SMC3_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SOX4_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SP1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_SP3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_TBX3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_TCF12_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_TCF7L2_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_TFAP2A_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_TFDP1_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_UBTF_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_YY1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ZBED4_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ZBTB7B_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ZNF236_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ZNF250_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ZNF407_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_ZNF706_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_AEBP2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ATF1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ATF5_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_BARHL1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_CLOCK_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_CREB3L4_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_DLX1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_E2F3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_E2F7_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_E2F8_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ERM_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ESR1_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ETS2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ETV7_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_EVI1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_FEV_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_ZFHX3_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_FOXD2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_FOXG1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_GATA1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_GLI3_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_GLIS1_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_HOXA13_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_HOXA2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_HOXC6_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_JUND_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_LYL1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_MAZ_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_MNT_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_NFKB2_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_NFYA_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_NKX2.2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_RARG_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_RBCK1_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_REST_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_SOX2_Goat_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_SP2_Mouse_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_TEAD2_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_TP73_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch2_chrom1_LoVo_VEZF1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_H3_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_H3K4me1_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:.:batch1_chrom1_LoVo_H3K4me3_Rabbit_PassedQC / LoVo / colon adenocarcinoma",
    "CHIP:RNAPII:ChIP-seq, RNAPII_LowDensity_noDMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:RNAPII:ChIP-seq, RNAPII_HighDensity_noDMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:RNAPII:ChIP-seq, RNAPII_LowDensity_DMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:RNAPII:ChIP-seq, RNAPII_HighDensity_DMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, CEBPb_HighDensity_noDMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, CEBPb_LowDensity_DMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, CEBPb_HighDensity_DMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:GR:ChIP-seq, GR_HighDensity_DMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:ATF4:ChIP-seq, ATF4_HighDensity_noDMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:H3K27Ac:ChIP-seq, H3K27Ac_HighDensity_noDMI / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_0.1uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_0.25uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_1.0uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_10uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:ATF4:ChIP-seq, InVitroCistromics_ATF4_5uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_0.1uL_plusATF4_0.002uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_0.1uL_plusATF4_0.02uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:CEBPb:ChIP-seq, InVitroCistromics_CEBPb_0.1uL_plusATF4_0.2uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:ATF4:ChIP-seq, InVitroCistromics_ATF4_0.02uL_plusCEBPb_0.1uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:ATF4:ChIP-seq, InVitroCistromics_ATF4_0.2uL_plusCEBPb_0.1uL / hMSC / Human Mesenchymal Stem Cells",
    "CHIP:hBMAL1:ChIP_hBMAL1 Chip-seq / U2OS cells / .",
    "CHIP:hHIF1A:ChIP_hHIF1A Chip-seq / U2OS cells / .",
    "CHIP:ATF4:anti-ATF4 (sc-200) / HAP1, 2 mM histidinol for 24 hours, ATF4 ChIP / HAP1",
    "CHIP:BMAL1:BMAL1_DMSO_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:BMAL1:BMAL1_6AN_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:CLOCK:CLOCK_DMSO_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:CLOCK:CLOCK_6AN_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:H3K4me3:H3K4me3_DMSO_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:H3K4me3:H3K4me3_6AN_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:H3K9ac:H3K9ac_DMSO_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:H3K9ac:H3K9ac_6AN_ChIPSeq / U2OS cells stably expressing Bmal1:Luc / osteosarcoma cell line U2OS stably expressing Bmal1:Luc",
    "CHIP:abcam:ChIP_hBMAL1-peak-DMOG CHIP-Seq / U2OS cells / .",
    "CHIP:abcam:ChIP_hBMAL1-trough-DMOG CHIP-Seq / U2OS cells / .",
    "CHIP:abcam:ChIP_hBMAL1-peak-DMSO CHIP-Seq / U2OS cells / .",
    "CHIP:abcam:ChIP_hBMAL1-trough-DMSO CHIP-Seq / U2OS cells / .",
    "CHIP:active:ChIP_hHIF1a-peak-DMOG CHIP-Seq / U2OS cells / .",
    "CHIP:active:ChIP_hHIF1a-trough-DMOG CHIP-Seq / U2OS cells / .",
    "CHIP:active:ChIP_hHIF1a-peak-DMSO CHIP-Seq / U2OS cells / .",
    "CHIP:active:ChIP_hHIF1a-trough-DMSO CHIP-Seq / U2OS cells / .",
    "CAGE:Clontech Human Universal Reference Total RNA, pool1",
    "CAGE:SABiosciences XpressRef Human Universal Total RNA, pool1",
    "CAGE:Universal RNA - Human Normal Tissues Biochain, pool1",
    "CAGE:adipose tissue, adult, pool1",
    "CAGE:bladder, adult, pool1",
    "CAGE:brain, adult, pool1",
    "CAGE:cervix, adult, pool1",
    "CAGE:colon, adult, pool1",
    "CAGE:esophagus, adult, pool1",
    "CAGE:heart, adult, pool1",
    "CAGE:kidney, adult, pool1",
    "CAGE:liver, adult, pool1",
    "CAGE:lung, adult, pool1",
    "CAGE:ovary, adult, pool1",
    "CAGE:placenta, adult, pool1",
    "CAGE:prostate, adult, pool1",
    "CAGE:skeletal muscle, adult, pool1",
    "CAGE:small intestine, adult, pool1",
    "CAGE:spleen, adult, pool1",
    "CAGE:testis, adult, pool1",
    "CAGE:thymus, adult, pool1",
    "CAGE:thyroid, adult, pool1",
    "CAGE:trachea, adult, pool1",
    "CAGE:retina, adult, pool1",
    "CAGE:temporal lobe, adult, pool1",
    "CAGE:postcentral gyrus, adult, pool1",
    "CAGE:pons, adult, pool1",
    "CAGE:parietal lobe, adult, pool1",
    "CAGE:paracentral gyrus, adult, pool1",
    "CAGE:occipital pole, adult, pool1",
    "CAGE:nucleus accumbens, adult, pool1",
    "CAGE:medulla oblongata, adult, pool1",
    "CAGE:insula, adult, pool1",
    "CAGE:frontal lobe, adult, pool1",
    "CAGE:dura mater, adult,",
    "CAGE:corpus callosum, adult, pool1",
    "CAGE:thymus, fetal, pool1",
    "CAGE:spleen, fetal, pool1",
    "CAGE:kidney, fetal, pool1",
    "CAGE:heart, fetal, pool1",
    "CAGE:tonsil, adult, pool1",
    "CAGE:acute myeloid leukemia (FAB M5) cell line:THP-1 (fresh)",
    "CAGE:acute myeloid leukemia (FAB M5) cell line:THP-1 (revived)",
    "CAGE:acute myeloid leukemia (FAB M5) cell line:THP-1 (thawed)",
    "CAGE:lung adenocarcinoma cell line:PC-14",
    "CAGE:chronic myelogenous leukemia cell line:KU812",
    "CAGE:extraskeletal myxoid chondrosarcoma cell line:H-EMC-SS",
    "CAGE:renal cell carcinoma cell line:OS-RC-2",
    "CAGE:malignant trichilemmal cyst cell line:DJM-1",
    "CAGE:glioma cell line:GI-1",
    "CAGE:maxillary sinus tumor cell line:HSQ-89",
    "CAGE:gall bladder carcinoma cell line:TGBC2TKB",
    "CAGE:papillotubular adenocarcinoma cell line:TGBC18TKB",
    "CAGE:transitional-cell carcinoma cell line:5637",
    "CAGE:breast carcinoma cell line:MDA-MB-453",
    "CAGE:colon carcinoma cell line:COLO-320",
    "CAGE:adult T-cell leukemia cell line:ATN-1",
    "CAGE:Burkitt's lymphoma cell line:DAUDI",
    "CAGE:choriocarcinoma cell line:BeWo",
    "CAGE:splenic lymphoma with villous lymphocytes cell line:SLVL",
    "CAGE:astrocytoma cell line:TM-31",
    "CAGE:epidermoid carcinoma cell line:A431",
    "CAGE:b cell line:RPMI1788",
    "CAGE:anaplastic carcinoma cell line:8305C",
    "CAGE:acute lymphoblastic leukemia (T-ALL) cell line:HPB-ALL",
    "CAGE:non T non B acute lymphoblastic leukemia (ALL) cell line:P30/OHK",
    "CAGE:epidermoid carcinoma cell line:Ca Ski",
    "CAGE:bile duct carcinoma cell line:HuCCT1",
    "CAGE:giant cell carcinoma cell line:Lu99B",
    "CAGE:oral squamous cell carcinoma cell line:Ca9-22",
    "CAGE:signet ring carcinoma cell line:Kato III",
    "CAGE:Endothelial Cells - Aortic,",
    "CAGE:Smooth Muscle Cells - Aortic,",
    "CAGE:Smooth Muscle Cells - Umbilical artery,",
    "CAGE:Retinal Pigment Epithelial Cells,",
    "CAGE:Urothelial cells,",
    "CAGE:Mesenchymal stem cells - adipose,",
    "CAGE:Mesenchymal stem cells - hepatic,",
    "CAGE:Mesenchymal Stem Cells - Vertebral,",
    "CAGE:Sebocyte,",
    "CAGE:Fibroblast - Gingival,  (GFH2)",
    "CAGE:Mesothelial Cells,",
    "CAGE:Sertoli Cells,",
    "CAGE:CD14+ Monocytes,",
    "CAGE:CD4+ T Cells,",
    "CAGE:CD8+ T Cells,",
    "CAGE:Dendritic Cells - monocyte immature derived, , tech_",
    "CAGE:Dendritic Cells - plasmacytoid,",
    "CAGE:CD14+ monocyte derived endothelial progenitor cells,",
    "CAGE:Natural Killer Cells,",
    "CAGE:Peripheral Blood Mononuclear Cells,",
    "CAGE:Macrophage - monocyte derived,",
    "CAGE:Neutrophils,",
    "CAGE:Smooth Muscle Cells - Brain Vascular,",
    "CAGE:Astrocyte - cerebral cortex,",
    "CAGE:Endothelial Cells - Lymphatic,",
    "CAGE:Fibroblast - Gingival,",
    "CAGE:Fibroblast - Periodontal Ligament,",
    "CAGE:Smooth Muscle Cells - Colonic,",
    "CAGE:Skeletal Muscle Satellite Cells,",
    "CAGE:Myoblast,",
    "CAGE:Ciliary Epithelial Cells,",
    "CAGE:Endothelial Cells - Umbilical vein,",
    "CAGE:Fibroblast - Aortic Adventitial,",
    "CAGE:Intestinal epithelial cells (polarized),",
    "CAGE:Anulus Pulposus Cell,",
    "CAGE:Pancreatic stromal cells,",
    "CAGE:Fibroblast - Pulmonary Artery,",
    "CAGE:Keratinocyte - oral,",
    "CAGE:Nucleus Pulposus Cell,",
    "CAGE:Prostate Epithelial Cells (polarized),",
    "CAGE:Prostate Stromal Cells,",
    "CAGE:Small Airway Epithelial Cells,",
    "CAGE:cord blood derived cell line:COBL-a untreated",
    "CAGE:embryonic kidney cell line: HEK293/SLAM untreated",
    "CAGE:embryonic kidney cell line: HEK293/SLAM infection, 24hr",
    "CAGE:cord blood derived cell line:COBL-a 24h infection(-C)",
    "CAGE:cord blood derived cell line:COBL-a 24h infection",
    "CAGE:Adipocyte - breast,",
    "CAGE:Preadipocyte - breast,",
    "CAGE:Adipocyte - omental,",
    "CAGE:Mesenchymal Stem Cells - Wharton's Jelly,",
    "CAGE:Gingival epithelial cells,  (GEA11)",
    "CAGE:Neural stem cells,",
    "CAGE:Keratinocyte - epidermal,",
    "CAGE:Preadipocyte - omental,",
    "CAGE:Smooth Muscle Cells - Internal Thoracic Artery,",
    "CAGE:Synoviocyte,",
    "CAGE:Mast cell - stimulated,",
    "CAGE:Fibroblast - skin spinal muscular atrophy,",
    "CAGE:Whole blood (ribopure), , donation1",
    "CAGE:Whole blood (ribopure), , donation2",
    "CAGE:Mammary Epithelial Cell,",
    "CAGE:Osteoblast,",
    "CAGE:Placental Epithelial Cells,",
    "CAGE:Preadipocyte - subcutaneous,",
    "CAGE:Preadipocyte - visceral,",
    "CAGE:Skeletal Muscle Cells,",
    "CAGE:Skeletal muscle cells differentiated into Myotubes - multinucleated,",
    "CAGE:Smooth Muscle Cells - Brachiocephalic,",
    "CAGE:Smooth Muscle Cells - Carotid,",
    "CAGE:Smooth Muscle Cells - Coronary Artery,",
    "CAGE:Smooth Muscle Cells - Pulmonary Artery,",
    "CAGE:Smooth Muscle Cells - Subclavian Artery,",
    "CAGE:Smooth Muscle Cells - Umbilical Artery,",
    "CAGE:Tracheal Epithelial Cells,",
    "CAGE:ductal cell carcinoma cell line:KLM-1",
    "CAGE:schwannoma cell line:HS-PSS, tech_",
    "CAGE:glioblastoma cell line:A172, tech_",
    "CAGE:prostate cancer cell line:PC-3",
    "CAGE:synovial sarcoma cell line:HS-SY-II",
    "CAGE:epithelioid sarcoma cell line:HS-ES-1",
    "CAGE:endometrial stromal sarcoma cell line:OMC-9",
    "CAGE:chronic myelogenous leukemia cell line:K562",
    "CAGE:acute lymphoblastic leukemia (B-ALL) cell line:BALL-1",
    "CAGE:squamous cell carcinoma cell line:EC-GI-10",
    "CAGE:acute lymphoblastic leukemia (T-ALL) cell line:Jurkat",
    "CAGE:melanoma cell line:G-361",
    "CAGE:rectal cancer cell line:TT1TKB",
    "CAGE:gall bladder carcinoma cell line:TGBC14TKB",
    "CAGE:renal cell carcinoma cell line:TUHR10TKB",
    "CAGE:myeloma cell line:PCM6",
    "CAGE:ductal cell carcinoma cell line:MIA Paca2",
    "CAGE:prostate cancer cell line:DU145",
    "CAGE:transitional-cell carcinoma cell line:JMSU1",
    "CAGE:mesothelioma cell line:ACC-MESO-1",
    "CAGE:mesothelioma cell line:ACC-MESO-4",
    "CAGE:bile duct carcinoma cell line:TFK-1",
    "CAGE:endometrial carcinoma cell line:OMC-2",
    "CAGE:retinoblastoma cell line:Y79",
    "CAGE:Burkitt's lymphoma cell line:RAJI",
    "CAGE:rhabdomyosarcoma cell line:RMS-YM",
    "CAGE:signet ring carcinoma cell line:NUGC-4",
    "CAGE:hepatoma cell line:Li-7",
    "CAGE:glioblastoma cell line:T98G",
    "CAGE:squamous cell lung carcinoma cell line:EBC-1",
    "CAGE:giant cell carcinoma cell line:LU65",
    "CAGE:lung adenocarcinoma cell line:A549",
    "CAGE:neuroblastoma cell line:CHP-134",
    "CAGE:large cell lung carcinoma cell line:IA-LM",
    "CAGE:osteosarcoma cell line:143B/TK^(-)neo^(R)",
    "CAGE:colon carcinoma cell line:CACO-2",
    "CAGE:melanoma cell line:COLO 679",
    "CAGE:acute lymphoblastic leukemia (B-ALL) cell line:NALM-6",
    "CAGE:cholangiocellular carcinoma cell line:HuH-28",
    "CAGE:neuroblastoma cell line:NB-1",
    "CAGE:small cell lung carcinoma cell line:LK-2",
    "CAGE:gastric cancer cell line:AZ521",
    "CAGE:oral squamous cell carcinoma cell line:HO-1-u-1",
    "CAGE:cervical cancer cell line:D98-AH2",
    "CAGE:cervical cancer cell line:ME-180",
    "CAGE:osteosarcoma cell line:HS-Os-1",
    "CAGE:Melanocyte - light,",
    "CAGE:Osteoblast - differentiated,",
    "CAGE:Mesenchymal Stem Cells - bone marrow,",
    "CAGE:Pericytes,",
    "CAGE:Fibroblast - Choroid Plexus,",
    "CAGE:Meningeal Cells,",
    "CAGE:Astrocyte - cerebellum,",
    "CAGE:Fibroblast - Lymphatic,",
    "CAGE:Esophageal Epithelial Cells,",
    "CAGE:Smooth Muscle Cells - Esophageal,",
    "CAGE:Alveolar Epithelial Cells,",
    "CAGE:Bronchial Epithelial Cell,",
    "CAGE:Smooth Muscle Cells - Bronchial,",
    "CAGE:Smooth Muscle Cells - Tracheal,",
    "CAGE:Renal Proximal Tubular Epithelial Cell,",
    "CAGE:Renal Cortical Epithelial Cells,",
    "CAGE:Renal Epithelial Cells,",
    "CAGE:Renal Mesangial Cells,",
    "CAGE:Urothelial Cells,",
    "CAGE:Hepatic Stellate Cells (lipocyte),",
    "CAGE:Corneal Epithelial Cells,",
    "CAGE:Keratocytes,",
    "CAGE:Fibroblast - Conjunctival,",
    "CAGE:Trabecular Meshwork Cells,",
    "CAGE:Amniotic Epithelial Cells,",
    "CAGE:Fibroblast - Villous Mesenchymal,",
    "CAGE:Mesenchymal Stem Cells - adipose,",
    "CAGE:Mesenchymal Stem Cells - hepatic,",
    "CAGE:Mesenchymal Stem Cells - umbilical,",
    "CAGE:Fibroblast - Mammary,",
    "CAGE:Mesenchymal Stem Cells - amniotic membrane,",
    "CAGE:Multipotent Cord Blood Unrestricted Somatic Stem Cells,",
    "CAGE:Fibroblast - skin normal,",
    "CAGE:Fibroblast - skin walker warburg,",
    "CAGE:Fibroblast - skin dystrophia myotonica,",
    "CAGE:Adipocyte - subcutaneous,",
    "CAGE:Chondrocyte - de diff,",
    "CAGE:Chondrocyte - re diff,",
    "CAGE:Endothelial Cells - Microvascular,",
    "CAGE:Endothelial Cells - Vein,",
    "CAGE:Fibroblast - Cardiac,",
    "CAGE:Fibroblast - Dermal,",
    "CAGE:Fibroblast - Lung,",
    "CAGE:uterus, adult, pool1",
    "CAGE:salivary gland, adult, pool1",
    "CAGE:lung, fetal,",
    "CAGE:chronic lymphocytic leukemia (T-CLL) cell line:SKW-3",
    "CAGE:Hodgkin's lymphoma cell line:HD-Mar2",
    "CAGE:papillary adenocarcinoma cell line:8505C",
    "CAGE:oral squamous cell carcinoma cell line:HSC-3",
    "CAGE:mesenchymal stem cell line:Hu5/E18",
    "CAGE:leiomyoma cell line:10964C",
    "CAGE:leiomyoma cell line:15242A",
    "CAGE:leiomyoma cell line:15425",
    "CAGE:argyrophil small cell carcinoma cell line:TC-YIK",
    "CAGE:testicular germ cell embryonal carcinoma cell line:NEC8",
    "CAGE:Wilms' tumor cell line:HFWT",
    "CAGE:myxofibrosarcoma cell line:MFH-ino",
    "CAGE:embryonic pancreas cell line:1B2C6",
    "CAGE:embryonic pancreas cell line:1C3D3",
    "CAGE:embryonic pancreas cell line:1C3IKEI",
    "CAGE:small-cell gastrointestinal carcinoma cell line:ECC4",
    "CAGE:small cell gastrointestinal carcinoma cell line:ECC10",
    "CAGE:gastric adenocarcinoma cell line:MKN1",
    "CAGE:gastrointestinal carcinoma cell line:ECC12",
    "CAGE:squamous cell carcinoma cell line:T3M-5",
    "CAGE:granulosa cell tumor cell line:KGN",
    "CAGE:diffuse large B-cell lymphoma cell line:CTB-1",
    "CAGE:hepatoblastoma cell line:HuH-6",
    "CAGE:neuroectodermal tumor cell line:FU-RPNT-1",
    "CAGE:clear cell carcinoma cell line:JHOC-5",
    "CAGE:serous adenocarcinoma cell line:JHOS-2",
    "CAGE:carcinosarcoma cell line:JHUCS-1",
    "CAGE:endometrioid adenocarcinoma cell line:JHUEM-1",
    "CAGE:squamous cell carcinoma cell line:JHUS-nk1",
    "CAGE:lens epithelial cell line:SRA 01/04",
    "CAGE:mucinous adenocarcinoma cell line:JHOM-1",
    "CAGE:neuroectodermal tumor cell line:FU-RPNT-2",
    "CAGE:smooth muscle, adult, pool1",
    "CAGE:pancreas, adult,",
    "CAGE:heart, adult, diseased post-infarction,",
    "CAGE:heart, adult, diseased,",
    "CAGE:aorta, adult, pool1",
    "CAGE:blood, adult, pool1",
    "CAGE:eye, fetal,",
    "CAGE:uterus, fetal,",
    "CAGE:spinal cord, fetal,",
    "CAGE:umbilical cord, fetal,",
    "CAGE:trachea, fetal,",
    "CAGE:tongue, fetal,",
    "CAGE:thyroid, fetal,",
    "CAGE:throat, fetal,",
    "CAGE:stomach, fetal,",
    "CAGE:temporal lobe, fetal, , tech_",
    "CAGE:small intestine, fetal,",
    "CAGE:skin, fetal,",
    "CAGE:skeletal muscle, fetal,",
    "CAGE:rectum, fetal,",
    "CAGE:diaphragm, fetal,",
    "CAGE:colon, fetal,",
    "CAGE:duodenum, fetal, , tech_",
    "CAGE:parietal lobe, fetal,",
    "CAGE:occipital lobe, fetal,",
    "CAGE:skin, adult,",
    "CAGE:lung, right lower lobe, adult,",
    "CAGE:occipital lobe, adult,",
    "CAGE:lymph node, adult,",
    "CAGE:left ventricle, adult,",
    "CAGE:left atrium, adult,",
    "CAGE:breast, adult,",
    "CAGE:adrenal gland, adult, pool1",
    "CAGE:colon, adult,",
    "CAGE:cerebellum, adult, pool1",
    "CAGE:brain, adult,",
    "CAGE:brain, fetal, pool1",
    "CAGE:liver, fetal, pool1",
    "CAGE:oral squamous cell carcinoma cell line:SAS",
    "CAGE:neuroblastoma cell line:NH-12",
    "CAGE:small cell lung carcinoma cell line:WA-hT",
    "CAGE:xeroderma pigentosum b cell line:XPL 17",
    "CAGE:embryonic pancreas cell line:2C6",
    "CAGE:neuroblastoma cell line:NBsusSR",
    "CAGE:gastric adenocarcinoma cell line:MKN45",
    "CAGE:choriocarcinoma cell line:T3M-3",
    "CAGE:myxofibrosarcoma cell line:NMFH-1",
    "CAGE:Krukenberg tumor cell line:HSKTC",
    "CAGE:glassy cell carcinoma cell line:HOKUG",
    "CAGE:large cell non-keratinizing squamous carcinoma cell line:SKG-II-SF",
    "CAGE:serous cystadenocarcinoma cell line:HTOA",
    "CAGE:tridermal teratoma cell line:HGRT",
    "CAGE:sacrococcigeal teratoma cell line:HTST",
    "CAGE:peripheral neuroectodermal tumor cell line:KU-SN",
    "CAGE:pancreatic carcinoma cell line:NOR-P1",
    "CAGE:chondrosarcoma cell line:SW 1353",
    "CAGE:carcinoid cell line:NCI-H1770",
    "CAGE:osteoclastoma cell line:Hs 706.T",
    "CAGE:Ewing's sarcoma cell line:Hs 863.T",
    "CAGE:transitional cell carcinoma cell line:Hs 769.T",
    "CAGE:alveolar cell carcinoma cell line:SW 1573",
    "CAGE:bronchioalveolar carcinoma cell line:NCI-H358",
    "CAGE:bronchogenic carcinoma cell line:ChaGo-K-1",
    "CAGE:fibrous histiocytoma cell line:GCT TIB-223",
    "CAGE:hairy cell leukemia cell line:Mo",
    "CAGE:acantholytic squamous carcinoma cell line:HCC1806",
    "CAGE:biphenotypic B myelomonocytic leukemia cell line:MV-4-11",
    "CAGE:carcinoid cell line:SK-PN-DW",
    "CAGE:leiomyoblastoma cell line:G-402",
    "CAGE:pharyngeal carcinoma cell line:Detroit 562",
    "CAGE:liposarcoma cell line:SW 872",
    "CAGE:lymphangiectasia cell line:DS-1",
    "CAGE:neuroepithelioma cell line:SK-N-MC",
    "CAGE:neurofibroma cell line:Hs 53.T",
    "CAGE:pagetoid sarcoma cell line:Hs 925.T",
    "CAGE:spindle cell sarcoma cell line:Hs 132.T",
    "CAGE:mycosis fungoides, T cell lymphoma cell line:HuT 102 TIB-162",
    "CAGE:leukemia, chronic megakaryoblastic cell line:MEG-01",
    "CAGE:fibrosarcoma cell line:HT-1080",
    "CAGE:medulloblastoma cell line:ONS-76",
    "CAGE:bronchial squamous cell carcinoma cell line:KNS-62",
    "CAGE:acute myeloid leukemia (FAB M2) cell line:NKM-1",
    "CAGE:chronic myelogenous leukemia (CML) cell line:MEG-A2",
    "CAGE:neuroectodermal tumor cell line:TASK1",
    "CAGE:NK T cell leukemia cell line:KHYG-1",
    "CAGE:hepatic mesenchymal tumor cell line:LI90",
    "CAGE:somatostatinoma cell line:QGP-1",
    "CAGE:liposarcoma cell line:KMLS-1",
    "CAGE:thyroid carcinoma cell line:TCO-1",
    "CAGE:mucinous cystadenocarcinoma cell line:MCAS",
    "CAGE:choriocarcinoma cell line:SCH",
    "CAGE:testicular germ cell embryonal carcinoma cell line:ITO-II",
    "CAGE:rhabdomyosarcoma cell line:KYM-1",
    "CAGE:teratocarcinoma cell line:NCC-IT-A3",
    "CAGE:keratoacanthoma cell line:HKA-1",
    "CAGE:anaplastic large cell lymphoma cell line:Ki-JK",
    "CAGE:adenocarcinoma cell line:IM95m",
    "CAGE:tubular adenocarcinoma cell line:SUIT-2",
    "CAGE:teratocarcinoma cell line:NCR-G1",
    "CAGE:small cell cervical cancer cell line:HCSC-1",
    "CAGE:chronic myeloblastic leukemia (CML) cell line:KCL-22",
    "CAGE:acute myeloid leukemia (FAB M7) cell line:MKPL-1",
    "CAGE:anaplastic squamous cell carcinoma cell line:RPMI 2650",
    "CAGE:teratocarcinoma cell line:PA-1",
    "CAGE:hereditary spherocytic anemia cell line:WIL2-NS",
    "CAGE:Wilms' tumor cell line:G-401",
    "CAGE:adrenal cortex adenocarcinoma cell line:SW-13",
    "CAGE:normal embryonic palatal mesenchymal cell line:HEPM",
    "CAGE:Gingival epithelial cells,  (GEA14)",
    "CAGE:Gingival epithelial cells,  (GEA15)",
    "CAGE:Smooth Muscle Cells - Prostate,",
    "CAGE:Smooth Muscle Cells - Uterine,",
    "CAGE:Endothelial Cells - Thoracic,",
    "CAGE:clear cell carcinoma cell line:TEN",
    "CAGE:bone marrow stromal cell line:StromaNKtert",
    "CAGE:basal cell carcinoma cell line:TE 354.T",
    "CAGE:pleomorphic hepatocellular carcinoma cell line:SNU-387",
    "CAGE:myelodysplastic syndrome cell line:SKM-1",
    "CAGE:lymphoma, malignant, hairy B-cell cell line:MLMA",
    "CAGE:breast carcinoma cell line:MCF7",
    "CAGE:mixed mullerian tumor cell line:HTMMT",
    "CAGE:meningioma cell line:HKBMM",
    "CAGE:Whole blood (ribopure), , donation3",
    "CAGE:normal intestinal epithelial cell line:FHs 74 Int",
    "CAGE:Fibroblast - Gingival,  (GFH3)",
    "CAGE:Fibroblast - Periodontal Ligament,  (PL30)",
    "CAGE:Prostate Epithelial Cells,",
    "CAGE:Endothelial Cells - Artery,",
    "CAGE:Hair Follicle Dermal Papilla Cells,",
    "CAGE:Fibroblast - Periodontal Ligament,  (PLH3)",
    "CAGE:Dendritic Cells - monocyte immature derived,",
    "CAGE:Preadipocyte - perirenal,",
    "CAGE:Adipocyte - perirenal,",
    "CAGE:Schwann Cells,",
    "CAGE:Renal Glomerular Endothelial Cells,",
    "CAGE:Hepatic Sinusoidal Endothelial Cells,",
    "CAGE:CD19+ B Cells (pluriselect), , donation2",
    "CAGE:CD8+ T Cells (pluriselect), , donation1",
    "CAGE:CD19+ B Cells (pluriselect), , donation1",
    "CAGE:CD8+ T Cells (pluriselect), , donation2",
    "CAGE:CD8+ T Cells (pluriselect), , donation3",
    "CAGE:CD19+ B Cells (pluriselect), , donation3",
    "CAGE:mesodermal tumor cell line:HIRS-BM",
    "CAGE:leiomyosarcoma cell line:Hs 5.T",
    "CAGE:non-small cell lung cancer cell line:NCI-H1385",
    "CAGE:CD34+ Progenitors,",
    "CAGE:spinal cord, adult,",
    "CAGE:pineal gland, adult,",
    "CAGE:pituitary gland, adult,",
    "CAGE:medial frontal gyrus, adult,",
    "CAGE:amygdala, adult,",
    "CAGE:hippocampus, adult,",
    "CAGE:thalamus, adult,",
    "CAGE:medulla oblongata, adult,",
    "CAGE:medial temporal gyrus, adult,",
    "CAGE:parietal lobe, adult,",
    "CAGE:substantia nigra, adult,",
    "CAGE:globus pallidus, adult,",
    "CAGE:occipital cortex, adult,",
    "CAGE:caudate nucleus, adult,",
    "CAGE:locus coeruleus, adult,",
    "CAGE:cerebellum, adult,",
    "CAGE:putamen, adult,",
    "CAGE:epitheloid carcinoma cell line: HelaS3 ENCODE, biol_",
    "CAGE:hepatocellular carcinoma cell line: HepG2 ENCODE, biol_",
    "CAGE:B lymphoblastoid cell line: GM12878 ENCODE, biol_",
    "CAGE:chronic myelogenous leukemia cell line:K562 ENCODE, biol_",
    "CAGE:Neurons,",
    "CAGE:Hair Follicle Outer Root Sheath Cells,",
    "CAGE:Hepatocyte,",
    "CAGE:Cardiac Myocyte,",
    "CAGE:Lens Epithelial Cells,",
    "CAGE:CD19+ B Cells,",
    "CAGE:Melanocyte - dark,",
    "CAGE:testicular germ cell embryonal carcinoma cell line:NEC14",
    "CAGE:testicular germ cell embryonal carcinoma cell line:NEC15",
    "CAGE:mesenchymal precursor cell - adipose,",
    "CAGE:mesenchymal precursor cell - bone marrow,",
    "CAGE:mesenchymal precursor cell - cardiac,",
    "CAGE:mesenchymal precursor cell - ovarian cancer left ovary,",
    "CAGE:mesenchymal precursor cell - ovarian cancer right ovary,",
    "CAGE:mesenchymal precursor cell - ovarian cancer metastasis,",
    "CAGE:mesenchymal precursor cell - ovarian cancer right ovary,  (SOC-57-02)",
    "CAGE:amniotic membrane cells,",
    "CAGE:chorionic membrane cells,",
    "CAGE:Mesenchymal stem cells - umbilical,",
    "CAGE:Fibroblast - Periodontal Ligament,  (PL29)",
    "CAGE:common myeloid progenitor CMP,",
    "CAGE:granulocyte macrophage progenitor,",
    "CAGE:promyelocytes/myelocytes PMC,",
    "CAGE:neutrophil PMN,",
    "CAGE:Mallassez-derived cells,  (MZH3)",
    "CAGE:CD133+ stem cells - cord blood derived, pool1",
    "CAGE:Basophils,",
    "CAGE:Eosinophils,",
    "CAGE:CD133+ stem cells - adult bone marrow derived, pool1",
    "CAGE:CD34+ stem cells - adult bone marrow derived, , tech_",
    "CAGE:nasal epithelial cells, , tech_",
    "CAGE:mature adipocyte,",
    "CAGE:Mast cell,",
    "CAGE:Smooth Muscle Cells - Umbilical Vein,",
    "CAGE:nasal epithelial cells,",
    "CAGE:Oligodendrocyte - precursors,",
    "CAGE:Perineurial Cells,",
    "CAGE:Smooth Muscle Cells - Intestinal,",
    "CAGE:Iris Pigment Epithelial Cells,",
    "CAGE:diencephalon, adult",
    "CAGE:olfactory region, adult",
    "CAGE:tenocyte,",
    "CAGE:medulloblastoma cell line:D283 Med",
    "CAGE:large cell lung carcinoma cell line:NCI-H460",
    "CAGE:plasma cell leukemia cell line:ARH-77",
    "CAGE:small cell lung carcinoma cell line:DMS 144",
    "CAGE:small cell lung carcinoma cell line:NCI-H82",
    "CAGE:salivary acinar cells,",
    "CAGE:merkel cell carcinoma cell line:MKL-1",
    "CAGE:merkel cell carcinoma cell line:MS-1",
    "CAGE:cerebral meninges, adult",
    "CAGE:appendix, adult",
    "CAGE:artery, adult",
    "CAGE:vein, adult",
    "CAGE:bone marrow, adult",
    "CAGE:ductus deferens, adult",
    "CAGE:epididymis, adult",
    "CAGE:gall bladder, adult",
    "CAGE:parotid gland, adult",
    "CAGE:penis, adult",
    "CAGE:seminal vesicle, adult",
    "CAGE:submaxillary gland, adult",
    "CAGE:tongue, adult",
    "CAGE:vagina, adult",
    "CAGE:heart - mitral valve, adult",
    "CAGE:heart - pulmonic valve, adult",
    "CAGE:heart - tricuspid valve, adult",
    "CAGE:throat, adult",
    "CAGE:Smooth Muscle Cells - Bladder,",
    "CAGE:testis, adult, pool2",
    "CAGE:acute myeloid leukemia (FAB M7) cell line:M-MOK",
    "CAGE:acute myeloid leukemia (FAB M5) cell line:NOMO-1",
    "CAGE:acute myeloid leukemia (FAB M5) cell line:P31/FUJ",
    "CAGE:acute myeloid leukemia (FAB M2) cell line:Kasumi-6",
    "CAGE:acute myeloid leukemia (FAB M0) cell line:KG-1",
    "CAGE:acute myeloid leukemia (FAB M1) cell line:HYT-1",
    "CAGE:acute myeloid leukemia (FAB M3) cell line:HL60",
    "CAGE:acute myeloid leukemia (FAB M4eo) cell line:EoL-1",
    "CAGE:acute myeloid leukemia (FAB M4eo) cell line:EoL-3",
    "CAGE:acute myeloid leukemia (FAB M5) cell line:U-937 DE-4",
    "CAGE:acute myeloid leukemia (FAB M6) cell line:EEB",
    "CAGE:acute myeloid leukemia (FAB M6) cell line:F-36E",
    "CAGE:mesothelioma cell line:NCI-H28",
    "CAGE:mesothelioma cell line:NCI-H226",
    "CAGE:mesothelioma cell line:NCI-H2052",
    "CAGE:mesothelioma cell line:NCI-H2452",
    "CAGE:mesothelioma cell line:Mero-14, tech_",
    "CAGE:mesothelioma cell line:Mero-25",
    "CAGE:mesothelioma cell line:Mero-41",
    "CAGE:mesothelioma cell line:Mero-48a",
    "CAGE:mesothelioma cell line:Mero-82",
    "CAGE:mesothelioma cell line:Mero-83",
    "CAGE:mesothelioma cell line:Mero-84",
    "CAGE:mesothelioma cell line:Mero-95",
    "CAGE:mesothelioma cell line:No36",
    "CAGE:mesothelioma cell line:ONE58",
    "CAGE:serous adenocarcinoma cell line:SK-OV-3-R, biol_",
    "CAGE:CD4+CD25+CD45RA- memory regulatory T cells,",
    "CAGE:CD4+CD25-CD45RA+ naive conventional T cells expanded,",
    "CAGE:CD4+CD25+CD45RA+ naive regulatory T cells expanded,",
    "CAGE:CD4+CD25+CD45RA- memory regulatory T cells expanded,",
    "CAGE:CD4+CD25-CD45RA+ naive conventional T cells,",
    "CAGE:CD14-CD16+ Monocytes,",
    "CAGE:CD14+CD16+ Monocytes,",
    "CAGE:CD4+CD25-CD45RA- memory conventional T cells expanded,",
    "CAGE:CD14+CD16- Monocytes,",
    "CAGE:CD4+CD25+CD45RA+ naive regulatory T cells,",
    "CAGE:CD4+CD25-CD45RA- memory conventional T cells,",
    "CAGE:acute myeloid leukemia (FAB M0) cell line:Kasumi-3",
    "CAGE:achilles tendon,",
    "CAGE:cerebrospinal fluid,",
    "CAGE:cruciate ligament,",
    "CAGE:eye - vitreous humor,",
    "CAGE:eye - muscle superior,",
    "CAGE:eye - muscle lateral,",
    "CAGE:eye - muscle medial,",
    "CAGE:eye - muscle inferior rectus,",
    "CAGE:Fingernail (including nail plate, eponychium and hyponychium),",
    "CAGE:optic nerve,",
    "CAGE:skeletal muscle - soleus muscle,",
    "CAGE:Skin - palm,",
    "CAGE:tongue epidermis (fungiform papillae),",
    "CAGE:Urethra,",
    "CAGE:CD14+ monocytes - treated with BCG,",
    "CAGE:CD14+ monocytes - treated with IFN + N-hexane,",
    "CAGE:CD14+ monocytes - treated with Trehalose dimycolate (TDM),",
    "CAGE:CD14+ monocytes - mock treated,",
    "CAGE:CD14+ monocytes - treated with Group A streptococci,",
    "CAGE:CD14+ monocytes - treated with lipopolysaccharide,",
    "CAGE:CD14+ monocytes - treated with Salmonella,",
    "CAGE:CD14+ monocytes - treated with Cryptococcus,",
    "CAGE:CD14+ monocytes - treated with Candida,",
    "CAGE:CD14+ monocytes - treated with B-glucan,",
    "CAGE:Hep-2 cells treated with Streptococci strain 5448, biol_",
    "CAGE:Hep-2 cells treated with Streptococci strain JRS4, biol_",
    "CAGE:Hep-2 cells mock treated, biol_",
    "CAGE:immature langerhans cells,",
    "CAGE:acute myeloid leukemia (FAB M2) cell line:Kasumi-1",
    "CAGE:acute myeloid leukemia (FAB M4) cell line:FKH-1",
    "CAGE:acute myeloid leukemia (FAB M4) cell line:HNT-34",
    "CAGE:acute myeloid leukemia (FAB M6) cell line:F-36P",
    "CAGE:mesenchymal precursor cell - ovarian cancer right ovary,  (SOC-57-02-G)",
    "CAGE:serous adenocarcinoma cell line:SK-OV-3-R after co-culture with SOC-57-02-G, biol_",
    "CAGE:migratory langerhans cells,",
    "CAGE:Mallassez-derived cells,",
    "CAGE:CD34 cells differentiated to erythrocyte lineage, biol_",
    "CAGE:amygdala - adult,",
    "CAGE:thalamus - adult,",
    "CAGE:hippocampus - adult,",
    "CAGE:medial frontal gyrus - adult,",
    "CAGE:parietal lobe - adult,",
    "CAGE:occipital cortex - adult,",
    "CAGE:cerebellum - adult,",
    "CAGE:medulla oblongata - adult,",
    "CAGE:globus pallidus - adult,",
    "CAGE:caudate nucleus - adult,",
    "CAGE:substantia nigra - adult,",
    "CAGE:pineal gland - adult,",
    "CAGE:pituitary gland - adult,",
    "CAGE:spinal cord - adult,",
    "CAGE:locus coeruleus - adult,",
    "CAGE:medial temporal gyrus - adult,",
    "CAGE:Olfactory epithelial cells,",
    "CAGE:gamma delta positive T cells,",
    "CAGE:Mast cell, expanded,",
    "CAGE:Mast cell, expanded and stimulated,",
    "CAGE:adipose,",
    "CAGE:medial frontal gyrus, newborn,",
    "CAGE:medial temporal gyrus, newborn,",
    "CAGE:caudate nucleus, newborn,",
    "CAGE:occipital cortex, newborn,",
    "CAGE:parietal lobe, newborn,",
    "CAGE:cerebellum, newborn,",
    "CAGE:substantia nigra, newborn,",
    "CAGE:spinal cord, newborn,",
    "CAGE:amygdala, newborn,",
    "CAGE:medulla oblongata, newborn,",
    "CAGE:locus coeruleus, newborn,",
    "CAGE:hippocampus, newborn,",
    "CAGE:globus pallidus, newborn,",
    "CAGE:putamen, newborn,",
    "CAGE:thalamus, newborn,",
    "CAGE:Fibroblast - Gingival,  (aggressive periodontitis)",
    "CAGE:Fibroblast - Gingival,  (control)",
    "CAGE:Fibroblast - Gingival,  (chronic periodontitis)",
    "CAGE:Fibroblast - Gingival,  (periodontitis)",
    "CAGE:bronchioalveolar carcinoma cell line:NCI-H650",
    "CAGE:thymic carcinoma cell line:Ty-82",
    "CAGE:thyroid carcinoma cell line:KHM-5M",
    "CAGE:Smooth muscle cells - airway, asthmatic,",
    "CAGE:Smooth muscle cells - airway, control,",
    "CAGE:thalamus, adult, , tech_",
    "CAGE:putamen, adult, , tech_",
    "CAGE:parietal cortex, adult,",
    "CAGE:medial temporal gyrus, adult, , tech_",
    "CAGE:squamous cell lung carcinoma cell line:LC-1F",
    "CAGE:epithelioid sarcoma cell line:HS-ES-2R",
    "CAGE:squamous cell lung carcinoma cell line:RERF-LC-AI",
    "CAGE:gastric cancer cell line:GSS",
    "CAGE:carcinoid cell line:NCI-H727",
    "CAGE:lung adenocarcinoma, papillary cell line:NCI-H441",
]

assert len(ENFORMER_TASKS_) == 5313, len(ENFORMER_TASKS_)


def _muscle():
    return [t for t in ENFORMER_TASKS_ 
            if ('muscle' in t or 'myocyte' in t) and 
            not ('smooth' in t or 'cardiac' in t or 'Smooth' in t)]
    
    
def _liver():
    return [t for t in ENFORMER_TASKS_  if 'liver' in t or 'hepatocyte' in t]
    
    
def _activate():
    return [t for t in ENFORMER_TASKS_  if 
            ('CAGE' in t or 'H3K27ac' in t or 'DNASE' in t or 'DHS' in t or 'ATAC' in t) and 
            not ('H3K9me' in t or 'H3K27me' in t)]
    
    
def _deactivate():
    return [t for t in ENFORMER_TASKS_  if 
            ('H3K9me' in t or 'H3K27me' in t) and
            not ('CAGE' in t or 'H3K27ac' in t or 'DNASE' in t or 'DHS' in t or 'ATAC' in t)]

def activate_muscle():
    return [t for t in _muscle() if t in _activate()]


def muscle_CAGE():
    return [t for t in _muscle() if 'CAGE' in t]


def muscle_DNASE():
    return [t for t in _muscle() if 'DNASE' in t]


def deactivate_muscle():
    return [t for t in _muscle() if t in _deactivate()]


def activate_liver():
    return [t for t in _liver() if t in _activate()]


def deactivate_liver():
    return [t for t in _liver() if t in _deactivate()]


def activate_muscle_idx():
    return [ENFORMER_TASKS_.index(t) for t in activate_muscle()]


def deactivate_muscle_idx():
    return [ENFORMER_TASKS_.index(t) for t in deactivate_muscle()]


def activate_liver_idx():
    return [ENFORMER_TASKS_.index(t) for t in activate_liver()]


def deactivate_liver_idx():
    return [ENFORMER_TASKS_.index(t) for t in deactivate_liver()]


def muscle_cage_idx():
    return [ENFORMER_TASKS_.index(t) for t in muscle_CAGE()]


def muscle_dnase_idx():
    return [ENFORMER_TASKS_.index(t) for t in muscle_DNASE()]


if __name__ == '__main__':
    print('Activate muscle: ')
    for t in activate_muscle():
        print(t)
    print('Deactivate muscle: ')
    for t in deactivate_muscle():
        print(t)
    print('Activate liver: ')
    for t in activate_liver():
        print(t)
    print('Deactivate liver: ')
    for t in deactivate_liver():
        print(t)
    print('Muscle CAGE: ')
    for t in muscle_CAGE():
        print(t)