"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFileSeeds = exports.InlineSeeds = exports.S3Seeds = exports.Seeds = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
class Seeds {
    /**
     * @param bucket The S3 bucket.
     * @param key The object key.
     * @param objectVersion Optional S3 object version.
     * @returns `S3Seeds` associated with the specified S3 object.
     */
    static fromBucket(bucket, key, objectVersion) {
        return new S3Seeds(bucket, key, objectVersion);
    }
    /**
     * @param seeds The actual json code (limited to 4KiB).
     * @returns `InlineSeeds` with inline seeds.
     */
    static fromInline(seeds) {
        return new InlineSeeds(JSON.stringify(seeds));
    }
    /**
     * Loads the seeds from a local disk path and uploads it to s3.
     *
     * @param path Path to json seeds file.
     * @returns `JsonFileSeeds` associated with the specified S3 object.
     */
    static fromJsonFile(path, options) {
        return new JsonFileSeeds(path, options);
    }
}
exports.Seeds = Seeds;
_a = JSII_RTTI_SYMBOL_1;
Seeds[_a] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.Seeds", version: "1.46.0" };
/**
 * Seeds from an S3 archive.
 */
class S3Seeds extends Seeds {
    constructor(bucket, key, objectVersion) {
        super();
        this.key = key;
        this.objectVersion = objectVersion;
        if (!bucket.bucketName) {
            throw new Error('BucketName is undefined for the provided bucket');
        }
        this.bucketName = bucket.bucketName;
    }
    /**
     * Called when the seeder is initialized to allow this object to bind to the stack.
     */
    bind(_scope) {
        return {
            s3Location: {
                bucketName: this.bucketName,
                objectKey: this.key,
                objectVersion: this.objectVersion,
            },
        };
    }
}
exports.S3Seeds = S3Seeds;
_b = JSII_RTTI_SYMBOL_1;
S3Seeds[_b] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.S3Seeds", version: "1.46.0" };
/**
 * Seeds from an inline json object (limited to 4KiB).
 */
class InlineSeeds extends Seeds {
    constructor(seeds) {
        super();
        this.seeds = seeds;
        if (seeds.length === 0) {
            throw new Error('Inline seeds cannot be empty');
        }
        if (seeds.length > 4096) {
            throw new Error(`Inline seeds are too large, must be <= 4096 but is ${seeds.length}`);
        }
    }
    /**
     * Called when the seeder is initialized to allow this object to bind to the stack.
     */
    bind(_scope) {
        return {
            inlineSeeds: this.seeds,
        };
    }
}
exports.InlineSeeds = InlineSeeds;
_c = JSII_RTTI_SYMBOL_1;
InlineSeeds[_c] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.InlineSeeds", version: "1.46.0" };
/**
 * Seeds from a local json file.
 */
class JsonFileSeeds extends Seeds {
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
    }
    /**
     * Called when the seeder is initialized to allow this object to bind to the stack.
     */
    bind(scope) {
        // If the same JsonFileSeeds is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new aws_s3_assets_1.Asset(scope, 'JsonFileSeeds', {
                path: this.path,
                ...this.options,
            });
        }
        try {
            JSON.parse(fs.readFileSync(this.path, 'utf-8'));
        }
        catch (e) {
            throw new Error('Could not convert file to JSON');
        }
        return {
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
}
exports.JsonFileSeeds = JsonFileSeeds;
_d = JSII_RTTI_SYMBOL_1;
JsonFileSeeds[_d] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.JsonFileSeeds", version: "1.46.0" };
//# sourceMappingURL=data:application/json;base64,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