"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const explanationDashboard_1 = require("./explanationDashboard");
const base_1 = require("@jupyter-widgets/base");
const EXTENSION_ID = 'interpret-ml-widget:plugin';
const explanationDashboardPlugin = {
    id: EXTENSION_ID,
    requires: [base_1.IJupyterWidgetRegistry],
    activate: activateWidgetExtension,
    autoStart: true
};
exports.default = explanationDashboardPlugin;
const data = require('../package.json');
/**
 * Activate the widget extension.
 */
function activateWidgetExtension(app, registry) {
    registry.registerWidget({
        name: 'interpret-text-widget',
        version: data.version,
        exports: {
            ExplanationModel: explanationDashboard_1.ExplanationModel,
            ExplanationView: explanationDashboard_1.ExplanationView
        }
    });
}
//# sourceMappingURL=labplugin.js.map