# -*- coding: utf-8 -*-
# Generated by Django 1.11.24 on 2019-10-11 10:55
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_like', '0001_initial'),
        ('djangoldp_conversation', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BrokenLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('code', models.CharField(max_length=2, verbose_name='ISO Code')),
                ('name', models.CharField(max_length=64, verbose_name='Country name')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Entrepreneur',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Field',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Title')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Format',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Title')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('code', models.CharField(max_length=2, verbose_name='ISO Code')),
                ('name', models.CharField(max_length=64, verbose_name='Language name')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Mentor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('phone', models.CharField(blank=True, max_length=25, null=True, verbose_name='Phone number')),
                ('headline', models.CharField(blank=True, max_length=256, verbose_name='Headline or current position')),
                ('city', models.CharField(blank=True, max_length=256, verbose_name='City')),
                ('biography', models.TextField(blank=True, verbose_name='Tell us more about your activities')),
                ('skills', models.TextField(blank=True, verbose_name='What skills can you share with our entrepreneurs ?')),
                ('linkedin', models.CharField(blank=True, max_length=256, null=True, verbose_name='Linkedin account')),
                ('twitter', models.CharField(blank=True, max_length=256, null=True, verbose_name='Twitter account')),
                ('registered_on', models.DateTimeField(default=django.utils.timezone.now)),
                ('country', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mentors', to='coopstarter_data.Country')),
                ('fields', models.ManyToManyField(blank=True, to='coopstarter_data.Field')),
                ('languages', models.ManyToManyField(blank=True, to='coopstarter_data.Language')),
            ],
        ),
        migrations.CreateModel(
            name='Organisation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('website', models.CharField(max_length=4096, verbose_name='Website')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('validated', 'Validated')], default='pending', max_length=32, verbose_name='Status')),
                ('skills', models.TextField(verbose_name='Learning outcomes/skills')),
                ('target', models.CharField(blank=True, choices=[('mentor', 'Mentor'), ('entrepreneur', 'Entrepreneur'), ('public', 'Public')], max_length=32, null=True, verbose_name='Target audience')),
                ('created_on', models.DateTimeField(default=django.utils.timezone.now)),
                ('country', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='coopstarter_data.Country')),
                ('fields', models.ManyToManyField(blank=True, to='coopstarter_data.Field')),
                ('language', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to='coopstarter_data.Language', verbose_name='Language')),
                ('organisation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='requests', to='coopstarter_data.Organisation')),
                ('reviewer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reviewed_requests', to=settings.AUTH_USER_MODEL)),
                ('submitter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='requests', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-created_on'],
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Title')),
                ('publication_year', models.IntegerField(verbose_name='Publication Year')),
                ('uri', models.CharField(max_length=4086, verbose_name='Location/weblink')),
                ('author', models.CharField(max_length=32, verbose_name='Author')),
                ('skills', models.TextField(verbose_name='Learning outcomes/skills')),
                ('description', models.TextField(null=True, verbose_name='Description')),
                ('iframe_link', models.TextField(blank=True, null=True, verbose_name='Iframe link')),
                ('preview_image', models.URLField(blank=True, null=True)),
                ('target', models.CharField(blank=True, choices=[('mentor', 'Mentor'), ('entrepreneur', 'Entrepreneur'), ('public', 'Public')], max_length=32, null=True, verbose_name='Target audience')),
                ('sharing', models.CharField(blank=True, choices=[('private', 'Private (nobody)'), ('public', 'Public (everybody)')], max_length=32, null=True, verbose_name='Sharing profile')),
                ('conversations', models.ManyToManyField(blank=True, related_name='resources', to='djangoldp_conversation.Conversation')),
                ('country', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='coopstarter_data.Country')),
                ('fields', models.ManyToManyField(blank=True, related_name='resources', to='coopstarter_data.Field')),
                ('format', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resources', to='coopstarter_data.Format')),
                ('language', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='resources', to='coopstarter_data.Language', verbose_name='Language')),
                ('likes', models.ManyToManyField(blank=True, related_name='resources', to='djangoldp_like.Like')),
                ('related', models.ManyToManyField(blank=True, related_name='_resource_related_+', to='coopstarter_data.Resource')),
            ],
        ),
        migrations.CreateModel(
            name='Review',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('status', models.CharField(blank=True, choices=[('pending', 'Pending'), ('inappropriate', 'Inappropriate'), ('validated', 'Validated'), ('to_improve', 'Improvement required')], max_length=32, null=True, verbose_name='Resource status')),
                ('reviewer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reviews', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Step',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('order', models.IntegerField(blank=True, default=0, null=True, verbose_name='Order')),
            ],
        ),
        migrations.CreateModel(
            name='Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=128, verbose_name='Title')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.AddField(
            model_name='resource',
            name='review',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resource', to='coopstarter_data.Review', verbose_name='Associated review'),
        ),
        migrations.AddField(
            model_name='resource',
            name='steps',
            field=models.ManyToManyField(blank=True, related_name='resources', to='coopstarter_data.Step'),
        ),
        migrations.AddField(
            model_name='resource',
            name='submitter',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resources', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='resource',
            name='type',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='resources', to='coopstarter_data.Type', verbose_name='Type of content'),
        ),
        migrations.AddField(
            model_name='mentor',
            name='organisation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mentors', to='coopstarter_data.Organisation'),
        ),
        migrations.AddField(
            model_name='mentor',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='mentor_profile', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='entrepreneur',
            name='organisation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='entrepreneurs', to='coopstarter_data.Organisation'),
        ),
        migrations.AddField(
            model_name='entrepreneur',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='entrepreneur_profile', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='brokenlink',
            name='resource',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='brokenlink_resource', to='coopstarter_data.Resource'),
        ),
        migrations.AddField(
            model_name='brokenlink',
            name='submitter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='brokenlink_submitter', to=settings.AUTH_USER_MODEL),
        ),
    ]
