import datetime


def str2datetime(str_date):
    str_date = str(str_date)
    if len(str_date) == 8:
        return datetime.datetime.strptime(str_date, '%Y%m%d')
    if len(str_date) == 10:
        return datetime.datetime.strptime(str_date, '%Y-%m-%d')
    elif len(str_date) == 19:
        return datetime.datetime.strptime(str_date, '%Y-%m-%d %H:%M:%S')
    elif len(str_date) == 26:
        return datetime.datetime.strptime(str_date, '%Y-%m-%dT%H:%M:%S.%f')
    elif len(str_date) == 28:
        str_date = str_date.split('+')[0]
        return datetime.datetime.strptime(str_date, '%Y-%m-%dT%H:%M:%S.%f')
    elif len(str_date) == 14:
        return datetime.datetime.strptime(str_date, '%Y%m%d%H%M%S')
    elif len(str_date) == 8:
        return datetime.datetime.strptime(str_date, '%Y%m%d')



def get_date_length(start_str, end_str):
    """
    获取当前日期到start的日期长度
    :param start_str:
    :return:
    """
    # end = datetime.datetime.now()
    length = str2datetime(start_str) - str2datetime(end_str)
    length = abs(length.days)+1
    return length



def get_date_min_length(start_str, end_str, freq):
    # print(start_str, end_str, freq)
    length = str2datetime(start_str) - str2datetime(end_str)
    length = abs(length.days)+1
    if freq in ['1m','1Min','1min','1Minute','1minute']:
        return length * (240+1)
    if freq in ['5m','5Min','5min','5Minute','5minute']:
        return length * (48+2)
    elif freq in ['15m','15Min','15min','15Minute','15minute']:
        return length * (16+2)
    elif freq in ['30m','30Min','30min','30Minute','30minute']:
        return length * (8+2)
    elif freq in ['60m','60Min','60min','60Minute','60minute']:
        return length * (4+1)
    else:
        return length * 240



def is_trading_day(date):
    china_holidays_2020 = [
        '2016-01-01', '2016-01-02', '2016-01-03',  # 元旦
        '2016-02-07', '2016-02-08', '2016-02-09', '2016-02-10', '2016-02-11', '2016-02-12', '2016-02-13',  # 春节
        '2016-04-02', '2016-04-03', '2016-04-04',  # 清明节
        '2016-04-30', '2016-05-01', '2016-05-02',  # 劳动节
        '2016-06-09', '2016-06-10', '2016-06-11', '2016-06-12',  # 端午节
        '2016-09-15', '2016-09-16', '2016-09-17', '2016-09-18',  # 中秋节
        '2016-10-01', '2016-10-02', '2016-10-03', '2016-10-04', '2016-10-05', '2016-10-06', '2016-10-07', '2016-10-08',
        # 国庆节 中秋节

        '2017-01-01', '2017-01-02',  # 元旦
        '2017-01-27', '2017-01-28', '2017-01-29', '2017-01-30', '2017-01-31', '2017-02-01', '2017-02-02',  # 春节
        '2017-04-02', '2017-04-03', '2017-04-04',  # 清明节
        '2017-04-29', '2017-04-30', '2017-05-01',  # 劳动节
        '2017-05-28', '2017-05-29', '2017-05-30',  # 端午节
        '2017-10-01', '2017-10-02', '2017-10-03', '2017-10-04', '2017-10-05', '2017-10-06', '2017-10-07', '2017-10-08',
        # 国庆节 中秋节

        '2018-01-01',  # 元旦
        '2018-02-15', '2018-02-16', '2018-02-17', '2018-02-18', '2018-02-19', '2018-02-20', '2018-02-21',  # 春节
        '2018-04-05', '2018-04-06', '2018-04-07',  # 清明节
        '2018-04-29', '2018-04-30', '2018-05-01',  # 劳动节
        '2018-06-16', '2018-06-17', '2018-06-18',  # 端午节
        '2018-09-22', '2018-09-23', '2018-09-24',  # 中秋节
        '2018-10-01', '2018-10-02', '2018-10-03', '2018-10-04', '2018-10-05', '2018-10-06', '2018-10-07',  # 国庆节
        '2018-12-30', '2018-12-31',

        '2019-01-01',  # 元旦
        '2019-02-04', '2019-02-05', '2019-02-06', '2019-02-07', '2019-02-08', '2019-02-09', '2019-02-10',  # 春节
        '2019-04-05', '2019-04-06', '2019-04-07',  # 清明节
        '2019-05-01', '2019-05-02', '2019-05-03', '2019-05-04',  # 劳动节
        '2019-06-07', '2019-06-08', '2019-06-09',  # 端午节
        '2019-09-13', '2019-09-14', '2019-09-15',  # 中秋节
        '2019-10-01', '2019-10-02', '2019-10-03', '2019-10-04', '2019-10-05', '2019-10-06', '2019-10-07',  # 国庆节

        '2020-01-01',  # 元旦
        '2020-01-24', '2020-01-25', '2020-01-26', '2020-01-27', '2020-01-28', '2020-01-29', '2020-01-30', '2020-01-31',  # 春节
        '2020-04-04', '2020-04-05', '2020-04-06',  # 清明节
        '2020-05-01', '2020-05-02', '2020-05-03', '2020-05-04', '2020-05-05',  # 劳动节
        '2020-06-25', '2020-06-26', '2020-06-27',  # 端午节
        '2020-10-01', '2020-10-02', '2020-10-03', '2020-10-04', '2020-10-05', '2020-10-06', '2020-10-07', '2020-10-08',  # 国庆节

        '2021-01-01',  # 元旦
        '2021-02-11', '2021-02-12', '2021-02-13', '2021-02-14', '2021-02-15', '2021-02-16', '2021-02-17', # 春节
        '2021-04-03', '2021-04-04', '2021-04-05',  # 清明节
        '2021-05-01', '2021-05-02', '2021-05-03', '2021-05-04', '2021-05-05',  # 劳动节
        '2021-06-12', '2021-06-13', '2021-06-14',  # 端午节
        '2021-09-19', '2021-09-20', '2021-09-21',  # 中秋节
        '2021-10-01', '2021-10-02', '2021-10-03', '2021-10-04', '2021-10-05', '2021-10-06', '2021-10-07', # 国庆节
    ]

    weekday_ = date.weekday()
    if weekday_ == 5:
        return False
    if weekday_ == 6:
        return False

    str_date = str(date)[:10]
    if str_date in china_holidays_2020:
        return False
    else:
        return True



if __name__ == '__main__':
    date1 = str2datetime('2020-05-20')
    print(date1)
    print(type(date1))
