# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/09_generative_models.generative_base.ipynb (unless otherwise specified).

__all__ = ['GenerativeModel', 'beam_search']

# Cell

from ..imports import *
from ..torch_imports import *
from ..torch_core import *
from ..layers import *

# Cell

class GenerativeModel(nn.Module):
    '''
    GenerativeModel - base generative model class
    '''
    def __init__(self):
        super().__init__()

    def forward(self, x):
        raise NotImplementedError

    def x_to_latent(self, x):
        '''
        x_to_latent - convert `x` to a latent vector

        Inputs:

        - `x`: `x` comes from a Dataloader. The specific
        form of `x` depends on the dataloader used

        Returns:

        If the model in question makes use of latent vectors
        for sampling or reconstruction, the function should
        return a batch of latent vectors. If latent vectors
        are not compatible, the function should return None

        '''
        raise NotImplementedError

    def sample(self, **sample_kwargs):
        '''
        sample - sample items from tthe model
        '''
        raise NotImplementedError

    def sample_no_grad(self, **sample_kwargs):
        'no grad wrapper for sample'
        with torch.no_grad():
            return self.sample(**sample_kwargs)

    def get_rl_tensors(self):
        '''
        get_rl_tensors - generate tensors needed in the training loop
        '''
        raise NotImplementedError

# Cell

def beam_search(model, seed_ints, k, beam_size, sl, temperature, pad_idx=None):
    '''
    beam_search - perform beam search using `model`

    Inputs:

    - `model nn.Module`: model

    - `seed_ints torch.Longtensor`: seed sequence

    - `k int`: top k beam sampling

    - `beam_size int`: maximum number of beams to retain

    - `sl int`: max sequence length

    - `temperature float`: sample temperature

    - `pad_idx Optional[int]`: pad index if applicable
    '''

    # currently only works for LSTM_LM. TODO: work for all generative models

    current_device = next(model.parameters()).device

    if seed_ints.ndim==1:
        seed_ints = seed_ints.unsqueeze(0)

    preds = seed_ints.repeat(k,1)
    preds = to_device(preds, current_device)
    idxs = preds[:,-1].unsqueeze(-1)
    lps = idxs.new_zeros((k, 1)).float()

    with torch.no_grad():
        for i in range(sl):
            x, hiddens, encoded = model._forward(idxs, hiddens)
            x.div_(temperature)
            log_probs = F.log_softmax(x, -1)
            values, indices = log_probs.topk(k, dim=-1)

            lps = torch.cat([lps.unsqueeze(-1).repeat(1,1,values.shape[-1]), -values], 1)
            current_sl = lps.shape[1]
            lps = lps.permute(0,2,1).reshape(-1,current_sl)

            preds = torch.cat([preds[:,None].expand(preds.size(0), k , preds.size(1)),
                    indices.squeeze(1)[:,:,None].expand(preds.size(0), k, 1),], dim=2)

            preds = preds.view(-1, preds.size(2))

            scores = lps.sum(-1)
            indices_idx = torch.arange(0,preds.size(0))[:,None].expand(preds.size(0), k).contiguous().view(-1)
            sort_idx = scores.argsort()[:beam_size]

            preds = preds[sort_idx]
            lps = lps[sort_idx]

            idxs = preds[:,-1].unsqueeze(-1)
            hiddens = [(i[0][:, indices_idx[sort_idx], :],
                        i[1][:, indices_idx[sort_idx], :]) for i in hiddens]

            if pad_idx is not None:
                if (preds[:,-1]==pad_idx).all():
                    break


    return preds, -lps