/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import log.ArtifactManager;
import log.ArtifactManagerFactory;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.CommandLineExecutorKt;
import utils.Killer;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u001a\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a]\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0018\u001a<\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001a\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"logger", "Llog/Logger;", "catchInterrupt", "", "f", "Lkotlin/Function0;", "cleanUpProcess", "p", "Ljava/lang/Process;", "noInterrupt", "safeCommandArrayExecLines", "Lkotlin/Pair;", "", "", "", "cmd", "", "outputName", "readStandardOutput", "", "checkExitCode", "timeoutSecs", "", "input", "([Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/Long;Ljava/lang/String;)Lkotlin/Pair;", "safeCommandExec", "outName", "Shared"})
public final class CommandLineExecutorKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.COMMON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Pair<Integer, List<String>> safeCommandArrayExecLines(@NotNull String[] cmd, @NotNull String outputName, boolean readStandardOutput, boolean checkExitCode, @Nullable Long timeoutSecs, @Nullable String input) {
        List<Object> list2;
        boolean bl;
        List<String> list3;
        Object object;
        File e2;
        File file;
        Intrinsics.checkNotNullParameter(cmd, "cmd");
        Intrinsics.checkNotNullParameter(outputName, "outputName");
        boolean redirectStdoutStderr = readStandardOutput && ArtifactManagerFactory.INSTANCE.isEnabled();
        try {
            file = redirectStdoutStderr ? new File(ArtifactManager.Companion.getCmdErrorFilepath(outputName)) : null;
        }
        catch (IllegalStateException e2) {
            file = null;
        }
        File fileError = file;
        try {
            e2 = redirectStdoutStderr ? new File(ArtifactManager.Companion.getCmdOutputFilepath(outputName)) : null;
        }
        catch (IllegalStateException e3) {
            e2 = null;
        }
        File fileOutput = e2;
        boolean hasRedirects = fileError != null && fileOutput != null;
        String stringCommand = ArraysKt.joinToString$default(cmd, (CharSequence)" ", null, null, 0, null, null, 62, null);
        boolean bl2 = !redirectStdoutStderr || hasRedirects;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string2 = "If asked to redirect from stdout/stderr, must have path for output file";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (hasRedirects && redirectStdoutStderr) {
            Object writer2;
            File file2 = fileError;
            Intrinsics.checkNotNull(file2);
            Closeable closeable = new PrintWriter(file2);
            bl3 = false;
            bl4 = false;
            Throwable throwable = null;
            try {
                writer2 = (PrintWriter)closeable;
                boolean bl6 = false;
                ((PrintWriter)writer2).println(Intrinsics.stringPlus("stderr: ", stringCommand));
                writer2 = Unit.INSTANCE;
            }
            catch (Throwable writer2) {
                throwable = writer2;
                throw writer2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            File file3 = fileOutput;
            Intrinsics.checkNotNull(file3);
            closeable = new PrintWriter(file3);
            bl3 = false;
            boolean bl7 = false;
            Throwable throwable2 = null;
            try {
                writer2 = (PrintWriter)closeable;
                boolean bl8 = false;
                ((PrintWriter)writer2).println(Intrinsics.stringPlus("stdout: ", stringCommand));
                writer2 = Unit.INSTANCE;
            }
            catch (Throwable writer222) {
                throwable2 = writer222;
                throw writer222;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable2);
            }
        }
        logger.info((Function0<? extends Object>)new Function0<Object>(stringCommand){
            final /* synthetic */ String $stringCommand;
            {
                this.$stringCommand = $stringCommand;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Thread " + Thread.currentThread().getId() + ": Going to start " + this.$stringCommand;
            }
        });
        Object object2 = new ProcessBuilder(new String[0]).command(Arrays.copyOf(cmd, cmd.length));
        bl4 = false;
        boolean writer222 = false;
        ProcessBuilder it = object2;
        boolean bl9 = false;
        Process p = (redirectStdoutStderr ? it.redirectError(ProcessBuilder.Redirect.appendTo(fileError)).redirectOutput(ProcessBuilder.Redirect.appendTo(fileOutput)) : it).start();
        if (input != null) {
            object2 = p.getOutputStream();
            bl4 = false;
            writer222 = false;
            Throwable writer222 = null;
            try {
                OutputStream out = (OutputStream)object2;
                boolean bl10 = false;
                object = input;
                list3 = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue(list3, "defaultCharset()");
                bl = false;
                byte[] byArray = ((String)object).getBytes((Charset)((Object)list3));
                Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
                out.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                writer222 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, writer222);
            }
        }
        Thread.sleep(100L);
        Closeable closeable = p.getInputStream();
        Intrinsics.checkNotNullExpressionValue(closeable, "p.inputStream");
        Charset writer222 = Charsets.UTF_8;
        boolean bl11 = false;
        closeable = new InputStreamReader((InputStream)closeable, writer222);
        int writer222 = 8192;
        bl11 = false;
        BufferedReader bufferedOutputReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, writer222);
        int exitValue = 0;
        try {
            if (timeoutSecs != null) {
                p.waitFor(timeoutSecs, TimeUnit.SECONDS);
            } else {
                p.waitFor();
            }
        }
        catch (InterruptedException e4) {
            p.destroyForcibly();
        }
        finally {
            Intrinsics.checkNotNullExpressionValue(p, "p");
            CommandLineExecutorKt.cleanUpProcess(p);
            exitValue = p.exitValue();
        }
        if (checkExitCode && exitValue != 0) {
            String string3;
            String string4;
            Object object3;
            File file4 = fileError;
            if (file4 == null) {
                object3 = "?";
            } else {
                String string5 = file4.getPath();
                if (string5 == null) {
                    object3 = "?";
                } else {
                    list3 = string5;
                    bl = false;
                    boolean bl12 = false;
                    List<String> path = list3;
                    boolean bl13 = false;
                    object = TextStreamsKt.readText(new FileReader((String)((Object)path)));
                    object3 = object == null ? "?" : object;
                }
            }
            String errors2 = object3;
            file4 = fileError;
            StringBuilder stringBuilder = new StringBuilder().append("Failed to run command (").append(stringCommand).append("), exited with code ").append(exitValue).append(", see errors: ").append(file4 == null ? "N/A" : ((string4 = file4.getPath()) == null ? "N/A" : string4)).append(", output: ");
            file4 = fileOutput;
            throw new Exception(stringBuilder.append(file4 == null ? "N/A" : ((string3 = file4.getPath()) == null ? "N/A" : string3)).append(". Details: ").append(errors2).toString());
        }
        if (redirectStdoutStderr) {
            File file5 = fileOutput;
            Intrinsics.checkNotNull(file5);
            Closeable closeable2 = new FileReader(file5);
            boolean bl14 = false;
            boolean bl15 = false;
            object = null;
            try {
                FileReader reader = (FileReader)closeable2;
                boolean bl16 = false;
                list3 = TextStreamsKt.readLines(reader);
                list2 = list3;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable2, (Throwable)object);
            }
        } else {
            list2 = readStandardOutput ? TextStreamsKt.readLines(bufferedOutputReader) : CollectionsKt.emptyList();
        }
        List lineList = list2;
        return new Pair<Integer, List<String>>(exitValue, lineList);
    }

    public static /* synthetic */ Pair safeCommandArrayExecLines$default(String[] stringArray, String string2, boolean bl, boolean bl2, Long l, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return CommandLineExecutorKt.safeCommandArrayExecLines(stringArray, string2, bl, bl2, l, string3);
    }

    private static final void noInterrupt(Function0<Unit> f) {
        boolean again = false;
        do {
            try {
                f.invoke();
                again = false;
            }
            catch (InterruptedException e) {
                again = true;
                StackTraceElement loc = e.getStackTrace()[1];
                logger.warn((Function0<? extends Object>)new Function0<Object>(loc){
                    final /* synthetic */ StackTraceElement $loc;
                    {
                        this.$loc = $loc;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Thread " + Thread.currentThread().getId() + ": Got Interrupted exception during noInterrupt at " + this.$loc.getMethodName() + " in " + this.$loc.getFileName() + ':' + this.$loc.getLineNumber();
                    }
                });
            }
        } while (again);
    }

    private static final void catchInterrupt(Function0<Unit> f) {
        try {
            f.invoke();
        }
        catch (InterruptedException e) {
            StackTraceElement loc = e.getStackTrace()[1];
            logger.warn((Function0<? extends Object>)new Function0<Object>(loc){
                final /* synthetic */ StackTraceElement $loc;
                {
                    this.$loc = $loc;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Thread " + Thread.currentThread().getId() + ": Got Interrupted exception during catchInterrupt at " + this.$loc.getMethodName() + " in " + this.$loc.getFileName() + ':' + this.$loc.getLineNumber();
                }
            });
        }
    }

    private static final void cleanUpProcess(Process p) {
        try {
            if (!p.isAlive()) {
                logger.info((Function0<? extends Object>)new Function0<Object>(p){
                    final /* synthetic */ Process $p;
                    {
                        this.$p = $p;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Thread " + Thread.currentThread().getId() + ": Process " + this.$p.pid() + " was dead before cleanup";
                    }
                });
                CommandLineExecutorKt.noInterrupt(new Function0<Unit>(p){
                    final /* synthetic */ Process $p;
                    {
                        this.$p = $p;
                        super(0);
                    }

                    public final void invoke() {
                        this.$p.waitFor();
                    }
                });
                return;
            }
            ProcessHandle processHandle = p.toHandle();
            Intrinsics.checkNotNullExpressionValue(processHandle, "p.toHandle()");
            Killer killer = new Killer(processHandle);
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(killer){
                final /* synthetic */ Killer $killer;
                {
                    this.$killer = $killer;
                    super(0);
                }

                public final void invoke() {
                    this.$killer.destroyChilds();
                }
            });
            CommandLineExecutorKt.catchInterrupt(cleanUpProcess.4.INSTANCE);
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(killer){
                final /* synthetic */ Killer $killer;
                {
                    this.$killer = $killer;
                    super(0);
                }

                public final void invoke() {
                    this.$killer.destroyChildsForcibly();
                }
            });
            CommandLineExecutorKt.catchInterrupt(cleanUpProcess.6.INSTANCE);
            if (p.isAlive()) {
                logger.info((Function0<? extends Object>)new Function0<Object>(p){
                    final /* synthetic */ Process $p;
                    {
                        this.$p = $p;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Why does " + this.$p.pid() + " does not want to die?";
                    }
                });
            }
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(p){
                final /* synthetic */ Process $p;
                {
                    this.$p = $p;
                    super(0);
                }

                public final void invoke() {
                    this.$p.waitFor();
                }
            });
        }
        catch (Exception e) {
            logger.warn(e, cleanUpProcess.9.INSTANCE);
        }
    }

    @NotNull
    public static final Pair<Integer, String> safeCommandExec(@NotNull List<String> cmd, @NotNull String outName, boolean readStandardOutput, boolean checkExitCode) {
        Intrinsics.checkNotNullParameter(cmd, "cmd");
        Intrinsics.checkNotNullParameter(outName, "outName");
        Collection $this$toTypedArray$iv = cmd;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair res2 = CommandLineExecutorKt.safeCommandArrayExecLines$default(stringArray, outName, readStandardOutput, checkExitCode, null, null, 32, null);
        List lineList = (List)res2.getSecond();
        StringBuffer sb = new StringBuffer();
        Iterable $this$forEach$iv = lineList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String l = (String)element$iv;
            boolean bl = false;
            Appendable appendable = sb;
            boolean bl2 = false;
            Appendable appendable2 = appendable.append(l);
            Intrinsics.checkNotNullExpressionValue(appendable2, "append(value)");
            StringsKt.appendln(appendable2);
        }
        Object a = res2.getFirst();
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return new Pair<Integer, String>((Integer)a, string2);
    }

    public static /* synthetic */ Pair safeCommandExec$default(List list2, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return CommandLineExecutorKt.safeCommandExec(list2, string2, bl, bl2);
    }
}

