/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.StandardCVLErrorLogger;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLTupleType;
import spec.cvlast.CVLType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J(\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e\u00a8\u0006\u0014"}, d2={"Lspec/cvlast/CVLTypeConversions;", "", "()V", "convertToSameArithmeticType", "Lkotlin/Triple;", "Lspec/cvlast/CVLExp;", "", "lTypeChecked", "rTypeChecked", "convertToSameType", "convertTypeIfPossible", "Lspec/cvlast/CVLTypeConversions$TypeConversion;", "exp", "targetType", "Lspec/cvlast/CVLType;", "convertTypeIfPossibleAssertSuccess", "convertTypeToSimpleIfPossible", "isConvertibleToArithmeticType", "typeRaw", "TypeConversion", "Shared"})
public final class CVLTypeConversions {
    @NotNull
    public static final CVLTypeConversions INSTANCE = new CVLTypeConversions();

    private CVLTypeConversions() {
    }

    @Nullable
    public final CVLExp convertTypeToSimpleIfPossible(@NotNull CVLExp exp) {
        Intrinsics.checkNotNullParameter(exp, "exp");
        CVLType type = exp.getCVLType();
        if (type instanceof CVLSimpleType) {
            return exp;
        }
        if (type instanceof CVLTupleType) {
            CVLExp cVLExp;
            if (((CVLTupleType)type).getTuple().size() == 1) {
                TypeConversion res2 = this.convertTypeIfPossible(exp, CollectionsKt.first(((CVLTupleType)type).getTuple()));
                boolean bl = res2 instanceof TypeConversion.Success;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                cVLExp = res2.getExp();
            } else {
                cVLExp = null;
            }
            return cVLExp;
        }
        return null;
    }

    @NotNull
    public final CVLExp convertTypeIfPossibleAssertSuccess(@NotNull CVLExp exp, @NotNull CVLType targetType) {
        Intrinsics.checkNotNullParameter(exp, "exp");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        TypeConversion converted = this.convertTypeIfPossible(exp, targetType);
        if (!(converted instanceof TypeConversion.Success)) {
            throw new AssertionError((Object)"conversion must succeed when using this method");
        }
        return converted.getExp();
    }

    @NotNull
    public final TypeConversion convertTypeIfPossible(@NotNull CVLExp exp, @NotNull CVLType targetType) {
        block31: {
            block32: {
                boolean bl;
                block30: {
                    Intrinsics.checkNotNullParameter(exp, "exp");
                    Intrinsics.checkNotNullParameter(targetType, "targetType");
                    if (exp.getCVLType() instanceof CVLErrorType) {
                        return TypeConversion.Companion.success(exp, targetType);
                    }
                    if (!(exp instanceof CVLExp.ApplyExp.ContractFunction)) break block31;
                    if (targetType.isArrayType()) break block32;
                    if (!(targetType instanceof CVLTupleType)) break block31;
                    Iterable $this$any$iv = ((CVLTupleType)targetType).getTuple();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CVLType it = (CVLType)element$iv;
                            boolean bl2 = false;
                            if (!it.isArrayType()) continue;
                            bl = true;
                            break block30;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block31;
            }
            return TypeConversion.Companion.error(exp, targetType, Intrinsics.stringPlus("Does not support array return types from contract calls to ", exp));
        }
        if (exp instanceof CVLExp.VariableExp) {
            return ((CVLExp.VariableExp)exp).isWildCard() ? (TypeConversion)TypeConversion.Companion.success(CVLExp.VariableExp.copy$default((CVLExp.VariableExp)exp, null, new CVLExpTag(targetType), null, false, 13, null), targetType) : (exp.getCVLType().isConvertibleTo(targetType) ? (TypeConversion)TypeConversion.Companion.success(exp, targetType) : (TypeConversion)TypeConversion.Companion.error(exp, targetType));
        }
        if (exp instanceof CVLExp.ApplyExp.Ghost) {
            return exp.getCVLType().isConvertibleTo(targetType) ? (TypeConversion)TypeConversion.Companion.success(exp, targetType) : (TypeConversion)TypeConversion.Companion.error(exp, targetType);
        }
        if (Intrinsics.areEqual(targetType, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE.getCvlType())) {
            return TypeConversion.Companion.error(exp, targetType);
        }
        if (targetType instanceof CVLErrorType) {
            return TypeConversion.Companion.success(exp, targetType);
        }
        if (exp instanceof CVLExp.ArrayLitExp && ((CVLExp.ArrayLitExp)exp).getElements().isEmpty() && exp.getCVLType().isArrayType() && targetType.isArrayType()) {
            return TypeConversion.Companion.success(CVLTypeConversions.convertTypeIfPossible$getUpdatedType(exp, targetType), targetType);
        }
        if (Intrinsics.areEqual(exp.getCVLType(), CVLInbuiltSimpleTypes.numberLiteral.INSTANCE.getCvlType())) {
            BigInteger bigInteger;
            boolean bl;
            Serializable serializable;
            if ((targetType instanceof CVLSimpleType.Inbuilt ? (CVLSimpleType.Inbuilt)targetType : null) == null) {
                return TypeConversion.Companion.error(exp, targetType);
            }
            if (Intrinsics.areEqual(((CVLSimpleType.Inbuilt)targetType).getEType(), CVLInbuiltSimpleTypes.mathint.INSTANCE)) {
                return TypeConversion.Companion.success(CVLTypeConversions.convertTypeIfPossible$getUpdatedType(exp, targetType), targetType);
            }
            Serializable serializable2 = exp.eval();
            CVLExp.Constant.NumberLit numberLit = serializable2 instanceof CVLExp.Constant.NumberLit ? (CVLExp.Constant.NumberLit)serializable2 : null;
            BigInteger bigInteger2 = serializable = numberLit == null ? null : numberLit.getN();
            if (serializable == null) {
                return TypeConversion.Companion.error(exp, targetType);
            }
            BigInteger expValue = serializable;
            serializable = ((CVLSimpleType.Inbuilt)targetType).getEType();
            if (Intrinsics.areEqual(serializable, CVLInbuiltSimpleTypes.int.INSTANCE) ? true : serializable instanceof CVLInbuiltSimpleTypes.IntK) {
                Integer n = ((CVLSimpleType.Inbuilt)targetType).getEType().getBitWidth();
                Intrinsics.checkNotNull(n);
                int bitwidth = n;
                serializable2 = BigInteger.TWO.pow(bitwidth - 1);
                Intrinsics.checkNotNullExpressionValue(serializable2, "TWO.pow(bitwidth - 1)");
                boolean bl3 = false;
                BigInteger bigInteger3 = ((BigInteger)serializable2).negate();
                Intrinsics.checkNotNullExpressionValue(bigInteger3, "this.negate()");
                if (expValue.compareTo(bigInteger3) >= 0) {
                    serializable2 = BigInteger.TWO.pow(bitwidth - 1);
                    Intrinsics.checkNotNullExpressionValue(serializable2, "TWO.pow(bitwidth - 1)");
                    BigInteger bigInteger4 = BigInteger.ONE;
                    Intrinsics.checkNotNullExpressionValue(bigInteger4, "ONE");
                    bl = false;
                    BigInteger bigInteger5 = ((BigInteger)serializable2).subtract(bigInteger4);
                    Intrinsics.checkNotNullExpressionValue(bigInteger5, "this.subtract(other)");
                    if (expValue.compareTo(bigInteger5) <= 0) {
                        return TypeConversion.Companion.success(CVLTypeConversions.convertTypeIfPossible$getUpdatedType(exp, targetType), targetType);
                    }
                }
            } else if ((Intrinsics.areEqual(serializable, CVLInbuiltSimpleTypes.uint.INSTANCE) ? true : serializable instanceof CVLInbuiltSimpleTypes.UIntK) ? true : serializable instanceof CVLInbuiltSimpleTypes.BytesK) {
                Integer n = ((CVLSimpleType.Inbuilt)targetType).getEType().getBitWidth();
                Intrinsics.checkNotNull(n);
                int bitwidth = n;
                if (expValue.compareTo(BigInteger.ZERO) >= 0) {
                    serializable2 = BigInteger.TWO.pow(bitwidth);
                    Intrinsics.checkNotNullExpressionValue(serializable2, "TWO.pow(bitwidth)");
                    bigInteger = BigInteger.ONE;
                    Intrinsics.checkNotNullExpressionValue(bigInteger, "ONE");
                    bl = false;
                    BigInteger bigInteger6 = ((BigInteger)serializable2).subtract(bigInteger);
                    Intrinsics.checkNotNullExpressionValue(bigInteger6, "this.subtract(other)");
                    if (expValue.compareTo(bigInteger6) <= 0) {
                        return TypeConversion.Companion.success(CVLTypeConversions.convertTypeIfPossible$getUpdatedType(exp, targetType), targetType);
                    }
                }
            } else if (Intrinsics.areEqual(serializable, CVLInbuiltSimpleTypes.address.INSTANCE)) {
                serializable2 = BigInteger.TWO.pow(160);
                Intrinsics.checkNotNullExpressionValue(serializable2, "TWO.pow(160)");
                bigInteger = BigInteger.ONE;
                Intrinsics.checkNotNullExpressionValue(bigInteger, "ONE");
                bl = false;
                BigInteger bigInteger7 = ((BigInteger)serializable2).subtract(bigInteger);
                Intrinsics.checkNotNullExpressionValue(bigInteger7, "this.subtract(other)");
                BigInteger maxAddress = bigInteger7;
                if (expValue.compareTo(BigInteger.ZERO) >= 0 && expValue.compareTo(maxAddress) <= 0) {
                    return TypeConversion.Companion.success(CVLTypeConversions.convertTypeIfPossible$getUpdatedType(exp, targetType), targetType);
                }
            } else {
                return TypeConversion.Companion.error(exp, targetType);
            }
            StandardCVLErrorLogger.INSTANCE.error("numberLiteral " + expValue + " is out of bounds for safe cast to " + targetType + ". Use explicit cast.", new CVLLocation.Empty(null, 1, null));
            return TypeConversion.Companion.error(exp, targetType);
        }
        if (!exp.getCVLType().isConvertibleTo(targetType)) {
            return TypeConversion.Companion.error(exp, targetType);
        }
        return TypeConversion.Companion.success(CVLTypeConversions.convertTypeIfPossible$getUpdatedType(exp, targetType), targetType);
    }

    @NotNull
    public final Triple<CVLExp, CVLExp, Boolean> convertToSameType(@NotNull CVLExp lTypeChecked, @NotNull CVLExp rTypeChecked) {
        Intrinsics.checkNotNullParameter(lTypeChecked, "lTypeChecked");
        Intrinsics.checkNotNullParameter(rTypeChecked, "rTypeChecked");
        CVLType lType = lTypeChecked.getCVLType();
        CVLType rType = rTypeChecked.getCVLType();
        if (lType instanceof CVLErrorType || rType instanceof CVLErrorType) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, true);
        }
        if (Intrinsics.areEqual(lType, rType)) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, true);
        }
        if (lType instanceof CVLTupleType && ((CVLTupleType)lType).getTuple().size() == 1 && !(rType instanceof CVLTupleType)) {
            return this.convertToSameType(lTypeChecked.updateType(CollectionsKt.first(((CVLTupleType)lType).getTuple())), rTypeChecked);
        }
        if (rType instanceof CVLTupleType && ((CVLTupleType)rType).getTuple().size() == 1 && !(lType instanceof CVLTupleType)) {
            return this.convertToSameType(lTypeChecked, rTypeChecked.updateType(CollectionsKt.first(((CVLTupleType)rType).getTuple())));
        }
        if (Intrinsics.areEqual(lType, CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType())) {
            return this.convertToSameType(lTypeChecked.updateType(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()), rTypeChecked);
        }
        if (Intrinsics.areEqual(rType, CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType())) {
            return this.convertToSameType(lTypeChecked, rTypeChecked.updateType(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()));
        }
        TypeConversion newLType = this.convertTypeIfPossible(lTypeChecked, rType);
        if (newLType instanceof TypeConversion.Success) {
            return new Triple<CVLExp, CVLExp, Boolean>(newLType.getExp(), rTypeChecked, true);
        }
        TypeConversion newRType = this.convertTypeIfPossible(rTypeChecked, lType);
        if (newRType instanceof TypeConversion.Success) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, newRType.getExp(), true);
        }
        StandardCVLErrorLogger.INSTANCE.warn("unable to convert from (" + lTypeChecked + " : " + lType + ") to (" + rTypeChecked + " : " + rType + ')', new CVLLocation.Empty(null, 1, null));
        if (Intrinsics.areEqual(lType, CVLInbuiltStructTypes.methodType.getCvlType()) && rType instanceof CVLFunctionType || Intrinsics.areEqual(rType, CVLInbuiltStructTypes.methodType.getCvlType()) && lType instanceof CVLFunctionType) {
            StandardCVLErrorLogger.INSTANCE.warn("Possible reason for this error: used a function's name (e.g. 'foo') instead of canonical name (e.g. 'foo(uint256, uint256) in a comparison with a method variable.", new CVLLocation.Empty(null, 1, null));
        }
        return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, false);
    }

    @NotNull
    public final Triple<CVLExp, CVLExp, Boolean> convertToSameArithmeticType(@NotNull CVLExp lTypeChecked, @NotNull CVLExp rTypeChecked) {
        Intrinsics.checkNotNullParameter(lTypeChecked, "lTypeChecked");
        Intrinsics.checkNotNullParameter(rTypeChecked, "rTypeChecked");
        if (!this.isConvertibleToArithmeticType(lTypeChecked.getCVLType()) || !this.isConvertibleToArithmeticType(rTypeChecked.getCVLType())) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, false);
        }
        return this.convertToSameType(lTypeChecked, rTypeChecked);
    }

    public final boolean isConvertibleToArithmeticType(@NotNull CVLType typeRaw) {
        boolean bl;
        CVLType type;
        Intrinsics.checkNotNullParameter(typeRaw, "typeRaw");
        CVLType cVLType = type = typeRaw instanceof CVLTupleType && ((CVLTupleType)typeRaw).getTuple().size() == 1 ? ((CVLTupleType)typeRaw).getTuple().get(0) : typeRaw;
        if (!(type instanceof CVLSimpleType.Inbuilt)) {
            return false;
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes = ((CVLSimpleType.Inbuilt)type).getEType();
        if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.EVMArray) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.EVMStruct) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.calldataarg.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.storage.INSTANCE)) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.UIntK) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.uint.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.int.INSTANCE)) {
            bl = true;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.IntK) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.mathint.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.address.INSTANCE)) {
            bl = CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType().isConvertibleTo(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType());
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.bool.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.string.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.bytes.INSTANCE)) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.StoragePointer) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.Opaque) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.BytesK) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.bottom.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.bytesblob.INSTANCE)) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final CVLExp convertTypeIfPossible$getUpdatedType(CVLExp $exp, CVLType $targetType) {
        return $exp.updateTag($exp.getTag().updateType($targetType));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lspec/cvlast/CVLTypeConversions$TypeConversion;", "", "()V", "exp", "Lspec/cvlast/CVLExp;", "getExp", "()Lspec/cvlast/CVLExp;", "targetType", "Lspec/cvlast/CVLType;", "getTargetType", "()Lspec/cvlast/CVLType;", "Companion", "Error", "Success", "Lspec/cvlast/CVLTypeConversions$TypeConversion$Error;", "Lspec/cvlast/CVLTypeConversions$TypeConversion$Success;", "Shared"})
    public static abstract class TypeConversion {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private TypeConversion() {
        }

        @NotNull
        public abstract CVLExp getExp();

        @NotNull
        public abstract CVLType getTargetType();

        public /* synthetic */ TypeConversion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lspec/cvlast/CVLTypeConversions$TypeConversion$Error;", "Lspec/cvlast/CVLTypeConversions$TypeConversion;", "exp", "Lspec/cvlast/CVLExp;", "targetType", "Lspec/cvlast/CVLType;", "msg", "", "(Lspec/cvlast/CVLExp;Lspec/cvlast/CVLType;Ljava/lang/String;)V", "getExp", "()Lspec/cvlast/CVLExp;", "getMsg", "()Ljava/lang/String;", "getTargetType", "()Lspec/cvlast/CVLType;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class Error
        extends TypeConversion {
            @NotNull
            private final CVLExp exp;
            @NotNull
            private final CVLType targetType;
            @Nullable
            private final String msg;

            public Error(@NotNull CVLExp exp, @NotNull CVLType targetType, @Nullable String msg) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                super(null);
                this.exp = exp;
                this.targetType = targetType;
                this.msg = msg;
            }

            @Override
            @NotNull
            public CVLExp getExp() {
                return this.exp;
            }

            @Override
            @NotNull
            public CVLType getTargetType() {
                return this.targetType;
            }

            @Nullable
            public final String getMsg() {
                return this.msg;
            }

            @NotNull
            public final CVLExp component1() {
                return this.getExp();
            }

            @NotNull
            public final CVLType component2() {
                return this.getTargetType();
            }

            @Nullable
            public final String component3() {
                return this.msg;
            }

            @NotNull
            public final Error copy(@NotNull CVLExp exp, @NotNull CVLType targetType, @Nullable String msg) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                return new Error(exp, targetType, msg);
            }

            public static /* synthetic */ Error copy$default(Error error2, CVLExp cVLExp, CVLType cVLType, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    cVLExp = error2.getExp();
                }
                if ((n & 2) != 0) {
                    cVLType = error2.getTargetType();
                }
                if ((n & 4) != 0) {
                    string2 = error2.msg;
                }
                return error2.copy(cVLExp, cVLType, string2);
            }

            @NotNull
            public String toString() {
                return "Error(exp=" + this.getExp() + ", targetType=" + this.getTargetType() + ", msg=" + this.msg + ')';
            }

            public int hashCode() {
                int result2 = this.getExp().hashCode();
                result2 = result2 * 31 + this.getTargetType().hashCode();
                result2 = result2 * 31 + (this.msg == null ? 0 : this.msg.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error2 = (Error)other;
                if (!Intrinsics.areEqual(this.getExp(), error2.getExp())) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.getTargetType(), error2.getTargetType())) {
                    return false;
                }
                return Intrinsics.areEqual(this.msg, error2.msg);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lspec/cvlast/CVLTypeConversions$TypeConversion$Success;", "Lspec/cvlast/CVLTypeConversions$TypeConversion;", "exp", "Lspec/cvlast/CVLExp;", "targetType", "Lspec/cvlast/CVLType;", "(Lspec/cvlast/CVLExp;Lspec/cvlast/CVLType;)V", "getExp", "()Lspec/cvlast/CVLExp;", "getTargetType", "()Lspec/cvlast/CVLType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Shared"})
        public static final class Success
        extends TypeConversion {
            @NotNull
            private final CVLExp exp;
            @NotNull
            private final CVLType targetType;

            public Success(@NotNull CVLExp exp, @NotNull CVLType targetType) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                super(null);
                this.exp = exp;
                this.targetType = targetType;
            }

            @Override
            @NotNull
            public CVLExp getExp() {
                return this.exp;
            }

            @Override
            @NotNull
            public CVLType getTargetType() {
                return this.targetType;
            }

            @NotNull
            public final CVLExp component1() {
                return this.getExp();
            }

            @NotNull
            public final CVLType component2() {
                return this.getTargetType();
            }

            @NotNull
            public final Success copy(@NotNull CVLExp exp, @NotNull CVLType targetType) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                return new Success(exp, targetType);
            }

            public static /* synthetic */ Success copy$default(Success success, CVLExp cVLExp, CVLType cVLType, int n, Object object) {
                if ((n & 1) != 0) {
                    cVLExp = success.getExp();
                }
                if ((n & 2) != 0) {
                    cVLType = success.getTargetType();
                }
                return success.copy(cVLExp, cVLType);
            }

            @NotNull
            public String toString() {
                return "Success(exp=" + this.getExp() + ", targetType=" + this.getTargetType() + ')';
            }

            public int hashCode() {
                int result2 = this.getExp().hashCode();
                result2 = result2 * 31 + this.getTargetType().hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual(this.getExp(), success.getExp())) {
                    return false;
                }
                return Intrinsics.areEqual(this.getTargetType(), success.getTargetType());
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lspec/cvlast/CVLTypeConversions$TypeConversion$Companion;", "", "()V", "error", "Lspec/cvlast/CVLTypeConversions$TypeConversion$Error;", "exp", "Lspec/cvlast/CVLExp;", "targetType", "Lspec/cvlast/CVLType;", "msg", "", "success", "Lspec/cvlast/CVLTypeConversions$TypeConversion$Success;", "Shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Error error(@NotNull CVLExp exp, @NotNull CVLType targetType) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                return new Error(exp, targetType, null);
            }

            @NotNull
            public final Error error(@NotNull CVLExp exp, @NotNull CVLType targetType, @NotNull String msg) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                Intrinsics.checkNotNullParameter(msg, "msg");
                return new Error(exp, targetType, msg);
            }

            @NotNull
            public final Success success(@NotNull CVLExp exp, @NotNull CVLType targetType) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                Intrinsics.checkNotNullParameter(targetType, "targetType");
                return new Success(exp, targetType);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

