/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.EndOfLineParallel;
import parallel.FilteringFanOut;
import parallel.Parallel;
import parallel.RaceFinish;
import parallel.Sem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B9\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0016R\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lparallel/FinishingRaceJob;", "T", "Lparallel/EndOfLineParallel;", "", "thunk", "Lkotlin/Function0;", "Lparallel/RaceFinish;", "id", "", "fanOut", "Lparallel/FilteringFanOut;", "timeout", "Ljava/time/Duration;", "(Lkotlin/jvm/functions/Function0;ILparallel/FilteringFanOut;Ljava/time/Duration;)V", "deps", "", "Lparallel/Parallel;", "getDeps", "()Ljava/util/List;", "getFanOut", "()Lparallel/FilteringFanOut;", "getId", "()I", "lock", "Lparallel/Sem;", "getLock", "()Lparallel/Sem;", "result", "getResult", "()Lkotlin/Unit;", "Lkotlin/Unit;", "getThunk", "()Lkotlin/jvm/functions/Function0;", "getTimeout", "()Ljava/time/Duration;", "dbgPrnt", "msg", "", "sched", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
final class FinishingRaceJob<T>
extends EndOfLineParallel<Unit> {
    @NotNull
    private final Function0<RaceFinish<T>> thunk;
    private final int id;
    @NotNull
    private final FilteringFanOut<T> fanOut;
    @Nullable
    private final Duration timeout;
    @NotNull
    private final Sem lock;
    @NotNull
    private final Unit result;

    public FinishingRaceJob(@NotNull Function0<? extends RaceFinish<? extends T>> thunk, int id, @NotNull FilteringFanOut<T> fanOut2, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter(thunk, "thunk");
        Intrinsics.checkNotNullParameter(fanOut2, "fanOut");
        this.thunk = thunk;
        this.id = id;
        this.fanOut = fanOut2;
        this.timeout = timeout;
        this.lock = this.fanOut.getLock();
        this.result = Unit.INSTANCE;
    }

    @NotNull
    public final Function0<RaceFinish<T>> getThunk() {
        return this.thunk;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final FilteringFanOut<T> getFanOut() {
        return this.fanOut;
    }

    @Nullable
    public final Duration getTimeout() {
        return this.timeout;
    }

    @NotNull
    public final Sem getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dbgPrnt(String msg) {
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            boolean bl3 = false;
            String string2 = this.getLock() + ' ' + this.getId() + " : " + msg + " (status: " + this.getFanOut().getStatus() + " done: " + this.done();
            boolean bl4 = false;
            System.out.println((Object)string2);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Unit getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sched(@NotNull ExecutorService ioPool) {
        Object object;
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        long startTimeMillis = System.currentTimeMillis();
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            boolean bl3 = false;
            if (this.getFanOut().getStatus() != 0) {
                boolean bl4 = this.getFanOut().getStatus() != this.getId();
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string2 = "this job is just starting; it can't have won the race";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                bl4 = this.getFanOut().getStatus() != -1 || this.getFanOut().getExceptionThrown() != null;
                bl5 = false;
                bl6 = false;
                if (!bl4) {
                    boolean bl8 = false;
                    String string3 = "status indicates that all jobs have finished unsuccessfully and without throwing an exception, but this one is just starting";
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                this.getFanOut().registerSkipped(this.getId());
                return;
            }
            object = Unit.INSTANCE;
        }
        Ref.BooleanRef taskDone = new Ref.BooleanRef();
        Future<?> fut = ioPool.submit(() -> FinishingRaceJob.sched$lambda-6(this, taskDone));
        object = this.lock;
        boolean bl9 = false;
        boolean bl10 = false;
        synchronized (object) {
            boolean bl11 = false;
            boolean hitTimeout = false;
            while (this.getFanOut().getStatus() == 0 && !taskDone.element && !hitTimeout) {
                if (this.getTimeout() != null) {
                    long timeRemaining = this.getTimeout().toMillis() - (System.currentTimeMillis() - startTimeMillis);
                    if (timeRemaining <= 0L) {
                        hitTimeout = true;
                        continue;
                    }
                    this.getLock().wait(timeRemaining);
                    continue;
                }
                this.getLock().wait();
            }
            if (!taskDone.element) {
                fut.cancel(true);
                if (hitTimeout) {
                    this.getFanOut().registerTimeout(this.getId());
                } else if (this.getFanOut().getStatus() != this.getId()) {
                    this.getFanOut().registerLostRace(this.getId());
                } else {
                    String string4 = "RaceJob " + this.getId() + " won yet is not done";
                    boolean bl12 = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sched$lambda-6(FinishingRaceJob this$0, Ref.BooleanRef $taskDone) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($taskDone, "$taskDone");
        try {
            RaceFinish res2 = this$0.getThunk().invoke();
            Sem sem = this$0.getLock();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (sem) {
                boolean bl3 = false;
                RaceFinish raceFinish = res2;
                if (raceFinish instanceof RaceFinish.DQF) {
                    this$0.getFanOut().registerDqf(this$0.getId(), res2.getRes());
                } else if (raceFinish instanceof RaceFinish.Full) {
                    this$0.getFanOut().registerFull(this$0.getId(), res2.getRes());
                }
                $taskDone.element = true;
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            Sem sem = this$0.getLock();
            boolean bl = false;
            boolean bl4 = false;
            synchronized (sem) {
                boolean bl5 = false;
                this$0.getFanOut().registerException(new IllegalStateException("thunk " + this$0.getId() + " in FinishingRaceJob threw an exception; thunks should catch their own exceptions", e));
                $taskDone.element = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

