/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.HashRelation;
import datastructures.LabelledGraph;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BA\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\"\u0010\f\u001a\u00028\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\bH\u0086\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\t\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR&\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldatastructures/SparseLabelledGraph;", "V", "E", "Ldatastructures/LabelledGraph;", "relation", "Ldatastructures/HashRelation;", "labelMapping", "", "Lkotlin/Pair;", "defaultLabel", "(Ldatastructures/HashRelation;Ljava/util/Map;Ljava/lang/Object;)V", "Ljava/lang/Object;", "get", "pair", "(Lkotlin/Pair;)Ljava/lang/Object;", "getEdgeLabel", "src", "tgt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "GeneralUtils"})
public final class SparseLabelledGraph<V, E>
extends LabelledGraph<V, E> {
    @NotNull
    private final HashRelation<V, V> relation;
    @NotNull
    private final Map<Pair<V, V>, E> labelMapping;
    private final E defaultLabel;

    public SparseLabelledGraph(@NotNull HashRelation<V, V> relation, @NotNull Map<Pair<V, V>, ? extends E> labelMapping, E defaultLabel) {
        Intrinsics.checkNotNullParameter(relation, "relation");
        Intrinsics.checkNotNullParameter(labelMapping, "labelMapping");
        super(relation, labelMapping);
        this.relation = relation;
        this.labelMapping = labelMapping;
        this.defaultLabel = defaultLabel;
    }

    public final E get(@NotNull Pair<? extends V, ? extends V> pair) {
        Intrinsics.checkNotNullParameter(pair, "pair");
        return this.getEdgeLabel(pair.getFirst(), pair.getSecond());
    }

    @Override
    public E getEdgeLabel(V src, V tgt) {
        E e = this.labelMapping.get(TuplesKt.to(src, tgt));
        return e == null ? this.defaultLabel : e;
    }
}

