/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.HashRelation;
import datastructures.MutableHashRelation;
import datastructures.SparseLabelledGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005BA\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eJ\"\u0010\u000f\u001a\u00028\u00012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\nH\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n\u0012\u0004\u0012\u00028\u00010\n0\u0013J\u001b\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ*\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u001d\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eR\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR&\u0010\b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldatastructures/MutableSparseLabelledGraph;", "V", "E", "", "defaultLabel", "(Ljava/lang/Object;)V", "relation", "Ldatastructures/MutableHashRelation;", "labelMapping", "", "Lkotlin/Pair;", "(Ldatastructures/MutableHashRelation;Ljava/util/Map;Ljava/lang/Object;)V", "Ljava/lang/Object;", "freeze", "Ldatastructures/SparseLabelledGraph;", "get", "pair", "(Lkotlin/Pair;)Ljava/lang/Object;", "getAllNonDefaultEdges", "", "getLabel", "src", "tgt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "put", "", "lab", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "set", "label", "(Lkotlin/Pair;Ljava/lang/Object;)V", "GeneralUtils"})
public final class MutableSparseLabelledGraph<V, E> {
    @NotNull
    private final MutableHashRelation<V, V> relation;
    @NotNull
    private final Map<Pair<V, V>, E> labelMapping;
    private final E defaultLabel;

    public MutableSparseLabelledGraph(@NotNull MutableHashRelation<V, V> relation, @NotNull Map<Pair<V, V>, E> labelMapping, E defaultLabel) {
        Intrinsics.checkNotNullParameter(relation, "relation");
        Intrinsics.checkNotNullParameter(labelMapping, "labelMapping");
        this.relation = relation;
        this.labelMapping = labelMapping;
        this.defaultLabel = defaultLabel;
    }

    public MutableSparseLabelledGraph(E defaultLabel) {
        this(new MutableHashRelation(), new LinkedHashMap(), defaultLabel);
    }

    public final void put(V src, E lab, V tgt) {
        this.relation.add(TuplesKt.to(src, tgt));
        Map<Pair<E, E>, E> map2 = this.labelMapping;
        Pair<V, V> pair = TuplesKt.to(src, tgt);
        boolean bl = false;
        map2.put(pair, lab);
    }

    public final void set(@NotNull Pair<? extends V, ? extends V> pair, E label) {
        Intrinsics.checkNotNullParameter(pair, "pair");
        this.put(pair.getFirst(), label, pair.getSecond());
    }

    public final E get(@NotNull Pair<? extends V, ? extends V> pair) {
        Intrinsics.checkNotNullParameter(pair, "pair");
        return this.getLabel(pair.getFirst(), pair.getSecond());
    }

    public final E getLabel(V src, V tgt) {
        E e = this.labelMapping.get(TuplesKt.to(src, tgt));
        return e == null ? this.defaultLabel : e;
    }

    @NotNull
    public final SparseLabelledGraph<V, E> freeze() {
        return new SparseLabelledGraph<V, E>((HashRelation)this.relation, this.labelMapping, this.defaultLabel);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Pair<Pair<V, V>, E>> getAllNonDefaultEdges() {
        void $this$mapTo$iv$iv;
        Object v2;
        Object v1;
        Pair $dstr$v1$v2;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.relation.getPairs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            $dstr$v1$v2 = (Pair)element$iv$iv;
            boolean bl = false;
            v1 = $dstr$v1$v2.component1();
            if (!(!Intrinsics.areEqual(this.labelMapping.get(TuplesKt.to(v1, v2 = $dstr$v1$v2.component2())), this.defaultLabel))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            $dstr$v1$v2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            v1 = $dstr$v1$v2.component1();
            v2 = $dstr$v1$v2.component2();
            Pair pair = TuplesKt.to(v1, v2);
            E e = this.labelMapping.get(TuplesKt.to(v1, v2));
            Intrinsics.checkNotNull(e);
            Pair pair2 = TuplesKt.to(pair, e);
            collection.add(pair2);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }
}

