/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import bridge.ContractInstanceInSDC;
import bridge.Method;
import bridge.SourceLanguage;
import bridge.StorageLayout;
import compiler.ABI;
import compiler.AbstractSolcRunner;
import compiler.StandardSolcRunner;
import compiler.data.Contract;
import compiler.data.ContractSource;
import compiler.data.Error;
import compiler.data.Input;
import compiler.data.Output;
import compiler.data.SolcSettings;
import compiler.data.SolidityOptimization;
import compiler.data.SourceParsed;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.Either;
import utils.EitherKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001/B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0013J\n\u0010'\u001a\u0004\u0018\u00010 H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0014J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020+0*H$J\b\u0010,\u001a\u00020\u0013H$J*\u0010-\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u00192\b\u0010.\u001a\u0004\u0018\u00010 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R3\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u001f\u001a\u0004\u0018\u00010 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0011\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lcompiler/AbstractSolcRunner;", "", "address", "Ljava/math/BigInteger;", "optimize", "", "runDir", "Ljava/nio/file/Path;", "(Ljava/math/BigInteger;ZLjava/nio/file/Path;)V", "getAddress", "()Ljava/math/BigInteger;", "contractInstances", "", "Lbridge/ContractInstanceInSDC;", "getContractInstances", "()Ljava/util/List;", "contractInstances$delegate", "Lkotlin/Lazy;", "errors", "", "getErrors", "errors$delegate", "getOptimize", "()Z", "result", "Lutils/Either;", "getResult", "()Lutils/Either;", "result$delegate", "getRunDir", "()Ljava/nio/file/Path;", "solOutput", "Lcompiler/data/Output;", "getSolOutput", "()Lcompiler/data/Output;", "solOutput$delegate", "ast", "Lkotlinx/serialization/json/JsonObject;", "file", "compileContracts", "getAllowedPaths", "getContractSource", "", "Lcompiler/AbstractSolcRunner$Source;", "getSolcExecutable", "postProcess", "res", "Source", "Shared"})
public abstract class AbstractSolcRunner {
    @NotNull
    private final BigInteger address;
    private final boolean optimize;
    @Nullable
    private final Path runDir;
    @NotNull
    private final Lazy solOutput$delegate;
    @NotNull
    private final Lazy result$delegate;
    @NotNull
    private final Lazy errors$delegate;
    @NotNull
    private final Lazy contractInstances$delegate;

    public AbstractSolcRunner(@NotNull BigInteger address2, boolean optimize, @Nullable Path runDir) {
        Intrinsics.checkNotNullParameter(address2, "address");
        this.address = address2;
        this.optimize = optimize;
        this.runDir = runDir;
        this.solOutput$delegate = LazyKt.lazy((Function0)new Function0<Output>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Output invoke() {
                return AbstractSolcRunner.access$compileContracts(this.this$0);
            }
        });
        this.result$delegate = LazyKt.lazy((Function0)new Function0<Either<? extends List<? extends ContractInstanceInSDC>, ? extends List<? extends String>>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Either<List<ContractInstanceInSDC>, List<String>> invoke() {
                return AbstractSolcRunner.access$postProcess(this.this$0, this.this$0.getSolOutput());
            }
        });
        this.errors$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return (List)EitherKt.toValue(this.this$0.getResult(), errors.1.INSTANCE, errors.2.INSTANCE);
            }
        });
        this.contractInstances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<ContractInstanceInSDC> invoke() {
                return (List)EitherKt.toValue(this.this$0.getResult(), contractInstances.1.INSTANCE, contractInstances.2.INSTANCE);
            }
        });
    }

    public /* synthetic */ AbstractSolcRunner(BigInteger bigInteger, boolean bl, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            BigInteger bigInteger2 = BigInteger.TWO.pow(24);
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "TWO.pow(24)");
            bigInteger = bigInteger2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            path = null;
        }
        this(bigInteger, bl, path);
    }

    @NotNull
    public final BigInteger getAddress() {
        return this.address;
    }

    public final boolean getOptimize() {
        return this.optimize;
    }

    @Nullable
    public final Path getRunDir() {
        return this.runDir;
    }

    @Nullable
    public final Output getSolOutput() {
        Lazy lazy = this.solOutput$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Output)lazy.getValue();
    }

    @NotNull
    public final Either<List<ContractInstanceInSDC>, List<String>> getResult() {
        Lazy lazy = this.result$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Either)lazy.getValue();
    }

    @Nullable
    public final JsonObject ast(@NotNull String file) {
        SourceParsed sourceParsed;
        Map<String, SourceParsed> map2;
        Intrinsics.checkNotNullParameter(file, "file");
        Output output = this.getSolOutput();
        return output == null ? null : ((map2 = output.getSources()) == null ? null : ((sourceParsed = map2.get(file)) == null ? null : sourceParsed.getAst()));
    }

    @NotNull
    public final List<String> getErrors() {
        Lazy lazy = this.errors$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<ContractInstanceInSDC> getContractInstances() {
        Lazy lazy = this.contractInstances$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    protected abstract Map<String, Source> getContractSource();

    @NotNull
    protected abstract String getSolcExecutable();

    @NotNull
    protected List<String> getAllowedPaths() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final Output compileContracts() {
        void $this$mapTo$iv$iv;
        List<String> allowedPaths = CollectionsKt.toMutableList((Collection)this.getAllowedPaths());
        String[] $this$map$iv = this.getContractSource();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var8_8.entrySet().iterator();
        while (iterator2.hasNext()) {
            ContractSource contractSource;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Source x = (Source)it.getValue();
            if (x instanceof Source.Literal) {
                contractSource = new ContractSource(((Source.Literal)x).getContractSource(), null, 2, null);
            } else if (x instanceof Source.FromFile) {
                File f = new File(((Source.FromFile)x).getPath());
                File file = f.getParentFile();
                if (file != null) {
                    void parentFile;
                    File file2 = file;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    File file3 = file2;
                    Object k2 = k;
                    boolean bl5 = false;
                    String string2 = parentFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string2, "parentFile.absolutePath");
                    Boolean bl6 = allowedPaths.add(string2);
                    k = k2;
                }
                contractSource = new ContractSource(null, f, 1, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair = TuplesKt.to(k, contractSource);
            collection.add(pair);
        }
        Map sources = MapsKt.toMap((List)destination$iv$iv);
        Object object = new Pair[2];
        stringArray = new String[]{"abi", "evm.deployedBytecode.object", "evm.bytecode.object", "evm.methodIdentifiers", "evm.deployedBytecode.sourceMap", "storageLayout"};
        object[0] = TuplesKt.to("*", CollectionsKt.listOf(stringArray));
        object[1] = TuplesKt.to("", CollectionsKt.listOf("ast"));
        Input solidityInput = new Input(null, sources, new SolcSettings(MapsKt.mapOf(TuplesKt.to("*", MapsKt.mapOf(object))), new SolidityOptimization(this.optimize)), 1, null);
        object = new StandardSolcRunner(this.getSolcExecutable(), allowedPaths, this.runDir).run(solidityInput);
        return object == null ? null : object;
    }

    /*
     * WARNING - void declaration
     */
    private final Either<List<ContractInstanceInSDC>, List<String>> postProcess(Output res2) {
        void $this$flatMapTo$iv$iv;
        Object destination$iv$iv;
        boolean bl;
        block11: {
            if (res2 == null) {
                boolean bl2 = false;
                return new Either.Left(CollectionsKt.emptyList());
            }
            Iterable $this$any$iv = res2.getErrors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error it = (Error)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getSeverity(), "error")) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            Error it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = res2.getErrors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Error)element$iv$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual(it.getSeverity(), "error")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Error)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl5 = false;
                String string2 = it.getMessage();
                object.add(string2);
            }
            return EitherKt.toRight((List)destination$iv$iv);
        }
        int i = 0;
        Map<String, Map<String, Contract>> $this$flatMap$iv = res2.getContracts();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void item$iv$iv = $this$flatMapTo$iv$iv;
        boolean bl6 = false;
        Iterator iterator2 = item$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map contracts;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$contracts = element$iv$iv = iterator2.next();
            boolean bl7 = false;
            Map.Entry entry = $dstr$_u24__u24$contracts;
            boolean bl8 = false;
            Map $this$map$iv = contracts = (Map)entry.getValue();
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var20_31 = $this$mapTo$iv$iv;
            boolean bl9 = false;
            Iterator iterator3 = var20_31.entrySet().iterator();
            while (iterator3.hasNext()) {
                String string3;
                String string4;
                BigInteger bigInteger;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                ABI it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $dstr$contractName$contract;
                Map.Entry item$iv$iv2;
                Map.Entry entry2 = item$iv$iv2 = iterator3.next();
                Collection collection = destination$iv$iv3;
                boolean bl10 = false;
                void var27_38 = $dstr$contractName$contract;
                boolean bl11 = false;
                String contractName = (String)var27_38.getKey();
                void var28_39 = $dstr$contractName$contract;
                boolean bl12 = false;
                Contract contract = (Contract)var28_39.getValue();
                Object object = contract.getAbi();
                boolean $i$f$filter = false;
                String string5 = $this$filter$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (ABI)element$iv$iv2;
                    boolean bl13 = false;
                    if (!Intrinsics.areEqual(it.getType(), "function")) continue;
                    destination$iv$iv4.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv4;
                boolean $i$f$map2 = false;
                $this$filterTo$iv$iv = $this$map$iv2;
                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    it = (ABI)item$iv$iv3;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl14 = false;
                    String sig = it.toCanonicalSig();
                    String string6 = contract.getEvm().getMethodIdentifiers().get(sig);
                    Method method = it.toMethod(string6 == null ? "" : string6);
                    collection2.add(method);
                }
                List methods = (List)destination$iv$iv4;
                object = SourceLanguage.Solidity;
                Intrinsics.checkNotNull(contract.getEvm().getDeployedBytecode().getObject());
                String string7 = contract.getEvm().getBytecode().getObject();
                Intrinsics.checkNotNull(string7);
                string5 = string7;
                Intrinsics.checkNotNull(contract.getEvm().getDeployedBytecode().getSourceMap());
                Object object2 = this.getAddress();
                int n = i;
                i = n + 1;
                boolean bl15 = false;
                BigInteger bigInteger2 = BigInteger.valueOf(n);
                Intrinsics.checkNotNullExpressionValue(bigInteger2, "BigInteger.valueOf(this.toLong())");
                Object object3 = bigInteger2;
                bl15 = false;
                Intrinsics.checkNotNullExpressionValue(((BigInteger)object2).add((BigInteger)object3), "this.add(other)");
                object2 = contract.getStorageLayout();
                bl15 = false;
                object3 = CollectionsKt.emptyList();
                boolean bl16 = false;
                List list2 = CollectionsKt.emptyList();
                ContractInstanceInSDC contractInstanceInSDC = new ContractInstanceInSDC(contractName, "", (SourceLanguage)((Object)object), "", bigInteger, methods, string4, string5, string3, null, null, (StorageLayout)object2, (List)object3, null, null, null, null, null, list2, null, null, 1828352, null);
                collection.add(contractInstanceInSDC);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return EitherKt.toLeft((List)destination$iv$iv2);
    }

    public AbstractSolcRunner() {
        this(null, false, null, 7, null);
    }

    public static final /* synthetic */ Output access$compileContracts(AbstractSolcRunner $this) {
        return $this.compileContracts();
    }

    public static final /* synthetic */ Either access$postProcess(AbstractSolcRunner $this, Output res2) {
        return $this.postProcess(res2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcompiler/AbstractSolcRunner$Source;", "", "()V", "FromFile", "Literal", "Lcompiler/AbstractSolcRunner$Source$Literal;", "Lcompiler/AbstractSolcRunner$Source$FromFile;", "Shared"})
    public static abstract class Source {
        private Source() {
        }

        public /* synthetic */ Source(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcompiler/AbstractSolcRunner$Source$Literal;", "Lcompiler/AbstractSolcRunner$Source;", "contractSource", "", "(Ljava/lang/String;)V", "getContractSource", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class Literal
        extends Source {
            @NotNull
            private final String contractSource;

            public Literal(@NotNull String contractSource) {
                Intrinsics.checkNotNullParameter(contractSource, "contractSource");
                super(null);
                this.contractSource = contractSource;
            }

            @NotNull
            public final String getContractSource() {
                return this.contractSource;
            }

            @NotNull
            public final String component1() {
                return this.contractSource;
            }

            @NotNull
            public final Literal copy(@NotNull String contractSource) {
                Intrinsics.checkNotNullParameter(contractSource, "contractSource");
                return new Literal(contractSource);
            }

            public static /* synthetic */ Literal copy$default(Literal literal, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = literal.contractSource;
                }
                return literal.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Literal(contractSource=" + this.contractSource + ')';
            }

            public int hashCode() {
                return this.contractSource.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Literal)) {
                    return false;
                }
                Literal literal = (Literal)other;
                return Intrinsics.areEqual(this.contractSource, literal.contractSource);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcompiler/AbstractSolcRunner$Source$FromFile;", "Lcompiler/AbstractSolcRunner$Source;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class FromFile
        extends Source {
            @NotNull
            private final String path;

            public FromFile(@NotNull String path) {
                Intrinsics.checkNotNullParameter(path, "path");
                super(null);
                this.path = path;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final FromFile copy(@NotNull String path) {
                Intrinsics.checkNotNullParameter(path, "path");
                return new FromFile(path);
            }

            public static /* synthetic */ FromFile copy$default(FromFile fromFile, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = fromFile.path;
                }
                return fromFile.copy(string2);
            }

            @NotNull
            public String toString() {
                return "FromFile(path=" + this.path + ')';
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromFile)) {
                    return false;
                }
                FromFile fromFile = (FromFile)other;
                return Intrinsics.areEqual(this.path, fromFile.path);
            }
        }
    }
}

