from .fhirbase import fhirbase


class ElementDefinition(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        path: The path identifies the element and is expressed as a
            "."-separated list of ancestor elements, beginning with the name of
            the resource or extension.
        representation: Codes that define how this element is represented in
            instances, when the deviation varies from the normal case.
        sliceName: The name of this element definition slice, when slicing is
            working. The name must be a token with no dots or spaces. This is a
            unique name referring to a specific set of constraints applied to this
            element, used to provide a name to different slices of the same
            element.
        label: A single preferred label which is the text to display beside
            the element indicating its meaning or to use to prompt for the element
            in a user display or form.
        code: A code that has the same meaning as the element in a particular
            terminology.
        slicing: Indicates that the element is sliced into a set of
            alternative definitions (i.e. in a structure definition, there are
            multiple different constraints on a single element in the base
            resource). Slicing can be used in any resource that has cardinality
            ..* on the base resource, or any resource with a choice of types. The
            set of slices is any elements that come after this in the element
            sequence that have the same path, until a shorter path occurs (the
            shorter path terminates the set).
        short: A concise description of what this element means (e.g. for use
            in autogenerated summaries).
        definition: Provides a complete explanation of the meaning of the data
            element for human readability.  For the case of elements derived from
            existing elements (e.g. constraints), the definition SHALL be
            consistent with the base definition, but convey the meaning of the
            element in the particular context of use of the resource.
        comment: Explanatory notes and implementation guidance about the data
            element, including notes about how to use the data properly,
            exceptions to proper use, etc.
        requirements: This element is for traceability of why the element was
            created and why the constraints exist as they do. This may be used to
            point to source materials or specifications that drove the structure
            of this element.
        alias: Identifies additional names by which this element might also be
            known.
        min: The minimum number of times this element SHALL appear in the
            instance.
        max: The maximum number of times this element is permitted to appear
            in the instance.
        base: Information about the base definition of the element, provided
            to make it unnecessary for tools to trace the deviation of the element
            through the derived and related profiles. This information is provided
            when the element definition is not the original definition of an
            element - i.g. either in a constraint on another type, or for elements
            from a super type in a snap shot.
        contentReference: Identifies the identity of an element defined
            elsewhere in the profile whose content rules should be applied to the
            current element.
        type: The data type or resource that the value of this element is
            permitted to be.
        defaultValueBoolean: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueInteger: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueDecimal: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueBase64Binary: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueInstant: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueString: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueUri: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueDate: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueDateTime: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueTime: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueCode: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueOid: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueUuid: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueId: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueUnsignedInt: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValuePositiveInt: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueMarkdown: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueElement: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueExtension: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueBackboneElement: The value that should be used if there is
            no value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueNarrative: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueAnnotation: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueAttachment: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueIdentifier: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueCodeableConcept: The value that should be used if there is
            no value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueCoding: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueQuantity: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueDuration: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueSimpleQuantity: The value that should be used if there is
            no value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueDistance: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueCount: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueMoney: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueAge: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueRange: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValuePeriod: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueRatio: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueReference: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueSampledData: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueSignature: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueHumanName: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueAddress: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueContactPoint: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueTiming: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueMeta: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueElementDefinition: The value that should be used if there
            is no value stated in the instance (e.g. 'if not otherwise specified,
            the abstract is false').
        defaultValueContactDetail: The value that should be used if there is
            no value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueContributor: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueDosage: The value that should be used if there is no value
            stated in the instance (e.g. 'if not otherwise specified, the abstract
            is false').
        defaultValueRelatedArtifact: The value that should be used if there is
            no value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueUsageContext: The value that should be used if there is no
            value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueDataRequirement: The value that should be used if there is
            no value stated in the instance (e.g. 'if not otherwise specified, the
            abstract is false').
        defaultValueParameterDefinition: The value that should be used if
            there is no value stated in the instance (e.g. 'if not otherwise
            specified, the abstract is false').
        defaultValueTriggerDefinition: The value that should be used if there
            is no value stated in the instance (e.g. 'if not otherwise specified,
            the abstract is false').
        meaningWhenMissing: The Implicit meaning that is to be understood when
            this element is missing (e.g. 'when this element is missing, the
            period is ongoing'.
        orderMeaning: If present, indicates that the order of the repeating
            element has meaning and describes what that meaning is.  If absent, it
            means that the order of the element has no meaning.
        fixedBoolean: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedInteger: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedDecimal: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedBase64Binary: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedInstant: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedString: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedUri: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedDate: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedDateTime: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedTime: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedCode: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedOid: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedUuid: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedId: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedUnsignedInt: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedPositiveInt: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedMarkdown: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedElement: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedExtension: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedBackboneElement: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedNarrative: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedAnnotation: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedAttachment: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedIdentifier: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedCodeableConcept: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedCoding: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedQuantity: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedDuration: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedSimpleQuantity: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedDistance: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedCount: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedMoney: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedAge: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedRange: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedPeriod: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedRatio: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedReference: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedSampledData: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedSignature: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedHumanName: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedAddress: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedContactPoint: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedTiming: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedMeta: Specifies a value that SHALL be exactly the value  for this
            element in the instance. For purposes of comparison, non-significant
            whitespace is ignored, and all values must be an exact match (case and
            accent sensitive). Missing elements/attributes must also be missing.
        fixedElementDefinition: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedContactDetail: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedContributor: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedDosage: Specifies a value that SHALL be exactly the value  for
            this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedRelatedArtifact: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedUsageContext: Specifies a value that SHALL be exactly the value
            for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedDataRequirement: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedParameterDefinition: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        fixedTriggerDefinition: Specifies a value that SHALL be exactly the
            value  for this element in the instance. For purposes of comparison,
            non-significant whitespace is ignored, and all values must be an exact
            match (case and accent sensitive). Missing elements/attributes must
            also be missing.
        patternBoolean: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternInteger: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDecimal: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternBase64Binary: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternInstant: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternString: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternUri: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDate: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDateTime: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternTime: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternCode: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternOid: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternUuid: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternId: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternUnsignedInt: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternPositiveInt: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternMarkdown: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternElement: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternExtension: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternBackboneElement: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternNarrative: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternAnnotation: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternAttachment: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternIdentifier: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternCodeableConcept: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternCoding: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternQuantity: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDuration: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternSimpleQuantity: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDistance: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternCount: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternMoney: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternAge: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternRange: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternPeriod: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternRatio: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternReference: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternSampledData: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternSignature: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternHumanName: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternAddress: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternContactPoint: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternTiming: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternMeta: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternElementDefinition: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternContactDetail: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternContributor: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDosage: Specifies a value that the value in the instance SHALL
            follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternRelatedArtifact: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternUsageContext: Specifies a value that the value in the instance
            SHALL follow - that is, any value in the pattern must be found in the
            instance. Other additional values may be found too. This is
            effectively constraint by example.  The values of elements present in
            the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternDataRequirement: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternParameterDefinition: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        patternTriggerDefinition: Specifies a value that the value in the
            instance SHALL follow - that is, any value in the pattern must be
            found in the instance. Other additional values may be found too. This
            is effectively constraint by example.  The values of elements present
            in the pattern must match exactly (case-sensitive, accent-sensitive,
            etc.).
        example: A sample value for this element demonstrating the type of
            information that would typically be found in the element.
        minValueDate: The minimum allowed value for the element. The value is
            inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        minValueDateTime: The minimum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        minValueInstant: The minimum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        minValueTime: The minimum allowed value for the element. The value is
            inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        minValueDecimal: The minimum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        minValueInteger: The minimum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        minValuePositiveInt: The minimum allowed value for the element. The
            value is inclusive. This is allowed for the types date, dateTime,
            instant, time, decimal, integer, and Quantity.
        minValueUnsignedInt: The minimum allowed value for the element. The
            value is inclusive. This is allowed for the types date, dateTime,
            instant, time, decimal, integer, and Quantity.
        minValueQuantity: The minimum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValueDate: The maximum allowed value for the element. The value is
            inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValueDateTime: The maximum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValueInstant: The maximum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValueTime: The maximum allowed value for the element. The value is
            inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValueDecimal: The maximum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValueInteger: The maximum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxValuePositiveInt: The maximum allowed value for the element. The
            value is inclusive. This is allowed for the types date, dateTime,
            instant, time, decimal, integer, and Quantity.
        maxValueUnsignedInt: The maximum allowed value for the element. The
            value is inclusive. This is allowed for the types date, dateTime,
            instant, time, decimal, integer, and Quantity.
        maxValueQuantity: The maximum allowed value for the element. The value
            is inclusive. This is allowed for the types date, dateTime, instant,
            time, decimal, integer, and Quantity.
        maxLength: Indicates the maximum length in characters that is
            permitted to be present in conformant instances and which is expected
            to be supported by conformant consumers that support the element.
        condition: A reference to an invariant that may make additional
            statements about the cardinality or value in the instance.
        constraint: Formal constraints such as co-occurrence and other
            constraints that can be computationally evaluated within the context
            of the instance.
        mustSupport: If true, implementations that produce or consume
            resources SHALL provide "support" for the element in some meaningful
            way.  If false, the element may be ignored and not supported.
        isModifier: If true, the value of this element affects the
            interpretation of the element or resource that contains it, and the
            value of the element cannot be ignored. Typically, this is used for
            status, negation and qualification codes. The effect of this is that
            the element cannot be ignored by systems: they SHALL either recognize
            the element and process it, and/or a pre-determination has been made
            that it is not relevant to their particular system.
        isSummary: Whether the element should be included if a client requests
            a search with the parameter _summary=true.
        binding: Binds to a value set if this element is coded (code, Coding,
            CodeableConcept, Quantity), or the data types (string, uri).
        mapping: Identifies a concept from an external specification that
            roughly corresponds to this element.
    """

    __name__ = 'ElementDefinition'

    def __init__(self, dict_values=None):
        self.path = None
        # type: str

        self.representation = None
        # type: list
        # possible values: xmlAttr, xmlText, typeAttr, cdaText, xhtml

        self.sliceName = None
        # type: str

        self.label = None
        # type: str

        self.code = None
        # type: list
        # reference to Coding

        self.slicing = None
        # reference to ElementDefinition_Slicing

        self.short = None
        # type: str

        self.definition = None
        # type: str

        self.comment = None
        # type: str

        self.requirements = None
        # type: str

        self.alias = None
        # type: list

        self.min = None
        # type: int

        self.max = None
        # type: str

        self.base = None
        # reference to ElementDefinition_Base

        self.contentReference = None
        # type: str

        self.type = None
        # type: list
        # reference to ElementDefinition_Type

        self.defaultValueBoolean = None
        # type: bool

        self.defaultValueInteger = None
        # type: int

        self.defaultValueDecimal = None
        # type: int

        self.defaultValueBase64Binary = None
        # type: str

        self.defaultValueInstant = None
        # type: str

        self.defaultValueString = None
        # type: str

        self.defaultValueUri = None
        # type: str

        self.defaultValueDate = None
        # type: str

        self.defaultValueDateTime = None
        # type: str

        self.defaultValueTime = None
        # type: str

        self.defaultValueCode = None
        # type: str

        self.defaultValueOid = None
        # type: str

        self.defaultValueUuid = None
        # type: str

        self.defaultValueId = None
        # type: str

        self.defaultValueUnsignedInt = None
        # type: int

        self.defaultValuePositiveInt = None
        # type: int

        self.defaultValueMarkdown = None
        # type: str

        self.defaultValueElement = None
        # reference to Element: id

        self.defaultValueExtension = None
        # reference to Extension

        self.defaultValueBackboneElement = None
        # reference to BackboneElement

        self.defaultValueNarrative = None
        # reference to Narrative

        self.defaultValueAnnotation = None
        # reference to Annotation

        self.defaultValueAttachment = None
        # reference to Attachment

        self.defaultValueIdentifier = None
        # reference to Identifier

        self.defaultValueCodeableConcept = None
        # reference to CodeableConcept

        self.defaultValueCoding = None
        # reference to Coding

        self.defaultValueQuantity = None
        # reference to Quantity

        self.defaultValueDuration = None
        # reference to Duration

        self.defaultValueSimpleQuantity = None
        # reference to Quantity

        self.defaultValueDistance = None
        # reference to Distance

        self.defaultValueCount = None
        # reference to Count

        self.defaultValueMoney = None
        # reference to Money

        self.defaultValueAge = None
        # reference to Age

        self.defaultValueRange = None
        # reference to Range

        self.defaultValuePeriod = None
        # reference to Period

        self.defaultValueRatio = None
        # reference to Ratio

        self.defaultValueReference = None
        # reference to Reference: identifier

        self.defaultValueSampledData = None
        # reference to SampledData

        self.defaultValueSignature = None
        # reference to Signature

        self.defaultValueHumanName = None
        # reference to HumanName

        self.defaultValueAddress = None
        # reference to Address

        self.defaultValueContactPoint = None
        # reference to ContactPoint

        self.defaultValueTiming = None
        # reference to Timing

        self.defaultValueMeta = None
        # reference to Meta

        self.defaultValueElementDefinition = None
        # reference to ElementDefinition

        self.defaultValueContactDetail = None
        # reference to ContactDetail

        self.defaultValueContributor = None
        # reference to Contributor

        self.defaultValueDosage = None
        # reference to Dosage

        self.defaultValueRelatedArtifact = None
        # reference to RelatedArtifact

        self.defaultValueUsageContext = None
        # reference to UsageContext

        self.defaultValueDataRequirement = None
        # reference to DataRequirement

        self.defaultValueParameterDefinition = None
        # reference to ParameterDefinition

        self.defaultValueTriggerDefinition = None
        # reference to TriggerDefinition

        self.meaningWhenMissing = None
        # type: str

        self.orderMeaning = None
        # type: str

        self.fixedBoolean = None
        # type: bool

        self.fixedInteger = None
        # type: int

        self.fixedDecimal = None
        # type: int

        self.fixedBase64Binary = None
        # type: str

        self.fixedInstant = None
        # type: str

        self.fixedString = None
        # type: str

        self.fixedUri = None
        # type: str

        self.fixedDate = None
        # type: str

        self.fixedDateTime = None
        # type: str

        self.fixedTime = None
        # type: str

        self.fixedCode = None
        # type: str

        self.fixedOid = None
        # type: str

        self.fixedUuid = None
        # type: str

        self.fixedId = None
        # type: str

        self.fixedUnsignedInt = None
        # type: int

        self.fixedPositiveInt = None
        # type: int

        self.fixedMarkdown = None
        # type: str

        self.fixedElement = None
        # reference to Element: id

        self.fixedExtension = None
        # reference to Extension

        self.fixedBackboneElement = None
        # reference to BackboneElement

        self.fixedNarrative = None
        # reference to Narrative

        self.fixedAnnotation = None
        # reference to Annotation

        self.fixedAttachment = None
        # reference to Attachment

        self.fixedIdentifier = None
        # reference to Identifier

        self.fixedCodeableConcept = None
        # reference to CodeableConcept

        self.fixedCoding = None
        # reference to Coding

        self.fixedQuantity = None
        # reference to Quantity

        self.fixedDuration = None
        # reference to Duration

        self.fixedSimpleQuantity = None
        # reference to Quantity

        self.fixedDistance = None
        # reference to Distance

        self.fixedCount = None
        # reference to Count

        self.fixedMoney = None
        # reference to Money

        self.fixedAge = None
        # reference to Age

        self.fixedRange = None
        # reference to Range

        self.fixedPeriod = None
        # reference to Period

        self.fixedRatio = None
        # reference to Ratio

        self.fixedReference = None
        # reference to Reference: identifier

        self.fixedSampledData = None
        # reference to SampledData

        self.fixedSignature = None
        # reference to Signature

        self.fixedHumanName = None
        # reference to HumanName

        self.fixedAddress = None
        # reference to Address

        self.fixedContactPoint = None
        # reference to ContactPoint

        self.fixedTiming = None
        # reference to Timing

        self.fixedMeta = None
        # reference to Meta

        self.fixedElementDefinition = None
        # reference to ElementDefinition

        self.fixedContactDetail = None
        # reference to ContactDetail

        self.fixedContributor = None
        # reference to Contributor

        self.fixedDosage = None
        # reference to Dosage

        self.fixedRelatedArtifact = None
        # reference to RelatedArtifact

        self.fixedUsageContext = None
        # reference to UsageContext

        self.fixedDataRequirement = None
        # reference to DataRequirement

        self.fixedParameterDefinition = None
        # reference to ParameterDefinition

        self.fixedTriggerDefinition = None
        # reference to TriggerDefinition

        self.patternBoolean = None
        # type: bool

        self.patternInteger = None
        # type: int

        self.patternDecimal = None
        # type: int

        self.patternBase64Binary = None
        # type: str

        self.patternInstant = None
        # type: str

        self.patternString = None
        # type: str

        self.patternUri = None
        # type: str

        self.patternDate = None
        # type: str

        self.patternDateTime = None
        # type: str

        self.patternTime = None
        # type: str

        self.patternCode = None
        # type: str

        self.patternOid = None
        # type: str

        self.patternUuid = None
        # type: str

        self.patternId = None
        # type: str

        self.patternUnsignedInt = None
        # type: int

        self.patternPositiveInt = None
        # type: int

        self.patternMarkdown = None
        # type: str

        self.patternElement = None
        # reference to Element: id

        self.patternExtension = None
        # reference to Extension

        self.patternBackboneElement = None
        # reference to BackboneElement

        self.patternNarrative = None
        # reference to Narrative

        self.patternAnnotation = None
        # reference to Annotation

        self.patternAttachment = None
        # reference to Attachment

        self.patternIdentifier = None
        # reference to Identifier

        self.patternCodeableConcept = None
        # reference to CodeableConcept

        self.patternCoding = None
        # reference to Coding

        self.patternQuantity = None
        # reference to Quantity

        self.patternDuration = None
        # reference to Duration

        self.patternSimpleQuantity = None
        # reference to Quantity

        self.patternDistance = None
        # reference to Distance

        self.patternCount = None
        # reference to Count

        self.patternMoney = None
        # reference to Money

        self.patternAge = None
        # reference to Age

        self.patternRange = None
        # reference to Range

        self.patternPeriod = None
        # reference to Period

        self.patternRatio = None
        # reference to Ratio

        self.patternReference = None
        # reference to Reference: identifier

        self.patternSampledData = None
        # reference to SampledData

        self.patternSignature = None
        # reference to Signature

        self.patternHumanName = None
        # reference to HumanName

        self.patternAddress = None
        # reference to Address

        self.patternContactPoint = None
        # reference to ContactPoint

        self.patternTiming = None
        # reference to Timing

        self.patternMeta = None
        # reference to Meta

        self.patternElementDefinition = None
        # reference to ElementDefinition

        self.patternContactDetail = None
        # reference to ContactDetail

        self.patternContributor = None
        # reference to Contributor

        self.patternDosage = None
        # reference to Dosage

        self.patternRelatedArtifact = None
        # reference to RelatedArtifact

        self.patternUsageContext = None
        # reference to UsageContext

        self.patternDataRequirement = None
        # reference to DataRequirement

        self.patternParameterDefinition = None
        # reference to ParameterDefinition

        self.patternTriggerDefinition = None
        # reference to TriggerDefinition

        self.example = None
        # type: list
        # reference to ElementDefinition_Example

        self.minValueDate = None
        # type: str

        self.minValueDateTime = None
        # type: str

        self.minValueInstant = None
        # type: str

        self.minValueTime = None
        # type: str

        self.minValueDecimal = None
        # type: int

        self.minValueInteger = None
        # type: int

        self.minValuePositiveInt = None
        # type: int

        self.minValueUnsignedInt = None
        # type: int

        self.minValueQuantity = None
        # reference to Quantity

        self.maxValueDate = None
        # type: str

        self.maxValueDateTime = None
        # type: str

        self.maxValueInstant = None
        # type: str

        self.maxValueTime = None
        # type: str

        self.maxValueDecimal = None
        # type: int

        self.maxValueInteger = None
        # type: int

        self.maxValuePositiveInt = None
        # type: int

        self.maxValueUnsignedInt = None
        # type: int

        self.maxValueQuantity = None
        # reference to Quantity

        self.maxLength = None
        # type: int

        self.condition = None
        # type: list

        self.constraint = None
        # type: list
        # reference to ElementDefinition_Constraint

        self.mustSupport = None
        # type: bool

        self.isModifier = None
        # type: bool

        self.isSummary = None
        # type: bool

        self.binding = None
        # reference to ElementDefinition_Binding

        self.mapping = None
        # type: list
        # reference to ElementDefinition_Mapping

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
            self.assert_type()

    def assert_type(self):

        if self.representation is not None:
            for value in self.representation:
                if value is not None and value.lower() not in [
                        'xmlattr', 'xmltext', 'typeattr', 'cdatext', 'xhtml']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'xmlAttr, xmlText, typeAttr, cdaText, xhtml'))

    def get_relationships(self):

        return [
            {'parent_entity': 'Money',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedMoney'},

            {'parent_entity': 'ElementDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueElementDefinition'},

            {'parent_entity': 'Reference',
             'parent_variable': 'identifier',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedReference'},

            {'parent_entity': 'Narrative',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternNarrative'},

            {'parent_entity': 'Duration',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueDuration'},

            {'parent_entity': 'Timing',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueTiming'},

            {'parent_entity': 'RelatedArtifact',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedRelatedArtifact'},

            {'parent_entity': 'TriggerDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueTriggerDefinition'},

            {'parent_entity': 'Age',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedAge'},

            {'parent_entity': 'Attachment',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueAttachment'},

            {'parent_entity': 'Extension',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternExtension'},

            {'parent_entity': 'ElementDefinition_Type',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'type'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedSimpleQuantity'},

            {'parent_entity': 'Narrative',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueNarrative'},

            {'parent_entity': 'Element',
             'parent_variable': 'id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueElement'},

            {'parent_entity': 'Count',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueCount'},

            {'parent_entity': 'Period',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternPeriod'},

            {'parent_entity': 'Identifier',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternIdentifier'},

            {'parent_entity': 'UsageContext',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueUsageContext'},

            {'parent_entity': 'Ratio',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternRatio'},

            {'parent_entity': 'Attachment',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternAttachment'},

            {'parent_entity': 'Annotation',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedAnnotation'},

            {'parent_entity': 'ElementDefinition_Constraint',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'constraint'},

            {'parent_entity': 'CodeableConcept',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueCodeableConcept'},

            {'parent_entity': 'Count',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedCount'},

            {'parent_entity': 'CodeableConcept',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternCodeableConcept'},

            {'parent_entity': 'HumanName',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternHumanName'},

            {'parent_entity': 'DataRequirement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueDataRequirement'},

            {'parent_entity': 'ElementDefinition_Slicing',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'slicing'},

            {'parent_entity': 'Count',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternCount'},

            {'parent_entity': 'HumanName',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueHumanName'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueSimpleQuantity'},

            {'parent_entity': 'Age',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternAge'},

            {'parent_entity': 'Dosage',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternDosage'},

            {'parent_entity': 'UsageContext',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedUsageContext'},

            {'parent_entity': 'Contributor',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternContributor'},

            {'parent_entity': 'ContactDetail',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueContactDetail'},

            {'parent_entity': 'RelatedArtifact',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternRelatedArtifact'},

            {'parent_entity': 'Coding',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueCoding'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueQuantity'},

            {'parent_entity': 'Identifier',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedIdentifier'},

            {'parent_entity': 'ElementDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternElementDefinition'},

            {'parent_entity': 'CodeableConcept',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedCodeableConcept'},

            {'parent_entity': 'DataRequirement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedDataRequirement'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedQuantity'},

            {'parent_entity': 'Timing',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternTiming'},

            {'parent_entity': 'ElementDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedElementDefinition'},

            {'parent_entity': 'Dosage',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedDosage'},

            {'parent_entity': 'Range',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueRange'},

            {'parent_entity': 'Duration',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternDuration'},

            {'parent_entity': 'ElementDefinition_Binding',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'binding'},

            {'parent_entity': 'ContactDetail',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternContactDetail'},

            {'parent_entity': 'DataRequirement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternDataRequirement'},

            {'parent_entity': 'Distance',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternDistance'},

            {'parent_entity': 'Extension',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueExtension'},

            {'parent_entity': 'Meta',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueMeta'},

            {'parent_entity': 'Period',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedPeriod'},

            {'parent_entity': 'BackboneElement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternBackboneElement'},

            {'parent_entity': 'ElementDefinition_Base',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'base'},

            {'parent_entity': 'Range',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternRange'},

            {'parent_entity': 'Element',
             'parent_variable': 'id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternElement'},

            {'parent_entity': 'Contributor',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedContributor'},

            {'parent_entity': 'Address',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternAddress'},

            {'parent_entity': 'SampledData',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueSampledData'},

            {'parent_entity': 'Element',
             'parent_variable': 'id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedElement'},

            {'parent_entity': 'ParameterDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternParameterDefinition'},

            {'parent_entity': 'Annotation',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternAnnotation'},

            {'parent_entity': 'Range',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedRange'},

            {'parent_entity': 'TriggerDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternTriggerDefinition'},

            {'parent_entity': 'Money',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternMoney'},

            {'parent_entity': 'Coding',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'code'},

            {'parent_entity': 'Extension',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedExtension'},

            {'parent_entity': 'Reference',
             'parent_variable': 'identifier',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternReference'},

            {'parent_entity': 'BackboneElement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedBackboneElement'},

            {'parent_entity': 'Dosage',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueDosage'},

            {'parent_entity': 'Reference',
             'parent_variable': 'identifier',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueReference'},

            {'parent_entity': 'RelatedArtifact',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueRelatedArtifact'},

            {'parent_entity': 'Meta',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedMeta'},

            {'parent_entity': 'SampledData',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedSampledData'},

            {'parent_entity': 'ContactPoint',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternContactPoint'},

            {'parent_entity': 'Meta',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternMeta'},

            {'parent_entity': 'UsageContext',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternUsageContext'},

            {'parent_entity': 'Signature',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedSignature'},

            {'parent_entity': 'Coding',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternCoding'},

            {'parent_entity': 'Money',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueMoney'},

            {'parent_entity': 'Duration',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedDuration'},

            {'parent_entity': 'Narrative',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedNarrative'},

            {'parent_entity': 'Distance',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedDistance'},

            {'parent_entity': 'Address',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueAddress'},

            {'parent_entity': 'ContactPoint',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueContactPoint'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'minValueQuantity'},

            {'parent_entity': 'ContactPoint',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedContactPoint'},

            {'parent_entity': 'Signature',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternSignature'},

            {'parent_entity': 'Ratio',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueRatio'},

            {'parent_entity': 'ParameterDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedParameterDefinition'},

            {'parent_entity': 'Age',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueAge'},

            {'parent_entity': 'Timing',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedTiming'},

            {'parent_entity': 'Contributor',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueContributor'},

            {'parent_entity': 'Coding',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedCoding'},

            {'parent_entity': 'Ratio',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedRatio'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'maxValueQuantity'},

            {'parent_entity': 'Address',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedAddress'},

            {'parent_entity': 'ElementDefinition_Example',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'example'},

            {'parent_entity': 'Period',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValuePeriod'},

            {'parent_entity': 'Attachment',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedAttachment'},

            {'parent_entity': 'BackboneElement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueBackboneElement'},

            {'parent_entity': 'HumanName',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedHumanName'},

            {'parent_entity': 'Annotation',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueAnnotation'},

            {'parent_entity': 'Identifier',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueIdentifier'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternSimpleQuantity'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternQuantity'},

            {'parent_entity': 'Signature',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueSignature'},

            {'parent_entity': 'SampledData',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'patternSampledData'},

            {'parent_entity': 'Distance',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueDistance'},

            {'parent_entity': 'ParameterDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'defaultValueParameterDefinition'},

            {'parent_entity': 'ContactDetail',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedContactDetail'},

            {'parent_entity': 'TriggerDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'fixedTriggerDefinition'},

            {'parent_entity': 'ElementDefinition_Mapping',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition',
             'child_variable': 'mapping'},
        ]


class ElementDefinition_Slicing(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        discriminator: Designates which child elements are used to
            discriminate between the slices when processing an instance. If one or
            more discriminators are provided, the value of the child elements in
            the instance data SHALL completely distinguish which slice the element
            in the resource matches based on the allowed values for those elements
            in each of the slices.
        description: A human-readable text description of how the slicing
            works. If there is no discriminator, this is required to be present to
            provide whatever information is possible about how the slices can be
            differentiated.
        ordered: If the matching elements have to occur in the same order as
            defined in the profile.
        rules: Whether additional slices are allowed or not. When the slices
            are ordered, profile authors can also say that additional slices are
            only allowed at the end.
    """

    __name__ = 'ElementDefinition_Slicing'

    def __init__(self, dict_values=None):
        self.discriminator = None
        # type: list
        # reference to ElementDefinition_Discriminator

        self.description = None
        # type: str

        self.ordered = None
        # type: bool

        self.rules = None
        # type: str
        # possible values: closed, open, openAtEnd

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
            self.assert_type()

    def assert_type(self):

        if self.rules is not None:
            for value in self.rules:
                if value is not None and value.lower() not in [
                        'closed', 'open', 'openatend']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'closed, open, openAtEnd'))

    def get_relationships(self):

        return [
            {'parent_entity': 'ElementDefinition_Discriminator',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Slicing',
             'child_variable': 'discriminator'},
        ]


class ElementDefinition_Discriminator(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        type: How the element value is interpreted when discrimination is
            evaluated.
        path: A FHIRPath expression, using a restricted subset of FHIRPath,
            that is used to identify the element on which discrimination is based.
    """

    __name__ = 'ElementDefinition_Discriminator'

    def __init__(self, dict_values=None):
        self.type = None
        # type: str
        # possible values: value, exists, pattern, type, profile

        self.path = None
        # type: str

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
            self.assert_type()

    def assert_type(self):

        if self.type is not None:
            for value in self.type:
                if value is not None and value.lower() not in [
                        'value', 'exists', 'pattern', 'type', 'profile']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'value, exists, pattern, type, profile'))


class ElementDefinition_Base(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        path: The Path that identifies the base element - this matches the
            ElementDefinition.path for that element. Across FHIR, there is only
            one base definition of any element - that is, an element definition on
            a [[[StructureDefinition]]] without a StructureDefinition.base.
        min: Minimum cardinality of the base element identified by the path.
        max: Maximum cardinality of the base element identified by the path.
    """

    __name__ = 'ElementDefinition_Base'

    def __init__(self, dict_values=None):
        self.path = None
        # type: str

        self.min = None
        # type: int

        self.max = None
        # type: str

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)


class ElementDefinition_Type(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        code: URL of Data type or Resource that is a(or the) type used for
            this element. References are URLs that are relative to
            http://hl7.org/fhir/StructureDefinition e.g. "string" is a reference
            to http://hl7.org/fhir/StructureDefinition/string. Absolute URLs are
            only allowed in logical models.
        profile: Identifies a profile structure or implementation Guide that
            SHALL hold for the datatype this element refers to. Can be a local
            reference - to a contained StructureDefinition, or a reference to
            another StructureDefinition or Implementation Guide by a canonical
            URL. When an implementation guide is specified, the resource SHALL
            conform to at least one profile defined in the implementation guide.
        targetProfile: Identifies a profile structure or implementation Guide
            that SHALL hold for the target of the reference this element refers
            to. Can be a local reference - to a contained StructureDefinition, or
            a reference to another StructureDefinition or Implementation Guide by
            a canonical URL. When an implementation guide is specified, the
            resource SHALL conform to at least one profile defined in the
            implementation guide.
        aggregation: If the type is a reference to another resource, how the
            resource is or can be aggregated - is it a contained resource, or a
            reference, and if the context is a bundle, is it included in the
            bundle.
        versioning: Whether this reference needs to be version specific or
            version independent, or whether either can be used.
    """

    __name__ = 'ElementDefinition_Type'

    def __init__(self, dict_values=None):
        self.code = None
        # type: str

        self.profile = None
        # type: str

        self.targetProfile = None
        # type: str

        self.aggregation = None
        # type: list
        # possible values: contained, referenced, bundled

        self.versioning = None
        # type: str
        # possible values: either, independent, specific

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
            self.assert_type()

    def assert_type(self):

        if self.aggregation is not None:
            for value in self.aggregation:
                if value is not None and value.lower() not in [
                        'contained', 'referenced', 'bundled']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'contained, referenced, bundled'))

        if self.versioning is not None:
            for value in self.versioning:
                if value is not None and value.lower() not in [
                        'either', 'independent', 'specific']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'either, independent, specific'))


class ElementDefinition_Example(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        label: Describes the purpose of this example amoung the set of
            examples.
        valueBoolean: The actual value for the element, which must be one of
            the types allowed for this element.
        valueInteger: The actual value for the element, which must be one of
            the types allowed for this element.
        valueDecimal: The actual value for the element, which must be one of
            the types allowed for this element.
        valueBase64Binary: The actual value for the element, which must be one
            of the types allowed for this element.
        valueInstant: The actual value for the element, which must be one of
            the types allowed for this element.
        valueString: The actual value for the element, which must be one of
            the types allowed for this element.
        valueUri: The actual value for the element, which must be one of the
            types allowed for this element.
        valueDate: The actual value for the element, which must be one of the
            types allowed for this element.
        valueDateTime: The actual value for the element, which must be one of
            the types allowed for this element.
        valueTime: The actual value for the element, which must be one of the
            types allowed for this element.
        valueCode: The actual value for the element, which must be one of the
            types allowed for this element.
        valueOid: The actual value for the element, which must be one of the
            types allowed for this element.
        valueUuid: The actual value for the element, which must be one of the
            types allowed for this element.
        valueId: The actual value for the element, which must be one of the
            types allowed for this element.
        valueUnsignedInt: The actual value for the element, which must be one
            of the types allowed for this element.
        valuePositiveInt: The actual value for the element, which must be one
            of the types allowed for this element.
        valueMarkdown: The actual value for the element, which must be one of
            the types allowed for this element.
        valueElement: The actual value for the element, which must be one of
            the types allowed for this element.
        valueExtension: The actual value for the element, which must be one of
            the types allowed for this element.
        valueBackboneElement: The actual value for the element, which must be
            one of the types allowed for this element.
        valueNarrative: The actual value for the element, which must be one of
            the types allowed for this element.
        valueAnnotation: The actual value for the element, which must be one
            of the types allowed for this element.
        valueAttachment: The actual value for the element, which must be one
            of the types allowed for this element.
        valueIdentifier: The actual value for the element, which must be one
            of the types allowed for this element.
        valueCodeableConcept: The actual value for the element, which must be
            one of the types allowed for this element.
        valueCoding: The actual value for the element, which must be one of
            the types allowed for this element.
        valueQuantity: The actual value for the element, which must be one of
            the types allowed for this element.
        valueDuration: The actual value for the element, which must be one of
            the types allowed for this element.
        valueSimpleQuantity: The actual value for the element, which must be
            one of the types allowed for this element.
        valueDistance: The actual value for the element, which must be one of
            the types allowed for this element.
        valueCount: The actual value for the element, which must be one of the
            types allowed for this element.
        valueMoney: The actual value for the element, which must be one of the
            types allowed for this element.
        valueAge: The actual value for the element, which must be one of the
            types allowed for this element.
        valueRange: The actual value for the element, which must be one of the
            types allowed for this element.
        valuePeriod: The actual value for the element, which must be one of
            the types allowed for this element.
        valueRatio: The actual value for the element, which must be one of the
            types allowed for this element.
        valueReference: The actual value for the element, which must be one of
            the types allowed for this element.
        valueSampledData: The actual value for the element, which must be one
            of the types allowed for this element.
        valueSignature: The actual value for the element, which must be one of
            the types allowed for this element.
        valueHumanName: The actual value for the element, which must be one of
            the types allowed for this element.
        valueAddress: The actual value for the element, which must be one of
            the types allowed for this element.
        valueContactPoint: The actual value for the element, which must be one
            of the types allowed for this element.
        valueTiming: The actual value for the element, which must be one of
            the types allowed for this element.
        valueMeta: The actual value for the element, which must be one of the
            types allowed for this element.
        valueElementDefinition: The actual value for the element, which must
            be one of the types allowed for this element.
        valueContactDetail: The actual value for the element, which must be
            one of the types allowed for this element.
        valueContributor: The actual value for the element, which must be one
            of the types allowed for this element.
        valueDosage: The actual value for the element, which must be one of
            the types allowed for this element.
        valueRelatedArtifact: The actual value for the element, which must be
            one of the types allowed for this element.
        valueUsageContext: The actual value for the element, which must be one
            of the types allowed for this element.
        valueDataRequirement: The actual value for the element, which must be
            one of the types allowed for this element.
        valueParameterDefinition: The actual value for the element, which must
            be one of the types allowed for this element.
        valueTriggerDefinition: The actual value for the element, which must
            be one of the types allowed for this element.
    """

    __name__ = 'ElementDefinition_Example'

    def __init__(self, dict_values=None):
        self.label = None
        # type: str

        self.valueBoolean = None
        # type: bool

        self.valueInteger = None
        # type: int

        self.valueDecimal = None
        # type: int

        self.valueBase64Binary = None
        # type: str

        self.valueInstant = None
        # type: str

        self.valueString = None
        # type: str

        self.valueUri = None
        # type: str

        self.valueDate = None
        # type: str

        self.valueDateTime = None
        # type: str

        self.valueTime = None
        # type: str

        self.valueCode = None
        # type: str

        self.valueOid = None
        # type: str

        self.valueUuid = None
        # type: str

        self.valueId = None
        # type: str

        self.valueUnsignedInt = None
        # type: int

        self.valuePositiveInt = None
        # type: int

        self.valueMarkdown = None
        # type: str

        self.valueElement = None
        # reference to Element: id

        self.valueExtension = None
        # reference to Extension

        self.valueBackboneElement = None
        # reference to BackboneElement

        self.valueNarrative = None
        # reference to Narrative

        self.valueAnnotation = None
        # reference to Annotation

        self.valueAttachment = None
        # reference to Attachment

        self.valueIdentifier = None
        # reference to Identifier

        self.valueCodeableConcept = None
        # reference to CodeableConcept

        self.valueCoding = None
        # reference to Coding

        self.valueQuantity = None
        # reference to Quantity

        self.valueDuration = None
        # reference to Duration

        self.valueSimpleQuantity = None
        # reference to Quantity

        self.valueDistance = None
        # reference to Distance

        self.valueCount = None
        # reference to Count

        self.valueMoney = None
        # reference to Money

        self.valueAge = None
        # reference to Age

        self.valueRange = None
        # reference to Range

        self.valuePeriod = None
        # reference to Period

        self.valueRatio = None
        # reference to Ratio

        self.valueReference = None
        # reference to Reference: identifier

        self.valueSampledData = None
        # reference to SampledData

        self.valueSignature = None
        # reference to Signature

        self.valueHumanName = None
        # reference to HumanName

        self.valueAddress = None
        # reference to Address

        self.valueContactPoint = None
        # reference to ContactPoint

        self.valueTiming = None
        # reference to Timing

        self.valueMeta = None
        # reference to Meta

        self.valueElementDefinition = None

        self.valueContactDetail = None
        # reference to ContactDetail

        self.valueContributor = None
        # reference to Contributor

        self.valueDosage = None
        # reference to Dosage

        self.valueRelatedArtifact = None
        # reference to RelatedArtifact

        self.valueUsageContext = None
        # reference to UsageContext

        self.valueDataRequirement = None
        # reference to DataRequirement

        self.valueParameterDefinition = None
        # reference to ParameterDefinition

        self.valueTriggerDefinition = None
        # reference to TriggerDefinition

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)

    def get_relationships(self):

        return [
            {'parent_entity': 'Address',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueAddress'},

            {'parent_entity': 'CodeableConcept',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueCodeableConcept'},

            {'parent_entity': 'ParameterDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueParameterDefinition'},

            {'parent_entity': 'Identifier',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueIdentifier'},

            {'parent_entity': 'Distance',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueDistance'},

            {'parent_entity': 'Period',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valuePeriod'},

            {'parent_entity': 'Duration',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueDuration'},

            {'parent_entity': 'Signature',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueSignature'},

            {'parent_entity': 'BackboneElement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueBackboneElement'},

            {'parent_entity': 'Range',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueRange'},

            {'parent_entity': 'Dosage',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueDosage'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueQuantity'},

            {'parent_entity': 'Money',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueMoney'},

            {'parent_entity': 'Quantity',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueSimpleQuantity'},

            {'parent_entity': 'DataRequirement',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueDataRequirement'},

            {'parent_entity': 'HumanName',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueHumanName'},

            {'parent_entity': 'UsageContext',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueUsageContext'},

            {'parent_entity': 'Contributor',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueContributor'},

            {'parent_entity': 'Annotation',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueAnnotation'},

            {'parent_entity': 'SampledData',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueSampledData'},

            {'parent_entity': 'ContactPoint',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueContactPoint'},

            {'parent_entity': 'Narrative',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueNarrative'},

            {'parent_entity': 'Meta',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueMeta'},

            {'parent_entity': 'RelatedArtifact',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueRelatedArtifact'},

            {'parent_entity': 'TriggerDefinition',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueTriggerDefinition'},

            {'parent_entity': 'Age',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueAge'},

            {'parent_entity': 'Count',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueCount'},

            {'parent_entity': 'ContactDetail',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueContactDetail'},

            {'parent_entity': 'Reference',
             'parent_variable': 'identifier',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueReference'},

            {'parent_entity': 'Timing',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueTiming'},

            {'parent_entity': 'Attachment',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueAttachment'},

            {'parent_entity': 'Ratio',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueRatio'},

            {'parent_entity': 'Element',
             'parent_variable': 'id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueElement'},

            {'parent_entity': 'Extension',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueExtension'},

            {'parent_entity': 'Coding',
             'parent_variable': 'object_id',
             'child_entity': 'ElementDefinition_Example',
             'child_variable': 'valueCoding'},
        ]


class ElementDefinition_Constraint(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        key: Allows identification of which elements have their cardinalities
            impacted by the constraint.  Will not be referenced for constraints
            that do not affect cardinality.
        requirements: Description of why this constraint is necessary or
            appropriate.
        severity: Identifies the impact constraint violation has on the
            conformance of the instance.
        human: Text that can be used to describe the constraint in messages
            identifying that the constraint has been violated.
        expression: A [FHIRPath](http://hl7.org/fluentpath) expression of
            constraint that can be executed to see if this constraint is met.
        xpath: An XPath expression of constraint that can be executed to see
            if this constraint is met.
        source: A reference to the original source of the constraint, for
            traceability purposes.
    """

    __name__ = 'ElementDefinition_Constraint'

    def __init__(self, dict_values=None):
        self.key = None
        # type: str

        self.requirements = None
        # type: str

        self.severity = None
        # type: str
        # possible values: error, warning

        self.human = None
        # type: str

        self.expression = None
        # type: str

        self.xpath = None
        # type: str

        self.source = None
        # type: str

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
            self.assert_type()

    def assert_type(self):

        if self.severity is not None:
            for value in self.severity:
                if value is not None and value.lower() not in [
                        'error', 'warning']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'error, warning'))


class ElementDefinition_Binding(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        strength: Indicates the degree of conformance expectations associated
            with this binding - that is, the degree to which the provided value
            set must be adhered to in the instances.
        description: Describes the intended use of this particular set of
            codes.
        valueSetUri: Points to the value set or external definition (e.g.
            implicit value set) that identifies the set of codes to be used. If
            the binding refers to an explicit value set - the normal case - then
            use a Reference(ValueSet) preferably containing the canonical URL for
            the value set. If the reference is to an implicit value set - usually,
            an IETF RFC that defines a grammar, such as mime types - then use a
            uri.
        valueSetReference: Points to the value set or external definition
            (e.g. implicit value set) that identifies the set of codes to be used.
            If the binding refers to an explicit value set - the normal case -
            then use a Reference(ValueSet) preferably containing the canonical URL
            for the value set. If the reference is to an implicit value set -
            usually, an IETF RFC that defines a grammar, such as mime types - then
            use a uri.
    """

    __name__ = 'ElementDefinition_Binding'

    def __init__(self, dict_values=None):
        self.strength = None
        # type: str
        # possible values: required, extensible, preferred, example

        self.description = None
        # type: str

        self.valueSetUri = None
        # type: str

        self.valueSetReference = None
        # reference to Reference: identifier

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
            self.assert_type()

    def assert_type(self):

        if self.strength is not None:
            for value in self.strength:
                if value is not None and value.lower() not in [
                        'required', 'extensible', 'preferred', 'example']:
                    raise ValueError('"{}" does not match possible values: {}'.format(
                        value, 'required, extensible, preferred, example'))

    def get_relationships(self):

        return [
            {'parent_entity': 'Reference',
             'parent_variable': 'identifier',
             'child_entity': 'ElementDefinition_Binding',
             'child_variable': 'valueSetReference'},
        ]


class ElementDefinition_Mapping(fhirbase):
    """
    Captures constraints on each element within the resource, profile, or
    extension.

    Attributes:
        identity: An internal reference to the definition of a mapping.
        language: Identifies the computable language in which mapping.map is
            expressed.
        map: Expresses what part of the target specification corresponds to
            this element.
        comment: Comments that provide information about the mapping or its
            use.
    """

    __name__ = 'ElementDefinition_Mapping'

    def __init__(self, dict_values=None):
        self.identity = None
        # type: str

        self.language = None
        # type: str

        self.map = None
        # type: str

        self.comment = None
        # type: str

        self.object_id = None
        # unique identifier for object class

        if dict_values:
            self.set_attributes(dict_values)
