# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ChannelCustomerManagedS3',
    'ChannelRetentionPeriod',
    'ChannelServiceManagedS3',
    'ChannelStorage',
    'ChannelTag',
    'DatasetAction',
    'DatasetContainerAction',
    'DatasetContentDeliveryRule',
    'DatasetContentDeliveryRuleDestination',
    'DatasetContentVersionValue',
    'DatasetDeltaTime',
    'DatasetDeltaTimeSessionWindowConfiguration',
    'DatasetFilter',
    'DatasetGlueConfiguration',
    'DatasetIotEventsDestinationConfiguration',
    'DatasetLateDataRule',
    'DatasetLateDataRuleConfiguration',
    'DatasetOutputFileUriValue',
    'DatasetQueryAction',
    'DatasetResourceConfiguration',
    'DatasetRetentionPeriod',
    'DatasetS3DestinationConfiguration',
    'DatasetSchedule',
    'DatasetTag',
    'DatasetTrigger',
    'DatasetTriggeringDataset',
    'DatasetVariable',
    'DatasetVersioningConfiguration',
    'DatastoreColumn',
    'DatastoreCustomerManagedS3',
    'DatastoreCustomerManagedS3Storage',
    'DatastoreFileFormatConfiguration',
    'DatastoreIotSiteWiseMultiLayerStorage',
    'DatastoreJsonConfiguration',
    'DatastoreParquetConfiguration',
    'DatastorePartition',
    'DatastorePartitions',
    'DatastoreRetentionPeriod',
    'DatastoreSchemaDefinition',
    'DatastoreServiceManagedS3',
    'DatastoreStorage',
    'DatastoreTag',
    'DatastoreTimestampPartition',
    'PipelineActivity',
    'PipelineAddAttributes',
    'PipelineChannel',
    'PipelineDatastore',
    'PipelineDeviceRegistryEnrich',
    'PipelineDeviceShadowEnrich',
    'PipelineFilter',
    'PipelineLambda',
    'PipelineMath',
    'PipelineRemoveAttributes',
    'PipelineSelectAttributes',
    'PipelineTag',
]

@pulumi.output_type
class ChannelCustomerManagedS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelCustomerManagedS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelCustomerManagedS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelCustomerManagedS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 role_arn: str,
                 key_prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "role_arn", role_arn)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[str]:
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class ChannelRetentionPeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfDays":
            suggest = "number_of_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelRetentionPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelRetentionPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelRetentionPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number_of_days: Optional[int] = None,
                 unlimited: Optional[bool] = None):
        if number_of_days is not None:
            pulumi.set(__self__, "number_of_days", number_of_days)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="numberOfDays")
    def number_of_days(self) -> Optional[int]:
        return pulumi.get(self, "number_of_days")

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[bool]:
        return pulumi.get(self, "unlimited")


@pulumi.output_type
class ChannelServiceManagedS3(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class ChannelStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedS3":
            suggest = "customer_managed_s3"
        elif key == "serviceManagedS3":
            suggest = "service_managed_s3"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_s3: Optional['outputs.ChannelCustomerManagedS3'] = None,
                 service_managed_s3: Optional['outputs.ChannelServiceManagedS3'] = None):
        if customer_managed_s3 is not None:
            pulumi.set(__self__, "customer_managed_s3", customer_managed_s3)
        if service_managed_s3 is not None:
            pulumi.set(__self__, "service_managed_s3", service_managed_s3)

    @property
    @pulumi.getter(name="customerManagedS3")
    def customer_managed_s3(self) -> Optional['outputs.ChannelCustomerManagedS3']:
        return pulumi.get(self, "customer_managed_s3")

    @property
    @pulumi.getter(name="serviceManagedS3")
    def service_managed_s3(self) -> Optional['outputs.ChannelServiceManagedS3']:
        return pulumi.get(self, "service_managed_s3")


@pulumi.output_type
class ChannelTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DatasetAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionName":
            suggest = "action_name"
        elif key == "containerAction":
            suggest = "container_action"
        elif key == "queryAction":
            suggest = "query_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_name: str,
                 container_action: Optional['outputs.DatasetContainerAction'] = None,
                 query_action: Optional['outputs.DatasetQueryAction'] = None):
        pulumi.set(__self__, "action_name", action_name)
        if container_action is not None:
            pulumi.set(__self__, "container_action", container_action)
        if query_action is not None:
            pulumi.set(__self__, "query_action", query_action)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> str:
        return pulumi.get(self, "action_name")

    @property
    @pulumi.getter(name="containerAction")
    def container_action(self) -> Optional['outputs.DatasetContainerAction']:
        return pulumi.get(self, "container_action")

    @property
    @pulumi.getter(name="queryAction")
    def query_action(self) -> Optional['outputs.DatasetQueryAction']:
        return pulumi.get(self, "query_action")


@pulumi.output_type
class DatasetContainerAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "resourceConfiguration":
            suggest = "resource_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetContainerAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetContainerAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetContainerAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role_arn: str,
                 image: str,
                 resource_configuration: 'outputs.DatasetResourceConfiguration',
                 variables: Optional[Sequence['outputs.DatasetVariable']] = None):
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "resource_configuration", resource_configuration)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> str:
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def image(self) -> str:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="resourceConfiguration")
    def resource_configuration(self) -> 'outputs.DatasetResourceConfiguration':
        return pulumi.get(self, "resource_configuration")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.DatasetVariable']]:
        return pulumi.get(self, "variables")


@pulumi.output_type
class DatasetContentDeliveryRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryName":
            suggest = "entry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetContentDeliveryRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetContentDeliveryRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetContentDeliveryRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.DatasetContentDeliveryRuleDestination',
                 entry_name: Optional[str] = None):
        pulumi.set(__self__, "destination", destination)
        if entry_name is not None:
            pulumi.set(__self__, "entry_name", entry_name)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.DatasetContentDeliveryRuleDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="entryName")
    def entry_name(self) -> Optional[str]:
        return pulumi.get(self, "entry_name")


@pulumi.output_type
class DatasetContentDeliveryRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iotEventsDestinationConfiguration":
            suggest = "iot_events_destination_configuration"
        elif key == "s3DestinationConfiguration":
            suggest = "s3_destination_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetContentDeliveryRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetContentDeliveryRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetContentDeliveryRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iot_events_destination_configuration: Optional['outputs.DatasetIotEventsDestinationConfiguration'] = None,
                 s3_destination_configuration: Optional['outputs.DatasetS3DestinationConfiguration'] = None):
        if iot_events_destination_configuration is not None:
            pulumi.set(__self__, "iot_events_destination_configuration", iot_events_destination_configuration)
        if s3_destination_configuration is not None:
            pulumi.set(__self__, "s3_destination_configuration", s3_destination_configuration)

    @property
    @pulumi.getter(name="iotEventsDestinationConfiguration")
    def iot_events_destination_configuration(self) -> Optional['outputs.DatasetIotEventsDestinationConfiguration']:
        return pulumi.get(self, "iot_events_destination_configuration")

    @property
    @pulumi.getter(name="s3DestinationConfiguration")
    def s3_destination_configuration(self) -> Optional['outputs.DatasetS3DestinationConfiguration']:
        return pulumi.get(self, "s3_destination_configuration")


@pulumi.output_type
class DatasetContentVersionValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetName":
            suggest = "dataset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetContentVersionValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetContentVersionValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetContentVersionValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_name: str):
        pulumi.set(__self__, "dataset_name", dataset_name)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> str:
        return pulumi.get(self, "dataset_name")


@pulumi.output_type
class DatasetDeltaTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offsetSeconds":
            suggest = "offset_seconds"
        elif key == "timeExpression":
            suggest = "time_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetDeltaTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetDeltaTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetDeltaTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 offset_seconds: int,
                 time_expression: str):
        pulumi.set(__self__, "offset_seconds", offset_seconds)
        pulumi.set(__self__, "time_expression", time_expression)

    @property
    @pulumi.getter(name="offsetSeconds")
    def offset_seconds(self) -> int:
        return pulumi.get(self, "offset_seconds")

    @property
    @pulumi.getter(name="timeExpression")
    def time_expression(self) -> str:
        return pulumi.get(self, "time_expression")


@pulumi.output_type
class DatasetDeltaTimeSessionWindowConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetDeltaTimeSessionWindowConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetDeltaTimeSessionWindowConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetDeltaTimeSessionWindowConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeout_in_minutes: int):
        pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> int:
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class DatasetFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaTime":
            suggest = "delta_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_time: Optional['outputs.DatasetDeltaTime'] = None):
        if delta_time is not None:
            pulumi.set(__self__, "delta_time", delta_time)

    @property
    @pulumi.getter(name="deltaTime")
    def delta_time(self) -> Optional['outputs.DatasetDeltaTime']:
        return pulumi.get(self, "delta_time")


@pulumi.output_type
class DatasetGlueConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetGlueConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetGlueConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetGlueConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 table_name: str):
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        return pulumi.get(self, "table_name")


@pulumi.output_type
class DatasetIotEventsDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputName":
            suggest = "input_name"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetIotEventsDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetIotEventsDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetIotEventsDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_name: str,
                 role_arn: str):
        pulumi.set(__self__, "input_name", input_name)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> str:
        return pulumi.get(self, "input_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DatasetLateDataRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleConfiguration":
            suggest = "rule_configuration"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetLateDataRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetLateDataRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetLateDataRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_configuration: 'outputs.DatasetLateDataRuleConfiguration',
                 rule_name: Optional[str] = None):
        pulumi.set(__self__, "rule_configuration", rule_configuration)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter(name="ruleConfiguration")
    def rule_configuration(self) -> 'outputs.DatasetLateDataRuleConfiguration':
        return pulumi.get(self, "rule_configuration")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[str]:
        return pulumi.get(self, "rule_name")


@pulumi.output_type
class DatasetLateDataRuleConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaTimeSessionWindowConfiguration":
            suggest = "delta_time_session_window_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetLateDataRuleConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetLateDataRuleConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetLateDataRuleConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_time_session_window_configuration: Optional['outputs.DatasetDeltaTimeSessionWindowConfiguration'] = None):
        if delta_time_session_window_configuration is not None:
            pulumi.set(__self__, "delta_time_session_window_configuration", delta_time_session_window_configuration)

    @property
    @pulumi.getter(name="deltaTimeSessionWindowConfiguration")
    def delta_time_session_window_configuration(self) -> Optional['outputs.DatasetDeltaTimeSessionWindowConfiguration']:
        return pulumi.get(self, "delta_time_session_window_configuration")


@pulumi.output_type
class DatasetOutputFileUriValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetOutputFileUriValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetOutputFileUriValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetOutputFileUriValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_name: str):
        pulumi.set(__self__, "file_name", file_name)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        return pulumi.get(self, "file_name")


@pulumi.output_type
class DatasetQueryAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlQuery":
            suggest = "sql_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetQueryAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetQueryAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetQueryAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_query: str,
                 filters: Optional[Sequence['outputs.DatasetFilter']] = None):
        pulumi.set(__self__, "sql_query", sql_query)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter(name="sqlQuery")
    def sql_query(self) -> str:
        return pulumi.get(self, "sql_query")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.DatasetFilter']]:
        return pulumi.get(self, "filters")


@pulumi.output_type
class DatasetResourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "volumeSizeInGB":
            suggest = "volume_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetResourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetResourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetResourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: 'DatasetResourceConfigurationComputeType',
                 volume_size_in_gb: int):
        pulumi.set(__self__, "compute_type", compute_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> 'DatasetResourceConfigurationComputeType':
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> int:
        return pulumi.get(self, "volume_size_in_gb")


@pulumi.output_type
class DatasetRetentionPeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfDays":
            suggest = "number_of_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetRetentionPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetRetentionPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetRetentionPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number_of_days: int,
                 unlimited: bool):
        pulumi.set(__self__, "number_of_days", number_of_days)
        pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="numberOfDays")
    def number_of_days(self) -> int:
        return pulumi.get(self, "number_of_days")

    @property
    @pulumi.getter
    def unlimited(self) -> bool:
        return pulumi.get(self, "unlimited")


@pulumi.output_type
class DatasetS3DestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "glueConfiguration":
            suggest = "glue_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetS3DestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetS3DestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetS3DestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 role_arn: str,
                 glue_configuration: Optional['outputs.DatasetGlueConfiguration'] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if glue_configuration is not None:
            pulumi.set(__self__, "glue_configuration", glue_configuration)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="glueConfiguration")
    def glue_configuration(self) -> Optional['outputs.DatasetGlueConfiguration']:
        return pulumi.get(self, "glue_configuration")


@pulumi.output_type
class DatasetSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: str):
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class DatasetTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DatasetTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggeringDataset":
            suggest = "triggering_dataset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule: Optional['outputs.DatasetSchedule'] = None,
                 triggering_dataset: Optional['outputs.DatasetTriggeringDataset'] = None):
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if triggering_dataset is not None:
            pulumi.set(__self__, "triggering_dataset", triggering_dataset)

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.DatasetSchedule']:
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="triggeringDataset")
    def triggering_dataset(self) -> Optional['outputs.DatasetTriggeringDataset']:
        return pulumi.get(self, "triggering_dataset")


@pulumi.output_type
class DatasetTriggeringDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetName":
            suggest = "dataset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetTriggeringDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetTriggeringDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetTriggeringDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_name: str):
        pulumi.set(__self__, "dataset_name", dataset_name)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> str:
        return pulumi.get(self, "dataset_name")


@pulumi.output_type
class DatasetVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableName":
            suggest = "variable_name"
        elif key == "datasetContentVersionValue":
            suggest = "dataset_content_version_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "outputFileUriValue":
            suggest = "output_file_uri_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 variable_name: str,
                 dataset_content_version_value: Optional['outputs.DatasetContentVersionValue'] = None,
                 double_value: Optional[float] = None,
                 output_file_uri_value: Optional['outputs.DatasetOutputFileUriValue'] = None,
                 string_value: Optional[str] = None):
        pulumi.set(__self__, "variable_name", variable_name)
        if dataset_content_version_value is not None:
            pulumi.set(__self__, "dataset_content_version_value", dataset_content_version_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if output_file_uri_value is not None:
            pulumi.set(__self__, "output_file_uri_value", output_file_uri_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> str:
        return pulumi.get(self, "variable_name")

    @property
    @pulumi.getter(name="datasetContentVersionValue")
    def dataset_content_version_value(self) -> Optional['outputs.DatasetContentVersionValue']:
        return pulumi.get(self, "dataset_content_version_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[float]:
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="outputFileUriValue")
    def output_file_uri_value(self) -> Optional['outputs.DatasetOutputFileUriValue']:
        return pulumi.get(self, "output_file_uri_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DatasetVersioningConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxVersions":
            suggest = "max_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetVersioningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetVersioningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetVersioningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_versions: Optional[int] = None,
                 unlimited: Optional[bool] = None):
        if max_versions is not None:
            pulumi.set(__self__, "max_versions", max_versions)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="maxVersions")
    def max_versions(self) -> Optional[int]:
        return pulumi.get(self, "max_versions")

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[bool]:
        return pulumi.get(self, "unlimited")


@pulumi.output_type
class DatastoreColumn(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class DatastoreCustomerManagedS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreCustomerManagedS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreCustomerManagedS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreCustomerManagedS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 role_arn: str,
                 key_prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "role_arn", role_arn)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[str]:
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class DatastoreCustomerManagedS3Storage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreCustomerManagedS3Storage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreCustomerManagedS3Storage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreCustomerManagedS3Storage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key_prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[str]:
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class DatastoreFileFormatConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonConfiguration":
            suggest = "json_configuration"
        elif key == "parquetConfiguration":
            suggest = "parquet_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreFileFormatConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreFileFormatConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreFileFormatConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_configuration: Optional['outputs.DatastoreJsonConfiguration'] = None,
                 parquet_configuration: Optional['outputs.DatastoreParquetConfiguration'] = None):
        if json_configuration is not None:
            pulumi.set(__self__, "json_configuration", json_configuration)
        if parquet_configuration is not None:
            pulumi.set(__self__, "parquet_configuration", parquet_configuration)

    @property
    @pulumi.getter(name="jsonConfiguration")
    def json_configuration(self) -> Optional['outputs.DatastoreJsonConfiguration']:
        return pulumi.get(self, "json_configuration")

    @property
    @pulumi.getter(name="parquetConfiguration")
    def parquet_configuration(self) -> Optional['outputs.DatastoreParquetConfiguration']:
        return pulumi.get(self, "parquet_configuration")


@pulumi.output_type
class DatastoreIotSiteWiseMultiLayerStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedS3Storage":
            suggest = "customer_managed_s3_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreIotSiteWiseMultiLayerStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreIotSiteWiseMultiLayerStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreIotSiteWiseMultiLayerStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_s3_storage: Optional['outputs.DatastoreCustomerManagedS3Storage'] = None):
        if customer_managed_s3_storage is not None:
            pulumi.set(__self__, "customer_managed_s3_storage", customer_managed_s3_storage)

    @property
    @pulumi.getter(name="customerManagedS3Storage")
    def customer_managed_s3_storage(self) -> Optional['outputs.DatastoreCustomerManagedS3Storage']:
        return pulumi.get(self, "customer_managed_s3_storage")


@pulumi.output_type
class DatastoreJsonConfiguration(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatastoreParquetConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaDefinition":
            suggest = "schema_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreParquetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreParquetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreParquetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema_definition: Optional['outputs.DatastoreSchemaDefinition'] = None):
        if schema_definition is not None:
            pulumi.set(__self__, "schema_definition", schema_definition)

    @property
    @pulumi.getter(name="schemaDefinition")
    def schema_definition(self) -> Optional['outputs.DatastoreSchemaDefinition']:
        return pulumi.get(self, "schema_definition")


@pulumi.output_type
class DatastorePartition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timestampPartition":
            suggest = "timestamp_partition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastorePartition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastorePartition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastorePartition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition: Optional['outputs.DatastorePartition'] = None,
                 timestamp_partition: Optional['outputs.DatastoreTimestampPartition'] = None):
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if timestamp_partition is not None:
            pulumi.set(__self__, "timestamp_partition", timestamp_partition)

    @property
    @pulumi.getter
    def partition(self) -> Optional['outputs.DatastorePartition']:
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="timestampPartition")
    def timestamp_partition(self) -> Optional['outputs.DatastoreTimestampPartition']:
        return pulumi.get(self, "timestamp_partition")


@pulumi.output_type
class DatastorePartitions(dict):
    def __init__(__self__, *,
                 partitions: Optional[Sequence['outputs.DatastorePartition']] = None):
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[Sequence['outputs.DatastorePartition']]:
        return pulumi.get(self, "partitions")


@pulumi.output_type
class DatastoreRetentionPeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfDays":
            suggest = "number_of_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreRetentionPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreRetentionPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreRetentionPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number_of_days: Optional[int] = None,
                 unlimited: Optional[bool] = None):
        if number_of_days is not None:
            pulumi.set(__self__, "number_of_days", number_of_days)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter(name="numberOfDays")
    def number_of_days(self) -> Optional[int]:
        return pulumi.get(self, "number_of_days")

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[bool]:
        return pulumi.get(self, "unlimited")


@pulumi.output_type
class DatastoreSchemaDefinition(dict):
    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.DatastoreColumn']] = None):
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.DatastoreColumn']]:
        return pulumi.get(self, "columns")


@pulumi.output_type
class DatastoreServiceManagedS3(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatastoreStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedS3":
            suggest = "customer_managed_s3"
        elif key == "iotSiteWiseMultiLayerStorage":
            suggest = "iot_site_wise_multi_layer_storage"
        elif key == "serviceManagedS3":
            suggest = "service_managed_s3"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_s3: Optional['outputs.DatastoreCustomerManagedS3'] = None,
                 iot_site_wise_multi_layer_storage: Optional['outputs.DatastoreIotSiteWiseMultiLayerStorage'] = None,
                 service_managed_s3: Optional['outputs.DatastoreServiceManagedS3'] = None):
        if customer_managed_s3 is not None:
            pulumi.set(__self__, "customer_managed_s3", customer_managed_s3)
        if iot_site_wise_multi_layer_storage is not None:
            pulumi.set(__self__, "iot_site_wise_multi_layer_storage", iot_site_wise_multi_layer_storage)
        if service_managed_s3 is not None:
            pulumi.set(__self__, "service_managed_s3", service_managed_s3)

    @property
    @pulumi.getter(name="customerManagedS3")
    def customer_managed_s3(self) -> Optional['outputs.DatastoreCustomerManagedS3']:
        return pulumi.get(self, "customer_managed_s3")

    @property
    @pulumi.getter(name="iotSiteWiseMultiLayerStorage")
    def iot_site_wise_multi_layer_storage(self) -> Optional['outputs.DatastoreIotSiteWiseMultiLayerStorage']:
        return pulumi.get(self, "iot_site_wise_multi_layer_storage")

    @property
    @pulumi.getter(name="serviceManagedS3")
    def service_managed_s3(self) -> Optional['outputs.DatastoreServiceManagedS3']:
        return pulumi.get(self, "service_managed_s3")


@pulumi.output_type
class DatastoreTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DatastoreTimestampPartition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreTimestampPartition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreTimestampPartition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreTimestampPartition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: str,
                 timestamp_format: Optional[str] = None):
        pulumi.set(__self__, "attribute_name", attribute_name)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class PipelineActivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addAttributes":
            suggest = "add_attributes"
        elif key == "deviceRegistryEnrich":
            suggest = "device_registry_enrich"
        elif key == "deviceShadowEnrich":
            suggest = "device_shadow_enrich"
        elif key == "lambda":
            suggest = "lambda_"
        elif key == "removeAttributes":
            suggest = "remove_attributes"
        elif key == "selectAttributes":
            suggest = "select_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineActivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineActivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineActivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_attributes: Optional['outputs.PipelineAddAttributes'] = None,
                 channel: Optional['outputs.PipelineChannel'] = None,
                 datastore: Optional['outputs.PipelineDatastore'] = None,
                 device_registry_enrich: Optional['outputs.PipelineDeviceRegistryEnrich'] = None,
                 device_shadow_enrich: Optional['outputs.PipelineDeviceShadowEnrich'] = None,
                 filter: Optional['outputs.PipelineFilter'] = None,
                 lambda_: Optional['outputs.PipelineLambda'] = None,
                 math: Optional['outputs.PipelineMath'] = None,
                 remove_attributes: Optional['outputs.PipelineRemoveAttributes'] = None,
                 select_attributes: Optional['outputs.PipelineSelectAttributes'] = None):
        if add_attributes is not None:
            pulumi.set(__self__, "add_attributes", add_attributes)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if device_registry_enrich is not None:
            pulumi.set(__self__, "device_registry_enrich", device_registry_enrich)
        if device_shadow_enrich is not None:
            pulumi.set(__self__, "device_shadow_enrich", device_shadow_enrich)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if math is not None:
            pulumi.set(__self__, "math", math)
        if remove_attributes is not None:
            pulumi.set(__self__, "remove_attributes", remove_attributes)
        if select_attributes is not None:
            pulumi.set(__self__, "select_attributes", select_attributes)

    @property
    @pulumi.getter(name="addAttributes")
    def add_attributes(self) -> Optional['outputs.PipelineAddAttributes']:
        return pulumi.get(self, "add_attributes")

    @property
    @pulumi.getter
    def channel(self) -> Optional['outputs.PipelineChannel']:
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def datastore(self) -> Optional['outputs.PipelineDatastore']:
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="deviceRegistryEnrich")
    def device_registry_enrich(self) -> Optional['outputs.PipelineDeviceRegistryEnrich']:
        return pulumi.get(self, "device_registry_enrich")

    @property
    @pulumi.getter(name="deviceShadowEnrich")
    def device_shadow_enrich(self) -> Optional['outputs.PipelineDeviceShadowEnrich']:
        return pulumi.get(self, "device_shadow_enrich")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.PipelineFilter']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional['outputs.PipelineLambda']:
        return pulumi.get(self, "lambda_")

    @property
    @pulumi.getter
    def math(self) -> Optional['outputs.PipelineMath']:
        return pulumi.get(self, "math")

    @property
    @pulumi.getter(name="removeAttributes")
    def remove_attributes(self) -> Optional['outputs.PipelineRemoveAttributes']:
        return pulumi.get(self, "remove_attributes")

    @property
    @pulumi.getter(name="selectAttributes")
    def select_attributes(self) -> Optional['outputs.PipelineSelectAttributes']:
        return pulumi.get(self, "select_attributes")


@pulumi.output_type
class PipelineAddAttributes(dict):
    def __init__(__self__, *,
                 attributes: Any,
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attributes(self) -> Any:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreName":
            suggest = "datastore_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datastore_name: str,
                 name: str):
        pulumi.set(__self__, "datastore_name", datastore_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="datastoreName")
    def datastore_name(self) -> str:
        return pulumi.get(self, "datastore_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class PipelineDeviceRegistryEnrich(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "thingName":
            suggest = "thing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineDeviceRegistryEnrich. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineDeviceRegistryEnrich.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineDeviceRegistryEnrich.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: str,
                 name: str,
                 role_arn: str,
                 thing_name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "thing_name", thing_name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> str:
        return pulumi.get(self, "thing_name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineDeviceShadowEnrich(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "thingName":
            suggest = "thing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineDeviceShadowEnrich. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineDeviceShadowEnrich.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineDeviceShadowEnrich.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: str,
                 name: str,
                 role_arn: str,
                 thing_name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "thing_name", thing_name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> str:
        return pulumi.get(self, "thing_name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineFilter(dict):
    def __init__(__self__, *,
                 filter: str,
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def filter(self) -> str:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineLambda(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "lambdaName":
            suggest = "lambda_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineLambda. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineLambda.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineLambda.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: int,
                 lambda_name: str,
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "batch_size", batch_size)
        pulumi.set(__self__, "lambda_name", lambda_name)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> int:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="lambdaName")
    def lambda_name(self) -> str:
        return pulumi.get(self, "lambda_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineMath(dict):
    def __init__(__self__, *,
                 attribute: str,
                 math: str,
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "math", math)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def math(self) -> str:
        return pulumi.get(self, "math")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineRemoveAttributes(dict):
    def __init__(__self__, *,
                 attributes: Sequence[str],
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attributes(self) -> Sequence[str]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineSelectAttributes(dict):
    def __init__(__self__, *,
                 attributes: Sequence[str],
                 name: str,
                 next: Optional[str] = None):
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "name", name)
        if next is not None:
            pulumi.set(__self__, "next", next)

    @property
    @pulumi.getter
    def attributes(self) -> Sequence[str]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def next(self) -> Optional[str]:
        return pulumi.get(self, "next")


@pulumi.output_type
class PipelineTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


