"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
/*
 * Creates a simple vpc with a public subnet and a private reserved subnet.
 * Public subnet should be visible but a private reserved subnet only has IP space reserved.
 * No resources are provisioned in a reserved subnet.
 *
 * Stack verification steps:
 * -- aws ec2 describe-nat-gateways returns { "natGateways": []}
 */
const app = new cdk.App();
class VpcReservedPrivateSubnetStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        /// !show
        // Specify no NAT gateways with a reserved private subnet
        new ec2.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            subnetConfiguration: [
                {
                    name: 'ingress',
                    subnetType: ec2.SubnetType.PUBLIC,
                },
                {
                    name: 'private',
                    subnetType: ec2.SubnetType.PRIVATE,
                    reserved: true,
                },
            ],
            natGateways: 0,
        });
        /// !hide
    }
}
new VpcReservedPrivateSubnetStack(app, 'aws-cdk-ec2-vpc-endpoint');
app.synth();
//# sourceMappingURL=data:application/json;base64,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