# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['console_debugger',
 'console_debugger.logic',
 'console_debugger.logic.tk_gui',
 'console_debugger.test']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'console-debugger',
    'version': '0.1.2',
    'description': 'Это подключаемая библиотека, для удобного вывода отладочной информации.',
    'long_description': '# Что это?\n\nЭто подключаемая библиотека, для удобного вывода  \nотладочной информации.\n\n---\n\n# Как использовать ?\n\n## 1 Сначала нужно создать экземпляры класса Debugger\n\nМожно вручную указать параметры экземпляра\n\n- `Debug_Name = Debugger(active: bool,,title_name: str, consoleOutput: bool = True, fileConfig: Optional[Dict] = None style_text: Optional[dstyle] = None)`\n\n     - `active` = on/off жизни экземпляра, Если `False` экземпляр \n    будет игнорировать вызов, а также будет добавлен в массив `Debugger.AllCountSleepInstance`.  \n       \n    - `title_name` = Уникальное имя экземпляра которое будет отображаться в выводе.  \n    \n    - `consoleOutput` = on/off отображения в консоль или другие\n    визуальные выходы, **не влияет на запись в файл!**.  \n    \n    - `fileConfig` = Конфигурация записи в файл, входные параметры такие же как и у стандартной функции `open()`  \n        передавать в формате `Dict{"file":"test.log", ... }`. Для удобного формирования параметров можно  \n         пользоваться функцией `dopen()`.  \n    \n    - `style_text` = Стиль отображения текста. Для удобного формирования параметров можно  \n        пользоваться функцией `dstyle`.  \n\n\nИли использовать готовые параметры\n\n- `Debug_Name = Debugger(**dDEBUG)`\n    - dDEBUG\n    - dINFO\n    - dWARNING\n    - dEXCEPTION\n\n## 2 Установить глобальный стиль для всех экземпляров\n\nЭта команда влияет на все экземпляры `Debugger`\n\n- `Debugger.GlobalManager(global_active=None, typePrint: Optional[str] = "grid"):`\n    - `global_active` = Вы можете on/off все экземпляры разом\n    - `typePrint=` = Глобальный стиль отображения данных\n        - `"grid"` = Стиль таблица \n        \n        ![](https://i.imgur.com/EwePtfk.png)\n        \n        - `"tk"` = Будет открыто **Tkinter** окно и \n        все записи будут направлены в него\n        \n        ![](https://i.imgur.com/OJP19OR.png)\n        \n        - `None` = Без стиля \n        \n        ![](https://i.imgur.com/byg84id.png)\n\n## 3 Использовать в коде\n\nВызывать экземпляр напрямую\n\n- `Debug_Name(text,*args, sep=\' \', end=\'\\n\')`\n    - `Debug_Name` = Имя экземпляра `Debugger`\n    - `text` = Строка\n    - `*args, sep=\' \', end=\'\\n\'` = такие же, как и у встроенной функции `print()`\n\nЛибо использовать функцию для однородности\n\n- `printD(Debug_Name, text, *args, sep=\' \', end=\'\\n\')`\n    - `Debug_Name` = Имя экземпляра `Debugger`\n    - `text` = Строка\n    - `*args, sep=\' \', end=\'\\n\'` = такие же, как и у встроенной функции `print()`\n\n---\n\n# Примеры\n\n## Использовать свои стили, вызывать экземпляры напрямую\n\n\nДля наглядности создадим функцию для генерации случайного слово\n```python\nimport random\nimport string             \n# Сгенерировать случайное слово\nrandom_word = lambda: "".join(random.choice(string.ascii_letters) for j in range(random.randint(1, 40)))\n```\n\n```python\nfrom debugger import *\n\nDebug = Debugger(True,title_name="[DEBUG]",\n\n                 fileConfig=dopen(file="debug.log",\n                                  mode="a",\n                                  encoding="utf-8"),\n\n                 style_text=dstyle(bg_color="bg_blue",\n                                   len_word=21)\n                 )\nInfo = Debugger(True,title_name="[INFO]",\n\n                fileConfig={"file": "info.log",\n                            "mode": "a", "encoding": "utf-8"},\n                style_text=dstyle(len_word=25),\n\n                consoleOutput=False\n                )\nWarning = Debugger(True,"[WARNING]", style_text=dstyle(len_word=25))\n\nDebugger.GlobalManager(typePrint="grid")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n        Warning(random_word())\n        Debug(random_word())\n        Info(random_word())\n```\n\n## Использовать готовые стили, вызывать `printD`\n\n```python\nfrom debugger import *\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\n\nDebugger.GlobalManager(typePrint="grid")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n        printD(Debug, random_word())\n        printD(Warning, random_word())\n        printD(Info, random_word())\n```\n\n## Использовать GUI Tkinter\n```python\nfrom debugger import *\n\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\nTEST = Debugger(True,"TEST")\n\nDebugger.GlobalManager(typePrint="tk")\n\n\nfor i in range(10):\n    printD(Debug, random_word())\n    printD(Info, random_word())\n    printD(Warning, random_word())\n    printD(TEST, random_word())\n    time.sleep(0.3) # Задержка для наглядности поступления сообщений\n```\n\n\n## Советы\n\n### Про интерфейс GUI Tkinter\n- Tkinter запускается в новом потоке\n- Если нажать на заголовок консоли, то она отчистится\n- Если нажать нижнею кнопку `save geometry` то вы\nсохраните положение окна на следующий запуск\n- Если закрыть окно, то данные будут отправляться в консоль\n\n\n### Про доступную информации об экземпляре `Debugger`\n- public set:\n    + `consoleOutput` = Вывод в консоль\n    + `style_text` = Стиль отображения текста\n    + `active()` = Включить дебагер\n    + `deactivate()` = Отключить дебагер\n\n- public get:\n    + `title_name` = Уникальное имя дебагера\n    + `fileConfig` = Конфигурация для файла\n    + `AllCountActiveInstance` = Все активные дебагеры\n    + `AllCountSleepInstance` = Все приостановленный дебагиры\n    + `AllUseFileName` = Все используемые имена файлов\n    + `AllInstance` = Все экземпляры дебагеров\n',
    'author': 'Denis Kustov',
    'author_email': 'denis-kustov@rambler.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/denisxab/console_debugger',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
