# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.dataplex import gapic_version as package_version

__version__ = package_version.__version__


from google.cloud.dataplex_v1.services.catalog_service.async_client import (
    CatalogServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.catalog_service.client import (
    CatalogServiceClient,
)
from google.cloud.dataplex_v1.services.cmek_service.async_client import (
    CmekServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.cmek_service.client import CmekServiceClient
from google.cloud.dataplex_v1.services.content_service.async_client import (
    ContentServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.content_service.client import (
    ContentServiceClient,
)
from google.cloud.dataplex_v1.services.data_scan_service.async_client import (
    DataScanServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.data_scan_service.client import (
    DataScanServiceClient,
)
from google.cloud.dataplex_v1.services.data_taxonomy_service.async_client import (
    DataTaxonomyServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.data_taxonomy_service.client import (
    DataTaxonomyServiceClient,
)
from google.cloud.dataplex_v1.services.dataplex_service.async_client import (
    DataplexServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.dataplex_service.client import (
    DataplexServiceClient,
)
from google.cloud.dataplex_v1.services.metadata_service.async_client import (
    MetadataServiceAsyncClient,
)
from google.cloud.dataplex_v1.services.metadata_service.client import (
    MetadataServiceClient,
)
from google.cloud.dataplex_v1.types.analyze import Content, Environment, Session
from google.cloud.dataplex_v1.types.catalog import (
    Aspect,
    AspectSource,
    AspectType,
    CancelMetadataJobRequest,
    CreateAspectTypeRequest,
    CreateEntryGroupRequest,
    CreateEntryRequest,
    CreateEntryTypeRequest,
    CreateMetadataJobRequest,
    DeleteAspectTypeRequest,
    DeleteEntryGroupRequest,
    DeleteEntryRequest,
    DeleteEntryTypeRequest,
    Entry,
    EntryGroup,
    EntrySource,
    EntryType,
    EntryView,
    GetAspectTypeRequest,
    GetEntryGroupRequest,
    GetEntryRequest,
    GetEntryTypeRequest,
    GetMetadataJobRequest,
    ImportItem,
    ListAspectTypesRequest,
    ListAspectTypesResponse,
    ListEntriesRequest,
    ListEntriesResponse,
    ListEntryGroupsRequest,
    ListEntryGroupsResponse,
    ListEntryTypesRequest,
    ListEntryTypesResponse,
    ListMetadataJobsRequest,
    ListMetadataJobsResponse,
    LookupEntryRequest,
    MetadataJob,
    SearchEntriesRequest,
    SearchEntriesResponse,
    SearchEntriesResult,
    TransferStatus,
    UpdateAspectTypeRequest,
    UpdateEntryGroupRequest,
    UpdateEntryRequest,
    UpdateEntryTypeRequest,
)
from google.cloud.dataplex_v1.types.cmek import (
    CreateEncryptionConfigRequest,
    DeleteEncryptionConfigRequest,
    EncryptionConfig,
    GetEncryptionConfigRequest,
    ListEncryptionConfigsRequest,
    ListEncryptionConfigsResponse,
    UpdateEncryptionConfigRequest,
)
from google.cloud.dataplex_v1.types.content import (
    CreateContentRequest,
    DeleteContentRequest,
    GetContentRequest,
    ListContentRequest,
    ListContentResponse,
    UpdateContentRequest,
)
from google.cloud.dataplex_v1.types.data_discovery import (
    DataDiscoveryResult,
    DataDiscoverySpec,
)
from google.cloud.dataplex_v1.types.data_profile import (
    DataProfileResult,
    DataProfileSpec,
)
from google.cloud.dataplex_v1.types.data_quality import (
    DataQualityColumnResult,
    DataQualityDimension,
    DataQualityDimensionResult,
    DataQualityResult,
    DataQualityRule,
    DataQualityRuleResult,
    DataQualitySpec,
)
from google.cloud.dataplex_v1.types.data_taxonomy import (
    CreateDataAttributeBindingRequest,
    CreateDataAttributeRequest,
    CreateDataTaxonomyRequest,
    DataAttribute,
    DataAttributeBinding,
    DataTaxonomy,
    DeleteDataAttributeBindingRequest,
    DeleteDataAttributeRequest,
    DeleteDataTaxonomyRequest,
    GetDataAttributeBindingRequest,
    GetDataAttributeRequest,
    GetDataTaxonomyRequest,
    ListDataAttributeBindingsRequest,
    ListDataAttributeBindingsResponse,
    ListDataAttributesRequest,
    ListDataAttributesResponse,
    ListDataTaxonomiesRequest,
    ListDataTaxonomiesResponse,
    UpdateDataAttributeBindingRequest,
    UpdateDataAttributeRequest,
    UpdateDataTaxonomyRequest,
)
from google.cloud.dataplex_v1.types.datascans import (
    CreateDataScanRequest,
    DataScan,
    DataScanJob,
    DataScanType,
    DeleteDataScanRequest,
    GenerateDataQualityRulesRequest,
    GenerateDataQualityRulesResponse,
    GetDataScanJobRequest,
    GetDataScanRequest,
    ListDataScanJobsRequest,
    ListDataScanJobsResponse,
    ListDataScansRequest,
    ListDataScansResponse,
    RunDataScanRequest,
    RunDataScanResponse,
    UpdateDataScanRequest,
)
from google.cloud.dataplex_v1.types.logs import (
    BusinessGlossaryEvent,
    DataQualityScanRuleResult,
    DataScanEvent,
    DiscoveryEvent,
    EntryLinkEvent,
    GovernanceEvent,
    JobEvent,
    SessionEvent,
)
from google.cloud.dataplex_v1.types.metadata_ import (
    CreateEntityRequest,
    CreatePartitionRequest,
    DeleteEntityRequest,
    DeletePartitionRequest,
    Entity,
    GetEntityRequest,
    GetPartitionRequest,
    ListEntitiesRequest,
    ListEntitiesResponse,
    ListPartitionsRequest,
    ListPartitionsResponse,
    Partition,
    Schema,
    StorageAccess,
    StorageFormat,
    StorageSystem,
    UpdateEntityRequest,
)
from google.cloud.dataplex_v1.types.processing import DataSource, ScannedData, Trigger
from google.cloud.dataplex_v1.types.resources import (
    Action,
    Asset,
    AssetStatus,
    Lake,
    State,
    Zone,
)
from google.cloud.dataplex_v1.types.security import DataAccessSpec, ResourceAccessSpec
from google.cloud.dataplex_v1.types.service import (
    CancelJobRequest,
    CreateAssetRequest,
    CreateEnvironmentRequest,
    CreateLakeRequest,
    CreateTaskRequest,
    CreateZoneRequest,
    DeleteAssetRequest,
    DeleteEnvironmentRequest,
    DeleteLakeRequest,
    DeleteTaskRequest,
    DeleteZoneRequest,
    GetAssetRequest,
    GetEnvironmentRequest,
    GetJobRequest,
    GetLakeRequest,
    GetTaskRequest,
    GetZoneRequest,
    ListActionsResponse,
    ListAssetActionsRequest,
    ListAssetsRequest,
    ListAssetsResponse,
    ListEnvironmentsRequest,
    ListEnvironmentsResponse,
    ListJobsRequest,
    ListJobsResponse,
    ListLakeActionsRequest,
    ListLakesRequest,
    ListLakesResponse,
    ListSessionsRequest,
    ListSessionsResponse,
    ListTasksRequest,
    ListTasksResponse,
    ListZoneActionsRequest,
    ListZonesRequest,
    ListZonesResponse,
    OperationMetadata,
    RunTaskRequest,
    RunTaskResponse,
    UpdateAssetRequest,
    UpdateEnvironmentRequest,
    UpdateLakeRequest,
    UpdateTaskRequest,
    UpdateZoneRequest,
)
from google.cloud.dataplex_v1.types.tasks import Job, Task

__all__ = (
    "CatalogServiceClient",
    "CatalogServiceAsyncClient",
    "CmekServiceClient",
    "CmekServiceAsyncClient",
    "ContentServiceClient",
    "ContentServiceAsyncClient",
    "DataplexServiceClient",
    "DataplexServiceAsyncClient",
    "DataScanServiceClient",
    "DataScanServiceAsyncClient",
    "DataTaxonomyServiceClient",
    "DataTaxonomyServiceAsyncClient",
    "MetadataServiceClient",
    "MetadataServiceAsyncClient",
    "Content",
    "Environment",
    "Session",
    "Aspect",
    "AspectSource",
    "AspectType",
    "CancelMetadataJobRequest",
    "CreateAspectTypeRequest",
    "CreateEntryGroupRequest",
    "CreateEntryRequest",
    "CreateEntryTypeRequest",
    "CreateMetadataJobRequest",
    "DeleteAspectTypeRequest",
    "DeleteEntryGroupRequest",
    "DeleteEntryRequest",
    "DeleteEntryTypeRequest",
    "Entry",
    "EntryGroup",
    "EntrySource",
    "EntryType",
    "GetAspectTypeRequest",
    "GetEntryGroupRequest",
    "GetEntryRequest",
    "GetEntryTypeRequest",
    "GetMetadataJobRequest",
    "ImportItem",
    "ListAspectTypesRequest",
    "ListAspectTypesResponse",
    "ListEntriesRequest",
    "ListEntriesResponse",
    "ListEntryGroupsRequest",
    "ListEntryGroupsResponse",
    "ListEntryTypesRequest",
    "ListEntryTypesResponse",
    "ListMetadataJobsRequest",
    "ListMetadataJobsResponse",
    "LookupEntryRequest",
    "MetadataJob",
    "SearchEntriesRequest",
    "SearchEntriesResponse",
    "SearchEntriesResult",
    "UpdateAspectTypeRequest",
    "UpdateEntryGroupRequest",
    "UpdateEntryRequest",
    "UpdateEntryTypeRequest",
    "EntryView",
    "TransferStatus",
    "CreateEncryptionConfigRequest",
    "DeleteEncryptionConfigRequest",
    "EncryptionConfig",
    "GetEncryptionConfigRequest",
    "ListEncryptionConfigsRequest",
    "ListEncryptionConfigsResponse",
    "UpdateEncryptionConfigRequest",
    "CreateContentRequest",
    "DeleteContentRequest",
    "GetContentRequest",
    "ListContentRequest",
    "ListContentResponse",
    "UpdateContentRequest",
    "DataDiscoveryResult",
    "DataDiscoverySpec",
    "DataProfileResult",
    "DataProfileSpec",
    "DataQualityColumnResult",
    "DataQualityDimension",
    "DataQualityDimensionResult",
    "DataQualityResult",
    "DataQualityRule",
    "DataQualityRuleResult",
    "DataQualitySpec",
    "CreateDataAttributeBindingRequest",
    "CreateDataAttributeRequest",
    "CreateDataTaxonomyRequest",
    "DataAttribute",
    "DataAttributeBinding",
    "DataTaxonomy",
    "DeleteDataAttributeBindingRequest",
    "DeleteDataAttributeRequest",
    "DeleteDataTaxonomyRequest",
    "GetDataAttributeBindingRequest",
    "GetDataAttributeRequest",
    "GetDataTaxonomyRequest",
    "ListDataAttributeBindingsRequest",
    "ListDataAttributeBindingsResponse",
    "ListDataAttributesRequest",
    "ListDataAttributesResponse",
    "ListDataTaxonomiesRequest",
    "ListDataTaxonomiesResponse",
    "UpdateDataAttributeBindingRequest",
    "UpdateDataAttributeRequest",
    "UpdateDataTaxonomyRequest",
    "CreateDataScanRequest",
    "DataScan",
    "DataScanJob",
    "DeleteDataScanRequest",
    "GenerateDataQualityRulesRequest",
    "GenerateDataQualityRulesResponse",
    "GetDataScanJobRequest",
    "GetDataScanRequest",
    "ListDataScanJobsRequest",
    "ListDataScanJobsResponse",
    "ListDataScansRequest",
    "ListDataScansResponse",
    "RunDataScanRequest",
    "RunDataScanResponse",
    "UpdateDataScanRequest",
    "DataScanType",
    "BusinessGlossaryEvent",
    "DataQualityScanRuleResult",
    "DataScanEvent",
    "DiscoveryEvent",
    "EntryLinkEvent",
    "GovernanceEvent",
    "JobEvent",
    "SessionEvent",
    "CreateEntityRequest",
    "CreatePartitionRequest",
    "DeleteEntityRequest",
    "DeletePartitionRequest",
    "Entity",
    "GetEntityRequest",
    "GetPartitionRequest",
    "ListEntitiesRequest",
    "ListEntitiesResponse",
    "ListPartitionsRequest",
    "ListPartitionsResponse",
    "Partition",
    "Schema",
    "StorageAccess",
    "StorageFormat",
    "UpdateEntityRequest",
    "StorageSystem",
    "DataSource",
    "ScannedData",
    "Trigger",
    "Action",
    "Asset",
    "AssetStatus",
    "Lake",
    "Zone",
    "State",
    "DataAccessSpec",
    "ResourceAccessSpec",
    "CancelJobRequest",
    "CreateAssetRequest",
    "CreateEnvironmentRequest",
    "CreateLakeRequest",
    "CreateTaskRequest",
    "CreateZoneRequest",
    "DeleteAssetRequest",
    "DeleteEnvironmentRequest",
    "DeleteLakeRequest",
    "DeleteTaskRequest",
    "DeleteZoneRequest",
    "GetAssetRequest",
    "GetEnvironmentRequest",
    "GetJobRequest",
    "GetLakeRequest",
    "GetTaskRequest",
    "GetZoneRequest",
    "ListActionsResponse",
    "ListAssetActionsRequest",
    "ListAssetsRequest",
    "ListAssetsResponse",
    "ListEnvironmentsRequest",
    "ListEnvironmentsResponse",
    "ListJobsRequest",
    "ListJobsResponse",
    "ListLakeActionsRequest",
    "ListLakesRequest",
    "ListLakesResponse",
    "ListSessionsRequest",
    "ListSessionsResponse",
    "ListTasksRequest",
    "ListTasksResponse",
    "ListZoneActionsRequest",
    "ListZonesRequest",
    "ListZonesResponse",
    "OperationMetadata",
    "RunTaskRequest",
    "RunTaskResponse",
    "UpdateAssetRequest",
    "UpdateEnvironmentRequest",
    "UpdateLakeRequest",
    "UpdateTaskRequest",
    "UpdateZoneRequest",
    "Job",
    "Task",
)
