# CITATION: Google Docs API quickstart

from __future__ import print_function  # not sure what this does

import os.path

from google.auth.transport.requests import Request
from google.oauth2.credentials import Credentials
from google_auth_oauthlib.flow import InstalledAppFlow

import googleapiclient.discovery
from googleapiclient.errors import HttpError


# Authorizes the user to access Google Docs
# CITATION: Google Docs API quickstart
def getservice(DOCUMENT_ID, SCOPES=None):
    """Credentials testing"""

    creds = None

    if SCOPES is None:
        # If modifying these scopes, delete the file token.json.
        SCOPES = ['https://www.googleapis.com/auth/documents']
    else:
        if os.path.exists('../token.json'):
            os.remove('../token.json')

    # The file token.json stores the user's access and refresh tokens.
    # Created automatically when the authorization flow completes for the first time.
    if os.path.exists('../token.json'):
        creds = Credentials.from_authorized_user_file('../token.json', SCOPES)
    # If there are no (valid) credentials available, let the user log in.
    if not creds or not creds.valid:
        if creds and creds.expired and creds.refresh_token:
            creds.refresh(Request())
        else:
            flow = InstalledAppFlow.from_client_secrets_file('../credentials.json', SCOPES)
            creds = flow.run_local_server(port=0)
        # Save the credentials for the next run
        with open('../token.json', 'w') as token:
            token.write(creds.to_json())

    # Create + return "service", which you can use to access the Docs API
    try:
        service = googleapiclient.discovery.build('docs', 'v1', credentials=creds)
    except HttpError as err:
        print(err)
        return

    return service


# if __name__ == '__main__':
#     getservice()
