"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoPutItem = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoPutItem
 */
class DynamoPutItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_DynamoPutItemProps(props);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.PUT}Item`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.PUT),
            Parameters: sfn.FieldUtils.renderObject({
                Item: utils_1.transformAttributeValueMap(this.props.item),
                TableName: this.props.table.tableName,
                ConditionExpression: this.props.conditionExpression,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ExpressionAttributeValues: utils_1.transformAttributeValueMap(this.props.expressionAttributeValues),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
                ReturnItemCollectionMetrics: this.props.returnItemCollectionMetrics,
                ReturnValues: this.props.returnValues,
            }),
        };
    }
}
exports.DynamoPutItem = DynamoPutItem;
_a = JSII_RTTI_SYMBOL_1;
DynamoPutItem[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.DynamoPutItem", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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