from ._version import __version__
from .handlers import setup_handlers


def _jupyter_server_extension_paths():
    return[{
        "module": "jupyter_rospkg"
    }]


def _jupyter_server_extension_points():
    return [{
        "module": "jupyter_rospkg"
    }]


def _load_jupyter_server_extension(server_app):
    """Registers the API handler to receive HTTP requests from the frontend extension.

    Parameters
    ----------
    server_app: jupyterlab.labapp.LabApp
        JupyterLab application instance
    """

    # url_path = "ros"
    setup_handlers(server_app.web_app)
    server_app.log.info(f"Registered jupyter_rospkg server extension.")


# For backward compatibility with notebook server - useful for Binder/JupyterHub
load_jupyter_server_extension = _load_jupyter_server_extension
