"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-athena-workgroup-tags');
new lib_1.CfnWorkGroup(stack, 'AthenaWorkgroup', {
    name: 'HelloWorld',
    description: 'A WorkGroup',
    recursiveDeleteOption: true,
    state: 'ENABLED',
    tags: [
        {
            key: 'key1',
            value: 'value1',
        },
        {
            key: 'key2',
            value: 'value2',
        },
    ],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcud29ya2dyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcud29ya2dyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLGdDQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLCtCQUErQixDQUFDLENBQUM7QUFFbEUsSUFBSSxrQkFBWSxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUN6QyxJQUFJLEVBQUUsWUFBWTtJQUNsQixXQUFXLEVBQUUsYUFBYTtJQUMxQixxQkFBcUIsRUFBRSxJQUFJO0lBQzNCLEtBQUssRUFBRSxTQUFTO0lBQ2hCLElBQUksRUFBRTtRQUNKO1lBQ0UsR0FBRyxFQUFFLE1BQU07WUFDWCxLQUFLLEVBQUUsUUFBUTtTQUNoQjtRQUNEO1lBQ0UsR0FBRyxFQUFFLE1BQU07WUFDWCxLQUFLLEVBQUUsUUFBUTtTQUNoQjtLQUNGO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ2ZuV29ya0dyb3VwIH1mcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstYXRoZW5hLXdvcmtncm91cC10YWdzJyk7XG5cbm5ldyBDZm5Xb3JrR3JvdXAoc3RhY2ssICdBdGhlbmFXb3JrZ3JvdXAnLCB7XG4gIG5hbWU6ICdIZWxsb1dvcmxkJyxcbiAgZGVzY3JpcHRpb246ICdBIFdvcmtHcm91cCcsXG4gIHJlY3Vyc2l2ZURlbGV0ZU9wdGlvbjogdHJ1ZSxcbiAgc3RhdGU6ICdFTkFCTEVEJyxcbiAgdGFnczogW1xuICAgIHtcbiAgICAgIGtleTogJ2tleTEnLFxuICAgICAgdmFsdWU6ICd2YWx1ZTEnLFxuICAgIH0sXG4gICAge1xuICAgICAga2V5OiAna2V5MicsXG4gICAgICB2YWx1ZTogJ3ZhbHVlMicsXG4gICAgfSxcbiAgXSxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==