# AUTOGENERATED! DO NOT EDIT! File to edit: 07_robot_model.ipynb (unless otherwise specified).

__all__ = ['show_link', 'show_joint']

# Cell

import gdown
from zipfile import ZipFile
import xml.etree.cElementTree as ET
import os

def show_link(path, output_file):
    """

    This function will read urdf.xacro file and show all link.

    Args :
        path : The urdf.xacro file path
        output_file : The file to store all link
    Return :
        link : list all link at the urdf.xacro file.
    """

    os.system("cat " + path + " | grep \"link name=\" >> " + output_file)

    link = []
    f = open(output_file, 'r')
    for line in f.readlines():
      index = []
      flag = 0
      for i, element in enumerate(line):
        if element == "<":
          flag = 1
        if flag == 1:
          index.append(i)
      link_string = str(line)
      link.append(link_string[index[0]:])
    f.close()

    return link

def show_joint(path):
    """

    This function will read xml file and show all joint from this file.

    Args:
        path : The xml file path
    Return:
        joint : list all joint at xml file.

    """

    joint = []
    tree = ET.parse(path)
    root = tree.getroot()

    for joints in root.iter("joint"):
        joint.append(joints.attrib)

    return joint