# -*- coding: utf-8 -*-
import os
import uuid
import environ

env = environ.Env()

gettext = lambda s: s  # noqa

DEBUG = env.bool('DJANGO_DEBUG', default=False)
TESTING = env.bool('DJANGO_TESTING', default=False)

ALLOWED_HOSTS = env.list('ALLOWED_HOSTS', default="*")

DATABASES = {
    'default': env.db('DATABASE_URL', default='sqlite:////tmp/assessment.db'),
}

TIME_ZONE = 'UTC'

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(os.path.dirname(__file__), 'static')
MEDIA_URL = '/media/'

SECRET_KEY = env('SECRET_KEY', default=str(uuid.uuid4()))
SITE_ID = 1

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'demo.urls'

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'rest_framework',
    'rest_framework.authtoken',
    'corsheaders',
    'parler',
    'allauth',
    'allauth.account',
    'rest_auth',
    'rest_auth.registration',
    'assessment'
)

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

USE_TZ = True
USE_I18N = True
USE_L10N = True

LANGUAGE_CODE = 'en'

LANGUAGES = [
    ('de', gettext('German')),
    ('en', gettext('English')),
    ('fr', gettext('French')),
    ('nl', gettext('Nederlands')),
]

# ------------------------------------------------------------------------------
# TRANSLATION Configuration
# ------------------------------------------------------------------------------
PARLER_DEFAULT_LANGUAGE_CODE = LANGUAGE_CODE
PARLER_LANGUAGES = {
    None: (
        {'code': 'de'},
        {'code': 'en'},
        {'code': 'fr'},
        {'code': 'nl'},
    ),
    'default': {
        'fallbacks': [LANGUAGE_CODE],
        'hide_untranslated': False,
    }
}

STATICFILES_STORAGE = 'whitenoise.storage.CompressedManifestStaticFilesStorage'

CORS_ORIGIN_WHITELIST = (
    'vandorjw.github.io',
    'localhost:8080',
)

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.TokenAuthentication',
    )
}
if TESTING:
    REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.TokenAuthentication',
        'rest_framework.authentication.SessionAuthentication',
    )
}


ACCOUNT_EMAIL_VERIFICATION = False

if DEBUG:
    EMAIL_BACKEND = 'django.core.mail.backends.dummy.EmailBackend'

EMAIL_USE_TLS = True
EMAIL_HOST = env('EMAIL_HOST', default='localhost')
EMAIL_HOST_USER = env('EMAIL_HOST_USER', default='')
EMAIL_HOST_PASSWORD = env('EMAIL_HOST_PASSWORD', default='')
EMAIL_PORT = 587
