"use strict";define(["loading","appRouter","layoutManager","appSettings","apphost","focusManager","connectionManager","globalize","actionsheet","dom","browser","material-icons","flexStyles","emby-scroller","emby-itemscontainer","cardStyle","emby-button"],(function(loading,appRouter,layoutManager,appSettings,appHost,focusManager,connectionManager,globalize,actionSheet,dom,browser){var enableFocusTransform=!browser.slow&&!browser.edge;function alertText(text){alertTextWithOptions({text:text})}function alertTextWithOptions(options){require(["alert"],(function(alert){alert(options)}))}return function(view,params){function connectToServer(server){loading.show(),connectionManager.connectToServer(server,{enableAutoLogin:appSettings.enableAutoLogin()}).then((function(result){loading.hide();var apiClient=result.ApiClient;switch(result.State){case"SignedIn":Dashboard.onServerChanged(apiClient.getCurrentUserId(),apiClient.accessToken(),apiClient),Dashboard.navigate("home.html");break;case"ServerSignIn":Dashboard.onServerChanged(null,null,apiClient),Dashboard.navigate("login.html?serverid="+result.Servers[0].Id);break;case"ServerUpdateNeeded":alertTextWithOptions({text:globalize.translate("core#ServerUpdateNeeded","https://github.com/jellyfin/jellyfin"),html:globalize.translate("core#ServerUpdateNeeded",'<a href="https://github.com/jellyfin/jellyfin">https://github.com/jellyfin/jellyfin</a>')});break;default:!function showServerConnectionFailure(){alertText(globalize.translate("MessageUnableToConnectToServer"),globalize.translate("HeaderConnectionFailure"))}()}}))}function onServerClick(server){var menuItems=[];menuItems.push({name:globalize.translate("Connect"),id:"connect"}),menuItems.push({name:globalize.translate("Delete"),id:"delete"}),actionSheet.show({items:menuItems,title:server.Name}).then((function(id){switch(id){case"connect":connectToServer(server);break;case"delete":!function deleteServer(server){loading.show(),connectionManager.deleteServer(server.Id).then((function(){loading.hide(),loadServers()}))}(server)}}))}function onServersRetrieved(result){servers=result,function renderSelectServerItems(view,servers){var items=servers.map((function(server){return{name:server.Name,showIcon:!0,icon:"cast",cardType:"",id:server.Id,server:server}})),html=items.map((function(item){var cardImageContainer;cardImageContainer=item.showIcon?'<i class="cardImageIcon material-icons">'+item.icon+"</i>":'<div class="cardImage" style="'+item.cardImageStyle+'"></div>';var cssClass="card overflowSquareCard loginSquareCard scalableCard overflowSquareCard-scalable";layoutManager.tv&&(cssClass+=" show-focus",enableFocusTransform&&(cssClass+=" show-animation"));var cardContainer="";return cardContainer+='<button raised class="'+cssClass+'" style="display:inline-block;" data-id="'+item.id+'" data-url="'+(item.url||"")+'" data-cardtype="'+item.cardType+'">',cardContainer+='<div class="cardBox">',cardContainer+='<div class="cardScalable">',cardContainer+='<div class="cardPadder cardPadder-square">',cardContainer+="</div>",cardContainer+='<div class="cardContent">',cardContainer+='<div class="cardImageContainer coveredImage" style="background:#0288D1;border-radius:.15em;">',cardContainer+=cardImageContainer,cardContainer+="</div>",cardContainer+="</div>",cardContainer+="</div>",cardContainer+='<div class="cardFooter">',cardContainer+='<div class="cardText cardTextCentered">'+item.name+"</div>",cardContainer+="</div></div></button>"})).join(""),itemsContainer=view.querySelector(".servers");items.length||(html="<p>"+globalize.translate("MessageNoServersAvailable")+"</p>"),itemsContainer.innerHTML=html,loading.hide()}(view,result),layoutManager.tv&&focusManager.autoFocus(view)}function loadServers(){loading.show(),connectionManager.getAvailableServers().then(onServersRetrieved)}var servers;!function updatePageStyle(view,params){"1"==params.showuser?(view.classList.add("libraryPage"),view.classList.remove("standalonePage"),view.classList.add("noSecondaryNavPage")):(view.classList.add("standalonePage"),view.classList.remove("libraryPage"),view.classList.remove("noSecondaryNavPage"))}(view,params),view.addEventListener("viewshow",(function(e){var isRestored=e.detail.isRestored;appRouter.setTitle(null),isRestored||loadServers()})),view.querySelector(".servers").addEventListener("click",(function(e){var card=dom.parentWithClass(e.target,"card");if(card){var url=card.getAttribute("data-url");if(url)appRouter.show(url);else{var id=card.getAttribute("data-id");onServerClick(servers.filter((function(s){return s.Id===id}))[0])}}}))}}));
//# sourceMappingURL=selectserver.js.map
