"use strict";define(["loading","globalize","events","viewManager","layoutManager","skinManager","pluginManager","backdrop","browser","page","appSettings","apphost","connectionManager"],(function(loading,globalize,events,viewManager,layoutManager,skinManager,pluginManager,backdrop,browser,page,appSettings,appHost,connectionManager){var currentViewLoadRequest,msgTimeout,forcedLogoutMsg,firstConnectionResult,isDummyBackToHome,appRouter={showLocalLogin:function showLocalLogin(serverId,manualLogin){show("/startup/"+(manualLogin?"manuallogin":"login")+".html?serverid="+serverId)},showSelectServer:function showSelectServer(){show("/startup/selectserver.html")},showWelcome:function showWelcome(){show("/startup/welcome.html")},showSettings:function showSettings(){show("/settings/settings.html")},showNowPlaying:function showNowPlaying(){show("/nowplaying.html")}};function beginConnectionWizard(){backdrop.clear(),loading.show(),connectionManager.connect({enableAutoLogin:appSettings.enableAutoLogin()}).then((function(result){handleConnectionResult(result,loading)}))}function handleConnectionResult(result,loading){switch(result.State){case"SignedIn":loading.hide(),skinManager.loadUserSkin();break;case"ServerSignIn":result.ApiClient.getPublicUsers().then((function(users){users.length?appRouter.showLocalLogin(result.Servers[0].Id):appRouter.showLocalLogin(result.Servers[0].Id,!0)}));break;case"ServerSelection":appRouter.showSelectServer();break;case"ConnectSignIn":appRouter.showWelcome();break;case"ServerUpdateNeeded":require(["alert"],(function(alert){alert({text:globalize.translate("ServerUpdateNeeded","https://github.com/jellyfin/jellyfin"),html:globalize.translate("ServerUpdateNeeded",'<a href="https://github.com/jellyfin/jellyfin">https://github.com/jellyfin/jellyfin</a>')}).then((function(){appRouter.showSelectServer()}))}))}}function loadContentUrl(ctx,next,route,request){var url;-1===(url=route.contentPath&&"function"==typeof route.contentPath?route.contentPath(ctx.querystring):route.contentPath||route.path).indexOf("://")&&(0!==url.indexOf("/")&&(url="/"+url),url=baseUrl()+url),ctx.querystring&&route.enableContentQueryString&&(url+="?"+ctx.querystring),require(["text!"+url],(function(html){!function loadContent(ctx,route,html,request){html=globalize.translateDocument(html,route.dictionary),request.view=html,viewManager.loadView(request),currentRouteInfo={route:route,path:ctx.path},ctx.handled=!0}(ctx,route,html,request)}))}function handleRoute(ctx,next,route){!function authenticate(ctx,route,callback){var firstResult=firstConnectionResult;if(firstResult&&(firstConnectionResult=null,"SignedIn"!==firstResult.State&&!route.anonymous))return void handleConnectionResult(firstResult,loading);var apiClient=connectionManager.currentApiClient(),pathname=ctx.pathname.toLowerCase();console.debug("appRouter - processing path request "+pathname);var isCurrentRouteStartup=!currentRouteInfo||currentRouteInfo.route.startup,shouldExitApp=ctx.isBack&&route.isDefaultRoute&&isCurrentRouteStartup;if(!(shouldExitApp||apiClient&&apiClient.isLoggedIn()||route.anonymous))return console.debug("appRouter - route does not allow anonymous access, redirecting to login"),void beginConnectionWizard();if(shouldExitApp)return appHost.supports("exit")?void appHost.exit():void 0;if(apiClient&&apiClient.isLoggedIn()){if(console.debug("appRouter - user is authenticated"),route.isDefaultRoute)return console.debug("appRouter - loading skin home page"),void function loadUserSkinWithOptions(ctx){require(["queryString"],(function(queryString){var params=queryString.parse(ctx.querystring);skinManager.loadUserSkin({start:params.start})}))}(ctx);if(route.roles)return void function validateRoles(apiClient,roles){return Promise.all(roles.split(",").map((function(role){return function validateRole(apiClient,role){if("admin"===role)return apiClient.getCurrentUser().then((function(user){return user.Policy.IsAdministrator?Promise.resolve():Promise.reject()}));return Promise.resolve()}(apiClient,role)})))}(apiClient,route.roles).then((function(){callback()}),beginConnectionWizard)}console.debug("appRouter - proceeding to "+pathname),callback()}(ctx,route,(function(){!function initRoute(ctx,next,route){var onInitComplete=function onInitComplete(controllerFactory){!function sendRouteToViewManager(ctx,next,route,controllerFactory){if(isDummyBackToHome&&"home"===route.type)return void(isDummyBackToHome=!1);!function cancelCurrentLoadRequest(){var currentRequest=currentViewLoadRequest;currentRequest&&(currentRequest.cancel=!0)}();var isBackNav=ctx.isBack,currentRequest={url:baseUrl()+ctx.path,transition:route.transition,isBack:isBackNav,state:ctx.state,type:route.type,fullscreen:route.fullscreen,controllerFactory:controllerFactory,options:{supportsThemeMedia:route.supportsThemeMedia||!1,enableMediaControl:!1!==route.enableMediaControl},autoFocus:route.autoFocus};currentViewLoadRequest=currentRequest;var onNewViewNeeded=function onNewViewNeeded(){"string"==typeof route.path?loadContentUrl(ctx,0,route,currentRequest):next()};if(!isBackNav)return void onNewViewNeeded();viewManager.tryRestoreView(currentRequest,(function(){currentRouteInfo={route:route,path:ctx.path}})).catch((function(result){result&&result.cancelled||onNewViewNeeded()}))}(ctx,next,route,controllerFactory)};route.controller?require(["controllers/"+route.controller],onInitComplete):onInitComplete()}(ctx,next,route)}))}function onForcedLogoutMessageTimeout(){var msg=forcedLogoutMsg;forcedLogoutMsg=null,msg&&require(["alert"],(function(alert){alert(msg)}))}function onRequestFail(e,data){401===data.status&&("ParentalControl"===data.errorCode&&(!currentRouteInfo||(currentRouteInfo.route.anonymous||currentRouteInfo.route.startup)||(!function showForcedLogoutMessage(msg){forcedLogoutMsg=msg,msgTimeout&&clearTimeout(msgTimeout),msgTimeout=setTimeout(onForcedLogoutMessageTimeout,100)}(globalize.translate("AccessRestrictedTryAgainLater")),appRouter.showLocalLogin(this.serverId()))))}function onBeforeExit(e){browser.web0s&&page.restorePreviousState()}function normalizeImageOptions(options){var setQuality,scaleFactor=browser.tv?.8:1;if(options.maxWidth&&(options.maxWidth=Math.round(options.maxWidth*scaleFactor),setQuality=!0),options.width&&(options.width=Math.round(options.width*scaleFactor),setQuality=!0),options.maxHeight&&(options.maxHeight=Math.round(options.maxHeight*scaleFactor),setQuality=!0),options.height&&(options.height=Math.round(options.height*scaleFactor),setQuality=!0),setQuality){var quality=100,type=options.type||"Primary";quality=browser.tv||browser.slow?browser.chrome?"Primary"===type?40:50:"Backdrop"===type?60:50:"Backdrop"===type?70:90,options.quality=quality}}function getMaxBandwidth(){if(navigator.connection){var max=navigator.connection.downlinkMax;if(max&&max>0&&max<Number.POSITIVE_INFINITY)return max/=8,max*=1e6,max*=.7,max=parseInt(max)}return null}function getMaxBandwidthIOS(){return 8e5}function onApiClientCreated(e,newApiClient){newApiClient.normalizeImageOptions=normalizeImageOptions,browser.iOS?newApiClient.getMaxBandwidth=getMaxBandwidthIOS:newApiClient.getMaxBandwidth=getMaxBandwidth,events.off(newApiClient,"requestfail",onRequestFail),events.on(newApiClient,"requestfail",onRequestFail)}function initApiClient(apiClient){onApiClientCreated(0,apiClient)}function onAppResume(){var apiClient=connectionManager.currentApiClient();apiClient&&apiClient.ensureWebSocket()}function enableHistory(){return!browser.xboxOne&&!browser.orsay}function getRequestFile(){var path=self.location.pathname||"",index=path.lastIndexOf("/");return(path=-1!==index?path.substring(index):"/"+path)&&"/"!==path||(path="/index.html"),path}function endsWith(str,srch){return str.lastIndexOf(srch)===srch.length-1}var baseRoute=self.location.href.split("?")[0].replace(getRequestFile(),"");function baseUrl(){return baseRoute}endsWith(baseRoute=baseRoute.split("#")[0],"/")&&!endsWith(baseRoute,"://")&&(baseRoute=baseRoute.substring(0,baseRoute.length-1));var popstateOccurred=!1;window.addEventListener("popstate",(function(){popstateOccurred=!0}));var resolveOnNextShow,currentRouteInfo,startPages=["home","login","selectserver"];function show(path,options){0!==path.indexOf("/")&&-1===path.indexOf("://")&&(path="/"+path);var baseRoute=baseUrl();return path=path.replace(baseRoute,""),currentRouteInfo&&currentRouteInfo.path===path&&"home"!==currentRouteInfo.route.type?(loading.hide(),Promise.resolve()):new Promise((function(resolve,reject){resolveOnNextShow=resolve,page.show(path,options)}))}function current(){return currentRouteInfo?currentRouteInfo.route:null}document.addEventListener("viewshow",(function(){var resolve=resolveOnNextShow;resolve&&(resolveOnNextShow=null,resolve())}));var backdropContainer,backgroundContainer,allRoutes=[];return function setBaseRoute(){var baseRoute=self.location.pathname.replace(getRequestFile(),"");baseRoute.lastIndexOf("/")===baseRoute.length-1&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.debug("setting page base to "+baseRoute),page.base(baseRoute)}(),appRouter.addRoute=function addRoute(path,newRoute){page(path,function getHandler(route){return function(ctx,next){ctx.isBack=popstateOccurred,handleRoute(ctx,next,route),popstateOccurred=!1}}(newRoute)),allRoutes.push(newRoute)},appRouter.param=function param(name,url){name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var results=new RegExp("[\\?&]"+name+"=([^&#]*)","i").exec(url||function getWindowLocationSearch(win){var currentPath=currentRouteInfo&&currentRouteInfo.path||"",index=currentPath.indexOf("?"),search="";return-1!==index&&(search=currentPath.substring(index)),search||""}());return null==results?"":decodeURIComponent(results[1].replace(/\+/g," "))},appRouter.back=function back(){page.back()},appRouter.show=show,appRouter.showDirect=function showDirect(path){return new Promise((function(resolve,reject){resolveOnNextShow=resolve,page.show(baseUrl()+path)}))},appRouter.start=function start(options){loading.show(),function initApiClients(){connectionManager.getApiClients().forEach(initApiClient),events.on(connectionManager,"apiclientcreated",onApiClientCreated)}(),events.on(appHost,"beforeexit",onBeforeExit),events.on(appHost,"resume",onAppResume),connectionManager.connect({enableAutoLogin:appSettings.enableAutoLogin()}).then((function(result){firstConnectionResult=result,page({click:!1!==(options=options||{}).click,hashbang:!1!==options.hashbang,enableHistory:enableHistory()})})).catch().then((function(){loading.hide()}))},appRouter.baseUrl=baseUrl,appRouter.canGoBack=function canGoBack(){var curr=current();return!!curr&&(!(!document.querySelector(".dialogContainer")&&-1!==startPages.indexOf(curr.type))&&(enableHistory()?history.length>1:(page.len||0)>0))},appRouter.current=current,appRouter.beginConnectionWizard=beginConnectionWizard,appRouter.invokeShortcut=function invokeShortcut(id){0===id.indexOf("library-")?(id=(id=id.replace("library-","")).split("_"),appRouter.showItem(id[0],id[1])):0===id.indexOf("item-")?(id=(id=id.replace("item-","")).split("_"),appRouter.showItem(id[0],id[1])):(id=id.split("_"),appRouter.show(appRouter.getRouteUrl(id[0],{serverId:id[1]})))},appRouter.showItem=function showItem(item,serverId,options){if("string"==typeof item){var apiClient=serverId?connectionManager.getApiClient(serverId):connectionManager.currentApiClient();apiClient.getItem(apiClient.getCurrentUserId(),item).then((function(item){appRouter.showItem(item,options)}))}else{2===arguments.length&&(options=arguments[1]);var url=appRouter.getRouteUrl(item,options);appRouter.show(url,{item:item})}},appRouter.setTransparency=function setTransparency(level){backdropContainer||(backdropContainer=document.querySelector(".backdropContainer")),backgroundContainer||(backgroundContainer=document.querySelector(".backgroundContainer")),"full"===level||2===level?(backdrop.clear(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):"backdrop"===level||1===level?(backdrop.externalBackdrop(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):(backdrop.externalBackdrop(!1),document.documentElement.classList.remove("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.remove("hide"))},appRouter.getRoutes=function getRoutes(){return allRoutes},appRouter.pushState=function pushState(state,title,url){state.navigate=!1,history.pushState(state,title,url)},appRouter.enableNativeHistory=function enableNativeHistory(){return!1},appRouter.handleAnchorClick=page.clickHandler,appRouter.TransparencyLevel={None:0,Backdrop:1,Full:2},appRouter}));
//# sourceMappingURL=appRouter.js.map
