"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitRouterVbrAttachment = exports.TransitRouterVbrAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "TransitRouterVbrAttachmentProperty", { enumerable: true, get: function () { return cen_generated_1.RosTransitRouterVbrAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::TransitRouterVbrAttachment`
 */
class TransitRouterVbrAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterVbrAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTransitRouterVbrAttachment = new cen_generated_1.RosTransitRouterVbrAttachment(this, id, {
            autoPublishRouteEnabled: props.autoPublishRouteEnabled,
            vbrOwnerId: props.vbrOwnerId,
            cenId: props.cenId,
            transitRouterAttachmentName: props.transitRouterAttachmentName,
            vbrId: props.vbrId,
            transitRouterAttachmentDescription: props.transitRouterAttachmentDescription,
            transitRouterId: props.transitRouterId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTransitRouterVbrAttachment;
        this.attrAutoPublishRouteEnabled = rosTransitRouterVbrAttachment.attrAutoPublishRouteEnabled;
        this.attrCenId = rosTransitRouterVbrAttachment.attrCenId;
        this.attrClientToken = rosTransitRouterVbrAttachment.attrClientToken;
        this.attrResourceType = rosTransitRouterVbrAttachment.attrResourceType;
        this.attrTransitRouterAttachmentDescription = rosTransitRouterVbrAttachment.attrTransitRouterAttachmentDescription;
        this.attrTransitRouterAttachmentId = rosTransitRouterVbrAttachment.attrTransitRouterAttachmentId;
        this.attrTransitRouterAttachmentName = rosTransitRouterVbrAttachment.attrTransitRouterAttachmentName;
        this.attrTransitRouterId = rosTransitRouterVbrAttachment.attrTransitRouterId;
        this.attrVbrId = rosTransitRouterVbrAttachment.attrVbrId;
        this.attrVbrOwnerId = rosTransitRouterVbrAttachment.attrVbrOwnerId;
    }
}
exports.TransitRouterVbrAttachment = TransitRouterVbrAttachment;
//# sourceMappingURL=data:application/json;base64,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