"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosTransitRouterVpcAttachment = exports.RosTransitRouterVbrAttachment = exports.RosTransitRouterRouteTablePropagation = exports.RosTransitRouterRouteTableAssociation = exports.RosTransitRouterRouteTable = exports.RosTransitRouterRouteEntry = exports.RosTransitRouterPeerAttachment = exports.RosTransitRouter = exports.RosRouteEntry = exports.RosChildInstanceRouteEntryToAttachment = exports.RosCenVbrHealthCheck = exports.RosCenRouteService = exports.RosCenRouteMap = exports.RosCenInstanceAttachment = exports.RosCenInstance = exports.RosCenBandwidthPackageAssociation = exports.RosCenBandwidthPackage = exports.RosCenBandwidthLimit = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosCenBandwidthLimitProps`
 *
 * @param properties - the TypeScript properties of a `RosCenBandwidthLimitProps`
 *
 * @returns the result of the validation.
 */
function RosCenBandwidthLimitPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('oppositeRegionId', ros.requiredValidator)(properties.oppositeRegionId));
    errors.collect(ros.propertyValidator('oppositeRegionId', ros.validateString)(properties.oppositeRegionId));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('bandwidthLimit', ros.requiredValidator)(properties.bandwidthLimit));
    if (properties.bandwidthLimit && (typeof properties.bandwidthLimit) !== 'object') {
        errors.collect(ros.propertyValidator('bandwidthLimit', ros.validateRange)({
            data: properties.bandwidthLimit,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('bandwidthLimit', ros.validateNumber)(properties.bandwidthLimit));
    errors.collect(ros.propertyValidator('localRegionId', ros.requiredValidator)(properties.localRegionId));
    errors.collect(ros.propertyValidator('localRegionId', ros.validateString)(properties.localRegionId));
    return errors.wrap('supplied properties not correct for "RosCenBandwidthLimitProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenBandwidthLimit` resource
 *
 * @param properties - the TypeScript properties of a `RosCenBandwidthLimitProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenBandwidthLimit` resource.
 */
// @ts-ignore TS6133
function rosCenBandwidthLimitPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenBandwidthLimitPropsValidator(properties).assertSuccess();
    }
    return {
        BandwidthLimit: ros.numberToRosTemplate(properties.bandwidthLimit),
        CenId: ros.stringToRosTemplate(properties.cenId),
        LocalRegionId: ros.stringToRosTemplate(properties.localRegionId),
        OppositeRegionId: ros.stringToRosTemplate(properties.oppositeRegionId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenBandwidthLimit`
 */
class RosCenBandwidthLimit extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenBandwidthLimit`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenBandwidthLimit.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.bandwidthLimit = props.bandwidthLimit;
        this.cenId = props.cenId;
        this.localRegionId = props.localRegionId;
        this.oppositeRegionId = props.oppositeRegionId;
    }
    get rosProperties() {
        return {
            bandwidthLimit: this.bandwidthLimit,
            cenId: this.cenId,
            localRegionId: this.localRegionId,
            oppositeRegionId: this.oppositeRegionId,
        };
    }
    renderProperties(props) {
        return rosCenBandwidthLimitPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenBandwidthLimit = RosCenBandwidthLimit;
/**
 * The resource type name for this resource class.
 */
RosCenBandwidthLimit.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenBandwidthLimit";
/**
 * Determine whether the given properties match those of a `RosCenBandwidthPackageProps`
 *
 * @param properties - the TypeScript properties of a `RosCenBandwidthPackageProps`
 *
 * @returns the result of the validation.
 */
function RosCenBandwidthPackagePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.bandwidthPackageChargeType && (typeof properties.bandwidthPackageChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('bandwidthPackageChargeType', ros.validateAllowedValues)({
            data: properties.bandwidthPackageChargeType,
            allowedValues: ["POSTPAY", "PREPAY"],
        }));
    }
    errors.collect(ros.propertyValidator('bandwidthPackageChargeType', ros.validateString)(properties.bandwidthPackageChargeType));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('geographicRegionBId', ros.requiredValidator)(properties.geographicRegionBId));
    if (properties.geographicRegionBId && (typeof properties.geographicRegionBId) !== 'object') {
        errors.collect(ros.propertyValidator('geographicRegionBId', ros.validateAllowedValues)({
            data: properties.geographicRegionBId,
            allowedValues: ["China", "North-America", "Asia-Pacific", "Europe", "Australia"],
        }));
    }
    errors.collect(ros.propertyValidator('geographicRegionBId', ros.validateString)(properties.geographicRegionBId));
    errors.collect(ros.propertyValidator('geographicRegionAId', ros.requiredValidator)(properties.geographicRegionAId));
    if (properties.geographicRegionAId && (typeof properties.geographicRegionAId) !== 'object') {
        errors.collect(ros.propertyValidator('geographicRegionAId', ros.validateAllowedValues)({
            data: properties.geographicRegionAId,
            allowedValues: ["China", "North-America", "Asia-Pacific", "Europe", "Australia"],
        }));
    }
    errors.collect(ros.propertyValidator('geographicRegionAId', ros.validateString)(properties.geographicRegionAId));
    if (properties.pricingCycle && (typeof properties.pricingCycle) !== 'object') {
        errors.collect(ros.propertyValidator('pricingCycle', ros.validateAllowedValues)({
            data: properties.pricingCycle,
            allowedValues: ["Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('pricingCycle', ros.validateString)(properties.pricingCycle));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('bandwidth', ros.requiredValidator)(properties.bandwidth));
    if (properties.bandwidth && (typeof properties.bandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('bandwidth', ros.validateRange)({
            data: properties.bandwidth,
            min: 2,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('bandwidth', ros.validateNumber)(properties.bandwidth));
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('autoPay', ros.validateBoolean)(properties.autoPay));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    if (properties.autoRenewDuration && (typeof properties.autoRenewDuration) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewDuration', ros.validateAllowedValues)({
            data: properties.autoRenewDuration,
            allowedValues: [1, 2, 3, 6],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewDuration', ros.validateNumber)(properties.autoRenewDuration));
    return errors.wrap('supplied properties not correct for "RosCenBandwidthPackageProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenBandwidthPackage` resource
 *
 * @param properties - the TypeScript properties of a `RosCenBandwidthPackageProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenBandwidthPackage` resource.
 */
// @ts-ignore TS6133
function rosCenBandwidthPackagePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenBandwidthPackagePropsValidator(properties).assertSuccess();
    }
    return {
        Bandwidth: ros.numberToRosTemplate(properties.bandwidth),
        GeographicRegionAId: ros.stringToRosTemplate(properties.geographicRegionAId),
        GeographicRegionBId: ros.stringToRosTemplate(properties.geographicRegionBId),
        AutoPay: ros.booleanToRosTemplate(properties.autoPay),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        AutoRenewDuration: ros.numberToRosTemplate(properties.autoRenewDuration),
        BandwidthPackageChargeType: ros.stringToRosTemplate(properties.bandwidthPackageChargeType),
        Description: ros.stringToRosTemplate(properties.description),
        Name: ros.stringToRosTemplate(properties.name),
        Period: ros.numberToRosTemplate(properties.period),
        PricingCycle: ros.stringToRosTemplate(properties.pricingCycle),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenBandwidthPackage`
 */
class RosCenBandwidthPackage extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenBandwidthPackage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenBandwidthPackage.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCenBandwidthPackageId = this.getAtt('CenBandwidthPackageId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.bandwidth = props.bandwidth;
        this.geographicRegionAId = props.geographicRegionAId;
        this.geographicRegionBId = props.geographicRegionBId;
        this.autoPay = props.autoPay;
        this.autoRenew = props.autoRenew;
        this.autoRenewDuration = props.autoRenewDuration;
        this.bandwidthPackageChargeType = props.bandwidthPackageChargeType;
        this.description = props.description;
        this.name = props.name;
        this.period = props.period;
        this.pricingCycle = props.pricingCycle;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            bandwidth: this.bandwidth,
            geographicRegionAId: this.geographicRegionAId,
            geographicRegionBId: this.geographicRegionBId,
            autoPay: this.autoPay,
            autoRenew: this.autoRenew,
            autoRenewDuration: this.autoRenewDuration,
            bandwidthPackageChargeType: this.bandwidthPackageChargeType,
            description: this.description,
            name: this.name,
            period: this.period,
            pricingCycle: this.pricingCycle,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosCenBandwidthPackagePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenBandwidthPackage = RosCenBandwidthPackage;
/**
 * The resource type name for this resource class.
 */
RosCenBandwidthPackage.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenBandwidthPackage";
/**
 * Determine whether the given properties match those of a `RosCenBandwidthPackageAssociationProps`
 *
 * @param properties - the TypeScript properties of a `RosCenBandwidthPackageAssociationProps`
 *
 * @returns the result of the validation.
 */
function RosCenBandwidthPackageAssociationPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('cenBandwidthPackageId', ros.requiredValidator)(properties.cenBandwidthPackageId));
    errors.collect(ros.propertyValidator('cenBandwidthPackageId', ros.validateString)(properties.cenBandwidthPackageId));
    return errors.wrap('supplied properties not correct for "RosCenBandwidthPackageAssociationProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenBandwidthPackageAssociation` resource
 *
 * @param properties - the TypeScript properties of a `RosCenBandwidthPackageAssociationProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenBandwidthPackageAssociation` resource.
 */
// @ts-ignore TS6133
function rosCenBandwidthPackageAssociationPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenBandwidthPackageAssociationPropsValidator(properties).assertSuccess();
    }
    return {
        CenBandwidthPackageId: ros.stringToRosTemplate(properties.cenBandwidthPackageId),
        CenId: ros.stringToRosTemplate(properties.cenId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenBandwidthPackageAssociation`
 */
class RosCenBandwidthPackageAssociation extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenBandwidthPackageAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenBandwidthPackageAssociation.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenBandwidthPackageId = props.cenBandwidthPackageId;
        this.cenId = props.cenId;
    }
    get rosProperties() {
        return {
            cenBandwidthPackageId: this.cenBandwidthPackageId,
            cenId: this.cenId,
        };
    }
    renderProperties(props) {
        return rosCenBandwidthPackageAssociationPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenBandwidthPackageAssociation = RosCenBandwidthPackageAssociation;
/**
 * The resource type name for this resource class.
 */
RosCenBandwidthPackageAssociation.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenBandwidthPackageAssociation";
/**
 * Determine whether the given properties match those of a `RosCenInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosCenInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosCenInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('protectionLevel', ros.validateString)(properties.protectionLevel));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosCenInstance_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "RosCenInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosCenInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenInstance` resource.
 */
// @ts-ignore TS6133
function rosCenInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenInstancePropsValidator(properties).assertSuccess();
    }
    return {
        Description: ros.stringToRosTemplate(properties.description),
        Name: ros.stringToRosTemplate(properties.name),
        ProtectionLevel: ros.stringToRosTemplate(properties.protectionLevel),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        Tags: ros.listMapper(rosCenInstanceTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenInstance`
 */
class RosCenInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCenId = this.getAtt('CenId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.description = props.description;
        this.name = props.name;
        this.protectionLevel = props.protectionLevel;
        this.resourceGroupId = props.resourceGroupId;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            description: this.description,
            name: this.name,
            protectionLevel: this.protectionLevel,
            resourceGroupId: this.resourceGroupId,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosCenInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenInstance = RosCenInstance;
/**
 * The resource type name for this resource class.
 */
RosCenInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenInstance";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosCenInstance_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenInstance.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenInstance.Tags` resource.
 */
// @ts-ignore TS6133
function rosCenInstanceTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCenInstance_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosCenInstanceAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `RosCenInstanceAttachmentProps`
 *
 * @returns the result of the validation.
 */
function RosCenInstanceAttachmentPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('childInstanceType', ros.requiredValidator)(properties.childInstanceType));
    if (properties.childInstanceType && (typeof properties.childInstanceType) !== 'object') {
        errors.collect(ros.propertyValidator('childInstanceType', ros.validateAllowedValues)({
            data: properties.childInstanceType,
            allowedValues: ["VPC", "VBR", "CCN"],
        }));
    }
    errors.collect(ros.propertyValidator('childInstanceType', ros.validateString)(properties.childInstanceType));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('childInstanceOwnerId', ros.validateNumber)(properties.childInstanceOwnerId));
    errors.collect(ros.propertyValidator('childInstanceId', ros.requiredValidator)(properties.childInstanceId));
    errors.collect(ros.propertyValidator('childInstanceId', ros.validateString)(properties.childInstanceId));
    errors.collect(ros.propertyValidator('childInstanceRegionId', ros.requiredValidator)(properties.childInstanceRegionId));
    errors.collect(ros.propertyValidator('childInstanceRegionId', ros.validateString)(properties.childInstanceRegionId));
    return errors.wrap('supplied properties not correct for "RosCenInstanceAttachmentProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenInstanceAttachment` resource
 *
 * @param properties - the TypeScript properties of a `RosCenInstanceAttachmentProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenInstanceAttachment` resource.
 */
// @ts-ignore TS6133
function rosCenInstanceAttachmentPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenInstanceAttachmentPropsValidator(properties).assertSuccess();
    }
    return {
        CenId: ros.stringToRosTemplate(properties.cenId),
        ChildInstanceId: ros.stringToRosTemplate(properties.childInstanceId),
        ChildInstanceRegionId: ros.stringToRosTemplate(properties.childInstanceRegionId),
        ChildInstanceType: ros.stringToRosTemplate(properties.childInstanceType),
        ChildInstanceOwnerId: ros.numberToRosTemplate(properties.childInstanceOwnerId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenInstanceAttachment`
 */
class RosCenInstanceAttachment extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenInstanceAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenInstanceAttachment.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenId = props.cenId;
        this.childInstanceId = props.childInstanceId;
        this.childInstanceRegionId = props.childInstanceRegionId;
        this.childInstanceType = props.childInstanceType;
        this.childInstanceOwnerId = props.childInstanceOwnerId;
    }
    get rosProperties() {
        return {
            cenId: this.cenId,
            childInstanceId: this.childInstanceId,
            childInstanceRegionId: this.childInstanceRegionId,
            childInstanceType: this.childInstanceType,
            childInstanceOwnerId: this.childInstanceOwnerId,
        };
    }
    renderProperties(props) {
        return rosCenInstanceAttachmentPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenInstanceAttachment = RosCenInstanceAttachment;
/**
 * The resource type name for this resource class.
 */
RosCenInstanceAttachment.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenInstanceAttachment";
/**
 * Determine whether the given properties match those of a `RosCenRouteMapProps`
 *
 * @param properties - the TypeScript properties of a `RosCenRouteMapProps`
 *
 * @returns the result of the validation.
 */
function RosCenRouteMapPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('sourceInstanceIdsReverseMatch', ros.validateBoolean)(properties.sourceInstanceIdsReverseMatch));
    errors.collect(ros.propertyValidator('transmitDirection', ros.requiredValidator)(properties.transmitDirection));
    errors.collect(ros.propertyValidator('transmitDirection', ros.validateString)(properties.transmitDirection));
    errors.collect(ros.propertyValidator('matchCommunitySet', ros.listValidator(ros.validateString))(properties.matchCommunitySet));
    errors.collect(ros.propertyValidator('cenRegionId', ros.requiredValidator)(properties.cenRegionId));
    errors.collect(ros.propertyValidator('cenRegionId', ros.validateString)(properties.cenRegionId));
    errors.collect(ros.propertyValidator('sourceRouteTableIds', ros.listValidator(ros.validateString))(properties.sourceRouteTableIds));
    errors.collect(ros.propertyValidator('destinationInstanceIds', ros.listValidator(ros.validateString))(properties.destinationInstanceIds));
    errors.collect(ros.propertyValidator('destinationInstanceIdsReverseMatch', ros.validateBoolean)(properties.destinationInstanceIdsReverseMatch));
    errors.collect(ros.propertyValidator('sourceInstanceIds', ros.listValidator(ros.validateString))(properties.sourceInstanceIds));
    errors.collect(ros.propertyValidator('destinationRouteTableIds', ros.listValidator(ros.validateString))(properties.destinationRouteTableIds));
    errors.collect(ros.propertyValidator('destinationCidrBlocks', ros.listValidator(ros.validateString))(properties.destinationCidrBlocks));
    errors.collect(ros.propertyValidator('operateCommunitySet', ros.listValidator(ros.validateString))(properties.operateCommunitySet));
    errors.collect(ros.propertyValidator('destinationChildInstanceTypes', ros.listValidator(ros.validateString))(properties.destinationChildInstanceTypes));
    errors.collect(ros.propertyValidator('priority', ros.requiredValidator)(properties.priority));
    errors.collect(ros.propertyValidator('priority', ros.validateNumber)(properties.priority));
    errors.collect(ros.propertyValidator('sourceChildInstanceTypes', ros.listValidator(ros.validateString))(properties.sourceChildInstanceTypes));
    errors.collect(ros.propertyValidator('asPathMatchMode', ros.validateString)(properties.asPathMatchMode));
    errors.collect(ros.propertyValidator('cidrMatchMode', ros.validateString)(properties.cidrMatchMode));
    errors.collect(ros.propertyValidator('mapResult', ros.requiredValidator)(properties.mapResult));
    errors.collect(ros.propertyValidator('mapResult', ros.validateString)(properties.mapResult));
    errors.collect(ros.propertyValidator('routeTypes', ros.listValidator(ros.validateString))(properties.routeTypes));
    errors.collect(ros.propertyValidator('preference', ros.validateNumber)(properties.preference));
    errors.collect(ros.propertyValidator('communityOperateMode', ros.validateString)(properties.communityOperateMode));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('nextPriority', ros.validateNumber)(properties.nextPriority));
    errors.collect(ros.propertyValidator('prependAsPath', ros.listValidator(ros.validateString))(properties.prependAsPath));
    errors.collect(ros.propertyValidator('communityMatchMode', ros.validateString)(properties.communityMatchMode));
    errors.collect(ros.propertyValidator('matchAsns', ros.listValidator(ros.validateString))(properties.matchAsns));
    errors.collect(ros.propertyValidator('sourceRegionIds', ros.listValidator(ros.validateString))(properties.sourceRegionIds));
    return errors.wrap('supplied properties not correct for "RosCenRouteMapProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenRouteMap` resource
 *
 * @param properties - the TypeScript properties of a `RosCenRouteMapProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenRouteMap` resource.
 */
// @ts-ignore TS6133
function rosCenRouteMapPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenRouteMapPropsValidator(properties).assertSuccess();
    }
    return {
        CenId: ros.stringToRosTemplate(properties.cenId),
        CenRegionId: ros.stringToRosTemplate(properties.cenRegionId),
        MapResult: ros.stringToRosTemplate(properties.mapResult),
        Priority: ros.numberToRosTemplate(properties.priority),
        TransmitDirection: ros.stringToRosTemplate(properties.transmitDirection),
        AsPathMatchMode: ros.stringToRosTemplate(properties.asPathMatchMode),
        CidrMatchMode: ros.stringToRosTemplate(properties.cidrMatchMode),
        CommunityMatchMode: ros.stringToRosTemplate(properties.communityMatchMode),
        CommunityOperateMode: ros.stringToRosTemplate(properties.communityOperateMode),
        Description: ros.stringToRosTemplate(properties.description),
        DestinationChildInstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.destinationChildInstanceTypes),
        DestinationCidrBlocks: ros.listMapper(ros.stringToRosTemplate)(properties.destinationCidrBlocks),
        DestinationInstanceIds: ros.listMapper(ros.stringToRosTemplate)(properties.destinationInstanceIds),
        DestinationInstanceIdsReverseMatch: ros.booleanToRosTemplate(properties.destinationInstanceIdsReverseMatch),
        DestinationRouteTableIds: ros.listMapper(ros.stringToRosTemplate)(properties.destinationRouteTableIds),
        MatchAsns: ros.listMapper(ros.stringToRosTemplate)(properties.matchAsns),
        MatchCommunitySet: ros.listMapper(ros.stringToRosTemplate)(properties.matchCommunitySet),
        NextPriority: ros.numberToRosTemplate(properties.nextPriority),
        OperateCommunitySet: ros.listMapper(ros.stringToRosTemplate)(properties.operateCommunitySet),
        Preference: ros.numberToRosTemplate(properties.preference),
        PrependAsPath: ros.listMapper(ros.stringToRosTemplate)(properties.prependAsPath),
        RouteTypes: ros.listMapper(ros.stringToRosTemplate)(properties.routeTypes),
        SourceChildInstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.sourceChildInstanceTypes),
        SourceInstanceIds: ros.listMapper(ros.stringToRosTemplate)(properties.sourceInstanceIds),
        SourceInstanceIdsReverseMatch: ros.booleanToRosTemplate(properties.sourceInstanceIdsReverseMatch),
        SourceRegionIds: ros.listMapper(ros.stringToRosTemplate)(properties.sourceRegionIds),
        SourceRouteTableIds: ros.listMapper(ros.stringToRosTemplate)(properties.sourceRouteTableIds),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenRouteMap`
 */
class RosCenRouteMap extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenRouteMap`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenRouteMap.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrRouteMapId = this.getAtt('RouteMapId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenId = props.cenId;
        this.cenRegionId = props.cenRegionId;
        this.mapResult = props.mapResult;
        this.priority = props.priority;
        this.transmitDirection = props.transmitDirection;
        this.asPathMatchMode = props.asPathMatchMode;
        this.cidrMatchMode = props.cidrMatchMode;
        this.communityMatchMode = props.communityMatchMode;
        this.communityOperateMode = props.communityOperateMode;
        this.description = props.description;
        this.destinationChildInstanceTypes = props.destinationChildInstanceTypes;
        this.destinationCidrBlocks = props.destinationCidrBlocks;
        this.destinationInstanceIds = props.destinationInstanceIds;
        this.destinationInstanceIdsReverseMatch = props.destinationInstanceIdsReverseMatch;
        this.destinationRouteTableIds = props.destinationRouteTableIds;
        this.matchAsns = props.matchAsns;
        this.matchCommunitySet = props.matchCommunitySet;
        this.nextPriority = props.nextPriority;
        this.operateCommunitySet = props.operateCommunitySet;
        this.preference = props.preference;
        this.prependAsPath = props.prependAsPath;
        this.routeTypes = props.routeTypes;
        this.sourceChildInstanceTypes = props.sourceChildInstanceTypes;
        this.sourceInstanceIds = props.sourceInstanceIds;
        this.sourceInstanceIdsReverseMatch = props.sourceInstanceIdsReverseMatch;
        this.sourceRegionIds = props.sourceRegionIds;
        this.sourceRouteTableIds = props.sourceRouteTableIds;
    }
    get rosProperties() {
        return {
            cenId: this.cenId,
            cenRegionId: this.cenRegionId,
            mapResult: this.mapResult,
            priority: this.priority,
            transmitDirection: this.transmitDirection,
            asPathMatchMode: this.asPathMatchMode,
            cidrMatchMode: this.cidrMatchMode,
            communityMatchMode: this.communityMatchMode,
            communityOperateMode: this.communityOperateMode,
            description: this.description,
            destinationChildInstanceTypes: this.destinationChildInstanceTypes,
            destinationCidrBlocks: this.destinationCidrBlocks,
            destinationInstanceIds: this.destinationInstanceIds,
            destinationInstanceIdsReverseMatch: this.destinationInstanceIdsReverseMatch,
            destinationRouteTableIds: this.destinationRouteTableIds,
            matchAsns: this.matchAsns,
            matchCommunitySet: this.matchCommunitySet,
            nextPriority: this.nextPriority,
            operateCommunitySet: this.operateCommunitySet,
            preference: this.preference,
            prependAsPath: this.prependAsPath,
            routeTypes: this.routeTypes,
            sourceChildInstanceTypes: this.sourceChildInstanceTypes,
            sourceInstanceIds: this.sourceInstanceIds,
            sourceInstanceIdsReverseMatch: this.sourceInstanceIdsReverseMatch,
            sourceRegionIds: this.sourceRegionIds,
            sourceRouteTableIds: this.sourceRouteTableIds,
        };
    }
    renderProperties(props) {
        return rosCenRouteMapPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenRouteMap = RosCenRouteMap;
/**
 * The resource type name for this resource class.
 */
RosCenRouteMap.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenRouteMap";
/**
 * Determine whether the given properties match those of a `RosCenRouteServiceProps`
 *
 * @param properties - the TypeScript properties of a `RosCenRouteServiceProps`
 *
 * @returns the result of the validation.
 */
function RosCenRouteServicePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('conflictIgnore', ros.validateBoolean)(properties.conflictIgnore));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('hostRegionId', ros.requiredValidator)(properties.hostRegionId));
    errors.collect(ros.propertyValidator('hostRegionId', ros.validateString)(properties.hostRegionId));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('accessRegionId', ros.requiredValidator)(properties.accessRegionId));
    errors.collect(ros.propertyValidator('accessRegionId', ros.validateString)(properties.accessRegionId));
    errors.collect(ros.propertyValidator('host', ros.requiredValidator)(properties.host));
    errors.collect(ros.propertyValidator('host', ros.validateString)(properties.host));
    errors.collect(ros.propertyValidator('hostVpcId', ros.requiredValidator)(properties.hostVpcId));
    errors.collect(ros.propertyValidator('hostVpcId', ros.validateString)(properties.hostVpcId));
    return errors.wrap('supplied properties not correct for "RosCenRouteServiceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenRouteService` resource
 *
 * @param properties - the TypeScript properties of a `RosCenRouteServiceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenRouteService` resource.
 */
// @ts-ignore TS6133
function rosCenRouteServicePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenRouteServicePropsValidator(properties).assertSuccess();
    }
    return {
        AccessRegionId: ros.stringToRosTemplate(properties.accessRegionId),
        CenId: ros.stringToRosTemplate(properties.cenId),
        Host: ros.stringToRosTemplate(properties.host),
        HostRegionId: ros.stringToRosTemplate(properties.hostRegionId),
        HostVpcId: ros.stringToRosTemplate(properties.hostVpcId),
        ConflictIgnore: ros.booleanToRosTemplate(properties.conflictIgnore),
        Description: ros.stringToRosTemplate(properties.description),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenRouteService`
 */
class RosCenRouteService extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenRouteService`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenRouteService.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrId = this.getAtt('Id');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accessRegionId = props.accessRegionId;
        this.cenId = props.cenId;
        this.host = props.host;
        this.hostRegionId = props.hostRegionId;
        this.hostVpcId = props.hostVpcId;
        this.conflictIgnore = props.conflictIgnore;
        this.description = props.description;
    }
    get rosProperties() {
        return {
            accessRegionId: this.accessRegionId,
            cenId: this.cenId,
            host: this.host,
            hostRegionId: this.hostRegionId,
            hostVpcId: this.hostVpcId,
            conflictIgnore: this.conflictIgnore,
            description: this.description,
        };
    }
    renderProperties(props) {
        return rosCenRouteServicePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenRouteService = RosCenRouteService;
/**
 * The resource type name for this resource class.
 */
RosCenRouteService.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenRouteService";
/**
 * Determine whether the given properties match those of a `RosCenVbrHealthCheckProps`
 *
 * @param properties - the TypeScript properties of a `RosCenVbrHealthCheckProps`
 *
 * @returns the result of the validation.
 */
function RosCenVbrHealthCheckPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('vbrInstanceRegionId', ros.requiredValidator)(properties.vbrInstanceRegionId));
    errors.collect(ros.propertyValidator('vbrInstanceRegionId', ros.validateString)(properties.vbrInstanceRegionId));
    errors.collect(ros.propertyValidator('healthCheckInterval', ros.validateNumber)(properties.healthCheckInterval));
    errors.collect(ros.propertyValidator('vbrInstanceId', ros.requiredValidator)(properties.vbrInstanceId));
    errors.collect(ros.propertyValidator('vbrInstanceId', ros.validateString)(properties.vbrInstanceId));
    errors.collect(ros.propertyValidator('vbrInstanceOwnerId', ros.validateNumber)(properties.vbrInstanceOwnerId));
    errors.collect(ros.propertyValidator('healthCheckSourceIp', ros.validateString)(properties.healthCheckSourceIp));
    errors.collect(ros.propertyValidator('healthyThreshold', ros.validateNumber)(properties.healthyThreshold));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('healthCheckTargetIp', ros.requiredValidator)(properties.healthCheckTargetIp));
    errors.collect(ros.propertyValidator('healthCheckTargetIp', ros.validateString)(properties.healthCheckTargetIp));
    return errors.wrap('supplied properties not correct for "RosCenVbrHealthCheckProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenVbrHealthCheck` resource
 *
 * @param properties - the TypeScript properties of a `RosCenVbrHealthCheckProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::CenVbrHealthCheck` resource.
 */
// @ts-ignore TS6133
function rosCenVbrHealthCheckPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCenVbrHealthCheckPropsValidator(properties).assertSuccess();
    }
    return {
        CenId: ros.stringToRosTemplate(properties.cenId),
        HealthCheckTargetIp: ros.stringToRosTemplate(properties.healthCheckTargetIp),
        VbrInstanceId: ros.stringToRosTemplate(properties.vbrInstanceId),
        VbrInstanceRegionId: ros.stringToRosTemplate(properties.vbrInstanceRegionId),
        HealthCheckInterval: ros.numberToRosTemplate(properties.healthCheckInterval),
        HealthCheckSourceIp: ros.stringToRosTemplate(properties.healthCheckSourceIp),
        HealthyThreshold: ros.numberToRosTemplate(properties.healthyThreshold),
        VbrInstanceOwnerId: ros.numberToRosTemplate(properties.vbrInstanceOwnerId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::CenVbrHealthCheck`
 */
class RosCenVbrHealthCheck extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::CenVbrHealthCheck`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCenVbrHealthCheck.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCenId = this.getAtt('CenId');
        this.attrHealthCheckInterval = this.getAtt('HealthCheckInterval');
        this.attrHealthCheckSourceIp = this.getAtt('HealthCheckSourceIp');
        this.attrHealthCheckTargetIp = this.getAtt('HealthCheckTargetIp');
        this.attrHealthyThreshold = this.getAtt('HealthyThreshold');
        this.attrVbrInstanceId = this.getAtt('VbrInstanceId');
        this.attrVbrInstanceOwnerId = this.getAtt('VbrInstanceOwnerId');
        this.attrVbrInstanceRegionId = this.getAtt('VbrInstanceRegionId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenId = props.cenId;
        this.healthCheckTargetIp = props.healthCheckTargetIp;
        this.vbrInstanceId = props.vbrInstanceId;
        this.vbrInstanceRegionId = props.vbrInstanceRegionId;
        this.healthCheckInterval = props.healthCheckInterval;
        this.healthCheckSourceIp = props.healthCheckSourceIp;
        this.healthyThreshold = props.healthyThreshold;
        this.vbrInstanceOwnerId = props.vbrInstanceOwnerId;
    }
    get rosProperties() {
        return {
            cenId: this.cenId,
            healthCheckTargetIp: this.healthCheckTargetIp,
            vbrInstanceId: this.vbrInstanceId,
            vbrInstanceRegionId: this.vbrInstanceRegionId,
            healthCheckInterval: this.healthCheckInterval,
            healthCheckSourceIp: this.healthCheckSourceIp,
            healthyThreshold: this.healthyThreshold,
            vbrInstanceOwnerId: this.vbrInstanceOwnerId,
        };
    }
    renderProperties(props) {
        return rosCenVbrHealthCheckPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCenVbrHealthCheck = RosCenVbrHealthCheck;
/**
 * The resource type name for this resource class.
 */
RosCenVbrHealthCheck.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::CenVbrHealthCheck";
/**
 * Determine whether the given properties match those of a `RosChildInstanceRouteEntryToAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `RosChildInstanceRouteEntryToAttachmentProps`
 *
 * @returns the result of the validation.
 */
function RosChildInstanceRouteEntryToAttachmentPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('transitRouterAttachmentId', ros.requiredValidator)(properties.transitRouterAttachmentId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentId', ros.validateString)(properties.transitRouterAttachmentId));
    errors.collect(ros.propertyValidator('routeTableId', ros.requiredValidator)(properties.routeTableId));
    errors.collect(ros.propertyValidator('routeTableId', ros.validateString)(properties.routeTableId));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('destinationCidrBlock', ros.requiredValidator)(properties.destinationCidrBlock));
    errors.collect(ros.propertyValidator('destinationCidrBlock', ros.validateString)(properties.destinationCidrBlock));
    return errors.wrap('supplied properties not correct for "RosChildInstanceRouteEntryToAttachmentProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::ChildInstanceRouteEntryToAttachment` resource
 *
 * @param properties - the TypeScript properties of a `RosChildInstanceRouteEntryToAttachmentProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::ChildInstanceRouteEntryToAttachment` resource.
 */
// @ts-ignore TS6133
function rosChildInstanceRouteEntryToAttachmentPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosChildInstanceRouteEntryToAttachmentPropsValidator(properties).assertSuccess();
    }
    return {
        CenId: ros.stringToRosTemplate(properties.cenId),
        DestinationCidrBlock: ros.stringToRosTemplate(properties.destinationCidrBlock),
        RouteTableId: ros.stringToRosTemplate(properties.routeTableId),
        TransitRouterAttachmentId: ros.stringToRosTemplate(properties.transitRouterAttachmentId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::ChildInstanceRouteEntryToAttachment`
 */
class RosChildInstanceRouteEntryToAttachment extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::ChildInstanceRouteEntryToAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosChildInstanceRouteEntryToAttachment.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCenId = this.getAtt('CenId');
        this.attrDestinationCidrBlock = this.getAtt('DestinationCidrBlock');
        this.attrRouteTableId = this.getAtt('RouteTableId');
        this.attrTransitRouterAttachmentId = this.getAtt('TransitRouterAttachmentId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenId = props.cenId;
        this.destinationCidrBlock = props.destinationCidrBlock;
        this.routeTableId = props.routeTableId;
        this.transitRouterAttachmentId = props.transitRouterAttachmentId;
    }
    get rosProperties() {
        return {
            cenId: this.cenId,
            destinationCidrBlock: this.destinationCidrBlock,
            routeTableId: this.routeTableId,
            transitRouterAttachmentId: this.transitRouterAttachmentId,
        };
    }
    renderProperties(props) {
        return rosChildInstanceRouteEntryToAttachmentPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosChildInstanceRouteEntryToAttachment = RosChildInstanceRouteEntryToAttachment;
/**
 * The resource type name for this resource class.
 */
RosChildInstanceRouteEntryToAttachment.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::ChildInstanceRouteEntryToAttachment";
/**
 * Determine whether the given properties match those of a `RosRouteEntryProps`
 *
 * @param properties - the TypeScript properties of a `RosRouteEntryProps`
 *
 * @returns the result of the validation.
 */
function RosRouteEntryPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('childInstanceType', ros.requiredValidator)(properties.childInstanceType));
    if (properties.childInstanceType && (typeof properties.childInstanceType) !== 'object') {
        errors.collect(ros.propertyValidator('childInstanceType', ros.validateAllowedValues)({
            data: properties.childInstanceType,
            allowedValues: ["VPC", "VBR"],
        }));
    }
    errors.collect(ros.propertyValidator('childInstanceType', ros.validateString)(properties.childInstanceType));
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('destinationCidrBlock', ros.requiredValidator)(properties.destinationCidrBlock));
    errors.collect(ros.propertyValidator('destinationCidrBlock', ros.validateString)(properties.destinationCidrBlock));
    errors.collect(ros.propertyValidator('childInstanceRouteTableId', ros.requiredValidator)(properties.childInstanceRouteTableId));
    errors.collect(ros.propertyValidator('childInstanceRouteTableId', ros.validateString)(properties.childInstanceRouteTableId));
    errors.collect(ros.propertyValidator('childInstanceId', ros.requiredValidator)(properties.childInstanceId));
    errors.collect(ros.propertyValidator('childInstanceId', ros.validateString)(properties.childInstanceId));
    errors.collect(ros.propertyValidator('childInstanceRegionId', ros.requiredValidator)(properties.childInstanceRegionId));
    errors.collect(ros.propertyValidator('childInstanceRegionId', ros.validateString)(properties.childInstanceRegionId));
    return errors.wrap('supplied properties not correct for "RosRouteEntryProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::RouteEntry` resource
 *
 * @param properties - the TypeScript properties of a `RosRouteEntryProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::RouteEntry` resource.
 */
// @ts-ignore TS6133
function rosRouteEntryPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRouteEntryPropsValidator(properties).assertSuccess();
    }
    return {
        CenId: ros.stringToRosTemplate(properties.cenId),
        ChildInstanceId: ros.stringToRosTemplate(properties.childInstanceId),
        ChildInstanceRegionId: ros.stringToRosTemplate(properties.childInstanceRegionId),
        ChildInstanceRouteTableId: ros.stringToRosTemplate(properties.childInstanceRouteTableId),
        ChildInstanceType: ros.stringToRosTemplate(properties.childInstanceType),
        DestinationCidrBlock: ros.stringToRosTemplate(properties.destinationCidrBlock),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::RouteEntry`
 */
class RosRouteEntry extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::RouteEntry`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRouteEntry.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenId = props.cenId;
        this.childInstanceId = props.childInstanceId;
        this.childInstanceRegionId = props.childInstanceRegionId;
        this.childInstanceRouteTableId = props.childInstanceRouteTableId;
        this.childInstanceType = props.childInstanceType;
        this.destinationCidrBlock = props.destinationCidrBlock;
    }
    get rosProperties() {
        return {
            cenId: this.cenId,
            childInstanceId: this.childInstanceId,
            childInstanceRegionId: this.childInstanceRegionId,
            childInstanceRouteTableId: this.childInstanceRouteTableId,
            childInstanceType: this.childInstanceType,
            destinationCidrBlock: this.destinationCidrBlock,
        };
    }
    renderProperties(props) {
        return rosRouteEntryPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRouteEntry = RosRouteEntry;
/**
 * The resource type name for this resource class.
 */
RosRouteEntry.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::RouteEntry";
/**
 * Determine whether the given properties match those of a `RosTransitRouterProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('cenId', ros.requiredValidator)(properties.cenId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('transitRouterName', ros.validateString)(properties.transitRouterName));
    errors.collect(ros.propertyValidator('transitRouterDescription', ros.validateString)(properties.transitRouterDescription));
    return errors.wrap('supplied properties not correct for "RosTransitRouterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouter` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouter` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterPropsValidator(properties).assertSuccess();
    }
    return {
        CenId: ros.stringToRosTemplate(properties.cenId),
        TransitRouterDescription: ros.stringToRosTemplate(properties.transitRouterDescription),
        TransitRouterName: ros.stringToRosTemplate(properties.transitRouterName),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouter`
 */
class RosTransitRouter extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouter.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAliUid = this.getAtt('AliUid');
        this.attrCenId = this.getAtt('CenId');
        this.attrSystemTransitRouterRouteTableId = this.getAtt('SystemTransitRouterRouteTableId');
        this.attrTransitRouterDescription = this.getAtt('TransitRouterDescription');
        this.attrTransitRouterId = this.getAtt('TransitRouterId');
        this.attrTransitRouterName = this.getAtt('TransitRouterName');
        this.attrType = this.getAtt('Type');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.cenId = props.cenId;
        this.transitRouterDescription = props.transitRouterDescription;
        this.transitRouterName = props.transitRouterName;
    }
    get rosProperties() {
        return {
            cenId: this.cenId,
            transitRouterDescription: this.transitRouterDescription,
            transitRouterName: this.transitRouterName,
        };
    }
    renderProperties(props) {
        return rosTransitRouterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouter = RosTransitRouter;
/**
 * The resource type name for this resource class.
 */
RosTransitRouter.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouter";
/**
 * Determine whether the given properties match those of a `RosTransitRouterPeerAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterPeerAttachmentProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterPeerAttachmentPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('autoPublishRouteEnabled', ros.validateBoolean)(properties.autoPublishRouteEnabled));
    errors.collect(ros.propertyValidator('bandwidth', ros.validateNumber)(properties.bandwidth));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentName', ros.validateString)(properties.transitRouterAttachmentName));
    errors.collect(ros.propertyValidator('peerTransitRouterId', ros.requiredValidator)(properties.peerTransitRouterId));
    errors.collect(ros.propertyValidator('peerTransitRouterId', ros.validateString)(properties.peerTransitRouterId));
    errors.collect(ros.propertyValidator('cenBandwidthPackageId', ros.validateString)(properties.cenBandwidthPackageId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentDescription', ros.validateString)(properties.transitRouterAttachmentDescription));
    errors.collect(ros.propertyValidator('transitRouterId', ros.validateString)(properties.transitRouterId));
    errors.collect(ros.propertyValidator('peerTransitRouterRegionId', ros.validateString)(properties.peerTransitRouterRegionId));
    return errors.wrap('supplied properties not correct for "RosTransitRouterPeerAttachmentProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterPeerAttachment` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterPeerAttachmentProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterPeerAttachment` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterPeerAttachmentPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterPeerAttachmentPropsValidator(properties).assertSuccess();
    }
    return {
        PeerTransitRouterId: ros.stringToRosTemplate(properties.peerTransitRouterId),
        AutoPublishRouteEnabled: ros.booleanToRosTemplate(properties.autoPublishRouteEnabled),
        Bandwidth: ros.numberToRosTemplate(properties.bandwidth),
        CenBandwidthPackageId: ros.stringToRosTemplate(properties.cenBandwidthPackageId),
        CenId: ros.stringToRosTemplate(properties.cenId),
        PeerTransitRouterRegionId: ros.stringToRosTemplate(properties.peerTransitRouterRegionId),
        TransitRouterAttachmentDescription: ros.stringToRosTemplate(properties.transitRouterAttachmentDescription),
        TransitRouterAttachmentName: ros.stringToRosTemplate(properties.transitRouterAttachmentName),
        TransitRouterId: ros.stringToRosTemplate(properties.transitRouterId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterPeerAttachment`
 */
class RosTransitRouterPeerAttachment extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterPeerAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterPeerAttachment.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAutoPublishRouteEnabled = this.getAtt('AutoPublishRouteEnabled');
        this.attrBandwidth = this.getAtt('Bandwidth');
        this.attrCenBandwidthPackageId = this.getAtt('CenBandwidthPackageId');
        this.attrCenId = this.getAtt('CenId');
        this.attrClientToken = this.getAtt('ClientToken');
        this.attrGeographicSpanId = this.getAtt('GeographicSpanId');
        this.attrPeerTransitRouterId = this.getAtt('PeerTransitRouterId');
        this.attrPeerTransitRouterOwnerId = this.getAtt('PeerTransitRouterOwnerId');
        this.attrPeerTransitRouterRegionId = this.getAtt('PeerTransitRouterRegionId');
        this.attrResourceType = this.getAtt('ResourceType');
        this.attrTransitRouterAttachmentDescription = this.getAtt('TransitRouterAttachmentDescription');
        this.attrTransitRouterAttachmentId = this.getAtt('TransitRouterAttachmentId');
        this.attrTransitRouterAttachmentName = this.getAtt('TransitRouterAttachmentName');
        this.attrTransitRouterId = this.getAtt('TransitRouterId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.peerTransitRouterId = props.peerTransitRouterId;
        this.autoPublishRouteEnabled = props.autoPublishRouteEnabled;
        this.bandwidth = props.bandwidth;
        this.cenBandwidthPackageId = props.cenBandwidthPackageId;
        this.cenId = props.cenId;
        this.peerTransitRouterRegionId = props.peerTransitRouterRegionId;
        this.transitRouterAttachmentDescription = props.transitRouterAttachmentDescription;
        this.transitRouterAttachmentName = props.transitRouterAttachmentName;
        this.transitRouterId = props.transitRouterId;
    }
    get rosProperties() {
        return {
            peerTransitRouterId: this.peerTransitRouterId,
            autoPublishRouteEnabled: this.autoPublishRouteEnabled,
            bandwidth: this.bandwidth,
            cenBandwidthPackageId: this.cenBandwidthPackageId,
            cenId: this.cenId,
            peerTransitRouterRegionId: this.peerTransitRouterRegionId,
            transitRouterAttachmentDescription: this.transitRouterAttachmentDescription,
            transitRouterAttachmentName: this.transitRouterAttachmentName,
            transitRouterId: this.transitRouterId,
        };
    }
    renderProperties(props) {
        return rosTransitRouterPeerAttachmentPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterPeerAttachment = RosTransitRouterPeerAttachment;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterPeerAttachment.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterPeerAttachment";
/**
 * Determine whether the given properties match those of a `RosTransitRouterRouteEntryProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteEntryProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterRouteEntryPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('transitRouterRouteTableId', ros.requiredValidator)(properties.transitRouterRouteTableId));
    errors.collect(ros.propertyValidator('transitRouterRouteTableId', ros.validateString)(properties.transitRouterRouteTableId));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryDestinationCidrBlock', ros.requiredValidator)(properties.transitRouterRouteEntryDestinationCidrBlock));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryDestinationCidrBlock', ros.validateString)(properties.transitRouterRouteEntryDestinationCidrBlock));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryNextHopId', ros.validateString)(properties.transitRouterRouteEntryNextHopId));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryDescription', ros.validateString)(properties.transitRouterRouteEntryDescription));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryNextHopType', ros.requiredValidator)(properties.transitRouterRouteEntryNextHopType));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryNextHopType', ros.validateString)(properties.transitRouterRouteEntryNextHopType));
    errors.collect(ros.propertyValidator('transitRouterRouteEntryName', ros.validateString)(properties.transitRouterRouteEntryName));
    return errors.wrap('supplied properties not correct for "RosTransitRouterRouteEntryProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteEntry` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteEntryProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteEntry` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterRouteEntryPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterRouteEntryPropsValidator(properties).assertSuccess();
    }
    return {
        TransitRouterRouteEntryDestinationCidrBlock: ros.stringToRosTemplate(properties.transitRouterRouteEntryDestinationCidrBlock),
        TransitRouterRouteEntryNextHopType: ros.stringToRosTemplate(properties.transitRouterRouteEntryNextHopType),
        TransitRouterRouteTableId: ros.stringToRosTemplate(properties.transitRouterRouteTableId),
        TransitRouterRouteEntryDescription: ros.stringToRosTemplate(properties.transitRouterRouteEntryDescription),
        TransitRouterRouteEntryName: ros.stringToRosTemplate(properties.transitRouterRouteEntryName),
        TransitRouterRouteEntryNextHopId: ros.stringToRosTemplate(properties.transitRouterRouteEntryNextHopId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterRouteEntry`
 */
class RosTransitRouterRouteEntry extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterRouteEntry`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterRouteEntry.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrTransitRouterRouteEntryDescription = this.getAtt('TransitRouterRouteEntryDescription');
        this.attrTransitRouterRouteEntryDestinationCidrBlock = this.getAtt('TransitRouterRouteEntryDestinationCidrBlock');
        this.attrTransitRouterRouteEntryId = this.getAtt('TransitRouterRouteEntryId');
        this.attrTransitRouterRouteEntryName = this.getAtt('TransitRouterRouteEntryName');
        this.attrTransitRouterRouteEntryNextHopId = this.getAtt('TransitRouterRouteEntryNextHopId');
        this.attrTransitRouterRouteEntryNextHopType = this.getAtt('TransitRouterRouteEntryNextHopType');
        this.attrTransitRouterRouteEntryType = this.getAtt('TransitRouterRouteEntryType');
        this.attrTransitRouterRouteTableId = this.getAtt('TransitRouterRouteTableId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.transitRouterRouteEntryDestinationCidrBlock = props.transitRouterRouteEntryDestinationCidrBlock;
        this.transitRouterRouteEntryNextHopType = props.transitRouterRouteEntryNextHopType;
        this.transitRouterRouteTableId = props.transitRouterRouteTableId;
        this.transitRouterRouteEntryDescription = props.transitRouterRouteEntryDescription;
        this.transitRouterRouteEntryName = props.transitRouterRouteEntryName;
        this.transitRouterRouteEntryNextHopId = props.transitRouterRouteEntryNextHopId;
    }
    get rosProperties() {
        return {
            transitRouterRouteEntryDestinationCidrBlock: this.transitRouterRouteEntryDestinationCidrBlock,
            transitRouterRouteEntryNextHopType: this.transitRouterRouteEntryNextHopType,
            transitRouterRouteTableId: this.transitRouterRouteTableId,
            transitRouterRouteEntryDescription: this.transitRouterRouteEntryDescription,
            transitRouterRouteEntryName: this.transitRouterRouteEntryName,
            transitRouterRouteEntryNextHopId: this.transitRouterRouteEntryNextHopId,
        };
    }
    renderProperties(props) {
        return rosTransitRouterRouteEntryPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterRouteEntry = RosTransitRouterRouteEntry;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterRouteEntry.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterRouteEntry";
/**
 * Determine whether the given properties match those of a `RosTransitRouterRouteTableProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteTableProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterRouteTablePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('transitRouterRouteTableDescription', ros.validateString)(properties.transitRouterRouteTableDescription));
    errors.collect(ros.propertyValidator('transitRouterRouteTableName', ros.validateString)(properties.transitRouterRouteTableName));
    errors.collect(ros.propertyValidator('transitRouterId', ros.requiredValidator)(properties.transitRouterId));
    errors.collect(ros.propertyValidator('transitRouterId', ros.validateString)(properties.transitRouterId));
    return errors.wrap('supplied properties not correct for "RosTransitRouterRouteTableProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteTable` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteTableProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteTable` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterRouteTablePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterRouteTablePropsValidator(properties).assertSuccess();
    }
    return {
        TransitRouterId: ros.stringToRosTemplate(properties.transitRouterId),
        TransitRouterRouteTableDescription: ros.stringToRosTemplate(properties.transitRouterRouteTableDescription),
        TransitRouterRouteTableName: ros.stringToRosTemplate(properties.transitRouterRouteTableName),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterRouteTable`
 */
class RosTransitRouterRouteTable extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterRouteTable`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterRouteTable.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClientToken = this.getAtt('ClientToken');
        this.attrTransitRouterId = this.getAtt('TransitRouterId');
        this.attrTransitRouterRouteTableDescription = this.getAtt('TransitRouterRouteTableDescription');
        this.attrTransitRouterRouteTableId = this.getAtt('TransitRouterRouteTableId');
        this.attrTransitRouterRouteTableName = this.getAtt('TransitRouterRouteTableName');
        this.attrTransitRouterRouteTableType = this.getAtt('TransitRouterRouteTableType');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.transitRouterId = props.transitRouterId;
        this.transitRouterRouteTableDescription = props.transitRouterRouteTableDescription;
        this.transitRouterRouteTableName = props.transitRouterRouteTableName;
    }
    get rosProperties() {
        return {
            transitRouterId: this.transitRouterId,
            transitRouterRouteTableDescription: this.transitRouterRouteTableDescription,
            transitRouterRouteTableName: this.transitRouterRouteTableName,
        };
    }
    renderProperties(props) {
        return rosTransitRouterRouteTablePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterRouteTable = RosTransitRouterRouteTable;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterRouteTable.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterRouteTable";
/**
 * Determine whether the given properties match those of a `RosTransitRouterRouteTableAssociationProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteTableAssociationProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterRouteTableAssociationPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('transitRouterRouteTableId', ros.requiredValidator)(properties.transitRouterRouteTableId));
    errors.collect(ros.propertyValidator('transitRouterRouteTableId', ros.validateString)(properties.transitRouterRouteTableId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentId', ros.requiredValidator)(properties.transitRouterAttachmentId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentId', ros.validateString)(properties.transitRouterAttachmentId));
    return errors.wrap('supplied properties not correct for "RosTransitRouterRouteTableAssociationProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteTableAssociation` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteTableAssociationProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteTableAssociation` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterRouteTableAssociationPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterRouteTableAssociationPropsValidator(properties).assertSuccess();
    }
    return {
        TransitRouterAttachmentId: ros.stringToRosTemplate(properties.transitRouterAttachmentId),
        TransitRouterRouteTableId: ros.stringToRosTemplate(properties.transitRouterRouteTableId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterRouteTableAssociation`
 */
class RosTransitRouterRouteTableAssociation extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterRouteTableAssociation.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrResourceId = this.getAtt('ResourceId');
        this.attrResourceType = this.getAtt('ResourceType');
        this.attrTransitRouterAttachmentId = this.getAtt('TransitRouterAttachmentId');
        this.attrTransitRouterRouteTableId = this.getAtt('TransitRouterRouteTableId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.transitRouterAttachmentId = props.transitRouterAttachmentId;
        this.transitRouterRouteTableId = props.transitRouterRouteTableId;
    }
    get rosProperties() {
        return {
            transitRouterAttachmentId: this.transitRouterAttachmentId,
            transitRouterRouteTableId: this.transitRouterRouteTableId,
        };
    }
    renderProperties(props) {
        return rosTransitRouterRouteTableAssociationPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterRouteTableAssociation = RosTransitRouterRouteTableAssociation;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterRouteTableAssociation.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterRouteTableAssociation";
/**
 * Determine whether the given properties match those of a `RosTransitRouterRouteTablePropagationProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteTablePropagationProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterRouteTablePropagationPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('transitRouterRouteTableId', ros.requiredValidator)(properties.transitRouterRouteTableId));
    errors.collect(ros.propertyValidator('transitRouterRouteTableId', ros.validateString)(properties.transitRouterRouteTableId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentId', ros.requiredValidator)(properties.transitRouterAttachmentId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentId', ros.validateString)(properties.transitRouterAttachmentId));
    return errors.wrap('supplied properties not correct for "RosTransitRouterRouteTablePropagationProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteTablePropagation` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterRouteTablePropagationProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterRouteTablePropagation` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterRouteTablePropagationPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterRouteTablePropagationPropsValidator(properties).assertSuccess();
    }
    return {
        TransitRouterAttachmentId: ros.stringToRosTemplate(properties.transitRouterAttachmentId),
        TransitRouterRouteTableId: ros.stringToRosTemplate(properties.transitRouterRouteTableId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterRouteTablePropagation`
 */
class RosTransitRouterRouteTablePropagation extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterRouteTablePropagation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterRouteTablePropagation.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrResourceId = this.getAtt('ResourceId');
        this.attrResourceType = this.getAtt('ResourceType');
        this.attrTransitRouterAttachmentId = this.getAtt('TransitRouterAttachmentId');
        this.attrTransitRouterRouteTableId = this.getAtt('TransitRouterRouteTableId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.transitRouterAttachmentId = props.transitRouterAttachmentId;
        this.transitRouterRouteTableId = props.transitRouterRouteTableId;
    }
    get rosProperties() {
        return {
            transitRouterAttachmentId: this.transitRouterAttachmentId,
            transitRouterRouteTableId: this.transitRouterRouteTableId,
        };
    }
    renderProperties(props) {
        return rosTransitRouterRouteTablePropagationPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterRouteTablePropagation = RosTransitRouterRouteTablePropagation;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterRouteTablePropagation.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterRouteTablePropagation";
/**
 * Determine whether the given properties match those of a `RosTransitRouterVbrAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterVbrAttachmentProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterVbrAttachmentPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('autoPublishRouteEnabled', ros.validateBoolean)(properties.autoPublishRouteEnabled));
    errors.collect(ros.propertyValidator('vbrOwnerId', ros.validateNumber)(properties.vbrOwnerId));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentName', ros.validateString)(properties.transitRouterAttachmentName));
    errors.collect(ros.propertyValidator('vbrId', ros.requiredValidator)(properties.vbrId));
    errors.collect(ros.propertyValidator('vbrId', ros.validateString)(properties.vbrId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentDescription', ros.validateString)(properties.transitRouterAttachmentDescription));
    errors.collect(ros.propertyValidator('transitRouterId', ros.validateString)(properties.transitRouterId));
    return errors.wrap('supplied properties not correct for "RosTransitRouterVbrAttachmentProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterVbrAttachment` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterVbrAttachmentProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterVbrAttachment` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterVbrAttachmentPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterVbrAttachmentPropsValidator(properties).assertSuccess();
    }
    return {
        VbrId: ros.stringToRosTemplate(properties.vbrId),
        AutoPublishRouteEnabled: ros.booleanToRosTemplate(properties.autoPublishRouteEnabled),
        CenId: ros.stringToRosTemplate(properties.cenId),
        TransitRouterAttachmentDescription: ros.stringToRosTemplate(properties.transitRouterAttachmentDescription),
        TransitRouterAttachmentName: ros.stringToRosTemplate(properties.transitRouterAttachmentName),
        TransitRouterId: ros.stringToRosTemplate(properties.transitRouterId),
        VbrOwnerId: ros.numberToRosTemplate(properties.vbrOwnerId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterVbrAttachment`
 */
class RosTransitRouterVbrAttachment extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterVbrAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterVbrAttachment.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAutoPublishRouteEnabled = this.getAtt('AutoPublishRouteEnabled');
        this.attrCenId = this.getAtt('CenId');
        this.attrClientToken = this.getAtt('ClientToken');
        this.attrResourceType = this.getAtt('ResourceType');
        this.attrTransitRouterAttachmentDescription = this.getAtt('TransitRouterAttachmentDescription');
        this.attrTransitRouterAttachmentId = this.getAtt('TransitRouterAttachmentId');
        this.attrTransitRouterAttachmentName = this.getAtt('TransitRouterAttachmentName');
        this.attrTransitRouterId = this.getAtt('TransitRouterId');
        this.attrVbrId = this.getAtt('VbrId');
        this.attrVbrOwnerId = this.getAtt('VbrOwnerId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.vbrId = props.vbrId;
        this.autoPublishRouteEnabled = props.autoPublishRouteEnabled;
        this.cenId = props.cenId;
        this.transitRouterAttachmentDescription = props.transitRouterAttachmentDescription;
        this.transitRouterAttachmentName = props.transitRouterAttachmentName;
        this.transitRouterId = props.transitRouterId;
        this.vbrOwnerId = props.vbrOwnerId;
    }
    get rosProperties() {
        return {
            vbrId: this.vbrId,
            autoPublishRouteEnabled: this.autoPublishRouteEnabled,
            cenId: this.cenId,
            transitRouterAttachmentDescription: this.transitRouterAttachmentDescription,
            transitRouterAttachmentName: this.transitRouterAttachmentName,
            transitRouterId: this.transitRouterId,
            vbrOwnerId: this.vbrOwnerId,
        };
    }
    renderProperties(props) {
        return rosTransitRouterVbrAttachmentPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterVbrAttachment = RosTransitRouterVbrAttachment;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterVbrAttachment.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterVbrAttachment";
/**
 * Determine whether the given properties match those of a `RosTransitRouterVpcAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterVpcAttachmentProps`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterVpcAttachmentPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('routeTableAssociationEnabled', ros.validateBoolean)(properties.routeTableAssociationEnabled));
    errors.collect(ros.propertyValidator('deletionForce', ros.validateBoolean)(properties.deletionForce));
    errors.collect(ros.propertyValidator('autoCreateVpcRoute', ros.validateBoolean)(properties.autoCreateVpcRoute));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('chargeType', ros.validateString)(properties.chargeType));
    errors.collect(ros.propertyValidator('routeTablePropagationEnabled', ros.validateBoolean)(properties.routeTablePropagationEnabled));
    errors.collect(ros.propertyValidator('cenId', ros.validateString)(properties.cenId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentName', ros.validateString)(properties.transitRouterAttachmentName));
    errors.collect(ros.propertyValidator('zoneMappings', ros.requiredValidator)(properties.zoneMappings));
    if (properties.zoneMappings && (Array.isArray(properties.zoneMappings) || (typeof properties.zoneMappings) === 'string')) {
        errors.collect(ros.propertyValidator('zoneMappings', ros.validateLength)({
            data: properties.zoneMappings.length,
            min: undefined,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('zoneMappings', ros.listValidator(RosTransitRouterVpcAttachment_ZoneMappingsPropertyValidator))(properties.zoneMappings));
    errors.collect(ros.propertyValidator('vpcOwnerId', ros.validateNumber)(properties.vpcOwnerId));
    errors.collect(ros.propertyValidator('transitRouterAttachmentDescription', ros.validateString)(properties.transitRouterAttachmentDescription));
    errors.collect(ros.propertyValidator('transitRouterId', ros.validateString)(properties.transitRouterId));
    return errors.wrap('supplied properties not correct for "RosTransitRouterVpcAttachmentProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterVpcAttachment` resource
 *
 * @param properties - the TypeScript properties of a `RosTransitRouterVpcAttachmentProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterVpcAttachment` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterVpcAttachmentPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTransitRouterVpcAttachmentPropsValidator(properties).assertSuccess();
    }
    return {
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        ZoneMappings: ros.listMapper(rosTransitRouterVpcAttachmentZoneMappingsPropertyToRosTemplate)(properties.zoneMappings),
        AutoCreateVpcRoute: ros.booleanToRosTemplate(properties.autoCreateVpcRoute),
        CenId: ros.stringToRosTemplate(properties.cenId),
        ChargeType: ros.stringToRosTemplate(properties.chargeType),
        DeletionForce: ros.booleanToRosTemplate(properties.deletionForce),
        RouteTableAssociationEnabled: ros.booleanToRosTemplate(properties.routeTableAssociationEnabled),
        RouteTablePropagationEnabled: ros.booleanToRosTemplate(properties.routeTablePropagationEnabled),
        TransitRouterAttachmentDescription: ros.stringToRosTemplate(properties.transitRouterAttachmentDescription),
        TransitRouterAttachmentName: ros.stringToRosTemplate(properties.transitRouterAttachmentName),
        TransitRouterId: ros.stringToRosTemplate(properties.transitRouterId),
        VpcOwnerId: ros.numberToRosTemplate(properties.vpcOwnerId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CEN::TransitRouterVpcAttachment`
 */
class RosTransitRouterVpcAttachment extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterVpcAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTransitRouterVpcAttachment.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCenId = this.getAtt('CenId');
        this.attrClientToken = this.getAtt('ClientToken');
        this.attrResourceType = this.getAtt('ResourceType');
        this.attrTransitRouterAttachmentDescription = this.getAtt('TransitRouterAttachmentDescription');
        this.attrTransitRouterAttachmentId = this.getAtt('TransitRouterAttachmentId');
        this.attrTransitRouterAttachmentName = this.getAtt('TransitRouterAttachmentName');
        this.attrTransitRouterId = this.getAtt('TransitRouterId');
        this.attrVpcId = this.getAtt('VpcId');
        this.attrVpcOwnerId = this.getAtt('VpcOwnerId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.vpcId = props.vpcId;
        this.zoneMappings = props.zoneMappings;
        this.autoCreateVpcRoute = props.autoCreateVpcRoute;
        this.cenId = props.cenId;
        this.chargeType = props.chargeType;
        this.deletionForce = props.deletionForce;
        this.routeTableAssociationEnabled = props.routeTableAssociationEnabled;
        this.routeTablePropagationEnabled = props.routeTablePropagationEnabled;
        this.transitRouterAttachmentDescription = props.transitRouterAttachmentDescription;
        this.transitRouterAttachmentName = props.transitRouterAttachmentName;
        this.transitRouterId = props.transitRouterId;
        this.vpcOwnerId = props.vpcOwnerId;
    }
    get rosProperties() {
        return {
            vpcId: this.vpcId,
            zoneMappings: this.zoneMappings,
            autoCreateVpcRoute: this.autoCreateVpcRoute,
            cenId: this.cenId,
            chargeType: this.chargeType,
            deletionForce: this.deletionForce,
            routeTableAssociationEnabled: this.routeTableAssociationEnabled,
            routeTablePropagationEnabled: this.routeTablePropagationEnabled,
            transitRouterAttachmentDescription: this.transitRouterAttachmentDescription,
            transitRouterAttachmentName: this.transitRouterAttachmentName,
            transitRouterId: this.transitRouterId,
            vpcOwnerId: this.vpcOwnerId,
        };
    }
    renderProperties(props) {
        return rosTransitRouterVpcAttachmentPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTransitRouterVpcAttachment = RosTransitRouterVpcAttachment;
/**
 * The resource type name for this resource class.
 */
RosTransitRouterVpcAttachment.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CEN::TransitRouterVpcAttachment";
/**
 * Determine whether the given properties match those of a `ZoneMappingsProperty`
 *
 * @param properties - the TypeScript properties of a `ZoneMappingsProperty`
 *
 * @returns the result of the validation.
 */
function RosTransitRouterVpcAttachment_ZoneMappingsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('zoneId', ros.requiredValidator)(properties.zoneId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    return errors.wrap('supplied properties not correct for "ZoneMappingsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterVpcAttachment.ZoneMappings` resource
 *
 * @param properties - the TypeScript properties of a `ZoneMappingsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CEN::TransitRouterVpcAttachment.ZoneMappings` resource.
 */
// @ts-ignore TS6133
function rosTransitRouterVpcAttachmentZoneMappingsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosTransitRouterVpcAttachment_ZoneMappingsPropertyValidator(properties).assertSuccess();
    return {
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
    };
}
//# sourceMappingURL=data:application/json;base64,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