# coding: utf-8
#
# This code was auto generated by AfterShip SDK Generator.
# Do not edit the class manually.

from typing import Optional
from enum import Enum, unique


class ApiException(Exception):
    """
    The base exception class for all ApiException

    :param code: Error code enum. Would be described in the following sections.
    :param status_code: Same as the http status code. Must have a value.
    :param message: Error returned by the API: same as meta.message, Error not returned by the API: error object default message
    :param meta_code: Could be null for the error that is not returned by the API,
        for example, timeout error, network error.
    :param response_body: response.body, if any.
    """

    def __init__(
        self,
        code: str,
        message: str,
        status_code: Optional[int] = None,
        meta_code: Optional[int] = None,
        response_body: Optional[str] = None,
        response_header: Optional[object] = None,
    ) -> None:
        super(ApiException, self).__init__()
        self.meta_code = meta_code
        self.message = message
        self.code = code
        self.status_code = status_code
        self.response_body = response_body
        self.response_header = response_header

    def __str__(self):
        return "{}: {}".format(self.__class__.__name__, self.message)


class BadRequestError(ApiException):
    pass


class UnauthorizedError(ApiException):
    pass


class ForbiddenError(ApiException):
    pass


class NotFoundError(ApiException):
    pass


class TooManyRequestsError(ApiException):
    pass


class InternalError(ApiException):
    pass


class TimedOutError(ApiException):
    pass


class UnknownError(ApiException):
    pass


class InvalidApiKeyError(BadRequestError):
    pass


class InvalidOptionError(BadRequestError):
    pass


class RateLimitExceedError(TooManyRequestsError):
    pass


@unique
class ErrorCodeEnum(Enum):
    """
    All available additional fields

    allowed enum values
    """

    INVALID_API_KEY = "INVALID_API_KEY"
    INVALID_OPTION = "INVALID_OPTION"
    BAD_REQUEST = "BAD_REQUEST"
    RATE_LIMIT_EXCEED = "RATE_LIMIT_EXCEED"
    TIMED_OUT = "TIMED_OUT"
    UNKNOW_ERROR = "UNKNOW_ERROR"

    INVALID_REQUEST = "INVALID_REQUEST"
    INVALID_JSON = "INVALID_JSON"
    TRACKING_ALREADY_EXIST = "TRACKING_ALREADY_EXIST"
    TRACKING_DOES_NOT_EXIST = "TRACKING_DOES_NOT_EXIST"
    TRACKING_NUMBER_INVALID = "TRACKING_NUMBER_INVALID"
    TRACKING_REQUIRED = "TRACKING_REQUIRED"
    TRACKING_NUMBER_REQUIRED = "TRACKING_NUMBER_REQUIRED"
    VALUE_INVALID = "VALUE_INVALID"
    VALUE_REQUIRED = "VALUE_REQUIRED"
    SLUG_INVALID = "SLUG_INVALID"
    MISSING_OR_INVALID_REQUIRED_FIELD = "MISSING_OR_INVALID_REQUIRED_FIELD"
    BAD_COURIER = "BAD_COURIER"
    INACTIVE_RETRACK_NOT_ALLOWED = "INACTIVE_RETRACK_NOT_ALLOWED"
    NOTIFICATION_REUQIRED = "NOTIFICATION_REUQIRED"
    ID_INVALID = "ID_INVALID"
    RETRACK_ONCE_ALLOWED = "RETRACK_ONCE_ALLOWED"
    TRACKING_NUMBER_FORMAT_INVALID = "TRACKING_NUMBER_FORMAT_INVALID"
    API_KEY_INVALID = "API_KEY_INVALID"
    REQUEST_NOT_ALLOWED = "REQUEST_NOT_ALLOWED"
    NOT_FOUND = "NOT_FOUND"
    TOO_MANY_REQUEST = "TOO_MANY_REQUEST"
    INTERNAL_ERROR = "INTERNAL_ERROR"
