# coding: utf-8
#
# This code was auto generated by AfterShip SDK Generator.
# Do not edit the class manually.

import os

from typing import Optional

from tracking.auth import ApiKey, Rsa, Aes
from tracking.exceptions import InvalidApiKeyError, InvalidOptionError, ErrorCodeEnum

_sdkPrefix = "AFTERSHIP_TRACKING_SDK_"


def _get_val_from_env_if_need(value, key_suffix, default=None):
    if value is None:
        key = f"{_sdkPrefix}{key_suffix}"
        return os.environ.get(key, default)
    return value


class Configuration:
    """This class contains various settings of the API client.

    :param domain: str - Base url.
    :param authentication_type: str - decide your authentication type.
    :param api_key: str - AS API key(s).
    :param api_secret: str - AS api secret.
    :param max_retry: int - retry limit.
    :param user_agent: user-agent string for AS.
    :param timeout: int - milliseconds timeout.
    :param proxy: str - proxy url string.
    """

    def __init__(
        self,
        domain: Optional[str] = None,
        authentication_type: Optional[str] = None,
        max_retry: Optional[int] = None,
        user_agent: Optional[str] = None,
        api_key: Optional[str] = None,
        api_secret: Optional[str] = None,
        proxy: Optional[str] = None,
        timeout: Optional[int] = None,
    ) -> None:
        self.domain = str(
            _get_val_from_env_if_need(
                domain, key_suffix="DOMAIN", default="https://api.aftership.com"
            )
        )

        self.authentication_type = str(
            _get_val_from_env_if_need(
                authentication_type, key_suffix="AUTHENTICATION_TYPE", default=ApiKey
            )
        )

        self.max_retry = int(
            _get_val_from_env_if_need(max_retry, key_suffix="MAX_RETRY", default=2)
        )

        self.user_agent = (
            str(_get_val_from_env_if_need(user_agent, key_suffix="USER_AGENT", default="")) or None
        )

        self.api_key = (
            str(_get_val_from_env_if_need(api_key, key_suffix="API_KEY", default="")) or None
        )

        self.api_secret = (
            str(_get_val_from_env_if_need(api_secret, key_suffix="API_SECRET", default="")) or None
        )

        self.proxy = str(_get_val_from_env_if_need(proxy, key_suffix="PROXY", default="")) or None

        self.timeout = int(_get_val_from_env_if_need(timeout, key_suffix="TIMEOUT", default=10000))

        self._validate()

    def _validate(self):
        if self.domain is None or len(self.domain) == 0:
            raise InvalidOptionError(
                code=ErrorCodeEnum.INVALID_OPTION, message=f"Invalid option: domain={self.domain}"
            )
        if self.authentication_type not in {ApiKey, Rsa, Aes}:
            raise InvalidOptionError(
                code=ErrorCodeEnum.INVALID_OPTION,
                message=f"Invalid option: authentication_type={self.authentication_type}",
            )

        if self.api_key is None or len(self.api_key) == 0:
            raise InvalidApiKeyError(code=ErrorCodeEnum.INVALID_API_KEY, message="Invalid API key")

        if self.authentication_type != ApiKey and (
            self.api_secret is None or len(self.api_secret) == 0
        ):
            raise InvalidOptionError(
                code=ErrorCodeEnum.INVALID_OPTION,
                message=f"Invalid option: api_secret={self.api_secret}",
            )

        if self.max_retry > 10 or self.max_retry < 0:
            raise InvalidOptionError(
                code=ErrorCodeEnum.INVALID_OPTION,
                message=f"Invalid option: max_retry={self.max_retry}",
            )

        if self.timeout <= 0:
            raise InvalidOptionError(
                code=ErrorCodeEnum.INVALID_OPTION, message=f"Invalid option: timeout={self.timeout}"
            )
