# coding: utf-8
#
# This code was auto generated by AfterShip SDK Generator.
# Do not edit the class manually.

import json
from typing import Union


from tracking.models import (
    PredictRequest,
    PredictResponse,
    PredictBatchRequest,
    PredictBatchResponse,
)
from tracking.request import ApiClient, validate_params


class EstimatedDeliveryDateApi(ApiClient):
    """EstimatedDeliveryDateApi api implements"""

    @validate_params
    def predict(self, predict_request: Union[PredictRequest, dict], **kwargs) -> PredictResponse:
        """
        > The estimated delivery date is provided by AfterShip, based on its AI-predictive model. You can display the EDD on the product page, cart, and order checkout page. It indicates when a customer will receive the order.You can use  to activate this feature.
        :param predict_request:
        :param kwargs:
            request options:
                **headers** (dict): support custom headers.
                **verify** bool|str|SSLContext: SSL certificates (a.k.a CA bundle) used to
                    verify the identity of requested hosts. Either `True` (default CA bundle),
                    a path to an SSL certificate file, an `ssl.SSLContext`, or `False`
                    (which will disable verification).
        """
        url = "/tracking/2025-01/estimated-delivery-date/predict"

        body = predict_request
        if not isinstance(body, dict):
            body = predict_request.model_dump(exclude_none=True)
        body = json.dumps(body)

        result = self._request("POST", url=url, body=body, **kwargs)
        return PredictResponse().from_dict(result)

    @validate_params
    def predict_batch(
        self, predict_batch_request: Union[PredictBatchRequest, dict], **kwargs
    ) -> PredictBatchResponse:
        """
        > The estimated delivery date is provided by AfterShip, based on its AI-predictive model. You can display the EDD on the product page, cart, and order checkout page. It indicates when a customer will receive the order.You can use  to activate this feature.Supported functionalities require:1. One `EstimatedDeliveryDate` object for one prediction result.2. Maximum 5 `EstimatedDeliveryDate` objects are allowed.3. API call will fail if any of the requests `EstimatedDeliveryDate` objects do not meet the specification requirement.
        :param predict_batch_request:
        :param kwargs:
            request options:
                **headers** (dict): support custom headers.
                **verify** bool|str|SSLContext: SSL certificates (a.k.a CA bundle) used to
                    verify the identity of requested hosts. Either `True` (default CA bundle),
                    a path to an SSL certificate file, an `ssl.SSLContext`, or `False`
                    (which will disable verification).
        """
        url = "/tracking/2025-01/estimated-delivery-date/predict-batch"

        body = predict_batch_request
        if not isinstance(body, dict):
            body = predict_batch_request.model_dump(exclude_none=True)
        body = json.dumps(body)

        result = self._request("POST", url=url, body=body, **kwargs)
        return PredictBatchResponse().from_dict(result)
