# coding: utf-8
#
# This code was auto generated by AfterShip SDK Generator.
# Do not edit the class manually.

import json
from typing import Union


from tracking.models import (
    DetectCourierRequest,
    DetectCourierResponse,
    GetAllCouriersResponse,
    GetUserCouriersResponse,
)
from tracking.request import ApiClient, validate_params


class CourierApi(ApiClient):
    """CourierApi api implements"""

    @validate_params
    def detect_courier(
        self, detect_courier_request: Union[DetectCourierRequest, dict], **kwargs
    ) -> DetectCourierResponse:
        """
        Return a list of matched couriers based on tracking number format and  or a list of couriers.
        :param detect_courier_request:
        :param kwargs:
            request options:
                **headers** (dict): support custom headers.
                **verify** bool|str|SSLContext: SSL certificates (a.k.a CA bundle) used to
                    verify the identity of requested hosts. Either `True` (default CA bundle),
                    a path to an SSL certificate file, an `ssl.SSLContext`, or `False`
                    (which will disable verification).
        """
        url = "/tracking/2025-01/couriers/detect"

        body = detect_courier_request
        if not isinstance(body, dict):
            body = detect_courier_request.model_dump(exclude_none=True)
        body = json.dumps(body)

        result = self._request("POST", url=url, body=body, **kwargs)
        return DetectCourierResponse().from_dict(result)

    @validate_params
    def get_all_couriers(self, **kwargs) -> GetAllCouriersResponse:
        """
        Return a list of all couriers.
        :param kwargs:
            request options:
                **headers** (dict): support custom headers.
                **verify** bool|str|SSLContext: SSL certificates (a.k.a CA bundle) used to
                    verify the identity of requested hosts. Either `True` (default CA bundle),
                    a path to an SSL certificate file, an `ssl.SSLContext`, or `False`
                    (which will disable verification).
        """
        url = "/tracking/2025-01/couriers/all"

        result = self._request("GET", url=url, **kwargs)
        return GetAllCouriersResponse().from_dict(result)

    @validate_params
    def get_user_couriers(self, **kwargs) -> GetUserCouriersResponse:
        """
        Return a list of .
        :param kwargs:
            request options:
                **headers** (dict): support custom headers.
                **verify** bool|str|SSLContext: SSL certificates (a.k.a CA bundle) used to
                    verify the identity of requested hosts. Either `True` (default CA bundle),
                    a path to an SSL certificate file, an `ssl.SSLContext`, or `False`
                    (which will disable verification).
        """
        url = "/tracking/2025-01/couriers"

        result = self._request("GET", url=url, **kwargs)
        return GetUserCouriersResponse().from_dict(result)
