/*!
 * jQuery JavaScript Library v3.6.0
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2021-03-02T17:08Z
 */
(function(global,factory){"use strict";if(typeof module==="object"&&typeof module.exports==="object"){module.exports=global.document?factory(global,true):function(w){if(!w.document){throw new Error("jQuery requires a window with a document");}
return factory(w);};}else{factory(global);}
})(typeof window!=="undefined"?window:this,function(window,noGlobal){"use strict";var arr=[];var getProto=Object.getPrototypeOf;var slice=arr.slice;var flat=arr.flat?function(array){return arr.flat.call(array);}:function(array){return arr.concat.apply([],array);};var push=arr.push;var indexOf=arr.indexOf;var class2type={};var toString=class2type.toString;var hasOwn=class2type.hasOwnProperty;var fnToString=hasOwn.toString;var ObjectFunctionString=fnToString.call(Object);var support={};var isFunction=function isFunction(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"&&typeof obj.item!=="function";};var isWindow=function isWindow(obj){return obj!=null&&obj===obj.window;};var document=window.document;var preservedScriptAttributes={type:true,src:true,nonce:true,noModule:true};function DOMEval(code,node,doc){doc=doc||document;var i,val,script=doc.createElement("script");script.text=code;if(node){for(i in preservedScriptAttributes){val=node[i]||node.getAttribute&&node.getAttribute(i);if(val){script.setAttribute(i,val);}}}
doc.head.appendChild(script).parentNode.removeChild(script);}
function toType(obj){if(obj==null){return obj+"";}
return typeof obj==="object"||typeof obj==="function"?class2type[toString.call(obj)]||"object":typeof obj;}
var
version="3.6.0",jQuery=function(selector,context){return new jQuery.fn.init(selector,context);};jQuery.fn=jQuery.prototype={jquery:version,constructor:jQuery,length:0,toArray:function(){return slice.call(this);},get:function(num){if(num==null){return slice.call(this);}
return num<0?this[num+this.length]:this[num];},pushStack:function(elems){var ret=jQuery.merge(this.constructor(),elems);ret.prevObject=this;return ret;},each:function(callback){return jQuery.each(this,callback);},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem);}));},slice:function(){return this.pushStack(slice.apply(this,arguments));},first:function(){return this.eq(0);},last:function(){return this.eq(-1);},even:function(){return this.pushStack(jQuery.grep(this,function(_elem,i){return(i+1)%2;}));},odd:function(){return this.pushStack(jQuery.grep(this,function(_elem,i){return i%2;}));},eq:function(i){var len=this.length,j=+i+(i<0?len:0);return this.pushStack(j>=0&&j<len?[this[j]]:[]);},end:function(){return this.prevObject||this.constructor();},push:push,sort:arr.sort,splice:arr.splice};jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=false;if(typeof target==="boolean"){deep=target;target=arguments[i]||{};i++;}
if(typeof target!=="object"&&!isFunction(target)){target={};}
if(i===length){target=this;i--;}
for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){copy=options[name];if(name==="__proto__"||target===copy){continue;}
if(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=Array.isArray(copy)))){src=target[name];if(copyIsArray&&!Array.isArray(src)){clone=[];}else if(!copyIsArray&&!jQuery.isPlainObject(src)){clone={};}else{clone=src;}
copyIsArray=false;target[name]=jQuery.extend(deep,clone,copy);}else if(copy!==undefined){target[name]=copy;}}}}
return target;};jQuery.extend({expando:"jQuery"+(version+Math.random()).replace(/\D/g,""),isReady:true,error:function(msg){throw new Error(msg);},noop:function(){},isPlainObject:function(obj){var proto,Ctor;if(!obj||toString.call(obj)!=="[object Object]"){return false;}
proto=getProto(obj);if(!proto){return true;}
Ctor=hasOwn.call(proto,"constructor")&&proto.constructor;return typeof Ctor==="function"&&fnToString.call(Ctor)===ObjectFunctionString;},isEmptyObject:function(obj){var name;for(name in obj){return false;}
return true;},globalEval:function(code,options,doc){DOMEval(code,{nonce:options&&options.nonce},doc);},each:function(obj,callback){var length,i=0;if(isArrayLike(obj)){length=obj.length;for(;i<length;i++){if(callback.call(obj[i],i,obj[i])===false){break;}}}else{for(i in obj){if(callback.call(obj[i],i,obj[i])===false){break;}}}
return obj;},makeArray:function(arr,results){var ret=results||[];if(arr!=null){if(isArrayLike(Object(arr))){jQuery.merge(ret,typeof arr==="string"?[arr]:arr);}else{push.call(ret,arr);}}
return ret;},inArray:function(elem,arr,i){return arr==null?-1:indexOf.call(arr,elem,i);},merge:function(first,second){var len=+second.length,j=0,i=first.length;for(;j<len;j++){first[i++]=second[j];}
first.length=i;return first;},grep:function(elems,callback,invert){var callbackInverse,matches=[],i=0,length=elems.length,callbackExpect=!invert;for(;i<length;i++){callbackInverse=!callback(elems[i],i);if(callbackInverse!==callbackExpect){matches.push(elems[i]);}}
return matches;},map:function(elems,callback,arg){var length,value,i=0,ret=[];if(isArrayLike(elems)){length=elems.length;for(;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret.push(value);}}
}else{for(i in elems){value=callback(elems[i],i,arg);if(value!=null){ret.push(value);}}}
return flat(ret);},guid:1,support:support});if(typeof Symbol==="function"){jQuery.fn[Symbol.iterator]=arr[Symbol.iterator];}
jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(_i,name){class2type["[object "+name+"]"]=name.toLowerCase();});function isArrayLike(obj){var length=!!obj&&"length"in obj&&obj.length,type=toType(obj);if(isFunction(obj)||isWindow(obj)){return false;}
return type==="array"||length===0||typeof length==="number"&&length>0&&(length-1)in obj;}
var Sizzle=/*!
 * Sizzle CSS Selector Engine v2.3.6
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2021-02-16
 */
(function(window){var i,support,Expr,getText,isXML,tokenize,compile,select,outermostContext,sortInput,hasDuplicate,setDocument,document,docElem,documentIsHTML,rbuggyQSA,rbuggyMatches,matches,contains,expando="sizzle"+1*new Date(),preferredDoc=window.document,dirruns=0,done=0,classCache=createCache(),tokenCache=createCache(),compilerCache=createCache(),nonnativeSelectorCache=createCache(),sortOrder=function(a,b){if(a===b){hasDuplicate=true;}
return 0;},hasOwn=({}).hasOwnProperty,arr=[],pop=arr.pop,pushNative=arr.push,push=arr.push,slice=arr.slice,indexOf=function(list,elem){var i=0,len=list.length;for(;i<len;i++){if(list[i]===elem){return i;}}
return-1;},booleans="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|"+
"ismap|loop|multiple|open|readonly|required|scoped",whitespace="[\\x20\\t\\r\\n\\f]",identifier="(?:\\\\[\\da-fA-F]{1,6}"+whitespace+
"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",attributes="\\["+whitespace+"*("+identifier+")(?:"+whitespace+
"*([*^$|!~]?=)"+whitespace+
"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+identifier+"))|)"+
whitespace+"*\\]",pseudos=":("+identifier+")(?:\\(("+
"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|"+
"((?:\\\\.|[^\\\\()[\\]]|"+attributes+")*)|"+
".*"+
")\\)|)",rwhitespace=new RegExp(whitespace+"+","g"),rtrim=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+
whitespace+"+$","g"),rcomma=new RegExp("^"+whitespace+"*,"+whitespace+"*"),rcombinators=new RegExp("^"+whitespace+"*([>+~]|"+whitespace+")"+whitespace+
"*"),rdescend=new RegExp(whitespace+"|>"),rpseudo=new RegExp(pseudos),ridentifier=new RegExp("^"+identifier+"$"),matchExpr={"ID":new RegExp("^#("+identifier+")"),"CLASS":new RegExp("^\\.("+identifier+")"),"TAG":new RegExp("^("+identifier+"|[*])"),"ATTR":new RegExp("^"+attributes),"PSEUDO":new RegExp("^"+pseudos),"CHILD":new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+
whitespace+"*(even|odd|(([+-]|)(\\d*)n|)"+whitespace+"*(?:([+-]|)"+
whitespace+"*(\\d+)|))"+whitespace+"*\\)|)","i"),"bool":new RegExp("^(?:"+booleans+")$","i"),"needsContext":new RegExp("^"+whitespace+
"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+whitespace+
"*((?:-\\d)?\\d*)"+whitespace+"*\\)|)(?=[^-]|$)","i")},rhtml=/HTML$/i,rinputs=/^(?:input|select|textarea|button)$/i,rheader=/^h\d$/i,rnative=/^[^{]+\{\s*\[native \w/,rquickExpr=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,rsibling=/[+~]/,runescape=new RegExp("\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\([^\\r\\n\\f])","g"),funescape=function(escape,nonHex){var high="0x"+escape.slice(1)-0x10000;return nonHex?nonHex:high<0?String.fromCharCode(high+0x10000):String.fromCharCode(high>>10|0xD800,high&0x3FF|0xDC00);},rcssescape=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,fcssescape=function(ch,asCodePoint){if(asCodePoint){if(ch==="\0"){return"\uFFFD";}
return ch.slice(0,-1)+"\\"+
ch.charCodeAt(ch.length-1).toString(16)+" ";}
return"\\"+ch;},unloadHandler=function(){setDocument();},inDisabledFieldset=addCombinator(function(elem){return elem.disabled===true&&elem.nodeName.toLowerCase()==="fieldset";},{dir:"parentNode",next:"legend"});try{push.apply((arr=slice.call(preferredDoc.childNodes)),preferredDoc.childNodes);arr[preferredDoc.childNodes.length].nodeType;}catch(e){push={apply:arr.length?function(target,els){pushNative.apply(target,slice.call(els));}:function(target,els){var j=target.length,i=0;while((target[j++]=els[i++])){}
target.length=j-1;}};}
function Sizzle(selector,context,results,seed){var m,i,elem,nid,match,groups,newSelector,newContext=context&&context.ownerDocument,nodeType=context?context.nodeType:9;results=results||[];if(typeof selector!=="string"||!selector||nodeType!==1&&nodeType!==9&&nodeType!==11){return results;}
if(!seed){setDocument(context);context=context||document;if(documentIsHTML){if(nodeType!==11&&(match=rquickExpr.exec(selector))){if((m=match[1])){if(nodeType===9){if((elem=context.getElementById(m))){if(elem.id===m){results.push(elem);return results;}}else{return results;}
}else{if(newContext&&(elem=newContext.getElementById(m))&&contains(context,elem)&&elem.id===m){results.push(elem);return results;}}
}else if(match[2]){push.apply(results,context.getElementsByTagName(selector));return results;}else if((m=match[3])&&support.getElementsByClassName&&context.getElementsByClassName){push.apply(results,context.getElementsByClassName(m));return results;}}
if(support.qsa&&!nonnativeSelectorCache[selector+" "]&&(!rbuggyQSA||!rbuggyQSA.test(selector))&&(nodeType!==1||context.nodeName.toLowerCase()!=="object")){newSelector=selector;newContext=context;if(nodeType===1&&(rdescend.test(selector)||rcombinators.test(selector))){newContext=rsibling.test(selector)&&testContext(context.parentNode)||context;if(newContext!==context||!support.scope){if((nid=context.getAttribute("id"))){nid=nid.replace(rcssescape,fcssescape);}else{context.setAttribute("id",(nid=expando));}}
groups=tokenize(selector);i=groups.length;while(i--){groups[i]=(nid?"#"+nid:":scope")+" "+
toSelector(groups[i]);}
newSelector=groups.join(",");}
try{push.apply(results,newContext.querySelectorAll(newSelector));return results;}catch(qsaError){nonnativeSelectorCache(selector,true);}finally{if(nid===expando){context.removeAttribute("id");}}}}}
return select(selector.replace(rtrim,"$1"),context,results,seed);}
function createCache(){var keys=[];function cache(key,value){if(keys.push(key+" ")>Expr.cacheLength){delete cache[keys.shift()];}
return(cache[key+" "]=value);}
return cache;}
function markFunction(fn){fn[expando]=true;return fn;}
function assert(fn){var el=document.createElement("fieldset");try{return!!fn(el);}catch(e){return false;}finally{if(el.parentNode){el.parentNode.removeChild(el);}
el=null;}}
function addHandle(attrs,handler){var arr=attrs.split("|"),i=arr.length;while(i--){Expr.attrHandle[arr[i]]=handler;}}
function siblingCheck(a,b){var cur=b&&a,diff=cur&&a.nodeType===1&&b.nodeType===1&&a.sourceIndex-b.sourceIndex;if(diff){return diff;}
if(cur){while((cur=cur.nextSibling)){if(cur===b){return-1;}}}
return a?1:-1;}
function createInputPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return name==="input"&&elem.type===type;};}
function createButtonPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return(name==="input"||name==="button")&&elem.type===type;};}
function createDisabledPseudo(disabled){return function(elem){if("form"in elem){if(elem.parentNode&&elem.disabled===false){if("label"in elem){if("label"in elem.parentNode){return elem.parentNode.disabled===disabled;}else{return elem.disabled===disabled;}}
return elem.isDisabled===disabled||elem.isDisabled!==!disabled&&inDisabledFieldset(elem)===disabled;}
return elem.disabled===disabled;}else if("label"in elem){return elem.disabled===disabled;}
return false;};}
function createPositionalPseudo(fn){return markFunction(function(argument){argument=+argument;return markFunction(function(seed,matches){var j,matchIndexes=fn([],seed.length,argument),i=matchIndexes.length;while(i--){if(seed[(j=matchIndexes[i])]){seed[j]=!(matches[j]=seed[j]);}}});});}
function testContext(context){return context&&typeof context.getElementsByTagName!=="undefined"&&context;}
support=Sizzle.support={};isXML=Sizzle.isXML=function(elem){var namespace=elem&&elem.namespaceURI,docElem=elem&&(elem.ownerDocument||elem).documentElement;return!rhtml.test(namespace||docElem&&docElem.nodeName||"HTML");};setDocument=Sizzle.setDocument=function(node){var hasCompare,subWindow,doc=node?node.ownerDocument||node:preferredDoc;if(doc==document||doc.nodeType!==9||!doc.documentElement){return document;}
document=doc;docElem=document.documentElement;documentIsHTML=!isXML(document);if(preferredDoc!=document&&(subWindow=document.defaultView)&&subWindow.top!==subWindow){if(subWindow.addEventListener){subWindow.addEventListener("unload",unloadHandler,false);}else if(subWindow.attachEvent){subWindow.attachEvent("onunload",unloadHandler);}}
support.scope=assert(function(el){docElem.appendChild(el).appendChild(document.createElement("div"));return typeof el.querySelectorAll!=="undefined"&&!el.querySelectorAll(":scope fieldset div").length;});support.attributes=assert(function(el){el.className="i";return!el.getAttribute("className");});support.getElementsByTagName=assert(function(el){el.appendChild(document.createComment(""));return!el.getElementsByTagName("*").length;});support.getElementsByClassName=rnative.test(document.getElementsByClassName);support.getById=assert(function(el){docElem.appendChild(el).id=expando;return!document.getElementsByName||!document.getElementsByName(expando).length;});if(support.getById){Expr.filter["ID"]=function(id){var attrId=id.replace(runescape,funescape);return function(elem){return elem.getAttribute("id")===attrId;};};Expr.find["ID"]=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var elem=context.getElementById(id);return elem?[elem]:[];}};}else{Expr.filter["ID"]=function(id){var attrId=id.replace(runescape,funescape);return function(elem){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return node&&node.value===attrId;};};Expr.find["ID"]=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var node,i,elems,elem=context.getElementById(id);if(elem){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem];}
elems=context.getElementsByName(id);i=0;while((elem=elems[i++])){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem];}}}
return[];}};}
Expr.find["TAG"]=support.getElementsByTagName?function(tag,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(tag);}else if(support.qsa){return context.querySelectorAll(tag);}}:function(tag,context){var elem,tmp=[],i=0,results=context.getElementsByTagName(tag);if(tag==="*"){while((elem=results[i++])){if(elem.nodeType===1){tmp.push(elem);}}
return tmp;}
return results;};Expr.find["CLASS"]=support.getElementsByClassName&&function(className,context){if(typeof context.getElementsByClassName!=="undefined"&&documentIsHTML){return context.getElementsByClassName(className);}};rbuggyMatches=[];rbuggyQSA=[];if((support.qsa=rnative.test(document.querySelectorAll))){assert(function(el){var input;docElem.appendChild(el).innerHTML="<a id='"+expando+"'></a>"+
"<select id='"+expando+"-\r\\' msallowcapture=''>"+
"<option selected=''></option></select>";if(el.querySelectorAll("[msallowcapture^='']").length){rbuggyQSA.push("[*^$]="+whitespace+"*(?:''|\"\")");}
if(!el.querySelectorAll("[selected]").length){rbuggyQSA.push("\\["+whitespace+"*(?:value|"+booleans+")");}
if(!el.querySelectorAll("[id~="+expando+"-]").length){rbuggyQSA.push("~=");}
input=document.createElement("input");input.setAttribute("name","");el.appendChild(input);if(!el.querySelectorAll("[name='']").length){rbuggyQSA.push("\\["+whitespace+"*name"+whitespace+"*="+
whitespace+"*(?:''|\"\")");}
if(!el.querySelectorAll(":checked").length){rbuggyQSA.push(":checked");}
if(!el.querySelectorAll("a#"+expando+"+*").length){rbuggyQSA.push(".#.+[+~]");}
el.querySelectorAll("\\\f");rbuggyQSA.push("[\\r\\n\\f]");});assert(function(el){el.innerHTML="<a href='' disabled='disabled'></a>"+
"<select disabled='disabled'><option/></select>";var input=document.createElement("input");input.setAttribute("type","hidden");el.appendChild(input).setAttribute("name","D");if(el.querySelectorAll("[name=d]").length){rbuggyQSA.push("name"+whitespace+"*[*^$|!~]?=");}
if(el.querySelectorAll(":enabled").length!==2){rbuggyQSA.push(":enabled",":disabled");}
docElem.appendChild(el).disabled=true;if(el.querySelectorAll(":disabled").length!==2){rbuggyQSA.push(":enabled",":disabled");}
el.querySelectorAll("*,:x");rbuggyQSA.push(",.*:");});}
if((support.matchesSelector=rnative.test((matches=docElem.matches||docElem.webkitMatchesSelector||docElem.mozMatchesSelector||docElem.oMatchesSelector||docElem.msMatchesSelector)))){assert(function(el){support.disconnectedMatch=matches.call(el,"*");matches.call(el,"[s!='']:x");rbuggyMatches.push("!=",pseudos);});}
rbuggyQSA=rbuggyQSA.length&&new RegExp(rbuggyQSA.join("|"));rbuggyMatches=rbuggyMatches.length&&new RegExp(rbuggyMatches.join("|"));hasCompare=rnative.test(docElem.compareDocumentPosition);contains=hasCompare||rnative.test(docElem.contains)?function(a,b){var adown=a.nodeType===9?a.documentElement:a,bup=b&&b.parentNode;return a===bup||!!(bup&&bup.nodeType===1&&(adown.contains?adown.contains(bup):a.compareDocumentPosition&&a.compareDocumentPosition(bup)&16));}:function(a,b){if(b){while((b=b.parentNode)){if(b===a){return true;}}}
return false;};sortOrder=hasCompare?function(a,b){if(a===b){hasDuplicate=true;return 0;}
var compare=!a.compareDocumentPosition-!b.compareDocumentPosition;if(compare){return compare;}
compare=(a.ownerDocument||a)==(b.ownerDocument||b)?a.compareDocumentPosition(b):1;if(compare&1||(!support.sortDetached&&b.compareDocumentPosition(a)===compare)){if(a==document||a.ownerDocument==preferredDoc&&contains(preferredDoc,a)){return-1;}
if(b==document||b.ownerDocument==preferredDoc&&contains(preferredDoc,b)){return 1;}
return sortInput?(indexOf(sortInput,a)-indexOf(sortInput,b)):0;}
return compare&4?-1:1;}:function(a,b){if(a===b){hasDuplicate=true;return 0;}
var cur,i=0,aup=a.parentNode,bup=b.parentNode,ap=[a],bp=[b];if(!aup||!bup){return a==document?-1:b==document?1:aup?-1:bup?1:sortInput?(indexOf(sortInput,a)-indexOf(sortInput,b)):0;}else if(aup===bup){return siblingCheck(a,b);}
cur=a;while((cur=cur.parentNode)){ap.unshift(cur);}
cur=b;while((cur=cur.parentNode)){bp.unshift(cur);}
while(ap[i]===bp[i]){i++;}
return i?siblingCheck(ap[i],bp[i]):ap[i]==preferredDoc?-1:bp[i]==preferredDoc?1:0;};return document;};Sizzle.matches=function(expr,elements){return Sizzle(expr,null,null,elements);};Sizzle.matchesSelector=function(elem,expr){setDocument(elem);if(support.matchesSelector&&documentIsHTML&&!nonnativeSelectorCache[expr+" "]&&(!rbuggyMatches||!rbuggyMatches.test(expr))&&(!rbuggyQSA||!rbuggyQSA.test(expr))){try{var ret=matches.call(elem,expr);if(ret||support.disconnectedMatch||elem.document&&elem.document.nodeType!==11){return ret;}}catch(e){nonnativeSelectorCache(expr,true);}}
return Sizzle(expr,document,null,[elem]).length>0;};Sizzle.contains=function(context,elem){if((context.ownerDocument||context)!=document){setDocument(context);}
return contains(context,elem);};Sizzle.attr=function(elem,name){if((elem.ownerDocument||elem)!=document){setDocument(elem);}
var fn=Expr.attrHandle[name.toLowerCase()],val=fn&&hasOwn.call(Expr.attrHandle,name.toLowerCase())?fn(elem,name,!documentIsHTML):undefined;return val!==undefined?val:support.attributes||!documentIsHTML?elem.getAttribute(name):(val=elem.getAttributeNode(name))&&val.specified?val.value:null;};Sizzle.escape=function(sel){return(sel+"").replace(rcssescape,fcssescape);};Sizzle.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg);};Sizzle.uniqueSort=function(results){var elem,duplicates=[],j=0,i=0;hasDuplicate=!support.detectDuplicates;sortInput=!support.sortStable&&results.slice(0);results.sort(sortOrder);if(hasDuplicate){while((elem=results[i++])){if(elem===results[i]){j=duplicates.push(i);}}
while(j--){results.splice(duplicates[j],1);}}
sortInput=null;return results;};getText=Sizzle.getText=function(elem){var node,ret="",i=0,nodeType=elem.nodeType;if(!nodeType){while((node=elem[i++])){ret+=getText(node);}}else if(nodeType===1||nodeType===9||nodeType===11){if(typeof elem.textContent==="string"){return elem.textContent;}else{for(elem=elem.firstChild;elem;elem=elem.nextSibling){ret+=getText(elem);}}}else if(nodeType===3||nodeType===4){return elem.nodeValue;}
return ret;};Expr=Sizzle.selectors={cacheLength:50,createPseudo:markFunction,match:matchExpr,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:true}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:true},"~":{dir:"previousSibling"}},preFilter:{"ATTR":function(match){match[1]=match[1].replace(runescape,funescape);match[3]=(match[3]||match[4]||match[5]||"").replace(runescape,funescape);if(match[2]==="~="){match[3]=" "+match[3]+" ";}
return match.slice(0,4);},"CHILD":function(match){match[1]=match[1].toLowerCase();if(match[1].slice(0,3)==="nth"){if(!match[3]){Sizzle.error(match[0]);}
match[4]=+(match[4]?match[5]+(match[6]||1):2*(match[3]==="even"||match[3]==="odd"));match[5]=+((match[7]+match[8])||match[3]==="odd");}else if(match[3]){Sizzle.error(match[0]);}
return match;},"PSEUDO":function(match){var excess,unquoted=!match[6]&&match[2];if(matchExpr["CHILD"].test(match[0])){return null;}
if(match[3]){match[2]=match[4]||match[5]||"";}else if(unquoted&&rpseudo.test(unquoted)&&(excess=tokenize(unquoted,true))&&(excess=unquoted.indexOf(")",unquoted.length-excess)-unquoted.length)){match[0]=match[0].slice(0,excess);match[2]=unquoted.slice(0,excess);}
return match.slice(0,3);}},filter:{"TAG":function(nodeNameSelector){var nodeName=nodeNameSelector.replace(runescape,funescape).toLowerCase();return nodeNameSelector==="*"?function(){return true;}:function(elem){return elem.nodeName&&elem.nodeName.toLowerCase()===nodeName;};},"CLASS":function(className){var pattern=classCache[className+" "];return pattern||(pattern=new RegExp("(^|"+whitespace+
")"+className+"("+whitespace+"|$)"))&&classCache(className,function(elem){return pattern.test(typeof elem.className==="string"&&elem.className||typeof elem.getAttribute!=="undefined"&&elem.getAttribute("class")||"");});},"ATTR":function(name,operator,check){return function(elem){var result=Sizzle.attr(elem,name);if(result==null){return operator==="!=";}
if(!operator){return true;}
result+="";return operator==="="?result===check:operator==="!="?result!==check:operator==="^="?check&&result.indexOf(check)===0:operator==="*="?check&&result.indexOf(check)>-1:operator==="$="?check&&result.slice(-check.length)===check:operator==="~="?(" "+result.replace(rwhitespace," ")+" ").indexOf(check)>-1:operator==="|="?result===check||result.slice(0,check.length+1)===check+"-":false;};},"CHILD":function(type,what,_argument,first,last){var simple=type.slice(0,3)!=="nth",forward=type.slice(-4)!=="last",ofType=what==="of-type";return first===1&&last===0?function(elem){return!!elem.parentNode;}:function(elem,_context,xml){var cache,uniqueCache,outerCache,node,nodeIndex,start,dir=simple!==forward?"nextSibling":"previousSibling",parent=elem.parentNode,name=ofType&&elem.nodeName.toLowerCase(),useCache=!xml&&!ofType,diff=false;if(parent){if(simple){while(dir){node=elem;while((node=node[dir])){if(ofType?node.nodeName.toLowerCase()===name:node.nodeType===1){return false;}}
start=dir=type==="only"&&!start&&"nextSibling";}
return true;}
start=[forward?parent.firstChild:parent.lastChild];if(forward&&useCache){node=parent;outerCache=node[expando]||(node[expando]={});uniqueCache=outerCache[node.uniqueID]||(outerCache[node.uniqueID]={});cache=uniqueCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex&&cache[2];node=nodeIndex&&parent.childNodes[nodeIndex];while((node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())){if(node.nodeType===1&&++diff&&node===elem){uniqueCache[type]=[dirruns,nodeIndex,diff];break;}}}else{if(useCache){node=elem;outerCache=node[expando]||(node[expando]={});uniqueCache=outerCache[node.uniqueID]||(outerCache[node.uniqueID]={});cache=uniqueCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex;}
if(diff===false){while((node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())){if((ofType?node.nodeName.toLowerCase()===name:node.nodeType===1)&&++diff){if(useCache){outerCache=node[expando]||(node[expando]={});uniqueCache=outerCache[node.uniqueID]||(outerCache[node.uniqueID]={});uniqueCache[type]=[dirruns,diff];}
if(node===elem){break;}}}}}
diff-=last;return diff===first||(diff%first===0&&diff/first>=0);}};},"PSEUDO":function(pseudo,argument){var args,fn=Expr.pseudos[pseudo]||Expr.setFilters[pseudo.toLowerCase()]||Sizzle.error("unsupported pseudo: "+pseudo);if(fn[expando]){return fn(argument);}
if(fn.length>1){args=[pseudo,pseudo,"",argument];return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase())?markFunction(function(seed,matches){var idx,matched=fn(seed,argument),i=matched.length;while(i--){idx=indexOf(seed,matched[i]);seed[idx]=!(matches[idx]=matched[i]);}}):function(elem){return fn(elem,0,args);};}
return fn;}},pseudos:{"not":markFunction(function(selector){var input=[],results=[],matcher=compile(selector.replace(rtrim,"$1"));return matcher[expando]?markFunction(function(seed,matches,_context,xml){var elem,unmatched=matcher(seed,null,xml,[]),i=seed.length;while(i--){if((elem=unmatched[i])){seed[i]=!(matches[i]=elem);}}}):function(elem,_context,xml){input[0]=elem;matcher(input,null,xml,results);input[0]=null;return!results.pop();};}),"has":markFunction(function(selector){return function(elem){return Sizzle(selector,elem).length>0;};}),"contains":markFunction(function(text){text=text.replace(runescape,funescape);return function(elem){return(elem.textContent||getText(elem)).indexOf(text)>-1;};}),"lang":markFunction(function(lang){if(!ridentifier.test(lang||"")){Sizzle.error("unsupported lang: "+lang);}
lang=lang.replace(runescape,funescape).toLowerCase();return function(elem){var elemLang;do{if((elemLang=documentIsHTML?elem.lang:elem.getAttribute("xml:lang")||elem.getAttribute("lang"))){elemLang=elemLang.toLowerCase();return elemLang===lang||elemLang.indexOf(lang+"-")===0;}}while((elem=elem.parentNode)&&elem.nodeType===1);return false;};}),"target":function(elem){var hash=window.location&&window.location.hash;return hash&&hash.slice(1)===elem.id;},"root":function(elem){return elem===docElem;},"focus":function(elem){return elem===document.activeElement&&(!document.hasFocus||document.hasFocus())&&!!(elem.type||elem.href||~elem.tabIndex);},"enabled":createDisabledPseudo(false),"disabled":createDisabledPseudo(true),"checked":function(elem){var nodeName=elem.nodeName.toLowerCase();return(nodeName==="input"&&!!elem.checked)||(nodeName==="option"&&!!elem.selected);},"selected":function(elem){if(elem.parentNode){elem.parentNode.selectedIndex;}
return elem.selected===true;},"empty":function(elem){for(elem=elem.firstChild;elem;elem=elem.nextSibling){if(elem.nodeType<6){return false;}}
return true;},"parent":function(elem){return!Expr.pseudos["empty"](elem);},"header":function(elem){return rheader.test(elem.nodeName);},"input":function(elem){return rinputs.test(elem.nodeName);},"button":function(elem){var name=elem.nodeName.toLowerCase();return name==="input"&&elem.type==="button"||name==="button";},"text":function(elem){var attr;return elem.nodeName.toLowerCase()==="input"&&elem.type==="text"&&((attr=elem.getAttribute("type"))==null||attr.toLowerCase()==="text");},"first":createPositionalPseudo(function(){return[0];}),"last":createPositionalPseudo(function(_matchIndexes,length){return[length-1];}),"eq":createPositionalPseudo(function(_matchIndexes,length,argument){return[argument<0?argument+length:argument];}),"even":createPositionalPseudo(function(matchIndexes,length){var i=0;for(;i<length;i+=2){matchIndexes.push(i);}
return matchIndexes;}),"odd":createPositionalPseudo(function(matchIndexes,length){var i=1;for(;i<length;i+=2){matchIndexes.push(i);}
return matchIndexes;}),"lt":createPositionalPseudo(function(matchIndexes,length,argument){var i=argument<0?argument+length:argument>length?length:argument;for(;--i>=0;){matchIndexes.push(i);}
return matchIndexes;}),"gt":createPositionalPseudo(function(matchIndexes,length,argument){var i=argument<0?argument+length:argument;for(;++i<length;){matchIndexes.push(i);}
return matchIndexes;})}};Expr.pseudos["nth"]=Expr.pseudos["eq"];for(i in{radio:true,checkbox:true,file:true,password:true,image:true}){Expr.pseudos[i]=createInputPseudo(i);}
for(i in{submit:true,reset:true}){Expr.pseudos[i]=createButtonPseudo(i);}
function setFilters(){}
setFilters.prototype=Expr.filters=Expr.pseudos;Expr.setFilters=new setFilters();tokenize=Sizzle.tokenize=function(selector,parseOnly){var matched,match,tokens,type,soFar,groups,preFilters,cached=tokenCache[selector+" "];if(cached){return parseOnly?0:cached.slice(0);}
soFar=selector;groups=[];preFilters=Expr.preFilter;while(soFar){if(!matched||(match=rcomma.exec(soFar))){if(match){soFar=soFar.slice(match[0].length)||soFar;}
groups.push((tokens=[]));}
matched=false;if((match=rcombinators.exec(soFar))){matched=match.shift();tokens.push({value:matched,type:match[0].replace(rtrim," ")});soFar=soFar.slice(matched.length);}
for(type in Expr.filter){if((match=matchExpr[type].exec(soFar))&&(!preFilters[type]||(match=preFilters[type](match)))){matched=match.shift();tokens.push({value:matched,type:type,matches:match});soFar=soFar.slice(matched.length);}}
if(!matched){break;}}
return parseOnly?soFar.length:soFar?Sizzle.error(selector):tokenCache(selector,groups).slice(0);};function toSelector(tokens){var i=0,len=tokens.length,selector="";for(;i<len;i++){selector+=tokens[i].value;}
return selector;}
function addCombinator(matcher,combinator,base){var dir=combinator.dir,skip=combinator.next,key=skip||dir,checkNonElements=base&&key==="parentNode",doneName=done++;return combinator.first?function(elem,context,xml){while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){return matcher(elem,context,xml);}}
return false;}:function(elem,context,xml){var oldCache,uniqueCache,outerCache,newCache=[dirruns,doneName];if(xml){while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){if(matcher(elem,context,xml)){return true;}}}}else{while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){outerCache=elem[expando]||(elem[expando]={});uniqueCache=outerCache[elem.uniqueID]||(outerCache[elem.uniqueID]={});if(skip&&skip===elem.nodeName.toLowerCase()){elem=elem[dir]||elem;}else if((oldCache=uniqueCache[key])&&oldCache[0]===dirruns&&oldCache[1]===doneName){return(newCache[2]=oldCache[2]);}else{uniqueCache[key]=newCache;if((newCache[2]=matcher(elem,context,xml))){return true;}}}}}
return false;};}
function elementMatcher(matchers){return matchers.length>1?function(elem,context,xml){var i=matchers.length;while(i--){if(!matchers[i](elem,context,xml)){return false;}}
return true;}:matchers[0];}
function multipleContexts(selector,contexts,results){var i=0,len=contexts.length;for(;i<len;i++){Sizzle(selector,contexts[i],results);}
return results;}
function condense(unmatched,map,filter,context,xml){var elem,newUnmatched=[],i=0,len=unmatched.length,mapped=map!=null;for(;i<len;i++){if((elem=unmatched[i])){if(!filter||filter(elem,context,xml)){newUnmatched.push(elem);if(mapped){map.push(i);}}}}
return newUnmatched;}
function setMatcher(preFilter,selector,matcher,postFilter,postFinder,postSelector){if(postFilter&&!postFilter[expando]){postFilter=setMatcher(postFilter);}
if(postFinder&&!postFinder[expando]){postFinder=setMatcher(postFinder,postSelector);}
return markFunction(function(seed,results,context,xml){var temp,i,elem,preMap=[],postMap=[],preexisting=results.length,elems=seed||multipleContexts(selector||"*",context.nodeType?[context]:context,[]),matcherIn=preFilter&&(seed||!selector)?condense(elems,preMap,preFilter,context,xml):elems,matcherOut=matcher?postFinder||(seed?preFilter:preexisting||postFilter)?[]:results:matcherIn;if(matcher){matcher(matcherIn,matcherOut,context,xml);}
if(postFilter){temp=condense(matcherOut,postMap);postFilter(temp,[],context,xml);i=temp.length;while(i--){if((elem=temp[i])){matcherOut[postMap[i]]=!(matcherIn[postMap[i]]=elem);}}}
if(seed){if(postFinder||preFilter){if(postFinder){temp=[];i=matcherOut.length;while(i--){if((elem=matcherOut[i])){temp.push((matcherIn[i]=elem));}}
postFinder(null,(matcherOut=[]),temp,xml);}
i=matcherOut.length;while(i--){if((elem=matcherOut[i])&&(temp=postFinder?indexOf(seed,elem):preMap[i])>-1){seed[temp]=!(results[temp]=elem);}}}
}else{matcherOut=condense(matcherOut===results?matcherOut.splice(preexisting,matcherOut.length):matcherOut);if(postFinder){postFinder(null,results,matcherOut,xml);}else{push.apply(results,matcherOut);}}});}
function matcherFromTokens(tokens){var checkContext,matcher,j,len=tokens.length,leadingRelative=Expr.relative[tokens[0].type],implicitRelative=leadingRelative||Expr.relative[" "],i=leadingRelative?1:0,matchContext=addCombinator(function(elem){return elem===checkContext;},implicitRelative,true),matchAnyContext=addCombinator(function(elem){return indexOf(checkContext,elem)>-1;},implicitRelative,true),matchers=[function(elem,context,xml){var ret=(!leadingRelative&&(xml||context!==outermostContext))||((checkContext=context).nodeType?matchContext(elem,context,xml):matchAnyContext(elem,context,xml));checkContext=null;return ret;}];for(;i<len;i++){if((matcher=Expr.relative[tokens[i].type])){matchers=[addCombinator(elementMatcher(matchers),matcher)];}else{matcher=Expr.filter[tokens[i].type].apply(null,tokens[i].matches);if(matcher[expando]){j=++i;for(;j<len;j++){if(Expr.relative[tokens[j].type]){break;}}
return setMatcher(i>1&&elementMatcher(matchers),i>1&&toSelector(tokens.slice(0,i-1).concat({value:tokens[i-2].type===" "?"*":""})).replace(rtrim,"$1"),matcher,i<j&&matcherFromTokens(tokens.slice(i,j)),j<len&&matcherFromTokens((tokens=tokens.slice(j))),j<len&&toSelector(tokens));}
matchers.push(matcher);}}
return elementMatcher(matchers);}
function matcherFromGroupMatchers(elementMatchers,setMatchers){var bySet=setMatchers.length>0,byElement=elementMatchers.length>0,superMatcher=function(seed,context,xml,results,outermost){var elem,j,matcher,matchedCount=0,i="0",unmatched=seed&&[],setMatched=[],contextBackup=outermostContext,elems=seed||byElement&&Expr.find["TAG"]("*",outermost),dirrunsUnique=(dirruns+=contextBackup==null?1:Math.random()||0.1),len=elems.length;if(outermost){outermostContext=context==document||context||outermost;}
for(;i!==len&&(elem=elems[i])!=null;i++){if(byElement&&elem){j=0;if(!context&&elem.ownerDocument!=document){setDocument(elem);xml=!documentIsHTML;}
while((matcher=elementMatchers[j++])){if(matcher(elem,context||document,xml)){results.push(elem);break;}}
if(outermost){dirruns=dirrunsUnique;}}
if(bySet){if((elem=!matcher&&elem)){matchedCount--;}
if(seed){unmatched.push(elem);}}}
matchedCount+=i;if(bySet&&i!==matchedCount){j=0;while((matcher=setMatchers[j++])){matcher(unmatched,setMatched,context,xml);}
if(seed){if(matchedCount>0){while(i--){if(!(unmatched[i]||setMatched[i])){setMatched[i]=pop.call(results);}}}
setMatched=condense(setMatched);}
push.apply(results,setMatched);if(outermost&&!seed&&setMatched.length>0&&(matchedCount+setMatchers.length)>1){Sizzle.uniqueSort(results);}}
if(outermost){dirruns=dirrunsUnique;outermostContext=contextBackup;}
return unmatched;};return bySet?markFunction(superMatcher):superMatcher;}
compile=Sizzle.compile=function(selector,match ){var i,setMatchers=[],elementMatchers=[],cached=compilerCache[selector+" "];if(!cached){if(!match){match=tokenize(selector);}
i=match.length;while(i--){cached=matcherFromTokens(match[i]);if(cached[expando]){setMatchers.push(cached);}else{elementMatchers.push(cached);}}
cached=compilerCache(selector,matcherFromGroupMatchers(elementMatchers,setMatchers));cached.selector=selector;}
return cached;};select=Sizzle.select=function(selector,context,results,seed){var i,tokens,token,type,find,compiled=typeof selector==="function"&&selector,match=!seed&&tokenize((selector=compiled.selector||selector));results=results||[];if(match.length===1){tokens=match[0]=match[0].slice(0);if(tokens.length>2&&(token=tokens[0]).type==="ID"&&context.nodeType===9&&documentIsHTML&&Expr.relative[tokens[1].type]){context=(Expr.find["ID"](token.matches[0].replace(runescape,funescape),context)||[])[0];if(!context){return results;}else if(compiled){context=context.parentNode;}
selector=selector.slice(tokens.shift().value.length);}
i=matchExpr["needsContext"].test(selector)?0:tokens.length;while(i--){token=tokens[i];if(Expr.relative[(type=token.type)]){break;}
if((find=Expr.find[type])){if((seed=find(token.matches[0].replace(runescape,funescape),rsibling.test(tokens[0].type)&&testContext(context.parentNode)||context))){tokens.splice(i,1);selector=seed.length&&toSelector(tokens);if(!selector){push.apply(results,seed);return results;}
break;}}}}
(compiled||compile(selector,match))(seed,context,!documentIsHTML,results,!context||rsibling.test(selector)&&testContext(context.parentNode)||context);return results;};support.sortStable=expando.split("").sort(sortOrder).join("")===expando;support.detectDuplicates=!!hasDuplicate;setDocument();support.sortDetached=assert(function(el){return el.compareDocumentPosition(document.createElement("fieldset"))&1;});if(!assert(function(el){el.innerHTML="<a href='#'></a>";return el.firstChild.getAttribute("href")==="#";})){addHandle("type|href|height|width",function(elem,name,isXML){if(!isXML){return elem.getAttribute(name,name.toLowerCase()==="type"?1:2);}});}
if(!support.attributes||!assert(function(el){el.innerHTML="<input/>";el.firstChild.setAttribute("value","");return el.firstChild.getAttribute("value")==="";})){addHandle("value",function(elem,_name,isXML){if(!isXML&&elem.nodeName.toLowerCase()==="input"){return elem.defaultValue;}});}
if(!assert(function(el){return el.getAttribute("disabled")==null;})){addHandle(booleans,function(elem,name,isXML){var val;if(!isXML){return elem[name]===true?name.toLowerCase():(val=elem.getAttributeNode(name))&&val.specified?val.value:null;}});}
return Sizzle;})(window);jQuery.find=Sizzle;jQuery.expr=Sizzle.selectors;jQuery.expr[":"]=jQuery.expr.pseudos;jQuery.uniqueSort=jQuery.unique=Sizzle.uniqueSort;jQuery.text=Sizzle.getText;jQuery.isXMLDoc=Sizzle.isXML;jQuery.contains=Sizzle.contains;jQuery.escapeSelector=Sizzle.escape;var dir=function(elem,dir,until){var matched=[],truncate=until!==undefined;while((elem=elem[dir])&&elem.nodeType!==9){if(elem.nodeType===1){if(truncate&&jQuery(elem).is(until)){break;}
matched.push(elem);}}
return matched;};var siblings=function(n,elem){var matched=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){matched.push(n);}}
return matched;};var rneedsContext=jQuery.expr.match.needsContext;function nodeName(elem,name){return elem.nodeName&&elem.nodeName.toLowerCase()===name.toLowerCase();}
var rsingleTag=(/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i);function winnow(elements,qualifier,not){if(isFunction(qualifier)){return jQuery.grep(elements,function(elem,i){return!!qualifier.call(elem,i,elem)!==not;});}
if(qualifier.nodeType){return jQuery.grep(elements,function(elem){return(elem===qualifier)!==not;});}
if(typeof qualifier!=="string"){return jQuery.grep(elements,function(elem){return(indexOf.call(qualifier,elem)>-1)!==not;});}
return jQuery.filter(qualifier,elements,not);}
jQuery.filter=function(expr,elems,not){var elem=elems[0];if(not){expr=":not("+expr+")";}
if(elems.length===1&&elem.nodeType===1){return jQuery.find.matchesSelector(elem,expr)?[elem]:[];}
return jQuery.find.matches(expr,jQuery.grep(elems,function(elem){return elem.nodeType===1;}));};jQuery.fn.extend({find:function(selector){var i,ret,len=this.length,self=this;if(typeof selector!=="string"){return this.pushStack(jQuery(selector).filter(function(){for(i=0;i<len;i++){if(jQuery.contains(self[i],this)){return true;}}}));}
ret=this.pushStack([]);for(i=0;i<len;i++){jQuery.find(selector,self[i],ret);}
return len>1?jQuery.uniqueSort(ret):ret;},filter:function(selector){return this.pushStack(winnow(this,selector||[],false));},not:function(selector){return this.pushStack(winnow(this,selector||[],true));},is:function(selector){return!!winnow(this,typeof selector==="string"&&rneedsContext.test(selector)?jQuery(selector):selector||[],false).length;}});var rootjQuery,rquickExpr=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,init=jQuery.fn.init=function(selector,context,root){var match,elem;if(!selector){return this;}
root=root||rootjQuery;if(typeof selector==="string"){if(selector[0]==="<"&&selector[selector.length-1]===">"&&selector.length>=3){match=[null,selector,null];}else{match=rquickExpr.exec(selector);}
if(match&&(match[1]||!context)){if(match[1]){context=context instanceof jQuery?context[0]:context;jQuery.merge(this,jQuery.parseHTML(match[1],context&&context.nodeType?context.ownerDocument||context:document,true));if(rsingleTag.test(match[1])&&jQuery.isPlainObject(context)){for(match in context){if(isFunction(this[match])){this[match](context[match]);}else{this.attr(match,context[match]);}}}
return this;}else{elem=document.getElementById(match[2]);if(elem){this[0]=elem;this.length=1;}
return this;}
}else if(!context||context.jquery){return(context||root).find(selector);}else{return this.constructor(context).find(selector);}
}else if(selector.nodeType){this[0]=selector;this.length=1;return this;}else if(isFunction(selector)){return root.ready!==undefined?root.ready(selector):selector(jQuery);}
return jQuery.makeArray(selector,this);};init.prototype=jQuery.fn;rootjQuery=jQuery(document);var rparentsprev=/^(?:parents|prev(?:Until|All))/,guaranteedUnique={children:true,contents:true,next:true,prev:true};jQuery.fn.extend({has:function(target){var targets=jQuery(target,this),l=targets.length;return this.filter(function(){var i=0;for(;i<l;i++){if(jQuery.contains(this,targets[i])){return true;}}});},closest:function(selectors,context){var cur,i=0,l=this.length,matched=[],targets=typeof selectors!=="string"&&jQuery(selectors);if(!rneedsContext.test(selectors)){for(;i<l;i++){for(cur=this[i];cur&&cur!==context;cur=cur.parentNode){if(cur.nodeType<11&&(targets?targets.index(cur)>-1:cur.nodeType===1&&jQuery.find.matchesSelector(cur,selectors))){matched.push(cur);break;}}}}
return this.pushStack(matched.length>1?jQuery.uniqueSort(matched):matched);},index:function(elem){if(!elem){return(this[0]&&this[0].parentNode)?this.first().prevAll().length:-1;}
if(typeof elem==="string"){return indexOf.call(jQuery(elem),this[0]);}
return indexOf.call(this,elem.jquery?elem[0]:elem);},add:function(selector,context){return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(),jQuery(selector,context))));},addBack:function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector));}});function sibling(cur,dir){while((cur=cur[dir])&&cur.nodeType!==1){}
return cur;}
jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null;},parents:function(elem){return dir(elem,"parentNode");},parentsUntil:function(elem,_i,until){return dir(elem,"parentNode",until);},next:function(elem){return sibling(elem,"nextSibling");},prev:function(elem){return sibling(elem,"previousSibling");},nextAll:function(elem){return dir(elem,"nextSibling");},prevAll:function(elem){return dir(elem,"previousSibling");},nextUntil:function(elem,_i,until){return dir(elem,"nextSibling",until);},prevUntil:function(elem,_i,until){return dir(elem,"previousSibling",until);},siblings:function(elem){return siblings((elem.parentNode||{}).firstChild,elem);},children:function(elem){return siblings(elem.firstChild);},contents:function(elem){if(elem.contentDocument!=null&&getProto(elem.contentDocument)){return elem.contentDocument;}
if(nodeName(elem,"template")){elem=elem.content||elem;}
return jQuery.merge([],elem.childNodes);}},function(name,fn){jQuery.fn[name]=function(until,selector){var matched=jQuery.map(this,fn,until);if(name.slice(-5)!=="Until"){selector=until;}
if(selector&&typeof selector==="string"){matched=jQuery.filter(selector,matched);}
if(this.length>1){if(!guaranteedUnique[name]){jQuery.uniqueSort(matched);}
if(rparentsprev.test(name)){matched.reverse();}}
return this.pushStack(matched);};});var rnothtmlwhite=(/[^\x20\t\r\n\f]+/g);function createOptions(options){var object={};jQuery.each(options.match(rnothtmlwhite)||[],function(_,flag){object[flag]=true;});return object;}
jQuery.Callbacks=function(options){options=typeof options==="string"?createOptions(options):jQuery.extend({},options);var
firing,memory,fired,locked,list=[],queue=[],firingIndex=-1,fire=function(){locked=locked||options.once;fired=firing=true;for(;queue.length;firingIndex=-1){memory=queue.shift();while(++firingIndex<list.length){if(list[firingIndex].apply(memory[0],memory[1])===false&&options.stopOnFalse){firingIndex=list.length;memory=false;}}}
if(!options.memory){memory=false;}
firing=false;if(locked){if(memory){list=[];}else{list="";}}},self={add:function(){if(list){if(memory&&!firing){firingIndex=list.length-1;queue.push(memory);}
(function add(args){jQuery.each(args,function(_,arg){if(isFunction(arg)){if(!options.unique||!self.has(arg)){list.push(arg);}}else if(arg&&arg.length&&toType(arg)!=="string"){add(arg);}});})(arguments);if(memory&&!firing){fire();}}
return this;},remove:function(){jQuery.each(arguments,function(_,arg){var index;while((index=jQuery.inArray(arg,list,index))>-1){list.splice(index,1);if(index<=firingIndex){firingIndex--;}}});return this;},has:function(fn){return fn?jQuery.inArray(fn,list)>-1:list.length>0;},empty:function(){if(list){list=[];}
return this;},disable:function(){locked=queue=[];list=memory="";return this;},disabled:function(){return!list;},lock:function(){locked=queue=[];if(!memory&&!firing){list=memory="";}
return this;},locked:function(){return!!locked;},fireWith:function(context,args){if(!locked){args=args||[];args=[context,args.slice?args.slice():args];queue.push(args);if(!firing){fire();}}
return this;},fire:function(){self.fireWith(this,arguments);return this;},fired:function(){return!!fired;}};return self;};function Identity(v){return v;}
function Thrower(ex){throw ex;}
function adoptValue(value,resolve,reject,noValue){var method;try{if(value&&isFunction((method=value.promise))){method.call(value).done(resolve).fail(reject);}else if(value&&isFunction((method=value.then))){method.call(value,resolve,reject);}else{resolve.apply(undefined,[value].slice(noValue));}
}catch(value){reject.apply(undefined,[value]);}}
jQuery.extend({Deferred:function(func){var tuples=[["notify","progress",jQuery.Callbacks("memory"),jQuery.Callbacks("memory"),2],["resolve","done",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),0,"resolved"],["reject","fail",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),1,"rejected"]],state="pending",promise={state:function(){return state;},always:function(){deferred.done(arguments).fail(arguments);return this;},"catch":function(fn){return promise.then(null,fn);},pipe:function(){var fns=arguments;return jQuery.Deferred(function(newDefer){jQuery.each(tuples,function(_i,tuple){var fn=isFunction(fns[tuple[4]])&&fns[tuple[4]];deferred[tuple[1]](function(){var returned=fn&&fn.apply(this,arguments);if(returned&&isFunction(returned.promise)){returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject);}else{newDefer[tuple[0]+"With"](this,fn?[returned]:arguments);}});});fns=null;}).promise();},then:function(onFulfilled,onRejected,onProgress){var maxDepth=0;function resolve(depth,deferred,handler,special){return function(){var that=this,args=arguments,mightThrow=function(){var returned,then;if(depth<maxDepth){return;}
returned=handler.apply(that,args);if(returned===deferred.promise()){throw new TypeError("Thenable self-resolution");}
then=returned&&(typeof returned==="object"||typeof returned==="function")&&returned.then;if(isFunction(then)){if(special){then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special));}else{maxDepth++;then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special),resolve(maxDepth,deferred,Identity,deferred.notifyWith));}
}else{if(handler!==Identity){that=undefined;args=[returned];}
(special||deferred.resolveWith)(that,args);}},process=special?mightThrow:function(){try{mightThrow();}catch(e){if(jQuery.Deferred.exceptionHook){jQuery.Deferred.exceptionHook(e,process.stackTrace);}
if(depth+1>=maxDepth){if(handler!==Thrower){that=undefined;args=[e];}
deferred.rejectWith(that,args);}}};if(depth){process();}else{if(jQuery.Deferred.getStackHook){process.stackTrace=jQuery.Deferred.getStackHook();}
window.setTimeout(process);}};}
return jQuery.Deferred(function(newDefer){tuples[0][3].add(resolve(0,newDefer,isFunction(onProgress)?onProgress:Identity,newDefer.notifyWith));tuples[1][3].add(resolve(0,newDefer,isFunction(onFulfilled)?onFulfilled:Identity));tuples[2][3].add(resolve(0,newDefer,isFunction(onRejected)?onRejected:Thrower));}).promise();},promise:function(obj){return obj!=null?jQuery.extend(obj,promise):promise;}},deferred={};jQuery.each(tuples,function(i,tuple){var list=tuple[2],stateString=tuple[5];promise[tuple[1]]=list.add;if(stateString){list.add(function(){state=stateString;},tuples[3-i][2].disable,tuples[3-i][3].disable,tuples[0][2].lock,tuples[0][3].lock);}
list.add(tuple[3].fire);deferred[tuple[0]]=function(){deferred[tuple[0]+"With"](this===deferred?undefined:this,arguments);return this;};deferred[tuple[0]+"With"]=list.fireWith;});promise.promise(deferred);if(func){func.call(deferred,deferred);}
return deferred;},when:function(singleValue){var
remaining=arguments.length,i=remaining,resolveContexts=Array(i),resolveValues=slice.call(arguments),primary=jQuery.Deferred(),updateFunc=function(i){return function(value){resolveContexts[i]=this;resolveValues[i]=arguments.length>1?slice.call(arguments):value;if(!(--remaining)){primary.resolveWith(resolveContexts,resolveValues);}};};if(remaining<=1){adoptValue(singleValue,primary.done(updateFunc(i)).resolve,primary.reject,!remaining);if(primary.state()==="pending"||isFunction(resolveValues[i]&&resolveValues[i].then)){return primary.then();}}
while(i--){adoptValue(resolveValues[i],updateFunc(i),primary.reject);}
return primary.promise();}});var rerrorNames=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;jQuery.Deferred.exceptionHook=function(error,stack){if(window.console&&window.console.warn&&error&&rerrorNames.test(error.name)){window.console.warn("jQuery.Deferred exception: "+error.message,error.stack,stack);}};jQuery.readyException=function(error){window.setTimeout(function(){throw error;});};var readyList=jQuery.Deferred();jQuery.fn.ready=function(fn){readyList.then(fn)
.catch(function(error){jQuery.readyException(error);});return this;};jQuery.extend({isReady:false,readyWait:1,ready:function(wait){if(wait===true?--jQuery.readyWait:jQuery.isReady){return;}
jQuery.isReady=true;if(wait!==true&&--jQuery.readyWait>0){return;}
readyList.resolveWith(document,[jQuery]);}});jQuery.ready.then=readyList.then;function completed(){document.removeEventListener("DOMContentLoaded",completed);window.removeEventListener("load",completed);jQuery.ready();}
if(document.readyState==="complete"||(document.readyState!=="loading"&&!document.documentElement.doScroll)){window.setTimeout(jQuery.ready);}else{document.addEventListener("DOMContentLoaded",completed);window.addEventListener("load",completed);}
var access=function(elems,fn,key,value,chainable,emptyGet,raw){var i=0,len=elems.length,bulk=key==null;if(toType(key)==="object"){chainable=true;for(i in key){access(elems,fn,i,key[i],true,emptyGet,raw);}
}else if(value!==undefined){chainable=true;if(!isFunction(value)){raw=true;}
if(bulk){if(raw){fn.call(elems,value);fn=null;}else{bulk=fn;fn=function(elem,_key,value){return bulk.call(jQuery(elem),value);};}}
if(fn){for(;i<len;i++){fn(elems[i],key,raw?value:value.call(elems[i],i,fn(elems[i],key)));}}}
if(chainable){return elems;}
if(bulk){return fn.call(elems);}
return len?fn(elems[0],key):emptyGet;};var rmsPrefix=/^-ms-/,rdashAlpha=/-([a-z])/g;function fcamelCase(_all,letter){return letter.toUpperCase();}
function camelCase(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase);}
var acceptData=function(owner){return owner.nodeType===1||owner.nodeType===9||!(+owner.nodeType);};function Data(){this.expando=jQuery.expando+Data.uid++;}
Data.uid=1;Data.prototype={cache:function(owner){var value=owner[this.expando];if(!value){value={};if(acceptData(owner)){if(owner.nodeType){owner[this.expando]=value;}else{Object.defineProperty(owner,this.expando,{value:value,configurable:true});}}}
return value;},set:function(owner,data,value){var prop,cache=this.cache(owner);if(typeof data==="string"){cache[camelCase(data)]=value;}else{for(prop in data){cache[camelCase(prop)]=data[prop];}}
return cache;},get:function(owner,key){return key===undefined?this.cache(owner):owner[this.expando]&&owner[this.expando][camelCase(key)];},access:function(owner,key,value){if(key===undefined||((key&&typeof key==="string")&&value===undefined)){return this.get(owner,key);}
this.set(owner,key,value);return value!==undefined?value:key;},remove:function(owner,key){var i,cache=owner[this.expando];if(cache===undefined){return;}
if(key!==undefined){if(Array.isArray(key)){key=key.map(camelCase);}else{key=camelCase(key);key=key in cache?[key]:(key.match(rnothtmlwhite)||[]);}
i=key.length;while(i--){delete cache[key[i]];}}
if(key===undefined||jQuery.isEmptyObject(cache)){if(owner.nodeType){owner[this.expando]=undefined;}else{delete owner[this.expando];}}},hasData:function(owner){var cache=owner[this.expando];return cache!==undefined&&!jQuery.isEmptyObject(cache);}};var dataPriv=new Data();var dataUser=new Data();var rbrace=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,rmultiDash=/[A-Z]/g;function getData(data){if(data==="true"){return true;}
if(data==="false"){return false;}
if(data==="null"){return null;}
if(data===+data+""){return+data;}
if(rbrace.test(data)){return JSON.parse(data);}
return data;}
function dataAttr(elem,key,data){var name;if(data===undefined&&elem.nodeType===1){name="data-"+key.replace(rmultiDash,"-$&").toLowerCase();data=elem.getAttribute(name);if(typeof data==="string"){try{data=getData(data);}catch(e){}
dataUser.set(elem,key,data);}else{data=undefined;}}
return data;}
jQuery.extend({hasData:function(elem){return dataUser.hasData(elem)||dataPriv.hasData(elem);},data:function(elem,name,data){return dataUser.access(elem,name,data);},removeData:function(elem,name){dataUser.remove(elem,name);},_data:function(elem,name,data){return dataPriv.access(elem,name,data);},_removeData:function(elem,name){dataPriv.remove(elem,name);}});jQuery.fn.extend({data:function(key,value){var i,name,data,elem=this[0],attrs=elem&&elem.attributes;if(key===undefined){if(this.length){data=dataUser.get(elem);if(elem.nodeType===1&&!dataPriv.get(elem,"hasDataAttrs")){i=attrs.length;while(i--){if(attrs[i]){name=attrs[i].name;if(name.indexOf("data-")===0){name=camelCase(name.slice(5));dataAttr(elem,name,data[name]);}}}
dataPriv.set(elem,"hasDataAttrs",true);}}
return data;}
if(typeof key==="object"){return this.each(function(){dataUser.set(this,key);});}
return access(this,function(value){var data;if(elem&&value===undefined){data=dataUser.get(elem,key);if(data!==undefined){return data;}
data=dataAttr(elem,key);if(data!==undefined){return data;}
return;}
this.each(function(){dataUser.set(this,key,value);});},null,value,arguments.length>1,null,true);},removeData:function(key){return this.each(function(){dataUser.remove(this,key);});}});jQuery.extend({queue:function(elem,type,data){var queue;if(elem){type=(type||"fx")+"queue";queue=dataPriv.get(elem,type);if(data){if(!queue||Array.isArray(data)){queue=dataPriv.access(elem,type,jQuery.makeArray(data));}else{queue.push(data);}}
return queue||[];}},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),startLength=queue.length,fn=queue.shift(),hooks=jQuery._queueHooks(elem,type),next=function(){jQuery.dequeue(elem,type);};if(fn==="inprogress"){fn=queue.shift();startLength--;}
if(fn){if(type==="fx"){queue.unshift("inprogress");}
delete hooks.stop;fn.call(elem,next,hooks);}
if(!startLength&&hooks){hooks.empty.fire();}},_queueHooks:function(elem,type){var key=type+"queueHooks";return dataPriv.get(elem,key)||dataPriv.access(elem,key,{empty:jQuery.Callbacks("once memory").add(function(){dataPriv.remove(elem,[type+"queue",key]);})});}});jQuery.fn.extend({queue:function(type,data){var setter=2;if(typeof type!=="string"){data=type;type="fx";setter--;}
if(arguments.length<setter){return jQuery.queue(this[0],type);}
return data===undefined?this:this.each(function(){var queue=jQuery.queue(this,type,data);jQuery._queueHooks(this,type);if(type==="fx"&&queue[0]!=="inprogress"){jQuery.dequeue(this,type);}});},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type);});},clearQueue:function(type){return this.queue(type||"fx",[]);},promise:function(type,obj){var tmp,count=1,defer=jQuery.Deferred(),elements=this,i=this.length,resolve=function(){if(!(--count)){defer.resolveWith(elements,[elements]);}};if(typeof type!=="string"){obj=type;type=undefined;}
type=type||"fx";while(i--){tmp=dataPriv.get(elements[i],type+"queueHooks");if(tmp&&tmp.empty){count++;tmp.empty.add(resolve);}}
resolve();return defer.promise(obj);}});var pnum=(/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/).source;var rcssNum=new RegExp("^(?:([+-])=|)("+pnum+")([a-z%]*)$","i");var cssExpand=["Top","Right","Bottom","Left"];var documentElement=document.documentElement;var isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem);},composed={composed:true};if(documentElement.getRootNode){isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)||elem.getRootNode(composed)===elem.ownerDocument;};}
var isHiddenWithinTree=function(elem,el){elem=el||elem;return elem.style.display==="none"||elem.style.display===""&&isAttached(elem)&&jQuery.css(elem,"display")==="none";};function adjustCSS(elem,prop,valueParts,tween){var adjusted,scale,maxIterations=20,currentValue=tween?function(){return tween.cur();}:function(){return jQuery.css(elem,prop,"");},initial=currentValue(),unit=valueParts&&valueParts[3]||(jQuery.cssNumber[prop]?"":"px"),initialInUnit=elem.nodeType&&(jQuery.cssNumber[prop]||unit!=="px"&&+initial)&&rcssNum.exec(jQuery.css(elem,prop));if(initialInUnit&&initialInUnit[3]!==unit){initial=initial/2;unit=unit||initialInUnit[3];initialInUnit=+initial||1;while(maxIterations--){jQuery.style(elem,prop,initialInUnit+unit);if((1-scale)*(1-(scale=currentValue()/initial||0.5))<=0){maxIterations=0;}
initialInUnit=initialInUnit/scale;}
initialInUnit=initialInUnit*2;jQuery.style(elem,prop,initialInUnit+unit);valueParts=valueParts||[];}
if(valueParts){initialInUnit=+initialInUnit||+initial||0;adjusted=valueParts[1]?initialInUnit+(valueParts[1]+1)*valueParts[2]:+valueParts[2];if(tween){tween.unit=unit;tween.start=initialInUnit;tween.end=adjusted;}}
return adjusted;}
var defaultDisplayMap={};function getDefaultDisplay(elem){var temp,doc=elem.ownerDocument,nodeName=elem.nodeName,display=defaultDisplayMap[nodeName];if(display){return display;}
temp=doc.body.appendChild(doc.createElement(nodeName));display=jQuery.css(temp,"display");temp.parentNode.removeChild(temp);if(display==="none"){display="block";}
defaultDisplayMap[nodeName]=display;return display;}
function showHide(elements,show){var display,elem,values=[],index=0,length=elements.length;for(;index<length;index++){elem=elements[index];if(!elem.style){continue;}
display=elem.style.display;if(show){if(display==="none"){values[index]=dataPriv.get(elem,"display")||null;if(!values[index]){elem.style.display="";}}
if(elem.style.display===""&&isHiddenWithinTree(elem)){values[index]=getDefaultDisplay(elem);}}else{if(display!=="none"){values[index]="none";dataPriv.set(elem,"display",display);}}}
for(index=0;index<length;index++){if(values[index]!=null){elements[index].style.display=values[index];}}
return elements;}
jQuery.fn.extend({show:function(){return showHide(this,true);},hide:function(){return showHide(this);},toggle:function(state){if(typeof state==="boolean"){return state?this.show():this.hide();}
return this.each(function(){if(isHiddenWithinTree(this)){jQuery(this).show();}else{jQuery(this).hide();}});}});var rcheckableType=(/^(?:checkbox|radio)$/i);var rtagName=(/<([a-z][^\/\0>\x20\t\r\n\f]*)/i);var rscriptType=(/^$|^module$|\/(?:java|ecma)script/i);(function(){var fragment=document.createDocumentFragment(),div=fragment.appendChild(document.createElement("div")),input=document.createElement("input");input.setAttribute("type","radio");input.setAttribute("checked","checked");input.setAttribute("name","t");div.appendChild(input);support.checkClone=div.cloneNode(true).cloneNode(true).lastChild.checked;div.innerHTML="<textarea>x</textarea>";support.noCloneChecked=!!div.cloneNode(true).lastChild.defaultValue;div.innerHTML="<option></option>";support.option=!!div.lastChild;})();var wrapMap={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!support.option){wrapMap.optgroup=wrapMap.option=[1,"<select multiple='multiple'>","</select>"];}
function getAll(context,tag){var ret;if(typeof context.getElementsByTagName!=="undefined"){ret=context.getElementsByTagName(tag||"*");}else if(typeof context.querySelectorAll!=="undefined"){ret=context.querySelectorAll(tag||"*");}else{ret=[];}
if(tag===undefined||tag&&nodeName(context,tag)){return jQuery.merge([context],ret);}
return ret;}
function setGlobalEval(elems,refElements){var i=0,l=elems.length;for(;i<l;i++){dataPriv.set(elems[i],"globalEval",!refElements||dataPriv.get(refElements[i],"globalEval"));}}
var rhtml=/<|&#?\w+;/;function buildFragment(elems,context,scripts,selection,ignored){var elem,tmp,tag,wrap,attached,j,fragment=context.createDocumentFragment(),nodes=[],i=0,l=elems.length;for(;i<l;i++){elem=elems[i];if(elem||elem===0){if(toType(elem)==="object"){jQuery.merge(nodes,elem.nodeType?[elem]:elem);}else if(!rhtml.test(elem)){nodes.push(context.createTextNode(elem));}else{tmp=tmp||fragment.appendChild(context.createElement("div"));tag=(rtagName.exec(elem)||["",""])[1].toLowerCase();wrap=wrapMap[tag]||wrapMap._default;tmp.innerHTML=wrap[1]+jQuery.htmlPrefilter(elem)+wrap[2];j=wrap[0];while(j--){tmp=tmp.lastChild;}
jQuery.merge(nodes,tmp.childNodes);tmp=fragment.firstChild;tmp.textContent="";}}}
fragment.textContent="";i=0;while((elem=nodes[i++])){if(selection&&jQuery.inArray(elem,selection)>-1){if(ignored){ignored.push(elem);}
continue;}
attached=isAttached(elem);tmp=getAll(fragment.appendChild(elem),"script");if(attached){setGlobalEval(tmp);}
if(scripts){j=0;while((elem=tmp[j++])){if(rscriptType.test(elem.type||"")){scripts.push(elem);}}}}
return fragment;}
var rtypenamespace=/^([^.]*)(?:\.(.+)|)/;function returnTrue(){return true;}
function returnFalse(){return false;}
function expectSync(elem,type){return(elem===safeActiveElement())===(type==="focus");}
function safeActiveElement(){try{return document.activeElement;}catch(err){}}
function on(elem,types,selector,data,fn,one){var origFn,type;if(typeof types==="object"){if(typeof selector!=="string"){data=data||selector;selector=undefined;}
for(type in types){on(elem,type,selector,data,types[type],one);}
return elem;}
if(data==null&&fn==null){fn=selector;data=selector=undefined;}else if(fn==null){if(typeof selector==="string"){fn=data;data=undefined;}else{fn=data;data=selector;selector=undefined;}}
if(fn===false){fn=returnFalse;}else if(!fn){return elem;}
if(one===1){origFn=fn;fn=function(event){jQuery().off(event);return origFn.apply(this,arguments);};fn.guid=origFn.guid||(origFn.guid=jQuery.guid++);}
return elem.each(function(){jQuery.event.add(this,types,fn,data,selector);});}
jQuery.event={global:{},add:function(elem,types,handler,data,selector){var handleObjIn,eventHandle,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.get(elem);if(!acceptData(elem)){return;}
if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;selector=handleObjIn.selector;}
if(selector){jQuery.find.matchesSelector(documentElement,selector);}
if(!handler.guid){handler.guid=jQuery.guid++;}
if(!(events=elemData.events)){events=elemData.events=Object.create(null);}
if(!(eventHandle=elemData.handle)){eventHandle=elemData.handle=function(e){return typeof jQuery!=="undefined"&&jQuery.event.triggered!==e.type?jQuery.event.dispatch.apply(elem,arguments):undefined;};}
types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){continue;}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;special=jQuery.event.special[type]||{};handleObj=jQuery.extend({type:type,origType:origType,data:data,handler:handler,guid:handler.guid,selector:selector,needsContext:selector&&jQuery.expr.match.needsContext.test(selector),namespace:namespaces.join(".")},handleObjIn);if(!(handlers=events[type])){handlers=events[type]=[];handlers.delegateCount=0;if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===false){if(elem.addEventListener){elem.addEventListener(type,eventHandle);}}}
if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid;}}
if(selector){handlers.splice(handlers.delegateCount++,0,handleObj);}else{handlers.push(handleObj);}
jQuery.event.global[type]=true;}},remove:function(elem,types,handler,selector,mappedTypes){var j,origCount,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.hasData(elem)&&dataPriv.get(elem);if(!elemData||!(events=elemData.events)){return;}
types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){for(type in events){jQuery.event.remove(elem,type+types[t],handler,selector,true);}
continue;}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;handlers=events[type]||[];tmp=tmp[2]&&new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)");origCount=j=handlers.length;while(j--){handleObj=handlers[j];if((mappedTypes||origType===handleObj.origType)&&(!handler||handler.guid===handleObj.guid)&&(!tmp||tmp.test(handleObj.namespace))&&(!selector||selector===handleObj.selector||selector==="**"&&handleObj.selector)){handlers.splice(j,1);if(handleObj.selector){handlers.delegateCount--;}
if(special.remove){special.remove.call(elem,handleObj);}}}
if(origCount&&!handlers.length){if(!special.teardown||special.teardown.call(elem,namespaces,elemData.handle)===false){jQuery.removeEvent(elem,type,elemData.handle);}
delete events[type];}}
if(jQuery.isEmptyObject(events)){dataPriv.remove(elem,"handle events");}},dispatch:function(nativeEvent){var i,j,ret,matched,handleObj,handlerQueue,args=new Array(arguments.length),event=jQuery.event.fix(nativeEvent),handlers=(dataPriv.get(this,"events")||Object.create(null))[event.type]||[],special=jQuery.event.special[event.type]||{};args[0]=event;for(i=1;i<arguments.length;i++){args[i]=arguments[i];}
event.delegateTarget=this;if(special.preDispatch&&special.preDispatch.call(this,event)===false){return;}
handlerQueue=jQuery.event.handlers.call(this,event,handlers);i=0;while((matched=handlerQueue[i++])&&!event.isPropagationStopped()){event.currentTarget=matched.elem;j=0;while((handleObj=matched.handlers[j++])&&!event.isImmediatePropagationStopped()){if(!event.rnamespace||handleObj.namespace===false||event.rnamespace.test(handleObj.namespace)){event.handleObj=handleObj;event.data=handleObj.data;ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args);if(ret!==undefined){if((event.result=ret)===false){event.preventDefault();event.stopPropagation();}}}}}
if(special.postDispatch){special.postDispatch.call(this,event);}
return event.result;},handlers:function(event,handlers){var i,handleObj,sel,matchedHandlers,matchedSelectors,handlerQueue=[],delegateCount=handlers.delegateCount,cur=event.target;if(delegateCount&&cur.nodeType&&!(event.type==="click"&&event.button>=1)){for(;cur!==this;cur=cur.parentNode||this){if(cur.nodeType===1&&!(event.type==="click"&&cur.disabled===true)){matchedHandlers=[];matchedSelectors={};for(i=0;i<delegateCount;i++){handleObj=handlers[i];sel=handleObj.selector+" ";if(matchedSelectors[sel]===undefined){matchedSelectors[sel]=handleObj.needsContext?jQuery(sel,this).index(cur)>-1:jQuery.find(sel,this,null,[cur]).length;}
if(matchedSelectors[sel]){matchedHandlers.push(handleObj);}}
if(matchedHandlers.length){handlerQueue.push({elem:cur,handlers:matchedHandlers});}}}}
cur=this;if(delegateCount<handlers.length){handlerQueue.push({elem:cur,handlers:handlers.slice(delegateCount)});}
return handlerQueue;},addProp:function(name,hook){Object.defineProperty(jQuery.Event.prototype,name,{enumerable:true,configurable:true,get:isFunction(hook)?function(){if(this.originalEvent){return hook(this.originalEvent);}}:function(){if(this.originalEvent){return this.originalEvent[name];}},set:function(value){Object.defineProperty(this,name,{enumerable:true,configurable:true,writable:true,value:value});}});},fix:function(originalEvent){return originalEvent[jQuery.expando]?originalEvent:new jQuery.Event(originalEvent);},special:{load:{noBubble:true},click:{setup:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click",returnTrue);}
return false;},trigger:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click");}
return true;},_default:function(event){var target=event.target;return rcheckableType.test(target.type)&&target.click&&nodeName(target,"input")&&dataPriv.get(target,"click")||nodeName(target,"a");}},beforeunload:{postDispatch:function(event){if(event.result!==undefined&&event.originalEvent){event.originalEvent.returnValue=event.result;}}}}};function leverageNative(el,type,expectSync){if(!expectSync){if(dataPriv.get(el,type)===undefined){jQuery.event.add(el,type,returnTrue);}
return;}
dataPriv.set(el,type,false);jQuery.event.add(el,type,{namespace:false,handler:function(event){var notAsync,result,saved=dataPriv.get(this,type);if((event.isTrigger&1)&&this[type]){if(!saved.length){saved=slice.call(arguments);dataPriv.set(this,type,saved);notAsync=expectSync(this,type);this[type]();result=dataPriv.get(this,type);if(saved!==result||notAsync){dataPriv.set(this,type,false);}else{result={};}
if(saved!==result){event.stopImmediatePropagation();event.preventDefault();return result&&result.value;}
}else if((jQuery.event.special[type]||{}).delegateType){event.stopPropagation();}
}else if(saved.length){dataPriv.set(this,type,{value:jQuery.event.trigger(jQuery.extend(saved[0],jQuery.Event.prototype),saved.slice(1),this)});event.stopImmediatePropagation();}}});}
jQuery.removeEvent=function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle);}};jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event)){return new jQuery.Event(src,props);}
if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=src.defaultPrevented||src.defaultPrevented===undefined&&src.returnValue===false?returnTrue:returnFalse;this.target=(src.target&&src.target.nodeType===3)?src.target.parentNode:src.target;this.currentTarget=src.currentTarget;this.relatedTarget=src.relatedTarget;}else{this.type=src;}
if(props){jQuery.extend(this,props);}
this.timeStamp=src&&src.timeStamp||Date.now();this[jQuery.expando]=true;};jQuery.Event.prototype={constructor:jQuery.Event,isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse,isSimulated:false,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=returnTrue;if(e&&!this.isSimulated){e.preventDefault();}},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopPropagation();}},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopImmediatePropagation();}
this.stopPropagation();}};jQuery.each({altKey:true,bubbles:true,cancelable:true,changedTouches:true,ctrlKey:true,detail:true,eventPhase:true,metaKey:true,pageX:true,pageY:true,shiftKey:true,view:true,"char":true,code:true,charCode:true,key:true,keyCode:true,button:true,buttons:true,clientX:true,clientY:true,offsetX:true,offsetY:true,pointerId:true,pointerType:true,screenX:true,screenY:true,targetTouches:true,toElement:true,touches:true,which:true},jQuery.event.addProp);jQuery.each({focus:"focusin",blur:"focusout"},function(type,delegateType){jQuery.event.special[type]={setup:function(){leverageNative(this,type,expectSync);return false;},trigger:function(){leverageNative(this,type);return true;},_default:function(){return true;},delegateType:delegateType};});jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var ret,target=this,related=event.relatedTarget,handleObj=event.handleObj;if(!related||(related!==target&&!jQuery.contains(target,related))){event.type=handleObj.origType;ret=handleObj.handler.apply(this,arguments);event.type=fix;}
return ret;}};});jQuery.fn.extend({on:function(types,selector,data,fn){return on(this,types,selector,data,fn);},one:function(types,selector,data,fn){return on(this,types,selector,data,fn,1);},off:function(types,selector,fn){var handleObj,type;if(types&&types.preventDefault&&types.handleObj){handleObj=types.handleObj;jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler);return this;}
if(typeof types==="object"){for(type in types){this.off(type,selector,types[type]);}
return this;}
if(selector===false||typeof selector==="function"){fn=selector;selector=undefined;}
if(fn===false){fn=returnFalse;}
return this.each(function(){jQuery.event.remove(this,types,fn,selector);});}});var
rnoInnerhtml=/<script|<style|<link/i,rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rcleanScript=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function manipulationTarget(elem,content){if(nodeName(elem,"table")&&nodeName(content.nodeType!==11?content:content.firstChild,"tr")){return jQuery(elem).children("tbody")[0]||elem;}
return elem;}
function disableScript(elem){elem.type=(elem.getAttribute("type")!==null)+"/"+elem.type;return elem;}
function restoreScript(elem){if((elem.type||"").slice(0,5)==="true/"){elem.type=elem.type.slice(5);}else{elem.removeAttribute("type");}
return elem;}
function cloneCopyEvent(src,dest){var i,l,type,pdataOld,udataOld,udataCur,events;if(dest.nodeType!==1){return;}
if(dataPriv.hasData(src)){pdataOld=dataPriv.get(src);events=pdataOld.events;if(events){dataPriv.remove(dest,"handle events");for(type in events){for(i=0,l=events[type].length;i<l;i++){jQuery.event.add(dest,type,events[type][i]);}}}}
if(dataUser.hasData(src)){udataOld=dataUser.access(src);udataCur=jQuery.extend({},udataOld);dataUser.set(dest,udataCur);}}
function fixInput(src,dest){var nodeName=dest.nodeName.toLowerCase();if(nodeName==="input"&&rcheckableType.test(src.type)){dest.checked=src.checked;}else if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue;}}
function domManip(collection,args,callback,ignored){args=flat(args);var fragment,first,scripts,hasScripts,node,doc,i=0,l=collection.length,iNoClone=l-1,value=args[0],valueIsFunction=isFunction(value);if(valueIsFunction||(l>1&&typeof value==="string"&&!support.checkClone&&rchecked.test(value))){return collection.each(function(index){var self=collection.eq(index);if(valueIsFunction){args[0]=value.call(this,index,self.html());}
domManip(self,args,callback,ignored);});}
if(l){fragment=buildFragment(args,collection[0].ownerDocument,false,collection,ignored);first=fragment.firstChild;if(fragment.childNodes.length===1){fragment=first;}
if(first||ignored){scripts=jQuery.map(getAll(fragment,"script"),disableScript);hasScripts=scripts.length;for(;i<l;i++){node=fragment;if(i!==iNoClone){node=jQuery.clone(node,true,true);if(hasScripts){jQuery.merge(scripts,getAll(node,"script"));}}
callback.call(collection[i],node,i);}
if(hasScripts){doc=scripts[scripts.length-1].ownerDocument;jQuery.map(scripts,restoreScript);for(i=0;i<hasScripts;i++){node=scripts[i];if(rscriptType.test(node.type||"")&&!dataPriv.access(node,"globalEval")&&jQuery.contains(doc,node)){if(node.src&&(node.type||"").toLowerCase()!=="module"){if(jQuery._evalUrl&&!node.noModule){jQuery._evalUrl(node.src,{nonce:node.nonce||node.getAttribute("nonce")},doc);}}else{DOMEval(node.textContent.replace(rcleanScript,""),node,doc);}}}}}}
return collection;}
function remove(elem,selector,keepData){var node,nodes=selector?jQuery.filter(selector,elem):elem,i=0;for(;(node=nodes[i])!=null;i++){if(!keepData&&node.nodeType===1){jQuery.cleanData(getAll(node));}
if(node.parentNode){if(keepData&&isAttached(node)){setGlobalEval(getAll(node,"script"));}
node.parentNode.removeChild(node);}}
return elem;}
jQuery.extend({htmlPrefilter:function(html){return html;},clone:function(elem,dataAndEvents,deepDataAndEvents){var i,l,srcElements,destElements,clone=elem.cloneNode(true),inPage=isAttached(elem);if(!support.noCloneChecked&&(elem.nodeType===1||elem.nodeType===11)&&!jQuery.isXMLDoc(elem)){destElements=getAll(clone);srcElements=getAll(elem);for(i=0,l=srcElements.length;i<l;i++){fixInput(srcElements[i],destElements[i]);}}
if(dataAndEvents){if(deepDataAndEvents){srcElements=srcElements||getAll(elem);destElements=destElements||getAll(clone);for(i=0,l=srcElements.length;i<l;i++){cloneCopyEvent(srcElements[i],destElements[i]);}}else{cloneCopyEvent(elem,clone);}}
destElements=getAll(clone,"script");if(destElements.length>0){setGlobalEval(destElements,!inPage&&getAll(elem,"script"));}
return clone;},cleanData:function(elems){var data,elem,type,special=jQuery.event.special,i=0;for(;(elem=elems[i])!==undefined;i++){if(acceptData(elem)){if((data=elem[dataPriv.expando])){if(data.events){for(type in data.events){if(special[type]){jQuery.event.remove(elem,type);}else{jQuery.removeEvent(elem,type,data.handle);}}}
elem[dataPriv.expando]=undefined;}
if(elem[dataUser.expando]){elem[dataUser.expando]=undefined;}}}}});jQuery.fn.extend({detach:function(selector){return remove(this,selector,true);},remove:function(selector){return remove(this,selector);},text:function(value){return access(this,function(value){return value===undefined?jQuery.text(this):this.empty().each(function(){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){this.textContent=value;}});},null,value,arguments.length);},append:function(){return domManip(this,arguments,function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.appendChild(elem);}});},prepend:function(){return domManip(this,arguments,function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.insertBefore(elem,target.firstChild);}});},before:function(){return domManip(this,arguments,function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this);}});},after:function(){return domManip(this,arguments,function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this.nextSibling);}});},empty:function(){var elem,i=0;for(;(elem=this[i])!=null;i++){if(elem.nodeType===1){jQuery.cleanData(getAll(elem,false));elem.textContent="";}}
return this;},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?false:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map(function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents);});},html:function(value){return access(this,function(value){var elem=this[0]||{},i=0,l=this.length;if(value===undefined&&elem.nodeType===1){return elem.innerHTML;}
if(typeof value==="string"&&!rnoInnerhtml.test(value)&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=jQuery.htmlPrefilter(value);try{for(;i<l;i++){elem=this[i]||{};if(elem.nodeType===1){jQuery.cleanData(getAll(elem,false));elem.innerHTML=value;}}
elem=0;}catch(e){}}
if(elem){this.empty().append(value);}},null,value,arguments.length);},replaceWith:function(){var ignored=[];return domManip(this,arguments,function(elem){var parent=this.parentNode;if(jQuery.inArray(this,ignored)<0){jQuery.cleanData(getAll(this));if(parent){parent.replaceChild(elem,this);}}
},ignored);}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var elems,ret=[],insert=jQuery(selector),last=insert.length-1,i=0;for(;i<=last;i++){elems=i===last?this:this.clone(true);jQuery(insert[i])[original](elems);push.apply(ret,elems.get());}
return this.pushStack(ret);};});var rnumnonpx=new RegExp("^("+pnum+")(?!px)[a-z%]+$","i");var getStyles=function(elem){var view=elem.ownerDocument.defaultView;if(!view||!view.opener){view=window;}
return view.getComputedStyle(elem);};var swap=function(elem,options,callback){var ret,name,old={};for(name in options){old[name]=elem.style[name];elem.style[name]=options[name];}
ret=callback.call(elem);for(name in options){elem.style[name]=old[name];}
return ret;};var rboxStyle=new RegExp(cssExpand.join("|"),"i");(function(){function computeStyleTests(){if(!div){return;}
container.style.cssText="position:absolute;left:-11111px;width:60px;"+
"margin-top:1px;padding:0;border:0";div.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;"+
"margin:auto;border:1px;padding:1px;"+
"width:60%;top:1%";documentElement.appendChild(container).appendChild(div);var divStyle=window.getComputedStyle(div);pixelPositionVal=divStyle.top!=="1%";reliableMarginLeftVal=roundPixelMeasures(divStyle.marginLeft)===12;div.style.right="60%";pixelBoxStylesVal=roundPixelMeasures(divStyle.right)===36;boxSizingReliableVal=roundPixelMeasures(divStyle.width)===36;div.style.position="absolute";scrollboxSizeVal=roundPixelMeasures(div.offsetWidth/3)===12;documentElement.removeChild(container);div=null;}
function roundPixelMeasures(measure){return Math.round(parseFloat(measure));}
var pixelPositionVal,boxSizingReliableVal,scrollboxSizeVal,pixelBoxStylesVal,reliableTrDimensionsVal,reliableMarginLeftVal,container=document.createElement("div"),div=document.createElement("div");if(!div.style){return;}
div.style.backgroundClip="content-box";div.cloneNode(true).style.backgroundClip="";support.clearCloneStyle=div.style.backgroundClip==="content-box";jQuery.extend(support,{boxSizingReliable:function(){computeStyleTests();return boxSizingReliableVal;},pixelBoxStyles:function(){computeStyleTests();return pixelBoxStylesVal;},pixelPosition:function(){computeStyleTests();return pixelPositionVal;},reliableMarginLeft:function(){computeStyleTests();return reliableMarginLeftVal;},scrollboxSize:function(){computeStyleTests();return scrollboxSizeVal;},reliableTrDimensions:function(){var table,tr,trChild,trStyle;if(reliableTrDimensionsVal==null){table=document.createElement("table");tr=document.createElement("tr");trChild=document.createElement("div");table.style.cssText="position:absolute;left:-11111px;border-collapse:separate";tr.style.cssText="border:1px solid";tr.style.height="1px";trChild.style.height="9px";trChild.style.display="block";documentElement.appendChild(table).appendChild(tr).appendChild(trChild);trStyle=window.getComputedStyle(tr);reliableTrDimensionsVal=(parseInt(trStyle.height,10)+
parseInt(trStyle.borderTopWidth,10)+
parseInt(trStyle.borderBottomWidth,10))===tr.offsetHeight;documentElement.removeChild(table);}
return reliableTrDimensionsVal;}});})();function curCSS(elem,name,computed){var width,minWidth,maxWidth,ret,style=elem.style;computed=computed||getStyles(elem);if(computed){ret=computed.getPropertyValue(name)||computed[name];if(ret===""&&!isAttached(elem)){ret=jQuery.style(elem,name);}
if(!support.pixelBoxStyles()&&rnumnonpx.test(ret)&&rboxStyle.test(name)){width=style.width;minWidth=style.minWidth;maxWidth=style.maxWidth;style.minWidth=style.maxWidth=style.width=ret;ret=computed.width;style.width=width;style.minWidth=minWidth;style.maxWidth=maxWidth;}}
return ret!==undefined?ret+"":ret;}
function addGetHookIf(conditionFn,hookFn){return{get:function(){if(conditionFn()){delete this.get;return;}
return(this.get=hookFn).apply(this,arguments);}};}
var cssPrefixes=["Webkit","Moz","ms"],emptyStyle=document.createElement("div").style,vendorProps={};function vendorPropName(name){var capName=name[0].toUpperCase()+name.slice(1),i=cssPrefixes.length;while(i--){name=cssPrefixes[i]+capName;if(name in emptyStyle){return name;}}}
function finalPropName(name){var final=jQuery.cssProps[name]||vendorProps[name];if(final){return final;}
if(name in emptyStyle){return name;}
return vendorProps[name]=vendorPropName(name)||name;}
var
rdisplayswap=/^(none|table(?!-c[ea]).+)/,rcustomProp=/^--/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssNormalTransform={letterSpacing:"0",fontWeight:"400"};function setPositiveNumber(_elem,value,subtract){var matches=rcssNum.exec(value);return matches?Math.max(0,matches[2]-(subtract||0))+(matches[3]||"px"):value;}
function boxModelAdjustment(elem,dimension,box,isBorderBox,styles,computedVal){var i=dimension==="width"?1:0,extra=0,delta=0;if(box===(isBorderBox?"border":"content")){return 0;}
for(;i<4;i+=2){if(box==="margin"){delta+=jQuery.css(elem,box+cssExpand[i],true,styles);}
if(!isBorderBox){delta+=jQuery.css(elem,"padding"+cssExpand[i],true,styles);if(box!=="padding"){delta+=jQuery.css(elem,"border"+cssExpand[i]+"Width",true,styles);}else{extra+=jQuery.css(elem,"border"+cssExpand[i]+"Width",true,styles);}
}else{if(box==="content"){delta-=jQuery.css(elem,"padding"+cssExpand[i],true,styles);}
if(box!=="margin"){delta-=jQuery.css(elem,"border"+cssExpand[i]+"Width",true,styles);}}}
if(!isBorderBox&&computedVal>=0){delta+=Math.max(0,Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-
computedVal-
delta-
extra-
0.5
))||0;}
return delta;}
function getWidthOrHeight(elem,dimension,extra){var styles=getStyles(elem),boxSizingNeeded=!support.boxSizingReliable()||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",false,styles)==="border-box",valueIsBorderBox=isBorderBox,val=curCSS(elem,dimension,styles),offsetProp="offset"+dimension[0].toUpperCase()+dimension.slice(1);if(rnumnonpx.test(val)){if(!extra){return val;}
val="auto";}
if((!support.boxSizingReliable()&&isBorderBox||!support.reliableTrDimensions()&&nodeName(elem,"tr")||val==="auto"||!parseFloat(val)&&jQuery.css(elem,"display",false,styles)==="inline")&&elem.getClientRects().length){isBorderBox=jQuery.css(elem,"boxSizing",false,styles)==="border-box";valueIsBorderBox=offsetProp in elem;if(valueIsBorderBox){val=elem[offsetProp];}}
val=parseFloat(val)||0;return(val+
boxModelAdjustment(elem,dimension,extra||(isBorderBox?"border":"content"),valueIsBorderBox,styles,val))+"px";}
jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return ret===""?"1":ret;}}}},cssNumber:{"animationIterationCount":true,"columnCount":true,"fillOpacity":true,"flexGrow":true,"flexShrink":true,"fontWeight":true,"gridArea":true,"gridColumn":true,"gridColumnEnd":true,"gridColumnStart":true,"gridRow":true,"gridRowEnd":true,"gridRowStart":true,"lineHeight":true,"opacity":true,"order":true,"orphans":true,"widows":true,"zIndex":true,"zoom":true},cssProps:{},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return;}
var ret,type,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name),style=elem.style;if(!isCustomProp){name=finalPropName(origName);}
hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(value!==undefined){type=typeof value;if(type==="string"&&(ret=rcssNum.exec(value))&&ret[1]){value=adjustCSS(elem,name,ret);type="number";}
if(value==null||value!==value){return;}
if(type==="number"&&!isCustomProp){value+=ret&&ret[3]||(jQuery.cssNumber[origName]?"":"px");}
if(!support.clearCloneStyle&&value===""&&name.indexOf("background")===0){style[name]="inherit";}
if(!hooks||!("set"in hooks)||(value=hooks.set(elem,value,extra))!==undefined){if(isCustomProp){style.setProperty(name,value);}else{style[name]=value;}}}else{if(hooks&&"get"in hooks&&(ret=hooks.get(elem,false,extra))!==undefined){return ret;}
return style[name];}},css:function(elem,name,extra,styles){var val,num,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name);if(!isCustomProp){name=finalPropName(origName);}
hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(hooks&&"get"in hooks){val=hooks.get(elem,true,extra);}
if(val===undefined){val=curCSS(elem,name,styles);}
if(val==="normal"&&name in cssNormalTransform){val=cssNormalTransform[name];}
if(extra===""||extra){num=parseFloat(val);return extra===true||isFinite(num)?num||0:val;}
return val;}});jQuery.each(["height","width"],function(_i,dimension){jQuery.cssHooks[dimension]={get:function(elem,computed,extra){if(computed){return rdisplayswap.test(jQuery.css(elem,"display"))&&(!elem.getClientRects().length||!elem.getBoundingClientRect().width)?swap(elem,cssShow,function(){return getWidthOrHeight(elem,dimension,extra);}):getWidthOrHeight(elem,dimension,extra);}},set:function(elem,value,extra){var matches,styles=getStyles(elem),scrollboxSizeBuggy=!support.scrollboxSize()&&styles.position==="absolute",boxSizingNeeded=scrollboxSizeBuggy||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",false,styles)==="border-box",subtract=extra?boxModelAdjustment(elem,dimension,extra,isBorderBox,styles):0;if(isBorderBox&&scrollboxSizeBuggy){subtract-=Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-
parseFloat(styles[dimension])-
boxModelAdjustment(elem,dimension,"border",false,styles)-
0.5);}
if(subtract&&(matches=rcssNum.exec(value))&&(matches[3]||"px")!=="px"){elem.style[dimension]=value;value=jQuery.css(elem,dimension);}
return setPositiveNumber(elem,value,subtract);}};});jQuery.cssHooks.marginLeft=addGetHookIf(support.reliableMarginLeft,function(elem,computed){if(computed){return(parseFloat(curCSS(elem,"marginLeft"))||elem.getBoundingClientRect().left-
swap(elem,{marginLeft:0},function(){return elem.getBoundingClientRect().left;}))+"px";}});jQuery.each({margin:"",padding:"",border:"Width"},function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){var i=0,expanded={},parts=typeof value==="string"?value.split(" "):[value];for(;i<4;i++){expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0];}
return expanded;}};if(prefix!=="margin"){jQuery.cssHooks[prefix+suffix].set=setPositiveNumber;}});jQuery.fn.extend({css:function(name,value){return access(this,function(elem,name,value){var styles,len,map={},i=0;if(Array.isArray(name)){styles=getStyles(elem);len=name.length;for(;i<len;i++){map[name[i]]=jQuery.css(elem,name[i],false,styles);}
return map;}
return value!==undefined?jQuery.style(elem,name,value):jQuery.css(elem,name);},name,value,arguments.length>1);}});function Tween(elem,options,prop,end,easing){return new Tween.prototype.init(elem,options,prop,end,easing);}
jQuery.Tween=Tween;Tween.prototype={constructor:Tween,init:function(elem,options,prop,end,easing,unit){this.elem=elem;this.prop=prop;this.easing=easing||jQuery.easing._default;this.options=options;this.start=this.now=this.cur();this.end=end;this.unit=unit||(jQuery.cssNumber[prop]?"":"px");},cur:function(){var hooks=Tween.propHooks[this.prop];return hooks&&hooks.get?hooks.get(this):Tween.propHooks._default.get(this);},run:function(percent){var eased,hooks=Tween.propHooks[this.prop];if(this.options.duration){this.pos=eased=jQuery.easing[this.easing](percent,this.options.duration*percent,0,1,this.options.duration);}else{this.pos=eased=percent;}
this.now=(this.end-this.start)*eased+this.start;if(this.options.step){this.options.step.call(this.elem,this.now,this);}
if(hooks&&hooks.set){hooks.set(this);}else{Tween.propHooks._default.set(this);}
return this;}};Tween.prototype.init.prototype=Tween.prototype;Tween.propHooks={_default:{get:function(tween){var result;if(tween.elem.nodeType!==1||tween.elem[tween.prop]!=null&&tween.elem.style[tween.prop]==null){return tween.elem[tween.prop];}
result=jQuery.css(tween.elem,tween.prop,"");return!result||result==="auto"?0:result;},set:function(tween){if(jQuery.fx.step[tween.prop]){jQuery.fx.step[tween.prop](tween);}else if(tween.elem.nodeType===1&&(jQuery.cssHooks[tween.prop]||tween.elem.style[finalPropName(tween.prop)]!=null)){jQuery.style(tween.elem,tween.prop,tween.now+tween.unit);}else{tween.elem[tween.prop]=tween.now;}}}};Tween.propHooks.scrollTop=Tween.propHooks.scrollLeft={set:function(tween){if(tween.elem.nodeType&&tween.elem.parentNode){tween.elem[tween.prop]=tween.now;}}};jQuery.easing={linear:function(p){return p;},swing:function(p){return 0.5-Math.cos(p*Math.PI)/2;},_default:"swing"};jQuery.fx=Tween.prototype.init;jQuery.fx.step={};var
fxNow,inProgress,rfxtypes=/^(?:toggle|show|hide)$/,rrun=/queueHooks$/;function schedule(){if(inProgress){if(document.hidden===false&&window.requestAnimationFrame){window.requestAnimationFrame(schedule);}else{window.setTimeout(schedule,jQuery.fx.interval);}
jQuery.fx.tick();}}
function createFxNow(){window.setTimeout(function(){fxNow=undefined;});return(fxNow=Date.now());}
function genFx(type,includeWidth){var which,i=0,attrs={height:type};includeWidth=includeWidth?1:0;for(;i<4;i+=2-includeWidth){which=cssExpand[i];attrs["margin"+which]=attrs["padding"+which]=type;}
if(includeWidth){attrs.opacity=attrs.width=type;}
return attrs;}
function createTween(value,prop,animation){var tween,collection=(Animation.tweeners[prop]||[]).concat(Animation.tweeners["*"]),index=0,length=collection.length;for(;index<length;index++){if((tween=collection[index].call(animation,prop,value))){return tween;}}}
function defaultPrefilter(elem,props,opts){var prop,value,toggle,hooks,oldfire,propTween,restoreDisplay,display,isBox="width"in props||"height"in props,anim=this,orig={},style=elem.style,hidden=elem.nodeType&&isHiddenWithinTree(elem),dataShow=dataPriv.get(elem,"fxshow");if(!opts.queue){hooks=jQuery._queueHooks(elem,"fx");if(hooks.unqueued==null){hooks.unqueued=0;oldfire=hooks.empty.fire;hooks.empty.fire=function(){if(!hooks.unqueued){oldfire();}};}
hooks.unqueued++;anim.always(function(){anim.always(function(){hooks.unqueued--;if(!jQuery.queue(elem,"fx").length){hooks.empty.fire();}});});}
for(prop in props){value=props[prop];if(rfxtypes.test(value)){delete props[prop];toggle=toggle||value==="toggle";if(value===(hidden?"hide":"show")){if(value==="show"&&dataShow&&dataShow[prop]!==undefined){hidden=true;}else{continue;}}
orig[prop]=dataShow&&dataShow[prop]||jQuery.style(elem,prop);}}
propTween=!jQuery.isEmptyObject(props);if(!propTween&&jQuery.isEmptyObject(orig)){return;}
if(isBox&&elem.nodeType===1){opts.overflow=[style.overflow,style.overflowX,style.overflowY];restoreDisplay=dataShow&&dataShow.display;if(restoreDisplay==null){restoreDisplay=dataPriv.get(elem,"display");}
display=jQuery.css(elem,"display");if(display==="none"){if(restoreDisplay){display=restoreDisplay;}else{showHide([elem],true);restoreDisplay=elem.style.display||restoreDisplay;display=jQuery.css(elem,"display");showHide([elem]);}}
if(display==="inline"||display==="inline-block"&&restoreDisplay!=null){if(jQuery.css(elem,"float")==="none"){if(!propTween){anim.done(function(){style.display=restoreDisplay;});if(restoreDisplay==null){display=style.display;restoreDisplay=display==="none"?"":display;}}
style.display="inline-block";}}}
if(opts.overflow){style.overflow="hidden";anim.always(function(){style.overflow=opts.overflow[0];style.overflowX=opts.overflow[1];style.overflowY=opts.overflow[2];});}
propTween=false;for(prop in orig){if(!propTween){if(dataShow){if("hidden"in dataShow){hidden=dataShow.hidden;}}else{dataShow=dataPriv.access(elem,"fxshow",{display:restoreDisplay});}
if(toggle){dataShow.hidden=!hidden;}
if(hidden){showHide([elem],true);}
anim.done(function(){if(!hidden){showHide([elem]);}
dataPriv.remove(elem,"fxshow");for(prop in orig){jQuery.style(elem,prop,orig[prop]);}});}
propTween=createTween(hidden?dataShow[prop]:0,prop,anim);if(!(prop in dataShow)){dataShow[prop]=propTween.start;if(hidden){propTween.end=propTween.start;propTween.start=0;}}}}
function propFilter(props,specialEasing){var index,name,easing,value,hooks;for(index in props){name=camelCase(index);easing=specialEasing[name];value=props[index];if(Array.isArray(value)){easing=value[1];value=props[index]=value[0];}
if(index!==name){props[name]=value;delete props[index];}
hooks=jQuery.cssHooks[name];if(hooks&&"expand"in hooks){value=hooks.expand(value);delete props[name];for(index in value){if(!(index in props)){props[index]=value[index];specialEasing[index]=easing;}}}else{specialEasing[name]=easing;}}}
function Animation(elem,properties,options){var result,stopped,index=0,length=Animation.prefilters.length,deferred=jQuery.Deferred().always(function(){delete tick.elem;}),tick=function(){if(stopped){return false;}
var currentTime=fxNow||createFxNow(),remaining=Math.max(0,animation.startTime+animation.duration-currentTime),temp=remaining/animation.duration||0,percent=1-temp,index=0,length=animation.tweens.length;for(;index<length;index++){animation.tweens[index].run(percent);}
deferred.notifyWith(elem,[animation,percent,remaining]);if(percent<1&&length){return remaining;}
if(!length){deferred.notifyWith(elem,[animation,1,0]);}
deferred.resolveWith(elem,[animation]);return false;},animation=deferred.promise({elem:elem,props:jQuery.extend({},properties),opts:jQuery.extend(true,{specialEasing:{},easing:jQuery.easing._default},options),originalProperties:properties,originalOptions:options,startTime:fxNow||createFxNow(),duration:options.duration,tweens:[],createTween:function(prop,end){var tween=jQuery.Tween(elem,animation.opts,prop,end,animation.opts.specialEasing[prop]||animation.opts.easing);animation.tweens.push(tween);return tween;},stop:function(gotoEnd){var index=0,length=gotoEnd?animation.tweens.length:0;if(stopped){return this;}
stopped=true;for(;index<length;index++){animation.tweens[index].run(1);}
if(gotoEnd){deferred.notifyWith(elem,[animation,1,0]);deferred.resolveWith(elem,[animation,gotoEnd]);}else{deferred.rejectWith(elem,[animation,gotoEnd]);}
return this;}}),props=animation.props;propFilter(props,animation.opts.specialEasing);for(;index<length;index++){result=Animation.prefilters[index].call(animation,elem,props,animation.opts);if(result){if(isFunction(result.stop)){jQuery._queueHooks(animation.elem,animation.opts.queue).stop=result.stop.bind(result);}
return result;}}
jQuery.map(props,createTween,animation);if(isFunction(animation.opts.start)){animation.opts.start.call(elem,animation);}
animation.progress(animation.opts.progress).done(animation.opts.done,animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);jQuery.fx.timer(jQuery.extend(tick,{elem:elem,anim:animation,queue:animation.opts.queue}));return animation;}
jQuery.Animation=jQuery.extend(Animation,{tweeners:{"*":[function(prop,value){var tween=this.createTween(prop,value);adjustCSS(tween.elem,prop,rcssNum.exec(value),tween);return tween;}]},tweener:function(props,callback){if(isFunction(props)){callback=props;props=["*"];}else{props=props.match(rnothtmlwhite);}
var prop,index=0,length=props.length;for(;index<length;index++){prop=props[index];Animation.tweeners[prop]=Animation.tweeners[prop]||[];Animation.tweeners[prop].unshift(callback);}},prefilters:[defaultPrefilter],prefilter:function(callback,prepend){if(prepend){Animation.prefilters.unshift(callback);}else{Animation.prefilters.push(callback);}}});jQuery.speed=function(speed,easing,fn){var opt=speed&&typeof speed==="object"?jQuery.extend({},speed):{complete:fn||!fn&&easing||isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!isFunction(easing)&&easing};if(jQuery.fx.off){opt.duration=0;}else{if(typeof opt.duration!=="number"){if(opt.duration in jQuery.fx.speeds){opt.duration=jQuery.fx.speeds[opt.duration];}else{opt.duration=jQuery.fx.speeds._default;}}}
if(opt.queue==null||opt.queue===true){opt.queue="fx";}
opt.old=opt.complete;opt.complete=function(){if(isFunction(opt.old)){opt.old.call(this);}
if(opt.queue){jQuery.dequeue(this,opt.queue);}};return opt;};jQuery.fn.extend({fadeTo:function(speed,to,easing,callback){return this.filter(isHiddenWithinTree).css("opacity",0).show()
.end().animate({opacity:to},speed,easing,callback);},animate:function(prop,speed,easing,callback){var empty=jQuery.isEmptyObject(prop),optall=jQuery.speed(speed,easing,callback),doAnimation=function(){var anim=Animation(this,jQuery.extend({},prop),optall);if(empty||dataPriv.get(this,"finish")){anim.stop(true);}};doAnimation.finish=doAnimation;return empty||optall.queue===false?this.each(doAnimation):this.queue(optall.queue,doAnimation);},stop:function(type,clearQueue,gotoEnd){var stopQueue=function(hooks){var stop=hooks.stop;delete hooks.stop;stop(gotoEnd);};if(typeof type!=="string"){gotoEnd=clearQueue;clearQueue=type;type=undefined;}
if(clearQueue){this.queue(type||"fx",[]);}
return this.each(function(){var dequeue=true,index=type!=null&&type+"queueHooks",timers=jQuery.timers,data=dataPriv.get(this);if(index){if(data[index]&&data[index].stop){stopQueue(data[index]);}}else{for(index in data){if(data[index]&&data[index].stop&&rrun.test(index)){stopQueue(data[index]);}}}
for(index=timers.length;index--;){if(timers[index].elem===this&&(type==null||timers[index].queue===type)){timers[index].anim.stop(gotoEnd);dequeue=false;timers.splice(index,1);}}
if(dequeue||!gotoEnd){jQuery.dequeue(this,type);}});},finish:function(type){if(type!==false){type=type||"fx";}
return this.each(function(){var index,data=dataPriv.get(this),queue=data[type+"queue"],hooks=data[type+"queueHooks"],timers=jQuery.timers,length=queue?queue.length:0;data.finish=true;jQuery.queue(this,type,[]);if(hooks&&hooks.stop){hooks.stop.call(this,true);}
for(index=timers.length;index--;){if(timers[index].elem===this&&timers[index].queue===type){timers[index].anim.stop(true);timers.splice(index,1);}}
for(index=0;index<length;index++){if(queue[index]&&queue[index].finish){queue[index].finish.call(this);}}
delete data.finish;});}});jQuery.each(["toggle","show","hide"],function(_i,name){var cssFn=jQuery.fn[name];jQuery.fn[name]=function(speed,easing,callback){return speed==null||typeof speed==="boolean"?cssFn.apply(this,arguments):this.animate(genFx(name,true),speed,easing,callback);};});jQuery.each({slideDown:genFx("show"),slideUp:genFx("hide"),slideToggle:genFx("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback);};});jQuery.timers=[];jQuery.fx.tick=function(){var timer,i=0,timers=jQuery.timers;fxNow=Date.now();for(;i<timers.length;i++){timer=timers[i];if(!timer()&&timers[i]===timer){timers.splice(i--,1);}}
if(!timers.length){jQuery.fx.stop();}
fxNow=undefined;};jQuery.fx.timer=function(timer){jQuery.timers.push(timer);jQuery.fx.start();};jQuery.fx.interval=13;jQuery.fx.start=function(){if(inProgress){return;}
inProgress=true;schedule();};jQuery.fx.stop=function(){inProgress=null;};jQuery.fx.speeds={slow:600,fast:200,_default:400};jQuery.fn.delay=function(time,type){time=jQuery.fx?jQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,function(next,hooks){var timeout=window.setTimeout(next,time);hooks.stop=function(){window.clearTimeout(timeout);};});};(function(){var input=document.createElement("input"),select=document.createElement("select"),opt=select.appendChild(document.createElement("option"));input.type="checkbox";support.checkOn=input.value!=="";support.optSelected=opt.selected;input=document.createElement("input");input.value="t";input.type="radio";support.radioValue=input.value==="t";})();var boolHook,attrHandle=jQuery.expr.attrHandle;jQuery.fn.extend({attr:function(name,value){return access(this,jQuery.attr,name,value,arguments.length>1);},removeAttr:function(name){return this.each(function(){jQuery.removeAttr(this,name);});}});jQuery.extend({attr:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return;}
if(typeof elem.getAttribute==="undefined"){return jQuery.prop(elem,name,value);}
if(nType!==1||!jQuery.isXMLDoc(elem)){hooks=jQuery.attrHooks[name.toLowerCase()]||(jQuery.expr.match.bool.test(name)?boolHook:undefined);}
if(value!==undefined){if(value===null){jQuery.removeAttr(elem,name);return;}
if(hooks&&"set"in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret;}
elem.setAttribute(name,value+"");return value;}
if(hooks&&"get"in hooks&&(ret=hooks.get(elem,name))!==null){return ret;}
ret=jQuery.find.attr(elem,name);return ret==null?undefined:ret;},attrHooks:{type:{set:function(elem,value){if(!support.radioValue&&value==="radio"&&nodeName(elem,"input")){var val=elem.value;elem.setAttribute("type",value);if(val){elem.value=val;}
return value;}}}},removeAttr:function(elem,value){var name,i=0,attrNames=value&&value.match(rnothtmlwhite);if(attrNames&&elem.nodeType===1){while((name=attrNames[i++])){elem.removeAttribute(name);}}}});boolHook={set:function(elem,value,name){if(value===false){jQuery.removeAttr(elem,name);}else{elem.setAttribute(name,name);}
return name;}};jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g),function(_i,name){var getter=attrHandle[name]||jQuery.find.attr;attrHandle[name]=function(elem,name,isXML){var ret,handle,lowercaseName=name.toLowerCase();if(!isXML){handle=attrHandle[lowercaseName];attrHandle[lowercaseName]=ret;ret=getter(elem,name,isXML)!=null?lowercaseName:null;attrHandle[lowercaseName]=handle;}
return ret;};});var rfocusable=/^(?:input|select|textarea|button)$/i,rclickable=/^(?:a|area)$/i;jQuery.fn.extend({prop:function(name,value){return access(this,jQuery.prop,name,value,arguments.length>1);},removeProp:function(name){return this.each(function(){delete this[jQuery.propFix[name]||name];});}});jQuery.extend({prop:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return;}
if(nType!==1||!jQuery.isXMLDoc(elem)){name=jQuery.propFix[name]||name;hooks=jQuery.propHooks[name];}
if(value!==undefined){if(hooks&&"set"in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret;}
return(elem[name]=value);}
if(hooks&&"get"in hooks&&(ret=hooks.get(elem,name))!==null){return ret;}
return elem[name];},propHooks:{tabIndex:{get:function(elem){var tabindex=jQuery.find.attr(elem,"tabindex");if(tabindex){return parseInt(tabindex,10);}
if(rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href){return 0;}
return-1;}}},propFix:{"for":"htmlFor","class":"className"}});if(!support.optSelected){jQuery.propHooks.selected={get:function(elem){var parent=elem.parentNode;if(parent&&parent.parentNode){parent.parentNode.selectedIndex;}
return null;},set:function(elem){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex;}}}};}
jQuery.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){jQuery.propFix[this.toLowerCase()]=this;});function stripAndCollapse(value){var tokens=value.match(rnothtmlwhite)||[];return tokens.join(" ");}
function getClass(elem){return elem.getAttribute&&elem.getAttribute("class")||"";}
function classesToArray(value){if(Array.isArray(value)){return value;}
if(typeof value==="string"){return value.match(rnothtmlwhite)||[];}
return[];}
jQuery.fn.extend({addClass:function(value){var classes,elem,cur,curValue,clazz,j,finalValue,i=0;if(isFunction(value)){return this.each(function(j){jQuery(this).addClass(value.call(this,j,getClass(this)));});}
classes=classesToArray(value);if(classes.length){while((elem=this[i++])){curValue=getClass(elem);cur=elem.nodeType===1&&(" "+stripAndCollapse(curValue)+" ");if(cur){j=0;while((clazz=classes[j++])){if(cur.indexOf(" "+clazz+" ")<0){cur+=clazz+" ";}}
finalValue=stripAndCollapse(cur);if(curValue!==finalValue){elem.setAttribute("class",finalValue);}}}}
return this;},removeClass:function(value){var classes,elem,cur,curValue,clazz,j,finalValue,i=0;if(isFunction(value)){return this.each(function(j){jQuery(this).removeClass(value.call(this,j,getClass(this)));});}
if(!arguments.length){return this.attr("class","");}
classes=classesToArray(value);if(classes.length){while((elem=this[i++])){curValue=getClass(elem);cur=elem.nodeType===1&&(" "+stripAndCollapse(curValue)+" ");if(cur){j=0;while((clazz=classes[j++])){while(cur.indexOf(" "+clazz+" ")>-1){cur=cur.replace(" "+clazz+" "," ");}}
finalValue=stripAndCollapse(cur);if(curValue!==finalValue){elem.setAttribute("class",finalValue);}}}}
return this;},toggleClass:function(value,stateVal){var type=typeof value,isValidValue=type==="string"||Array.isArray(value);if(typeof stateVal==="boolean"&&isValidValue){return stateVal?this.addClass(value):this.removeClass(value);}
if(isFunction(value)){return this.each(function(i){jQuery(this).toggleClass(value.call(this,i,getClass(this),stateVal),stateVal);});}
return this.each(function(){var className,i,self,classNames;if(isValidValue){i=0;self=jQuery(this);classNames=classesToArray(value);while((className=classNames[i++])){if(self.hasClass(className)){self.removeClass(className);}else{self.addClass(className);}}
}else if(value===undefined||type==="boolean"){className=getClass(this);if(className){dataPriv.set(this,"__className__",className);}
if(this.setAttribute){this.setAttribute("class",className||value===false?"":dataPriv.get(this,"__className__")||"");}}});},hasClass:function(selector){var className,elem,i=0;className=" "+selector+" ";while((elem=this[i++])){if(elem.nodeType===1&&(" "+stripAndCollapse(getClass(elem))+" ").indexOf(className)>-1){return true;}}
return false;}});var rreturn=/\r/g;jQuery.fn.extend({val:function(value){var hooks,ret,valueIsFunction,elem=this[0];if(!arguments.length){if(elem){hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()];if(hooks&&"get"in hooks&&(ret=hooks.get(elem,"value"))!==undefined){return ret;}
ret=elem.value;if(typeof ret==="string"){return ret.replace(rreturn,"");}
return ret==null?"":ret;}
return;}
valueIsFunction=isFunction(value);return this.each(function(i){var val;if(this.nodeType!==1){return;}
if(valueIsFunction){val=value.call(this,i,jQuery(this).val());}else{val=value;}
if(val==null){val="";}else if(typeof val==="number"){val+="";}else if(Array.isArray(val)){val=jQuery.map(val,function(value){return value==null?"":value+"";});}
hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!hooks||!("set"in hooks)||hooks.set(this,val,"value")===undefined){this.value=val;}});}});jQuery.extend({valHooks:{option:{get:function(elem){var val=jQuery.find.attr(elem,"value");return val!=null?val:stripAndCollapse(jQuery.text(elem));}},select:{get:function(elem){var value,option,i,options=elem.options,index=elem.selectedIndex,one=elem.type==="select-one",values=one?null:[],max=one?index+1:options.length;if(index<0){i=max;}else{i=one?index:0;}
for(;i<max;i++){option=options[i];if((option.selected||i===index)&&!option.disabled&&(!option.parentNode.disabled||!nodeName(option.parentNode,"optgroup"))){value=jQuery(option).val();if(one){return value;}
values.push(value);}}
return values;},set:function(elem,value){var optionSet,option,options=elem.options,values=jQuery.makeArray(value),i=options.length;while(i--){option=options[i];if(option.selected=jQuery.inArray(jQuery.valHooks.option.get(option),values)>-1){optionSet=true;}
}
if(!optionSet){elem.selectedIndex=-1;}
return values;}}}});jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]={set:function(elem,value){if(Array.isArray(value)){return(elem.checked=jQuery.inArray(jQuery(elem).val(),value)>-1);}}};if(!support.checkOn){jQuery.valHooks[this].get=function(elem){return elem.getAttribute("value")===null?"on":elem.value;};}});support.focusin="onfocusin"in window;var rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,stopPropagationCallback=function(e){e.stopPropagation();};jQuery.extend(jQuery.event,{trigger:function(event,data,elem,onlyHandlers){var i,cur,tmp,bubbleType,ontype,handle,special,lastElement,eventPath=[elem||document],type=hasOwn.call(event,"type")?event.type:event,namespaces=hasOwn.call(event,"namespace")?event.namespace.split("."):[];cur=lastElement=tmp=elem=elem||document;if(elem.nodeType===3||elem.nodeType===8){return;}
if(rfocusMorph.test(type+jQuery.event.triggered)){return;}
if(type.indexOf(".")>-1){namespaces=type.split(".");type=namespaces.shift();namespaces.sort();}
ontype=type.indexOf(":")<0&&"on"+type;event=event[jQuery.expando]?event:new jQuery.Event(type,typeof event==="object"&&event);event.isTrigger=onlyHandlers?2:3;event.namespace=namespaces.join(".");event.rnamespace=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)"):null;event.result=undefined;if(!event.target){event.target=elem;}
data=data==null?[event]:jQuery.makeArray(data,[event]);special=jQuery.event.special[type]||{};if(!onlyHandlers&&special.trigger&&special.trigger.apply(elem,data)===false){return;}
if(!onlyHandlers&&!special.noBubble&&!isWindow(elem)){bubbleType=special.delegateType||type;if(!rfocusMorph.test(bubbleType+type)){cur=cur.parentNode;}
for(;cur;cur=cur.parentNode){eventPath.push(cur);tmp=cur;}
if(tmp===(elem.ownerDocument||document)){eventPath.push(tmp.defaultView||tmp.parentWindow||window);}}
i=0;while((cur=eventPath[i++])&&!event.isPropagationStopped()){lastElement=cur;event.type=i>1?bubbleType:special.bindType||type;handle=(dataPriv.get(cur,"events")||Object.create(null))[event.type]&&dataPriv.get(cur,"handle");if(handle){handle.apply(cur,data);}
handle=ontype&&cur[ontype];if(handle&&handle.apply&&acceptData(cur)){event.result=handle.apply(cur,data);if(event.result===false){event.preventDefault();}}}
event.type=type;if(!onlyHandlers&&!event.isDefaultPrevented()){if((!special._default||special._default.apply(eventPath.pop(),data)===false)&&acceptData(elem)){if(ontype&&isFunction(elem[type])&&!isWindow(elem)){tmp=elem[ontype];if(tmp){elem[ontype]=null;}
jQuery.event.triggered=type;if(event.isPropagationStopped()){lastElement.addEventListener(type,stopPropagationCallback);}
elem[type]();if(event.isPropagationStopped()){lastElement.removeEventListener(type,stopPropagationCallback);}
jQuery.event.triggered=undefined;if(tmp){elem[ontype]=tmp;}}}}
return event.result;},simulate:function(type,elem,event){var e=jQuery.extend(new jQuery.Event(),event,{type:type,isSimulated:true});jQuery.event.trigger(e,null,elem);}});jQuery.fn.extend({trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this);});},triggerHandler:function(type,data){var elem=this[0];if(elem){return jQuery.event.trigger(type,data,elem,true);}}});if(!support.focusin){jQuery.each({focus:"focusin",blur:"focusout"},function(orig,fix){var handler=function(event){jQuery.event.simulate(fix,event.target,jQuery.event.fix(event));};jQuery.event.special[fix]={setup:function(){var doc=this.ownerDocument||this.document||this,attaches=dataPriv.access(doc,fix);if(!attaches){doc.addEventListener(orig,handler,true);}
dataPriv.access(doc,fix,(attaches||0)+1);},teardown:function(){var doc=this.ownerDocument||this.document||this,attaches=dataPriv.access(doc,fix)-1;if(!attaches){doc.removeEventListener(orig,handler,true);dataPriv.remove(doc,fix);}else{dataPriv.access(doc,fix,attaches);}}};});}
var location=window.location;var nonce={guid:Date.now()};var rquery=(/\?/);jQuery.parseXML=function(data){var xml,parserErrorElem;if(!data||typeof data!=="string"){return null;}
try{xml=(new window.DOMParser()).parseFromString(data,"text/xml");}catch(e){}
parserErrorElem=xml&&xml.getElementsByTagName("parsererror")[0];if(!xml||parserErrorElem){jQuery.error("Invalid XML: "+(parserErrorElem?jQuery.map(parserErrorElem.childNodes,function(el){return el.textContent;}).join("\n"):data));}
return xml;};var
rbracket=/\[\]$/,rCRLF=/\r?\n/g,rsubmitterTypes=/^(?:submit|button|image|reset|file)$/i,rsubmittable=/^(?:input|select|textarea|keygen)/i;function buildParams(prefix,obj,traditional,add){var name;if(Array.isArray(obj)){jQuery.each(obj,function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v);}else{buildParams(prefix+"["+(typeof v==="object"&&v!=null?i:"")+"]",v,traditional,add);}});}else if(!traditional&&toType(obj)==="object"){for(name in obj){buildParams(prefix+"["+name+"]",obj[name],traditional,add);}}else{add(prefix,obj);}}
jQuery.param=function(a,traditional){var prefix,s=[],add=function(key,valueOrFunction){var value=isFunction(valueOrFunction)?valueOrFunction():valueOrFunction;s[s.length]=encodeURIComponent(key)+"="+
encodeURIComponent(value==null?"":value);};if(a==null){return"";}
if(Array.isArray(a)||(a.jquery&&!jQuery.isPlainObject(a))){jQuery.each(a,function(){add(this.name,this.value);});}else{for(prefix in a){buildParams(prefix,a[prefix],traditional,add);}}
return s.join("&");};jQuery.fn.extend({serialize:function(){return jQuery.param(this.serializeArray());},serializeArray:function(){return this.map(function(){var elements=jQuery.prop(this,"elements");return elements?jQuery.makeArray(elements):this;}).filter(function(){var type=this.type;return this.name&&!jQuery(this).is(":disabled")&&rsubmittable.test(this.nodeName)&&!rsubmitterTypes.test(type)&&(this.checked||!rcheckableType.test(type));}).map(function(_i,elem){var val=jQuery(this).val();if(val==null){return null;}
if(Array.isArray(val)){return jQuery.map(val,function(val){return{name:elem.name,value:val.replace(rCRLF,"\r\n")};});}
return{name:elem.name,value:val.replace(rCRLF,"\r\n")};}).get();}});var
r20=/%20/g,rhash=/#.*$/,rantiCache=/([?&])_=[^&]*/,rheaders=/^(.*?):[ \t]*([^\r\n]*)$/mg,rlocalProtocol=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,prefilters={},transports={},allTypes="*/".concat("*"),originAnchor=document.createElement("a");originAnchor.href=location.href;function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*";}
var dataType,i=0,dataTypes=dataTypeExpression.toLowerCase().match(rnothtmlwhite)||[];if(isFunction(func)){while((dataType=dataTypes[i++])){if(dataType[0]==="+"){dataType=dataType.slice(1)||"*";(structure[dataType]=structure[dataType]||[]).unshift(func);}else{(structure[dataType]=structure[dataType]||[]).push(func);}}}};}
function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR){var inspected={},seekingTransport=(structure===transports);function inspect(dataType){var selected;inspected[dataType]=true;jQuery.each(structure[dataType]||[],function(_,prefilterOrFactory){var dataTypeOrTransport=prefilterOrFactory(options,originalOptions,jqXHR);if(typeof dataTypeOrTransport==="string"&&!seekingTransport&&!inspected[dataTypeOrTransport]){options.dataTypes.unshift(dataTypeOrTransport);inspect(dataTypeOrTransport);return false;}else if(seekingTransport){return!(selected=dataTypeOrTransport);}});return selected;}
return inspect(options.dataTypes[0])||!inspected["*"]&&inspect("*");}
function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src){if(src[key]!==undefined){(flatOptions[key]?target:(deep||(deep={})))[key]=src[key];}}
if(deep){jQuery.extend(true,target,deep);}
return target;}
function ajaxHandleResponses(s,jqXHR,responses){var ct,type,finalDataType,firstDataType,contents=s.contents,dataTypes=s.dataTypes;while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=s.mimeType||jqXHR.getResponseHeader("Content-Type");}}
if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break;}}}
if(dataTypes[0]in responses){finalDataType=dataTypes[0];}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break;}
if(!firstDataType){firstDataType=type;}}
finalDataType=finalDataType||firstDataType;}
if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType);}
return responses[finalDataType];}}
function ajaxConvert(s,response,jqXHR,isSuccess){var conv2,current,conv,tmp,prev,converters={},dataTypes=s.dataTypes.slice();if(dataTypes[1]){for(conv in s.converters){converters[conv.toLowerCase()]=s.converters[conv];}}
current=dataTypes.shift();while(current){if(s.responseFields[current]){jqXHR[s.responseFields[current]]=response;}
if(!prev&&isSuccess&&s.dataFilter){response=s.dataFilter(response,s.dataType);}
prev=current;current=dataTypes.shift();if(current){if(current==="*"){current=prev;}else if(prev!=="*"&&prev!==current){conv=converters[prev+" "+current]||converters["* "+current];if(!conv){for(conv2 in converters){tmp=conv2.split(" ");if(tmp[1]===current){conv=converters[prev+" "+tmp[0]]||converters["* "+tmp[0]];if(conv){if(conv===true){conv=converters[conv2];}else if(converters[conv2]!==true){current=tmp[0];dataTypes.unshift(tmp[1]);}
break;}}}}
if(conv!==true){if(conv&&s.throws){response=conv(response);}else{try{response=conv(response);}catch(e){return{state:"parsererror",error:conv?e:"No conversion from "+prev+" to "+current};}}}}}}
return{state:"success",data:response};}
jQuery.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:location.href,type:"GET",isLocal:rlocalProtocol.test(location.protocol),global:true,processData:true,async:true,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":allTypes,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":true,"text json":JSON.parse,"text xml":jQuery.parseXML},flatOptions:{url:true,context:true}},ajaxSetup:function(target,settings){return settings?ajaxExtend(ajaxExtend(target,jQuery.ajaxSettings),settings):ajaxExtend(jQuery.ajaxSettings,target);},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof url==="object"){options=url;url=undefined;}
options=options||{};var transport,cacheURL,responseHeadersString,responseHeaders,timeoutTimer,urlAnchor,completed,fireGlobals,i,uncached,s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=s.context&&(callbackContext.nodeType||callbackContext.jquery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},requestHeaders={},requestHeadersNames={},strAbort="canceled",jqXHR={readyState:0,getResponseHeader:function(key){var match;if(completed){if(!responseHeaders){responseHeaders={};while((match=rheaders.exec(responseHeadersString))){responseHeaders[match[1].toLowerCase()+" "]=(responseHeaders[match[1].toLowerCase()+" "]||[]).concat(match[2]);}}
match=responseHeaders[key.toLowerCase()+" "];}
return match==null?null:match.join(", ");},getAllResponseHeaders:function(){return completed?responseHeadersString:null;},setRequestHeader:function(name,value){if(completed==null){name=requestHeadersNames[name.toLowerCase()]=requestHeadersNames[name.toLowerCase()]||name;requestHeaders[name]=value;}
return this;},overrideMimeType:function(type){if(completed==null){s.mimeType=type;}
return this;},statusCode:function(map){var code;if(map){if(completed){jqXHR.always(map[jqXHR.status]);}else{for(code in map){statusCode[code]=[statusCode[code],map[code]];}}}
return this;},abort:function(statusText){var finalText=statusText||strAbort;if(transport){transport.abort(finalText);}
done(0,finalText);return this;}};deferred.promise(jqXHR);s.url=((url||s.url||location.href)+"").replace(rprotocol,location.protocol+"//");s.type=options.method||options.type||s.method||s.type;s.dataTypes=(s.dataType||"*").toLowerCase().match(rnothtmlwhite)||[""];if(s.crossDomain==null){urlAnchor=document.createElement("a");try{urlAnchor.href=s.url;urlAnchor.href=urlAnchor.href;s.crossDomain=originAnchor.protocol+"//"+originAnchor.host!==urlAnchor.protocol+"//"+urlAnchor.host;}catch(e){s.crossDomain=true;}}
if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data,s.traditional);}
inspectPrefiltersOrTransports(prefilters,s,options,jqXHR);if(completed){return jqXHR;}
fireGlobals=jQuery.event&&s.global;if(fireGlobals&&jQuery.active++===0){jQuery.event.trigger("ajaxStart");}
s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);cacheURL=s.url.replace(rhash,"");if(!s.hasContent){uncached=s.url.slice(cacheURL.length);if(s.data&&(s.processData||typeof s.data==="string")){cacheURL+=(rquery.test(cacheURL)?"&":"?")+s.data;delete s.data;}
if(s.cache===false){cacheURL=cacheURL.replace(rantiCache,"$1");uncached=(rquery.test(cacheURL)?"&":"?")+"_="+(nonce.guid++)+
uncached;}
s.url=cacheURL+uncached;}else if(s.data&&s.processData&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0){s.data=s.data.replace(r20,"+");}
if(s.ifModified){if(jQuery.lastModified[cacheURL]){jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[cacheURL]);}
if(jQuery.etag[cacheURL]){jqXHR.setRequestHeader("If-None-Match",jQuery.etag[cacheURL]);}}
if(s.data&&s.hasContent&&s.contentType!==false||options.contentType){jqXHR.setRequestHeader("Content-Type",s.contentType);}
jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+
(s.dataTypes[0]!=="*"?", "+allTypes+"; q=0.01":""):s.accepts["*"]);for(i in s.headers){jqXHR.setRequestHeader(i,s.headers[i]);}
if(s.beforeSend&&(s.beforeSend.call(callbackContext,jqXHR,s)===false||completed)){return jqXHR.abort();}
strAbort="abort";completeDeferred.add(s.complete);jqXHR.done(s.success);jqXHR.fail(s.error);transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR);if(!transport){done(-1,"No Transport");}else{jqXHR.readyState=1;if(fireGlobals){globalEventContext.trigger("ajaxSend",[jqXHR,s]);}
if(completed){return jqXHR;}
if(s.async&&s.timeout>0){timeoutTimer=window.setTimeout(function(){jqXHR.abort("timeout");},s.timeout);}
try{completed=false;transport.send(requestHeaders,done);}catch(e){if(completed){throw e;}
done(-1,e);}}
function done(status,nativeStatusText,responses,headers){var isSuccess,success,error,response,modified,statusText=nativeStatusText;if(completed){return;}
completed=true;if(timeoutTimer){window.clearTimeout(timeoutTimer);}
transport=undefined;responseHeadersString=headers||"";jqXHR.readyState=status>0?4:0;isSuccess=status>=200&&status<300||status===304;if(responses){response=ajaxHandleResponses(s,jqXHR,responses);}
if(!isSuccess&&jQuery.inArray("script",s.dataTypes)>-1&&jQuery.inArray("json",s.dataTypes)<0){s.converters["text script"]=function(){};}
response=ajaxConvert(s,response,jqXHR,isSuccess);if(isSuccess){if(s.ifModified){modified=jqXHR.getResponseHeader("Last-Modified");if(modified){jQuery.lastModified[cacheURL]=modified;}
modified=jqXHR.getResponseHeader("etag");if(modified){jQuery.etag[cacheURL]=modified;}}
if(status===204||s.type==="HEAD"){statusText="nocontent";}else if(status===304){statusText="notmodified";}else{statusText=response.state;success=response.data;error=response.error;isSuccess=!error;}}else{error=statusText;if(status||!statusText){statusText="error";if(status<0){status=0;}}}
jqXHR.status=status;jqXHR.statusText=(nativeStatusText||statusText)+"";if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jqXHR]);}else{deferred.rejectWith(callbackContext,[jqXHR,statusText,error]);}
jqXHR.statusCode(statusCode);statusCode=undefined;if(fireGlobals){globalEventContext.trigger(isSuccess?"ajaxSuccess":"ajaxError",[jqXHR,s,isSuccess?success:error]);}
completeDeferred.fireWith(callbackContext,[jqXHR,statusText]);if(fireGlobals){globalEventContext.trigger("ajaxComplete",[jqXHR,s]);if(!(--jQuery.active)){jQuery.event.trigger("ajaxStop");}}}
return jqXHR;},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json");},getScript:function(url,callback){return jQuery.get(url,undefined,callback,"script");}});jQuery.each(["get","post"],function(_i,method){jQuery[method]=function(url,data,callback,type){if(isFunction(data)){type=type||callback;callback=data;data=undefined;}
return jQuery.ajax(jQuery.extend({url:url,type:method,dataType:type,data:data,success:callback},jQuery.isPlainObject(url)&&url));};});jQuery.ajaxPrefilter(function(s){var i;for(i in s.headers){if(i.toLowerCase()==="content-type"){s.contentType=s.headers[i]||"";}}});jQuery._evalUrl=function(url,options,doc){return jQuery.ajax({url:url,type:"GET",dataType:"script",cache:true,async:false,global:false,converters:{"text script":function(){}},dataFilter:function(response){jQuery.globalEval(response,options,doc);}});};jQuery.fn.extend({wrapAll:function(html){var wrap;if(this[0]){if(isFunction(html)){html=html.call(this[0]);}
wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(true);if(this[0].parentNode){wrap.insertBefore(this[0]);}
wrap.map(function(){var elem=this;while(elem.firstElementChild){elem=elem.firstElementChild;}
return elem;}).append(this);}
return this;},wrapInner:function(html){if(isFunction(html)){return this.each(function(i){jQuery(this).wrapInner(html.call(this,i));});}
return this.each(function(){var self=jQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html);}else{self.append(html);}});},wrap:function(html){var htmlIsFunction=isFunction(html);return this.each(function(i){jQuery(this).wrapAll(htmlIsFunction?html.call(this,i):html);});},unwrap:function(selector){this.parent(selector).not("body").each(function(){jQuery(this).replaceWith(this.childNodes);});return this;}});jQuery.expr.pseudos.hidden=function(elem){return!jQuery.expr.pseudos.visible(elem);};jQuery.expr.pseudos.visible=function(elem){return!!(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length);};jQuery.ajaxSettings.xhr=function(){try{return new window.XMLHttpRequest();}catch(e){}};var xhrSuccessStatus={0:200,1223:204},xhrSupported=jQuery.ajaxSettings.xhr();support.cors=!!xhrSupported&&("withCredentials"in xhrSupported);support.ajax=xhrSupported=!!xhrSupported;jQuery.ajaxTransport(function(options){var callback,errorCallback;if(support.cors||xhrSupported&&!options.crossDomain){return{send:function(headers,complete){var i,xhr=options.xhr();xhr.open(options.type,options.url,options.async,options.username,options.password);if(options.xhrFields){for(i in options.xhrFields){xhr[i]=options.xhrFields[i];}}
if(options.mimeType&&xhr.overrideMimeType){xhr.overrideMimeType(options.mimeType);}
if(!options.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest";}
for(i in headers){xhr.setRequestHeader(i,headers[i]);}
callback=function(type){return function(){if(callback){callback=errorCallback=xhr.onload=xhr.onerror=xhr.onabort=xhr.ontimeout=xhr.onreadystatechange=null;if(type==="abort"){xhr.abort();}else if(type==="error"){if(typeof xhr.status!=="number"){complete(0,"error");}else{complete(xhr.status,xhr.statusText);}}else{complete(xhrSuccessStatus[xhr.status]||xhr.status,xhr.statusText,(xhr.responseType||"text")!=="text"||typeof xhr.responseText!=="string"?{binary:xhr.response}:{text:xhr.responseText},xhr.getAllResponseHeaders());}}};};xhr.onload=callback();errorCallback=xhr.onerror=xhr.ontimeout=callback("error");if(xhr.onabort!==undefined){xhr.onabort=errorCallback;}else{xhr.onreadystatechange=function(){if(xhr.readyState===4){window.setTimeout(function(){if(callback){errorCallback();}});}};}
callback=callback("abort");try{xhr.send(options.hasContent&&options.data||null);}catch(e){if(callback){throw e;}}},abort:function(){if(callback){callback();}}};}});jQuery.ajaxPrefilter(function(s){if(s.crossDomain){s.contents.script=false;}});jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, "+
"application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(text){jQuery.globalEval(text);return text;}}});jQuery.ajaxPrefilter("script",function(s){if(s.cache===undefined){s.cache=false;}
if(s.crossDomain){s.type="GET";}});jQuery.ajaxTransport("script",function(s){if(s.crossDomain||s.scriptAttrs){var script,callback;return{send:function(_,complete){script=jQuery("<script>").attr(s.scriptAttrs||{}).prop({charset:s.scriptCharset,src:s.url}).on("load error",callback=function(evt){script.remove();callback=null;if(evt){complete(evt.type==="error"?404:200,evt.type);}});document.head.appendChild(script[0]);},abort:function(){if(callback){callback();}}};}});var oldCallbacks=[],rjsonp=/(=)\?(?=&|$)|\?\?/;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var callback=oldCallbacks.pop()||(jQuery.expando+"_"+(nonce.guid++));this[callback]=true;return callback;}});jQuery.ajaxPrefilter("json jsonp",function(s,originalSettings,jqXHR){var callbackName,overwritten,responseContainer,jsonProp=s.jsonp!==false&&(rjsonp.test(s.url)?"url":typeof s.data==="string"&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0&&rjsonp.test(s.data)&&"data");if(jsonProp||s.dataTypes[0]==="jsonp"){callbackName=s.jsonpCallback=isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback;if(jsonProp){s[jsonProp]=s[jsonProp].replace(rjsonp,"$1"+callbackName);}else if(s.jsonp!==false){s.url+=(rquery.test(s.url)?"&":"?")+s.jsonp+"="+callbackName;}
s.converters["script json"]=function(){if(!responseContainer){jQuery.error(callbackName+" was not called");}
return responseContainer[0];};s.dataTypes[0]="json";overwritten=window[callbackName];window[callbackName]=function(){responseContainer=arguments;};jqXHR.always(function(){if(overwritten===undefined){jQuery(window).removeProp(callbackName);}else{window[callbackName]=overwritten;}
if(s[callbackName]){s.jsonpCallback=originalSettings.jsonpCallback;oldCallbacks.push(callbackName);}
if(responseContainer&&isFunction(overwritten)){overwritten(responseContainer[0]);}
responseContainer=overwritten=undefined;});return"script";}});support.createHTMLDocument=(function(){var body=document.implementation.createHTMLDocument("").body;body.innerHTML="<form></form><form></form>";return body.childNodes.length===2;})();jQuery.parseHTML=function(data,context,keepScripts){if(typeof data!=="string"){return[];}
if(typeof context==="boolean"){keepScripts=context;context=false;}
var base,parsed,scripts;if(!context){if(support.createHTMLDocument){context=document.implementation.createHTMLDocument("");base=context.createElement("base");base.href=document.location.href;context.head.appendChild(base);}else{context=document;}}
parsed=rsingleTag.exec(data);scripts=!keepScripts&&[];if(parsed){return[context.createElement(parsed[1])];}
parsed=buildFragment([data],context,scripts);if(scripts&&scripts.length){jQuery(scripts).remove();}
return jQuery.merge([],parsed.childNodes);};jQuery.fn.load=function(url,params,callback){var selector,type,response,self=this,off=url.indexOf(" ");if(off>-1){selector=stripAndCollapse(url.slice(off));url=url.slice(0,off);}
if(isFunction(params)){callback=params;params=undefined;}else if(params&&typeof params==="object"){type="POST";}
if(self.length>0){jQuery.ajax({url:url,type:type||"GET",dataType:"html",data:params}).done(function(responseText){response=arguments;self.html(selector?jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector):responseText);}).always(callback&&function(jqXHR,status){self.each(function(){callback.apply(this,response||[jqXHR.responseText,status,jqXHR]);});});}
return this;};jQuery.expr.pseudos.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem;}).length;};jQuery.offset={setOffset:function(elem,options,i){var curPosition,curLeft,curCSSTop,curTop,curOffset,curCSSLeft,calculatePosition,position=jQuery.css(elem,"position"),curElem=jQuery(elem),props={};if(position==="static"){elem.style.position="relative";}
curOffset=curElem.offset();curCSSTop=jQuery.css(elem,"top");curCSSLeft=jQuery.css(elem,"left");calculatePosition=(position==="absolute"||position==="fixed")&&(curCSSTop+curCSSLeft).indexOf("auto")>-1;if(calculatePosition){curPosition=curElem.position();curTop=curPosition.top;curLeft=curPosition.left;}else{curTop=parseFloat(curCSSTop)||0;curLeft=parseFloat(curCSSLeft)||0;}
if(isFunction(options)){options=options.call(elem,i,jQuery.extend({},curOffset));}
if(options.top!=null){props.top=(options.top-curOffset.top)+curTop;}
if(options.left!=null){props.left=(options.left-curOffset.left)+curLeft;}
if("using"in options){options.using.call(elem,props);}else{curElem.css(props);}}};jQuery.fn.extend({offset:function(options){if(arguments.length){return options===undefined?this:this.each(function(i){jQuery.offset.setOffset(this,options,i);});}
var rect,win,elem=this[0];if(!elem){return;}
if(!elem.getClientRects().length){return{top:0,left:0};}
rect=elem.getBoundingClientRect();win=elem.ownerDocument.defaultView;return{top:rect.top+win.pageYOffset,left:rect.left+win.pageXOffset};},position:function(){if(!this[0]){return;}
var offsetParent,offset,doc,elem=this[0],parentOffset={top:0,left:0};if(jQuery.css(elem,"position")==="fixed"){offset=elem.getBoundingClientRect();}else{offset=this.offset();doc=elem.ownerDocument;offsetParent=elem.offsetParent||doc.documentElement;while(offsetParent&&(offsetParent===doc.body||offsetParent===doc.documentElement)&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.parentNode;}
if(offsetParent&&offsetParent!==elem&&offsetParent.nodeType===1){parentOffset=jQuery(offsetParent).offset();parentOffset.top+=jQuery.css(offsetParent,"borderTopWidth",true);parentOffset.left+=jQuery.css(offsetParent,"borderLeftWidth",true);}}
return{top:offset.top-parentOffset.top-jQuery.css(elem,"marginTop",true),left:offset.left-parentOffset.left-jQuery.css(elem,"marginLeft",true)};},offsetParent:function(){return this.map(function(){var offsetParent=this.offsetParent;while(offsetParent&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.offsetParent;}
return offsetParent||documentElement;});}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(method,prop){var top="pageYOffset"===prop;jQuery.fn[method]=function(val){return access(this,function(elem,method,val){var win;if(isWindow(elem)){win=elem;}else if(elem.nodeType===9){win=elem.defaultView;}
if(val===undefined){return win?win[prop]:elem[method];}
if(win){win.scrollTo(!top?val:win.pageXOffset,top?val:win.pageYOffset);}else{elem[method]=val;}},method,val,arguments.length);};});jQuery.each(["top","left"],function(_i,prop){jQuery.cssHooks[prop]=addGetHookIf(support.pixelPosition,function(elem,computed){if(computed){computed=curCSS(elem,prop);return rnumnonpx.test(computed)?jQuery(elem).position()[prop]+"px":computed;}});});jQuery.each({Height:"height",Width:"width"},function(name,type){jQuery.each({padding:"inner"+name,content:type,"":"outer"+name},function(defaultExtra,funcName){jQuery.fn[funcName]=function(margin,value){var chainable=arguments.length&&(defaultExtra||typeof margin!=="boolean"),extra=defaultExtra||(margin===true||value===true?"margin":"border");return access(this,function(elem,type,value){var doc;if(isWindow(elem)){return funcName.indexOf("outer")===0?elem["inner"+name]:elem.document.documentElement["client"+name];}
if(elem.nodeType===9){doc=elem.documentElement;return Math.max(elem.body["scroll"+name],doc["scroll"+name],elem.body["offset"+name],doc["offset"+name],doc["client"+name]);}
return value===undefined?jQuery.css(elem,type,extra):jQuery.style(elem,type,value,extra);},type,chainable?margin:undefined,chainable);};});});jQuery.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(_i,type){jQuery.fn[type]=function(fn){return this.on(type,fn);};});jQuery.fn.extend({bind:function(types,data,fn){return this.on(types,null,data,fn);},unbind:function(types,fn){return this.off(types,null,fn);},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn);},undelegate:function(selector,types,fn){return arguments.length===1?this.off(selector,"**"):this.off(types,selector||"**",fn);},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut||fnOver);}});jQuery.each(("blur focus focusin focusout resize scroll click dblclick "+
"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+
"change select submit keydown keypress keyup contextmenu").split(" "),function(_i,name){jQuery.fn[name]=function(data,fn){return arguments.length>0?this.on(name,null,data,fn):this.trigger(name);};});var rtrim=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;jQuery.proxy=function(fn,context){var tmp,args,proxy;if(typeof context==="string"){tmp=fn[context];context=fn;fn=tmp;}
if(!isFunction(fn)){return undefined;}
args=slice.call(arguments,2);proxy=function(){return fn.apply(context||this,args.concat(slice.call(arguments)));};proxy.guid=fn.guid=fn.guid||jQuery.guid++;return proxy;};jQuery.holdReady=function(hold){if(hold){jQuery.readyWait++;}else{jQuery.ready(true);}};jQuery.isArray=Array.isArray;jQuery.parseJSON=JSON.parse;jQuery.nodeName=nodeName;jQuery.isFunction=isFunction;jQuery.isWindow=isWindow;jQuery.camelCase=camelCase;jQuery.type=toType;jQuery.now=Date.now;jQuery.isNumeric=function(obj){var type=jQuery.type(obj);return(type==="number"||type==="string")&&!isNaN(obj-parseFloat(obj));};jQuery.trim=function(text){return text==null?"":(text+"").replace(rtrim,"");};if(typeof define==="function"&&define.amd){define("jquery",[],function(){return jQuery;});}
var
_jQuery=window.jQuery,_$=window.$;jQuery.noConflict=function(deep){if(window.$===jQuery){window.$=_$;}
if(deep&&window.jQuery===jQuery){window.jQuery=_jQuery;}
return jQuery;};if(typeof noGlobal==="undefined"){window.jQuery=window.$=jQuery;}
return jQuery;});/*! jQuery UI - v1.12.1 - 2016-09-14
* http://jqueryui.com
* Includes: widget.js, position.js, data.js, disable-selection.js, effect.js, effects/effect-blind.js, effects/effect-bounce.js, effects/effect-clip.js, effects/effect-drop.js, effects/effect-explode.js, effects/effect-fade.js, effects/effect-fold.js, effects/effect-highlight.js, effects/effect-puff.js, effects/effect-pulsate.js, effects/effect-scale.js, effects/effect-shake.js, effects/effect-size.js, effects/effect-slide.js, effects/effect-transfer.js, focusable.js, form-reset-mixin.js, jquery-1-7.js, keycode.js, labels.js, scroll-parent.js, tabbable.js, unique-id.js, widgets/accordion.js, widgets/autocomplete.js, widgets/button.js, widgets/checkboxradio.js, widgets/controlgroup.js, widgets/datepicker.js, widgets/dialog.js, widgets/draggable.js, widgets/droppable.js, widgets/menu.js, widgets/mouse.js, widgets/progressbar.js, widgets/resizable.js, widgets/selectable.js, widgets/selectmenu.js, widgets/slider.js, widgets/sortable.js, widgets/spinner.js, widgets/tabs.js, widgets/tooltip.js
* Copyright jQuery Foundation and other contributors; Licensed MIT */
(function(t){"function"==typeof define&&define.amd?define(["jquery"],t):t(jQuery)})(function(t){function e(t){for(var e=t.css("visibility");"inherit"===e;)t=t.parent(),e=t.css("visibility");return"hidden"!==e}function i(t){for(var e,i;t.length&&t[0]!==document;){if(e=t.css("position"),("absolute"===e||"relative"===e||"fixed"===e)&&(i=parseInt(t.css("zIndex"),10),!isNaN(i)&&0!==i))return i;t=t.parent()}return 0}function s(){this._curInst=null,this._keyEvent=!1,this._disabledInputs=[],this._datepickerShowing=!1,this._inDialog=!1,this._mainDivId="ui-datepicker-div",this._inlineClass="ui-datepicker-inline",this._appendClass="ui-datepicker-append",this._triggerClass="ui-datepicker-trigger",this._dialogClass="ui-datepicker-dialog",this._disableClass="ui-datepicker-disabled",this._unselectableClass="ui-datepicker-unselectable",this._currentClass="ui-datepicker-current-day",this._dayOverClass="ui-datepicker-days-cell-over",this.regional=[],this.regional[""]={closeText:"Done",prevText:"Prev",nextText:"Next",currentText:"Today",monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],dayNamesMin:["Su","Mo","Tu","We","Th","Fr","Sa"],weekHeader:"Wk",dateFormat:"mm/dd/yy",firstDay:0,isRTL:!1,showMonthAfterYear:!1,yearSuffix:""},this._defaults={showOn:"focus",showAnim:"fadeIn",showOptions:{},defaultDate:null,appendText:"",buttonText:"...",buttonImage:"",buttonImageOnly:!1,hideIfNoPrevNext:!1,navigationAsDateFormat:!1,gotoCurrent:!1,changeMonth:!1,changeYear:!1,yearRange:"c-10:c+10",showOtherMonths:!1,selectOtherMonths:!1,showWeek:!1,calculateWeek:this.iso8601Week,shortYearCutoff:"+10",minDate:null,maxDate:null,duration:"fast",beforeShowDay:null,beforeShow:null,onSelect:null,onChangeMonthYear:null,onClose:null,numberOfMonths:1,showCurrentAtPos:0,stepMonths:1,stepBigMonths:12,altField:"",altFormat:"",constrainInput:!0,showButtonPanel:!1,autoSize:!1,disabled:!1},t.extend(this._defaults,this.regional[""]),this.regional.en=t.extend(!0,{},this.regional[""]),this.regional["en-US"]=t.extend(!0,{},this.regional.en),this.dpDiv=n(t("<div id='"+this._mainDivId+"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))}function n(e){var i="button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";return e.on("mouseout",i,function(){t(this).removeClass("ui-state-hover"),-1!==this.className.indexOf("ui-datepicker-prev")&&t(this).removeClass("ui-datepicker-prev-hover"),-1!==this.className.indexOf("ui-datepicker-next")&&t(this).removeClass("ui-datepicker-next-hover")}).on("mouseover",i,o)}function o(){t.datepicker._isDisabledDatepicker(m.inline?m.dpDiv.parent()[0]:m.input[0])||(t(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover"),t(this).addClass("ui-state-hover"),-1!==this.className.indexOf("ui-datepicker-prev")&&t(this).addClass("ui-datepicker-prev-hover"),-1!==this.className.indexOf("ui-datepicker-next")&&t(this).addClass("ui-datepicker-next-hover"))}function a(e,i){t.extend(e,i);for(var s in i)null==i[s]&&(e[s]=i[s]);return e}function r(t){return function(){var e=this.element.val();t.apply(this,arguments),this._refresh(),e!==this.element.val()&&this._trigger("change")}}t.ui=t.ui||{},t.ui.version="1.12.1";var h=0,l=Array.prototype.slice;t.cleanData=function(e){return function(i){var s,n,o;for(o=0;null!=(n=i[o]);o++)try{s=t._data(n,"events"),s&&s.remove&&t(n).triggerHandler("remove")}catch(a){}e(i)}}(t.cleanData),t.widget=function(e,i,s){var n,o,a,r={},h=e.split(".")[0];e=e.split(".")[1];var l=h+"-"+e;return s||(s=i,i=t.Widget),t.isArray(s)&&(s=t.extend.apply(null,[{}].concat(s))),t.expr[":"][l.toLowerCase()]=function(e){return!!t.data(e,l)},t[h]=t[h]||{},n=t[h][e],o=t[h][e]=function(t,e){return this._createWidget?(arguments.length&&this._createWidget(t,e),void 0):new o(t,e)},t.extend(o,n,{version:s.version,_proto:t.extend({},s),_childConstructors:[]}),a=new i,a.options=t.widget.extend({},a.options),t.each(s,function(e,s){return t.isFunction(s)?(r[e]=function(){function t(){return i.prototype[e].apply(this,arguments)}function n(t){return i.prototype[e].apply(this,t)}return function(){var e,i=this._super,o=this._superApply;return this._super=t,this._superApply=n,e=s.apply(this,arguments),this._super=i,this._superApply=o,e}}(),void 0):(r[e]=s,void 0)}),o.prototype=t.widget.extend(a,{widgetEventPrefix:n?a.widgetEventPrefix||e:e},r,{constructor:o,namespace:h,widgetName:e,widgetFullName:l}),n?(t.each(n._childConstructors,function(e,i){var s=i.prototype;t.widget(s.namespace+"."+s.widgetName,o,i._proto)}),delete n._childConstructors):i._childConstructors.push(o),t.widget.bridge(e,o),o},t.widget.extend=function(e){for(var i,s,n=l.call(arguments,1),o=0,a=n.length;a>o;o++)for(i in n[o])s=n[o][i],n[o].hasOwnProperty(i)&&void 0!==s&&(e[i]=t.isPlainObject(s)?t.isPlainObject(e[i])?t.widget.extend({},e[i],s):t.widget.extend({},s):s);return e},t.widget.bridge=function(e,i){var s=i.prototype.widgetFullName||e;t.fn[e]=function(n){var o="string"==typeof n,a=l.call(arguments,1),r=this;return o?this.length||"instance"!==n?this.each(function(){var i,o=t.data(this,s);return"instance"===n?(r=o,!1):o?t.isFunction(o[n])&&"_"!==n.charAt(0)?(i=o[n].apply(o,a),i!==o&&void 0!==i?(r=i&&i.jquery?r.pushStack(i.get()):i,!1):void 0):t.error("no such method '"+n+"' for "+e+" widget instance"):t.error("cannot call methods on "+e+" prior to initialization; "+"attempted to call method '"+n+"'")}):r=void 0:(a.length&&(n=t.widget.extend.apply(null,[n].concat(a))),this.each(function(){var e=t.data(this,s);e?(e.option(n||{}),e._init&&e._init()):t.data(this,s,new i(n,this))})),r}},t.Widget=function(){},t.Widget._childConstructors=[],t.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:!1,create:null},_createWidget:function(e,i){i=t(i||this.defaultElement||this)[0],this.element=t(i),this.uuid=h++,this.eventNamespace="."+this.widgetName+this.uuid,this.bindings=t(),this.hoverable=t(),this.focusable=t(),this.classesElementLookup={},i!==this&&(t.data(i,this.widgetFullName,this),this._on(!0,this.element,{remove:function(t){t.target===i&&this.destroy()}}),this.document=t(i.style?i.ownerDocument:i.document||i),this.window=t(this.document[0].defaultView||this.document[0].parentWindow)),this.options=t.widget.extend({},this.options,this._getCreateOptions(),e),this._create(),this.options.disabled&&this._setOptionDisabled(this.options.disabled),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:function(){return{}},_getCreateEventData:t.noop,_create:t.noop,_init:t.noop,destroy:function(){var e=this;this._destroy(),t.each(this.classesElementLookup,function(t,i){e._removeClass(i,t)}),this.element.off(this.eventNamespace).removeData(this.widgetFullName),this.widget().off(this.eventNamespace).removeAttr("aria-disabled"),this.bindings.off(this.eventNamespace)},_destroy:t.noop,widget:function(){return this.element},option:function(e,i){var s,n,o,a=e;if(0===arguments.length)return t.widget.extend({},this.options);if("string"==typeof e)if(a={},s=e.split("."),e=s.shift(),s.length){for(n=a[e]=t.widget.extend({},this.options[e]),o=0;s.length-1>o;o++)n[s[o]]=n[s[o]]||{},n=n[s[o]];if(e=s.pop(),1===arguments.length)return void 0===n[e]?null:n[e];n[e]=i}else{if(1===arguments.length)return void 0===this.options[e]?null:this.options[e];a[e]=i}return this._setOptions(a),this},_setOptions:function(t){var e;for(e in t)this._setOption(e,t[e]);return this},_setOption:function(t,e){return"classes"===t&&this._setOptionClasses(e),this.options[t]=e,"disabled"===t&&this._setOptionDisabled(e),this},_setOptionClasses:function(e){var i,s,n;for(i in e)n=this.classesElementLookup[i],e[i]!==this.options.classes[i]&&n&&n.length&&(s=t(n.get()),this._removeClass(n,i),s.addClass(this._classes({element:s,keys:i,classes:e,add:!0})))},_setOptionDisabled:function(t){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!t),t&&(this._removeClass(this.hoverable,null,"ui-state-hover"),this._removeClass(this.focusable,null,"ui-state-focus"))},enable:function(){return this._setOptions({disabled:!1})},disable:function(){return this._setOptions({disabled:!0})},_classes:function(e){function i(i,o){var a,r;for(r=0;i.length>r;r++)a=n.classesElementLookup[i[r]]||t(),a=e.add?t(t.unique(a.get().concat(e.element.get()))):t(a.not(e.element).get()),n.classesElementLookup[i[r]]=a,s.push(i[r]),o&&e.classes[i[r]]&&s.push(e.classes[i[r]])}var s=[],n=this;return e=t.extend({element:this.element,classes:this.options.classes||{}},e),this._on(e.element,{remove:"_untrackClassesElement"}),e.keys&&i(e.keys.match(/\S+/g)||[],!0),e.extra&&i(e.extra.match(/\S+/g)||[]),s.join(" ")},_untrackClassesElement:function(e){var i=this;t.each(i.classesElementLookup,function(s,n){-1!==t.inArray(e.target,n)&&(i.classesElementLookup[s]=t(n.not(e.target).get()))})},_removeClass:function(t,e,i){return this._toggleClass(t,e,i,!1)},_addClass:function(t,e,i){return this._toggleClass(t,e,i,!0)},_toggleClass:function(t,e,i,s){s="boolean"==typeof s?s:i;var n="string"==typeof t||null===t,o={extra:n?e:i,keys:n?t:e,element:n?this.element:t,add:s};return o.element.toggleClass(this._classes(o),s),this},_on:function(e,i,s){var n,o=this;"boolean"!=typeof e&&(s=i,i=e,e=!1),s?(i=n=t(i),this.bindings=this.bindings.add(i)):(s=i,i=this.element,n=this.widget()),t.each(s,function(s,a){function r(){return e||o.options.disabled!==!0&&!t(this).hasClass("ui-state-disabled")?("string"==typeof a?o[a]:a).apply(o,arguments):void 0}"string"!=typeof a&&(r.guid=a.guid=a.guid||r.guid||t.guid++);var h=s.match(/^([\w:-]*)\s*(.*)$/),l=h[1]+o.eventNamespace,c=h[2];c?n.on(l,c,r):i.on(l,r)})},_off:function(e,i){i=(i||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,e.off(i).off(i),this.bindings=t(this.bindings.not(e).get()),this.focusable=t(this.focusable.not(e).get()),this.hoverable=t(this.hoverable.not(e).get())},_delay:function(t,e){function i(){return("string"==typeof t?s[t]:t).apply(s,arguments)}var s=this;return setTimeout(i,e||0)},_hoverable:function(e){this.hoverable=this.hoverable.add(e),this._on(e,{mouseenter:function(e){this._addClass(t(e.currentTarget),null,"ui-state-hover")},mouseleave:function(e){this._removeClass(t(e.currentTarget),null,"ui-state-hover")}})},_focusable:function(e){this.focusable=this.focusable.add(e),this._on(e,{focusin:function(e){this._addClass(t(e.currentTarget),null,"ui-state-focus")},focusout:function(e){this._removeClass(t(e.currentTarget),null,"ui-state-focus")}})},_trigger:function(e,i,s){var n,o,a=this.options[e];if(s=s||{},i=t.Event(i),i.type=(e===this.widgetEventPrefix?e:this.widgetEventPrefix+e).toLowerCase(),i.target=this.element[0],o=i.originalEvent)for(n in o)n in i||(i[n]=o[n]);return this.element.trigger(i,s),!(t.isFunction(a)&&a.apply(this.element[0],[i].concat(s))===!1||i.isDefaultPrevented())}},t.each({show:"fadeIn",hide:"fadeOut"},function(e,i){t.Widget.prototype["_"+e]=function(s,n,o){"string"==typeof n&&(n={effect:n});var a,r=n?n===!0||"number"==typeof n?i:n.effect||i:e;n=n||{},"number"==typeof n&&(n={duration:n}),a=!t.isEmptyObject(n),n.complete=o,n.delay&&s.delay(n.delay),a&&t.effects&&t.effects.effect[r]?s[e](n):r!==e&&s[r]?s[r](n.duration,n.easing,o):s.queue(function(i){t(this)[e](),o&&o.call(s[0]),i()})}}),t.widget,function(){function e(t,e,i){return[parseFloat(t[0])*(u.test(t[0])?e/100:1),parseFloat(t[1])*(u.test(t[1])?i/100:1)]}function i(e,i){return parseInt(t.css(e,i),10)||0}function s(e){var i=e[0];return 9===i.nodeType?{width:e.width(),height:e.height(),offset:{top:0,left:0}}:t.isWindow(i)?{width:e.width(),height:e.height(),offset:{top:e.scrollTop(),left:e.scrollLeft()}}:i.preventDefault?{width:0,height:0,offset:{top:i.pageY,left:i.pageX}}:{width:e.outerWidth(),height:e.outerHeight(),offset:e.offset()}}var n,o=Math.max,a=Math.abs,r=/left|center|right/,h=/top|center|bottom/,l=/[\+\-]\d+(\.[\d]+)?%?/,c=/^\w+/,u=/%$/,d=t.fn.position;t.position={scrollbarWidth:function(){if(void 0!==n)return n;var e,i,s=t("<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>"),o=s.children()[0];return t("body").append(s),e=o.offsetWidth,s.css("overflow","scroll"),i=o.offsetWidth,e===i&&(i=s[0].clientWidth),s.remove(),n=e-i},getScrollInfo:function(e){var i=e.isWindow||e.isDocument?"":e.element.css("overflow-x"),s=e.isWindow||e.isDocument?"":e.element.css("overflow-y"),n="scroll"===i||"auto"===i&&e.width<e.element[0].scrollWidth,o="scroll"===s||"auto"===s&&e.height<e.element[0].scrollHeight;return{width:o?t.position.scrollbarWidth():0,height:n?t.position.scrollbarWidth():0}},getWithinInfo:function(e){var i=t(e||window),s=t.isWindow(i[0]),n=!!i[0]&&9===i[0].nodeType,o=!s&&!n;return{element:i,isWindow:s,isDocument:n,offset:o?t(e).offset():{left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:i.outerWidth(),height:i.outerHeight()}}},t.fn.position=function(n){if(!n||!n.of)return d.apply(this,arguments);n=t.extend({},n);var u,p,f,g,m,_,v=t(n.of),b=t.position.getWithinInfo(n.within),y=t.position.getScrollInfo(b),w=(n.collision||"flip").split(" "),k={};return _=s(v),v[0].preventDefault&&(n.at="left top"),p=_.width,f=_.height,g=_.offset,m=t.extend({},g),t.each(["my","at"],function(){var t,e,i=(n[this]||"").split(" ");1===i.length&&(i=r.test(i[0])?i.concat(["center"]):h.test(i[0])?["center"].concat(i):["center","center"]),i[0]=r.test(i[0])?i[0]:"center",i[1]=h.test(i[1])?i[1]:"center",t=l.exec(i[0]),e=l.exec(i[1]),k[this]=[t?t[0]:0,e?e[0]:0],n[this]=[c.exec(i[0])[0],c.exec(i[1])[0]]}),1===w.length&&(w[1]=w[0]),"right"===n.at[0]?m.left+=p:"center"===n.at[0]&&(m.left+=p/2),"bottom"===n.at[1]?m.top+=f:"center"===n.at[1]&&(m.top+=f/2),u=e(k.at,p,f),m.left+=u[0],m.top+=u[1],this.each(function(){var s,r,h=t(this),l=h.outerWidth(),c=h.outerHeight(),d=i(this,"marginLeft"),_=i(this,"marginTop"),x=l+d+i(this,"marginRight")+y.width,C=c+_+i(this,"marginBottom")+y.height,D=t.extend({},m),I=e(k.my,h.outerWidth(),h.outerHeight());"right"===n.my[0]?D.left-=l:"center"===n.my[0]&&(D.left-=l/2),"bottom"===n.my[1]?D.top-=c:"center"===n.my[1]&&(D.top-=c/2),D.left+=I[0],D.top+=I[1],s={marginLeft:d,marginTop:_},t.each(["left","top"],function(e,i){t.ui.position[w[e]]&&t.ui.position[w[e]][i](D,{targetWidth:p,targetHeight:f,elemWidth:l,elemHeight:c,collisionPosition:s,collisionWidth:x,collisionHeight:C,offset:[u[0]+I[0],u[1]+I[1]],my:n.my,at:n.at,within:b,elem:h})}),n.using&&(r=function(t){var e=g.left-D.left,i=e+p-l,s=g.top-D.top,r=s+f-c,u={target:{element:v,left:g.left,top:g.top,width:p,height:f},element:{element:h,left:D.left,top:D.top,width:l,height:c},horizontal:0>i?"left":e>0?"right":"center",vertical:0>r?"top":s>0?"bottom":"middle"};l>p&&p>a(e+i)&&(u.horizontal="center"),c>f&&f>a(s+r)&&(u.vertical="middle"),u.important=o(a(e),a(i))>o(a(s),a(r))?"horizontal":"vertical",n.using.call(this,t,u)}),h.offset(t.extend(D,{using:r}))})},t.ui.position={fit:{left:function(t,e){var i,s=e.within,n=s.isWindow?s.scrollLeft:s.offset.left,a=s.width,r=t.left-e.collisionPosition.marginLeft,h=n-r,l=r+e.collisionWidth-a-n;e.collisionWidth>a?h>0&&0>=l?(i=t.left+h+e.collisionWidth-a-n,t.left+=h-i):t.left=l>0&&0>=h?n:h>l?n+a-e.collisionWidth:n:h>0?t.left+=h:l>0?t.left-=l:t.left=o(t.left-r,t.left)},top:function(t,e){var i,s=e.within,n=s.isWindow?s.scrollTop:s.offset.top,a=e.within.height,r=t.top-e.collisionPosition.marginTop,h=n-r,l=r+e.collisionHeight-a-n;e.collisionHeight>a?h>0&&0>=l?(i=t.top+h+e.collisionHeight-a-n,t.top+=h-i):t.top=l>0&&0>=h?n:h>l?n+a-e.collisionHeight:n:h>0?t.top+=h:l>0?t.top-=l:t.top=o(t.top-r,t.top)}},flip:{left:function(t,e){var i,s,n=e.within,o=n.offset.left+n.scrollLeft,r=n.width,h=n.isWindow?n.scrollLeft:n.offset.left,l=t.left-e.collisionPosition.marginLeft,c=l-h,u=l+e.collisionWidth-r-h,d="left"===e.my[0]?-e.elemWidth:"right"===e.my[0]?e.elemWidth:0,p="left"===e.at[0]?e.targetWidth:"right"===e.at[0]?-e.targetWidth:0,f=-2*e.offset[0];0>c?(i=t.left+d+p+f+e.collisionWidth-r-o,(0>i||a(c)>i)&&(t.left+=d+p+f)):u>0&&(s=t.left-e.collisionPosition.marginLeft+d+p+f-h,(s>0||u>a(s))&&(t.left+=d+p+f))},top:function(t,e){var i,s,n=e.within,o=n.offset.top+n.scrollTop,r=n.height,h=n.isWindow?n.scrollTop:n.offset.top,l=t.top-e.collisionPosition.marginTop,c=l-h,u=l+e.collisionHeight-r-h,d="top"===e.my[1],p=d?-e.elemHeight:"bottom"===e.my[1]?e.elemHeight:0,f="top"===e.at[1]?e.targetHeight:"bottom"===e.at[1]?-e.targetHeight:0,g=-2*e.offset[1];0>c?(s=t.top+p+f+g+e.collisionHeight-r-o,(0>s||a(c)>s)&&(t.top+=p+f+g)):u>0&&(i=t.top-e.collisionPosition.marginTop+p+f+g-h,(i>0||u>a(i))&&(t.top+=p+f+g))}},flipfit:{left:function(){t.ui.position.flip.left.apply(this,arguments),t.ui.position.fit.left.apply(this,arguments)},top:function(){t.ui.position.flip.top.apply(this,arguments),t.ui.position.fit.top.apply(this,arguments)}}}}(),t.ui.position,t.extend(t.expr[":"],{data:t.expr.createPseudo?t.expr.createPseudo(function(e){return function(i){return!!t.data(i,e)}}):function(e,i,s){return!!t.data(e,s[3])}}),t.fn.extend({disableSelection:function(){var t="onselectstart"in document.createElement("div")?"selectstart":"mousedown";return function(){return this.on(t+".ui-disableSelection",function(t){t.preventDefault()})}}(),enableSelection:function(){return this.off(".ui-disableSelection")}});var c="ui-effects-",u="ui-effects-style",d="ui-effects-animated",p=t;t.effects={effect:{}},function(t,e){function i(t,e,i){var s=u[e.type]||{};return null==t?i||!e.def?null:e.def:(t=s.floor?~~t:parseFloat(t),isNaN(t)?e.def:s.mod?(t+s.mod)%s.mod:0>t?0:t>s.max?s.max:t)}function s(i){var s=l(),n=s._rgba=[];return i=i.toLowerCase(),f(h,function(t,o){var a,r=o.re.exec(i),h=r&&o.parse(r),l=o.space||"rgba";return h?(a=s[l](h),s[c[l].cache]=a[c[l].cache],n=s._rgba=a._rgba,!1):e}),n.length?("0,0,0,0"===n.join()&&t.extend(n,o.transparent),s):o[i]}function n(t,e,i){return i=(i+1)%1,1>6*i?t+6*(e-t)*i:1>2*i?e:2>3*i?t+6*(e-t)*(2/3-i):t}var o,a="backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor",r=/^([\-+])=\s*(\d+\.?\d*)/,h=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(t){return[t[1],t[2],t[3],t[4]]}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(t){return[2.55*t[1],2.55*t[2],2.55*t[3],t[4]]}},{re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/#([a-f0-9])([a-f0-9])([a-f0-9])/,parse:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function(t){return[t[1],t[2]/100,t[3]/100,t[4]]}}],l=t.Color=function(e,i,s,n){return new t.Color.fn.parse(e,i,s,n)},c={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},u={"byte":{floor:!0,max:255},percent:{max:1},degrees:{mod:360,floor:!0}},d=l.support={},p=t("<p>")[0],f=t.each;p.style.cssText="background-color:rgba(1,1,1,.5)",d.rgba=p.style.backgroundColor.indexOf("rgba")>-1,f(c,function(t,e){e.cache="_"+t,e.props.alpha={idx:3,type:"percent",def:1}}),l.fn=t.extend(l.prototype,{parse:function(n,a,r,h){if(n===e)return this._rgba=[null,null,null,null],this;(n.jquery||n.nodeType)&&(n=t(n).css(a),a=e);var u=this,d=t.type(n),p=this._rgba=[];return a!==e&&(n=[n,a,r,h],d="array"),"string"===d?this.parse(s(n)||o._default):"array"===d?(f(c.rgba.props,function(t,e){p[e.idx]=i(n[e.idx],e)}),this):"object"===d?(n instanceof l?f(c,function(t,e){n[e.cache]&&(u[e.cache]=n[e.cache].slice())}):f(c,function(e,s){var o=s.cache;f(s.props,function(t,e){if(!u[o]&&s.to){if("alpha"===t||null==n[t])return;u[o]=s.to(u._rgba)}u[o][e.idx]=i(n[t],e,!0)}),u[o]&&0>t.inArray(null,u[o].slice(0,3))&&(u[o][3]=1,s.from&&(u._rgba=s.from(u[o])))}),this):e},is:function(t){var i=l(t),s=!0,n=this;return f(c,function(t,o){var a,r=i[o.cache];return r&&(a=n[o.cache]||o.to&&o.to(n._rgba)||[],f(o.props,function(t,i){return null!=r[i.idx]?s=r[i.idx]===a[i.idx]:e})),s}),s},_space:function(){var t=[],e=this;return f(c,function(i,s){e[s.cache]&&t.push(i)}),t.pop()},transition:function(t,e){var s=l(t),n=s._space(),o=c[n],a=0===this.alpha()?l("transparent"):this,r=a[o.cache]||o.to(a._rgba),h=r.slice();return s=s[o.cache],f(o.props,function(t,n){var o=n.idx,a=r[o],l=s[o],c=u[n.type]||{};null!==l&&(null===a?h[o]=l:(c.mod&&(l-a>c.mod/2?a+=c.mod:a-l>c.mod/2&&(a-=c.mod)),h[o]=i((l-a)*e+a,n)))}),this[n](h)},blend:function(e){if(1===this._rgba[3])return this;var i=this._rgba.slice(),s=i.pop(),n=l(e)._rgba;return l(t.map(i,function(t,e){return(1-s)*n[e]+s*t}))},toRgbaString:function(){var e="rgba(",i=t.map(this._rgba,function(t,e){return null==t?e>2?1:0:t});return 1===i[3]&&(i.pop(),e="rgb("),e+i.join()+")"},toHslaString:function(){var e="hsla(",i=t.map(this.hsla(),function(t,e){return null==t&&(t=e>2?1:0),e&&3>e&&(t=Math.round(100*t)+"%"),t});return 1===i[3]&&(i.pop(),e="hsl("),e+i.join()+")"},toHexString:function(e){var i=this._rgba.slice(),s=i.pop();return e&&i.push(~~(255*s)),"#"+t.map(i,function(t){return t=(t||0).toString(16),1===t.length?"0"+t:t}).join("")},toString:function(){return 0===this._rgba[3]?"transparent":this.toRgbaString()}}),l.fn.parse.prototype=l.fn,c.hsla.to=function(t){if(null==t[0]||null==t[1]||null==t[2])return[null,null,null,t[3]];var e,i,s=t[0]/255,n=t[1]/255,o=t[2]/255,a=t[3],r=Math.max(s,n,o),h=Math.min(s,n,o),l=r-h,c=r+h,u=.5*c;return e=h===r?0:s===r?60*(n-o)/l+360:n===r?60*(o-s)/l+120:60*(s-n)/l+240,i=0===l?0:.5>=u?l/c:l/(2-c),[Math.round(e)%360,i,u,null==a?1:a]},c.hsla.from=function(t){if(null==t[0]||null==t[1]||null==t[2])return[null,null,null,t[3]];var e=t[0]/360,i=t[1],s=t[2],o=t[3],a=.5>=s?s*(1+i):s+i-s*i,r=2*s-a;return[Math.round(255*n(r,a,e+1/3)),Math.round(255*n(r,a,e)),Math.round(255*n(r,a,e-1/3)),o]},f(c,function(s,n){var o=n.props,a=n.cache,h=n.to,c=n.from;l.fn[s]=function(s){if(h&&!this[a]&&(this[a]=h(this._rgba)),s===e)return this[a].slice();var n,r=t.type(s),u="array"===r||"object"===r?s:arguments,d=this[a].slice();return f(o,function(t,e){var s=u["object"===r?t:e.idx];null==s&&(s=d[e.idx]),d[e.idx]=i(s,e)}),c?(n=l(c(d)),n[a]=d,n):l(d)},f(o,function(e,i){l.fn[e]||(l.fn[e]=function(n){var o,a=t.type(n),h="alpha"===e?this._hsla?"hsla":"rgba":s,l=this[h](),c=l[i.idx];return"undefined"===a?c:("function"===a&&(n=n.call(this,c),a=t.type(n)),null==n&&i.empty?this:("string"===a&&(o=r.exec(n),o&&(n=c+parseFloat(o[2])*("+"===o[1]?1:-1))),l[i.idx]=n,this[h](l)))})})}),l.hook=function(e){var i=e.split(" ");f(i,function(e,i){t.cssHooks[i]={set:function(e,n){var o,a,r="";if("transparent"!==n&&("string"!==t.type(n)||(o=s(n)))){if(n=l(o||n),!d.rgba&&1!==n._rgba[3]){for(a="backgroundColor"===i?e.parentNode:e;(""===r||"transparent"===r)&&a&&a.style;)try{r=t.css(a,"backgroundColor"),a=a.parentNode}catch(h){}n=n.blend(r&&"transparent"!==r?r:"_default")}n=n.toRgbaString()}try{e.style[i]=n}catch(h){}}},t.fx.step[i]=function(e){e.colorInit||(e.start=l(e.elem,i),e.end=l(e.end),e.colorInit=!0),t.cssHooks[i].set(e.elem,e.start.transition(e.end,e.pos))}})},l.hook(a),t.cssHooks.borderColor={expand:function(t){var e={};return f(["Top","Right","Bottom","Left"],function(i,s){e["border"+s+"Color"]=t}),e}},o=t.Color.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",transparent:[null,null,null,0],_default:"#ffffff"}}(p),function(){function e(e){var i,s,n=e.ownerDocument.defaultView?e.ownerDocument.defaultView.getComputedStyle(e,null):e.currentStyle,o={};if(n&&n.length&&n[0]&&n[n[0]])for(s=n.length;s--;)i=n[s],"string"==typeof n[i]&&(o[t.camelCase(i)]=n[i]);else for(i in n)"string"==typeof n[i]&&(o[i]=n[i]);return o}function i(e,i){var s,o,a={};for(s in i)o=i[s],e[s]!==o&&(n[s]||(t.fx.step[s]||!isNaN(parseFloat(o)))&&(a[s]=o));return a}var s=["add","remove","toggle"],n={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};t.each(["borderLeftStyle","borderRightStyle","borderBottomStyle","borderTopStyle"],function(e,i){t.fx.step[i]=function(t){("none"!==t.end&&!t.setAttr||1===t.pos&&!t.setAttr)&&(p.style(t.elem,i,t.end),t.setAttr=!0)}}),t.fn.addBack||(t.fn.addBack=function(t){return this.add(null==t?this.prevObject:this.prevObject.filter(t))}),t.effects.animateClass=function(n,o,a,r){var h=t.speed(o,a,r);return this.queue(function(){var o,a=t(this),r=a.attr("class")||"",l=h.children?a.find("*").addBack():a;l=l.map(function(){var i=t(this);return{el:i,start:e(this)}}),o=function(){t.each(s,function(t,e){n[e]&&a[e+"Class"](n[e])})},o(),l=l.map(function(){return this.end=e(this.el[0]),this.diff=i(this.start,this.end),this}),a.attr("class",r),l=l.map(function(){var e=this,i=t.Deferred(),s=t.extend({},h,{queue:!1,complete:function(){i.resolve(e)}});return this.el.animate(this.diff,s),i.promise()}),t.when.apply(t,l.get()).done(function(){o(),t.each(arguments,function(){var e=this.el;t.each(this.diff,function(t){e.css(t,"")})}),h.complete.call(a[0])})})},t.fn.extend({addClass:function(e){return function(i,s,n,o){return s?t.effects.animateClass.call(this,{add:i},s,n,o):e.apply(this,arguments)}}(t.fn.addClass),removeClass:function(e){return function(i,s,n,o){return arguments.length>1?t.effects.animateClass.call(this,{remove:i},s,n,o):e.apply(this,arguments)}}(t.fn.removeClass),toggleClass:function(e){return function(i,s,n,o,a){return"boolean"==typeof s||void 0===s?n?t.effects.animateClass.call(this,s?{add:i}:{remove:i},n,o,a):e.apply(this,arguments):t.effects.animateClass.call(this,{toggle:i},s,n,o)}}(t.fn.toggleClass),switchClass:function(e,i,s,n,o){return t.effects.animateClass.call(this,{add:i,remove:e},s,n,o)}})}(),function(){function e(e,i,s,n){return t.isPlainObject(e)&&(i=e,e=e.effect),e={effect:e},null==i&&(i={}),t.isFunction(i)&&(n=i,s=null,i={}),("number"==typeof i||t.fx.speeds[i])&&(n=s,s=i,i={}),t.isFunction(s)&&(n=s,s=null),i&&t.extend(e,i),s=s||i.duration,e.duration=t.fx.off?0:"number"==typeof s?s:s in t.fx.speeds?t.fx.speeds[s]:t.fx.speeds._default,e.complete=n||i.complete,e}function i(e){return!e||"number"==typeof e||t.fx.speeds[e]?!0:"string"!=typeof e||t.effects.effect[e]?t.isFunction(e)?!0:"object"!=typeof e||e.effect?!1:!0:!0}function s(t,e){var i=e.outerWidth(),s=e.outerHeight(),n=/^rect\((-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto)\)$/,o=n.exec(t)||["",0,i,s,0];return{top:parseFloat(o[1])||0,right:"auto"===o[2]?i:parseFloat(o[2]),bottom:"auto"===o[3]?s:parseFloat(o[3]),left:parseFloat(o[4])||0}}t.expr&&t.expr.filters&&t.expr.filters.animated&&(t.expr.filters.animated=function(e){return function(i){return!!t(i).data(d)||e(i)}}(t.expr.filters.animated)),t.uiBackCompat!==!1&&t.extend(t.effects,{save:function(t,e){for(var i=0,s=e.length;s>i;i++)null!==e[i]&&t.data(c+e[i],t[0].style[e[i]])},restore:function(t,e){for(var i,s=0,n=e.length;n>s;s++)null!==e[s]&&(i=t.data(c+e[s]),t.css(e[s],i))},setMode:function(t,e){return"toggle"===e&&(e=t.is(":hidden")?"show":"hide"),e},createWrapper:function(e){if(e.parent().is(".ui-effects-wrapper"))return e.parent();var i={width:e.outerWidth(!0),height:e.outerHeight(!0),"float":e.css("float")},s=t("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),n={width:e.width(),height:e.height()},o=document.activeElement;try{o.id}catch(a){o=document.body}return e.wrap(s),(e[0]===o||t.contains(e[0],o))&&t(o).trigger("focus"),s=e.parent(),"static"===e.css("position")?(s.css({position:"relative"}),e.css({position:"relative"})):(t.extend(i,{position:e.css("position"),zIndex:e.css("z-index")}),t.each(["top","left","bottom","right"],function(t,s){i[s]=e.css(s),isNaN(parseInt(i[s],10))&&(i[s]="auto")}),e.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"})),e.css(n),s.css(i).show()},removeWrapper:function(e){var i=document.activeElement;return e.parent().is(".ui-effects-wrapper")&&(e.parent().replaceWith(e),(e[0]===i||t.contains(e[0],i))&&t(i).trigger("focus")),e}}),t.extend(t.effects,{version:"1.12.1",define:function(e,i,s){return s||(s=i,i="effect"),t.effects.effect[e]=s,t.effects.effect[e].mode=i,s},scaledDimensions:function(t,e,i){if(0===e)return{height:0,width:0,outerHeight:0,outerWidth:0};var s="horizontal"!==i?(e||100)/100:1,n="vertical"!==i?(e||100)/100:1;return{height:t.height()*n,width:t.width()*s,outerHeight:t.outerHeight()*n,outerWidth:t.outerWidth()*s}},clipToBox:function(t){return{width:t.clip.right-t.clip.left,height:t.clip.bottom-t.clip.top,left:t.clip.left,top:t.clip.top}},unshift:function(t,e,i){var s=t.queue();e>1&&s.splice.apply(s,[1,0].concat(s.splice(e,i))),t.dequeue()},saveStyle:function(t){t.data(u,t[0].style.cssText)},restoreStyle:function(t){t[0].style.cssText=t.data(u)||"",t.removeData(u)},mode:function(t,e){var i=t.is(":hidden");return"toggle"===e&&(e=i?"show":"hide"),(i?"hide"===e:"show"===e)&&(e="none"),e},getBaseline:function(t,e){var i,s;switch(t[0]){case"top":i=0;break;case"middle":i=.5;break;case"bottom":i=1;break;default:i=t[0]/e.height}switch(t[1]){case"left":s=0;break;case"center":s=.5;break;case"right":s=1;break;default:s=t[1]/e.width}return{x:s,y:i}},createPlaceholder:function(e){var i,s=e.css("position"),n=e.position();return e.css({marginTop:e.css("marginTop"),marginBottom:e.css("marginBottom"),marginLeft:e.css("marginLeft"),marginRight:e.css("marginRight")}).outerWidth(e.outerWidth()).outerHeight(e.outerHeight()),/^(static|relative)/.test(s)&&(s="absolute",i=t("<"+e[0].nodeName+">").insertAfter(e).css({display:/^(inline|ruby)/.test(e.css("display"))?"inline-block":"block",visibility:"hidden",marginTop:e.css("marginTop"),marginBottom:e.css("marginBottom"),marginLeft:e.css("marginLeft"),marginRight:e.css("marginRight"),"float":e.css("float")}).outerWidth(e.outerWidth()).outerHeight(e.outerHeight()).addClass("ui-effects-placeholder"),e.data(c+"placeholder",i)),e.css({position:s,left:n.left,top:n.top}),i},removePlaceholder:function(t){var e=c+"placeholder",i=t.data(e);i&&(i.remove(),t.removeData(e))},cleanUp:function(e){t.effects.restoreStyle(e),t.effects.removePlaceholder(e)},setTransition:function(e,i,s,n){return n=n||{},t.each(i,function(t,i){var o=e.cssUnit(i);o[0]>0&&(n[i]=o[0]*s+o[1])}),n}}),t.fn.extend({effect:function(){function i(e){function i(){r.removeData(d),t.effects.cleanUp(r),"hide"===s.mode&&r.hide(),a()}function a(){t.isFunction(h)&&h.call(r[0]),t.isFunction(e)&&e()}var r=t(this);s.mode=c.shift(),t.uiBackCompat===!1||o?"none"===s.mode?(r[l](),a()):n.call(r[0],s,i):(r.is(":hidden")?"hide"===l:"show"===l)?(r[l](),a()):n.call(r[0],s,a)}var s=e.apply(this,arguments),n=t.effects.effect[s.effect],o=n.mode,a=s.queue,r=a||"fx",h=s.complete,l=s.mode,c=[],u=function(e){var i=t(this),s=t.effects.mode(i,l)||o;i.data(d,!0),c.push(s),o&&("show"===s||s===o&&"hide"===s)&&i.show(),o&&"none"===s||t.effects.saveStyle(i),t.isFunction(e)&&e()};return t.fx.off||!n?l?this[l](s.duration,h):this.each(function(){h&&h.call(this)}):a===!1?this.each(u).each(i):this.queue(r,u).queue(r,i)},show:function(t){return function(s){if(i(s))return t.apply(this,arguments);var n=e.apply(this,arguments);return n.mode="show",this.effect.call(this,n)}}(t.fn.show),hide:function(t){return function(s){if(i(s))return t.apply(this,arguments);var n=e.apply(this,arguments);return n.mode="hide",this.effect.call(this,n)}}(t.fn.hide),toggle:function(t){return function(s){if(i(s)||"boolean"==typeof s)return t.apply(this,arguments);var n=e.apply(this,arguments);return n.mode="toggle",this.effect.call(this,n)}}(t.fn.toggle),cssUnit:function(e){var i=this.css(e),s=[];return t.each(["em","px","%","pt"],function(t,e){i.indexOf(e)>0&&(s=[parseFloat(i),e])}),s},cssClip:function(t){return t?this.css("clip","rect("+t.top+"px "+t.right+"px "+t.bottom+"px "+t.left+"px)"):s(this.css("clip"),this)},transfer:function(e,i){var s=t(this),n=t(e.to),o="fixed"===n.css("position"),a=t("body"),r=o?a.scrollTop():0,h=o?a.scrollLeft():0,l=n.offset(),c={top:l.top-r,left:l.left-h,height:n.innerHeight(),width:n.innerWidth()},u=s.offset(),d=t("<div class='ui-effects-transfer'></div>").appendTo("body").addClass(e.className).css({top:u.top-r,left:u.left-h,height:s.innerHeight(),width:s.innerWidth(),position:o?"fixed":"absolute"}).animate(c,e.duration,e.easing,function(){d.remove(),t.isFunction(i)&&i()})}}),t.fx.step.clip=function(e){e.clipInit||(e.start=t(e.elem).cssClip(),"string"==typeof e.end&&(e.end=s(e.end,e.elem)),e.clipInit=!0),t(e.elem).cssClip({top:e.pos*(e.end.top-e.start.top)+e.start.top,right:e.pos*(e.end.right-e.start.right)+e.start.right,bottom:e.pos*(e.end.bottom-e.start.bottom)+e.start.bottom,left:e.pos*(e.end.left-e.start.left)+e.start.left})}}(),function(){var e={};t.each(["Quad","Cubic","Quart","Quint","Expo"],function(t,i){e[i]=function(e){return Math.pow(e,t+2)}}),t.extend(e,{Sine:function(t){return 1-Math.cos(t*Math.PI/2)},Circ:function(t){return 1-Math.sqrt(1-t*t)},Elastic:function(t){return 0===t||1===t?t:-Math.pow(2,8*(t-1))*Math.sin((80*(t-1)-7.5)*Math.PI/15)},Back:function(t){return t*t*(3*t-2)},Bounce:function(t){for(var e,i=4;((e=Math.pow(2,--i))-1)/11>t;);return 1/Math.pow(4,3-i)-7.5625*Math.pow((3*e-2)/22-t,2)}}),t.each(e,function(e,i){t.easing["easeIn"+e]=i,t.easing["easeOut"+e]=function(t){return 1-i(1-t)},t.easing["easeInOut"+e]=function(t){return.5>t?i(2*t)/2:1-i(-2*t+2)/2}})}();var f=t.effects;t.effects.define("blind","hide",function(e,i){var s={up:["bottom","top"],vertical:["bottom","top"],down:["top","bottom"],left:["right","left"],horizontal:["right","left"],right:["left","right"]},n=t(this),o=e.direction||"up",a=n.cssClip(),r={clip:t.extend({},a)},h=t.effects.createPlaceholder(n);r.clip[s[o][0]]=r.clip[s[o][1]],"show"===e.mode&&(n.cssClip(r.clip),h&&h.css(t.effects.clipToBox(r)),r.clip=a),h&&h.animate(t.effects.clipToBox(r),e.duration,e.easing),n.animate(r,{queue:!1,duration:e.duration,easing:e.easing,complete:i})}),t.effects.define("bounce",function(e,i){var s,n,o,a=t(this),r=e.mode,h="hide"===r,l="show"===r,c=e.direction||"up",u=e.distance,d=e.times||5,p=2*d+(l||h?1:0),f=e.duration/p,g=e.easing,m="up"===c||"down"===c?"top":"left",_="up"===c||"left"===c,v=0,b=a.queue().length;for(t.effects.createPlaceholder(a),o=a.css(m),u||(u=a["top"===m?"outerHeight":"outerWidth"]()/3),l&&(n={opacity:1},n[m]=o,a.css("opacity",0).css(m,_?2*-u:2*u).animate(n,f,g)),h&&(u/=Math.pow(2,d-1)),n={},n[m]=o;d>v;v++)s={},s[m]=(_?"-=":"+=")+u,a.animate(s,f,g).animate(n,f,g),u=h?2*u:u/2;h&&(s={opacity:0},s[m]=(_?"-=":"+=")+u,a.animate(s,f,g)),a.queue(i),t.effects.unshift(a,b,p+1)}),t.effects.define("clip","hide",function(e,i){var s,n={},o=t(this),a=e.direction||"vertical",r="both"===a,h=r||"horizontal"===a,l=r||"vertical"===a;s=o.cssClip(),n.clip={top:l?(s.bottom-s.top)/2:s.top,right:h?(s.right-s.left)/2:s.right,bottom:l?(s.bottom-s.top)/2:s.bottom,left:h?(s.right-s.left)/2:s.left},t.effects.createPlaceholder(o),"show"===e.mode&&(o.cssClip(n.clip),n.clip=s),o.animate(n,{queue:!1,duration:e.duration,easing:e.easing,complete:i})}),t.effects.define("drop","hide",function(e,i){var s,n=t(this),o=e.mode,a="show"===o,r=e.direction||"left",h="up"===r||"down"===r?"top":"left",l="up"===r||"left"===r?"-=":"+=",c="+="===l?"-=":"+=",u={opacity:0};t.effects.createPlaceholder(n),s=e.distance||n["top"===h?"outerHeight":"outerWidth"](!0)/2,u[h]=l+s,a&&(n.css(u),u[h]=c+s,u.opacity=1),n.animate(u,{queue:!1,duration:e.duration,easing:e.easing,complete:i})}),t.effects.define("explode","hide",function(e,i){function s(){b.push(this),b.length===u*d&&n()}function n(){p.css({visibility:"visible"}),t(b).remove(),i()}var o,a,r,h,l,c,u=e.pieces?Math.round(Math.sqrt(e.pieces)):3,d=u,p=t(this),f=e.mode,g="show"===f,m=p.show().css("visibility","hidden").offset(),_=Math.ceil(p.outerWidth()/d),v=Math.ceil(p.outerHeight()/u),b=[];for(o=0;u>o;o++)for(h=m.top+o*v,c=o-(u-1)/2,a=0;d>a;a++)r=m.left+a*_,l=a-(d-1)/2,p.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",visibility:"visible",left:-a*_,top:-o*v}).parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:_,height:v,left:r+(g?l*_:0),top:h+(g?c*v:0),opacity:g?0:1}).animate({left:r+(g?0:l*_),top:h+(g?0:c*v),opacity:g?1:0},e.duration||500,e.easing,s)}),t.effects.define("fade","toggle",function(e,i){var s="show"===e.mode;t(this).css("opacity",s?0:1).animate({opacity:s?1:0},{queue:!1,duration:e.duration,easing:e.easing,complete:i})}),t.effects.define("fold","hide",function(e,i){var s=t(this),n=e.mode,o="show"===n,a="hide"===n,r=e.size||15,h=/([0-9]+)%/.exec(r),l=!!e.horizFirst,c=l?["right","bottom"]:["bottom","right"],u=e.duration/2,d=t.effects.createPlaceholder(s),p=s.cssClip(),f={clip:t.extend({},p)},g={clip:t.extend({},p)},m=[p[c[0]],p[c[1]]],_=s.queue().length;h&&(r=parseInt(h[1],10)/100*m[a?0:1]),f.clip[c[0]]=r,g.clip[c[0]]=r,g.clip[c[1]]=0,o&&(s.cssClip(g.clip),d&&d.css(t.effects.clipToBox(g)),g.clip=p),s.queue(function(i){d&&d.animate(t.effects.clipToBox(f),u,e.easing).animate(t.effects.clipToBox(g),u,e.easing),i()}).animate(f,u,e.easing).animate(g,u,e.easing).queue(i),t.effects.unshift(s,_,4)}),t.effects.define("highlight","show",function(e,i){var s=t(this),n={backgroundColor:s.css("backgroundColor")};"hide"===e.mode&&(n.opacity=0),t.effects.saveStyle(s),s.css({backgroundImage:"none",backgroundColor:e.color||"#ffff99"}).animate(n,{queue:!1,duration:e.duration,easing:e.easing,complete:i})}),t.effects.define("size",function(e,i){var s,n,o,a=t(this),r=["fontSize"],h=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],l=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],c=e.mode,u="effect"!==c,d=e.scale||"both",p=e.origin||["middle","center"],f=a.css("position"),g=a.position(),m=t.effects.scaledDimensions(a),_=e.from||m,v=e.to||t.effects.scaledDimensions(a,0);t.effects.createPlaceholder(a),"show"===c&&(o=_,_=v,v=o),n={from:{y:_.height/m.height,x:_.width/m.width},to:{y:v.height/m.height,x:v.width/m.width}},("box"===d||"both"===d)&&(n.from.y!==n.to.y&&(_=t.effects.setTransition(a,h,n.from.y,_),v=t.effects.setTransition(a,h,n.to.y,v)),n.from.x!==n.to.x&&(_=t.effects.setTransition(a,l,n.from.x,_),v=t.effects.setTransition(a,l,n.to.x,v))),("content"===d||"both"===d)&&n.from.y!==n.to.y&&(_=t.effects.setTransition(a,r,n.from.y,_),v=t.effects.setTransition(a,r,n.to.y,v)),p&&(s=t.effects.getBaseline(p,m),_.top=(m.outerHeight-_.outerHeight)*s.y+g.top,_.left=(m.outerWidth-_.outerWidth)*s.x+g.left,v.top=(m.outerHeight-v.outerHeight)*s.y+g.top,v.left=(m.outerWidth-v.outerWidth)*s.x+g.left),a.css(_),("content"===d||"both"===d)&&(h=h.concat(["marginTop","marginBottom"]).concat(r),l=l.concat(["marginLeft","marginRight"]),a.find("*[width]").each(function(){var i=t(this),s=t.effects.scaledDimensions(i),o={height:s.height*n.from.y,width:s.width*n.from.x,outerHeight:s.outerHeight*n.from.y,outerWidth:s.outerWidth*n.from.x},a={height:s.height*n.to.y,width:s.width*n.to.x,outerHeight:s.height*n.to.y,outerWidth:s.width*n.to.x};n.from.y!==n.to.y&&(o=t.effects.setTransition(i,h,n.from.y,o),a=t.effects.setTransition(i,h,n.to.y,a)),n.from.x!==n.to.x&&(o=t.effects.setTransition(i,l,n.from.x,o),a=t.effects.setTransition(i,l,n.to.x,a)),u&&t.effects.saveStyle(i),i.css(o),i.animate(a,e.duration,e.easing,function(){u&&t.effects.restoreStyle(i)})})),a.animate(v,{queue:!1,duration:e.duration,easing:e.easing,complete:function(){var e=a.offset();0===v.opacity&&a.css("opacity",_.opacity),u||(a.css("position","static"===f?"relative":f).offset(e),t.effects.saveStyle(a)),i()}})}),t.effects.define("scale",function(e,i){var s=t(this),n=e.mode,o=parseInt(e.percent,10)||(0===parseInt(e.percent,10)?0:"effect"!==n?0:100),a=t.extend(!0,{from:t.effects.scaledDimensions(s),to:t.effects.scaledDimensions(s,o,e.direction||"both"),origin:e.origin||["middle","center"]},e);e.fade&&(a.from.opacity=1,a.to.opacity=0),t.effects.effect.size.call(this,a,i)}),t.effects.define("puff","hide",function(e,i){var s=t.extend(!0,{},e,{fade:!0,percent:parseInt(e.percent,10)||150});t.effects.effect.scale.call(this,s,i)}),t.effects.define("pulsate","show",function(e,i){var s=t(this),n=e.mode,o="show"===n,a="hide"===n,r=o||a,h=2*(e.times||5)+(r?1:0),l=e.duration/h,c=0,u=1,d=s.queue().length;for((o||!s.is(":visible"))&&(s.css("opacity",0).show(),c=1);h>u;u++)s.animate({opacity:c},l,e.easing),c=1-c;s.animate({opacity:c},l,e.easing),s.queue(i),t.effects.unshift(s,d,h+1)}),t.effects.define("shake",function(e,i){var s=1,n=t(this),o=e.direction||"left",a=e.distance||20,r=e.times||3,h=2*r+1,l=Math.round(e.duration/h),c="up"===o||"down"===o?"top":"left",u="up"===o||"left"===o,d={},p={},f={},g=n.queue().length;for(t.effects.createPlaceholder(n),d[c]=(u?"-=":"+=")+a,p[c]=(u?"+=":"-=")+2*a,f[c]=(u?"-=":"+=")+2*a,n.animate(d,l,e.easing);r>s;s++)n.animate(p,l,e.easing).animate(f,l,e.easing);n.animate(p,l,e.easing).animate(d,l/2,e.easing).queue(i),t.effects.unshift(n,g,h+1)}),t.effects.define("slide","show",function(e,i){var s,n,o=t(this),a={up:["bottom","top"],down:["top","bottom"],left:["right","left"],right:["left","right"]},r=e.mode,h=e.direction||"left",l="up"===h||"down"===h?"top":"left",c="up"===h||"left"===h,u=e.distance||o["top"===l?"outerHeight":"outerWidth"](!0),d={};t.effects.createPlaceholder(o),s=o.cssClip(),n=o.position()[l],d[l]=(c?-1:1)*u+n,d.clip=o.cssClip(),d.clip[a[h][1]]=d.clip[a[h][0]],"show"===r&&(o.cssClip(d.clip),o.css(l,d[l]),d.clip=s,d[l]=n),o.animate(d,{queue:!1,duration:e.duration,easing:e.easing,complete:i})});var f;t.uiBackCompat!==!1&&(f=t.effects.define("transfer",function(e,i){t(this).transfer(e,i)})),t.ui.focusable=function(i,s){var n,o,a,r,h,l=i.nodeName.toLowerCase();return"area"===l?(n=i.parentNode,o=n.name,i.href&&o&&"map"===n.nodeName.toLowerCase()?(a=t("img[usemap='#"+o+"']"),a.length>0&&a.is(":visible")):!1):(/^(input|select|textarea|button|object)$/.test(l)?(r=!i.disabled,r&&(h=t(i).closest("fieldset")[0],h&&(r=!h.disabled))):r="a"===l?i.href||s:s,r&&t(i).is(":visible")&&e(t(i)))},t.extend(t.expr[":"],{focusable:function(e){return t.ui.focusable(e,null!=t.attr(e,"tabindex"))}}),t.ui.focusable,t.fn.form=function(){return"string"==typeof this[0].form?this.closest("form"):t(this[0].form)},t.ui.formResetMixin={_formResetHandler:function(){var e=t(this);setTimeout(function(){var i=e.data("ui-form-reset-instances");t.each(i,function(){this.refresh()})})},_bindFormResetHandler:function(){if(this.form=this.element.form(),this.form.length){var t=this.form.data("ui-form-reset-instances")||[];t.length||this.form.on("reset.ui-form-reset",this._formResetHandler),t.push(this),this.form.data("ui-form-reset-instances",t)}},_unbindFormResetHandler:function(){if(this.form.length){var e=this.form.data("ui-form-reset-instances");e.splice(t.inArray(this,e),1),e.length?this.form.data("ui-form-reset-instances",e):this.form.removeData("ui-form-reset-instances").off("reset.ui-form-reset")}}},"1.7"===t.fn.jquery.substring(0,3)&&(t.each(["Width","Height"],function(e,i){function s(e,i,s,o){return t.each(n,function(){i-=parseFloat(t.css(e,"padding"+this))||0,s&&(i-=parseFloat(t.css(e,"border"+this+"Width"))||0),o&&(i-=parseFloat(t.css(e,"margin"+this))||0)}),i}var n="Width"===i?["Left","Right"]:["Top","Bottom"],o=i.toLowerCase(),a={innerWidth:t.fn.innerWidth,innerHeight:t.fn.innerHeight,outerWidth:t.fn.outerWidth,outerHeight:t.fn.outerHeight};t.fn["inner"+i]=function(e){return void 0===e?a["inner"+i].call(this):this.each(function(){t(this).css(o,s(this,e)+"px")})},t.fn["outer"+i]=function(e,n){return"number"!=typeof e?a["outer"+i].call(this,e):this.each(function(){t(this).css(o,s(this,e,!0,n)+"px")})}}),t.fn.addBack=function(t){return this.add(null==t?this.prevObject:this.prevObject.filter(t))}),t.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38},t.ui.escapeSelector=function(){var t=/([!"#$%&'()*+,.\/:;<=>?@[\]^`{|}~])/g;return function(e){return e.replace(t,"\\$1")}}(),t.fn.labels=function(){var e,i,s,n,o;return this[0].labels&&this[0].labels.length?this.pushStack(this[0].labels):(n=this.eq(0).parents("label"),s=this.attr("id"),s&&(e=this.eq(0).parents().last(),o=e.add(e.length?e.siblings():this.siblings()),i="label[for='"+t.ui.escapeSelector(s)+"']",n=n.add(o.find(i).addBack(i))),this.pushStack(n))},t.fn.scrollParent=function(e){var i=this.css("position"),s="absolute"===i,n=e?/(auto|scroll|hidden)/:/(auto|scroll)/,o=this.parents().filter(function(){var e=t(this);return s&&"static"===e.css("position")?!1:n.test(e.css("overflow")+e.css("overflow-y")+e.css("overflow-x"))}).eq(0);return"fixed"!==i&&o.length?o:t(this[0].ownerDocument||document)},t.extend(t.expr[":"],{tabbable:function(e){var i=t.attr(e,"tabindex"),s=null!=i;return(!s||i>=0)&&t.ui.focusable(e,s)}}),t.fn.extend({uniqueId:function(){var t=0;return function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++t)})}}(),removeUniqueId:function(){return this.each(function(){/^ui-id-\d+$/.test(this.id)&&t(this).removeAttr("id")})}}),t.widget("ui.accordion",{version:"1.12.1",options:{active:0,animate:{},classes:{"ui-accordion-header":"ui-corner-top","ui-accordion-header-collapsed":"ui-corner-all","ui-accordion-content":"ui-corner-bottom"},collapsible:!1,event:"click",header:"> li > :first-child, > :not(li):even",heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},activate:null,beforeActivate:null},hideProps:{borderTopWidth:"hide",borderBottomWidth:"hide",paddingTop:"hide",paddingBottom:"hide",height:"hide"},showProps:{borderTopWidth:"show",borderBottomWidth:"show",paddingTop:"show",paddingBottom:"show",height:"show"},_create:function(){var e=this.options;this.prevShow=this.prevHide=t(),this._addClass("ui-accordion","ui-widget ui-helper-reset"),this.element.attr("role","tablist"),e.collapsible||e.active!==!1&&null!=e.active||(e.active=0),this._processPanels(),0>e.active&&(e.active+=this.headers.length),this._refresh()},_getCreateEventData:function(){return{header:this.active,panel:this.active.length?this.active.next():t()}},_createIcons:function(){var e,i,s=this.options.icons;s&&(e=t("<span>"),this._addClass(e,"ui-accordion-header-icon","ui-icon "+s.header),e.prependTo(this.headers),i=this.active.children(".ui-accordion-header-icon"),this._removeClass(i,s.header)._addClass(i,null,s.activeHeader)._addClass(this.headers,"ui-accordion-icons"))},_destroyIcons:function(){this._removeClass(this.headers,"ui-accordion-icons"),this.headers.children(".ui-accordion-header-icon").remove()},_destroy:function(){var t;this.element.removeAttr("role"),this.headers.removeAttr("role aria-expanded aria-selected aria-controls tabIndex").removeUniqueId(),this._destroyIcons(),t=this.headers.next().css("display","").removeAttr("role aria-hidden aria-labelledby").removeUniqueId(),"content"!==this.options.heightStyle&&t.css("height","")},_setOption:function(t,e){return"active"===t?(this._activate(e),void 0):("event"===t&&(this.options.event&&this._off(this.headers,this.options.event),this._setupEvents(e)),this._super(t,e),"collapsible"!==t||e||this.options.active!==!1||this._activate(0),"icons"===t&&(this._destroyIcons(),e&&this._createIcons()),void 0)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t),this._toggleClass(null,"ui-state-disabled",!!t),this._toggleClass(this.headers.add(this.headers.next()),null,"ui-state-disabled",!!t)},_keydown:function(e){if(!e.altKey&&!e.ctrlKey){var i=t.ui.keyCode,s=this.headers.length,n=this.headers.index(e.target),o=!1;switch(e.keyCode){case i.RIGHT:case i.DOWN:o=this.headers[(n+1)%s];break;case i.LEFT:case i.UP:o=this.headers[(n-1+s)%s];break;case i.SPACE:case i.ENTER:this._eventHandler(e);break;case i.HOME:o=this.headers[0];break;case i.END:o=this.headers[s-1]}o&&(t(e.target).attr("tabIndex",-1),t(o).attr("tabIndex",0),t(o).trigger("focus"),e.preventDefault())}},_panelKeyDown:function(e){e.keyCode===t.ui.keyCode.UP&&e.ctrlKey&&t(e.currentTarget).prev().trigger("focus")},refresh:function(){var e=this.options;this._processPanels(),e.active===!1&&e.collapsible===!0||!this.headers.length?(e.active=!1,this.active=t()):e.active===!1?this._activate(0):this.active.length&&!t.contains(this.element[0],this.active[0])?this.headers.length===this.headers.find(".ui-state-disabled").length?(e.active=!1,this.active=t()):this._activate(Math.max(0,e.active-1)):e.active=this.headers.index(this.active),this._destroyIcons(),this._refresh()},_processPanels:function(){var t=this.headers,e=this.panels;this.headers=this.element.find(this.options.header),this._addClass(this.headers,"ui-accordion-header ui-accordion-header-collapsed","ui-state-default"),this.panels=this.headers.next().filter(":not(.ui-accordion-content-active)").hide(),this._addClass(this.panels,"ui-accordion-content","ui-helper-reset ui-widget-content"),e&&(this._off(t.not(this.headers)),this._off(e.not(this.panels)))},_refresh:function(){var e,i=this.options,s=i.heightStyle,n=this.element.parent();this.active=this._findActive(i.active),this._addClass(this.active,"ui-accordion-header-active","ui-state-active")._removeClass(this.active,"ui-accordion-header-collapsed"),this._addClass(this.active.next(),"ui-accordion-content-active"),this.active.next().show(),this.headers.attr("role","tab").each(function(){var e=t(this),i=e.uniqueId().attr("id"),s=e.next(),n=s.uniqueId().attr("id");e.attr("aria-controls",n),s.attr("aria-labelledby",i)}).next().attr("role","tabpanel"),this.headers.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}).next().attr({"aria-hidden":"true"}).hide(),this.active.length?this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}).next().attr({"aria-hidden":"false"}):this.headers.eq(0).attr("tabIndex",0),this._createIcons(),this._setupEvents(i.event),"fill"===s?(e=n.height(),this.element.siblings(":visible").each(function(){var i=t(this),s=i.css("position");"absolute"!==s&&"fixed"!==s&&(e-=i.outerHeight(!0))}),this.headers.each(function(){e-=t(this).outerHeight(!0)}),this.headers.next().each(function(){t(this).height(Math.max(0,e-t(this).innerHeight()+t(this).height()))}).css("overflow","auto")):"auto"===s&&(e=0,this.headers.next().each(function(){var i=t(this).is(":visible");i||t(this).show(),e=Math.max(e,t(this).css("height","").height()),i||t(this).hide()}).height(e))},_activate:function(e){var i=this._findActive(e)[0];i!==this.active[0]&&(i=i||this.active[0],this._eventHandler({target:i,currentTarget:i,preventDefault:t.noop}))},_findActive:function(e){return"number"==typeof e?this.headers.eq(e):t()},_setupEvents:function(e){var i={keydown:"_keydown"};e&&t.each(e.split(" "),function(t,e){i[e]="_eventHandler"}),this._off(this.headers.add(this.headers.next())),this._on(this.headers,i),this._on(this.headers.next(),{keydown:"_panelKeyDown"}),this._hoverable(this.headers),this._focusable(this.headers)},_eventHandler:function(e){var i,s,n=this.options,o=this.active,a=t(e.currentTarget),r=a[0]===o[0],h=r&&n.collapsible,l=h?t():a.next(),c=o.next(),u={oldHeader:o,oldPanel:c,newHeader:h?t():a,newPanel:l};e.preventDefault(),r&&!n.collapsible||this._trigger("beforeActivate",e,u)===!1||(n.active=h?!1:this.headers.index(a),this.active=r?t():a,this._toggle(u),this._removeClass(o,"ui-accordion-header-active","ui-state-active"),n.icons&&(i=o.children(".ui-accordion-header-icon"),this._removeClass(i,null,n.icons.activeHeader)._addClass(i,null,n.icons.header)),r||(this._removeClass(a,"ui-accordion-header-collapsed")._addClass(a,"ui-accordion-header-active","ui-state-active"),n.icons&&(s=a.children(".ui-accordion-header-icon"),this._removeClass(s,null,n.icons.header)._addClass(s,null,n.icons.activeHeader)),this._addClass(a.next(),"ui-accordion-content-active")))},_toggle:function(e){var i=e.newPanel,s=this.prevShow.length?this.prevShow:e.oldPanel;this.prevShow.add(this.prevHide).stop(!0,!0),this.prevShow=i,this.prevHide=s,this.options.animate?this._animate(i,s,e):(s.hide(),i.show(),this._toggleComplete(e)),s.attr({"aria-hidden":"true"}),s.prev().attr({"aria-selected":"false","aria-expanded":"false"}),i.length&&s.length?s.prev().attr({tabIndex:-1,"aria-expanded":"false"}):i.length&&this.headers.filter(function(){return 0===parseInt(t(this).attr("tabIndex"),10)}).attr("tabIndex",-1),i.attr("aria-hidden","false").prev().attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0})},_animate:function(t,e,i){var s,n,o,a=this,r=0,h=t.css("box-sizing"),l=t.length&&(!e.length||t.index()<e.index()),c=this.options.animate||{},u=l&&c.down||c,d=function(){a._toggleComplete(i)};return"number"==typeof u&&(o=u),"string"==typeof u&&(n=u),n=n||u.easing||c.easing,o=o||u.duration||c.duration,e.length?t.length?(s=t.show().outerHeight(),e.animate(this.hideProps,{duration:o,easing:n,step:function(t,e){e.now=Math.round(t)}}),t.hide().animate(this.showProps,{duration:o,easing:n,complete:d,step:function(t,i){i.now=Math.round(t),"height"!==i.prop?"content-box"===h&&(r+=i.now):"content"!==a.options.heightStyle&&(i.now=Math.round(s-e.outerHeight()-r),r=0)}}),void 0):e.animate(this.hideProps,o,n,d):t.animate(this.showProps,o,n,d)},_toggleComplete:function(t){var e=t.oldPanel,i=e.prev();this._removeClass(e,"ui-accordion-content-active"),this._removeClass(i,"ui-accordion-header-active")._addClass(i,"ui-accordion-header-collapsed"),e.length&&(e.parent()[0].className=e.parent()[0].className),this._trigger("activate",null,t)}}),t.ui.safeActiveElement=function(t){var e;try{e=t.activeElement}catch(i){e=t.body}return e||(e=t.body),e.nodeName||(e=t.body),e},t.widget("ui.menu",{version:"1.12.1",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-caret-1-e"},items:"> *",menus:"ul",position:{my:"left top",at:"right top"},role:"menu",blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element,this.mouseHandled=!1,this.element.uniqueId().attr({role:this.options.role,tabIndex:0}),this._addClass("ui-menu","ui-widget ui-widget-content"),this._on({"mousedown .ui-menu-item":function(t){t.preventDefault()},"click .ui-menu-item":function(e){var i=t(e.target),s=t(t.ui.safeActiveElement(this.document[0]));!this.mouseHandled&&i.not(".ui-state-disabled").length&&(this.select(e),e.isPropagationStopped()||(this.mouseHandled=!0),i.has(".ui-menu").length?this.expand(e):!this.element.is(":focus")&&s.closest(".ui-menu").length&&(this.element.trigger("focus",[!0]),this.active&&1===this.active.parents(".ui-menu").length&&clearTimeout(this.timer)))},"mouseenter .ui-menu-item":function(e){if(!this.previousFilter){var i=t(e.target).closest(".ui-menu-item"),s=t(e.currentTarget);i[0]===s[0]&&(this._removeClass(s.siblings().children(".ui-state-active"),null,"ui-state-active"),this.focus(e,s))}},mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function(t,e){var i=this.active||this.element.find(this.options.items).eq(0);e||this.focus(t,i)},blur:function(e){this._delay(function(){var i=!t.contains(this.element[0],t.ui.safeActiveElement(this.document[0]));i&&this.collapseAll(e)})},keydown:"_keydown"}),this.refresh(),this._on(this.document,{click:function(t){this._closeOnDocumentClick(t)&&this.collapseAll(t),this.mouseHandled=!1}})},_destroy:function(){var e=this.element.find(".ui-menu-item").removeAttr("role aria-disabled"),i=e.children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled tabIndex").removeUniqueId().show(),i.children().each(function(){var e=t(this);e.data("ui-menu-submenu-caret")&&e.remove()})},_keydown:function(e){var i,s,n,o,a=!0;switch(e.keyCode){case t.ui.keyCode.PAGE_UP:this.previousPage(e);break;case t.ui.keyCode.PAGE_DOWN:this.nextPage(e);break;case t.ui.keyCode.HOME:this._move("first","first",e);break;case t.ui.keyCode.END:this._move("last","last",e);break;case t.ui.keyCode.UP:this.previous(e);break;case t.ui.keyCode.DOWN:this.next(e);break;case t.ui.keyCode.LEFT:this.collapse(e);break;case t.ui.keyCode.RIGHT:this.active&&!this.active.is(".ui-state-disabled")&&this.expand(e);break;case t.ui.keyCode.ENTER:case t.ui.keyCode.SPACE:this._activate(e);break;case t.ui.keyCode.ESCAPE:this.collapse(e);break;default:a=!1,s=this.previousFilter||"",o=!1,n=e.keyCode>=96&&105>=e.keyCode?""+(e.keyCode-96):String.fromCharCode(e.keyCode),clearTimeout(this.filterTimer),n===s?o=!0:n=s+n,i=this._filterMenuItems(n),i=o&&-1!==i.index(this.active.next())?this.active.nextAll(".ui-menu-item"):i,i.length||(n=String.fromCharCode(e.keyCode),i=this._filterMenuItems(n)),i.length?(this.focus(e,i),this.previousFilter=n,this.filterTimer=this._delay(function(){delete this.previousFilter},1e3)):delete this.previousFilter}a&&e.preventDefault()},_activate:function(t){this.active&&!this.active.is(".ui-state-disabled")&&(this.active.children("[aria-haspopup='true']").length?this.expand(t):this.select(t))},refresh:function(){var e,i,s,n,o,a=this,r=this.options.icons.submenu,h=this.element.find(this.options.menus);this._toggleClass("ui-menu-icons",null,!!this.element.find(".ui-icon").length),s=h.filter(":not(.ui-menu)").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var e=t(this),i=e.prev(),s=t("<span>").data("ui-menu-submenu-caret",!0);a._addClass(s,"ui-menu-icon","ui-icon "+r),i.attr("aria-haspopup","true").prepend(s),e.attr("aria-labelledby",i.attr("id"))}),this._addClass(s,"ui-menu","ui-widget ui-widget-content ui-front"),e=h.add(this.element),i=e.find(this.options.items),i.not(".ui-menu-item").each(function(){var e=t(this);a._isDivider(e)&&a._addClass(e,"ui-menu-divider","ui-widget-content")}),n=i.not(".ui-menu-item, .ui-menu-divider"),o=n.children().not(".ui-menu").uniqueId().attr({tabIndex:-1,role:this._itemRole()}),this._addClass(n,"ui-menu-item")._addClass(o,"ui-menu-item-wrapper"),i.filter(".ui-state-disabled").attr("aria-disabled","true"),this.active&&!t.contains(this.element[0],this.active[0])&&this.blur()},_itemRole:function(){return{menu:"menuitem",listbox:"option"}[this.options.role]},_setOption:function(t,e){if("icons"===t){var i=this.element.find(".ui-menu-icon");this._removeClass(i,null,this.options.icons.submenu)._addClass(i,null,e.submenu)}this._super(t,e)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t+""),this._toggleClass(null,"ui-state-disabled",!!t)},focus:function(t,e){var i,s,n;this.blur(t,t&&"focus"===t.type),this._scrollIntoView(e),this.active=e.first(),s=this.active.children(".ui-menu-item-wrapper"),this._addClass(s,null,"ui-state-active"),this.options.role&&this.element.attr("aria-activedescendant",s.attr("id")),n=this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper"),this._addClass(n,null,"ui-state-active"),t&&"keydown"===t.type?this._close():this.timer=this._delay(function(){this._close()},this.delay),i=e.children(".ui-menu"),i.length&&t&&/^mouse/.test(t.type)&&this._startOpening(i),this.activeMenu=e.parent(),this._trigger("focus",t,{item:e})},_scrollIntoView:function(e){var i,s,n,o,a,r;this._hasScroll()&&(i=parseFloat(t.css(this.activeMenu[0],"borderTopWidth"))||0,s=parseFloat(t.css(this.activeMenu[0],"paddingTop"))||0,n=e.offset().top-this.activeMenu.offset().top-i-s,o=this.activeMenu.scrollTop(),a=this.activeMenu.height(),r=e.outerHeight(),0>n?this.activeMenu.scrollTop(o+n):n+r>a&&this.activeMenu.scrollTop(o+n-a+r))},blur:function(t,e){e||clearTimeout(this.timer),this.active&&(this._removeClass(this.active.children(".ui-menu-item-wrapper"),null,"ui-state-active"),this._trigger("blur",t,{item:this.active}),this.active=null)},_startOpening:function(t){clearTimeout(this.timer),"true"===t.attr("aria-hidden")&&(this.timer=this._delay(function(){this._close(),this._open(t)},this.delay))},_open:function(e){var i=t.extend({of:this.active},this.options.position);clearTimeout(this.timer),this.element.find(".ui-menu").not(e.parents(".ui-menu")).hide().attr("aria-hidden","true"),e.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(i)},collapseAll:function(e,i){clearTimeout(this.timer),this.timer=this._delay(function(){var s=i?this.element:t(e&&e.target).closest(this.element.find(".ui-menu"));s.length||(s=this.element),this._close(s),this.blur(e),this._removeClass(s.find(".ui-state-active"),null,"ui-state-active"),this.activeMenu=s},this.delay)},_close:function(t){t||(t=this.active?this.active.parent():this.element),t.find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false")},_closeOnDocumentClick:function(e){return!t(e.target).closest(".ui-menu").length},_isDivider:function(t){return!/[^\-\u2014\u2013\s]/.test(t.text())},collapse:function(t){var e=this.active&&this.active.parent().closest(".ui-menu-item",this.element);e&&e.length&&(this._close(),this.focus(t,e))},expand:function(t){var e=this.active&&this.active.children(".ui-menu ").find(this.options.items).first();e&&e.length&&(this._open(e.parent()),this._delay(function(){this.focus(t,e)}))},next:function(t){this._move("next","first",t)},previous:function(t){this._move("prev","last",t)},isFirstItem:function(){return this.active&&!this.active.prevAll(".ui-menu-item").length},isLastItem:function(){return this.active&&!this.active.nextAll(".ui-menu-item").length},_move:function(t,e,i){var s;this.active&&(s="first"===t||"last"===t?this.active["first"===t?"prevAll":"nextAll"](".ui-menu-item").eq(-1):this.active[t+"All"](".ui-menu-item").eq(0)),s&&s.length&&this.active||(s=this.activeMenu.find(this.options.items)[e]()),this.focus(i,s)},nextPage:function(e){var i,s,n;return this.active?(this.isLastItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.nextAll(".ui-menu-item").each(function(){return i=t(this),0>i.offset().top-s-n}),this.focus(e,i)):this.focus(e,this.activeMenu.find(this.options.items)[this.active?"last":"first"]())),void 0):(this.next(e),void 0)},previousPage:function(e){var i,s,n;return this.active?(this.isFirstItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.prevAll(".ui-menu-item").each(function(){return i=t(this),i.offset().top-s+n>0}),this.focus(e,i)):this.focus(e,this.activeMenu.find(this.options.items).first())),void 0):(this.next(e),void 0)},_hasScroll:function(){return this.element.outerHeight()<this.element.prop("scrollHeight")},select:function(e){this.active=this.active||t(e.target).closest(".ui-menu-item");var i={item:this.active};this.active.has(".ui-menu").length||this.collapseAll(e,!0),this._trigger("select",e,i)},_filterMenuItems:function(e){var i=e.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&"),s=RegExp("^"+i,"i");return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function(){return s.test(t.trim(t(this).children(".ui-menu-item-wrapper").text()))})}}),t.widget("ui.autocomplete",{version:"1.12.1",defaultElement:"<input>",options:{appendTo:null,autoFocus:!1,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},requestIndex:0,pending:0,_create:function(){var e,i,s,n=this.element[0].nodeName.toLowerCase(),o="textarea"===n,a="input"===n;this.isMultiLine=o||!a&&this._isContentEditable(this.element),this.valueMethod=this.element[o||a?"val":"text"],this.isNewMenu=!0,this._addClass("ui-autocomplete-input"),this.element.attr("autocomplete","off"),this._on(this.element,{keydown:function(n){if(this.element.prop("readOnly"))return e=!0,s=!0,i=!0,void 0;e=!1,s=!1,i=!1;var o=t.ui.keyCode;switch(n.keyCode){case o.PAGE_UP:e=!0,this._move("previousPage",n);break;case o.PAGE_DOWN:e=!0,this._move("nextPage",n);break;case o.UP:e=!0,this._keyEvent("previous",n);break;case o.DOWN:e=!0,this._keyEvent("next",n);break;case o.ENTER:this.menu.active&&(e=!0,n.preventDefault(),this.menu.select(n));break;case o.TAB:this.menu.active&&this.menu.select(n);break;case o.ESCAPE:this.menu.element.is(":visible")&&(this.isMultiLine||this._value(this.term),this.close(n),n.preventDefault());break;default:i=!0,this._searchTimeout(n)}},keypress:function(s){if(e)return e=!1,(!this.isMultiLine||this.menu.element.is(":visible"))&&s.preventDefault(),void 0;if(!i){var n=t.ui.keyCode;switch(s.keyCode){case n.PAGE_UP:this._move("previousPage",s);break;case n.PAGE_DOWN:this._move("nextPage",s);break;case n.UP:this._keyEvent("previous",s);break;case n.DOWN:this._keyEvent("next",s)}}},input:function(t){return s?(s=!1,t.preventDefault(),void 0):(this._searchTimeout(t),void 0)},focus:function(){this.selectedItem=null,this.previous=this._value()},blur:function(t){return this.cancelBlur?(delete this.cancelBlur,void 0):(clearTimeout(this.searching),this.close(t),this._change(t),void 0)}}),this._initSource(),this.menu=t("<ul>").appendTo(this._appendTo()).menu({role:null}).hide().menu("instance"),this._addClass(this.menu.element,"ui-autocomplete","ui-front"),this._on(this.menu.element,{mousedown:function(e){e.preventDefault(),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur,this.element[0]!==t.ui.safeActiveElement(this.document[0])&&this.element.trigger("focus")})},menufocus:function(e,i){var s,n;return this.isNewMenu&&(this.isNewMenu=!1,e.originalEvent&&/^mouse/.test(e.originalEvent.type))?(this.menu.blur(),this.document.one("mousemove",function(){t(e.target).trigger(e.originalEvent)}),void 0):(n=i.item.data("ui-autocomplete-item"),!1!==this._trigger("focus",e,{item:n})&&e.originalEvent&&/^key/.test(e.originalEvent.type)&&this._value(n.value),s=i.item.attr("aria-label")||n.value,s&&t.trim(s).length&&(this.liveRegion.children().hide(),t("<div>").text(s).appendTo(this.liveRegion)),void 0)},menuselect:function(e,i){var s=i.item.data("ui-autocomplete-item"),n=this.previous;this.element[0]!==t.ui.safeActiveElement(this.document[0])&&(this.element.trigger("focus"),this.previous=n,this._delay(function(){this.previous=n,this.selectedItem=s})),!1!==this._trigger("select",e,{item:s})&&this._value(s.value),this.term=this._value(),this.close(e),this.selectedItem=s}}),this.liveRegion=t("<div>",{role:"status","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body),this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible"),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_destroy:function(){clearTimeout(this.searching),this.element.removeAttr("autocomplete"),this.menu.element.remove(),this.liveRegion.remove()},_setOption:function(t,e){this._super(t,e),"source"===t&&this._initSource(),"appendTo"===t&&this.menu.element.appendTo(this._appendTo()),"disabled"===t&&e&&this.xhr&&this.xhr.abort()},_isEventTargetInWidget:function(e){var i=this.menu.element[0];return e.target===this.element[0]||e.target===i||t.contains(i,e.target)},_closeOnClickOutside:function(t){this._isEventTargetInWidget(t)||this.close()},_appendTo:function(){var e=this.options.appendTo;return e&&(e=e.jquery||e.nodeType?t(e):this.document.find(e).eq(0)),e&&e[0]||(e=this.element.closest(".ui-front, dialog")),e.length||(e=this.document[0].body),e},_initSource:function(){var e,i,s=this;t.isArray(this.options.source)?(e=this.options.source,this.source=function(i,s){s(t.ui.autocomplete.filter(e,i.term))}):"string"==typeof this.options.source?(i=this.options.source,this.source=function(e,n){s.xhr&&s.xhr.abort(),s.xhr=t.ajax({url:i,data:e,dataType:"json",success:function(t){n(t)},error:function(){n([])}})}):this.source=this.options.source},_searchTimeout:function(t){clearTimeout(this.searching),this.searching=this._delay(function(){var e=this.term===this._value(),i=this.menu.element.is(":visible"),s=t.altKey||t.ctrlKey||t.metaKey||t.shiftKey;(!e||e&&!i&&!s)&&(this.selectedItem=null,this.search(null,t))},this.options.delay)},search:function(t,e){return t=null!=t?t:this._value(),this.term=this._value(),t.length<this.options.minLength?this.close(e):this._trigger("search",e)!==!1?this._search(t):void 0},_search:function(t){this.pending++,this._addClass("ui-autocomplete-loading"),this.cancelSearch=!1,this.source({term:t},this._response())},_response:function(){var e=++this.requestIndex;return t.proxy(function(t){e===this.requestIndex&&this.__response(t),this.pending--,this.pending||this._removeClass("ui-autocomplete-loading")},this)},__response:function(t){t&&(t=this._normalize(t)),this._trigger("response",null,{content:t}),!this.options.disabled&&t&&t.length&&!this.cancelSearch?(this._suggest(t),this._trigger("open")):this._close()},close:function(t){this.cancelSearch=!0,this._close(t)},_close:function(t){this._off(this.document,"mousedown"),this.menu.element.is(":visible")&&(this.menu.element.hide(),this.menu.blur(),this.isNewMenu=!0,this._trigger("close",t))},_change:function(t){this.previous!==this._value()&&this._trigger("change",t,{item:this.selectedItem})},_normalize:function(e){return e.length&&e[0].label&&e[0].value?e:t.map(e,function(e){return"string"==typeof e?{label:e,value:e}:t.extend({},e,{label:e.label||e.value,value:e.value||e.label})})},_suggest:function(e){var i=this.menu.element.empty();this._renderMenu(i,e),this.isNewMenu=!0,this.menu.refresh(),i.show(),this._resizeMenu(),i.position(t.extend({of:this.element},this.options.position)),this.options.autoFocus&&this.menu.next(),this._on(this.document,{mousedown:"_closeOnClickOutside"})},_resizeMenu:function(){var t=this.menu.element;t.outerWidth(Math.max(t.width("").outerWidth()+1,this.element.outerWidth()))},_renderMenu:function(e,i){var s=this;t.each(i,function(t,i){s._renderItemData(e,i)})},_renderItemData:function(t,e){return this._renderItem(t,e).data("ui-autocomplete-item",e)},_renderItem:function(e,i){return t("<li>").append(t("<div>").text(i.label)).appendTo(e)},_move:function(t,e){return this.menu.element.is(":visible")?this.menu.isFirstItem()&&/^previous/.test(t)||this.menu.isLastItem()&&/^next/.test(t)?(this.isMultiLine||this._value(this.term),this.menu.blur(),void 0):(this.menu[t](e),void 0):(this.search(null,e),void 0)},widget:function(){return this.menu.element},_value:function(){return this.valueMethod.apply(this.element,arguments)},_keyEvent:function(t,e){(!this.isMultiLine||this.menu.element.is(":visible"))&&(this._move(t,e),e.preventDefault())},_isContentEditable:function(t){if(!t.length)return!1;var e=t.prop("contentEditable");return"inherit"===e?this._isContentEditable(t.parent()):"true"===e}}),t.extend(t.ui.autocomplete,{escapeRegex:function(t){return t.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")},filter:function(e,i){var s=RegExp(t.ui.autocomplete.escapeRegex(i),"i");return t.grep(e,function(t){return s.test(t.label||t.value||t)})}}),t.widget("ui.autocomplete",t.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(t){return t+(t>1?" results are":" result is")+" available, use up and down arrow keys to navigate."}}},__response:function(e){var i;this._superApply(arguments),this.options.disabled||this.cancelSearch||(i=e&&e.length?this.options.messages.results(e.length):this.options.messages.noResults,this.liveRegion.children().hide(),t("<div>").text(i).appendTo(this.liveRegion))}}),t.ui.autocomplete;var g=/ui-corner-([a-z]){2,6}/g;t.widget("ui.controlgroup",{version:"1.12.1",defaultElement:"<div>",options:{direction:"horizontal",disabled:null,onlyVisible:!0,items:{button:"input[type=button], input[type=submit], input[type=reset], button, a",controlgroupLabel:".ui-controlgroup-label",checkboxradio:"input[type='checkbox'], input[type='radio']",selectmenu:"select",spinner:".ui-spinner-input"}},_create:function(){this._enhance()},_enhance:function(){this.element.attr("role","toolbar"),this.refresh()},_destroy:function(){this._callChildMethod("destroy"),this.childWidgets.removeData("ui-controlgroup-data"),this.element.removeAttr("role"),this.options.items.controlgroupLabel&&this.element.find(this.options.items.controlgroupLabel).find(".ui-controlgroup-label-contents").contents().unwrap()},_initWidgets:function(){var e=this,i=[];t.each(this.options.items,function(s,n){var o,a={};return n?"controlgroupLabel"===s?(o=e.element.find(n),o.each(function(){var e=t(this);e.children(".ui-controlgroup-label-contents").length||e.contents().wrapAll("<span class='ui-controlgroup-label-contents'></span>")}),e._addClass(o,null,"ui-widget ui-widget-content ui-state-default"),i=i.concat(o.get()),void 0):(t.fn[s]&&(a=e["_"+s+"Options"]?e["_"+s+"Options"]("middle"):{classes:{}},e.element.find(n).each(function(){var n=t(this),o=n[s]("instance"),r=t.widget.extend({},a);if("button"!==s||!n.parent(".ui-spinner").length){o||(o=n[s]()[s]("instance")),o&&(r.classes=e._resolveClassesValues(r.classes,o)),n[s](r);var h=n[s]("widget");t.data(h[0],"ui-controlgroup-data",o?o:n[s]("instance")),i.push(h[0])}})),void 0):void 0}),this.childWidgets=t(t.unique(i)),this._addClass(this.childWidgets,"ui-controlgroup-item")},_callChildMethod:function(e){this.childWidgets.each(function(){var i=t(this),s=i.data("ui-controlgroup-data");s&&s[e]&&s[e]()})},_updateCornerClass:function(t,e){var i="ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all",s=this._buildSimpleOptions(e,"label").classes.label;this._removeClass(t,null,i),this._addClass(t,null,s)},_buildSimpleOptions:function(t,e){var i="vertical"===this.options.direction,s={classes:{}};return s.classes[e]={middle:"",first:"ui-corner-"+(i?"top":"left"),last:"ui-corner-"+(i?"bottom":"right"),only:"ui-corner-all"}[t],s},_spinnerOptions:function(t){var e=this._buildSimpleOptions(t,"ui-spinner");return e.classes["ui-spinner-up"]="",e.classes["ui-spinner-down"]="",e},_buttonOptions:function(t){return this._buildSimpleOptions(t,"ui-button")},_checkboxradioOptions:function(t){return this._buildSimpleOptions(t,"ui-checkboxradio-label")},_selectmenuOptions:function(t){var e="vertical"===this.options.direction;return{width:e?"auto":!1,classes:{middle:{"ui-selectmenu-button-open":"","ui-selectmenu-button-closed":""},first:{"ui-selectmenu-button-open":"ui-corner-"+(e?"top":"tl"),"ui-selectmenu-button-closed":"ui-corner-"+(e?"top":"left")},last:{"ui-selectmenu-button-open":e?"":"ui-corner-tr","ui-selectmenu-button-closed":"ui-corner-"+(e?"bottom":"right")},only:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"}}[t]}},_resolveClassesValues:function(e,i){var s={};return t.each(e,function(n){var o=i.options.classes[n]||"";o=t.trim(o.replace(g,"")),s[n]=(o+" "+e[n]).replace(/\s+/g," ")}),s},_setOption:function(t,e){return"direction"===t&&this._removeClass("ui-controlgroup-"+this.options.direction),this._super(t,e),"disabled"===t?(this._callChildMethod(e?"disable":"enable"),void 0):(this.refresh(),void 0)},refresh:function(){var e,i=this;this._addClass("ui-controlgroup ui-controlgroup-"+this.options.direction),"horizontal"===this.options.direction&&this._addClass(null,"ui-helper-clearfix"),this._initWidgets(),e=this.childWidgets,this.options.onlyVisible&&(e=e.filter(":visible")),e.length&&(t.each(["first","last"],function(t,s){var n=e[s]().data("ui-controlgroup-data");if(n&&i["_"+n.widgetName+"Options"]){var o=i["_"+n.widgetName+"Options"](1===e.length?"only":s);o.classes=i._resolveClassesValues(o.classes,n),n.element[n.widgetName](o)}else i._updateCornerClass(e[s](),s)}),this._callChildMethod("refresh"))}}),t.widget("ui.checkboxradio",[t.ui.formResetMixin,{version:"1.12.1",options:{disabled:null,label:null,icon:!0,classes:{"ui-checkboxradio-label":"ui-corner-all","ui-checkboxradio-icon":"ui-corner-all"}},_getCreateOptions:function(){var e,i,s=this,n=this._super()||{};return this._readType(),i=this.element.labels(),this.label=t(i[i.length-1]),this.label.length||t.error("No label found for checkboxradio widget"),this.originalLabel="",this.label.contents().not(this.element[0]).each(function(){s.originalLabel+=3===this.nodeType?t(this).text():this.outerHTML}),this.originalLabel&&(n.label=this.originalLabel),e=this.element[0].disabled,null!=e&&(n.disabled=e),n},_create:function(){var t=this.element[0].checked;this._bindFormResetHandler(),null==this.options.disabled&&(this.options.disabled=this.element[0].disabled),this._setOption("disabled",this.options.disabled),this._addClass("ui-checkboxradio","ui-helper-hidden-accessible"),this._addClass(this.label,"ui-checkboxradio-label","ui-button ui-widget"),"radio"===this.type&&this._addClass(this.label,"ui-checkboxradio-radio-label"),this.options.label&&this.options.label!==this.originalLabel?this._updateLabel():this.originalLabel&&(this.options.label=this.originalLabel),this._enhance(),t&&(this._addClass(this.label,"ui-checkboxradio-checked","ui-state-active"),this.icon&&this._addClass(this.icon,null,"ui-state-hover")),this._on({change:"_toggleClasses",focus:function(){this._addClass(this.label,null,"ui-state-focus ui-visual-focus")},blur:function(){this._removeClass(this.label,null,"ui-state-focus ui-visual-focus")}})},_readType:function(){var e=this.element[0].nodeName.toLowerCase();this.type=this.element[0].type,"input"===e&&/radio|checkbox/.test(this.type)||t.error("Can't create checkboxradio on element.nodeName="+e+" and element.type="+this.type)},_enhance:function(){this._updateIcon(this.element[0].checked)},widget:function(){return this.label},_getRadioGroup:function(){var e,i=this.element[0].name,s="input[name='"+t.ui.escapeSelector(i)+"']";return i?(e=this.form.length?t(this.form[0].elements).filter(s):t(s).filter(function(){return 0===t(this).form().length}),e.not(this.element)):t([])},_toggleClasses:function(){var e=this.element[0].checked;this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",e),this.options.icon&&"checkbox"===this.type&&this._toggleClass(this.icon,null,"ui-icon-check ui-state-checked",e)._toggleClass(this.icon,null,"ui-icon-blank",!e),"radio"===this.type&&this._getRadioGroup().each(function(){var e=t(this).checkboxradio("instance");e&&e._removeClass(e.label,"ui-checkboxradio-checked","ui-state-active")})},_destroy:function(){this._unbindFormResetHandler(),this.icon&&(this.icon.remove(),this.iconSpace.remove())},_setOption:function(t,e){return"label"!==t||e?(this._super(t,e),"disabled"===t?(this._toggleClass(this.label,null,"ui-state-disabled",e),this.element[0].disabled=e,void 0):(this.refresh(),void 0)):void 0},_updateIcon:function(e){var i="ui-icon ui-icon-background ";this.options.icon?(this.icon||(this.icon=t("<span>"),this.iconSpace=t("<span> </span>"),this._addClass(this.iconSpace,"ui-checkboxradio-icon-space")),"checkbox"===this.type?(i+=e?"ui-icon-check ui-state-checked":"ui-icon-blank",this._removeClass(this.icon,null,e?"ui-icon-blank":"ui-icon-check")):i+="ui-icon-blank",this._addClass(this.icon,"ui-checkboxradio-icon",i),e||this._removeClass(this.icon,null,"ui-icon-check ui-state-checked"),this.icon.prependTo(this.label).after(this.iconSpace)):void 0!==this.icon&&(this.icon.remove(),this.iconSpace.remove(),delete this.icon)},_updateLabel:function(){var t=this.label.contents().not(this.element[0]);this.icon&&(t=t.not(this.icon[0])),this.iconSpace&&(t=t.not(this.iconSpace[0])),t.remove(),this.label.append(this.options.label)},refresh:function(){var t=this.element[0].checked,e=this.element[0].disabled;this._updateIcon(t),this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",t),null!==this.options.label&&this._updateLabel(),e!==this.options.disabled&&this._setOptions({disabled:e})}}]),t.ui.checkboxradio,t.widget("ui.button",{version:"1.12.1",defaultElement:"<button>",options:{classes:{"ui-button":"ui-corner-all"},disabled:null,icon:null,iconPosition:"beginning",label:null,showLabel:!0},_getCreateOptions:function(){var t,e=this._super()||{};return this.isInput=this.element.is("input"),t=this.element[0].disabled,null!=t&&(e.disabled=t),this.originalLabel=this.isInput?this.element.val():this.element.html(),this.originalLabel&&(e.label=this.originalLabel),e},_create:function(){!this.option.showLabel&!this.options.icon&&(this.options.showLabel=!0),null==this.options.disabled&&(this.options.disabled=this.element[0].disabled||!1),this.hasTitle=!!this.element.attr("title"),this.options.label&&this.options.label!==this.originalLabel&&(this.isInput?this.element.val(this.options.label):this.element.html(this.options.label)),this._addClass("ui-button","ui-widget"),this._setOption("disabled",this.options.disabled),this._enhance(),this.element.is("a")&&this._on({keyup:function(e){e.keyCode===t.ui.keyCode.SPACE&&(e.preventDefault(),this.element[0].click?this.element[0].click():this.element.trigger("click"))}})},_enhance:function(){this.element.is("button")||this.element.attr("role","button"),this.options.icon&&(this._updateIcon("icon",this.options.icon),this._updateTooltip())},_updateTooltip:function(){this.title=this.element.attr("title"),this.options.showLabel||this.title||this.element.attr("title",this.options.label)},_updateIcon:function(e,i){var s="iconPosition"!==e,n=s?this.options.iconPosition:i,o="top"===n||"bottom"===n;this.icon?s&&this._removeClass(this.icon,null,this.options.icon):(this.icon=t("<span>"),this._addClass(this.icon,"ui-button-icon","ui-icon"),this.options.showLabel||this._addClass("ui-button-icon-only")),s&&this._addClass(this.icon,null,i),this._attachIcon(n),o?(this._addClass(this.icon,null,"ui-widget-icon-block"),this.iconSpace&&this.iconSpace.remove()):(this.iconSpace||(this.iconSpace=t("<span> </span>"),this._addClass(this.iconSpace,"ui-button-icon-space")),this._removeClass(this.icon,null,"ui-wiget-icon-block"),this._attachIconSpace(n))},_destroy:function(){this.element.removeAttr("role"),this.icon&&this.icon.remove(),this.iconSpace&&this.iconSpace.remove(),this.hasTitle||this.element.removeAttr("title")},_attachIconSpace:function(t){this.icon[/^(?:end|bottom)/.test(t)?"before":"after"](this.iconSpace)},_attachIcon:function(t){this.element[/^(?:end|bottom)/.test(t)?"append":"prepend"](this.icon)},_setOptions:function(t){var e=void 0===t.showLabel?this.options.showLabel:t.showLabel,i=void 0===t.icon?this.options.icon:t.icon;e||i||(t.showLabel=!0),this._super(t)},_setOption:function(t,e){"icon"===t&&(e?this._updateIcon(t,e):this.icon&&(this.icon.remove(),this.iconSpace&&this.iconSpace.remove())),"iconPosition"===t&&this._updateIcon(t,e),"showLabel"===t&&(this._toggleClass("ui-button-icon-only",null,!e),this._updateTooltip()),"label"===t&&(this.isInput?this.element.val(e):(this.element.html(e),this.icon&&(this._attachIcon(this.options.iconPosition),this._attachIconSpace(this.options.iconPosition)))),this._super(t,e),"disabled"===t&&(this._toggleClass(null,"ui-state-disabled",e),this.element[0].disabled=e,e&&this.element.blur())},refresh:function(){var t=this.element.is("input, button")?this.element[0].disabled:this.element.hasClass("ui-button-disabled");t!==this.options.disabled&&this._setOptions({disabled:t}),this._updateTooltip()}}),t.uiBackCompat!==!1&&(t.widget("ui.button",t.ui.button,{options:{text:!0,icons:{primary:null,secondary:null}},_create:function(){this.options.showLabel&&!this.options.text&&(this.options.showLabel=this.options.text),!this.options.showLabel&&this.options.text&&(this.options.text=this.options.showLabel),this.options.icon||!this.options.icons.primary&&!this.options.icons.secondary?this.options.icon&&(this.options.icons.primary=this.options.icon):this.options.icons.primary?this.options.icon=this.options.icons.primary:(this.options.icon=this.options.icons.secondary,this.options.iconPosition="end"),this._super()},_setOption:function(t,e){return"text"===t?(this._super("showLabel",e),void 0):("showLabel"===t&&(this.options.text=e),"icon"===t&&(this.options.icons.primary=e),"icons"===t&&(e.primary?(this._super("icon",e.primary),this._super("iconPosition","beginning")):e.secondary&&(this._super("icon",e.secondary),this._super("iconPosition","end"))),this._superApply(arguments),void 0)}}),t.fn.button=function(e){return function(){return!this.length||this.length&&"INPUT"!==this[0].tagName||this.length&&"INPUT"===this[0].tagName&&"checkbox"!==this.attr("type")&&"radio"!==this.attr("type")?e.apply(this,arguments):(t.ui.checkboxradio||t.error("Checkboxradio widget missing"),0===arguments.length?this.checkboxradio({icon:!1}):this.checkboxradio.apply(this,arguments))}}(t.fn.button),t.fn.buttonset=function(){return t.ui.controlgroup||t.error("Controlgroup widget missing"),"option"===arguments[0]&&"items"===arguments[1]&&arguments[2]?this.controlgroup.apply(this,[arguments[0],"items.button",arguments[2]]):"option"===arguments[0]&&"items"===arguments[1]?this.controlgroup.apply(this,[arguments[0],"items.button"]):("object"==typeof arguments[0]&&arguments[0].items&&(arguments[0].items={button:arguments[0].items}),this.controlgroup.apply(this,arguments))}),t.ui.button,t.extend(t.ui,{datepicker:{version:"1.12.1"}});var m;t.extend(s.prototype,{markerClassName:"hasDatepicker",maxRows:4,_widgetDatepicker:function(){return this.dpDiv},setDefaults:function(t){return a(this._defaults,t||{}),this},_attachDatepicker:function(e,i){var s,n,o;s=e.nodeName.toLowerCase(),n="div"===s||"span"===s,e.id||(this.uuid+=1,e.id="dp"+this.uuid),o=this._newInst(t(e),n),o.settings=t.extend({},i||{}),"input"===s?this._connectDatepicker(e,o):n&&this._inlineDatepicker(e,o)},_newInst:function(e,i){var s=e[0].id.replace(/([^A-Za-z0-9_\-])/g,"\\\\$1");return{id:s,input:e,selectedDay:0,selectedMonth:0,selectedYear:0,drawMonth:0,drawYear:0,inline:i,dpDiv:i?n(t("<div class='"+this._inlineClass+" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")):this.dpDiv}},_connectDatepicker:function(e,i){var s=t(e);i.append=t([]),i.trigger=t([]),s.hasClass(this.markerClassName)||(this._attachments(s,i),s.addClass(this.markerClassName).on("keydown",this._doKeyDown).on("keypress",this._doKeyPress).on("keyup",this._doKeyUp),this._autoSize(i),t.data(e,"datepicker",i),i.settings.disabled&&this._disableDatepicker(e))},_attachments:function(e,i){var s,n,o,a=this._get(i,"appendText"),r=this._get(i,"isRTL");i.append&&i.append.remove(),a&&(i.append=t("<span class='"+this._appendClass+"'>"+a+"</span>"),e[r?"before":"after"](i.append)),e.off("focus",this._showDatepicker),i.trigger&&i.trigger.remove(),s=this._get(i,"showOn"),("focus"===s||"both"===s)&&e.on("focus",this._showDatepicker),("button"===s||"both"===s)&&(n=this._get(i,"buttonText"),o=this._get(i,"buttonImage"),i.trigger=t(this._get(i,"buttonImageOnly")?t("<img/>").addClass(this._triggerClass).attr({src:o,alt:n,title:n}):t("<button type='button'></button>").addClass(this._triggerClass).html(o?t("<img/>").attr({src:o,alt:n,title:n}):n)),e[r?"before":"after"](i.trigger),i.trigger.on("click",function(){return t.datepicker._datepickerShowing&&t.datepicker._lastInput===e[0]?t.datepicker._hideDatepicker():t.datepicker._datepickerShowing&&t.datepicker._lastInput!==e[0]?(t.datepicker._hideDatepicker(),t.datepicker._showDatepicker(e[0])):t.datepicker._showDatepicker(e[0]),!1}))},_autoSize:function(t){if(this._get(t,"autoSize")&&!t.inline){var e,i,s,n,o=new Date(2009,11,20),a=this._get(t,"dateFormat");a.match(/[DM]/)&&(e=function(t){for(i=0,s=0,n=0;t.length>n;n++)t[n].length>i&&(i=t[n].length,s=n);return s},o.setMonth(e(this._get(t,a.match(/MM/)?"monthNames":"monthNamesShort"))),o.setDate(e(this._get(t,a.match(/DD/)?"dayNames":"dayNamesShort"))+20-o.getDay())),t.input.attr("size",this._formatDate(t,o).length)}},_inlineDatepicker:function(e,i){var s=t(e);s.hasClass(this.markerClassName)||(s.addClass(this.markerClassName).append(i.dpDiv),t.data(e,"datepicker",i),this._setDate(i,this._getDefaultDate(i),!0),this._updateDatepicker(i),this._updateAlternate(i),i.settings.disabled&&this._disableDatepicker(e),i.dpDiv.css("display","block"))},_dialogDatepicker:function(e,i,s,n,o){var r,h,l,c,u,d=this._dialogInst;return d||(this.uuid+=1,r="dp"+this.uuid,this._dialogInput=t("<input type='text' id='"+r+"' style='position: absolute; top: -100px; width: 0px;'/>"),this._dialogInput.on("keydown",this._doKeyDown),t("body").append(this._dialogInput),d=this._dialogInst=this._newInst(this._dialogInput,!1),d.settings={},t.data(this._dialogInput[0],"datepicker",d)),a(d.settings,n||{}),i=i&&i.constructor===Date?this._formatDate(d,i):i,this._dialogInput.val(i),this._pos=o?o.length?o:[o.pageX,o.pageY]:null,this._pos||(h=document.documentElement.clientWidth,l=document.documentElement.clientHeight,c=document.documentElement.scrollLeft||document.body.scrollLeft,u=document.documentElement.scrollTop||document.body.scrollTop,this._pos=[h/2-100+c,l/2-150+u]),this._dialogInput.css("left",this._pos[0]+20+"px").css("top",this._pos[1]+"px"),d.settings.onSelect=s,this._inDialog=!0,this.dpDiv.addClass(this._dialogClass),this._showDatepicker(this._dialogInput[0]),t.blockUI&&t.blockUI(this.dpDiv),t.data(this._dialogInput[0],"datepicker",d),this},_destroyDatepicker:function(e){var i,s=t(e),n=t.data(e,"datepicker");s.hasClass(this.markerClassName)&&(i=e.nodeName.toLowerCase(),t.removeData(e,"datepicker"),"input"===i?(n.append.remove(),n.trigger.remove(),s.removeClass(this.markerClassName).off("focus",this._showDatepicker).off("keydown",this._doKeyDown).off("keypress",this._doKeyPress).off("keyup",this._doKeyUp)):("div"===i||"span"===i)&&s.removeClass(this.markerClassName).empty(),m===n&&(m=null))},_enableDatepicker:function(e){var i,s,n=t(e),o=t.data(e,"datepicker");n.hasClass(this.markerClassName)&&(i=e.nodeName.toLowerCase(),"input"===i?(e.disabled=!1,o.trigger.filter("button").each(function(){this.disabled=!1}).end().filter("img").css({opacity:"1.0",cursor:""})):("div"===i||"span"===i)&&(s=n.children("."+this._inlineClass),s.children().removeClass("ui-state-disabled"),s.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",!1)),this._disabledInputs=t.map(this._disabledInputs,function(t){return t===e?null:t}))},_disableDatepicker:function(e){var i,s,n=t(e),o=t.data(e,"datepicker");n.hasClass(this.markerClassName)&&(i=e.nodeName.toLowerCase(),"input"===i?(e.disabled=!0,o.trigger.filter("button").each(function(){this.disabled=!0}).end().filter("img").css({opacity:"0.5",cursor:"default"})):("div"===i||"span"===i)&&(s=n.children("."+this._inlineClass),s.children().addClass("ui-state-disabled"),s.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",!0)),this._disabledInputs=t.map(this._disabledInputs,function(t){return t===e?null:t}),this._disabledInputs[this._disabledInputs.length]=e)},_isDisabledDatepicker:function(t){if(!t)return!1;for(var e=0;this._disabledInputs.length>e;e++)if(this._disabledInputs[e]===t)return!0;return!1},_getInst:function(e){try{return t.data(e,"datepicker")}catch(i){throw"Missing instance data for this datepicker"}},_optionDatepicker:function(e,i,s){var n,o,r,h,l=this._getInst(e);return 2===arguments.length&&"string"==typeof i?"defaults"===i?t.extend({},t.datepicker._defaults):l?"all"===i?t.extend({},l.settings):this._get(l,i):null:(n=i||{},"string"==typeof i&&(n={},n[i]=s),l&&(this._curInst===l&&this._hideDatepicker(),o=this._getDateDatepicker(e,!0),r=this._getMinMaxDate(l,"min"),h=this._getMinMaxDate(l,"max"),a(l.settings,n),null!==r&&void 0!==n.dateFormat&&void 0===n.minDate&&(l.settings.minDate=this._formatDate(l,r)),null!==h&&void 0!==n.dateFormat&&void 0===n.maxDate&&(l.settings.maxDate=this._formatDate(l,h)),"disabled"in n&&(n.disabled?this._disableDatepicker(e):this._enableDatepicker(e)),this._attachments(t(e),l),this._autoSize(l),this._setDate(l,o),this._updateAlternate(l),this._updateDatepicker(l)),void 0)},_changeDatepicker:function(t,e,i){this._optionDatepicker(t,e,i)},_refreshDatepicker:function(t){var e=this._getInst(t);e&&this._updateDatepicker(e)},_setDateDatepicker:function(t,e){var i=this._getInst(t);i&&(this._setDate(i,e),this._updateDatepicker(i),this._updateAlternate(i))},_getDateDatepicker:function(t,e){var i=this._getInst(t);return i&&!i.inline&&this._setDateFromField(i,e),i?this._getDate(i):null},_doKeyDown:function(e){var i,s,n,o=t.datepicker._getInst(e.target),a=!0,r=o.dpDiv.is(".ui-datepicker-rtl");if(o._keyEvent=!0,t.datepicker._datepickerShowing)switch(e.keyCode){case 9:t.datepicker._hideDatepicker(),a=!1;break;case 13:return n=t("td."+t.datepicker._dayOverClass+":not(."+t.datepicker._currentClass+")",o.dpDiv),n[0]&&t.datepicker._selectDay(e.target,o.selectedMonth,o.selectedYear,n[0]),i=t.datepicker._get(o,"onSelect"),i?(s=t.datepicker._formatDate(o),i.apply(o.input?o.input[0]:null,[s,o])):t.datepicker._hideDatepicker(),!1;case 27:t.datepicker._hideDatepicker();break;case 33:t.datepicker._adjustDate(e.target,e.ctrlKey?-t.datepicker._get(o,"stepBigMonths"):-t.datepicker._get(o,"stepMonths"),"M");break;case 34:t.datepicker._adjustDate(e.target,e.ctrlKey?+t.datepicker._get(o,"stepBigMonths"):+t.datepicker._get(o,"stepMonths"),"M");break;case 35:(e.ctrlKey||e.metaKey)&&t.datepicker._clearDate(e.target),a=e.ctrlKey||e.metaKey;break;case 36:(e.ctrlKey||e.metaKey)&&t.datepicker._gotoToday(e.target),a=e.ctrlKey||e.metaKey;break;case 37:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,r?1:-1,"D"),a=e.ctrlKey||e.metaKey,e.originalEvent.altKey&&t.datepicker._adjustDate(e.target,e.ctrlKey?-t.datepicker._get(o,"stepBigMonths"):-t.datepicker._get(o,"stepMonths"),"M");break;case 38:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,-7,"D"),a=e.ctrlKey||e.metaKey;break;case 39:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,r?-1:1,"D"),a=e.ctrlKey||e.metaKey,e.originalEvent.altKey&&t.datepicker._adjustDate(e.target,e.ctrlKey?+t.datepicker._get(o,"stepBigMonths"):+t.datepicker._get(o,"stepMonths"),"M");break;case 40:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,7,"D"),a=e.ctrlKey||e.metaKey;break;default:a=!1}else 36===e.keyCode&&e.ctrlKey?t.datepicker._showDatepicker(this):a=!1;a&&(e.preventDefault(),e.stopPropagation())},_doKeyPress:function(e){var i,s,n=t.datepicker._getInst(e.target);return t.datepicker._get(n,"constrainInput")?(i=t.datepicker._possibleChars(t.datepicker._get(n,"dateFormat")),s=String.fromCharCode(null==e.charCode?e.keyCode:e.charCode),e.ctrlKey||e.metaKey||" ">s||!i||i.indexOf(s)>-1):void 0},_doKeyUp:function(e){var i,s=t.datepicker._getInst(e.target);if(s.input.val()!==s.lastVal)try{i=t.datepicker.parseDate(t.datepicker._get(s,"dateFormat"),s.input?s.input.val():null,t.datepicker._getFormatConfig(s)),i&&(t.datepicker._setDateFromField(s),t.datepicker._updateAlternate(s),t.datepicker._updateDatepicker(s))}catch(n){}return!0},_showDatepicker:function(e){if(e=e.target||e,"input"!==e.nodeName.toLowerCase()&&(e=t("input",e.parentNode)[0]),!t.datepicker._isDisabledDatepicker(e)&&t.datepicker._lastInput!==e){var s,n,o,r,h,l,c;s=t.datepicker._getInst(e),t.datepicker._curInst&&t.datepicker._curInst!==s&&(t.datepicker._curInst.dpDiv.stop(!0,!0),s&&t.datepicker._datepickerShowing&&t.datepicker._hideDatepicker(t.datepicker._curInst.input[0])),n=t.datepicker._get(s,"beforeShow"),o=n?n.apply(e,[e,s]):{},o!==!1&&(a(s.settings,o),s.lastVal=null,t.datepicker._lastInput=e,t.datepicker._setDateFromField(s),t.datepicker._inDialog&&(e.value=""),t.datepicker._pos||(t.datepicker._pos=t.datepicker._findPos(e),t.datepicker._pos[1]+=e.offsetHeight),r=!1,t(e).parents().each(function(){return r|="fixed"===t(this).css("position"),!r}),h={left:t.datepicker._pos[0],top:t.datepicker._pos[1]},t.datepicker._pos=null,s.dpDiv.empty(),s.dpDiv.css({position:"absolute",display:"block",top:"-1000px"}),t.datepicker._updateDatepicker(s),h=t.datepicker._checkOffset(s,h,r),s.dpDiv.css({position:t.datepicker._inDialog&&t.blockUI?"static":r?"fixed":"absolute",display:"none",left:h.left+"px",top:h.top+"px"}),s.inline||(l=t.datepicker._get(s,"showAnim"),c=t.datepicker._get(s,"duration"),s.dpDiv.css("z-index",i(t(e))+1),t.datepicker._datepickerShowing=!0,t.effects&&t.effects.effect[l]?s.dpDiv.show(l,t.datepicker._get(s,"showOptions"),c):s.dpDiv[l||"show"](l?c:null),t.datepicker._shouldFocusInput(s)&&s.input.trigger("focus"),t.datepicker._curInst=s))}},_updateDatepicker:function(e){this.maxRows=4,m=e,e.dpDiv.empty().append(this._generateHTML(e)),this._attachHandlers(e);var i,s=this._getNumberOfMonths(e),n=s[1],a=17,r=e.dpDiv.find("."+this._dayOverClass+" a");r.length>0&&o.apply(r.get(0)),e.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width(""),n>1&&e.dpDiv.addClass("ui-datepicker-multi-"+n).css("width",a*n+"em"),e.dpDiv[(1!==s[0]||1!==s[1]?"add":"remove")+"Class"]("ui-datepicker-multi"),e.dpDiv[(this._get(e,"isRTL")?"add":"remove")+"Class"]("ui-datepicker-rtl"),e===t.datepicker._curInst&&t.datepicker._datepickerShowing&&t.datepicker._shouldFocusInput(e)&&e.input.trigger("focus"),e.yearshtml&&(i=e.yearshtml,setTimeout(function(){i===e.yearshtml&&e.yearshtml&&e.dpDiv.find("select.ui-datepicker-year:first").replaceWith(e.yearshtml),i=e.yearshtml=null},0))},_shouldFocusInput:function(t){return t.input&&t.input.is(":visible")&&!t.input.is(":disabled")&&!t.input.is(":focus")},_checkOffset:function(e,i,s){var n=e.dpDiv.outerWidth(),o=e.dpDiv.outerHeight(),a=e.input?e.input.outerWidth():0,r=e.input?e.input.outerHeight():0,h=document.documentElement.clientWidth+(s?0:t(document).scrollLeft()),l=document.documentElement.clientHeight+(s?0:t(document).scrollTop());return i.left-=this._get(e,"isRTL")?n-a:0,i.left-=s&&i.left===e.input.offset().left?t(document).scrollLeft():0,i.top-=s&&i.top===e.input.offset().top+r?t(document).scrollTop():0,i.left-=Math.min(i.left,i.left+n>h&&h>n?Math.abs(i.left+n-h):0),i.top-=Math.min(i.top,i.top+o>l&&l>o?Math.abs(o+r):0),i},_findPos:function(e){for(var i,s=this._getInst(e),n=this._get(s,"isRTL");e&&("hidden"===e.type||1!==e.nodeType||t.expr.filters.hidden(e));)e=e[n?"previousSibling":"nextSibling"];return i=t(e).offset(),[i.left,i.top]},_hideDatepicker:function(e){var i,s,n,o,a=this._curInst;!a||e&&a!==t.data(e,"datepicker")||this._datepickerShowing&&(i=this._get(a,"showAnim"),s=this._get(a,"duration"),n=function(){t.datepicker._tidyDialog(a)},t.effects&&(t.effects.effect[i]||t.effects[i])?a.dpDiv.hide(i,t.datepicker._get(a,"showOptions"),s,n):a.dpDiv["slideDown"===i?"slideUp":"fadeIn"===i?"fadeOut":"hide"](i?s:null,n),i||n(),this._datepickerShowing=!1,o=this._get(a,"onClose"),o&&o.apply(a.input?a.input[0]:null,[a.input?a.input.val():"",a]),this._lastInput=null,this._inDialog&&(this._dialogInput.css({position:"absolute",left:"0",top:"-100px"}),t.blockUI&&(t.unblockUI(),t("body").append(this.dpDiv))),this._inDialog=!1)},_tidyDialog:function(t){t.dpDiv.removeClass(this._dialogClass).off(".ui-datepicker-calendar")},_checkExternalClick:function(e){if(t.datepicker._curInst){var i=t(e.target),s=t.datepicker._getInst(i[0]);(i[0].id!==t.datepicker._mainDivId&&0===i.parents("#"+t.datepicker._mainDivId).length&&!i.hasClass(t.datepicker.markerClassName)&&!i.closest("."+t.datepicker._triggerClass).length&&t.datepicker._datepickerShowing&&(!t.datepicker._inDialog||!t.blockUI)||i.hasClass(t.datepicker.markerClassName)&&t.datepicker._curInst!==s)&&t.datepicker._hideDatepicker()}},_adjustDate:function(e,i,s){var n=t(e),o=this._getInst(n[0]);this._isDisabledDatepicker(n[0])||(this._adjustInstDate(o,i+("M"===s?this._get(o,"showCurrentAtPos"):0),s),this._updateDatepicker(o))},_gotoToday:function(e){var i,s=t(e),n=this._getInst(s[0]);this._get(n,"gotoCurrent")&&n.currentDay?(n.selectedDay=n.currentDay,n.drawMonth=n.selectedMonth=n.currentMonth,n.drawYear=n.selectedYear=n.currentYear):(i=new Date,n.selectedDay=i.getDate(),n.drawMonth=n.selectedMonth=i.getMonth(),n.drawYear=n.selectedYear=i.getFullYear()),this._notifyChange(n),this._adjustDate(s)},_selectMonthYear:function(e,i,s){var n=t(e),o=this._getInst(n[0]);o["selected"+("M"===s?"Month":"Year")]=o["draw"+("M"===s?"Month":"Year")]=parseInt(i.options[i.selectedIndex].value,10),this._notifyChange(o),this._adjustDate(n)},_selectDay:function(e,i,s,n){var o,a=t(e);t(n).hasClass(this._unselectableClass)||this._isDisabledDatepicker(a[0])||(o=this._getInst(a[0]),o.selectedDay=o.currentDay=t("a",n).html(),o.selectedMonth=o.currentMonth=i,o.selectedYear=o.currentYear=s,this._selectDate(e,this._formatDate(o,o.currentDay,o.currentMonth,o.currentYear)))},_clearDate:function(e){var i=t(e);this._selectDate(i,"")},_selectDate:function(e,i){var s,n=t(e),o=this._getInst(n[0]);i=null!=i?i:this._formatDate(o),o.input&&o.input.val(i),this._updateAlternate(o),s=this._get(o,"onSelect"),s?s.apply(o.input?o.input[0]:null,[i,o]):o.input&&o.input.trigger("change"),o.inline?this._updateDatepicker(o):(this._hideDatepicker(),this._lastInput=o.input[0],"object"!=typeof o.input[0]&&o.input.trigger("focus"),this._lastInput=null)},_updateAlternate:function(e){var i,s,n,o=this._get(e,"altField");o&&(i=this._get(e,"altFormat")||this._get(e,"dateFormat"),s=this._getDate(e),n=this.formatDate(i,s,this._getFormatConfig(e)),t(o).val(n))},noWeekends:function(t){var e=t.getDay();return[e>0&&6>e,""]},iso8601Week:function(t){var e,i=new Date(t.getTime());return i.setDate(i.getDate()+4-(i.getDay()||7)),e=i.getTime(),i.setMonth(0),i.setDate(1),Math.floor(Math.round((e-i)/864e5)/7)+1},parseDate:function(e,i,s){if(null==e||null==i)throw"Invalid arguments";if(i="object"==typeof i?""+i:i+"",""===i)return null;var n,o,a,r,h=0,l=(s?s.shortYearCutoff:null)||this._defaults.shortYearCutoff,c="string"!=typeof l?l:(new Date).getFullYear()%100+parseInt(l,10),u=(s?s.dayNamesShort:null)||this._defaults.dayNamesShort,d=(s?s.dayNames:null)||this._defaults.dayNames,p=(s?s.monthNamesShort:null)||this._defaults.monthNamesShort,f=(s?s.monthNames:null)||this._defaults.monthNames,g=-1,m=-1,_=-1,v=-1,b=!1,y=function(t){var i=e.length>n+1&&e.charAt(n+1)===t;return i&&n++,i},w=function(t){var e=y(t),s="@"===t?14:"!"===t?20:"y"===t&&e?4:"o"===t?3:2,n="y"===t?s:1,o=RegExp("^\\d{"+n+","+s+"}"),a=i.substring(h).match(o);if(!a)throw"Missing number at position "+h;return h+=a[0].length,parseInt(a[0],10)},k=function(e,s,n){var o=-1,a=t.map(y(e)?n:s,function(t,e){return[[e,t]]}).sort(function(t,e){return-(t[1].length-e[1].length)});if(t.each(a,function(t,e){var s=e[1];return i.substr(h,s.length).toLowerCase()===s.toLowerCase()?(o=e[0],h+=s.length,!1):void 0}),-1!==o)return o+1;throw"Unknown name at position "+h},x=function(){if(i.charAt(h)!==e.charAt(n))throw"Unexpected literal at position "+h;h++};for(n=0;e.length>n;n++)if(b)"'"!==e.charAt(n)||y("'")?x():b=!1;else switch(e.charAt(n)){case"d":_=w("d");break;case"D":k("D",u,d);break;case"o":v=w("o");break;case"m":m=w("m");break;case"M":m=k("M",p,f);break;case"y":g=w("y");break;case"@":r=new Date(w("@")),g=r.getFullYear(),m=r.getMonth()+1,_=r.getDate();break;case"!":r=new Date((w("!")-this._ticksTo1970)/1e4),g=r.getFullYear(),m=r.getMonth()+1,_=r.getDate();break;case"'":y("'")?x():b=!0;break;default:x()}if(i.length>h&&(a=i.substr(h),!/^\s+/.test(a)))throw"Extra/unparsed characters found in date: "+a;if(-1===g?g=(new Date).getFullYear():100>g&&(g+=(new Date).getFullYear()-(new Date).getFullYear()%100+(c>=g?0:-100)),v>-1)for(m=1,_=v;;){if(o=this._getDaysInMonth(g,m-1),o>=_)break;m++,_-=o}if(r=this._daylightSavingAdjust(new Date(g,m-1,_)),r.getFullYear()!==g||r.getMonth()+1!==m||r.getDate()!==_)throw"Invalid date";return r},ATOM:"yy-mm-dd",COOKIE:"D, dd M yy",ISO_8601:"yy-mm-dd",RFC_822:"D, d M y",RFC_850:"DD, dd-M-y",RFC_1036:"D, d M y",RFC_1123:"D, d M yy",RFC_2822:"D, d M yy",RSS:"D, d M y",TICKS:"!",TIMESTAMP:"@",W3C:"yy-mm-dd",_ticksTo1970:1e7*60*60*24*(718685+Math.floor(492.5)-Math.floor(19.7)+Math.floor(4.925)),formatDate:function(t,e,i){if(!e)return"";var s,n=(i?i.dayNamesShort:null)||this._defaults.dayNamesShort,o=(i?i.dayNames:null)||this._defaults.dayNames,a=(i?i.monthNamesShort:null)||this._defaults.monthNamesShort,r=(i?i.monthNames:null)||this._defaults.monthNames,h=function(e){var i=t.length>s+1&&t.charAt(s+1)===e;return i&&s++,i},l=function(t,e,i){var s=""+e;if(h(t))for(;i>s.length;)s="0"+s;return s},c=function(t,e,i,s){return h(t)?s[e]:i[e]},u="",d=!1;if(e)for(s=0;t.length>s;s++)if(d)"'"!==t.charAt(s)||h("'")?u+=t.charAt(s):d=!1;else switch(t.charAt(s)){case"d":u+=l("d",e.getDate(),2);break;case"D":u+=c("D",e.getDay(),n,o);break;case"o":u+=l("o",Math.round((new Date(e.getFullYear(),e.getMonth(),e.getDate()).getTime()-new Date(e.getFullYear(),0,0).getTime())/864e5),3);break;case"m":u+=l("m",e.getMonth()+1,2);break;case"M":u+=c("M",e.getMonth(),a,r);break;case"y":u+=h("y")?e.getFullYear():(10>e.getFullYear()%100?"0":"")+e.getFullYear()%100;break;case"@":u+=e.getTime();break;case"!":u+=1e4*e.getTime()+this._ticksTo1970;break;case"'":h("'")?u+="'":d=!0;break;default:u+=t.charAt(s)}return u},_possibleChars:function(t){var e,i="",s=!1,n=function(i){var s=t.length>e+1&&t.charAt(e+1)===i;return s&&e++,s};for(e=0;t.length>e;e++)if(s)"'"!==t.charAt(e)||n("'")?i+=t.charAt(e):s=!1;else switch(t.charAt(e)){case"d":case"m":case"y":case"@":i+="0123456789";break;case"D":case"M":return null;case"'":n("'")?i+="'":s=!0;break;default:i+=t.charAt(e)}return i},_get:function(t,e){return void 0!==t.settings[e]?t.settings[e]:this._defaults[e]},_setDateFromField:function(t,e){if(t.input.val()!==t.lastVal){var i=this._get(t,"dateFormat"),s=t.lastVal=t.input?t.input.val():null,n=this._getDefaultDate(t),o=n,a=this._getFormatConfig(t);try{o=this.parseDate(i,s,a)||n}catch(r){s=e?"":s}t.selectedDay=o.getDate(),t.drawMonth=t.selectedMonth=o.getMonth(),t.drawYear=t.selectedYear=o.getFullYear(),t.currentDay=s?o.getDate():0,t.currentMonth=s?o.getMonth():0,t.currentYear=s?o.getFullYear():0,this._adjustInstDate(t)}},_getDefaultDate:function(t){return this._restrictMinMax(t,this._determineDate(t,this._get(t,"defaultDate"),new Date))},_determineDate:function(e,i,s){var n=function(t){var e=new Date;return e.setDate(e.getDate()+t),e},o=function(i){try{return t.datepicker.parseDate(t.datepicker._get(e,"dateFormat"),i,t.datepicker._getFormatConfig(e))}catch(s){}for(var n=(i.toLowerCase().match(/^c/)?t.datepicker._getDate(e):null)||new Date,o=n.getFullYear(),a=n.getMonth(),r=n.getDate(),h=/([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,l=h.exec(i);l;){switch(l[2]||"d"){case"d":case"D":r+=parseInt(l[1],10);break;case"w":case"W":r+=7*parseInt(l[1],10);break;case"m":case"M":a+=parseInt(l[1],10),r=Math.min(r,t.datepicker._getDaysInMonth(o,a));break;case"y":case"Y":o+=parseInt(l[1],10),r=Math.min(r,t.datepicker._getDaysInMonth(o,a))}l=h.exec(i)}return new Date(o,a,r)},a=null==i||""===i?s:"string"==typeof i?o(i):"number"==typeof i?isNaN(i)?s:n(i):new Date(i.getTime());return a=a&&"Invalid Date"==""+a?s:a,a&&(a.setHours(0),a.setMinutes(0),a.setSeconds(0),a.setMilliseconds(0)),this._daylightSavingAdjust(a)},_daylightSavingAdjust:function(t){return t?(t.setHours(t.getHours()>12?t.getHours()+2:0),t):null},_setDate:function(t,e,i){var s=!e,n=t.selectedMonth,o=t.selectedYear,a=this._restrictMinMax(t,this._determineDate(t,e,new Date));t.selectedDay=t.currentDay=a.getDate(),t.drawMonth=t.selectedMonth=t.currentMonth=a.getMonth(),t.drawYear=t.selectedYear=t.currentYear=a.getFullYear(),n===t.selectedMonth&&o===t.selectedYear||i||this._notifyChange(t),this._adjustInstDate(t),t.input&&t.input.val(s?"":this._formatDate(t))},_getDate:function(t){var e=!t.currentYear||t.input&&""===t.input.val()?null:this._daylightSavingAdjust(new Date(t.currentYear,t.currentMonth,t.currentDay));return e},_attachHandlers:function(e){var i=this._get(e,"stepMonths"),s="#"+e.id.replace(/\\\\/g,"\\");e.dpDiv.find("[data-handler]").map(function(){var e={prev:function(){t.datepicker._adjustDate(s,-i,"M")},next:function(){t.datepicker._adjustDate(s,+i,"M")},hide:function(){t.datepicker._hideDatepicker()},today:function(){t.datepicker._gotoToday(s)},selectDay:function(){return t.datepicker._selectDay(s,+this.getAttribute("data-month"),+this.getAttribute("data-year"),this),!1},selectMonth:function(){return t.datepicker._selectMonthYear(s,this,"M"),!1},selectYear:function(){return t.datepicker._selectMonthYear(s,this,"Y"),!1}};t(this).on(this.getAttribute("data-event"),e[this.getAttribute("data-handler")])})},_generateHTML:function(t){var e,i,s,n,o,a,r,h,l,c,u,d,p,f,g,m,_,v,b,y,w,k,x,C,D,I,T,P,M,S,H,z,O,A,N,W,E,F,L,R=new Date,B=this._daylightSavingAdjust(new Date(R.getFullYear(),R.getMonth(),R.getDate())),Y=this._get(t,"isRTL"),j=this._get(t,"showButtonPanel"),q=this._get(t,"hideIfNoPrevNext"),K=this._get(t,"navigationAsDateFormat"),U=this._getNumberOfMonths(t),V=this._get(t,"showCurrentAtPos"),$=this._get(t,"stepMonths"),X=1!==U[0]||1!==U[1],G=this._daylightSavingAdjust(t.currentDay?new Date(t.currentYear,t.currentMonth,t.currentDay):new Date(9999,9,9)),Q=this._getMinMaxDate(t,"min"),J=this._getMinMaxDate(t,"max"),Z=t.drawMonth-V,te=t.drawYear;if(0>Z&&(Z+=12,te--),J)for(e=this._daylightSavingAdjust(new Date(J.getFullYear(),J.getMonth()-U[0]*U[1]+1,J.getDate())),e=Q&&Q>e?Q:e;this._daylightSavingAdjust(new Date(te,Z,1))>e;)Z--,0>Z&&(Z=11,te--);for(t.drawMonth=Z,t.drawYear=te,i=this._get(t,"prevText"),i=K?this.formatDate(i,this._daylightSavingAdjust(new Date(te,Z-$,1)),this._getFormatConfig(t)):i,s=this._canAdjustMonth(t,-1,te,Z)?"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click' title='"+i+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"e":"w")+"'>"+i+"</span></a>":q?"":"<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='"+i+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"e":"w")+"'>"+i+"</span></a>",n=this._get(t,"nextText"),n=K?this.formatDate(n,this._daylightSavingAdjust(new Date(te,Z+$,1)),this._getFormatConfig(t)):n,o=this._canAdjustMonth(t,1,te,Z)?"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click' title='"+n+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"w":"e")+"'>"+n+"</span></a>":q?"":"<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='"+n+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"w":"e")+"'>"+n+"</span></a>",a=this._get(t,"currentText"),r=this._get(t,"gotoCurrent")&&t.currentDay?G:B,a=K?this.formatDate(a,r,this._getFormatConfig(t)):a,h=t.inline?"":"<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>"+this._get(t,"closeText")+"</button>",l=j?"<div class='ui-datepicker-buttonpane ui-widget-content'>"+(Y?h:"")+(this._isInRange(t,r)?"<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'>"+a+"</button>":"")+(Y?"":h)+"</div>":"",c=parseInt(this._get(t,"firstDay"),10),c=isNaN(c)?0:c,u=this._get(t,"showWeek"),d=this._get(t,"dayNames"),p=this._get(t,"dayNamesMin"),f=this._get(t,"monthNames"),g=this._get(t,"monthNamesShort"),m=this._get(t,"beforeShowDay"),_=this._get(t,"showOtherMonths"),v=this._get(t,"selectOtherMonths"),b=this._getDefaultDate(t),y="",k=0;U[0]>k;k++){for(x="",this.maxRows=4,C=0;U[1]>C;C++){if(D=this._daylightSavingAdjust(new Date(te,Z,t.selectedDay)),I=" ui-corner-all",T="",X){if(T+="<div class='ui-datepicker-group",U[1]>1)switch(C){case 0:T+=" ui-datepicker-group-first",I=" ui-corner-"+(Y?"right":"left");break;case U[1]-1:T+=" ui-datepicker-group-last",I=" ui-corner-"+(Y?"left":"right");break;default:T+=" ui-datepicker-group-middle",I=""}T+="'>"}for(T+="<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix"+I+"'>"+(/all|left/.test(I)&&0===k?Y?o:s:"")+(/all|right/.test(I)&&0===k?Y?s:o:"")+this._generateMonthYearHeader(t,Z,te,Q,J,k>0||C>0,f,g)+"</div><table class='ui-datepicker-calendar'><thead>"+"<tr>",P=u?"<th class='ui-datepicker-week-col'>"+this._get(t,"weekHeader")+"</th>":"",w=0;7>w;w++)M=(w+c)%7,P+="<th scope='col'"+((w+c+6)%7>=5?" class='ui-datepicker-week-end'":"")+">"+"<span title='"+d[M]+"'>"+p[M]+"</span></th>";for(T+=P+"</tr></thead><tbody>",S=this._getDaysInMonth(te,Z),te===t.selectedYear&&Z===t.selectedMonth&&(t.selectedDay=Math.min(t.selectedDay,S)),H=(this._getFirstDayOfMonth(te,Z)-c+7)%7,z=Math.ceil((H+S)/7),O=X?this.maxRows>z?this.maxRows:z:z,this.maxRows=O,A=this._daylightSavingAdjust(new Date(te,Z,1-H)),N=0;O>N;N++){for(T+="<tr>",W=u?"<td class='ui-datepicker-week-col'>"+this._get(t,"calculateWeek")(A)+"</td>":"",w=0;7>w;w++)E=m?m.apply(t.input?t.input[0]:null,[A]):[!0,""],F=A.getMonth()!==Z,L=F&&!v||!E[0]||Q&&Q>A||J&&A>J,W+="<td class='"+((w+c+6)%7>=5?" ui-datepicker-week-end":"")+(F?" ui-datepicker-other-month":"")+(A.getTime()===D.getTime()&&Z===t.selectedMonth&&t._keyEvent||b.getTime()===A.getTime()&&b.getTime()===D.getTime()?" "+this._dayOverClass:"")+(L?" "+this._unselectableClass+" ui-state-disabled":"")+(F&&!_?"":" "+E[1]+(A.getTime()===G.getTime()?" "+this._currentClass:"")+(A.getTime()===B.getTime()?" ui-datepicker-today":""))+"'"+(F&&!_||!E[2]?"":" title='"+E[2].replace(/'/g,"&#39;")+"'")+(L?"":" data-handler='selectDay' data-event='click' data-month='"+A.getMonth()+"' data-year='"+A.getFullYear()+"'")+">"+(F&&!_?"&#xa0;":L?"<span class='ui-state-default'>"+A.getDate()+"</span>":"<a class='ui-state-default"+(A.getTime()===B.getTime()?" ui-state-highlight":"")+(A.getTime()===G.getTime()?" ui-state-active":"")+(F?" ui-priority-secondary":"")+"' href='#'>"+A.getDate()+"</a>")+"</td>",A.setDate(A.getDate()+1),A=this._daylightSavingAdjust(A);T+=W+"</tr>"}Z++,Z>11&&(Z=0,te++),T+="</tbody></table>"+(X?"</div>"+(U[0]>0&&C===U[1]-1?"<div class='ui-datepicker-row-break'></div>":""):""),x+=T}y+=x}return y+=l,t._keyEvent=!1,y},_generateMonthYearHeader:function(t,e,i,s,n,o,a,r){var h,l,c,u,d,p,f,g,m=this._get(t,"changeMonth"),_=this._get(t,"changeYear"),v=this._get(t,"showMonthAfterYear"),b="<div class='ui-datepicker-title'>",y="";if(o||!m)y+="<span class='ui-datepicker-month'>"+a[e]+"</span>";else{for(h=s&&s.getFullYear()===i,l=n&&n.getFullYear()===i,y+="<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>",c=0;12>c;c++)(!h||c>=s.getMonth())&&(!l||n.getMonth()>=c)&&(y+="<option value='"+c+"'"+(c===e?" selected='selected'":"")+">"+r[c]+"</option>");y+="</select>"}if(v||(b+=y+(!o&&m&&_?"":"&#xa0;")),!t.yearshtml)if(t.yearshtml="",o||!_)b+="<span class='ui-datepicker-year'>"+i+"</span>";else{for(u=this._get(t,"yearRange").split(":"),d=(new Date).getFullYear(),p=function(t){var e=t.match(/c[+\-].*/)?i+parseInt(t.substring(1),10):t.match(/[+\-].*/)?d+parseInt(t,10):parseInt(t,10);return isNaN(e)?d:e},f=p(u[0]),g=Math.max(f,p(u[1]||"")),f=s?Math.max(f,s.getFullYear()):f,g=n?Math.min(g,n.getFullYear()):g,t.yearshtml+="<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>";g>=f;f++)t.yearshtml+="<option value='"+f+"'"+(f===i?" selected='selected'":"")+">"+f+"</option>";t.yearshtml+="</select>",b+=t.yearshtml,t.yearshtml=null}return b+=this._get(t,"yearSuffix"),v&&(b+=(!o&&m&&_?"":"&#xa0;")+y),b+="</div>"},_adjustInstDate:function(t,e,i){var s=t.selectedYear+("Y"===i?e:0),n=t.selectedMonth+("M"===i?e:0),o=Math.min(t.selectedDay,this._getDaysInMonth(s,n))+("D"===i?e:0),a=this._restrictMinMax(t,this._daylightSavingAdjust(new Date(s,n,o)));t.selectedDay=a.getDate(),t.drawMonth=t.selectedMonth=a.getMonth(),t.drawYear=t.selectedYear=a.getFullYear(),("M"===i||"Y"===i)&&this._notifyChange(t)},_restrictMinMax:function(t,e){var i=this._getMinMaxDate(t,"min"),s=this._getMinMaxDate(t,"max"),n=i&&i>e?i:e;return s&&n>s?s:n},_notifyChange:function(t){var e=this._get(t,"onChangeMonthYear");e&&e.apply(t.input?t.input[0]:null,[t.selectedYear,t.selectedMonth+1,t])},_getNumberOfMonths:function(t){var e=this._get(t,"numberOfMonths");return null==e?[1,1]:"number"==typeof e?[1,e]:e},_getMinMaxDate:function(t,e){return this._determineDate(t,this._get(t,e+"Date"),null)},_getDaysInMonth:function(t,e){return 32-this._daylightSavingAdjust(new Date(t,e,32)).getDate()},_getFirstDayOfMonth:function(t,e){return new Date(t,e,1).getDay()},_canAdjustMonth:function(t,e,i,s){var n=this._getNumberOfMonths(t),o=this._daylightSavingAdjust(new Date(i,s+(0>e?e:n[0]*n[1]),1));return 0>e&&o.setDate(this._getDaysInMonth(o.getFullYear(),o.getMonth())),this._isInRange(t,o)},_isInRange:function(t,e){var i,s,n=this._getMinMaxDate(t,"min"),o=this._getMinMaxDate(t,"max"),a=null,r=null,h=this._get(t,"yearRange");return h&&(i=h.split(":"),s=(new Date).getFullYear(),a=parseInt(i[0],10),r=parseInt(i[1],10),i[0].match(/[+\-].*/)&&(a+=s),i[1].match(/[+\-].*/)&&(r+=s)),(!n||e.getTime()>=n.getTime())&&(!o||e.getTime()<=o.getTime())&&(!a||e.getFullYear()>=a)&&(!r||r>=e.getFullYear())},_getFormatConfig:function(t){var e=this._get(t,"shortYearCutoff");return e="string"!=typeof e?e:(new Date).getFullYear()%100+parseInt(e,10),{shortYearCutoff:e,dayNamesShort:this._get(t,"dayNamesShort"),dayNames:this._get(t,"dayNames"),monthNamesShort:this._get(t,"monthNamesShort"),monthNames:this._get(t,"monthNames")}},_formatDate:function(t,e,i,s){e||(t.currentDay=t.selectedDay,t.currentMonth=t.selectedMonth,t.currentYear=t.selectedYear);var n=e?"object"==typeof e?e:this._daylightSavingAdjust(new Date(s,i,e)):this._daylightSavingAdjust(new Date(t.currentYear,t.currentMonth,t.currentDay));return this.formatDate(this._get(t,"dateFormat"),n,this._getFormatConfig(t))}}),t.fn.datepicker=function(e){if(!this.length)return this;t.datepicker.initialized||(t(document).on("mousedown",t.datepicker._checkExternalClick),t.datepicker.initialized=!0),0===t("#"+t.datepicker._mainDivId).length&&t("body").append(t.datepicker.dpDiv);var i=Array.prototype.slice.call(arguments,1);return"string"!=typeof e||"isDisabled"!==e&&"getDate"!==e&&"widget"!==e?"option"===e&&2===arguments.length&&"string"==typeof arguments[1]?t.datepicker["_"+e+"Datepicker"].apply(t.datepicker,[this[0]].concat(i)):this.each(function(){"string"==typeof e?t.datepicker["_"+e+"Datepicker"].apply(t.datepicker,[this].concat(i)):t.datepicker._attachDatepicker(this,e)}):t.datepicker["_"+e+"Datepicker"].apply(t.datepicker,[this[0]].concat(i))},t.datepicker=new s,t.datepicker.initialized=!1,t.datepicker.uuid=(new Date).getTime(),t.datepicker.version="1.12.1",t.datepicker,t.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase());var _=!1;t(document).on("mouseup",function(){_=!1}),t.widget("ui.mouse",{version:"1.12.1",options:{cancel:"input, textarea, button, select, option",distance:1,delay:0},_mouseInit:function(){var e=this;this.element.on("mousedown."+this.widgetName,function(t){return e._mouseDown(t)}).on("click."+this.widgetName,function(i){return!0===t.data(i.target,e.widgetName+".preventClickEvent")?(t.removeData(i.target,e.widgetName+".preventClickEvent"),i.stopImmediatePropagation(),!1):void 0}),this.started=!1},_mouseDestroy:function(){this.element.off("."+this.widgetName),this._mouseMoveDelegate&&this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(e){if(!_){this._mouseMoved=!1,this._mouseStarted&&this._mouseUp(e),this._mouseDownEvent=e;var i=this,s=1===e.which,n="string"==typeof this.options.cancel&&e.target.nodeName?t(e.target).closest(this.options.cancel).length:!1;return s&&!n&&this._mouseCapture(e)?(this.mouseDelayMet=!this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){i.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(e)&&this._mouseDelayMet(e)&&(this._mouseStarted=this._mouseStart(e)!==!1,!this._mouseStarted)?(e.preventDefault(),!0):(!0===t.data(e.target,this.widgetName+".preventClickEvent")&&t.removeData(e.target,this.widgetName+".preventClickEvent"),this._mouseMoveDelegate=function(t){return i._mouseMove(t)},this._mouseUpDelegate=function(t){return i._mouseUp(t)},this.document.on("mousemove."+this.widgetName,this._mouseMoveDelegate).on("mouseup."+this.widgetName,this._mouseUpDelegate),e.preventDefault(),_=!0,!0)):!0}},_mouseMove:function(e){if(this._mouseMoved){if(t.ui.ie&&(!document.documentMode||9>document.documentMode)&&!e.button)return this._mouseUp(e);if(!e.which)if(e.originalEvent.altKey||e.originalEvent.ctrlKey||e.originalEvent.metaKey||e.originalEvent.shiftKey)this.ignoreMissingWhich=!0;else if(!this.ignoreMissingWhich)return this._mouseUp(e)}return(e.which||e.button)&&(this._mouseMoved=!0),this._mouseStarted?(this._mouseDrag(e),e.preventDefault()):(this._mouseDistanceMet(e)&&this._mouseDelayMet(e)&&(this._mouseStarted=this._mouseStart(this._mouseDownEvent,e)!==!1,this._mouseStarted?this._mouseDrag(e):this._mouseUp(e)),!this._mouseStarted)},_mouseUp:function(e){this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,e.target===this._mouseDownEvent.target&&t.data(e.target,this.widgetName+".preventClickEvent",!0),this._mouseStop(e)),this._mouseDelayTimer&&(clearTimeout(this._mouseDelayTimer),delete this._mouseDelayTimer),this.ignoreMissingWhich=!1,_=!1,e.preventDefault()},_mouseDistanceMet:function(t){return Math.max(Math.abs(this._mouseDownEvent.pageX-t.pageX),Math.abs(this._mouseDownEvent.pageY-t.pageY))>=this.options.distance},_mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}}),t.ui.plugin={add:function(e,i,s){var n,o=t.ui[e].prototype;for(n in s)o.plugins[n]=o.plugins[n]||[],o.plugins[n].push([i,s[n]])},call:function(t,e,i,s){var n,o=t.plugins[e];if(o&&(s||t.element[0].parentNode&&11!==t.element[0].parentNode.nodeType))for(n=0;o.length>n;n++)t.options[o[n][0]]&&o[n][1].apply(t.element,i)}},t.ui.safeBlur=function(e){e&&"body"!==e.nodeName.toLowerCase()&&t(e).trigger("blur")},t.widget("ui.draggable",t.ui.mouse,{version:"1.12.1",widgetEventPrefix:"drag",options:{addClasses:!0,appendTo:"parent",axis:!1,connectToSortable:!1,containment:!1,cursor:"auto",cursorAt:!1,grid:!1,handle:!1,helper:"original",iframeFix:!1,opacity:!1,refreshPositions:!1,revert:!1,revertDuration:500,scope:"default",scroll:!0,scrollSensitivity:20,scrollSpeed:20,snap:!1,snapMode:"both",snapTolerance:20,stack:!1,zIndex:!1,drag:null,start:null,stop:null},_create:function(){"original"===this.options.helper&&this._setPositionRelative(),this.options.addClasses&&this._addClass("ui-draggable"),this._setHandleClassName(),this._mouseInit()},_setOption:function(t,e){this._super(t,e),"handle"===t&&(this._removeHandleClassName(),this._setHandleClassName())},_destroy:function(){return(this.helper||this.element).is(".ui-draggable-dragging")?(this.destroyOnClear=!0,void 0):(this._removeHandleClassName(),this._mouseDestroy(),void 0)},_mouseCapture:function(e){var i=this.options;return this.helper||i.disabled||t(e.target).closest(".ui-resizable-handle").length>0?!1:(this.handle=this._getHandle(e),this.handle?(this._blurActiveElement(e),this._blockFrames(i.iframeFix===!0?"iframe":i.iframeFix),!0):!1)},_blockFrames:function(e){this.iframeBlocks=this.document.find(e).map(function(){var e=t(this);return t("<div>").css("position","absolute").appendTo(e.parent()).outerWidth(e.outerWidth()).outerHeight(e.outerHeight()).offset(e.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_blurActiveElement:function(e){var i=t.ui.safeActiveElement(this.document[0]),s=t(e.target);s.closest(i).length||t.ui.safeBlur(i)},_mouseStart:function(e){var i=this.options;return this.helper=this._createHelper(e),this._addClass(this.helper,"ui-draggable-dragging"),this._cacheHelperProportions(),t.ui.ddmanager&&(t.ui.ddmanager.current=this),this._cacheMargins(),this.cssPosition=this.helper.css("position"),this.scrollParent=this.helper.scrollParent(!0),this.offsetParent=this.helper.offsetParent(),this.hasFixedAncestor=this.helper.parents().filter(function(){return"fixed"===t(this).css("position")}).length>0,this.positionAbs=this.element.offset(),this._refreshOffsets(e),this.originalPosition=this.position=this._generatePosition(e,!1),this.originalPageX=e.pageX,this.originalPageY=e.pageY,i.cursorAt&&this._adjustOffsetFromHelper(i.cursorAt),this._setContainment(),this._trigger("start",e)===!1?(this._clear(),!1):(this._cacheHelperProportions(),t.ui.ddmanager&&!i.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this._mouseDrag(e,!0),t.ui.ddmanager&&t.ui.ddmanager.dragStart(this,e),!0)},_refreshOffsets:function(t){this.offset={top:this.positionAbs.top-this.margins.top,left:this.positionAbs.left-this.margins.left,scroll:!1,parent:this._getParentOffset(),relative:this._getRelativeOffset()},this.offset.click={left:t.pageX-this.offset.left,top:t.pageY-this.offset.top}},_mouseDrag:function(e,i){if(this.hasFixedAncestor&&(this.offset.parent=this._getParentOffset()),this.position=this._generatePosition(e,!0),this.positionAbs=this._convertPositionTo("absolute"),!i){var s=this._uiHash();if(this._trigger("drag",e,s)===!1)return this._mouseUp(new t.Event("mouseup",e)),!1;this.position=s.position}return this.helper[0].style.left=this.position.left+"px",this.helper[0].style.top=this.position.top+"px",t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),!1},_mouseStop:function(e){var i=this,s=!1;return t.ui.ddmanager&&!this.options.dropBehaviour&&(s=t.ui.ddmanager.drop(this,e)),this.dropped&&(s=this.dropped,this.dropped=!1),"invalid"===this.options.revert&&!s||"valid"===this.options.revert&&s||this.options.revert===!0||t.isFunction(this.options.revert)&&this.options.revert.call(this.element,s)?t(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){i._trigger("stop",e)!==!1&&i._clear()}):this._trigger("stop",e)!==!1&&this._clear(),!1},_mouseUp:function(e){return this._unblockFrames(),t.ui.ddmanager&&t.ui.ddmanager.dragStop(this,e),this.handleElement.is(e.target)&&this.element.trigger("focus"),t.ui.mouse.prototype._mouseUp.call(this,e)},cancel:function(){return this.helper.is(".ui-draggable-dragging")?this._mouseUp(new t.Event("mouseup",{target:this.element[0]})):this._clear(),this},_getHandle:function(e){return this.options.handle?!!t(e.target).closest(this.element.find(this.options.handle)).length:!0},_setHandleClassName:function(){this.handleElement=this.options.handle?this.element.find(this.options.handle):this.element,this._addClass(this.handleElement,"ui-draggable-handle")},_removeHandleClassName:function(){this._removeClass(this.handleElement,"ui-draggable-handle")},_createHelper:function(e){var i=this.options,s=t.isFunction(i.helper),n=s?t(i.helper.apply(this.element[0],[e])):"clone"===i.helper?this.element.clone().removeAttr("id"):this.element;return n.parents("body").length||n.appendTo("parent"===i.appendTo?this.element[0].parentNode:i.appendTo),s&&n[0]===this.element[0]&&this._setPositionRelative(),n[0]===this.element[0]||/(fixed|absolute)/.test(n.css("position"))||n.css("position","absolute"),n},_setPositionRelative:function(){/^(?:r|a|f)/.test(this.element.css("position"))||(this.element[0].style.position="relative")},_adjustOffsetFromHelper:function(e){"string"==typeof e&&(e=e.split(" ")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),"left"in e&&(this.offset.click.left=e.left+this.margins.left),"right"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),"top"in e&&(this.offset.click.top=e.top+this.margins.top),"bottom"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_isRootNode:function(t){return/(html|body)/i.test(t.tagName)||t===this.document[0]},_getParentOffset:function(){var e=this.offsetParent.offset(),i=this.document[0];return"absolute"===this.cssPosition&&this.scrollParent[0]!==i&&t.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),this._isRootNode(this.offsetParent[0])&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"!==this.cssPosition)return{top:0,left:0};var t=this.element.position(),e=this._isRootNode(this.scrollParent[0]);return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+(e?0:this.scrollParent.scrollTop()),left:t.left-(parseInt(this.helper.css("left"),10)||0)+(e?0:this.scrollParent.scrollLeft())}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,n=this.options,o=this.document[0];return this.relativeContainer=null,n.containment?"window"===n.containment?(this.containment=[t(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,t(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,t(window).scrollLeft()+t(window).width()-this.helperProportions.width-this.margins.left,t(window).scrollTop()+(t(window).height()||o.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top],void 0):"document"===n.containment?(this.containment=[0,0,t(o).width()-this.helperProportions.width-this.margins.left,(t(o).height()||o.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top],void 0):n.containment.constructor===Array?(this.containment=n.containment,void 0):("parent"===n.containment&&(n.containment=this.helper[0].parentNode),i=t(n.containment),s=i[0],s&&(e=/(scroll|auto)/.test(i.css("overflow")),this.containment=[(parseInt(i.css("borderLeftWidth"),10)||0)+(parseInt(i.css("paddingLeft"),10)||0),(parseInt(i.css("borderTopWidth"),10)||0)+(parseInt(i.css("paddingTop"),10)||0),(e?Math.max(s.scrollWidth,s.offsetWidth):s.offsetWidth)-(parseInt(i.css("borderRightWidth"),10)||0)-(parseInt(i.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(e?Math.max(s.scrollHeight,s.offsetHeight):s.offsetHeight)-(parseInt(i.css("borderBottomWidth"),10)||0)-(parseInt(i.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom],this.relativeContainer=i),void 0):(this.containment=null,void 0)},_convertPositionTo:function(t,e){e||(e=this.position);var i="absolute"===t?1:-1,s=this._isRootNode(this.scrollParent[0]);return{top:e.top+this.offset.relative.top*i+this.offset.parent.top*i-("fixed"===this.cssPosition?-this.offset.scroll.top:s?0:this.offset.scroll.top)*i,left:e.left+this.offset.relative.left*i+this.offset.parent.left*i-("fixed"===this.cssPosition?-this.offset.scroll.left:s?0:this.offset.scroll.left)*i}},_generatePosition:function(t,e){var i,s,n,o,a=this.options,r=this._isRootNode(this.scrollParent[0]),h=t.pageX,l=t.pageY;return r&&this.offset.scroll||(this.offset.scroll={top:this.scrollParent.scrollTop(),left:this.scrollParent.scrollLeft()}),e&&(this.containment&&(this.relativeContainer?(s=this.relativeContainer.offset(),i=[this.containment[0]+s.left,this.containment[1]+s.top,this.containment[2]+s.left,this.containment[3]+s.top]):i=this.containment,t.pageX-this.offset.click.left<i[0]&&(h=i[0]+this.offset.click.left),t.pageY-this.offset.click.top<i[1]&&(l=i[1]+this.offset.click.top),t.pageX-this.offset.click.left>i[2]&&(h=i[2]+this.offset.click.left),t.pageY-this.offset.click.top>i[3]&&(l=i[3]+this.offset.click.top)),a.grid&&(n=a.grid[1]?this.originalPageY+Math.round((l-this.originalPageY)/a.grid[1])*a.grid[1]:this.originalPageY,l=i?n-this.offset.click.top>=i[1]||n-this.offset.click.top>i[3]?n:n-this.offset.click.top>=i[1]?n-a.grid[1]:n+a.grid[1]:n,o=a.grid[0]?this.originalPageX+Math.round((h-this.originalPageX)/a.grid[0])*a.grid[0]:this.originalPageX,h=i?o-this.offset.click.left>=i[0]||o-this.offset.click.left>i[2]?o:o-this.offset.click.left>=i[0]?o-a.grid[0]:o+a.grid[0]:o),"y"===a.axis&&(h=this.originalPageX),"x"===a.axis&&(l=this.originalPageY)),{top:l-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.offset.scroll.top:r?0:this.offset.scroll.top),left:h-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.offset.scroll.left:r?0:this.offset.scroll.left)}},_clear:function(){this._removeClass(this.helper,"ui-draggable-dragging"),this.helper[0]===this.element[0]||this.cancelHelperRemoval||this.helper.remove(),this.helper=null,this.cancelHelperRemoval=!1,this.destroyOnClear&&this.destroy()},_trigger:function(e,i,s){return s=s||this._uiHash(),t.ui.plugin.call(this,e,[i,s,this],!0),/^(drag|start|stop)/.test(e)&&(this.positionAbs=this._convertPositionTo("absolute"),s.offset=this.positionAbs),t.Widget.prototype._trigger.call(this,e,i,s)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}}),t.ui.plugin.add("draggable","connectToSortable",{start:function(e,i,s){var n=t.extend({},i,{item:s.element});s.sortables=[],t(s.options.connectToSortable).each(function(){var i=t(this).sortable("instance");i&&!i.options.disabled&&(s.sortables.push(i),i.refreshPositions(),i._trigger("activate",e,n))})},stop:function(e,i,s){var n=t.extend({},i,{item:s.element});s.cancelHelperRemoval=!1,t.each(s.sortables,function(){var t=this;t.isOver?(t.isOver=0,s.cancelHelperRemoval=!0,t.cancelHelperRemoval=!1,t._storedCSS={position:t.placeholder.css("position"),top:t.placeholder.css("top"),left:t.placeholder.css("left")},t._mouseStop(e),t.options.helper=t.options._helper):(t.cancelHelperRemoval=!0,t._trigger("deactivate",e,n))})},drag:function(e,i,s){t.each(s.sortables,function(){var n=!1,o=this;o.positionAbs=s.positionAbs,o.helperProportions=s.helperProportions,o.offset.click=s.offset.click,o._intersectsWith(o.containerCache)&&(n=!0,t.each(s.sortables,function(){return this.positionAbs=s.positionAbs,this.helperProportions=s.helperProportions,this.offset.click=s.offset.click,this!==o&&this._intersectsWith(this.containerCache)&&t.contains(o.element[0],this.element[0])&&(n=!1),n})),n?(o.isOver||(o.isOver=1,s._parent=i.helper.parent(),o.currentItem=i.helper.appendTo(o.element).data("ui-sortable-item",!0),o.options._helper=o.options.helper,o.options.helper=function(){return i.helper[0]},e.target=o.currentItem[0],o._mouseCapture(e,!0),o._mouseStart(e,!0,!0),o.offset.click.top=s.offset.click.top,o.offset.click.left=s.offset.click.left,o.offset.parent.left-=s.offset.parent.left-o.offset.parent.left,o.offset.parent.top-=s.offset.parent.top-o.offset.parent.top,s._trigger("toSortable",e),s.dropped=o.element,t.each(s.sortables,function(){this.refreshPositions()}),s.currentItem=s.element,o.fromOutside=s),o.currentItem&&(o._mouseDrag(e),i.position=o.position)):o.isOver&&(o.isOver=0,o.cancelHelperRemoval=!0,o.options._revert=o.options.revert,o.options.revert=!1,o._trigger("out",e,o._uiHash(o)),o._mouseStop(e,!0),o.options.revert=o.options._revert,o.options.helper=o.options._helper,o.placeholder&&o.placeholder.remove(),i.helper.appendTo(s._parent),s._refreshOffsets(e),i.position=s._generatePosition(e,!0),s._trigger("fromSortable",e),s.dropped=!1,t.each(s.sortables,function(){this.refreshPositions()}))})}}),t.ui.plugin.add("draggable","cursor",{start:function(e,i,s){var n=t("body"),o=s.options;n.css("cursor")&&(o._cursor=n.css("cursor")),n.css("cursor",o.cursor)},stop:function(e,i,s){var n=s.options;n._cursor&&t("body").css("cursor",n._cursor)}}),t.ui.plugin.add("draggable","opacity",{start:function(e,i,s){var n=t(i.helper),o=s.options;n.css("opacity")&&(o._opacity=n.css("opacity")),n.css("opacity",o.opacity)},stop:function(e,i,s){var n=s.options;n._opacity&&t(i.helper).css("opacity",n._opacity)}}),t.ui.plugin.add("draggable","scroll",{start:function(t,e,i){i.scrollParentNotHidden||(i.scrollParentNotHidden=i.helper.scrollParent(!1)),i.scrollParentNotHidden[0]!==i.document[0]&&"HTML"!==i.scrollParentNotHidden[0].tagName&&(i.overflowOffset=i.scrollParentNotHidden.offset())},drag:function(e,i,s){var n=s.options,o=!1,a=s.scrollParentNotHidden[0],r=s.document[0];a!==r&&"HTML"!==a.tagName?(n.axis&&"x"===n.axis||(s.overflowOffset.top+a.offsetHeight-e.pageY<n.scrollSensitivity?a.scrollTop=o=a.scrollTop+n.scrollSpeed:e.pageY-s.overflowOffset.top<n.scrollSensitivity&&(a.scrollTop=o=a.scrollTop-n.scrollSpeed)),n.axis&&"y"===n.axis||(s.overflowOffset.left+a.offsetWidth-e.pageX<n.scrollSensitivity?a.scrollLeft=o=a.scrollLeft+n.scrollSpeed:e.pageX-s.overflowOffset.left<n.scrollSensitivity&&(a.scrollLeft=o=a.scrollLeft-n.scrollSpeed))):(n.axis&&"x"===n.axis||(e.pageY-t(r).scrollTop()<n.scrollSensitivity?o=t(r).scrollTop(t(r).scrollTop()-n.scrollSpeed):t(window).height()-(e.pageY-t(r).scrollTop())<n.scrollSensitivity&&(o=t(r).scrollTop(t(r).scrollTop()+n.scrollSpeed))),n.axis&&"y"===n.axis||(e.pageX-t(r).scrollLeft()<n.scrollSensitivity?o=t(r).scrollLeft(t(r).scrollLeft()-n.scrollSpeed):t(window).width()-(e.pageX-t(r).scrollLeft())<n.scrollSensitivity&&(o=t(r).scrollLeft(t(r).scrollLeft()+n.scrollSpeed)))),o!==!1&&t.ui.ddmanager&&!n.dropBehaviour&&t.ui.ddmanager.prepareOffsets(s,e)}}),t.ui.plugin.add("draggable","snap",{start:function(e,i,s){var n=s.options;s.snapElements=[],t(n.snap.constructor!==String?n.snap.items||":data(ui-draggable)":n.snap).each(function(){var e=t(this),i=e.offset();this!==s.element[0]&&s.snapElements.push({item:this,width:e.outerWidth(),height:e.outerHeight(),top:i.top,left:i.left})})},drag:function(e,i,s){var n,o,a,r,h,l,c,u,d,p,f=s.options,g=f.snapTolerance,m=i.offset.left,_=m+s.helperProportions.width,v=i.offset.top,b=v+s.helperProportions.height;for(d=s.snapElements.length-1;d>=0;d--)h=s.snapElements[d].left-s.margins.left,l=h+s.snapElements[d].width,c=s.snapElements[d].top-s.margins.top,u=c+s.snapElements[d].height,h-g>_||m>l+g||c-g>b||v>u+g||!t.contains(s.snapElements[d].item.ownerDocument,s.snapElements[d].item)?(s.snapElements[d].snapping&&s.options.snap.release&&s.options.snap.release.call(s.element,e,t.extend(s._uiHash(),{snapItem:s.snapElements[d].item})),s.snapElements[d].snapping=!1):("inner"!==f.snapMode&&(n=g>=Math.abs(c-b),o=g>=Math.abs(u-v),a=g>=Math.abs(h-_),r=g>=Math.abs(l-m),n&&(i.position.top=s._convertPositionTo("relative",{top:c-s.helperProportions.height,left:0}).top),o&&(i.position.top=s._convertPositionTo("relative",{top:u,left:0}).top),a&&(i.position.left=s._convertPositionTo("relative",{top:0,left:h-s.helperProportions.width}).left),r&&(i.position.left=s._convertPositionTo("relative",{top:0,left:l}).left)),p=n||o||a||r,"outer"!==f.snapMode&&(n=g>=Math.abs(c-v),o=g>=Math.abs(u-b),a=g>=Math.abs(h-m),r=g>=Math.abs(l-_),n&&(i.position.top=s._convertPositionTo("relative",{top:c,left:0}).top),o&&(i.position.top=s._convertPositionTo("relative",{top:u-s.helperProportions.height,left:0}).top),a&&(i.position.left=s._convertPositionTo("relative",{top:0,left:h}).left),r&&(i.position.left=s._convertPositionTo("relative",{top:0,left:l-s.helperProportions.width}).left)),!s.snapElements[d].snapping&&(n||o||a||r||p)&&s.options.snap.snap&&s.options.snap.snap.call(s.element,e,t.extend(s._uiHash(),{snapItem:s.snapElements[d].item})),s.snapElements[d].snapping=n||o||a||r||p)}}),t.ui.plugin.add("draggable","stack",{start:function(e,i,s){var n,o=s.options,a=t.makeArray(t(o.stack)).sort(function(e,i){return(parseInt(t(e).css("zIndex"),10)||0)-(parseInt(t(i).css("zIndex"),10)||0)});a.length&&(n=parseInt(t(a[0]).css("zIndex"),10)||0,t(a).each(function(e){t(this).css("zIndex",n+e)}),this.css("zIndex",n+a.length))}}),t.ui.plugin.add("draggable","zIndex",{start:function(e,i,s){var n=t(i.helper),o=s.options;n.css("zIndex")&&(o._zIndex=n.css("zIndex")),n.css("zIndex",o.zIndex)},stop:function(e,i,s){var n=s.options;n._zIndex&&t(i.helper).css("zIndex",n._zIndex)}}),t.ui.draggable,t.widget("ui.resizable",t.ui.mouse,{version:"1.12.1",widgetEventPrefix:"resize",options:{alsoResize:!1,animate:!1,animateDuration:"slow",animateEasing:"swing",aspectRatio:!1,autoHide:!1,classes:{"ui-resizable-se":"ui-icon ui-icon-gripsmall-diagonal-se"},containment:!1,ghost:!1,grid:!1,handles:"e,s,se",helper:!1,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:90,resize:null,start:null,stop:null},_num:function(t){return parseFloat(t)||0},_isNumber:function(t){return!isNaN(parseFloat(t))},_hasScroll:function(e,i){if("hidden"===t(e).css("overflow"))return!1;var s=i&&"left"===i?"scrollLeft":"scrollTop",n=!1;return e[s]>0?!0:(e[s]=1,n=e[s]>0,e[s]=0,n)},_create:function(){var e,i=this.options,s=this;this._addClass("ui-resizable"),t.extend(this,{_aspectRatio:!!i.aspectRatio,aspectRatio:i.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:i.helper||i.ghost||i.animate?i.helper||"ui-resizable-helper":null}),this.element[0].nodeName.match(/^(canvas|textarea|input|select|button|img)$/i)&&(this.element.wrap(t("<div class='ui-wrapper' style='overflow: hidden;'></div>").css({position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")})),this.element=this.element.parent().data("ui-resizable",this.element.resizable("instance")),this.elementIsWrapper=!0,e={marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom"),marginLeft:this.originalElement.css("marginLeft")},this.element.css(e),this.originalElement.css("margin",0),this.originalResizeStyle=this.originalElement.css("resize"),this.originalElement.css("resize","none"),this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"})),this.originalElement.css(e),this._proportionallyResize()),this._setupHandles(),i.autoHide&&t(this.element).on("mouseenter",function(){i.disabled||(s._removeClass("ui-resizable-autohide"),s._handles.show())}).on("mouseleave",function(){i.disabled||s.resizing||(s._addClass("ui-resizable-autohide"),s._handles.hide())}),this._mouseInit()},_destroy:function(){this._mouseDestroy();var e,i=function(e){t(e).removeData("resizable").removeData("ui-resizable").off(".resizable").find(".ui-resizable-handle").remove()};return this.elementIsWrapper&&(i(this.element),e=this.element,this.originalElement.css({position:e.css("position"),width:e.outerWidth(),height:e.outerHeight(),top:e.css("top"),left:e.css("left")}).insertAfter(e),e.remove()),this.originalElement.css("resize",this.originalResizeStyle),i(this.originalElement),this},_setOption:function(t,e){switch(this._super(t,e),t){case"handles":this._removeHandles(),this._setupHandles();break;default:}},_setupHandles:function(){var e,i,s,n,o,a=this.options,r=this;if(this.handles=a.handles||(t(".ui-resizable-handle",this.element).length?{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"}:"e,s,se"),this._handles=t(),this.handles.constructor===String)for("all"===this.handles&&(this.handles="n,e,s,w,se,sw,ne,nw"),s=this.handles.split(","),this.handles={},i=0;s.length>i;i++)e=t.trim(s[i]),n="ui-resizable-"+e,o=t("<div>"),this._addClass(o,"ui-resizable-handle "+n),o.css({zIndex:a.zIndex}),this.handles[e]=".ui-resizable-"+e,this.element.append(o);this._renderAxis=function(e){var i,s,n,o;e=e||this.element;for(i in this.handles)this.handles[i].constructor===String?this.handles[i]=this.element.children(this.handles[i]).first().show():(this.handles[i].jquery||this.handles[i].nodeType)&&(this.handles[i]=t(this.handles[i]),this._on(this.handles[i],{mousedown:r._mouseDown})),this.elementIsWrapper&&this.originalElement[0].nodeName.match(/^(textarea|input|select|button)$/i)&&(s=t(this.handles[i],this.element),o=/sw|ne|nw|se|n|s/.test(i)?s.outerHeight():s.outerWidth(),n=["padding",/ne|nw|n/.test(i)?"Top":/se|sw|s/.test(i)?"Bottom":/^e$/.test(i)?"Right":"Left"].join(""),e.css(n,o),this._proportionallyResize()),this._handles=this._handles.add(this.handles[i])},this._renderAxis(this.element),this._handles=this._handles.add(this.element.find(".ui-resizable-handle")),this._handles.disableSelection(),this._handles.on("mouseover",function(){r.resizing||(this.className&&(o=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)),r.axis=o&&o[1]?o[1]:"se")}),a.autoHide&&(this._handles.hide(),this._addClass("ui-resizable-autohide"))},_removeHandles:function(){this._handles.remove()},_mouseCapture:function(e){var i,s,n=!1;for(i in this.handles)s=t(this.handles[i])[0],(s===e.target||t.contains(s,e.target))&&(n=!0);return!this.options.disabled&&n},_mouseStart:function(e){var i,s,n,o=this.options,a=this.element;return this.resizing=!0,this._renderProxy(),i=this._num(this.helper.css("left")),s=this._num(this.helper.css("top")),o.containment&&(i+=t(o.containment).scrollLeft()||0,s+=t(o.containment).scrollTop()||0),this.offset=this.helper.offset(),this.position={left:i,top:s},this.size=this._helper?{width:this.helper.width(),height:this.helper.height()}:{width:a.width(),height:a.height()},this.originalSize=this._helper?{width:a.outerWidth(),height:a.outerHeight()}:{width:a.width(),height:a.height()},this.sizeDiff={width:a.outerWidth()-a.width(),height:a.outerHeight()-a.height()},this.originalPosition={left:i,top:s},this.originalMousePosition={left:e.pageX,top:e.pageY},this.aspectRatio="number"==typeof o.aspectRatio?o.aspectRatio:this.originalSize.width/this.originalSize.height||1,n=t(".ui-resizable-"+this.axis).css("cursor"),t("body").css("cursor","auto"===n?this.axis+"-resize":n),this._addClass("ui-resizable-resizing"),this._propagate("start",e),!0},_mouseDrag:function(e){var i,s,n=this.originalMousePosition,o=this.axis,a=e.pageX-n.left||0,r=e.pageY-n.top||0,h=this._change[o];return this._updatePrevProperties(),h?(i=h.apply(this,[e,a,r]),this._updateVirtualBoundaries(e.shiftKey),(this._aspectRatio||e.shiftKey)&&(i=this._updateRatio(i,e)),i=this._respectSize(i,e),this._updateCache(i),this._propagate("resize",e),s=this._applyChanges(),!this._helper&&this._proportionallyResizeElements.length&&this._proportionallyResize(),t.isEmptyObject(s)||(this._updatePrevProperties(),this._trigger("resize",e,this.ui()),this._applyChanges()),!1):!1},_mouseStop:function(e){this.resizing=!1;var i,s,n,o,a,r,h,l=this.options,c=this;return this._helper&&(i=this._proportionallyResizeElements,s=i.length&&/textarea/i.test(i[0].nodeName),n=s&&this._hasScroll(i[0],"left")?0:c.sizeDiff.height,o=s?0:c.sizeDiff.width,a={width:c.helper.width()-o,height:c.helper.height()-n},r=parseFloat(c.element.css("left"))+(c.position.left-c.originalPosition.left)||null,h=parseFloat(c.element.css("top"))+(c.position.top-c.originalPosition.top)||null,l.animate||this.element.css(t.extend(a,{top:h,left:r})),c.helper.height(c.size.height),c.helper.width(c.size.width),this._helper&&!l.animate&&this._proportionallyResize()),t("body").css("cursor","auto"),this._removeClass("ui-resizable-resizing"),this._propagate("stop",e),this._helper&&this.helper.remove(),!1},_updatePrevProperties:function(){this.prevPosition={top:this.position.top,left:this.position.left},this.prevSize={width:this.size.width,height:this.size.height}},_applyChanges:function(){var t={};return this.position.top!==this.prevPosition.top&&(t.top=this.position.top+"px"),this.position.left!==this.prevPosition.left&&(t.left=this.position.left+"px"),this.size.width!==this.prevSize.width&&(t.width=this.size.width+"px"),this.size.height!==this.prevSize.height&&(t.height=this.size.height+"px"),this.helper.css(t),t},_updateVirtualBoundaries:function(t){var e,i,s,n,o,a=this.options;o={minWidth:this._isNumber(a.minWidth)?a.minWidth:0,maxWidth:this._isNumber(a.maxWidth)?a.maxWidth:1/0,minHeight:this._isNumber(a.minHeight)?a.minHeight:0,maxHeight:this._isNumber(a.maxHeight)?a.maxHeight:1/0},(this._aspectRatio||t)&&(e=o.minHeight*this.aspectRatio,s=o.minWidth/this.aspectRatio,i=o.maxHeight*this.aspectRatio,n=o.maxWidth/this.aspectRatio,e>o.minWidth&&(o.minWidth=e),s>o.minHeight&&(o.minHeight=s),o.maxWidth>i&&(o.maxWidth=i),o.maxHeight>n&&(o.maxHeight=n)),this._vBoundaries=o},_updateCache:function(t){this.offset=this.helper.offset(),this._isNumber(t.left)&&(this.position.left=t.left),this._isNumber(t.top)&&(this.position.top=t.top),this._isNumber(t.height)&&(this.size.height=t.height),this._isNumber(t.width)&&(this.size.width=t.width)},_updateRatio:function(t){var e=this.position,i=this.size,s=this.axis;return this._isNumber(t.height)?t.width=t.height*this.aspectRatio:this._isNumber(t.width)&&(t.height=t.width/this.aspectRatio),"sw"===s&&(t.left=e.left+(i.width-t.width),t.top=null),"nw"===s&&(t.top=e.top+(i.height-t.height),t.left=e.left+(i.width-t.width)),t},_respectSize:function(t){var e=this._vBoundaries,i=this.axis,s=this._isNumber(t.width)&&e.maxWidth&&e.maxWidth<t.width,n=this._isNumber(t.height)&&e.maxHeight&&e.maxHeight<t.height,o=this._isNumber(t.width)&&e.minWidth&&e.minWidth>t.width,a=this._isNumber(t.height)&&e.minHeight&&e.minHeight>t.height,r=this.originalPosition.left+this.originalSize.width,h=this.originalPosition.top+this.originalSize.height,l=/sw|nw|w/.test(i),c=/nw|ne|n/.test(i);return o&&(t.width=e.minWidth),a&&(t.height=e.minHeight),s&&(t.width=e.maxWidth),n&&(t.height=e.maxHeight),o&&l&&(t.left=r-e.minWidth),s&&l&&(t.left=r-e.maxWidth),a&&c&&(t.top=h-e.minHeight),n&&c&&(t.top=h-e.maxHeight),t.width||t.height||t.left||!t.top?t.width||t.height||t.top||!t.left||(t.left=null):t.top=null,t},_getPaddingPlusBorderDimensions:function(t){for(var e=0,i=[],s=[t.css("borderTopWidth"),t.css("borderRightWidth"),t.css("borderBottomWidth"),t.css("borderLeftWidth")],n=[t.css("paddingTop"),t.css("paddingRight"),t.css("paddingBottom"),t.css("paddingLeft")];4>e;e++)i[e]=parseFloat(s[e])||0,i[e]+=parseFloat(n[e])||0;return{height:i[0]+i[2],width:i[1]+i[3]}},_proportionallyResize:function(){if(this._proportionallyResizeElements.length)for(var t,e=0,i=this.helper||this.element;this._proportionallyResizeElements.length>e;e++)t=this._proportionallyResizeElements[e],this.outerDimensions||(this.outerDimensions=this._getPaddingPlusBorderDimensions(t)),t.css({height:i.height()-this.outerDimensions.height||0,width:i.width()-this.outerDimensions.width||0})},_renderProxy:function(){var e=this.element,i=this.options;this.elementOffset=e.offset(),this._helper?(this.helper=this.helper||t("<div style='overflow:hidden;'></div>"),this._addClass(this.helper,this._helper),this.helper.css({width:this.element.outerWidth(),height:this.element.outerHeight(),position:"absolute",left:this.elementOffset.left+"px",top:this.elementOffset.top+"px",zIndex:++i.zIndex}),this.helper.appendTo("body").disableSelection()):this.helper=this.element},_change:{e:function(t,e){return{width:this.originalSize.width+e}},w:function(t,e){var i=this.originalSize,s=this.originalPosition;return{left:s.left+e,width:i.width-e}},n:function(t,e,i){var s=this.originalSize,n=this.originalPosition;return{top:n.top+i,height:s.height-i}},s:function(t,e,i){return{height:this.originalSize.height+i}},se:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},sw:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[e,i,s]))},ne:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},nw:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[e,i,s]))}},_propagate:function(e,i){t.ui.plugin.call(this,e,[i,this.ui()]),"resize"!==e&&this._trigger(e,i,this.ui())},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}}}),t.ui.plugin.add("resizable","animate",{stop:function(e){var i=t(this).resizable("instance"),s=i.options,n=i._proportionallyResizeElements,o=n.length&&/textarea/i.test(n[0].nodeName),a=o&&i._hasScroll(n[0],"left")?0:i.sizeDiff.height,r=o?0:i.sizeDiff.width,h={width:i.size.width-r,height:i.size.height-a},l=parseFloat(i.element.css("left"))+(i.position.left-i.originalPosition.left)||null,c=parseFloat(i.element.css("top"))+(i.position.top-i.originalPosition.top)||null;i.element.animate(t.extend(h,c&&l?{top:c,left:l}:{}),{duration:s.animateDuration,easing:s.animateEasing,step:function(){var s={width:parseFloat(i.element.css("width")),height:parseFloat(i.element.css("height")),top:parseFloat(i.element.css("top")),left:parseFloat(i.element.css("left"))};n&&n.length&&t(n[0]).css({width:s.width,height:s.height}),i._updateCache(s),i._propagate("resize",e)}})}}),t.ui.plugin.add("resizable","containment",{start:function(){var e,i,s,n,o,a,r,h=t(this).resizable("instance"),l=h.options,c=h.element,u=l.containment,d=u instanceof t?u.get(0):/parent/.test(u)?c.parent().get(0):u;d&&(h.containerElement=t(d),/document/.test(u)||u===document?(h.containerOffset={left:0,top:0},h.containerPosition={left:0,top:0},h.parentData={element:t(document),left:0,top:0,width:t(document).width(),height:t(document).height()||document.body.parentNode.scrollHeight}):(e=t(d),i=[],t(["Top","Right","Left","Bottom"]).each(function(t,s){i[t]=h._num(e.css("padding"+s))}),h.containerOffset=e.offset(),h.containerPosition=e.position(),h.containerSize={height:e.innerHeight()-i[3],width:e.innerWidth()-i[1]},s=h.containerOffset,n=h.containerSize.height,o=h.containerSize.width,a=h._hasScroll(d,"left")?d.scrollWidth:o,r=h._hasScroll(d)?d.scrollHeight:n,h.parentData={element:d,left:s.left,top:s.top,width:a,height:r}))},resize:function(e){var i,s,n,o,a=t(this).resizable("instance"),r=a.options,h=a.containerOffset,l=a.position,c=a._aspectRatio||e.shiftKey,u={top:0,left:0},d=a.containerElement,p=!0;d[0]!==document&&/static/.test(d.css("position"))&&(u=h),l.left<(a._helper?h.left:0)&&(a.size.width=a.size.width+(a._helper?a.position.left-h.left:a.position.left-u.left),c&&(a.size.height=a.size.width/a.aspectRatio,p=!1),a.position.left=r.helper?h.left:0),l.top<(a._helper?h.top:0)&&(a.size.height=a.size.height+(a._helper?a.position.top-h.top:a.position.top),c&&(a.size.width=a.size.height*a.aspectRatio,p=!1),a.position.top=a._helper?h.top:0),n=a.containerElement.get(0)===a.element.parent().get(0),o=/relative|absolute/.test(a.containerElement.css("position")),n&&o?(a.offset.left=a.parentData.left+a.position.left,a.offset.top=a.parentData.top+a.position.top):(a.offset.left=a.element.offset().left,a.offset.top=a.element.offset().top),i=Math.abs(a.sizeDiff.width+(a._helper?a.offset.left-u.left:a.offset.left-h.left)),s=Math.abs(a.sizeDiff.height+(a._helper?a.offset.top-u.top:a.offset.top-h.top)),i+a.size.width>=a.parentData.width&&(a.size.width=a.parentData.width-i,c&&(a.size.height=a.size.width/a.aspectRatio,p=!1)),s+a.size.height>=a.parentData.height&&(a.size.height=a.parentData.height-s,c&&(a.size.width=a.size.height*a.aspectRatio,p=!1)),p||(a.position.left=a.prevPosition.left,a.position.top=a.prevPosition.top,a.size.width=a.prevSize.width,a.size.height=a.prevSize.height)},stop:function(){var e=t(this).resizable("instance"),i=e.options,s=e.containerOffset,n=e.containerPosition,o=e.containerElement,a=t(e.helper),r=a.offset(),h=a.outerWidth()-e.sizeDiff.width,l=a.outerHeight()-e.sizeDiff.height;e._helper&&!i.animate&&/relative/.test(o.css("position"))&&t(this).css({left:r.left-n.left-s.left,width:h,height:l}),e._helper&&!i.animate&&/static/.test(o.css("position"))&&t(this).css({left:r.left-n.left-s.left,width:h,height:l})}}),t.ui.plugin.add("resizable","alsoResize",{start:function(){var e=t(this).resizable("instance"),i=e.options;t(i.alsoResize).each(function(){var e=t(this);e.data("ui-resizable-alsoresize",{width:parseFloat(e.width()),height:parseFloat(e.height()),left:parseFloat(e.css("left")),top:parseFloat(e.css("top"))})})},resize:function(e,i){var s=t(this).resizable("instance"),n=s.options,o=s.originalSize,a=s.originalPosition,r={height:s.size.height-o.height||0,width:s.size.width-o.width||0,top:s.position.top-a.top||0,left:s.position.left-a.left||0};t(n.alsoResize).each(function(){var e=t(this),s=t(this).data("ui-resizable-alsoresize"),n={},o=e.parents(i.originalElement[0]).length?["width","height"]:["width","height","top","left"];t.each(o,function(t,e){var i=(s[e]||0)+(r[e]||0);i&&i>=0&&(n[e]=i||null)}),e.css(n)})},stop:function(){t(this).removeData("ui-resizable-alsoresize")}}),t.ui.plugin.add("resizable","ghost",{start:function(){var e=t(this).resizable("instance"),i=e.size;e.ghost=e.originalElement.clone(),e.ghost.css({opacity:.25,display:"block",position:"relative",height:i.height,width:i.width,margin:0,left:0,top:0}),e._addClass(e.ghost,"ui-resizable-ghost"),t.uiBackCompat!==!1&&"string"==typeof e.options.ghost&&e.ghost.addClass(this.options.ghost),e.ghost.appendTo(e.helper)},resize:function(){var e=t(this).resizable("instance");e.ghost&&e.ghost.css({position:"relative",height:e.size.height,width:e.size.width})},stop:function(){var e=t(this).resizable("instance");e.ghost&&e.helper&&e.helper.get(0).removeChild(e.ghost.get(0))}}),t.ui.plugin.add("resizable","grid",{resize:function(){var e,i=t(this).resizable("instance"),s=i.options,n=i.size,o=i.originalSize,a=i.originalPosition,r=i.axis,h="number"==typeof s.grid?[s.grid,s.grid]:s.grid,l=h[0]||1,c=h[1]||1,u=Math.round((n.width-o.width)/l)*l,d=Math.round((n.height-o.height)/c)*c,p=o.width+u,f=o.height+d,g=s.maxWidth&&p>s.maxWidth,m=s.maxHeight&&f>s.maxHeight,_=s.minWidth&&s.minWidth>p,v=s.minHeight&&s.minHeight>f;s.grid=h,_&&(p+=l),v&&(f+=c),g&&(p-=l),m&&(f-=c),/^(se|s|e)$/.test(r)?(i.size.width=p,i.size.height=f):/^(ne)$/.test(r)?(i.size.width=p,i.size.height=f,i.position.top=a.top-d):/^(sw)$/.test(r)?(i.size.width=p,i.size.height=f,i.position.left=a.left-u):((0>=f-c||0>=p-l)&&(e=i._getPaddingPlusBorderDimensions(this)),f-c>0?(i.size.height=f,i.position.top=a.top-d):(f=c-e.height,i.size.height=f,i.position.top=a.top+o.height-f),p-l>0?(i.size.width=p,i.position.left=a.left-u):(p=l-e.width,i.size.width=p,i.position.left=a.left+o.width-p))}}),t.ui.resizable,t.widget("ui.dialog",{version:"1.12.1",options:{appendTo:"body",autoOpen:!0,buttons:[],classes:{"ui-dialog":"ui-corner-all","ui-dialog-titlebar":"ui-corner-all"},closeOnEscape:!0,closeText:"Close",draggable:!0,hide:null,height:"auto",maxHeight:null,maxWidth:null,minHeight:150,minWidth:150,modal:!1,position:{my:"center",at:"center",of:window,collision:"fit",using:function(e){var i=t(this).css(e).offset().top;0>i&&t(this).css("top",e.top-i)}},resizable:!0,show:null,title:null,width:300,beforeClose:null,close:null,drag:null,dragStart:null,dragStop:null,focus:null,open:null,resize:null,resizeStart:null,resizeStop:null},sizeRelatedOptions:{buttons:!0,height:!0,maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0,width:!0},resizableRelatedOptions:{maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0},_create:function(){this.originalCss={display:this.element[0].style.display,width:this.element[0].style.width,minHeight:this.element[0].style.minHeight,maxHeight:this.element[0].style.maxHeight,height:this.element[0].style.height},this.originalPosition={parent:this.element.parent(),index:this.element.parent().children().index(this.element)},this.originalTitle=this.element.attr("title"),null==this.options.title&&null!=this.originalTitle&&(this.options.title=this.originalTitle),this.options.disabled&&(this.options.disabled=!1),this._createWrapper(),this.element.show().removeAttr("title").appendTo(this.uiDialog),this._addClass("ui-dialog-content","ui-widget-content"),this._createTitlebar(),this._createButtonPane(),this.options.draggable&&t.fn.draggable&&this._makeDraggable(),this.options.resizable&&t.fn.resizable&&this._makeResizable(),this._isOpen=!1,this._trackFocus()},_init:function(){this.options.autoOpen&&this.open()},_appendTo:function(){var e=this.options.appendTo;return e&&(e.jquery||e.nodeType)?t(e):this.document.find(e||"body").eq(0)},_destroy:function(){var t,e=this.originalPosition;this._untrackInstance(),this._destroyOverlay(),this.element.removeUniqueId().css(this.originalCss).detach(),this.uiDialog.remove(),this.originalTitle&&this.element.attr("title",this.originalTitle),t=e.parent.children().eq(e.index),t.length&&t[0]!==this.element[0]?t.before(this.element):e.parent.append(this.element)},widget:function(){return this.uiDialog},disable:t.noop,enable:t.noop,close:function(e){var i=this;this._isOpen&&this._trigger("beforeClose",e)!==!1&&(this._isOpen=!1,this._focusedElement=null,this._destroyOverlay(),this._untrackInstance(),this.opener.filter(":focusable").trigger("focus").length||t.ui.safeBlur(t.ui.safeActiveElement(this.document[0])),this._hide(this.uiDialog,this.options.hide,function(){i._trigger("close",e)}))},isOpen:function(){return this._isOpen},moveToTop:function(){this._moveToTop()},_moveToTop:function(e,i){var s=!1,n=this.uiDialog.siblings(".ui-front:visible").map(function(){return+t(this).css("z-index")}).get(),o=Math.max.apply(null,n);return o>=+this.uiDialog.css("z-index")&&(this.uiDialog.css("z-index",o+1),s=!0),s&&!i&&this._trigger("focus",e),s},open:function(){var e=this;return this._isOpen?(this._moveToTop()&&this._focusTabbable(),void 0):(this._isOpen=!0,this.opener=t(t.ui.safeActiveElement(this.document[0])),this._size(),this._position(),this._createOverlay(),this._moveToTop(null,!0),this.overlay&&this.overlay.css("z-index",this.uiDialog.css("z-index")-1),this._show(this.uiDialog,this.options.show,function(){e._focusTabbable(),e._trigger("focus")}),this._makeFocusTarget(),this._trigger("open"),void 0)},_focusTabbable:function(){var t=this._focusedElement;t||(t=this.element.find("[autofocus]")),t.length||(t=this.element.find(":tabbable")),t.length||(t=this.uiDialogButtonPane.find(":tabbable")),t.length||(t=this.uiDialogTitlebarClose.filter(":tabbable")),t.length||(t=this.uiDialog),t.eq(0).trigger("focus")},_keepFocus:function(e){function i(){var e=t.ui.safeActiveElement(this.document[0]),i=this.uiDialog[0]===e||t.contains(this.uiDialog[0],e);i||this._focusTabbable()}e.preventDefault(),i.call(this),this._delay(i)},_createWrapper:function(){this.uiDialog=t("<div>").hide().attr({tabIndex:-1,role:"dialog"}).appendTo(this._appendTo()),this._addClass(this.uiDialog,"ui-dialog","ui-widget ui-widget-content ui-front"),this._on(this.uiDialog,{keydown:function(e){if(this.options.closeOnEscape&&!e.isDefaultPrevented()&&e.keyCode&&e.keyCode===t.ui.keyCode.ESCAPE)return e.preventDefault(),this.close(e),void 0;if(e.keyCode===t.ui.keyCode.TAB&&!e.isDefaultPrevented()){var i=this.uiDialog.find(":tabbable"),s=i.filter(":first"),n=i.filter(":last");e.target!==n[0]&&e.target!==this.uiDialog[0]||e.shiftKey?e.target!==s[0]&&e.target!==this.uiDialog[0]||!e.shiftKey||(this._delay(function(){n.trigger("focus")}),e.preventDefault()):(this._delay(function(){s.trigger("focus")}),e.preventDefault())}},mousedown:function(t){this._moveToTop(t)&&this._focusTabbable()}}),this.element.find("[aria-describedby]").length||this.uiDialog.attr({"aria-describedby":this.element.uniqueId().attr("id")})},_createTitlebar:function(){var e;this.uiDialogTitlebar=t("<div>"),this._addClass(this.uiDialogTitlebar,"ui-dialog-titlebar","ui-widget-header ui-helper-clearfix"),this._on(this.uiDialogTitlebar,{mousedown:function(e){t(e.target).closest(".ui-dialog-titlebar-close")||this.uiDialog.trigger("focus")}}),this.uiDialogTitlebarClose=t("<button type='button'></button>").button({label:t("<a>").text(this.options.closeText).html(),icon:"ui-icon-closethick",showLabel:!1}).appendTo(this.uiDialogTitlebar),this._addClass(this.uiDialogTitlebarClose,"ui-dialog-titlebar-close"),this._on(this.uiDialogTitlebarClose,{click:function(t){t.preventDefault(),this.close(t)}}),e=t("<span>").uniqueId().prependTo(this.uiDialogTitlebar),this._addClass(e,"ui-dialog-title"),this._title(e),this.uiDialogTitlebar.prependTo(this.uiDialog),this.uiDialog.attr({"aria-labelledby":e.attr("id")})},_title:function(t){this.options.title?t.text(this.options.title):t.html("&#160;")},_createButtonPane:function(){this.uiDialogButtonPane=t("<div>"),this._addClass(this.uiDialogButtonPane,"ui-dialog-buttonpane","ui-widget-content ui-helper-clearfix"),this.uiButtonSet=t("<div>").appendTo(this.uiDialogButtonPane),this._addClass(this.uiButtonSet,"ui-dialog-buttonset"),this._createButtons()},_createButtons:function(){var e=this,i=this.options.buttons;return this.uiDialogButtonPane.remove(),this.uiButtonSet.empty(),t.isEmptyObject(i)||t.isArray(i)&&!i.length?(this._removeClass(this.uiDialog,"ui-dialog-buttons"),void 0):(t.each(i,function(i,s){var n,o;s=t.isFunction(s)?{click:s,text:i}:s,s=t.extend({type:"button"},s),n=s.click,o={icon:s.icon,iconPosition:s.iconPosition,showLabel:s.showLabel,icons:s.icons,text:s.text},delete s.click,delete s.icon,delete s.iconPosition,delete s.showLabel,delete s.icons,"boolean"==typeof s.text&&delete s.text,t("<button></button>",s).button(o).appendTo(e.uiButtonSet).on("click",function(){n.apply(e.element[0],arguments)})}),this._addClass(this.uiDialog,"ui-dialog-buttons"),this.uiDialogButtonPane.appendTo(this.uiDialog),void 0)},_makeDraggable:function(){function e(t){return{position:t.position,offset:t.offset}}var i=this,s=this.options;this.uiDialog.draggable({cancel:".ui-dialog-content, .ui-dialog-titlebar-close",handle:".ui-dialog-titlebar",containment:"document",start:function(s,n){i._addClass(t(this),"ui-dialog-dragging"),i._blockFrames(),i._trigger("dragStart",s,e(n))},drag:function(t,s){i._trigger("drag",t,e(s))},stop:function(n,o){var a=o.offset.left-i.document.scrollLeft(),r=o.offset.top-i.document.scrollTop();s.position={my:"left top",at:"left"+(a>=0?"+":"")+a+" "+"top"+(r>=0?"+":"")+r,of:i.window},i._removeClass(t(this),"ui-dialog-dragging"),i._unblockFrames(),i._trigger("dragStop",n,e(o))}})},_makeResizable:function(){function e(t){return{originalPosition:t.originalPosition,originalSize:t.originalSize,position:t.position,size:t.size}}var i=this,s=this.options,n=s.resizable,o=this.uiDialog.css("position"),a="string"==typeof n?n:"n,e,s,w,se,sw,ne,nw";this.uiDialog.resizable({cancel:".ui-dialog-content",containment:"document",alsoResize:this.element,maxWidth:s.maxWidth,maxHeight:s.maxHeight,minWidth:s.minWidth,minHeight:this._minHeight(),handles:a,start:function(s,n){i._addClass(t(this),"ui-dialog-resizing"),i._blockFrames(),i._trigger("resizeStart",s,e(n))},resize:function(t,s){i._trigger("resize",t,e(s))},stop:function(n,o){var a=i.uiDialog.offset(),r=a.left-i.document.scrollLeft(),h=a.top-i.document.scrollTop();s.height=i.uiDialog.height(),s.width=i.uiDialog.width(),s.position={my:"left top",at:"left"+(r>=0?"+":"")+r+" "+"top"+(h>=0?"+":"")+h,of:i.window},i._removeClass(t(this),"ui-dialog-resizing"),i._unblockFrames(),i._trigger("resizeStop",n,e(o))}}).css("position",o)},_trackFocus:function(){this._on(this.widget(),{focusin:function(e){this._makeFocusTarget(),this._focusedElement=t(e.target)}})},_makeFocusTarget:function(){this._untrackInstance(),this._trackingInstances().unshift(this)},_untrackInstance:function(){var e=this._trackingInstances(),i=t.inArray(this,e);-1!==i&&e.splice(i,1)},_trackingInstances:function(){var t=this.document.data("ui-dialog-instances");return t||(t=[],this.document.data("ui-dialog-instances",t)),t},_minHeight:function(){var t=this.options;return"auto"===t.height?t.minHeight:Math.min(t.minHeight,t.height)},_position:function(){var t=this.uiDialog.is(":visible");t||this.uiDialog.show(),this.uiDialog.position(this.options.position),t||this.uiDialog.hide()},_setOptions:function(e){var i=this,s=!1,n={};t.each(e,function(t,e){i._setOption(t,e),t in i.sizeRelatedOptions&&(s=!0),t in i.resizableRelatedOptions&&(n[t]=e)}),s&&(this._size(),this._position()),this.uiDialog.is(":data(ui-resizable)")&&this.uiDialog.resizable("option",n)},_setOption:function(e,i){var s,n,o=this.uiDialog;"disabled"!==e&&(this._super(e,i),"appendTo"===e&&this.uiDialog.appendTo(this._appendTo()),"buttons"===e&&this._createButtons(),"closeText"===e&&this.uiDialogTitlebarClose.button({label:t("<a>").text(""+this.options.closeText).html()}),"draggable"===e&&(s=o.is(":data(ui-draggable)"),s&&!i&&o.draggable("destroy"),!s&&i&&this._makeDraggable()),"position"===e&&this._position(),"resizable"===e&&(n=o.is(":data(ui-resizable)"),n&&!i&&o.resizable("destroy"),n&&"string"==typeof i&&o.resizable("option","handles",i),n||i===!1||this._makeResizable()),"title"===e&&this._title(this.uiDialogTitlebar.find(".ui-dialog-title")))},_size:function(){var t,e,i,s=this.options;this.element.show().css({width:"auto",minHeight:0,maxHeight:"none",height:0}),s.minWidth>s.width&&(s.width=s.minWidth),t=this.uiDialog.css({height:"auto",width:s.width}).outerHeight(),e=Math.max(0,s.minHeight-t),i="number"==typeof s.maxHeight?Math.max(0,s.maxHeight-t):"none","auto"===s.height?this.element.css({minHeight:e,maxHeight:i,height:"auto"}):this.element.height(Math.max(0,s.height-t)),this.uiDialog.is(":data(ui-resizable)")&&this.uiDialog.resizable("option","minHeight",this._minHeight())},_blockFrames:function(){this.iframeBlocks=this.document.find("iframe").map(function(){var e=t(this);return t("<div>").css({position:"absolute",width:e.outerWidth(),height:e.outerHeight()}).appendTo(e.parent()).offset(e.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_allowInteraction:function(e){return t(e.target).closest(".ui-dialog").length?!0:!!t(e.target).closest(".ui-datepicker").length},_createOverlay:function(){if(this.options.modal){var e=!0;this._delay(function(){e=!1}),this.document.data("ui-dialog-overlays")||this._on(this.document,{focusin:function(t){e||this._allowInteraction(t)||(t.preventDefault(),this._trackingInstances()[0]._focusTabbable())}}),this.overlay=t("<div>").appendTo(this._appendTo()),this._addClass(this.overlay,null,"ui-widget-overlay ui-front"),this._on(this.overlay,{mousedown:"_keepFocus"}),this.document.data("ui-dialog-overlays",(this.document.data("ui-dialog-overlays")||0)+1)}},_destroyOverlay:function(){if(this.options.modal&&this.overlay){var t=this.document.data("ui-dialog-overlays")-1;t?this.document.data("ui-dialog-overlays",t):(this._off(this.document,"focusin"),this.document.removeData("ui-dialog-overlays")),this.overlay.remove(),this.overlay=null}}}),t.uiBackCompat!==!1&&t.widget("ui.dialog",t.ui.dialog,{options:{dialogClass:""},_createWrapper:function(){this._super(),this.uiDialog.addClass(this.options.dialogClass)},_setOption:function(t,e){"dialogClass"===t&&this.uiDialog.removeClass(this.options.dialogClass).addClass(e),this._superApply(arguments)}}),t.ui.dialog,t.widget("ui.droppable",{version:"1.12.1",widgetEventPrefix:"drop",options:{accept:"*",addClasses:!0,greedy:!1,scope:"default",tolerance:"intersect",activate:null,deactivate:null,drop:null,out:null,over:null},_create:function(){var e,i=this.options,s=i.accept;this.isover=!1,this.isout=!0,this.accept=t.isFunction(s)?s:function(t){return t.is(s)},this.proportions=function(){return arguments.length?(e=arguments[0],void 0):e?e:e={width:this.element[0].offsetWidth,height:this.element[0].offsetHeight}},this._addToManager(i.scope),i.addClasses&&this._addClass("ui-droppable")},_addToManager:function(e){t.ui.ddmanager.droppables[e]=t.ui.ddmanager.droppables[e]||[],t.ui.ddmanager.droppables[e].push(this)},_splice:function(t){for(var e=0;t.length>e;e++)t[e]===this&&t.splice(e,1)},_destroy:function(){var e=t.ui.ddmanager.droppables[this.options.scope];this._splice(e)},_setOption:function(e,i){if("accept"===e)this.accept=t.isFunction(i)?i:function(t){return t.is(i)};else if("scope"===e){var s=t.ui.ddmanager.droppables[this.options.scope];this._splice(s),this._addToManager(i)}this._super(e,i)},_activate:function(e){var i=t.ui.ddmanager.current;this._addActiveClass(),i&&this._trigger("activate",e,this.ui(i))},_deactivate:function(e){var i=t.ui.ddmanager.current;this._removeActiveClass(),i&&this._trigger("deactivate",e,this.ui(i))},_over:function(e){var i=t.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this._addHoverClass(),this._trigger("over",e,this.ui(i)))},_out:function(e){var i=t.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this._removeHoverClass(),this._trigger("out",e,this.ui(i)))},_drop:function(e,i){var s=i||t.ui.ddmanager.current,n=!1;return s&&(s.currentItem||s.element)[0]!==this.element[0]?(this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function(){var i=t(this).droppable("instance");return i.options.greedy&&!i.options.disabled&&i.options.scope===s.options.scope&&i.accept.call(i.element[0],s.currentItem||s.element)&&v(s,t.extend(i,{offset:i.element.offset()}),i.options.tolerance,e)?(n=!0,!1):void 0}),n?!1:this.accept.call(this.element[0],s.currentItem||s.element)?(this._removeActiveClass(),this._removeHoverClass(),this._trigger("drop",e,this.ui(s)),this.element):!1):!1},ui:function(t){return{draggable:t.currentItem||t.element,helper:t.helper,position:t.position,offset:t.positionAbs}},_addHoverClass:function(){this._addClass("ui-droppable-hover")},_removeHoverClass:function(){this._removeClass("ui-droppable-hover")},_addActiveClass:function(){this._addClass("ui-droppable-active")},_removeActiveClass:function(){this._removeClass("ui-droppable-active")}});var v=t.ui.intersect=function(){function t(t,e,i){return t>=e&&e+i>t}return function(e,i,s,n){if(!i.offset)return!1;var o=(e.positionAbs||e.position.absolute).left+e.margins.left,a=(e.positionAbs||e.position.absolute).top+e.margins.top,r=o+e.helperProportions.width,h=a+e.helperProportions.height,l=i.offset.left,c=i.offset.top,u=l+i.proportions().width,d=c+i.proportions().height;switch(s){case"fit":return o>=l&&u>=r&&a>=c&&d>=h;case"intersect":return o+e.helperProportions.width/2>l&&u>r-e.helperProportions.width/2&&a+e.helperProportions.height/2>c&&d>h-e.helperProportions.height/2;case"pointer":return t(n.pageY,c,i.proportions().height)&&t(n.pageX,l,i.proportions().width);case"touch":return(a>=c&&d>=a||h>=c&&d>=h||c>a&&h>d)&&(o>=l&&u>=o||r>=l&&u>=r||l>o&&r>u);default:return!1}}}();t.ui.ddmanager={current:null,droppables:{"default":[]},prepareOffsets:function(e,i){var s,n,o=t.ui.ddmanager.droppables[e.options.scope]||[],a=i?i.type:null,r=(e.currentItem||e.element).find(":data(ui-droppable)").addBack();t:for(s=0;o.length>s;s++)if(!(o[s].options.disabled||e&&!o[s].accept.call(o[s].element[0],e.currentItem||e.element))){for(n=0;r.length>n;n++)if(r[n]===o[s].element[0]){o[s].proportions().height=0;continue t}o[s].visible="none"!==o[s].element.css("display"),o[s].visible&&("mousedown"===a&&o[s]._activate.call(o[s],i),o[s].offset=o[s].element.offset(),o[s].proportions({width:o[s].element[0].offsetWidth,height:o[s].element[0].offsetHeight}))}},drop:function(e,i){var s=!1;return t.each((t.ui.ddmanager.droppables[e.options.scope]||[]).slice(),function(){this.options&&(!this.options.disabled&&this.visible&&v(e,this,this.options.tolerance,i)&&(s=this._drop.call(this,i)||s),!this.options.disabled&&this.visible&&this.accept.call(this.element[0],e.currentItem||e.element)&&(this.isout=!0,this.isover=!1,this._deactivate.call(this,i)))}),s},dragStart:function(e,i){e.element.parentsUntil("body").on("scroll.droppable",function(){e.options.refreshPositions||t.ui.ddmanager.prepareOffsets(e,i)})},drag:function(e,i){e.options.refreshPositions&&t.ui.ddmanager.prepareOffsets(e,i),t.each(t.ui.ddmanager.droppables[e.options.scope]||[],function(){if(!this.options.disabled&&!this.greedyChild&&this.visible){var s,n,o,a=v(e,this,this.options.tolerance,i),r=!a&&this.isover?"isout":a&&!this.isover?"isover":null;r&&(this.options.greedy&&(n=this.options.scope,o=this.element.parents(":data(ui-droppable)").filter(function(){return t(this).droppable("instance").options.scope===n}),o.length&&(s=t(o[0]).droppable("instance"),s.greedyChild="isover"===r)),s&&"isover"===r&&(s.isover=!1,s.isout=!0,s._out.call(s,i)),this[r]=!0,this["isout"===r?"isover":"isout"]=!1,this["isover"===r?"_over":"_out"].call(this,i),s&&"isout"===r&&(s.isout=!1,s.isover=!0,s._over.call(s,i)))}})},dragStop:function(e,i){e.element.parentsUntil("body").off("scroll.droppable"),e.options.refreshPositions||t.ui.ddmanager.prepareOffsets(e,i)}},t.uiBackCompat!==!1&&t.widget("ui.droppable",t.ui.droppable,{options:{hoverClass:!1,activeClass:!1},_addActiveClass:function(){this._super(),this.options.activeClass&&this.element.addClass(this.options.activeClass)},_removeActiveClass:function(){this._super(),this.options.activeClass&&this.element.removeClass(this.options.activeClass)},_addHoverClass:function(){this._super(),this.options.hoverClass&&this.element.addClass(this.options.hoverClass)},_removeHoverClass:function(){this._super(),this.options.hoverClass&&this.element.removeClass(this.options.hoverClass)}}),t.ui.droppable,t.widget("ui.progressbar",{version:"1.12.1",options:{classes:{"ui-progressbar":"ui-corner-all","ui-progressbar-value":"ui-corner-left","ui-progressbar-complete":"ui-corner-right"},max:100,value:0,change:null,complete:null},min:0,_create:function(){this.oldValue=this.options.value=this._constrainedValue(),this.element.attr({role:"progressbar","aria-valuemin":this.min}),this._addClass("ui-progressbar","ui-widget ui-widget-content"),this.valueDiv=t("<div>").appendTo(this.element),this._addClass(this.valueDiv,"ui-progressbar-value","ui-widget-header"),this._refreshValue()},_destroy:function(){this.element.removeAttr("role aria-valuemin aria-valuemax aria-valuenow"),this.valueDiv.remove()},value:function(t){return void 0===t?this.options.value:(this.options.value=this._constrainedValue(t),this._refreshValue(),void 0)},_constrainedValue:function(t){return void 0===t&&(t=this.options.value),this.indeterminate=t===!1,"number"!=typeof t&&(t=0),this.indeterminate?!1:Math.min(this.options.max,Math.max(this.min,t))},_setOptions:function(t){var e=t.value;delete t.value,this._super(t),this.options.value=this._constrainedValue(e),this._refreshValue()},_setOption:function(t,e){"max"===t&&(e=Math.max(this.min,e)),this._super(t,e)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t),this._toggleClass(null,"ui-state-disabled",!!t)},_percentage:function(){return this.indeterminate?100:100*(this.options.value-this.min)/(this.options.max-this.min)},_refreshValue:function(){var e=this.options.value,i=this._percentage();this.valueDiv.toggle(this.indeterminate||e>this.min).width(i.toFixed(0)+"%"),this._toggleClass(this.valueDiv,"ui-progressbar-complete",null,e===this.options.max)._toggleClass("ui-progressbar-indeterminate",null,this.indeterminate),this.indeterminate?(this.element.removeAttr("aria-valuenow"),this.overlayDiv||(this.overlayDiv=t("<div>").appendTo(this.valueDiv),this._addClass(this.overlayDiv,"ui-progressbar-overlay"))):(this.element.attr({"aria-valuemax":this.options.max,"aria-valuenow":e}),this.overlayDiv&&(this.overlayDiv.remove(),this.overlayDiv=null)),this.oldValue!==e&&(this.oldValue=e,this._trigger("change")),e===this.options.max&&this._trigger("complete")}}),t.widget("ui.selectable",t.ui.mouse,{version:"1.12.1",options:{appendTo:"body",autoRefresh:!0,distance:0,filter:"*",tolerance:"touch",selected:null,selecting:null,start:null,stop:null,unselected:null,unselecting:null},_create:function(){var e=this;this._addClass("ui-selectable"),this.dragged=!1,this.refresh=function(){e.elementPos=t(e.element[0]).offset(),e.selectees=t(e.options.filter,e.element[0]),e._addClass(e.selectees,"ui-selectee"),e.selectees.each(function(){var i=t(this),s=i.offset(),n={left:s.left-e.elementPos.left,top:s.top-e.elementPos.top};t.data(this,"selectable-item",{element:this,$element:i,left:n.left,top:n.top,right:n.left+i.outerWidth(),bottom:n.top+i.outerHeight(),startselected:!1,selected:i.hasClass("ui-selected"),selecting:i.hasClass("ui-selecting"),unselecting:i.hasClass("ui-unselecting")})})},this.refresh(),this._mouseInit(),this.helper=t("<div>"),this._addClass(this.helper,"ui-selectable-helper")},_destroy:function(){this.selectees.removeData("selectable-item"),this._mouseDestroy()},_mouseStart:function(e){var i=this,s=this.options;this.opos=[e.pageX,e.pageY],this.elementPos=t(this.element[0]).offset(),this.options.disabled||(this.selectees=t(s.filter,this.element[0]),this._trigger("start",e),t(s.appendTo).append(this.helper),this.helper.css({left:e.pageX,top:e.pageY,width:0,height:0}),s.autoRefresh&&this.refresh(),this.selectees.filter(".ui-selected").each(function(){var s=t.data(this,"selectable-item");s.startselected=!0,e.metaKey||e.ctrlKey||(i._removeClass(s.$element,"ui-selected"),s.selected=!1,i._addClass(s.$element,"ui-unselecting"),s.unselecting=!0,i._trigger("unselecting",e,{unselecting:s.element}))}),t(e.target).parents().addBack().each(function(){var s,n=t.data(this,"selectable-item");return n?(s=!e.metaKey&&!e.ctrlKey||!n.$element.hasClass("ui-selected"),i._removeClass(n.$element,s?"ui-unselecting":"ui-selected")._addClass(n.$element,s?"ui-selecting":"ui-unselecting"),n.unselecting=!s,n.selecting=s,n.selected=s,s?i._trigger("selecting",e,{selecting:n.element}):i._trigger("unselecting",e,{unselecting:n.element}),!1):void 0}))},_mouseDrag:function(e){if(this.dragged=!0,!this.options.disabled){var i,s=this,n=this.options,o=this.opos[0],a=this.opos[1],r=e.pageX,h=e.pageY;return o>r&&(i=r,r=o,o=i),a>h&&(i=h,h=a,a=i),this.helper.css({left:o,top:a,width:r-o,height:h-a}),this.selectees.each(function(){var i=t.data(this,"selectable-item"),l=!1,c={};i&&i.element!==s.element[0]&&(c.left=i.left+s.elementPos.left,c.right=i.right+s.elementPos.left,c.top=i.top+s.elementPos.top,c.bottom=i.bottom+s.elementPos.top,"touch"===n.tolerance?l=!(c.left>r||o>c.right||c.top>h||a>c.bottom):"fit"===n.tolerance&&(l=c.left>o&&r>c.right&&c.top>a&&h>c.bottom),l?(i.selected&&(s._removeClass(i.$element,"ui-selected"),i.selected=!1),i.unselecting&&(s._removeClass(i.$element,"ui-unselecting"),i.unselecting=!1),i.selecting||(s._addClass(i.$element,"ui-selecting"),i.selecting=!0,s._trigger("selecting",e,{selecting:i.element}))):(i.selecting&&((e.metaKey||e.ctrlKey)&&i.startselected?(s._removeClass(i.$element,"ui-selecting"),i.selecting=!1,s._addClass(i.$element,"ui-selected"),i.selected=!0):(s._removeClass(i.$element,"ui-selecting"),i.selecting=!1,i.startselected&&(s._addClass(i.$element,"ui-unselecting"),i.unselecting=!0),s._trigger("unselecting",e,{unselecting:i.element}))),i.selected&&(e.metaKey||e.ctrlKey||i.startselected||(s._removeClass(i.$element,"ui-selected"),i.selected=!1,s._addClass(i.$element,"ui-unselecting"),i.unselecting=!0,s._trigger("unselecting",e,{unselecting:i.element})))))}),!1}},_mouseStop:function(e){var i=this;return this.dragged=!1,t(".ui-unselecting",this.element[0]).each(function(){var s=t.data(this,"selectable-item");i._removeClass(s.$element,"ui-unselecting"),s.unselecting=!1,s.startselected=!1,i._trigger("unselected",e,{unselected:s.element})}),t(".ui-selecting",this.element[0]).each(function(){var s=t.data(this,"selectable-item");i._removeClass(s.$element,"ui-selecting")._addClass(s.$element,"ui-selected"),s.selecting=!1,s.selected=!0,s.startselected=!0,i._trigger("selected",e,{selected:s.element})}),this._trigger("stop",e),this.helper.remove(),!1}}),t.widget("ui.selectmenu",[t.ui.formResetMixin,{version:"1.12.1",defaultElement:"<select>",options:{appendTo:null,classes:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"},disabled:null,icons:{button:"ui-icon-triangle-1-s"},position:{my:"left top",at:"left bottom",collision:"none"},width:!1,change:null,close:null,focus:null,open:null,select:null},_create:function(){var e=this.element.uniqueId().attr("id");this.ids={element:e,button:e+"-button",menu:e+"-menu"},this._drawButton(),this._drawMenu(),this._bindFormResetHandler(),this._rendered=!1,this.menuItems=t()},_drawButton:function(){var e,i=this,s=this._parseOption(this.element.find("option:selected"),this.element[0].selectedIndex);this.labels=this.element.labels().attr("for",this.ids.button),this._on(this.labels,{click:function(t){this.button.focus(),t.preventDefault()}}),this.element.hide(),this.button=t("<span>",{tabindex:this.options.disabled?-1:0,id:this.ids.button,role:"combobox","aria-expanded":"false","aria-autocomplete":"list","aria-owns":this.ids.menu,"aria-haspopup":"true",title:this.element.attr("title")}).insertAfter(this.element),this._addClass(this.button,"ui-selectmenu-button ui-selectmenu-button-closed","ui-button ui-widget"),e=t("<span>").appendTo(this.button),this._addClass(e,"ui-selectmenu-icon","ui-icon "+this.options.icons.button),this.buttonItem=this._renderButtonItem(s).appendTo(this.button),this.options.width!==!1&&this._resizeButton(),this._on(this.button,this._buttonEvents),this.button.one("focusin",function(){i._rendered||i._refreshMenu()})},_drawMenu:function(){var e=this;this.menu=t("<ul>",{"aria-hidden":"true","aria-labelledby":this.ids.button,id:this.ids.menu}),this.menuWrap=t("<div>").append(this.menu),this._addClass(this.menuWrap,"ui-selectmenu-menu","ui-front"),this.menuWrap.appendTo(this._appendTo()),this.menuInstance=this.menu.menu({classes:{"ui-menu":"ui-corner-bottom"},role:"listbox",select:function(t,i){t.preventDefault(),e._setSelection(),e._select(i.item.data("ui-selectmenu-item"),t)},focus:function(t,i){var s=i.item.data("ui-selectmenu-item");null!=e.focusIndex&&s.index!==e.focusIndex&&(e._trigger("focus",t,{item:s}),e.isOpen||e._select(s,t)),e.focusIndex=s.index,e.button.attr("aria-activedescendant",e.menuItems.eq(s.index).attr("id"))}}).menu("instance"),this.menuInstance._off(this.menu,"mouseleave"),this.menuInstance._closeOnDocumentClick=function(){return!1},this.menuInstance._isDivider=function(){return!1}},refresh:function(){this._refreshMenu(),this.buttonItem.replaceWith(this.buttonItem=this._renderButtonItem(this._getSelectedItem().data("ui-selectmenu-item")||{})),null===this.options.width&&this._resizeButton()},_refreshMenu:function(){var t,e=this.element.find("option");this.menu.empty(),this._parseOptions(e),this._renderMenu(this.menu,this.items),this.menuInstance.refresh(),this.menuItems=this.menu.find("li").not(".ui-selectmenu-optgroup").find(".ui-menu-item-wrapper"),this._rendered=!0,e.length&&(t=this._getSelectedItem(),this.menuInstance.focus(null,t),this._setAria(t.data("ui-selectmenu-item")),this._setOption("disabled",this.element.prop("disabled")))},open:function(t){this.options.disabled||(this._rendered?(this._removeClass(this.menu.find(".ui-state-active"),null,"ui-state-active"),this.menuInstance.focus(null,this._getSelectedItem())):this._refreshMenu(),this.menuItems.length&&(this.isOpen=!0,this._toggleAttr(),this._resizeMenu(),this._position(),this._on(this.document,this._documentClick),this._trigger("open",t)))},_position:function(){this.menuWrap.position(t.extend({of:this.button},this.options.position))},close:function(t){this.isOpen&&(this.isOpen=!1,this._toggleAttr(),this.range=null,this._off(this.document),this._trigger("close",t))},widget:function(){return this.button},menuWidget:function(){return this.menu},_renderButtonItem:function(e){var i=t("<span>");return this._setText(i,e.label),this._addClass(i,"ui-selectmenu-text"),i},_renderMenu:function(e,i){var s=this,n="";t.each(i,function(i,o){var a;o.optgroup!==n&&(a=t("<li>",{text:o.optgroup}),s._addClass(a,"ui-selectmenu-optgroup","ui-menu-divider"+(o.element.parent("optgroup").prop("disabled")?" ui-state-disabled":"")),a.appendTo(e),n=o.optgroup),s._renderItemData(e,o)})},_renderItemData:function(t,e){return this._renderItem(t,e).data("ui-selectmenu-item",e)},_renderItem:function(e,i){var s=t("<li>"),n=t("<div>",{title:i.element.attr("title")});return i.disabled&&this._addClass(s,null,"ui-state-disabled"),this._setText(n,i.label),s.append(n).appendTo(e)},_setText:function(t,e){e?t.text(e):t.html("&#160;")},_move:function(t,e){var i,s,n=".ui-menu-item";this.isOpen?i=this.menuItems.eq(this.focusIndex).parent("li"):(i=this.menuItems.eq(this.element[0].selectedIndex).parent("li"),n+=":not(.ui-state-disabled)"),s="first"===t||"last"===t?i["first"===t?"prevAll":"nextAll"](n).eq(-1):i[t+"All"](n).eq(0),s.length&&this.menuInstance.focus(e,s)},_getSelectedItem:function(){return this.menuItems.eq(this.element[0].selectedIndex).parent("li")},_toggle:function(t){this[this.isOpen?"close":"open"](t)},_setSelection:function(){var t;this.range&&(window.getSelection?(t=window.getSelection(),t.removeAllRanges(),t.addRange(this.range)):this.range.select(),this.button.focus())},_documentClick:{mousedown:function(e){this.isOpen&&(t(e.target).closest(".ui-selectmenu-menu, #"+t.ui.escapeSelector(this.ids.button)).length||this.close(e))}},_buttonEvents:{mousedown:function(){var t;window.getSelection?(t=window.getSelection(),t.rangeCount&&(this.range=t.getRangeAt(0))):this.range=document.selection.createRange()},click:function(t){this._setSelection(),this._toggle(t)},keydown:function(e){var i=!0;switch(e.keyCode){case t.ui.keyCode.TAB:case t.ui.keyCode.ESCAPE:this.close(e),i=!1;break;case t.ui.keyCode.ENTER:this.isOpen&&this._selectFocusedItem(e);break;case t.ui.keyCode.UP:e.altKey?this._toggle(e):this._move("prev",e);break;case t.ui.keyCode.DOWN:e.altKey?this._toggle(e):this._move("next",e);break;case t.ui.keyCode.SPACE:this.isOpen?this._selectFocusedItem(e):this._toggle(e);break;case t.ui.keyCode.LEFT:this._move("prev",e);break;case t.ui.keyCode.RIGHT:this._move("next",e);break;case t.ui.keyCode.HOME:case t.ui.keyCode.PAGE_UP:this._move("first",e);break;case t.ui.keyCode.END:case t.ui.keyCode.PAGE_DOWN:this._move("last",e);break;default:this.menu.trigger(e),i=!1}i&&e.preventDefault()}},_selectFocusedItem:function(t){var e=this.menuItems.eq(this.focusIndex).parent("li");e.hasClass("ui-state-disabled")||this._select(e.data("ui-selectmenu-item"),t)},_select:function(t,e){var i=this.element[0].selectedIndex;this.element[0].selectedIndex=t.index,this.buttonItem.replaceWith(this.buttonItem=this._renderButtonItem(t)),this._setAria(t),this._trigger("select",e,{item:t}),t.index!==i&&this._trigger("change",e,{item:t}),this.close(e)},_setAria:function(t){var e=this.menuItems.eq(t.index).attr("id");this.button.attr({"aria-labelledby":e,"aria-activedescendant":e}),this.menu.attr("aria-activedescendant",e)},_setOption:function(t,e){if("icons"===t){var i=this.button.find("span.ui-icon");this._removeClass(i,null,this.options.icons.button)._addClass(i,null,e.button)}this._super(t,e),"appendTo"===t&&this.menuWrap.appendTo(this._appendTo()),"width"===t&&this._resizeButton()},_setOptionDisabled:function(t){this._super(t),this.menuInstance.option("disabled",t),this.button.attr("aria-disabled",t),this._toggleClass(this.button,null,"ui-state-disabled",t),this.element.prop("disabled",t),t?(this.button.attr("tabindex",-1),this.close()):this.button.attr("tabindex",0)},_appendTo:function(){var e=this.options.appendTo;return e&&(e=e.jquery||e.nodeType?t(e):this.document.find(e).eq(0)),e&&e[0]||(e=this.element.closest(".ui-front, dialog")),e.length||(e=this.document[0].body),e},_toggleAttr:function(){this.button.attr("aria-expanded",this.isOpen),this._removeClass(this.button,"ui-selectmenu-button-"+(this.isOpen?"closed":"open"))._addClass(this.button,"ui-selectmenu-button-"+(this.isOpen?"open":"closed"))._toggleClass(this.menuWrap,"ui-selectmenu-open",null,this.isOpen),this.menu.attr("aria-hidden",!this.isOpen)},_resizeButton:function(){var t=this.options.width;return t===!1?(this.button.css("width",""),void 0):(null===t&&(t=this.element.show().outerWidth(),this.element.hide()),this.button.outerWidth(t),void 0)},_resizeMenu:function(){this.menu.outerWidth(Math.max(this.button.outerWidth(),this.menu.width("").outerWidth()+1))},_getCreateOptions:function(){var t=this._super();return t.disabled=this.element.prop("disabled"),t},_parseOptions:function(e){var i=this,s=[];e.each(function(e,n){s.push(i._parseOption(t(n),e))}),this.items=s},_parseOption:function(t,e){var i=t.parent("optgroup");return{element:t,index:e,value:t.val(),label:t.text(),optgroup:i.attr("label")||"",disabled:i.prop("disabled")||t.prop("disabled")}},_destroy:function(){this._unbindFormResetHandler(),this.menuWrap.remove(),this.button.remove(),this.element.show(),this.element.removeUniqueId(),this.labels.attr("for",this.ids.element)}}]),t.widget("ui.slider",t.ui.mouse,{version:"1.12.1",widgetEventPrefix:"slide",options:{animate:!1,classes:{"ui-slider":"ui-corner-all","ui-slider-handle":"ui-corner-all","ui-slider-range":"ui-corner-all ui-widget-header"},distance:0,max:100,min:0,orientation:"horizontal",range:!1,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},numPages:5,_create:function(){this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this._calculateNewMax(),this._addClass("ui-slider ui-slider-"+this.orientation,"ui-widget ui-widget-content"),this._refresh(),this._animateOff=!1},_refresh:function(){this._createRange(),this._createHandles(),this._setupEvents(),this._refreshValue()},_createHandles:function(){var e,i,s=this.options,n=this.element.find(".ui-slider-handle"),o="<span tabindex='0'></span>",a=[];for(i=s.values&&s.values.length||1,n.length>i&&(n.slice(i).remove(),n=n.slice(0,i)),e=n.length;i>e;e++)a.push(o);this.handles=n.add(t(a.join("")).appendTo(this.element)),this._addClass(this.handles,"ui-slider-handle","ui-state-default"),this.handle=this.handles.eq(0),this.handles.each(function(e){t(this).data("ui-slider-handle-index",e).attr("tabIndex",0)})},_createRange:function(){var e=this.options;e.range?(e.range===!0&&(e.values?e.values.length&&2!==e.values.length?e.values=[e.values[0],e.values[0]]:t.isArray(e.values)&&(e.values=e.values.slice(0)):e.values=[this._valueMin(),this._valueMin()]),this.range&&this.range.length?(this._removeClass(this.range,"ui-slider-range-min ui-slider-range-max"),this.range.css({left:"",bottom:""})):(this.range=t("<div>").appendTo(this.element),this._addClass(this.range,"ui-slider-range")),("min"===e.range||"max"===e.range)&&this._addClass(this.range,"ui-slider-range-"+e.range)):(this.range&&this.range.remove(),this.range=null)},_setupEvents:function(){this._off(this.handles),this._on(this.handles,this._handleEvents),this._hoverable(this.handles),this._focusable(this.handles)},_destroy:function(){this.handles.remove(),this.range&&this.range.remove(),this._mouseDestroy()},_mouseCapture:function(e){var i,s,n,o,a,r,h,l,c=this,u=this.options;return u.disabled?!1:(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),i={x:e.pageX,y:e.pageY},s=this._normValueFromMouse(i),n=this._valueMax()-this._valueMin()+1,this.handles.each(function(e){var i=Math.abs(s-c.values(e));(n>i||n===i&&(e===c._lastChangedValue||c.values(e)===u.min))&&(n=i,o=t(this),a=e)}),r=this._start(e,a),r===!1?!1:(this._mouseSliding=!0,this._handleIndex=a,this._addClass(o,null,"ui-state-active"),o.trigger("focus"),h=o.offset(),l=!t(e.target).parents().addBack().is(".ui-slider-handle"),this._clickOffset=l?{left:0,top:0}:{left:e.pageX-h.left-o.width()/2,top:e.pageY-h.top-o.height()/2-(parseInt(o.css("borderTopWidth"),10)||0)-(parseInt(o.css("borderBottomWidth"),10)||0)+(parseInt(o.css("marginTop"),10)||0)},this.handles.hasClass("ui-state-hover")||this._slide(e,a,s),this._animateOff=!0,!0))},_mouseStart:function(){return!0},_mouseDrag:function(t){var e={x:t.pageX,y:t.pageY},i=this._normValueFromMouse(e);return this._slide(t,this._handleIndex,i),!1},_mouseStop:function(t){return this._removeClass(this.handles,null,"ui-state-active"),this._mouseSliding=!1,this._stop(t,this._handleIndex),this._change(t,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1,!1},_detectOrientation:function(){this.orientation="vertical"===this.options.orientation?"vertical":"horizontal"},_normValueFromMouse:function(t){var e,i,s,n,o;return"horizontal"===this.orientation?(e=this.elementSize.width,i=t.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(e=this.elementSize.height,i=t.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),s=i/e,s>1&&(s=1),0>s&&(s=0),"vertical"===this.orientation&&(s=1-s),n=this._valueMax()-this._valueMin(),o=this._valueMin()+s*n,this._trimAlignValue(o)},_uiHash:function(t,e,i){var s={handle:this.handles[t],handleIndex:t,value:void 0!==e?e:this.value()};return this._hasMultipleValues()&&(s.value=void 0!==e?e:this.values(t),s.values=i||this.values()),s},_hasMultipleValues:function(){return this.options.values&&this.options.values.length},_start:function(t,e){return this._trigger("start",t,this._uiHash(e))},_slide:function(t,e,i){var s,n,o=this.value(),a=this.values();this._hasMultipleValues()&&(n=this.values(e?0:1),o=this.values(e),2===this.options.values.length&&this.options.range===!0&&(i=0===e?Math.min(n,i):Math.max(n,i)),a[e]=i),i!==o&&(s=this._trigger("slide",t,this._uiHash(e,i,a)),s!==!1&&(this._hasMultipleValues()?this.values(e,i):this.value(i)))},_stop:function(t,e){this._trigger("stop",t,this._uiHash(e))},_change:function(t,e){this._keySliding||this._mouseSliding||(this._lastChangedValue=e,this._trigger("change",t,this._uiHash(e)))},value:function(t){return arguments.length?(this.options.value=this._trimAlignValue(t),this._refreshValue(),this._change(null,0),void 0):this._value()},values:function(e,i){var s,n,o;if(arguments.length>1)return this.options.values[e]=this._trimAlignValue(i),this._refreshValue(),this._change(null,e),void 0;if(!arguments.length)return this._values();if(!t.isArray(arguments[0]))return this._hasMultipleValues()?this._values(e):this.value();for(s=this.options.values,n=arguments[0],o=0;s.length>o;o+=1)s[o]=this._trimAlignValue(n[o]),this._change(null,o);this._refreshValue()},_setOption:function(e,i){var s,n=0;switch("range"===e&&this.options.range===!0&&("min"===i?(this.options.value=this._values(0),this.options.values=null):"max"===i&&(this.options.value=this._values(this.options.values.length-1),this.options.values=null)),t.isArray(this.options.values)&&(n=this.options.values.length),this._super(e,i),e){case"orientation":this._detectOrientation(),this._removeClass("ui-slider-horizontal ui-slider-vertical")._addClass("ui-slider-"+this.orientation),this._refreshValue(),this.options.range&&this._refreshRange(i),this.handles.css("horizontal"===i?"bottom":"left","");break;case"value":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case"values":for(this._animateOff=!0,this._refreshValue(),s=n-1;s>=0;s--)this._change(null,s);this._animateOff=!1;break;case"step":case"min":case"max":this._animateOff=!0,this._calculateNewMax(),this._refreshValue(),this._animateOff=!1;break;case"range":this._animateOff=!0,this._refresh(),this._animateOff=!1}},_setOptionDisabled:function(t){this._super(t),this._toggleClass(null,"ui-state-disabled",!!t)},_value:function(){var t=this.options.value;return t=this._trimAlignValue(t)},_values:function(t){var e,i,s;if(arguments.length)return e=this.options.values[t],e=this._trimAlignValue(e);if(this._hasMultipleValues()){for(i=this.options.values.slice(),s=0;i.length>s;s+=1)i[s]=this._trimAlignValue(i[s]);return i}return[]},_trimAlignValue:function(t){if(this._valueMin()>=t)return this._valueMin();if(t>=this._valueMax())return this._valueMax();var e=this.options.step>0?this.options.step:1,i=(t-this._valueMin())%e,s=t-i;return 2*Math.abs(i)>=e&&(s+=i>0?e:-e),parseFloat(s.toFixed(5))},_calculateNewMax:function(){var t=this.options.max,e=this._valueMin(),i=this.options.step,s=Math.round((t-e)/i)*i;t=s+e,t>this.options.max&&(t-=i),this.max=parseFloat(t.toFixed(this._precision()))},_precision:function(){var t=this._precisionOf(this.options.step);return null!==this.options.min&&(t=Math.max(t,this._precisionOf(this.options.min))),t},_precisionOf:function(t){var e=""+t,i=e.indexOf(".");return-1===i?0:e.length-i-1},_valueMin:function(){return this.options.min},_valueMax:function(){return this.max},_refreshRange:function(t){"vertical"===t&&this.range.css({width:"",left:""}),"horizontal"===t&&this.range.css({height:"",bottom:""})},_refreshValue:function(){var e,i,s,n,o,a=this.options.range,r=this.options,h=this,l=this._animateOff?!1:r.animate,c={};this._hasMultipleValues()?this.handles.each(function(s){i=100*((h.values(s)-h._valueMin())/(h._valueMax()-h._valueMin())),c["horizontal"===h.orientation?"left":"bottom"]=i+"%",t(this).stop(1,1)[l?"animate":"css"](c,r.animate),h.options.range===!0&&("horizontal"===h.orientation?(0===s&&h.range.stop(1,1)[l?"animate":"css"]({left:i+"%"},r.animate),1===s&&h.range[l?"animate":"css"]({width:i-e+"%"},{queue:!1,duration:r.animate})):(0===s&&h.range.stop(1,1)[l?"animate":"css"]({bottom:i+"%"},r.animate),1===s&&h.range[l?"animate":"css"]({height:i-e+"%"},{queue:!1,duration:r.animate}))),e=i}):(s=this.value(),n=this._valueMin(),o=this._valueMax(),i=o!==n?100*((s-n)/(o-n)):0,c["horizontal"===this.orientation?"left":"bottom"]=i+"%",this.handle.stop(1,1)[l?"animate":"css"](c,r.animate),"min"===a&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:i+"%"},r.animate),"max"===a&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:100-i+"%"},r.animate),"min"===a&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:i+"%"},r.animate),"max"===a&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:100-i+"%"},r.animate))},_handleEvents:{keydown:function(e){var i,s,n,o,a=t(e.target).data("ui-slider-handle-index");switch(e.keyCode){case t.ui.keyCode.HOME:case t.ui.keyCode.END:case t.ui.keyCode.PAGE_UP:case t.ui.keyCode.PAGE_DOWN:case t.ui.keyCode.UP:case t.ui.keyCode.RIGHT:case t.ui.keyCode.DOWN:case t.ui.keyCode.LEFT:if(e.preventDefault(),!this._keySliding&&(this._keySliding=!0,this._addClass(t(e.target),null,"ui-state-active"),i=this._start(e,a),i===!1))return}switch(o=this.options.step,s=n=this._hasMultipleValues()?this.values(a):this.value(),e.keyCode){case t.ui.keyCode.HOME:n=this._valueMin();break;case t.ui.keyCode.END:n=this._valueMax();break;case t.ui.keyCode.PAGE_UP:n=this._trimAlignValue(s+(this._valueMax()-this._valueMin())/this.numPages);break;case t.ui.keyCode.PAGE_DOWN:n=this._trimAlignValue(s-(this._valueMax()-this._valueMin())/this.numPages);break;case t.ui.keyCode.UP:case t.ui.keyCode.RIGHT:if(s===this._valueMax())return;n=this._trimAlignValue(s+o);break;case t.ui.keyCode.DOWN:case t.ui.keyCode.LEFT:if(s===this._valueMin())return;n=this._trimAlignValue(s-o)}this._slide(e,a,n)},keyup:function(e){var i=t(e.target).data("ui-slider-handle-index");this._keySliding&&(this._keySliding=!1,this._stop(e,i),this._change(e,i),this._removeClass(t(e.target),null,"ui-state-active"))}}}),t.widget("ui.sortable",t.ui.mouse,{version:"1.12.1",widgetEventPrefix:"sort",ready:!1,options:{appendTo:"parent",axis:!1,connectWith:!1,containment:!1,cursor:"auto",cursorAt:!1,dropOnEmpty:!0,forcePlaceholderSize:!1,forceHelperSize:!1,grid:!1,handle:!1,helper:"original",items:"> *",opacity:!1,placeholder:!1,revert:!1,scroll:!0,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1e3,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_isOverAxis:function(t,e,i){return t>=e&&e+i>t},_isFloating:function(t){return/left|right/.test(t.css("float"))||/inline|table-cell/.test(t.css("display"))},_create:function(){this.containerCache={},this._addClass("ui-sortable"),this.refresh(),this.offset=this.element.offset(),this._mouseInit(),this._setHandleClassName(),this.ready=!0},_setOption:function(t,e){this._super(t,e),"handle"===t&&this._setHandleClassName()},_setHandleClassName:function(){var e=this;this._removeClass(this.element.find(".ui-sortable-handle"),"ui-sortable-handle"),t.each(this.items,function(){e._addClass(this.instance.options.handle?this.item.find(this.instance.options.handle):this.item,"ui-sortable-handle")})},_destroy:function(){this._mouseDestroy();for(var t=this.items.length-1;t>=0;t--)this.items[t].item.removeData(this.widgetName+"-item");return this},_mouseCapture:function(e,i){var s=null,n=!1,o=this;return this.reverting?!1:this.options.disabled||"static"===this.options.type?!1:(this._refreshItems(e),t(e.target).parents().each(function(){return t.data(this,o.widgetName+"-item")===o?(s=t(this),!1):void 0}),t.data(e.target,o.widgetName+"-item")===o&&(s=t(e.target)),s?!this.options.handle||i||(t(this.options.handle,s).find("*").addBack().each(function(){this===e.target&&(n=!0)}),n)?(this.currentItem=s,this._removeCurrentsFromItems(),!0):!1:!1)},_mouseStart:function(e,i,s){var n,o,a=this.options;if(this.currentContainer=this,this.refreshPositions(),this.helper=this._createHelper(e),this._cacheHelperProportions(),this._cacheMargins(),this.scrollParent=this.helper.scrollParent(),this.offset=this.currentItem.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.helper.css("position","absolute"),this.cssPosition=this.helper.css("position"),this.originalPosition=this._generatePosition(e),this.originalPageX=e.pageX,this.originalPageY=e.pageY,a.cursorAt&&this._adjustOffsetFromHelper(a.cursorAt),this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]},this.helper[0]!==this.currentItem[0]&&this.currentItem.hide(),this._createPlaceholder(),a.containment&&this._setContainment(),a.cursor&&"auto"!==a.cursor&&(o=this.document.find("body"),this.storedCursor=o.css("cursor"),o.css("cursor",a.cursor),this.storedStylesheet=t("<style>*{ cursor: "+a.cursor+" !important; }</style>").appendTo(o)),a.opacity&&(this.helper.css("opacity")&&(this._storedOpacity=this.helper.css("opacity")),this.helper.css("opacity",a.opacity)),a.zIndex&&(this.helper.css("zIndex")&&(this._storedZIndex=this.helper.css("zIndex")),this.helper.css("zIndex",a.zIndex)),this.scrollParent[0]!==this.document[0]&&"HTML"!==this.scrollParent[0].tagName&&(this.overflowOffset=this.scrollParent.offset()),this._trigger("start",e,this._uiHash()),this._preserveHelperProportions||this._cacheHelperProportions(),!s)for(n=this.containers.length-1;n>=0;n--)this.containers[n]._trigger("activate",e,this._uiHash(this));return t.ui.ddmanager&&(t.ui.ddmanager.current=this),t.ui.ddmanager&&!a.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this.dragging=!0,this._addClass(this.helper,"ui-sortable-helper"),this._mouseDrag(e),!0},_mouseDrag:function(e){var i,s,n,o,a=this.options,r=!1;for(this.position=this._generatePosition(e),this.positionAbs=this._convertPositionTo("absolute"),this.lastPositionAbs||(this.lastPositionAbs=this.positionAbs),this.options.scroll&&(this.scrollParent[0]!==this.document[0]&&"HTML"!==this.scrollParent[0].tagName?(this.overflowOffset.top+this.scrollParent[0].offsetHeight-e.pageY<a.scrollSensitivity?this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop+a.scrollSpeed:e.pageY-this.overflowOffset.top<a.scrollSensitivity&&(this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop-a.scrollSpeed),this.overflowOffset.left+this.scrollParent[0].offsetWidth-e.pageX<a.scrollSensitivity?this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft+a.scrollSpeed:e.pageX-this.overflowOffset.left<a.scrollSensitivity&&(this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft-a.scrollSpeed)):(e.pageY-this.document.scrollTop()<a.scrollSensitivity?r=this.document.scrollTop(this.document.scrollTop()-a.scrollSpeed):this.window.height()-(e.pageY-this.document.scrollTop())<a.scrollSensitivity&&(r=this.document.scrollTop(this.document.scrollTop()+a.scrollSpeed)),e.pageX-this.document.scrollLeft()<a.scrollSensitivity?r=this.document.scrollLeft(this.document.scrollLeft()-a.scrollSpeed):this.window.width()-(e.pageX-this.document.scrollLeft())<a.scrollSensitivity&&(r=this.document.scrollLeft(this.document.scrollLeft()+a.scrollSpeed))),r!==!1&&t.ui.ddmanager&&!a.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e)),this.positionAbs=this._convertPositionTo("absolute"),this.options.axis&&"y"===this.options.axis||(this.helper[0].style.left=this.position.left+"px"),this.options.axis&&"x"===this.options.axis||(this.helper[0].style.top=this.position.top+"px"),i=this.items.length-1;i>=0;i--)if(s=this.items[i],n=s.item[0],o=this._intersectsWithPointer(s),o&&s.instance===this.currentContainer&&n!==this.currentItem[0]&&this.placeholder[1===o?"next":"prev"]()[0]!==n&&!t.contains(this.placeholder[0],n)&&("semi-dynamic"===this.options.type?!t.contains(this.element[0],n):!0)){if(this.direction=1===o?"down":"up","pointer"!==this.options.tolerance&&!this._intersectsWithSides(s))break;this._rearrange(e,s),this._trigger("change",e,this._uiHash());break}return this._contactContainers(e),t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),this._trigger("sort",e,this._uiHash()),this.lastPositionAbs=this.positionAbs,!1},_mouseStop:function(e,i){if(e){if(t.ui.ddmanager&&!this.options.dropBehaviour&&t.ui.ddmanager.drop(this,e),this.options.revert){var s=this,n=this.placeholder.offset(),o=this.options.axis,a={};o&&"x"!==o||(a.left=n.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===this.document[0].body?0:this.offsetParent[0].scrollLeft)),o&&"y"!==o||(a.top=n.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===this.document[0].body?0:this.offsetParent[0].scrollTop)),this.reverting=!0,t(this.helper).animate(a,parseInt(this.options.revert,10)||500,function(){s._clear(e)})}else this._clear(e,i);return!1}},cancel:function(){if(this.dragging){this._mouseUp(new t.Event("mouseup",{target:null})),"original"===this.options.helper?(this.currentItem.css(this._storedCSS),this._removeClass(this.currentItem,"ui-sortable-helper")):this.currentItem.show();for(var e=this.containers.length-1;e>=0;e--)this.containers[e]._trigger("deactivate",null,this._uiHash(this)),this.containers[e].containerCache.over&&(this.containers[e]._trigger("out",null,this._uiHash(this)),this.containers[e].containerCache.over=0)}return this.placeholder&&(this.placeholder[0].parentNode&&this.placeholder[0].parentNode.removeChild(this.placeholder[0]),"original"!==this.options.helper&&this.helper&&this.helper[0].parentNode&&this.helper.remove(),t.extend(this,{helper:null,dragging:!1,reverting:!1,_noFinalSort:null}),this.domPosition.prev?t(this.domPosition.prev).after(this.currentItem):t(this.domPosition.parent).prepend(this.currentItem)),this},serialize:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];return e=e||{},t(i).each(function(){var i=(t(e.item||this).attr(e.attribute||"id")||"").match(e.expression||/(.+)[\-=_](.+)/);i&&s.push((e.key||i[1]+"[]")+"="+(e.key&&e.expression?i[1]:i[2]))}),!s.length&&e.key&&s.push(e.key+"="),s.join("&")},toArray:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];return e=e||{},i.each(function(){s.push(t(e.item||this).attr(e.attribute||"id")||"")}),s},_intersectsWith:function(t){var e=this.positionAbs.left,i=e+this.helperProportions.width,s=this.positionAbs.top,n=s+this.helperProportions.height,o=t.left,a=o+t.width,r=t.top,h=r+t.height,l=this.offset.click.top,c=this.offset.click.left,u="x"===this.options.axis||s+l>r&&h>s+l,d="y"===this.options.axis||e+c>o&&a>e+c,p=u&&d;return"pointer"===this.options.tolerance||this.options.forcePointerForContainers||"pointer"!==this.options.tolerance&&this.helperProportions[this.floating?"width":"height"]>t[this.floating?"width":"height"]?p:e+this.helperProportions.width/2>o&&a>i-this.helperProportions.width/2&&s+this.helperProportions.height/2>r&&h>n-this.helperProportions.height/2},_intersectsWithPointer:function(t){var e,i,s="x"===this.options.axis||this._isOverAxis(this.positionAbs.top+this.offset.click.top,t.top,t.height),n="y"===this.options.axis||this._isOverAxis(this.positionAbs.left+this.offset.click.left,t.left,t.width),o=s&&n;return o?(e=this._getDragVerticalDirection(),i=this._getDragHorizontalDirection(),this.floating?"right"===i||"down"===e?2:1:e&&("down"===e?2:1)):!1},_intersectsWithSides:function(t){var e=this._isOverAxis(this.positionAbs.top+this.offset.click.top,t.top+t.height/2,t.height),i=this._isOverAxis(this.positionAbs.left+this.offset.click.left,t.left+t.width/2,t.width),s=this._getDragVerticalDirection(),n=this._getDragHorizontalDirection();return this.floating&&n?"right"===n&&i||"left"===n&&!i:s&&("down"===s&&e||"up"===s&&!e)},_getDragVerticalDirection:function(){var t=this.positionAbs.top-this.lastPositionAbs.top;return 0!==t&&(t>0?"down":"up")},_getDragHorizontalDirection:function(){var t=this.positionAbs.left-this.lastPositionAbs.left;return 0!==t&&(t>0?"right":"left")},refresh:function(t){return this._refreshItems(t),this._setHandleClassName(),this.refreshPositions(),this},_connectWith:function(){var t=this.options;return t.connectWith.constructor===String?[t.connectWith]:t.connectWith},_getItemsAsjQuery:function(e){function i(){r.push(this)}var s,n,o,a,r=[],h=[],l=this._connectWith();if(l&&e)for(s=l.length-1;s>=0;s--)for(o=t(l[s],this.document[0]),n=o.length-1;n>=0;n--)a=t.data(o[n],this.widgetFullName),a&&a!==this&&!a.options.disabled&&h.push([t.isFunction(a.options.items)?a.options.items.call(a.element):t(a.options.items,a.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),a]);for(h.push([t.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):t(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]),s=h.length-1;s>=0;s--)h[s][0].each(i);return t(r)},_removeCurrentsFromItems:function(){var e=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=t.grep(this.items,function(t){for(var i=0;e.length>i;i++)if(e[i]===t.item[0])return!1;return!0})},_refreshItems:function(e){this.items=[],this.containers=[this];var i,s,n,o,a,r,h,l,c=this.items,u=[[t.isFunction(this.options.items)?this.options.items.call(this.element[0],e,{item:this.currentItem}):t(this.options.items,this.element),this]],d=this._connectWith();if(d&&this.ready)for(i=d.length-1;i>=0;i--)for(n=t(d[i],this.document[0]),s=n.length-1;s>=0;s--)o=t.data(n[s],this.widgetFullName),o&&o!==this&&!o.options.disabled&&(u.push([t.isFunction(o.options.items)?o.options.items.call(o.element[0],e,{item:this.currentItem}):t(o.options.items,o.element),o]),this.containers.push(o));for(i=u.length-1;i>=0;i--)for(a=u[i][1],r=u[i][0],s=0,l=r.length;l>s;s++)h=t(r[s]),h.data(this.widgetName+"-item",a),c.push({item:h,instance:a,width:0,height:0,left:0,top:0})},refreshPositions:function(e){this.floating=this.items.length?"x"===this.options.axis||this._isFloating(this.items[0].item):!1,this.offsetParent&&this.helper&&(this.offset.parent=this._getParentOffset());var i,s,n,o;for(i=this.items.length-1;i>=0;i--)s=this.items[i],s.instance!==this.currentContainer&&this.currentContainer&&s.item[0]!==this.currentItem[0]||(n=this.options.toleranceElement?t(this.options.toleranceElement,s.item):s.item,e||(s.width=n.outerWidth(),s.height=n.outerHeight()),o=n.offset(),s.left=o.left,s.top=o.top);if(this.options.custom&&this.options.custom.refreshContainers)this.options.custom.refreshContainers.call(this);else for(i=this.containers.length-1;i>=0;i--)o=this.containers[i].element.offset(),this.containers[i].containerCache.left=o.left,this.containers[i].containerCache.top=o.top,this.containers[i].containerCache.width=this.containers[i].element.outerWidth(),this.containers[i].containerCache.height=this.containers[i].element.outerHeight();return this},_createPlaceholder:function(e){e=e||this;var i,s=e.options;s.placeholder&&s.placeholder.constructor!==String||(i=s.placeholder,s.placeholder={element:function(){var s=e.currentItem[0].nodeName.toLowerCase(),n=t("<"+s+">",e.document[0]);return e._addClass(n,"ui-sortable-placeholder",i||e.currentItem[0].className)._removeClass(n,"ui-sortable-helper"),"tbody"===s?e._createTrPlaceholder(e.currentItem.find("tr").eq(0),t("<tr>",e.document[0]).appendTo(n)):"tr"===s?e._createTrPlaceholder(e.currentItem,n):"img"===s&&n.attr("src",e.currentItem.attr("src")),i||n.css("visibility","hidden"),n},update:function(t,n){(!i||s.forcePlaceholderSize)&&(n.height()||n.height(e.currentItem.innerHeight()-parseInt(e.currentItem.css("paddingTop")||0,10)-parseInt(e.currentItem.css("paddingBottom")||0,10)),n.width()||n.width(e.currentItem.innerWidth()-parseInt(e.currentItem.css("paddingLeft")||0,10)-parseInt(e.currentItem.css("paddingRight")||0,10)))}}),e.placeholder=t(s.placeholder.element.call(e.element,e.currentItem)),e.currentItem.after(e.placeholder),s.placeholder.update(e,e.placeholder)},_createTrPlaceholder:function(e,i){var s=this;e.children().each(function(){t("<td>&#160;</td>",s.document[0]).attr("colspan",t(this).attr("colspan")||1).appendTo(i)})},_contactContainers:function(e){var i,s,n,o,a,r,h,l,c,u,d=null,p=null;for(i=this.containers.length-1;i>=0;i--)if(!t.contains(this.currentItem[0],this.containers[i].element[0]))if(this._intersectsWith(this.containers[i].containerCache)){if(d&&t.contains(this.containers[i].element[0],d.element[0]))continue;d=this.containers[i],p=i}else this.containers[i].containerCache.over&&(this.containers[i]._trigger("out",e,this._uiHash(this)),this.containers[i].containerCache.over=0);if(d)if(1===this.containers.length)this.containers[p].containerCache.over||(this.containers[p]._trigger("over",e,this._uiHash(this)),this.containers[p].containerCache.over=1);else{for(n=1e4,o=null,c=d.floating||this._isFloating(this.currentItem),a=c?"left":"top",r=c?"width":"height",u=c?"pageX":"pageY",s=this.items.length-1;s>=0;s--)t.contains(this.containers[p].element[0],this.items[s].item[0])&&this.items[s].item[0]!==this.currentItem[0]&&(h=this.items[s].item.offset()[a],l=!1,e[u]-h>this.items[s][r]/2&&(l=!0),n>Math.abs(e[u]-h)&&(n=Math.abs(e[u]-h),o=this.items[s],this.direction=l?"up":"down"));if(!o&&!this.options.dropOnEmpty)return;if(this.currentContainer===this.containers[p])return this.currentContainer.containerCache.over||(this.containers[p]._trigger("over",e,this._uiHash()),this.currentContainer.containerCache.over=1),void 0;o?this._rearrange(e,o,null,!0):this._rearrange(e,null,this.containers[p].element,!0),this._trigger("change",e,this._uiHash()),this.containers[p]._trigger("change",e,this._uiHash(this)),this.currentContainer=this.containers[p],this.options.placeholder.update(this.currentContainer,this.placeholder),this.containers[p]._trigger("over",e,this._uiHash(this)),this.containers[p].containerCache.over=1}},_createHelper:function(e){var i=this.options,s=t.isFunction(i.helper)?t(i.helper.apply(this.element[0],[e,this.currentItem])):"clone"===i.helper?this.currentItem.clone():this.currentItem;return s.parents("body").length||t("parent"!==i.appendTo?i.appendTo:this.currentItem[0].parentNode)[0].appendChild(s[0]),s[0]===this.currentItem[0]&&(this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}),(!s[0].style.width||i.forceHelperSize)&&s.width(this.currentItem.width()),(!s[0].style.height||i.forceHelperSize)&&s.height(this.currentItem.height()),s},_adjustOffsetFromHelper:function(e){"string"==typeof e&&(e=e.split(" ")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),"left"in e&&(this.offset.click.left=e.left+this.margins.left),"right"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),"top"in e&&(this.offset.click.top=e.top+this.margins.top),"bottom"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var e=this.offsetParent.offset();return"absolute"===this.cssPosition&&this.scrollParent[0]!==this.document[0]&&t.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]===this.document[0].body||this.offsetParent[0].tagName&&"html"===this.offsetParent[0].tagName.toLowerCase()&&t.ui.ie)&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"===this.cssPosition){var t=this.currentItem.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css("marginLeft"),10)||0,top:parseInt(this.currentItem.css("marginTop"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,n=this.options;"parent"===n.containment&&(n.containment=this.helper[0].parentNode),("document"===n.containment||"window"===n.containment)&&(this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,"document"===n.containment?this.document.width():this.window.width()-this.helperProportions.width-this.margins.left,("document"===n.containment?this.document.height()||document.body.parentNode.scrollHeight:this.window.height()||this.document[0].body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(n.containment)||(e=t(n.containment)[0],i=t(n.containment).offset(),s="hidden"!==t(e).css("overflow"),this.containment=[i.left+(parseInt(t(e).css("borderLeftWidth"),10)||0)+(parseInt(t(e).css("paddingLeft"),10)||0)-this.margins.left,i.top+(parseInt(t(e).css("borderTopWidth"),10)||0)+(parseInt(t(e).css("paddingTop"),10)||0)-this.margins.top,i.left+(s?Math.max(e.scrollWidth,e.offsetWidth):e.offsetWidth)-(parseInt(t(e).css("borderLeftWidth"),10)||0)-(parseInt(t(e).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,i.top+(s?Math.max(e.scrollHeight,e.offsetHeight):e.offsetHeight)-(parseInt(t(e).css("borderTopWidth"),10)||0)-(parseInt(t(e).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top])},_convertPositionTo:function(e,i){i||(i=this.position);var s="absolute"===e?1:-1,n="absolute"!==this.cssPosition||this.scrollParent[0]!==this.document[0]&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,o=/(html|body)/i.test(n[0].tagName);return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-("fixed"===this.cssPosition?-this.scrollParent.scrollTop():o?0:n.scrollTop())*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():o?0:n.scrollLeft())*s}},_generatePosition:function(e){var i,s,n=this.options,o=e.pageX,a=e.pageY,r="absolute"!==this.cssPosition||this.scrollParent[0]!==this.document[0]&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,h=/(html|body)/i.test(r[0].tagName);return"relative"!==this.cssPosition||this.scrollParent[0]!==this.document[0]&&this.scrollParent[0]!==this.offsetParent[0]||(this.offset.relative=this._getRelativeOffset()),this.originalPosition&&(this.containment&&(e.pageX-this.offset.click.left<this.containment[0]&&(o=this.containment[0]+this.offset.click.left),e.pageY-this.offset.click.top<this.containment[1]&&(a=this.containment[1]+this.offset.click.top),e.pageX-this.offset.click.left>this.containment[2]&&(o=this.containment[2]+this.offset.click.left),e.pageY-this.offset.click.top>this.containment[3]&&(a=this.containment[3]+this.offset.click.top)),n.grid&&(i=this.originalPageY+Math.round((a-this.originalPageY)/n.grid[1])*n.grid[1],a=this.containment?i-this.offset.click.top>=this.containment[1]&&i-this.offset.click.top<=this.containment[3]?i:i-this.offset.click.top>=this.containment[1]?i-n.grid[1]:i+n.grid[1]:i,s=this.originalPageX+Math.round((o-this.originalPageX)/n.grid[0])*n.grid[0],o=this.containment?s-this.offset.click.left>=this.containment[0]&&s-this.offset.click.left<=this.containment[2]?s:s-this.offset.click.left>=this.containment[0]?s-n.grid[0]:s+n.grid[0]:s)),{top:a-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.scrollParent.scrollTop():h?0:r.scrollTop()),left:o-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():h?0:r.scrollLeft())}},_rearrange:function(t,e,i,s){i?i[0].appendChild(this.placeholder[0]):e.item[0].parentNode.insertBefore(this.placeholder[0],"down"===this.direction?e.item[0]:e.item[0].nextSibling),this.counter=this.counter?++this.counter:1;var n=this.counter;this._delay(function(){n===this.counter&&this.refreshPositions(!s)})},_clear:function(t,e){function i(t,e,i){return function(s){i._trigger(t,s,e._uiHash(e))}}this.reverting=!1;var s,n=[];if(!this._noFinalSort&&this.currentItem.parent().length&&this.placeholder.before(this.currentItem),this._noFinalSort=null,this.helper[0]===this.currentItem[0]){for(s in this._storedCSS)("auto"===this._storedCSS[s]||"static"===this._storedCSS[s])&&(this._storedCSS[s]="");this.currentItem.css(this._storedCSS),this._removeClass(this.currentItem,"ui-sortable-helper")}else this.currentItem.show();for(this.fromOutside&&!e&&n.push(function(t){this._trigger("receive",t,this._uiHash(this.fromOutside))}),!this.fromOutside&&this.domPosition.prev===this.currentItem.prev().not(".ui-sortable-helper")[0]&&this.domPosition.parent===this.currentItem.parent()[0]||e||n.push(function(t){this._trigger("update",t,this._uiHash())}),this!==this.currentContainer&&(e||(n.push(function(t){this._trigger("remove",t,this._uiHash())}),n.push(function(t){return function(e){t._trigger("receive",e,this._uiHash(this))}}.call(this,this.currentContainer)),n.push(function(t){return function(e){t._trigger("update",e,this._uiHash(this))}}.call(this,this.currentContainer)))),s=this.containers.length-1;s>=0;s--)e||n.push(i("deactivate",this,this.containers[s])),this.containers[s].containerCache.over&&(n.push(i("out",this,this.containers[s])),this.containers[s].containerCache.over=0);if(this.storedCursor&&(this.document.find("body").css("cursor",this.storedCursor),this.storedStylesheet.remove()),this._storedOpacity&&this.helper.css("opacity",this._storedOpacity),this._storedZIndex&&this.helper.css("zIndex","auto"===this._storedZIndex?"":this._storedZIndex),this.dragging=!1,e||this._trigger("beforeStop",t,this._uiHash()),this.placeholder[0].parentNode.removeChild(this.placeholder[0]),this.cancelHelperRemoval||(this.helper[0]!==this.currentItem[0]&&this.helper.remove(),this.helper=null),!e){for(s=0;n.length>s;s++)n[s].call(this,t);this._trigger("stop",t,this._uiHash())}return this.fromOutside=!1,!this.cancelHelperRemoval},_trigger:function(){t.Widget.prototype._trigger.apply(this,arguments)===!1&&this.cancel()},_uiHash:function(e){var i=e||this;return{helper:i.helper,placeholder:i.placeholder||t([]),position:i.position,originalPosition:i.originalPosition,offset:i.positionAbs,item:i.currentItem,sender:e?e.element:null}}}),t.widget("ui.spinner",{version:"1.12.1",defaultElement:"<input>",widgetEventPrefix:"spin",options:{classes:{"ui-spinner":"ui-corner-all","ui-spinner-down":"ui-corner-br","ui-spinner-up":"ui-corner-tr"},culture:null,icons:{down:"ui-icon-triangle-1-s",up:"ui-icon-triangle-1-n"},incremental:!0,max:null,min:null,numberFormat:null,page:10,step:1,change:null,spin:null,start:null,stop:null},_create:function(){this._setOption("max",this.options.max),this._setOption("min",this.options.min),this._setOption("step",this.options.step),""!==this.value()&&this._value(this.element.val(),!0),this._draw(),this._on(this._events),this._refresh(),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_getCreateOptions:function(){var e=this._super(),i=this.element;return t.each(["min","max","step"],function(t,s){var n=i.attr(s);null!=n&&n.length&&(e[s]=n)}),e},_events:{keydown:function(t){this._start(t)&&this._keydown(t)&&t.preventDefault()},keyup:"_stop",focus:function(){this.previous=this.element.val()},blur:function(t){return this.cancelBlur?(delete this.cancelBlur,void 0):(this._stop(),this._refresh(),this.previous!==this.element.val()&&this._trigger("change",t),void 0)},mousewheel:function(t,e){if(e){if(!this.spinning&&!this._start(t))return!1;this._spin((e>0?1:-1)*this.options.step,t),clearTimeout(this.mousewheelTimer),this.mousewheelTimer=this._delay(function(){this.spinning&&this._stop(t)},100),t.preventDefault()}},"mousedown .ui-spinner-button":function(e){function i(){var e=this.element[0]===t.ui.safeActiveElement(this.document[0]);e||(this.element.trigger("focus"),this.previous=s,this._delay(function(){this.previous=s}))}var s;s=this.element[0]===t.ui.safeActiveElement(this.document[0])?this.previous:this.element.val(),e.preventDefault(),i.call(this),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur,i.call(this)}),this._start(e)!==!1&&this._repeat(null,t(e.currentTarget).hasClass("ui-spinner-up")?1:-1,e)},"mouseup .ui-spinner-button":"_stop","mouseenter .ui-spinner-button":function(e){return t(e.currentTarget).hasClass("ui-state-active")?this._start(e)===!1?!1:(this._repeat(null,t(e.currentTarget).hasClass("ui-spinner-up")?1:-1,e),void 0):void 0},"mouseleave .ui-spinner-button":"_stop"},_enhance:function(){this.uiSpinner=this.element.attr("autocomplete","off").wrap("<span>").parent().append("<a></a><a></a>")},_draw:function(){this._enhance(),this._addClass(this.uiSpinner,"ui-spinner","ui-widget ui-widget-content"),this._addClass("ui-spinner-input"),this.element.attr("role","spinbutton"),this.buttons=this.uiSpinner.children("a").attr("tabIndex",-1).attr("aria-hidden",!0).button({classes:{"ui-button":""}}),this._removeClass(this.buttons,"ui-corner-all"),this._addClass(this.buttons.first(),"ui-spinner-button ui-spinner-up"),this._addClass(this.buttons.last(),"ui-spinner-button ui-spinner-down"),this.buttons.first().button({icon:this.options.icons.up,showLabel:!1}),this.buttons.last().button({icon:this.options.icons.down,showLabel:!1}),this.buttons.height()>Math.ceil(.5*this.uiSpinner.height())&&this.uiSpinner.height()>0&&this.uiSpinner.height(this.uiSpinner.height())},_keydown:function(e){var i=this.options,s=t.ui.keyCode;switch(e.keyCode){case s.UP:return this._repeat(null,1,e),!0;case s.DOWN:return this._repeat(null,-1,e),!0;case s.PAGE_UP:return this._repeat(null,i.page,e),!0;case s.PAGE_DOWN:return this._repeat(null,-i.page,e),!0}return!1},_start:function(t){return this.spinning||this._trigger("start",t)!==!1?(this.counter||(this.counter=1),this.spinning=!0,!0):!1},_repeat:function(t,e,i){t=t||500,clearTimeout(this.timer),this.timer=this._delay(function(){this._repeat(40,e,i)},t),this._spin(e*this.options.step,i)},_spin:function(t,e){var i=this.value()||0;this.counter||(this.counter=1),i=this._adjustValue(i+t*this._increment(this.counter)),this.spinning&&this._trigger("spin",e,{value:i})===!1||(this._value(i),this.counter++)},_increment:function(e){var i=this.options.incremental;return i?t.isFunction(i)?i(e):Math.floor(e*e*e/5e4-e*e/500+17*e/200+1):1},_precision:function(){var t=this._precisionOf(this.options.step);return null!==this.options.min&&(t=Math.max(t,this._precisionOf(this.options.min))),t},_precisionOf:function(t){var e=""+t,i=e.indexOf(".");return-1===i?0:e.length-i-1},_adjustValue:function(t){var e,i,s=this.options;return e=null!==s.min?s.min:0,i=t-e,i=Math.round(i/s.step)*s.step,t=e+i,t=parseFloat(t.toFixed(this._precision())),null!==s.max&&t>s.max?s.max:null!==s.min&&s.min>t?s.min:t},_stop:function(t){this.spinning&&(clearTimeout(this.timer),clearTimeout(this.mousewheelTimer),this.counter=0,this.spinning=!1,this._trigger("stop",t))},_setOption:function(t,e){var i,s,n;return"culture"===t||"numberFormat"===t?(i=this._parse(this.element.val()),this.options[t]=e,this.element.val(this._format(i)),void 0):(("max"===t||"min"===t||"step"===t)&&"string"==typeof e&&(e=this._parse(e)),"icons"===t&&(s=this.buttons.first().find(".ui-icon"),this._removeClass(s,null,this.options.icons.up),this._addClass(s,null,e.up),n=this.buttons.last().find(".ui-icon"),this._removeClass(n,null,this.options.icons.down),this._addClass(n,null,e.down)),this._super(t,e),void 0)},_setOptionDisabled:function(t){this._super(t),this._toggleClass(this.uiSpinner,null,"ui-state-disabled",!!t),this.element.prop("disabled",!!t),this.buttons.button(t?"disable":"enable")},_setOptions:r(function(t){this._super(t)}),_parse:function(t){return"string"==typeof t&&""!==t&&(t=window.Globalize&&this.options.numberFormat?Globalize.parseFloat(t,10,this.options.culture):+t),""===t||isNaN(t)?null:t},_format:function(t){return""===t?"":window.Globalize&&this.options.numberFormat?Globalize.format(t,this.options.numberFormat,this.options.culture):t},_refresh:function(){this.element.attr({"aria-valuemin":this.options.min,"aria-valuemax":this.options.max,"aria-valuenow":this._parse(this.element.val())})},isValid:function(){var t=this.value();return null===t?!1:t===this._adjustValue(t)},_value:function(t,e){var i;""!==t&&(i=this._parse(t),null!==i&&(e||(i=this._adjustValue(i)),t=this._format(i))),this.element.val(t),this._refresh()},_destroy:function(){this.element.prop("disabled",!1).removeAttr("autocomplete role aria-valuemin aria-valuemax aria-valuenow"),this.uiSpinner.replaceWith(this.element)},stepUp:r(function(t){this._stepUp(t)}),_stepUp:function(t){this._start()&&(this._spin((t||1)*this.options.step),this._stop())},stepDown:r(function(t){this._stepDown(t)}),_stepDown:function(t){this._start()&&(this._spin((t||1)*-this.options.step),this._stop())},pageUp:r(function(t){this._stepUp((t||1)*this.options.page)}),pageDown:r(function(t){this._stepDown((t||1)*this.options.page)}),value:function(t){return arguments.length?(r(this._value).call(this,t),void 0):this._parse(this.element.val())},widget:function(){return this.uiSpinner}}),t.uiBackCompat!==!1&&t.widget("ui.spinner",t.ui.spinner,{_enhance:function(){this.uiSpinner=this.element.attr("autocomplete","off").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml())},_uiSpinnerHtml:function(){return"<span>"},_buttonHtml:function(){return"<a></a><a></a>"}}),t.ui.spinner,t.widget("ui.tabs",{version:"1.12.1",delay:300,options:{active:null,classes:{"ui-tabs":"ui-corner-all","ui-tabs-nav":"ui-corner-all","ui-tabs-panel":"ui-corner-bottom","ui-tabs-tab":"ui-corner-top"},collapsible:!1,event:"click",heightStyle:"content",hide:null,show:null,activate:null,beforeActivate:null,beforeLoad:null,load:null},_isLocal:function(){var t=/#.*$/;return function(e){var i,s;i=e.href.replace(t,""),s=location.href.replace(t,"");try{i=decodeURIComponent(i)}catch(n){}try{s=decodeURIComponent(s)}catch(n){}return e.hash.length>1&&i===s}}(),_create:function(){var e=this,i=this.options;this.running=!1,this._addClass("ui-tabs","ui-widget ui-widget-content"),this._toggleClass("ui-tabs-collapsible",null,i.collapsible),this._processTabs(),i.active=this._initialActive(),t.isArray(i.disabled)&&(i.disabled=t.unique(i.disabled.concat(t.map(this.tabs.filter(".ui-state-disabled"),function(t){return e.tabs.index(t)}))).sort()),this.active=this.options.active!==!1&&this.anchors.length?this._findActive(i.active):t(),this._refresh(),this.active.length&&this.load(i.active)},_initialActive:function(){var e=this.options.active,i=this.options.collapsible,s=location.hash.substring(1);return null===e&&(s&&this.tabs.each(function(i,n){return t(n).attr("aria-controls")===s?(e=i,!1):void 0}),null===e&&(e=this.tabs.index(this.tabs.filter(".ui-tabs-active"))),(null===e||-1===e)&&(e=this.tabs.length?0:!1)),e!==!1&&(e=this.tabs.index(this.tabs.eq(e)),-1===e&&(e=i?!1:0)),!i&&e===!1&&this.anchors.length&&(e=0),e},_getCreateEventData:function(){return{tab:this.active,panel:this.active.length?this._getPanelForTab(this.active):t()}},_tabKeydown:function(e){var i=t(t.ui.safeActiveElement(this.document[0])).closest("li"),s=this.tabs.index(i),n=!0;if(!this._handlePageNav(e)){switch(e.keyCode){case t.ui.keyCode.RIGHT:case t.ui.keyCode.DOWN:s++;break;case t.ui.keyCode.UP:case t.ui.keyCode.LEFT:n=!1,s--;break;case t.ui.keyCode.END:s=this.anchors.length-1;break;case t.ui.keyCode.HOME:s=0;break;case t.ui.keyCode.SPACE:return e.preventDefault(),clearTimeout(this.activating),this._activate(s),void 0;case t.ui.keyCode.ENTER:return e.preventDefault(),clearTimeout(this.activating),this._activate(s===this.options.active?!1:s),void 0;default:return}e.preventDefault(),clearTimeout(this.activating),s=this._focusNextTab(s,n),e.ctrlKey||e.metaKey||(i.attr("aria-selected","false"),this.tabs.eq(s).attr("aria-selected","true"),this.activating=this._delay(function(){this.option("active",s)},this.delay))}},_panelKeydown:function(e){this._handlePageNav(e)||e.ctrlKey&&e.keyCode===t.ui.keyCode.UP&&(e.preventDefault(),this.active.trigger("focus"))},_handlePageNav:function(e){return e.altKey&&e.keyCode===t.ui.keyCode.PAGE_UP?(this._activate(this._focusNextTab(this.options.active-1,!1)),!0):e.altKey&&e.keyCode===t.ui.keyCode.PAGE_DOWN?(this._activate(this._focusNextTab(this.options.active+1,!0)),!0):void 0},_findNextTab:function(e,i){function s(){return e>n&&(e=0),0>e&&(e=n),e}for(var n=this.tabs.length-1;-1!==t.inArray(s(),this.options.disabled);)e=i?e+1:e-1;return e},_focusNextTab:function(t,e){return t=this._findNextTab(t,e),this.tabs.eq(t).trigger("focus"),t},_setOption:function(t,e){return"active"===t?(this._activate(e),void 0):(this._super(t,e),"collapsible"===t&&(this._toggleClass("ui-tabs-collapsible",null,e),e||this.options.active!==!1||this._activate(0)),"event"===t&&this._setupEvents(e),"heightStyle"===t&&this._setupHeightStyle(e),void 0)},_sanitizeSelector:function(t){return t?t.replace(/[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g,"\\$&"):""},refresh:function(){var e=this.options,i=this.tablist.children(":has(a[href])");e.disabled=t.map(i.filter(".ui-state-disabled"),function(t){return i.index(t)}),this._processTabs(),e.active!==!1&&this.anchors.length?this.active.length&&!t.contains(this.tablist[0],this.active[0])?this.tabs.length===e.disabled.length?(e.active=!1,this.active=t()):this._activate(this._findNextTab(Math.max(0,e.active-1),!1)):e.active=this.tabs.index(this.active):(e.active=!1,this.active=t()),this._refresh()},_refresh:function(){this._setOptionDisabled(this.options.disabled),this._setupEvents(this.options.event),this._setupHeightStyle(this.options.heightStyle),this.tabs.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}),this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-hidden":"true"}),this.active.length?(this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}),this._addClass(this.active,"ui-tabs-active","ui-state-active"),this._getPanelForTab(this.active).show().attr({"aria-hidden":"false"})):this.tabs.eq(0).attr("tabIndex",0)},_processTabs:function(){var e=this,i=this.tabs,s=this.anchors,n=this.panels;this.tablist=this._getList().attr("role","tablist"),this._addClass(this.tablist,"ui-tabs-nav","ui-helper-reset ui-helper-clearfix ui-widget-header"),this.tablist.on("mousedown"+this.eventNamespace,"> li",function(e){t(this).is(".ui-state-disabled")&&e.preventDefault()}).on("focus"+this.eventNamespace,".ui-tabs-anchor",function(){t(this).closest("li").is(".ui-state-disabled")&&this.blur()}),this.tabs=this.tablist.find("> li:has(a[href])").attr({role:"tab",tabIndex:-1}),this._addClass(this.tabs,"ui-tabs-tab","ui-state-default"),this.anchors=this.tabs.map(function(){return t("a",this)[0]}).attr({role:"presentation",tabIndex:-1}),this._addClass(this.anchors,"ui-tabs-anchor"),this.panels=t(),this.anchors.each(function(i,s){var n,o,a,r=t(s).uniqueId().attr("id"),h=t(s).closest("li"),l=h.attr("aria-controls");e._isLocal(s)?(n=s.hash,a=n.substring(1),o=e.element.find(e._sanitizeSelector(n))):(a=h.attr("aria-controls")||t({}).uniqueId()[0].id,n="#"+a,o=e.element.find(n),o.length||(o=e._createPanel(a),o.insertAfter(e.panels[i-1]||e.tablist)),o.attr("aria-live","polite")),o.length&&(e.panels=e.panels.add(o)),l&&h.data("ui-tabs-aria-controls",l),h.attr({"aria-controls":a,"aria-labelledby":r}),o.attr("aria-labelledby",r)}),this.panels.attr("role","tabpanel"),this._addClass(this.panels,"ui-tabs-panel","ui-widget-content"),i&&(this._off(i.not(this.tabs)),this._off(s.not(this.anchors)),this._off(n.not(this.panels)))},_getList:function(){return this.tablist||this.element.find("ol, ul").eq(0)},_createPanel:function(e){return t("<div>").attr("id",e).data("ui-tabs-destroy",!0)},_setOptionDisabled:function(e){var i,s,n;for(t.isArray(e)&&(e.length?e.length===this.anchors.length&&(e=!0):e=!1),n=0;s=this.tabs[n];n++)i=t(s),e===!0||-1!==t.inArray(n,e)?(i.attr("aria-disabled","true"),this._addClass(i,null,"ui-state-disabled")):(i.removeAttr("aria-disabled"),this._removeClass(i,null,"ui-state-disabled"));this.options.disabled=e,this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,e===!0)},_setupEvents:function(e){var i={};e&&t.each(e.split(" "),function(t,e){i[e]="_eventHandler"}),this._off(this.anchors.add(this.tabs).add(this.panels)),this._on(!0,this.anchors,{click:function(t){t.preventDefault()}}),this._on(this.anchors,i),this._on(this.tabs,{keydown:"_tabKeydown"}),this._on(this.panels,{keydown:"_panelKeydown"}),this._focusable(this.tabs),this._hoverable(this.tabs)},_setupHeightStyle:function(e){var i,s=this.element.parent();"fill"===e?(i=s.height(),i-=this.element.outerHeight()-this.element.height(),this.element.siblings(":visible").each(function(){var e=t(this),s=e.css("position");"absolute"!==s&&"fixed"!==s&&(i-=e.outerHeight(!0))}),this.element.children().not(this.panels).each(function(){i-=t(this).outerHeight(!0)}),this.panels.each(function(){t(this).height(Math.max(0,i-t(this).innerHeight()+t(this).height()))}).css("overflow","auto")):"auto"===e&&(i=0,this.panels.each(function(){i=Math.max(i,t(this).height("").height())}).height(i))},_eventHandler:function(e){var i=this.options,s=this.active,n=t(e.currentTarget),o=n.closest("li"),a=o[0]===s[0],r=a&&i.collapsible,h=r?t():this._getPanelForTab(o),l=s.length?this._getPanelForTab(s):t(),c={oldTab:s,oldPanel:l,newTab:r?t():o,newPanel:h};e.preventDefault(),o.hasClass("ui-state-disabled")||o.hasClass("ui-tabs-loading")||this.running||a&&!i.collapsible||this._trigger("beforeActivate",e,c)===!1||(i.active=r?!1:this.tabs.index(o),this.active=a?t():o,this.xhr&&this.xhr.abort(),l.length||h.length||t.error("jQuery UI Tabs: Mismatching fragment identifier."),h.length&&this.load(this.tabs.index(o),e),this._toggle(e,c))},_toggle:function(e,i){function s(){o.running=!1,o._trigger("activate",e,i)}function n(){o._addClass(i.newTab.closest("li"),"ui-tabs-active","ui-state-active"),a.length&&o.options.show?o._show(a,o.options.show,s):(a.show(),s())}var o=this,a=i.newPanel,r=i.oldPanel;this.running=!0,r.length&&this.options.hide?this._hide(r,this.options.hide,function(){o._removeClass(i.oldTab.closest("li"),"ui-tabs-active","ui-state-active"),n()}):(this._removeClass(i.oldTab.closest("li"),"ui-tabs-active","ui-state-active"),r.hide(),n()),r.attr("aria-hidden","true"),i.oldTab.attr({"aria-selected":"false","aria-expanded":"false"}),a.length&&r.length?i.oldTab.attr("tabIndex",-1):a.length&&this.tabs.filter(function(){return 0===t(this).attr("tabIndex")}).attr("tabIndex",-1),a.attr("aria-hidden","false"),i.newTab.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0})},_activate:function(e){var i,s=this._findActive(e);s[0]!==this.active[0]&&(s.length||(s=this.active),i=s.find(".ui-tabs-anchor")[0],this._eventHandler({target:i,currentTarget:i,preventDefault:t.noop}))},_findActive:function(e){return e===!1?t():this.tabs.eq(e)},_getIndex:function(e){return"string"==typeof e&&(e=this.anchors.index(this.anchors.filter("[href$='"+t.ui.escapeSelector(e)+"']"))),e},_destroy:function(){this.xhr&&this.xhr.abort(),this.tablist.removeAttr("role").off(this.eventNamespace),this.anchors.removeAttr("role tabIndex").removeUniqueId(),this.tabs.add(this.panels).each(function(){t.data(this,"ui-tabs-destroy")?t(this).remove():t(this).removeAttr("role tabIndex aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded")}),this.tabs.each(function(){var e=t(this),i=e.data("ui-tabs-aria-controls");i?e.attr("aria-controls",i).removeData("ui-tabs-aria-controls"):e.removeAttr("aria-controls")}),this.panels.show(),"content"!==this.options.heightStyle&&this.panels.css("height","")},enable:function(e){var i=this.options.disabled;i!==!1&&(void 0===e?i=!1:(e=this._getIndex(e),i=t.isArray(i)?t.map(i,function(t){return t!==e?t:null}):t.map(this.tabs,function(t,i){return i!==e?i:null})),this._setOptionDisabled(i))},disable:function(e){var i=this.options.disabled;if(i!==!0){if(void 0===e)i=!0;else{if(e=this._getIndex(e),-1!==t.inArray(e,i))return;i=t.isArray(i)?t.merge([e],i).sort():[e]}this._setOptionDisabled(i)}},load:function(e,i){e=this._getIndex(e);var s=this,n=this.tabs.eq(e),o=n.find(".ui-tabs-anchor"),a=this._getPanelForTab(n),r={tab:n,panel:a},h=function(t,e){"abort"===e&&s.panels.stop(!1,!0),s._removeClass(n,"ui-tabs-loading"),a.removeAttr("aria-busy"),t===s.xhr&&delete s.xhr};this._isLocal(o[0])||(this.xhr=t.ajax(this._ajaxSettings(o,i,r)),this.xhr&&"canceled"!==this.xhr.statusText&&(this._addClass(n,"ui-tabs-loading"),a.attr("aria-busy","true"),this.xhr.done(function(t,e,n){setTimeout(function(){a.html(t),s._trigger("load",i,r),h(n,e)},1)}).fail(function(t,e){setTimeout(function(){h(t,e)},1)})))},_ajaxSettings:function(e,i,s){var n=this;return{url:e.attr("href").replace(/#.*$/,""),beforeSend:function(e,o){return n._trigger("beforeLoad",i,t.extend({jqXHR:e,ajaxSettings:o},s))}}},_getPanelForTab:function(e){var i=t(e).attr("aria-controls");return this.element.find(this._sanitizeSelector("#"+i))}}),t.uiBackCompat!==!1&&t.widget("ui.tabs",t.ui.tabs,{_processTabs:function(){this._superApply(arguments),this._addClass(this.tabs,"ui-tab")}}),t.ui.tabs,t.widget("ui.tooltip",{version:"1.12.1",options:{classes:{"ui-tooltip":"ui-corner-all ui-widget-shadow"},content:function(){var e=t(this).attr("title")||"";return t("<a>").text(e).html()},hide:!0,items:"[title]:not([disabled])",position:{my:"left top+15",at:"left bottom",collision:"flipfit flip"},show:!0,track:!1,close:null,open:null},_addDescribedBy:function(e,i){var s=(e.attr("aria-describedby")||"").split(/\s+/);s.push(i),e.data("ui-tooltip-id",i).attr("aria-describedby",t.trim(s.join(" ")))},_removeDescribedBy:function(e){var i=e.data("ui-tooltip-id"),s=(e.attr("aria-describedby")||"").split(/\s+/),n=t.inArray(i,s);-1!==n&&s.splice(n,1),e.removeData("ui-tooltip-id"),s=t.trim(s.join(" ")),s?e.attr("aria-describedby",s):e.removeAttr("aria-describedby")},_create:function(){this._on({mouseover:"open",focusin:"open"}),this.tooltips={},this.parents={},this.liveRegion=t("<div>").attr({role:"log","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body),this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible"),this.disabledTitles=t([])},_setOption:function(e,i){var s=this;this._super(e,i),"content"===e&&t.each(this.tooltips,function(t,e){s._updateContent(e.element)})},_setOptionDisabled:function(t){this[t?"_disable":"_enable"]()},_disable:function(){var e=this;t.each(this.tooltips,function(i,s){var n=t.Event("blur");n.target=n.currentTarget=s.element[0],e.close(n,!0)}),this.disabledTitles=this.disabledTitles.add(this.element.find(this.options.items).addBack().filter(function(){var e=t(this);return e.is("[title]")?e.data("ui-tooltip-title",e.attr("title")).removeAttr("title"):void 0}))},_enable:function(){this.disabledTitles.each(function(){var e=t(this);e.data("ui-tooltip-title")&&e.attr("title",e.data("ui-tooltip-title"))}),this.disabledTitles=t([])},open:function(e){var i=this,s=t(e?e.target:this.element).closest(this.options.items);s.length&&!s.data("ui-tooltip-id")&&(s.attr("title")&&s.data("ui-tooltip-title",s.attr("title")),s.data("ui-tooltip-open",!0),e&&"mouseover"===e.type&&s.parents().each(function(){var e,s=t(this);s.data("ui-tooltip-open")&&(e=t.Event("blur"),e.target=e.currentTarget=this,i.close(e,!0)),s.attr("title")&&(s.uniqueId(),i.parents[this.id]={element:this,title:s.attr("title")},s.attr("title",""))}),this._registerCloseHandlers(e,s),this._updateContent(s,e))},_updateContent:function(t,e){var i,s=this.options.content,n=this,o=e?e.type:null;return"string"==typeof s||s.nodeType||s.jquery?this._open(e,t,s):(i=s.call(t[0],function(i){n._delay(function(){t.data("ui-tooltip-open")&&(e&&(e.type=o),this._open(e,t,i))})}),i&&this._open(e,t,i),void 0)},_open:function(e,i,s){function n(t){l.of=t,a.is(":hidden")||a.position(l)}var o,a,r,h,l=t.extend({},this.options.position);if(s){if(o=this._find(i))return o.tooltip.find(".ui-tooltip-content").html(s),void 0;i.is("[title]")&&(e&&"mouseover"===e.type?i.attr("title",""):i.removeAttr("title")),o=this._tooltip(i),a=o.tooltip,this._addDescribedBy(i,a.attr("id")),a.find(".ui-tooltip-content").html(s),this.liveRegion.children().hide(),h=t("<div>").html(a.find(".ui-tooltip-content").html()),h.removeAttr("name").find("[name]").removeAttr("name"),h.removeAttr("id").find("[id]").removeAttr("id"),h.appendTo(this.liveRegion),this.options.track&&e&&/^mouse/.test(e.type)?(this._on(this.document,{mousemove:n}),n(e)):a.position(t.extend({of:i},this.options.position)),a.hide(),this._show(a,this.options.show),this.options.track&&this.options.show&&this.options.show.delay&&(r=this.delayedShow=setInterval(function(){a.is(":visible")&&(n(l.of),clearInterval(r))},t.fx.interval)),this._trigger("open",e,{tooltip:a})}},_registerCloseHandlers:function(e,i){var s={keyup:function(e){if(e.keyCode===t.ui.keyCode.ESCAPE){var s=t.Event(e);s.currentTarget=i[0],this.close(s,!0)}}};i[0]!==this.element[0]&&(s.remove=function(){this._removeTooltip(this._find(i).tooltip)}),e&&"mouseover"!==e.type||(s.mouseleave="close"),e&&"focusin"!==e.type||(s.focusout="close"),this._on(!0,i,s)},close:function(e){var i,s=this,n=t(e?e.currentTarget:this.element),o=this._find(n);return o?(i=o.tooltip,o.closing||(clearInterval(this.delayedShow),n.data("ui-tooltip-title")&&!n.attr("title")&&n.attr("title",n.data("ui-tooltip-title")),this._removeDescribedBy(n),o.hiding=!0,i.stop(!0),this._hide(i,this.options.hide,function(){s._removeTooltip(t(this))}),n.removeData("ui-tooltip-open"),this._off(n,"mouseleave focusout keyup"),n[0]!==this.element[0]&&this._off(n,"remove"),this._off(this.document,"mousemove"),e&&"mouseleave"===e.type&&t.each(this.parents,function(e,i){t(i.element).attr("title",i.title),delete s.parents[e]}),o.closing=!0,this._trigger("close",e,{tooltip:i}),o.hiding||(o.closing=!1)),void 0):(n.removeData("ui-tooltip-open"),void 0)},_tooltip:function(e){var i=t("<div>").attr("role","tooltip"),s=t("<div>").appendTo(i),n=i.uniqueId().attr("id");return this._addClass(s,"ui-tooltip-content"),this._addClass(i,"ui-tooltip","ui-widget ui-widget-content"),i.appendTo(this._appendTo(e)),this.tooltips[n]={element:e,tooltip:i}},_find:function(t){var e=t.data("ui-tooltip-id");return e?this.tooltips[e]:null},_removeTooltip:function(t){t.remove(),delete this.tooltips[t.attr("id")]},_appendTo:function(t){var e=t.closest(".ui-front, dialog");return e.length||(e=this.document[0].body),e},_destroy:function(){var e=this;t.each(this.tooltips,function(i,s){var n=t.Event("blur"),o=s.element;n.target=n.currentTarget=o[0],e.close(n,!0),t("#"+i).remove(),o.data("ui-tooltip-title")&&(o.attr("title")||o.attr("title",o.data("ui-tooltip-title")),o.removeData("ui-tooltip-title"))}),this.liveRegion.remove()}}),t.uiBackCompat!==!1&&t.widget("ui.tooltip",t.ui.tooltip,{options:{tooltipClass:null},_tooltip:function(){var t=this._superApply(arguments);return this.options.tooltipClass&&t.tooltip.addClass(this.options.tooltipClass),t}}),t.ui.tooltip});/*!
  * Bootstrap v4.6.0 (https://getbootstrap.com/)
  * Copyright 2011-2021 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("jquery")):"function"==typeof define&&define.amd?define(["exports","jquery"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).bootstrap={},t.jQuery)}(this,(function(t,e){"use strict";function n(t){return t&&"object"==typeof t&&"default"in t?t:{default:t}}var i=n(e);function o(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(t,i.key,i)}}function r(t,e,n){return e&&o(t.prototype,e),n&&o(t,n),t}function a(){return(a=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function s(t){var e=this,n=!1;return i.default(this).one(l.TRANSITION_END,(function(){n=!0})),setTimeout((function(){n||l.triggerTransitionEnd(e)}),t),this}var l={TRANSITION_END:"bsTransitionEnd",getUID:function(t){do{t+=~~(1e6*Math.random())}while(document.getElementById(t));return t},getSelectorFromElement:function(t){var e=t.getAttribute("data-target");if(!e||"#"===e){var n=t.getAttribute("href");e=n&&"#"!==n?n.trim():""}try{return document.querySelector(e)?e:null}catch(t){return null}},getTransitionDurationFromElement:function(t){if(!t)return 0;var e=i.default(t).css("transition-duration"),n=i.default(t).css("transition-delay"),o=parseFloat(e),r=parseFloat(n);return o||r?(e=e.split(",")[0],n=n.split(",")[0],1e3*(parseFloat(e)+parseFloat(n))):0},reflow:function(t){return t.offsetHeight},triggerTransitionEnd:function(t){i.default(t).trigger("transitionend")},supportsTransitionEnd:function(){return Boolean("transitionend")},isElement:function(t){return(t[0]||t).nodeType},typeCheckConfig:function(t,e,n){for(var i in n)if(Object.prototype.hasOwnProperty.call(n,i)){var o=n[i],r=e[i],a=r&&l.isElement(r)?"element":null===(s=r)||"undefined"==typeof s?""+s:{}.toString.call(s).match(/\s([a-z]+)/i)[1].toLowerCase();if(!new RegExp(o).test(a))throw new Error(t.toUpperCase()+': Option "'+i+'" provided type "'+a+'" but expected type "'+o+'".')}var s},findShadowRoot:function(t){if(!document.documentElement.attachShadow)return null;if("function"==typeof t.getRootNode){var e=t.getRootNode();return e instanceof ShadowRoot?e:null}return t instanceof ShadowRoot?t:t.parentNode?l.findShadowRoot(t.parentNode):null},jQueryDetection:function(){if("undefined"==typeof i.default)throw new TypeError("Bootstrap's JavaScript requires jQuery. jQuery must be included before Bootstrap's JavaScript.");var t=i.default.fn.jquery.split(" ")[0].split(".");if(t[0]<2&&t[1]<9||1===t[0]&&9===t[1]&&t[2]<1||t[0]>=4)throw new Error("Bootstrap's JavaScript requires at least jQuery v1.9.1 but less than v4.0.0")}};l.jQueryDetection(),i.default.fn.emulateTransitionEnd=s,i.default.event.special[l.TRANSITION_END]={bindType:"transitionend",delegateType:"transitionend",handle:function(t){if(i.default(t.target).is(this))return t.handleObj.handler.apply(this,arguments)}};var u="alert",f=i.default.fn[u],d=function(){function t(t){this._element=t}var e=t.prototype;return e.close=function(t){var e=this._element;t&&(e=this._getRootElement(t)),this._triggerCloseEvent(e).isDefaultPrevented()||this._removeElement(e)},e.dispose=function(){i.default.removeData(this._element,"bs.alert"),this._element=null},e._getRootElement=function(t){var e=l.getSelectorFromElement(t),n=!1;return e&&(n=document.querySelector(e)),n||(n=i.default(t).closest(".alert")[0]),n},e._triggerCloseEvent=function(t){var e=i.default.Event("close.bs.alert");return i.default(t).trigger(e),e},e._removeElement=function(t){var e=this;if(i.default(t).removeClass("show"),i.default(t).hasClass("fade")){var n=l.getTransitionDurationFromElement(t);i.default(t).one(l.TRANSITION_END,(function(n){return e._destroyElement(t,n)})).emulateTransitionEnd(n)}else this._destroyElement(t)},e._destroyElement=function(t){i.default(t).detach().trigger("closed.bs.alert").remove()},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this),o=n.data("bs.alert");o||(o=new t(this),n.data("bs.alert",o)),"close"===e&&o[e](this)}))},t._handleDismiss=function(t){return function(e){e&&e.preventDefault(),t.close(this)}},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}}]),t}();i.default(document).on("click.bs.alert.data-api",'[data-dismiss="alert"]',d._handleDismiss(new d)),i.default.fn[u]=d._jQueryInterface,i.default.fn[u].Constructor=d,i.default.fn[u].noConflict=function(){return i.default.fn[u]=f,d._jQueryInterface};var c=i.default.fn.button,h=function(){function t(t){this._element=t,this.shouldAvoidTriggerChange=!1}var e=t.prototype;return e.toggle=function(){var t=!0,e=!0,n=i.default(this._element).closest('[data-toggle="buttons"]')[0];if(n){var o=this._element.querySelector('input:not([type="hidden"])');if(o){if("radio"===o.type)if(o.checked&&this._element.classList.contains("active"))t=!1;else{var r=n.querySelector(".active");r&&i.default(r).removeClass("active")}t&&("checkbox"!==o.type&&"radio"!==o.type||(o.checked=!this._element.classList.contains("active")),this.shouldAvoidTriggerChange||i.default(o).trigger("change")),o.focus(),e=!1}}this._element.hasAttribute("disabled")||this._element.classList.contains("disabled")||(e&&this._element.setAttribute("aria-pressed",!this._element.classList.contains("active")),t&&i.default(this._element).toggleClass("active"))},e.dispose=function(){i.default.removeData(this._element,"bs.button"),this._element=null},t._jQueryInterface=function(e,n){return this.each((function(){var o=i.default(this),r=o.data("bs.button");r||(r=new t(this),o.data("bs.button",r)),r.shouldAvoidTriggerChange=n,"toggle"===e&&r[e]()}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}}]),t}();i.default(document).on("click.bs.button.data-api",'[data-toggle^="button"]',(function(t){var e=t.target,n=e;if(i.default(e).hasClass("btn")||(e=i.default(e).closest(".btn")[0]),!e||e.hasAttribute("disabled")||e.classList.contains("disabled"))t.preventDefault();else{var o=e.querySelector('input:not([type="hidden"])');if(o&&(o.hasAttribute("disabled")||o.classList.contains("disabled")))return void t.preventDefault();"INPUT"!==n.tagName&&"LABEL"===e.tagName||h._jQueryInterface.call(i.default(e),"toggle","INPUT"===n.tagName)}})).on("focus.bs.button.data-api blur.bs.button.data-api",'[data-toggle^="button"]',(function(t){var e=i.default(t.target).closest(".btn")[0];i.default(e).toggleClass("focus",/^focus(in)?$/.test(t.type))})),i.default(window).on("load.bs.button.data-api",(function(){for(var t=[].slice.call(document.querySelectorAll('[data-toggle="buttons"] .btn')),e=0,n=t.length;e<n;e++){var i=t[e],o=i.querySelector('input:not([type="hidden"])');o.checked||o.hasAttribute("checked")?i.classList.add("active"):i.classList.remove("active")}for(var r=0,a=(t=[].slice.call(document.querySelectorAll('[data-toggle="button"]'))).length;r<a;r++){var s=t[r];"true"===s.getAttribute("aria-pressed")?s.classList.add("active"):s.classList.remove("active")}})),i.default.fn.button=h._jQueryInterface,i.default.fn.button.Constructor=h,i.default.fn.button.noConflict=function(){return i.default.fn.button=c,h._jQueryInterface};var p="carousel",m=".bs.carousel",g=i.default.fn[p],v={interval:5e3,keyboard:!0,slide:!1,pause:"hover",wrap:!0,touch:!0},_={interval:"(number|boolean)",keyboard:"boolean",slide:"(boolean|string)",pause:"(string|boolean)",wrap:"boolean",touch:"boolean"},b={TOUCH:"touch",PEN:"pen"},y=function(){function t(t,e){this._items=null,this._interval=null,this._activeElement=null,this._isPaused=!1,this._isSliding=!1,this.touchTimeout=null,this.touchStartX=0,this.touchDeltaX=0,this._config=this._getConfig(e),this._element=t,this._indicatorsElement=this._element.querySelector(".carousel-indicators"),this._touchSupported="ontouchstart"in document.documentElement||navigator.maxTouchPoints>0,this._pointerEvent=Boolean(window.PointerEvent||window.MSPointerEvent),this._addEventListeners()}var e=t.prototype;return e.next=function(){this._isSliding||this._slide("next")},e.nextWhenVisible=function(){var t=i.default(this._element);!document.hidden&&t.is(":visible")&&"hidden"!==t.css("visibility")&&this.next()},e.prev=function(){this._isSliding||this._slide("prev")},e.pause=function(t){t||(this._isPaused=!0),this._element.querySelector(".carousel-item-next, .carousel-item-prev")&&(l.triggerTransitionEnd(this._element),this.cycle(!0)),clearInterval(this._interval),this._interval=null},e.cycle=function(t){t||(this._isPaused=!1),this._interval&&(clearInterval(this._interval),this._interval=null),this._config.interval&&!this._isPaused&&(this._updateInterval(),this._interval=setInterval((document.visibilityState?this.nextWhenVisible:this.next).bind(this),this._config.interval))},e.to=function(t){var e=this;this._activeElement=this._element.querySelector(".active.carousel-item");var n=this._getItemIndex(this._activeElement);if(!(t>this._items.length-1||t<0))if(this._isSliding)i.default(this._element).one("slid.bs.carousel",(function(){return e.to(t)}));else{if(n===t)return this.pause(),void this.cycle();var o=t>n?"next":"prev";this._slide(o,this._items[t])}},e.dispose=function(){i.default(this._element).off(m),i.default.removeData(this._element,"bs.carousel"),this._items=null,this._config=null,this._element=null,this._interval=null,this._isPaused=null,this._isSliding=null,this._activeElement=null,this._indicatorsElement=null},e._getConfig=function(t){return t=a({},v,t),l.typeCheckConfig(p,t,_),t},e._handleSwipe=function(){var t=Math.abs(this.touchDeltaX);if(!(t<=40)){var e=t/this.touchDeltaX;this.touchDeltaX=0,e>0&&this.prev(),e<0&&this.next()}},e._addEventListeners=function(){var t=this;this._config.keyboard&&i.default(this._element).on("keydown.bs.carousel",(function(e){return t._keydown(e)})),"hover"===this._config.pause&&i.default(this._element).on("mouseenter.bs.carousel",(function(e){return t.pause(e)})).on("mouseleave.bs.carousel",(function(e){return t.cycle(e)})),this._config.touch&&this._addTouchEventListeners()},e._addTouchEventListeners=function(){var t=this;if(this._touchSupported){var e=function(e){t._pointerEvent&&b[e.originalEvent.pointerType.toUpperCase()]?t.touchStartX=e.originalEvent.clientX:t._pointerEvent||(t.touchStartX=e.originalEvent.touches[0].clientX)},n=function(e){t._pointerEvent&&b[e.originalEvent.pointerType.toUpperCase()]&&(t.touchDeltaX=e.originalEvent.clientX-t.touchStartX),t._handleSwipe(),"hover"===t._config.pause&&(t.pause(),t.touchTimeout&&clearTimeout(t.touchTimeout),t.touchTimeout=setTimeout((function(e){return t.cycle(e)}),500+t._config.interval))};i.default(this._element.querySelectorAll(".carousel-item img")).on("dragstart.bs.carousel",(function(t){return t.preventDefault()})),this._pointerEvent?(i.default(this._element).on("pointerdown.bs.carousel",(function(t){return e(t)})),i.default(this._element).on("pointerup.bs.carousel",(function(t){return n(t)})),this._element.classList.add("pointer-event")):(i.default(this._element).on("touchstart.bs.carousel",(function(t){return e(t)})),i.default(this._element).on("touchmove.bs.carousel",(function(e){return function(e){e.originalEvent.touches&&e.originalEvent.touches.length>1?t.touchDeltaX=0:t.touchDeltaX=e.originalEvent.touches[0].clientX-t.touchStartX}(e)})),i.default(this._element).on("touchend.bs.carousel",(function(t){return n(t)})))}},e._keydown=function(t){if(!/input|textarea/i.test(t.target.tagName))switch(t.which){case 37:t.preventDefault(),this.prev();break;case 39:t.preventDefault(),this.next()}},e._getItemIndex=function(t){return this._items=t&&t.parentNode?[].slice.call(t.parentNode.querySelectorAll(".carousel-item")):[],this._items.indexOf(t)},e._getItemByDirection=function(t,e){var n="next"===t,i="prev"===t,o=this._getItemIndex(e),r=this._items.length-1;if((i&&0===o||n&&o===r)&&!this._config.wrap)return e;var a=(o+("prev"===t?-1:1))%this._items.length;return-1===a?this._items[this._items.length-1]:this._items[a]},e._triggerSlideEvent=function(t,e){var n=this._getItemIndex(t),o=this._getItemIndex(this._element.querySelector(".active.carousel-item")),r=i.default.Event("slide.bs.carousel",{relatedTarget:t,direction:e,from:o,to:n});return i.default(this._element).trigger(r),r},e._setActiveIndicatorElement=function(t){if(this._indicatorsElement){var e=[].slice.call(this._indicatorsElement.querySelectorAll(".active"));i.default(e).removeClass("active");var n=this._indicatorsElement.children[this._getItemIndex(t)];n&&i.default(n).addClass("active")}},e._updateInterval=function(){var t=this._activeElement||this._element.querySelector(".active.carousel-item");if(t){var e=parseInt(t.getAttribute("data-interval"),10);e?(this._config.defaultInterval=this._config.defaultInterval||this._config.interval,this._config.interval=e):this._config.interval=this._config.defaultInterval||this._config.interval}},e._slide=function(t,e){var n,o,r,a=this,s=this._element.querySelector(".active.carousel-item"),u=this._getItemIndex(s),f=e||s&&this._getItemByDirection(t,s),d=this._getItemIndex(f),c=Boolean(this._interval);if("next"===t?(n="carousel-item-left",o="carousel-item-next",r="left"):(n="carousel-item-right",o="carousel-item-prev",r="right"),f&&i.default(f).hasClass("active"))this._isSliding=!1;else if(!this._triggerSlideEvent(f,r).isDefaultPrevented()&&s&&f){this._isSliding=!0,c&&this.pause(),this._setActiveIndicatorElement(f),this._activeElement=f;var h=i.default.Event("slid.bs.carousel",{relatedTarget:f,direction:r,from:u,to:d});if(i.default(this._element).hasClass("slide")){i.default(f).addClass(o),l.reflow(f),i.default(s).addClass(n),i.default(f).addClass(n);var p=l.getTransitionDurationFromElement(s);i.default(s).one(l.TRANSITION_END,(function(){i.default(f).removeClass(n+" "+o).addClass("active"),i.default(s).removeClass("active "+o+" "+n),a._isSliding=!1,setTimeout((function(){return i.default(a._element).trigger(h)}),0)})).emulateTransitionEnd(p)}else i.default(s).removeClass("active"),i.default(f).addClass("active"),this._isSliding=!1,i.default(this._element).trigger(h);c&&this.cycle()}},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this).data("bs.carousel"),o=a({},v,i.default(this).data());"object"==typeof e&&(o=a({},o,e));var r="string"==typeof e?e:o.slide;if(n||(n=new t(this,o),i.default(this).data("bs.carousel",n)),"number"==typeof e)n.to(e);else if("string"==typeof r){if("undefined"==typeof n[r])throw new TypeError('No method named "'+r+'"');n[r]()}else o.interval&&o.ride&&(n.pause(),n.cycle())}))},t._dataApiClickHandler=function(e){var n=l.getSelectorFromElement(this);if(n){var o=i.default(n)[0];if(o&&i.default(o).hasClass("carousel")){var r=a({},i.default(o).data(),i.default(this).data()),s=this.getAttribute("data-slide-to");s&&(r.interval=!1),t._jQueryInterface.call(i.default(o),r),s&&i.default(o).data("bs.carousel").to(s),e.preventDefault()}}},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return v}}]),t}();i.default(document).on("click.bs.carousel.data-api","[data-slide], [data-slide-to]",y._dataApiClickHandler),i.default(window).on("load.bs.carousel.data-api",(function(){for(var t=[].slice.call(document.querySelectorAll('[data-ride="carousel"]')),e=0,n=t.length;e<n;e++){var o=i.default(t[e]);y._jQueryInterface.call(o,o.data())}})),i.default.fn[p]=y._jQueryInterface,i.default.fn[p].Constructor=y,i.default.fn[p].noConflict=function(){return i.default.fn[p]=g,y._jQueryInterface};var w="collapse",E=i.default.fn[w],T={toggle:!0,parent:""},C={toggle:"boolean",parent:"(string|element)"},S=function(){function t(t,e){this._isTransitioning=!1,this._element=t,this._config=this._getConfig(e),this._triggerArray=[].slice.call(document.querySelectorAll('[data-toggle="collapse"][href="#'+t.id+'"],[data-toggle="collapse"][data-target="#'+t.id+'"]'));for(var n=[].slice.call(document.querySelectorAll('[data-toggle="collapse"]')),i=0,o=n.length;i<o;i++){var r=n[i],a=l.getSelectorFromElement(r),s=[].slice.call(document.querySelectorAll(a)).filter((function(e){return e===t}));null!==a&&s.length>0&&(this._selector=a,this._triggerArray.push(r))}this._parent=this._config.parent?this._getParent():null,this._config.parent||this._addAriaAndCollapsedClass(this._element,this._triggerArray),this._config.toggle&&this.toggle()}var e=t.prototype;return e.toggle=function(){i.default(this._element).hasClass("show")?this.hide():this.show()},e.show=function(){var e,n,o=this;if(!this._isTransitioning&&!i.default(this._element).hasClass("show")&&(this._parent&&0===(e=[].slice.call(this._parent.querySelectorAll(".show, .collapsing")).filter((function(t){return"string"==typeof o._config.parent?t.getAttribute("data-parent")===o._config.parent:t.classList.contains("collapse")}))).length&&(e=null),!(e&&(n=i.default(e).not(this._selector).data("bs.collapse"))&&n._isTransitioning))){var r=i.default.Event("show.bs.collapse");if(i.default(this._element).trigger(r),!r.isDefaultPrevented()){e&&(t._jQueryInterface.call(i.default(e).not(this._selector),"hide"),n||i.default(e).data("bs.collapse",null));var a=this._getDimension();i.default(this._element).removeClass("collapse").addClass("collapsing"),this._element.style[a]=0,this._triggerArray.length&&i.default(this._triggerArray).removeClass("collapsed").attr("aria-expanded",!0),this.setTransitioning(!0);var s="scroll"+(a[0].toUpperCase()+a.slice(1)),u=l.getTransitionDurationFromElement(this._element);i.default(this._element).one(l.TRANSITION_END,(function(){i.default(o._element).removeClass("collapsing").addClass("collapse show"),o._element.style[a]="",o.setTransitioning(!1),i.default(o._element).trigger("shown.bs.collapse")})).emulateTransitionEnd(u),this._element.style[a]=this._element[s]+"px"}}},e.hide=function(){var t=this;if(!this._isTransitioning&&i.default(this._element).hasClass("show")){var e=i.default.Event("hide.bs.collapse");if(i.default(this._element).trigger(e),!e.isDefaultPrevented()){var n=this._getDimension();this._element.style[n]=this._element.getBoundingClientRect()[n]+"px",l.reflow(this._element),i.default(this._element).addClass("collapsing").removeClass("collapse show");var o=this._triggerArray.length;if(o>0)for(var r=0;r<o;r++){var a=this._triggerArray[r],s=l.getSelectorFromElement(a);if(null!==s)i.default([].slice.call(document.querySelectorAll(s))).hasClass("show")||i.default(a).addClass("collapsed").attr("aria-expanded",!1)}this.setTransitioning(!0);this._element.style[n]="";var u=l.getTransitionDurationFromElement(this._element);i.default(this._element).one(l.TRANSITION_END,(function(){t.setTransitioning(!1),i.default(t._element).removeClass("collapsing").addClass("collapse").trigger("hidden.bs.collapse")})).emulateTransitionEnd(u)}}},e.setTransitioning=function(t){this._isTransitioning=t},e.dispose=function(){i.default.removeData(this._element,"bs.collapse"),this._config=null,this._parent=null,this._element=null,this._triggerArray=null,this._isTransitioning=null},e._getConfig=function(t){return(t=a({},T,t)).toggle=Boolean(t.toggle),l.typeCheckConfig(w,t,C),t},e._getDimension=function(){return i.default(this._element).hasClass("width")?"width":"height"},e._getParent=function(){var e,n=this;l.isElement(this._config.parent)?(e=this._config.parent,"undefined"!=typeof this._config.parent.jquery&&(e=this._config.parent[0])):e=document.querySelector(this._config.parent);var o='[data-toggle="collapse"][data-parent="'+this._config.parent+'"]',r=[].slice.call(e.querySelectorAll(o));return i.default(r).each((function(e,i){n._addAriaAndCollapsedClass(t._getTargetFromElement(i),[i])})),e},e._addAriaAndCollapsedClass=function(t,e){var n=i.default(t).hasClass("show");e.length&&i.default(e).toggleClass("collapsed",!n).attr("aria-expanded",n)},t._getTargetFromElement=function(t){var e=l.getSelectorFromElement(t);return e?document.querySelector(e):null},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this),o=n.data("bs.collapse"),r=a({},T,n.data(),"object"==typeof e&&e?e:{});if(!o&&r.toggle&&"string"==typeof e&&/show|hide/.test(e)&&(r.toggle=!1),o||(o=new t(this,r),n.data("bs.collapse",o)),"string"==typeof e){if("undefined"==typeof o[e])throw new TypeError('No method named "'+e+'"');o[e]()}}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return T}}]),t}();i.default(document).on("click.bs.collapse.data-api",'[data-toggle="collapse"]',(function(t){"A"===t.currentTarget.tagName&&t.preventDefault();var e=i.default(this),n=l.getSelectorFromElement(this),o=[].slice.call(document.querySelectorAll(n));i.default(o).each((function(){var t=i.default(this),n=t.data("bs.collapse")?"toggle":e.data();S._jQueryInterface.call(t,n)}))})),i.default.fn[w]=S._jQueryInterface,i.default.fn[w].Constructor=S,i.default.fn[w].noConflict=function(){return i.default.fn[w]=E,S._jQueryInterface};var D="undefined"!=typeof window&&"undefined"!=typeof document&&"undefined"!=typeof navigator,N=function(){for(var t=["Edge","Trident","Firefox"],e=0;e<t.length;e+=1)if(D&&navigator.userAgent.indexOf(t[e])>=0)return 1;return 0}();var k=D&&window.Promise?function(t){var e=!1;return function(){e||(e=!0,window.Promise.resolve().then((function(){e=!1,t()})))}}:function(t){var e=!1;return function(){e||(e=!0,setTimeout((function(){e=!1,t()}),N))}};function A(t){return t&&"[object Function]"==={}.toString.call(t)}function I(t,e){if(1!==t.nodeType)return[];var n=t.ownerDocument.defaultView.getComputedStyle(t,null);return e?n[e]:n}function O(t){return"HTML"===t.nodeName?t:t.parentNode||t.host}function x(t){if(!t)return document.body;switch(t.nodeName){case"HTML":case"BODY":return t.ownerDocument.body;case"#document":return t.body}var e=I(t),n=e.overflow,i=e.overflowX,o=e.overflowY;return/(auto|scroll|overlay)/.test(n+o+i)?t:x(O(t))}function j(t){return t&&t.referenceNode?t.referenceNode:t}var L=D&&!(!window.MSInputMethodContext||!document.documentMode),P=D&&/MSIE 10/.test(navigator.userAgent);function F(t){return 11===t?L:10===t?P:L||P}function R(t){if(!t)return document.documentElement;for(var e=F(10)?document.body:null,n=t.offsetParent||null;n===e&&t.nextElementSibling;)n=(t=t.nextElementSibling).offsetParent;var i=n&&n.nodeName;return i&&"BODY"!==i&&"HTML"!==i?-1!==["TH","TD","TABLE"].indexOf(n.nodeName)&&"static"===I(n,"position")?R(n):n:t?t.ownerDocument.documentElement:document.documentElement}function H(t){return null!==t.parentNode?H(t.parentNode):t}function M(t,e){if(!(t&&t.nodeType&&e&&e.nodeType))return document.documentElement;var n=t.compareDocumentPosition(e)&Node.DOCUMENT_POSITION_FOLLOWING,i=n?t:e,o=n?e:t,r=document.createRange();r.setStart(i,0),r.setEnd(o,0);var a,s,l=r.commonAncestorContainer;if(t!==l&&e!==l||i.contains(o))return"BODY"===(s=(a=l).nodeName)||"HTML"!==s&&R(a.firstElementChild)!==a?R(l):l;var u=H(t);return u.host?M(u.host,e):M(t,H(e).host)}function q(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"top",n="top"===e?"scrollTop":"scrollLeft",i=t.nodeName;if("BODY"===i||"HTML"===i){var o=t.ownerDocument.documentElement,r=t.ownerDocument.scrollingElement||o;return r[n]}return t[n]}function B(t,e){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],i=q(e,"top"),o=q(e,"left"),r=n?-1:1;return t.top+=i*r,t.bottom+=i*r,t.left+=o*r,t.right+=o*r,t}function Q(t,e){var n="x"===e?"Left":"Top",i="Left"===n?"Right":"Bottom";return parseFloat(t["border"+n+"Width"])+parseFloat(t["border"+i+"Width"])}function W(t,e,n,i){return Math.max(e["offset"+t],e["scroll"+t],n["client"+t],n["offset"+t],n["scroll"+t],F(10)?parseInt(n["offset"+t])+parseInt(i["margin"+("Height"===t?"Top":"Left")])+parseInt(i["margin"+("Height"===t?"Bottom":"Right")]):0)}function U(t){var e=t.body,n=t.documentElement,i=F(10)&&getComputedStyle(n);return{height:W("Height",e,n,i),width:W("Width",e,n,i)}}var V=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},Y=function(){function t(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(t,i.key,i)}}return function(e,n,i){return n&&t(e.prototype,n),i&&t(e,i),e}}(),z=function(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t},X=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t};function K(t){return X({},t,{right:t.left+t.width,bottom:t.top+t.height})}function G(t){var e={};try{if(F(10)){e=t.getBoundingClientRect();var n=q(t,"top"),i=q(t,"left");e.top+=n,e.left+=i,e.bottom+=n,e.right+=i}else e=t.getBoundingClientRect()}catch(t){}var o={left:e.left,top:e.top,width:e.right-e.left,height:e.bottom-e.top},r="HTML"===t.nodeName?U(t.ownerDocument):{},a=r.width||t.clientWidth||o.width,s=r.height||t.clientHeight||o.height,l=t.offsetWidth-a,u=t.offsetHeight-s;if(l||u){var f=I(t);l-=Q(f,"x"),u-=Q(f,"y"),o.width-=l,o.height-=u}return K(o)}function $(t,e){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],i=F(10),o="HTML"===e.nodeName,r=G(t),a=G(e),s=x(t),l=I(e),u=parseFloat(l.borderTopWidth),f=parseFloat(l.borderLeftWidth);n&&o&&(a.top=Math.max(a.top,0),a.left=Math.max(a.left,0));var d=K({top:r.top-a.top-u,left:r.left-a.left-f,width:r.width,height:r.height});if(d.marginTop=0,d.marginLeft=0,!i&&o){var c=parseFloat(l.marginTop),h=parseFloat(l.marginLeft);d.top-=u-c,d.bottom-=u-c,d.left-=f-h,d.right-=f-h,d.marginTop=c,d.marginLeft=h}return(i&&!n?e.contains(s):e===s&&"BODY"!==s.nodeName)&&(d=B(d,e)),d}function J(t){var e=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=t.ownerDocument.documentElement,i=$(t,n),o=Math.max(n.clientWidth,window.innerWidth||0),r=Math.max(n.clientHeight,window.innerHeight||0),a=e?0:q(n),s=e?0:q(n,"left"),l={top:a-i.top+i.marginTop,left:s-i.left+i.marginLeft,width:o,height:r};return K(l)}function Z(t){var e=t.nodeName;if("BODY"===e||"HTML"===e)return!1;if("fixed"===I(t,"position"))return!0;var n=O(t);return!!n&&Z(n)}function tt(t){if(!t||!t.parentElement||F())return document.documentElement;for(var e=t.parentElement;e&&"none"===I(e,"transform");)e=e.parentElement;return e||document.documentElement}function et(t,e,n,i){var o=arguments.length>4&&void 0!==arguments[4]&&arguments[4],r={top:0,left:0},a=o?tt(t):M(t,j(e));if("viewport"===i)r=J(a,o);else{var s=void 0;"scrollParent"===i?"BODY"===(s=x(O(e))).nodeName&&(s=t.ownerDocument.documentElement):s="window"===i?t.ownerDocument.documentElement:i;var l=$(s,a,o);if("HTML"!==s.nodeName||Z(a))r=l;else{var u=U(t.ownerDocument),f=u.height,d=u.width;r.top+=l.top-l.marginTop,r.bottom=f+l.top,r.left+=l.left-l.marginLeft,r.right=d+l.left}}var c="number"==typeof(n=n||0);return r.left+=c?n:n.left||0,r.top+=c?n:n.top||0,r.right-=c?n:n.right||0,r.bottom-=c?n:n.bottom||0,r}function nt(t){return t.width*t.height}function it(t,e,n,i,o){var r=arguments.length>5&&void 0!==arguments[5]?arguments[5]:0;if(-1===t.indexOf("auto"))return t;var a=et(n,i,r,o),s={top:{width:a.width,height:e.top-a.top},right:{width:a.right-e.right,height:a.height},bottom:{width:a.width,height:a.bottom-e.bottom},left:{width:e.left-a.left,height:a.height}},l=Object.keys(s).map((function(t){return X({key:t},s[t],{area:nt(s[t])})})).sort((function(t,e){return e.area-t.area})),u=l.filter((function(t){var e=t.width,i=t.height;return e>=n.clientWidth&&i>=n.clientHeight})),f=u.length>0?u[0].key:l[0].key,d=t.split("-")[1];return f+(d?"-"+d:"")}function ot(t,e,n){var i=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,o=i?tt(e):M(e,j(n));return $(n,o,i)}function rt(t){var e=t.ownerDocument.defaultView.getComputedStyle(t),n=parseFloat(e.marginTop||0)+parseFloat(e.marginBottom||0),i=parseFloat(e.marginLeft||0)+parseFloat(e.marginRight||0);return{width:t.offsetWidth+i,height:t.offsetHeight+n}}function at(t){var e={left:"right",right:"left",bottom:"top",top:"bottom"};return t.replace(/left|right|bottom|top/g,(function(t){return e[t]}))}function st(t,e,n){n=n.split("-")[0];var i=rt(t),o={width:i.width,height:i.height},r=-1!==["right","left"].indexOf(n),a=r?"top":"left",s=r?"left":"top",l=r?"height":"width",u=r?"width":"height";return o[a]=e[a]+e[l]/2-i[l]/2,o[s]=n===s?e[s]-i[u]:e[at(s)],o}function lt(t,e){return Array.prototype.find?t.find(e):t.filter(e)[0]}function ut(t,e,n){return(void 0===n?t:t.slice(0,function(t,e,n){if(Array.prototype.findIndex)return t.findIndex((function(t){return t[e]===n}));var i=lt(t,(function(t){return t[e]===n}));return t.indexOf(i)}(t,"name",n))).forEach((function(t){t.function&&console.warn("`modifier.function` is deprecated, use `modifier.fn`!");var n=t.function||t.fn;t.enabled&&A(n)&&(e.offsets.popper=K(e.offsets.popper),e.offsets.reference=K(e.offsets.reference),e=n(e,t))})),e}function ft(){if(!this.state.isDestroyed){var t={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:!1,offsets:{}};t.offsets.reference=ot(this.state,this.popper,this.reference,this.options.positionFixed),t.placement=it(this.options.placement,t.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding),t.originalPlacement=t.placement,t.positionFixed=this.options.positionFixed,t.offsets.popper=st(this.popper,t.offsets.reference,t.placement),t.offsets.popper.position=this.options.positionFixed?"fixed":"absolute",t=ut(this.modifiers,t),this.state.isCreated?this.options.onUpdate(t):(this.state.isCreated=!0,this.options.onCreate(t))}}function dt(t,e){return t.some((function(t){var n=t.name;return t.enabled&&n===e}))}function ct(t){for(var e=[!1,"ms","Webkit","Moz","O"],n=t.charAt(0).toUpperCase()+t.slice(1),i=0;i<e.length;i++){var o=e[i],r=o?""+o+n:t;if("undefined"!=typeof document.body.style[r])return r}return null}function ht(){return this.state.isDestroyed=!0,dt(this.modifiers,"applyStyle")&&(this.popper.removeAttribute("x-placement"),this.popper.style.position="",this.popper.style.top="",this.popper.style.left="",this.popper.style.right="",this.popper.style.bottom="",this.popper.style.willChange="",this.popper.style[ct("transform")]=""),this.disableEventListeners(),this.options.removeOnDestroy&&this.popper.parentNode.removeChild(this.popper),this}function pt(t){var e=t.ownerDocument;return e?e.defaultView:window}function mt(t,e,n,i){n.updateBound=i,pt(t).addEventListener("resize",n.updateBound,{passive:!0});var o=x(t);return function t(e,n,i,o){var r="BODY"===e.nodeName,a=r?e.ownerDocument.defaultView:e;a.addEventListener(n,i,{passive:!0}),r||t(x(a.parentNode),n,i,o),o.push(a)}(o,"scroll",n.updateBound,n.scrollParents),n.scrollElement=o,n.eventsEnabled=!0,n}function gt(){this.state.eventsEnabled||(this.state=mt(this.reference,this.options,this.state,this.scheduleUpdate))}function vt(){var t,e;this.state.eventsEnabled&&(cancelAnimationFrame(this.scheduleUpdate),this.state=(t=this.reference,e=this.state,pt(t).removeEventListener("resize",e.updateBound),e.scrollParents.forEach((function(t){t.removeEventListener("scroll",e.updateBound)})),e.updateBound=null,e.scrollParents=[],e.scrollElement=null,e.eventsEnabled=!1,e))}function _t(t){return""!==t&&!isNaN(parseFloat(t))&&isFinite(t)}function bt(t,e){Object.keys(e).forEach((function(n){var i="";-1!==["width","height","top","right","bottom","left"].indexOf(n)&&_t(e[n])&&(i="px"),t.style[n]=e[n]+i}))}var yt=D&&/Firefox/i.test(navigator.userAgent);function wt(t,e,n){var i=lt(t,(function(t){return t.name===e})),o=!!i&&t.some((function(t){return t.name===n&&t.enabled&&t.order<i.order}));if(!o){var r="`"+e+"`",a="`"+n+"`";console.warn(a+" modifier is required by "+r+" modifier in order to work, be sure to include it before "+r+"!")}return o}var Et=["auto-start","auto","auto-end","top-start","top","top-end","right-start","right","right-end","bottom-end","bottom","bottom-start","left-end","left","left-start"],Tt=Et.slice(3);function Ct(t){var e=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=Tt.indexOf(t),i=Tt.slice(n+1).concat(Tt.slice(0,n));return e?i.reverse():i}var St="flip",Dt="clockwise",Nt="counterclockwise";function kt(t,e,n,i){var o=[0,0],r=-1!==["right","left"].indexOf(i),a=t.split(/(\+|\-)/).map((function(t){return t.trim()})),s=a.indexOf(lt(a,(function(t){return-1!==t.search(/,|\s/)})));a[s]&&-1===a[s].indexOf(",")&&console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");var l=/\s*,\s*|\s+/,u=-1!==s?[a.slice(0,s).concat([a[s].split(l)[0]]),[a[s].split(l)[1]].concat(a.slice(s+1))]:[a];return(u=u.map((function(t,i){var o=(1===i?!r:r)?"height":"width",a=!1;return t.reduce((function(t,e){return""===t[t.length-1]&&-1!==["+","-"].indexOf(e)?(t[t.length-1]=e,a=!0,t):a?(t[t.length-1]+=e,a=!1,t):t.concat(e)}),[]).map((function(t){return function(t,e,n,i){var o=t.match(/((?:\-|\+)?\d*\.?\d*)(.*)/),r=+o[1],a=o[2];if(!r)return t;if(0===a.indexOf("%")){var s=void 0;switch(a){case"%p":s=n;break;case"%":case"%r":default:s=i}return K(s)[e]/100*r}if("vh"===a||"vw"===a)return("vh"===a?Math.max(document.documentElement.clientHeight,window.innerHeight||0):Math.max(document.documentElement.clientWidth,window.innerWidth||0))/100*r;return r}(t,o,e,n)}))}))).forEach((function(t,e){t.forEach((function(n,i){_t(n)&&(o[e]+=n*("-"===t[i-1]?-1:1))}))})),o}var At={placement:"bottom",positionFixed:!1,eventsEnabled:!0,removeOnDestroy:!1,onCreate:function(){},onUpdate:function(){},modifiers:{shift:{order:100,enabled:!0,fn:function(t){var e=t.placement,n=e.split("-")[0],i=e.split("-")[1];if(i){var o=t.offsets,r=o.reference,a=o.popper,s=-1!==["bottom","top"].indexOf(n),l=s?"left":"top",u=s?"width":"height",f={start:z({},l,r[l]),end:z({},l,r[l]+r[u]-a[u])};t.offsets.popper=X({},a,f[i])}return t}},offset:{order:200,enabled:!0,fn:function(t,e){var n=e.offset,i=t.placement,o=t.offsets,r=o.popper,a=o.reference,s=i.split("-")[0],l=void 0;return l=_t(+n)?[+n,0]:kt(n,r,a,s),"left"===s?(r.top+=l[0],r.left-=l[1]):"right"===s?(r.top+=l[0],r.left+=l[1]):"top"===s?(r.left+=l[0],r.top-=l[1]):"bottom"===s&&(r.left+=l[0],r.top+=l[1]),t.popper=r,t},offset:0},preventOverflow:{order:300,enabled:!0,fn:function(t,e){var n=e.boundariesElement||R(t.instance.popper);t.instance.reference===n&&(n=R(n));var i=ct("transform"),o=t.instance.popper.style,r=o.top,a=o.left,s=o[i];o.top="",o.left="",o[i]="";var l=et(t.instance.popper,t.instance.reference,e.padding,n,t.positionFixed);o.top=r,o.left=a,o[i]=s,e.boundaries=l;var u=e.priority,f=t.offsets.popper,d={primary:function(t){var n=f[t];return f[t]<l[t]&&!e.escapeWithReference&&(n=Math.max(f[t],l[t])),z({},t,n)},secondary:function(t){var n="right"===t?"left":"top",i=f[n];return f[t]>l[t]&&!e.escapeWithReference&&(i=Math.min(f[n],l[t]-("right"===t?f.width:f.height))),z({},n,i)}};return u.forEach((function(t){var e=-1!==["left","top"].indexOf(t)?"primary":"secondary";f=X({},f,d[e](t))})),t.offsets.popper=f,t},priority:["left","right","top","bottom"],padding:5,boundariesElement:"scrollParent"},keepTogether:{order:400,enabled:!0,fn:function(t){var e=t.offsets,n=e.popper,i=e.reference,o=t.placement.split("-")[0],r=Math.floor,a=-1!==["top","bottom"].indexOf(o),s=a?"right":"bottom",l=a?"left":"top",u=a?"width":"height";return n[s]<r(i[l])&&(t.offsets.popper[l]=r(i[l])-n[u]),n[l]>r(i[s])&&(t.offsets.popper[l]=r(i[s])),t}},arrow:{order:500,enabled:!0,fn:function(t,e){var n;if(!wt(t.instance.modifiers,"arrow","keepTogether"))return t;var i=e.element;if("string"==typeof i){if(!(i=t.instance.popper.querySelector(i)))return t}else if(!t.instance.popper.contains(i))return console.warn("WARNING: `arrow.element` must be child of its popper element!"),t;var o=t.placement.split("-")[0],r=t.offsets,a=r.popper,s=r.reference,l=-1!==["left","right"].indexOf(o),u=l?"height":"width",f=l?"Top":"Left",d=f.toLowerCase(),c=l?"left":"top",h=l?"bottom":"right",p=rt(i)[u];s[h]-p<a[d]&&(t.offsets.popper[d]-=a[d]-(s[h]-p)),s[d]+p>a[h]&&(t.offsets.popper[d]+=s[d]+p-a[h]),t.offsets.popper=K(t.offsets.popper);var m=s[d]+s[u]/2-p/2,g=I(t.instance.popper),v=parseFloat(g["margin"+f]),_=parseFloat(g["border"+f+"Width"]),b=m-t.offsets.popper[d]-v-_;return b=Math.max(Math.min(a[u]-p,b),0),t.arrowElement=i,t.offsets.arrow=(z(n={},d,Math.round(b)),z(n,c,""),n),t},element:"[x-arrow]"},flip:{order:600,enabled:!0,fn:function(t,e){if(dt(t.instance.modifiers,"inner"))return t;if(t.flipped&&t.placement===t.originalPlacement)return t;var n=et(t.instance.popper,t.instance.reference,e.padding,e.boundariesElement,t.positionFixed),i=t.placement.split("-")[0],o=at(i),r=t.placement.split("-")[1]||"",a=[];switch(e.behavior){case St:a=[i,o];break;case Dt:a=Ct(i);break;case Nt:a=Ct(i,!0);break;default:a=e.behavior}return a.forEach((function(s,l){if(i!==s||a.length===l+1)return t;i=t.placement.split("-")[0],o=at(i);var u=t.offsets.popper,f=t.offsets.reference,d=Math.floor,c="left"===i&&d(u.right)>d(f.left)||"right"===i&&d(u.left)<d(f.right)||"top"===i&&d(u.bottom)>d(f.top)||"bottom"===i&&d(u.top)<d(f.bottom),h=d(u.left)<d(n.left),p=d(u.right)>d(n.right),m=d(u.top)<d(n.top),g=d(u.bottom)>d(n.bottom),v="left"===i&&h||"right"===i&&p||"top"===i&&m||"bottom"===i&&g,_=-1!==["top","bottom"].indexOf(i),b=!!e.flipVariations&&(_&&"start"===r&&h||_&&"end"===r&&p||!_&&"start"===r&&m||!_&&"end"===r&&g),y=!!e.flipVariationsByContent&&(_&&"start"===r&&p||_&&"end"===r&&h||!_&&"start"===r&&g||!_&&"end"===r&&m),w=b||y;(c||v||w)&&(t.flipped=!0,(c||v)&&(i=a[l+1]),w&&(r=function(t){return"end"===t?"start":"start"===t?"end":t}(r)),t.placement=i+(r?"-"+r:""),t.offsets.popper=X({},t.offsets.popper,st(t.instance.popper,t.offsets.reference,t.placement)),t=ut(t.instance.modifiers,t,"flip"))})),t},behavior:"flip",padding:5,boundariesElement:"viewport",flipVariations:!1,flipVariationsByContent:!1},inner:{order:700,enabled:!1,fn:function(t){var e=t.placement,n=e.split("-")[0],i=t.offsets,o=i.popper,r=i.reference,a=-1!==["left","right"].indexOf(n),s=-1===["top","left"].indexOf(n);return o[a?"left":"top"]=r[n]-(s?o[a?"width":"height"]:0),t.placement=at(e),t.offsets.popper=K(o),t}},hide:{order:800,enabled:!0,fn:function(t){if(!wt(t.instance.modifiers,"hide","preventOverflow"))return t;var e=t.offsets.reference,n=lt(t.instance.modifiers,(function(t){return"preventOverflow"===t.name})).boundaries;if(e.bottom<n.top||e.left>n.right||e.top>n.bottom||e.right<n.left){if(!0===t.hide)return t;t.hide=!0,t.attributes["x-out-of-boundaries"]=""}else{if(!1===t.hide)return t;t.hide=!1,t.attributes["x-out-of-boundaries"]=!1}return t}},computeStyle:{order:850,enabled:!0,fn:function(t,e){var n=e.x,i=e.y,o=t.offsets.popper,r=lt(t.instance.modifiers,(function(t){return"applyStyle"===t.name})).gpuAcceleration;void 0!==r&&console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");var a=void 0!==r?r:e.gpuAcceleration,s=R(t.instance.popper),l=G(s),u={position:o.position},f=function(t,e){var n=t.offsets,i=n.popper,o=n.reference,r=Math.round,a=Math.floor,s=function(t){return t},l=r(o.width),u=r(i.width),f=-1!==["left","right"].indexOf(t.placement),d=-1!==t.placement.indexOf("-"),c=e?f||d||l%2==u%2?r:a:s,h=e?r:s;return{left:c(l%2==1&&u%2==1&&!d&&e?i.left-1:i.left),top:h(i.top),bottom:h(i.bottom),right:c(i.right)}}(t,window.devicePixelRatio<2||!yt),d="bottom"===n?"top":"bottom",c="right"===i?"left":"right",h=ct("transform"),p=void 0,m=void 0;if(m="bottom"===d?"HTML"===s.nodeName?-s.clientHeight+f.bottom:-l.height+f.bottom:f.top,p="right"===c?"HTML"===s.nodeName?-s.clientWidth+f.right:-l.width+f.right:f.left,a&&h)u[h]="translate3d("+p+"px, "+m+"px, 0)",u[d]=0,u[c]=0,u.willChange="transform";else{var g="bottom"===d?-1:1,v="right"===c?-1:1;u[d]=m*g,u[c]=p*v,u.willChange=d+", "+c}var _={"x-placement":t.placement};return t.attributes=X({},_,t.attributes),t.styles=X({},u,t.styles),t.arrowStyles=X({},t.offsets.arrow,t.arrowStyles),t},gpuAcceleration:!0,x:"bottom",y:"right"},applyStyle:{order:900,enabled:!0,fn:function(t){var e,n;return bt(t.instance.popper,t.styles),e=t.instance.popper,n=t.attributes,Object.keys(n).forEach((function(t){!1!==n[t]?e.setAttribute(t,n[t]):e.removeAttribute(t)})),t.arrowElement&&Object.keys(t.arrowStyles).length&&bt(t.arrowElement,t.arrowStyles),t},onLoad:function(t,e,n,i,o){var r=ot(o,e,t,n.positionFixed),a=it(n.placement,r,e,t,n.modifiers.flip.boundariesElement,n.modifiers.flip.padding);return e.setAttribute("x-placement",a),bt(e,{position:n.positionFixed?"fixed":"absolute"}),n},gpuAcceleration:void 0}}},It=function(){function t(e,n){var i=this,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};V(this,t),this.scheduleUpdate=function(){return requestAnimationFrame(i.update)},this.update=k(this.update.bind(this)),this.options=X({},t.Defaults,o),this.state={isDestroyed:!1,isCreated:!1,scrollParents:[]},this.reference=e&&e.jquery?e[0]:e,this.popper=n&&n.jquery?n[0]:n,this.options.modifiers={},Object.keys(X({},t.Defaults.modifiers,o.modifiers)).forEach((function(e){i.options.modifiers[e]=X({},t.Defaults.modifiers[e]||{},o.modifiers?o.modifiers[e]:{})})),this.modifiers=Object.keys(this.options.modifiers).map((function(t){return X({name:t},i.options.modifiers[t])})).sort((function(t,e){return t.order-e.order})),this.modifiers.forEach((function(t){t.enabled&&A(t.onLoad)&&t.onLoad(i.reference,i.popper,i.options,t,i.state)})),this.update();var r=this.options.eventsEnabled;r&&this.enableEventListeners(),this.state.eventsEnabled=r}return Y(t,[{key:"update",value:function(){return ft.call(this)}},{key:"destroy",value:function(){return ht.call(this)}},{key:"enableEventListeners",value:function(){return gt.call(this)}},{key:"disableEventListeners",value:function(){return vt.call(this)}}]),t}();It.Utils=("undefined"!=typeof window?window:global).PopperUtils,It.placements=Et,It.Defaults=At;var Ot="dropdown",xt=i.default.fn[Ot],jt=new RegExp("38|40|27"),Lt={offset:0,flip:!0,boundary:"scrollParent",reference:"toggle",display:"dynamic",popperConfig:null},Pt={offset:"(number|string|function)",flip:"boolean",boundary:"(string|element)",reference:"(string|element)",display:"string",popperConfig:"(null|object)"},Ft=function(){function t(t,e){this._element=t,this._popper=null,this._config=this._getConfig(e),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar(),this._addEventListeners()}var e=t.prototype;return e.toggle=function(){if(!this._element.disabled&&!i.default(this._element).hasClass("disabled")){var e=i.default(this._menu).hasClass("show");t._clearMenus(),e||this.show(!0)}},e.show=function(e){if(void 0===e&&(e=!1),!(this._element.disabled||i.default(this._element).hasClass("disabled")||i.default(this._menu).hasClass("show"))){var n={relatedTarget:this._element},o=i.default.Event("show.bs.dropdown",n),r=t._getParentFromElement(this._element);if(i.default(r).trigger(o),!o.isDefaultPrevented()){if(!this._inNavbar&&e){if("undefined"==typeof It)throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org)");var a=this._element;"parent"===this._config.reference?a=r:l.isElement(this._config.reference)&&(a=this._config.reference,"undefined"!=typeof this._config.reference.jquery&&(a=this._config.reference[0])),"scrollParent"!==this._config.boundary&&i.default(r).addClass("position-static"),this._popper=new It(a,this._menu,this._getPopperConfig())}"ontouchstart"in document.documentElement&&0===i.default(r).closest(".navbar-nav").length&&i.default(document.body).children().on("mouseover",null,i.default.noop),this._element.focus(),this._element.setAttribute("aria-expanded",!0),i.default(this._menu).toggleClass("show"),i.default(r).toggleClass("show").trigger(i.default.Event("shown.bs.dropdown",n))}}},e.hide=function(){if(!this._element.disabled&&!i.default(this._element).hasClass("disabled")&&i.default(this._menu).hasClass("show")){var e={relatedTarget:this._element},n=i.default.Event("hide.bs.dropdown",e),o=t._getParentFromElement(this._element);i.default(o).trigger(n),n.isDefaultPrevented()||(this._popper&&this._popper.destroy(),i.default(this._menu).toggleClass("show"),i.default(o).toggleClass("show").trigger(i.default.Event("hidden.bs.dropdown",e)))}},e.dispose=function(){i.default.removeData(this._element,"bs.dropdown"),i.default(this._element).off(".bs.dropdown"),this._element=null,this._menu=null,null!==this._popper&&(this._popper.destroy(),this._popper=null)},e.update=function(){this._inNavbar=this._detectNavbar(),null!==this._popper&&this._popper.scheduleUpdate()},e._addEventListeners=function(){var t=this;i.default(this._element).on("click.bs.dropdown",(function(e){e.preventDefault(),e.stopPropagation(),t.toggle()}))},e._getConfig=function(t){return t=a({},this.constructor.Default,i.default(this._element).data(),t),l.typeCheckConfig(Ot,t,this.constructor.DefaultType),t},e._getMenuElement=function(){if(!this._menu){var e=t._getParentFromElement(this._element);e&&(this._menu=e.querySelector(".dropdown-menu"))}return this._menu},e._getPlacement=function(){var t=i.default(this._element.parentNode),e="bottom-start";return t.hasClass("dropup")?e=i.default(this._menu).hasClass("dropdown-menu-right")?"top-end":"top-start":t.hasClass("dropright")?e="right-start":t.hasClass("dropleft")?e="left-start":i.default(this._menu).hasClass("dropdown-menu-right")&&(e="bottom-end"),e},e._detectNavbar=function(){return i.default(this._element).closest(".navbar").length>0},e._getOffset=function(){var t=this,e={};return"function"==typeof this._config.offset?e.fn=function(e){return e.offsets=a({},e.offsets,t._config.offset(e.offsets,t._element)||{}),e}:e.offset=this._config.offset,e},e._getPopperConfig=function(){var t={placement:this._getPlacement(),modifiers:{offset:this._getOffset(),flip:{enabled:this._config.flip},preventOverflow:{boundariesElement:this._config.boundary}}};return"static"===this._config.display&&(t.modifiers.applyStyle={enabled:!1}),a({},t,this._config.popperConfig)},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this).data("bs.dropdown");if(n||(n=new t(this,"object"==typeof e?e:null),i.default(this).data("bs.dropdown",n)),"string"==typeof e){if("undefined"==typeof n[e])throw new TypeError('No method named "'+e+'"');n[e]()}}))},t._clearMenus=function(e){if(!e||3!==e.which&&("keyup"!==e.type||9===e.which))for(var n=[].slice.call(document.querySelectorAll('[data-toggle="dropdown"]')),o=0,r=n.length;o<r;o++){var a=t._getParentFromElement(n[o]),s=i.default(n[o]).data("bs.dropdown"),l={relatedTarget:n[o]};if(e&&"click"===e.type&&(l.clickEvent=e),s){var u=s._menu;if(i.default(a).hasClass("show")&&!(e&&("click"===e.type&&/input|textarea/i.test(e.target.tagName)||"keyup"===e.type&&9===e.which)&&i.default.contains(a,e.target))){var f=i.default.Event("hide.bs.dropdown",l);i.default(a).trigger(f),f.isDefaultPrevented()||("ontouchstart"in document.documentElement&&i.default(document.body).children().off("mouseover",null,i.default.noop),n[o].setAttribute("aria-expanded","false"),s._popper&&s._popper.destroy(),i.default(u).removeClass("show"),i.default(a).removeClass("show").trigger(i.default.Event("hidden.bs.dropdown",l)))}}}},t._getParentFromElement=function(t){var e,n=l.getSelectorFromElement(t);return n&&(e=document.querySelector(n)),e||t.parentNode},t._dataApiKeydownHandler=function(e){if(!(/input|textarea/i.test(e.target.tagName)?32===e.which||27!==e.which&&(40!==e.which&&38!==e.which||i.default(e.target).closest(".dropdown-menu").length):!jt.test(e.which))&&!this.disabled&&!i.default(this).hasClass("disabled")){var n=t._getParentFromElement(this),o=i.default(n).hasClass("show");if(o||27!==e.which){if(e.preventDefault(),e.stopPropagation(),!o||27===e.which||32===e.which)return 27===e.which&&i.default(n.querySelector('[data-toggle="dropdown"]')).trigger("focus"),void i.default(this).trigger("click");var r=[].slice.call(n.querySelectorAll(".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)")).filter((function(t){return i.default(t).is(":visible")}));if(0!==r.length){var a=r.indexOf(e.target);38===e.which&&a>0&&a--,40===e.which&&a<r.length-1&&a++,a<0&&(a=0),r[a].focus()}}}},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return Lt}},{key:"DefaultType",get:function(){return Pt}}]),t}();i.default(document).on("keydown.bs.dropdown.data-api",'[data-toggle="dropdown"]',Ft._dataApiKeydownHandler).on("keydown.bs.dropdown.data-api",".dropdown-menu",Ft._dataApiKeydownHandler).on("click.bs.dropdown.data-api keyup.bs.dropdown.data-api",Ft._clearMenus).on("click.bs.dropdown.data-api",'[data-toggle="dropdown"]',(function(t){t.preventDefault(),t.stopPropagation(),Ft._jQueryInterface.call(i.default(this),"toggle")})).on("click.bs.dropdown.data-api",".dropdown form",(function(t){t.stopPropagation()})),i.default.fn[Ot]=Ft._jQueryInterface,i.default.fn[Ot].Constructor=Ft,i.default.fn[Ot].noConflict=function(){return i.default.fn[Ot]=xt,Ft._jQueryInterface};var Rt=i.default.fn.modal,Ht={backdrop:!0,keyboard:!0,focus:!0,show:!0},Mt={backdrop:"(boolean|string)",keyboard:"boolean",focus:"boolean",show:"boolean"},qt=function(){function t(t,e){this._config=this._getConfig(e),this._element=t,this._dialog=t.querySelector(".modal-dialog"),this._backdrop=null,this._isShown=!1,this._isBodyOverflowing=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1,this._scrollbarWidth=0}var e=t.prototype;return e.toggle=function(t){return this._isShown?this.hide():this.show(t)},e.show=function(t){var e=this;if(!this._isShown&&!this._isTransitioning){i.default(this._element).hasClass("fade")&&(this._isTransitioning=!0);var n=i.default.Event("show.bs.modal",{relatedTarget:t});i.default(this._element).trigger(n),this._isShown||n.isDefaultPrevented()||(this._isShown=!0,this._checkScrollbar(),this._setScrollbar(),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),i.default(this._element).on("click.dismiss.bs.modal",'[data-dismiss="modal"]',(function(t){return e.hide(t)})),i.default(this._dialog).on("mousedown.dismiss.bs.modal",(function(){i.default(e._element).one("mouseup.dismiss.bs.modal",(function(t){i.default(t.target).is(e._element)&&(e._ignoreBackdropClick=!0)}))})),this._showBackdrop((function(){return e._showElement(t)})))}},e.hide=function(t){var e=this;if(t&&t.preventDefault(),this._isShown&&!this._isTransitioning){var n=i.default.Event("hide.bs.modal");if(i.default(this._element).trigger(n),this._isShown&&!n.isDefaultPrevented()){this._isShown=!1;var o=i.default(this._element).hasClass("fade");if(o&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),i.default(document).off("focusin.bs.modal"),i.default(this._element).removeClass("show"),i.default(this._element).off("click.dismiss.bs.modal"),i.default(this._dialog).off("mousedown.dismiss.bs.modal"),o){var r=l.getTransitionDurationFromElement(this._element);i.default(this._element).one(l.TRANSITION_END,(function(t){return e._hideModal(t)})).emulateTransitionEnd(r)}else this._hideModal()}}},e.dispose=function(){[window,this._element,this._dialog].forEach((function(t){return i.default(t).off(".bs.modal")})),i.default(document).off("focusin.bs.modal"),i.default.removeData(this._element,"bs.modal"),this._config=null,this._element=null,this._dialog=null,this._backdrop=null,this._isShown=null,this._isBodyOverflowing=null,this._ignoreBackdropClick=null,this._isTransitioning=null,this._scrollbarWidth=null},e.handleUpdate=function(){this._adjustDialog()},e._getConfig=function(t){return t=a({},Ht,t),l.typeCheckConfig("modal",t,Mt),t},e._triggerBackdropTransition=function(){var t=this,e=i.default.Event("hidePrevented.bs.modal");if(i.default(this._element).trigger(e),!e.isDefaultPrevented()){var n=this._element.scrollHeight>document.documentElement.clientHeight;n||(this._element.style.overflowY="hidden"),this._element.classList.add("modal-static");var o=l.getTransitionDurationFromElement(this._dialog);i.default(this._element).off(l.TRANSITION_END),i.default(this._element).one(l.TRANSITION_END,(function(){t._element.classList.remove("modal-static"),n||i.default(t._element).one(l.TRANSITION_END,(function(){t._element.style.overflowY=""})).emulateTransitionEnd(t._element,o)})).emulateTransitionEnd(o),this._element.focus()}},e._showElement=function(t){var e=this,n=i.default(this._element).hasClass("fade"),o=this._dialog?this._dialog.querySelector(".modal-body"):null;this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||document.body.appendChild(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),i.default(this._dialog).hasClass("modal-dialog-scrollable")&&o?o.scrollTop=0:this._element.scrollTop=0,n&&l.reflow(this._element),i.default(this._element).addClass("show"),this._config.focus&&this._enforceFocus();var r=i.default.Event("shown.bs.modal",{relatedTarget:t}),a=function(){e._config.focus&&e._element.focus(),e._isTransitioning=!1,i.default(e._element).trigger(r)};if(n){var s=l.getTransitionDurationFromElement(this._dialog);i.default(this._dialog).one(l.TRANSITION_END,a).emulateTransitionEnd(s)}else a()},e._enforceFocus=function(){var t=this;i.default(document).off("focusin.bs.modal").on("focusin.bs.modal",(function(e){document!==e.target&&t._element!==e.target&&0===i.default(t._element).has(e.target).length&&t._element.focus()}))},e._setEscapeEvent=function(){var t=this;this._isShown?i.default(this._element).on("keydown.dismiss.bs.modal",(function(e){t._config.keyboard&&27===e.which?(e.preventDefault(),t.hide()):t._config.keyboard||27!==e.which||t._triggerBackdropTransition()})):this._isShown||i.default(this._element).off("keydown.dismiss.bs.modal")},e._setResizeEvent=function(){var t=this;this._isShown?i.default(window).on("resize.bs.modal",(function(e){return t.handleUpdate(e)})):i.default(window).off("resize.bs.modal")},e._hideModal=function(){var t=this;this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._isTransitioning=!1,this._showBackdrop((function(){i.default(document.body).removeClass("modal-open"),t._resetAdjustments(),t._resetScrollbar(),i.default(t._element).trigger("hidden.bs.modal")}))},e._removeBackdrop=function(){this._backdrop&&(i.default(this._backdrop).remove(),this._backdrop=null)},e._showBackdrop=function(t){var e=this,n=i.default(this._element).hasClass("fade")?"fade":"";if(this._isShown&&this._config.backdrop){if(this._backdrop=document.createElement("div"),this._backdrop.className="modal-backdrop",n&&this._backdrop.classList.add(n),i.default(this._backdrop).appendTo(document.body),i.default(this._element).on("click.dismiss.bs.modal",(function(t){e._ignoreBackdropClick?e._ignoreBackdropClick=!1:t.target===t.currentTarget&&("static"===e._config.backdrop?e._triggerBackdropTransition():e.hide())})),n&&l.reflow(this._backdrop),i.default(this._backdrop).addClass("show"),!t)return;if(!n)return void t();var o=l.getTransitionDurationFromElement(this._backdrop);i.default(this._backdrop).one(l.TRANSITION_END,t).emulateTransitionEnd(o)}else if(!this._isShown&&this._backdrop){i.default(this._backdrop).removeClass("show");var r=function(){e._removeBackdrop(),t&&t()};if(i.default(this._element).hasClass("fade")){var a=l.getTransitionDurationFromElement(this._backdrop);i.default(this._backdrop).one(l.TRANSITION_END,r).emulateTransitionEnd(a)}else r()}else t&&t()},e._adjustDialog=function(){var t=this._element.scrollHeight>document.documentElement.clientHeight;!this._isBodyOverflowing&&t&&(this._element.style.paddingLeft=this._scrollbarWidth+"px"),this._isBodyOverflowing&&!t&&(this._element.style.paddingRight=this._scrollbarWidth+"px")},e._resetAdjustments=function(){this._element.style.paddingLeft="",this._element.style.paddingRight=""},e._checkScrollbar=function(){var t=document.body.getBoundingClientRect();this._isBodyOverflowing=Math.round(t.left+t.right)<window.innerWidth,this._scrollbarWidth=this._getScrollbarWidth()},e._setScrollbar=function(){var t=this;if(this._isBodyOverflowing){var e=[].slice.call(document.querySelectorAll(".fixed-top, .fixed-bottom, .is-fixed, .sticky-top")),n=[].slice.call(document.querySelectorAll(".sticky-top"));i.default(e).each((function(e,n){var o=n.style.paddingRight,r=i.default(n).css("padding-right");i.default(n).data("padding-right",o).css("padding-right",parseFloat(r)+t._scrollbarWidth+"px")})),i.default(n).each((function(e,n){var o=n.style.marginRight,r=i.default(n).css("margin-right");i.default(n).data("margin-right",o).css("margin-right",parseFloat(r)-t._scrollbarWidth+"px")}));var o=document.body.style.paddingRight,r=i.default(document.body).css("padding-right");i.default(document.body).data("padding-right",o).css("padding-right",parseFloat(r)+this._scrollbarWidth+"px")}i.default(document.body).addClass("modal-open")},e._resetScrollbar=function(){var t=[].slice.call(document.querySelectorAll(".fixed-top, .fixed-bottom, .is-fixed, .sticky-top"));i.default(t).each((function(t,e){var n=i.default(e).data("padding-right");i.default(e).removeData("padding-right"),e.style.paddingRight=n||""}));var e=[].slice.call(document.querySelectorAll(".sticky-top"));i.default(e).each((function(t,e){var n=i.default(e).data("margin-right");"undefined"!=typeof n&&i.default(e).css("margin-right",n).removeData("margin-right")}));var n=i.default(document.body).data("padding-right");i.default(document.body).removeData("padding-right"),document.body.style.paddingRight=n||""},e._getScrollbarWidth=function(){var t=document.createElement("div");t.className="modal-scrollbar-measure",document.body.appendChild(t);var e=t.getBoundingClientRect().width-t.clientWidth;return document.body.removeChild(t),e},t._jQueryInterface=function(e,n){return this.each((function(){var o=i.default(this).data("bs.modal"),r=a({},Ht,i.default(this).data(),"object"==typeof e&&e?e:{});if(o||(o=new t(this,r),i.default(this).data("bs.modal",o)),"string"==typeof e){if("undefined"==typeof o[e])throw new TypeError('No method named "'+e+'"');o[e](n)}else r.show&&o.show(n)}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return Ht}}]),t}();i.default(document).on("click.bs.modal.data-api",'[data-toggle="modal"]',(function(t){var e,n=this,o=l.getSelectorFromElement(this);o&&(e=document.querySelector(o));var r=i.default(e).data("bs.modal")?"toggle":a({},i.default(e).data(),i.default(this).data());"A"!==this.tagName&&"AREA"!==this.tagName||t.preventDefault();var s=i.default(e).one("show.bs.modal",(function(t){t.isDefaultPrevented()||s.one("hidden.bs.modal",(function(){i.default(n).is(":visible")&&n.focus()}))}));qt._jQueryInterface.call(i.default(e),r,this)})),i.default.fn.modal=qt._jQueryInterface,i.default.fn.modal.Constructor=qt,i.default.fn.modal.noConflict=function(){return i.default.fn.modal=Rt,qt._jQueryInterface};var Bt=["background","cite","href","itemtype","longdesc","poster","src","xlink:href"],Qt={"*":["class","dir","id","lang","role",/^aria-[\w-]*$/i],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","srcset","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]},Wt=/^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/gi,Ut=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;function Vt(t,e,n){if(0===t.length)return t;if(n&&"function"==typeof n)return n(t);for(var i=(new window.DOMParser).parseFromString(t,"text/html"),o=Object.keys(e),r=[].slice.call(i.body.querySelectorAll("*")),a=function(t,n){var i=r[t],a=i.nodeName.toLowerCase();if(-1===o.indexOf(i.nodeName.toLowerCase()))return i.parentNode.removeChild(i),"continue";var s=[].slice.call(i.attributes),l=[].concat(e["*"]||[],e[a]||[]);s.forEach((function(t){(function(t,e){var n=t.nodeName.toLowerCase();if(-1!==e.indexOf(n))return-1===Bt.indexOf(n)||Boolean(t.nodeValue.match(Wt)||t.nodeValue.match(Ut));for(var i=e.filter((function(t){return t instanceof RegExp})),o=0,r=i.length;o<r;o++)if(n.match(i[o]))return!0;return!1})(t,l)||i.removeAttribute(t.nodeName)}))},s=0,l=r.length;s<l;s++)a(s);return i.body.innerHTML}var Yt="tooltip",zt=i.default.fn[Yt],Xt=new RegExp("(^|\\s)bs-tooltip\\S+","g"),Kt=["sanitize","whiteList","sanitizeFn"],Gt={animation:"boolean",template:"string",title:"(string|element|function)",trigger:"string",delay:"(number|object)",html:"boolean",selector:"(string|boolean)",placement:"(string|function)",offset:"(number|string|function)",container:"(string|element|boolean)",fallbackPlacement:"(string|array)",boundary:"(string|element)",customClass:"(string|function)",sanitize:"boolean",sanitizeFn:"(null|function)",whiteList:"object",popperConfig:"(null|object)"},$t={AUTO:"auto",TOP:"top",RIGHT:"right",BOTTOM:"bottom",LEFT:"left"},Jt={animation:!0,template:'<div class="tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,selector:!1,placement:"top",offset:0,container:!1,fallbackPlacement:"flip",boundary:"scrollParent",customClass:"",sanitize:!0,sanitizeFn:null,whiteList:Qt,popperConfig:null},Zt={HIDE:"hide.bs.tooltip",HIDDEN:"hidden.bs.tooltip",SHOW:"show.bs.tooltip",SHOWN:"shown.bs.tooltip",INSERTED:"inserted.bs.tooltip",CLICK:"click.bs.tooltip",FOCUSIN:"focusin.bs.tooltip",FOCUSOUT:"focusout.bs.tooltip",MOUSEENTER:"mouseenter.bs.tooltip",MOUSELEAVE:"mouseleave.bs.tooltip"},te=function(){function t(t,e){if("undefined"==typeof It)throw new TypeError("Bootstrap's tooltips require Popper (https://popper.js.org)");this._isEnabled=!0,this._timeout=0,this._hoverState="",this._activeTrigger={},this._popper=null,this.element=t,this.config=this._getConfig(e),this.tip=null,this._setListeners()}var e=t.prototype;return e.enable=function(){this._isEnabled=!0},e.disable=function(){this._isEnabled=!1},e.toggleEnabled=function(){this._isEnabled=!this._isEnabled},e.toggle=function(t){if(this._isEnabled)if(t){var e=this.constructor.DATA_KEY,n=i.default(t.currentTarget).data(e);n||(n=new this.constructor(t.currentTarget,this._getDelegateConfig()),i.default(t.currentTarget).data(e,n)),n._activeTrigger.click=!n._activeTrigger.click,n._isWithActiveTrigger()?n._enter(null,n):n._leave(null,n)}else{if(i.default(this.getTipElement()).hasClass("show"))return void this._leave(null,this);this._enter(null,this)}},e.dispose=function(){clearTimeout(this._timeout),i.default.removeData(this.element,this.constructor.DATA_KEY),i.default(this.element).off(this.constructor.EVENT_KEY),i.default(this.element).closest(".modal").off("hide.bs.modal",this._hideModalHandler),this.tip&&i.default(this.tip).remove(),this._isEnabled=null,this._timeout=null,this._hoverState=null,this._activeTrigger=null,this._popper&&this._popper.destroy(),this._popper=null,this.element=null,this.config=null,this.tip=null},e.show=function(){var t=this;if("none"===i.default(this.element).css("display"))throw new Error("Please use show on visible elements");var e=i.default.Event(this.constructor.Event.SHOW);if(this.isWithContent()&&this._isEnabled){i.default(this.element).trigger(e);var n=l.findShadowRoot(this.element),o=i.default.contains(null!==n?n:this.element.ownerDocument.documentElement,this.element);if(e.isDefaultPrevented()||!o)return;var r=this.getTipElement(),a=l.getUID(this.constructor.NAME);r.setAttribute("id",a),this.element.setAttribute("aria-describedby",a),this.setContent(),this.config.animation&&i.default(r).addClass("fade");var s="function"==typeof this.config.placement?this.config.placement.call(this,r,this.element):this.config.placement,u=this._getAttachment(s);this.addAttachmentClass(u);var f=this._getContainer();i.default(r).data(this.constructor.DATA_KEY,this),i.default.contains(this.element.ownerDocument.documentElement,this.tip)||i.default(r).appendTo(f),i.default(this.element).trigger(this.constructor.Event.INSERTED),this._popper=new It(this.element,r,this._getPopperConfig(u)),i.default(r).addClass("show"),i.default(r).addClass(this.config.customClass),"ontouchstart"in document.documentElement&&i.default(document.body).children().on("mouseover",null,i.default.noop);var d=function(){t.config.animation&&t._fixTransition();var e=t._hoverState;t._hoverState=null,i.default(t.element).trigger(t.constructor.Event.SHOWN),"out"===e&&t._leave(null,t)};if(i.default(this.tip).hasClass("fade")){var c=l.getTransitionDurationFromElement(this.tip);i.default(this.tip).one(l.TRANSITION_END,d).emulateTransitionEnd(c)}else d()}},e.hide=function(t){var e=this,n=this.getTipElement(),o=i.default.Event(this.constructor.Event.HIDE),r=function(){"show"!==e._hoverState&&n.parentNode&&n.parentNode.removeChild(n),e._cleanTipClass(),e.element.removeAttribute("aria-describedby"),i.default(e.element).trigger(e.constructor.Event.HIDDEN),null!==e._popper&&e._popper.destroy(),t&&t()};if(i.default(this.element).trigger(o),!o.isDefaultPrevented()){if(i.default(n).removeClass("show"),"ontouchstart"in document.documentElement&&i.default(document.body).children().off("mouseover",null,i.default.noop),this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1,i.default(this.tip).hasClass("fade")){var a=l.getTransitionDurationFromElement(n);i.default(n).one(l.TRANSITION_END,r).emulateTransitionEnd(a)}else r();this._hoverState=""}},e.update=function(){null!==this._popper&&this._popper.scheduleUpdate()},e.isWithContent=function(){return Boolean(this.getTitle())},e.addAttachmentClass=function(t){i.default(this.getTipElement()).addClass("bs-tooltip-"+t)},e.getTipElement=function(){return this.tip=this.tip||i.default(this.config.template)[0],this.tip},e.setContent=function(){var t=this.getTipElement();this.setElementContent(i.default(t.querySelectorAll(".tooltip-inner")),this.getTitle()),i.default(t).removeClass("fade show")},e.setElementContent=function(t,e){"object"!=typeof e||!e.nodeType&&!e.jquery?this.config.html?(this.config.sanitize&&(e=Vt(e,this.config.whiteList,this.config.sanitizeFn)),t.html(e)):t.text(e):this.config.html?i.default(e).parent().is(t)||t.empty().append(e):t.text(i.default(e).text())},e.getTitle=function(){var t=this.element.getAttribute("data-original-title");return t||(t="function"==typeof this.config.title?this.config.title.call(this.element):this.config.title),t},e._getPopperConfig=function(t){var e=this;return a({},{placement:t,modifiers:{offset:this._getOffset(),flip:{behavior:this.config.fallbackPlacement},arrow:{element:".arrow"},preventOverflow:{boundariesElement:this.config.boundary}},onCreate:function(t){t.originalPlacement!==t.placement&&e._handlePopperPlacementChange(t)},onUpdate:function(t){return e._handlePopperPlacementChange(t)}},this.config.popperConfig)},e._getOffset=function(){var t=this,e={};return"function"==typeof this.config.offset?e.fn=function(e){return e.offsets=a({},e.offsets,t.config.offset(e.offsets,t.element)||{}),e}:e.offset=this.config.offset,e},e._getContainer=function(){return!1===this.config.container?document.body:l.isElement(this.config.container)?i.default(this.config.container):i.default(document).find(this.config.container)},e._getAttachment=function(t){return $t[t.toUpperCase()]},e._setListeners=function(){var t=this;this.config.trigger.split(" ").forEach((function(e){if("click"===e)i.default(t.element).on(t.constructor.Event.CLICK,t.config.selector,(function(e){return t.toggle(e)}));else if("manual"!==e){var n="hover"===e?t.constructor.Event.MOUSEENTER:t.constructor.Event.FOCUSIN,o="hover"===e?t.constructor.Event.MOUSELEAVE:t.constructor.Event.FOCUSOUT;i.default(t.element).on(n,t.config.selector,(function(e){return t._enter(e)})).on(o,t.config.selector,(function(e){return t._leave(e)}))}})),this._hideModalHandler=function(){t.element&&t.hide()},i.default(this.element).closest(".modal").on("hide.bs.modal",this._hideModalHandler),this.config.selector?this.config=a({},this.config,{trigger:"manual",selector:""}):this._fixTitle()},e._fixTitle=function(){var t=typeof this.element.getAttribute("data-original-title");(this.element.getAttribute("title")||"string"!==t)&&(this.element.setAttribute("data-original-title",this.element.getAttribute("title")||""),this.element.setAttribute("title",""))},e._enter=function(t,e){var n=this.constructor.DATA_KEY;(e=e||i.default(t.currentTarget).data(n))||(e=new this.constructor(t.currentTarget,this._getDelegateConfig()),i.default(t.currentTarget).data(n,e)),t&&(e._activeTrigger["focusin"===t.type?"focus":"hover"]=!0),i.default(e.getTipElement()).hasClass("show")||"show"===e._hoverState?e._hoverState="show":(clearTimeout(e._timeout),e._hoverState="show",e.config.delay&&e.config.delay.show?e._timeout=setTimeout((function(){"show"===e._hoverState&&e.show()}),e.config.delay.show):e.show())},e._leave=function(t,e){var n=this.constructor.DATA_KEY;(e=e||i.default(t.currentTarget).data(n))||(e=new this.constructor(t.currentTarget,this._getDelegateConfig()),i.default(t.currentTarget).data(n,e)),t&&(e._activeTrigger["focusout"===t.type?"focus":"hover"]=!1),e._isWithActiveTrigger()||(clearTimeout(e._timeout),e._hoverState="out",e.config.delay&&e.config.delay.hide?e._timeout=setTimeout((function(){"out"===e._hoverState&&e.hide()}),e.config.delay.hide):e.hide())},e._isWithActiveTrigger=function(){for(var t in this._activeTrigger)if(this._activeTrigger[t])return!0;return!1},e._getConfig=function(t){var e=i.default(this.element).data();return Object.keys(e).forEach((function(t){-1!==Kt.indexOf(t)&&delete e[t]})),"number"==typeof(t=a({},this.constructor.Default,e,"object"==typeof t&&t?t:{})).delay&&(t.delay={show:t.delay,hide:t.delay}),"number"==typeof t.title&&(t.title=t.title.toString()),"number"==typeof t.content&&(t.content=t.content.toString()),l.typeCheckConfig(Yt,t,this.constructor.DefaultType),t.sanitize&&(t.template=Vt(t.template,t.whiteList,t.sanitizeFn)),t},e._getDelegateConfig=function(){var t={};if(this.config)for(var e in this.config)this.constructor.Default[e]!==this.config[e]&&(t[e]=this.config[e]);return t},e._cleanTipClass=function(){var t=i.default(this.getTipElement()),e=t.attr("class").match(Xt);null!==e&&e.length&&t.removeClass(e.join(""))},e._handlePopperPlacementChange=function(t){this.tip=t.instance.popper,this._cleanTipClass(),this.addAttachmentClass(this._getAttachment(t.placement))},e._fixTransition=function(){var t=this.getTipElement(),e=this.config.animation;null===t.getAttribute("x-placement")&&(i.default(t).removeClass("fade"),this.config.animation=!1,this.hide(),this.show(),this.config.animation=e)},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this),o=n.data("bs.tooltip"),r="object"==typeof e&&e;if((o||!/dispose|hide/.test(e))&&(o||(o=new t(this,r),n.data("bs.tooltip",o)),"string"==typeof e)){if("undefined"==typeof o[e])throw new TypeError('No method named "'+e+'"');o[e]()}}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return Jt}},{key:"NAME",get:function(){return Yt}},{key:"DATA_KEY",get:function(){return"bs.tooltip"}},{key:"Event",get:function(){return Zt}},{key:"EVENT_KEY",get:function(){return".bs.tooltip"}},{key:"DefaultType",get:function(){return Gt}}]),t}();i.default.fn[Yt]=te._jQueryInterface,i.default.fn[Yt].Constructor=te,i.default.fn[Yt].noConflict=function(){return i.default.fn[Yt]=zt,te._jQueryInterface};var ee="popover",ne=i.default.fn[ee],ie=new RegExp("(^|\\s)bs-popover\\S+","g"),oe=a({},te.Default,{placement:"right",trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>'}),re=a({},te.DefaultType,{content:"(string|element|function)"}),ae={HIDE:"hide.bs.popover",HIDDEN:"hidden.bs.popover",SHOW:"show.bs.popover",SHOWN:"shown.bs.popover",INSERTED:"inserted.bs.popover",CLICK:"click.bs.popover",FOCUSIN:"focusin.bs.popover",FOCUSOUT:"focusout.bs.popover",MOUSEENTER:"mouseenter.bs.popover",MOUSELEAVE:"mouseleave.bs.popover"},se=function(t){var e,n;function o(){return t.apply(this,arguments)||this}n=t,(e=o).prototype=Object.create(n.prototype),e.prototype.constructor=e,e.__proto__=n;var a=o.prototype;return a.isWithContent=function(){return this.getTitle()||this._getContent()},a.addAttachmentClass=function(t){i.default(this.getTipElement()).addClass("bs-popover-"+t)},a.getTipElement=function(){return this.tip=this.tip||i.default(this.config.template)[0],this.tip},a.setContent=function(){var t=i.default(this.getTipElement());this.setElementContent(t.find(".popover-header"),this.getTitle());var e=this._getContent();"function"==typeof e&&(e=e.call(this.element)),this.setElementContent(t.find(".popover-body"),e),t.removeClass("fade show")},a._getContent=function(){return this.element.getAttribute("data-content")||this.config.content},a._cleanTipClass=function(){var t=i.default(this.getTipElement()),e=t.attr("class").match(ie);null!==e&&e.length>0&&t.removeClass(e.join(""))},o._jQueryInterface=function(t){return this.each((function(){var e=i.default(this).data("bs.popover"),n="object"==typeof t?t:null;if((e||!/dispose|hide/.test(t))&&(e||(e=new o(this,n),i.default(this).data("bs.popover",e)),"string"==typeof t)){if("undefined"==typeof e[t])throw new TypeError('No method named "'+t+'"');e[t]()}}))},r(o,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return oe}},{key:"NAME",get:function(){return ee}},{key:"DATA_KEY",get:function(){return"bs.popover"}},{key:"Event",get:function(){return ae}},{key:"EVENT_KEY",get:function(){return".bs.popover"}},{key:"DefaultType",get:function(){return re}}]),o}(te);i.default.fn[ee]=se._jQueryInterface,i.default.fn[ee].Constructor=se,i.default.fn[ee].noConflict=function(){return i.default.fn[ee]=ne,se._jQueryInterface};var le="scrollspy",ue=i.default.fn[le],fe={offset:10,method:"auto",target:""},de={offset:"number",method:"string",target:"(string|element)"},ce=function(){function t(t,e){var n=this;this._element=t,this._scrollElement="BODY"===t.tagName?window:t,this._config=this._getConfig(e),this._selector=this._config.target+" .nav-link,"+this._config.target+" .list-group-item,"+this._config.target+" .dropdown-item",this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,i.default(this._scrollElement).on("scroll.bs.scrollspy",(function(t){return n._process(t)})),this.refresh(),this._process()}var e=t.prototype;return e.refresh=function(){var t=this,e=this._scrollElement===this._scrollElement.window?"offset":"position",n="auto"===this._config.method?e:this._config.method,o="position"===n?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight(),[].slice.call(document.querySelectorAll(this._selector)).map((function(t){var e,r=l.getSelectorFromElement(t);if(r&&(e=document.querySelector(r)),e){var a=e.getBoundingClientRect();if(a.width||a.height)return[i.default(e)[n]().top+o,r]}return null})).filter((function(t){return t})).sort((function(t,e){return t[0]-e[0]})).forEach((function(e){t._offsets.push(e[0]),t._targets.push(e[1])}))},e.dispose=function(){i.default.removeData(this._element,"bs.scrollspy"),i.default(this._scrollElement).off(".bs.scrollspy"),this._element=null,this._scrollElement=null,this._config=null,this._selector=null,this._offsets=null,this._targets=null,this._activeTarget=null,this._scrollHeight=null},e._getConfig=function(t){if("string"!=typeof(t=a({},fe,"object"==typeof t&&t?t:{})).target&&l.isElement(t.target)){var e=i.default(t.target).attr("id");e||(e=l.getUID(le),i.default(t.target).attr("id",e)),t.target="#"+e}return l.typeCheckConfig(le,t,de),t},e._getScrollTop=function(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop},e._getScrollHeight=function(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)},e._getOffsetHeight=function(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height},e._process=function(){var t=this._getScrollTop()+this._config.offset,e=this._getScrollHeight(),n=this._config.offset+e-this._getOffsetHeight();if(this._scrollHeight!==e&&this.refresh(),t>=n){var i=this._targets[this._targets.length-1];this._activeTarget!==i&&this._activate(i)}else{if(this._activeTarget&&t<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(var o=this._offsets.length;o--;){this._activeTarget!==this._targets[o]&&t>=this._offsets[o]&&("undefined"==typeof this._offsets[o+1]||t<this._offsets[o+1])&&this._activate(this._targets[o])}}},e._activate=function(t){this._activeTarget=t,this._clear();var e=this._selector.split(",").map((function(e){return e+'[data-target="'+t+'"],'+e+'[href="'+t+'"]'})),n=i.default([].slice.call(document.querySelectorAll(e.join(","))));n.hasClass("dropdown-item")?(n.closest(".dropdown").find(".dropdown-toggle").addClass("active"),n.addClass("active")):(n.addClass("active"),n.parents(".nav, .list-group").prev(".nav-link, .list-group-item").addClass("active"),n.parents(".nav, .list-group").prev(".nav-item").children(".nav-link").addClass("active")),i.default(this._scrollElement).trigger("activate.bs.scrollspy",{relatedTarget:t})},e._clear=function(){[].slice.call(document.querySelectorAll(this._selector)).filter((function(t){return t.classList.contains("active")})).forEach((function(t){return t.classList.remove("active")}))},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this).data("bs.scrollspy");if(n||(n=new t(this,"object"==typeof e&&e),i.default(this).data("bs.scrollspy",n)),"string"==typeof e){if("undefined"==typeof n[e])throw new TypeError('No method named "'+e+'"');n[e]()}}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"Default",get:function(){return fe}}]),t}();i.default(window).on("load.bs.scrollspy.data-api",(function(){for(var t=[].slice.call(document.querySelectorAll('[data-spy="scroll"]')),e=t.length;e--;){var n=i.default(t[e]);ce._jQueryInterface.call(n,n.data())}})),i.default.fn[le]=ce._jQueryInterface,i.default.fn[le].Constructor=ce,i.default.fn[le].noConflict=function(){return i.default.fn[le]=ue,ce._jQueryInterface};var he=i.default.fn.tab,pe=function(){function t(t){this._element=t}var e=t.prototype;return e.show=function(){var t=this;if(!(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&i.default(this._element).hasClass("active")||i.default(this._element).hasClass("disabled"))){var e,n,o=i.default(this._element).closest(".nav, .list-group")[0],r=l.getSelectorFromElement(this._element);if(o){var a="UL"===o.nodeName||"OL"===o.nodeName?"> li > .active":".active";n=(n=i.default.makeArray(i.default(o).find(a)))[n.length-1]}var s=i.default.Event("hide.bs.tab",{relatedTarget:this._element}),u=i.default.Event("show.bs.tab",{relatedTarget:n});if(n&&i.default(n).trigger(s),i.default(this._element).trigger(u),!u.isDefaultPrevented()&&!s.isDefaultPrevented()){r&&(e=document.querySelector(r)),this._activate(this._element,o);var f=function(){var e=i.default.Event("hidden.bs.tab",{relatedTarget:t._element}),o=i.default.Event("shown.bs.tab",{relatedTarget:n});i.default(n).trigger(e),i.default(t._element).trigger(o)};e?this._activate(e,e.parentNode,f):f()}}},e.dispose=function(){i.default.removeData(this._element,"bs.tab"),this._element=null},e._activate=function(t,e,n){var o=this,r=(!e||"UL"!==e.nodeName&&"OL"!==e.nodeName?i.default(e).children(".active"):i.default(e).find("> li > .active"))[0],a=n&&r&&i.default(r).hasClass("fade"),s=function(){return o._transitionComplete(t,r,n)};if(r&&a){var u=l.getTransitionDurationFromElement(r);i.default(r).removeClass("show").one(l.TRANSITION_END,s).emulateTransitionEnd(u)}else s()},e._transitionComplete=function(t,e,n){if(e){i.default(e).removeClass("active");var o=i.default(e.parentNode).find("> .dropdown-menu .active")[0];o&&i.default(o).removeClass("active"),"tab"===e.getAttribute("role")&&e.setAttribute("aria-selected",!1)}if(i.default(t).addClass("active"),"tab"===t.getAttribute("role")&&t.setAttribute("aria-selected",!0),l.reflow(t),t.classList.contains("fade")&&t.classList.add("show"),t.parentNode&&i.default(t.parentNode).hasClass("dropdown-menu")){var r=i.default(t).closest(".dropdown")[0];if(r){var a=[].slice.call(r.querySelectorAll(".dropdown-toggle"));i.default(a).addClass("active")}t.setAttribute("aria-expanded",!0)}n&&n()},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this),o=n.data("bs.tab");if(o||(o=new t(this),n.data("bs.tab",o)),"string"==typeof e){if("undefined"==typeof o[e])throw new TypeError('No method named "'+e+'"');o[e]()}}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}}]),t}();i.default(document).on("click.bs.tab.data-api",'[data-toggle="tab"], [data-toggle="pill"], [data-toggle="list"]',(function(t){t.preventDefault(),pe._jQueryInterface.call(i.default(this),"show")})),i.default.fn.tab=pe._jQueryInterface,i.default.fn.tab.Constructor=pe,i.default.fn.tab.noConflict=function(){return i.default.fn.tab=he,pe._jQueryInterface};var me=i.default.fn.toast,ge={animation:"boolean",autohide:"boolean",delay:"number"},ve={animation:!0,autohide:!0,delay:500},_e=function(){function t(t,e){this._element=t,this._config=this._getConfig(e),this._timeout=null,this._setListeners()}var e=t.prototype;return e.show=function(){var t=this,e=i.default.Event("show.bs.toast");if(i.default(this._element).trigger(e),!e.isDefaultPrevented()){this._clearTimeout(),this._config.animation&&this._element.classList.add("fade");var n=function(){t._element.classList.remove("showing"),t._element.classList.add("show"),i.default(t._element).trigger("shown.bs.toast"),t._config.autohide&&(t._timeout=setTimeout((function(){t.hide()}),t._config.delay))};if(this._element.classList.remove("hide"),l.reflow(this._element),this._element.classList.add("showing"),this._config.animation){var o=l.getTransitionDurationFromElement(this._element);i.default(this._element).one(l.TRANSITION_END,n).emulateTransitionEnd(o)}else n()}},e.hide=function(){if(this._element.classList.contains("show")){var t=i.default.Event("hide.bs.toast");i.default(this._element).trigger(t),t.isDefaultPrevented()||this._close()}},e.dispose=function(){this._clearTimeout(),this._element.classList.contains("show")&&this._element.classList.remove("show"),i.default(this._element).off("click.dismiss.bs.toast"),i.default.removeData(this._element,"bs.toast"),this._element=null,this._config=null},e._getConfig=function(t){return t=a({},ve,i.default(this._element).data(),"object"==typeof t&&t?t:{}),l.typeCheckConfig("toast",t,this.constructor.DefaultType),t},e._setListeners=function(){var t=this;i.default(this._element).on("click.dismiss.bs.toast",'[data-dismiss="toast"]',(function(){return t.hide()}))},e._close=function(){var t=this,e=function(){t._element.classList.add("hide"),i.default(t._element).trigger("hidden.bs.toast")};if(this._element.classList.remove("show"),this._config.animation){var n=l.getTransitionDurationFromElement(this._element);i.default(this._element).one(l.TRANSITION_END,e).emulateTransitionEnd(n)}else e()},e._clearTimeout=function(){clearTimeout(this._timeout),this._timeout=null},t._jQueryInterface=function(e){return this.each((function(){var n=i.default(this),o=n.data("bs.toast");if(o||(o=new t(this,"object"==typeof e&&e),n.data("bs.toast",o)),"string"==typeof e){if("undefined"==typeof o[e])throw new TypeError('No method named "'+e+'"');o[e](this)}}))},r(t,null,[{key:"VERSION",get:function(){return"4.6.0"}},{key:"DefaultType",get:function(){return ge}},{key:"Default",get:function(){return ve}}]),t}();i.default.fn.toast=_e._jQueryInterface,i.default.fn.toast.Constructor=_e,i.default.fn.toast.noConflict=function(){return i.default.fn.toast=me,_e._jQueryInterface},t.Alert=d,t.Button=h,t.Carousel=y,t.Collapse=S,t.Dropdown=Ft,t.Modal=qt,t.Popover=se,t.Scrollspy=ce,t.Tab=pe,t.Toast=_e,t.Tooltip=te,t.Util=l,Object.defineProperty(t,"__esModule",{value:!0})}));/*!
 * OverlayScrollbars
 * https://github.com/KingSora/OverlayScrollbars
 *
 * Version: 1.13.0
 *
 * Copyright KingSora | Rene Haas.
 * https://github.com/KingSora
 *
 * Released under the MIT license.
 * Date: 02.08.2020
 */
(function(global,factory){if(typeof define==='function'&&define.amd)
define(['jquery'],function(framework){return factory(global,global.document,undefined,framework);});else if(typeof module==='object'&&typeof module.exports==='object')
module.exports=factory(global,global.document,undefined,require('jquery'));else
factory(global,global.document,undefined,global.jQuery);}(typeof window!=='undefined'?window:this,function(window,document,undefined,framework){'use strict';var PLUGINNAME='OverlayScrollbars';var TYPES={o:'object',f:'function',a:'array',s:'string',b:'boolean',n:'number',u:'undefined',z:'null'
};var LEXICON={c:'class',s:'style',i:'id',l:'length',p:'prototype',ti:'tabindex',oH:'offsetHeight',cH:'clientHeight',sH:'scrollHeight',oW:'offsetWidth',cW:'clientWidth',sW:'scrollWidth',hOP:'hasOwnProperty',bCR:'getBoundingClientRect'};var VENDORS=(function(){var jsCache={};var cssCache={};var cssPrefixes=['-webkit-','-moz-','-o-','-ms-'];var jsPrefixes=['WebKit','Moz','O','MS'];function firstLetterToUpper(str){return str.charAt(0).toUpperCase()+str.slice(1);}
return{_cssPrefixes:cssPrefixes,_jsPrefixes:jsPrefixes,_cssProperty:function(name){var result=cssCache[name];if(cssCache[LEXICON.hOP](name))
return result;var uppercasedName=firstLetterToUpper(name);var elmStyle=document.createElement('div')[LEXICON.s];var resultPossibilities;var i=0;var v;var currVendorWithoutDashes;for(;i<cssPrefixes.length;i++){currVendorWithoutDashes=cssPrefixes[i].replace(/-/g,'');resultPossibilities=[name,cssPrefixes[i]+name,currVendorWithoutDashes+uppercasedName,firstLetterToUpper(currVendorWithoutDashes)+uppercasedName];for(v=0;v<resultPossibilities[LEXICON.l];v++){if(elmStyle[resultPossibilities[v]]!==undefined){result=resultPossibilities[v];break;}}}
cssCache[name]=result;return result;},_cssPropertyValue:function(property,values,suffix){var name=property+' '+values;var result=cssCache[name];if(cssCache[LEXICON.hOP](name))
return result;var dummyStyle=document.createElement('div')[LEXICON.s];var possbleValues=values.split(' ');var preparedSuffix=suffix||'';var i=0;var v=-1;var prop;for(;i<possbleValues[LEXICON.l];i++){for(;v<VENDORS._cssPrefixes[LEXICON.l];v++){prop=v<0?possbleValues[i]:VENDORS._cssPrefixes[v]+possbleValues[i];dummyStyle.cssText=property+':'+prop+preparedSuffix;if(dummyStyle[LEXICON.l]){result=prop;break;}}}
cssCache[name]=result;return result;},_jsAPI:function(name,isInterface,fallback){var i=0;var result=jsCache[name];if(!jsCache[LEXICON.hOP](name)){result=window[name];for(;i<jsPrefixes[LEXICON.l];i++)
result=result||window[(isInterface?jsPrefixes[i]:jsPrefixes[i].toLowerCase())+firstLetterToUpper(name)];jsCache[name]=result;}
return result||fallback;}}})();var COMPATIBILITY=(function(){function windowSize(x){return x?window.innerWidth||document.documentElement[LEXICON.cW]||document.body[LEXICON.cW]:window.innerHeight||document.documentElement[LEXICON.cH]||document.body[LEXICON.cH];}
function bind(func,thisObj){if(typeof func!=TYPES.f){throw"Can't bind function!";}
var proto=LEXICON.p;var aArgs=Array[proto].slice.call(arguments,2);var fNOP=function(){};var fBound=function(){return func.apply(this instanceof fNOP?this:thisObj,aArgs.concat(Array[proto].slice.call(arguments)));};if(func[proto])
fNOP[proto]=func[proto];fBound[proto]=new fNOP();return fBound;}
return{wW:bind(windowSize,0,true),wH:bind(windowSize,0),mO:bind(VENDORS._jsAPI,0,'MutationObserver',true),rO:bind(VENDORS._jsAPI,0,'ResizeObserver',true),rAF:bind(VENDORS._jsAPI,0,'requestAnimationFrame',false,function(func){return window.setTimeout(func,1000/60);}),cAF:bind(VENDORS._jsAPI,0,'cancelAnimationFrame',false,function(id){return window.clearTimeout(id);}),now:function(){return Date.now&&Date.now()||new Date().getTime();},stpP:function(event){if(event.stopPropagation)
event.stopPropagation();else
event.cancelBubble=true;},prvD:function(event){if(event.preventDefault&&event.cancelable)
event.preventDefault();else
event.returnValue=false;},page:function(event){event=event.originalEvent||event;var strPage='page';var strClient='client';var strX='X';var strY='Y';var target=event.target||event.srcElement||document;var eventDoc=target.ownerDocument||document;var doc=eventDoc.documentElement;var body=eventDoc.body;if(event.touches!==undefined){var touch=event.touches[0];return{x:touch[strPage+strX],y:touch[strPage+strY]}}
if(!event[strPage+strX]&&event[strClient+strX]&&event[strClient+strX]!=null){return{x:event[strClient+strX]+
(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-
(doc&&doc.clientLeft||body&&body.clientLeft||0),y:event[strClient+strY]+
(doc&&doc.scrollTop||body&&body.scrollTop||0)-
(doc&&doc.clientTop||body&&body.clientTop||0)}}
return{x:event[strPage+strX],y:event[strPage+strY]};},mBtn:function(event){var button=event.button;if(!event.which&&button!==undefined)
return(button&1?1:(button&2?3:(button&4?2:0)));else
return event.which;},inA:function(item,arr){for(var i=0;i<arr[LEXICON.l];i++)
try{if(arr[i]===item)
return i;}
catch(e){}
return-1;},isA:function(arr){var def=Array.isArray;return def?def(arr):this.type(arr)==TYPES.a;},type:function(obj){if(obj===undefined)
return obj+'';if(obj===null)
return obj+'';return Object[LEXICON.p].toString.call(obj).replace(/^\[object (.+)\]$/,'$1').toLowerCase();},bind:bind
}})();var MATH=Math;var JQUERY=framework;var EASING=framework.easing;var FRAMEWORK=framework;var INSTANCES=(function(){var _targets=[];var _instancePropertyString='__overlayScrollbars__';return function(target,instance){var argLen=arguments[LEXICON.l];if(argLen<1){return _targets;}
else{if(instance){target[_instancePropertyString]=instance;_targets.push(target);}
else{var index=COMPATIBILITY.inA(target,_targets);if(index>-1){if(argLen>1){delete target[_instancePropertyString];_targets.splice(index,1);}
else{return _targets[index][_instancePropertyString];}}}}}})();var PLUGIN=(function(){var _plugin;var _pluginsGlobals;var _pluginsAutoUpdateLoop;var _pluginsExtensions=[];var _pluginsOptions=(function(){var type=COMPATIBILITY.type;var possibleTemplateTypes=[TYPES.b,TYPES.n,TYPES.s,TYPES.a,TYPES.o,TYPES.f,TYPES.z];var restrictedStringsSplit=' ';var restrictedStringsPossibilitiesSplit=':';var classNameAllowedValues=[TYPES.z,TYPES.s];var numberAllowedValues=TYPES.n;var booleanNullAllowedValues=[TYPES.z,TYPES.b];var booleanTrueTemplate=[true,TYPES.b];var booleanFalseTemplate=[false,TYPES.b];var callbackTemplate=[null,[TYPES.z,TYPES.f]];var updateOnLoadTemplate=[['img'],[TYPES.s,TYPES.a,TYPES.z]];var inheritedAttrsTemplate=[['style','class'],[TYPES.s,TYPES.a,TYPES.z]];var resizeAllowedValues='n:none b:both h:horizontal v:vertical';var overflowBehaviorAllowedValues='v-h:visible-hidden v-s:visible-scroll s:scroll h:hidden';var scrollbarsVisibilityAllowedValues='v:visible h:hidden a:auto';var scrollbarsAutoHideAllowedValues='n:never s:scroll l:leave m:move';var optionsDefaultsAndTemplate={className:['os-theme-dark',classNameAllowedValues],resize:['none',resizeAllowedValues],sizeAutoCapable:booleanTrueTemplate,clipAlways:booleanTrueTemplate,normalizeRTL:booleanTrueTemplate,paddingAbsolute:booleanFalseTemplate,autoUpdate:[null,booleanNullAllowedValues],autoUpdateInterval:[33,numberAllowedValues],updateOnLoad:updateOnLoadTemplate,nativeScrollbarsOverlaid:{showNativeScrollbars:booleanFalseTemplate,initialize:booleanTrueTemplate},overflowBehavior:{x:['scroll',overflowBehaviorAllowedValues],y:['scroll',overflowBehaviorAllowedValues]},scrollbars:{visibility:['auto',scrollbarsVisibilityAllowedValues],autoHide:['never',scrollbarsAutoHideAllowedValues],autoHideDelay:[800,numberAllowedValues],dragScrolling:booleanTrueTemplate,clickScrolling:booleanFalseTemplate,touchSupport:booleanTrueTemplate,snapHandle:booleanFalseTemplate},textarea:{dynWidth:booleanFalseTemplate,dynHeight:booleanFalseTemplate,inheritedAttrs:inheritedAttrsTemplate},callbacks:{onInitialized:callbackTemplate,onInitializationWithdrawn:callbackTemplate,onDestroyed:callbackTemplate,onScrollStart:callbackTemplate,onScroll:callbackTemplate,onScrollStop:callbackTemplate,onOverflowChanged:callbackTemplate,onOverflowAmountChanged:callbackTemplate,onDirectionChanged:callbackTemplate,onContentSizeChanged:callbackTemplate,onHostSizeChanged:callbackTemplate,onUpdated:callbackTemplate}};var convert=function(template){var recursive=function(obj){var key;var val;var valType;for(key in obj){if(!obj[LEXICON.hOP](key))
continue;val=obj[key];valType=type(val);if(valType==TYPES.a)
obj[key]=val[template?1:0];else if(valType==TYPES.o)
obj[key]=recursive(val);}
return obj;};return recursive(FRAMEWORK.extend(true,{},optionsDefaultsAndTemplate));};return{_defaults:convert(),_template:convert(true),_validate:function(obj,template,writeErrors,diffObj){var validatedOptions={};var validatedOptionsPrepared={};var objectCopy=FRAMEWORK.extend(true,{},obj);var inArray=FRAMEWORK.inArray;var isEmptyObj=FRAMEWORK.isEmptyObject;var checkObjectProps=function(data,template,diffData,validatedOptions,validatedOptionsPrepared,prevPropName){for(var prop in template){if(template[LEXICON.hOP](prop)&&data[LEXICON.hOP](prop)){var isValid=false;var isDiff=false;var templateValue=template[prop];var templateValueType=type(templateValue);var templateIsComplex=templateValueType==TYPES.o;var templateTypes=!COMPATIBILITY.isA(templateValue)?[templateValue]:templateValue;var dataDiffValue=diffData[prop];var dataValue=data[prop];var dataValueType=type(dataValue);var propPrefix=prevPropName?prevPropName+'.':'';var error="The option \""+propPrefix+prop+"\" wasn't set, because";var errorPossibleTypes=[];var errorRestrictedStrings=[];var restrictedStringValuesSplit;var restrictedStringValuesPossibilitiesSplit;var isRestrictedValue;var mainPossibility;var currType;var i;var v;var j;dataDiffValue=dataDiffValue===undefined?{}:dataDiffValue;if(templateIsComplex&&dataValueType==TYPES.o){validatedOptions[prop]={};validatedOptionsPrepared[prop]={};checkObjectProps(dataValue,templateValue,dataDiffValue,validatedOptions[prop],validatedOptionsPrepared[prop],propPrefix+prop);FRAMEWORK.each([data,validatedOptions,validatedOptionsPrepared],function(index,value){if(isEmptyObj(value[prop])){delete value[prop];}});}
else if(!templateIsComplex){for(i=0;i<templateTypes[LEXICON.l];i++){currType=templateTypes[i];templateValueType=type(currType);isRestrictedValue=templateValueType==TYPES.s&&inArray(currType,possibleTemplateTypes)===-1;if(isRestrictedValue){errorPossibleTypes.push(TYPES.s);restrictedStringValuesSplit=currType.split(restrictedStringsSplit);errorRestrictedStrings=errorRestrictedStrings.concat(restrictedStringValuesSplit);for(v=0;v<restrictedStringValuesSplit[LEXICON.l];v++){restrictedStringValuesPossibilitiesSplit=restrictedStringValuesSplit[v].split(restrictedStringsPossibilitiesSplit);mainPossibility=restrictedStringValuesPossibilitiesSplit[0];for(j=0;j<restrictedStringValuesPossibilitiesSplit[LEXICON.l];j++){if(dataValue===restrictedStringValuesPossibilitiesSplit[j]){isValid=true;break;}}
if(isValid)
break;}}
else{errorPossibleTypes.push(currType);if(dataValueType===currType){isValid=true;break;}}}
if(isValid){isDiff=dataValue!==dataDiffValue;if(isDiff)
validatedOptions[prop]=dataValue;if(isRestrictedValue?inArray(dataDiffValue,restrictedStringValuesPossibilitiesSplit)<0:isDiff)
validatedOptionsPrepared[prop]=isRestrictedValue?mainPossibility:dataValue;}
else if(writeErrors){console.warn(error+" it doesn't accept the type [ "+dataValueType.toUpperCase()+" ] with the value of \""+dataValue+"\".\r\n"+
"Accepted types are: [ "+errorPossibleTypes.join(', ').toUpperCase()+" ]."+
(errorRestrictedStrings[length]>0?"\r\nValid strings are: [ "+errorRestrictedStrings.join(', ').split(restrictedStringsPossibilitiesSplit).join(', ')+" ].":''));}
delete data[prop];}}}};checkObjectProps(objectCopy,template,diffObj||{},validatedOptions,validatedOptionsPrepared);if(!isEmptyObj(objectCopy)&&writeErrors)
console.warn('The following options are discarded due to invalidity:\r\n'+window.JSON.stringify(objectCopy,null,2));return{_default:validatedOptions,_prepared:validatedOptionsPrepared};}}}());function initOverlayScrollbarsStatics(){if(!_pluginsGlobals)
_pluginsGlobals=new OverlayScrollbarsGlobals(_pluginsOptions._defaults);if(!_pluginsAutoUpdateLoop)
_pluginsAutoUpdateLoop=new OverlayScrollbarsAutoUpdateLoop(_pluginsGlobals);}
function OverlayScrollbarsGlobals(defaultOptions){var _base=this;var strOverflow='overflow';var strHidden='hidden';var strScroll='scroll';var bodyElement=FRAMEWORK('body');var scrollbarDummyElement=FRAMEWORK('<div id="os-dummy-scrollbar-size"><div></div></div>');var scrollbarDummyElement0=scrollbarDummyElement[0];var dummyContainerChild=FRAMEWORK(scrollbarDummyElement.children('div').eq(0));bodyElement.append(scrollbarDummyElement);scrollbarDummyElement.hide().show();var nativeScrollbarSize=calcNativeScrollbarSize(scrollbarDummyElement0);var nativeScrollbarIsOverlaid={x:nativeScrollbarSize.x===0,y:nativeScrollbarSize.y===0};var msie=(function(){var ua=window.navigator.userAgent;var strIndexOf='indexOf';var strSubString='substring';var msie=ua[strIndexOf]('MSIE ');var trident=ua[strIndexOf]('Trident/');var edge=ua[strIndexOf]('Edge/');var rv=ua[strIndexOf]('rv:');var result;var parseIntFunc=parseInt;if(msie>0)
result=parseIntFunc(ua[strSubString](msie+5,ua[strIndexOf]('.',msie)),10);else if(trident>0)
result=parseIntFunc(ua[strSubString](rv+3,ua[strIndexOf]('.',rv)),10);else if(edge>0)
result=parseIntFunc(ua[strSubString](edge+5,ua[strIndexOf]('.',edge)),10);return result;})();FRAMEWORK.extend(_base,{defaultOptions:defaultOptions,msie:msie,autoUpdateLoop:false,autoUpdateRecommended:!COMPATIBILITY.mO(),nativeScrollbarSize:nativeScrollbarSize,nativeScrollbarIsOverlaid:nativeScrollbarIsOverlaid,nativeScrollbarStyling:(function(){var result=false;scrollbarDummyElement.addClass('os-viewport-native-scrollbars-invisible');try{result=(scrollbarDummyElement.css('scrollbar-width')==='none'&&(msie>9||!msie))||window.getComputedStyle(scrollbarDummyElement0,'::-webkit-scrollbar').getPropertyValue('display')==='none';}catch(ex){}
return result;})(),overlayScrollbarDummySize:{x:30,y:30},cssCalc:VENDORS._cssPropertyValue('width','calc','(1px)')||null,restrictedMeasuring:(function(){scrollbarDummyElement.css(strOverflow,strHidden);var scrollSize={w:scrollbarDummyElement0[LEXICON.sW],h:scrollbarDummyElement0[LEXICON.sH]};scrollbarDummyElement.css(strOverflow,'visible');var scrollSize2={w:scrollbarDummyElement0[LEXICON.sW],h:scrollbarDummyElement0[LEXICON.sH]};return(scrollSize.w-scrollSize2.w)!==0||(scrollSize.h-scrollSize2.h)!==0;})(),rtlScrollBehavior:(function(){scrollbarDummyElement.css({'overflow-y':strHidden,'overflow-x':strScroll,'direction':'rtl'}).scrollLeft(0);var dummyContainerOffset=scrollbarDummyElement.offset();var dummyContainerChildOffset=dummyContainerChild.offset();scrollbarDummyElement.scrollLeft(-999);var dummyContainerChildOffsetAfterScroll=dummyContainerChild.offset();return{i:dummyContainerOffset.left===dummyContainerChildOffset.left,n:dummyContainerChildOffset.left!==dummyContainerChildOffsetAfterScroll.left};})(),supportTransform:!!VENDORS._cssProperty('transform'),supportTransition:!!VENDORS._cssProperty('transition'),supportPassiveEvents:(function(){var supportsPassive=false;try{window.addEventListener('test',null,Object.defineProperty({},'passive',{get:function(){supportsPassive=true;}}));}catch(e){}
return supportsPassive;})(),supportResizeObserver:!!COMPATIBILITY.rO(),supportMutationObserver:!!COMPATIBILITY.mO()});scrollbarDummyElement.removeAttr(LEXICON.s).remove();(function(){if(nativeScrollbarIsOverlaid.x&&nativeScrollbarIsOverlaid.y)
return;var abs=MATH.abs;var windowWidth=COMPATIBILITY.wW();var windowHeight=COMPATIBILITY.wH();var windowDpr=getWindowDPR();var onResize=function(){if(INSTANCES().length>0){var newW=COMPATIBILITY.wW();var newH=COMPATIBILITY.wH();var deltaW=newW-windowWidth;var deltaH=newH-windowHeight;if(deltaW===0&&deltaH===0)
return;var deltaWRatio=MATH.round(newW/(windowWidth/100.0));var deltaHRatio=MATH.round(newH/(windowHeight/100.0));var absDeltaW=abs(deltaW);var absDeltaH=abs(deltaH);var absDeltaWRatio=abs(deltaWRatio);var absDeltaHRatio=abs(deltaHRatio);var newDPR=getWindowDPR();var deltaIsBigger=absDeltaW>2&&absDeltaH>2;var difference=!differenceIsBiggerThanOne(absDeltaWRatio,absDeltaHRatio);var dprChanged=newDPR!==windowDpr&&windowDpr>0;var isZoom=deltaIsBigger&&difference&&dprChanged;var oldScrollbarSize=_base.nativeScrollbarSize;var newScrollbarSize;if(isZoom){bodyElement.append(scrollbarDummyElement);newScrollbarSize=_base.nativeScrollbarSize=calcNativeScrollbarSize(scrollbarDummyElement[0]);scrollbarDummyElement.remove();if(oldScrollbarSize.x!==newScrollbarSize.x||oldScrollbarSize.y!==newScrollbarSize.y){FRAMEWORK.each(INSTANCES(),function(){if(INSTANCES(this))
INSTANCES(this).update('zoom');});}}
windowWidth=newW;windowHeight=newH;windowDpr=newDPR;}};function differenceIsBiggerThanOne(valOne,valTwo){var absValOne=abs(valOne);var absValTwo=abs(valTwo);return!(absValOne===absValTwo||absValOne+1===absValTwo||absValOne-1===absValTwo);}
function getWindowDPR(){var dDPI=window.screen.deviceXDPI||0;var sDPI=window.screen.logicalXDPI||1;return window.devicePixelRatio||(dDPI/sDPI);}
FRAMEWORK(window).on('resize',onResize);})();function calcNativeScrollbarSize(measureElement){return{x:measureElement[LEXICON.oH]-measureElement[LEXICON.cH],y:measureElement[LEXICON.oW]-measureElement[LEXICON.cW]};}}
function OverlayScrollbarsAutoUpdateLoop(globals){var _base=this;var _inArray=FRAMEWORK.inArray;var _getNow=COMPATIBILITY.now;var _strAutoUpdate='autoUpdate';var _strAutoUpdateInterval=_strAutoUpdate+'Interval';var _strLength=LEXICON.l;var _loopingInstances=[];var _loopingInstancesIntervalCache=[];var _loopIsActive=false;var _loopIntervalDefault=33;var _loopInterval=_loopIntervalDefault;var _loopTimeOld=_getNow();var _loopID;var loop=function(){if(_loopingInstances[_strLength]>0&&_loopIsActive){_loopID=COMPATIBILITY.rAF()(function(){loop();});var timeNew=_getNow();var timeDelta=timeNew-_loopTimeOld;var lowestInterval;var instance;var instanceOptions;var instanceAutoUpdateAllowed;var instanceAutoUpdateInterval;var now;if(timeDelta>_loopInterval){_loopTimeOld=timeNew-(timeDelta%_loopInterval);lowestInterval=_loopIntervalDefault;for(var i=0;i<_loopingInstances[_strLength];i++){instance=_loopingInstances[i];if(instance!==undefined){instanceOptions=instance.options();instanceAutoUpdateAllowed=instanceOptions[_strAutoUpdate];instanceAutoUpdateInterval=MATH.max(1,instanceOptions[_strAutoUpdateInterval]);now=_getNow();if((instanceAutoUpdateAllowed===true||instanceAutoUpdateAllowed===null)&&(now-_loopingInstancesIntervalCache[i])>instanceAutoUpdateInterval){instance.update('auto');_loopingInstancesIntervalCache[i]=new Date(now+=instanceAutoUpdateInterval);}
lowestInterval=MATH.max(1,MATH.min(lowestInterval,instanceAutoUpdateInterval));}}
_loopInterval=lowestInterval;}}else{_loopInterval=_loopIntervalDefault;}};_base.add=function(instance){if(_inArray(instance,_loopingInstances)===-1){_loopingInstances.push(instance);_loopingInstancesIntervalCache.push(_getNow());if(_loopingInstances[_strLength]>0&&!_loopIsActive){_loopIsActive=true;globals.autoUpdateLoop=_loopIsActive;loop();}}};_base.remove=function(instance){var index=_inArray(instance,_loopingInstances);if(index>-1){_loopingInstancesIntervalCache.splice(index,1);_loopingInstances.splice(index,1);if(_loopingInstances[_strLength]===0&&_loopIsActive){_loopIsActive=false;globals.autoUpdateLoop=_loopIsActive;if(_loopID!==undefined){COMPATIBILITY.cAF()(_loopID);_loopID=-1;}}}};}
function OverlayScrollbarsInstance(pluginTargetElement,options,extensions,globals,autoUpdateLoop){var type=COMPATIBILITY.type;var inArray=FRAMEWORK.inArray;var each=FRAMEWORK.each;var _base=new _plugin();var _frameworkProto=FRAMEWORK[LEXICON.p];if(!isHTMLElement(pluginTargetElement))
return;if(INSTANCES(pluginTargetElement)){var inst=INSTANCES(pluginTargetElement);inst.options(options);return inst;}
var _nativeScrollbarIsOverlaid;var _overlayScrollbarDummySize;var _rtlScrollBehavior;var _autoUpdateRecommended;var _msieVersion;var _nativeScrollbarStyling;var _cssCalc;var _nativeScrollbarSize;var _supportTransition;var _supportTransform;var _supportPassiveEvents;var _supportResizeObserver;var _supportMutationObserver;var _restrictedMeasuring;var _initialized;var _destroyed;var _isTextarea;var _isBody;var _documentMixed;var _domExists;var _isBorderBox;var _sizeAutoObserverAdded;var _paddingX;var _paddingY;var _borderX;var _borderY;var _marginX;var _marginY;var _isRTL;var _sleeping;var _contentBorderSize={};var _scrollHorizontalInfo={};var _scrollVerticalInfo={};var _viewportSize={};var _nativeScrollbarMinSize={};var _strMinusHidden='-hidden';var _strMarginMinus='margin-';var _strPaddingMinus='padding-';var _strBorderMinus='border-';var _strTop='top';var _strRight='right';var _strBottom='bottom';var _strLeft='left';var _strMinMinus='min-';var _strMaxMinus='max-';var _strWidth='width';var _strHeight='height';var _strFloat='float';var _strEmpty='';var _strAuto='auto';var _strSync='sync';var _strScroll='scroll';var _strHundredPercent='100%';var _strX='x';var _strY='y';var _strDot='.';var _strSpace=' ';var _strScrollbar='scrollbar';var _strMinusHorizontal='-horizontal';var _strMinusVertical='-vertical';var _strScrollLeft=_strScroll+'Left';var _strScrollTop=_strScroll+'Top';var _strMouseTouchDownEvent='mousedown touchstart';var _strMouseTouchUpEvent='mouseup touchend touchcancel';var _strMouseTouchMoveEvent='mousemove touchmove';var _strMouseEnter='mouseenter';var _strMouseLeave='mouseleave';var _strKeyDownEvent='keydown';var _strKeyUpEvent='keyup';var _strSelectStartEvent='selectstart';var _strTransitionEndEvent='transitionend webkitTransitionEnd oTransitionEnd';var _strResizeObserverProperty='__overlayScrollbarsRO__';var _cassNamesPrefix='os-';var _classNameHTMLElement=_cassNamesPrefix+'html';var _classNameHostElement=_cassNamesPrefix+'host';var _classNameHostElementForeign=_classNameHostElement+'-foreign';var _classNameHostTextareaElement=_classNameHostElement+'-textarea';var _classNameHostScrollbarHorizontalHidden=_classNameHostElement+'-'+_strScrollbar+_strMinusHorizontal+_strMinusHidden;var _classNameHostScrollbarVerticalHidden=_classNameHostElement+'-'+_strScrollbar+_strMinusVertical+_strMinusHidden;var _classNameHostTransition=_classNameHostElement+'-transition';var _classNameHostRTL=_classNameHostElement+'-rtl';var _classNameHostResizeDisabled=_classNameHostElement+'-resize-disabled';var _classNameHostScrolling=_classNameHostElement+'-scrolling';var _classNameHostOverflow=_classNameHostElement+'-overflow';var _classNameHostOverflow=_classNameHostElement+'-overflow';var _classNameHostOverflowX=_classNameHostOverflow+'-x';var _classNameHostOverflowY=_classNameHostOverflow+'-y';var _classNameTextareaElement=_cassNamesPrefix+'textarea';var _classNameTextareaCoverElement=_classNameTextareaElement+'-cover';var _classNamePaddingElement=_cassNamesPrefix+'padding';var _classNameViewportElement=_cassNamesPrefix+'viewport';var _classNameViewportNativeScrollbarsInvisible=_classNameViewportElement+'-native-scrollbars-invisible';var _classNameViewportNativeScrollbarsOverlaid=_classNameViewportElement+'-native-scrollbars-overlaid';var _classNameContentElement=_cassNamesPrefix+'content';var _classNameContentArrangeElement=_cassNamesPrefix+'content-arrange';var _classNameContentGlueElement=_cassNamesPrefix+'content-glue';var _classNameSizeAutoObserverElement=_cassNamesPrefix+'size-auto-observer';var _classNameResizeObserverElement=_cassNamesPrefix+'resize-observer';var _classNameResizeObserverItemElement=_cassNamesPrefix+'resize-observer-item';var _classNameResizeObserverItemFinalElement=_classNameResizeObserverItemElement+'-final';var _classNameTextInherit=_cassNamesPrefix+'text-inherit';var _classNameScrollbar=_cassNamesPrefix+_strScrollbar;var _classNameScrollbarTrack=_classNameScrollbar+'-track';var _classNameScrollbarTrackOff=_classNameScrollbarTrack+'-off';var _classNameScrollbarHandle=_classNameScrollbar+'-handle';var _classNameScrollbarHandleOff=_classNameScrollbarHandle+'-off';var _classNameScrollbarUnusable=_classNameScrollbar+'-unusable';var _classNameScrollbarAutoHidden=_classNameScrollbar+'-'+_strAuto+_strMinusHidden;var _classNameScrollbarCorner=_classNameScrollbar+'-corner';var _classNameScrollbarCornerResize=_classNameScrollbarCorner+'-resize';var _classNameScrollbarCornerResizeB=_classNameScrollbarCornerResize+'-both';var _classNameScrollbarCornerResizeH=_classNameScrollbarCornerResize+_strMinusHorizontal;var _classNameScrollbarCornerResizeV=_classNameScrollbarCornerResize+_strMinusVertical;var _classNameScrollbarHorizontal=_classNameScrollbar+_strMinusHorizontal;var _classNameScrollbarVertical=_classNameScrollbar+_strMinusVertical;var _classNameDragging=_cassNamesPrefix+'dragging';var _classNameThemeNone=_cassNamesPrefix+'theme-none';var _classNamesDynamicDestroy=[_classNameViewportNativeScrollbarsInvisible,_classNameViewportNativeScrollbarsOverlaid,_classNameScrollbarTrackOff,_classNameScrollbarHandleOff,_classNameScrollbarUnusable,_classNameScrollbarAutoHidden,_classNameScrollbarCornerResize,_classNameScrollbarCornerResizeB,_classNameScrollbarCornerResizeH,_classNameScrollbarCornerResizeV,_classNameDragging].join(_strSpace);var _callbacksInitQeueue=[];var _viewportAttrsFromTarget=[LEXICON.ti];var _defaultOptions;var _currentOptions;var _currentPreparedOptions;var _extensions={};var _extensionsPrivateMethods='added removed on contract';var _lastUpdateTime;var _swallowedUpdateHints={};var _swallowedUpdateTimeout;var _swallowUpdateLag=42;var _updateOnLoadEventName='load';var _updateOnLoadElms=[];var _windowElement;var _documentElement;var _htmlElement;var _bodyElement;var _targetElement;var _hostElement;var _sizeAutoObserverElement;var _sizeObserverElement;var _paddingElement;var _viewportElement;var _contentElement;var _contentArrangeElement;var _contentGlueElement;var _textareaCoverElement;var _scrollbarCornerElement;var _scrollbarHorizontalElement;var _scrollbarHorizontalTrackElement;var _scrollbarHorizontalHandleElement;var _scrollbarVerticalElement;var _scrollbarVerticalTrackElement;var _scrollbarVerticalHandleElement;var _windowElementNative;var _documentElementNative;var _targetElementNative;var _hostElementNative;var _sizeAutoObserverElementNative;var _sizeObserverElementNative;var _paddingElementNative;var _viewportElementNative;var _contentElementNative;var _hostSizeCache;var _contentScrollSizeCache;var _arrangeContentSizeCache;var _hasOverflowCache;var _hideOverflowCache;var _widthAutoCache;var _heightAutoCache;var _cssBoxSizingCache;var _cssPaddingCache;var _cssBorderCache;var _cssMarginCache;var _cssDirectionCache;var _cssDirectionDetectedCache;var _paddingAbsoluteCache;var _clipAlwaysCache;var _contentGlueSizeCache;var _overflowBehaviorCache;var _overflowAmountCache;var _ignoreOverlayScrollbarHidingCache;var _autoUpdateCache;var _sizeAutoCapableCache;var _contentElementScrollSizeChangeDetectedCache;var _hostElementSizeChangeDetectedCache;var _scrollbarsVisibilityCache;var _scrollbarsAutoHideCache;var _scrollbarsClickScrollingCache;var _scrollbarsDragScrollingCache;var _resizeCache;var _normalizeRTLCache;var _classNameCache;var _oldClassName;var _textareaAutoWrappingCache;var _textareaInfoCache;var _textareaSizeCache;var _textareaDynHeightCache;var _textareaDynWidthCache;var _bodyMinSizeCache;var _updateAutoCache={};var _mutationObserverHost;var _mutationObserverContent;var _mutationObserverHostCallback;var _mutationObserverContentCallback;var _mutationObserversConnected;var _mutationObserverAttrsTextarea=['wrap','cols','rows'];var _mutationObserverAttrsHost=[LEXICON.i,LEXICON.c,LEXICON.s,'open'].concat(_viewportAttrsFromTarget);var _destroyEvents=[];var _textareaHasFocus;var _scrollbarsAutoHideTimeoutId;var _scrollbarsAutoHideMoveTimeoutId;var _scrollbarsAutoHideDelay;var _scrollbarsAutoHideNever;var _scrollbarsAutoHideScroll;var _scrollbarsAutoHideMove;var _scrollbarsAutoHideLeave;var _scrollbarsHandleHovered;var _scrollbarsHandlesDefineScrollPos;var _resizeNone;var _resizeBoth;var _resizeHorizontal;var _resizeVertical;function setupResponsiveEventListener(element,eventNames,listener,remove,passiveOrOptions){var collected=COMPATIBILITY.isA(eventNames)&&COMPATIBILITY.isA(listener);var method=remove?'removeEventListener':'addEventListener';var onOff=remove?'off':'on';var events=collected?false:eventNames.split(_strSpace)
var i=0;var passiveOrOptionsIsObj=FRAMEWORK.isPlainObject(passiveOrOptions);var passive=(_supportPassiveEvents&&(passiveOrOptionsIsObj?(passiveOrOptions._passive):passiveOrOptions))||false;var capture=passiveOrOptionsIsObj&&(passiveOrOptions._capture||false);var nativeParam=_supportPassiveEvents?{passive:passive,capture:capture,}:capture;if(collected){for(;i<eventNames[LEXICON.l];i++)
setupResponsiveEventListener(element,eventNames[i],listener[i],remove,passiveOrOptions);}
else{for(;i<events[LEXICON.l];i++){if(_supportPassiveEvents){element[0][method](events[i],listener,nativeParam);}
else{element[onOff](events[i],listener);}}}}
function addDestroyEventListener(element,eventNames,listener,passive){setupResponsiveEventListener(element,eventNames,listener,false,passive);_destroyEvents.push(COMPATIBILITY.bind(setupResponsiveEventListener,0,element,eventNames,listener,true,passive));}
function setupResizeObserver(targetElement,onElementResizedCallback){if(targetElement){var resizeObserver=COMPATIBILITY.rO();var strAnimationStartEvent='animationstart mozAnimationStart webkitAnimationStart MSAnimationStart';var strChildNodes='childNodes';var constScroll=3333333;var callback=function(){targetElement[_strScrollTop](constScroll)[_strScrollLeft](_isRTL?_rtlScrollBehavior.n?-constScroll:_rtlScrollBehavior.i?0:constScroll:constScroll);onElementResizedCallback();};if(onElementResizedCallback){if(_supportResizeObserver){var element=targetElement.addClass('observed').append(generateDiv(_classNameResizeObserverElement)).contents()[0];var observer=element[_strResizeObserverProperty]=new resizeObserver(callback);observer.observe(element);}
else{if(_msieVersion>9||!_autoUpdateRecommended){targetElement.prepend(generateDiv(_classNameResizeObserverElement,generateDiv({c:_classNameResizeObserverItemElement,dir:'ltr'},generateDiv(_classNameResizeObserverItemElement,generateDiv(_classNameResizeObserverItemFinalElement))+
generateDiv(_classNameResizeObserverItemElement,generateDiv({c:_classNameResizeObserverItemFinalElement,style:'width: 200%; height: 200%'})))));var observerElement=targetElement[0][strChildNodes][0][strChildNodes][0];var shrinkElement=FRAMEWORK(observerElement[strChildNodes][1]);var expandElement=FRAMEWORK(observerElement[strChildNodes][0]);var expandElementChild=FRAMEWORK(expandElement[0][strChildNodes][0]);var widthCache=observerElement[LEXICON.oW];var heightCache=observerElement[LEXICON.oH];var isDirty;var rAFId;var currWidth;var currHeight;var factor=2;var nativeScrollbarSize=globals.nativeScrollbarSize;var reset=function(){expandElement[_strScrollLeft](constScroll)[_strScrollTop](constScroll);shrinkElement[_strScrollLeft](constScroll)[_strScrollTop](constScroll);};var onResized=function(){rAFId=0;if(!isDirty)
return;widthCache=currWidth;heightCache=currHeight;callback();};var onScroll=function(event){currWidth=observerElement[LEXICON.oW];currHeight=observerElement[LEXICON.oH];isDirty=currWidth!=widthCache||currHeight!=heightCache;if(event&&isDirty&&!rAFId){COMPATIBILITY.cAF()(rAFId);rAFId=COMPATIBILITY.rAF()(onResized);}
else if(!event)
onResized();reset();if(event){COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}
return false;};var expandChildCSS={};var observerElementCSS={};setTopRightBottomLeft(observerElementCSS,_strEmpty,[-((nativeScrollbarSize.y+1)*factor),nativeScrollbarSize.x*-factor,nativeScrollbarSize.y*-factor,-((nativeScrollbarSize.x+1)*factor)]);FRAMEWORK(observerElement).css(observerElementCSS);expandElement.on(_strScroll,onScroll);shrinkElement.on(_strScroll,onScroll);targetElement.on(strAnimationStartEvent,function(){onScroll(false);});expandChildCSS[_strWidth]=constScroll;expandChildCSS[_strHeight]=constScroll;expandElementChild.css(expandChildCSS);reset();}
else{var attachEvent=_documentElementNative.attachEvent;var isIE=_msieVersion!==undefined;if(attachEvent){targetElement.prepend(generateDiv(_classNameResizeObserverElement));findFirst(targetElement,_strDot+_classNameResizeObserverElement)[0].attachEvent('onresize',callback);}
else{var obj=_documentElementNative.createElement(TYPES.o);obj.setAttribute(LEXICON.ti,'-1');obj.setAttribute(LEXICON.c,_classNameResizeObserverElement);obj.onload=function(){var wnd=this.contentDocument.defaultView;wnd.addEventListener('resize',callback);wnd.document.documentElement.style.display='none';};obj.type='text/html';if(isIE)
targetElement.prepend(obj);obj.data='about:blank';if(!isIE)
targetElement.prepend(obj);targetElement.on(strAnimationStartEvent,callback);}}}
if(targetElement[0]===_sizeObserverElementNative){var directionChanged=function(){var dir=_hostElement.css('direction');var css={};var scrollLeftValue=0;var result=false;if(dir!==_cssDirectionDetectedCache){if(dir==='ltr'){css[_strLeft]=0;css[_strRight]=_strAuto;scrollLeftValue=constScroll;}
else{css[_strLeft]=_strAuto;css[_strRight]=0;scrollLeftValue=_rtlScrollBehavior.n?-constScroll:_rtlScrollBehavior.i?0:constScroll;}
_sizeObserverElement.children().eq(0).css(css);_sizeObserverElement[_strScrollLeft](scrollLeftValue)[_strScrollTop](constScroll);_cssDirectionDetectedCache=dir;result=true;}
return result;};directionChanged();addDestroyEventListener(targetElement,_strScroll,function(event){if(directionChanged())
update();COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);return false;});}}
else{if(_supportResizeObserver){var element=targetElement.contents()[0];var resizeObserverObj=element[_strResizeObserverProperty];if(resizeObserverObj){resizeObserverObj.disconnect();delete element[_strResizeObserverProperty];}}
else{remove(targetElement.children(_strDot+_classNameResizeObserverElement).eq(0));}}}}
function createMutationObservers(){if(_supportMutationObserver){var mutationObserverContentLag=11;var mutationObserver=COMPATIBILITY.mO();var contentLastUpdate=COMPATIBILITY.now();var mutationTarget;var mutationAttrName;var mutationIsClass;var oldMutationVal;var newClassVal;var hostClassNameRegex;var contentTimeout;var now;var sizeAuto;var action;_mutationObserverHostCallback=function(mutations){var doUpdate=false;var doUpdateForce=false;var mutation;var mutatedAttrs=[];if(_initialized&&!_sleeping){each(mutations,function(){mutation=this;mutationTarget=mutation.target;mutationAttrName=mutation.attributeName;mutationIsClass=mutationAttrName===LEXICON.c;oldMutationVal=mutation.oldValue;newClassVal=mutationTarget.className;if(_domExists&&mutationIsClass&&!doUpdateForce){if(oldMutationVal.indexOf(_classNameHostElementForeign)>-1&&newClassVal.indexOf(_classNameHostElementForeign)<0){hostClassNameRegex=createHostClassNameRegExp(true);_hostElementNative.className=newClassVal.split(_strSpace).concat(oldMutationVal.split(_strSpace).filter(function(name){return name.match(hostClassNameRegex);})).join(_strSpace);doUpdate=doUpdateForce=true;}}
if(!doUpdate){doUpdate=mutationIsClass?hostClassNamesChanged(oldMutationVal,newClassVal):mutationAttrName===LEXICON.s?oldMutationVal!==mutationTarget[LEXICON.s].cssText:true;}
mutatedAttrs.push(mutationAttrName);});updateViewportAttrsFromTarget(mutatedAttrs);if(doUpdate)
_base.update(doUpdateForce||_strAuto);}
return doUpdate;};_mutationObserverContentCallback=function(mutations){var doUpdate=false;var mutation;if(_initialized&&!_sleeping){each(mutations,function(){mutation=this;doUpdate=isUnknownMutation(mutation);return!doUpdate;});if(doUpdate){now=COMPATIBILITY.now();sizeAuto=(_heightAutoCache||_widthAutoCache);action=function(){if(!_destroyed){contentLastUpdate=now;if(_isTextarea)
textareaUpdate();if(sizeAuto)
update();else
_base.update(_strAuto);}};clearTimeout(contentTimeout);if(mutationObserverContentLag<=0||now-contentLastUpdate>mutationObserverContentLag||!sizeAuto)
action();else
contentTimeout=setTimeout(action,mutationObserverContentLag);}}
return doUpdate;}
_mutationObserverHost=new mutationObserver(_mutationObserverHostCallback);_mutationObserverContent=new mutationObserver(_mutationObserverContentCallback);}}
function connectMutationObservers(){if(_supportMutationObserver&&!_mutationObserversConnected){_mutationObserverHost.observe(_hostElementNative,{attributes:true,attributeOldValue:true,attributeFilter:_mutationObserverAttrsHost});_mutationObserverContent.observe(_isTextarea?_targetElementNative:_contentElementNative,{attributes:true,attributeOldValue:true,subtree:!_isTextarea,childList:!_isTextarea,characterData:!_isTextarea,attributeFilter:_isTextarea?_mutationObserverAttrsTextarea:_mutationObserverAttrsHost});_mutationObserversConnected=true;}}
function disconnectMutationObservers(){if(_supportMutationObserver&&_mutationObserversConnected){_mutationObserverHost.disconnect();_mutationObserverContent.disconnect();_mutationObserversConnected=false;}}
function hostOnResized(){if(!_sleeping){var changed;var hostSize={w:_sizeObserverElementNative[LEXICON.sW],h:_sizeObserverElementNative[LEXICON.sH]};changed=checkCache(hostSize,_hostElementSizeChangeDetectedCache);_hostElementSizeChangeDetectedCache=hostSize;if(changed)
update({_hostSizeChanged:true});}}
function hostOnMouseEnter(){if(_scrollbarsAutoHideLeave)
refreshScrollbarsAutoHide(true);}
function hostOnMouseLeave(){if(_scrollbarsAutoHideLeave&&!_bodyElement.hasClass(_classNameDragging))
refreshScrollbarsAutoHide(false);}
function hostOnMouseMove(){if(_scrollbarsAutoHideMove){refreshScrollbarsAutoHide(true);clearTimeout(_scrollbarsAutoHideMoveTimeoutId);_scrollbarsAutoHideMoveTimeoutId=setTimeout(function(){if(_scrollbarsAutoHideMove&&!_destroyed)
refreshScrollbarsAutoHide(false);},100);}}
function documentOnSelectStart(event){COMPATIBILITY.prvD(event);return false;}
function updateOnLoadCallback(event){var elm=FRAMEWORK(event.target);eachUpdateOnLoad(function(i,updateOnLoadSelector){if(elm.is(updateOnLoadSelector)){update({_contentSizeChanged:true});}});}
function setupHostMouseTouchEvents(destroy){if(!destroy)
setupHostMouseTouchEvents(true);setupResponsiveEventListener(_hostElement,_strMouseTouchMoveEvent.split(_strSpace)[0],hostOnMouseMove,(!_scrollbarsAutoHideMove||destroy),true);setupResponsiveEventListener(_hostElement,[_strMouseEnter,_strMouseLeave],[hostOnMouseEnter,hostOnMouseLeave],(!_scrollbarsAutoHideLeave||destroy),true);if(!_initialized&&!destroy)
_hostElement.one('mouseover',hostOnMouseEnter);}
function bodyMinSizeChanged(){var bodyMinSize={};if(_isBody&&_contentArrangeElement){bodyMinSize.w=parseToZeroOrNumber(_contentArrangeElement.css(_strMinMinus+_strWidth));bodyMinSize.h=parseToZeroOrNumber(_contentArrangeElement.css(_strMinMinus+_strHeight));bodyMinSize.c=checkCache(bodyMinSize,_bodyMinSizeCache);bodyMinSize.f=true;}
_bodyMinSizeCache=bodyMinSize;return!!bodyMinSize.c;}
function hostClassNamesChanged(oldClassNames,newClassNames){var currClasses=typeof newClassNames==TYPES.s?newClassNames.split(_strSpace):[];var oldClasses=typeof oldClassNames==TYPES.s?oldClassNames.split(_strSpace):[];var diff=getArrayDifferences(oldClasses,currClasses);var idx=inArray(_classNameThemeNone,diff);var i;var regex;if(idx>-1)
diff.splice(idx,1);if(diff[LEXICON.l]>0){regex=createHostClassNameRegExp(true,true);for(i=0;i<diff.length;i++){if(!diff[i].match(regex)){return true;}}}
return false;}
function isUnknownMutation(mutation){var attributeName=mutation.attributeName;var mutationTarget=mutation.target;var mutationType=mutation.type;var strClosest='closest';if(mutationTarget===_contentElementNative)
return attributeName===null;if(mutationType==='attributes'&&(attributeName===LEXICON.c||attributeName===LEXICON.s)&&!_isTextarea){if(attributeName===LEXICON.c&&FRAMEWORK(mutationTarget).hasClass(_classNameHostElement))
return hostClassNamesChanged(mutation.oldValue,mutationTarget.className);if(typeof mutationTarget[strClosest]!=TYPES.f)
return true;if(mutationTarget[strClosest](_strDot+_classNameResizeObserverElement)!==null||mutationTarget[strClosest](_strDot+_classNameScrollbar)!==null||mutationTarget[strClosest](_strDot+_classNameScrollbarCorner)!==null)
return false;}
return true;}
function updateAutoContentSizeChanged(){if(_sleeping)
return false;var contentMeasureElement=getContentMeasureElement();var textareaValueLength=_isTextarea&&_widthAutoCache&&!_textareaAutoWrappingCache?_targetElement.val().length:0;var setCSS=!_mutationObserversConnected&&_widthAutoCache&&!_isTextarea;var css={};var float;var bodyMinSizeC;var changed;var contentElementScrollSize;if(setCSS){float=_contentElement.css(_strFloat);css[_strFloat]=_isRTL?_strRight:_strLeft;css[_strWidth]=_strAuto;_contentElement.css(css);}
contentElementScrollSize={w:contentMeasureElement[LEXICON.sW]+textareaValueLength,h:contentMeasureElement[LEXICON.sH]+textareaValueLength};if(setCSS){css[_strFloat]=float;css[_strWidth]=_strHundredPercent;_contentElement.css(css);}
bodyMinSizeC=bodyMinSizeChanged();changed=checkCache(contentElementScrollSize,_contentElementScrollSizeChangeDetectedCache);_contentElementScrollSizeChangeDetectedCache=contentElementScrollSize;return changed||bodyMinSizeC;}
function meaningfulAttrsChanged(){if(_sleeping||_mutationObserversConnected)
return;var elem;var curr;var cache;var changedAttrs=[];var checks=[{_elem:_hostElement,_attrs:_mutationObserverAttrsHost.concat(':visible')},{_elem:_isTextarea?_targetElement:undefined,_attrs:_mutationObserverAttrsTextarea}];each(checks,function(index,check){elem=check._elem;if(elem){each(check._attrs,function(index,attr){curr=attr.charAt(0)===':'?elem.is(attr):elem.attr(attr);cache=_updateAutoCache[attr];if(checkCache(curr,cache)){changedAttrs.push(attr);}
_updateAutoCache[attr]=curr;});}});updateViewportAttrsFromTarget(changedAttrs);return changedAttrs[LEXICON.l]>0;}
function isSizeAffectingCSSProperty(propertyName){if(!_initialized)
return true;var flexGrow='flex-grow';var flexShrink='flex-shrink';var flexBasis='flex-basis';var affectingPropsX=[_strWidth,_strMinMinus+_strWidth,_strMaxMinus+_strWidth,_strMarginMinus+_strLeft,_strMarginMinus+_strRight,_strLeft,_strRight,'font-weight','word-spacing',flexGrow,flexShrink,flexBasis];var affectingPropsXContentBox=[_strPaddingMinus+_strLeft,_strPaddingMinus+_strRight,_strBorderMinus+_strLeft+_strWidth,_strBorderMinus+_strRight+_strWidth];var affectingPropsY=[_strHeight,_strMinMinus+_strHeight,_strMaxMinus+_strHeight,_strMarginMinus+_strTop,_strMarginMinus+_strBottom,_strTop,_strBottom,'line-height',flexGrow,flexShrink,flexBasis];var affectingPropsYContentBox=[_strPaddingMinus+_strTop,_strPaddingMinus+_strBottom,_strBorderMinus+_strTop+_strWidth,_strBorderMinus+_strBottom+_strWidth];var _strS='s';var _strVS='v-s';var checkX=_overflowBehaviorCache.x===_strS||_overflowBehaviorCache.x===_strVS;var checkY=_overflowBehaviorCache.y===_strS||_overflowBehaviorCache.y===_strVS;var sizeIsAffected=false;var checkPropertyName=function(arr,name){for(var i=0;i<arr[LEXICON.l];i++){if(arr[i]===name)
return true;}
return false;};if(checkY){sizeIsAffected=checkPropertyName(affectingPropsY,propertyName);if(!sizeIsAffected&&!_isBorderBox)
sizeIsAffected=checkPropertyName(affectingPropsYContentBox,propertyName);}
if(checkX&&!sizeIsAffected){sizeIsAffected=checkPropertyName(affectingPropsX,propertyName);if(!sizeIsAffected&&!_isBorderBox)
sizeIsAffected=checkPropertyName(affectingPropsXContentBox,propertyName);}
return sizeIsAffected;}
function updateViewportAttrsFromTarget(attrs){attrs=attrs||_viewportAttrsFromTarget;each(attrs,function(index,attr){if(COMPATIBILITY.inA(attr,_viewportAttrsFromTarget)>-1){var targetAttr=_targetElement.attr(attr);if(type(targetAttr)==TYPES.s){_viewportElement.attr(attr,targetAttr);}
else{_viewportElement.removeAttr(attr);}}});}
function textareaUpdate(){if(!_sleeping){var wrapAttrOff=!_textareaAutoWrappingCache;var minWidth=_viewportSize.w;var minHeight=_viewportSize.h;var css={};var doMeasure=_widthAutoCache||wrapAttrOff;var origWidth;var width;var origHeight;var height;css[_strMinMinus+_strWidth]=_strEmpty;css[_strMinMinus+_strHeight]=_strEmpty;css[_strWidth]=_strAuto;_targetElement.css(css);origWidth=_targetElementNative[LEXICON.oW];width=doMeasure?MATH.max(origWidth,_targetElementNative[LEXICON.sW]-1):1;css[_strWidth]=_widthAutoCache?_strAuto :_strHundredPercent;css[_strMinMinus+_strWidth]=_strHundredPercent;css[_strHeight]=_strAuto;_targetElement.css(css);origHeight=_targetElementNative[LEXICON.oH];height=MATH.max(origHeight,_targetElementNative[LEXICON.sH]-1);css[_strWidth]=width;css[_strHeight]=height;_textareaCoverElement.css(css);css[_strMinMinus+_strWidth]=minWidth ;css[_strMinMinus+_strHeight]=minHeight ;_targetElement.css(css);return{_originalWidth:origWidth,_originalHeight:origHeight,_dynamicWidth:width,_dynamicHeight:height};}}
function update(updateHints){clearTimeout(_swallowedUpdateTimeout);updateHints=updateHints||{};_swallowedUpdateHints._hostSizeChanged|=updateHints._hostSizeChanged;_swallowedUpdateHints._contentSizeChanged|=updateHints._contentSizeChanged;_swallowedUpdateHints._force|=updateHints._force;var now=COMPATIBILITY.now();var hostSizeChanged=!!_swallowedUpdateHints._hostSizeChanged;var contentSizeChanged=!!_swallowedUpdateHints._contentSizeChanged;var force=!!_swallowedUpdateHints._force;var changedOptions=updateHints._changedOptions;var swallow=_swallowUpdateLag>0&&_initialized&&!_destroyed&&!force&&!changedOptions&&(now-_lastUpdateTime)<_swallowUpdateLag&&(!_heightAutoCache&&!_widthAutoCache);var displayIsHidden;if(swallow)
_swallowedUpdateTimeout=setTimeout(update,_swallowUpdateLag);if(_destroyed||swallow||(_sleeping&&!changedOptions)||(_initialized&&!force&&(displayIsHidden=_hostElement.is(':hidden')))||_hostElement.css('display')==='inline')
return;_lastUpdateTime=now;_swallowedUpdateHints={};if(_nativeScrollbarStyling&&!(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y)){_nativeScrollbarSize.x=0;_nativeScrollbarSize.y=0;}
else{_nativeScrollbarSize=extendDeep({},globals.nativeScrollbarSize);}
_nativeScrollbarMinSize={x:(_nativeScrollbarSize.x+(_nativeScrollbarIsOverlaid.x?0:3))*3,y:(_nativeScrollbarSize.y+(_nativeScrollbarIsOverlaid.y?0:3))*3};changedOptions=changedOptions||{};var checkCacheAutoForce=function(){return checkCache.apply(this,[].slice.call(arguments).concat([force]));};var currScroll={x:_viewportElement[_strScrollLeft](),y:_viewportElement[_strScrollTop]()};var currentPreparedOptionsScrollbars=_currentPreparedOptions.scrollbars;var currentPreparedOptionsTextarea=_currentPreparedOptions.textarea;var scrollbarsVisibility=currentPreparedOptionsScrollbars.visibility;var scrollbarsVisibilityChanged=checkCacheAutoForce(scrollbarsVisibility,_scrollbarsVisibilityCache);var scrollbarsAutoHide=currentPreparedOptionsScrollbars.autoHide;var scrollbarsAutoHideChanged=checkCacheAutoForce(scrollbarsAutoHide,_scrollbarsAutoHideCache);var scrollbarsClickScrolling=currentPreparedOptionsScrollbars.clickScrolling;var scrollbarsClickScrollingChanged=checkCacheAutoForce(scrollbarsClickScrolling,_scrollbarsClickScrollingCache);var scrollbarsDragScrolling=currentPreparedOptionsScrollbars.dragScrolling;var scrollbarsDragScrollingChanged=checkCacheAutoForce(scrollbarsDragScrolling,_scrollbarsDragScrollingCache);var className=_currentPreparedOptions.className;var classNameChanged=checkCacheAutoForce(className,_classNameCache);var resize=_currentPreparedOptions.resize;var resizeChanged=checkCacheAutoForce(resize,_resizeCache)&&!_isBody;var paddingAbsolute=_currentPreparedOptions.paddingAbsolute;var paddingAbsoluteChanged=checkCacheAutoForce(paddingAbsolute,_paddingAbsoluteCache);var clipAlways=_currentPreparedOptions.clipAlways;var clipAlwaysChanged=checkCacheAutoForce(clipAlways,_clipAlwaysCache);var sizeAutoCapable=_currentPreparedOptions.sizeAutoCapable&&!_isBody;var sizeAutoCapableChanged=checkCacheAutoForce(sizeAutoCapable,_sizeAutoCapableCache);var ignoreOverlayScrollbarHiding=_currentPreparedOptions.nativeScrollbarsOverlaid.showNativeScrollbars;var ignoreOverlayScrollbarHidingChanged=checkCacheAutoForce(ignoreOverlayScrollbarHiding,_ignoreOverlayScrollbarHidingCache);var autoUpdate=_currentPreparedOptions.autoUpdate;var autoUpdateChanged=checkCacheAutoForce(autoUpdate,_autoUpdateCache);var overflowBehavior=_currentPreparedOptions.overflowBehavior;var overflowBehaviorChanged=checkCacheAutoForce(overflowBehavior,_overflowBehaviorCache,force);var textareaDynWidth=currentPreparedOptionsTextarea.dynWidth;var textareaDynWidthChanged=checkCacheAutoForce(_textareaDynWidthCache,textareaDynWidth);var textareaDynHeight=currentPreparedOptionsTextarea.dynHeight;var textareaDynHeightChanged=checkCacheAutoForce(_textareaDynHeightCache,textareaDynHeight);_scrollbarsAutoHideNever=scrollbarsAutoHide==='n';_scrollbarsAutoHideScroll=scrollbarsAutoHide==='s';_scrollbarsAutoHideMove=scrollbarsAutoHide==='m';_scrollbarsAutoHideLeave=scrollbarsAutoHide==='l';_scrollbarsAutoHideDelay=currentPreparedOptionsScrollbars.autoHideDelay;_oldClassName=_classNameCache;_resizeNone=resize==='n';_resizeBoth=resize==='b';_resizeHorizontal=resize==='h';_resizeVertical=resize==='v';_normalizeRTLCache=_currentPreparedOptions.normalizeRTL;ignoreOverlayScrollbarHiding=ignoreOverlayScrollbarHiding&&(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y);_scrollbarsVisibilityCache=scrollbarsVisibility;_scrollbarsAutoHideCache=scrollbarsAutoHide;_scrollbarsClickScrollingCache=scrollbarsClickScrolling;_scrollbarsDragScrollingCache=scrollbarsDragScrolling;_classNameCache=className;_resizeCache=resize;_paddingAbsoluteCache=paddingAbsolute;_clipAlwaysCache=clipAlways;_sizeAutoCapableCache=sizeAutoCapable;_ignoreOverlayScrollbarHidingCache=ignoreOverlayScrollbarHiding;_autoUpdateCache=autoUpdate;_overflowBehaviorCache=extendDeep({},overflowBehavior);_textareaDynWidthCache=textareaDynWidth;_textareaDynHeightCache=textareaDynHeight;_hasOverflowCache=_hasOverflowCache||{x:false,y:false};if(classNameChanged){removeClass(_hostElement,_oldClassName+_strSpace+_classNameThemeNone);addClass(_hostElement,className!==undefined&&className!==null&&className.length>0?className:_classNameThemeNone);}
if(autoUpdateChanged){if(autoUpdate===true||(autoUpdate===null&&_autoUpdateRecommended)){disconnectMutationObservers();autoUpdateLoop.add(_base);}
else{autoUpdateLoop.remove(_base);connectMutationObservers();}}
if(sizeAutoCapableChanged){if(sizeAutoCapable){if(_contentGlueElement){_contentGlueElement.show();}
else{_contentGlueElement=FRAMEWORK(generateDiv(_classNameContentGlueElement));_paddingElement.before(_contentGlueElement);}
if(_sizeAutoObserverAdded){_sizeAutoObserverElement.show();}
else{_sizeAutoObserverElement=FRAMEWORK(generateDiv(_classNameSizeAutoObserverElement));_sizeAutoObserverElementNative=_sizeAutoObserverElement[0];_contentGlueElement.before(_sizeAutoObserverElement);var oldSize={w:-1,h:-1};setupResizeObserver(_sizeAutoObserverElement,function(){var newSize={w:_sizeAutoObserverElementNative[LEXICON.oW],h:_sizeAutoObserverElementNative[LEXICON.oH]};if(checkCache(newSize,oldSize)){if(_initialized&&(_heightAutoCache&&newSize.h>0)||(_widthAutoCache&&newSize.w>0)){update();}
else if(_initialized&&(!_heightAutoCache&&newSize.h===0)||(!_widthAutoCache&&newSize.w===0)){update();}}
oldSize=newSize;});_sizeAutoObserverAdded=true;if(_cssCalc!==null)
_sizeAutoObserverElement.css(_strHeight,_cssCalc+'(100% + 1px)');}}
else{if(_sizeAutoObserverAdded)
_sizeAutoObserverElement.hide();if(_contentGlueElement)
_contentGlueElement.hide();}}
if(force){_sizeObserverElement.find('*').trigger(_strScroll);if(_sizeAutoObserverAdded)
_sizeAutoObserverElement.find('*').trigger(_strScroll);}
displayIsHidden=displayIsHidden===undefined?_hostElement.is(':hidden'):displayIsHidden;var textareaAutoWrapping=_isTextarea?_targetElement.attr('wrap')!=='off':false;var textareaAutoWrappingChanged=checkCacheAutoForce(textareaAutoWrapping,_textareaAutoWrappingCache);var cssDirection=_hostElement.css('direction');var cssDirectionChanged=checkCacheAutoForce(cssDirection,_cssDirectionCache);var boxSizing=_hostElement.css('box-sizing');var boxSizingChanged=checkCacheAutoForce(boxSizing,_cssBoxSizingCache);var padding=getTopRightBottomLeftHost(_strPaddingMinus);var sizeAutoObserverElementBCRect;try{sizeAutoObserverElementBCRect=_sizeAutoObserverAdded?_sizeAutoObserverElementNative[LEXICON.bCR]():null;}catch(ex){return;}
_isRTL=cssDirection==='rtl';_isBorderBox=(boxSizing==='border-box');var isRTLLeft=_isRTL?_strLeft:_strRight;var isRTLRight=_isRTL?_strRight:_strLeft;var widthAutoResizeDetection=false;var widthAutoObserverDetection=(_sizeAutoObserverAdded&&(_hostElement.css(_strFloat)!=='none'))?(MATH.round(sizeAutoObserverElementBCRect.right-sizeAutoObserverElementBCRect.left)===0)&&(!paddingAbsolute?(_hostElementNative[LEXICON.cW]-_paddingX)>0:true):false;if(sizeAutoCapable&&!widthAutoObserverDetection){var tmpCurrHostWidth=_hostElementNative[LEXICON.oW];var tmpCurrContentGlueWidth=_contentGlueElement.css(_strWidth);_contentGlueElement.css(_strWidth,_strAuto);var tmpNewHostWidth=_hostElementNative[LEXICON.oW];_contentGlueElement.css(_strWidth,tmpCurrContentGlueWidth);widthAutoResizeDetection=tmpCurrHostWidth!==tmpNewHostWidth;if(!widthAutoResizeDetection){_contentGlueElement.css(_strWidth,tmpCurrHostWidth+1);tmpNewHostWidth=_hostElementNative[LEXICON.oW];_contentGlueElement.css(_strWidth,tmpCurrContentGlueWidth);widthAutoResizeDetection=tmpCurrHostWidth!==tmpNewHostWidth;}}
var widthAuto=(widthAutoObserverDetection||widthAutoResizeDetection)&&sizeAutoCapable&&!displayIsHidden;var widthAutoChanged=checkCacheAutoForce(widthAuto,_widthAutoCache);var wasWidthAuto=!widthAuto&&_widthAutoCache;var heightAuto=_sizeAutoObserverAdded&&sizeAutoCapable&&!displayIsHidden?(MATH.round(sizeAutoObserverElementBCRect.bottom-sizeAutoObserverElementBCRect.top)===0):false;var heightAutoChanged=checkCacheAutoForce(heightAuto,_heightAutoCache);var wasHeightAuto=!heightAuto&&_heightAutoCache;var updateBorderX=(widthAuto&&_isBorderBox)||!_isBorderBox;var updateBorderY=(heightAuto&&_isBorderBox)||!_isBorderBox;var border=getTopRightBottomLeftHost(_strBorderMinus,'-'+_strWidth,!updateBorderX,!updateBorderY)
var margin=getTopRightBottomLeftHost(_strMarginMinus);var contentElementCSS={};var contentGlueElementCSS={};var getHostSize=function(){return{w:_hostElementNative[LEXICON.cW],h:_hostElementNative[LEXICON.cH]};};var getViewportSize=function(){return{w:_paddingElementNative[LEXICON.oW]+MATH.max(0,_contentElementNative[LEXICON.cW]-_contentElementNative[LEXICON.sW]),h:_paddingElementNative[LEXICON.oH]+MATH.max(0,_contentElementNative[LEXICON.cH]-_contentElementNative[LEXICON.sH])};};var paddingAbsoluteX=_paddingX=padding.l+padding.r;var paddingAbsoluteY=_paddingY=padding.t+padding.b;paddingAbsoluteX*=paddingAbsolute?1:0;paddingAbsoluteY*=paddingAbsolute?1:0;padding.c=checkCacheAutoForce(padding,_cssPaddingCache);_borderX=border.l+border.r;_borderY=border.t+border.b;border.c=checkCacheAutoForce(border,_cssBorderCache);_marginX=margin.l+margin.r;_marginY=margin.t+margin.b;margin.c=checkCacheAutoForce(margin,_cssMarginCache);_textareaAutoWrappingCache=textareaAutoWrapping;_cssDirectionCache=cssDirection;_cssBoxSizingCache=boxSizing;_widthAutoCache=widthAuto;_heightAutoCache=heightAuto;_cssPaddingCache=padding;_cssBorderCache=border;_cssMarginCache=margin;if(cssDirectionChanged&&_sizeAutoObserverAdded)
_sizeAutoObserverElement.css(_strFloat,isRTLRight);if(padding.c||cssDirectionChanged||paddingAbsoluteChanged||widthAutoChanged||heightAutoChanged||boxSizingChanged||sizeAutoCapableChanged){var paddingElementCSS={};var textareaCSS={};var paddingValues=[padding.t,padding.r,padding.b,padding.l];setTopRightBottomLeft(contentGlueElementCSS,_strMarginMinus,[-padding.t,-padding.r,-padding.b,-padding.l]);if(paddingAbsolute){setTopRightBottomLeft(paddingElementCSS,_strEmpty,paddingValues);setTopRightBottomLeft(_isTextarea?textareaCSS:contentElementCSS,_strPaddingMinus);}
else{setTopRightBottomLeft(paddingElementCSS,_strEmpty);setTopRightBottomLeft(_isTextarea?textareaCSS:contentElementCSS,_strPaddingMinus,paddingValues);}
_paddingElement.css(paddingElementCSS);_targetElement.css(textareaCSS);}
_viewportSize=getViewportSize();var textareaSize=_isTextarea?textareaUpdate():false;var textareaSizeChanged=_isTextarea&&checkCacheAutoForce(textareaSize,_textareaSizeCache);var textareaDynOrigSize=_isTextarea&&textareaSize?{w:textareaDynWidth?textareaSize._dynamicWidth:textareaSize._originalWidth,h:textareaDynHeight?textareaSize._dynamicHeight:textareaSize._originalHeight}:{};_textareaSizeCache=textareaSize;if(heightAuto&&(heightAutoChanged||paddingAbsoluteChanged||boxSizingChanged||padding.c||border.c)){contentElementCSS[_strHeight]=_strAuto;}
else if(heightAutoChanged||paddingAbsoluteChanged){contentElementCSS[_strHeight]=_strHundredPercent;}
if(widthAuto&&(widthAutoChanged||paddingAbsoluteChanged||boxSizingChanged||padding.c||border.c||cssDirectionChanged)){contentElementCSS[_strWidth]=_strAuto;contentGlueElementCSS[_strMaxMinus+_strWidth]=_strHundredPercent;}
else if(widthAutoChanged||paddingAbsoluteChanged){contentElementCSS[_strWidth]=_strHundredPercent;contentElementCSS[_strFloat]=_strEmpty;contentGlueElementCSS[_strMaxMinus+_strWidth]=_strEmpty;}
if(widthAuto){contentGlueElementCSS[_strWidth]=_strAuto;contentElementCSS[_strWidth]=VENDORS._cssPropertyValue(_strWidth,'max-content intrinsic')||_strAuto;contentElementCSS[_strFloat]=isRTLRight;}
else{contentGlueElementCSS[_strWidth]=_strEmpty;}
if(heightAuto){contentGlueElementCSS[_strHeight]=textareaDynOrigSize.h||_contentElementNative[LEXICON.cH];}
else{contentGlueElementCSS[_strHeight]=_strEmpty;}
if(sizeAutoCapable)
_contentGlueElement.css(contentGlueElementCSS);_contentElement.css(contentElementCSS);contentElementCSS={};contentGlueElementCSS={};if(hostSizeChanged||contentSizeChanged||textareaSizeChanged||cssDirectionChanged||boxSizingChanged||paddingAbsoluteChanged||widthAutoChanged||widthAuto||heightAutoChanged||heightAuto||ignoreOverlayScrollbarHidingChanged||overflowBehaviorChanged||clipAlwaysChanged||resizeChanged||scrollbarsVisibilityChanged||scrollbarsAutoHideChanged||scrollbarsDragScrollingChanged||scrollbarsClickScrollingChanged||textareaDynWidthChanged||textareaDynHeightChanged||textareaAutoWrappingChanged){var strOverflow='overflow';var strOverflowX=strOverflow+'-x';var strOverflowY=strOverflow+'-y';var strHidden='hidden';var strVisible='visible';if(!_nativeScrollbarStyling){var viewportElementResetCSS={};var resetXTmp=_hasOverflowCache.y&&_hideOverflowCache.ys&&!ignoreOverlayScrollbarHiding?(_nativeScrollbarIsOverlaid.y?_viewportElement.css(isRTLLeft):-_nativeScrollbarSize.y):0;var resetBottomTmp=_hasOverflowCache.x&&_hideOverflowCache.xs&&!ignoreOverlayScrollbarHiding?(_nativeScrollbarIsOverlaid.x?_viewportElement.css(_strBottom):-_nativeScrollbarSize.x):0;setTopRightBottomLeft(viewportElementResetCSS,_strEmpty);_viewportElement.css(viewportElementResetCSS);}
var contentMeasureElement=getContentMeasureElement();var contentSize={w:textareaDynOrigSize.w||contentMeasureElement[LEXICON.cW],h:textareaDynOrigSize.h||contentMeasureElement[LEXICON.cH]};var scrollSize={w:contentMeasureElement[LEXICON.sW],h:contentMeasureElement[LEXICON.sH]};if(!_nativeScrollbarStyling){viewportElementResetCSS[_strBottom]=wasHeightAuto?_strEmpty:resetBottomTmp;viewportElementResetCSS[isRTLLeft]=wasWidthAuto?_strEmpty:resetXTmp;_viewportElement.css(viewportElementResetCSS);}
_viewportSize=getViewportSize();var hostSize=getHostSize();var hostAbsoluteRectSize={w:hostSize.w-_marginX-_borderX-(_isBorderBox?0:_paddingX),h:hostSize.h-_marginY-_borderY-(_isBorderBox?0:_paddingY)};var contentGlueSize={w:MATH.max((widthAuto?contentSize.w:scrollSize.w)+paddingAbsoluteX,hostAbsoluteRectSize.w),h:MATH.max((heightAuto?contentSize.h:scrollSize.h)+paddingAbsoluteY,hostAbsoluteRectSize.h)};contentGlueSize.c=checkCacheAutoForce(contentGlueSize,_contentGlueSizeCache);_contentGlueSizeCache=contentGlueSize;if(sizeAutoCapable){if(contentGlueSize.c||(heightAuto||widthAuto)){contentGlueElementCSS[_strWidth]=contentGlueSize.w;contentGlueElementCSS[_strHeight]=contentGlueSize.h;if(!_isTextarea){contentSize={w:contentMeasureElement[LEXICON.cW],h:contentMeasureElement[LEXICON.cH]};}}
var textareaCoverCSS={};var setContentGlueElementCSSfunction=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var wh=scrollbarVars._w_h;var strWH=scrollbarVars._width_height;var autoSize=horizontal?widthAuto:heightAuto;var borderSize=horizontal?_borderX:_borderY;var paddingSize=horizontal?_paddingX:_paddingY;var marginSize=horizontal?_marginX:_marginY;var viewportSize=_viewportSize[wh]-borderSize-marginSize-(_isBorderBox?0:paddingSize);if(!autoSize||(!autoSize&&border.c))
contentGlueElementCSS[strWH]=hostAbsoluteRectSize[wh]-1;if(autoSize&&(contentSize[wh]<viewportSize)&&(horizontal&&_isTextarea?!textareaAutoWrapping:true)){if(_isTextarea)
textareaCoverCSS[strWH]=parseToZeroOrNumber(_textareaCoverElement.css(strWH))-1;contentGlueElementCSS[strWH]-=1;}
if(contentSize[wh]>0)
contentGlueElementCSS[strWH]=MATH.max(1,contentGlueElementCSS[strWH]);};setContentGlueElementCSSfunction(true);setContentGlueElementCSSfunction(false);if(_isTextarea)
_textareaCoverElement.css(textareaCoverCSS);_contentGlueElement.css(contentGlueElementCSS);}
if(widthAuto)
contentElementCSS[_strWidth]=_strHundredPercent;if(widthAuto&&!_isBorderBox&&!_mutationObserversConnected)
contentElementCSS[_strFloat]='none';_contentElement.css(contentElementCSS);contentElementCSS={};var contentScrollSize={w:contentMeasureElement[LEXICON.sW],h:contentMeasureElement[LEXICON.sH],};contentScrollSize.c=contentSizeChanged=checkCacheAutoForce(contentScrollSize,_contentScrollSizeCache);_contentScrollSizeCache=contentScrollSize;_viewportSize=getViewportSize();hostSize=getHostSize();hostSizeChanged=checkCacheAutoForce(hostSize,_hostSizeCache);_hostSizeCache=hostSize;var hideOverflowForceTextarea=_isTextarea&&(_viewportSize.w===0||_viewportSize.h===0);var previousOverflowAmount=_overflowAmountCache;var overflowBehaviorIsVS={};var overflowBehaviorIsVH={};var overflowBehaviorIsS={};var overflowAmount={};var hasOverflow={};var hideOverflow={};var canScroll={};var viewportRect=_paddingElementNative[LEXICON.bCR]();var setOverflowVariables=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var scrollbarVarsInverted=getScrollbarVars(!horizontal);var xyI=scrollbarVarsInverted._x_y;var xy=scrollbarVars._x_y;var wh=scrollbarVars._w_h;var widthHeight=scrollbarVars._width_height;var scrollMax=_strScroll+scrollbarVars._Left_Top+'Max';var fractionalOverflowAmount=viewportRect[widthHeight]?MATH.abs(viewportRect[widthHeight]-_viewportSize[wh]):0;var checkFractionalOverflowAmount=previousOverflowAmount&&previousOverflowAmount[xy]>0&&_viewportElementNative[scrollMax]===0;overflowBehaviorIsVS[xy]=overflowBehavior[xy]==='v-s';overflowBehaviorIsVH[xy]=overflowBehavior[xy]==='v-h';overflowBehaviorIsS[xy]=overflowBehavior[xy]==='s';overflowAmount[xy]=MATH.max(0,MATH.round((contentScrollSize[wh]-_viewportSize[wh])*100)/100);overflowAmount[xy]*=(hideOverflowForceTextarea||(checkFractionalOverflowAmount&&fractionalOverflowAmount>0&&fractionalOverflowAmount<1))?0:1;hasOverflow[xy]=overflowAmount[xy]>0;hideOverflow[xy]=overflowBehaviorIsVS[xy]||overflowBehaviorIsVH[xy]?(hasOverflow[xyI]&&!overflowBehaviorIsVS[xyI]&&!overflowBehaviorIsVH[xyI]):hasOverflow[xy];hideOverflow[xy+'s']=hideOverflow[xy]?(overflowBehaviorIsS[xy]||overflowBehaviorIsVS[xy]):false;canScroll[xy]=hasOverflow[xy]&&hideOverflow[xy+'s'];};setOverflowVariables(true);setOverflowVariables(false);overflowAmount.c=checkCacheAutoForce(overflowAmount,_overflowAmountCache);_overflowAmountCache=overflowAmount;hasOverflow.c=checkCacheAutoForce(hasOverflow,_hasOverflowCache);_hasOverflowCache=hasOverflow;hideOverflow.c=checkCacheAutoForce(hideOverflow,_hideOverflowCache);_hideOverflowCache=hideOverflow;if(_nativeScrollbarIsOverlaid.x||_nativeScrollbarIsOverlaid.y){var borderDesign='px solid transparent';var contentArrangeElementCSS={};var arrangeContent={};var arrangeChanged=force;var setContentElementCSS;if(hasOverflow.x||hasOverflow.y){arrangeContent.w=_nativeScrollbarIsOverlaid.y&&hasOverflow.y?contentScrollSize.w+_overlayScrollbarDummySize.y:_strEmpty;arrangeContent.h=_nativeScrollbarIsOverlaid.x&&hasOverflow.x?contentScrollSize.h+_overlayScrollbarDummySize.x:_strEmpty;arrangeChanged=checkCacheAutoForce(arrangeContent,_arrangeContentSizeCache);_arrangeContentSizeCache=arrangeContent;}
if(hasOverflow.c||hideOverflow.c||contentScrollSize.c||cssDirectionChanged||widthAutoChanged||heightAutoChanged||widthAuto||heightAuto||ignoreOverlayScrollbarHidingChanged){contentElementCSS[_strMarginMinus+isRTLRight]=contentElementCSS[_strBorderMinus+isRTLRight]=_strEmpty;setContentElementCSS=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var scrollbarVarsInverted=getScrollbarVars(!horizontal);var xy=scrollbarVars._x_y;var strDirection=horizontal?_strBottom:isRTLLeft;var invertedAutoSize=horizontal?heightAuto:widthAuto;if(_nativeScrollbarIsOverlaid[xy]&&hasOverflow[xy]&&hideOverflow[xy+'s']){contentElementCSS[_strMarginMinus+strDirection]=invertedAutoSize?(ignoreOverlayScrollbarHiding?_strEmpty:_overlayScrollbarDummySize[xy]):_strEmpty;contentElementCSS[_strBorderMinus+strDirection]=((horizontal?!invertedAutoSize:true)&&!ignoreOverlayScrollbarHiding)?(_overlayScrollbarDummySize[xy]+borderDesign):_strEmpty;}
else{arrangeContent[scrollbarVarsInverted._w_h]=contentElementCSS[_strMarginMinus+strDirection]=contentElementCSS[_strBorderMinus+strDirection]=_strEmpty;arrangeChanged=true;}};if(_nativeScrollbarStyling){addRemoveClass(_viewportElement,_classNameViewportNativeScrollbarsInvisible,!ignoreOverlayScrollbarHiding)}
else{setContentElementCSS(true);setContentElementCSS(false);}}
if(ignoreOverlayScrollbarHiding){arrangeContent.w=arrangeContent.h=_strEmpty;arrangeChanged=true;}
if(arrangeChanged&&!_nativeScrollbarStyling){contentArrangeElementCSS[_strWidth]=hideOverflow.y?arrangeContent.w:_strEmpty;contentArrangeElementCSS[_strHeight]=hideOverflow.x?arrangeContent.h:_strEmpty;if(!_contentArrangeElement){_contentArrangeElement=FRAMEWORK(generateDiv(_classNameContentArrangeElement));_viewportElement.prepend(_contentArrangeElement);}
_contentArrangeElement.css(contentArrangeElementCSS);}
_contentElement.css(contentElementCSS);}
var viewportElementCSS={};var paddingElementCSS={};var setViewportCSS;if(hostSizeChanged||hasOverflow.c||hideOverflow.c||contentScrollSize.c||overflowBehaviorChanged||boxSizingChanged||ignoreOverlayScrollbarHidingChanged||cssDirectionChanged||clipAlwaysChanged||heightAutoChanged){viewportElementCSS[isRTLRight]=_strEmpty;setViewportCSS=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var scrollbarVarsInverted=getScrollbarVars(!horizontal);var xy=scrollbarVars._x_y;var XY=scrollbarVars._X_Y;var strDirection=horizontal?_strBottom:isRTLLeft;var reset=function(){viewportElementCSS[strDirection]=_strEmpty;_contentBorderSize[scrollbarVarsInverted._w_h]=0;};if(hasOverflow[xy]&&hideOverflow[xy+'s']){viewportElementCSS[strOverflow+XY]=_strScroll;if(ignoreOverlayScrollbarHiding||_nativeScrollbarStyling){reset();}
else{viewportElementCSS[strDirection]=-(_nativeScrollbarIsOverlaid[xy]?_overlayScrollbarDummySize[xy]:_nativeScrollbarSize[xy]);_contentBorderSize[scrollbarVarsInverted._w_h]=_nativeScrollbarIsOverlaid[xy]?_overlayScrollbarDummySize[scrollbarVarsInverted._x_y]:0;}}else{viewportElementCSS[strOverflow+XY]=_strEmpty;reset();}};setViewportCSS(true);setViewportCSS(false);if(!_nativeScrollbarStyling&&(_viewportSize.h<_nativeScrollbarMinSize.x||_viewportSize.w<_nativeScrollbarMinSize.y)&&((hasOverflow.x&&hideOverflow.x&&!_nativeScrollbarIsOverlaid.x)||(hasOverflow.y&&hideOverflow.y&&!_nativeScrollbarIsOverlaid.y))){viewportElementCSS[_strPaddingMinus+_strTop]=_nativeScrollbarMinSize.x;viewportElementCSS[_strMarginMinus+_strTop]=-_nativeScrollbarMinSize.x;viewportElementCSS[_strPaddingMinus+isRTLRight]=_nativeScrollbarMinSize.y;viewportElementCSS[_strMarginMinus+isRTLRight]=-_nativeScrollbarMinSize.y;}
else{viewportElementCSS[_strPaddingMinus+_strTop]=viewportElementCSS[_strMarginMinus+_strTop]=viewportElementCSS[_strPaddingMinus+isRTLRight]=viewportElementCSS[_strMarginMinus+isRTLRight]=_strEmpty;}
viewportElementCSS[_strPaddingMinus+isRTLLeft]=viewportElementCSS[_strMarginMinus+isRTLLeft]=_strEmpty;if((hasOverflow.x&&hideOverflow.x)||(hasOverflow.y&&hideOverflow.y)||hideOverflowForceTextarea){if(_isTextarea&&hideOverflowForceTextarea){paddingElementCSS[strOverflowX]=paddingElementCSS[strOverflowY]=strHidden;}}
else{if(!clipAlways||(overflowBehaviorIsVH.x||overflowBehaviorIsVS.x||overflowBehaviorIsVH.y||overflowBehaviorIsVS.y)){if(_isTextarea){paddingElementCSS[strOverflowX]=paddingElementCSS[strOverflowY]=_strEmpty;}
viewportElementCSS[strOverflowX]=viewportElementCSS[strOverflowY]=strVisible;}}
_paddingElement.css(paddingElementCSS);_viewportElement.css(viewportElementCSS);viewportElementCSS={};if((hasOverflow.c||boxSizingChanged||widthAutoChanged||heightAutoChanged)&&!(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y)){var elementStyle=_contentElementNative[LEXICON.s];var dump;elementStyle.webkitTransform='scale(1)';elementStyle.display='run-in';dump=_contentElementNative[LEXICON.oH];elementStyle.display=_strEmpty;elementStyle.webkitTransform=_strEmpty;}
}
contentElementCSS={};if(cssDirectionChanged||widthAutoChanged||heightAutoChanged){if(_isRTL&&widthAuto){var floatTmp=_contentElement.css(_strFloat);var posLeftWithoutFloat=MATH.round(_contentElement.css(_strFloat,_strEmpty).css(_strLeft,_strEmpty).position().left);_contentElement.css(_strFloat,floatTmp);var posLeftWithFloat=MATH.round(_contentElement.position().left);if(posLeftWithoutFloat!==posLeftWithFloat)
contentElementCSS[_strLeft]=posLeftWithoutFloat;}
else{contentElementCSS[_strLeft]=_strEmpty;}}
_contentElement.css(contentElementCSS);if(_isTextarea&&contentSizeChanged){var textareaInfo=getTextareaInfo();if(textareaInfo){var textareaRowsChanged=_textareaInfoCache===undefined?true:textareaInfo._rows!==_textareaInfoCache._rows;var cursorRow=textareaInfo._cursorRow;var cursorCol=textareaInfo._cursorColumn;var widestRow=textareaInfo._widestRow;var lastRow=textareaInfo._rows;var lastCol=textareaInfo._columns;var cursorPos=textareaInfo._cursorPosition;var cursorMax=textareaInfo._cursorMax;var cursorIsLastPosition=(cursorPos>=cursorMax&&_textareaHasFocus);var textareaScrollAmount={x:(!textareaAutoWrapping&&(cursorCol===lastCol&&cursorRow===widestRow))?_overflowAmountCache.x:-1,y:(textareaAutoWrapping?cursorIsLastPosition||textareaRowsChanged&&(previousOverflowAmount?(currScroll.y===previousOverflowAmount.y):false):(cursorIsLastPosition||textareaRowsChanged)&&cursorRow===lastRow)?_overflowAmountCache.y:-1};currScroll.x=textareaScrollAmount.x>-1?(_isRTL&&_normalizeRTLCache&&_rtlScrollBehavior.i?0:textareaScrollAmount.x):currScroll.x;currScroll.y=textareaScrollAmount.y>-1?textareaScrollAmount.y:currScroll.y;}
_textareaInfoCache=textareaInfo;}
if(_isRTL&&_rtlScrollBehavior.i&&_nativeScrollbarIsOverlaid.y&&hasOverflow.x&&_normalizeRTLCache)
currScroll.x+=_contentBorderSize.w||0;if(widthAuto)
_hostElement[_strScrollLeft](0);if(heightAuto)
_hostElement[_strScrollTop](0);_viewportElement[_strScrollLeft](currScroll.x)[_strScrollTop](currScroll.y);var scrollbarsVisibilityVisible=scrollbarsVisibility==='v';var scrollbarsVisibilityHidden=scrollbarsVisibility==='h';var scrollbarsVisibilityAuto=scrollbarsVisibility==='a';var refreshScrollbarsVisibility=function(showX,showY){showY=showY===undefined?showX:showY;refreshScrollbarAppearance(true,showX,canScroll.x)
refreshScrollbarAppearance(false,showY,canScroll.y)};addRemoveClass(_hostElement,_classNameHostOverflow,hideOverflow.x||hideOverflow.y);addRemoveClass(_hostElement,_classNameHostOverflowX,hideOverflow.x);addRemoveClass(_hostElement,_classNameHostOverflowY,hideOverflow.y);if(cssDirectionChanged&&!_isBody){addRemoveClass(_hostElement,_classNameHostRTL,_isRTL);}
if(_isBody)
addClass(_hostElement,_classNameHostResizeDisabled);if(resizeChanged){addRemoveClass(_hostElement,_classNameHostResizeDisabled,_resizeNone);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResize,!_resizeNone);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResizeB,_resizeBoth);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResizeH,_resizeHorizontal);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResizeV,_resizeVertical);}
if(scrollbarsVisibilityChanged||overflowBehaviorChanged||hideOverflow.c||hasOverflow.c||ignoreOverlayScrollbarHidingChanged){if(ignoreOverlayScrollbarHiding){if(ignoreOverlayScrollbarHidingChanged){removeClass(_hostElement,_classNameHostScrolling);if(ignoreOverlayScrollbarHiding){refreshScrollbarsVisibility(false);}}}
else if(scrollbarsVisibilityAuto){refreshScrollbarsVisibility(canScroll.x,canScroll.y);}
else if(scrollbarsVisibilityVisible){refreshScrollbarsVisibility(true);}
else if(scrollbarsVisibilityHidden){refreshScrollbarsVisibility(false);}}
if(scrollbarsAutoHideChanged||ignoreOverlayScrollbarHidingChanged){setupHostMouseTouchEvents(!_scrollbarsAutoHideLeave&&!_scrollbarsAutoHideMove);refreshScrollbarsAutoHide(_scrollbarsAutoHideNever,!_scrollbarsAutoHideNever);}
if(hostSizeChanged||overflowAmount.c||heightAutoChanged||widthAutoChanged||resizeChanged||boxSizingChanged||paddingAbsoluteChanged||ignoreOverlayScrollbarHidingChanged||cssDirectionChanged){refreshScrollbarHandleLength(true);refreshScrollbarHandleOffset(true);refreshScrollbarHandleLength(false);refreshScrollbarHandleOffset(false);}
if(scrollbarsClickScrollingChanged)
refreshScrollbarsInteractive(true,scrollbarsClickScrolling);if(scrollbarsDragScrollingChanged)
refreshScrollbarsInteractive(false,scrollbarsDragScrolling);dispatchCallback('onDirectionChanged',{isRTL:_isRTL,dir:cssDirection},cssDirectionChanged);dispatchCallback('onHostSizeChanged',{width:_hostSizeCache.w,height:_hostSizeCache.h},hostSizeChanged);dispatchCallback('onContentSizeChanged',{width:_contentScrollSizeCache.w,height:_contentScrollSizeCache.h},contentSizeChanged);dispatchCallback('onOverflowChanged',{x:hasOverflow.x,y:hasOverflow.y,xScrollable:hideOverflow.xs,yScrollable:hideOverflow.ys,clipped:hideOverflow.x||hideOverflow.y},hasOverflow.c||hideOverflow.c);dispatchCallback('onOverflowAmountChanged',{x:overflowAmount.x,y:overflowAmount.y},overflowAmount.c);}
if(_isBody&&_bodyMinSizeCache&&(_hasOverflowCache.c||_bodyMinSizeCache.c)){if(!_bodyMinSizeCache.f)
bodyMinSizeChanged();if(_nativeScrollbarIsOverlaid.y&&_hasOverflowCache.x)
_contentElement.css(_strMinMinus+_strWidth,_bodyMinSizeCache.w+_overlayScrollbarDummySize.y);if(_nativeScrollbarIsOverlaid.x&&_hasOverflowCache.y)
_contentElement.css(_strMinMinus+_strHeight,_bodyMinSizeCache.h+_overlayScrollbarDummySize.x);_bodyMinSizeCache.c=false;}
if(_initialized&&changedOptions.updateOnLoad){updateElementsOnLoad();}
dispatchCallback('onUpdated',{forced:force});}
function updateElementsOnLoad(){if(!_isTextarea){eachUpdateOnLoad(function(i,updateOnLoadSelector){_contentElement.find(updateOnLoadSelector).each(function(i,el){if(COMPATIBILITY.inA(el,_updateOnLoadElms)<0){_updateOnLoadElms.push(el);FRAMEWORK(el).off(_updateOnLoadEventName,updateOnLoadCallback).on(_updateOnLoadEventName,updateOnLoadCallback);}});});}}
function setOptions(newOptions){var validatedOpts=_pluginsOptions._validate(newOptions,_pluginsOptions._template,true,_currentOptions)
_currentOptions=extendDeep({},_currentOptions,validatedOpts._default);_currentPreparedOptions=extendDeep({},_currentPreparedOptions,validatedOpts._prepared);return validatedOpts._prepared;}
function setupStructureDOM(destroy){var strParent='parent';var classNameResizeObserverHost='os-resize-observer-host';var classNameTextareaElementFull=_classNameTextareaElement+_strSpace+_classNameTextInherit;var textareaClass=_isTextarea?_strSpace+_classNameTextInherit:_strEmpty;var adoptAttrs=_currentPreparedOptions.textarea.inheritedAttrs;var adoptAttrsMap={};var applyAdoptedAttrs=function(){var applyAdoptedAttrsElm=destroy?_targetElement:_hostElement;each(adoptAttrsMap,function(key,value){if(type(value)==TYPES.s){if(key==LEXICON.c)
applyAdoptedAttrsElm.addClass(value);else
applyAdoptedAttrsElm.attr(key,value);}});};var hostElementClassNames=[_classNameHostElement,_classNameHostElementForeign,_classNameHostTextareaElement,_classNameHostResizeDisabled,_classNameHostRTL,_classNameHostScrollbarHorizontalHidden,_classNameHostScrollbarVerticalHidden,_classNameHostTransition,_classNameHostScrolling,_classNameHostOverflow,_classNameHostOverflowX,_classNameHostOverflowY,_classNameThemeNone,_classNameTextareaElement,_classNameTextInherit,_classNameCache].join(_strSpace);var hostElementCSS={};_hostElement=_hostElement||(_isTextarea?(_domExists?_targetElement[strParent]()[strParent]()[strParent]()[strParent]():FRAMEWORK(generateDiv(_classNameHostTextareaElement))):_targetElement);_contentElement=_contentElement||selectOrGenerateDivByClass(_classNameContentElement+textareaClass);_viewportElement=_viewportElement||selectOrGenerateDivByClass(_classNameViewportElement+textareaClass);_paddingElement=_paddingElement||selectOrGenerateDivByClass(_classNamePaddingElement+textareaClass);_sizeObserverElement=_sizeObserverElement||selectOrGenerateDivByClass(classNameResizeObserverHost);_textareaCoverElement=_textareaCoverElement||(_isTextarea?selectOrGenerateDivByClass(_classNameTextareaCoverElement):undefined);if(_domExists)
addClass(_hostElement,_classNameHostElementForeign);if(destroy)
removeClass(_hostElement,hostElementClassNames);adoptAttrs=type(adoptAttrs)==TYPES.s?adoptAttrs.split(_strSpace):adoptAttrs;if(COMPATIBILITY.isA(adoptAttrs)&&_isTextarea){each(adoptAttrs,function(i,v){if(type(v)==TYPES.s){adoptAttrsMap[v]=destroy?_hostElement.attr(v):_targetElement.attr(v);}});}
if(!destroy){if(_isTextarea){if(!_currentPreparedOptions.sizeAutoCapable){hostElementCSS[_strWidth]=_targetElement.css(_strWidth);hostElementCSS[_strHeight]=_targetElement.css(_strHeight);}
if(!_domExists)
_targetElement.addClass(_classNameTextInherit).wrap(_hostElement);_hostElement=_targetElement[strParent]().css(hostElementCSS);}
if(!_domExists){addClass(_targetElement,_isTextarea?classNameTextareaElementFull:_classNameHostElement);_hostElement.wrapInner(_contentElement).wrapInner(_viewportElement).wrapInner(_paddingElement).prepend(_sizeObserverElement);_contentElement=findFirst(_hostElement,_strDot+_classNameContentElement);_viewportElement=findFirst(_hostElement,_strDot+_classNameViewportElement);_paddingElement=findFirst(_hostElement,_strDot+_classNamePaddingElement);if(_isTextarea){_contentElement.prepend(_textareaCoverElement);applyAdoptedAttrs();}}
if(_nativeScrollbarStyling)
addClass(_viewportElement,_classNameViewportNativeScrollbarsInvisible);if(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y)
addClass(_viewportElement,_classNameViewportNativeScrollbarsOverlaid);if(_isBody)
addClass(_htmlElement,_classNameHTMLElement);_sizeObserverElementNative=_sizeObserverElement[0];_hostElementNative=_hostElement[0];_paddingElementNative=_paddingElement[0];_viewportElementNative=_viewportElement[0];_contentElementNative=_contentElement[0];updateViewportAttrsFromTarget();}
else{if(_domExists&&_initialized){_sizeObserverElement.children().remove();each([_paddingElement,_viewportElement,_contentElement,_textareaCoverElement],function(i,elm){if(elm){removeClass(elm.removeAttr(LEXICON.s),_classNamesDynamicDestroy);}});addClass(_hostElement,_isTextarea?_classNameHostTextareaElement:_classNameHostElement);}
else{remove(_sizeObserverElement);_contentElement.contents().unwrap().unwrap().unwrap();if(_isTextarea){_targetElement.unwrap();remove(_hostElement);remove(_textareaCoverElement);applyAdoptedAttrs();}}
if(_isTextarea)
_targetElement.removeAttr(LEXICON.s);if(_isBody)
removeClass(_htmlElement,_classNameHTMLElement);}}
function setupStructureEvents(){var textareaKeyDownRestrictedKeyCodes=[112,113,114,115,116,117,118,119,120,121,123,33,34,37,38,39,40,16,17,18,19,20,144];var textareaKeyDownKeyCodesList=[];var textareaUpdateIntervalID;var scrollStopTimeoutId;var scrollStopDelay=175;var strFocus='focus';function updateTextarea(doClearInterval){textareaUpdate();_base.update(_strAuto);if(doClearInterval&&_autoUpdateRecommended)
clearInterval(textareaUpdateIntervalID);}
function textareaOnScroll(event){_targetElement[_strScrollLeft](_rtlScrollBehavior.i&&_normalizeRTLCache?9999999:0);_targetElement[_strScrollTop](0);COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);return false;}
function textareaOnDrop(event){setTimeout(function(){if(!_destroyed)
updateTextarea();},50);}
function textareaOnFocus(){_textareaHasFocus=true;addClass(_hostElement,strFocus);}
function textareaOnFocusout(){_textareaHasFocus=false;textareaKeyDownKeyCodesList=[];removeClass(_hostElement,strFocus);updateTextarea(true);}
function textareaOnKeyDown(event){var keyCode=event.keyCode;if(inArray(keyCode,textareaKeyDownRestrictedKeyCodes)<0){if(!textareaKeyDownKeyCodesList[LEXICON.l]){updateTextarea();textareaUpdateIntervalID=setInterval(updateTextarea,1000/60);}
if(inArray(keyCode,textareaKeyDownKeyCodesList)<0)
textareaKeyDownKeyCodesList.push(keyCode);}}
function textareaOnKeyUp(event){var keyCode=event.keyCode;var index=inArray(keyCode,textareaKeyDownKeyCodesList);if(inArray(keyCode,textareaKeyDownRestrictedKeyCodes)<0){if(index>-1)
textareaKeyDownKeyCodesList.splice(index,1);if(!textareaKeyDownKeyCodesList[LEXICON.l])
updateTextarea(true);}}
function contentOnTransitionEnd(event){if(_autoUpdateCache===true)
return;event=event.originalEvent||event;if(isSizeAffectingCSSProperty(event.propertyName))
_base.update(_strAuto);}
function viewportOnScroll(event){if(!_sleeping){if(scrollStopTimeoutId!==undefined)
clearTimeout(scrollStopTimeoutId);else{if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(true);if(!nativeOverlayScrollbarsAreActive())
addClass(_hostElement,_classNameHostScrolling);dispatchCallback('onScrollStart',event);}
if(!_scrollbarsHandlesDefineScrollPos){refreshScrollbarHandleOffset(true);refreshScrollbarHandleOffset(false);}
dispatchCallback('onScroll',event);scrollStopTimeoutId=setTimeout(function(){if(!_destroyed){clearTimeout(scrollStopTimeoutId);scrollStopTimeoutId=undefined;if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(false);if(!nativeOverlayScrollbarsAreActive())
removeClass(_hostElement,_classNameHostScrolling);dispatchCallback('onScrollStop',event);}},scrollStopDelay);}}
if(_isTextarea){if(_msieVersion>9||!_autoUpdateRecommended){addDestroyEventListener(_targetElement,'input',updateTextarea);}
else{addDestroyEventListener(_targetElement,[_strKeyDownEvent,_strKeyUpEvent],[textareaOnKeyDown,textareaOnKeyUp]);}
addDestroyEventListener(_targetElement,[_strScroll,'drop',strFocus,strFocus+'out'],[textareaOnScroll,textareaOnDrop,textareaOnFocus,textareaOnFocusout]);}
else{addDestroyEventListener(_contentElement,_strTransitionEndEvent,contentOnTransitionEnd);}
addDestroyEventListener(_viewportElement,_strScroll,viewportOnScroll,true);}
function setupScrollbarsDOM(destroy){var selectOrGenerateScrollbarDOM=function(isHorizontal){var scrollbarClassName=isHorizontal?_classNameScrollbarHorizontal:_classNameScrollbarVertical;var scrollbar=selectOrGenerateDivByClass(_classNameScrollbar+_strSpace+scrollbarClassName,true);var track=selectOrGenerateDivByClass(_classNameScrollbarTrack,scrollbar);var handle=selectOrGenerateDivByClass(_classNameScrollbarHandle,scrollbar);if(!_domExists&&!destroy){scrollbar.append(track);track.append(handle);}
return{_scrollbar:scrollbar,_track:track,_handle:handle};};function resetScrollbarDOM(isHorizontal){var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbar=scrollbarVars._scrollbar;var track=scrollbarVars._track;var handle=scrollbarVars._handle;if(_domExists&&_initialized){each([scrollbar,track,handle],function(i,elm){removeClass(elm.removeAttr(LEXICON.s),_classNamesDynamicDestroy);});}
else{remove(scrollbar||selectOrGenerateScrollbarDOM(isHorizontal)._scrollbar);}}
var horizontalElements;var verticalElements;if(!destroy){horizontalElements=selectOrGenerateScrollbarDOM(true);verticalElements=selectOrGenerateScrollbarDOM();_scrollbarHorizontalElement=horizontalElements._scrollbar;_scrollbarHorizontalTrackElement=horizontalElements._track;_scrollbarHorizontalHandleElement=horizontalElements._handle;_scrollbarVerticalElement=verticalElements._scrollbar;_scrollbarVerticalTrackElement=verticalElements._track;_scrollbarVerticalHandleElement=verticalElements._handle;if(!_domExists){_paddingElement.after(_scrollbarVerticalElement);_paddingElement.after(_scrollbarHorizontalElement);}}
else{resetScrollbarDOM(true);resetScrollbarDOM();}}
function setupScrollbarEvents(isHorizontal){var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbarVarsInfo=scrollbarVars._info;var insideIFrame=_windowElementNative.top!==_windowElementNative;var xy=scrollbarVars._x_y;var XY=scrollbarVars._X_Y;var scroll=_strScroll+scrollbarVars._Left_Top;var strActive='active';var strSnapHandle='snapHandle';var strClickEvent='click';var scrollDurationFactor=1;var increaseDecreaseScrollAmountKeyCodes=[16,17];var trackTimeout;var mouseDownScroll;var mouseDownOffset;var mouseDownInvertedScale;function getPointerPosition(event){return _msieVersion&&insideIFrame?event['screen'+XY]:COMPATIBILITY.page(event)[xy];}
function getPreparedScrollbarsOption(name){return _currentPreparedOptions.scrollbars[name];}
function increaseTrackScrollAmount(){scrollDurationFactor=0.5;}
function decreaseTrackScrollAmount(){scrollDurationFactor=1;}
function stopClickEventPropagation(event){COMPATIBILITY.stpP(event);}
function documentKeyDown(event){if(inArray(event.keyCode,increaseDecreaseScrollAmountKeyCodes)>-1)
increaseTrackScrollAmount();}
function documentKeyUp(event){if(inArray(event.keyCode,increaseDecreaseScrollAmountKeyCodes)>-1)
decreaseTrackScrollAmount();}
function onMouseTouchDownContinue(event){var originalEvent=event.originalEvent||event;var isTouchEvent=originalEvent.touches!==undefined;return _sleeping||_destroyed||nativeOverlayScrollbarsAreActive()||!_scrollbarsDragScrollingCache||(isTouchEvent&&!getPreparedScrollbarsOption('touchSupport'))?false:COMPATIBILITY.mBtn(event)===1||isTouchEvent;}
function documentDragMove(event){if(onMouseTouchDownContinue(event)){var trackLength=scrollbarVarsInfo._trackLength;var handleLength=scrollbarVarsInfo._handleLength;var scrollRange=scrollbarVarsInfo._maxScroll;var scrollRaw=(getPointerPosition(event)-mouseDownOffset)*mouseDownInvertedScale;var scrollDeltaPercent=scrollRaw/(trackLength-handleLength);var scrollDelta=(scrollRange*scrollDeltaPercent);scrollDelta=isFinite(scrollDelta)?scrollDelta:0;if(_isRTL&&isHorizontal&&!_rtlScrollBehavior.i)
scrollDelta*=-1;_viewportElement[scroll](MATH.round(mouseDownScroll+scrollDelta));if(_scrollbarsHandlesDefineScrollPos)
refreshScrollbarHandleOffset(isHorizontal,mouseDownScroll+scrollDelta);if(!_supportPassiveEvents)
COMPATIBILITY.prvD(event);}
else
documentMouseTouchUp(event);}
function documentMouseTouchUp(event){event=event||event.originalEvent;setupResponsiveEventListener(_documentElement,[_strMouseTouchMoveEvent,_strMouseTouchUpEvent,_strKeyDownEvent,_strKeyUpEvent,_strSelectStartEvent],[documentDragMove,documentMouseTouchUp,documentKeyDown,documentKeyUp,documentOnSelectStart],true);COMPATIBILITY.rAF()(function(){setupResponsiveEventListener(_documentElement,strClickEvent,stopClickEventPropagation,true,{_capture:true});});if(_scrollbarsHandlesDefineScrollPos)
refreshScrollbarHandleOffset(isHorizontal,true);_scrollbarsHandlesDefineScrollPos=false;removeClass(_bodyElement,_classNameDragging);removeClass(scrollbarVars._handle,strActive);removeClass(scrollbarVars._track,strActive);removeClass(scrollbarVars._scrollbar,strActive);mouseDownScroll=undefined;mouseDownOffset=undefined;mouseDownInvertedScale=1;decreaseTrackScrollAmount();if(trackTimeout!==undefined){_base.scrollStop();clearTimeout(trackTimeout);trackTimeout=undefined;}
if(event){var rect=_hostElementNative[LEXICON.bCR]();var mouseInsideHost=event.clientX>=rect.left&&event.clientX<=rect.right&&event.clientY>=rect.top&&event.clientY<=rect.bottom;if(!mouseInsideHost)
hostOnMouseLeave();if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(false);}}
function onHandleMouseTouchDown(event){if(onMouseTouchDownContinue(event))
onHandleMouseTouchDownAction(event);}
function onHandleMouseTouchDownAction(event){mouseDownScroll=_viewportElement[scroll]();mouseDownScroll=isNaN(mouseDownScroll)?0:mouseDownScroll;if(_isRTL&&isHorizontal&&!_rtlScrollBehavior.n||!_isRTL)
mouseDownScroll=mouseDownScroll<0?0:mouseDownScroll;mouseDownInvertedScale=getHostElementInvertedScale()[xy];mouseDownOffset=getPointerPosition(event);_scrollbarsHandlesDefineScrollPos=!getPreparedScrollbarsOption(strSnapHandle);addClass(_bodyElement,_classNameDragging);addClass(scrollbarVars._handle,strActive);addClass(scrollbarVars._scrollbar,strActive);setupResponsiveEventListener(_documentElement,[_strMouseTouchMoveEvent,_strMouseTouchUpEvent,_strSelectStartEvent],[documentDragMove,documentMouseTouchUp,documentOnSelectStart]);COMPATIBILITY.rAF()(function(){setupResponsiveEventListener(_documentElement,strClickEvent,stopClickEventPropagation,false,{_capture:true});});if(_msieVersion||!_documentMixed)
COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}
function onTrackMouseTouchDown(event){if(onMouseTouchDownContinue(event)){var handleToViewportRatio=scrollbarVars._info._handleLength/Math.round(MATH.min(1,_viewportSize[scrollbarVars._w_h]/_contentScrollSizeCache[scrollbarVars._w_h])*scrollbarVars._info._trackLength);var scrollDistance=MATH.round(_viewportSize[scrollbarVars._w_h]*handleToViewportRatio);var scrollBaseDuration=270*handleToViewportRatio;var scrollFirstIterationDelay=400*handleToViewportRatio;var trackOffset=scrollbarVars._track.offset()[scrollbarVars._left_top];var ctrlKey=event.ctrlKey;var instantScroll=event.shiftKey;var instantScrollTransition=instantScroll&&ctrlKey;var isFirstIteration=true;var easing='linear';var decreaseScroll;var finishedCondition;var scrollActionFinsished=function(transition){if(_scrollbarsHandlesDefineScrollPos)
refreshScrollbarHandleOffset(isHorizontal,transition);};var scrollActionInstantFinished=function(){scrollActionFinsished();onHandleMouseTouchDownAction(event);};var scrollAction=function(){if(!_destroyed){var mouseOffset=(mouseDownOffset-trackOffset)*mouseDownInvertedScale;var handleOffset=scrollbarVarsInfo._handleOffset;var trackLength=scrollbarVarsInfo._trackLength;var handleLength=scrollbarVarsInfo._handleLength;var scrollRange=scrollbarVarsInfo._maxScroll;var currScroll=scrollbarVarsInfo._currentScroll;var scrollDuration=scrollBaseDuration*scrollDurationFactor;var timeoutDelay=isFirstIteration?MATH.max(scrollFirstIterationDelay,scrollDuration):scrollDuration;var instantScrollPosition=scrollRange*((mouseOffset-(handleLength/2))/(trackLength-handleLength));var rtlIsNormal=_isRTL&&isHorizontal&&((!_rtlScrollBehavior.i&&!_rtlScrollBehavior.n)||_normalizeRTLCache);var decreaseScrollCondition=rtlIsNormal?handleOffset<mouseOffset:handleOffset>mouseOffset;var scrollObj={};var animationObj={easing:easing,step:function(now){if(_scrollbarsHandlesDefineScrollPos){_viewportElement[scroll](now);refreshScrollbarHandleOffset(isHorizontal,now);}}};instantScrollPosition=isFinite(instantScrollPosition)?instantScrollPosition:0;instantScrollPosition=_isRTL&&isHorizontal&&!_rtlScrollBehavior.i?(scrollRange-instantScrollPosition):instantScrollPosition;if(instantScroll){_viewportElement[scroll](instantScrollPosition);if(instantScrollTransition){instantScrollPosition=_viewportElement[scroll]();_viewportElement[scroll](currScroll);instantScrollPosition=rtlIsNormal&&_rtlScrollBehavior.i?(scrollRange-instantScrollPosition):instantScrollPosition;instantScrollPosition=rtlIsNormal&&_rtlScrollBehavior.n?-instantScrollPosition:instantScrollPosition;scrollObj[xy]=instantScrollPosition;_base.scroll(scrollObj,extendDeep(animationObj,{duration:130,complete:scrollActionInstantFinished}));}
else
scrollActionInstantFinished();}
else{decreaseScroll=isFirstIteration?decreaseScrollCondition:decreaseScroll;finishedCondition=rtlIsNormal?(decreaseScroll?handleOffset+handleLength>=mouseOffset:handleOffset<=mouseOffset):(decreaseScroll?handleOffset<=mouseOffset:handleOffset+handleLength>=mouseOffset);if(finishedCondition){clearTimeout(trackTimeout);_base.scrollStop();trackTimeout=undefined;scrollActionFinsished(true);}
else{trackTimeout=setTimeout(scrollAction,timeoutDelay);scrollObj[xy]=(decreaseScroll?'-=':'+=')+scrollDistance;_base.scroll(scrollObj,extendDeep(animationObj,{duration:scrollDuration}));}
isFirstIteration=false;}}};if(ctrlKey)
increaseTrackScrollAmount();mouseDownInvertedScale=getHostElementInvertedScale()[xy];mouseDownOffset=COMPATIBILITY.page(event)[xy];_scrollbarsHandlesDefineScrollPos=!getPreparedScrollbarsOption(strSnapHandle);addClass(_bodyElement,_classNameDragging);addClass(scrollbarVars._track,strActive);addClass(scrollbarVars._scrollbar,strActive);setupResponsiveEventListener(_documentElement,[_strMouseTouchUpEvent,_strKeyDownEvent,_strKeyUpEvent,_strSelectStartEvent],[documentMouseTouchUp,documentKeyDown,documentKeyUp,documentOnSelectStart]);scrollAction();COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}}
function onTrackMouseTouchEnter(event){_scrollbarsHandleHovered=true;if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(true);}
function onTrackMouseTouchLeave(event){_scrollbarsHandleHovered=false;if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(false);}
function onScrollbarMouseTouchDown(event){COMPATIBILITY.stpP(event);}
addDestroyEventListener(scrollbarVars._handle,_strMouseTouchDownEvent,onHandleMouseTouchDown);addDestroyEventListener(scrollbarVars._track,[_strMouseTouchDownEvent,_strMouseEnter,_strMouseLeave],[onTrackMouseTouchDown,onTrackMouseTouchEnter,onTrackMouseTouchLeave]);addDestroyEventListener(scrollbarVars._scrollbar,_strMouseTouchDownEvent,onScrollbarMouseTouchDown);if(_supportTransition){addDestroyEventListener(scrollbarVars._scrollbar,_strTransitionEndEvent,function(event){if(event.target!==scrollbarVars._scrollbar[0])
return;refreshScrollbarHandleLength(isHorizontal);refreshScrollbarHandleOffset(isHorizontal);});}}
function refreshScrollbarAppearance(isHorizontal,shallBeVisible,canScroll){var scrollbarHiddenClassName=isHorizontal?_classNameHostScrollbarHorizontalHidden:_classNameHostScrollbarVerticalHidden;var scrollbarElement=isHorizontal?_scrollbarHorizontalElement:_scrollbarVerticalElement;addRemoveClass(_hostElement,scrollbarHiddenClassName,!shallBeVisible);addRemoveClass(scrollbarElement,_classNameScrollbarUnusable,!canScroll);}
function refreshScrollbarsAutoHide(shallBeVisible,delayfree){clearTimeout(_scrollbarsAutoHideTimeoutId);if(shallBeVisible){removeClass(_scrollbarHorizontalElement,_classNameScrollbarAutoHidden);removeClass(_scrollbarVerticalElement,_classNameScrollbarAutoHidden);}
else{var anyActive;var strActive='active';var hide=function(){if(!_scrollbarsHandleHovered&&!_destroyed){anyActive=_scrollbarHorizontalHandleElement.hasClass(strActive)||_scrollbarVerticalHandleElement.hasClass(strActive);if(!anyActive&&(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove||_scrollbarsAutoHideLeave))
addClass(_scrollbarHorizontalElement,_classNameScrollbarAutoHidden);if(!anyActive&&(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove||_scrollbarsAutoHideLeave))
addClass(_scrollbarVerticalElement,_classNameScrollbarAutoHidden);}};if(_scrollbarsAutoHideDelay>0&&delayfree!==true)
_scrollbarsAutoHideTimeoutId=setTimeout(hide,_scrollbarsAutoHideDelay);else
hide();}}
function refreshScrollbarHandleLength(isHorizontal){var handleCSS={};var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbarVarsInfo=scrollbarVars._info;var digit=1000000;var handleRatio=MATH.min(1,_viewportSize[scrollbarVars._w_h]/_contentScrollSizeCache[scrollbarVars._w_h]);handleCSS[scrollbarVars._width_height]=(MATH.floor(handleRatio*100*digit)/digit)+'%';if(!nativeOverlayScrollbarsAreActive())
scrollbarVars._handle.css(handleCSS);scrollbarVarsInfo._handleLength=scrollbarVars._handle[0]['offset'+scrollbarVars._Width_Height];scrollbarVarsInfo._handleLengthRatio=handleRatio;}
function refreshScrollbarHandleOffset(isHorizontal,scrollOrTransition){var transition=type(scrollOrTransition)==TYPES.b;var transitionDuration=250;var isRTLisHorizontal=_isRTL&&isHorizontal;var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbarVarsInfo=scrollbarVars._info;var strTranslateBrace='translate(';var strTransform=VENDORS._cssProperty('transform');var strTransition=VENDORS._cssProperty('transition');var nativeScroll=isHorizontal?_viewportElement[_strScrollLeft]():_viewportElement[_strScrollTop]();var currentScroll=scrollOrTransition===undefined||transition?nativeScroll:scrollOrTransition;var handleLength=scrollbarVarsInfo._handleLength;var trackLength=scrollbarVars._track[0]['offset'+scrollbarVars._Width_Height];var handleTrackDiff=trackLength-handleLength;var handleCSS={};var transformOffset;var translateValue;var maxScroll=(_viewportElementNative[_strScroll+scrollbarVars._Width_Height]-_viewportElementNative['client'+scrollbarVars._Width_Height])*(_rtlScrollBehavior.n&&isRTLisHorizontal?-1:1);var getScrollRatio=function(base){return isNaN(base/maxScroll)?0:MATH.max(0,MATH.min(1,base/maxScroll));};var getHandleOffset=function(scrollRatio){var offset=handleTrackDiff*scrollRatio;offset=isNaN(offset)?0:offset;offset=(isRTLisHorizontal&&!_rtlScrollBehavior.i)?(trackLength-handleLength-offset):offset;offset=MATH.max(0,offset);return offset;};var scrollRatio=getScrollRatio(nativeScroll);var unsnappedScrollRatio=getScrollRatio(currentScroll);var handleOffset=getHandleOffset(unsnappedScrollRatio);var snappedHandleOffset=getHandleOffset(scrollRatio);scrollbarVarsInfo._maxScroll=maxScroll;scrollbarVarsInfo._currentScroll=nativeScroll;scrollbarVarsInfo._currentScrollRatio=scrollRatio;if(_supportTransform){transformOffset=isRTLisHorizontal?-(trackLength-handleLength-handleOffset):handleOffset;translateValue=isHorizontal?strTranslateBrace+transformOffset+'px, 0)':strTranslateBrace+'0, '+transformOffset+'px)';handleCSS[strTransform]=translateValue;if(_supportTransition)
handleCSS[strTransition]=transition&&MATH.abs(handleOffset-scrollbarVarsInfo._handleOffset)>1?getCSSTransitionString(scrollbarVars._handle)+', '+(strTransform+_strSpace+transitionDuration+'ms'):_strEmpty;}
else
handleCSS[scrollbarVars._left_top]=handleOffset;if(!nativeOverlayScrollbarsAreActive()){scrollbarVars._handle.css(handleCSS);if(_supportTransform&&_supportTransition&&transition){scrollbarVars._handle.one(_strTransitionEndEvent,function(){if(!_destroyed)
scrollbarVars._handle.css(strTransition,_strEmpty);});}}
scrollbarVarsInfo._handleOffset=handleOffset;scrollbarVarsInfo._snappedHandleOffset=snappedHandleOffset;scrollbarVarsInfo._trackLength=trackLength;}
function refreshScrollbarsInteractive(isTrack,value){var action=value?'removeClass':'addClass';var element1=isTrack?_scrollbarHorizontalTrackElement:_scrollbarHorizontalHandleElement;var element2=isTrack?_scrollbarVerticalTrackElement:_scrollbarVerticalHandleElement;var className=isTrack?_classNameScrollbarTrackOff:_classNameScrollbarHandleOff;element1[action](className);element2[action](className);}
function getScrollbarVars(isHorizontal){return{_width_height:isHorizontal?_strWidth:_strHeight,_Width_Height:isHorizontal?'Width':'Height',_left_top:isHorizontal?_strLeft:_strTop,_Left_Top:isHorizontal?'Left':'Top',_x_y:isHorizontal?_strX:_strY,_X_Y:isHorizontal?'X':'Y',_w_h:isHorizontal?'w':'h',_l_t:isHorizontal?'l':'t',_track:isHorizontal?_scrollbarHorizontalTrackElement:_scrollbarVerticalTrackElement,_handle:isHorizontal?_scrollbarHorizontalHandleElement:_scrollbarVerticalHandleElement,_scrollbar:isHorizontal?_scrollbarHorizontalElement:_scrollbarVerticalElement,_info:isHorizontal?_scrollHorizontalInfo:_scrollVerticalInfo};}
function setupScrollbarCornerDOM(destroy){_scrollbarCornerElement=_scrollbarCornerElement||selectOrGenerateDivByClass(_classNameScrollbarCorner,true);if(!destroy){if(!_domExists){_hostElement.append(_scrollbarCornerElement);}}
else{if(_domExists&&_initialized){removeClass(_scrollbarCornerElement.removeAttr(LEXICON.s),_classNamesDynamicDestroy);}
else{remove(_scrollbarCornerElement);}}}
function setupScrollbarCornerEvents(){var insideIFrame=_windowElementNative.top!==_windowElementNative;var mouseDownPosition={};var mouseDownSize={};var mouseDownInvertedScale={};var reconnectMutationObserver;function documentDragMove(event){if(onMouseTouchDownContinue(event)){var pageOffset=getCoordinates(event);var hostElementCSS={};if(_resizeHorizontal||_resizeBoth)
hostElementCSS[_strWidth]=(mouseDownSize.w+(pageOffset.x-mouseDownPosition.x)*mouseDownInvertedScale.x);if(_resizeVertical||_resizeBoth)
hostElementCSS[_strHeight]=(mouseDownSize.h+(pageOffset.y-mouseDownPosition.y)*mouseDownInvertedScale.y);_hostElement.css(hostElementCSS);COMPATIBILITY.stpP(event);}
else{documentMouseTouchUp(event);}}
function documentMouseTouchUp(event){var eventIsTrusted=event!==undefined;setupResponsiveEventListener(_documentElement,[_strSelectStartEvent,_strMouseTouchMoveEvent,_strMouseTouchUpEvent],[documentOnSelectStart,documentDragMove,documentMouseTouchUp],true);removeClass(_bodyElement,_classNameDragging);if(_scrollbarCornerElement.releaseCapture)
_scrollbarCornerElement.releaseCapture();if(eventIsTrusted){if(reconnectMutationObserver)
connectMutationObservers();_base.update(_strAuto);}
reconnectMutationObserver=false;}
function onMouseTouchDownContinue(event){var originalEvent=event.originalEvent||event;var isTouchEvent=originalEvent.touches!==undefined;return _sleeping||_destroyed?false:COMPATIBILITY.mBtn(event)===1||isTouchEvent;}
function getCoordinates(event){return _msieVersion&&insideIFrame?{x:event.screenX,y:event.screenY}:COMPATIBILITY.page(event);}
addDestroyEventListener(_scrollbarCornerElement,_strMouseTouchDownEvent,function(event){if(onMouseTouchDownContinue(event)&&!_resizeNone){if(_mutationObserversConnected){reconnectMutationObserver=true;disconnectMutationObservers();}
mouseDownPosition=getCoordinates(event);mouseDownSize.w=_hostElementNative[LEXICON.oW]-(!_isBorderBox?_paddingX:0);mouseDownSize.h=_hostElementNative[LEXICON.oH]-(!_isBorderBox?_paddingY:0);mouseDownInvertedScale=getHostElementInvertedScale();setupResponsiveEventListener(_documentElement,[_strSelectStartEvent,_strMouseTouchMoveEvent,_strMouseTouchUpEvent],[documentOnSelectStart,documentDragMove,documentMouseTouchUp]);addClass(_bodyElement,_classNameDragging);if(_scrollbarCornerElement.setCapture)
_scrollbarCornerElement.setCapture();COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}});}
function dispatchCallback(name,args,dependent){if(dependent===false)
return;if(_initialized){var callback=_currentPreparedOptions.callbacks[name];var extensionOnName=name;var ext;if(extensionOnName.substr(0,2)==='on')
extensionOnName=extensionOnName.substr(2,1).toLowerCase()+extensionOnName.substr(3);if(type(callback)==TYPES.f)
callback.call(_base,args);each(_extensions,function(){ext=this;if(type(ext.on)==TYPES.f)
ext.on(extensionOnName,args);});}
else if(!_destroyed)
_callbacksInitQeueue.push({n:name,a:args});}
function setTopRightBottomLeft(targetCSSObject,prefix,values){prefix=prefix||_strEmpty;values=values||[_strEmpty,_strEmpty,_strEmpty,_strEmpty];targetCSSObject[prefix+_strTop]=values[0];targetCSSObject[prefix+_strRight]=values[1];targetCSSObject[prefix+_strBottom]=values[2];targetCSSObject[prefix+_strLeft]=values[3];}
function getTopRightBottomLeftHost(prefix,suffix,zeroX,zeroY){suffix=suffix||_strEmpty;prefix=prefix||_strEmpty;return{t:zeroY?0:parseToZeroOrNumber(_hostElement.css(prefix+_strTop+suffix)),r:zeroX?0:parseToZeroOrNumber(_hostElement.css(prefix+_strRight+suffix)),b:zeroY?0:parseToZeroOrNumber(_hostElement.css(prefix+_strBottom+suffix)),l:zeroX?0:parseToZeroOrNumber(_hostElement.css(prefix+_strLeft+suffix))};}
function getCSSTransitionString(element){var transitionStr=VENDORS._cssProperty('transition');var assembledValue=element.css(transitionStr);if(assembledValue)
return assembledValue;var regExpString='\\s*('+'([^,(]+(\\(.+?\\))?)+'+')[\\s,]*';var regExpMain=new RegExp(regExpString);var regExpValidate=new RegExp('^('+regExpString+')+$');var properties='property duration timing-function delay'.split(' ');var result=[];var strResult;var valueArray;var i=0;var j;var splitCssStyleByComma=function(str){strResult=[];if(!str.match(regExpValidate))
return str;while(str.match(regExpMain)){strResult.push(RegExp.$1);str=str.replace(regExpMain,_strEmpty);}
return strResult;};for(;i<properties[LEXICON.l];i++){valueArray=splitCssStyleByComma(element.css(transitionStr+'-'+properties[i]));for(j=0;j<valueArray[LEXICON.l];j++)
result[j]=(result[j]?result[j]+_strSpace:_strEmpty)+valueArray[j];}
return result.join(', ');}
function createHostClassNameRegExp(withCurrClassNameOption,withOldClassNameOption){var i;var split;var appendix;var appendClasses=function(classes,condition){appendix='';if(condition&&typeof classes==TYPES.s){split=classes.split(_strSpace);for(i=0;i<split[LEXICON.l];i++)
appendix+='|'+split[i]+'$';}
return appendix;};return new RegExp('(^'+_classNameHostElement+'([-_].+|)$)'+
appendClasses(_classNameCache,withCurrClassNameOption)+
appendClasses(_oldClassName,withOldClassNameOption),'g');}
function getHostElementInvertedScale(){var rect=_paddingElementNative[LEXICON.bCR]();return{x:_supportTransform?1/(MATH.round(rect.width)/_paddingElementNative[LEXICON.oW])||1:1,y:_supportTransform?1/(MATH.round(rect.height)/_paddingElementNative[LEXICON.oH])||1:1};}
function isHTMLElement(o){var strOwnerDocument='ownerDocument';var strHTMLElement='HTMLElement';var wnd=o&&o[strOwnerDocument]?(o[strOwnerDocument].parentWindow||window):window;return(typeof wnd[strHTMLElement]==TYPES.o?o instanceof wnd[strHTMLElement]:o&&typeof o==TYPES.o&&o!==null&&o.nodeType===1&&typeof o.nodeName==TYPES.s);}
function getArrayDifferences(a1,a2){var a=[];var diff=[];var i;var k;for(i=0;i<a1.length;i++)
a[a1[i]]=true;for(i=0;i<a2.length;i++){if(a[a2[i]])
delete a[a2[i]];else
a[a2[i]]=true;}
for(k in a)
diff.push(k);return diff;}
function parseToZeroOrNumber(value,toFloat){var num=toFloat?parseFloat(value):parseInt(value,10);return isNaN(num)?0:num;}
function getTextareaInfo(){var textareaCursorPosition=_targetElementNative.selectionStart;if(textareaCursorPosition===undefined)
return;var textareaValue=_targetElement.val();var textareaLength=textareaValue[LEXICON.l];var textareaRowSplit=textareaValue.split('\n');var textareaLastRow=textareaRowSplit[LEXICON.l];var textareaCurrentCursorRowSplit=textareaValue.substr(0,textareaCursorPosition).split('\n');var widestRow=0;var textareaLastCol=0;var cursorRow=textareaCurrentCursorRowSplit[LEXICON.l];var cursorCol=textareaCurrentCursorRowSplit[textareaCurrentCursorRowSplit[LEXICON.l]-1][LEXICON.l];var rowCols;var i;for(i=0;i<textareaRowSplit[LEXICON.l];i++){rowCols=textareaRowSplit[i][LEXICON.l];if(rowCols>textareaLastCol){widestRow=i+1;textareaLastCol=rowCols;}}
return{_cursorRow:cursorRow,_cursorColumn:cursorCol,_rows:textareaLastRow,_columns:textareaLastCol,_widestRow:widestRow,_cursorPosition:textareaCursorPosition,_cursorMax:textareaLength};}
function nativeOverlayScrollbarsAreActive(){return(_ignoreOverlayScrollbarHidingCache&&(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y));}
function getContentMeasureElement(){return _isTextarea?_textareaCoverElement[0]:_contentElementNative;}
function generateDiv(classesOrAttrs,content){return'<div '+(classesOrAttrs?type(classesOrAttrs)==TYPES.s?'class="'+classesOrAttrs+'"':(function(){var key;var attrs=_strEmpty;if(FRAMEWORK.isPlainObject(classesOrAttrs)){for(key in classesOrAttrs)
attrs+=(key==='c'?'class':key)+'="'+classesOrAttrs[key]+'" ';}
return attrs;})():_strEmpty)+
'>'+
(content||_strEmpty)+
'</div>';}
function selectOrGenerateDivByClass(className,selectParentOrOnlyChildren){var onlyChildren=type(selectParentOrOnlyChildren)==TYPES.b;var selectParent=onlyChildren?_hostElement:(selectParentOrOnlyChildren||_hostElement);return(_domExists&&!selectParent[LEXICON.l])?null:_domExists?selectParent[onlyChildren?'children':'find'](_strDot+className.replace(/\s/g,_strDot)).eq(0):FRAMEWORK(generateDiv(className))}
function getObjectPropVal(obj,path){var splits=path.split(_strDot);var i=0;var val;for(;i<splits.length;i++){if(!obj[LEXICON.hOP](splits[i]))
return;val=obj[splits[i]];if(i<splits.length&&type(val)==TYPES.o)
obj=val;}
return val;}
function setObjectPropVal(obj,path,val){var splits=path.split(_strDot);var splitsLength=splits.length;var i=0;var extendObj={};var extendObjRoot=extendObj;for(;i<splitsLength;i++)
extendObj=extendObj[splits[i]]=i+1<splitsLength?{}:val;FRAMEWORK.extend(obj,extendObjRoot,true);}
function eachUpdateOnLoad(action){var updateOnLoad=_currentPreparedOptions.updateOnLoad;updateOnLoad=type(updateOnLoad)==TYPES.s?updateOnLoad.split(_strSpace):updateOnLoad;if(COMPATIBILITY.isA(updateOnLoad)&&!_destroyed){each(updateOnLoad,action);}}
function checkCache(current,cache,force){if(force)
return force;if(type(current)==TYPES.o&&type(cache)==TYPES.o){for(var prop in current){if(prop!=='c'){if(current[LEXICON.hOP](prop)&&cache[LEXICON.hOP](prop)){if(checkCache(current[prop],cache[prop]))
return true;}
else{return true;}}}}
else{return current!==cache;}
return false;}
function extendDeep(){return FRAMEWORK.extend.apply(this,[true].concat([].slice.call(arguments)));}
function addClass(el,classes){return _frameworkProto.addClass.call(el,classes);}
function removeClass(el,classes){return _frameworkProto.removeClass.call(el,classes);}
function addRemoveClass(el,classes,doAdd){return doAdd?addClass(el,classes):removeClass(el,classes);}
function remove(el){return _frameworkProto.remove.call(el);}
function findFirst(el,selector){return _frameworkProto.find.call(el,selector).eq(0);}
_base.sleep=function(){_sleeping=true;};_base.update=function(force){if(_destroyed)
return;var attrsChanged;var contentSizeC;var isString=type(force)==TYPES.s;var doUpdateAuto;var mutHost;var mutContent;if(isString){if(force===_strAuto){attrsChanged=meaningfulAttrsChanged();contentSizeC=updateAutoContentSizeChanged();doUpdateAuto=attrsChanged||contentSizeC;if(doUpdateAuto){update({_contentSizeChanged:contentSizeC,_changedOptions:_initialized?undefined:_currentPreparedOptions});}}
else if(force===_strSync){if(_mutationObserversConnected){mutHost=_mutationObserverHostCallback(_mutationObserverHost.takeRecords());mutContent=_mutationObserverContentCallback(_mutationObserverContent.takeRecords());}
else{mutHost=_base.update(_strAuto);}}
else if(force==='zoom'){update({_hostSizeChanged:true,_contentSizeChanged:true});}}
else{force=_sleeping||force;_sleeping=false;if(!_base.update(_strSync)||force)
update({_force:force});}
updateElementsOnLoad();return doUpdateAuto||mutHost||mutContent;};_base.options=function(newOptions,value){var option={};var changedOps;if(FRAMEWORK.isEmptyObject(newOptions)||!FRAMEWORK.isPlainObject(newOptions)){if(type(newOptions)==TYPES.s){if(arguments.length>1){setObjectPropVal(option,newOptions,value);changedOps=setOptions(option);}
else
return getObjectPropVal(_currentOptions,newOptions);}
else
return _currentOptions;}
else{changedOps=setOptions(newOptions);}
if(!FRAMEWORK.isEmptyObject(changedOps)){update({_changedOptions:changedOps});}};_base.destroy=function(){if(_destroyed)
return;autoUpdateLoop.remove(_base);disconnectMutationObservers();setupResizeObserver(_sizeObserverElement);setupResizeObserver(_sizeAutoObserverElement);for(var extName in _extensions)
_base.removeExt(extName);while(_destroyEvents[LEXICON.l]>0)
_destroyEvents.pop()();setupHostMouseTouchEvents(true);if(_contentGlueElement)
remove(_contentGlueElement);if(_contentArrangeElement)
remove(_contentArrangeElement);if(_sizeAutoObserverAdded)
remove(_sizeAutoObserverElement);setupScrollbarsDOM(true);setupScrollbarCornerDOM(true);setupStructureDOM(true);for(var i=0;i<_updateOnLoadElms[LEXICON.l];i++)
FRAMEWORK(_updateOnLoadElms[i]).off(_updateOnLoadEventName,updateOnLoadCallback);_updateOnLoadElms=undefined;_destroyed=true;_sleeping=true;INSTANCES(pluginTargetElement,0);dispatchCallback('onDestroyed');};_base.scroll=function(coordinates,duration,easing,complete){if(arguments.length===0||coordinates===undefined){var infoX=_scrollHorizontalInfo;var infoY=_scrollVerticalInfo;var normalizeInvert=_normalizeRTLCache&&_isRTL&&_rtlScrollBehavior.i;var normalizeNegate=_normalizeRTLCache&&_isRTL&&_rtlScrollBehavior.n;var scrollX=infoX._currentScroll;var scrollXRatio=infoX._currentScrollRatio;var maxScrollX=infoX._maxScroll;scrollXRatio=normalizeInvert?1-scrollXRatio:scrollXRatio;scrollX=normalizeInvert?maxScrollX-scrollX:scrollX;scrollX*=normalizeNegate?-1:1;maxScrollX*=normalizeNegate?-1:1;return{position:{x:scrollX,y:infoY._currentScroll},ratio:{x:scrollXRatio,y:infoY._currentScrollRatio},max:{x:maxScrollX,y:infoY._maxScroll},handleOffset:{x:infoX._handleOffset,y:infoY._handleOffset},handleLength:{x:infoX._handleLength,y:infoY._handleLength},handleLengthRatio:{x:infoX._handleLengthRatio,y:infoY._handleLengthRatio},trackLength:{x:infoX._trackLength,y:infoY._trackLength},snappedHandleOffset:{x:infoX._snappedHandleOffset,y:infoY._snappedHandleOffset},isRTL:_isRTL,isRTLNormalized:_normalizeRTLCache};}
_base.update(_strSync);var normalizeRTL=_normalizeRTLCache;var coordinatesXAxisProps=[_strX,_strLeft,'l'];var coordinatesYAxisProps=[_strY,_strTop,'t'];var coordinatesOperators=['+=','-=','*=','/='];var durationIsObject=type(duration)==TYPES.o;var completeCallback=durationIsObject?duration.complete:complete;var i;var finalScroll={};var specialEasing={};var doScrollLeft;var doScrollTop;var animationOptions;var strEnd='end';var strBegin='begin';var strCenter='center';var strNearest='nearest';var strAlways='always';var strNever='never';var strIfNeeded='ifneeded';var strLength=LEXICON.l;var settingsAxis;var settingsScroll;var settingsBlock;var settingsMargin;var finalElement;var elementObjSettingsAxisValues=[_strX,_strY,'xy','yx'];var elementObjSettingsBlockValues=[strBegin,strEnd,strCenter,strNearest];var elementObjSettingsScrollValues=[strAlways,strNever,strIfNeeded];var coordinatesIsElementObj=coordinates[LEXICON.hOP]('el');var possibleElement=coordinatesIsElementObj?coordinates.el:coordinates;var possibleElementIsJQuery=possibleElement instanceof FRAMEWORK||JQUERY?possibleElement instanceof JQUERY:false;var possibleElementIsHTMLElement=possibleElementIsJQuery?false:isHTMLElement(possibleElement);var updateScrollbarInfos=function(){if(doScrollLeft)
refreshScrollbarHandleOffset(true);if(doScrollTop)
refreshScrollbarHandleOffset(false);};var proxyCompleteCallback=type(completeCallback)!=TYPES.f?undefined:function(){updateScrollbarInfos();completeCallback();};function checkSettingsStringValue(currValue,allowedValues){for(i=0;i<allowedValues[strLength];i++){if(currValue===allowedValues[i])
return true;}
return false;}
function getRawScroll(isX,coordinates){var coordinateProps=isX?coordinatesXAxisProps:coordinatesYAxisProps;coordinates=type(coordinates)==TYPES.s||type(coordinates)==TYPES.n?[coordinates,coordinates]:coordinates;if(COMPATIBILITY.isA(coordinates))
return isX?coordinates[0]:coordinates[1];else if(type(coordinates)==TYPES.o){for(i=0;i<coordinateProps[strLength];i++)
if(coordinateProps[i]in coordinates)
return coordinates[coordinateProps[i]];}}
function getFinalScroll(isX,rawScroll){var isString=type(rawScroll)==TYPES.s;var operator;var amount;var scrollInfo=isX?_scrollHorizontalInfo:_scrollVerticalInfo;var currScroll=scrollInfo._currentScroll;var maxScroll=scrollInfo._maxScroll;var mult=' * ';var finalValue;var isRTLisX=_isRTL&&isX;var normalizeShortcuts=isRTLisX&&_rtlScrollBehavior.n&&!normalizeRTL;var strReplace='replace';var evalFunc=eval;var possibleOperator;if(isString){if(rawScroll[strLength]>2){possibleOperator=rawScroll.substr(0,2);if(inArray(possibleOperator,coordinatesOperators)>-1)
operator=possibleOperator;}
rawScroll=operator?rawScroll.substr(2):rawScroll;rawScroll=rawScroll
[strReplace](/min/g,0)
[strReplace](/</g,0)
[strReplace](/max/g,(normalizeShortcuts?'-':_strEmpty)+_strHundredPercent)
[strReplace](/>/g,(normalizeShortcuts?'-':_strEmpty)+_strHundredPercent)
[strReplace](/px/g,_strEmpty)
[strReplace](/%/g,mult+(maxScroll*(isRTLisX&&_rtlScrollBehavior.n?-1:1)/100.0))
[strReplace](/vw/g,mult+_viewportSize.w)
[strReplace](/vh/g,mult+_viewportSize.h);amount=parseToZeroOrNumber(isNaN(rawScroll)?parseToZeroOrNumber(evalFunc(rawScroll),true).toFixed():rawScroll);}
else{amount=rawScroll;}
if(amount!==undefined&&!isNaN(amount)&&type(amount)==TYPES.n){var normalizeIsRTLisX=normalizeRTL&&isRTLisX;var operatorCurrScroll=currScroll*(normalizeIsRTLisX&&_rtlScrollBehavior.n?-1:1);var invert=normalizeIsRTLisX&&_rtlScrollBehavior.i;var negate=normalizeIsRTLisX&&_rtlScrollBehavior.n;operatorCurrScroll=invert?(maxScroll-operatorCurrScroll):operatorCurrScroll;switch(operator){case'+=':finalValue=operatorCurrScroll+amount;break;case'-=':finalValue=operatorCurrScroll-amount;break;case'*=':finalValue=operatorCurrScroll*amount;break;case'/=':finalValue=operatorCurrScroll/amount;break;default:finalValue=amount;break;}
finalValue=invert?maxScroll-finalValue:finalValue;finalValue*=negate?-1:1;finalValue=isRTLisX&&_rtlScrollBehavior.n?MATH.min(0,MATH.max(maxScroll,finalValue)):MATH.max(0,MATH.min(maxScroll,finalValue));}
return finalValue===currScroll?undefined:finalValue;}
function getPerAxisValue(value,valueInternalType,defaultValue,allowedValues){var resultDefault=[defaultValue,defaultValue];var valueType=type(value);var valueArrLength;var valueArrItem;if(valueType==valueInternalType){value=[value,value];}
else if(valueType==TYPES.a){valueArrLength=value[strLength];if(valueArrLength>2||valueArrLength<1)
value=resultDefault;else{if(valueArrLength===1)
value[1]=defaultValue;for(i=0;i<valueArrLength;i++){valueArrItem=value[i];if(type(valueArrItem)!=valueInternalType||!checkSettingsStringValue(valueArrItem,allowedValues)){value=resultDefault;break;}}}}
else if(valueType==TYPES.o)
value=[value[_strX]||defaultValue,value[_strY]||defaultValue];else
value=resultDefault;return{x:value[0],y:value[1]};}
function generateMargin(marginTopRightBottomLeftArray){var result=[];var currValue;var currValueType;var valueDirections=[_strTop,_strRight,_strBottom,_strLeft];for(i=0;i<marginTopRightBottomLeftArray[strLength];i++){if(i===valueDirections[strLength])
break;currValue=marginTopRightBottomLeftArray[i];currValueType=type(currValue);if(currValueType==TYPES.b)
result.push(currValue?parseToZeroOrNumber(finalElement.css(_strMarginMinus+valueDirections[i])):0);else
result.push(currValueType==TYPES.n?currValue:0);}
return result;}
if(possibleElementIsJQuery||possibleElementIsHTMLElement){var margin=coordinatesIsElementObj?coordinates.margin:0;var axis=coordinatesIsElementObj?coordinates.axis:0;var scroll=coordinatesIsElementObj?coordinates.scroll:0;var block=coordinatesIsElementObj?coordinates.block:0;var marginDefault=[0,0,0,0];var marginType=type(margin);var marginLength;finalElement=possibleElementIsJQuery?possibleElement:FRAMEWORK(possibleElement);if(finalElement[strLength]>0){if(marginType==TYPES.n||marginType==TYPES.b)
margin=generateMargin([margin,margin,margin,margin]);else if(marginType==TYPES.a){marginLength=margin[strLength];if(marginLength===2)
margin=generateMargin([margin[0],margin[1],margin[0],margin[1]]);else if(marginLength>=4)
margin=generateMargin(margin);else
margin=marginDefault;}
else if(marginType==TYPES.o)
margin=generateMargin([margin[_strTop],margin[_strRight],margin[_strBottom],margin[_strLeft]]);else
margin=marginDefault;settingsAxis=checkSettingsStringValue(axis,elementObjSettingsAxisValues)?axis:'xy';settingsScroll=getPerAxisValue(scroll,TYPES.s,strAlways,elementObjSettingsScrollValues);settingsBlock=getPerAxisValue(block,TYPES.s,strBegin,elementObjSettingsBlockValues);settingsMargin=margin;var viewportScroll={l:_scrollHorizontalInfo._currentScroll,t:_scrollVerticalInfo._currentScroll};var viewportOffset=_paddingElement.offset();var elementOffset=finalElement.offset();var doNotScroll={x:settingsScroll.x==strNever||settingsAxis==_strY,y:settingsScroll.y==strNever||settingsAxis==_strX};elementOffset[_strTop]-=settingsMargin[0];elementOffset[_strLeft]-=settingsMargin[3];var elementScrollCoordinates={x:MATH.round(elementOffset[_strLeft]-viewportOffset[_strLeft]+viewportScroll.l),y:MATH.round(elementOffset[_strTop]-viewportOffset[_strTop]+viewportScroll.t)};if(_isRTL){if(!_rtlScrollBehavior.n&&!_rtlScrollBehavior.i)
elementScrollCoordinates.x=MATH.round(viewportOffset[_strLeft]-elementOffset[_strLeft]+viewportScroll.l);if(_rtlScrollBehavior.n&&normalizeRTL)
elementScrollCoordinates.x*=-1;if(_rtlScrollBehavior.i&&normalizeRTL)
elementScrollCoordinates.x=MATH.round(viewportOffset[_strLeft]-elementOffset[_strLeft]+(_scrollHorizontalInfo._maxScroll-viewportScroll.l));}
if(settingsBlock.x!=strBegin||settingsBlock.y!=strBegin||settingsScroll.x==strIfNeeded||settingsScroll.y==strIfNeeded||_isRTL){var measuringElm=finalElement[0];var rawElementSize=_supportTransform?measuringElm[LEXICON.bCR]():{width:measuringElm[LEXICON.oW],height:measuringElm[LEXICON.oH]};var elementSize={w:rawElementSize[_strWidth]+settingsMargin[3]+settingsMargin[1],h:rawElementSize[_strHeight]+settingsMargin[0]+settingsMargin[2]};var finalizeBlock=function(isX){var vars=getScrollbarVars(isX);var wh=vars._w_h;var lt=vars._left_top;var xy=vars._x_y;var blockIsEnd=settingsBlock[xy]==(isX?_isRTL?strBegin:strEnd:strEnd);var blockIsCenter=settingsBlock[xy]==strCenter;var blockIsNearest=settingsBlock[xy]==strNearest;var scrollNever=settingsScroll[xy]==strNever;var scrollIfNeeded=settingsScroll[xy]==strIfNeeded;var vpSize=_viewportSize[wh];var vpOffset=viewportOffset[lt];var elSize=elementSize[wh];var elOffset=elementOffset[lt];var divide=blockIsCenter?2:1;var elementCenterOffset=elOffset+(elSize/2);var viewportCenterOffset=vpOffset+(vpSize/2);var isInView=elSize<=vpSize&&elOffset>=vpOffset&&elOffset+elSize<=vpOffset+vpSize;if(scrollNever)
doNotScroll[xy]=true;else if(!doNotScroll[xy]){if(blockIsNearest||scrollIfNeeded){doNotScroll[xy]=scrollIfNeeded?isInView:false;blockIsEnd=elSize<vpSize?elementCenterOffset>viewportCenterOffset:elementCenterOffset<viewportCenterOffset;}
elementScrollCoordinates[xy]-=blockIsEnd||blockIsCenter?((vpSize/divide)-(elSize/divide))*(isX&&_isRTL&&normalizeRTL?-1:1):0;}};finalizeBlock(true);finalizeBlock(false);}
if(doNotScroll.y)
delete elementScrollCoordinates.y;if(doNotScroll.x)
delete elementScrollCoordinates.x;coordinates=elementScrollCoordinates;}}
finalScroll[_strScrollLeft]=getFinalScroll(true,getRawScroll(true,coordinates));finalScroll[_strScrollTop]=getFinalScroll(false,getRawScroll(false,coordinates));doScrollLeft=finalScroll[_strScrollLeft]!==undefined;doScrollTop=finalScroll[_strScrollTop]!==undefined;if((doScrollLeft||doScrollTop)&&(duration>0||durationIsObject)){if(durationIsObject){duration.complete=proxyCompleteCallback;_viewportElement.animate(finalScroll,duration);}
else{animationOptions={duration:duration,complete:proxyCompleteCallback};if(COMPATIBILITY.isA(easing)||FRAMEWORK.isPlainObject(easing)){specialEasing[_strScrollLeft]=easing[0]||easing.x;specialEasing[_strScrollTop]=easing[1]||easing.y;animationOptions.specialEasing=specialEasing;}
else{animationOptions.easing=easing;}
_viewportElement.animate(finalScroll,animationOptions);}}
else{if(doScrollLeft)
_viewportElement[_strScrollLeft](finalScroll[_strScrollLeft]);if(doScrollTop)
_viewportElement[_strScrollTop](finalScroll[_strScrollTop]);updateScrollbarInfos();}};_base.scrollStop=function(param1,param2,param3){_viewportElement.stop(param1,param2,param3);return _base;};_base.getElements=function(elementName){var obj={target:_targetElementNative,host:_hostElementNative,padding:_paddingElementNative,viewport:_viewportElementNative,content:_contentElementNative,scrollbarHorizontal:{scrollbar:_scrollbarHorizontalElement[0],track:_scrollbarHorizontalTrackElement[0],handle:_scrollbarHorizontalHandleElement[0]},scrollbarVertical:{scrollbar:_scrollbarVerticalElement[0],track:_scrollbarVerticalTrackElement[0],handle:_scrollbarVerticalHandleElement[0]},scrollbarCorner:_scrollbarCornerElement[0]};return type(elementName)==TYPES.s?getObjectPropVal(obj,elementName):obj;};_base.getState=function(stateProperty){function prepare(obj){if(!FRAMEWORK.isPlainObject(obj))
return obj;var extended=extendDeep({},obj);var changePropertyName=function(from,to){if(extended[LEXICON.hOP](from)){extended[to]=extended[from];delete extended[from];}};changePropertyName('w',_strWidth);changePropertyName('h',_strHeight);delete extended.c;return extended;};var obj={destroyed:!!prepare(_destroyed),sleeping:!!prepare(_sleeping),autoUpdate:prepare(!_mutationObserversConnected),widthAuto:prepare(_widthAutoCache),heightAuto:prepare(_heightAutoCache),padding:prepare(_cssPaddingCache),overflowAmount:prepare(_overflowAmountCache),hideOverflow:prepare(_hideOverflowCache),hasOverflow:prepare(_hasOverflowCache),contentScrollSize:prepare(_contentScrollSizeCache),viewportSize:prepare(_viewportSize),hostSize:prepare(_hostSizeCache),documentMixed:prepare(_documentMixed)};return type(stateProperty)==TYPES.s?getObjectPropVal(obj,stateProperty):obj;};_base.ext=function(extName){var result;var privateMethods=_extensionsPrivateMethods.split(' ');var i=0;if(type(extName)==TYPES.s){if(_extensions[LEXICON.hOP](extName)){result=extendDeep({},_extensions[extName]);for(;i<privateMethods.length;i++)
delete result[privateMethods[i]];}}
else{result={};for(i in _extensions)
result[i]=extendDeep({},_base.ext(i));}
return result;};_base.addExt=function(extName,extensionOptions){var registeredExtensionObj=_plugin.extension(extName);var instance;var instanceAdded;var instanceContract;var contractResult;var contractFulfilled=true;if(registeredExtensionObj){if(!_extensions[LEXICON.hOP](extName)){instance=registeredExtensionObj.extensionFactory.call(_base,extendDeep({},registeredExtensionObj.defaultOptions),FRAMEWORK,COMPATIBILITY);if(instance){instanceContract=instance.contract;if(type(instanceContract)==TYPES.f){contractResult=instanceContract(window);contractFulfilled=type(contractResult)==TYPES.b?contractResult:contractFulfilled;}
if(contractFulfilled){_extensions[extName]=instance;instanceAdded=instance.added;if(type(instanceAdded)==TYPES.f)
instanceAdded(extensionOptions);return _base.ext(extName);}}}
else
return _base.ext(extName);}
else
console.warn("A extension with the name \""+extName+"\" isn't registered.");};_base.removeExt=function(extName){var instance=_extensions[extName];var instanceRemoved;if(instance){delete _extensions[extName];instanceRemoved=instance.removed;if(type(instanceRemoved)==TYPES.f)
instanceRemoved();return true;}
return false;};function construct(targetElement,options,extensions){_defaultOptions=globals.defaultOptions;_nativeScrollbarStyling=globals.nativeScrollbarStyling;_nativeScrollbarSize=extendDeep({},globals.nativeScrollbarSize);_nativeScrollbarIsOverlaid=extendDeep({},globals.nativeScrollbarIsOverlaid);_overlayScrollbarDummySize=extendDeep({},globals.overlayScrollbarDummySize);_rtlScrollBehavior=extendDeep({},globals.rtlScrollBehavior);setOptions(extendDeep({},_defaultOptions,options));_cssCalc=globals.cssCalc;_msieVersion=globals.msie;_autoUpdateRecommended=globals.autoUpdateRecommended;_supportTransition=globals.supportTransition;_supportTransform=globals.supportTransform;_supportPassiveEvents=globals.supportPassiveEvents;_supportResizeObserver=globals.supportResizeObserver;_supportMutationObserver=globals.supportMutationObserver;_restrictedMeasuring=globals.restrictedMeasuring;_documentElement=FRAMEWORK(targetElement.ownerDocument);_documentElementNative=_documentElement[0];_windowElement=FRAMEWORK(_documentElementNative.defaultView||_documentElementNative.parentWindow);_windowElementNative=_windowElement[0];_htmlElement=findFirst(_documentElement,'html');_bodyElement=findFirst(_htmlElement,'body');_targetElement=FRAMEWORK(targetElement);_targetElementNative=_targetElement[0];_isTextarea=_targetElement.is('textarea');_isBody=_targetElement.is('body');_documentMixed=_documentElementNative!==document;_domExists=_isTextarea?_targetElement.hasClass(_classNameTextareaElement)&&_targetElement.parent().hasClass(_classNameContentElement):_targetElement.hasClass(_classNameHostElement)&&_targetElement.children(_strDot+_classNamePaddingElement)[LEXICON.l];var initBodyScroll;var bodyMouseTouchDownListener;if(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y&&!_currentPreparedOptions.nativeScrollbarsOverlaid.initialize){dispatchCallback('onInitializationWithdrawn');if(_domExists){setupStructureDOM(true);setupScrollbarsDOM(true);setupScrollbarCornerDOM(true);}
_destroyed=true;_sleeping=true;return _base;}
if(_isBody){initBodyScroll={};initBodyScroll.l=MATH.max(_targetElement[_strScrollLeft](),_htmlElement[_strScrollLeft](),_windowElement[_strScrollLeft]());initBodyScroll.t=MATH.max(_targetElement[_strScrollTop](),_htmlElement[_strScrollTop](),_windowElement[_strScrollTop]());bodyMouseTouchDownListener=function(){_viewportElement.removeAttr(LEXICON.ti);setupResponsiveEventListener(_viewportElement,_strMouseTouchDownEvent,bodyMouseTouchDownListener,true,true);}}
setupStructureDOM();setupScrollbarsDOM();setupScrollbarCornerDOM();setupStructureEvents();setupScrollbarEvents(true);setupScrollbarEvents(false);setupScrollbarCornerEvents();createMutationObservers();setupResizeObserver(_sizeObserverElement,hostOnResized);if(_isBody){_viewportElement[_strScrollLeft](initBodyScroll.l)[_strScrollTop](initBodyScroll.t);if(document.activeElement==targetElement&&_viewportElementNative.focus){_viewportElement.attr(LEXICON.ti,'-1');_viewportElementNative.focus();setupResponsiveEventListener(_viewportElement,_strMouseTouchDownEvent,bodyMouseTouchDownListener,false,true);}}
_base.update(_strAuto);_initialized=true;dispatchCallback('onInitialized');each(_callbacksInitQeueue,function(index,value){dispatchCallback(value.n,value.a);});_callbacksInitQeueue=[];if(type(extensions)==TYPES.s)
extensions=[extensions];if(COMPATIBILITY.isA(extensions))
each(extensions,function(index,value){_base.addExt(value);});else if(FRAMEWORK.isPlainObject(extensions))
each(extensions,function(key,value){_base.addExt(key,value);});setTimeout(function(){if(_supportTransition&&!_destroyed)
addClass(_hostElement,_classNameHostTransition);},333);return _base;}
if(_plugin.valid(construct(pluginTargetElement,options,extensions))){INSTANCES(pluginTargetElement,_base);}
return _base;}
_plugin=window[PLUGINNAME]=function(pluginTargetElements,options,extensions){if(arguments[LEXICON.l]===0)
return this;var arr=[];var optsIsPlainObj=FRAMEWORK.isPlainObject(options);var inst;var result;if(!pluginTargetElements)
return optsIsPlainObj||!options?result:arr;pluginTargetElements=pluginTargetElements[LEXICON.l]!=undefined?pluginTargetElements:[pluginTargetElements[0]||pluginTargetElements];initOverlayScrollbarsStatics();if(pluginTargetElements[LEXICON.l]>0){if(optsIsPlainObj){FRAMEWORK.each(pluginTargetElements,function(i,v){inst=v;if(inst!==undefined)
arr.push(OverlayScrollbarsInstance(inst,options,extensions,_pluginsGlobals,_pluginsAutoUpdateLoop));});}
else{FRAMEWORK.each(pluginTargetElements,function(i,v){inst=INSTANCES(v);if((options==='!'&&_plugin.valid(inst))||(COMPATIBILITY.type(options)==TYPES.f&&options(v,inst)))
arr.push(inst);else if(options===undefined)
arr.push(inst);});}
result=arr[LEXICON.l]===1?arr[0]:arr;}
return result;};_plugin.globals=function(){initOverlayScrollbarsStatics();var globals=FRAMEWORK.extend(true,{},_pluginsGlobals);delete globals['msie'];return globals;};_plugin.defaultOptions=function(newDefaultOptions){initOverlayScrollbarsStatics();var currDefaultOptions=_pluginsGlobals.defaultOptions;if(newDefaultOptions===undefined)
return FRAMEWORK.extend(true,{},currDefaultOptions);_pluginsGlobals.defaultOptions=FRAMEWORK.extend(true,{},currDefaultOptions,_pluginsOptions._validate(newDefaultOptions,_pluginsOptions._template,true,currDefaultOptions)._default);};_plugin.valid=function(osInstance){return osInstance instanceof _plugin&&!osInstance.getState().destroyed;};_plugin.extension=function(extensionName,extension,defaultOptions){var extNameTypeString=COMPATIBILITY.type(extensionName)==TYPES.s;var argLen=arguments[LEXICON.l];var i=0;if(argLen<1||!extNameTypeString){return FRAMEWORK.extend(true,{length:_pluginsExtensions[LEXICON.l]},_pluginsExtensions);}
else if(extNameTypeString){if(COMPATIBILITY.type(extension)==TYPES.f){_pluginsExtensions.push({name:extensionName,extensionFactory:extension,defaultOptions:defaultOptions});}
else{for(;i<_pluginsExtensions[LEXICON.l];i++){if(_pluginsExtensions[i].name===extensionName){if(argLen>1)
_pluginsExtensions.splice(i,1);else
return FRAMEWORK.extend(true,{},_pluginsExtensions[i]);}}}}};return _plugin;})();if(JQUERY&&JQUERY.fn){JQUERY.fn.overlayScrollbars=function(options,extensions){var _elements=this;if(JQUERY.isPlainObject(options)){JQUERY.each(_elements,function(){PLUGIN(this,options,extensions);});return _elements;}
else
return PLUGIN(_elements,options);};}
return PLUGIN;}));/*!
 * OverlayScrollbars
 * https://github.com/KingSora/OverlayScrollbars
 *
 * Version: 1.13.0
 *
 * Copyright KingSora | Rene Haas.
 * https://github.com/KingSora
 *
 * Released under the MIT license.
 * Date: 02.08.2020
 */
(function(global,factory){if(typeof define==='function'&&define.amd)
define(function(){return factory(global,global.document,undefined);});else if(typeof module==='object'&&typeof module.exports==='object')
module.exports=factory(global,global.document,undefined);else
factory(global,global.document,undefined);}(typeof window!=='undefined'?window:this,function(window,document,undefined){'use strict';var PLUGINNAME='OverlayScrollbars';var TYPES={o:'object',f:'function',a:'array',s:'string',b:'boolean',n:'number',u:'undefined',z:'null'
};var LEXICON={c:'class',s:'style',i:'id',l:'length',p:'prototype',ti:'tabindex',oH:'offsetHeight',cH:'clientHeight',sH:'scrollHeight',oW:'offsetWidth',cW:'clientWidth',sW:'scrollWidth',hOP:'hasOwnProperty',bCR:'getBoundingClientRect'};var VENDORS=(function(){var jsCache={};var cssCache={};var cssPrefixes=['-webkit-','-moz-','-o-','-ms-'];var jsPrefixes=['WebKit','Moz','O','MS'];function firstLetterToUpper(str){return str.charAt(0).toUpperCase()+str.slice(1);}
return{_cssPrefixes:cssPrefixes,_jsPrefixes:jsPrefixes,_cssProperty:function(name){var result=cssCache[name];if(cssCache[LEXICON.hOP](name))
return result;var uppercasedName=firstLetterToUpper(name);var elmStyle=document.createElement('div')[LEXICON.s];var resultPossibilities;var i=0;var v;var currVendorWithoutDashes;for(;i<cssPrefixes.length;i++){currVendorWithoutDashes=cssPrefixes[i].replace(/-/g,'');resultPossibilities=[name,cssPrefixes[i]+name,currVendorWithoutDashes+uppercasedName,firstLetterToUpper(currVendorWithoutDashes)+uppercasedName];for(v=0;v<resultPossibilities[LEXICON.l];v++){if(elmStyle[resultPossibilities[v]]!==undefined){result=resultPossibilities[v];break;}}}
cssCache[name]=result;return result;},_cssPropertyValue:function(property,values,suffix){var name=property+' '+values;var result=cssCache[name];if(cssCache[LEXICON.hOP](name))
return result;var dummyStyle=document.createElement('div')[LEXICON.s];var possbleValues=values.split(' ');var preparedSuffix=suffix||'';var i=0;var v=-1;var prop;for(;i<possbleValues[LEXICON.l];i++){for(;v<VENDORS._cssPrefixes[LEXICON.l];v++){prop=v<0?possbleValues[i]:VENDORS._cssPrefixes[v]+possbleValues[i];dummyStyle.cssText=property+':'+prop+preparedSuffix;if(dummyStyle[LEXICON.l]){result=prop;break;}}}
cssCache[name]=result;return result;},_jsAPI:function(name,isInterface,fallback){var i=0;var result=jsCache[name];if(!jsCache[LEXICON.hOP](name)){result=window[name];for(;i<jsPrefixes[LEXICON.l];i++)
result=result||window[(isInterface?jsPrefixes[i]:jsPrefixes[i].toLowerCase())+firstLetterToUpper(name)];jsCache[name]=result;}
return result||fallback;}}})();var COMPATIBILITY=(function(){function windowSize(x){return x?window.innerWidth||document.documentElement[LEXICON.cW]||document.body[LEXICON.cW]:window.innerHeight||document.documentElement[LEXICON.cH]||document.body[LEXICON.cH];}
function bind(func,thisObj){if(typeof func!=TYPES.f){throw"Can't bind function!";}
var proto=LEXICON.p;var aArgs=Array[proto].slice.call(arguments,2);var fNOP=function(){};var fBound=function(){return func.apply(this instanceof fNOP?this:thisObj,aArgs.concat(Array[proto].slice.call(arguments)));};if(func[proto])
fNOP[proto]=func[proto];fBound[proto]=new fNOP();return fBound;}
return{wW:bind(windowSize,0,true),wH:bind(windowSize,0),mO:bind(VENDORS._jsAPI,0,'MutationObserver',true),rO:bind(VENDORS._jsAPI,0,'ResizeObserver',true),rAF:bind(VENDORS._jsAPI,0,'requestAnimationFrame',false,function(func){return window.setTimeout(func,1000/60);}),cAF:bind(VENDORS._jsAPI,0,'cancelAnimationFrame',false,function(id){return window.clearTimeout(id);}),now:function(){return Date.now&&Date.now()||new Date().getTime();},stpP:function(event){if(event.stopPropagation)
event.stopPropagation();else
event.cancelBubble=true;},prvD:function(event){if(event.preventDefault&&event.cancelable)
event.preventDefault();else
event.returnValue=false;},page:function(event){event=event.originalEvent||event;var strPage='page';var strClient='client';var strX='X';var strY='Y';var target=event.target||event.srcElement||document;var eventDoc=target.ownerDocument||document;var doc=eventDoc.documentElement;var body=eventDoc.body;if(event.touches!==undefined){var touch=event.touches[0];return{x:touch[strPage+strX],y:touch[strPage+strY]}}
if(!event[strPage+strX]&&event[strClient+strX]&&event[strClient+strX]!=null){return{x:event[strClient+strX]+
(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-
(doc&&doc.clientLeft||body&&body.clientLeft||0),y:event[strClient+strY]+
(doc&&doc.scrollTop||body&&body.scrollTop||0)-
(doc&&doc.clientTop||body&&body.clientTop||0)}}
return{x:event[strPage+strX],y:event[strPage+strY]};},mBtn:function(event){var button=event.button;if(!event.which&&button!==undefined)
return(button&1?1:(button&2?3:(button&4?2:0)));else
return event.which;},inA:function(item,arr){for(var i=0;i<arr[LEXICON.l];i++)
try{if(arr[i]===item)
return i;}
catch(e){}
return-1;},isA:function(arr){var def=Array.isArray;return def?def(arr):this.type(arr)==TYPES.a;},type:function(obj){if(obj===undefined)
return obj+'';if(obj===null)
return obj+'';return Object[LEXICON.p].toString.call(obj).replace(/^\[object (.+)\]$/,'$1').toLowerCase();},bind:bind
}})();var MATH=Math;var JQUERY=window.jQuery;var EASING=(function(){var _easingsMath={p:MATH.PI,c:MATH.cos,s:MATH.sin,w:MATH.pow,t:MATH.sqrt,n:MATH.asin,a:MATH.abs,o:1.70158};return{swing:function(x,t,b,c,d){return 0.5-_easingsMath.c(x*_easingsMath.p)/2;},linear:function(x,t,b,c,d){return x;},easeInQuad:function(x,t,b,c,d){return c*(t/=d)*t+b;},easeOutQuad:function(x,t,b,c,d){return-c*(t/=d)*(t-2)+b;},easeInOutQuad:function(x,t,b,c,d){return((t/=d/2)<1)?c/2*t*t+b:-c/2*((--t)*(t-2)-1)+b;},easeInCubic:function(x,t,b,c,d){return c*(t/=d)*t*t+b;},easeOutCubic:function(x,t,b,c,d){return c*((t=t/d-1)*t*t+1)+b;},easeInOutCubic:function(x,t,b,c,d){return((t/=d/2)<1)?c/2*t*t*t+b:c/2*((t-=2)*t*t+2)+b;},easeInQuart:function(x,t,b,c,d){return c*(t/=d)*t*t*t+b;},easeOutQuart:function(x,t,b,c,d){return-c*((t=t/d-1)*t*t*t-1)+b;},easeInOutQuart:function(x,t,b,c,d){return((t/=d/2)<1)?c/2*t*t*t*t+b:-c/2*((t-=2)*t*t*t-2)+b;},easeInQuint:function(x,t,b,c,d){return c*(t/=d)*t*t*t*t+b;},easeOutQuint:function(x,t,b,c,d){return c*((t=t/d-1)*t*t*t*t+1)+b;},easeInOutQuint:function(x,t,b,c,d){return((t/=d/2)<1)?c/2*t*t*t*t*t+b:c/2*((t-=2)*t*t*t*t+2)+b;},easeInSine:function(x,t,b,c,d){return-c*_easingsMath.c(t/d*(_easingsMath.p/2))+c+b;},easeOutSine:function(x,t,b,c,d){return c*_easingsMath.s(t/d*(_easingsMath.p/2))+b;},easeInOutSine:function(x,t,b,c,d){return-c/2*(_easingsMath.c(_easingsMath.p*t/d)-1)+b;},easeInExpo:function(x,t,b,c,d){return(t==0)?b:c*_easingsMath.w(2,10*(t/d-1))+b;},easeOutExpo:function(x,t,b,c,d){return(t==d)?b+c:c*(-_easingsMath.w(2,-10*t/d)+1)+b;},easeInOutExpo:function(x,t,b,c,d){if(t==0)return b;if(t==d)return b+c;if((t/=d/2)<1)return c/2*_easingsMath.w(2,10*(t-1))+b;return c/2*(-_easingsMath.w(2,-10*--t)+2)+b;},easeInCirc:function(x,t,b,c,d){return-c*(_easingsMath.t(1-(t/=d)*t)-1)+b;},easeOutCirc:function(x,t,b,c,d){return c*_easingsMath.t(1-(t=t/d-1)*t)+b;},easeInOutCirc:function(x,t,b,c,d){return((t/=d/2)<1)?-c/2*(_easingsMath.t(1-t*t)-1)+b:c/2*(_easingsMath.t(1-(t-=2)*t)+1)+b;},easeInElastic:function(x,t,b,c,d){var s=_easingsMath.o;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<_easingsMath.a(c)){a=c;s=p/4;}
else s=p/(2*_easingsMath.p)*_easingsMath.n(c/a);return-(a*_easingsMath.w(2,10*(t-=1))*_easingsMath.s((t*d-s)*(2*_easingsMath.p)/p))+b;},easeOutElastic:function(x,t,b,c,d){var s=_easingsMath.o;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<_easingsMath.a(c)){a=c;s=p/4;}
else s=p/(2*_easingsMath.p)*_easingsMath.n(c/a);return a*_easingsMath.w(2,-10*t)*_easingsMath.s((t*d-s)*(2*_easingsMath.p)/p)+c+b;},easeInOutElastic:function(x,t,b,c,d){var s=_easingsMath.o;var p=0;var a=c;if(t==0)return b;if((t/=d/2)==2)return b+c;if(!p)p=d*(.3*1.5);if(a<_easingsMath.a(c)){a=c;s=p/4;}
else s=p/(2*_easingsMath.p)*_easingsMath.n(c/a);if(t<1)return-.5*(a*_easingsMath.w(2,10*(t-=1))*_easingsMath.s((t*d-s)*(2*_easingsMath.p)/p))+b;return a*_easingsMath.w(2,-10*(t-=1))*_easingsMath.s((t*d-s)*(2*_easingsMath.p)/p)*.5+c+b;},easeInBack:function(x,t,b,c,d,s){s=s||_easingsMath.o;return c*(t/=d)*t*((s+1)*t-s)+b;},easeOutBack:function(x,t,b,c,d,s){s=s||_easingsMath.o;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b;},easeInOutBack:function(x,t,b,c,d,s){s=s||_easingsMath.o;return((t/=d/2)<1)?c/2*(t*t*(((s*=(1.525))+1)*t-s))+b:c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b;},easeInBounce:function(x,t,b,c,d){return c-this.easeOutBounce(x,d-t,0,c,d)+b;},easeOutBounce:function(x,t,b,c,d){var o=7.5625;if((t/=d)<(1/2.75)){return c*(o*t*t)+b;}else if(t<(2/2.75)){return c*(o*(t-=(1.5/2.75))*t+.75)+b;}else if(t<(2.5/2.75)){return c*(o*(t-=(2.25/2.75))*t+.9375)+b;}else{return c*(o*(t-=(2.625/2.75))*t+.984375)+b;}},easeInOutBounce:function(x,t,b,c,d){return(t<d/2)?this.easeInBounce(x,t*2,0,c,d)*.5+b:this.easeOutBounce(x,t*2-d,0,c,d)*.5+c*.5+b;}};})();var FRAMEWORK=(function(){var _rnothtmlwhite=(/[^\x20\t\r\n\f]+/g);var _strSpace=' ';var _strEmpty='';var _strScrollLeft='scrollLeft';var _strScrollTop='scrollTop';var _animations=[];var _type=COMPATIBILITY.type;var _cssNumber={animationIterationCount:true,columnCount:true,fillOpacity:true,flexGrow:true,flexShrink:true,fontWeight:true,lineHeight:true,opacity:true,order:true,orphans:true,widows:true,zIndex:true,zoom:true};function extend(){var src,copyIsArray,copy,name,options,clone,target=arguments[0]||{},i=1,length=arguments[LEXICON.l],deep=false;if(_type(target)==TYPES.b){deep=target;target=arguments[1]||{};i=2;}
if(_type(target)!=TYPES.o&&!_type(target)==TYPES.f){target={};}
if(length===i){target=FakejQuery;--i;}
for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){src=target[name];copy=options[name];if(target===copy){continue;}
if(deep&&copy&&(isPlainObject(copy)||(copyIsArray=COMPATIBILITY.isA(copy)))){if(copyIsArray){copyIsArray=false;clone=src&&COMPATIBILITY.isA(src)?src:[];}else{clone=src&&isPlainObject(src)?src:{};}
target[name]=extend(deep,clone,copy);}else if(copy!==undefined){target[name]=copy;}}}}
return target;};function inArray(item,arr,fromIndex){for(var i=fromIndex||0;i<arr[LEXICON.l];i++)
if(arr[i]===item)
return i;return-1;}
function isFunction(obj){return _type(obj)==TYPES.f;};function isEmptyObject(obj){for(var name in obj)
return false;return true;};function isPlainObject(obj){if(!obj||_type(obj)!=TYPES.o)
return false;var key;var proto=LEXICON.p;var hasOwnProperty=Object[proto].hasOwnProperty;var hasOwnConstructor=hasOwnProperty.call(obj,'constructor');var hasIsPrototypeOf=obj.constructor&&obj.constructor[proto]&&hasOwnProperty.call(obj.constructor[proto],'isPrototypeOf');if(obj.constructor&&!hasOwnConstructor&&!hasIsPrototypeOf){return false;}
for(key in obj){}
return _type(key)==TYPES.u||hasOwnProperty.call(obj,key);};function each(obj,callback){var i=0;if(isArrayLike(obj)){for(;i<obj[LEXICON.l];i++){if(callback.call(obj[i],i,obj[i])===false)
break;}}
else{for(i in obj){if(callback.call(obj[i],i,obj[i])===false)
break;}}
return obj;};function isArrayLike(obj){var length=!!obj&&[LEXICON.l]in obj&&obj[LEXICON.l];var t=_type(obj);return isFunction(t)?false:(t==TYPES.a||length===0||_type(length)==TYPES.n&&length>0&&(length-1)in obj);}
function stripAndCollapse(value){var tokens=value.match(_rnothtmlwhite)||[];return tokens.join(_strSpace);}
function matches(elem,selector){var nodeList=(elem.parentNode||document).querySelectorAll(selector)||[];var i=nodeList[LEXICON.l];while(i--)
if(nodeList[i]==elem)
return true;return false;}
function insertAdjacentElement(el,strategy,child){if(COMPATIBILITY.isA(child)){for(var i=0;i<child[LEXICON.l];i++)
insertAdjacentElement(el,strategy,child[i]);}
else if(_type(child)==TYPES.s)
el.insertAdjacentHTML(strategy,child);else
el.insertAdjacentElement(strategy,child.nodeType?child:child[0]);}
function setCSSVal(el,prop,val){try{if(el[LEXICON.s][prop]!==undefined)
el[LEXICON.s][prop]=parseCSSVal(prop,val);}catch(e){}}
function parseCSSVal(prop,val){if(!_cssNumber[prop.toLowerCase()]&&_type(val)==TYPES.n)
val+='px';return val;}
function startNextAnimationInQ(animObj,removeFromQ){var index;var nextAnim;if(removeFromQ!==false)
animObj.q.splice(0,1);if(animObj.q[LEXICON.l]>0){nextAnim=animObj.q[0];animate(animObj.el,nextAnim.props,nextAnim.duration,nextAnim.easing,nextAnim.complete,true);}
else{index=inArray(animObj,_animations);if(index>-1)
_animations.splice(index,1);}}
function setAnimationValue(el,prop,value){if(prop===_strScrollLeft||prop===_strScrollTop)
el[prop]=value;else
setCSSVal(el,prop,value);}
function animate(el,props,options,easing,complete,guaranteedNext){var hasOptions=isPlainObject(options);var from={};var to={};var i=0;var key;var animObj;var start;var progress;var step;var specialEasing;var duration;if(hasOptions){easing=options.easing;start=options.start;progress=options.progress;step=options.step;specialEasing=options.specialEasing;complete=options.complete;duration=options.duration;}
else
duration=options;specialEasing=specialEasing||{};duration=duration||400;easing=easing||'swing';guaranteedNext=guaranteedNext||false;for(;i<_animations[LEXICON.l];i++){if(_animations[i].el===el){animObj=_animations[i];break;}}
if(!animObj){animObj={el:el,q:[]};_animations.push(animObj);}
for(key in props){if(key===_strScrollLeft||key===_strScrollTop)
from[key]=el[key];else
from[key]=FakejQuery(el).css(key);}
for(key in from){if(from[key]!==props[key]&&props[key]!==undefined)
to[key]=props[key];}
if(!isEmptyObject(to)){var timeNow;var end;var percent;var fromVal;var toVal;var easedVal;var timeStart;var frame;var elapsed;var qPos=guaranteedNext?0:inArray(qObj,animObj.q);var qObj={props:to,duration:hasOptions?options:duration,easing:easing,complete:complete};if(qPos===-1){qPos=animObj.q[LEXICON.l];animObj.q.push(qObj);}
if(qPos===0){if(duration>0){timeStart=COMPATIBILITY.now();frame=function(){timeNow=COMPATIBILITY.now();elapsed=(timeNow-timeStart);end=qObj.stop||elapsed>=duration;percent=1-((MATH.max(0,timeStart+duration-timeNow)/duration)||0);for(key in to){fromVal=parseFloat(from[key]);toVal=parseFloat(to[key]);easedVal=(toVal-fromVal)*EASING[specialEasing[key]||easing](percent,percent*duration,0,1,duration)+fromVal;setAnimationValue(el,key,easedVal);if(isFunction(step)){step(easedVal,{elem:el,prop:key,start:fromVal,now:easedVal,end:toVal,pos:percent,options:{easing:easing,speacialEasing:specialEasing,duration:duration,complete:complete,step:step},startTime:timeStart});}}
if(isFunction(progress))
progress({},percent,MATH.max(0,duration-elapsed));if(end){startNextAnimationInQ(animObj);if(isFunction(complete))
complete();}
else
qObj.frame=COMPATIBILITY.rAF()(frame);};qObj.frame=COMPATIBILITY.rAF()(frame);}
else{for(key in to)
setAnimationValue(el,key,to[key]);startNextAnimationInQ(animObj);}}}
else if(guaranteedNext)
startNextAnimationInQ(animObj);}
function stop(el,clearQ,jumpToEnd){var animObj;var qObj;var key;var i=0;for(;i<_animations[LEXICON.l];i++){animObj=_animations[i];if(animObj.el===el){if(animObj.q[LEXICON.l]>0){qObj=animObj.q[0];qObj.stop=true;COMPATIBILITY.cAF()(qObj.frame);animObj.q.splice(0,1);if(jumpToEnd)
for(key in qObj.props)
setAnimationValue(el,key,qObj.props[key]);if(clearQ)
animObj.q=[];else
startNextAnimationInQ(animObj,false);}
break;}}}
function elementIsVisible(el){return!!(el[LEXICON.oW]||el[LEXICON.oH]||el.getClientRects()[LEXICON.l]);}
function FakejQuery(selector){if(arguments[LEXICON.l]===0)
return this;var base=new FakejQuery();var elements=selector;var i=0;var elms;var el;if(_type(selector)==TYPES.s){elements=[];if(selector.charAt(0)==='<'){el=document.createElement('div');el.innerHTML=selector;elms=el.children;}
else{elms=document.querySelectorAll(selector);}
for(;i<elms[LEXICON.l];i++)
elements.push(elms[i]);}
if(elements){if(_type(elements)!=TYPES.s&&(!isArrayLike(elements)||elements===window||elements===elements.self))
elements=[elements];for(i=0;i<elements[LEXICON.l];i++)
base[i]=elements[i];base[LEXICON.l]=elements[LEXICON.l];}
return base;};FakejQuery[LEXICON.p]={on:function(eventName,handler){eventName=(eventName||_strEmpty).match(_rnothtmlwhite)||[_strEmpty];var eventNameLength=eventName[LEXICON.l];var i=0;var el;return this.each(function(){el=this;try{if(el.addEventListener){for(;i<eventNameLength;i++)
el.addEventListener(eventName[i],handler);}
else if(el.detachEvent){for(;i<eventNameLength;i++)
el.attachEvent('on'+eventName[i],handler);}}catch(e){}});},off:function(eventName,handler){eventName=(eventName||_strEmpty).match(_rnothtmlwhite)||[_strEmpty];var eventNameLength=eventName[LEXICON.l];var i=0;var el;return this.each(function(){el=this;try{if(el.removeEventListener){for(;i<eventNameLength;i++)
el.removeEventListener(eventName[i],handler);}
else if(el.detachEvent){for(;i<eventNameLength;i++)
el.detachEvent('on'+eventName[i],handler);}}catch(e){}});},one:function(eventName,handler){eventName=(eventName||_strEmpty).match(_rnothtmlwhite)||[_strEmpty];return this.each(function(){var el=FakejQuery(this);FakejQuery.each(eventName,function(i,oneEventName){var oneHandler=function(e){handler.call(this,e);el.off(oneEventName,oneHandler);};el.on(oneEventName,oneHandler);});});},trigger:function(eventName){var el;var event;return this.each(function(){el=this;if(document.createEvent){event=document.createEvent('HTMLEvents');event.initEvent(eventName,true,false);el.dispatchEvent(event);}
else{el.fireEvent('on'+eventName);}});},append:function(child){return this.each(function(){insertAdjacentElement(this,'beforeend',child);});},prepend:function(child){return this.each(function(){insertAdjacentElement(this,'afterbegin',child);});},before:function(child){return this.each(function(){insertAdjacentElement(this,'beforebegin',child);});},after:function(child){return this.each(function(){insertAdjacentElement(this,'afterend',child);});},remove:function(){return this.each(function(){var el=this;var parentNode=el.parentNode;if(parentNode!=null)
parentNode.removeChild(el);});},unwrap:function(){var parents=[];var i;var el;var parent;this.each(function(){parent=this.parentNode;if(inArray(parent,parents)===-1)
parents.push(parent);});for(i=0;i<parents[LEXICON.l];i++){el=parents[i];parent=el.parentNode;while(el.firstChild)
parent.insertBefore(el.firstChild,el);parent.removeChild(el);}
return this;},wrapAll:function(wrapperHTML){var i;var nodes=this;var wrapper=FakejQuery(wrapperHTML)[0];var deepest=wrapper;var parent=nodes[0].parentNode;var previousSibling=nodes[0].previousSibling;while(deepest.childNodes[LEXICON.l]>0)
deepest=deepest.childNodes[0];for(i=0;nodes[LEXICON.l]-i;deepest.firstChild===nodes[0]&&i++)
deepest.appendChild(nodes[i]);var nextSibling=previousSibling?previousSibling.nextSibling:parent.firstChild;parent.insertBefore(wrapper,nextSibling);return this;},wrapInner:function(wrapperHTML){return this.each(function(){var el=FakejQuery(this);var contents=el.contents();if(contents[LEXICON.l])
contents.wrapAll(wrapperHTML);else
el.append(wrapperHTML);});},wrap:function(wrapperHTML){return this.each(function(){FakejQuery(this).wrapAll(wrapperHTML);});},css:function(styles,val){var el;var key;var cptStyle;var getCptStyle=window.getComputedStyle;if(_type(styles)==TYPES.s){if(val===undefined){el=this[0];cptStyle=getCptStyle?getCptStyle(el,null):el.currentStyle[styles];return getCptStyle?cptStyle!=null?cptStyle.getPropertyValue(styles):el[LEXICON.s][styles]:cptStyle;}
else{return this.each(function(){setCSSVal(this,styles,val);});}}
else{return this.each(function(){for(key in styles)
setCSSVal(this,key,styles[key]);});}},hasClass:function(className){var elem,i=0;var classNamePrepared=_strSpace+className+_strSpace;var classList;while((elem=this[i++])){classList=elem.classList;if(classList&&classList.contains(className))
return true;else if(elem.nodeType===1&&(_strSpace+stripAndCollapse(elem.className+_strEmpty)+_strSpace).indexOf(classNamePrepared)>-1)
return true;}
return false;},addClass:function(className){var classes;var elem;var cur;var curValue;var clazz;var finalValue;var supportClassList;var elmClassList;var i=0;var v=0;if(className){classes=className.match(_rnothtmlwhite)||[];while((elem=this[i++])){elmClassList=elem.classList;if(supportClassList===undefined)
supportClassList=elmClassList!==undefined;if(supportClassList){while((clazz=classes[v++]))
elmClassList.add(clazz);}
else{curValue=elem.className+_strEmpty;cur=elem.nodeType===1&&(_strSpace+stripAndCollapse(curValue)+_strSpace);if(cur){while((clazz=classes[v++]))
if(cur.indexOf(_strSpace+clazz+_strSpace)<0)
cur+=clazz+_strSpace;finalValue=stripAndCollapse(cur);if(curValue!==finalValue)
elem.className=finalValue;}}}}
return this;},removeClass:function(className){var classes;var elem;var cur;var curValue;var clazz;var finalValue;var supportClassList;var elmClassList;var i=0;var v=0;if(className){classes=className.match(_rnothtmlwhite)||[];while((elem=this[i++])){elmClassList=elem.classList;if(supportClassList===undefined)
supportClassList=elmClassList!==undefined;if(supportClassList){while((clazz=classes[v++]))
elmClassList.remove(clazz);}
else{curValue=elem.className+_strEmpty;cur=elem.nodeType===1&&(_strSpace+stripAndCollapse(curValue)+_strSpace);if(cur){while((clazz=classes[v++]))
while(cur.indexOf(_strSpace+clazz+_strSpace)>-1)
cur=cur.replace(_strSpace+clazz+_strSpace,_strSpace);finalValue=stripAndCollapse(cur);if(curValue!==finalValue)
elem.className=finalValue;}}}}
return this;},hide:function(){return this.each(function(){this[LEXICON.s].display='none';});},show:function(){return this.each(function(){this[LEXICON.s].display='block';});},attr:function(attrName,value){var i=0;var el;while(el=this[i++]){if(value===undefined)
return el.getAttribute(attrName);el.setAttribute(attrName,value);}
return this;},removeAttr:function(attrName){return this.each(function(){this.removeAttribute(attrName);});},offset:function(){var el=this[0];var rect=el[LEXICON.bCR]();var scrollLeft=window.pageXOffset||document.documentElement[_strScrollLeft];var scrollTop=window.pageYOffset||document.documentElement[_strScrollTop];return{top:rect.top+scrollTop,left:rect.left+scrollLeft};},position:function(){var el=this[0];return{top:el.offsetTop,left:el.offsetLeft};},scrollLeft:function(value){var i=0;var el;while(el=this[i++]){if(value===undefined)
return el[_strScrollLeft];el[_strScrollLeft]=value;}
return this;},scrollTop:function(value){var i=0;var el;while(el=this[i++]){if(value===undefined)
return el[_strScrollTop];el[_strScrollTop]=value;}
return this;},val:function(value){var el=this[0];if(!value)
return el.value;el.value=value;return this;},first:function(){return this.eq(0);},last:function(){return this.eq(-1);},eq:function(index){return FakejQuery(this[index>=0?index:this[LEXICON.l]+index]);},find:function(selector){var children=[];var i;this.each(function(){var el=this;var ch=el.querySelectorAll(selector);for(i=0;i<ch[LEXICON.l];i++)
children.push(ch[i]);});return FakejQuery(children);},children:function(selector){var children=[];var el;var ch;var i;this.each(function(){ch=this.children;for(i=0;i<ch[LEXICON.l];i++){el=ch[i];if(selector){if((el.matches&&el.matches(selector))||matches(el,selector))
children.push(el);}
else
children.push(el);}});return FakejQuery(children);},parent:function(selector){var parents=[];var parent;this.each(function(){parent=this.parentNode;if(selector?FakejQuery(parent).is(selector):true)
parents.push(parent);});return FakejQuery(parents);},is:function(selector){var el;var i;for(i=0;i<this[LEXICON.l];i++){el=this[i];if(selector===':visible')
return elementIsVisible(el);if(selector===':hidden')
return!elementIsVisible(el);if((el.matches&&el.matches(selector))||matches(el,selector))
return true;}
return false;},contents:function(){var contents=[];var childs;var i;this.each(function(){childs=this.childNodes;for(i=0;i<childs[LEXICON.l];i++)
contents.push(childs[i]);});return FakejQuery(contents);},each:function(callback){return each(this,callback);},animate:function(props,duration,easing,complete){return this.each(function(){animate(this,props,duration,easing,complete);});},stop:function(clearQ,jump){return this.each(function(){stop(this,clearQ,jump);});}};extend(FakejQuery,{extend:extend,inArray:inArray,isEmptyObject:isEmptyObject,isPlainObject:isPlainObject,each:each});return FakejQuery;})();var INSTANCES=(function(){var _targets=[];var _instancePropertyString='__overlayScrollbars__';return function(target,instance){var argLen=arguments[LEXICON.l];if(argLen<1){return _targets;}
else{if(instance){target[_instancePropertyString]=instance;_targets.push(target);}
else{var index=COMPATIBILITY.inA(target,_targets);if(index>-1){if(argLen>1){delete target[_instancePropertyString];_targets.splice(index,1);}
else{return _targets[index][_instancePropertyString];}}}}}})();var PLUGIN=(function(){var _plugin;var _pluginsGlobals;var _pluginsAutoUpdateLoop;var _pluginsExtensions=[];var _pluginsOptions=(function(){var type=COMPATIBILITY.type;var possibleTemplateTypes=[TYPES.b,TYPES.n,TYPES.s,TYPES.a,TYPES.o,TYPES.f,TYPES.z];var restrictedStringsSplit=' ';var restrictedStringsPossibilitiesSplit=':';var classNameAllowedValues=[TYPES.z,TYPES.s];var numberAllowedValues=TYPES.n;var booleanNullAllowedValues=[TYPES.z,TYPES.b];var booleanTrueTemplate=[true,TYPES.b];var booleanFalseTemplate=[false,TYPES.b];var callbackTemplate=[null,[TYPES.z,TYPES.f]];var updateOnLoadTemplate=[['img'],[TYPES.s,TYPES.a,TYPES.z]];var inheritedAttrsTemplate=[['style','class'],[TYPES.s,TYPES.a,TYPES.z]];var resizeAllowedValues='n:none b:both h:horizontal v:vertical';var overflowBehaviorAllowedValues='v-h:visible-hidden v-s:visible-scroll s:scroll h:hidden';var scrollbarsVisibilityAllowedValues='v:visible h:hidden a:auto';var scrollbarsAutoHideAllowedValues='n:never s:scroll l:leave m:move';var optionsDefaultsAndTemplate={className:['os-theme-dark',classNameAllowedValues],resize:['none',resizeAllowedValues],sizeAutoCapable:booleanTrueTemplate,clipAlways:booleanTrueTemplate,normalizeRTL:booleanTrueTemplate,paddingAbsolute:booleanFalseTemplate,autoUpdate:[null,booleanNullAllowedValues],autoUpdateInterval:[33,numberAllowedValues],updateOnLoad:updateOnLoadTemplate,nativeScrollbarsOverlaid:{showNativeScrollbars:booleanFalseTemplate,initialize:booleanTrueTemplate},overflowBehavior:{x:['scroll',overflowBehaviorAllowedValues],y:['scroll',overflowBehaviorAllowedValues]},scrollbars:{visibility:['auto',scrollbarsVisibilityAllowedValues],autoHide:['never',scrollbarsAutoHideAllowedValues],autoHideDelay:[800,numberAllowedValues],dragScrolling:booleanTrueTemplate,clickScrolling:booleanFalseTemplate,touchSupport:booleanTrueTemplate,snapHandle:booleanFalseTemplate},textarea:{dynWidth:booleanFalseTemplate,dynHeight:booleanFalseTemplate,inheritedAttrs:inheritedAttrsTemplate},callbacks:{onInitialized:callbackTemplate,onInitializationWithdrawn:callbackTemplate,onDestroyed:callbackTemplate,onScrollStart:callbackTemplate,onScroll:callbackTemplate,onScrollStop:callbackTemplate,onOverflowChanged:callbackTemplate,onOverflowAmountChanged:callbackTemplate,onDirectionChanged:callbackTemplate,onContentSizeChanged:callbackTemplate,onHostSizeChanged:callbackTemplate,onUpdated:callbackTemplate}};var convert=function(template){var recursive=function(obj){var key;var val;var valType;for(key in obj){if(!obj[LEXICON.hOP](key))
continue;val=obj[key];valType=type(val);if(valType==TYPES.a)
obj[key]=val[template?1:0];else if(valType==TYPES.o)
obj[key]=recursive(val);}
return obj;};return recursive(FRAMEWORK.extend(true,{},optionsDefaultsAndTemplate));};return{_defaults:convert(),_template:convert(true),_validate:function(obj,template,writeErrors,diffObj){var validatedOptions={};var validatedOptionsPrepared={};var objectCopy=FRAMEWORK.extend(true,{},obj);var inArray=FRAMEWORK.inArray;var isEmptyObj=FRAMEWORK.isEmptyObject;var checkObjectProps=function(data,template,diffData,validatedOptions,validatedOptionsPrepared,prevPropName){for(var prop in template){if(template[LEXICON.hOP](prop)&&data[LEXICON.hOP](prop)){var isValid=false;var isDiff=false;var templateValue=template[prop];var templateValueType=type(templateValue);var templateIsComplex=templateValueType==TYPES.o;var templateTypes=!COMPATIBILITY.isA(templateValue)?[templateValue]:templateValue;var dataDiffValue=diffData[prop];var dataValue=data[prop];var dataValueType=type(dataValue);var propPrefix=prevPropName?prevPropName+'.':'';var error="The option \""+propPrefix+prop+"\" wasn't set, because";var errorPossibleTypes=[];var errorRestrictedStrings=[];var restrictedStringValuesSplit;var restrictedStringValuesPossibilitiesSplit;var isRestrictedValue;var mainPossibility;var currType;var i;var v;var j;dataDiffValue=dataDiffValue===undefined?{}:dataDiffValue;if(templateIsComplex&&dataValueType==TYPES.o){validatedOptions[prop]={};validatedOptionsPrepared[prop]={};checkObjectProps(dataValue,templateValue,dataDiffValue,validatedOptions[prop],validatedOptionsPrepared[prop],propPrefix+prop);FRAMEWORK.each([data,validatedOptions,validatedOptionsPrepared],function(index,value){if(isEmptyObj(value[prop])){delete value[prop];}});}
else if(!templateIsComplex){for(i=0;i<templateTypes[LEXICON.l];i++){currType=templateTypes[i];templateValueType=type(currType);isRestrictedValue=templateValueType==TYPES.s&&inArray(currType,possibleTemplateTypes)===-1;if(isRestrictedValue){errorPossibleTypes.push(TYPES.s);restrictedStringValuesSplit=currType.split(restrictedStringsSplit);errorRestrictedStrings=errorRestrictedStrings.concat(restrictedStringValuesSplit);for(v=0;v<restrictedStringValuesSplit[LEXICON.l];v++){restrictedStringValuesPossibilitiesSplit=restrictedStringValuesSplit[v].split(restrictedStringsPossibilitiesSplit);mainPossibility=restrictedStringValuesPossibilitiesSplit[0];for(j=0;j<restrictedStringValuesPossibilitiesSplit[LEXICON.l];j++){if(dataValue===restrictedStringValuesPossibilitiesSplit[j]){isValid=true;break;}}
if(isValid)
break;}}
else{errorPossibleTypes.push(currType);if(dataValueType===currType){isValid=true;break;}}}
if(isValid){isDiff=dataValue!==dataDiffValue;if(isDiff)
validatedOptions[prop]=dataValue;if(isRestrictedValue?inArray(dataDiffValue,restrictedStringValuesPossibilitiesSplit)<0:isDiff)
validatedOptionsPrepared[prop]=isRestrictedValue?mainPossibility:dataValue;}
else if(writeErrors){console.warn(error+" it doesn't accept the type [ "+dataValueType.toUpperCase()+" ] with the value of \""+dataValue+"\".\r\n"+
"Accepted types are: [ "+errorPossibleTypes.join(', ').toUpperCase()+" ]."+
(errorRestrictedStrings[length]>0?"\r\nValid strings are: [ "+errorRestrictedStrings.join(', ').split(restrictedStringsPossibilitiesSplit).join(', ')+" ].":''));}
delete data[prop];}}}};checkObjectProps(objectCopy,template,diffObj||{},validatedOptions,validatedOptionsPrepared);if(!isEmptyObj(objectCopy)&&writeErrors)
console.warn('The following options are discarded due to invalidity:\r\n'+window.JSON.stringify(objectCopy,null,2));return{_default:validatedOptions,_prepared:validatedOptionsPrepared};}}}());function initOverlayScrollbarsStatics(){if(!_pluginsGlobals)
_pluginsGlobals=new OverlayScrollbarsGlobals(_pluginsOptions._defaults);if(!_pluginsAutoUpdateLoop)
_pluginsAutoUpdateLoop=new OverlayScrollbarsAutoUpdateLoop(_pluginsGlobals);}
function OverlayScrollbarsGlobals(defaultOptions){var _base=this;var strOverflow='overflow';var strHidden='hidden';var strScroll='scroll';var bodyElement=FRAMEWORK('body');var scrollbarDummyElement=FRAMEWORK('<div id="os-dummy-scrollbar-size"><div></div></div>');var scrollbarDummyElement0=scrollbarDummyElement[0];var dummyContainerChild=FRAMEWORK(scrollbarDummyElement.children('div').eq(0));bodyElement.append(scrollbarDummyElement);scrollbarDummyElement.hide().show();var nativeScrollbarSize=calcNativeScrollbarSize(scrollbarDummyElement0);var nativeScrollbarIsOverlaid={x:nativeScrollbarSize.x===0,y:nativeScrollbarSize.y===0};var msie=(function(){var ua=window.navigator.userAgent;var strIndexOf='indexOf';var strSubString='substring';var msie=ua[strIndexOf]('MSIE ');var trident=ua[strIndexOf]('Trident/');var edge=ua[strIndexOf]('Edge/');var rv=ua[strIndexOf]('rv:');var result;var parseIntFunc=parseInt;if(msie>0)
result=parseIntFunc(ua[strSubString](msie+5,ua[strIndexOf]('.',msie)),10);else if(trident>0)
result=parseIntFunc(ua[strSubString](rv+3,ua[strIndexOf]('.',rv)),10);else if(edge>0)
result=parseIntFunc(ua[strSubString](edge+5,ua[strIndexOf]('.',edge)),10);return result;})();FRAMEWORK.extend(_base,{defaultOptions:defaultOptions,msie:msie,autoUpdateLoop:false,autoUpdateRecommended:!COMPATIBILITY.mO(),nativeScrollbarSize:nativeScrollbarSize,nativeScrollbarIsOverlaid:nativeScrollbarIsOverlaid,nativeScrollbarStyling:(function(){var result=false;scrollbarDummyElement.addClass('os-viewport-native-scrollbars-invisible');try{result=(scrollbarDummyElement.css('scrollbar-width')==='none'&&(msie>9||!msie))||window.getComputedStyle(scrollbarDummyElement0,'::-webkit-scrollbar').getPropertyValue('display')==='none';}catch(ex){}
return result;})(),overlayScrollbarDummySize:{x:30,y:30},cssCalc:VENDORS._cssPropertyValue('width','calc','(1px)')||null,restrictedMeasuring:(function(){scrollbarDummyElement.css(strOverflow,strHidden);var scrollSize={w:scrollbarDummyElement0[LEXICON.sW],h:scrollbarDummyElement0[LEXICON.sH]};scrollbarDummyElement.css(strOverflow,'visible');var scrollSize2={w:scrollbarDummyElement0[LEXICON.sW],h:scrollbarDummyElement0[LEXICON.sH]};return(scrollSize.w-scrollSize2.w)!==0||(scrollSize.h-scrollSize2.h)!==0;})(),rtlScrollBehavior:(function(){scrollbarDummyElement.css({'overflow-y':strHidden,'overflow-x':strScroll,'direction':'rtl'}).scrollLeft(0);var dummyContainerOffset=scrollbarDummyElement.offset();var dummyContainerChildOffset=dummyContainerChild.offset();scrollbarDummyElement.scrollLeft(-999);var dummyContainerChildOffsetAfterScroll=dummyContainerChild.offset();return{i:dummyContainerOffset.left===dummyContainerChildOffset.left,n:dummyContainerChildOffset.left!==dummyContainerChildOffsetAfterScroll.left};})(),supportTransform:!!VENDORS._cssProperty('transform'),supportTransition:!!VENDORS._cssProperty('transition'),supportPassiveEvents:(function(){var supportsPassive=false;try{window.addEventListener('test',null,Object.defineProperty({},'passive',{get:function(){supportsPassive=true;}}));}catch(e){}
return supportsPassive;})(),supportResizeObserver:!!COMPATIBILITY.rO(),supportMutationObserver:!!COMPATIBILITY.mO()});scrollbarDummyElement.removeAttr(LEXICON.s).remove();(function(){if(nativeScrollbarIsOverlaid.x&&nativeScrollbarIsOverlaid.y)
return;var abs=MATH.abs;var windowWidth=COMPATIBILITY.wW();var windowHeight=COMPATIBILITY.wH();var windowDpr=getWindowDPR();var onResize=function(){if(INSTANCES().length>0){var newW=COMPATIBILITY.wW();var newH=COMPATIBILITY.wH();var deltaW=newW-windowWidth;var deltaH=newH-windowHeight;if(deltaW===0&&deltaH===0)
return;var deltaWRatio=MATH.round(newW/(windowWidth/100.0));var deltaHRatio=MATH.round(newH/(windowHeight/100.0));var absDeltaW=abs(deltaW);var absDeltaH=abs(deltaH);var absDeltaWRatio=abs(deltaWRatio);var absDeltaHRatio=abs(deltaHRatio);var newDPR=getWindowDPR();var deltaIsBigger=absDeltaW>2&&absDeltaH>2;var difference=!differenceIsBiggerThanOne(absDeltaWRatio,absDeltaHRatio);var dprChanged=newDPR!==windowDpr&&windowDpr>0;var isZoom=deltaIsBigger&&difference&&dprChanged;var oldScrollbarSize=_base.nativeScrollbarSize;var newScrollbarSize;if(isZoom){bodyElement.append(scrollbarDummyElement);newScrollbarSize=_base.nativeScrollbarSize=calcNativeScrollbarSize(scrollbarDummyElement[0]);scrollbarDummyElement.remove();if(oldScrollbarSize.x!==newScrollbarSize.x||oldScrollbarSize.y!==newScrollbarSize.y){FRAMEWORK.each(INSTANCES(),function(){if(INSTANCES(this))
INSTANCES(this).update('zoom');});}}
windowWidth=newW;windowHeight=newH;windowDpr=newDPR;}};function differenceIsBiggerThanOne(valOne,valTwo){var absValOne=abs(valOne);var absValTwo=abs(valTwo);return!(absValOne===absValTwo||absValOne+1===absValTwo||absValOne-1===absValTwo);}
function getWindowDPR(){var dDPI=window.screen.deviceXDPI||0;var sDPI=window.screen.logicalXDPI||1;return window.devicePixelRatio||(dDPI/sDPI);}
FRAMEWORK(window).on('resize',onResize);})();function calcNativeScrollbarSize(measureElement){return{x:measureElement[LEXICON.oH]-measureElement[LEXICON.cH],y:measureElement[LEXICON.oW]-measureElement[LEXICON.cW]};}}
function OverlayScrollbarsAutoUpdateLoop(globals){var _base=this;var _inArray=FRAMEWORK.inArray;var _getNow=COMPATIBILITY.now;var _strAutoUpdate='autoUpdate';var _strAutoUpdateInterval=_strAutoUpdate+'Interval';var _strLength=LEXICON.l;var _loopingInstances=[];var _loopingInstancesIntervalCache=[];var _loopIsActive=false;var _loopIntervalDefault=33;var _loopInterval=_loopIntervalDefault;var _loopTimeOld=_getNow();var _loopID;var loop=function(){if(_loopingInstances[_strLength]>0&&_loopIsActive){_loopID=COMPATIBILITY.rAF()(function(){loop();});var timeNew=_getNow();var timeDelta=timeNew-_loopTimeOld;var lowestInterval;var instance;var instanceOptions;var instanceAutoUpdateAllowed;var instanceAutoUpdateInterval;var now;if(timeDelta>_loopInterval){_loopTimeOld=timeNew-(timeDelta%_loopInterval);lowestInterval=_loopIntervalDefault;for(var i=0;i<_loopingInstances[_strLength];i++){instance=_loopingInstances[i];if(instance!==undefined){instanceOptions=instance.options();instanceAutoUpdateAllowed=instanceOptions[_strAutoUpdate];instanceAutoUpdateInterval=MATH.max(1,instanceOptions[_strAutoUpdateInterval]);now=_getNow();if((instanceAutoUpdateAllowed===true||instanceAutoUpdateAllowed===null)&&(now-_loopingInstancesIntervalCache[i])>instanceAutoUpdateInterval){instance.update('auto');_loopingInstancesIntervalCache[i]=new Date(now+=instanceAutoUpdateInterval);}
lowestInterval=MATH.max(1,MATH.min(lowestInterval,instanceAutoUpdateInterval));}}
_loopInterval=lowestInterval;}}else{_loopInterval=_loopIntervalDefault;}};_base.add=function(instance){if(_inArray(instance,_loopingInstances)===-1){_loopingInstances.push(instance);_loopingInstancesIntervalCache.push(_getNow());if(_loopingInstances[_strLength]>0&&!_loopIsActive){_loopIsActive=true;globals.autoUpdateLoop=_loopIsActive;loop();}}};_base.remove=function(instance){var index=_inArray(instance,_loopingInstances);if(index>-1){_loopingInstancesIntervalCache.splice(index,1);_loopingInstances.splice(index,1);if(_loopingInstances[_strLength]===0&&_loopIsActive){_loopIsActive=false;globals.autoUpdateLoop=_loopIsActive;if(_loopID!==undefined){COMPATIBILITY.cAF()(_loopID);_loopID=-1;}}}};}
function OverlayScrollbarsInstance(pluginTargetElement,options,extensions,globals,autoUpdateLoop){var type=COMPATIBILITY.type;var inArray=FRAMEWORK.inArray;var each=FRAMEWORK.each;var _base=new _plugin();var _frameworkProto=FRAMEWORK[LEXICON.p];if(!isHTMLElement(pluginTargetElement))
return;if(INSTANCES(pluginTargetElement)){var inst=INSTANCES(pluginTargetElement);inst.options(options);return inst;}
var _nativeScrollbarIsOverlaid;var _overlayScrollbarDummySize;var _rtlScrollBehavior;var _autoUpdateRecommended;var _msieVersion;var _nativeScrollbarStyling;var _cssCalc;var _nativeScrollbarSize;var _supportTransition;var _supportTransform;var _supportPassiveEvents;var _supportResizeObserver;var _supportMutationObserver;var _restrictedMeasuring;var _initialized;var _destroyed;var _isTextarea;var _isBody;var _documentMixed;var _domExists;var _isBorderBox;var _sizeAutoObserverAdded;var _paddingX;var _paddingY;var _borderX;var _borderY;var _marginX;var _marginY;var _isRTL;var _sleeping;var _contentBorderSize={};var _scrollHorizontalInfo={};var _scrollVerticalInfo={};var _viewportSize={};var _nativeScrollbarMinSize={};var _strMinusHidden='-hidden';var _strMarginMinus='margin-';var _strPaddingMinus='padding-';var _strBorderMinus='border-';var _strTop='top';var _strRight='right';var _strBottom='bottom';var _strLeft='left';var _strMinMinus='min-';var _strMaxMinus='max-';var _strWidth='width';var _strHeight='height';var _strFloat='float';var _strEmpty='';var _strAuto='auto';var _strSync='sync';var _strScroll='scroll';var _strHundredPercent='100%';var _strX='x';var _strY='y';var _strDot='.';var _strSpace=' ';var _strScrollbar='scrollbar';var _strMinusHorizontal='-horizontal';var _strMinusVertical='-vertical';var _strScrollLeft=_strScroll+'Left';var _strScrollTop=_strScroll+'Top';var _strMouseTouchDownEvent='mousedown touchstart';var _strMouseTouchUpEvent='mouseup touchend touchcancel';var _strMouseTouchMoveEvent='mousemove touchmove';var _strMouseEnter='mouseenter';var _strMouseLeave='mouseleave';var _strKeyDownEvent='keydown';var _strKeyUpEvent='keyup';var _strSelectStartEvent='selectstart';var _strTransitionEndEvent='transitionend webkitTransitionEnd oTransitionEnd';var _strResizeObserverProperty='__overlayScrollbarsRO__';var _cassNamesPrefix='os-';var _classNameHTMLElement=_cassNamesPrefix+'html';var _classNameHostElement=_cassNamesPrefix+'host';var _classNameHostElementForeign=_classNameHostElement+'-foreign';var _classNameHostTextareaElement=_classNameHostElement+'-textarea';var _classNameHostScrollbarHorizontalHidden=_classNameHostElement+'-'+_strScrollbar+_strMinusHorizontal+_strMinusHidden;var _classNameHostScrollbarVerticalHidden=_classNameHostElement+'-'+_strScrollbar+_strMinusVertical+_strMinusHidden;var _classNameHostTransition=_classNameHostElement+'-transition';var _classNameHostRTL=_classNameHostElement+'-rtl';var _classNameHostResizeDisabled=_classNameHostElement+'-resize-disabled';var _classNameHostScrolling=_classNameHostElement+'-scrolling';var _classNameHostOverflow=_classNameHostElement+'-overflow';var _classNameHostOverflow=_classNameHostElement+'-overflow';var _classNameHostOverflowX=_classNameHostOverflow+'-x';var _classNameHostOverflowY=_classNameHostOverflow+'-y';var _classNameTextareaElement=_cassNamesPrefix+'textarea';var _classNameTextareaCoverElement=_classNameTextareaElement+'-cover';var _classNamePaddingElement=_cassNamesPrefix+'padding';var _classNameViewportElement=_cassNamesPrefix+'viewport';var _classNameViewportNativeScrollbarsInvisible=_classNameViewportElement+'-native-scrollbars-invisible';var _classNameViewportNativeScrollbarsOverlaid=_classNameViewportElement+'-native-scrollbars-overlaid';var _classNameContentElement=_cassNamesPrefix+'content';var _classNameContentArrangeElement=_cassNamesPrefix+'content-arrange';var _classNameContentGlueElement=_cassNamesPrefix+'content-glue';var _classNameSizeAutoObserverElement=_cassNamesPrefix+'size-auto-observer';var _classNameResizeObserverElement=_cassNamesPrefix+'resize-observer';var _classNameResizeObserverItemElement=_cassNamesPrefix+'resize-observer-item';var _classNameResizeObserverItemFinalElement=_classNameResizeObserverItemElement+'-final';var _classNameTextInherit=_cassNamesPrefix+'text-inherit';var _classNameScrollbar=_cassNamesPrefix+_strScrollbar;var _classNameScrollbarTrack=_classNameScrollbar+'-track';var _classNameScrollbarTrackOff=_classNameScrollbarTrack+'-off';var _classNameScrollbarHandle=_classNameScrollbar+'-handle';var _classNameScrollbarHandleOff=_classNameScrollbarHandle+'-off';var _classNameScrollbarUnusable=_classNameScrollbar+'-unusable';var _classNameScrollbarAutoHidden=_classNameScrollbar+'-'+_strAuto+_strMinusHidden;var _classNameScrollbarCorner=_classNameScrollbar+'-corner';var _classNameScrollbarCornerResize=_classNameScrollbarCorner+'-resize';var _classNameScrollbarCornerResizeB=_classNameScrollbarCornerResize+'-both';var _classNameScrollbarCornerResizeH=_classNameScrollbarCornerResize+_strMinusHorizontal;var _classNameScrollbarCornerResizeV=_classNameScrollbarCornerResize+_strMinusVertical;var _classNameScrollbarHorizontal=_classNameScrollbar+_strMinusHorizontal;var _classNameScrollbarVertical=_classNameScrollbar+_strMinusVertical;var _classNameDragging=_cassNamesPrefix+'dragging';var _classNameThemeNone=_cassNamesPrefix+'theme-none';var _classNamesDynamicDestroy=[_classNameViewportNativeScrollbarsInvisible,_classNameViewportNativeScrollbarsOverlaid,_classNameScrollbarTrackOff,_classNameScrollbarHandleOff,_classNameScrollbarUnusable,_classNameScrollbarAutoHidden,_classNameScrollbarCornerResize,_classNameScrollbarCornerResizeB,_classNameScrollbarCornerResizeH,_classNameScrollbarCornerResizeV,_classNameDragging].join(_strSpace);var _callbacksInitQeueue=[];var _viewportAttrsFromTarget=[LEXICON.ti];var _defaultOptions;var _currentOptions;var _currentPreparedOptions;var _extensions={};var _extensionsPrivateMethods='added removed on contract';var _lastUpdateTime;var _swallowedUpdateHints={};var _swallowedUpdateTimeout;var _swallowUpdateLag=42;var _updateOnLoadEventName='load';var _updateOnLoadElms=[];var _windowElement;var _documentElement;var _htmlElement;var _bodyElement;var _targetElement;var _hostElement;var _sizeAutoObserverElement;var _sizeObserverElement;var _paddingElement;var _viewportElement;var _contentElement;var _contentArrangeElement;var _contentGlueElement;var _textareaCoverElement;var _scrollbarCornerElement;var _scrollbarHorizontalElement;var _scrollbarHorizontalTrackElement;var _scrollbarHorizontalHandleElement;var _scrollbarVerticalElement;var _scrollbarVerticalTrackElement;var _scrollbarVerticalHandleElement;var _windowElementNative;var _documentElementNative;var _targetElementNative;var _hostElementNative;var _sizeAutoObserverElementNative;var _sizeObserverElementNative;var _paddingElementNative;var _viewportElementNative;var _contentElementNative;var _hostSizeCache;var _contentScrollSizeCache;var _arrangeContentSizeCache;var _hasOverflowCache;var _hideOverflowCache;var _widthAutoCache;var _heightAutoCache;var _cssBoxSizingCache;var _cssPaddingCache;var _cssBorderCache;var _cssMarginCache;var _cssDirectionCache;var _cssDirectionDetectedCache;var _paddingAbsoluteCache;var _clipAlwaysCache;var _contentGlueSizeCache;var _overflowBehaviorCache;var _overflowAmountCache;var _ignoreOverlayScrollbarHidingCache;var _autoUpdateCache;var _sizeAutoCapableCache;var _contentElementScrollSizeChangeDetectedCache;var _hostElementSizeChangeDetectedCache;var _scrollbarsVisibilityCache;var _scrollbarsAutoHideCache;var _scrollbarsClickScrollingCache;var _scrollbarsDragScrollingCache;var _resizeCache;var _normalizeRTLCache;var _classNameCache;var _oldClassName;var _textareaAutoWrappingCache;var _textareaInfoCache;var _textareaSizeCache;var _textareaDynHeightCache;var _textareaDynWidthCache;var _bodyMinSizeCache;var _updateAutoCache={};var _mutationObserverHost;var _mutationObserverContent;var _mutationObserverHostCallback;var _mutationObserverContentCallback;var _mutationObserversConnected;var _mutationObserverAttrsTextarea=['wrap','cols','rows'];var _mutationObserverAttrsHost=[LEXICON.i,LEXICON.c,LEXICON.s,'open'].concat(_viewportAttrsFromTarget);var _destroyEvents=[];var _textareaHasFocus;var _scrollbarsAutoHideTimeoutId;var _scrollbarsAutoHideMoveTimeoutId;var _scrollbarsAutoHideDelay;var _scrollbarsAutoHideNever;var _scrollbarsAutoHideScroll;var _scrollbarsAutoHideMove;var _scrollbarsAutoHideLeave;var _scrollbarsHandleHovered;var _scrollbarsHandlesDefineScrollPos;var _resizeNone;var _resizeBoth;var _resizeHorizontal;var _resizeVertical;function setupResponsiveEventListener(element,eventNames,listener,remove,passiveOrOptions){var collected=COMPATIBILITY.isA(eventNames)&&COMPATIBILITY.isA(listener);var method=remove?'removeEventListener':'addEventListener';var onOff=remove?'off':'on';var events=collected?false:eventNames.split(_strSpace)
var i=0;var passiveOrOptionsIsObj=FRAMEWORK.isPlainObject(passiveOrOptions);var passive=(_supportPassiveEvents&&(passiveOrOptionsIsObj?(passiveOrOptions._passive):passiveOrOptions))||false;var capture=passiveOrOptionsIsObj&&(passiveOrOptions._capture||false);var nativeParam=_supportPassiveEvents?{passive:passive,capture:capture,}:capture;if(collected){for(;i<eventNames[LEXICON.l];i++)
setupResponsiveEventListener(element,eventNames[i],listener[i],remove,passiveOrOptions);}
else{for(;i<events[LEXICON.l];i++){if(_supportPassiveEvents){element[0][method](events[i],listener,nativeParam);}
else{element[onOff](events[i],listener);}}}}
function addDestroyEventListener(element,eventNames,listener,passive){setupResponsiveEventListener(element,eventNames,listener,false,passive);_destroyEvents.push(COMPATIBILITY.bind(setupResponsiveEventListener,0,element,eventNames,listener,true,passive));}
function setupResizeObserver(targetElement,onElementResizedCallback){if(targetElement){var resizeObserver=COMPATIBILITY.rO();var strAnimationStartEvent='animationstart mozAnimationStart webkitAnimationStart MSAnimationStart';var strChildNodes='childNodes';var constScroll=3333333;var callback=function(){targetElement[_strScrollTop](constScroll)[_strScrollLeft](_isRTL?_rtlScrollBehavior.n?-constScroll:_rtlScrollBehavior.i?0:constScroll:constScroll);onElementResizedCallback();};if(onElementResizedCallback){if(_supportResizeObserver){var element=targetElement.addClass('observed').append(generateDiv(_classNameResizeObserverElement)).contents()[0];var observer=element[_strResizeObserverProperty]=new resizeObserver(callback);observer.observe(element);}
else{if(_msieVersion>9||!_autoUpdateRecommended){targetElement.prepend(generateDiv(_classNameResizeObserverElement,generateDiv({c:_classNameResizeObserverItemElement,dir:'ltr'},generateDiv(_classNameResizeObserverItemElement,generateDiv(_classNameResizeObserverItemFinalElement))+
generateDiv(_classNameResizeObserverItemElement,generateDiv({c:_classNameResizeObserverItemFinalElement,style:'width: 200%; height: 200%'})))));var observerElement=targetElement[0][strChildNodes][0][strChildNodes][0];var shrinkElement=FRAMEWORK(observerElement[strChildNodes][1]);var expandElement=FRAMEWORK(observerElement[strChildNodes][0]);var expandElementChild=FRAMEWORK(expandElement[0][strChildNodes][0]);var widthCache=observerElement[LEXICON.oW];var heightCache=observerElement[LEXICON.oH];var isDirty;var rAFId;var currWidth;var currHeight;var factor=2;var nativeScrollbarSize=globals.nativeScrollbarSize;var reset=function(){expandElement[_strScrollLeft](constScroll)[_strScrollTop](constScroll);shrinkElement[_strScrollLeft](constScroll)[_strScrollTop](constScroll);};var onResized=function(){rAFId=0;if(!isDirty)
return;widthCache=currWidth;heightCache=currHeight;callback();};var onScroll=function(event){currWidth=observerElement[LEXICON.oW];currHeight=observerElement[LEXICON.oH];isDirty=currWidth!=widthCache||currHeight!=heightCache;if(event&&isDirty&&!rAFId){COMPATIBILITY.cAF()(rAFId);rAFId=COMPATIBILITY.rAF()(onResized);}
else if(!event)
onResized();reset();if(event){COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}
return false;};var expandChildCSS={};var observerElementCSS={};setTopRightBottomLeft(observerElementCSS,_strEmpty,[-((nativeScrollbarSize.y+1)*factor),nativeScrollbarSize.x*-factor,nativeScrollbarSize.y*-factor,-((nativeScrollbarSize.x+1)*factor)]);FRAMEWORK(observerElement).css(observerElementCSS);expandElement.on(_strScroll,onScroll);shrinkElement.on(_strScroll,onScroll);targetElement.on(strAnimationStartEvent,function(){onScroll(false);});expandChildCSS[_strWidth]=constScroll;expandChildCSS[_strHeight]=constScroll;expandElementChild.css(expandChildCSS);reset();}
else{var attachEvent=_documentElementNative.attachEvent;var isIE=_msieVersion!==undefined;if(attachEvent){targetElement.prepend(generateDiv(_classNameResizeObserverElement));findFirst(targetElement,_strDot+_classNameResizeObserverElement)[0].attachEvent('onresize',callback);}
else{var obj=_documentElementNative.createElement(TYPES.o);obj.setAttribute(LEXICON.ti,'-1');obj.setAttribute(LEXICON.c,_classNameResizeObserverElement);obj.onload=function(){var wnd=this.contentDocument.defaultView;wnd.addEventListener('resize',callback);wnd.document.documentElement.style.display='none';};obj.type='text/html';if(isIE)
targetElement.prepend(obj);obj.data='about:blank';if(!isIE)
targetElement.prepend(obj);targetElement.on(strAnimationStartEvent,callback);}}}
if(targetElement[0]===_sizeObserverElementNative){var directionChanged=function(){var dir=_hostElement.css('direction');var css={};var scrollLeftValue=0;var result=false;if(dir!==_cssDirectionDetectedCache){if(dir==='ltr'){css[_strLeft]=0;css[_strRight]=_strAuto;scrollLeftValue=constScroll;}
else{css[_strLeft]=_strAuto;css[_strRight]=0;scrollLeftValue=_rtlScrollBehavior.n?-constScroll:_rtlScrollBehavior.i?0:constScroll;}
_sizeObserverElement.children().eq(0).css(css);_sizeObserverElement[_strScrollLeft](scrollLeftValue)[_strScrollTop](constScroll);_cssDirectionDetectedCache=dir;result=true;}
return result;};directionChanged();addDestroyEventListener(targetElement,_strScroll,function(event){if(directionChanged())
update();COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);return false;});}}
else{if(_supportResizeObserver){var element=targetElement.contents()[0];var resizeObserverObj=element[_strResizeObserverProperty];if(resizeObserverObj){resizeObserverObj.disconnect();delete element[_strResizeObserverProperty];}}
else{remove(targetElement.children(_strDot+_classNameResizeObserverElement).eq(0));}}}}
function createMutationObservers(){if(_supportMutationObserver){var mutationObserverContentLag=11;var mutationObserver=COMPATIBILITY.mO();var contentLastUpdate=COMPATIBILITY.now();var mutationTarget;var mutationAttrName;var mutationIsClass;var oldMutationVal;var newClassVal;var hostClassNameRegex;var contentTimeout;var now;var sizeAuto;var action;_mutationObserverHostCallback=function(mutations){var doUpdate=false;var doUpdateForce=false;var mutation;var mutatedAttrs=[];if(_initialized&&!_sleeping){each(mutations,function(){mutation=this;mutationTarget=mutation.target;mutationAttrName=mutation.attributeName;mutationIsClass=mutationAttrName===LEXICON.c;oldMutationVal=mutation.oldValue;newClassVal=mutationTarget.className;if(_domExists&&mutationIsClass&&!doUpdateForce){if(oldMutationVal.indexOf(_classNameHostElementForeign)>-1&&newClassVal.indexOf(_classNameHostElementForeign)<0){hostClassNameRegex=createHostClassNameRegExp(true);_hostElementNative.className=newClassVal.split(_strSpace).concat(oldMutationVal.split(_strSpace).filter(function(name){return name.match(hostClassNameRegex);})).join(_strSpace);doUpdate=doUpdateForce=true;}}
if(!doUpdate){doUpdate=mutationIsClass?hostClassNamesChanged(oldMutationVal,newClassVal):mutationAttrName===LEXICON.s?oldMutationVal!==mutationTarget[LEXICON.s].cssText:true;}
mutatedAttrs.push(mutationAttrName);});updateViewportAttrsFromTarget(mutatedAttrs);if(doUpdate)
_base.update(doUpdateForce||_strAuto);}
return doUpdate;};_mutationObserverContentCallback=function(mutations){var doUpdate=false;var mutation;if(_initialized&&!_sleeping){each(mutations,function(){mutation=this;doUpdate=isUnknownMutation(mutation);return!doUpdate;});if(doUpdate){now=COMPATIBILITY.now();sizeAuto=(_heightAutoCache||_widthAutoCache);action=function(){if(!_destroyed){contentLastUpdate=now;if(_isTextarea)
textareaUpdate();if(sizeAuto)
update();else
_base.update(_strAuto);}};clearTimeout(contentTimeout);if(mutationObserverContentLag<=0||now-contentLastUpdate>mutationObserverContentLag||!sizeAuto)
action();else
contentTimeout=setTimeout(action,mutationObserverContentLag);}}
return doUpdate;}
_mutationObserverHost=new mutationObserver(_mutationObserverHostCallback);_mutationObserverContent=new mutationObserver(_mutationObserverContentCallback);}}
function connectMutationObservers(){if(_supportMutationObserver&&!_mutationObserversConnected){_mutationObserverHost.observe(_hostElementNative,{attributes:true,attributeOldValue:true,attributeFilter:_mutationObserverAttrsHost});_mutationObserverContent.observe(_isTextarea?_targetElementNative:_contentElementNative,{attributes:true,attributeOldValue:true,subtree:!_isTextarea,childList:!_isTextarea,characterData:!_isTextarea,attributeFilter:_isTextarea?_mutationObserverAttrsTextarea:_mutationObserverAttrsHost});_mutationObserversConnected=true;}}
function disconnectMutationObservers(){if(_supportMutationObserver&&_mutationObserversConnected){_mutationObserverHost.disconnect();_mutationObserverContent.disconnect();_mutationObserversConnected=false;}}
function hostOnResized(){if(!_sleeping){var changed;var hostSize={w:_sizeObserverElementNative[LEXICON.sW],h:_sizeObserverElementNative[LEXICON.sH]};changed=checkCache(hostSize,_hostElementSizeChangeDetectedCache);_hostElementSizeChangeDetectedCache=hostSize;if(changed)
update({_hostSizeChanged:true});}}
function hostOnMouseEnter(){if(_scrollbarsAutoHideLeave)
refreshScrollbarsAutoHide(true);}
function hostOnMouseLeave(){if(_scrollbarsAutoHideLeave&&!_bodyElement.hasClass(_classNameDragging))
refreshScrollbarsAutoHide(false);}
function hostOnMouseMove(){if(_scrollbarsAutoHideMove){refreshScrollbarsAutoHide(true);clearTimeout(_scrollbarsAutoHideMoveTimeoutId);_scrollbarsAutoHideMoveTimeoutId=setTimeout(function(){if(_scrollbarsAutoHideMove&&!_destroyed)
refreshScrollbarsAutoHide(false);},100);}}
function documentOnSelectStart(event){COMPATIBILITY.prvD(event);return false;}
function updateOnLoadCallback(event){var elm=FRAMEWORK(event.target);eachUpdateOnLoad(function(i,updateOnLoadSelector){if(elm.is(updateOnLoadSelector)){update({_contentSizeChanged:true});}});}
function setupHostMouseTouchEvents(destroy){if(!destroy)
setupHostMouseTouchEvents(true);setupResponsiveEventListener(_hostElement,_strMouseTouchMoveEvent.split(_strSpace)[0],hostOnMouseMove,(!_scrollbarsAutoHideMove||destroy),true);setupResponsiveEventListener(_hostElement,[_strMouseEnter,_strMouseLeave],[hostOnMouseEnter,hostOnMouseLeave],(!_scrollbarsAutoHideLeave||destroy),true);if(!_initialized&&!destroy)
_hostElement.one('mouseover',hostOnMouseEnter);}
function bodyMinSizeChanged(){var bodyMinSize={};if(_isBody&&_contentArrangeElement){bodyMinSize.w=parseToZeroOrNumber(_contentArrangeElement.css(_strMinMinus+_strWidth));bodyMinSize.h=parseToZeroOrNumber(_contentArrangeElement.css(_strMinMinus+_strHeight));bodyMinSize.c=checkCache(bodyMinSize,_bodyMinSizeCache);bodyMinSize.f=true;}
_bodyMinSizeCache=bodyMinSize;return!!bodyMinSize.c;}
function hostClassNamesChanged(oldClassNames,newClassNames){var currClasses=typeof newClassNames==TYPES.s?newClassNames.split(_strSpace):[];var oldClasses=typeof oldClassNames==TYPES.s?oldClassNames.split(_strSpace):[];var diff=getArrayDifferences(oldClasses,currClasses);var idx=inArray(_classNameThemeNone,diff);var i;var regex;if(idx>-1)
diff.splice(idx,1);if(diff[LEXICON.l]>0){regex=createHostClassNameRegExp(true,true);for(i=0;i<diff.length;i++){if(!diff[i].match(regex)){return true;}}}
return false;}
function isUnknownMutation(mutation){var attributeName=mutation.attributeName;var mutationTarget=mutation.target;var mutationType=mutation.type;var strClosest='closest';if(mutationTarget===_contentElementNative)
return attributeName===null;if(mutationType==='attributes'&&(attributeName===LEXICON.c||attributeName===LEXICON.s)&&!_isTextarea){if(attributeName===LEXICON.c&&FRAMEWORK(mutationTarget).hasClass(_classNameHostElement))
return hostClassNamesChanged(mutation.oldValue,mutationTarget.className);if(typeof mutationTarget[strClosest]!=TYPES.f)
return true;if(mutationTarget[strClosest](_strDot+_classNameResizeObserverElement)!==null||mutationTarget[strClosest](_strDot+_classNameScrollbar)!==null||mutationTarget[strClosest](_strDot+_classNameScrollbarCorner)!==null)
return false;}
return true;}
function updateAutoContentSizeChanged(){if(_sleeping)
return false;var contentMeasureElement=getContentMeasureElement();var textareaValueLength=_isTextarea&&_widthAutoCache&&!_textareaAutoWrappingCache?_targetElement.val().length:0;var setCSS=!_mutationObserversConnected&&_widthAutoCache&&!_isTextarea;var css={};var float;var bodyMinSizeC;var changed;var contentElementScrollSize;if(setCSS){float=_contentElement.css(_strFloat);css[_strFloat]=_isRTL?_strRight:_strLeft;css[_strWidth]=_strAuto;_contentElement.css(css);}
contentElementScrollSize={w:contentMeasureElement[LEXICON.sW]+textareaValueLength,h:contentMeasureElement[LEXICON.sH]+textareaValueLength};if(setCSS){css[_strFloat]=float;css[_strWidth]=_strHundredPercent;_contentElement.css(css);}
bodyMinSizeC=bodyMinSizeChanged();changed=checkCache(contentElementScrollSize,_contentElementScrollSizeChangeDetectedCache);_contentElementScrollSizeChangeDetectedCache=contentElementScrollSize;return changed||bodyMinSizeC;}
function meaningfulAttrsChanged(){if(_sleeping||_mutationObserversConnected)
return;var elem;var curr;var cache;var changedAttrs=[];var checks=[{_elem:_hostElement,_attrs:_mutationObserverAttrsHost.concat(':visible')},{_elem:_isTextarea?_targetElement:undefined,_attrs:_mutationObserverAttrsTextarea}];each(checks,function(index,check){elem=check._elem;if(elem){each(check._attrs,function(index,attr){curr=attr.charAt(0)===':'?elem.is(attr):elem.attr(attr);cache=_updateAutoCache[attr];if(checkCache(curr,cache)){changedAttrs.push(attr);}
_updateAutoCache[attr]=curr;});}});updateViewportAttrsFromTarget(changedAttrs);return changedAttrs[LEXICON.l]>0;}
function isSizeAffectingCSSProperty(propertyName){if(!_initialized)
return true;var flexGrow='flex-grow';var flexShrink='flex-shrink';var flexBasis='flex-basis';var affectingPropsX=[_strWidth,_strMinMinus+_strWidth,_strMaxMinus+_strWidth,_strMarginMinus+_strLeft,_strMarginMinus+_strRight,_strLeft,_strRight,'font-weight','word-spacing',flexGrow,flexShrink,flexBasis];var affectingPropsXContentBox=[_strPaddingMinus+_strLeft,_strPaddingMinus+_strRight,_strBorderMinus+_strLeft+_strWidth,_strBorderMinus+_strRight+_strWidth];var affectingPropsY=[_strHeight,_strMinMinus+_strHeight,_strMaxMinus+_strHeight,_strMarginMinus+_strTop,_strMarginMinus+_strBottom,_strTop,_strBottom,'line-height',flexGrow,flexShrink,flexBasis];var affectingPropsYContentBox=[_strPaddingMinus+_strTop,_strPaddingMinus+_strBottom,_strBorderMinus+_strTop+_strWidth,_strBorderMinus+_strBottom+_strWidth];var _strS='s';var _strVS='v-s';var checkX=_overflowBehaviorCache.x===_strS||_overflowBehaviorCache.x===_strVS;var checkY=_overflowBehaviorCache.y===_strS||_overflowBehaviorCache.y===_strVS;var sizeIsAffected=false;var checkPropertyName=function(arr,name){for(var i=0;i<arr[LEXICON.l];i++){if(arr[i]===name)
return true;}
return false;};if(checkY){sizeIsAffected=checkPropertyName(affectingPropsY,propertyName);if(!sizeIsAffected&&!_isBorderBox)
sizeIsAffected=checkPropertyName(affectingPropsYContentBox,propertyName);}
if(checkX&&!sizeIsAffected){sizeIsAffected=checkPropertyName(affectingPropsX,propertyName);if(!sizeIsAffected&&!_isBorderBox)
sizeIsAffected=checkPropertyName(affectingPropsXContentBox,propertyName);}
return sizeIsAffected;}
function updateViewportAttrsFromTarget(attrs){attrs=attrs||_viewportAttrsFromTarget;each(attrs,function(index,attr){if(COMPATIBILITY.inA(attr,_viewportAttrsFromTarget)>-1){var targetAttr=_targetElement.attr(attr);if(type(targetAttr)==TYPES.s){_viewportElement.attr(attr,targetAttr);}
else{_viewportElement.removeAttr(attr);}}});}
function textareaUpdate(){if(!_sleeping){var wrapAttrOff=!_textareaAutoWrappingCache;var minWidth=_viewportSize.w;var minHeight=_viewportSize.h;var css={};var doMeasure=_widthAutoCache||wrapAttrOff;var origWidth;var width;var origHeight;var height;css[_strMinMinus+_strWidth]=_strEmpty;css[_strMinMinus+_strHeight]=_strEmpty;css[_strWidth]=_strAuto;_targetElement.css(css);origWidth=_targetElementNative[LEXICON.oW];width=doMeasure?MATH.max(origWidth,_targetElementNative[LEXICON.sW]-1):1;css[_strWidth]=_widthAutoCache?_strAuto :_strHundredPercent;css[_strMinMinus+_strWidth]=_strHundredPercent;css[_strHeight]=_strAuto;_targetElement.css(css);origHeight=_targetElementNative[LEXICON.oH];height=MATH.max(origHeight,_targetElementNative[LEXICON.sH]-1);css[_strWidth]=width;css[_strHeight]=height;_textareaCoverElement.css(css);css[_strMinMinus+_strWidth]=minWidth ;css[_strMinMinus+_strHeight]=minHeight ;_targetElement.css(css);return{_originalWidth:origWidth,_originalHeight:origHeight,_dynamicWidth:width,_dynamicHeight:height};}}
function update(updateHints){clearTimeout(_swallowedUpdateTimeout);updateHints=updateHints||{};_swallowedUpdateHints._hostSizeChanged|=updateHints._hostSizeChanged;_swallowedUpdateHints._contentSizeChanged|=updateHints._contentSizeChanged;_swallowedUpdateHints._force|=updateHints._force;var now=COMPATIBILITY.now();var hostSizeChanged=!!_swallowedUpdateHints._hostSizeChanged;var contentSizeChanged=!!_swallowedUpdateHints._contentSizeChanged;var force=!!_swallowedUpdateHints._force;var changedOptions=updateHints._changedOptions;var swallow=_swallowUpdateLag>0&&_initialized&&!_destroyed&&!force&&!changedOptions&&(now-_lastUpdateTime)<_swallowUpdateLag&&(!_heightAutoCache&&!_widthAutoCache);var displayIsHidden;if(swallow)
_swallowedUpdateTimeout=setTimeout(update,_swallowUpdateLag);if(_destroyed||swallow||(_sleeping&&!changedOptions)||(_initialized&&!force&&(displayIsHidden=_hostElement.is(':hidden')))||_hostElement.css('display')==='inline')
return;_lastUpdateTime=now;_swallowedUpdateHints={};if(_nativeScrollbarStyling&&!(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y)){_nativeScrollbarSize.x=0;_nativeScrollbarSize.y=0;}
else{_nativeScrollbarSize=extendDeep({},globals.nativeScrollbarSize);}
_nativeScrollbarMinSize={x:(_nativeScrollbarSize.x+(_nativeScrollbarIsOverlaid.x?0:3))*3,y:(_nativeScrollbarSize.y+(_nativeScrollbarIsOverlaid.y?0:3))*3};changedOptions=changedOptions||{};var checkCacheAutoForce=function(){return checkCache.apply(this,[].slice.call(arguments).concat([force]));};var currScroll={x:_viewportElement[_strScrollLeft](),y:_viewportElement[_strScrollTop]()};var currentPreparedOptionsScrollbars=_currentPreparedOptions.scrollbars;var currentPreparedOptionsTextarea=_currentPreparedOptions.textarea;var scrollbarsVisibility=currentPreparedOptionsScrollbars.visibility;var scrollbarsVisibilityChanged=checkCacheAutoForce(scrollbarsVisibility,_scrollbarsVisibilityCache);var scrollbarsAutoHide=currentPreparedOptionsScrollbars.autoHide;var scrollbarsAutoHideChanged=checkCacheAutoForce(scrollbarsAutoHide,_scrollbarsAutoHideCache);var scrollbarsClickScrolling=currentPreparedOptionsScrollbars.clickScrolling;var scrollbarsClickScrollingChanged=checkCacheAutoForce(scrollbarsClickScrolling,_scrollbarsClickScrollingCache);var scrollbarsDragScrolling=currentPreparedOptionsScrollbars.dragScrolling;var scrollbarsDragScrollingChanged=checkCacheAutoForce(scrollbarsDragScrolling,_scrollbarsDragScrollingCache);var className=_currentPreparedOptions.className;var classNameChanged=checkCacheAutoForce(className,_classNameCache);var resize=_currentPreparedOptions.resize;var resizeChanged=checkCacheAutoForce(resize,_resizeCache)&&!_isBody;var paddingAbsolute=_currentPreparedOptions.paddingAbsolute;var paddingAbsoluteChanged=checkCacheAutoForce(paddingAbsolute,_paddingAbsoluteCache);var clipAlways=_currentPreparedOptions.clipAlways;var clipAlwaysChanged=checkCacheAutoForce(clipAlways,_clipAlwaysCache);var sizeAutoCapable=_currentPreparedOptions.sizeAutoCapable&&!_isBody;var sizeAutoCapableChanged=checkCacheAutoForce(sizeAutoCapable,_sizeAutoCapableCache);var ignoreOverlayScrollbarHiding=_currentPreparedOptions.nativeScrollbarsOverlaid.showNativeScrollbars;var ignoreOverlayScrollbarHidingChanged=checkCacheAutoForce(ignoreOverlayScrollbarHiding,_ignoreOverlayScrollbarHidingCache);var autoUpdate=_currentPreparedOptions.autoUpdate;var autoUpdateChanged=checkCacheAutoForce(autoUpdate,_autoUpdateCache);var overflowBehavior=_currentPreparedOptions.overflowBehavior;var overflowBehaviorChanged=checkCacheAutoForce(overflowBehavior,_overflowBehaviorCache,force);var textareaDynWidth=currentPreparedOptionsTextarea.dynWidth;var textareaDynWidthChanged=checkCacheAutoForce(_textareaDynWidthCache,textareaDynWidth);var textareaDynHeight=currentPreparedOptionsTextarea.dynHeight;var textareaDynHeightChanged=checkCacheAutoForce(_textareaDynHeightCache,textareaDynHeight);_scrollbarsAutoHideNever=scrollbarsAutoHide==='n';_scrollbarsAutoHideScroll=scrollbarsAutoHide==='s';_scrollbarsAutoHideMove=scrollbarsAutoHide==='m';_scrollbarsAutoHideLeave=scrollbarsAutoHide==='l';_scrollbarsAutoHideDelay=currentPreparedOptionsScrollbars.autoHideDelay;_oldClassName=_classNameCache;_resizeNone=resize==='n';_resizeBoth=resize==='b';_resizeHorizontal=resize==='h';_resizeVertical=resize==='v';_normalizeRTLCache=_currentPreparedOptions.normalizeRTL;ignoreOverlayScrollbarHiding=ignoreOverlayScrollbarHiding&&(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y);_scrollbarsVisibilityCache=scrollbarsVisibility;_scrollbarsAutoHideCache=scrollbarsAutoHide;_scrollbarsClickScrollingCache=scrollbarsClickScrolling;_scrollbarsDragScrollingCache=scrollbarsDragScrolling;_classNameCache=className;_resizeCache=resize;_paddingAbsoluteCache=paddingAbsolute;_clipAlwaysCache=clipAlways;_sizeAutoCapableCache=sizeAutoCapable;_ignoreOverlayScrollbarHidingCache=ignoreOverlayScrollbarHiding;_autoUpdateCache=autoUpdate;_overflowBehaviorCache=extendDeep({},overflowBehavior);_textareaDynWidthCache=textareaDynWidth;_textareaDynHeightCache=textareaDynHeight;_hasOverflowCache=_hasOverflowCache||{x:false,y:false};if(classNameChanged){removeClass(_hostElement,_oldClassName+_strSpace+_classNameThemeNone);addClass(_hostElement,className!==undefined&&className!==null&&className.length>0?className:_classNameThemeNone);}
if(autoUpdateChanged){if(autoUpdate===true||(autoUpdate===null&&_autoUpdateRecommended)){disconnectMutationObservers();autoUpdateLoop.add(_base);}
else{autoUpdateLoop.remove(_base);connectMutationObservers();}}
if(sizeAutoCapableChanged){if(sizeAutoCapable){if(_contentGlueElement){_contentGlueElement.show();}
else{_contentGlueElement=FRAMEWORK(generateDiv(_classNameContentGlueElement));_paddingElement.before(_contentGlueElement);}
if(_sizeAutoObserverAdded){_sizeAutoObserverElement.show();}
else{_sizeAutoObserverElement=FRAMEWORK(generateDiv(_classNameSizeAutoObserverElement));_sizeAutoObserverElementNative=_sizeAutoObserverElement[0];_contentGlueElement.before(_sizeAutoObserverElement);var oldSize={w:-1,h:-1};setupResizeObserver(_sizeAutoObserverElement,function(){var newSize={w:_sizeAutoObserverElementNative[LEXICON.oW],h:_sizeAutoObserverElementNative[LEXICON.oH]};if(checkCache(newSize,oldSize)){if(_initialized&&(_heightAutoCache&&newSize.h>0)||(_widthAutoCache&&newSize.w>0)){update();}
else if(_initialized&&(!_heightAutoCache&&newSize.h===0)||(!_widthAutoCache&&newSize.w===0)){update();}}
oldSize=newSize;});_sizeAutoObserverAdded=true;if(_cssCalc!==null)
_sizeAutoObserverElement.css(_strHeight,_cssCalc+'(100% + 1px)');}}
else{if(_sizeAutoObserverAdded)
_sizeAutoObserverElement.hide();if(_contentGlueElement)
_contentGlueElement.hide();}}
if(force){_sizeObserverElement.find('*').trigger(_strScroll);if(_sizeAutoObserverAdded)
_sizeAutoObserverElement.find('*').trigger(_strScroll);}
displayIsHidden=displayIsHidden===undefined?_hostElement.is(':hidden'):displayIsHidden;var textareaAutoWrapping=_isTextarea?_targetElement.attr('wrap')!=='off':false;var textareaAutoWrappingChanged=checkCacheAutoForce(textareaAutoWrapping,_textareaAutoWrappingCache);var cssDirection=_hostElement.css('direction');var cssDirectionChanged=checkCacheAutoForce(cssDirection,_cssDirectionCache);var boxSizing=_hostElement.css('box-sizing');var boxSizingChanged=checkCacheAutoForce(boxSizing,_cssBoxSizingCache);var padding=getTopRightBottomLeftHost(_strPaddingMinus);var sizeAutoObserverElementBCRect;try{sizeAutoObserverElementBCRect=_sizeAutoObserverAdded?_sizeAutoObserverElementNative[LEXICON.bCR]():null;}catch(ex){return;}
_isRTL=cssDirection==='rtl';_isBorderBox=(boxSizing==='border-box');var isRTLLeft=_isRTL?_strLeft:_strRight;var isRTLRight=_isRTL?_strRight:_strLeft;var widthAutoResizeDetection=false;var widthAutoObserverDetection=(_sizeAutoObserverAdded&&(_hostElement.css(_strFloat)!=='none'))?(MATH.round(sizeAutoObserverElementBCRect.right-sizeAutoObserverElementBCRect.left)===0)&&(!paddingAbsolute?(_hostElementNative[LEXICON.cW]-_paddingX)>0:true):false;if(sizeAutoCapable&&!widthAutoObserverDetection){var tmpCurrHostWidth=_hostElementNative[LEXICON.oW];var tmpCurrContentGlueWidth=_contentGlueElement.css(_strWidth);_contentGlueElement.css(_strWidth,_strAuto);var tmpNewHostWidth=_hostElementNative[LEXICON.oW];_contentGlueElement.css(_strWidth,tmpCurrContentGlueWidth);widthAutoResizeDetection=tmpCurrHostWidth!==tmpNewHostWidth;if(!widthAutoResizeDetection){_contentGlueElement.css(_strWidth,tmpCurrHostWidth+1);tmpNewHostWidth=_hostElementNative[LEXICON.oW];_contentGlueElement.css(_strWidth,tmpCurrContentGlueWidth);widthAutoResizeDetection=tmpCurrHostWidth!==tmpNewHostWidth;}}
var widthAuto=(widthAutoObserverDetection||widthAutoResizeDetection)&&sizeAutoCapable&&!displayIsHidden;var widthAutoChanged=checkCacheAutoForce(widthAuto,_widthAutoCache);var wasWidthAuto=!widthAuto&&_widthAutoCache;var heightAuto=_sizeAutoObserverAdded&&sizeAutoCapable&&!displayIsHidden?(MATH.round(sizeAutoObserverElementBCRect.bottom-sizeAutoObserverElementBCRect.top)===0):false;var heightAutoChanged=checkCacheAutoForce(heightAuto,_heightAutoCache);var wasHeightAuto=!heightAuto&&_heightAutoCache;var updateBorderX=(widthAuto&&_isBorderBox)||!_isBorderBox;var updateBorderY=(heightAuto&&_isBorderBox)||!_isBorderBox;var border=getTopRightBottomLeftHost(_strBorderMinus,'-'+_strWidth,!updateBorderX,!updateBorderY)
var margin=getTopRightBottomLeftHost(_strMarginMinus);var contentElementCSS={};var contentGlueElementCSS={};var getHostSize=function(){return{w:_hostElementNative[LEXICON.cW],h:_hostElementNative[LEXICON.cH]};};var getViewportSize=function(){return{w:_paddingElementNative[LEXICON.oW]+MATH.max(0,_contentElementNative[LEXICON.cW]-_contentElementNative[LEXICON.sW]),h:_paddingElementNative[LEXICON.oH]+MATH.max(0,_contentElementNative[LEXICON.cH]-_contentElementNative[LEXICON.sH])};};var paddingAbsoluteX=_paddingX=padding.l+padding.r;var paddingAbsoluteY=_paddingY=padding.t+padding.b;paddingAbsoluteX*=paddingAbsolute?1:0;paddingAbsoluteY*=paddingAbsolute?1:0;padding.c=checkCacheAutoForce(padding,_cssPaddingCache);_borderX=border.l+border.r;_borderY=border.t+border.b;border.c=checkCacheAutoForce(border,_cssBorderCache);_marginX=margin.l+margin.r;_marginY=margin.t+margin.b;margin.c=checkCacheAutoForce(margin,_cssMarginCache);_textareaAutoWrappingCache=textareaAutoWrapping;_cssDirectionCache=cssDirection;_cssBoxSizingCache=boxSizing;_widthAutoCache=widthAuto;_heightAutoCache=heightAuto;_cssPaddingCache=padding;_cssBorderCache=border;_cssMarginCache=margin;if(cssDirectionChanged&&_sizeAutoObserverAdded)
_sizeAutoObserverElement.css(_strFloat,isRTLRight);if(padding.c||cssDirectionChanged||paddingAbsoluteChanged||widthAutoChanged||heightAutoChanged||boxSizingChanged||sizeAutoCapableChanged){var paddingElementCSS={};var textareaCSS={};var paddingValues=[padding.t,padding.r,padding.b,padding.l];setTopRightBottomLeft(contentGlueElementCSS,_strMarginMinus,[-padding.t,-padding.r,-padding.b,-padding.l]);if(paddingAbsolute){setTopRightBottomLeft(paddingElementCSS,_strEmpty,paddingValues);setTopRightBottomLeft(_isTextarea?textareaCSS:contentElementCSS,_strPaddingMinus);}
else{setTopRightBottomLeft(paddingElementCSS,_strEmpty);setTopRightBottomLeft(_isTextarea?textareaCSS:contentElementCSS,_strPaddingMinus,paddingValues);}
_paddingElement.css(paddingElementCSS);_targetElement.css(textareaCSS);}
_viewportSize=getViewportSize();var textareaSize=_isTextarea?textareaUpdate():false;var textareaSizeChanged=_isTextarea&&checkCacheAutoForce(textareaSize,_textareaSizeCache);var textareaDynOrigSize=_isTextarea&&textareaSize?{w:textareaDynWidth?textareaSize._dynamicWidth:textareaSize._originalWidth,h:textareaDynHeight?textareaSize._dynamicHeight:textareaSize._originalHeight}:{};_textareaSizeCache=textareaSize;if(heightAuto&&(heightAutoChanged||paddingAbsoluteChanged||boxSizingChanged||padding.c||border.c)){contentElementCSS[_strHeight]=_strAuto;}
else if(heightAutoChanged||paddingAbsoluteChanged){contentElementCSS[_strHeight]=_strHundredPercent;}
if(widthAuto&&(widthAutoChanged||paddingAbsoluteChanged||boxSizingChanged||padding.c||border.c||cssDirectionChanged)){contentElementCSS[_strWidth]=_strAuto;contentGlueElementCSS[_strMaxMinus+_strWidth]=_strHundredPercent;}
else if(widthAutoChanged||paddingAbsoluteChanged){contentElementCSS[_strWidth]=_strHundredPercent;contentElementCSS[_strFloat]=_strEmpty;contentGlueElementCSS[_strMaxMinus+_strWidth]=_strEmpty;}
if(widthAuto){contentGlueElementCSS[_strWidth]=_strAuto;contentElementCSS[_strWidth]=VENDORS._cssPropertyValue(_strWidth,'max-content intrinsic')||_strAuto;contentElementCSS[_strFloat]=isRTLRight;}
else{contentGlueElementCSS[_strWidth]=_strEmpty;}
if(heightAuto){contentGlueElementCSS[_strHeight]=textareaDynOrigSize.h||_contentElementNative[LEXICON.cH];}
else{contentGlueElementCSS[_strHeight]=_strEmpty;}
if(sizeAutoCapable)
_contentGlueElement.css(contentGlueElementCSS);_contentElement.css(contentElementCSS);contentElementCSS={};contentGlueElementCSS={};if(hostSizeChanged||contentSizeChanged||textareaSizeChanged||cssDirectionChanged||boxSizingChanged||paddingAbsoluteChanged||widthAutoChanged||widthAuto||heightAutoChanged||heightAuto||ignoreOverlayScrollbarHidingChanged||overflowBehaviorChanged||clipAlwaysChanged||resizeChanged||scrollbarsVisibilityChanged||scrollbarsAutoHideChanged||scrollbarsDragScrollingChanged||scrollbarsClickScrollingChanged||textareaDynWidthChanged||textareaDynHeightChanged||textareaAutoWrappingChanged){var strOverflow='overflow';var strOverflowX=strOverflow+'-x';var strOverflowY=strOverflow+'-y';var strHidden='hidden';var strVisible='visible';if(!_nativeScrollbarStyling){var viewportElementResetCSS={};var resetXTmp=_hasOverflowCache.y&&_hideOverflowCache.ys&&!ignoreOverlayScrollbarHiding?(_nativeScrollbarIsOverlaid.y?_viewportElement.css(isRTLLeft):-_nativeScrollbarSize.y):0;var resetBottomTmp=_hasOverflowCache.x&&_hideOverflowCache.xs&&!ignoreOverlayScrollbarHiding?(_nativeScrollbarIsOverlaid.x?_viewportElement.css(_strBottom):-_nativeScrollbarSize.x):0;setTopRightBottomLeft(viewportElementResetCSS,_strEmpty);_viewportElement.css(viewportElementResetCSS);}
var contentMeasureElement=getContentMeasureElement();var contentSize={w:textareaDynOrigSize.w||contentMeasureElement[LEXICON.cW],h:textareaDynOrigSize.h||contentMeasureElement[LEXICON.cH]};var scrollSize={w:contentMeasureElement[LEXICON.sW],h:contentMeasureElement[LEXICON.sH]};if(!_nativeScrollbarStyling){viewportElementResetCSS[_strBottom]=wasHeightAuto?_strEmpty:resetBottomTmp;viewportElementResetCSS[isRTLLeft]=wasWidthAuto?_strEmpty:resetXTmp;_viewportElement.css(viewportElementResetCSS);}
_viewportSize=getViewportSize();var hostSize=getHostSize();var hostAbsoluteRectSize={w:hostSize.w-_marginX-_borderX-(_isBorderBox?0:_paddingX),h:hostSize.h-_marginY-_borderY-(_isBorderBox?0:_paddingY)};var contentGlueSize={w:MATH.max((widthAuto?contentSize.w:scrollSize.w)+paddingAbsoluteX,hostAbsoluteRectSize.w),h:MATH.max((heightAuto?contentSize.h:scrollSize.h)+paddingAbsoluteY,hostAbsoluteRectSize.h)};contentGlueSize.c=checkCacheAutoForce(contentGlueSize,_contentGlueSizeCache);_contentGlueSizeCache=contentGlueSize;if(sizeAutoCapable){if(contentGlueSize.c||(heightAuto||widthAuto)){contentGlueElementCSS[_strWidth]=contentGlueSize.w;contentGlueElementCSS[_strHeight]=contentGlueSize.h;if(!_isTextarea){contentSize={w:contentMeasureElement[LEXICON.cW],h:contentMeasureElement[LEXICON.cH]};}}
var textareaCoverCSS={};var setContentGlueElementCSSfunction=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var wh=scrollbarVars._w_h;var strWH=scrollbarVars._width_height;var autoSize=horizontal?widthAuto:heightAuto;var borderSize=horizontal?_borderX:_borderY;var paddingSize=horizontal?_paddingX:_paddingY;var marginSize=horizontal?_marginX:_marginY;var viewportSize=_viewportSize[wh]-borderSize-marginSize-(_isBorderBox?0:paddingSize);if(!autoSize||(!autoSize&&border.c))
contentGlueElementCSS[strWH]=hostAbsoluteRectSize[wh]-1;if(autoSize&&(contentSize[wh]<viewportSize)&&(horizontal&&_isTextarea?!textareaAutoWrapping:true)){if(_isTextarea)
textareaCoverCSS[strWH]=parseToZeroOrNumber(_textareaCoverElement.css(strWH))-1;contentGlueElementCSS[strWH]-=1;}
if(contentSize[wh]>0)
contentGlueElementCSS[strWH]=MATH.max(1,contentGlueElementCSS[strWH]);};setContentGlueElementCSSfunction(true);setContentGlueElementCSSfunction(false);if(_isTextarea)
_textareaCoverElement.css(textareaCoverCSS);_contentGlueElement.css(contentGlueElementCSS);}
if(widthAuto)
contentElementCSS[_strWidth]=_strHundredPercent;if(widthAuto&&!_isBorderBox&&!_mutationObserversConnected)
contentElementCSS[_strFloat]='none';_contentElement.css(contentElementCSS);contentElementCSS={};var contentScrollSize={w:contentMeasureElement[LEXICON.sW],h:contentMeasureElement[LEXICON.sH],};contentScrollSize.c=contentSizeChanged=checkCacheAutoForce(contentScrollSize,_contentScrollSizeCache);_contentScrollSizeCache=contentScrollSize;_viewportSize=getViewportSize();hostSize=getHostSize();hostSizeChanged=checkCacheAutoForce(hostSize,_hostSizeCache);_hostSizeCache=hostSize;var hideOverflowForceTextarea=_isTextarea&&(_viewportSize.w===0||_viewportSize.h===0);var previousOverflowAmount=_overflowAmountCache;var overflowBehaviorIsVS={};var overflowBehaviorIsVH={};var overflowBehaviorIsS={};var overflowAmount={};var hasOverflow={};var hideOverflow={};var canScroll={};var viewportRect=_paddingElementNative[LEXICON.bCR]();var setOverflowVariables=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var scrollbarVarsInverted=getScrollbarVars(!horizontal);var xyI=scrollbarVarsInverted._x_y;var xy=scrollbarVars._x_y;var wh=scrollbarVars._w_h;var widthHeight=scrollbarVars._width_height;var scrollMax=_strScroll+scrollbarVars._Left_Top+'Max';var fractionalOverflowAmount=viewportRect[widthHeight]?MATH.abs(viewportRect[widthHeight]-_viewportSize[wh]):0;var checkFractionalOverflowAmount=previousOverflowAmount&&previousOverflowAmount[xy]>0&&_viewportElementNative[scrollMax]===0;overflowBehaviorIsVS[xy]=overflowBehavior[xy]==='v-s';overflowBehaviorIsVH[xy]=overflowBehavior[xy]==='v-h';overflowBehaviorIsS[xy]=overflowBehavior[xy]==='s';overflowAmount[xy]=MATH.max(0,MATH.round((contentScrollSize[wh]-_viewportSize[wh])*100)/100);overflowAmount[xy]*=(hideOverflowForceTextarea||(checkFractionalOverflowAmount&&fractionalOverflowAmount>0&&fractionalOverflowAmount<1))?0:1;hasOverflow[xy]=overflowAmount[xy]>0;hideOverflow[xy]=overflowBehaviorIsVS[xy]||overflowBehaviorIsVH[xy]?(hasOverflow[xyI]&&!overflowBehaviorIsVS[xyI]&&!overflowBehaviorIsVH[xyI]):hasOverflow[xy];hideOverflow[xy+'s']=hideOverflow[xy]?(overflowBehaviorIsS[xy]||overflowBehaviorIsVS[xy]):false;canScroll[xy]=hasOverflow[xy]&&hideOverflow[xy+'s'];};setOverflowVariables(true);setOverflowVariables(false);overflowAmount.c=checkCacheAutoForce(overflowAmount,_overflowAmountCache);_overflowAmountCache=overflowAmount;hasOverflow.c=checkCacheAutoForce(hasOverflow,_hasOverflowCache);_hasOverflowCache=hasOverflow;hideOverflow.c=checkCacheAutoForce(hideOverflow,_hideOverflowCache);_hideOverflowCache=hideOverflow;if(_nativeScrollbarIsOverlaid.x||_nativeScrollbarIsOverlaid.y){var borderDesign='px solid transparent';var contentArrangeElementCSS={};var arrangeContent={};var arrangeChanged=force;var setContentElementCSS;if(hasOverflow.x||hasOverflow.y){arrangeContent.w=_nativeScrollbarIsOverlaid.y&&hasOverflow.y?contentScrollSize.w+_overlayScrollbarDummySize.y:_strEmpty;arrangeContent.h=_nativeScrollbarIsOverlaid.x&&hasOverflow.x?contentScrollSize.h+_overlayScrollbarDummySize.x:_strEmpty;arrangeChanged=checkCacheAutoForce(arrangeContent,_arrangeContentSizeCache);_arrangeContentSizeCache=arrangeContent;}
if(hasOverflow.c||hideOverflow.c||contentScrollSize.c||cssDirectionChanged||widthAutoChanged||heightAutoChanged||widthAuto||heightAuto||ignoreOverlayScrollbarHidingChanged){contentElementCSS[_strMarginMinus+isRTLRight]=contentElementCSS[_strBorderMinus+isRTLRight]=_strEmpty;setContentElementCSS=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var scrollbarVarsInverted=getScrollbarVars(!horizontal);var xy=scrollbarVars._x_y;var strDirection=horizontal?_strBottom:isRTLLeft;var invertedAutoSize=horizontal?heightAuto:widthAuto;if(_nativeScrollbarIsOverlaid[xy]&&hasOverflow[xy]&&hideOverflow[xy+'s']){contentElementCSS[_strMarginMinus+strDirection]=invertedAutoSize?(ignoreOverlayScrollbarHiding?_strEmpty:_overlayScrollbarDummySize[xy]):_strEmpty;contentElementCSS[_strBorderMinus+strDirection]=((horizontal?!invertedAutoSize:true)&&!ignoreOverlayScrollbarHiding)?(_overlayScrollbarDummySize[xy]+borderDesign):_strEmpty;}
else{arrangeContent[scrollbarVarsInverted._w_h]=contentElementCSS[_strMarginMinus+strDirection]=contentElementCSS[_strBorderMinus+strDirection]=_strEmpty;arrangeChanged=true;}};if(_nativeScrollbarStyling){addRemoveClass(_viewportElement,_classNameViewportNativeScrollbarsInvisible,!ignoreOverlayScrollbarHiding)}
else{setContentElementCSS(true);setContentElementCSS(false);}}
if(ignoreOverlayScrollbarHiding){arrangeContent.w=arrangeContent.h=_strEmpty;arrangeChanged=true;}
if(arrangeChanged&&!_nativeScrollbarStyling){contentArrangeElementCSS[_strWidth]=hideOverflow.y?arrangeContent.w:_strEmpty;contentArrangeElementCSS[_strHeight]=hideOverflow.x?arrangeContent.h:_strEmpty;if(!_contentArrangeElement){_contentArrangeElement=FRAMEWORK(generateDiv(_classNameContentArrangeElement));_viewportElement.prepend(_contentArrangeElement);}
_contentArrangeElement.css(contentArrangeElementCSS);}
_contentElement.css(contentElementCSS);}
var viewportElementCSS={};var paddingElementCSS={};var setViewportCSS;if(hostSizeChanged||hasOverflow.c||hideOverflow.c||contentScrollSize.c||overflowBehaviorChanged||boxSizingChanged||ignoreOverlayScrollbarHidingChanged||cssDirectionChanged||clipAlwaysChanged||heightAutoChanged){viewportElementCSS[isRTLRight]=_strEmpty;setViewportCSS=function(horizontal){var scrollbarVars=getScrollbarVars(horizontal);var scrollbarVarsInverted=getScrollbarVars(!horizontal);var xy=scrollbarVars._x_y;var XY=scrollbarVars._X_Y;var strDirection=horizontal?_strBottom:isRTLLeft;var reset=function(){viewportElementCSS[strDirection]=_strEmpty;_contentBorderSize[scrollbarVarsInverted._w_h]=0;};if(hasOverflow[xy]&&hideOverflow[xy+'s']){viewportElementCSS[strOverflow+XY]=_strScroll;if(ignoreOverlayScrollbarHiding||_nativeScrollbarStyling){reset();}
else{viewportElementCSS[strDirection]=-(_nativeScrollbarIsOverlaid[xy]?_overlayScrollbarDummySize[xy]:_nativeScrollbarSize[xy]);_contentBorderSize[scrollbarVarsInverted._w_h]=_nativeScrollbarIsOverlaid[xy]?_overlayScrollbarDummySize[scrollbarVarsInverted._x_y]:0;}}else{viewportElementCSS[strOverflow+XY]=_strEmpty;reset();}};setViewportCSS(true);setViewportCSS(false);if(!_nativeScrollbarStyling&&(_viewportSize.h<_nativeScrollbarMinSize.x||_viewportSize.w<_nativeScrollbarMinSize.y)&&((hasOverflow.x&&hideOverflow.x&&!_nativeScrollbarIsOverlaid.x)||(hasOverflow.y&&hideOverflow.y&&!_nativeScrollbarIsOverlaid.y))){viewportElementCSS[_strPaddingMinus+_strTop]=_nativeScrollbarMinSize.x;viewportElementCSS[_strMarginMinus+_strTop]=-_nativeScrollbarMinSize.x;viewportElementCSS[_strPaddingMinus+isRTLRight]=_nativeScrollbarMinSize.y;viewportElementCSS[_strMarginMinus+isRTLRight]=-_nativeScrollbarMinSize.y;}
else{viewportElementCSS[_strPaddingMinus+_strTop]=viewportElementCSS[_strMarginMinus+_strTop]=viewportElementCSS[_strPaddingMinus+isRTLRight]=viewportElementCSS[_strMarginMinus+isRTLRight]=_strEmpty;}
viewportElementCSS[_strPaddingMinus+isRTLLeft]=viewportElementCSS[_strMarginMinus+isRTLLeft]=_strEmpty;if((hasOverflow.x&&hideOverflow.x)||(hasOverflow.y&&hideOverflow.y)||hideOverflowForceTextarea){if(_isTextarea&&hideOverflowForceTextarea){paddingElementCSS[strOverflowX]=paddingElementCSS[strOverflowY]=strHidden;}}
else{if(!clipAlways||(overflowBehaviorIsVH.x||overflowBehaviorIsVS.x||overflowBehaviorIsVH.y||overflowBehaviorIsVS.y)){if(_isTextarea){paddingElementCSS[strOverflowX]=paddingElementCSS[strOverflowY]=_strEmpty;}
viewportElementCSS[strOverflowX]=viewportElementCSS[strOverflowY]=strVisible;}}
_paddingElement.css(paddingElementCSS);_viewportElement.css(viewportElementCSS);viewportElementCSS={};if((hasOverflow.c||boxSizingChanged||widthAutoChanged||heightAutoChanged)&&!(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y)){var elementStyle=_contentElementNative[LEXICON.s];var dump;elementStyle.webkitTransform='scale(1)';elementStyle.display='run-in';dump=_contentElementNative[LEXICON.oH];elementStyle.display=_strEmpty;elementStyle.webkitTransform=_strEmpty;}
}
contentElementCSS={};if(cssDirectionChanged||widthAutoChanged||heightAutoChanged){if(_isRTL&&widthAuto){var floatTmp=_contentElement.css(_strFloat);var posLeftWithoutFloat=MATH.round(_contentElement.css(_strFloat,_strEmpty).css(_strLeft,_strEmpty).position().left);_contentElement.css(_strFloat,floatTmp);var posLeftWithFloat=MATH.round(_contentElement.position().left);if(posLeftWithoutFloat!==posLeftWithFloat)
contentElementCSS[_strLeft]=posLeftWithoutFloat;}
else{contentElementCSS[_strLeft]=_strEmpty;}}
_contentElement.css(contentElementCSS);if(_isTextarea&&contentSizeChanged){var textareaInfo=getTextareaInfo();if(textareaInfo){var textareaRowsChanged=_textareaInfoCache===undefined?true:textareaInfo._rows!==_textareaInfoCache._rows;var cursorRow=textareaInfo._cursorRow;var cursorCol=textareaInfo._cursorColumn;var widestRow=textareaInfo._widestRow;var lastRow=textareaInfo._rows;var lastCol=textareaInfo._columns;var cursorPos=textareaInfo._cursorPosition;var cursorMax=textareaInfo._cursorMax;var cursorIsLastPosition=(cursorPos>=cursorMax&&_textareaHasFocus);var textareaScrollAmount={x:(!textareaAutoWrapping&&(cursorCol===lastCol&&cursorRow===widestRow))?_overflowAmountCache.x:-1,y:(textareaAutoWrapping?cursorIsLastPosition||textareaRowsChanged&&(previousOverflowAmount?(currScroll.y===previousOverflowAmount.y):false):(cursorIsLastPosition||textareaRowsChanged)&&cursorRow===lastRow)?_overflowAmountCache.y:-1};currScroll.x=textareaScrollAmount.x>-1?(_isRTL&&_normalizeRTLCache&&_rtlScrollBehavior.i?0:textareaScrollAmount.x):currScroll.x;currScroll.y=textareaScrollAmount.y>-1?textareaScrollAmount.y:currScroll.y;}
_textareaInfoCache=textareaInfo;}
if(_isRTL&&_rtlScrollBehavior.i&&_nativeScrollbarIsOverlaid.y&&hasOverflow.x&&_normalizeRTLCache)
currScroll.x+=_contentBorderSize.w||0;if(widthAuto)
_hostElement[_strScrollLeft](0);if(heightAuto)
_hostElement[_strScrollTop](0);_viewportElement[_strScrollLeft](currScroll.x)[_strScrollTop](currScroll.y);var scrollbarsVisibilityVisible=scrollbarsVisibility==='v';var scrollbarsVisibilityHidden=scrollbarsVisibility==='h';var scrollbarsVisibilityAuto=scrollbarsVisibility==='a';var refreshScrollbarsVisibility=function(showX,showY){showY=showY===undefined?showX:showY;refreshScrollbarAppearance(true,showX,canScroll.x)
refreshScrollbarAppearance(false,showY,canScroll.y)};addRemoveClass(_hostElement,_classNameHostOverflow,hideOverflow.x||hideOverflow.y);addRemoveClass(_hostElement,_classNameHostOverflowX,hideOverflow.x);addRemoveClass(_hostElement,_classNameHostOverflowY,hideOverflow.y);if(cssDirectionChanged&&!_isBody){addRemoveClass(_hostElement,_classNameHostRTL,_isRTL);}
if(_isBody)
addClass(_hostElement,_classNameHostResizeDisabled);if(resizeChanged){addRemoveClass(_hostElement,_classNameHostResizeDisabled,_resizeNone);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResize,!_resizeNone);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResizeB,_resizeBoth);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResizeH,_resizeHorizontal);addRemoveClass(_scrollbarCornerElement,_classNameScrollbarCornerResizeV,_resizeVertical);}
if(scrollbarsVisibilityChanged||overflowBehaviorChanged||hideOverflow.c||hasOverflow.c||ignoreOverlayScrollbarHidingChanged){if(ignoreOverlayScrollbarHiding){if(ignoreOverlayScrollbarHidingChanged){removeClass(_hostElement,_classNameHostScrolling);if(ignoreOverlayScrollbarHiding){refreshScrollbarsVisibility(false);}}}
else if(scrollbarsVisibilityAuto){refreshScrollbarsVisibility(canScroll.x,canScroll.y);}
else if(scrollbarsVisibilityVisible){refreshScrollbarsVisibility(true);}
else if(scrollbarsVisibilityHidden){refreshScrollbarsVisibility(false);}}
if(scrollbarsAutoHideChanged||ignoreOverlayScrollbarHidingChanged){setupHostMouseTouchEvents(!_scrollbarsAutoHideLeave&&!_scrollbarsAutoHideMove);refreshScrollbarsAutoHide(_scrollbarsAutoHideNever,!_scrollbarsAutoHideNever);}
if(hostSizeChanged||overflowAmount.c||heightAutoChanged||widthAutoChanged||resizeChanged||boxSizingChanged||paddingAbsoluteChanged||ignoreOverlayScrollbarHidingChanged||cssDirectionChanged){refreshScrollbarHandleLength(true);refreshScrollbarHandleOffset(true);refreshScrollbarHandleLength(false);refreshScrollbarHandleOffset(false);}
if(scrollbarsClickScrollingChanged)
refreshScrollbarsInteractive(true,scrollbarsClickScrolling);if(scrollbarsDragScrollingChanged)
refreshScrollbarsInteractive(false,scrollbarsDragScrolling);dispatchCallback('onDirectionChanged',{isRTL:_isRTL,dir:cssDirection},cssDirectionChanged);dispatchCallback('onHostSizeChanged',{width:_hostSizeCache.w,height:_hostSizeCache.h},hostSizeChanged);dispatchCallback('onContentSizeChanged',{width:_contentScrollSizeCache.w,height:_contentScrollSizeCache.h},contentSizeChanged);dispatchCallback('onOverflowChanged',{x:hasOverflow.x,y:hasOverflow.y,xScrollable:hideOverflow.xs,yScrollable:hideOverflow.ys,clipped:hideOverflow.x||hideOverflow.y},hasOverflow.c||hideOverflow.c);dispatchCallback('onOverflowAmountChanged',{x:overflowAmount.x,y:overflowAmount.y},overflowAmount.c);}
if(_isBody&&_bodyMinSizeCache&&(_hasOverflowCache.c||_bodyMinSizeCache.c)){if(!_bodyMinSizeCache.f)
bodyMinSizeChanged();if(_nativeScrollbarIsOverlaid.y&&_hasOverflowCache.x)
_contentElement.css(_strMinMinus+_strWidth,_bodyMinSizeCache.w+_overlayScrollbarDummySize.y);if(_nativeScrollbarIsOverlaid.x&&_hasOverflowCache.y)
_contentElement.css(_strMinMinus+_strHeight,_bodyMinSizeCache.h+_overlayScrollbarDummySize.x);_bodyMinSizeCache.c=false;}
if(_initialized&&changedOptions.updateOnLoad){updateElementsOnLoad();}
dispatchCallback('onUpdated',{forced:force});}
function updateElementsOnLoad(){if(!_isTextarea){eachUpdateOnLoad(function(i,updateOnLoadSelector){_contentElement.find(updateOnLoadSelector).each(function(i,el){if(COMPATIBILITY.inA(el,_updateOnLoadElms)<0){_updateOnLoadElms.push(el);FRAMEWORK(el).off(_updateOnLoadEventName,updateOnLoadCallback).on(_updateOnLoadEventName,updateOnLoadCallback);}});});}}
function setOptions(newOptions){var validatedOpts=_pluginsOptions._validate(newOptions,_pluginsOptions._template,true,_currentOptions)
_currentOptions=extendDeep({},_currentOptions,validatedOpts._default);_currentPreparedOptions=extendDeep({},_currentPreparedOptions,validatedOpts._prepared);return validatedOpts._prepared;}
function setupStructureDOM(destroy){var strParent='parent';var classNameResizeObserverHost='os-resize-observer-host';var classNameTextareaElementFull=_classNameTextareaElement+_strSpace+_classNameTextInherit;var textareaClass=_isTextarea?_strSpace+_classNameTextInherit:_strEmpty;var adoptAttrs=_currentPreparedOptions.textarea.inheritedAttrs;var adoptAttrsMap={};var applyAdoptedAttrs=function(){var applyAdoptedAttrsElm=destroy?_targetElement:_hostElement;each(adoptAttrsMap,function(key,value){if(type(value)==TYPES.s){if(key==LEXICON.c)
applyAdoptedAttrsElm.addClass(value);else
applyAdoptedAttrsElm.attr(key,value);}});};var hostElementClassNames=[_classNameHostElement,_classNameHostElementForeign,_classNameHostTextareaElement,_classNameHostResizeDisabled,_classNameHostRTL,_classNameHostScrollbarHorizontalHidden,_classNameHostScrollbarVerticalHidden,_classNameHostTransition,_classNameHostScrolling,_classNameHostOverflow,_classNameHostOverflowX,_classNameHostOverflowY,_classNameThemeNone,_classNameTextareaElement,_classNameTextInherit,_classNameCache].join(_strSpace);var hostElementCSS={};_hostElement=_hostElement||(_isTextarea?(_domExists?_targetElement[strParent]()[strParent]()[strParent]()[strParent]():FRAMEWORK(generateDiv(_classNameHostTextareaElement))):_targetElement);_contentElement=_contentElement||selectOrGenerateDivByClass(_classNameContentElement+textareaClass);_viewportElement=_viewportElement||selectOrGenerateDivByClass(_classNameViewportElement+textareaClass);_paddingElement=_paddingElement||selectOrGenerateDivByClass(_classNamePaddingElement+textareaClass);_sizeObserverElement=_sizeObserverElement||selectOrGenerateDivByClass(classNameResizeObserverHost);_textareaCoverElement=_textareaCoverElement||(_isTextarea?selectOrGenerateDivByClass(_classNameTextareaCoverElement):undefined);if(_domExists)
addClass(_hostElement,_classNameHostElementForeign);if(destroy)
removeClass(_hostElement,hostElementClassNames);adoptAttrs=type(adoptAttrs)==TYPES.s?adoptAttrs.split(_strSpace):adoptAttrs;if(COMPATIBILITY.isA(adoptAttrs)&&_isTextarea){each(adoptAttrs,function(i,v){if(type(v)==TYPES.s){adoptAttrsMap[v]=destroy?_hostElement.attr(v):_targetElement.attr(v);}});}
if(!destroy){if(_isTextarea){if(!_currentPreparedOptions.sizeAutoCapable){hostElementCSS[_strWidth]=_targetElement.css(_strWidth);hostElementCSS[_strHeight]=_targetElement.css(_strHeight);}
if(!_domExists)
_targetElement.addClass(_classNameTextInherit).wrap(_hostElement);_hostElement=_targetElement[strParent]().css(hostElementCSS);}
if(!_domExists){addClass(_targetElement,_isTextarea?classNameTextareaElementFull:_classNameHostElement);_hostElement.wrapInner(_contentElement).wrapInner(_viewportElement).wrapInner(_paddingElement).prepend(_sizeObserverElement);_contentElement=findFirst(_hostElement,_strDot+_classNameContentElement);_viewportElement=findFirst(_hostElement,_strDot+_classNameViewportElement);_paddingElement=findFirst(_hostElement,_strDot+_classNamePaddingElement);if(_isTextarea){_contentElement.prepend(_textareaCoverElement);applyAdoptedAttrs();}}
if(_nativeScrollbarStyling)
addClass(_viewportElement,_classNameViewportNativeScrollbarsInvisible);if(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y)
addClass(_viewportElement,_classNameViewportNativeScrollbarsOverlaid);if(_isBody)
addClass(_htmlElement,_classNameHTMLElement);_sizeObserverElementNative=_sizeObserverElement[0];_hostElementNative=_hostElement[0];_paddingElementNative=_paddingElement[0];_viewportElementNative=_viewportElement[0];_contentElementNative=_contentElement[0];updateViewportAttrsFromTarget();}
else{if(_domExists&&_initialized){_sizeObserverElement.children().remove();each([_paddingElement,_viewportElement,_contentElement,_textareaCoverElement],function(i,elm){if(elm){removeClass(elm.removeAttr(LEXICON.s),_classNamesDynamicDestroy);}});addClass(_hostElement,_isTextarea?_classNameHostTextareaElement:_classNameHostElement);}
else{remove(_sizeObserverElement);_contentElement.contents().unwrap().unwrap().unwrap();if(_isTextarea){_targetElement.unwrap();remove(_hostElement);remove(_textareaCoverElement);applyAdoptedAttrs();}}
if(_isTextarea)
_targetElement.removeAttr(LEXICON.s);if(_isBody)
removeClass(_htmlElement,_classNameHTMLElement);}}
function setupStructureEvents(){var textareaKeyDownRestrictedKeyCodes=[112,113,114,115,116,117,118,119,120,121,123,33,34,37,38,39,40,16,17,18,19,20,144];var textareaKeyDownKeyCodesList=[];var textareaUpdateIntervalID;var scrollStopTimeoutId;var scrollStopDelay=175;var strFocus='focus';function updateTextarea(doClearInterval){textareaUpdate();_base.update(_strAuto);if(doClearInterval&&_autoUpdateRecommended)
clearInterval(textareaUpdateIntervalID);}
function textareaOnScroll(event){_targetElement[_strScrollLeft](_rtlScrollBehavior.i&&_normalizeRTLCache?9999999:0);_targetElement[_strScrollTop](0);COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);return false;}
function textareaOnDrop(event){setTimeout(function(){if(!_destroyed)
updateTextarea();},50);}
function textareaOnFocus(){_textareaHasFocus=true;addClass(_hostElement,strFocus);}
function textareaOnFocusout(){_textareaHasFocus=false;textareaKeyDownKeyCodesList=[];removeClass(_hostElement,strFocus);updateTextarea(true);}
function textareaOnKeyDown(event){var keyCode=event.keyCode;if(inArray(keyCode,textareaKeyDownRestrictedKeyCodes)<0){if(!textareaKeyDownKeyCodesList[LEXICON.l]){updateTextarea();textareaUpdateIntervalID=setInterval(updateTextarea,1000/60);}
if(inArray(keyCode,textareaKeyDownKeyCodesList)<0)
textareaKeyDownKeyCodesList.push(keyCode);}}
function textareaOnKeyUp(event){var keyCode=event.keyCode;var index=inArray(keyCode,textareaKeyDownKeyCodesList);if(inArray(keyCode,textareaKeyDownRestrictedKeyCodes)<0){if(index>-1)
textareaKeyDownKeyCodesList.splice(index,1);if(!textareaKeyDownKeyCodesList[LEXICON.l])
updateTextarea(true);}}
function contentOnTransitionEnd(event){if(_autoUpdateCache===true)
return;event=event.originalEvent||event;if(isSizeAffectingCSSProperty(event.propertyName))
_base.update(_strAuto);}
function viewportOnScroll(event){if(!_sleeping){if(scrollStopTimeoutId!==undefined)
clearTimeout(scrollStopTimeoutId);else{if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(true);if(!nativeOverlayScrollbarsAreActive())
addClass(_hostElement,_classNameHostScrolling);dispatchCallback('onScrollStart',event);}
if(!_scrollbarsHandlesDefineScrollPos){refreshScrollbarHandleOffset(true);refreshScrollbarHandleOffset(false);}
dispatchCallback('onScroll',event);scrollStopTimeoutId=setTimeout(function(){if(!_destroyed){clearTimeout(scrollStopTimeoutId);scrollStopTimeoutId=undefined;if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(false);if(!nativeOverlayScrollbarsAreActive())
removeClass(_hostElement,_classNameHostScrolling);dispatchCallback('onScrollStop',event);}},scrollStopDelay);}}
if(_isTextarea){if(_msieVersion>9||!_autoUpdateRecommended){addDestroyEventListener(_targetElement,'input',updateTextarea);}
else{addDestroyEventListener(_targetElement,[_strKeyDownEvent,_strKeyUpEvent],[textareaOnKeyDown,textareaOnKeyUp]);}
addDestroyEventListener(_targetElement,[_strScroll,'drop',strFocus,strFocus+'out'],[textareaOnScroll,textareaOnDrop,textareaOnFocus,textareaOnFocusout]);}
else{addDestroyEventListener(_contentElement,_strTransitionEndEvent,contentOnTransitionEnd);}
addDestroyEventListener(_viewportElement,_strScroll,viewportOnScroll,true);}
function setupScrollbarsDOM(destroy){var selectOrGenerateScrollbarDOM=function(isHorizontal){var scrollbarClassName=isHorizontal?_classNameScrollbarHorizontal:_classNameScrollbarVertical;var scrollbar=selectOrGenerateDivByClass(_classNameScrollbar+_strSpace+scrollbarClassName,true);var track=selectOrGenerateDivByClass(_classNameScrollbarTrack,scrollbar);var handle=selectOrGenerateDivByClass(_classNameScrollbarHandle,scrollbar);if(!_domExists&&!destroy){scrollbar.append(track);track.append(handle);}
return{_scrollbar:scrollbar,_track:track,_handle:handle};};function resetScrollbarDOM(isHorizontal){var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbar=scrollbarVars._scrollbar;var track=scrollbarVars._track;var handle=scrollbarVars._handle;if(_domExists&&_initialized){each([scrollbar,track,handle],function(i,elm){removeClass(elm.removeAttr(LEXICON.s),_classNamesDynamicDestroy);});}
else{remove(scrollbar||selectOrGenerateScrollbarDOM(isHorizontal)._scrollbar);}}
var horizontalElements;var verticalElements;if(!destroy){horizontalElements=selectOrGenerateScrollbarDOM(true);verticalElements=selectOrGenerateScrollbarDOM();_scrollbarHorizontalElement=horizontalElements._scrollbar;_scrollbarHorizontalTrackElement=horizontalElements._track;_scrollbarHorizontalHandleElement=horizontalElements._handle;_scrollbarVerticalElement=verticalElements._scrollbar;_scrollbarVerticalTrackElement=verticalElements._track;_scrollbarVerticalHandleElement=verticalElements._handle;if(!_domExists){_paddingElement.after(_scrollbarVerticalElement);_paddingElement.after(_scrollbarHorizontalElement);}}
else{resetScrollbarDOM(true);resetScrollbarDOM();}}
function setupScrollbarEvents(isHorizontal){var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbarVarsInfo=scrollbarVars._info;var insideIFrame=_windowElementNative.top!==_windowElementNative;var xy=scrollbarVars._x_y;var XY=scrollbarVars._X_Y;var scroll=_strScroll+scrollbarVars._Left_Top;var strActive='active';var strSnapHandle='snapHandle';var strClickEvent='click';var scrollDurationFactor=1;var increaseDecreaseScrollAmountKeyCodes=[16,17];var trackTimeout;var mouseDownScroll;var mouseDownOffset;var mouseDownInvertedScale;function getPointerPosition(event){return _msieVersion&&insideIFrame?event['screen'+XY]:COMPATIBILITY.page(event)[xy];}
function getPreparedScrollbarsOption(name){return _currentPreparedOptions.scrollbars[name];}
function increaseTrackScrollAmount(){scrollDurationFactor=0.5;}
function decreaseTrackScrollAmount(){scrollDurationFactor=1;}
function stopClickEventPropagation(event){COMPATIBILITY.stpP(event);}
function documentKeyDown(event){if(inArray(event.keyCode,increaseDecreaseScrollAmountKeyCodes)>-1)
increaseTrackScrollAmount();}
function documentKeyUp(event){if(inArray(event.keyCode,increaseDecreaseScrollAmountKeyCodes)>-1)
decreaseTrackScrollAmount();}
function onMouseTouchDownContinue(event){var originalEvent=event.originalEvent||event;var isTouchEvent=originalEvent.touches!==undefined;return _sleeping||_destroyed||nativeOverlayScrollbarsAreActive()||!_scrollbarsDragScrollingCache||(isTouchEvent&&!getPreparedScrollbarsOption('touchSupport'))?false:COMPATIBILITY.mBtn(event)===1||isTouchEvent;}
function documentDragMove(event){if(onMouseTouchDownContinue(event)){var trackLength=scrollbarVarsInfo._trackLength;var handleLength=scrollbarVarsInfo._handleLength;var scrollRange=scrollbarVarsInfo._maxScroll;var scrollRaw=(getPointerPosition(event)-mouseDownOffset)*mouseDownInvertedScale;var scrollDeltaPercent=scrollRaw/(trackLength-handleLength);var scrollDelta=(scrollRange*scrollDeltaPercent);scrollDelta=isFinite(scrollDelta)?scrollDelta:0;if(_isRTL&&isHorizontal&&!_rtlScrollBehavior.i)
scrollDelta*=-1;_viewportElement[scroll](MATH.round(mouseDownScroll+scrollDelta));if(_scrollbarsHandlesDefineScrollPos)
refreshScrollbarHandleOffset(isHorizontal,mouseDownScroll+scrollDelta);if(!_supportPassiveEvents)
COMPATIBILITY.prvD(event);}
else
documentMouseTouchUp(event);}
function documentMouseTouchUp(event){event=event||event.originalEvent;setupResponsiveEventListener(_documentElement,[_strMouseTouchMoveEvent,_strMouseTouchUpEvent,_strKeyDownEvent,_strKeyUpEvent,_strSelectStartEvent],[documentDragMove,documentMouseTouchUp,documentKeyDown,documentKeyUp,documentOnSelectStart],true);COMPATIBILITY.rAF()(function(){setupResponsiveEventListener(_documentElement,strClickEvent,stopClickEventPropagation,true,{_capture:true});});if(_scrollbarsHandlesDefineScrollPos)
refreshScrollbarHandleOffset(isHorizontal,true);_scrollbarsHandlesDefineScrollPos=false;removeClass(_bodyElement,_classNameDragging);removeClass(scrollbarVars._handle,strActive);removeClass(scrollbarVars._track,strActive);removeClass(scrollbarVars._scrollbar,strActive);mouseDownScroll=undefined;mouseDownOffset=undefined;mouseDownInvertedScale=1;decreaseTrackScrollAmount();if(trackTimeout!==undefined){_base.scrollStop();clearTimeout(trackTimeout);trackTimeout=undefined;}
if(event){var rect=_hostElementNative[LEXICON.bCR]();var mouseInsideHost=event.clientX>=rect.left&&event.clientX<=rect.right&&event.clientY>=rect.top&&event.clientY<=rect.bottom;if(!mouseInsideHost)
hostOnMouseLeave();if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(false);}}
function onHandleMouseTouchDown(event){if(onMouseTouchDownContinue(event))
onHandleMouseTouchDownAction(event);}
function onHandleMouseTouchDownAction(event){mouseDownScroll=_viewportElement[scroll]();mouseDownScroll=isNaN(mouseDownScroll)?0:mouseDownScroll;if(_isRTL&&isHorizontal&&!_rtlScrollBehavior.n||!_isRTL)
mouseDownScroll=mouseDownScroll<0?0:mouseDownScroll;mouseDownInvertedScale=getHostElementInvertedScale()[xy];mouseDownOffset=getPointerPosition(event);_scrollbarsHandlesDefineScrollPos=!getPreparedScrollbarsOption(strSnapHandle);addClass(_bodyElement,_classNameDragging);addClass(scrollbarVars._handle,strActive);addClass(scrollbarVars._scrollbar,strActive);setupResponsiveEventListener(_documentElement,[_strMouseTouchMoveEvent,_strMouseTouchUpEvent,_strSelectStartEvent],[documentDragMove,documentMouseTouchUp,documentOnSelectStart]);COMPATIBILITY.rAF()(function(){setupResponsiveEventListener(_documentElement,strClickEvent,stopClickEventPropagation,false,{_capture:true});});if(_msieVersion||!_documentMixed)
COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}
function onTrackMouseTouchDown(event){if(onMouseTouchDownContinue(event)){var handleToViewportRatio=scrollbarVars._info._handleLength/Math.round(MATH.min(1,_viewportSize[scrollbarVars._w_h]/_contentScrollSizeCache[scrollbarVars._w_h])*scrollbarVars._info._trackLength);var scrollDistance=MATH.round(_viewportSize[scrollbarVars._w_h]*handleToViewportRatio);var scrollBaseDuration=270*handleToViewportRatio;var scrollFirstIterationDelay=400*handleToViewportRatio;var trackOffset=scrollbarVars._track.offset()[scrollbarVars._left_top];var ctrlKey=event.ctrlKey;var instantScroll=event.shiftKey;var instantScrollTransition=instantScroll&&ctrlKey;var isFirstIteration=true;var easing='linear';var decreaseScroll;var finishedCondition;var scrollActionFinsished=function(transition){if(_scrollbarsHandlesDefineScrollPos)
refreshScrollbarHandleOffset(isHorizontal,transition);};var scrollActionInstantFinished=function(){scrollActionFinsished();onHandleMouseTouchDownAction(event);};var scrollAction=function(){if(!_destroyed){var mouseOffset=(mouseDownOffset-trackOffset)*mouseDownInvertedScale;var handleOffset=scrollbarVarsInfo._handleOffset;var trackLength=scrollbarVarsInfo._trackLength;var handleLength=scrollbarVarsInfo._handleLength;var scrollRange=scrollbarVarsInfo._maxScroll;var currScroll=scrollbarVarsInfo._currentScroll;var scrollDuration=scrollBaseDuration*scrollDurationFactor;var timeoutDelay=isFirstIteration?MATH.max(scrollFirstIterationDelay,scrollDuration):scrollDuration;var instantScrollPosition=scrollRange*((mouseOffset-(handleLength/2))/(trackLength-handleLength));var rtlIsNormal=_isRTL&&isHorizontal&&((!_rtlScrollBehavior.i&&!_rtlScrollBehavior.n)||_normalizeRTLCache);var decreaseScrollCondition=rtlIsNormal?handleOffset<mouseOffset:handleOffset>mouseOffset;var scrollObj={};var animationObj={easing:easing,step:function(now){if(_scrollbarsHandlesDefineScrollPos){_viewportElement[scroll](now);refreshScrollbarHandleOffset(isHorizontal,now);}}};instantScrollPosition=isFinite(instantScrollPosition)?instantScrollPosition:0;instantScrollPosition=_isRTL&&isHorizontal&&!_rtlScrollBehavior.i?(scrollRange-instantScrollPosition):instantScrollPosition;if(instantScroll){_viewportElement[scroll](instantScrollPosition);if(instantScrollTransition){instantScrollPosition=_viewportElement[scroll]();_viewportElement[scroll](currScroll);instantScrollPosition=rtlIsNormal&&_rtlScrollBehavior.i?(scrollRange-instantScrollPosition):instantScrollPosition;instantScrollPosition=rtlIsNormal&&_rtlScrollBehavior.n?-instantScrollPosition:instantScrollPosition;scrollObj[xy]=instantScrollPosition;_base.scroll(scrollObj,extendDeep(animationObj,{duration:130,complete:scrollActionInstantFinished}));}
else
scrollActionInstantFinished();}
else{decreaseScroll=isFirstIteration?decreaseScrollCondition:decreaseScroll;finishedCondition=rtlIsNormal?(decreaseScroll?handleOffset+handleLength>=mouseOffset:handleOffset<=mouseOffset):(decreaseScroll?handleOffset<=mouseOffset:handleOffset+handleLength>=mouseOffset);if(finishedCondition){clearTimeout(trackTimeout);_base.scrollStop();trackTimeout=undefined;scrollActionFinsished(true);}
else{trackTimeout=setTimeout(scrollAction,timeoutDelay);scrollObj[xy]=(decreaseScroll?'-=':'+=')+scrollDistance;_base.scroll(scrollObj,extendDeep(animationObj,{duration:scrollDuration}));}
isFirstIteration=false;}}};if(ctrlKey)
increaseTrackScrollAmount();mouseDownInvertedScale=getHostElementInvertedScale()[xy];mouseDownOffset=COMPATIBILITY.page(event)[xy];_scrollbarsHandlesDefineScrollPos=!getPreparedScrollbarsOption(strSnapHandle);addClass(_bodyElement,_classNameDragging);addClass(scrollbarVars._track,strActive);addClass(scrollbarVars._scrollbar,strActive);setupResponsiveEventListener(_documentElement,[_strMouseTouchUpEvent,_strKeyDownEvent,_strKeyUpEvent,_strSelectStartEvent],[documentMouseTouchUp,documentKeyDown,documentKeyUp,documentOnSelectStart]);scrollAction();COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}}
function onTrackMouseTouchEnter(event){_scrollbarsHandleHovered=true;if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(true);}
function onTrackMouseTouchLeave(event){_scrollbarsHandleHovered=false;if(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove)
refreshScrollbarsAutoHide(false);}
function onScrollbarMouseTouchDown(event){COMPATIBILITY.stpP(event);}
addDestroyEventListener(scrollbarVars._handle,_strMouseTouchDownEvent,onHandleMouseTouchDown);addDestroyEventListener(scrollbarVars._track,[_strMouseTouchDownEvent,_strMouseEnter,_strMouseLeave],[onTrackMouseTouchDown,onTrackMouseTouchEnter,onTrackMouseTouchLeave]);addDestroyEventListener(scrollbarVars._scrollbar,_strMouseTouchDownEvent,onScrollbarMouseTouchDown);if(_supportTransition){addDestroyEventListener(scrollbarVars._scrollbar,_strTransitionEndEvent,function(event){if(event.target!==scrollbarVars._scrollbar[0])
return;refreshScrollbarHandleLength(isHorizontal);refreshScrollbarHandleOffset(isHorizontal);});}}
function refreshScrollbarAppearance(isHorizontal,shallBeVisible,canScroll){var scrollbarHiddenClassName=isHorizontal?_classNameHostScrollbarHorizontalHidden:_classNameHostScrollbarVerticalHidden;var scrollbarElement=isHorizontal?_scrollbarHorizontalElement:_scrollbarVerticalElement;addRemoveClass(_hostElement,scrollbarHiddenClassName,!shallBeVisible);addRemoveClass(scrollbarElement,_classNameScrollbarUnusable,!canScroll);}
function refreshScrollbarsAutoHide(shallBeVisible,delayfree){clearTimeout(_scrollbarsAutoHideTimeoutId);if(shallBeVisible){removeClass(_scrollbarHorizontalElement,_classNameScrollbarAutoHidden);removeClass(_scrollbarVerticalElement,_classNameScrollbarAutoHidden);}
else{var anyActive;var strActive='active';var hide=function(){if(!_scrollbarsHandleHovered&&!_destroyed){anyActive=_scrollbarHorizontalHandleElement.hasClass(strActive)||_scrollbarVerticalHandleElement.hasClass(strActive);if(!anyActive&&(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove||_scrollbarsAutoHideLeave))
addClass(_scrollbarHorizontalElement,_classNameScrollbarAutoHidden);if(!anyActive&&(_scrollbarsAutoHideScroll||_scrollbarsAutoHideMove||_scrollbarsAutoHideLeave))
addClass(_scrollbarVerticalElement,_classNameScrollbarAutoHidden);}};if(_scrollbarsAutoHideDelay>0&&delayfree!==true)
_scrollbarsAutoHideTimeoutId=setTimeout(hide,_scrollbarsAutoHideDelay);else
hide();}}
function refreshScrollbarHandleLength(isHorizontal){var handleCSS={};var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbarVarsInfo=scrollbarVars._info;var digit=1000000;var handleRatio=MATH.min(1,_viewportSize[scrollbarVars._w_h]/_contentScrollSizeCache[scrollbarVars._w_h]);handleCSS[scrollbarVars._width_height]=(MATH.floor(handleRatio*100*digit)/digit)+'%';if(!nativeOverlayScrollbarsAreActive())
scrollbarVars._handle.css(handleCSS);scrollbarVarsInfo._handleLength=scrollbarVars._handle[0]['offset'+scrollbarVars._Width_Height];scrollbarVarsInfo._handleLengthRatio=handleRatio;}
function refreshScrollbarHandleOffset(isHorizontal,scrollOrTransition){var transition=type(scrollOrTransition)==TYPES.b;var transitionDuration=250;var isRTLisHorizontal=_isRTL&&isHorizontal;var scrollbarVars=getScrollbarVars(isHorizontal);var scrollbarVarsInfo=scrollbarVars._info;var strTranslateBrace='translate(';var strTransform=VENDORS._cssProperty('transform');var strTransition=VENDORS._cssProperty('transition');var nativeScroll=isHorizontal?_viewportElement[_strScrollLeft]():_viewportElement[_strScrollTop]();var currentScroll=scrollOrTransition===undefined||transition?nativeScroll:scrollOrTransition;var handleLength=scrollbarVarsInfo._handleLength;var trackLength=scrollbarVars._track[0]['offset'+scrollbarVars._Width_Height];var handleTrackDiff=trackLength-handleLength;var handleCSS={};var transformOffset;var translateValue;var maxScroll=(_viewportElementNative[_strScroll+scrollbarVars._Width_Height]-_viewportElementNative['client'+scrollbarVars._Width_Height])*(_rtlScrollBehavior.n&&isRTLisHorizontal?-1:1);var getScrollRatio=function(base){return isNaN(base/maxScroll)?0:MATH.max(0,MATH.min(1,base/maxScroll));};var getHandleOffset=function(scrollRatio){var offset=handleTrackDiff*scrollRatio;offset=isNaN(offset)?0:offset;offset=(isRTLisHorizontal&&!_rtlScrollBehavior.i)?(trackLength-handleLength-offset):offset;offset=MATH.max(0,offset);return offset;};var scrollRatio=getScrollRatio(nativeScroll);var unsnappedScrollRatio=getScrollRatio(currentScroll);var handleOffset=getHandleOffset(unsnappedScrollRatio);var snappedHandleOffset=getHandleOffset(scrollRatio);scrollbarVarsInfo._maxScroll=maxScroll;scrollbarVarsInfo._currentScroll=nativeScroll;scrollbarVarsInfo._currentScrollRatio=scrollRatio;if(_supportTransform){transformOffset=isRTLisHorizontal?-(trackLength-handleLength-handleOffset):handleOffset;translateValue=isHorizontal?strTranslateBrace+transformOffset+'px, 0)':strTranslateBrace+'0, '+transformOffset+'px)';handleCSS[strTransform]=translateValue;if(_supportTransition)
handleCSS[strTransition]=transition&&MATH.abs(handleOffset-scrollbarVarsInfo._handleOffset)>1?getCSSTransitionString(scrollbarVars._handle)+', '+(strTransform+_strSpace+transitionDuration+'ms'):_strEmpty;}
else
handleCSS[scrollbarVars._left_top]=handleOffset;if(!nativeOverlayScrollbarsAreActive()){scrollbarVars._handle.css(handleCSS);if(_supportTransform&&_supportTransition&&transition){scrollbarVars._handle.one(_strTransitionEndEvent,function(){if(!_destroyed)
scrollbarVars._handle.css(strTransition,_strEmpty);});}}
scrollbarVarsInfo._handleOffset=handleOffset;scrollbarVarsInfo._snappedHandleOffset=snappedHandleOffset;scrollbarVarsInfo._trackLength=trackLength;}
function refreshScrollbarsInteractive(isTrack,value){var action=value?'removeClass':'addClass';var element1=isTrack?_scrollbarHorizontalTrackElement:_scrollbarHorizontalHandleElement;var element2=isTrack?_scrollbarVerticalTrackElement:_scrollbarVerticalHandleElement;var className=isTrack?_classNameScrollbarTrackOff:_classNameScrollbarHandleOff;element1[action](className);element2[action](className);}
function getScrollbarVars(isHorizontal){return{_width_height:isHorizontal?_strWidth:_strHeight,_Width_Height:isHorizontal?'Width':'Height',_left_top:isHorizontal?_strLeft:_strTop,_Left_Top:isHorizontal?'Left':'Top',_x_y:isHorizontal?_strX:_strY,_X_Y:isHorizontal?'X':'Y',_w_h:isHorizontal?'w':'h',_l_t:isHorizontal?'l':'t',_track:isHorizontal?_scrollbarHorizontalTrackElement:_scrollbarVerticalTrackElement,_handle:isHorizontal?_scrollbarHorizontalHandleElement:_scrollbarVerticalHandleElement,_scrollbar:isHorizontal?_scrollbarHorizontalElement:_scrollbarVerticalElement,_info:isHorizontal?_scrollHorizontalInfo:_scrollVerticalInfo};}
function setupScrollbarCornerDOM(destroy){_scrollbarCornerElement=_scrollbarCornerElement||selectOrGenerateDivByClass(_classNameScrollbarCorner,true);if(!destroy){if(!_domExists){_hostElement.append(_scrollbarCornerElement);}}
else{if(_domExists&&_initialized){removeClass(_scrollbarCornerElement.removeAttr(LEXICON.s),_classNamesDynamicDestroy);}
else{remove(_scrollbarCornerElement);}}}
function setupScrollbarCornerEvents(){var insideIFrame=_windowElementNative.top!==_windowElementNative;var mouseDownPosition={};var mouseDownSize={};var mouseDownInvertedScale={};var reconnectMutationObserver;function documentDragMove(event){if(onMouseTouchDownContinue(event)){var pageOffset=getCoordinates(event);var hostElementCSS={};if(_resizeHorizontal||_resizeBoth)
hostElementCSS[_strWidth]=(mouseDownSize.w+(pageOffset.x-mouseDownPosition.x)*mouseDownInvertedScale.x);if(_resizeVertical||_resizeBoth)
hostElementCSS[_strHeight]=(mouseDownSize.h+(pageOffset.y-mouseDownPosition.y)*mouseDownInvertedScale.y);_hostElement.css(hostElementCSS);COMPATIBILITY.stpP(event);}
else{documentMouseTouchUp(event);}}
function documentMouseTouchUp(event){var eventIsTrusted=event!==undefined;setupResponsiveEventListener(_documentElement,[_strSelectStartEvent,_strMouseTouchMoveEvent,_strMouseTouchUpEvent],[documentOnSelectStart,documentDragMove,documentMouseTouchUp],true);removeClass(_bodyElement,_classNameDragging);if(_scrollbarCornerElement.releaseCapture)
_scrollbarCornerElement.releaseCapture();if(eventIsTrusted){if(reconnectMutationObserver)
connectMutationObservers();_base.update(_strAuto);}
reconnectMutationObserver=false;}
function onMouseTouchDownContinue(event){var originalEvent=event.originalEvent||event;var isTouchEvent=originalEvent.touches!==undefined;return _sleeping||_destroyed?false:COMPATIBILITY.mBtn(event)===1||isTouchEvent;}
function getCoordinates(event){return _msieVersion&&insideIFrame?{x:event.screenX,y:event.screenY}:COMPATIBILITY.page(event);}
addDestroyEventListener(_scrollbarCornerElement,_strMouseTouchDownEvent,function(event){if(onMouseTouchDownContinue(event)&&!_resizeNone){if(_mutationObserversConnected){reconnectMutationObserver=true;disconnectMutationObservers();}
mouseDownPosition=getCoordinates(event);mouseDownSize.w=_hostElementNative[LEXICON.oW]-(!_isBorderBox?_paddingX:0);mouseDownSize.h=_hostElementNative[LEXICON.oH]-(!_isBorderBox?_paddingY:0);mouseDownInvertedScale=getHostElementInvertedScale();setupResponsiveEventListener(_documentElement,[_strSelectStartEvent,_strMouseTouchMoveEvent,_strMouseTouchUpEvent],[documentOnSelectStart,documentDragMove,documentMouseTouchUp]);addClass(_bodyElement,_classNameDragging);if(_scrollbarCornerElement.setCapture)
_scrollbarCornerElement.setCapture();COMPATIBILITY.prvD(event);COMPATIBILITY.stpP(event);}});}
function dispatchCallback(name,args,dependent){if(dependent===false)
return;if(_initialized){var callback=_currentPreparedOptions.callbacks[name];var extensionOnName=name;var ext;if(extensionOnName.substr(0,2)==='on')
extensionOnName=extensionOnName.substr(2,1).toLowerCase()+extensionOnName.substr(3);if(type(callback)==TYPES.f)
callback.call(_base,args);each(_extensions,function(){ext=this;if(type(ext.on)==TYPES.f)
ext.on(extensionOnName,args);});}
else if(!_destroyed)
_callbacksInitQeueue.push({n:name,a:args});}
function setTopRightBottomLeft(targetCSSObject,prefix,values){prefix=prefix||_strEmpty;values=values||[_strEmpty,_strEmpty,_strEmpty,_strEmpty];targetCSSObject[prefix+_strTop]=values[0];targetCSSObject[prefix+_strRight]=values[1];targetCSSObject[prefix+_strBottom]=values[2];targetCSSObject[prefix+_strLeft]=values[3];}
function getTopRightBottomLeftHost(prefix,suffix,zeroX,zeroY){suffix=suffix||_strEmpty;prefix=prefix||_strEmpty;return{t:zeroY?0:parseToZeroOrNumber(_hostElement.css(prefix+_strTop+suffix)),r:zeroX?0:parseToZeroOrNumber(_hostElement.css(prefix+_strRight+suffix)),b:zeroY?0:parseToZeroOrNumber(_hostElement.css(prefix+_strBottom+suffix)),l:zeroX?0:parseToZeroOrNumber(_hostElement.css(prefix+_strLeft+suffix))};}
function getCSSTransitionString(element){var transitionStr=VENDORS._cssProperty('transition');var assembledValue=element.css(transitionStr);if(assembledValue)
return assembledValue;var regExpString='\\s*('+'([^,(]+(\\(.+?\\))?)+'+')[\\s,]*';var regExpMain=new RegExp(regExpString);var regExpValidate=new RegExp('^('+regExpString+')+$');var properties='property duration timing-function delay'.split(' ');var result=[];var strResult;var valueArray;var i=0;var j;var splitCssStyleByComma=function(str){strResult=[];if(!str.match(regExpValidate))
return str;while(str.match(regExpMain)){strResult.push(RegExp.$1);str=str.replace(regExpMain,_strEmpty);}
return strResult;};for(;i<properties[LEXICON.l];i++){valueArray=splitCssStyleByComma(element.css(transitionStr+'-'+properties[i]));for(j=0;j<valueArray[LEXICON.l];j++)
result[j]=(result[j]?result[j]+_strSpace:_strEmpty)+valueArray[j];}
return result.join(', ');}
function createHostClassNameRegExp(withCurrClassNameOption,withOldClassNameOption){var i;var split;var appendix;var appendClasses=function(classes,condition){appendix='';if(condition&&typeof classes==TYPES.s){split=classes.split(_strSpace);for(i=0;i<split[LEXICON.l];i++)
appendix+='|'+split[i]+'$';}
return appendix;};return new RegExp('(^'+_classNameHostElement+'([-_].+|)$)'+
appendClasses(_classNameCache,withCurrClassNameOption)+
appendClasses(_oldClassName,withOldClassNameOption),'g');}
function getHostElementInvertedScale(){var rect=_paddingElementNative[LEXICON.bCR]();return{x:_supportTransform?1/(MATH.round(rect.width)/_paddingElementNative[LEXICON.oW])||1:1,y:_supportTransform?1/(MATH.round(rect.height)/_paddingElementNative[LEXICON.oH])||1:1};}
function isHTMLElement(o){var strOwnerDocument='ownerDocument';var strHTMLElement='HTMLElement';var wnd=o&&o[strOwnerDocument]?(o[strOwnerDocument].parentWindow||window):window;return(typeof wnd[strHTMLElement]==TYPES.o?o instanceof wnd[strHTMLElement]:o&&typeof o==TYPES.o&&o!==null&&o.nodeType===1&&typeof o.nodeName==TYPES.s);}
function getArrayDifferences(a1,a2){var a=[];var diff=[];var i;var k;for(i=0;i<a1.length;i++)
a[a1[i]]=true;for(i=0;i<a2.length;i++){if(a[a2[i]])
delete a[a2[i]];else
a[a2[i]]=true;}
for(k in a)
diff.push(k);return diff;}
function parseToZeroOrNumber(value,toFloat){var num=toFloat?parseFloat(value):parseInt(value,10);return isNaN(num)?0:num;}
function getTextareaInfo(){var textareaCursorPosition=_targetElementNative.selectionStart;if(textareaCursorPosition===undefined)
return;var textareaValue=_targetElement.val();var textareaLength=textareaValue[LEXICON.l];var textareaRowSplit=textareaValue.split('\n');var textareaLastRow=textareaRowSplit[LEXICON.l];var textareaCurrentCursorRowSplit=textareaValue.substr(0,textareaCursorPosition).split('\n');var widestRow=0;var textareaLastCol=0;var cursorRow=textareaCurrentCursorRowSplit[LEXICON.l];var cursorCol=textareaCurrentCursorRowSplit[textareaCurrentCursorRowSplit[LEXICON.l]-1][LEXICON.l];var rowCols;var i;for(i=0;i<textareaRowSplit[LEXICON.l];i++){rowCols=textareaRowSplit[i][LEXICON.l];if(rowCols>textareaLastCol){widestRow=i+1;textareaLastCol=rowCols;}}
return{_cursorRow:cursorRow,_cursorColumn:cursorCol,_rows:textareaLastRow,_columns:textareaLastCol,_widestRow:widestRow,_cursorPosition:textareaCursorPosition,_cursorMax:textareaLength};}
function nativeOverlayScrollbarsAreActive(){return(_ignoreOverlayScrollbarHidingCache&&(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y));}
function getContentMeasureElement(){return _isTextarea?_textareaCoverElement[0]:_contentElementNative;}
function generateDiv(classesOrAttrs,content){return'<div '+(classesOrAttrs?type(classesOrAttrs)==TYPES.s?'class="'+classesOrAttrs+'"':(function(){var key;var attrs=_strEmpty;if(FRAMEWORK.isPlainObject(classesOrAttrs)){for(key in classesOrAttrs)
attrs+=(key==='c'?'class':key)+'="'+classesOrAttrs[key]+'" ';}
return attrs;})():_strEmpty)+
'>'+
(content||_strEmpty)+
'</div>';}
function selectOrGenerateDivByClass(className,selectParentOrOnlyChildren){var onlyChildren=type(selectParentOrOnlyChildren)==TYPES.b;var selectParent=onlyChildren?_hostElement:(selectParentOrOnlyChildren||_hostElement);return(_domExists&&!selectParent[LEXICON.l])?null:_domExists?selectParent[onlyChildren?'children':'find'](_strDot+className.replace(/\s/g,_strDot)).eq(0):FRAMEWORK(generateDiv(className))}
function getObjectPropVal(obj,path){var splits=path.split(_strDot);var i=0;var val;for(;i<splits.length;i++){if(!obj[LEXICON.hOP](splits[i]))
return;val=obj[splits[i]];if(i<splits.length&&type(val)==TYPES.o)
obj=val;}
return val;}
function setObjectPropVal(obj,path,val){var splits=path.split(_strDot);var splitsLength=splits.length;var i=0;var extendObj={};var extendObjRoot=extendObj;for(;i<splitsLength;i++)
extendObj=extendObj[splits[i]]=i+1<splitsLength?{}:val;FRAMEWORK.extend(obj,extendObjRoot,true);}
function eachUpdateOnLoad(action){var updateOnLoad=_currentPreparedOptions.updateOnLoad;updateOnLoad=type(updateOnLoad)==TYPES.s?updateOnLoad.split(_strSpace):updateOnLoad;if(COMPATIBILITY.isA(updateOnLoad)&&!_destroyed){each(updateOnLoad,action);}}
function checkCache(current,cache,force){if(force)
return force;if(type(current)==TYPES.o&&type(cache)==TYPES.o){for(var prop in current){if(prop!=='c'){if(current[LEXICON.hOP](prop)&&cache[LEXICON.hOP](prop)){if(checkCache(current[prop],cache[prop]))
return true;}
else{return true;}}}}
else{return current!==cache;}
return false;}
function extendDeep(){return FRAMEWORK.extend.apply(this,[true].concat([].slice.call(arguments)));}
function addClass(el,classes){return _frameworkProto.addClass.call(el,classes);}
function removeClass(el,classes){return _frameworkProto.removeClass.call(el,classes);}
function addRemoveClass(el,classes,doAdd){return doAdd?addClass(el,classes):removeClass(el,classes);}
function remove(el){return _frameworkProto.remove.call(el);}
function findFirst(el,selector){return _frameworkProto.find.call(el,selector).eq(0);}
_base.sleep=function(){_sleeping=true;};_base.update=function(force){if(_destroyed)
return;var attrsChanged;var contentSizeC;var isString=type(force)==TYPES.s;var doUpdateAuto;var mutHost;var mutContent;if(isString){if(force===_strAuto){attrsChanged=meaningfulAttrsChanged();contentSizeC=updateAutoContentSizeChanged();doUpdateAuto=attrsChanged||contentSizeC;if(doUpdateAuto){update({_contentSizeChanged:contentSizeC,_changedOptions:_initialized?undefined:_currentPreparedOptions});}}
else if(force===_strSync){if(_mutationObserversConnected){mutHost=_mutationObserverHostCallback(_mutationObserverHost.takeRecords());mutContent=_mutationObserverContentCallback(_mutationObserverContent.takeRecords());}
else{mutHost=_base.update(_strAuto);}}
else if(force==='zoom'){update({_hostSizeChanged:true,_contentSizeChanged:true});}}
else{force=_sleeping||force;_sleeping=false;if(!_base.update(_strSync)||force)
update({_force:force});}
updateElementsOnLoad();return doUpdateAuto||mutHost||mutContent;};_base.options=function(newOptions,value){var option={};var changedOps;if(FRAMEWORK.isEmptyObject(newOptions)||!FRAMEWORK.isPlainObject(newOptions)){if(type(newOptions)==TYPES.s){if(arguments.length>1){setObjectPropVal(option,newOptions,value);changedOps=setOptions(option);}
else
return getObjectPropVal(_currentOptions,newOptions);}
else
return _currentOptions;}
else{changedOps=setOptions(newOptions);}
if(!FRAMEWORK.isEmptyObject(changedOps)){update({_changedOptions:changedOps});}};_base.destroy=function(){if(_destroyed)
return;autoUpdateLoop.remove(_base);disconnectMutationObservers();setupResizeObserver(_sizeObserverElement);setupResizeObserver(_sizeAutoObserverElement);for(var extName in _extensions)
_base.removeExt(extName);while(_destroyEvents[LEXICON.l]>0)
_destroyEvents.pop()();setupHostMouseTouchEvents(true);if(_contentGlueElement)
remove(_contentGlueElement);if(_contentArrangeElement)
remove(_contentArrangeElement);if(_sizeAutoObserverAdded)
remove(_sizeAutoObserverElement);setupScrollbarsDOM(true);setupScrollbarCornerDOM(true);setupStructureDOM(true);for(var i=0;i<_updateOnLoadElms[LEXICON.l];i++)
FRAMEWORK(_updateOnLoadElms[i]).off(_updateOnLoadEventName,updateOnLoadCallback);_updateOnLoadElms=undefined;_destroyed=true;_sleeping=true;INSTANCES(pluginTargetElement,0);dispatchCallback('onDestroyed');};_base.scroll=function(coordinates,duration,easing,complete){if(arguments.length===0||coordinates===undefined){var infoX=_scrollHorizontalInfo;var infoY=_scrollVerticalInfo;var normalizeInvert=_normalizeRTLCache&&_isRTL&&_rtlScrollBehavior.i;var normalizeNegate=_normalizeRTLCache&&_isRTL&&_rtlScrollBehavior.n;var scrollX=infoX._currentScroll;var scrollXRatio=infoX._currentScrollRatio;var maxScrollX=infoX._maxScroll;scrollXRatio=normalizeInvert?1-scrollXRatio:scrollXRatio;scrollX=normalizeInvert?maxScrollX-scrollX:scrollX;scrollX*=normalizeNegate?-1:1;maxScrollX*=normalizeNegate?-1:1;return{position:{x:scrollX,y:infoY._currentScroll},ratio:{x:scrollXRatio,y:infoY._currentScrollRatio},max:{x:maxScrollX,y:infoY._maxScroll},handleOffset:{x:infoX._handleOffset,y:infoY._handleOffset},handleLength:{x:infoX._handleLength,y:infoY._handleLength},handleLengthRatio:{x:infoX._handleLengthRatio,y:infoY._handleLengthRatio},trackLength:{x:infoX._trackLength,y:infoY._trackLength},snappedHandleOffset:{x:infoX._snappedHandleOffset,y:infoY._snappedHandleOffset},isRTL:_isRTL,isRTLNormalized:_normalizeRTLCache};}
_base.update(_strSync);var normalizeRTL=_normalizeRTLCache;var coordinatesXAxisProps=[_strX,_strLeft,'l'];var coordinatesYAxisProps=[_strY,_strTop,'t'];var coordinatesOperators=['+=','-=','*=','/='];var durationIsObject=type(duration)==TYPES.o;var completeCallback=durationIsObject?duration.complete:complete;var i;var finalScroll={};var specialEasing={};var doScrollLeft;var doScrollTop;var animationOptions;var strEnd='end';var strBegin='begin';var strCenter='center';var strNearest='nearest';var strAlways='always';var strNever='never';var strIfNeeded='ifneeded';var strLength=LEXICON.l;var settingsAxis;var settingsScroll;var settingsBlock;var settingsMargin;var finalElement;var elementObjSettingsAxisValues=[_strX,_strY,'xy','yx'];var elementObjSettingsBlockValues=[strBegin,strEnd,strCenter,strNearest];var elementObjSettingsScrollValues=[strAlways,strNever,strIfNeeded];var coordinatesIsElementObj=coordinates[LEXICON.hOP]('el');var possibleElement=coordinatesIsElementObj?coordinates.el:coordinates;var possibleElementIsJQuery=possibleElement instanceof FRAMEWORK||JQUERY?possibleElement instanceof JQUERY:false;var possibleElementIsHTMLElement=possibleElementIsJQuery?false:isHTMLElement(possibleElement);var updateScrollbarInfos=function(){if(doScrollLeft)
refreshScrollbarHandleOffset(true);if(doScrollTop)
refreshScrollbarHandleOffset(false);};var proxyCompleteCallback=type(completeCallback)!=TYPES.f?undefined:function(){updateScrollbarInfos();completeCallback();};function checkSettingsStringValue(currValue,allowedValues){for(i=0;i<allowedValues[strLength];i++){if(currValue===allowedValues[i])
return true;}
return false;}
function getRawScroll(isX,coordinates){var coordinateProps=isX?coordinatesXAxisProps:coordinatesYAxisProps;coordinates=type(coordinates)==TYPES.s||type(coordinates)==TYPES.n?[coordinates,coordinates]:coordinates;if(COMPATIBILITY.isA(coordinates))
return isX?coordinates[0]:coordinates[1];else if(type(coordinates)==TYPES.o){for(i=0;i<coordinateProps[strLength];i++)
if(coordinateProps[i]in coordinates)
return coordinates[coordinateProps[i]];}}
function getFinalScroll(isX,rawScroll){var isString=type(rawScroll)==TYPES.s;var operator;var amount;var scrollInfo=isX?_scrollHorizontalInfo:_scrollVerticalInfo;var currScroll=scrollInfo._currentScroll;var maxScroll=scrollInfo._maxScroll;var mult=' * ';var finalValue;var isRTLisX=_isRTL&&isX;var normalizeShortcuts=isRTLisX&&_rtlScrollBehavior.n&&!normalizeRTL;var strReplace='replace';var evalFunc=eval;var possibleOperator;if(isString){if(rawScroll[strLength]>2){possibleOperator=rawScroll.substr(0,2);if(inArray(possibleOperator,coordinatesOperators)>-1)
operator=possibleOperator;}
rawScroll=operator?rawScroll.substr(2):rawScroll;rawScroll=rawScroll
[strReplace](/min/g,0)
[strReplace](/</g,0)
[strReplace](/max/g,(normalizeShortcuts?'-':_strEmpty)+_strHundredPercent)
[strReplace](/>/g,(normalizeShortcuts?'-':_strEmpty)+_strHundredPercent)
[strReplace](/px/g,_strEmpty)
[strReplace](/%/g,mult+(maxScroll*(isRTLisX&&_rtlScrollBehavior.n?-1:1)/100.0))
[strReplace](/vw/g,mult+_viewportSize.w)
[strReplace](/vh/g,mult+_viewportSize.h);amount=parseToZeroOrNumber(isNaN(rawScroll)?parseToZeroOrNumber(evalFunc(rawScroll),true).toFixed():rawScroll);}
else{amount=rawScroll;}
if(amount!==undefined&&!isNaN(amount)&&type(amount)==TYPES.n){var normalizeIsRTLisX=normalizeRTL&&isRTLisX;var operatorCurrScroll=currScroll*(normalizeIsRTLisX&&_rtlScrollBehavior.n?-1:1);var invert=normalizeIsRTLisX&&_rtlScrollBehavior.i;var negate=normalizeIsRTLisX&&_rtlScrollBehavior.n;operatorCurrScroll=invert?(maxScroll-operatorCurrScroll):operatorCurrScroll;switch(operator){case'+=':finalValue=operatorCurrScroll+amount;break;case'-=':finalValue=operatorCurrScroll-amount;break;case'*=':finalValue=operatorCurrScroll*amount;break;case'/=':finalValue=operatorCurrScroll/amount;break;default:finalValue=amount;break;}
finalValue=invert?maxScroll-finalValue:finalValue;finalValue*=negate?-1:1;finalValue=isRTLisX&&_rtlScrollBehavior.n?MATH.min(0,MATH.max(maxScroll,finalValue)):MATH.max(0,MATH.min(maxScroll,finalValue));}
return finalValue===currScroll?undefined:finalValue;}
function getPerAxisValue(value,valueInternalType,defaultValue,allowedValues){var resultDefault=[defaultValue,defaultValue];var valueType=type(value);var valueArrLength;var valueArrItem;if(valueType==valueInternalType){value=[value,value];}
else if(valueType==TYPES.a){valueArrLength=value[strLength];if(valueArrLength>2||valueArrLength<1)
value=resultDefault;else{if(valueArrLength===1)
value[1]=defaultValue;for(i=0;i<valueArrLength;i++){valueArrItem=value[i];if(type(valueArrItem)!=valueInternalType||!checkSettingsStringValue(valueArrItem,allowedValues)){value=resultDefault;break;}}}}
else if(valueType==TYPES.o)
value=[value[_strX]||defaultValue,value[_strY]||defaultValue];else
value=resultDefault;return{x:value[0],y:value[1]};}
function generateMargin(marginTopRightBottomLeftArray){var result=[];var currValue;var currValueType;var valueDirections=[_strTop,_strRight,_strBottom,_strLeft];for(i=0;i<marginTopRightBottomLeftArray[strLength];i++){if(i===valueDirections[strLength])
break;currValue=marginTopRightBottomLeftArray[i];currValueType=type(currValue);if(currValueType==TYPES.b)
result.push(currValue?parseToZeroOrNumber(finalElement.css(_strMarginMinus+valueDirections[i])):0);else
result.push(currValueType==TYPES.n?currValue:0);}
return result;}
if(possibleElementIsJQuery||possibleElementIsHTMLElement){var margin=coordinatesIsElementObj?coordinates.margin:0;var axis=coordinatesIsElementObj?coordinates.axis:0;var scroll=coordinatesIsElementObj?coordinates.scroll:0;var block=coordinatesIsElementObj?coordinates.block:0;var marginDefault=[0,0,0,0];var marginType=type(margin);var marginLength;finalElement=possibleElementIsJQuery?possibleElement:FRAMEWORK(possibleElement);if(finalElement[strLength]>0){if(marginType==TYPES.n||marginType==TYPES.b)
margin=generateMargin([margin,margin,margin,margin]);else if(marginType==TYPES.a){marginLength=margin[strLength];if(marginLength===2)
margin=generateMargin([margin[0],margin[1],margin[0],margin[1]]);else if(marginLength>=4)
margin=generateMargin(margin);else
margin=marginDefault;}
else if(marginType==TYPES.o)
margin=generateMargin([margin[_strTop],margin[_strRight],margin[_strBottom],margin[_strLeft]]);else
margin=marginDefault;settingsAxis=checkSettingsStringValue(axis,elementObjSettingsAxisValues)?axis:'xy';settingsScroll=getPerAxisValue(scroll,TYPES.s,strAlways,elementObjSettingsScrollValues);settingsBlock=getPerAxisValue(block,TYPES.s,strBegin,elementObjSettingsBlockValues);settingsMargin=margin;var viewportScroll={l:_scrollHorizontalInfo._currentScroll,t:_scrollVerticalInfo._currentScroll};var viewportOffset=_paddingElement.offset();var elementOffset=finalElement.offset();var doNotScroll={x:settingsScroll.x==strNever||settingsAxis==_strY,y:settingsScroll.y==strNever||settingsAxis==_strX};elementOffset[_strTop]-=settingsMargin[0];elementOffset[_strLeft]-=settingsMargin[3];var elementScrollCoordinates={x:MATH.round(elementOffset[_strLeft]-viewportOffset[_strLeft]+viewportScroll.l),y:MATH.round(elementOffset[_strTop]-viewportOffset[_strTop]+viewportScroll.t)};if(_isRTL){if(!_rtlScrollBehavior.n&&!_rtlScrollBehavior.i)
elementScrollCoordinates.x=MATH.round(viewportOffset[_strLeft]-elementOffset[_strLeft]+viewportScroll.l);if(_rtlScrollBehavior.n&&normalizeRTL)
elementScrollCoordinates.x*=-1;if(_rtlScrollBehavior.i&&normalizeRTL)
elementScrollCoordinates.x=MATH.round(viewportOffset[_strLeft]-elementOffset[_strLeft]+(_scrollHorizontalInfo._maxScroll-viewportScroll.l));}
if(settingsBlock.x!=strBegin||settingsBlock.y!=strBegin||settingsScroll.x==strIfNeeded||settingsScroll.y==strIfNeeded||_isRTL){var measuringElm=finalElement[0];var rawElementSize=_supportTransform?measuringElm[LEXICON.bCR]():{width:measuringElm[LEXICON.oW],height:measuringElm[LEXICON.oH]};var elementSize={w:rawElementSize[_strWidth]+settingsMargin[3]+settingsMargin[1],h:rawElementSize[_strHeight]+settingsMargin[0]+settingsMargin[2]};var finalizeBlock=function(isX){var vars=getScrollbarVars(isX);var wh=vars._w_h;var lt=vars._left_top;var xy=vars._x_y;var blockIsEnd=settingsBlock[xy]==(isX?_isRTL?strBegin:strEnd:strEnd);var blockIsCenter=settingsBlock[xy]==strCenter;var blockIsNearest=settingsBlock[xy]==strNearest;var scrollNever=settingsScroll[xy]==strNever;var scrollIfNeeded=settingsScroll[xy]==strIfNeeded;var vpSize=_viewportSize[wh];var vpOffset=viewportOffset[lt];var elSize=elementSize[wh];var elOffset=elementOffset[lt];var divide=blockIsCenter?2:1;var elementCenterOffset=elOffset+(elSize/2);var viewportCenterOffset=vpOffset+(vpSize/2);var isInView=elSize<=vpSize&&elOffset>=vpOffset&&elOffset+elSize<=vpOffset+vpSize;if(scrollNever)
doNotScroll[xy]=true;else if(!doNotScroll[xy]){if(blockIsNearest||scrollIfNeeded){doNotScroll[xy]=scrollIfNeeded?isInView:false;blockIsEnd=elSize<vpSize?elementCenterOffset>viewportCenterOffset:elementCenterOffset<viewportCenterOffset;}
elementScrollCoordinates[xy]-=blockIsEnd||blockIsCenter?((vpSize/divide)-(elSize/divide))*(isX&&_isRTL&&normalizeRTL?-1:1):0;}};finalizeBlock(true);finalizeBlock(false);}
if(doNotScroll.y)
delete elementScrollCoordinates.y;if(doNotScroll.x)
delete elementScrollCoordinates.x;coordinates=elementScrollCoordinates;}}
finalScroll[_strScrollLeft]=getFinalScroll(true,getRawScroll(true,coordinates));finalScroll[_strScrollTop]=getFinalScroll(false,getRawScroll(false,coordinates));doScrollLeft=finalScroll[_strScrollLeft]!==undefined;doScrollTop=finalScroll[_strScrollTop]!==undefined;if((doScrollLeft||doScrollTop)&&(duration>0||durationIsObject)){if(durationIsObject){duration.complete=proxyCompleteCallback;_viewportElement.animate(finalScroll,duration);}
else{animationOptions={duration:duration,complete:proxyCompleteCallback};if(COMPATIBILITY.isA(easing)||FRAMEWORK.isPlainObject(easing)){specialEasing[_strScrollLeft]=easing[0]||easing.x;specialEasing[_strScrollTop]=easing[1]||easing.y;animationOptions.specialEasing=specialEasing;}
else{animationOptions.easing=easing;}
_viewportElement.animate(finalScroll,animationOptions);}}
else{if(doScrollLeft)
_viewportElement[_strScrollLeft](finalScroll[_strScrollLeft]);if(doScrollTop)
_viewportElement[_strScrollTop](finalScroll[_strScrollTop]);updateScrollbarInfos();}};_base.scrollStop=function(param1,param2,param3){_viewportElement.stop(param1,param2,param3);return _base;};_base.getElements=function(elementName){var obj={target:_targetElementNative,host:_hostElementNative,padding:_paddingElementNative,viewport:_viewportElementNative,content:_contentElementNative,scrollbarHorizontal:{scrollbar:_scrollbarHorizontalElement[0],track:_scrollbarHorizontalTrackElement[0],handle:_scrollbarHorizontalHandleElement[0]},scrollbarVertical:{scrollbar:_scrollbarVerticalElement[0],track:_scrollbarVerticalTrackElement[0],handle:_scrollbarVerticalHandleElement[0]},scrollbarCorner:_scrollbarCornerElement[0]};return type(elementName)==TYPES.s?getObjectPropVal(obj,elementName):obj;};_base.getState=function(stateProperty){function prepare(obj){if(!FRAMEWORK.isPlainObject(obj))
return obj;var extended=extendDeep({},obj);var changePropertyName=function(from,to){if(extended[LEXICON.hOP](from)){extended[to]=extended[from];delete extended[from];}};changePropertyName('w',_strWidth);changePropertyName('h',_strHeight);delete extended.c;return extended;};var obj={destroyed:!!prepare(_destroyed),sleeping:!!prepare(_sleeping),autoUpdate:prepare(!_mutationObserversConnected),widthAuto:prepare(_widthAutoCache),heightAuto:prepare(_heightAutoCache),padding:prepare(_cssPaddingCache),overflowAmount:prepare(_overflowAmountCache),hideOverflow:prepare(_hideOverflowCache),hasOverflow:prepare(_hasOverflowCache),contentScrollSize:prepare(_contentScrollSizeCache),viewportSize:prepare(_viewportSize),hostSize:prepare(_hostSizeCache),documentMixed:prepare(_documentMixed)};return type(stateProperty)==TYPES.s?getObjectPropVal(obj,stateProperty):obj;};_base.ext=function(extName){var result;var privateMethods=_extensionsPrivateMethods.split(' ');var i=0;if(type(extName)==TYPES.s){if(_extensions[LEXICON.hOP](extName)){result=extendDeep({},_extensions[extName]);for(;i<privateMethods.length;i++)
delete result[privateMethods[i]];}}
else{result={};for(i in _extensions)
result[i]=extendDeep({},_base.ext(i));}
return result;};_base.addExt=function(extName,extensionOptions){var registeredExtensionObj=_plugin.extension(extName);var instance;var instanceAdded;var instanceContract;var contractResult;var contractFulfilled=true;if(registeredExtensionObj){if(!_extensions[LEXICON.hOP](extName)){instance=registeredExtensionObj.extensionFactory.call(_base,extendDeep({},registeredExtensionObj.defaultOptions),FRAMEWORK,COMPATIBILITY);if(instance){instanceContract=instance.contract;if(type(instanceContract)==TYPES.f){contractResult=instanceContract(window);contractFulfilled=type(contractResult)==TYPES.b?contractResult:contractFulfilled;}
if(contractFulfilled){_extensions[extName]=instance;instanceAdded=instance.added;if(type(instanceAdded)==TYPES.f)
instanceAdded(extensionOptions);return _base.ext(extName);}}}
else
return _base.ext(extName);}
else
console.warn("A extension with the name \""+extName+"\" isn't registered.");};_base.removeExt=function(extName){var instance=_extensions[extName];var instanceRemoved;if(instance){delete _extensions[extName];instanceRemoved=instance.removed;if(type(instanceRemoved)==TYPES.f)
instanceRemoved();return true;}
return false;};function construct(targetElement,options,extensions){_defaultOptions=globals.defaultOptions;_nativeScrollbarStyling=globals.nativeScrollbarStyling;_nativeScrollbarSize=extendDeep({},globals.nativeScrollbarSize);_nativeScrollbarIsOverlaid=extendDeep({},globals.nativeScrollbarIsOverlaid);_overlayScrollbarDummySize=extendDeep({},globals.overlayScrollbarDummySize);_rtlScrollBehavior=extendDeep({},globals.rtlScrollBehavior);setOptions(extendDeep({},_defaultOptions,options));_cssCalc=globals.cssCalc;_msieVersion=globals.msie;_autoUpdateRecommended=globals.autoUpdateRecommended;_supportTransition=globals.supportTransition;_supportTransform=globals.supportTransform;_supportPassiveEvents=globals.supportPassiveEvents;_supportResizeObserver=globals.supportResizeObserver;_supportMutationObserver=globals.supportMutationObserver;_restrictedMeasuring=globals.restrictedMeasuring;_documentElement=FRAMEWORK(targetElement.ownerDocument);_documentElementNative=_documentElement[0];_windowElement=FRAMEWORK(_documentElementNative.defaultView||_documentElementNative.parentWindow);_windowElementNative=_windowElement[0];_htmlElement=findFirst(_documentElement,'html');_bodyElement=findFirst(_htmlElement,'body');_targetElement=FRAMEWORK(targetElement);_targetElementNative=_targetElement[0];_isTextarea=_targetElement.is('textarea');_isBody=_targetElement.is('body');_documentMixed=_documentElementNative!==document;_domExists=_isTextarea?_targetElement.hasClass(_classNameTextareaElement)&&_targetElement.parent().hasClass(_classNameContentElement):_targetElement.hasClass(_classNameHostElement)&&_targetElement.children(_strDot+_classNamePaddingElement)[LEXICON.l];var initBodyScroll;var bodyMouseTouchDownListener;if(_nativeScrollbarIsOverlaid.x&&_nativeScrollbarIsOverlaid.y&&!_currentPreparedOptions.nativeScrollbarsOverlaid.initialize){dispatchCallback('onInitializationWithdrawn');if(_domExists){setupStructureDOM(true);setupScrollbarsDOM(true);setupScrollbarCornerDOM(true);}
_destroyed=true;_sleeping=true;return _base;}
if(_isBody){initBodyScroll={};initBodyScroll.l=MATH.max(_targetElement[_strScrollLeft](),_htmlElement[_strScrollLeft](),_windowElement[_strScrollLeft]());initBodyScroll.t=MATH.max(_targetElement[_strScrollTop](),_htmlElement[_strScrollTop](),_windowElement[_strScrollTop]());bodyMouseTouchDownListener=function(){_viewportElement.removeAttr(LEXICON.ti);setupResponsiveEventListener(_viewportElement,_strMouseTouchDownEvent,bodyMouseTouchDownListener,true,true);}}
setupStructureDOM();setupScrollbarsDOM();setupScrollbarCornerDOM();setupStructureEvents();setupScrollbarEvents(true);setupScrollbarEvents(false);setupScrollbarCornerEvents();createMutationObservers();setupResizeObserver(_sizeObserverElement,hostOnResized);if(_isBody){_viewportElement[_strScrollLeft](initBodyScroll.l)[_strScrollTop](initBodyScroll.t);if(document.activeElement==targetElement&&_viewportElementNative.focus){_viewportElement.attr(LEXICON.ti,'-1');_viewportElementNative.focus();setupResponsiveEventListener(_viewportElement,_strMouseTouchDownEvent,bodyMouseTouchDownListener,false,true);}}
_base.update(_strAuto);_initialized=true;dispatchCallback('onInitialized');each(_callbacksInitQeueue,function(index,value){dispatchCallback(value.n,value.a);});_callbacksInitQeueue=[];if(type(extensions)==TYPES.s)
extensions=[extensions];if(COMPATIBILITY.isA(extensions))
each(extensions,function(index,value){_base.addExt(value);});else if(FRAMEWORK.isPlainObject(extensions))
each(extensions,function(key,value){_base.addExt(key,value);});setTimeout(function(){if(_supportTransition&&!_destroyed)
addClass(_hostElement,_classNameHostTransition);},333);return _base;}
if(_plugin.valid(construct(pluginTargetElement,options,extensions))){INSTANCES(pluginTargetElement,_base);}
return _base;}
_plugin=window[PLUGINNAME]=function(pluginTargetElements,options,extensions){if(arguments[LEXICON.l]===0)
return this;var arr=[];var optsIsPlainObj=FRAMEWORK.isPlainObject(options);var inst;var result;if(!pluginTargetElements)
return optsIsPlainObj||!options?result:arr;pluginTargetElements=pluginTargetElements[LEXICON.l]!=undefined?pluginTargetElements:[pluginTargetElements[0]||pluginTargetElements];initOverlayScrollbarsStatics();if(pluginTargetElements[LEXICON.l]>0){if(optsIsPlainObj){FRAMEWORK.each(pluginTargetElements,function(i,v){inst=v;if(inst!==undefined)
arr.push(OverlayScrollbarsInstance(inst,options,extensions,_pluginsGlobals,_pluginsAutoUpdateLoop));});}
else{FRAMEWORK.each(pluginTargetElements,function(i,v){inst=INSTANCES(v);if((options==='!'&&_plugin.valid(inst))||(COMPATIBILITY.type(options)==TYPES.f&&options(v,inst)))
arr.push(inst);else if(options===undefined)
arr.push(inst);});}
result=arr[LEXICON.l]===1?arr[0]:arr;}
return result;};_plugin.globals=function(){initOverlayScrollbarsStatics();var globals=FRAMEWORK.extend(true,{},_pluginsGlobals);delete globals['msie'];return globals;};_plugin.defaultOptions=function(newDefaultOptions){initOverlayScrollbarsStatics();var currDefaultOptions=_pluginsGlobals.defaultOptions;if(newDefaultOptions===undefined)
return FRAMEWORK.extend(true,{},currDefaultOptions);_pluginsGlobals.defaultOptions=FRAMEWORK.extend(true,{},currDefaultOptions,_pluginsOptions._validate(newDefaultOptions,_pluginsOptions._template,true,currDefaultOptions)._default);};_plugin.valid=function(osInstance){return osInstance instanceof _plugin&&!osInstance.getState().destroyed;};_plugin.extension=function(extensionName,extension,defaultOptions){var extNameTypeString=COMPATIBILITY.type(extensionName)==TYPES.s;var argLen=arguments[LEXICON.l];var i=0;if(argLen<1||!extNameTypeString){return FRAMEWORK.extend(true,{length:_pluginsExtensions[LEXICON.l]},_pluginsExtensions);}
else if(extNameTypeString){if(COMPATIBILITY.type(extension)==TYPES.f){_pluginsExtensions.push({name:extensionName,extensionFactory:extension,defaultOptions:defaultOptions});}
else{for(;i<_pluginsExtensions[LEXICON.l];i++){if(_pluginsExtensions[i].name===extensionName){if(argLen>1)
_pluginsExtensions.splice(i,1);else
return FRAMEWORK.extend(true,{},_pluginsExtensions[i]);}}}}};return _plugin;})();if(JQUERY&&JQUERY.fn){JQUERY.fn.overlayScrollbars=function(options,extensions){var _elements=this;if(JQUERY.isPlainObject(options)){JQUERY.each(_elements,function(){PLUGIN(this,options,extensions);});return _elements;}
else
return PLUGIN(_elements,options);};}
return PLUGIN;}));/*!
 * AdminLTE v3.1.0 (https://adminlte.io)
 * Copyright 2014-2021 Colorlib <https://colorlib.com>
 * Licensed under MIT (https://github.com/ColorlibHQ/AdminLTE/blob/master/LICENSE)
 */
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?factory(exports,require('jquery')):typeof define==='function'&&define.amd?define(['exports','jquery'],factory):(global=typeof globalThis!=='undefined'?globalThis:global||self,factory(global.adminlte={},global.jQuery));}(this,(function(exports,$){'use strict';function _interopDefaultLegacy(e){return e&&typeof e==='object'&&'default'in e?e:{'default':e};}
var $__default=_interopDefaultLegacy($);var NAME$e='CardRefresh';var DATA_KEY$e='lte.cardrefresh';var EVENT_KEY$7="."+DATA_KEY$e;var JQUERY_NO_CONFLICT$e=$__default['default'].fn[NAME$e];var EVENT_LOADED="loaded"+EVENT_KEY$7;var EVENT_OVERLAY_ADDED="overlay.added"+EVENT_KEY$7;var EVENT_OVERLAY_REMOVED="overlay.removed"+EVENT_KEY$7;var CLASS_NAME_CARD$1='card';var SELECTOR_CARD$1="."+CLASS_NAME_CARD$1;var SELECTOR_DATA_REFRESH='[data-card-widget="card-refresh"]';var Default$c={source:'',sourceSelector:'',params:{},trigger:SELECTOR_DATA_REFRESH,content:'.card-body',loadInContent:true,loadOnInit:true,responseType:'',overlayTemplate:'<div class="overlay"><i class="fas fa-2x fa-sync-alt fa-spin"></i></div>',onLoadStart:function onLoadStart(){},onLoadDone:function onLoadDone(response){return response;}};var CardRefresh=function(){function CardRefresh(element,settings){this._element=element;this._parent=element.parents(SELECTOR_CARD$1).first();this._settings=$__default['default'].extend({},Default$c,settings);this._overlay=$__default['default'](this._settings.overlayTemplate);if(element.hasClass(CLASS_NAME_CARD$1)){this._parent=element;}
if(this._settings.source===''){throw new Error('Source url was not defined. Please specify a url in your CardRefresh source option.');}}
var _proto=CardRefresh.prototype;_proto.load=function load(){var _this=this;this._addOverlay();this._settings.onLoadStart.call($__default['default'](this));$__default['default'].get(this._settings.source,this._settings.params,function(response){if(_this._settings.loadInContent){if(_this._settings.sourceSelector!==''){response=$__default['default'](response).find(_this._settings.sourceSelector).html();}
_this._parent.find(_this._settings.content).html(response);}
_this._settings.onLoadDone.call($__default['default'](_this),response);_this._removeOverlay();},this._settings.responseType!==''&&this._settings.responseType);$__default['default'](this._element).trigger($__default['default'].Event(EVENT_LOADED));};_proto._addOverlay=function _addOverlay(){this._parent.append(this._overlay);$__default['default'](this._element).trigger($__default['default'].Event(EVENT_OVERLAY_ADDED));};_proto._removeOverlay=function _removeOverlay(){this._parent.find(this._overlay).remove();$__default['default'](this._element).trigger($__default['default'].Event(EVENT_OVERLAY_REMOVED));};_proto._init=function _init(){var _this2=this;$__default['default'](this).find(this._settings.trigger).on('click',function(){_this2.load();});if(this._settings.loadOnInit){this.load();}};CardRefresh._jQueryInterface=function _jQueryInterface(config){var data=$__default['default'](this).data(DATA_KEY$e);var _options=$__default['default'].extend({},Default$c,$__default['default'](this).data());if(!data){data=new CardRefresh($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY$e,typeof config==='string'?data:config);}
if(typeof config==='string'&&/load/.test(config)){data[config]();}else{data._init($__default['default'](this));}};return CardRefresh;}();$__default['default'](document).on('click',SELECTOR_DATA_REFRESH,function(event){if(event){event.preventDefault();}
CardRefresh._jQueryInterface.call($__default['default'](this),'load');});$__default['default'](function(){$__default['default'](SELECTOR_DATA_REFRESH).each(function(){CardRefresh._jQueryInterface.call($__default['default'](this));});});$__default['default'].fn[NAME$e]=CardRefresh._jQueryInterface;$__default['default'].fn[NAME$e].Constructor=CardRefresh;$__default['default'].fn[NAME$e].noConflict=function(){$__default['default'].fn[NAME$e]=JQUERY_NO_CONFLICT$e;return CardRefresh._jQueryInterface;};var NAME$d='CardWidget';var DATA_KEY$d='lte.cardwidget';var EVENT_KEY$6="."+DATA_KEY$d;var JQUERY_NO_CONFLICT$d=$__default['default'].fn[NAME$d];var EVENT_EXPANDED$3="expanded"+EVENT_KEY$6;var EVENT_COLLAPSED$4="collapsed"+EVENT_KEY$6;var EVENT_MAXIMIZED="maximized"+EVENT_KEY$6;var EVENT_MINIMIZED="minimized"+EVENT_KEY$6;var EVENT_REMOVED$1="removed"+EVENT_KEY$6;var CLASS_NAME_CARD='card';var CLASS_NAME_COLLAPSED$1='collapsed-card';var CLASS_NAME_COLLAPSING='collapsing-card';var CLASS_NAME_EXPANDING='expanding-card';var CLASS_NAME_WAS_COLLAPSED='was-collapsed';var CLASS_NAME_MAXIMIZED='maximized-card';var SELECTOR_DATA_REMOVE='[data-card-widget="remove"]';var SELECTOR_DATA_COLLAPSE='[data-card-widget="collapse"]';var SELECTOR_DATA_MAXIMIZE='[data-card-widget="maximize"]';var SELECTOR_CARD="."+CLASS_NAME_CARD;var SELECTOR_CARD_HEADER='.card-header';var SELECTOR_CARD_BODY='.card-body';var SELECTOR_CARD_FOOTER='.card-footer';var Default$b={animationSpeed:'normal',collapseTrigger:SELECTOR_DATA_COLLAPSE,removeTrigger:SELECTOR_DATA_REMOVE,maximizeTrigger:SELECTOR_DATA_MAXIMIZE,collapseIcon:'fa-minus',expandIcon:'fa-plus',maximizeIcon:'fa-expand',minimizeIcon:'fa-compress'};var CardWidget=function(){function CardWidget(element,settings){this._element=element;this._parent=element.parents(SELECTOR_CARD).first();if(element.hasClass(CLASS_NAME_CARD)){this._parent=element;}
this._settings=$__default['default'].extend({},Default$b,settings);}
var _proto=CardWidget.prototype;_proto.collapse=function collapse(){var _this=this;this._parent.addClass(CLASS_NAME_COLLAPSING).children(SELECTOR_CARD_BODY+", "+SELECTOR_CARD_FOOTER).slideUp(this._settings.animationSpeed,function(){_this._parent.addClass(CLASS_NAME_COLLAPSED$1).removeClass(CLASS_NAME_COLLAPSING);});this._parent.find("> "+SELECTOR_CARD_HEADER+" "+this._settings.collapseTrigger+" ."+this._settings.collapseIcon).addClass(this._settings.expandIcon).removeClass(this._settings.collapseIcon);this._element.trigger($__default['default'].Event(EVENT_COLLAPSED$4),this._parent);};_proto.expand=function expand(){var _this2=this;this._parent.addClass(CLASS_NAME_EXPANDING).children(SELECTOR_CARD_BODY+", "+SELECTOR_CARD_FOOTER).slideDown(this._settings.animationSpeed,function(){_this2._parent.removeClass(CLASS_NAME_COLLAPSED$1).removeClass(CLASS_NAME_EXPANDING);});this._parent.find("> "+SELECTOR_CARD_HEADER+" "+this._settings.collapseTrigger+" ."+this._settings.expandIcon).addClass(this._settings.collapseIcon).removeClass(this._settings.expandIcon);this._element.trigger($__default['default'].Event(EVENT_EXPANDED$3),this._parent);};_proto.remove=function remove(){this._parent.slideUp();this._element.trigger($__default['default'].Event(EVENT_REMOVED$1),this._parent);};_proto.toggle=function toggle(){if(this._parent.hasClass(CLASS_NAME_COLLAPSED$1)){this.expand();return;}
this.collapse();};_proto.maximize=function maximize(){this._parent.find(this._settings.maximizeTrigger+" ."+this._settings.maximizeIcon).addClass(this._settings.minimizeIcon).removeClass(this._settings.maximizeIcon);this._parent.css({height:this._parent.height(),width:this._parent.width(),transition:'all .15s'}).delay(150).queue(function(){var $element=$__default['default'](this);$element.addClass(CLASS_NAME_MAXIMIZED);$__default['default']('html').addClass(CLASS_NAME_MAXIMIZED);if($element.hasClass(CLASS_NAME_COLLAPSED$1)){$element.addClass(CLASS_NAME_WAS_COLLAPSED);}
$element.dequeue();});this._element.trigger($__default['default'].Event(EVENT_MAXIMIZED),this._parent);};_proto.minimize=function minimize(){this._parent.find(this._settings.maximizeTrigger+" ."+this._settings.minimizeIcon).addClass(this._settings.maximizeIcon).removeClass(this._settings.minimizeIcon);this._parent.css('cssText',"height: "+this._parent[0].style.height+" !important; width: "+this._parent[0].style.width+" !important; transition: all .15s;").delay(10).queue(function(){var $element=$__default['default'](this);$element.removeClass(CLASS_NAME_MAXIMIZED);$__default['default']('html').removeClass(CLASS_NAME_MAXIMIZED);$element.css({height:'inherit',width:'inherit'});if($element.hasClass(CLASS_NAME_WAS_COLLAPSED)){$element.removeClass(CLASS_NAME_WAS_COLLAPSED);}
$element.dequeue();});this._element.trigger($__default['default'].Event(EVENT_MINIMIZED),this._parent);};_proto.toggleMaximize=function toggleMaximize(){if(this._parent.hasClass(CLASS_NAME_MAXIMIZED)){this.minimize();return;}
this.maximize();};_proto._init=function _init(card){var _this3=this;this._parent=card;$__default['default'](this).find(this._settings.collapseTrigger).click(function(){_this3.toggle();});$__default['default'](this).find(this._settings.maximizeTrigger).click(function(){_this3.toggleMaximize();});$__default['default'](this).find(this._settings.removeTrigger).click(function(){_this3.remove();});};CardWidget._jQueryInterface=function _jQueryInterface(config){var data=$__default['default'](this).data(DATA_KEY$d);var _options=$__default['default'].extend({},Default$b,$__default['default'](this).data());if(!data){data=new CardWidget($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY$d,typeof config==='string'?data:config);}
if(typeof config==='string'&&/collapse|expand|remove|toggle|maximize|minimize|toggleMaximize/.test(config)){data[config]();}else if(typeof config==='object'){data._init($__default['default'](this));}};return CardWidget;}();$__default['default'](document).on('click',SELECTOR_DATA_COLLAPSE,function(event){if(event){event.preventDefault();}
CardWidget._jQueryInterface.call($__default['default'](this),'toggle');});$__default['default'](document).on('click',SELECTOR_DATA_REMOVE,function(event){if(event){event.preventDefault();}
CardWidget._jQueryInterface.call($__default['default'](this),'remove');});$__default['default'](document).on('click',SELECTOR_DATA_MAXIMIZE,function(event){if(event){event.preventDefault();}
CardWidget._jQueryInterface.call($__default['default'](this),'toggleMaximize');});$__default['default'].fn[NAME$d]=CardWidget._jQueryInterface;$__default['default'].fn[NAME$d].Constructor=CardWidget;$__default['default'].fn[NAME$d].noConflict=function(){$__default['default'].fn[NAME$d]=JQUERY_NO_CONFLICT$d;return CardWidget._jQueryInterface;};var NAME$c='ControlSidebar';var DATA_KEY$c='lte.controlsidebar';var EVENT_KEY$5="."+DATA_KEY$c;var JQUERY_NO_CONFLICT$c=$__default['default'].fn[NAME$c];var EVENT_COLLAPSED$3="collapsed"+EVENT_KEY$5;var EVENT_EXPANDED$2="expanded"+EVENT_KEY$5;var SELECTOR_CONTROL_SIDEBAR='.control-sidebar';var SELECTOR_CONTROL_SIDEBAR_CONTENT$1='.control-sidebar-content';var SELECTOR_DATA_TOGGLE$4='[data-widget="control-sidebar"]';var SELECTOR_HEADER$1='.main-header';var SELECTOR_FOOTER$1='.main-footer';var CLASS_NAME_CONTROL_SIDEBAR_ANIMATE='control-sidebar-animate';var CLASS_NAME_CONTROL_SIDEBAR_OPEN$1='control-sidebar-open';var CLASS_NAME_CONTROL_SIDEBAR_SLIDE='control-sidebar-slide-open';var CLASS_NAME_LAYOUT_FIXED$1='layout-fixed';var CLASS_NAME_NAVBAR_FIXED='layout-navbar-fixed';var CLASS_NAME_NAVBAR_SM_FIXED='layout-sm-navbar-fixed';var CLASS_NAME_NAVBAR_MD_FIXED='layout-md-navbar-fixed';var CLASS_NAME_NAVBAR_LG_FIXED='layout-lg-navbar-fixed';var CLASS_NAME_NAVBAR_XL_FIXED='layout-xl-navbar-fixed';var CLASS_NAME_FOOTER_FIXED='layout-footer-fixed';var CLASS_NAME_FOOTER_SM_FIXED='layout-sm-footer-fixed';var CLASS_NAME_FOOTER_MD_FIXED='layout-md-footer-fixed';var CLASS_NAME_FOOTER_LG_FIXED='layout-lg-footer-fixed';var CLASS_NAME_FOOTER_XL_FIXED='layout-xl-footer-fixed';var Default$a={controlsidebarSlide:true,scrollbarTheme:'os-theme-light',scrollbarAutoHide:'l',target:SELECTOR_CONTROL_SIDEBAR};var ControlSidebar=function(){function ControlSidebar(element,config){this._element=element;this._config=config;}
var _proto=ControlSidebar.prototype;_proto.collapse=function collapse(){var $body=$__default['default']('body');var $html=$__default['default']('html');var target=this._config.target;if(this._config.controlsidebarSlide){$html.addClass(CLASS_NAME_CONTROL_SIDEBAR_ANIMATE);$body.removeClass(CLASS_NAME_CONTROL_SIDEBAR_SLIDE).delay(300).queue(function(){$__default['default'](target).hide();$html.removeClass(CLASS_NAME_CONTROL_SIDEBAR_ANIMATE);$__default['default'](this).dequeue();});}else{$body.removeClass(CLASS_NAME_CONTROL_SIDEBAR_OPEN$1);}
$__default['default'](this._element).trigger($__default['default'].Event(EVENT_COLLAPSED$3));};_proto.show=function show(){var $body=$__default['default']('body');var $html=$__default['default']('html');if(this._config.controlsidebarSlide){$html.addClass(CLASS_NAME_CONTROL_SIDEBAR_ANIMATE);$__default['default'](this._config.target).show().delay(10).queue(function(){$body.addClass(CLASS_NAME_CONTROL_SIDEBAR_SLIDE).delay(300).queue(function(){$html.removeClass(CLASS_NAME_CONTROL_SIDEBAR_ANIMATE);$__default['default'](this).dequeue();});$__default['default'](this).dequeue();});}else{$body.addClass(CLASS_NAME_CONTROL_SIDEBAR_OPEN$1);}
this._fixHeight();this._fixScrollHeight();$__default['default'](this._element).trigger($__default['default'].Event(EVENT_EXPANDED$2));};_proto.toggle=function toggle(){var $body=$__default['default']('body');var shouldClose=$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_OPEN$1)||$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_SLIDE);if(shouldClose){this.collapse();}else{this.show();}};_proto._init=function _init(){var _this=this;var $body=$__default['default']('body');var shouldNotHideAll=$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_OPEN$1)||$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_SLIDE);if(shouldNotHideAll){$__default['default'](SELECTOR_CONTROL_SIDEBAR).not(this._config.target).hide();$__default['default'](this._config.target).css('display','block');}else{$__default['default'](SELECTOR_CONTROL_SIDEBAR).hide();}
this._fixHeight();this._fixScrollHeight();$__default['default'](window).resize(function(){_this._fixHeight();_this._fixScrollHeight();});$__default['default'](window).scroll(function(){var $body=$__default['default']('body');var shouldFixHeight=$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_OPEN$1)||$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_SLIDE);if(shouldFixHeight){_this._fixScrollHeight();}});};_proto._isNavbarFixed=function _isNavbarFixed(){var $body=$__default['default']('body');return $body.hasClass(CLASS_NAME_NAVBAR_FIXED)||$body.hasClass(CLASS_NAME_NAVBAR_SM_FIXED)||$body.hasClass(CLASS_NAME_NAVBAR_MD_FIXED)||$body.hasClass(CLASS_NAME_NAVBAR_LG_FIXED)||$body.hasClass(CLASS_NAME_NAVBAR_XL_FIXED);};_proto._isFooterFixed=function _isFooterFixed(){var $body=$__default['default']('body');return $body.hasClass(CLASS_NAME_FOOTER_FIXED)||$body.hasClass(CLASS_NAME_FOOTER_SM_FIXED)||$body.hasClass(CLASS_NAME_FOOTER_MD_FIXED)||$body.hasClass(CLASS_NAME_FOOTER_LG_FIXED)||$body.hasClass(CLASS_NAME_FOOTER_XL_FIXED);};_proto._fixScrollHeight=function _fixScrollHeight(){var $body=$__default['default']('body');var $controlSidebar=$__default['default'](this._config.target);if(!$body.hasClass(CLASS_NAME_LAYOUT_FIXED$1)){return;}
var heights={scroll:$__default['default'](document).height(),window:$__default['default'](window).height(),header:$__default['default'](SELECTOR_HEADER$1).outerHeight(),footer:$__default['default'](SELECTOR_FOOTER$1).outerHeight()};var positions={bottom:Math.abs(heights.window+$__default['default'](window).scrollTop()-heights.scroll),top:$__default['default'](window).scrollTop()};var navbarFixed=this._isNavbarFixed()&&$__default['default'](SELECTOR_HEADER$1).css('position')==='fixed';var footerFixed=this._isFooterFixed()&&$__default['default'](SELECTOR_FOOTER$1).css('position')==='fixed';var $controlsidebarContent=$__default['default'](this._config.target+", "+this._config.target+" "+SELECTOR_CONTROL_SIDEBAR_CONTENT$1);if(positions.top===0&&positions.bottom===0){$controlSidebar.css({bottom:heights.footer,top:heights.header});$controlsidebarContent.css('height',heights.window-(heights.header+heights.footer));}else if(positions.bottom<=heights.footer){if(footerFixed===false){var top=heights.header-positions.top;$controlSidebar.css('bottom',heights.footer-positions.bottom).css('top',top>=0?top:0);$controlsidebarContent.css('height',heights.window-(heights.footer-positions.bottom));}else{$controlSidebar.css('bottom',heights.footer);}}else if(positions.top<=heights.header){if(navbarFixed===false){$controlSidebar.css('top',heights.header-positions.top);$controlsidebarContent.css('height',heights.window-(heights.header-positions.top));}else{$controlSidebar.css('top',heights.header);}}else if(navbarFixed===false){$controlSidebar.css('top',0);$controlsidebarContent.css('height',heights.window);}else{$controlSidebar.css('top',heights.header);}
if(footerFixed&&navbarFixed){$controlsidebarContent.css('height','100%');$controlSidebar.css('height','');}else if(footerFixed||navbarFixed){$controlsidebarContent.css('height','100%');$controlsidebarContent.css('height','');}};_proto._fixHeight=function _fixHeight(){var $body=$__default['default']('body');var $controlSidebar=$__default['default'](this._config.target+" "+SELECTOR_CONTROL_SIDEBAR_CONTENT$1);if(!$body.hasClass(CLASS_NAME_LAYOUT_FIXED$1)){$controlSidebar.attr('style','');return;}
var heights={window:$__default['default'](window).height(),header:$__default['default'](SELECTOR_HEADER$1).outerHeight(),footer:$__default['default'](SELECTOR_FOOTER$1).outerHeight()};var sidebarHeight=heights.window-heights.header;if(this._isFooterFixed()&&$__default['default'](SELECTOR_FOOTER$1).css('position')==='fixed'){sidebarHeight=heights.window-heights.header-heights.footer;}
$controlSidebar.css('height',sidebarHeight);if(typeof $__default['default'].fn.overlayScrollbars!=='undefined'){$controlSidebar.overlayScrollbars({className:this._config.scrollbarTheme,sizeAutoCapable:true,scrollbars:{autoHide:this._config.scrollbarAutoHide,clickScrolling:true}});}};ControlSidebar._jQueryInterface=function _jQueryInterface(operation){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$c);var _options=$__default['default'].extend({},Default$a,$__default['default'](this).data());if(!data){data=new ControlSidebar(this,_options);$__default['default'](this).data(DATA_KEY$c,data);}
if(data[operation]==='undefined'){throw new Error(operation+" is not a function");}
data[operation]();});};return ControlSidebar;}();$__default['default'](document).on('click',SELECTOR_DATA_TOGGLE$4,function(event){event.preventDefault();ControlSidebar._jQueryInterface.call($__default['default'](this),'toggle');});$__default['default'](document).ready(function(){ControlSidebar._jQueryInterface.call($__default['default'](SELECTOR_DATA_TOGGLE$4),'_init');});$__default['default'].fn[NAME$c]=ControlSidebar._jQueryInterface;$__default['default'].fn[NAME$c].Constructor=ControlSidebar;$__default['default'].fn[NAME$c].noConflict=function(){$__default['default'].fn[NAME$c]=JQUERY_NO_CONFLICT$c;return ControlSidebar._jQueryInterface;};var NAME$b='DirectChat';var DATA_KEY$b='lte.directchat';var EVENT_KEY$4="."+DATA_KEY$b;var JQUERY_NO_CONFLICT$b=$__default['default'].fn[NAME$b];var EVENT_TOGGLED="toggled"+EVENT_KEY$4;var SELECTOR_DATA_TOGGLE$3='[data-widget="chat-pane-toggle"]';var SELECTOR_DIRECT_CHAT='.direct-chat';var CLASS_NAME_DIRECT_CHAT_OPEN='direct-chat-contacts-open';var DirectChat=function(){function DirectChat(element){this._element=element;}
var _proto=DirectChat.prototype;_proto.toggle=function toggle(){$__default['default'](this._element).parents(SELECTOR_DIRECT_CHAT).first().toggleClass(CLASS_NAME_DIRECT_CHAT_OPEN);$__default['default'](this._element).trigger($__default['default'].Event(EVENT_TOGGLED));};DirectChat._jQueryInterface=function _jQueryInterface(config){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$b);if(!data){data=new DirectChat($__default['default'](this));$__default['default'](this).data(DATA_KEY$b,data);}
data[config]();});};return DirectChat;}();$__default['default'](document).on('click',SELECTOR_DATA_TOGGLE$3,function(event){if(event){event.preventDefault();}
DirectChat._jQueryInterface.call($__default['default'](this),'toggle');});$__default['default'].fn[NAME$b]=DirectChat._jQueryInterface;$__default['default'].fn[NAME$b].Constructor=DirectChat;$__default['default'].fn[NAME$b].noConflict=function(){$__default['default'].fn[NAME$b]=JQUERY_NO_CONFLICT$b;return DirectChat._jQueryInterface;};var NAME$a='Dropdown';var DATA_KEY$a='lte.dropdown';var JQUERY_NO_CONFLICT$a=$__default['default'].fn[NAME$a];var SELECTOR_NAVBAR='.navbar';var SELECTOR_DROPDOWN_MENU='.dropdown-menu';var SELECTOR_DROPDOWN_MENU_ACTIVE='.dropdown-menu.show';var SELECTOR_DROPDOWN_TOGGLE='[data-toggle="dropdown"]';var CLASS_NAME_DROPDOWN_RIGHT='dropdown-menu-right';var CLASS_NAME_DROPDOWN_SUBMENU='dropdown-submenu';var Default$9={};var Dropdown=function(){function Dropdown(element,config){this._config=config;this._element=element;}
var _proto=Dropdown.prototype;_proto.toggleSubmenu=function toggleSubmenu(){this._element.siblings().show().toggleClass('show');if(!this._element.next().hasClass('show')){this._element.parents(SELECTOR_DROPDOWN_MENU).first().find('.show').removeClass('show').hide();}
this._element.parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown',function(){$__default['default']('.dropdown-submenu .show').removeClass('show').hide();});};_proto.fixPosition=function fixPosition(){var $element=$__default['default'](SELECTOR_DROPDOWN_MENU_ACTIVE);if($element.length===0){return;}
if($element.hasClass(CLASS_NAME_DROPDOWN_RIGHT)){$element.css({left:'inherit',right:0});}else{$element.css({left:0,right:'inherit'});}
var offset=$element.offset();var width=$element.width();var visiblePart=$__default['default'](window).width()-offset.left;if(offset.left<0){$element.css({left:'inherit',right:offset.left-5});}else if(visiblePart<width){$element.css({left:'inherit',right:0});}};Dropdown._jQueryInterface=function _jQueryInterface(config){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$a);var _config=$__default['default'].extend({},Default$9,$__default['default'](this).data());if(!data){data=new Dropdown($__default['default'](this),_config);$__default['default'](this).data(DATA_KEY$a,data);}
if(config==='toggleSubmenu'||config==='fixPosition'){data[config]();}});};return Dropdown;}();$__default['default'](SELECTOR_DROPDOWN_MENU+" "+SELECTOR_DROPDOWN_TOGGLE).on('click',function(event){event.preventDefault();event.stopPropagation();Dropdown._jQueryInterface.call($__default['default'](this),'toggleSubmenu');});$__default['default'](SELECTOR_NAVBAR+" "+SELECTOR_DROPDOWN_TOGGLE).on('click',function(event){event.preventDefault();if($__default['default'](event.target).parent().hasClass(CLASS_NAME_DROPDOWN_SUBMENU)){return;}
setTimeout(function(){Dropdown._jQueryInterface.call($__default['default'](this),'fixPosition');},1);});$__default['default'].fn[NAME$a]=Dropdown._jQueryInterface;$__default['default'].fn[NAME$a].Constructor=Dropdown;$__default['default'].fn[NAME$a].noConflict=function(){$__default['default'].fn[NAME$a]=JQUERY_NO_CONFLICT$a;return Dropdown._jQueryInterface;};var NAME$9='ExpandableTable';var DATA_KEY$9='lte.expandableTable';var EVENT_KEY$3="."+DATA_KEY$9;var JQUERY_NO_CONFLICT$9=$__default['default'].fn[NAME$9];var EVENT_EXPANDED$1="expanded"+EVENT_KEY$3;var EVENT_COLLAPSED$2="collapsed"+EVENT_KEY$3;var SELECTOR_TABLE='.expandable-table';var SELECTOR_EXPANDABLE_BODY='.expandable-body';var SELECTOR_DATA_TOGGLE$2='[data-widget="expandable-table"]';var SELECTOR_ARIA_ATTR='aria-expanded';var ExpandableTable=function(){function ExpandableTable(element,options){this._options=options;this._element=element;}
var _proto=ExpandableTable.prototype;_proto.init=function init(){$__default['default'](SELECTOR_DATA_TOGGLE$2).each(function(_,$header){var $type=$__default['default']($header).attr(SELECTOR_ARIA_ATTR);var $body=$__default['default']($header).next(SELECTOR_EXPANDABLE_BODY).children().first().children();if($type==='true'){$body.show();}else if($type==='false'){$body.hide();$body.parent().parent().addClass('d-none');}});};_proto.toggleRow=function toggleRow(){var $element=this._element;var time=500;var $type=$element.attr(SELECTOR_ARIA_ATTR);var $body=$element.next(SELECTOR_EXPANDABLE_BODY).children().first().children();$body.stop();if($type==='true'){$body.slideUp(time,function(){$element.next(SELECTOR_EXPANDABLE_BODY).addClass('d-none');});$element.attr(SELECTOR_ARIA_ATTR,'false');$element.trigger($__default['default'].Event(EVENT_COLLAPSED$2));}else if($type==='false'){$element.next(SELECTOR_EXPANDABLE_BODY).removeClass('d-none');$body.slideDown(time);$element.attr(SELECTOR_ARIA_ATTR,'true');$element.trigger($__default['default'].Event(EVENT_EXPANDED$1));}};ExpandableTable._jQueryInterface=function _jQueryInterface(operation){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$9);if(!data){data=new ExpandableTable($__default['default'](this));$__default['default'](this).data(DATA_KEY$9,data);}
if(typeof operation==='string'&&/init|toggleRow/.test(operation)){data[operation]();}});};return ExpandableTable;}();$__default['default'](SELECTOR_TABLE).ready(function(){ExpandableTable._jQueryInterface.call($__default['default'](this),'init');});$__default['default'](document).on('click',SELECTOR_DATA_TOGGLE$2,function(){ExpandableTable._jQueryInterface.call($__default['default'](this),'toggleRow');});$__default['default'].fn[NAME$9]=ExpandableTable._jQueryInterface;$__default['default'].fn[NAME$9].Constructor=ExpandableTable;$__default['default'].fn[NAME$9].noConflict=function(){$__default['default'].fn[NAME$9]=JQUERY_NO_CONFLICT$9;return ExpandableTable._jQueryInterface;};var NAME$8='Fullscreen';var DATA_KEY$8='lte.fullscreen';var JQUERY_NO_CONFLICT$8=$__default['default'].fn[NAME$8];var SELECTOR_DATA_WIDGET$2='[data-widget="fullscreen"]';var SELECTOR_ICON=SELECTOR_DATA_WIDGET$2+" i";var Default$8={minimizeIcon:'fa-compress-arrows-alt',maximizeIcon:'fa-expand-arrows-alt'};var Fullscreen=function(){function Fullscreen(_element,_options){this.element=_element;this.options=$__default['default'].extend({},Default$8,_options);}
var _proto=Fullscreen.prototype;_proto.toggle=function toggle(){if(document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement){this.windowed();}else{this.fullscreen();}};_proto.fullscreen=function fullscreen(){if(document.documentElement.requestFullscreen){document.documentElement.requestFullscreen();}else if(document.documentElement.webkitRequestFullscreen){document.documentElement.webkitRequestFullscreen();}else if(document.documentElement.msRequestFullscreen){document.documentElement.msRequestFullscreen();}
$__default['default'](SELECTOR_ICON).removeClass(this.options.maximizeIcon).addClass(this.options.minimizeIcon);};_proto.windowed=function windowed(){if(document.exitFullscreen){document.exitFullscreen();}else if(document.webkitExitFullscreen){document.webkitExitFullscreen();}else if(document.msExitFullscreen){document.msExitFullscreen();}
$__default['default'](SELECTOR_ICON).removeClass(this.options.minimizeIcon).addClass(this.options.maximizeIcon);};Fullscreen._jQueryInterface=function _jQueryInterface(config){var data=$__default['default'](this).data(DATA_KEY$8);if(!data){data=$__default['default'](this).data();}
var _options=$__default['default'].extend({},Default$8,typeof config==='object'?config:data);var plugin=new Fullscreen($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY$8,typeof config==='object'?config:data);if(typeof config==='string'&&/toggle|fullscreen|windowed/.test(config)){plugin[config]();}else{plugin.init();}};return Fullscreen;}();$__default['default'](document).on('click',SELECTOR_DATA_WIDGET$2,function(){Fullscreen._jQueryInterface.call($__default['default'](this),'toggle');});$__default['default'].fn[NAME$8]=Fullscreen._jQueryInterface;$__default['default'].fn[NAME$8].Constructor=Fullscreen;$__default['default'].fn[NAME$8].noConflict=function(){$__default['default'].fn[NAME$8]=JQUERY_NO_CONFLICT$8;return Fullscreen._jQueryInterface;};var NAME$7='IFrame';var DATA_KEY$7='lte.iframe';var JQUERY_NO_CONFLICT$7=$__default['default'].fn[NAME$7];var SELECTOR_DATA_TOGGLE$1='[data-widget="iframe"]';var SELECTOR_DATA_TOGGLE_CLOSE='[data-widget="iframe-close"]';var SELECTOR_DATA_TOGGLE_SCROLL_LEFT='[data-widget="iframe-scrollleft"]';var SELECTOR_DATA_TOGGLE_SCROLL_RIGHT='[data-widget="iframe-scrollright"]';var SELECTOR_DATA_TOGGLE_FULLSCREEN='[data-widget="iframe-fullscreen"]';var SELECTOR_CONTENT_WRAPPER='.content-wrapper';var SELECTOR_CONTENT_IFRAME=SELECTOR_CONTENT_WRAPPER+" iframe";var SELECTOR_TAB_NAV=SELECTOR_DATA_TOGGLE$1+".iframe-mode .nav";var SELECTOR_TAB_NAVBAR_NAV=SELECTOR_DATA_TOGGLE$1+".iframe-mode .navbar-nav";var SELECTOR_TAB_NAVBAR_NAV_ITEM=SELECTOR_TAB_NAVBAR_NAV+" .nav-item";var SELECTOR_TAB_NAVBAR_NAV_LINK=SELECTOR_TAB_NAVBAR_NAV+" .nav-link";var SELECTOR_TAB_CONTENT=SELECTOR_DATA_TOGGLE$1+".iframe-mode .tab-content";var SELECTOR_TAB_EMPTY=SELECTOR_TAB_CONTENT+" .tab-empty";var SELECTOR_TAB_LOADING=SELECTOR_TAB_CONTENT+" .tab-loading";var SELECTOR_TAB_PANE=SELECTOR_TAB_CONTENT+" .tab-pane";var SELECTOR_SIDEBAR_MENU_ITEM='.main-sidebar .nav-item > a.nav-link';var SELECTOR_SIDEBAR_SEARCH_ITEM='.sidebar-search-results .list-group-item';var SELECTOR_HEADER_MENU_ITEM='.main-header .nav-item a.nav-link';var SELECTOR_HEADER_DROPDOWN_ITEM='.main-header a.dropdown-item';var CLASS_NAME_IFRAME_MODE='iframe-mode';var CLASS_NAME_FULLSCREEN_MODE='iframe-mode-fullscreen';var Default$7={onTabClick:function onTabClick(item){return item;},onTabChanged:function onTabChanged(item){return item;},onTabCreated:function onTabCreated(item){return item;},autoIframeMode:true,autoItemActive:true,autoShowNewTab:true,allowDuplicates:false,loadingScreen:true,useNavbarItems:true,scrollOffset:40,scrollBehaviorSwap:false,iconMaximize:'fa-expand',iconMinimize:'fa-compress'};var IFrame=function(){function IFrame(element,config){this._config=config;this._element=element;this._init();}
var _proto=IFrame.prototype;_proto.onTabClick=function onTabClick(item){this._config.onTabClick(item);};_proto.onTabChanged=function onTabChanged(item){this._config.onTabChanged(item);};_proto.onTabCreated=function onTabCreated(item){this._config.onTabCreated(item);};_proto.createTab=function createTab(title,link,uniqueName,autoOpen){var _this=this;var tabId="panel-"+uniqueName;var navId="tab-"+uniqueName;if(this._config.allowDuplicates){tabId+="-"+Math.floor(Math.random()*1000);navId+="-"+Math.floor(Math.random()*1000);}
var newNavItem="<li class=\"nav-item\" role=\"presentation\"><a href=\"#\" class=\"btn-iframe-close\" data-widget=\"iframe-close\" data-type=\"only-this\"><i class=\"fas fa-times\"></i></a><a class=\"nav-link\" data-toggle=\"row\" id=\""+navId+"\" href=\"#"+tabId+"\" role=\"tab\" aria-controls=\""+tabId+"\" aria-selected=\"false\">"+title+"</a></li>";$__default['default'](SELECTOR_TAB_NAVBAR_NAV).append(unescape(escape(newNavItem)));var newTabItem="<div class=\"tab-pane fade\" id=\""+tabId+"\" role=\"tabpanel\" aria-labelledby=\""+navId+"\"><iframe src=\""+link+"\"></iframe></div>";$__default['default'](SELECTOR_TAB_CONTENT).append(unescape(escape(newTabItem)));if(autoOpen){if(this._config.loadingScreen){var $loadingScreen=$__default['default'](SELECTOR_TAB_LOADING);$loadingScreen.fadeIn();$__default['default'](tabId+" iframe").ready(function(){if(typeof _this._config.loadingScreen==='number'){_this.switchTab("#"+navId);setTimeout(function(){$loadingScreen.fadeOut();},_this._config.loadingScreen);}else{_this.switchTab("#"+navId);$loadingScreen.fadeOut();}});}else{this.switchTab("#"+navId);}}
this.onTabCreated($__default['default']("#"+navId));};_proto.openTabSidebar=function openTabSidebar(item,autoOpen){if(autoOpen===void 0){autoOpen=this._config.autoShowNewTab;}
var $item=$__default['default'](item).clone();if($item.attr('href')===undefined){$item=$__default['default'](item).parent('a').clone();}
$item.find('.right, .search-path').remove();var title=$item.find('p').text();if(title===''){title=$item.text();}
var link=$item.attr('href');if(link==='#'||link===''||link===undefined){return;}
var uniqueName=link.replace('./','').replace(/["&'./:=?[\]]/gi,'-').replace(/(--)/gi,'');var navId="tab-"+uniqueName;if(!this._config.allowDuplicates&&$__default['default']("#"+navId).length>0){return this.switchTab("#"+navId);}
if(!this._config.allowDuplicates&&$__default['default']("#"+navId).length===0||this._config.allowDuplicates){this.createTab(title,link,uniqueName,autoOpen);}};_proto.switchTab=function switchTab(item){var $item=$__default['default'](item);var tabId=$item.attr('href');$__default['default'](SELECTOR_TAB_EMPTY).hide();$__default['default'](SELECTOR_TAB_NAVBAR_NAV+" .active").tab('dispose').removeClass('active');this._fixHeight();$item.tab('show');$item.parents('li').addClass('active');this.onTabChanged($item);if(this._config.autoItemActive){this._setItemActive($__default['default'](tabId+" iframe").attr('src'));}};_proto.removeActiveTab=function removeActiveTab(type,element){if(type=='all'){$__default['default'](SELECTOR_TAB_NAVBAR_NAV_ITEM).remove();$__default['default'](SELECTOR_TAB_PANE).remove();$__default['default'](SELECTOR_TAB_EMPTY).show();}else if(type=='all-other'){$__default['default'](SELECTOR_TAB_NAVBAR_NAV_ITEM+":not(.active)").remove();$__default['default'](SELECTOR_TAB_PANE+":not(.active)").remove();}else if(type=='only-this'){var $navClose=$__default['default'](element);var $navItem=$navClose.parent('.nav-item');var $navItemParent=$navItem.parent();var navItemIndex=$navItem.index();var tabId=$navClose.siblings('.nav-link').attr('aria-controls');$navItem.remove();$__default['default']("#"+tabId).remove();if($__default['default'](SELECTOR_TAB_CONTENT).children().length==$__default['default'](SELECTOR_TAB_EMPTY+", "+SELECTOR_TAB_LOADING).length){$__default['default'](SELECTOR_TAB_EMPTY).show();}else{var prevNavItemIndex=navItemIndex-1;this.switchTab($navItemParent.children().eq(prevNavItemIndex).find('a.nav-link'));}}else{var _$navItem=$__default['default'](SELECTOR_TAB_NAVBAR_NAV_ITEM+".active");var _$navItemParent=_$navItem.parent();var _navItemIndex=_$navItem.index();_$navItem.remove();$__default['default'](SELECTOR_TAB_PANE+".active").remove();if($__default['default'](SELECTOR_TAB_CONTENT).children().length==$__default['default'](SELECTOR_TAB_EMPTY+", "+SELECTOR_TAB_LOADING).length){$__default['default'](SELECTOR_TAB_EMPTY).show();}else{var _prevNavItemIndex=_navItemIndex-1;this.switchTab(_$navItemParent.children().eq(_prevNavItemIndex).find('a.nav-link'));}}};_proto.toggleFullscreen=function toggleFullscreen(){if($__default['default']('body').hasClass(CLASS_NAME_FULLSCREEN_MODE)){$__default['default'](SELECTOR_DATA_TOGGLE_FULLSCREEN+" i").removeClass(this._config.iconMinimize).addClass(this._config.iconMaximize);$__default['default']('body').removeClass(CLASS_NAME_FULLSCREEN_MODE);$__default['default'](SELECTOR_TAB_EMPTY+", "+SELECTOR_TAB_LOADING).height('auto');$__default['default'](SELECTOR_CONTENT_WRAPPER).height('auto');$__default['default'](SELECTOR_CONTENT_IFRAME).height('auto');}else{$__default['default'](SELECTOR_DATA_TOGGLE_FULLSCREEN+" i").removeClass(this._config.iconMaximize).addClass(this._config.iconMinimize);$__default['default']('body').addClass(CLASS_NAME_FULLSCREEN_MODE);}
$__default['default'](window).trigger('resize');this._fixHeight(true);};_proto._init=function _init(){if(window.frameElement&&this._config.autoIframeMode){$__default['default']('body').addClass(CLASS_NAME_IFRAME_MODE);}else if($__default['default'](SELECTOR_CONTENT_WRAPPER).hasClass(CLASS_NAME_IFRAME_MODE)){if($__default['default'](SELECTOR_TAB_CONTENT).children().length>2){var $el=$__default['default'](SELECTOR_TAB_PANE+":first-child");$el.show();this._setItemActive($el.find('iframe').attr('src'));}
this._setupListeners();this._fixHeight(true);}};_proto._navScroll=function _navScroll(offset){var leftPos=$__default['default'](SELECTOR_TAB_NAVBAR_NAV).scrollLeft();$__default['default'](SELECTOR_TAB_NAVBAR_NAV).animate({scrollLeft:leftPos+offset},250,'linear');};_proto._setupListeners=function _setupListeners(){var _this2=this;$__default['default'](window).on('resize',function(){setTimeout(function(){_this2._fixHeight();},1);});$__default['default'](document).on('click',SELECTOR_SIDEBAR_MENU_ITEM+", "+SELECTOR_SIDEBAR_SEARCH_ITEM,function(e){e.preventDefault();_this2.openTabSidebar(e.target);});if(this._config.useNavbarItems){$__default['default'](document).on('click',SELECTOR_HEADER_MENU_ITEM+", "+SELECTOR_HEADER_DROPDOWN_ITEM,function(e){e.preventDefault();_this2.openTabSidebar(e.target);});}
$__default['default'](document).on('click',SELECTOR_TAB_NAVBAR_NAV_LINK,function(e){e.preventDefault();_this2.onTabClick(e.target);_this2.switchTab(e.target);});$__default['default'](document).on('click',SELECTOR_TAB_NAVBAR_NAV_LINK,function(e){e.preventDefault();_this2.onTabClick(e.target);_this2.switchTab(e.target);});$__default['default'](document).on('click',SELECTOR_DATA_TOGGLE_CLOSE,function(e){e.preventDefault();var target=e.target;if(target.nodeName=='I'){target=e.target.offsetParent;}
_this2.removeActiveTab(target.attributes['data-type']?target.attributes['data-type'].nodeValue:null,target);});$__default['default'](document).on('click',SELECTOR_DATA_TOGGLE_FULLSCREEN,function(e){e.preventDefault();_this2.toggleFullscreen();});var mousedown=false;var mousedownInterval=null;$__default['default'](document).on('mousedown',SELECTOR_DATA_TOGGLE_SCROLL_LEFT,function(e){e.preventDefault();clearInterval(mousedownInterval);var scrollOffset=_this2._config.scrollOffset;if(!_this2._config.scrollBehaviorSwap){scrollOffset=-scrollOffset;}
mousedown=true;_this2._navScroll(scrollOffset);mousedownInterval=setInterval(function(){_this2._navScroll(scrollOffset);},250);});$__default['default'](document).on('mousedown',SELECTOR_DATA_TOGGLE_SCROLL_RIGHT,function(e){e.preventDefault();clearInterval(mousedownInterval);var scrollOffset=_this2._config.scrollOffset;if(_this2._config.scrollBehaviorSwap){scrollOffset=-scrollOffset;}
mousedown=true;_this2._navScroll(scrollOffset);mousedownInterval=setInterval(function(){_this2._navScroll(scrollOffset);},250);});$__default['default'](document).on('mouseup',function(){if(mousedown){mousedown=false;clearInterval(mousedownInterval);mousedownInterval=null;}});};_proto._setItemActive=function _setItemActive(href){$__default['default'](SELECTOR_SIDEBAR_MENU_ITEM+", "+SELECTOR_HEADER_DROPDOWN_ITEM).removeClass('active');$__default['default'](SELECTOR_HEADER_MENU_ITEM).parent().removeClass('active');var $headerMenuItem=$__default['default'](SELECTOR_HEADER_MENU_ITEM+"[href$=\""+href+"\"]");var $headerDropdownItem=$__default['default'](SELECTOR_HEADER_DROPDOWN_ITEM+"[href$=\""+href+"\"]");var $sidebarMenuItem=$__default['default'](SELECTOR_SIDEBAR_MENU_ITEM+"[href$=\""+href+"\"]");$headerMenuItem.each(function(i,e){$__default['default'](e).parent().addClass('active');});$headerDropdownItem.each(function(i,e){$__default['default'](e).addClass('active');});$sidebarMenuItem.each(function(i,e){$__default['default'](e).addClass('active');$__default['default'](e).parents('.nav-treeview').prevAll('.nav-link').addClass('active');});};_proto._fixHeight=function _fixHeight(tabEmpty){if(tabEmpty===void 0){tabEmpty=false;}
if($__default['default']('body').hasClass(CLASS_NAME_FULLSCREEN_MODE)){var windowHeight=$__default['default'](window).height();var navbarHeight=$__default['default'](SELECTOR_TAB_NAV).outerHeight();$__default['default'](SELECTOR_TAB_EMPTY+", "+SELECTOR_TAB_LOADING+", "+SELECTOR_CONTENT_IFRAME).height(windowHeight-navbarHeight);$__default['default'](SELECTOR_CONTENT_WRAPPER).height(windowHeight);}else{var contentWrapperHeight=parseFloat($__default['default'](SELECTOR_CONTENT_WRAPPER).css('height'));var _navbarHeight=$__default['default'](SELECTOR_TAB_NAV).outerHeight();if(tabEmpty==true){setTimeout(function(){$__default['default'](SELECTOR_TAB_EMPTY+", "+SELECTOR_TAB_LOADING).height(contentWrapperHeight-_navbarHeight);},50);}else{$__default['default'](SELECTOR_CONTENT_IFRAME).height(contentWrapperHeight-_navbarHeight);}}};IFrame._jQueryInterface=function _jQueryInterface(operation){var data=$__default['default'](this).data(DATA_KEY$7);var _options=$__default['default'].extend({},Default$7,$__default['default'](this).data());if(!data){data=new IFrame(this,_options);$__default['default'](this).data(DATA_KEY$7,data);}
if(typeof operation==='string'&&/createTab|openTabSidebar|switchTab|removeActiveTab/.test(operation)){var _data;for(var _len=arguments.length,args=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key];}
(_data=data)[operation].apply(_data,args);}};return IFrame;}();$__default['default'](window).on('load',function(){IFrame._jQueryInterface.call($__default['default'](SELECTOR_DATA_TOGGLE$1));});$__default['default'].fn[NAME$7]=IFrame._jQueryInterface;$__default['default'].fn[NAME$7].Constructor=IFrame;$__default['default'].fn[NAME$7].noConflict=function(){$__default['default'].fn[NAME$7]=JQUERY_NO_CONFLICT$7;return IFrame._jQueryInterface;};var NAME$6='Layout';var DATA_KEY$6='lte.layout';var JQUERY_NO_CONFLICT$6=$__default['default'].fn[NAME$6];var SELECTOR_HEADER='.main-header';var SELECTOR_MAIN_SIDEBAR='.main-sidebar';var SELECTOR_SIDEBAR$1='.main-sidebar .sidebar';var SELECTOR_CONTENT='.content-wrapper';var SELECTOR_CONTROL_SIDEBAR_CONTENT='.control-sidebar-content';var SELECTOR_CONTROL_SIDEBAR_BTN='[data-widget="control-sidebar"]';var SELECTOR_FOOTER='.main-footer';var SELECTOR_PUSHMENU_BTN='[data-widget="pushmenu"]';var SELECTOR_LOGIN_BOX='.login-box';var SELECTOR_REGISTER_BOX='.register-box';var SELECTOR_PRELOADER='.preloader';var CLASS_NAME_SIDEBAR_COLLAPSED$1='sidebar-collapse';var CLASS_NAME_SIDEBAR_FOCUSED='sidebar-focused';var CLASS_NAME_LAYOUT_FIXED='layout-fixed';var CLASS_NAME_CONTROL_SIDEBAR_SLIDE_OPEN='control-sidebar-slide-open';var CLASS_NAME_CONTROL_SIDEBAR_OPEN='control-sidebar-open';var Default$6={scrollbarTheme:'os-theme-light',scrollbarAutoHide:'l',panelAutoHeight:true,panelAutoHeightMode:'min-height',preloadDuration:200,loginRegisterAutoHeight:true};var Layout=function(){function Layout(element,config){this._config=config;this._element=element;}
var _proto=Layout.prototype;_proto.fixLayoutHeight=function fixLayoutHeight(extra){if(extra===void 0){extra=null;}
var $body=$__default['default']('body');var controlSidebar=0;if($body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_SLIDE_OPEN)||$body.hasClass(CLASS_NAME_CONTROL_SIDEBAR_OPEN)||extra==='control_sidebar'){controlSidebar=$__default['default'](SELECTOR_CONTROL_SIDEBAR_CONTENT).outerHeight();}
var heights={window:$__default['default'](window).height(),header:$__default['default'](SELECTOR_HEADER).length>0?$__default['default'](SELECTOR_HEADER).outerHeight():0,footer:$__default['default'](SELECTOR_FOOTER).length>0?$__default['default'](SELECTOR_FOOTER).outerHeight():0,sidebar:$__default['default'](SELECTOR_SIDEBAR$1).length>0?$__default['default'](SELECTOR_SIDEBAR$1).height():0,controlSidebar:controlSidebar};var max=this._max(heights);var offset=this._config.panelAutoHeight;if(offset===true){offset=0;}
var $contentSelector=$__default['default'](SELECTOR_CONTENT);if(offset!==false){if(max===heights.controlSidebar){$contentSelector.css(this._config.panelAutoHeightMode,max+offset);}else if(max===heights.window){$contentSelector.css(this._config.panelAutoHeightMode,max+offset-heights.header-heights.footer);}else{$contentSelector.css(this._config.panelAutoHeightMode,max+offset-heights.header);}
if(this._isFooterFixed()){$contentSelector.css(this._config.panelAutoHeightMode,parseFloat($contentSelector.css(this._config.panelAutoHeightMode))+heights.footer);}}
if(!$body.hasClass(CLASS_NAME_LAYOUT_FIXED)){return;}
if(typeof $__default['default'].fn.overlayScrollbars!=='undefined'){$__default['default'](SELECTOR_SIDEBAR$1).overlayScrollbars({className:this._config.scrollbarTheme,sizeAutoCapable:true,scrollbars:{autoHide:this._config.scrollbarAutoHide,clickScrolling:true}});}else{$__default['default'](SELECTOR_SIDEBAR$1).css('overflow-y','auto');}};_proto.fixLoginRegisterHeight=function fixLoginRegisterHeight(){var $body=$__default['default']('body');var $selector=$__default['default'](SELECTOR_LOGIN_BOX+", "+SELECTOR_REGISTER_BOX);if($selector.length===0){$body.css('height','auto');$__default['default']('html').css('height','auto');}else{var boxHeight=$selector.height();if($body.css(this._config.panelAutoHeightMode)!==boxHeight){$body.css(this._config.panelAutoHeightMode,boxHeight);}}};_proto._init=function _init(){var _this=this;this.fixLayoutHeight();if(this._config.loginRegisterAutoHeight===true){this.fixLoginRegisterHeight();}else if(this._config.loginRegisterAutoHeight===parseInt(this._config.loginRegisterAutoHeight,10)){setInterval(this.fixLoginRegisterHeight,this._config.loginRegisterAutoHeight);}
$__default['default'](SELECTOR_SIDEBAR$1).on('collapsed.lte.treeview expanded.lte.treeview',function(){_this.fixLayoutHeight();});$__default['default'](SELECTOR_MAIN_SIDEBAR).on('mouseenter mouseleave',function(){if($__default['default']('body').hasClass(CLASS_NAME_SIDEBAR_COLLAPSED$1)){_this.fixLayoutHeight();}});$__default['default'](SELECTOR_PUSHMENU_BTN).on('collapsed.lte.pushmenu shown.lte.pushmenu',function(){setTimeout(function(){_this.fixLayoutHeight();},300);});$__default['default'](SELECTOR_CONTROL_SIDEBAR_BTN).on('collapsed.lte.controlsidebar',function(){_this.fixLayoutHeight();}).on('expanded.lte.controlsidebar',function(){_this.fixLayoutHeight('control_sidebar');});$__default['default'](window).resize(function(){_this.fixLayoutHeight();});setTimeout(function(){$__default['default']('body.hold-transition').removeClass('hold-transition');},50);setTimeout(function(){var $preloader=$__default['default'](SELECTOR_PRELOADER);if($preloader){$preloader.css('height',0);setTimeout(function(){$preloader.children().hide();},200);}},this._config.preloadDuration);};_proto._max=function _max(numbers){var max=0;Object.keys(numbers).forEach(function(key){if(numbers[key]>max){max=numbers[key];}});return max;};_proto._isFooterFixed=function _isFooterFixed(){return $__default['default'](SELECTOR_FOOTER).css('position')==='fixed';};Layout._jQueryInterface=function _jQueryInterface(config){if(config===void 0){config='';}
return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$6);var _options=$__default['default'].extend({},Default$6,$__default['default'](this).data());if(!data){data=new Layout($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY$6,data);}
if(config==='init'||config===''){data._init();}else if(config==='fixLayoutHeight'||config==='fixLoginRegisterHeight'){data[config]();}});};return Layout;}();$__default['default'](window).on('load',function(){Layout._jQueryInterface.call($__default['default']('body'));});$__default['default'](SELECTOR_SIDEBAR$1+" a").on('focusin',function(){$__default['default'](SELECTOR_MAIN_SIDEBAR).addClass(CLASS_NAME_SIDEBAR_FOCUSED);}).on('focusout',function(){$__default['default'](SELECTOR_MAIN_SIDEBAR).removeClass(CLASS_NAME_SIDEBAR_FOCUSED);});$__default['default'].fn[NAME$6]=Layout._jQueryInterface;$__default['default'].fn[NAME$6].Constructor=Layout;$__default['default'].fn[NAME$6].noConflict=function(){$__default['default'].fn[NAME$6]=JQUERY_NO_CONFLICT$6;return Layout._jQueryInterface;};var NAME$5='PushMenu';var DATA_KEY$5='lte.pushmenu';var EVENT_KEY$2="."+DATA_KEY$5;var JQUERY_NO_CONFLICT$5=$__default['default'].fn[NAME$5];var EVENT_COLLAPSED$1="collapsed"+EVENT_KEY$2;var EVENT_SHOWN="shown"+EVENT_KEY$2;var SELECTOR_TOGGLE_BUTTON$1='[data-widget="pushmenu"]';var SELECTOR_BODY='body';var SELECTOR_OVERLAY='#sidebar-overlay';var SELECTOR_WRAPPER='.wrapper';var CLASS_NAME_COLLAPSED='sidebar-collapse';var CLASS_NAME_OPEN$3='sidebar-open';var CLASS_NAME_IS_OPENING$1='sidebar-is-opening';var CLASS_NAME_CLOSED='sidebar-closed';var Default$5={autoCollapseSize:992,enableRemember:false,noTransitionAfterReload:true};var PushMenu=function(){function PushMenu(element,options){this._element=element;this._options=$__default['default'].extend({},Default$5,options);if($__default['default'](SELECTOR_OVERLAY).length===0){this._addOverlay();}
this._init();}
var _proto=PushMenu.prototype;_proto.expand=function expand(){var $bodySelector=$__default['default'](SELECTOR_BODY);if(this._options.autoCollapseSize&&$__default['default'](window).width()<=this._options.autoCollapseSize){$bodySelector.addClass(CLASS_NAME_OPEN$3);}
$bodySelector.addClass(CLASS_NAME_IS_OPENING$1).removeClass(CLASS_NAME_COLLAPSED+" "+CLASS_NAME_CLOSED).delay(50).queue(function(){$bodySelector.removeClass(CLASS_NAME_IS_OPENING$1);$__default['default'](this).dequeue();});if(this._options.enableRemember){localStorage.setItem("remember"+EVENT_KEY$2,CLASS_NAME_OPEN$3);}
$__default['default'](this._element).trigger($__default['default'].Event(EVENT_SHOWN));};_proto.collapse=function collapse(){var $bodySelector=$__default['default'](SELECTOR_BODY);if(this._options.autoCollapseSize&&$__default['default'](window).width()<=this._options.autoCollapseSize){$bodySelector.removeClass(CLASS_NAME_OPEN$3).addClass(CLASS_NAME_CLOSED);}
$bodySelector.addClass(CLASS_NAME_COLLAPSED);if(this._options.enableRemember){localStorage.setItem("remember"+EVENT_KEY$2,CLASS_NAME_COLLAPSED);}
$__default['default'](this._element).trigger($__default['default'].Event(EVENT_COLLAPSED$1));};_proto.toggle=function toggle(){if($__default['default'](SELECTOR_BODY).hasClass(CLASS_NAME_COLLAPSED)){this.expand();}else{this.collapse();}};_proto.autoCollapse=function autoCollapse(resize){if(resize===void 0){resize=false;}
if(!this._options.autoCollapseSize){return;}
var $bodySelector=$__default['default'](SELECTOR_BODY);if($__default['default'](window).width()<=this._options.autoCollapseSize){if(!$bodySelector.hasClass(CLASS_NAME_OPEN$3)){this.collapse();}}else if(resize===true){if($bodySelector.hasClass(CLASS_NAME_OPEN$3)){$bodySelector.removeClass(CLASS_NAME_OPEN$3);}else if($bodySelector.hasClass(CLASS_NAME_CLOSED)){this.expand();}}};_proto.remember=function remember(){if(!this._options.enableRemember){return;}
var $body=$__default['default']('body');var toggleState=localStorage.getItem("remember"+EVENT_KEY$2);if(toggleState===CLASS_NAME_COLLAPSED){if(this._options.noTransitionAfterReload){$body.addClass('hold-transition').addClass(CLASS_NAME_COLLAPSED).delay(50).queue(function(){$__default['default'](this).removeClass('hold-transition');$__default['default'](this).dequeue();});}else{$body.addClass(CLASS_NAME_COLLAPSED);}}else if(this._options.noTransitionAfterReload){$body.addClass('hold-transition').removeClass(CLASS_NAME_COLLAPSED).delay(50).queue(function(){$__default['default'](this).removeClass('hold-transition');$__default['default'](this).dequeue();});}else{$body.removeClass(CLASS_NAME_COLLAPSED);}};_proto._init=function _init(){var _this=this;this.remember();this.autoCollapse();$__default['default'](window).resize(function(){_this.autoCollapse(true);});};_proto._addOverlay=function _addOverlay(){var _this2=this;var overlay=$__default['default']('<div />',{id:'sidebar-overlay'});overlay.on('click',function(){_this2.collapse();});$__default['default'](SELECTOR_WRAPPER).append(overlay);};PushMenu._jQueryInterface=function _jQueryInterface(operation){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$5);var _options=$__default['default'].extend({},Default$5,$__default['default'](this).data());if(!data){data=new PushMenu(this,_options);$__default['default'](this).data(DATA_KEY$5,data);}
if(typeof operation==='string'&&/collapse|expand|toggle/.test(operation)){data[operation]();}});};return PushMenu;}();$__default['default'](document).on('click',SELECTOR_TOGGLE_BUTTON$1,function(event){event.preventDefault();var button=event.currentTarget;if($__default['default'](button).data('widget')!=='pushmenu'){button=$__default['default'](button).closest(SELECTOR_TOGGLE_BUTTON$1);}
PushMenu._jQueryInterface.call($__default['default'](button),'toggle');});$__default['default'](window).on('load',function(){PushMenu._jQueryInterface.call($__default['default'](SELECTOR_TOGGLE_BUTTON$1));});$__default['default'].fn[NAME$5]=PushMenu._jQueryInterface;$__default['default'].fn[NAME$5].Constructor=PushMenu;$__default['default'].fn[NAME$5].noConflict=function(){$__default['default'].fn[NAME$5]=JQUERY_NO_CONFLICT$5;return PushMenu._jQueryInterface;};var NAME$4='SidebarSearch';var DATA_KEY$4='lte.sidebar-search';var JQUERY_NO_CONFLICT$4=$__default['default'].fn[NAME$4];var CLASS_NAME_OPEN$2='sidebar-search-open';var CLASS_NAME_ICON_SEARCH='fa-search';var CLASS_NAME_ICON_CLOSE='fa-times';var CLASS_NAME_HEADER='nav-header';var CLASS_NAME_SEARCH_RESULTS='sidebar-search-results';var CLASS_NAME_LIST_GROUP='list-group';var SELECTOR_DATA_WIDGET$1='[data-widget="sidebar-search"]';var SELECTOR_SIDEBAR='.main-sidebar .nav-sidebar';var SELECTOR_NAV_LINK='.nav-link';var SELECTOR_NAV_TREEVIEW='.nav-treeview';var SELECTOR_SEARCH_INPUT$1=SELECTOR_DATA_WIDGET$1+" .form-control";var SELECTOR_SEARCH_BUTTON=SELECTOR_DATA_WIDGET$1+" .btn";var SELECTOR_SEARCH_ICON=SELECTOR_SEARCH_BUTTON+" i";var SELECTOR_SEARCH_LIST_GROUP="."+CLASS_NAME_LIST_GROUP;var SELECTOR_SEARCH_RESULTS="."+CLASS_NAME_SEARCH_RESULTS;var SELECTOR_SEARCH_RESULTS_GROUP=SELECTOR_SEARCH_RESULTS+" ."+CLASS_NAME_LIST_GROUP;var Default$4={arrowSign:'->',minLength:3,maxResults:7,highlightName:true,highlightPath:false,highlightClass:'text-light',notFoundText:'No element found!'};var SearchItems=[];var SidebarSearch=function(){function SidebarSearch(_element,_options){this.element=_element;this.options=$__default['default'].extend({},Default$4,_options);this.items=[];}
var _proto=SidebarSearch.prototype;_proto.init=function init(){var _this=this;if($__default['default'](SELECTOR_DATA_WIDGET$1).length===0){return;}
if($__default['default'](SELECTOR_DATA_WIDGET$1).next(SELECTOR_SEARCH_RESULTS).length===0){$__default['default'](SELECTOR_DATA_WIDGET$1).after($__default['default']('<div />',{class:CLASS_NAME_SEARCH_RESULTS}));}
if($__default['default'](SELECTOR_SEARCH_RESULTS).children(SELECTOR_SEARCH_LIST_GROUP).length===0){$__default['default'](SELECTOR_SEARCH_RESULTS).append($__default['default']('<div />',{class:CLASS_NAME_LIST_GROUP}));}
this._addNotFound();$__default['default'](SELECTOR_SIDEBAR).children().each(function(i,child){_this._parseItem(child);});};_proto.search=function search(){var _this2=this;var searchValue=$__default['default'](SELECTOR_SEARCH_INPUT$1).val().toLowerCase();if(searchValue.length<this.options.minLength){$__default['default'](SELECTOR_SEARCH_RESULTS_GROUP).empty();this._addNotFound();this.close();return;}
var searchResults=SearchItems.filter(function(item){return item.name.toLowerCase().includes(searchValue);});var endResults=$__default['default'](searchResults.slice(0,this.options.maxResults));$__default['default'](SELECTOR_SEARCH_RESULTS_GROUP).empty();if(endResults.length===0){this._addNotFound();}else{endResults.each(function(i,result){$__default['default'](SELECTOR_SEARCH_RESULTS_GROUP).append(_this2._renderItem(escape(result.name),escape(result.link),result.path));});}
this.open();};_proto.open=function open(){$__default['default'](SELECTOR_DATA_WIDGET$1).parent().addClass(CLASS_NAME_OPEN$2);$__default['default'](SELECTOR_SEARCH_ICON).removeClass(CLASS_NAME_ICON_SEARCH).addClass(CLASS_NAME_ICON_CLOSE);};_proto.close=function close(){$__default['default'](SELECTOR_DATA_WIDGET$1).parent().removeClass(CLASS_NAME_OPEN$2);$__default['default'](SELECTOR_SEARCH_ICON).removeClass(CLASS_NAME_ICON_CLOSE).addClass(CLASS_NAME_ICON_SEARCH);};_proto.toggle=function toggle(){if($__default['default'](SELECTOR_DATA_WIDGET$1).parent().hasClass(CLASS_NAME_OPEN$2)){this.close();}else{this.open();}};_proto._parseItem=function _parseItem(item,path){var _this3=this;if(path===void 0){path=[];}
if($__default['default'](item).hasClass(CLASS_NAME_HEADER)){return;}
var itemObject={};var navLink=$__default['default'](item).clone().find("> "+SELECTOR_NAV_LINK);var navTreeview=$__default['default'](item).clone().find("> "+SELECTOR_NAV_TREEVIEW);var link=navLink.attr('href');var name=navLink.find('p').children().remove().end().text();itemObject.name=this._trimText(name);itemObject.link=link;itemObject.path=path;if(navTreeview.length===0){SearchItems.push(itemObject);}else{var newPath=itemObject.path.concat([itemObject.name]);navTreeview.children().each(function(i,child){_this3._parseItem(child,newPath);});}};_proto._trimText=function _trimText(text){return $.trim(text.replace(/(\r\n|\n|\r)/gm,' '));};_proto._renderItem=function _renderItem(name,link,path){var _this4=this;path=path.join(" "+this.options.arrowSign+" ");name=unescape(name);if(this.options.highlightName||this.options.highlightPath){var searchValue=$__default['default'](SELECTOR_SEARCH_INPUT$1).val().toLowerCase();var regExp=new RegExp(searchValue,'gi');if(this.options.highlightName){name=name.replace(regExp,function(str){return"<strong class=\""+_this4.options.highlightClass+"\">"+str+"</strong>";});}
if(this.options.highlightPath){path=path.replace(regExp,function(str){return"<strong class=\""+_this4.options.highlightClass+"\">"+str+"</strong>";});}}
var groupItemElement=$__default['default']('<a/>',{href:link,class:'list-group-item'});var searchTitleElement=$__default['default']('<div/>',{class:'search-title'}).html(name);var searchPathElement=$__default['default']('<div/>',{class:'search-path'}).html(path);groupItemElement.append(searchTitleElement).append(searchPathElement);return groupItemElement;};_proto._addNotFound=function _addNotFound(){$__default['default'](SELECTOR_SEARCH_RESULTS_GROUP).append(this._renderItem(this.options.notFoundText,'#',[]));};SidebarSearch._jQueryInterface=function _jQueryInterface(config){var data=$__default['default'](this).data(DATA_KEY$4);if(!data){data=$__default['default'](this).data();}
var _options=$__default['default'].extend({},Default$4,typeof config==='object'?config:data);var plugin=new SidebarSearch($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY$4,typeof config==='object'?config:data);if(typeof config==='string'&&/init|toggle|close|open|search/.test(config)){plugin[config]();}else{plugin.init();}};return SidebarSearch;}();$__default['default'](document).on('click',SELECTOR_SEARCH_BUTTON,function(event){event.preventDefault();SidebarSearch._jQueryInterface.call($__default['default'](SELECTOR_DATA_WIDGET$1),'toggle');});$__default['default'](document).on('keyup',SELECTOR_SEARCH_INPUT$1,function(event){if(event.keyCode==38){event.preventDefault();$__default['default'](SELECTOR_SEARCH_RESULTS_GROUP).children().last().focus();return;}
if(event.keyCode==40){event.preventDefault();$__default['default'](SELECTOR_SEARCH_RESULTS_GROUP).children().first().focus();return;}
setTimeout(function(){SidebarSearch._jQueryInterface.call($__default['default'](SELECTOR_DATA_WIDGET$1),'search');},100);});$__default['default'](document).on('keydown',SELECTOR_SEARCH_RESULTS_GROUP,function(event){var $focused=$__default['default'](':focus');if(event.keyCode==38){event.preventDefault();if($focused.is(':first-child')){$focused.siblings().last().focus();}else{$focused.prev().focus();}}
if(event.keyCode==40){event.preventDefault();if($focused.is(':last-child')){$focused.siblings().first().focus();}else{$focused.next().focus();}}});$__default['default'](window).on('load',function(){SidebarSearch._jQueryInterface.call($__default['default'](SELECTOR_DATA_WIDGET$1),'init');});$__default['default'].fn[NAME$4]=SidebarSearch._jQueryInterface;$__default['default'].fn[NAME$4].Constructor=SidebarSearch;$__default['default'].fn[NAME$4].noConflict=function(){$__default['default'].fn[NAME$4]=JQUERY_NO_CONFLICT$4;return SidebarSearch._jQueryInterface;};var NAME$3='NavbarSearch';var DATA_KEY$3='lte.navbar-search';var JQUERY_NO_CONFLICT$3=$__default['default'].fn[NAME$3];var SELECTOR_TOGGLE_BUTTON='[data-widget="navbar-search"]';var SELECTOR_SEARCH_BLOCK='.navbar-search-block';var SELECTOR_SEARCH_INPUT='.form-control';var CLASS_NAME_OPEN$1='navbar-search-open';var Default$3={resetOnClose:true,target:SELECTOR_SEARCH_BLOCK};var NavbarSearch=function(){function NavbarSearch(_element,_options){this._element=_element;this._config=$__default['default'].extend({},Default$3,_options);}
var _proto=NavbarSearch.prototype;_proto.open=function open(){$__default['default'](this._config.target).css('display','flex').hide().fadeIn().addClass(CLASS_NAME_OPEN$1);$__default['default'](this._config.target+" "+SELECTOR_SEARCH_INPUT).focus();};_proto.close=function close(){$__default['default'](this._config.target).fadeOut().removeClass(CLASS_NAME_OPEN$1);if(this._config.resetOnClose){$__default['default'](this._config.target+" "+SELECTOR_SEARCH_INPUT).val('');}};_proto.toggle=function toggle(){if($__default['default'](this._config.target).hasClass(CLASS_NAME_OPEN$1)){this.close();}else{this.open();}};NavbarSearch._jQueryInterface=function _jQueryInterface(options){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$3);var _options=$__default['default'].extend({},Default$3,$__default['default'](this).data());if(!data){data=new NavbarSearch(this,_options);$__default['default'](this).data(DATA_KEY$3,data);}
if(!/toggle|close|open/.test(options)){throw new Error("Undefined method "+options);}
data[options]();});};return NavbarSearch;}();$__default['default'](document).on('click',SELECTOR_TOGGLE_BUTTON,function(event){event.preventDefault();var button=$__default['default'](event.currentTarget);if(button.data('widget')!=='navbar-search'){button=button.closest(SELECTOR_TOGGLE_BUTTON);}
NavbarSearch._jQueryInterface.call(button,'toggle');});$__default['default'].fn[NAME$3]=NavbarSearch._jQueryInterface;$__default['default'].fn[NAME$3].Constructor=NavbarSearch;$__default['default'].fn[NAME$3].noConflict=function(){$__default['default'].fn[NAME$3]=JQUERY_NO_CONFLICT$3;return NavbarSearch._jQueryInterface;};var NAME$2='Toasts';var DATA_KEY$2='lte.toasts';var EVENT_KEY$1="."+DATA_KEY$2;var JQUERY_NO_CONFLICT$2=$__default['default'].fn[NAME$2];var EVENT_INIT="init"+EVENT_KEY$1;var EVENT_CREATED="created"+EVENT_KEY$1;var EVENT_REMOVED="removed"+EVENT_KEY$1;var SELECTOR_CONTAINER_TOP_RIGHT='#toastsContainerTopRight';var SELECTOR_CONTAINER_TOP_LEFT='#toastsContainerTopLeft';var SELECTOR_CONTAINER_BOTTOM_RIGHT='#toastsContainerBottomRight';var SELECTOR_CONTAINER_BOTTOM_LEFT='#toastsContainerBottomLeft';var CLASS_NAME_TOP_RIGHT='toasts-top-right';var CLASS_NAME_TOP_LEFT='toasts-top-left';var CLASS_NAME_BOTTOM_RIGHT='toasts-bottom-right';var CLASS_NAME_BOTTOM_LEFT='toasts-bottom-left';var POSITION_TOP_RIGHT='topRight';var POSITION_TOP_LEFT='topLeft';var POSITION_BOTTOM_RIGHT='bottomRight';var POSITION_BOTTOM_LEFT='bottomLeft';var Default$2={position:POSITION_TOP_RIGHT,fixed:true,autohide:false,autoremove:true,delay:1000,fade:true,icon:null,image:null,imageAlt:null,imageHeight:'25px',title:null,subtitle:null,close:true,body:null,class:null};var Toasts=function(){function Toasts(element,config){this._config=config;this._prepareContainer();$__default['default']('body').trigger($__default['default'].Event(EVENT_INIT));}
var _proto=Toasts.prototype;_proto.create=function create(){var toast=$__default['default']('<div class="toast" role="alert" aria-live="assertive" aria-atomic="true"/>');toast.data('autohide',this._config.autohide);toast.data('animation',this._config.fade);if(this._config.class){toast.addClass(this._config.class);}
if(this._config.delay&&this._config.delay!=500){toast.data('delay',this._config.delay);}
var toastHeader=$__default['default']('<div class="toast-header">');if(this._config.image!=null){var toastImage=$__default['default']('<img />').addClass('rounded mr-2').attr('src',this._config.image).attr('alt',this._config.imageAlt);if(this._config.imageHeight!=null){toastImage.height(this._config.imageHeight).width('auto');}
toastHeader.append(toastImage);}
if(this._config.icon!=null){toastHeader.append($__default['default']('<i />').addClass('mr-2').addClass(this._config.icon));}
if(this._config.title!=null){toastHeader.append($__default['default']('<strong />').addClass('mr-auto').html(this._config.title));}
if(this._config.subtitle!=null){toastHeader.append($__default['default']('<small />').html(this._config.subtitle));}
if(this._config.close==true){var toastClose=$__default['default']('<button data-dismiss="toast" />').attr('type','button').addClass('ml-2 mb-1 close').attr('aria-label','Close').append('<span aria-hidden="true">&times;</span>');if(this._config.title==null){toastClose.toggleClass('ml-2 ml-auto');}
toastHeader.append(toastClose);}
toast.append(toastHeader);if(this._config.body!=null){toast.append($__default['default']('<div class="toast-body" />').html(this._config.body));}
$__default['default'](this._getContainerId()).prepend(toast);var $body=$__default['default']('body');$body.trigger($__default['default'].Event(EVENT_CREATED));toast.toast('show');if(this._config.autoremove){toast.on('hidden.bs.toast',function(){$__default['default'](this).delay(200).remove();$body.trigger($__default['default'].Event(EVENT_REMOVED));});}};_proto._getContainerId=function _getContainerId(){if(this._config.position==POSITION_TOP_RIGHT){return SELECTOR_CONTAINER_TOP_RIGHT;}
if(this._config.position==POSITION_TOP_LEFT){return SELECTOR_CONTAINER_TOP_LEFT;}
if(this._config.position==POSITION_BOTTOM_RIGHT){return SELECTOR_CONTAINER_BOTTOM_RIGHT;}
if(this._config.position==POSITION_BOTTOM_LEFT){return SELECTOR_CONTAINER_BOTTOM_LEFT;}};_proto._prepareContainer=function _prepareContainer(){if($__default['default'](this._getContainerId()).length===0){var container=$__default['default']('<div />').attr('id',this._getContainerId().replace('#',''));if(this._config.position==POSITION_TOP_RIGHT){container.addClass(CLASS_NAME_TOP_RIGHT);}else if(this._config.position==POSITION_TOP_LEFT){container.addClass(CLASS_NAME_TOP_LEFT);}else if(this._config.position==POSITION_BOTTOM_RIGHT){container.addClass(CLASS_NAME_BOTTOM_RIGHT);}else if(this._config.position==POSITION_BOTTOM_LEFT){container.addClass(CLASS_NAME_BOTTOM_LEFT);}
$__default['default']('body').append(container);}
if(this._config.fixed){$__default['default'](this._getContainerId()).addClass('fixed');}else{$__default['default'](this._getContainerId()).removeClass('fixed');}};Toasts._jQueryInterface=function _jQueryInterface(option,config){return this.each(function(){var _options=$__default['default'].extend({},Default$2,config);var toast=new Toasts($__default['default'](this),_options);if(option==='create'){toast[option]();}});};return Toasts;}();$__default['default'].fn[NAME$2]=Toasts._jQueryInterface;$__default['default'].fn[NAME$2].Constructor=Toasts;$__default['default'].fn[NAME$2].noConflict=function(){$__default['default'].fn[NAME$2]=JQUERY_NO_CONFLICT$2;return Toasts._jQueryInterface;};var NAME$1='TodoList';var DATA_KEY$1='lte.todolist';var JQUERY_NO_CONFLICT$1=$__default['default'].fn[NAME$1];var SELECTOR_DATA_TOGGLE='[data-widget="todo-list"]';var CLASS_NAME_TODO_LIST_DONE='done';var Default$1={onCheck:function onCheck(item){return item;},onUnCheck:function onUnCheck(item){return item;}};var TodoList=function(){function TodoList(element,config){this._config=config;this._element=element;this._init();}
var _proto=TodoList.prototype;_proto.toggle=function toggle(item){item.parents('li').toggleClass(CLASS_NAME_TODO_LIST_DONE);if(!$__default['default'](item).prop('checked')){this.unCheck($__default['default'](item));return;}
this.check(item);};_proto.check=function check(item){this._config.onCheck.call(item);};_proto.unCheck=function unCheck(item){this._config.onUnCheck.call(item);};_proto._init=function _init(){var _this=this;var $toggleSelector=this._element;$toggleSelector.find('input:checkbox:checked').parents('li').toggleClass(CLASS_NAME_TODO_LIST_DONE);$toggleSelector.on('change','input:checkbox',function(event){_this.toggle($__default['default'](event.target));});};TodoList._jQueryInterface=function _jQueryInterface(config){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY$1);if(!data){data=$__default['default'](this).data();}
var _options=$__default['default'].extend({},Default$1,typeof config==='object'?config:data);var plugin=new TodoList($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY$1,typeof config==='object'?config:data);if(config==='init'){plugin[config]();}});};return TodoList;}();$__default['default'](window).on('load',function(){TodoList._jQueryInterface.call($__default['default'](SELECTOR_DATA_TOGGLE));});$__default['default'].fn[NAME$1]=TodoList._jQueryInterface;$__default['default'].fn[NAME$1].Constructor=TodoList;$__default['default'].fn[NAME$1].noConflict=function(){$__default['default'].fn[NAME$1]=JQUERY_NO_CONFLICT$1;return TodoList._jQueryInterface;};var NAME='Treeview';var DATA_KEY='lte.treeview';var EVENT_KEY="."+DATA_KEY;var JQUERY_NO_CONFLICT=$__default['default'].fn[NAME];var EVENT_EXPANDED="expanded"+EVENT_KEY;var EVENT_COLLAPSED="collapsed"+EVENT_KEY;var EVENT_LOAD_DATA_API="load"+EVENT_KEY;var SELECTOR_LI='.nav-item';var SELECTOR_LINK='.nav-link';var SELECTOR_TREEVIEW_MENU='.nav-treeview';var SELECTOR_OPEN='.menu-open';var SELECTOR_DATA_WIDGET='[data-widget="treeview"]';var CLASS_NAME_OPEN='menu-open';var CLASS_NAME_IS_OPENING='menu-is-opening';var CLASS_NAME_SIDEBAR_COLLAPSED='sidebar-collapse';var Default={trigger:SELECTOR_DATA_WIDGET+" "+SELECTOR_LINK,animationSpeed:300,accordion:true,expandSidebar:false,sidebarButtonSelector:'[data-widget="pushmenu"]'};var Treeview=function(){function Treeview(element,config){this._config=config;this._element=element;}
var _proto=Treeview.prototype;_proto.init=function init(){$__default['default'](""+SELECTOR_LI+SELECTOR_OPEN+" "+SELECTOR_TREEVIEW_MENU+SELECTOR_OPEN).css('display','block');this._setupListeners();};_proto.expand=function expand(treeviewMenu,parentLi){var _this=this;var expandedEvent=$__default['default'].Event(EVENT_EXPANDED);if(this._config.accordion){var openMenuLi=parentLi.siblings(SELECTOR_OPEN).first();var openTreeview=openMenuLi.find(SELECTOR_TREEVIEW_MENU).first();this.collapse(openTreeview,openMenuLi);}
parentLi.addClass(CLASS_NAME_IS_OPENING);treeviewMenu.stop().slideDown(this._config.animationSpeed,function(){parentLi.addClass(CLASS_NAME_OPEN);$__default['default'](_this._element).trigger(expandedEvent);});if(this._config.expandSidebar){this._expandSidebar();}};_proto.collapse=function collapse(treeviewMenu,parentLi){var _this2=this;var collapsedEvent=$__default['default'].Event(EVENT_COLLAPSED);parentLi.removeClass(CLASS_NAME_IS_OPENING+" "+CLASS_NAME_OPEN);treeviewMenu.stop().slideUp(this._config.animationSpeed,function(){$__default['default'](_this2._element).trigger(collapsedEvent);treeviewMenu.find(SELECTOR_OPEN+" > "+SELECTOR_TREEVIEW_MENU).slideUp();treeviewMenu.find(SELECTOR_OPEN).removeClass(CLASS_NAME_OPEN);});};_proto.toggle=function toggle(event){var $relativeTarget=$__default['default'](event.currentTarget);var $parent=$relativeTarget.parent();var treeviewMenu=$parent.find("> "+SELECTOR_TREEVIEW_MENU);if(!treeviewMenu.is(SELECTOR_TREEVIEW_MENU)){if(!$parent.is(SELECTOR_LI)){treeviewMenu=$parent.parent().find("> "+SELECTOR_TREEVIEW_MENU);}
if(!treeviewMenu.is(SELECTOR_TREEVIEW_MENU)){return;}}
event.preventDefault();var parentLi=$relativeTarget.parents(SELECTOR_LI).first();var isOpen=parentLi.hasClass(CLASS_NAME_OPEN);if(isOpen){this.collapse($__default['default'](treeviewMenu),parentLi);}else{this.expand($__default['default'](treeviewMenu),parentLi);}};_proto._setupListeners=function _setupListeners(){var _this3=this;var elementId=this._element.attr('id')!==undefined?"#"+this._element.attr('id'):'';$__default['default'](document).on('click',""+elementId+this._config.trigger,function(event){_this3.toggle(event);});};_proto._expandSidebar=function _expandSidebar(){if($__default['default']('body').hasClass(CLASS_NAME_SIDEBAR_COLLAPSED)){$__default['default'](this._config.sidebarButtonSelector).PushMenu('expand');}};Treeview._jQueryInterface=function _jQueryInterface(config){return this.each(function(){var data=$__default['default'](this).data(DATA_KEY);var _options=$__default['default'].extend({},Default,$__default['default'](this).data());if(!data){data=new Treeview($__default['default'](this),_options);$__default['default'](this).data(DATA_KEY,data);}
if(config==='init'){data[config]();}});};return Treeview;}();$__default['default'](window).on(EVENT_LOAD_DATA_API,function(){$__default['default'](SELECTOR_DATA_WIDGET).each(function(){Treeview._jQueryInterface.call($__default['default'](this),'init');});});$__default['default'].fn[NAME]=Treeview._jQueryInterface;$__default['default'].fn[NAME].Constructor=Treeview;$__default['default'].fn[NAME].noConflict=function(){$__default['default'].fn[NAME]=JQUERY_NO_CONFLICT;return Treeview._jQueryInterface;};exports.CardRefresh=CardRefresh;exports.CardWidget=CardWidget;exports.ControlSidebar=ControlSidebar;exports.DirectChat=DirectChat;exports.Dropdown=Dropdown;exports.ExpandableTable=ExpandableTable;exports.Fullscreen=Fullscreen;exports.IFrame=IFrame;exports.Layout=Layout;exports.NavbarSearch=NavbarSearch;exports.PushMenu=PushMenu;exports.SidebarSearch=SidebarSearch;exports.Toasts=Toasts;exports.TodoList=TodoList;exports.Treeview=Treeview;Object.defineProperty(exports,'__esModule',{value:true});})));