"""Модуль проверки авторизации клиента на сервере."""
import sys
import socket

import logging

# метод определения модуля, источника запуска.
if sys.argv[0].find('client') == -1:
    # Если не клиент, то сервер!
    logger = logging.getLogger('server')
else:
    # Раз не сервер, то клиент
    logger = logging.getLogger('client')


def log(func_to_log):
    def log_saver(*args, **kwargs):
        logger.debug(f'Была вызвана функция {func_to_log.__name__} c '
                     f'параметрами {args} , {kwargs}. Вызов из модуля'
                     f' {func_to_log.__module__}')
        ret = func_to_log(*args, **kwargs)
        return ret
    return log_saver


def login_required(func):
    """
    Декоратор, проверяющий, что клиент авторизован на сервере.
    Проверяет, что передаваемый объект сокета находится в
    списке авторизованных клиентов.
    За исключением передачи словаря-запроса
    на авторизацию. Если клиент не авторизован,
    генерирует исключение TypeError.
    """

    def checker(*args, **kwargs):
        # Проверяем, что первый аргумент - экземпляр MessageProcessor.
        # Импортировать необходимо тут, иначе ошибка рекурсивного импорта.
        from messanger_lite.server.server import MessageProcessor
        from messanger_lite.client.common.variables import ACTION, PRESENCE
        if isinstance(args[0], MessageProcessor):
            found = False
            for arg in args:
                if isinstance(arg, socket.socket):
                    # Проверяем, что данный сокет есть в списке names класса
                    # MessageProcessor
                    for client in args[0].names:
                        if args[0].names[client] == arg:
                            found = True

            # Теперь надо проверить, что передаваемые аргументы не presence
            # сообщение. Если presence, то разрешаем.
            for arg in args:
                if isinstance(arg, dict):
                    if ACTION in arg and arg[ACTION] == PRESENCE:
                        found = True
            # Если не авторизован и не сообщение начала авторизации, то
            # вызываем исключение.
            if not found:
                raise TypeError
        return func(*args, **kwargs)

    return checker
