"use strict";define(["dialogHelper","connectionManager","dom","loading","scrollHelper","layoutManager","globalize","require","emby-button","emby-select","formDialogStyle","css!./style"],(function(dialogHelper,connectionManager,dom,loading,scrollHelper,layoutManager,globalize,require){var currentItemId,currentServerId,currentFile,hasChanges=!1;function onFileReaderError(evt){switch(loading.hide(),evt.target.error.code){case evt.target.error.NOT_FOUND_ERR:require(["toast"],(function(toast){toast(globalize.translate("MessageFileReadError"))}));break;case evt.target.error.ABORT_ERR:break;default:require(["toast"],(function(toast){toast(globalize.translate("MessageFileReadError"))}))}}function onSubmit(e){var file=currentFile;if(!file)return!1;if(!file.type.startsWith("image/"))return require(["toast"],(function(toast){toast(globalize.translate("MessageImageFileTypeAllowed"))})),e.preventDefault(),!1;loading.show();var dlg=dom.parentWithClass(this,"dialog"),imageType=dlg.querySelector("#selectImageType").value;return"None"===imageType?(require(["toast"],(function(toast){toast(globalize.translate("MessageImageTypeNotSelected"))})),e.preventDefault(),!1):(connectionManager.getApiClient(currentServerId).uploadItemImage(currentItemId,imageType,file).then((function(){dlg.querySelector("#uploadImage").value="",loading.hide(),hasChanges=!0,dialogHelper.close(dlg)})),e.preventDefault(),!1)}function initEditor(page){page.querySelector("form").addEventListener("submit",onSubmit),page.querySelector("#uploadImage").addEventListener("change",(function(){!function setFiles(page,files){var file=files[0];if(!file||!file.type.match("image.*"))return page.querySelector("#imageOutput").innerHTML="",page.querySelector("#fldUpload").classList.add("hide"),void(currentFile=null);currentFile=file;var theFile,reader=new FileReader;reader.onerror=onFileReaderError,reader.onloadstart=function(){page.querySelector("#fldUpload").classList.add("hide")},reader.onabort=function(){loading.hide(),console.debug("File read cancelled")},reader.onload=(theFile=file,function(e){var html=['<img style="max-width:100%;max-height:100%;" src="',e.target.result,'" title="',escape(theFile.name),'"/>'].join("");page.querySelector("#imageOutput").innerHTML=html,page.querySelector("#fldUpload").classList.remove("hide")}),reader.readAsDataURL(file)}(page,this.files)})),page.querySelector(".btnBrowse").addEventListener("click",(function(){page.querySelector("#uploadImage").click()}))}return{show:function show(options){return new Promise((function(resolve,reject){hasChanges=!1,function showEditor(options,resolve,reject){options=options||{},require(["text!./imageuploader.template.html"],(function(template){currentItemId=options.itemId,currentServerId=options.serverId;var dialogOptions={removeOnClose:!0};layoutManager.tv?dialogOptions.size="fullscreen":dialogOptions.size="fullscreen-border";var dlg=dialogHelper.createDialog(dialogOptions);dlg.classList.add("formDialog"),dlg.innerHTML=globalize.translateDocument(template,"core"),layoutManager.tv&&scrollHelper.centerFocus.on(dlg,!1),dlg.addEventListener("close",(function(){layoutManager.tv&&scrollHelper.centerFocus.off(dlg,!1),loading.hide(),resolve(hasChanges)})),dialogHelper.open(dlg),initEditor(dlg),dlg.querySelector("#selectImageType").value=options.imageType||"Primary",dlg.querySelector(".btnCancel").addEventListener("click",(function(){dialogHelper.close(dlg)}))}))}(options,resolve)}))}}}));
//# sourceMappingURL=imageuploader.js.map
