<div align="center">
<img src="https://raw.githubusercontent.com/OSOceanAcoustics/echopype/master/docs/source/_static/echopype_logo_banner.png" width="400">
</div>

# Echopype

<a href="https://github.com/OSOceanAcoustics/echopype/actions/workflows/ci.yaml">
  <img src="https://github.com/OSOceanAcoustics/echopype/actions/workflows/ci.yaml/badge.svg"/>
</a>

<a href="https://echopype.readthedocs.io/en/latest/?badge=latest">
  <img src="https://readthedocs.org/projects/echopype/badge/?version=latest"/>
</a>

<a href="https://codecov.io/gh/OSOceanAcoustics/echopype">
  <img src="https://codecov.io/gh/OSOceanAcoustics/echopype/branch/master/graph/badge.svg?token=GT98F919XR"/>
</a>

<a href="https://pypi.org/project/echopype/">
  <img src="https://img.shields.io/pypi/v/echopype.svg"/>
</a>

<a href="https://anaconda.org/conda-forge/echopype">
  <img src="https://img.shields.io/conda/vn/conda-forge/echopype.svg"/>
</a>

<a href="https://doi.org/10.5281/zenodo.4066742">
  <img src="https://zenodo.org/badge/DOI/10.5281/zenodo.4066742.svg" alt="DOI">
</a>

<a href="https://raw.githubusercontent.com/OSOceanAcoustics/echopype/master/LICENSE">
  <img alt="GitHub License" src="https://img.shields.io/github/license/OSOceanAcoustics/echopype">
</a>

Echopype is a package built to enable interoperability and scalability in ocean sonar data processing. These data are widely used for obtaining information about the distribution and abundance of marine animals, such as fish and krill. Our ability to collect large volumes of sonar data from a variety of ocean platforms has grown significantly in the last decade. However, most of the new data remain under-utilized. echopype aims to address the root cause of this problem - the lack of interoperable data format and scalable analysis workflows that adapt well with increasing data volume - by providing open-source tools as entry points for scientists to make discovery using these new data.

Watch the [echopype talk](https://www.youtube.com/watch?v=qboH7MyHrpU)
at SciPy 2019 for background, discussions and a quick demo!

## Documentation

Learn more about echopype in the official documentation at https://echopype.readthedocs.io. Check out executable examples in the companion repository https://github.com/OSOceanAcoustics/echopype-examples.


## Contributing

You can find information about how to contribute to echopype at our [Contributing Page](https://echopype.readthedocs.io/en/latest/contributing.html).


## Echopype doesn't run on your data?

Please report any bugs by [creating issues on GitHub](https://medium.com/nyc-planning-digital/writing-a-proper-github-issue-97427d62a20f).

[Pull requests](https://jarednielsen.com/learn-git-fork-pull-request/) are always welcome!


Contributors
------------

[Wu-Jung Lee](http://leewujung.github.io) (@leewujung) leads this project and together with
[Kavin Nguyen](https://github.com/ngkavin) (@ngkavin), [Landung "Don" Setiawan](https://github.com/lsetiawan) (@lsetiawan), and [Imran Majeed](https://github.com/imranmaj) (@imranmaj) are primary developers of this package.
[Emilio Mayorga](https://www.apl.washington.edu/people/profile.php?last_name=Mayorga&first_name=Emilio) (@emiliom)
and [Valentina Staneva](https://escience.washington.edu/people/valentina-staneva/) (@valentina-s)
are also part of the development team.

Other contributors are listed in [echopype documentation](https://echopype.readthedocs.io).

We thank Dave Billenness of ASL Environmental Sciences for
providing the AZFP Matlab Toolbox as reference for our
development of AZFP support in echopype.
We also thank [Rick Towler](https://github.com/rhtowler) (@rhtowler)
of the Alaska Fisheries Science Center
for providing low-level file parsing routines for
Simrad EK60 and EK80 echosounders.


License
-------

Echopype is licensed under the open source [Apache 2.0 license](https://opensource.org/licenses/Apache-2.0).


---------------

Copyright (c) 2018-2021, echopype Developers.
