# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class WorkoutSessionMessage(DataMessage):
    ID = 158
    NAME = 'workout_session'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=WorkoutSessionMessage.NAME,
                         global_id=WorkoutSessionMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             WorkoutSessionSportField(
                                 size=self.__get_field_size(definition_message, WorkoutSessionSportField.ID),
                                 growable=definition_message is None),
                             WorkoutSessionSubSportField(
                                 size=self.__get_field_size(definition_message, WorkoutSessionSubSportField.ID),
                                 growable=definition_message is None),
                             WorkoutSessionNumValidStepsField(
                                 size=self.__get_field_size(definition_message, WorkoutSessionNumValidStepsField.ID),
                                 growable=definition_message is None),
                             WorkoutSessionFirstStepIndexField(
                                 size=self.__get_field_size(definition_message, WorkoutSessionFirstStepIndexField.ID),
                                 growable=definition_message is None),
                             WorkoutSessionPoolLengthField(
                                 size=self.__get_field_size(definition_message, WorkoutSessionPoolLengthField.ID),
                                 growable=definition_message is None),
                             WorkoutSessionPoolLengthUnitField(
                                 size=self.__get_field_size(definition_message, WorkoutSessionPoolLengthUnitField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(WorkoutSessionSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(WorkoutSessionSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sub_sport(self) -> Optional[SubSport]:
        field = self.get_field(WorkoutSessionSubSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sub_sport.setter
    def sub_sport(self, value: SubSport):
        field = self.get_field(WorkoutSessionSubSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_valid_steps(self) -> Optional[int]:
        field = self.get_field(WorkoutSessionNumValidStepsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_valid_steps.setter
    def num_valid_steps(self, value: int):
        field = self.get_field(WorkoutSessionNumValidStepsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def first_step_index(self) -> Optional[int]:
        field = self.get_field(WorkoutSessionFirstStepIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @first_step_index.setter
    def first_step_index(self, value: int):
        field = self.get_field(WorkoutSessionFirstStepIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pool_length(self) -> Optional[float]:
        field = self.get_field(WorkoutSessionPoolLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pool_length.setter
    def pool_length(self, value: float):
        field = self.get_field(WorkoutSessionPoolLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pool_length_unit(self) -> Optional[DisplayMeasure]:
        field = self.get_field(WorkoutSessionPoolLengthUnitField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pool_length_unit.setter
    def pool_length_unit(self, value: DisplayMeasure):
        field = self.get_field(WorkoutSessionPoolLengthUnitField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSessionSportField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSessionSubSportField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sub_sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSessionNumValidStepsField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_valid_steps',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSessionFirstStepIndexField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='first_step_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSessionPoolLengthField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pool_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSessionPoolLengthUnitField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pool_length_unit',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
