# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field


class SegmentPointMessage(DataMessage):
    ID = 150
    NAME = 'segment_point'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=SegmentPointMessage.NAME,
                         global_id=SegmentPointMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             SegmentPointPositionLatField(
                                 size=self.__get_field_size(definition_message, SegmentPointPositionLatField.ID),
                                 growable=definition_message is None),
                             SegmentPointPositionLongField(
                                 size=self.__get_field_size(definition_message, SegmentPointPositionLongField.ID),
                                 growable=definition_message is None),
                             SegmentPointDistanceField(
                                 size=self.__get_field_size(definition_message, SegmentPointDistanceField.ID),
                                 growable=definition_message is None),
                             SegmentPointAltitudeField(
                                 size=self.__get_field_size(definition_message, SegmentPointAltitudeField.ID),
                                 growable=definition_message is None),
                             SegmentPointLeaderTimeField(
                                 size=self.__get_field_size(definition_message, SegmentPointLeaderTimeField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def position_lat(self) -> Optional[float]:
        field = self.get_field(SegmentPointPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @position_lat.setter
    def position_lat(self, value: float):
        field = self.get_field(SegmentPointPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def position_long(self) -> Optional[float]:
        field = self.get_field(SegmentPointPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @position_long.setter
    def position_long(self, value: float):
        field = self.get_field(SegmentPointPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def distance(self) -> Optional[float]:
        field = self.get_field(SegmentPointDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @distance.setter
    def distance(self, value: float):
        field = self.get_field(SegmentPointDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def altitude(self) -> Optional[float]:
        field = self.get_field(SegmentPointAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @altitude.setter
    def altitude(self, value: float):
        field = self.get_field(SegmentPointAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def leader_time(self) -> Optional[float]:
        field = self.get_field(SegmentPointLeaderTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @leader_time.setter
    def leader_time(self, value: float):
        field = self.get_field(SegmentPointLeaderTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentPointPositionLatField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentPointPositionLongField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentPointDistanceField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='distance',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentPointAltitudeField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentPointLeaderTimeField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='leader_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
