# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class RecordMessage(DataMessage):
    ID = 20
    NAME = 'record'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=RecordMessage.NAME,
                         global_id=RecordMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             RecordPositionLatField(
                                 size=self.__get_field_size(definition_message, RecordPositionLatField.ID),
                                 growable=definition_message is None),
                             RecordPositionLongField(
                                 size=self.__get_field_size(definition_message, RecordPositionLongField.ID),
                                 growable=definition_message is None),
                             RecordAltitudeField(
                                 size=self.__get_field_size(definition_message, RecordAltitudeField.ID),
                                 growable=definition_message is None),
                             RecordHeartRateField(
                                 size=self.__get_field_size(definition_message, RecordHeartRateField.ID),
                                 growable=definition_message is None),
                             RecordCadenceField(
                                 size=self.__get_field_size(definition_message, RecordCadenceField.ID),
                                 growable=definition_message is None),
                             RecordDistanceField(
                                 size=self.__get_field_size(definition_message, RecordDistanceField.ID),
                                 growable=definition_message is None),
                             RecordSpeedField(
                                 size=self.__get_field_size(definition_message, RecordSpeedField.ID),
                                 growable=definition_message is None),
                             RecordPowerField(
                                 size=self.__get_field_size(definition_message, RecordPowerField.ID),
                                 growable=definition_message is None),
                             RecordCompressedSpeedDistanceField(
                                 size=self.__get_field_size(definition_message, RecordCompressedSpeedDistanceField.ID),
                                 growable=definition_message is None),
                             RecordGradeField(
                                 size=self.__get_field_size(definition_message, RecordGradeField.ID),
                                 growable=definition_message is None),
                             RecordResistanceField(
                                 size=self.__get_field_size(definition_message, RecordResistanceField.ID),
                                 growable=definition_message is None),
                             RecordTimeFromCourseField(
                                 size=self.__get_field_size(definition_message, RecordTimeFromCourseField.ID),
                                 growable=definition_message is None),
                             RecordCycleLengthField(
                                 size=self.__get_field_size(definition_message, RecordCycleLengthField.ID),
                                 growable=definition_message is None),
                             RecordTemperatureField(
                                 size=self.__get_field_size(definition_message, RecordTemperatureField.ID),
                                 growable=definition_message is None),
                             RecordSpeed1sField(
                                 size=self.__get_field_size(definition_message, RecordSpeed1sField.ID),
                                 growable=definition_message is None),
                             RecordCyclesField(
                                 size=self.__get_field_size(definition_message, RecordCyclesField.ID),
                                 growable=definition_message is None),
                             RecordTotalCyclesField(
                                 size=self.__get_field_size(definition_message, RecordTotalCyclesField.ID),
                                 growable=definition_message is None),
                             RecordCompressedAccumulatedPowerField(
                                 size=self.__get_field_size(definition_message,
                                                            RecordCompressedAccumulatedPowerField.ID),
                                 growable=definition_message is None),
                             RecordAccumulatedPowerField(
                                 size=self.__get_field_size(definition_message, RecordAccumulatedPowerField.ID),
                                 growable=definition_message is None),
                             RecordLeftRightBalanceField(
                                 size=self.__get_field_size(definition_message, RecordLeftRightBalanceField.ID),
                                 growable=definition_message is None),
                             RecordGpsAccuracyField(
                                 size=self.__get_field_size(definition_message, RecordGpsAccuracyField.ID),
                                 growable=definition_message is None),
                             RecordVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, RecordVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             RecordCaloriesField(
                                 size=self.__get_field_size(definition_message, RecordCaloriesField.ID),
                                 growable=definition_message is None),
                             RecordVerticalOscillationField(
                                 size=self.__get_field_size(definition_message, RecordVerticalOscillationField.ID),
                                 growable=definition_message is None),
                             RecordStanceTimePercentField(
                                 size=self.__get_field_size(definition_message, RecordStanceTimePercentField.ID),
                                 growable=definition_message is None),
                             RecordStanceTimeField(
                                 size=self.__get_field_size(definition_message, RecordStanceTimeField.ID),
                                 growable=definition_message is None),
                             RecordActivityTypeField(
                                 size=self.__get_field_size(definition_message, RecordActivityTypeField.ID),
                                 growable=definition_message is None),
                             RecordLeftTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message, RecordLeftTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             RecordRightTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message, RecordRightTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             RecordLeftPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, RecordLeftPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             RecordRightPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, RecordRightPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             RecordCombinedPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, RecordCombinedPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             RecordTime128Field(
                                 size=self.__get_field_size(definition_message, RecordTime128Field.ID),
                                 growable=definition_message is None),
                             RecordStrokeTypeField(
                                 size=self.__get_field_size(definition_message, RecordStrokeTypeField.ID),
                                 growable=definition_message is None),
                             RecordZoneField(
                                 size=self.__get_field_size(definition_message, RecordZoneField.ID),
                                 growable=definition_message is None),
                             RecordBallSpeedField(
                                 size=self.__get_field_size(definition_message, RecordBallSpeedField.ID),
                                 growable=definition_message is None),
                             RecordCadence256Field(
                                 size=self.__get_field_size(definition_message, RecordCadence256Field.ID),
                                 growable=definition_message is None),
                             RecordFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, RecordFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             RecordTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, RecordTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             RecordTotalHemoglobinConcMinField(
                                 size=self.__get_field_size(definition_message, RecordTotalHemoglobinConcMinField.ID),
                                 growable=definition_message is None),
                             RecordTotalHemoglobinConcMaxField(
                                 size=self.__get_field_size(definition_message, RecordTotalHemoglobinConcMaxField.ID),
                                 growable=definition_message is None),
                             RecordSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            RecordSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             RecordSaturatedHemoglobinPercentMinField(
                                 size=self.__get_field_size(definition_message,
                                                            RecordSaturatedHemoglobinPercentMinField.ID),
                                 growable=definition_message is None),
                             RecordSaturatedHemoglobinPercentMaxField(
                                 size=self.__get_field_size(definition_message,
                                                            RecordSaturatedHemoglobinPercentMaxField.ID),
                                 growable=definition_message is None),
                             RecordDeviceIndexField(
                                 size=self.__get_field_size(definition_message, RecordDeviceIndexField.ID),
                                 growable=definition_message is None),
                             RecordLeftPcoField(
                                 size=self.__get_field_size(definition_message, RecordLeftPcoField.ID),
                                 growable=definition_message is None),
                             RecordRightPcoField(
                                 size=self.__get_field_size(definition_message, RecordRightPcoField.ID),
                                 growable=definition_message is None),
                             RecordLeftPowerPhaseField(
                                 size=self.__get_field_size(definition_message, RecordLeftPowerPhaseField.ID),
                                 growable=definition_message is None),
                             RecordLeftPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message, RecordLeftPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             RecordRightPowerPhaseField(
                                 size=self.__get_field_size(definition_message, RecordRightPowerPhaseField.ID),
                                 growable=definition_message is None),
                             RecordRightPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message, RecordRightPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             RecordEnhancedSpeedField(
                                 size=self.__get_field_size(definition_message, RecordEnhancedSpeedField.ID),
                                 growable=definition_message is None),
                             RecordEnhancedAltitudeField(
                                 size=self.__get_field_size(definition_message, RecordEnhancedAltitudeField.ID),
                                 growable=definition_message is None),
                             RecordBatterySocField(
                                 size=self.__get_field_size(definition_message, RecordBatterySocField.ID),
                                 growable=definition_message is None),
                             RecordMotorPowerField(
                                 size=self.__get_field_size(definition_message, RecordMotorPowerField.ID),
                                 growable=definition_message is None),
                             RecordVerticalRatioField(
                                 size=self.__get_field_size(definition_message, RecordVerticalRatioField.ID),
                                 growable=definition_message is None),
                             RecordStanceTimeBalanceField(
                                 size=self.__get_field_size(definition_message, RecordStanceTimeBalanceField.ID),
                                 growable=definition_message is None),
                             RecordStepLengthField(
                                 size=self.__get_field_size(definition_message, RecordStepLengthField.ID),
                                 growable=definition_message is None),
                             RecordAbsolutePressureField(
                                 size=self.__get_field_size(definition_message, RecordAbsolutePressureField.ID),
                                 growable=definition_message is None),
                             RecordDepthField(
                                 size=self.__get_field_size(definition_message, RecordDepthField.ID),
                                 growable=definition_message is None),
                             RecordNextStopDepthField(
                                 size=self.__get_field_size(definition_message, RecordNextStopDepthField.ID),
                                 growable=definition_message is None),
                             RecordNextStopTimeField(
                                 size=self.__get_field_size(definition_message, RecordNextStopTimeField.ID),
                                 growable=definition_message is None),
                             RecordTimeToSurfaceField(
                                 size=self.__get_field_size(definition_message, RecordTimeToSurfaceField.ID),
                                 growable=definition_message is None),
                             RecordNdlTimeField(
                                 size=self.__get_field_size(definition_message, RecordNdlTimeField.ID),
                                 growable=definition_message is None),
                             RecordCnsLoadField(
                                 size=self.__get_field_size(definition_message, RecordCnsLoadField.ID),
                                 growable=definition_message is None),
                             RecordN2LoadField(
                                 size=self.__get_field_size(definition_message, RecordN2LoadField.ID),
                                 growable=definition_message is None),
                             RecordGritField(
                                 size=self.__get_field_size(definition_message, RecordGritField.ID),
                                 growable=definition_message is None),
                             RecordFlowField(
                                 size=self.__get_field_size(definition_message, RecordFlowField.ID),
                                 growable=definition_message is None),
                             RecordEbikeTravelRangeField(
                                 size=self.__get_field_size(definition_message, RecordEbikeTravelRangeField.ID),
                                 growable=definition_message is None),
                             RecordEbikeBatteryLevelField(
                                 size=self.__get_field_size(definition_message, RecordEbikeBatteryLevelField.ID),
                                 growable=definition_message is None),
                             RecordEbikeAssistModeField(
                                 size=self.__get_field_size(definition_message, RecordEbikeAssistModeField.ID),
                                 growable=definition_message is None),
                             RecordEbikeAssistLevelPercentField(
                                 size=self.__get_field_size(definition_message, RecordEbikeAssistLevelPercentField.ID),
                                 growable=definition_message is None),
                             RecordCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, RecordCoreTemperatureField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def position_lat(self) -> Optional[float]:
        field = self.get_field(RecordPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @position_lat.setter
    def position_lat(self, value: float):
        field = self.get_field(RecordPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def position_long(self) -> Optional[float]:
        field = self.get_field(RecordPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @position_long.setter
    def position_long(self, value: float):
        field = self.get_field(RecordPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def altitude(self) -> Optional[float]:
        field = self.get_field(RecordAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @altitude.setter
    def altitude(self, value: float):
        field = self.get_field(RecordAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def heart_rate(self) -> Optional[int]:
        field = self.get_field(RecordHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @heart_rate.setter
    def heart_rate(self, value: int):
        field = self.get_field(RecordHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cadence(self) -> Optional[int]:
        field = self.get_field(RecordCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cadence.setter
    def cadence(self, value: int):
        field = self.get_field(RecordCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def distance(self) -> Optional[float]:
        field = self.get_field(RecordDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @distance.setter
    def distance(self, value: float):
        field = self.get_field(RecordDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def speed(self) -> Optional[float]:
        field = self.get_field(RecordSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @speed.setter
    def speed(self, value: float):
        field = self.get_field(RecordSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def power(self) -> Optional[int]:
        field = self.get_field(RecordPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @power.setter
    def power(self, value: int):
        field = self.get_field(RecordPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def compressed_speed_distance(self) -> Optional[int]:
        field = self.get_field(RecordCompressedSpeedDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @compressed_speed_distance.setter
    def compressed_speed_distance(self, value: int):
        field = self.get_field(RecordCompressedSpeedDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def grade(self) -> Optional[float]:
        field = self.get_field(RecordGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @grade.setter
    def grade(self, value: float):
        field = self.get_field(RecordGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def resistance(self) -> Optional[int]:
        field = self.get_field(RecordResistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @resistance.setter
    def resistance(self, value: int):
        field = self.get_field(RecordResistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_from_course(self) -> Optional[float]:
        field = self.get_field(RecordTimeFromCourseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_from_course.setter
    def time_from_course(self, value: float):
        field = self.get_field(RecordTimeFromCourseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cycle_length(self) -> Optional[float]:
        field = self.get_field(RecordCycleLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cycle_length.setter
    def cycle_length(self, value: float):
        field = self.get_field(RecordCycleLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature(self) -> Optional[int]:
        field = self.get_field(RecordTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature.setter
    def temperature(self, value: int):
        field = self.get_field(RecordTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def speed_1s(self) -> Optional[float]:
        field = self.get_field(RecordSpeed1sField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @speed_1s.setter
    def speed_1s(self, value: float):
        field = self.get_field(RecordSpeed1sField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cycles(self) -> Optional[int]:
        field = self.get_field(RecordCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cycles.setter
    def cycles(self, value: int):
        field = self.get_field(RecordCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_cycles(self) -> Optional[int]:
        field = self.get_field(RecordTotalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_cycles.setter
    def total_cycles(self, value: int):
        field = self.get_field(RecordTotalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def compressed_accumulated_power(self) -> Optional[int]:
        field = self.get_field(RecordCompressedAccumulatedPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @compressed_accumulated_power.setter
    def compressed_accumulated_power(self, value: int):
        field = self.get_field(RecordCompressedAccumulatedPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def accumulated_power(self) -> Optional[int]:
        field = self.get_field(RecordAccumulatedPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @accumulated_power.setter
    def accumulated_power(self, value: int):
        field = self.get_field(RecordAccumulatedPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_right_balance(self) -> Optional[int]:
        field = self.get_field(RecordLeftRightBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_right_balance.setter
    def left_right_balance(self, value: int):
        field = self.get_field(RecordLeftRightBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def gps_accuracy(self) -> Optional[int]:
        field = self.get_field(RecordGpsAccuracyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @gps_accuracy.setter
    def gps_accuracy(self, value: int):
        field = self.get_field(RecordGpsAccuracyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def vertical_speed(self) -> Optional[float]:
        field = self.get_field(RecordVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @vertical_speed.setter
    def vertical_speed(self, value: float):
        field = self.get_field(RecordVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def calories(self) -> Optional[int]:
        field = self.get_field(RecordCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @calories.setter
    def calories(self, value: int):
        field = self.get_field(RecordCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def vertical_oscillation(self) -> Optional[float]:
        field = self.get_field(RecordVerticalOscillationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @vertical_oscillation.setter
    def vertical_oscillation(self, value: float):
        field = self.get_field(RecordVerticalOscillationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stance_time_percent(self) -> Optional[float]:
        field = self.get_field(RecordStanceTimePercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stance_time_percent.setter
    def stance_time_percent(self, value: float):
        field = self.get_field(RecordStanceTimePercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stance_time(self) -> Optional[float]:
        field = self.get_field(RecordStanceTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stance_time.setter
    def stance_time(self, value: float):
        field = self.get_field(RecordStanceTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_type(self) -> Optional[ActivityType]:
        field = self.get_field(RecordActivityTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_type.setter
    def activity_type(self, value: ActivityType):
        field = self.get_field(RecordActivityTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(RecordLeftTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_torque_effectiveness.setter
    def left_torque_effectiveness(self, value: float):
        field = self.get_field(RecordLeftTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def right_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(RecordRightTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @right_torque_effectiveness.setter
    def right_torque_effectiveness(self, value: float):
        field = self.get_field(RecordRightTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(RecordLeftPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_pedal_smoothness.setter
    def left_pedal_smoothness(self, value: float):
        field = self.get_field(RecordLeftPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def right_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(RecordRightPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @right_pedal_smoothness.setter
    def right_pedal_smoothness(self, value: float):
        field = self.get_field(RecordRightPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def combined_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(RecordCombinedPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @combined_pedal_smoothness.setter
    def combined_pedal_smoothness(self, value: float):
        field = self.get_field(RecordCombinedPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time128(self) -> Optional[float]:
        field = self.get_field(RecordTime128Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time128.setter
    def time128(self, value: float):
        field = self.get_field(RecordTime128Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stroke_type(self) -> Optional[StrokeType]:
        field = self.get_field(RecordStrokeTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stroke_type.setter
    def stroke_type(self, value: StrokeType):
        field = self.get_field(RecordStrokeTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def zone(self) -> Optional[int]:
        field = self.get_field(RecordZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @zone.setter
    def zone(self, value: int):
        field = self.get_field(RecordZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ball_speed(self) -> Optional[float]:
        field = self.get_field(RecordBallSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ball_speed.setter
    def ball_speed(self, value: float):
        field = self.get_field(RecordBallSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cadence256(self) -> Optional[float]:
        field = self.get_field(RecordCadence256Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cadence256.setter
    def cadence256(self, value: float):
        field = self.get_field(RecordCadence256Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def fractional_cadence(self) -> Optional[float]:
        field = self.get_field(RecordFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @fractional_cadence.setter
    def fractional_cadence(self, value: float):
        field = self.get_field(RecordFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(RecordTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_hemoglobin_conc.setter
    def total_hemoglobin_conc(self, value: float):
        field = self.get_field(RecordTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_hemoglobin_conc_min(self) -> Optional[float]:
        field = self.get_field(RecordTotalHemoglobinConcMinField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_hemoglobin_conc_min.setter
    def total_hemoglobin_conc_min(self, value: float):
        field = self.get_field(RecordTotalHemoglobinConcMinField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_hemoglobin_conc_max(self) -> Optional[float]:
        field = self.get_field(RecordTotalHemoglobinConcMaxField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_hemoglobin_conc_max.setter
    def total_hemoglobin_conc_max(self, value: float):
        field = self.get_field(RecordTotalHemoglobinConcMaxField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(RecordSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @saturated_hemoglobin_percent.setter
    def saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(RecordSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def saturated_hemoglobin_percent_min(self) -> Optional[float]:
        field = self.get_field(RecordSaturatedHemoglobinPercentMinField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @saturated_hemoglobin_percent_min.setter
    def saturated_hemoglobin_percent_min(self, value: float):
        field = self.get_field(RecordSaturatedHemoglobinPercentMinField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def saturated_hemoglobin_percent_max(self) -> Optional[float]:
        field = self.get_field(RecordSaturatedHemoglobinPercentMaxField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @saturated_hemoglobin_percent_max.setter
    def saturated_hemoglobin_percent_max(self, value: float):
        field = self.get_field(RecordSaturatedHemoglobinPercentMaxField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def device_index(self) -> Optional[int]:
        field = self.get_field(RecordDeviceIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @device_index.setter
    def device_index(self, value: int):
        field = self.get_field(RecordDeviceIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_pco(self) -> Optional[int]:
        field = self.get_field(RecordLeftPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_pco.setter
    def left_pco(self, value: int):
        field = self.get_field(RecordLeftPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def right_pco(self) -> Optional[int]:
        field = self.get_field(RecordRightPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @right_pco.setter
    def right_pco(self, value: int):
        field = self.get_field(RecordRightPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_power_phase(self) -> Optional[float]:
        field = self.get_field(RecordLeftPowerPhaseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_power_phase.setter
    def left_power_phase(self, value: float):
        field = self.get_field(RecordLeftPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_power_phase_peak(self) -> Optional[float]:
        field = self.get_field(RecordLeftPowerPhasePeakField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_power_phase_peak.setter
    def left_power_phase_peak(self, value: float):
        field = self.get_field(RecordLeftPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def right_power_phase(self) -> Optional[float]:
        field = self.get_field(RecordRightPowerPhaseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @right_power_phase.setter
    def right_power_phase(self, value: float):
        field = self.get_field(RecordRightPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def right_power_phase_peak(self) -> Optional[float]:
        field = self.get_field(RecordRightPowerPhasePeakField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @right_power_phase_peak.setter
    def right_power_phase_peak(self, value: float):
        field = self.get_field(RecordRightPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_speed(self) -> Optional[float]:
        field = self.get_field(RecordEnhancedSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_speed.setter
    def enhanced_speed(self, value: float):
        field = self.get_field(RecordEnhancedSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_altitude(self) -> Optional[float]:
        field = self.get_field(RecordEnhancedAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_altitude.setter
    def enhanced_altitude(self, value: float):
        field = self.get_field(RecordEnhancedAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def battery_soc(self) -> Optional[float]:
        field = self.get_field(RecordBatterySocField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @battery_soc.setter
    def battery_soc(self, value: float):
        field = self.get_field(RecordBatterySocField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def motor_power(self) -> Optional[int]:
        field = self.get_field(RecordMotorPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @motor_power.setter
    def motor_power(self, value: int):
        field = self.get_field(RecordMotorPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def vertical_ratio(self) -> Optional[float]:
        field = self.get_field(RecordVerticalRatioField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @vertical_ratio.setter
    def vertical_ratio(self, value: float):
        field = self.get_field(RecordVerticalRatioField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stance_time_balance(self) -> Optional[float]:
        field = self.get_field(RecordStanceTimeBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stance_time_balance.setter
    def stance_time_balance(self, value: float):
        field = self.get_field(RecordStanceTimeBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def step_length(self) -> Optional[float]:
        field = self.get_field(RecordStepLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @step_length.setter
    def step_length(self, value: float):
        field = self.get_field(RecordStepLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def absolute_pressure(self) -> Optional[int]:
        field = self.get_field(RecordAbsolutePressureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @absolute_pressure.setter
    def absolute_pressure(self, value: int):
        field = self.get_field(RecordAbsolutePressureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def depth(self) -> Optional[float]:
        field = self.get_field(RecordDepthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @depth.setter
    def depth(self, value: float):
        field = self.get_field(RecordDepthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def next_stop_depth(self) -> Optional[float]:
        field = self.get_field(RecordNextStopDepthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @next_stop_depth.setter
    def next_stop_depth(self, value: float):
        field = self.get_field(RecordNextStopDepthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def next_stop_time(self) -> Optional[int]:
        field = self.get_field(RecordNextStopTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @next_stop_time.setter
    def next_stop_time(self, value: int):
        field = self.get_field(RecordNextStopTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_to_surface(self) -> Optional[int]:
        field = self.get_field(RecordTimeToSurfaceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_to_surface.setter
    def time_to_surface(self, value: int):
        field = self.get_field(RecordTimeToSurfaceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ndl_time(self) -> Optional[int]:
        field = self.get_field(RecordNdlTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ndl_time.setter
    def ndl_time(self, value: int):
        field = self.get_field(RecordNdlTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cns_load(self) -> Optional[int]:
        field = self.get_field(RecordCnsLoadField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cns_load.setter
    def cns_load(self, value: int):
        field = self.get_field(RecordCnsLoadField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def n2_load(self) -> Optional[int]:
        field = self.get_field(RecordN2LoadField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @n2_load.setter
    def n2_load(self, value: int):
        field = self.get_field(RecordN2LoadField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def grit(self) -> Optional[float]:
        field = self.get_field(RecordGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @grit.setter
    def grit(self, value: float):
        field = self.get_field(RecordGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def flow(self) -> Optional[float]:
        field = self.get_field(RecordFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @flow.setter
    def flow(self, value: float):
        field = self.get_field(RecordFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ebike_travel_range(self) -> Optional[int]:
        field = self.get_field(RecordEbikeTravelRangeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ebike_travel_range.setter
    def ebike_travel_range(self, value: int):
        field = self.get_field(RecordEbikeTravelRangeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ebike_battery_level(self) -> Optional[int]:
        field = self.get_field(RecordEbikeBatteryLevelField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ebike_battery_level.setter
    def ebike_battery_level(self, value: int):
        field = self.get_field(RecordEbikeBatteryLevelField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ebike_assist_mode(self) -> Optional[int]:
        field = self.get_field(RecordEbikeAssistModeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ebike_assist_mode.setter
    def ebike_assist_mode(self, value: int):
        field = self.get_field(RecordEbikeAssistModeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ebike_assist_level_percent(self) -> Optional[int]:
        field = self.get_field(RecordEbikeAssistLevelPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ebike_assist_level_percent.setter
    def ebike_assist_level_percent(self, value: int):
        field = self.get_field(RecordEbikeAssistLevelPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def core_temperature(self) -> Optional[float]:
        field = self.get_field(RecordCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @core_temperature.setter
    def core_temperature(self, value: float):
        field = self.get_field(RecordCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordPositionLatField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordPositionLongField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordAltitudeField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordHeartRateField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCadenceField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordDistanceField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='distance',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordSpeedField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordPowerField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCompressedSpeedDistanceField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='compressed_speed_distance',
            field_id=self.ID,
            base_type=BaseType.BYTE,
            offset=0,
            scale=1,
            size=size,
            units='m/s,m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordGradeField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordResistanceField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='resistance',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTimeFromCourseField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_from_course',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCycleLengthField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cycle_length',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTemperatureField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordSpeed1sField(Field):
    ID = 17

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='speed_1s',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=16,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCyclesField(Field):
    ID = 18

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cycles',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTotalCyclesField(Field):
    ID = 19

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCompressedAccumulatedPowerField(Field):
    ID = 28

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='compressed_accumulated_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordAccumulatedPowerField(Field):
    ID = 29

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='accumulated_power',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordLeftRightBalanceField(Field):
    ID = 30

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_right_balance',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordGpsAccuracyField(Field):
    ID = 31

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='gps_accuracy',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordVerticalSpeedField(Field):
    ID = 32

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCaloriesField(Field):
    ID = 33

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordVerticalOscillationField(Field):
    ID = 39

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='vertical_oscillation',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordStanceTimePercentField(Field):
    ID = 40

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stance_time_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordStanceTimeField(Field):
    ID = 41

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stance_time',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='ms',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordActivityTypeField(Field):
    ID = 42

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordLeftTorqueEffectivenessField(Field):
    ID = 43

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordRightTorqueEffectivenessField(Field):
    ID = 44

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='right_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordLeftPedalSmoothnessField(Field):
    ID = 45

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordRightPedalSmoothnessField(Field):
    ID = 46

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='right_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCombinedPedalSmoothnessField(Field):
    ID = 47

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='combined_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTime128Field(Field):
    ID = 48

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time128',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordStrokeTypeField(Field):
    ID = 49

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stroke_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordZoneField(Field):
    ID = 50

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='zone',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordBallSpeedField(Field):
    ID = 51

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ball_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCadence256Field(Field):
    ID = 52

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cadence256',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=256,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordFractionalCadenceField(Field):
    ID = 53

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTotalHemoglobinConcField(Field):
    ID = 54

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTotalHemoglobinConcMinField(Field):
    ID = 55

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_hemoglobin_conc_min',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTotalHemoglobinConcMaxField(Field):
    ID = 56

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_hemoglobin_conc_max',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordSaturatedHemoglobinPercentField(Field):
    ID = 57

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordSaturatedHemoglobinPercentMinField(Field):
    ID = 58

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='saturated_hemoglobin_percent_min',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordSaturatedHemoglobinPercentMaxField(Field):
    ID = 59

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='saturated_hemoglobin_percent_max',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordDeviceIndexField(Field):
    ID = 62

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='device_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordLeftPcoField(Field):
    ID = 67

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordRightPcoField(Field):
    ID = 68

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='right_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordLeftPowerPhaseField(Field):
    ID = 69

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordLeftPowerPhasePeakField(Field):
    ID = 70

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordRightPowerPhaseField(Field):
    ID = 71

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='right_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordRightPowerPhasePeakField(Field):
    ID = 72

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='right_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordEnhancedSpeedField(Field):
    ID = 73

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_speed',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordEnhancedAltitudeField(Field):
    ID = 78

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordBatterySocField(Field):
    ID = 81

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='battery_soc',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordMotorPowerField(Field):
    ID = 82

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='motor_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordVerticalRatioField(Field):
    ID = 83

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='vertical_ratio',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordStanceTimeBalanceField(Field):
    ID = 84

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stance_time_balance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordStepLengthField(Field):
    ID = 85

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='step_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordAbsolutePressureField(Field):
    ID = 91

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='absolute_pressure',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='Pa',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordDepthField(Field):
    ID = 92

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='depth',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordNextStopDepthField(Field):
    ID = 93

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='next_stop_depth',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordNextStopTimeField(Field):
    ID = 94

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='next_stop_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordTimeToSurfaceField(Field):
    ID = 95

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_to_surface',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordNdlTimeField(Field):
    ID = 96

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ndl_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCnsLoadField(Field):
    ID = 97

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cns_load',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordN2LoadField(Field):
    ID = 98

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='n2_load',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordGritField(Field):
    ID = 114

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordFlowField(Field):
    ID = 115

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class RecordEbikeTravelRangeField(Field):
    ID = 117

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ebike_travel_range',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='km',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordEbikeBatteryLevelField(Field):
    ID = 118

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ebike_battery_level',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordEbikeAssistModeField(Field):
    ID = 119

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ebike_assist_mode',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='depends on sensor',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordEbikeAssistLevelPercentField(Field):
    ID = 120

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ebike_assist_level_percent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class RecordCoreTemperatureField(Field):
    ID = 139

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
