# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *
from fit_tool.sub_field import SubField


class MesgCapabilitiesMessage(DataMessage):
    ID = 38
    NAME = 'mesg_capabilities'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=MesgCapabilitiesMessage.NAME,
                         global_id=MesgCapabilitiesMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             MesgCapabilitiesFileField(
                                 size=self.__get_field_size(definition_message, MesgCapabilitiesFileField.ID),
                                 growable=definition_message is None),
                             MesgCapabilitiesMesgNumField(
                                 size=self.__get_field_size(definition_message, MesgCapabilitiesMesgNumField.ID),
                                 growable=definition_message is None),
                             MesgCapabilitiesCountTypeField(
                                 size=self.__get_field_size(definition_message, MesgCapabilitiesCountTypeField.ID),
                                 growable=definition_message is None),
                             MesgCapabilitiesCountField(
                                 size=self.__get_field_size(definition_message, MesgCapabilitiesCountField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def file(self) -> Optional[FileType]:
        field = self.get_field(MesgCapabilitiesFileField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @file.setter
    def file(self, value: FileType):
        field = self.get_field(MesgCapabilitiesFileField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def mesg_num(self) -> Optional[int]:
        field = self.get_field(MesgCapabilitiesMesgNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @mesg_num.setter
    def mesg_num(self, value: int):
        field = self.get_field(MesgCapabilitiesMesgNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def count_type(self) -> Optional[MesgCount]:
        field = self.get_field(MesgCapabilitiesCountTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @count_type.setter
    def count_type(self, value: MesgCount):
        field = self.get_field(MesgCapabilitiesCountTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def count(self) -> Optional[int]:
        field = self.get_field(MesgCapabilitiesCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @count.setter
    def count(self, value: int):
        field = self.get_field(MesgCapabilitiesCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_per_file(self) -> Optional[int]:
        field = self.get_field(MesgCapabilitiesCountField.ID)
        type_field = self.get_field(MesgCapabilitiesCountTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [0]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_per_file.setter
    def num_per_file(self, value: int):
        field = self.get_field(MesgCapabilitiesCountField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()

    @property
    def max_per_file(self) -> Optional[int]:
        field = self.get_field(MesgCapabilitiesCountField.ID)
        type_field = self.get_field(MesgCapabilitiesCountTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_per_file.setter
    def max_per_file(self, value: int):
        field = self.get_field(MesgCapabilitiesCountField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()

    @property
    def max_per_file_type(self) -> Optional[int]:
        field = self.get_field(MesgCapabilitiesCountField.ID)
        type_field = self.get_field(MesgCapabilitiesCountTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [2]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_per_file_type.setter
    def max_per_file_type(self, value: int):
        field = self.get_field(MesgCapabilitiesCountField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MesgCapabilitiesFileField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='file',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MesgCapabilitiesMesgNumField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='mesg_num',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MesgCapabilitiesCountTypeField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='count_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MesgCapabilitiesCountField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='num_per_file',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        MesgCapabilitiesCountTypeField.ID: [0]
                    }),
                SubField(
                    name='max_per_file',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        MesgCapabilitiesCountTypeField.ID: [1]
                    }),
                SubField(
                    name='max_per_file_type',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        MesgCapabilitiesCountTypeField.ID: [2]
                    })
            ]
        )
