# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *
from fit_tool.sub_field import SubField


class LapMessage(DataMessage):
    ID = 19
    NAME = 'lap'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=LapMessage.NAME,
                         global_id=LapMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             LapEventField(
                                 size=self.__get_field_size(definition_message, LapEventField.ID),
                                 growable=definition_message is None),
                             LapEventTypeField(
                                 size=self.__get_field_size(definition_message, LapEventTypeField.ID),
                                 growable=definition_message is None),
                             LapStartTimeField(
                                 size=self.__get_field_size(definition_message, LapStartTimeField.ID),
                                 growable=definition_message is None),
                             LapStartPositionLatField(
                                 size=self.__get_field_size(definition_message, LapStartPositionLatField.ID),
                                 growable=definition_message is None),
                             LapStartPositionLongField(
                                 size=self.__get_field_size(definition_message, LapStartPositionLongField.ID),
                                 growable=definition_message is None),
                             LapEndPositionLatField(
                                 size=self.__get_field_size(definition_message, LapEndPositionLatField.ID),
                                 growable=definition_message is None),
                             LapEndPositionLongField(
                                 size=self.__get_field_size(definition_message, LapEndPositionLongField.ID),
                                 growable=definition_message is None),
                             LapTotalElapsedTimeField(
                                 size=self.__get_field_size(definition_message, LapTotalElapsedTimeField.ID),
                                 growable=definition_message is None),
                             LapTotalTimerTimeField(
                                 size=self.__get_field_size(definition_message, LapTotalTimerTimeField.ID),
                                 growable=definition_message is None),
                             LapTotalDistanceField(
                                 size=self.__get_field_size(definition_message, LapTotalDistanceField.ID),
                                 growable=definition_message is None),
                             LapTotalCyclesField(
                                 size=self.__get_field_size(definition_message, LapTotalCyclesField.ID),
                                 growable=definition_message is None),
                             LapTotalCaloriesField(
                                 size=self.__get_field_size(definition_message, LapTotalCaloriesField.ID),
                                 growable=definition_message is None),
                             LapTotalFatCaloriesField(
                                 size=self.__get_field_size(definition_message, LapTotalFatCaloriesField.ID),
                                 growable=definition_message is None),
                             LapAvgSpeedField(
                                 size=self.__get_field_size(definition_message, LapAvgSpeedField.ID),
                                 growable=definition_message is None),
                             LapMaxSpeedField(
                                 size=self.__get_field_size(definition_message, LapMaxSpeedField.ID),
                                 growable=definition_message is None),
                             LapAvgHeartRateField(
                                 size=self.__get_field_size(definition_message, LapAvgHeartRateField.ID),
                                 growable=definition_message is None),
                             LapMaxHeartRateField(
                                 size=self.__get_field_size(definition_message, LapMaxHeartRateField.ID),
                                 growable=definition_message is None),
                             LapAvgCadenceField(
                                 size=self.__get_field_size(definition_message, LapAvgCadenceField.ID),
                                 growable=definition_message is None),
                             LapMaxCadenceField(
                                 size=self.__get_field_size(definition_message, LapMaxCadenceField.ID),
                                 growable=definition_message is None),
                             LapAvgPowerField(
                                 size=self.__get_field_size(definition_message, LapAvgPowerField.ID),
                                 growable=definition_message is None),
                             LapMaxPowerField(
                                 size=self.__get_field_size(definition_message, LapMaxPowerField.ID),
                                 growable=definition_message is None),
                             LapTotalAscentField(
                                 size=self.__get_field_size(definition_message, LapTotalAscentField.ID),
                                 growable=definition_message is None),
                             LapTotalDescentField(
                                 size=self.__get_field_size(definition_message, LapTotalDescentField.ID),
                                 growable=definition_message is None),
                             LapIntensityField(
                                 size=self.__get_field_size(definition_message, LapIntensityField.ID),
                                 growable=definition_message is None),
                             LapLapTriggerField(
                                 size=self.__get_field_size(definition_message, LapLapTriggerField.ID),
                                 growable=definition_message is None),
                             LapSportField(
                                 size=self.__get_field_size(definition_message, LapSportField.ID),
                                 growable=definition_message is None),
                             LapEventGroupField(
                                 size=self.__get_field_size(definition_message, LapEventGroupField.ID),
                                 growable=definition_message is None),
                             LapNumLengthsField(
                                 size=self.__get_field_size(definition_message, LapNumLengthsField.ID),
                                 growable=definition_message is None),
                             LapNormalizedPowerField(
                                 size=self.__get_field_size(definition_message, LapNormalizedPowerField.ID),
                                 growable=definition_message is None),
                             LapLeftRightBalanceField(
                                 size=self.__get_field_size(definition_message, LapLeftRightBalanceField.ID),
                                 growable=definition_message is None),
                             LapFirstLengthIndexField(
                                 size=self.__get_field_size(definition_message, LapFirstLengthIndexField.ID),
                                 growable=definition_message is None),
                             LapAvgStrokeDistanceField(
                                 size=self.__get_field_size(definition_message, LapAvgStrokeDistanceField.ID),
                                 growable=definition_message is None),
                             LapSwimStrokeField(
                                 size=self.__get_field_size(definition_message, LapSwimStrokeField.ID),
                                 growable=definition_message is None),
                             LapSubSportField(
                                 size=self.__get_field_size(definition_message, LapSubSportField.ID),
                                 growable=definition_message is None),
                             LapNumActiveLengthsField(
                                 size=self.__get_field_size(definition_message, LapNumActiveLengthsField.ID),
                                 growable=definition_message is None),
                             LapTotalWorkField(
                                 size=self.__get_field_size(definition_message, LapTotalWorkField.ID),
                                 growable=definition_message is None),
                             LapAvgAltitudeField(
                                 size=self.__get_field_size(definition_message, LapAvgAltitudeField.ID),
                                 growable=definition_message is None),
                             LapMaxAltitudeField(
                                 size=self.__get_field_size(definition_message, LapMaxAltitudeField.ID),
                                 growable=definition_message is None),
                             LapGpsAccuracyField(
                                 size=self.__get_field_size(definition_message, LapGpsAccuracyField.ID),
                                 growable=definition_message is None),
                             LapAvgGradeField(
                                 size=self.__get_field_size(definition_message, LapAvgGradeField.ID),
                                 growable=definition_message is None),
                             LapAvgPosGradeField(
                                 size=self.__get_field_size(definition_message, LapAvgPosGradeField.ID),
                                 growable=definition_message is None),
                             LapAvgNegGradeField(
                                 size=self.__get_field_size(definition_message, LapAvgNegGradeField.ID),
                                 growable=definition_message is None),
                             LapMaxPosGradeField(
                                 size=self.__get_field_size(definition_message, LapMaxPosGradeField.ID),
                                 growable=definition_message is None),
                             LapMaxNegGradeField(
                                 size=self.__get_field_size(definition_message, LapMaxNegGradeField.ID),
                                 growable=definition_message is None),
                             LapAvgTemperatureField(
                                 size=self.__get_field_size(definition_message, LapAvgTemperatureField.ID),
                                 growable=definition_message is None),
                             LapMaxTemperatureField(
                                 size=self.__get_field_size(definition_message, LapMaxTemperatureField.ID),
                                 growable=definition_message is None),
                             LapTotalMovingTimeField(
                                 size=self.__get_field_size(definition_message, LapTotalMovingTimeField.ID),
                                 growable=definition_message is None),
                             LapAvgPosVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, LapAvgPosVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             LapAvgNegVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, LapAvgNegVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             LapMaxPosVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, LapMaxPosVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             LapMaxNegVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, LapMaxNegVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             LapTimeInHrZoneField(
                                 size=self.__get_field_size(definition_message, LapTimeInHrZoneField.ID),
                                 growable=definition_message is None),
                             LapTimeInSpeedZoneField(
                                 size=self.__get_field_size(definition_message, LapTimeInSpeedZoneField.ID),
                                 growable=definition_message is None),
                             LapTimeInCadenceZoneField(
                                 size=self.__get_field_size(definition_message, LapTimeInCadenceZoneField.ID),
                                 growable=definition_message is None),
                             LapTimeInPowerZoneField(
                                 size=self.__get_field_size(definition_message, LapTimeInPowerZoneField.ID),
                                 growable=definition_message is None),
                             LapRepetitionNumField(
                                 size=self.__get_field_size(definition_message, LapRepetitionNumField.ID),
                                 growable=definition_message is None),
                             LapMinAltitudeField(
                                 size=self.__get_field_size(definition_message, LapMinAltitudeField.ID),
                                 growable=definition_message is None),
                             LapMinHeartRateField(
                                 size=self.__get_field_size(definition_message, LapMinHeartRateField.ID),
                                 growable=definition_message is None),
                             LapWorkoutStepIndexField(
                                 size=self.__get_field_size(definition_message, LapWorkoutStepIndexField.ID),
                                 growable=definition_message is None),
                             LapOpponentScoreField(
                                 size=self.__get_field_size(definition_message, LapOpponentScoreField.ID),
                                 growable=definition_message is None),
                             LapStrokeCountField(
                                 size=self.__get_field_size(definition_message, LapStrokeCountField.ID),
                                 growable=definition_message is None),
                             LapZoneCountField(
                                 size=self.__get_field_size(definition_message, LapZoneCountField.ID),
                                 growable=definition_message is None),
                             LapAvgVerticalOscillationField(
                                 size=self.__get_field_size(definition_message, LapAvgVerticalOscillationField.ID),
                                 growable=definition_message is None),
                             LapAvgStanceTimePercentField(
                                 size=self.__get_field_size(definition_message, LapAvgStanceTimePercentField.ID),
                                 growable=definition_message is None),
                             LapAvgStanceTimeField(
                                 size=self.__get_field_size(definition_message, LapAvgStanceTimeField.ID),
                                 growable=definition_message is None),
                             LapAvgFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, LapAvgFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             LapMaxFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, LapMaxFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             LapTotalFractionalCyclesField(
                                 size=self.__get_field_size(definition_message, LapTotalFractionalCyclesField.ID),
                                 growable=definition_message is None),
                             LapPlayerScoreField(
                                 size=self.__get_field_size(definition_message, LapPlayerScoreField.ID),
                                 growable=definition_message is None),
                             LapAvgTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, LapAvgTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             LapMinTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, LapMinTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             LapMaxTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, LapMaxTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             LapAvgSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            LapAvgSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             LapMinSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            LapMinSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             LapMaxSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            LapMaxSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             LapAvgLeftTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message, LapAvgLeftTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             LapAvgRightTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message, LapAvgRightTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             LapAvgLeftPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, LapAvgLeftPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             LapAvgRightPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, LapAvgRightPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             LapAvgCombinedPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, LapAvgCombinedPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             LapTimeStandingField(
                                 size=self.__get_field_size(definition_message, LapTimeStandingField.ID),
                                 growable=definition_message is None),
                             LapStandCountField(
                                 size=self.__get_field_size(definition_message, LapStandCountField.ID),
                                 growable=definition_message is None),
                             LapAvgLeftPcoField(
                                 size=self.__get_field_size(definition_message, LapAvgLeftPcoField.ID),
                                 growable=definition_message is None),
                             LapAvgRightPcoField(
                                 size=self.__get_field_size(definition_message, LapAvgRightPcoField.ID),
                                 growable=definition_message is None),
                             LapAvgLeftPowerPhaseField(
                                 size=self.__get_field_size(definition_message, LapAvgLeftPowerPhaseField.ID),
                                 growable=definition_message is None),
                             LapAvgLeftPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message, LapAvgLeftPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             LapAvgRightPowerPhaseField(
                                 size=self.__get_field_size(definition_message, LapAvgRightPowerPhaseField.ID),
                                 growable=definition_message is None),
                             LapAvgRightPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message, LapAvgRightPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             LapAvgPowerPositionField(
                                 size=self.__get_field_size(definition_message, LapAvgPowerPositionField.ID),
                                 growable=definition_message is None),
                             LapMaxPowerPositionField(
                                 size=self.__get_field_size(definition_message, LapMaxPowerPositionField.ID),
                                 growable=definition_message is None),
                             LapAvgCadencePositionField(
                                 size=self.__get_field_size(definition_message, LapAvgCadencePositionField.ID),
                                 growable=definition_message is None),
                             LapMaxCadencePositionField(
                                 size=self.__get_field_size(definition_message, LapMaxCadencePositionField.ID),
                                 growable=definition_message is None),
                             LapEnhancedAvgSpeedField(
                                 size=self.__get_field_size(definition_message, LapEnhancedAvgSpeedField.ID),
                                 growable=definition_message is None),
                             LapEnhancedMaxSpeedField(
                                 size=self.__get_field_size(definition_message, LapEnhancedMaxSpeedField.ID),
                                 growable=definition_message is None),
                             LapEnhancedAvgAltitudeField(
                                 size=self.__get_field_size(definition_message, LapEnhancedAvgAltitudeField.ID),
                                 growable=definition_message is None),
                             LapEnhancedMinAltitudeField(
                                 size=self.__get_field_size(definition_message, LapEnhancedMinAltitudeField.ID),
                                 growable=definition_message is None),
                             LapEnhancedMaxAltitudeField(
                                 size=self.__get_field_size(definition_message, LapEnhancedMaxAltitudeField.ID),
                                 growable=definition_message is None),
                             LapAvgLevMotorPowerField(
                                 size=self.__get_field_size(definition_message, LapAvgLevMotorPowerField.ID),
                                 growable=definition_message is None),
                             LapMaxLevMotorPowerField(
                                 size=self.__get_field_size(definition_message, LapMaxLevMotorPowerField.ID),
                                 growable=definition_message is None),
                             LapLevBatteryConsumptionField(
                                 size=self.__get_field_size(definition_message, LapLevBatteryConsumptionField.ID),
                                 growable=definition_message is None),
                             LapAvgVerticalRatioField(
                                 size=self.__get_field_size(definition_message, LapAvgVerticalRatioField.ID),
                                 growable=definition_message is None),
                             LapAvgStanceTimeBalanceField(
                                 size=self.__get_field_size(definition_message, LapAvgStanceTimeBalanceField.ID),
                                 growable=definition_message is None),
                             LapAvgStepLengthField(
                                 size=self.__get_field_size(definition_message, LapAvgStepLengthField.ID),
                                 growable=definition_message is None),
                             LapAvgVamField(
                                 size=self.__get_field_size(definition_message, LapAvgVamField.ID),
                                 growable=definition_message is None),
                             LapTotalGritField(
                                 size=self.__get_field_size(definition_message, LapTotalGritField.ID),
                                 growable=definition_message is None),
                             LapTotalFlowField(
                                 size=self.__get_field_size(definition_message, LapTotalFlowField.ID),
                                 growable=definition_message is None),
                             LapJumpCountField(
                                 size=self.__get_field_size(definition_message, LapJumpCountField.ID),
                                 growable=definition_message is None),
                             LapAvgGritField(
                                 size=self.__get_field_size(definition_message, LapAvgGritField.ID),
                                 growable=definition_message is None),
                             LapAvgFlowField(
                                 size=self.__get_field_size(definition_message, LapAvgFlowField.ID),
                                 growable=definition_message is None),
                             LapTotalFractionalAscentField(
                                 size=self.__get_field_size(definition_message, LapTotalFractionalAscentField.ID),
                                 growable=definition_message is None),
                             LapTotalFractionalDescentField(
                                 size=self.__get_field_size(definition_message, LapTotalFractionalDescentField.ID),
                                 growable=definition_message is None),
                             LapAvgCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, LapAvgCoreTemperatureField.ID),
                                 growable=definition_message is None),
                             LapMinCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, LapMinCoreTemperatureField.ID),
                                 growable=definition_message is None),
                             LapMaxCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, LapMaxCoreTemperatureField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event(self) -> Optional[Event]:
        field = self.get_field(LapEventField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event.setter
    def event(self, value: Event):
        field = self.get_field(LapEventField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_type(self) -> Optional[EventType]:
        field = self.get_field(LapEventTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_type.setter
    def event_type(self, value: EventType):
        field = self.get_field(LapEventTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def start_time(self) -> Optional[int]:
        field = self.get_field(LapStartTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @start_time.setter
    def start_time(self, value: int):
        field = self.get_field(LapStartTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_position_lat(self) -> Optional[float]:
        field = self.get_field(LapStartPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_position_lat.setter
    def start_position_lat(self, value: float):
        field = self.get_field(LapStartPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_position_long(self) -> Optional[float]:
        field = self.get_field(LapStartPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_position_long.setter
    def start_position_long(self, value: float):
        field = self.get_field(LapStartPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def end_position_lat(self) -> Optional[float]:
        field = self.get_field(LapEndPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @end_position_lat.setter
    def end_position_lat(self, value: float):
        field = self.get_field(LapEndPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def end_position_long(self) -> Optional[float]:
        field = self.get_field(LapEndPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @end_position_long.setter
    def end_position_long(self, value: float):
        field = self.get_field(LapEndPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_elapsed_time(self) -> Optional[float]:
        field = self.get_field(LapTotalElapsedTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_elapsed_time.setter
    def total_elapsed_time(self, value: float):
        field = self.get_field(LapTotalElapsedTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_timer_time(self) -> Optional[float]:
        field = self.get_field(LapTotalTimerTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_timer_time.setter
    def total_timer_time(self, value: float):
        field = self.get_field(LapTotalTimerTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_distance(self) -> Optional[float]:
        field = self.get_field(LapTotalDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_distance.setter
    def total_distance(self, value: float):
        field = self.get_field(LapTotalDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_cycles(self) -> Optional[int]:
        field = self.get_field(LapTotalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_cycles.setter
    def total_cycles(self, value: int):
        field = self.get_field(LapTotalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_strides(self) -> Optional[int]:
        field = self.get_field(LapTotalCyclesField.ID)
        type_field = self.get_field(LapSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1, 11]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_strides.setter
    def total_strides(self, value: int):
        field = self.get_field(LapTotalCyclesField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()

    @property
    def total_strokes(self) -> Optional[int]:
        field = self.get_field(LapTotalCyclesField.ID)
        type_field = self.get_field(LapSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [2, 5, 15, 37]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_strokes.setter
    def total_strokes(self, value: int):
        field = self.get_field(LapTotalCyclesField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()

    @property
    def total_calories(self) -> Optional[int]:
        field = self.get_field(LapTotalCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_calories.setter
    def total_calories(self, value: int):
        field = self.get_field(LapTotalCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fat_calories(self) -> Optional[int]:
        field = self.get_field(LapTotalFatCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fat_calories.setter
    def total_fat_calories(self, value: int):
        field = self.get_field(LapTotalFatCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_speed(self) -> Optional[float]:
        field = self.get_field(LapAvgSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_speed.setter
    def avg_speed(self, value: float):
        field = self.get_field(LapAvgSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_speed(self) -> Optional[float]:
        field = self.get_field(LapMaxSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_speed.setter
    def max_speed(self, value: float):
        field = self.get_field(LapMaxSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_heart_rate(self) -> Optional[int]:
        field = self.get_field(LapAvgHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_heart_rate.setter
    def avg_heart_rate(self, value: int):
        field = self.get_field(LapAvgHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_heart_rate(self) -> Optional[int]:
        field = self.get_field(LapMaxHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_heart_rate.setter
    def max_heart_rate(self, value: int):
        field = self.get_field(LapMaxHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_cadence(self) -> Optional[int]:
        field = self.get_field(LapAvgCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_cadence.setter
    def avg_cadence(self, value: int):
        field = self.get_field(LapAvgCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_running_cadence(self) -> Optional[int]:
        field = self.get_field(LapAvgCadenceField.ID)
        type_field = self.get_field(LapSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_running_cadence.setter
    def avg_running_cadence(self, value: int):
        field = self.get_field(LapAvgCadenceField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()

    @property
    def max_cadence(self) -> Optional[int]:
        field = self.get_field(LapMaxCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_cadence.setter
    def max_cadence(self, value: int):
        field = self.get_field(LapMaxCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_running_cadence(self) -> Optional[int]:
        field = self.get_field(LapMaxCadenceField.ID)
        type_field = self.get_field(LapSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_running_cadence.setter
    def max_running_cadence(self, value: int):
        field = self.get_field(LapMaxCadenceField.ID)
        if field:
            if value:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)
            else:
                field.clear()

    @property
    def avg_power(self) -> Optional[int]:
        field = self.get_field(LapAvgPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_power.setter
    def avg_power(self, value: int):
        field = self.get_field(LapAvgPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_power(self) -> Optional[int]:
        field = self.get_field(LapMaxPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_power.setter
    def max_power(self, value: int):
        field = self.get_field(LapMaxPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_ascent(self) -> Optional[int]:
        field = self.get_field(LapTotalAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_ascent.setter
    def total_ascent(self, value: int):
        field = self.get_field(LapTotalAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_descent(self) -> Optional[int]:
        field = self.get_field(LapTotalDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_descent.setter
    def total_descent(self, value: int):
        field = self.get_field(LapTotalDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def intensity(self) -> Optional[Intensity]:
        field = self.get_field(LapIntensityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @intensity.setter
    def intensity(self, value: Intensity):
        field = self.get_field(LapIntensityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def lap_trigger(self) -> Optional[LapTrigger]:
        field = self.get_field(LapLapTriggerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @lap_trigger.setter
    def lap_trigger(self, value: LapTrigger):
        field = self.get_field(LapLapTriggerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(LapSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(LapSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_group(self) -> Optional[int]:
        field = self.get_field(LapEventGroupField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_group.setter
    def event_group(self, value: int):
        field = self.get_field(LapEventGroupField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_lengths(self) -> Optional[int]:
        field = self.get_field(LapNumLengthsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_lengths.setter
    def num_lengths(self, value: int):
        field = self.get_field(LapNumLengthsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def normalized_power(self) -> Optional[int]:
        field = self.get_field(LapNormalizedPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @normalized_power.setter
    def normalized_power(self, value: int):
        field = self.get_field(LapNormalizedPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_right_balance(self) -> Optional[int]:
        field = self.get_field(LapLeftRightBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_right_balance.setter
    def left_right_balance(self, value: int):
        field = self.get_field(LapLeftRightBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def first_length_index(self) -> Optional[int]:
        field = self.get_field(LapFirstLengthIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @first_length_index.setter
    def first_length_index(self, value: int):
        field = self.get_field(LapFirstLengthIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stroke_distance(self) -> Optional[float]:
        field = self.get_field(LapAvgStrokeDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stroke_distance.setter
    def avg_stroke_distance(self, value: float):
        field = self.get_field(LapAvgStrokeDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def swim_stroke(self) -> Optional[SwimStroke]:
        field = self.get_field(LapSwimStrokeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @swim_stroke.setter
    def swim_stroke(self, value: SwimStroke):
        field = self.get_field(LapSwimStrokeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sub_sport(self) -> Optional[SubSport]:
        field = self.get_field(LapSubSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sub_sport.setter
    def sub_sport(self, value: SubSport):
        field = self.get_field(LapSubSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_active_lengths(self) -> Optional[int]:
        field = self.get_field(LapNumActiveLengthsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_active_lengths.setter
    def num_active_lengths(self, value: int):
        field = self.get_field(LapNumActiveLengthsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_work(self) -> Optional[int]:
        field = self.get_field(LapTotalWorkField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_work.setter
    def total_work(self, value: int):
        field = self.get_field(LapTotalWorkField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_altitude(self) -> Optional[float]:
        field = self.get_field(LapAvgAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_altitude.setter
    def avg_altitude(self, value: float):
        field = self.get_field(LapAvgAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_altitude(self) -> Optional[float]:
        field = self.get_field(LapMaxAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_altitude.setter
    def max_altitude(self, value: float):
        field = self.get_field(LapMaxAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def gps_accuracy(self) -> Optional[int]:
        field = self.get_field(LapGpsAccuracyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @gps_accuracy.setter
    def gps_accuracy(self, value: int):
        field = self.get_field(LapGpsAccuracyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_grade(self) -> Optional[float]:
        field = self.get_field(LapAvgGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_grade.setter
    def avg_grade(self, value: float):
        field = self.get_field(LapAvgGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_pos_grade(self) -> Optional[float]:
        field = self.get_field(LapAvgPosGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_pos_grade.setter
    def avg_pos_grade(self, value: float):
        field = self.get_field(LapAvgPosGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_neg_grade(self) -> Optional[float]:
        field = self.get_field(LapAvgNegGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_neg_grade.setter
    def avg_neg_grade(self, value: float):
        field = self.get_field(LapAvgNegGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_pos_grade(self) -> Optional[float]:
        field = self.get_field(LapMaxPosGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_pos_grade.setter
    def max_pos_grade(self, value: float):
        field = self.get_field(LapMaxPosGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_neg_grade(self) -> Optional[float]:
        field = self.get_field(LapMaxNegGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_neg_grade.setter
    def max_neg_grade(self, value: float):
        field = self.get_field(LapMaxNegGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_temperature(self) -> Optional[int]:
        field = self.get_field(LapAvgTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_temperature.setter
    def avg_temperature(self, value: int):
        field = self.get_field(LapAvgTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_temperature(self) -> Optional[int]:
        field = self.get_field(LapMaxTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_temperature.setter
    def max_temperature(self, value: int):
        field = self.get_field(LapMaxTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_moving_time(self) -> Optional[float]:
        field = self.get_field(LapTotalMovingTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_moving_time.setter
    def total_moving_time(self, value: float):
        field = self.get_field(LapTotalMovingTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_pos_vertical_speed(self) -> Optional[float]:
        field = self.get_field(LapAvgPosVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_pos_vertical_speed.setter
    def avg_pos_vertical_speed(self, value: float):
        field = self.get_field(LapAvgPosVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_neg_vertical_speed(self) -> Optional[float]:
        field = self.get_field(LapAvgNegVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_neg_vertical_speed.setter
    def avg_neg_vertical_speed(self, value: float):
        field = self.get_field(LapAvgNegVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_pos_vertical_speed(self) -> Optional[float]:
        field = self.get_field(LapMaxPosVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_pos_vertical_speed.setter
    def max_pos_vertical_speed(self, value: float):
        field = self.get_field(LapMaxPosVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_neg_vertical_speed(self) -> Optional[float]:
        field = self.get_field(LapMaxNegVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_neg_vertical_speed.setter
    def max_neg_vertical_speed(self, value: float):
        field = self.get_field(LapMaxNegVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_hr_zone(self) -> Optional[float]:
        field = self.get_field(LapTimeInHrZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_hr_zone.setter
    def time_in_hr_zone(self, value: float):
        field = self.get_field(LapTimeInHrZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_speed_zone(self) -> Optional[float]:
        field = self.get_field(LapTimeInSpeedZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_speed_zone.setter
    def time_in_speed_zone(self, value: float):
        field = self.get_field(LapTimeInSpeedZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_cadence_zone(self) -> Optional[float]:
        field = self.get_field(LapTimeInCadenceZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_cadence_zone.setter
    def time_in_cadence_zone(self, value: float):
        field = self.get_field(LapTimeInCadenceZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_power_zone(self) -> Optional[float]:
        field = self.get_field(LapTimeInPowerZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_power_zone.setter
    def time_in_power_zone(self, value: float):
        field = self.get_field(LapTimeInPowerZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def repetition_num(self) -> Optional[int]:
        field = self.get_field(LapRepetitionNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @repetition_num.setter
    def repetition_num(self, value: int):
        field = self.get_field(LapRepetitionNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_altitude(self) -> Optional[float]:
        field = self.get_field(LapMinAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_altitude.setter
    def min_altitude(self, value: float):
        field = self.get_field(LapMinAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_heart_rate(self) -> Optional[int]:
        field = self.get_field(LapMinHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_heart_rate.setter
    def min_heart_rate(self, value: int):
        field = self.get_field(LapMinHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def workout_step_index(self) -> Optional[int]:
        field = self.get_field(LapWorkoutStepIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @workout_step_index.setter
    def workout_step_index(self, value: int):
        field = self.get_field(LapWorkoutStepIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def opponent_score(self) -> Optional[int]:
        field = self.get_field(LapOpponentScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @opponent_score.setter
    def opponent_score(self, value: int):
        field = self.get_field(LapOpponentScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stroke_count(self) -> Optional[int]:
        field = self.get_field(LapStrokeCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stroke_count.setter
    def stroke_count(self, value: int):
        field = self.get_field(LapStrokeCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def zone_count(self) -> Optional[int]:
        field = self.get_field(LapZoneCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @zone_count.setter
    def zone_count(self, value: int):
        field = self.get_field(LapZoneCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_vertical_oscillation(self) -> Optional[float]:
        field = self.get_field(LapAvgVerticalOscillationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_vertical_oscillation.setter
    def avg_vertical_oscillation(self, value: float):
        field = self.get_field(LapAvgVerticalOscillationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stance_time_percent(self) -> Optional[float]:
        field = self.get_field(LapAvgStanceTimePercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stance_time_percent.setter
    def avg_stance_time_percent(self, value: float):
        field = self.get_field(LapAvgStanceTimePercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stance_time(self) -> Optional[float]:
        field = self.get_field(LapAvgStanceTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stance_time.setter
    def avg_stance_time(self, value: float):
        field = self.get_field(LapAvgStanceTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_fractional_cadence(self) -> Optional[float]:
        field = self.get_field(LapAvgFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_fractional_cadence.setter
    def avg_fractional_cadence(self, value: float):
        field = self.get_field(LapAvgFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_fractional_cadence(self) -> Optional[float]:
        field = self.get_field(LapMaxFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_fractional_cadence.setter
    def max_fractional_cadence(self, value: float):
        field = self.get_field(LapMaxFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_cycles(self) -> Optional[float]:
        field = self.get_field(LapTotalFractionalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_cycles.setter
    def total_fractional_cycles(self, value: float):
        field = self.get_field(LapTotalFractionalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def player_score(self) -> Optional[int]:
        field = self.get_field(LapPlayerScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @player_score.setter
    def player_score(self, value: int):
        field = self.get_field(LapPlayerScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(LapAvgTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_total_hemoglobin_conc.setter
    def avg_total_hemoglobin_conc(self, value: float):
        field = self.get_field(LapAvgTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(LapMinTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_total_hemoglobin_conc.setter
    def min_total_hemoglobin_conc(self, value: float):
        field = self.get_field(LapMinTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(LapMaxTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_total_hemoglobin_conc.setter
    def max_total_hemoglobin_conc(self, value: float):
        field = self.get_field(LapMaxTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(LapAvgSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_saturated_hemoglobin_percent.setter
    def avg_saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(LapAvgSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(LapMinSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_saturated_hemoglobin_percent.setter
    def min_saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(LapMinSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(LapMaxSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_saturated_hemoglobin_percent.setter
    def max_saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(LapMaxSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(LapAvgLeftTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_torque_effectiveness.setter
    def avg_left_torque_effectiveness(self, value: float):
        field = self.get_field(LapAvgLeftTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(LapAvgRightTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_torque_effectiveness.setter
    def avg_right_torque_effectiveness(self, value: float):
        field = self.get_field(LapAvgRightTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(LapAvgLeftPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_pedal_smoothness.setter
    def avg_left_pedal_smoothness(self, value: float):
        field = self.get_field(LapAvgLeftPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(LapAvgRightPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_pedal_smoothness.setter
    def avg_right_pedal_smoothness(self, value: float):
        field = self.get_field(LapAvgRightPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_combined_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(LapAvgCombinedPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_combined_pedal_smoothness.setter
    def avg_combined_pedal_smoothness(self, value: float):
        field = self.get_field(LapAvgCombinedPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_standing(self) -> Optional[float]:
        field = self.get_field(LapTimeStandingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_standing.setter
    def time_standing(self, value: float):
        field = self.get_field(LapTimeStandingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stand_count(self) -> Optional[int]:
        field = self.get_field(LapStandCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stand_count.setter
    def stand_count(self, value: int):
        field = self.get_field(LapStandCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_pco(self) -> Optional[int]:
        field = self.get_field(LapAvgLeftPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_pco.setter
    def avg_left_pco(self, value: int):
        field = self.get_field(LapAvgLeftPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_pco(self) -> Optional[int]:
        field = self.get_field(LapAvgRightPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_pco.setter
    def avg_right_pco(self, value: int):
        field = self.get_field(LapAvgRightPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_power_phase(self) -> Optional[float]:
        field = self.get_field(LapAvgLeftPowerPhaseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_power_phase.setter
    def avg_left_power_phase(self, value: float):
        field = self.get_field(LapAvgLeftPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_power_phase_peak(self) -> Optional[float]:
        field = self.get_field(LapAvgLeftPowerPhasePeakField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_power_phase_peak.setter
    def avg_left_power_phase_peak(self, value: float):
        field = self.get_field(LapAvgLeftPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_power_phase(self) -> Optional[float]:
        field = self.get_field(LapAvgRightPowerPhaseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_power_phase.setter
    def avg_right_power_phase(self, value: float):
        field = self.get_field(LapAvgRightPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_power_phase_peak(self) -> Optional[float]:
        field = self.get_field(LapAvgRightPowerPhasePeakField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_power_phase_peak.setter
    def avg_right_power_phase_peak(self, value: float):
        field = self.get_field(LapAvgRightPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_power_position(self) -> Optional[int]:
        field = self.get_field(LapAvgPowerPositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_power_position.setter
    def avg_power_position(self, value: int):
        field = self.get_field(LapAvgPowerPositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_power_position(self) -> Optional[int]:
        field = self.get_field(LapMaxPowerPositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_power_position.setter
    def max_power_position(self, value: int):
        field = self.get_field(LapMaxPowerPositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_cadence_position(self) -> Optional[int]:
        field = self.get_field(LapAvgCadencePositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_cadence_position.setter
    def avg_cadence_position(self, value: int):
        field = self.get_field(LapAvgCadencePositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_cadence_position(self) -> Optional[int]:
        field = self.get_field(LapMaxCadencePositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_cadence_position.setter
    def max_cadence_position(self, value: int):
        field = self.get_field(LapMaxCadencePositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_avg_speed(self) -> Optional[float]:
        field = self.get_field(LapEnhancedAvgSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_avg_speed.setter
    def enhanced_avg_speed(self, value: float):
        field = self.get_field(LapEnhancedAvgSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_max_speed(self) -> Optional[float]:
        field = self.get_field(LapEnhancedMaxSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_max_speed.setter
    def enhanced_max_speed(self, value: float):
        field = self.get_field(LapEnhancedMaxSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_avg_altitude(self) -> Optional[float]:
        field = self.get_field(LapEnhancedAvgAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_avg_altitude.setter
    def enhanced_avg_altitude(self, value: float):
        field = self.get_field(LapEnhancedAvgAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_min_altitude(self) -> Optional[float]:
        field = self.get_field(LapEnhancedMinAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_min_altitude.setter
    def enhanced_min_altitude(self, value: float):
        field = self.get_field(LapEnhancedMinAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_max_altitude(self) -> Optional[float]:
        field = self.get_field(LapEnhancedMaxAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_max_altitude.setter
    def enhanced_max_altitude(self, value: float):
        field = self.get_field(LapEnhancedMaxAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_lev_motor_power(self) -> Optional[int]:
        field = self.get_field(LapAvgLevMotorPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_lev_motor_power.setter
    def avg_lev_motor_power(self, value: int):
        field = self.get_field(LapAvgLevMotorPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_lev_motor_power(self) -> Optional[int]:
        field = self.get_field(LapMaxLevMotorPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_lev_motor_power.setter
    def max_lev_motor_power(self, value: int):
        field = self.get_field(LapMaxLevMotorPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def lev_battery_consumption(self) -> Optional[float]:
        field = self.get_field(LapLevBatteryConsumptionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @lev_battery_consumption.setter
    def lev_battery_consumption(self, value: float):
        field = self.get_field(LapLevBatteryConsumptionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_vertical_ratio(self) -> Optional[float]:
        field = self.get_field(LapAvgVerticalRatioField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_vertical_ratio.setter
    def avg_vertical_ratio(self, value: float):
        field = self.get_field(LapAvgVerticalRatioField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stance_time_balance(self) -> Optional[float]:
        field = self.get_field(LapAvgStanceTimeBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stance_time_balance.setter
    def avg_stance_time_balance(self, value: float):
        field = self.get_field(LapAvgStanceTimeBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_step_length(self) -> Optional[float]:
        field = self.get_field(LapAvgStepLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_step_length.setter
    def avg_step_length(self, value: float):
        field = self.get_field(LapAvgStepLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_vam(self) -> Optional[float]:
        field = self.get_field(LapAvgVamField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_vam.setter
    def avg_vam(self, value: float):
        field = self.get_field(LapAvgVamField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_grit(self) -> Optional[float]:
        field = self.get_field(LapTotalGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_grit.setter
    def total_grit(self, value: float):
        field = self.get_field(LapTotalGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_flow(self) -> Optional[float]:
        field = self.get_field(LapTotalFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_flow.setter
    def total_flow(self, value: float):
        field = self.get_field(LapTotalFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def jump_count(self) -> Optional[int]:
        field = self.get_field(LapJumpCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @jump_count.setter
    def jump_count(self, value: int):
        field = self.get_field(LapJumpCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_grit(self) -> Optional[float]:
        field = self.get_field(LapAvgGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_grit.setter
    def avg_grit(self, value: float):
        field = self.get_field(LapAvgGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_flow(self) -> Optional[float]:
        field = self.get_field(LapAvgFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_flow.setter
    def avg_flow(self, value: float):
        field = self.get_field(LapAvgFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_ascent(self) -> Optional[float]:
        field = self.get_field(LapTotalFractionalAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_ascent.setter
    def total_fractional_ascent(self, value: float):
        field = self.get_field(LapTotalFractionalAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_descent(self) -> Optional[float]:
        field = self.get_field(LapTotalFractionalDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_descent.setter
    def total_fractional_descent(self, value: float):
        field = self.get_field(LapTotalFractionalDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_core_temperature(self) -> Optional[float]:
        field = self.get_field(LapAvgCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_core_temperature.setter
    def avg_core_temperature(self, value: float):
        field = self.get_field(LapAvgCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_core_temperature(self) -> Optional[float]:
        field = self.get_field(LapMinCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_core_temperature.setter
    def min_core_temperature(self, value: float):
        field = self.get_field(LapMinCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_core_temperature(self) -> Optional[float]:
        field = self.get_field(LapMaxCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_core_temperature.setter
    def max_core_temperature(self, value: float):
        field = self.get_field(LapMaxCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEventField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapEventTypeField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapStartTimeField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class LapStartPositionLatField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapStartPositionLongField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEndPositionLatField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='end_position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEndPositionLongField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='end_position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalElapsedTimeField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_elapsed_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalTimerTimeField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_timer_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalDistanceField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_distance',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalCyclesField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='total_strides',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='strides',
                    reference_map={
                        LapSportField.ID: [1, 11]
                    }),
                SubField(
                    name='total_strokes',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='strokes',
                    reference_map={
                        LapSportField.ID: [2, 5, 15, 37]
                    })
            ]
        )


class LapTotalCaloriesField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalFatCaloriesField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fat_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgSpeedField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxSpeedField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgHeartRateField(Field):
    ID = 15

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxHeartRateField(Field):
    ID = 16

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgCadenceField(Field):
    ID = 17

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='avg_running_cadence',
                    base_type=BaseType.UINT8,
                    scale=1,
                    offset=0,
                    units='strides/min',
                    reference_map={
                        LapSportField.ID: [1]
                    })
            ]
        )


class LapMaxCadenceField(Field):
    ID = 18

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='max_running_cadence',
                    base_type=BaseType.UINT8,
                    scale=1,
                    offset=0,
                    units='strides/min',
                    reference_map={
                        LapSportField.ID: [1]
                    })
            ]
        )


class LapAvgPowerField(Field):
    ID = 19

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxPowerField(Field):
    ID = 20

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalAscentField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_ascent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalDescentField(Field):
    ID = 22

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_descent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapIntensityField(Field):
    ID = 23

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='intensity',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapLapTriggerField(Field):
    ID = 24

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='lap_trigger',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapSportField(Field):
    ID = 25

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapEventGroupField(Field):
    ID = 26

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_group',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapNumLengthsField(Field):
    ID = 32

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_lengths',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='lengths',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapNormalizedPowerField(Field):
    ID = 33

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='normalized_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapLeftRightBalanceField(Field):
    ID = 34

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_right_balance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapFirstLengthIndexField(Field):
    ID = 35

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='first_length_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgStrokeDistanceField(Field):
    ID = 37

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stroke_distance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapSwimStrokeField(Field):
    ID = 38

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='swim_stroke',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapSubSportField(Field):
    ID = 39

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sub_sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapNumActiveLengthsField(Field):
    ID = 40

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_active_lengths',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='lengths',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalWorkField(Field):
    ID = 41

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_work',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='J',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgAltitudeField(Field):
    ID = 42

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxAltitudeField(Field):
    ID = 43

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapGpsAccuracyField(Field):
    ID = 44

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='gps_accuracy',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgGradeField(Field):
    ID = 45

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgPosGradeField(Field):
    ID = 46

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_pos_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgNegGradeField(Field):
    ID = 47

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_neg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxPosGradeField(Field):
    ID = 48

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_pos_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxNegGradeField(Field):
    ID = 49

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_neg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgTemperatureField(Field):
    ID = 50

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxTemperatureField(Field):
    ID = 51

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalMovingTimeField(Field):
    ID = 52

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_moving_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgPosVerticalSpeedField(Field):
    ID = 53

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_pos_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgNegVerticalSpeedField(Field):
    ID = 54

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_neg_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxPosVerticalSpeedField(Field):
    ID = 55

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_pos_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxNegVerticalSpeedField(Field):
    ID = 56

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_neg_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTimeInHrZoneField(Field):
    ID = 57

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_hr_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTimeInSpeedZoneField(Field):
    ID = 58

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_speed_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTimeInCadenceZoneField(Field):
    ID = 59

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_cadence_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTimeInPowerZoneField(Field):
    ID = 60

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_power_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapRepetitionNumField(Field):
    ID = 61

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='repetition_num',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapMinAltitudeField(Field):
    ID = 62

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMinHeartRateField(Field):
    ID = 63

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapWorkoutStepIndexField(Field):
    ID = 71

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wkt_step_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapOpponentScoreField(Field):
    ID = 74

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='opponent_score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapStrokeCountField(Field):
    ID = 75

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stroke_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='counts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapZoneCountField(Field):
    ID = 76

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='zone_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='counts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgVerticalOscillationField(Field):
    ID = 77

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_vertical_oscillation',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgStanceTimePercentField(Field):
    ID = 78

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stance_time_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgStanceTimeField(Field):
    ID = 79

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stance_time',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='ms',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgFractionalCadenceField(Field):
    ID = 80

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxFractionalCadenceField(Field):
    ID = 81

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalFractionalCyclesField(Field):
    ID = 82

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapPlayerScoreField(Field):
    ID = 83

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='player_score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgTotalHemoglobinConcField(Field):
    ID = 84

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMinTotalHemoglobinConcField(Field):
    ID = 85

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxTotalHemoglobinConcField(Field):
    ID = 86

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgSaturatedHemoglobinPercentField(Field):
    ID = 87

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMinSaturatedHemoglobinPercentField(Field):
    ID = 88

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxSaturatedHemoglobinPercentField(Field):
    ID = 89

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgLeftTorqueEffectivenessField(Field):
    ID = 91

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgRightTorqueEffectivenessField(Field):
    ID = 92

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgLeftPedalSmoothnessField(Field):
    ID = 93

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgRightPedalSmoothnessField(Field):
    ID = 94

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgCombinedPedalSmoothnessField(Field):
    ID = 95

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_combined_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTimeStandingField(Field):
    ID = 98

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_standing',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapStandCountField(Field):
    ID = 99

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stand_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgLeftPcoField(Field):
    ID = 100

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgRightPcoField(Field):
    ID = 101

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgLeftPowerPhaseField(Field):
    ID = 102

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgLeftPowerPhasePeakField(Field):
    ID = 103

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgRightPowerPhaseField(Field):
    ID = 104

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgRightPowerPhasePeakField(Field):
    ID = 105

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgPowerPositionField(Field):
    ID = 106

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_power_position',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxPowerPositionField(Field):
    ID = 107

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_power_position',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgCadencePositionField(Field):
    ID = 108

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_cadence_position',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxCadencePositionField(Field):
    ID = 109

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_cadence_position',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEnhancedAvgSpeedField(Field):
    ID = 110

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_avg_speed',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEnhancedMaxSpeedField(Field):
    ID = 111

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_max_speed',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEnhancedAvgAltitudeField(Field):
    ID = 112

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_avg_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEnhancedMinAltitudeField(Field):
    ID = 113

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_min_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapEnhancedMaxAltitudeField(Field):
    ID = 114

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_max_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgLevMotorPowerField(Field):
    ID = 115

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_lev_motor_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxLevMotorPowerField(Field):
    ID = 116

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_lev_motor_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapLevBatteryConsumptionField(Field):
    ID = 117

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='lev_battery_consumption',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgVerticalRatioField(Field):
    ID = 118

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_vertical_ratio',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgStanceTimeBalanceField(Field):
    ID = 119

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stance_time_balance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgStepLengthField(Field):
    ID = 120

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_step_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgVamField(Field):
    ID = 121

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_vam',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalGritField(Field):
    ID = 149

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='kGrit',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalFlowField(Field):
    ID = 150

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='Flow',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapJumpCountField(Field):
    ID = 151

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='jump_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgGritField(Field):
    ID = 153

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='kGrit',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgFlowField(Field):
    ID = 154

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='Flow',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalFractionalAscentField(Field):
    ID = 156

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_ascent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapTotalFractionalDescentField(Field):
    ID = 157

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_descent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapAvgCoreTemperatureField(Field):
    ID = 158

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMinCoreTemperatureField(Field):
    ID = 159

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class LapMaxCoreTemperatureField(Field):
    ID = 160

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
