# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: google/api/expr/v1alpha1/syntax.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


@dataclass(eq=False, repr=False)
class ParsedExpr(betterproto.Message):
    """
    An expression together with source information as returned by the parser.
    """

    # The parsed expression.
    expr: "Expr" = betterproto.message_field(2)
    # The source info derived from input that generated the parsed `expr`.
    source_info: "SourceInfo" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Expr(betterproto.Message):
    """
    An abstract representation of a common expression. Expressions are
    abstractly represented as a collection of identifiers, select statements,
    function calls, literals, and comprehensions. All operators with the
    exception of the '.' operator are modelled as function calls. This makes it
    easy to represent new operators into the existing AST. All references
    within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl]
    provided at type-check for an expression to be valid. A reference may
    either be a bare identifier `name` or a qualified identifier
    `google.api.name`. References may either refer to a value or a function
    declaration. For example, the expression
    `google.api.name.startsWith('expr')` references the declaration
    `google.api.name` within a
    [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the
    function declaration `startsWith`.
    """

    # Required. An id assigned to this node by the parser which is unique in a
    # given expression tree. This is used to associate type information and other
    # attributes to a node in the parse tree.
    id: int = betterproto.int64_field(2)
    # A literal expression.
    const_expr: "Constant" = betterproto.message_field(3, group="expr_kind")
    # An identifier expression.
    ident_expr: "ExprIdent" = betterproto.message_field(4, group="expr_kind")
    # A field selection expression, e.g. `request.auth`.
    select_expr: "ExprSelect" = betterproto.message_field(5, group="expr_kind")
    # A call expression, including calls to predefined functions and operators.
    call_expr: "ExprCall" = betterproto.message_field(6, group="expr_kind")
    # A list creation expression.
    list_expr: "ExprCreateList" = betterproto.message_field(7, group="expr_kind")
    # A map or message creation expression.
    struct_expr: "ExprCreateStruct" = betterproto.message_field(8, group="expr_kind")
    # A comprehension expression.
    comprehension_expr: "ExprComprehension" = betterproto.message_field(
        9, group="expr_kind"
    )


@dataclass(eq=False, repr=False)
class ExprIdent(betterproto.Message):
    """An identifier expression. e.g. `request`."""

    # Required. Holds a single, unqualified identifier, possibly preceded by a
    # '.'. Qualified names are represented by the
    # [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression.
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ExprSelect(betterproto.Message):
    """A field selection expression. e.g. `request.auth`."""

    # Required. The target of the selection expression. For example, in the
    # select expression `request.auth`, the `request` portion of the expression
    # is the `operand`.
    operand: "Expr" = betterproto.message_field(1)
    # Required. The name of the field to select. For example, in the select
    # expression `request.auth`, the `auth` portion of the expression would be
    # the `field`.
    field: str = betterproto.string_field(2)
    # Whether the select is to be interpreted as a field presence test. This
    # results from the macro `has(request.auth)`.
    test_only: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ExprCall(betterproto.Message):
    """
    A call expression, including calls to predefined functions and operators.
    For example, `value == 10`, `size(map_value)`.
    """

    # The target of an method call-style expression. For example, `x` in `x.f()`.
    target: "Expr" = betterproto.message_field(1)
    # Required. The name of the function or method being called.
    function: str = betterproto.string_field(2)
    # The arguments.
    args: List["Expr"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ExprCreateList(betterproto.Message):
    """
    A list creation expression. Lists may either be homogenous, e.g. `[1, 2,
    3]`, or heterogenous, e.g. `dyn([1, 'hello', 2.0])`
    """

    # The elements part of the list.
    elements: List["Expr"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ExprCreateStruct(betterproto.Message):
    """
    A map or message creation expression. Maps are constructed as `{'key_name':
    'value'}`. Message construction is similar, but prefixed with a type name
    and composed of field ids: `types.MyType{field_id: 'value'}`.
    """

    # The type name of the message to be created, empty when creating map
    # literals.
    message_name: str = betterproto.string_field(1)
    # The entries in the creation expression.
    entries: List["ExprCreateStructEntry"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ExprCreateStructEntry(betterproto.Message):
    """Represents an entry."""

    # Required. An id assigned to this node by the parser which is unique in a
    # given expression tree. This is used to associate type information and other
    # attributes to the node.
    id: int = betterproto.int64_field(1)
    # The field key for a message creator statement.
    field_key: str = betterproto.string_field(2, group="key_kind")
    # The key expression for a map creation statement.
    map_key: "Expr" = betterproto.message_field(3, group="key_kind")
    # Required. The value assigned to the key.
    value: "Expr" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ExprComprehension(betterproto.Message):
    """
    A comprehension expression applied to a list or map. Comprehensions are not
    part of the core syntax, but enabled with macros. A macro matches a
    specific call signature within a parsed AST and replaces the call with an
    alternate AST block. Macro expansion happens at parse time. The following
    macros are supported within CEL: Aggregate type macros may be applied to
    all elements in a list or all keys in a map: *  `all`, `exists`,
    `exists_one` -  test a predicate expression against    the inputs and
    return `true` if the predicate is satisfied for all,    any, or only one
    value `list.all(x, x < 10)`. *  `filter` - test a predicate expression
    against the inputs and return    the subset of elements which satisfy the
    predicate:    `payments.filter(p, p > 1000)`. *  `map` - apply an
    expression to all elements in the input and return the    output aggregate
    type: `[1, 2, 3].map(i, i * i)`. The `has(m.x)` macro tests whether the
    property `x` is present in struct `m`. The semantics of this macro depend
    on the type of `m`. For proto2 messages `has(m.x)` is defined as 'defined,
    but not set`. For proto3, the macro tests whether the property is set to
    its default. For map and struct types, the macro tests whether the property
    `x` is defined on `m`.
    """

    # The name of the iteration variable.
    iter_var: str = betterproto.string_field(1)
    # The range over which var iterates.
    iter_range: "Expr" = betterproto.message_field(2)
    # The name of the variable used for accumulation of the result.
    accu_var: str = betterproto.string_field(3)
    # The initial value of the accumulator.
    accu_init: "Expr" = betterproto.message_field(4)
    # An expression which can contain iter_var and accu_var. Returns false when
    # the result has been computed and may be used as a hint to short-circuit the
    # remainder of the comprehension.
    loop_condition: "Expr" = betterproto.message_field(5)
    # An expression which can contain iter_var and accu_var. Computes the next
    # value of accu_var.
    loop_step: "Expr" = betterproto.message_field(6)
    # An expression which can contain accu_var. Computes the result.
    result: "Expr" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class Constant(betterproto.Message):
    """
    Represents a primitive literal. Named 'Constant' here for backwards
    compatibility. This is similar as the primitives supported in the well-
    known type `google.protobuf.Value`, but richer so it can represent CEL's
    full range of primitives. Lists and structs are not included as constants
    as these aggregate types may contain [Expr][google.api.expr.v1alpha1.Expr]
    elements which require evaluation and are thus not constant. Examples of
    literals include: `"hello"`, `b'bytes'`, `1u`, `4.2`, `-2`, `true`, `null`.
    """

    # null value.
    null_value: "betterproto_lib_google_protobuf.NullValue" = betterproto.enum_field(
        1, group="constant_kind"
    )
    # boolean value.
    bool_value: bool = betterproto.bool_field(2, group="constant_kind")
    # int64 value.
    int64_value: int = betterproto.int64_field(3, group="constant_kind")
    # uint64 value.
    uint64_value: int = betterproto.uint64_field(4, group="constant_kind")
    # double value.
    double_value: float = betterproto.double_field(5, group="constant_kind")
    # string value.
    string_value: str = betterproto.string_field(6, group="constant_kind")
    # bytes value.
    bytes_value: bytes = betterproto.bytes_field(7, group="constant_kind")
    # protobuf.Duration value. Deprecated: duration is no longer considered a
    # builtin cel type.
    duration_value: timedelta = betterproto.message_field(8, group="constant_kind")
    # protobuf.Timestamp value. Deprecated: timestamp is no longer considered a
    # builtin cel type.
    timestamp_value: datetime = betterproto.message_field(9, group="constant_kind")

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.duration_value:
            warnings.warn("Constant.duration_value is deprecated", DeprecationWarning)
        if self.timestamp_value:
            warnings.warn("Constant.timestamp_value is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class SourceInfo(betterproto.Message):
    """Source information collected at parse time."""

    # The syntax version of the source, e.g. `cel1`.
    syntax_version: str = betterproto.string_field(1)
    # The location name. All position information attached to an expression is
    # relative to this location. The location could be a file, UI element, or
    # similar. For example, `acme/app/AnvilPolicy.cel`.
    location: str = betterproto.string_field(2)
    # Monotonically increasing list of character offsets where newlines appear.
    # The line number of a given position is the index `i` where for a given `id`
    # the `line_offsets[i] < id_positions[id] < line_offsets[i+1]`. The column
    # may be derivd from `id_positions[id] - line_offsets[i]`.
    line_offsets: List[int] = betterproto.int32_field(3)
    # A map from the parse node id (e.g. `Expr.id`) to the character offset
    # within source.
    positions: Dict[int, int] = betterproto.map_field(
        4, betterproto.TYPE_INT64, betterproto.TYPE_INT32
    )
    # A map from the parse node id where a macro replacement was made to the call
    # `Expr` that resulted in a macro expansion. For example, `has(value.field)`
    # is a function call that is replaced by a `test_only` field selection in the
    # AST. Likewise, the call `list.exists(e, e > 10)` translates to a
    # comprehension expression. The key in the map corresponds to the expression
    # id of the expanded macro, and the value is the call `Expr` that was
    # replaced.
    macro_calls: Dict[int, "Expr"] = betterproto.map_field(
        5, betterproto.TYPE_INT64, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class SourcePosition(betterproto.Message):
    """A specific position in source."""

    # The soucre location name (e.g. file name).
    location: str = betterproto.string_field(1)
    # The character offset.
    offset: int = betterproto.int32_field(2)
    # The 1-based index of the starting line in the source text where the issue
    # occurs, or 0 if unknown.
    line: int = betterproto.int32_field(3)
    # The 0-based index of the starting position within the line of source text
    # where the issue occurs.  Only meaningful if line is nonzero.
    column: int = betterproto.int32_field(4)


import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
